/*
 * Copyright (c) 2022-2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "src/cpu/kernels/lut/list.h"

#ifdef __aarch64__
#ifdef ARM_COMPUTE_ENABLE_SVE

namespace arm_compute
{
namespace cpu
{
void lut_u8_sve2(
    const uint8_t        *table,
    size_t                num_strings,
    size_t                string_length,
    const uint8_t *const *input,
    uint8_t *const       *output)
{
    __asm__ __volatile__(
        "ptrue p0.b\n"
        "cntd x25\n"
        "addvl %x[table], %x[table], #8\n"
        "ld1b { z16.b }, p0/Z, [%x[table], #-8, MUL VL]\n"
        "tbnz x25, #5, 1f\n"
        "ld1b { z17.b }, p0/Z, [%x[table], #-7, MUL VL]\n"
        "tbnz x25, #4, 1f\n"
        "ld1b { z18.b }, p0/Z, [%x[table], #-6, MUL VL]\n"
        "ld1b { z19.b }, p0/Z, [%x[table], #-5, MUL VL]\n"
        "tbnz x25, #3, 1f\n"
        "ld1b { z20.b }, p0/Z, [%x[table], #-4, MUL VL]\n"
        "ld1b { z21.b }, p0/Z, [%x[table], #-3, MUL VL]\n"
        "ld1b { z22.b }, p0/Z, [%x[table], #-2, MUL VL]\n"
        "ld1b { z23.b }, p0/Z, [%x[table], #-1, MUL VL]\n"
        "tbnz x25, #2, 1f\n"
        "ld1b { z24.b }, p0/Z, [%x[table]]\n"
        "ld1b { z25.b }, p0/Z, [%x[table], #1, MUL VL]\n"
        "ld1b { z26.b }, p0/Z, [%x[table], #2, MUL VL]\n"
        "ld1b { z27.b }, p0/Z, [%x[table], #3, MUL VL]\n"
        "ld1b { z28.b }, p0/Z, [%x[table], #4, MUL VL]\n"
        "ld1b { z29.b }, p0/Z, [%x[table], #5, MUL VL]\n"
        "ld1b { z30.b }, p0/Z, [%x[table], #6, MUL VL]\n"
        "ld1b { z31.b }, p0/Z, [%x[table], #7, MUL VL]\n"
        "1:" // Table load done
        "mov x24, #0x0\n"
        "2:" // string loop
        "ldr x23, [%x[input], x24, LSL #0x3]\n"
        "ldr x22, [%x[output], x24, LSL #0x3]\n"
        "tbnz x25, #5, 14f\n"
        "tbnz x25, #4, 11f\n"
        "tbnz x25, #3, 8f\n"
        "tbnz x25, #2, 5f\n"
        "mov z12.b, #0x10\n"
        "mov x21, %x[string_length]\n"
        "ptrue p5.b\n"
        "ptrue p4.b\n"
        "ptrue p3.b\n"
        "ptrue p2.b\n"
        "ptrue p1.b\n"
        "ptrue p0.b\n"
        "3:" // 16 rounds: width loop
        "addvl x20, x21, #-6\n"
        "cmp x20, XZR\n"
        "bge 4f\n"
        "mov x20, #0x0\n"
        "addvl x20, x20, #1\n"
        "whilelt p5.b, XZR, x21\n"
        "whilelt p4.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p3.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p2.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p1.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p0.b, x20, x21\n"
        "4:" // 16 rounds: predicate OK
        "ld1b { z11.b }, p5/Z, [x23]\n"
        "ld1b { z10.b }, p4/Z, [x23, #1, MUL VL]\n"
        "tbl z9.b, { z16.b }, z11.b\n"
        "ld1b { z8.b }, p3/Z, [x23, #2, MUL VL]\n"
        "ld1b { z7.b }, p2/Z, [x23, #3, MUL VL]\n"
        "sub z11.b, z11.b, z12.b\n"
        "ld1b { z6.b }, p1/Z, [x23, #4, MUL VL]\n"
        "ld1b { z5.b }, p0/Z, [x23, #5, MUL VL]\n"
        "tbl z4.b, { z16.b }, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        "tbl z3.b, { z16.b }, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        "tbl z2.b, { z16.b }, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        "tbl z1.b, { z16.b }, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        "tbl z0.b, { z16.b }, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e29 // tbx z9.b, z17.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e24 // tbx z4.b, z17.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e23 // tbx z3.b, z17.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e22 // tbx z2.b, z17.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e21 // tbx z1.b, z17.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e20 // tbx z0.b, z17.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e49 // tbx z9.b, z18.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e44 // tbx z4.b, z18.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e43 // tbx z3.b, z18.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e42 // tbx z2.b, z18.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e41 // tbx z1.b, z18.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e40 // tbx z0.b, z18.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e69 // tbx z9.b, z19.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e64 // tbx z4.b, z19.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e63 // tbx z3.b, z19.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e62 // tbx z2.b, z19.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e61 // tbx z1.b, z19.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e60 // tbx z0.b, z19.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e89 // tbx z9.b, z20.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e84 // tbx z4.b, z20.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e83 // tbx z3.b, z20.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e82 // tbx z2.b, z20.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e81 // tbx z1.b, z20.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e80 // tbx z0.b, z20.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2ea9 // tbx z9.b, z21.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2ea4 // tbx z4.b, z21.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282ea3 // tbx z3.b, z21.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272ea2 // tbx z2.b, z21.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262ea1 // tbx z1.b, z21.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252ea0 // tbx z0.b, z21.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2ec9 // tbx z9.b, z22.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2ec4 // tbx z4.b, z22.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282ec3 // tbx z3.b, z22.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272ec2 // tbx z2.b, z22.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262ec1 // tbx z1.b, z22.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252ec0 // tbx z0.b, z22.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2ee9 // tbx z9.b, z23.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2ee4 // tbx z4.b, z23.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282ee3 // tbx z3.b, z23.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272ee2 // tbx z2.b, z23.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262ee1 // tbx z1.b, z23.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252ee0 // tbx z0.b, z23.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2f09 // tbx z9.b, z24.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2f04 // tbx z4.b, z24.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282f03 // tbx z3.b, z24.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272f02 // tbx z2.b, z24.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262f01 // tbx z1.b, z24.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252f00 // tbx z0.b, z24.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2f29 // tbx z9.b, z25.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2f24 // tbx z4.b, z25.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282f23 // tbx z3.b, z25.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272f22 // tbx z2.b, z25.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262f21 // tbx z1.b, z25.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252f20 // tbx z0.b, z25.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2f49 // tbx z9.b, z26.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2f44 // tbx z4.b, z26.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282f43 // tbx z3.b, z26.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272f42 // tbx z2.b, z26.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262f41 // tbx z1.b, z26.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252f40 // tbx z0.b, z26.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2f69 // tbx z9.b, z27.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2f64 // tbx z4.b, z27.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282f63 // tbx z3.b, z27.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272f62 // tbx z2.b, z27.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262f61 // tbx z1.b, z27.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252f60 // tbx z0.b, z27.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2f89 // tbx z9.b, z28.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2f84 // tbx z4.b, z28.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282f83 // tbx z3.b, z28.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272f82 // tbx z2.b, z28.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262f81 // tbx z1.b, z28.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252f80 // tbx z0.b, z28.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2fa9 // tbx z9.b, z29.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2fa4 // tbx z4.b, z29.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282fa3 // tbx z3.b, z29.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272fa2 // tbx z2.b, z29.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262fa1 // tbx z1.b, z29.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252fa0 // tbx z0.b, z29.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        "addvl x21, x21, #-6\n"
        ".inst 0x052b2fc9 // tbx z9.b, z30.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2fc4 // tbx z4.b, z30.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282fc3 // tbx z3.b, z30.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272fc2 // tbx z2.b, z30.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262fc1 // tbx z1.b, z30.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252fc0 // tbx z0.b, z30.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        "cmp x21, XZR\n"
        ".inst 0x052b2fe9 // tbx z9.b, z31.b, z11.b\n"
        ".inst 0x052a2fe4 // tbx z4.b, z31.b, z10.b\n"
        ".inst 0x05282fe3 // tbx z3.b, z31.b, z8.b\n"
        "st1b { z9.b }, p5, [x22]\n"
        ".inst 0x05272fe2 // tbx z2.b, z31.b, z7.b\n"
        ".inst 0x05262fe1 // tbx z1.b, z31.b, z6.b\n"
        "st1b { z4.b }, p4, [x22, #1, MUL VL]\n"
        ".inst 0x05252fe0 // tbx z0.b, z31.b, z5.b\n"
        "st1b { z3.b }, p3, [x22, #2, MUL VL]\n"
        "addvl x23, x23, #6\n"
        "st1b { z2.b }, p2, [x22, #3, MUL VL]\n"
        "st1b { z1.b }, p1, [x22, #4, MUL VL]\n"
        "st1b { z0.b }, p0, [x22, #5, MUL VL]\n"
        "addvl x22, x22, #6\n"
        "bgt 3b\n"
        "b 17f\n"
        "5:" // 256 bits
        "mov z12.b, #0x20\n"
        "mov x21, %x[string_length]\n"
        "ptrue p5.b\n"
        "ptrue p4.b\n"
        "ptrue p3.b\n"
        "ptrue p2.b\n"
        "ptrue p1.b\n"
        "ptrue p0.b\n"
        "6:" // 8 rounds: width loop
        "addvl x20, x21, #-6\n"
        "cmp x20, XZR\n"
        "bge 7f\n"
        "mov x20, #0x0\n"
        "addvl x20, x20, #1\n"
        "whilelt p5.b, XZR, x21\n"
        "whilelt p4.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p3.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p2.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p1.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p0.b, x20, x21\n"
        "7:" // 8 rounds: predicate OK
        "ld1b { z11.b }, p5/Z, [x23]\n"
        "ld1b { z10.b }, p4/Z, [x23, #1, MUL VL]\n"
        "tbl z9.b, { z16.b }, z11.b\n"
        "ld1b { z8.b }, p3/Z, [x23, #2, MUL VL]\n"
        "ld1b { z7.b }, p2/Z, [x23, #3, MUL VL]\n"
        "sub z11.b, z11.b, z12.b\n"
        "ld1b { z6.b }, p1/Z, [x23, #4, MUL VL]\n"
        "ld1b { z5.b }, p0/Z, [x23, #5, MUL VL]\n"
        "tbl z4.b, { z16.b }, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        "tbl z3.b, { z16.b }, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        "tbl z2.b, { z16.b }, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        "tbl z1.b, { z16.b }, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        "tbl z0.b, { z16.b }, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e29 // tbx z9.b, z17.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e24 // tbx z4.b, z17.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e23 // tbx z3.b, z17.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e22 // tbx z2.b, z17.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e21 // tbx z1.b, z17.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e20 // tbx z0.b, z17.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e49 // tbx z9.b, z18.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e44 // tbx z4.b, z18.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e43 // tbx z3.b, z18.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e42 // tbx z2.b, z18.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e41 // tbx z1.b, z18.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e40 // tbx z0.b, z18.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e69 // tbx z9.b, z19.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e64 // tbx z4.b, z19.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e63 // tbx z3.b, z19.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e62 // tbx z2.b, z19.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e61 // tbx z1.b, z19.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e60 // tbx z0.b, z19.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e89 // tbx z9.b, z20.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e84 // tbx z4.b, z20.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e83 // tbx z3.b, z20.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e82 // tbx z2.b, z20.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e81 // tbx z1.b, z20.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e80 // tbx z0.b, z20.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2ea9 // tbx z9.b, z21.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2ea4 // tbx z4.b, z21.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282ea3 // tbx z3.b, z21.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272ea2 // tbx z2.b, z21.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262ea1 // tbx z1.b, z21.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252ea0 // tbx z0.b, z21.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        "addvl x21, x21, #-6\n"
        ".inst 0x052b2ec9 // tbx z9.b, z22.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2ec4 // tbx z4.b, z22.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282ec3 // tbx z3.b, z22.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272ec2 // tbx z2.b, z22.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262ec1 // tbx z1.b, z22.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252ec0 // tbx z0.b, z22.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        "cmp x21, XZR\n"
        ".inst 0x052b2ee9 // tbx z9.b, z23.b, z11.b\n"
        ".inst 0x052a2ee4 // tbx z4.b, z23.b, z10.b\n"
        ".inst 0x05282ee3 // tbx z3.b, z23.b, z8.b\n"
        "st1b { z9.b }, p5, [x22]\n"
        ".inst 0x05272ee2 // tbx z2.b, z23.b, z7.b\n"
        ".inst 0x05262ee1 // tbx z1.b, z23.b, z6.b\n"
        "st1b { z4.b }, p4, [x22, #1, MUL VL]\n"
        ".inst 0x05252ee0 // tbx z0.b, z23.b, z5.b\n"
        "st1b { z3.b }, p3, [x22, #2, MUL VL]\n"
        "addvl x23, x23, #6\n"
        "st1b { z2.b }, p2, [x22, #3, MUL VL]\n"
        "st1b { z1.b }, p1, [x22, #4, MUL VL]\n"
        "st1b { z0.b }, p0, [x22, #5, MUL VL]\n"
        "addvl x22, x22, #6\n"
        "bgt 6b\n"
        "b 17f\n"
        "8:" // 512 bits
        "mov z12.b, #0x40\n"
        "mov x21, %x[string_length]\n"
        "ptrue p5.b\n"
        "ptrue p4.b\n"
        "ptrue p3.b\n"
        "ptrue p2.b\n"
        "ptrue p1.b\n"
        "ptrue p0.b\n"
        "9:" // 4 rounds: width loop
        "addvl x20, x21, #-6\n"
        "cmp x20, XZR\n"
        "bge 10f\n"
        "mov x20, #0x0\n"
        "addvl x20, x20, #1\n"
        "whilelt p5.b, XZR, x21\n"
        "whilelt p4.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p3.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p2.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p1.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p0.b, x20, x21\n"
        "10:" // 4 rounds: predicate OK
        "ld1b { z11.b }, p5/Z, [x23]\n"
        "ld1b { z10.b }, p4/Z, [x23, #1, MUL VL]\n"
        "tbl z9.b, { z16.b }, z11.b\n"
        "ld1b { z8.b }, p3/Z, [x23, #2, MUL VL]\n"
        "ld1b { z7.b }, p2/Z, [x23, #3, MUL VL]\n"
        "sub z11.b, z11.b, z12.b\n"
        "ld1b { z6.b }, p1/Z, [x23, #4, MUL VL]\n"
        "ld1b { z5.b }, p0/Z, [x23, #5, MUL VL]\n"
        "tbl z4.b, { z16.b }, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        "tbl z3.b, { z16.b }, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        "tbl z2.b, { z16.b }, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        "tbl z1.b, { z16.b }, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        "tbl z0.b, { z16.b }, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        ".inst 0x052b2e29 // tbx z9.b, z17.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e24 // tbx z4.b, z17.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e23 // tbx z3.b, z17.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e22 // tbx z2.b, z17.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e21 // tbx z1.b, z17.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e20 // tbx z0.b, z17.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        "addvl x21, x21, #-6\n"
        ".inst 0x052b2e49 // tbx z9.b, z18.b, z11.b\n"
        "sub z11.b, z11.b, z12.b\n"
        ".inst 0x052a2e44 // tbx z4.b, z18.b, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        ".inst 0x05282e43 // tbx z3.b, z18.b, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        ".inst 0x05272e42 // tbx z2.b, z18.b, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        ".inst 0x05262e41 // tbx z1.b, z18.b, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        ".inst 0x05252e40 // tbx z0.b, z18.b, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        "cmp x21, XZR\n"
        ".inst 0x052b2e69 // tbx z9.b, z19.b, z11.b\n"
        ".inst 0x052a2e64 // tbx z4.b, z19.b, z10.b\n"
        ".inst 0x05282e63 // tbx z3.b, z19.b, z8.b\n"
        "st1b { z9.b }, p5, [x22]\n"
        ".inst 0x05272e62 // tbx z2.b, z19.b, z7.b\n"
        ".inst 0x05262e61 // tbx z1.b, z19.b, z6.b\n"
        "st1b { z4.b }, p4, [x22, #1, MUL VL]\n"
        ".inst 0x05252e60 // tbx z0.b, z19.b, z5.b\n"
        "st1b { z3.b }, p3, [x22, #2, MUL VL]\n"
        "addvl x23, x23, #6\n"
        "st1b { z2.b }, p2, [x22, #3, MUL VL]\n"
        "st1b { z1.b }, p1, [x22, #4, MUL VL]\n"
        "st1b { z0.b }, p0, [x22, #5, MUL VL]\n"
        "addvl x22, x22, #6\n"
        "bgt 9b\n"
        "b 17f\n"
        "11:" // 1024 bits
        "mov z12.b, #0x80\n"
        "mov x21, %x[string_length]\n"
        "ptrue p5.b\n"
        "ptrue p4.b\n"
        "ptrue p3.b\n"
        "ptrue p2.b\n"
        "ptrue p1.b\n"
        "ptrue p0.b\n"
        "12:" // 2 rounds: width loop
        "addvl x20, x21, #-6\n"
        "cmp x20, XZR\n"
        "bge 13f\n"
        "mov x20, #0x0\n"
        "addvl x20, x20, #1\n"
        "whilelt p5.b, XZR, x21\n"
        "whilelt p4.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p3.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p2.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p1.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p0.b, x20, x21\n"
        "13:" // 2 rounds: predicate OK
        "ld1b { z11.b }, p5/Z, [x23]\n"
        "ld1b { z10.b }, p4/Z, [x23, #1, MUL VL]\n"
        "addvl x21, x21, #-6\n"
        "ld1b { z8.b }, p3/Z, [x23, #2, MUL VL]\n"
        "ld1b { z7.b }, p2/Z, [x23, #3, MUL VL]\n"
        "tbl z9.b, { z16.b }, z11.b\n"
        "ld1b { z6.b }, p1/Z, [x23, #4, MUL VL]\n"
        "ld1b { z5.b }, p0/Z, [x23, #5, MUL VL]\n"
        "sub z11.b, z11.b, z12.b\n"
        "tbl z4.b, { z16.b }, z10.b\n"
        "sub z10.b, z10.b, z12.b\n"
        "tbl z3.b, { z16.b }, z8.b\n"
        "sub z8.b, z8.b, z12.b\n"
        "tbl z2.b, { z16.b }, z7.b\n"
        "sub z7.b, z7.b, z12.b\n"
        "tbl z1.b, { z16.b }, z6.b\n"
        "sub z6.b, z6.b, z12.b\n"
        "tbl z0.b, { z16.b }, z5.b\n"
        "sub z5.b, z5.b, z12.b\n"
        "cmp x21, XZR\n"
        ".inst 0x052b2e29 // tbx z9.b, z17.b, z11.b\n"
        ".inst 0x052a2e24 // tbx z4.b, z17.b, z10.b\n"
        ".inst 0x05282e23 // tbx z3.b, z17.b, z8.b\n"
        "st1b { z9.b }, p5, [x22]\n"
        ".inst 0x05272e22 // tbx z2.b, z17.b, z7.b\n"
        ".inst 0x05262e21 // tbx z1.b, z17.b, z6.b\n"
        "st1b { z4.b }, p4, [x22, #1, MUL VL]\n"
        ".inst 0x05252e20 // tbx z0.b, z17.b, z5.b\n"
        "st1b { z3.b }, p3, [x22, #2, MUL VL]\n"
        "addvl x23, x23, #6\n"
        "st1b { z2.b }, p2, [x22, #3, MUL VL]\n"
        "st1b { z1.b }, p1, [x22, #4, MUL VL]\n"
        "st1b { z0.b }, p0, [x22, #5, MUL VL]\n"
        "addvl x22, x22, #6\n"
        "bgt 12b\n"
        "b 17f\n"
        "14:" // 2048 bits
        "mov x21, %x[string_length]\n"
        "ptrue p5.b\n"
        "ptrue p4.b\n"
        "ptrue p3.b\n"
        "ptrue p2.b\n"
        "ptrue p1.b\n"
        "ptrue p0.b\n"
        "15:" // 1 rounds: width loop
        "addvl x20, x21, #-6\n"
        "cmp x20, XZR\n"
        "bge 16f\n"
        "mov x20, #0x0\n"
        "addvl x20, x20, #1\n"
        "whilelt p5.b, XZR, x21\n"
        "whilelt p4.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p3.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p2.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p1.b, x20, x21\n"
        "addvl x20, x20, #1\n"
        "whilelt p0.b, x20, x21\n"
        "16:" // 1 rounds: predicate OK
        "addvl x21, x21, #-6\n"
        "ld1b { z11.b }, p5/Z, [x23]\n"
        "ld1b { z10.b }, p4/Z, [x23, #1, MUL VL]\n"
        "ld1b { z8.b }, p3/Z, [x23, #2, MUL VL]\n"
        "ld1b { z7.b }, p2/Z, [x23, #3, MUL VL]\n"
        "cmp x21, XZR\n"
        "ld1b { z6.b }, p1/Z, [x23, #4, MUL VL]\n"
        "ld1b { z5.b }, p0/Z, [x23, #5, MUL VL]\n"
        "tbl z9.b, { z16.b }, z11.b\n"
        "tbl z4.b, { z16.b }, z10.b\n"
        "tbl z3.b, { z16.b }, z8.b\n"
        "st1b { z9.b }, p5, [x22]\n"
        "tbl z2.b, { z16.b }, z7.b\n"
        "tbl z1.b, { z16.b }, z6.b\n"
        "st1b { z4.b }, p4, [x22, #1, MUL VL]\n"
        "tbl z0.b, { z16.b }, z5.b\n"
        "st1b { z3.b }, p3, [x22, #2, MUL VL]\n"
        "addvl x23, x23, #6\n"
        "st1b { z2.b }, p2, [x22, #3, MUL VL]\n"
        "st1b { z1.b }, p1, [x22, #4, MUL VL]\n"
        "st1b { z0.b }, p0, [x22, #5, MUL VL]\n"
        "addvl x22, x22, #6\n"
        "bgt 15b\n"
        "17:" // SVE body done
        "add x24, x24, #0x1\n"
        "cmp x24, %x[num_strings]\n"
        "bne 2b\n"
        : [table] "+&r"(table)
        : [input] "r"(input), [num_strings] "r"(num_strings), [output] "r"(output), [string_length] "r"(string_length)
        : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "x20", "x21", "x22", "x23", "x24", "x25", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31");
}

} // namespace cpu
} // namespace arm_compute

#endif // ARM_COMPUTE_ENABLE_SVE
#endif // __aarch64__
