#!/usr/bin/perl -w
 
#
#  usage look_for [<options>] files or directories....
#

#^# use lib '$Argus::Home/lib';  

use strict;
use Getopt::Std;
use Argus;
use Argus::Archive;

use vars qw($opt_f $opt_F $opt_s $opt_D $opt_o  $opt_q $opt_P $opt_w 
$opt_t);

getopts("D:s:f:o:F:qw:t:P:") || die "Invalid options found";

#  D <directory>-- Directory where data is held
#  s <date>     -- Start date
#  f <date>     -- Finish date
#  F <file>     -- read filter from <file>
#  o <options>  -- options for ra (default -nc)
#  P <file>     -- function to post filter
#  w <filename> -- Output to filename
#  q            -- quite mode
#  t <timezone> -- print times relative to alternate timezone eg UTC

my $opts = defined $opt_o ? "-$opt_o" : '-Anc -Zb';

Argus::Archive::Set_Archive_Directory( $opt_D ) if defined $opt_D;  

my $filter = defined $opt_F ? "-F $opt_F" : join(' ', @ARGV);

if (defined $opt_w) {
    open(OUT, ">$opt_w") || die "failed to open '$opt_w':$!";
} else {
    open(OUT, ">-") || die "failed to open 'stdout':$!";
}

if( defined $opt_t ) {
    $ENV{TZ} = $opt_t ;
}

$opt_s = 'yesterday' unless defined $opt_s;

my @files = Argus::Archive::Get_File_List($opt_s, $opt_f );

if( ! defined @files ) {
    die "$Argus::Error";
}

foreach my $fn ( @files ) {

    print "$fn\n" if ! defined $opt_q;

    open(SW, "$Argus::Client_path/ra -r $fn $opts $filter |" ) ||
            die "can't open ra:$!";

    while (<SW>) {
        if( defined $opt_P ) {
            next if post_filter($_);
        }
        print OUT;
    }
}


