use Argus;

package Argus::SlowScan;   # config vars for particular scripts

use vars qw ( @Summary %Ignore $RA_Filter $Drop_int $NoGnuttela $NoNB_Name 
	      $Maxlines );

#
# If you don't need Summary or Ignore just delete their definition here
#

#@Summary = (
#	       'skitter\.',          # various cadia skitter probes
#	       '207\.114\.24\.98',    # WebChat.MD.US.Undernet.Org
#	       '130\.216\.1\.26',      # scream -- ftp server
#	       '130\.216\.191\.26',    # scream -- ftp server
#	       '130\.216\.1\.27',      # www.auckland.ac.nz 
#	       'msgr-ns.+\.hotmail.com', 
#		       );

# ignore these packets altogether
#my %Ignore = (
#	      '128.103.160.162', =>  '130.216.1.240',  # surveyor...
#	      '140.142.16.227', =>  '130.216.1.240',
#	      '205.189.33.70', =>  '130.216.1.240',
#	      );

# if you dont want udp remove it from the filter 

$RA_Filter = 'icmp or frag or udp or \(tcp and \(not est\) and \(not ' .
             '\(port 80 or port 113 or port 25 or port 53\)\)\)';

$Drop_int = 2;   # drop data after this many days with no traffic 

$NoGnuttela = 0;  # ignore gnutella traffic 
$NoNB_Name = 0;   # ignore netbios name traffic (udp -137)

$Maxlines = 256;  # print a summary if more than this many line in hour

##########################################################################

# Control the reporting thresholds:

my $Local_Times = 10;
my $Local_Dests1 = 100;
my $Local_Dests2 = 200;
my $Local_Dests3 = 500;

my $Rem_Times = 4;
my $Rem_Dests1 = 10;
my $Rem_Dests2 = 30;
my $Rem_Dests3 = 100;

sub report_this {
    my ($ip, $times, $count ) = @_;

    return ( $ip =~ /$Argus::Local_IP_re/o ) ?  # a local address
	(( $times >  $Local_Times and $count > $Local_Dests1 ) or
	 ( $times <= $Local_Times and $count > $Local_Dests2 ) or
	 $count > $Local_Dests3
	) 
	    : # else # outside
	(( $times >  $Rem_Times and $count > $Rem_Dests1 ) or
	 ( $times <= $Rem_Times and $count > $Rem_Dests2 ) or
	 $count > $Rem_Dests3
	) 
	    ;
}
