/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgTrigger {
    private String function;
    private String name;
    private String relationName;
    private EventTimeQualification eventTimeQualification = EventTimeQualification.before;
    private boolean forEachRow;
    private boolean onDelete;
    private boolean onInsert;
    private boolean onUpdate;
    private boolean onTruncate;
    private final List<String> updateColumns = new ArrayList<String>();
    private String when;
    private String comment;
    private String referencing;
    private boolean disable;

    public void setEventTimeQualification(EventTimeQualification eventTimeQualification) {
        this.eventTimeQualification = eventTimeQualification;
    }

    public EventTimeQualification getEventTimeQualification() {
        return this.eventTimeQualification;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE TRIGGER ");
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getName()));
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("\t");
        stringBuilder.append(EventTimeQualification.toString(this.getEventTimeQualification()));
        boolean bl = true;
        if (this.isOnInsert()) {
            stringBuilder.append(" INSERT");
            bl = false;
        }
        if (this.isOnUpdate()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" OR");
            }
            stringBuilder.append(" UPDATE");
            if (!this.updateColumns.isEmpty()) {
                stringBuilder.append(" OF");
                boolean bl2 = true;
                for (String string : this.updateColumns) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(' ');
                    stringBuilder.append(string);
                }
            }
        }
        if (this.isOnDelete()) {
            if (!bl) {
                stringBuilder.append(" OR");
            }
            stringBuilder.append(" DELETE");
        }
        if (this.isOnTruncate()) {
            if (!bl) {
                stringBuilder.append(" OR");
            }
            stringBuilder.append(" TRUNCATE");
        }
        stringBuilder.append(" ON ");
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getRelationName()));
        stringBuilder.append(System.getProperty("line.separator"));
        if (this.referencing != null && !this.referencing.isEmpty()) {
            stringBuilder.append(this.getReferencing());
            stringBuilder.append(System.getProperty("line.separator"));
        }
        stringBuilder.append("\tFOR EACH ");
        stringBuilder.append(this.isForEachRow() ? "ROW" : "STATEMENT");
        if (this.when != null && !this.when.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tWHEN (");
            stringBuilder.append(this.when);
            stringBuilder.append(')');
        }
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("\tEXECUTE PROCEDURE ");
        stringBuilder.append(this.getFunction());
        stringBuilder.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON TRIGGER ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" ON ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.relationName));
            stringBuilder.append(" IS ");
            stringBuilder.append(this.comment);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public String getDropSQL() {
        return "DROP TRIGGER " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(this.getName()) + " ON " + PgDiffUtils.getQuotedName(this.getRelationName()) + ";";
    }

    public void setForEachRow(boolean bl) {
        this.forEachRow = bl;
    }

    public boolean isForEachRow() {
        return this.forEachRow;
    }

    public void setFunction(String string) {
        this.function = string;
    }

    public String getFunction() {
        return this.function;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setOnDelete(boolean bl) {
        this.onDelete = bl;
    }

    public boolean isOnDelete() {
        return this.onDelete;
    }

    public void setOnInsert(boolean bl) {
        this.onInsert = bl;
    }

    public boolean isOnInsert() {
        return this.onInsert;
    }

    public void setOnUpdate(boolean bl) {
        this.onUpdate = bl;
    }

    public boolean isOnUpdate() {
        return this.onUpdate;
    }

    public boolean isOnTruncate() {
        return this.onTruncate;
    }

    public void setOnTruncate(boolean bl) {
        this.onTruncate = bl;
    }

    public void setRelationName(String string) {
        this.relationName = string;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public List<String> getUpdateColumns() {
        return Collections.unmodifiableList(this.updateColumns);
    }

    public void addUpdateColumn(String string) {
        this.updateColumns.add(string);
    }

    public String getWhen() {
        return this.when;
    }

    public void setWhen(String string) {
        this.when = string;
    }

    public String getReferencing() {
        return this.referencing;
    }

    public void setReferencing(String string) {
        this.referencing = string;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public void setDisable(boolean bl) {
        this.disable = bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PgTrigger) {
            PgTrigger pgTrigger = (PgTrigger)object;
            boolean bl2 = bl = this.eventTimeQualification == pgTrigger.getEventTimeQualification() && this.forEachRow == pgTrigger.isForEachRow() && this.function.equals(pgTrigger.getFunction()) && this.name.equals(pgTrigger.getName()) && this.onDelete == pgTrigger.isOnDelete() && this.onInsert == pgTrigger.isOnInsert() && this.onUpdate == pgTrigger.isOnUpdate() && this.onTruncate == pgTrigger.isOnTruncate() && this.relationName.equals(pgTrigger.getRelationName());
            if (bl) {
                ArrayList<String> arrayList = new ArrayList<String>(this.updateColumns);
                ArrayList<String> arrayList2 = new ArrayList<String>(pgTrigger.getUpdateColumns());
                Collections.sort(arrayList);
                Collections.sort(arrayList2);
                bl = arrayList.equals(arrayList2);
            }
        }
        return bl;
    }

    public int hashCode() {
        return (this.getClass().getName() + "|" + (Object)((Object)this.eventTimeQualification) + "|" + this.forEachRow + "|" + this.function + "|" + this.name + "|" + this.onDelete + "|" + this.onInsert + "|" + this.onUpdate + "|" + this.onTruncate + "|" + this.relationName + "|" + this.disable).hashCode();
    }

    public String getDisableOrEnableSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("ALTER TABLE ");
        stringBuilder.append(this.relationName);
        if (this.disable) {
            stringBuilder.append(" DISABLE");
        } else {
            stringBuilder.append(" ENABLE");
        }
        stringBuilder.append(" TRIGGER ");
        stringBuilder.append(this.name);
        stringBuilder.append(';');
        stringBuilder.append(System.getProperty("line.separator"));
        return stringBuilder.toString();
    }

    public static enum EventTimeQualification {
        before,
        after,
        instead_of;

        private static final Map<EventTimeQualification, String> stringRepresentation;

        public static String toString(EventTimeQualification eventTimeQualification) {
            return stringRepresentation.get((Object)eventTimeQualification);
        }

        static {
            HashMap<EventTimeQualification, String> hashMap = new HashMap<EventTimeQualification, String>();
            hashMap.put(before, "BEFORE");
            hashMap.put(after, "AFTER");
            hashMap.put(instead_of, "INSTEAD OF");
            stringRepresentation = Collections.unmodifiableMap(hashMap);
        }
    }
}

