/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.loader;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.loader.FileException;
import cz.startnet.utils.pgdiff.parsers.AlterRelationParser;
import cz.startnet.utils.pgdiff.parsers.AlterSequenceParser;
import cz.startnet.utils.pgdiff.parsers.CommentParser;
import cz.startnet.utils.pgdiff.parsers.CreateExtensionParser;
import cz.startnet.utils.pgdiff.parsers.CreateFunctionParser;
import cz.startnet.utils.pgdiff.parsers.CreateIndexParser;
import cz.startnet.utils.pgdiff.parsers.CreatePolicyParser;
import cz.startnet.utils.pgdiff.parsers.CreateRuleParser;
import cz.startnet.utils.pgdiff.parsers.CreateSchemaParser;
import cz.startnet.utils.pgdiff.parsers.CreateSequenceParser;
import cz.startnet.utils.pgdiff.parsers.CreateTableParser;
import cz.startnet.utils.pgdiff.parsers.CreateTriggerParser;
import cz.startnet.utils.pgdiff.parsers.CreateTypeParser;
import cz.startnet.utils.pgdiff.parsers.CreateViewParser;
import cz.startnet.utils.pgdiff.parsers.GrantRevokeParser;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PgDumpLoader {
    private static final Pattern PATTERN_CREATE_SCHEMA = Pattern.compile("^CREATE[\\s]+SCHEMA[\\s]+.*$", 34);
    private static final Pattern PATTERN_DEFAULT_SCHEMA = Pattern.compile("^SET[\\s]+search_path[\\s]*=[\\s]*\"?([^,\\s\"]+)\"?(?:,[\\s]+.*)?;$", 34);
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("^CREATE[\\s]+(UNLOGGED\\s|FOREIGN\\s)*TABLE[\\s]+.*$", 34);
    private static final Pattern PATTERN_CREATE_VIEW = Pattern.compile("^CREATE[\\s]+(?:OR[\\s]+REPLACE[\\s]+)?(?:MATERIALIZED[\\s]+)?VIEW[\\s]+.*$", 34);
    private static final Pattern PATTERN_ALTER_TABLE = Pattern.compile("^ALTER[\\s](FOREIGN)*TABLE[\\s]+.*$", 34);
    private static final Pattern PATTERN_CREATE_SEQUENCE = Pattern.compile("^CREATE[\\s]+SEQUENCE[\\s]+.*$", 34);
    private static final Pattern PATTERN_ALTER_SEQUENCE = Pattern.compile("^ALTER[\\s]+SEQUENCE[\\s]+.*$", 34);
    private static final Pattern PATTERN_CREATE_INDEX = Pattern.compile("^CREATE[\\s]+(?:UNIQUE[\\s]+)?INDEX[\\s]+.*$", 34);
    private static final Pattern PATTERN_SELECT = Pattern.compile("^SELECT[\\s]+.*$", 34);
    private static final Pattern PATTERN_INSERT_INTO = Pattern.compile("^INSERT[\\s]+INTO[\\s]+.*$", 34);
    private static final Pattern PATTERN_UPDATE = Pattern.compile("^UPDATE[\\s].*$", 34);
    private static final Pattern PATTERN_DELETE_FROM = Pattern.compile("^DELETE[\\s]+FROM[\\s]+.*$", 34);
    private static final Pattern PATTERN_CREATE_TRIGGER = Pattern.compile("^CREATE[\\s]+TRIGGER[\\s]+.*$", 34);
    private static final Pattern PATTERN_CREATE_FUNCTION = Pattern.compile("^CREATE[\\s]+(?:OR[\\s]+REPLACE[\\s]+)?FUNCTION[\\s]+.*$", 34);
    private static final Pattern PATTERN_ALTER_VIEW = Pattern.compile("^ALTER[\\s]+(?:MATERIALIZED[\\s]+)?VIEW[\\s]+.*$", 34);
    private static final Pattern PATTERN_COMMENT = Pattern.compile("^COMMENT[\\s]+ON[\\s]+.*$", 34);
    private static final Pattern PATTERN_CREATE_TYPE = Pattern.compile("^CREATE[\\s]+TYPE[\\s]+.*$", 34);
    private static final Pattern PATTERN_GRANT = Pattern.compile("^GRANT[\\s]+.*$", 34);
    private static final Pattern PATTERN_REVOKE = Pattern.compile("^REVOKE[\\s]+.*$", 34);
    private static final Pattern PATTERN_DOLLAR_TAG = Pattern.compile("[\"\\s]", 34);
    private static final Pattern PATTERN_CREATE_EXTENSION = Pattern.compile("^CREATE[\\s]+EXTENSION[\\s]+.*$", 34);
    private static final Pattern PATTERN_CREATE_POLICY = Pattern.compile("^CREATE[\\s]+POLICY[\\s]+.*$", 34);
    private static final Pattern PATTERN_DISABLE_TRIGGER = Pattern.compile("ALTER\\s+TABLE+\\s+\\w+.+\\w+\\s+DISABLE+\\s+TRIGGER+\\s+\\w+.*$", 34);
    private static final Pattern PATTERN_CREATE_RULE = Pattern.compile("^CREATE[\\s]+RULE[\\s]+.*$", 34);
    private static String lineBuffer;

    public static PgDatabase loadDatabaseSchema(InputStream inputStream, String string, boolean bl, boolean bl2, boolean bl3) {
        PgDatabase pgDatabase = new PgDatabase();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedOperationException(Resources.getString("UnsupportedEncoding") + ": " + string, unsupportedEncodingException);
        }
        String string2 = PgDumpLoader.getWholeStatement(bufferedReader);
        while (string2 != null) {
            if (PATTERN_CREATE_SCHEMA.matcher(string2).matches()) {
                CreateSchemaParser.parse(pgDatabase, string2);
            } else if (PATTERN_CREATE_EXTENSION.matcher(string2).matches()) {
                CreateExtensionParser.parse(pgDatabase, string2);
            } else if (PATTERN_DEFAULT_SCHEMA.matcher(string2).matches()) {
                Matcher matcher = PATTERN_DEFAULT_SCHEMA.matcher(string2);
                matcher.matches();
                pgDatabase.setDefaultSchema(matcher.group(1));
            } else if (PATTERN_CREATE_TABLE.matcher(string2).matches()) {
                CreateTableParser.parse(pgDatabase, string2, bl3);
            } else if ((PATTERN_ALTER_TABLE.matcher(string2).matches() || PATTERN_ALTER_VIEW.matcher(string2).matches()) && !PATTERN_DISABLE_TRIGGER.matcher(string2).matches()) {
                AlterRelationParser.parse(pgDatabase, string2, bl);
            } else if (PATTERN_CREATE_SEQUENCE.matcher(string2).matches()) {
                CreateSequenceParser.parse(pgDatabase, string2);
            } else if (PATTERN_ALTER_SEQUENCE.matcher(string2).matches()) {
                AlterSequenceParser.parse(pgDatabase, string2, bl);
            } else if (PATTERN_CREATE_INDEX.matcher(string2).matches()) {
                CreateIndexParser.parse(pgDatabase, string2);
            } else if (PATTERN_CREATE_VIEW.matcher(string2).matches()) {
                CreateViewParser.parse(pgDatabase, string2);
            } else if (PATTERN_CREATE_TRIGGER.matcher(string2).matches()) {
                CreateTriggerParser.parse(pgDatabase, string2, bl2);
            } else if (PATTERN_DISABLE_TRIGGER.matcher(string2).matches()) {
                CreateTriggerParser.parseDisable(pgDatabase, string2);
            } else if (PATTERN_CREATE_FUNCTION.matcher(string2).matches()) {
                CreateFunctionParser.parse(pgDatabase, string2);
            } else if (PATTERN_CREATE_TYPE.matcher(string2).matches()) {
                CreateTypeParser.parse(pgDatabase, string2);
            } else if (PATTERN_COMMENT.matcher(string2).matches()) {
                CommentParser.parse(pgDatabase, string2, bl);
            } else if (!(PATTERN_SELECT.matcher(string2).matches() || PATTERN_INSERT_INTO.matcher(string2).matches() || PATTERN_UPDATE.matcher(string2).matches() || PATTERN_DELETE_FROM.matcher(string2).matches())) {
                if (PATTERN_GRANT.matcher(string2).matches()) {
                    GrantRevokeParser.parse(pgDatabase, string2, bl);
                } else if (PATTERN_REVOKE.matcher(string2).matches()) {
                    GrantRevokeParser.parse(pgDatabase, string2, bl);
                } else if (PATTERN_CREATE_POLICY.matcher(string2).matches()) {
                    CreatePolicyParser.parse(pgDatabase, string2);
                } else if (PATTERN_CREATE_RULE.matcher(string2).matches()) {
                    CreateRuleParser.parse(pgDatabase, string2);
                } else if (bl) {
                    pgDatabase.addIgnoredStatement(string2);
                }
            }
            string2 = PgDumpLoader.getWholeStatement(bufferedReader);
        }
        return pgDatabase;
    }

    public static PgDatabase loadDatabaseSchema(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (string.equals("-")) {
            return PgDumpLoader.loadDatabaseSchema(System.in, string2, bl, bl2, bl3);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            PgDatabase pgDatabase = PgDumpLoader.loadDatabaseSchema(fileInputStream, string2, bl, bl2, bl3);
            return pgDatabase;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileException(MessageFormat.format(Resources.getString("FileNotFound"), string), fileNotFoundException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getWholeStatement(BufferedReader bufferedReader) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        if (lineBuffer != null) {
            stringBuilder.append(lineBuffer);
            lineBuffer = null;
            PgDumpLoader.stripComment(stringBuilder);
        }
        int n = stringBuilder.indexOf(";");
        while (true) {
            if (n == -1) {
                String string;
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    throw new FileException(Resources.getString("CannotReadFile"), iOException);
                }
                if (string == null) {
                    if (stringBuilder.toString().trim().length() == 0) {
                        return null;
                    }
                    throw new RuntimeException(MessageFormat.format(Resources.getString("EndOfStatementNotFound"), stringBuilder.toString()));
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(System.getProperty("line.separator"));
                }
                n = stringBuilder.length();
                stringBuilder.append(string);
                PgDumpLoader.stripComment(stringBuilder);
                n = stringBuilder.indexOf(";", n);
                continue;
            }
            if (!PgDumpLoader.isQuoted(stringBuilder, n)) {
                if (n == stringBuilder.length() - 1) {
                    lineBuffer = null;
                } else {
                    lineBuffer = stringBuilder.substring(n + 1);
                    stringBuilder.setLength(n + 1);
                }
                return stringBuilder.toString().trim();
            }
            n = stringBuilder.indexOf(";", n + 1);
        }
    }

    private static void stripComment(StringBuilder stringBuilder) {
        int n = stringBuilder.indexOf("--");
        while (n >= 0) {
            if (n == 0) {
                stringBuilder.setLength(0);
                return;
            }
            if (!PgDumpLoader.isQuoted(stringBuilder, n)) {
                stringBuilder.setLength(n);
                return;
            }
            n = stringBuilder.indexOf("--", n + 1);
        }
        int n2 = stringBuilder.indexOf("*/");
        while (n2 >= 0) {
            int n3;
            if (!PgDumpLoader.isQuoted(stringBuilder, n2) && (n3 = stringBuilder.lastIndexOf("/*", n2)) < n2 && !PgDumpLoader.isQuoted(stringBuilder, n3)) {
                stringBuilder.replace(n3, n2 + 2, "");
            }
            n2 = stringBuilder.indexOf("*/", n2 + 2);
        }
    }

    private static boolean isQuoted(StringBuilder stringBuilder, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.charAt(i) == '\"' && !bl3) {
                boolean bl4 = bl2 = !bl2;
            }
            if (stringBuilder.charAt(i) == '\'' && !bl2) {
                boolean bl5 = bl3 = !bl3;
            }
            if (bl2) continue;
            if (stringBuilder.charAt(i) == '\'') {
                boolean bl6 = bl = !bl;
                if (n <= 0 || stringBuilder.charAt(n - 1) != '\\') continue;
                bl = !bl;
                continue;
            }
            if (stringBuilder.charAt(i) != '$' || bl) continue;
            int n2 = stringBuilder.indexOf("$", i + 1);
            if (n2 == -1) {
                return false;
            }
            String string = stringBuilder.substring(i, n2 + 1);
            if (!PgDumpLoader.isCorrectTag(string)) {
                return false;
            }
            int n3 = stringBuilder.indexOf(string, n2 + 1);
            if (n3 == -1 || n3 > n) {
                return true;
            }
            i = n3 + string.length() - 1;
        }
        return bl;
    }

    private static boolean isCorrectTag(String string) {
        return !PATTERN_DOLLAR_TAG.matcher(string).find();
    }

    private PgDumpLoader() {
    }
}

