/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.io.PrintWriter;

public class PgDiffFunctions {
    public static void createFunctions(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        for (PgFunction pgFunction : pgSchema2.getFunctions()) {
            PgFunction pgFunction2 = pgSchema == null ? null : pgSchema.getFunction(pgFunction.getSignature());
            if (pgFunction2 != null && pgFunction.equals(pgFunction2, pgDiffArguments.isIgnoreFunctionWhitespace())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgFunction.getCreationSQL());
        }
    }

    public static void dropFunctions(PrintWriter printWriter, PgDiffArguments pgDiffArguments, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgFunction pgFunction : pgSchema.getFunctions()) {
            if (pgSchema2.containsFunction(pgFunction.getSignature())) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.println(pgFunction.getDropSQL());
        }
    }

    public static void alterComments(PrintWriter printWriter, PgSchema pgSchema, PgSchema pgSchema2, SearchPathHelper searchPathHelper) {
        if (pgSchema == null) {
            return;
        }
        for (PgFunction pgFunction : pgSchema.getFunctions()) {
            boolean bl;
            PgFunction pgFunction2 = pgSchema2.getFunction(pgFunction.getSignature());
            if (pgFunction2 == null) continue;
            if (pgFunction.getComment() == null && pgFunction2.getComment() != null || pgFunction.getComment() != null && pgFunction2.getComment() != null && !pgFunction.getComment().equals(pgFunction2.getComment())) {
                searchPathHelper.outputSearchPath(printWriter);
                printWriter.println();
                printWriter.print("COMMENT ON FUNCTION ");
                printWriter.print(PgDiffUtils.getQuotedName(pgFunction2.getName()));
                printWriter.print('(');
                bl = false;
                for (PgFunction.Argument argument : pgFunction2.getArguments()) {
                    if (bl) {
                        printWriter.print(", ");
                    } else {
                        bl = true;
                    }
                    printWriter.print(argument.getDeclaration(false));
                }
                printWriter.print(") IS ");
                printWriter.print(pgFunction2.getComment());
                printWriter.println(';');
                continue;
            }
            if (pgFunction.getComment() == null || pgFunction2.getComment() != null) continue;
            searchPathHelper.outputSearchPath(printWriter);
            printWriter.println();
            printWriter.print("COMMENT ON FUNCTION ");
            printWriter.print(PgDiffUtils.getQuotedName(pgFunction2.getName()));
            printWriter.print('(');
            bl = false;
            for (PgFunction.Argument argument : pgFunction2.getArguments()) {
                if (bl) {
                    printWriter.print(", ");
                } else {
                    bl = true;
                }
                printWriter.print(argument.getDeclaration(false));
            }
            printWriter.println(") IS NULL;");
        }
    }

    private PgDiffFunctions() {
    }
}

