/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.Resources;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.SortedMap;

public class PgDiffArguments {
    private String inCharsetName = "UTF-8";
    private String newDumpFile;
    private String oldDumpFile;
    private String outCharsetName = "UTF-8";
    private boolean addDefaults;
    private boolean addTransaction;
    private boolean ignoreFunctionWhitespace;
    private boolean ignoreStartWith;
    private boolean version;
    private boolean outputIgnoredStatements;
    private boolean listCharsets;
    private boolean ignoreSlonyTriggers;
    private boolean ignoreSchemaCreation;
    private boolean useIfExists;

    public void setAddDefaults(boolean bl) {
        this.addDefaults = bl;
    }

    public boolean isAddDefaults() {
        return this.addDefaults;
    }

    public void setAddTransaction(boolean bl) {
        this.addTransaction = bl;
    }

    public boolean isAddTransaction() {
        return this.addTransaction;
    }

    public void setIgnoreFunctionWhitespace(boolean bl) {
        this.ignoreFunctionWhitespace = bl;
    }

    public boolean isIgnoreFunctionWhitespace() {
        return this.ignoreFunctionWhitespace;
    }

    public void setIgnoreStartWith(boolean bl) {
        this.ignoreStartWith = bl;
    }

    public boolean isIgnoreStartWith() {
        return this.ignoreStartWith;
    }

    public void setNewDumpFile(String string) {
        this.newDumpFile = string;
    }

    public String getNewDumpFile() {
        return this.newDumpFile;
    }

    public void setOldDumpFile(String string) {
        this.oldDumpFile = string;
    }

    public String getOldDumpFile() {
        return this.oldDumpFile;
    }

    public boolean isOutputIgnoredStatements() {
        return this.outputIgnoredStatements;
    }

    public void setOutputIgnoredStatements(boolean bl) {
        this.outputIgnoredStatements = bl;
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean parse(PrintWriter printWriter, String[] stringArray) {
        boolean bl = true;
        int n = stringArray.length >= 2 ? stringArray.length - 2 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            if ("--add-defaults".equals(stringArray[i])) {
                this.setAddDefaults(true);
                continue;
            }
            if ("--add-transaction".equals(stringArray[i])) {
                this.setAddTransaction(true);
                continue;
            }
            if ("--ignore-function-whitespace".equals(stringArray[i])) {
                this.setIgnoreFunctionWhitespace(true);
                continue;
            }
            if ("--ignore-slony-triggers".equals(stringArray[i])) {
                this.setIgnoreSlonyTriggers(true);
                continue;
            }
            if ("--ignore-start-with".equals(stringArray[i])) {
                this.setIgnoreStartWith(true);
                continue;
            }
            if ("--ignore-schema-creation".equals(stringArray[i])) {
                this.setIgnoreSchemaCreation(true);
                continue;
            }
            if ("--in-charset-name".equals(stringArray[i])) {
                this.setInCharsetName(stringArray[i + 1]);
                ++i;
                continue;
            }
            if ("--list-charsets".equals(stringArray[i])) {
                this.setListCharsets(true);
                continue;
            }
            if ("--out-charset-name".equals(stringArray[i])) {
                this.setOutCharsetName(stringArray[i + 1]);
                ++i;
                continue;
            }
            if ("--output-ignored-statements".equals(stringArray[i])) {
                this.setOutputIgnoredStatements(true);
                continue;
            }
            if ("--version".equals(stringArray[i])) {
                this.setVersion(true);
                continue;
            }
            if ("--drop-if-exists".equals(stringArray[i])) {
                PgDiffUtils.setUseExists(true);
                continue;
            }
            printWriter.print(Resources.getString("ErrorUnknownOption"));
            printWriter.print(": ");
            printWriter.println(stringArray[i]);
            bl = false;
            break;
        }
        if (stringArray.length == 1 && this.isVersion()) {
            this.printVersion(printWriter);
            bl = false;
        } else if (stringArray.length == 1 && this.isListCharsets()) {
            this.listCharsets(printWriter);
            bl = false;
        } else if (stringArray.length < 2) {
            this.printUsage(printWriter);
            bl = false;
        } else if (bl) {
            this.setOldDumpFile(stringArray[stringArray.length - 2]);
            this.setNewDumpFile(stringArray[stringArray.length - 1]);
        }
        return bl;
    }

    private void printUsage(PrintWriter printWriter) {
        printWriter.println(Resources.getString("UsageHelp").replace("${tab}", "\t"));
    }

    private void printVersion(PrintWriter printWriter) {
        printWriter.print(Resources.getString("Version"));
        printWriter.print(": ");
        printWriter.println(Resources.getString("VersionNumber"));
    }

    public String getInCharsetName() {
        return this.inCharsetName;
    }

    public void setInCharsetName(String string) {
        this.inCharsetName = string;
    }

    public String getOutCharsetName() {
        return this.outCharsetName;
    }

    public void setOutCharsetName(String string) {
        this.outCharsetName = string;
    }

    public boolean isListCharsets() {
        return this.listCharsets;
    }

    public void setListCharsets(boolean bl) {
        this.listCharsets = bl;
    }

    private void listCharsets(PrintWriter printWriter) {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        for (String string : sortedMap.keySet()) {
            printWriter.println(string);
        }
    }

    public boolean isIgnoreSlonyTriggers() {
        return this.ignoreSlonyTriggers;
    }

    public void setIgnoreSlonyTriggers(boolean bl) {
        this.ignoreSlonyTriggers = bl;
    }

    public boolean isIgnoreSchemaCreation() {
        return this.ignoreSchemaCreation;
    }

    public void setIgnoreSchemaCreation(boolean bl) {
        this.ignoreSchemaCreation = bl;
    }
}

