# Section I - What would an anarchist society look like?

So far this FAQ has been largely critical, focusing on hierarchy, capitalism,
the state and so on, and the problems to which they have led, as well as
refuting some bogus "solutions" that have been offered by authoritarians of
both the right and the left. It is now time to examine the constructive side
of anarchism -- the libertarian-socialist society that anarchists envision.
This is important because anarchism is essentially a **constructive** theory,
in stark contradiction to the picture usually painted of anarchism as chaos or
mindless destruction.

In this section of the FAQ we will give an outline of what an anarchist
society might look like. Such a society has basic features -- such as being
non-hierarchical, decentralised and, above all else, spontaneous like life
itself. To quote Glenn Albrecht, anarchists _"lay great stress on the free
unfolding of a spontaneous order without the use of external force or
authority."_ [ _"Ethics, Anarchy and Sustainable Development"_ , pp. 95-117,
**Anarchist Studies** , vol. 2, no. 2, p. 110] This type of development
implies that anarchist society would be organised from the simple to the
complex, from the individual upwards to the community, the bio-region and,
ultimately, the planet. The resulting society, which would be the outcome of
nature freely unfolding toward greater diversity and complexity, is ethically
preferable to any other sort of order simply because it allows for the highest
degree of organic solidarity and freedom. Kropotkin described this vision of a
truly free society as follows:

> _"We foresee millions and millions of groups freely constituting themselves
> for the satisfaction of all the varied needs of human beings . . . All these
> will be composed of human beings who will combine freely . . . 'Take
> pebbles,' said Fourier, 'put them in a box and shake them, and they will
> arrange themselves in a mosaic that you could never get by instructing to
> anyone the work of arranging them harmoniously.'"_ [ **The Place of
> Anarchism in Socialistic Evolution** , pp. 11-12]

Anarchist opposition to hierarchy is an essential part of a "spontaneously
ordered" society, for authority stops the free development and growth of the
individual. From this natural growth of individuals, groups and society as a
whole anarchists expect a society which meets the needs of all -- for
individual and social freedom, material goods to meet physical needs and free
and equal social relationships that meet what could be termed "spiritual
needs" (i.e., mental and emotional wellbeing, creativity, ethical development
and so on). Any attempt to force society or individuals into a pre-determined
structure which restricts their liberty will produce **dis** -order as natural
balances and development is hindered and distorted in anti-social and
destructive directions. Thus an anarchist society must be a free society of
free individuals, associating within libertarian structures, rather than a
series of competing hierarchies (be they political or economical). Only in
freedom can society and individuals develop and create a just and fair world.
In Proudhon's words, _"liberty is the mother of order, not its daughter."_

As the individual does not exist in a social vacuum, appropriate social
conditions are required for individual freedom to develop and blossom
according to its full potential. The theory of anarchism is built around the
central assertion that individuals and their organisations **cannot** be
considered in isolation from each other. That is, social structures shape us,
_"that there is an interrelationship between the authority structures of
institutions and the psychological qualities and attitudes of individuals"_
and that _"the major function of participation is an educative one."_ [Carole
Pateman, **Participation and Democratic Theory** , p. 27] Anarchism presents
this position in its most coherent and libertarian form. In other words,
freedom is only sustained and protected by activity under conditions of
freedom, namely self-government. Freedom is the only precondition for
acquiring the maturity required for continued freedom: _"Only in freedom can
man grow to his full stature. Only in freedom will be learn to think and move,
and give the very best in him."_ [Emma Goldman, **Red Emma Speaks** , p. 72]

As individual freedom can only be created, developed and defended by self-
government and free association, a system which encourages individuality must
be decentralised and participatory in order for people to develop a psychology
that allows them to accept the responsibilities of self-management. Living
under the state or any other authoritarian system produces a servile
character, as the individual is constantly placed under hierarchical
authority, which blunts their critical and self-governing abilities by lack of
use. Such a situation cannot promote freedom, and so anarchists _"realise that
power and authority corrupt those who exercise them as much as those who are
compelled to submit to them."_ [Bakunin, **The Political Philosophy of
Bakunin** , p. 249]

Looking at capitalism, we find that under wage labour people sell their
creative energy and control over their activity for a given period. The boss
does not just take surplus value from the time employees sell, but the time
itself -- their liberty, their ability to make their own decisions, express
themselves through work and with their fellow workers. Wage labour equals wage
slavery as you sell your time and skills (i.e. liberty) everyday at work and
you will never be able to buy that time back for yourself. Once it is gone; it
is gone for good. It also generates, to quote Godwin, a _"sense of
dependence"_ and a _"servile and truckling spirit"_ , so ensuring that the
_"feudal spirit still survives that reduced the great mass of mankind to the
rank of slaves and cattle for the service of the few."_ [ **The Anarchist
Writings of William Godwin** , pp. 125-6] This is why anarchists see the need
to _"create the situation where each person may live by working freely,
without being forced to sell his [or her] work and his [or her] liberty to
others who accumulate wealth by the labour of their serfs."_ [Kropotkin,
**Words of a Rebel** , p. 208]

Thus the aim of anarchism is to create a society in which every person _should
have the material and moral means to develop his humanity"_ and so to _"
**organise society in such a way that every individual . . . should find . . .
approximately equal means for the development of [their] various faculties and
for their utilisation in [their] work** ; to create a society which would
place every individual . . . in such a position that it would be impossible
for [them] to exploit the labour of anyone else"_ and be _"enabled to
participate in the enjoyment of social wealth"_ as long as they _"contributed
directly toward the production of that wealth."_ [Bakunin, **Op. Cit.** , p.
409] As such, anarchists would agree with George Orwell: _"The question is
very simple. Shall people . . . be allowed to live the decent, fully human
life which is now technically achievable, or shan't they? Shall the common man
be pushed back into the mud, or shall he not?"_ [ **Orwell on Spain** , p.
361]

Anarchism, in summary, is about changing society and abolishing all forms of
authoritarian social relationship, putting life before the soul-destroying
"efficiency" needed to survive under capitalism; for the anarchist _"takes his
stand on his positive right to life and all its pleasures, both intellectual,
moral and physical. He loves life, and intends to enjoy it to the full."_
[Bakunin, **Michael Bakunin: Selected Writings** , p. 101] Thus, to quote Emma
Goldman, _"all human-beings, irrespective of race, colour, or sex, are born
with the equal right to share at the table of life; that to secure this right,
there must be established among men economic, social, and political freedom."_
[ **A Documentary History of the American Years** , vol. 2, p. 450] This would
be a classless and non-hierarchical society, one without masters and servants,
one based on the free association of free individuals which encourages and
celebrates individuality and freedom:

> _"The phrase, 'a classless society', no doubt has terrors for any thoughtful
> person. It calls up immediately the image of dull mediocrity . . . all one
> uniform scale of self-sufficient individuals, living in model-houses,
> travelling in uniform Fords along endless uniform roads . . . But . . . the
> sharing of this wealth would not produce a uniformity of life, simply
> because there is no uniformity of desire. Uniformity is an unintelligent
> nightmare; there can be no uniformity in a free human society. Uniformity
> can only be created by the tyranny of a totalitarian regime."_ [Herbert
> Read, **Anarchy and Order** , pp. 87-8]

Anarchists think that the essential social values are human values, and that
society is a complex of associations which express the wills of their members,
whose well-being is its purpose. We consider that it is not enough that the
forms of association should have the passive or "implied" consent of their
members, but that the society, and the individuals who make it up, will be
healthy only if it is in the full sense libertarian, i.e. self-governing,
self-managed, and egalitarian. This implies not only that all the members
should have a right to influence its policy if they so desire, but that the
greatest possible opportunity should be afforded for every person to exercise
this right. Anarchism involves an active, not merely passive, citizenship on
the part of society's members and holds that this principle is not only
applied to some "special" sphere of social action called "politics" but to any
and every form of social action, including economic activity.

So, as will be seen, the key concept underlying both the social/political and
the economic structure of libertarian socialism is _"self-management,"_ a term
that implies not only workers control of their workplaces but also citizens'
control of their communities (where it becomes _"self-government"_ ), through
direct democracy and voluntary federation. Thus self-management is the
positive implication of anarchism's "negative" principle of opposition to
hierarchical authority. For through self-management, hierarchical authority is
dissolved as self-managing workplace and community assemblies/councils are
decentralised, "horizontal" organisations in which each participant has an
equal voice in the decisions that affect his or her life, instead of merely
following orders and being governed by others. Self-management, therefore, is
the essential condition for a world in which individuals will be free to
follow their own dreams, in their own ways, co-operating together as equals
without interference from any form of authoritarian power (such as government
or boss).

Perhaps needless to say, this section is intended as a heuristic device
**only** , as a way of helping readers envision how anarchist principles might
be embodied in practice. It is not (nor is it intended to be, nor is it
desired to be) a definitive statement of how they **must** be embodied. The
idea that a few people could determine exactly what a free society would look
like is contrary to the anarchist principles of free growth and thought, and
is far from our intention. Here we simply try to indicate some of the
structures that an anarchist society may contain, based on the ideals and
ideas anarchists hold, informed by the few examples of anarchy in action that
have existed and our critical evaluation of their limitations and successes.
As Herbert Read once put it, _"it is always a mistake to build **a priori**
constitutions. The main thing is to establish your principles -- the
principles of equity, of individual freedom, of workers' control. The
community then aims at the establishment of these principles from the
starting-point of local needs and local conditions."_ [ **Op. Cit.** , p. 51]

Moreover, we must remember that the state has changed over time and has not
always existed. Thus it is possible to have a social organisation which is not
a state and to confuse the two would be a _"confusion"_ made by those _"who
cannot visualise Society without a concentration of the State."_ Yet this _"is
to overlook the fact that Man lived in Societies for thousands of years before
the State had been heard of"_ and that _"large numbers of people [have] lived
in communes and free federations."_ These were not states as the state _"is
only one of the forms assumed by society in the course of history. Why then
make no distinction between what is permanent and what is accidental?"_
[Kropotkin, **The State: Its Historic Role** , pp. 9-10] Similarly, the axioms
of capitalist economics **not** withstanding, capitalism is but latest of a
series of economies. Just as serfdom replaced slavery and capitalism replaced
serfdom, so free (associated) labour can replace hired labour. As Proudhon
noted, the _"period through which we are now passing"_ is _"distinguished by a
special characteristic: WAGE-LABOUR."_ Capitalism has not always existed nor
need it continue. So while _"the radical vice of political economy"_ is
_"affirming as a definitive state a transitory condition - namely, the
division of society into patricians and proletarians"_ in reality, _"_ _in its
present form, the organisation [of labour] is inadequate and transitory. "_ [
**Property Is Theft!** , p. 190, p. 174 and p. 170] Anarchists seek to make
that transitory condition shorter rather than longer.

Ultimately, a free society based on self-managed communities and associated
labour is, in many ways, a natural evolution of tendencies **within** existing
society. For example, the means of production can only be used collectively,
so suggesting that relations of equality and freedom based on associations of
workers are a sensible alternative to ones based on hierarchy, exploitation
and oppression based on masters and servants. It is the struggle against those
oppressive social relationships which creates the very associations (workplace
strike assemblies) which could expropriate the workplaces and make that
possibility a reality.

So an anarchist society will not be created overnight nor without links to the
past, and so it will initially be based on structures created in social
struggle (i.e. created **within** but **against** capitalism and the state)
and will be marked with the ideas that inspired and developed within that
struggle. For example, the anarchist collectives in Spain were organised in a
bottom-up manner, similar to the way the C.N.T. (the anarcho-syndicalist
labour union) was organised before the revolution. In this sense, anarchy is
not some distant goal but rather an expression of working class struggle. The
creation of alternatives to the current hierarchical, oppressive, exploitative
and alienated society is a necessary part of the struggle and the maintaining
of your liberty and humanity in the insane world of hierarchical society. As
such, an anarchist society will be the generalisation of the various types of
**_"anarchy in action"_** created in the various struggles against all forms
of oppression and exploitation (see [section I.2.3](secI2.md#seci23) ).

This means that how an anarchist society would look like and work is not
independent of the specific societies it is created from nor the means used to
create it. In other words, an anarchist society will reflect the economic
conditions inherited from capitalism, the social struggles which preceded it
and the ideas which existed within that struggle as modified by the practical
needs of any given situation. Therefore the vision of a free society indicated
in this section of the FAQ is not some sort of abstraction which will be
created overnight. If anarchists did think that then we would rightly be
called utopian. No, an anarchist society is the outcome of social struggle,
self-activity which helps to create a mass movement which contains individuals
who can think for themselves and are willing and able to take responsibility
for their own lives.

So, when reading this section please remember that this is not a blueprint but
only possible suggestions of what anarchy would look like. It is designed to
provoke thought and indicate that an anarchist society is possible. We hope
that our arguments and ideas presented in this section will inspire more
debate and discussion of how a free society could work and, equally as
important, help to inspire the struggle which will create that society. After
all, anarchists desire to build the new world in the shell of the old. Unless
we have some idea of what that new society will be like it is difficult to
pre-figure it in our activities today! A point not lost on Kropotkin who
argued that it is difficult to build _"without extremely careful consideration
beforehand, based on the study of social life, of **what** and **how** we want
to build -- we must reject [Proudhon's] slogan [that "in demolishing we shall
build"] . . . and declare: 'in building we shall demolish.'"_ [ **Conquest of
Bread** , p. 173f] More recently, Noam Chomsky argued that _"[a]lternatives to
existing forms of hierarchy, domination, private power and social control
certainly exist in principle. . . But to make them realistic will require a
great deal of committed work, including the work of articulating them
clearly."_ [Noam Chomsky, **Turning the Tide** , p. 250] This section of the
FAQ can be considered as a contribution to the articulating of libertarian
alternatives to existing society, of what we want to build for the future.

We are not afraid that many will argue that much of the vision we present in
this section of the FAQ is utopian. Perhaps they are right, but, as Oscar
Wilde once said:

> _"A map of the world that does not include Utopia is not worth glancing at,
> for it leaves out the one country at which Humanity is always landing. And
> when Humanity lands there, it looks out and, seeing a better country, sets
> sail. Progress is the realisation of Utopias."_ [ **The Soul of Man Under
> Socialism** , p. 1184]

However, we have attempted to be as practical as we are visionary, presenting
realistic problems as well as presenting evidence for our solutions to these
problems from real life where possible, rather than present a series of
impossible assumptions which dismiss possible problems by definition. It is
better to consider the worse possible cases for if they do not appear then
nothing has been lost and if they do at least we have a starting point for
possible solutions. So, all in all, we have tried to be practical utopians!

We must stress, however, that anarchists do not want a "perfect" society (as
is often associated with the term _"utopia"_ ). This would be as impossible as
the neo-classical economic vision of perfect competition. Rather we want a
free society and so one based on real human beings and so one with its own
problems and difficulties. Our use of the word _"utopia"_ should not be taken
to imply that anarchists assume away all problems and argue that an anarchist
society would be ideal and perfect. No society has ever been perfect and no
society ever will be. All we argue is that an anarchist society will have
fewer problems than those before and be better to live within. Anyone looking
for perfection should look elsewhere. Anyone looking for a better, but still
human and so imperfect, world may find in anarchism a potential end for their
quest.

So anarchists are realistic in their hopes and dreams. We do not conjure up
hopes that cannot achieved but rather base our visions in an analysis of what
is wrong with society today and a means of changing the world for the better.
And even if some people call us utopians, we shrug off the accusation with a
smile. After all, dreams are important, not only because they are often the
source of change in reality but because of the hope they express:

> _"People may . . . call us dreamers . . . They fail to see that dreams are
> also a part of the reality of life, that life without dreams would be
> unbearable. No change in our way of life would be possible without dreams
> and dreamers. The only people who are never disappointed are those who never
> hope and never try to realise their hope."_ [Rudolf Rocker, **The London
> Years** , p. 95]

One last point. We must point out here that we are discussing the social and
economic structures of areas within which the inhabitants are predominately
anarchists. It is obviously the case that areas in which the inhabitants are
not anarchists will take on different forms depending upon the ideas that
dominate there. Hence, assuming the end of the current state structure, we
could see anarchist communities along with statist ones (capitalist or
socialist) and these communities taking different forms depending on what
their inhabitants want -- communist to individualist communities in the case
of anarchist ones, state socialist to private state communities in the statist
areas, ones based on religious sects and so on. As Malatesta argued,
anarchists _"must be intransigent in our opposition to all capitalist
imposition and exploitation, and tolerant of all social concepts which prevail
in different human groupings, so long as they do not threaten the equal rights
and freedom of others."_ [ **Errico Malatesta: His Life and Ideas** , p. 174]
Thus we respect the wishes of others to experiment and live their own lives as
they see fit, while encouraging those in capitalist and other statist
communities to rise in revolution against their masters and join the free
federation of the anarchist community. Needless to say, we do not discuss non-
anarchist communities here as it is up to non-anarchists to present their
arguments in favour of their kind of statism.

So remember that we are not arguing that everyone will live in an anarchist
way in a free society. Far from it. There will be pockets of unfreedom around,
simply because the development of ideas varies from area to area. Anarchists,
needless to say, are against forcing people to become anarchists (how can you
force someone to be free?) Our aim is to encourage those subject to authority
to free themselves and to work with them to create an anarchist society but,
obviously, how successful we are at this will vary. We can, therefore, expect
areas of freedom to co-exist with areas dominated by, say, state socialism,
religion or capitalism just as we can expect to see different kinds of
anarchism co-existing.

However, it would be a mistake to assume that just because there are many
choices of community available that it automatically makes a society an
anarchist one. For example, the modern world boasts over 200 different states.
For most of them, individuals can leave and join another if it will let them.
There is no world government as such. This does not make this series of states
an anarchy. Similarly, a system based on different corporations is not an
anarchy either, nor would be one based on a series of company towns and
neither would a (quasi-feudal or neo-feudal?) system based on a multitude of
landlords who hire their land and workplaces to workers in return for rent.
The nature of the associations is just as important as their voluntary nature.
As Kropotkin argued, the _"communes of the next revolution will not only break
down the state and substitute free federation for parliamentary rule; they
will part with parliamentary rule within the commune itself . . . They will be
anarchist within the commune as they will be anarchist outside it."_ [
**Selected Writings on Anarchism and Revolution** , p. 132] Hence an anarchist
society is one that is freely joined and left, is internally non-hierarchical
and non-oppressive and non-exploitative. Thus anarchist communities may co-
exist with non-anarchist ones but this does **not** mean the non-anarchist
ones are in any way anarchistic or libertarian.

To conclude. Anarchists, to state the blindly obvious, do not aim for chaos,
anarchy in the popular sense of the word (George Orwell once noted how one
right-wing author _"use[d] 'Anarchism' indifferently with 'anarchy', which is
a hardly more correct use of words than saying that a Conservative is one who
makes jam."_ [ **Op. Cit.** , p. 298]). Nor do anarchists reject any
discussion of what a free society would be like (such a rejection is usually
based on the somewhat spurious grounds that you cannot prescribe what free
people would do). In fact, anarchists have quite strong opinions on the basic
outlines of a free society, always premised on the assumption that these are
guidelines only. These suggestions are based on libertarian principles,
developments in the class struggle and a keen awareness of what is wrong with
class and hierarchical systems (and so what **not** to do!).

When reading this section of the FAQ remember that an anarchist society will
be created by the autonomous actions of the mass of the population, not by
anarchists writing books about it. This means any real anarchist society will
make many mistakes and develop in ways we cannot predict. This implies that
this is only a series of suggestions on how things **could** work in an
anarchist society -- it is **not** a blueprint of any kind. All anarchists can
do is present what we believe and why we think such a vision is both desirable
**and** viable. We hope that our arguments and ideas presented in this section
of the FAQ will inspire more debate and discussion of how a free society would
work. In addition, and equally as important, we hope it will help inspire the
struggle that will create that society.

[‹ Section I - What would an anarchist society look like?](secIcon.md "Go to
previous page") [up](secIcon.md "Go to parent page") [I.1 Isn't libertarian
socialism an oxymoron? ›](secI1.md "Go to next page")

