# G.6 What are the ideas of Max Stirner?

To some extent, Stirner's work **The Ego and Its Own** is like a Rorschach
test. Depending on the reader's psychology, he or she can interpret it in
drastically different ways. Hence, a few have tried to use Stirner's ideas to
defend capitalism while others have used them to argue for anarcho-
syndicalism. For example, many in the anarchist movement in Glasgow, Scotland,
took Stirner's _"Union of Egoists"_ literally as the basis for their anarcho-
syndicalist organising in the 1940s and beyond. Similarly, we discover the
noted anarchist historian Max Nettlau stating that _"[o]n reading Stirner, I
maintain that he cannot be interpreted except in a socialist sense."_ [ **A
Short History of Anarchism** , p. 55] In this section of the FAQ, we will
indicate why, in our view, the latter, syndicalistic, interpretation of egoism
is far more appropriate than the capitalistic one.

It should be noted, before continuing, that Stirner's work has had a bigger
impact on individualist anarchism than social anarchism. Benjamin Tucker and
many of his comrades embraced egoism when they became aware of **The Ego and
Its Own** (a development which provoked a split in individualist circles
which, undoubtedly, contributed to its decline). However, his influence was
not limited to individualist anarchism. As John P. Clark notes, Stirner _"has
also been seen as a significant figure by figures who are more in the
mainstream of the anarchist tradition. Emma Goldman, for example, combines an
acceptance of many of the principles of anarcho-syndicalism and anarcho-
communism with a strong emphasis on individuality and personal uniqueness. The
inspiration for this latter part of her outlook comes from thinkers like . . .
Stirner. Herbert Read has commented on the value of Stirner's defence of
individuality."_ [ **Max Stirner's Egoism** , p. 90] Daniel Guérin's classic
introduction to anarchism gives significant space to the German egoist,
arguing he _"rehabilitated the individual at a time when the philosophical
field was dominated by Hegelian anti-individualism and most reformers in the
social field had been led by the misdeeds of bourgeois egotism to stress its
opposite"_ and pointed to _"the boldness and scope of his thought."_ [
**Anarchism** , p. 27] From meeting anarchists in Glasgow during the Second
World War, long-time anarchist activist and artist Donald Rooum likewise
combined Stirner and anarcho-communism. In America, the short-lived
Situationist influenced group _"For Ourselves"_ produced the inspired **The
Right to Be Greedy: Theses on the Practical Necessity of Demanding
Everything** , a fusion of Marx and Stirner which proclaimed a _"communist
egoism"_ based on the awareness that greed _"in its fullest sense is the
**only possible** basis of communist society."_

It is not hard to see why so many people are influenced by Stirner's work. It
is a classic, full of ideas and a sense of fun that is lacking in many
political writers. For many, it is only known through the criticism Marx and
Engels subjected it too in their book **The German Ideology**. As with their
later attacks on Proudhon and Bakunin, the two Germans did not accurately
reflect the ideas they were attacking and, in the case of Stirner, they made
it their task to make them appear ridiculous and preposterous. That they took
so much time and energy to do so suggests that Stirner's work is far more
important and difficult to refute than their notoriously misleading diatribe
suggests. That in itself should prompt interest in his work.

As will become clear from our discussion, social anarchists have much to gain
from understanding Stirner's ideas and applying what is useful in them. While
some may object to our attempt to place egoism and communism together,
pointing out that Stirner rejected "communism". Quite! Stirner did not
subscribe to libertarian communism, because it did not exist when he was
writing and so he was directing his critique against the various forms of
**state** communism which did. Moreover, this does not mean that anarcho-
communists and others may not find his work of use to them. And Stirner would
have approved, for nothing could be more foreign to his ideas than to limit
what an individual considers to be in their best interest. Unlike the narrow
and self-defeating "egoism" of, say, Ayn Rand, Stirner did not prescribe what
was and was not in a person's self-interest. He did not say you should act in
certain ways because he preferred it, he did not redefine selfishness to allow
most of bourgeois morality to remain intact. Rather he urged the individual to
think for themselves and seek their own path. Not for Stirner the grim
"egoism" of "selfishly" living a life determined by some guru and which only
that authority figure would approve of. True egoism is not parroting what
Stirner wrote and agreeing with everything he expounded. Nothing could be more
foreign to Stirner's work than to invent "Stirnerism." As Donald Rooum put it:

> _"I am happy to be called a Stirnerite anarchist, provided 'Stirnerite'
> means one who agrees with Stirner's general drift, not one who agrees with
> Stirner's every word. Please judge my arguments on their merits, not on the
> merits of Stirner's arguments, and not by the test of whether I conform to
> Stirner."_ [ _"Anarchism and Selfishness"_ , pp. 251-9, **The Raven** , no.
> 3, p. 259fn]

With that in mind, we will summarise Stirner's main arguments and indicate why
social anarchists have been, and should be, interested in his ideas. Saying
that, John P. Clark presents a sympathetic and useful social anarchist
critique of his work in **Max Stirner's Egoism**. Unless otherwise indicated
all quotes are from Stirner's **The Ego and Its Own**.

So what is Stirner all about? Simply put, he is an Egoist, which means that he
considers self-interest to be the root cause of an individual's every action,
even when he or she is apparently doing "altruistic" actions. Thus: _"I am
everything to myself and I do everything **on my account**."_ Even love is an
example of selfishness, _"because love makes me happy, I love because loving
is natural to me, because it pleases me."_ He urges others to follow him and
_"take courage now to really make **yourselves** the central point and the
main thing altogether."_ As for other people, he sees them purely as a means
for self-enjoyment, a self-enjoyment which is mutual: _"For me you are nothing
but my food, even as I am fed upon and turned to use by you. We have only one
relation to each other, that of **usableness,** of utility, of use."_ [p. 162,
p. 291 and pp. 296-7]

For Stirner, all individuals are unique ( _"My flesh is not their flesh, my
mind is not their mind,"_ ) and should reject any attempts to restrict or deny
their uniqueness: _"To be looked upon as a mere **part,** part of society, the
individual cannot bear -- because he is **more** ; his uniqueness puts from it
this limited conception."_ Individuals, in order to maximise their uniqueness,
must become aware of the **real** reasons for their actions. In other words
they must become conscious, not unconscious, egoists. An unconscious, or
involuntary, egoist is one _"who is always looking after his own and yet does
not count himself as the highest being, who serves only himself and at the
same time always thinks he is serving a higher being, who knows nothing higher
than himself and yet is infatuated about something higher."_ [p. 138, p. 265
and p. 36] In contrast, egoists are aware that they act purely out of self-
interest, and if they support a "higher being," it is not because it is a
noble thought but because it will benefit them.

Stirner himself, however, has no truck with "higher beings." Indeed, with the
aim of concerning himself purely with his own interests, he attacks all
"higher beings," regarding them as a variety of what he calls _"spooks,"_ or
ideas to which individuals sacrifice themselves and by which they are
dominated. First amongst these is the abstraction _"Man"_ , into which all
unique individuals are submerged and lost. As he put it, _"liberalism is a
religion because it separates my essence from me and sets it above me, because
it exalts 'Man' to the same extent as any other religion does to God . . . it
sets me beneath Man."_ Indeed, he _"who is infatuated with **Man** leaves
persons out of account so far as that infatuation extends, and floats in an
ideal, sacred interest. **Man** , you see, is not a person, but an ideal, a
spook."_ [p. 176 and p.79] Among the many _"spooks"_ Stirner attacks are such
notable aspects of capitalist life as private property, the division of
labour, the state, religion, and (at times) society itself. We will discuss
Stirner's critique of capitalism before moving onto his vision of an egoist
society and how it relates to social anarchism.

For the egoist, private property is a spook which _"lives by the grace of
**law** "_ and it _"becomes 'mine' only by effect of the law"_. In other
words, private property exists purely _"through the **protection of the
State,** through the State's grace."_ Recognising its need for state
protection, Stirner is also aware that _"[i]t need not make any difference to
the 'good citizens' who protects them and their principles, whether an
absolute King or a constitutional one, a republic, if only they are protected.
And what is their principle, whose protector they always 'love'? Not that of
labour"_ , rather it is _" **interest-bearing possession** . . . **labouring
capital** , therefore . . . labour certainly, yet little or none at all of
one's own, but labour of capital and of the -- subject labourers."_ [p. 251,
p. 114, p. 113 and p. 114]

As can be seen from capitalist support for fascism, Stirner was correct -- as
long as a regime supports capitalist interests, the 'good citizens' (including
many on the so-called "libertarian" right) will support it. Stirner sees that
not only does private property require state protection, it also leads to
exploitation and oppression. As noted in [section D.10](secD10.md), like
subsequent anarchists like Kropotkin, Stirner attacked the division of labour
resulting from private property for its deadening effects on the ego and
individuality of the worker:

> _"When everyone is to cultivate himself into man, condemning a man to
> **machine-like labour** amounts to the same thing as slavery . . . Every
> labour is to have the intent that the man be satisfied. Therefore he must
> become a **master** in it too, be able to perform it as a totality. He who
> in a pin-factory only puts on heads, only draws the wire, works, as it were
> mechanically, like a machine; he remains half-trained, does not become a
> master: his labour cannot **satisfy** him, it can only **fatigue** him. His
> labour is nothing by itself, has no object **in itself,** is nothing
> complete in itself; he labours only into another's hands, and is **used**
> (exploited) by this other."_ [p. 121]

Stirner had nothing but contempt for those who defended property in terms of
"natural rights" and opposed theft and taxation with a passion because it
violates said rights. _"Rightful, or legitimate property of another,"_ he
stated, _"will be only that which **you** are content to recognise as such. If
your content ceases, then this property has lost legitimacy for you, and you
will laugh at absolute right to it."_ After all, _"what well-founded objection
could be made against theft"_ [p. 278 and p. 251] He was well aware that
inequality was only possible as long as the masses were convinced of the
sacredness of property. In this way, the majority ends up without property:

> _"Property in the civic sense means **sacred** property, such that I must
> **respect** your property . . . Be it ever so little, if one only has
> somewhat of his own - to wit, a **respected** property: The more such owners
> . . . the more 'free people and good patriots' has the State. _

> _"Political liberalism, like everything religious, counts on **respect** ,
> humaneness, the virtues of love . . . For in practice people respect
> nothing, and everyday the small possessions are bought up again by greater
> proprietors, and the 'free people' change into day labourers."_ [p. 248]

Thus free competition _"is not 'free,' because I lack the **things** for
competition."_ Due to this basic inequality of wealth (of "things"), _"[u]nder
the **regime** of the commonality the labourers always fall into the hands of
the possessors . . . of the capitalists, therefore. The labourer cannot
**realise** on his labour to the extent of the value that it has for the
customer."_ [p. 262 and p. 115] In other words, the working class is exploited
by the capitalists and landlords.

Moreover, it is the exploitation of labour which is the basis of the state,
for the state _"rests on the **slavery of labour.** If **labour becomes free**
, the State is lost."_ Without surplus value to feed off, a state could not
exist. For Stirner, the state is the greatest threat to his individuality: _"
**I** am free in **no** State."_ This is because the state claims to be
sovereign over a given area, while, for Stirner, only the ego can be sovereign
over itself and that which it uses (its _"property"_ ): _"I am my **own** only
when I am master of myself."_ Thus the state _"is not thinkable without
lordship and servitude (subjection); for the State must will to be the lord of
all that it embraces."_ Stirner also warned against the illusion in thinking
that political liberty means that the state need not be a cause of concern for
_"[p]olitical liberty means that the **polis** , the State, is free; . . .
not, therefore, that I am free of the State. . . It does not mean **my**
liberty, but the liberty of a power that rules and subjugates me; it means
that one of my **despots** . . . is free."_ [p. 116, p. 226, p. 169, p. 195
and p. 107]

Therefore Stirner urges insurrection against all forms of authority and
**dis** -respect for property. For _"[i]f man reaches the point of losing
respect for property, everyone will have property, as all slaves become free
men as soon as they no longer respect the master as master."_ And in order for
labour to become free, all must have _"property."_ _"The poor become free and
proprietors only when they **rise.** "_ Thus, _"[i]f we want no longer to
leave the land to the landed proprietors, but to appropriate it to ourselves,
we unite ourselves to this end, form a union, a **société** , that makes
**itself** proprietor . . . we can drive them out of many another property
yet, in order to make it **our** property, the property of the --
**conquerors**."_ Thus property _"deserves the attacks of the Communists and
Proudhon: it is untenable, because the civic proprietor is in truth nothing
but a propertyless man, one who is everywhere **shut out**. Instead of owning
the world, as he might, he does not own even the paltry point on which he
turns around."_ [p. 258, p. 260, p. 249 and pp. 248-9]

Stirner recognises the importance of self-liberation and the way that
authority often exists purely through its acceptance by the governed. As he
argues, _"no thing is sacred of itself, but my **declaring it sacred,** by my
declaration, my judgement, my bending the knee; in short, by my conscience."_
It is from this worship of what society deems _"sacred"_ that individuals must
liberate themselves in order to discover their true selves. And,
significantly, part of this process of liberation involves the destruction of
**hierarchy.** For Stirner, _"Hierarchy is domination of thoughts, domination
of mind!,"_ and this means that we are _"kept down by those who are supported
by thoughts."_ [p. 72 and p. 74] That is, by our own willingness to not
question authority and the sources of that authority, such as private property
and the state:

> _"Proudhon calls property 'robbery' ( **le vol** ) But alien property -- and
> he is talking of this alone -- is not less existent by renunciation,
> cession, and humility; it is a **present**. Who so sentimentally call for
> compassion as a poor victim of robbery, when one is just a foolish, cowardly
> giver of presents? Why here again put the fault on others as if they were
> robbing us, while we ourselves do bear the fault in leaving the others
> unrobbed? The poor are to blame for there being rich men."_ [p. 315]

For those, like modern-day "libertarian" capitalists, who regard "profit" as
the key to "selfishness," Stirner has nothing but contempt. Because "greed" is
just one part of the ego, and to spend one's life pursuing only that part is
to deny all other parts. Stirner called such pursuit _"self-sacrificing,"_ or
a _"one-sided, unopened, narrow egoism,"_ which leads to the ego being
possessed by one aspect of itself. For _"he who ventures everything else for
**one thing,** one object, one will, one passion . . . is ruled by a passion
to which he brings the rest as sacrifices."_ [p. 76]

For the true egoist, capitalists are _"self-sacrificing"_ in this sense,
because they are driven only by profit. In the end, their behaviour is just
another form of self-denial, as the worship of money leads them to slight
other aspects of themselves such as empathy and critical thought (the bank
balance becomes the rule book). A society based on such "egoism" ends up
undermining the egos which inhabit it, deadening one's own and other people's
individuality and so reducing the vast potential "utility" of others to
oneself. In addition, the drive for profit is not even based on self-interest,
it is forced upon the individual by the workings of the market (an alien
authority) and results in labour _"claim[ing] all our time and toil,"_ leaving
no time for the individual _"to take comfort in himself as the unique."_ [pp.
268-9]

Stirner also turns his analysis to "socialism" and "communism," and his
critique is as powerful as the one he directs against capitalism. This attack,
for some, gives his work an appearance of being pro-capitalist, while, as
indicated above, it is not. Stirner did attack socialism, but he (rightly)
attacked **state** socialism, not libertarian socialism, which did not really
exist at that time (the only well known anarchist work at the time was
Proudhon's **What is Property?** , published in 1840 and this work obviously
could not fully reflect the developments within anarchism that were to come).
He also indicated why moralistic (or altruistic) socialism is doomed to
failure, and laid the foundations of the theory that socialism will work only
on the basis of egoism (communist-egoism, as it is sometimes called). Stirner
correctly pointed out that much of what is called socialism was nothing but
warmed up liberalism, and as such ignores the individual: _"Whom does the
liberal look upon as his equal? Man! . . ., In other words, he sees in you,
not **you** , but the **species.** "_ A socialism that ignores the individual
consigns itself to being state capitalism, nothing more. "Socialists" of this
school forget that "society" is made up of individuals and that it is
individuals who work, think, love, play and enjoy themselves. Thus: _"That
society is no ego at all, which could give, bestow, or grant, but an
instrument or means, from which we may derive benefit . . . of this the
socialists do not think, because they -- as liberals -- are imprisoned in the
religious principle and zealously aspire after -- a sacred society, such as
the State was hitherto."_ [p. 123]

Of course, for the egoist libertarian communism can be just as much an option
as any other socio-political regime. As Stirner stressed, egoism _"is not
hostile to the tenderest of cordiality . . . nor of socialism: in short, it is
not inimical to any interest: it excludes no interest. It simply runs counter
to un-interest and to the uninteresting: it is not against love but against
sacred love . . . not against socialists, but against the sacred socialists."_
[ **No Gods, No Masters** , vol. 1, p. 23] After all, if it aids the
individual then Stirner had no more problems with libertarian communism that,
say, rulers or exploitation. Yet this position does not imply that egoism
tolerates the latter. Stirner's argument is, of course, that those who are
subject to either have an interest in ending both and should unite with those
in the same position to end it rather than appealing to the good will of those
in power. As such, it goes without saying that those who find in egoism
fascistic tendencies are fundamentally wrong. Fascism, like any class system,
aims for the elite to rule and provides various spooks for the masses to
ensure this (the nation, tradition, property, and so on). Stirner, on the
other hand, urges an universal egoism rather than one limited to just a few.
In other words, he would wish those subjected to fascistic domination to
reject such spooks and to unite and rise against those oppressing them:

> _"Well, who says that every one can do everything? What are you there for,
> pray, you who do not need to put up with everything? Defend yourself, and no
> one will do anything to you! He who would break your will has to do with
> you, and is your **enemy**. Deal with him as such. If there stand behind you
> for your protection some millions more, then you are an imposing power and
> will have an easy victory."_ [p. 197]

That Stirner's desire for individual autonomy becomes transferred into support
for rulership for the few and subjection for the many by many of his critics
simply reflects the fact we are conditioned by class society to accept such
rule as normal -- and hope that our masters will be kind and subscribe to the
same spooks they inflict on their subjects. It is true, of course, that a
narrow "egoism" would accept and seek such relationships of domination but
such a perspective is not Stirner's. This can be seen from how Stirner's
egoist vision could fit with social anarchist ideas.

The key to understanding the connection lies in Stirner's idea of the _"union
of egoists,"_ his proposed alternative mode of organising society. Stirner
believed that as more and more people become egoists, conflict in society will
decrease as each individual recognises the uniqueness of others, thus ensuring
a suitable environment within which they can co-operate (or find _"truces"_ in
the _"war of all against all"_ ). These _"truces"_ Stirner termed **_"Unions
of Egoists."_** They are the means by which egoists could, firstly,
_"annihilate"_ the state, and secondly, destroy its creature, private
property, since they would _"multiply the individual's means and secure his
assailed property."_ [p. 258]

The unions Stirner desires would be based on free agreement, being spontaneous
and voluntary associations drawn together out of the mutual interests of those
involved, who would _"care best for their welfare if they **unite** with
others."_ [p. 309] The unions, unlike the state, exist to ensure what Stirner
calls _"intercourse,"_ or _"union"_ between individuals. To better understand
the nature of these associations, which will replace the state, Stirner lists
the relationships between friends, lovers, and children at play as examples. [
**No Gods, No Masters** , vol. 1, p. 25] These illustrate the kinds of
relationships that maximise an individual's self-enjoyment, pleasure, freedom,
and individuality, as well as ensuring that those involved sacrifice nothing
while belonging to them. Such associations are based on mutuality and a free
and spontaneous co-operation between equals. As Stirner puts it, _"intercourse
is mutuality, it is the action, the **commercium,** of individuals."_ [p. 218]
Its aim is _"pleasure"_ and _"self-enjoyment."_ Thus Stirner sought a broad
egoism, one which appreciated others and their uniqueness, and so criticised
the narrow egoism of people who forgot the wealth others are:

> _"But that would be a man who does not know and cannot appreciate any of the
> delights emanating from an interest taken in others, from the consideration
> shown to others. That would be a man bereft of innumerable pleasures, a
> wretched character . . . would he not be a wretched egoist, rather than a
> genuine Egoist? . . . The person who loves a human being is, by virtue of
> that love, a wealthier man that someone else who loves no one."_ [ **No
> Gods, No Masters** , vol. 1, p. 23]

In order to ensure that those involved do not sacrifice any of their
uniqueness and freedom, the contracting parties have to have roughly the same
bargaining power and the association created must be based on self-management
(i.e. equality of power). Only under self-management can all participate in
the affairs of the union and express their individuality. Otherwise, we have
to assume that some of the egoists involved will stop being egoists and will
allow themselves to be dominated by another, which is unlikely. As Stirner
himself argued:

> _"But is an association, wherein most members allow themselves to be lulled
> as regards their most natural and most obvious interests, actually an
> Egoist's association? Can they really be 'Egoists' who have banded together
> when one is a slave or a serf of the other?. . ._

> _"Societies wherein the needs of some are satisfied at the expense of the
> rest, where, say, some may satisfy their need for rest thanks to the fact
> that the rest must work to the point of exhaustion, and can lead a life of
> ease because others live in misery and perish of hunger, or indeed who live
> a life of dissipation because others are foolish enough to live in
> indigence, etc., such societies . . . [are] more of a religious society, a
> communion held as sacrosanct by right, by law and by all the pomp and
> circumstance of the courts."_ [ **Op. Cit.** , p. 24]

Therefore, egoism's revolt against all hierarchies that restrict the ego
logically leads to the end of authoritarian social relationships, particularly
those associated with private property and the state. Given that capitalism is
marked by extensive differences in bargaining power outside its "associations"
(i.e. firms) and power within these "associations" (i.e. the worker/boss
hierarchy), from an egoist point of view it is in the self-interest of those
subjected to such relationships to get rid of them and replace them with
unions based on mutuality, free association, and self-management. Ultimately,
Stirner stresses that it is in the workers' **self-interest** to free
themselves from both state and capitalist oppression. Sounding like an
anarcho-syndicalist, Stirner recognised the potential for strike action as a
means of self-liberation:

> _"The labourers have the most enormous power in their hands, and, if they
> once become thoroughly conscious of it and used it, nothing could withstand
> them; they would only have to stop labour, regard the product of labour as
> theirs, and enjoy it. This is the sense of the labour disturbances which
> show themselves here and there."_ [p. 116]

Given the holistic and egalitarian nature of the union of egoists, it can be
seen that it shares little with the so-called free agreements of capitalism
(in particular wage labour). The hierarchical structure of capitalist firms
hardly produces associations in which the individual's experiences can be
compared to those involved in friendship or play, nor do they involve
equality. An essential aspect of the _"union of egoists"_ for Stirner was such
groups should be "owned" by their members, not the members by the group. That
points to a **libertarian** form of organisation within these "unions" (i.e.
one based on equality and participation), **not** a hierarchical one. If you
have no say in how a group functions (as in wage slavery, where workers have
the "option" of "love it or leave it") then you can hardly be said to own it,
can you? Indeed, Stirner argues, for _"[o]nly in the union can you assert
yourself as unique, because the union does not possess you, but you possess it
or make it of use to you."_ [p. 312]

Thus, Stirner's _"union of egoists"_ cannot be compared to the employer-
employee contract as the employees cannot be said to "own" the organisation
resulting from the contract (nor do they own themselves during work time,
having sold their labour/liberty to the boss in return for wages -- see
[section B.4](secB4.md)). Only within a participatory association can you
_"assert"_ yourself freely and subject your maxims, and association, to your
_"ongoing criticism"_ \-- in capitalist contracts you can do both only with
your bosses' permission.

And by the same token, capitalist contracts do not involve "leaving each other
alone" (a la "anarcho"-capitalism). No boss will "leave alone" the workers in
his factory, nor will a landowner "leave alone" a squatter on land he owns but
does not use. Stirner rejects the narrow concept of "property" as private
property and recognises the **social** nature of "property," whose use often
affects far more people than those who claim to "own" it: _"I do not step
shyly back from your property, but look upon it always as **my** property, in
which I 'respect' nothing. Pray do the like with what you call my property!"_
[p. 248] This view logically leads to the idea of both workers' self-
management and grassroots community control (as will be discussed more fully
in [section I](secIcon.md)) as those affected by an activity will take a
direct interest in it and not let "respect" for "private" property allow them
to be oppressed by others.

Moreover, egoism (self-interest) must lead to self-management and mutual aid
(solidarity), for by coming to agreements based on mutual respect and social
equality, we ensure non-hierarchical relationships. If I dominate someone,
then in all likelihood I will be dominated in turn. By removing hierarchy and
domination, the ego is free to experience and utilise the full potential of
others. As Kropotkin argued in **Mutual Aid** , individual freedom and social
co-operation are not only compatible but, when united, create the most
productive conditions for all individuals within society.

Stirner reminds the social anarchist that communism and collectivism are not
sought for their own sake but to ensure individual freedom and enjoyment. As
he argued: _"But should competition some day disappear, because concerted
effort will have been acknowledged as more beneficial than isolation, then
will not every single individual inside the associations be equally egoistic
and out for his own interests?"_ [ **Op. Cit.** , p. 22] This is because
competition has its drawbacks, for _"[r]estless acquisition does not let us
take breath, take a calm **enjoyment**. We do not get the comfort of our
possessions. . . Hence it is at any rate helpful that we come to an agreement
about **human** labours that they may not, as under competition, claim all our
time and toil."_ [p. 268] In other words, in the market only the market is
free not those subject to its pressures and necessities -- an important truism
which defenders of capitalism always ignore.

Forgetting about the individual was, for Stirner, the key problem with the
forms of communism he was familiar with and so this _"organisation of labour
touches only such labours as others can do for us . . . the rest remain
egoistic, because no one can in your stead elaborate your musical
compositions, carry out your projects of painting, etc.; nobody can replace
Raphael's labours. The latter are labours of a unique person, which only he is
competent to achieve."_ He went on to ask _"for whom is time to be gained [by
association]? For what does man require more time than is necessary to refresh
his wearied powers of labour? Here Communism is silent."_ Unlike egoism, which
answers: _"To take comfort in himself as unique, after he has done his part as
man!"_ In other words, competition _"has a continued existence"_ because _"all
do not attend to **their affair** and come to an **understanding** with each
other about it."_ [p. 269 and p. 275] As can be seen from Chapter 8 of
Kropotkin's **Conquest of Bread** ( _"The Need for Luxury"_ ), communist-
anarchism builds upon this insight, arguing that communism is required to
ensure that all individuals have the time and energy to pursue their own
unique interests and dreams (see [section I.4](secI4.md)).

Stirner notes that socialising property need not result in genuine freedom if
it is not rooted in individual use and control. He states _"the lord is
proprietor. Choose then whether you want to be lord, or whether society shall
be!"_ He notes that many communists of his time attacked alienated property
but did not stress that the aim was to ensure access for all individuals.
_"Instead of transforming the alien into own,"_ Stirner noted, _"they play
impartial and ask only that all property be left to a third party, such as
human society. They revindicate the alien not in their own name, but in a
third party's"_ Ultimately, of course, under libertarian communism it is not
"society" which uses the means of life but individuals and associations of
individuals. As Stirner stressed: _"Neither God nor Man ('human society') is
proprietor, but the individual."_ [p. 313, p. 315 and p. 251] This is why
social anarchists have always stressed self-management -- only that can bring
collectivised property into the hands of those who utilise it. Stirner places
the focus on decision making back where it belongs -- in the individuals who
make up a given community rather than abstractions like "society."

Therefore Stirner's union of egoists has strong connections with social
anarchism's desire for a society based on freely federated individuals, co-
operating as equals. His central idea of "property" -- that which is used by
the ego -- is an important concept for social anarchism because it stresses
that hierarchy develops when we let ideas and organisations own us rather than
vice versa. A participatory anarchist community will be made up of individuals
who must ensure that it remains their "property" and be under their control;
hence the importance of decentralised, confederal organisations which ensure
that control. A free society must be organised in such a way to ensure the
free and full development of individuality and maximise the pleasure to be
gained from individual interaction and activity. Lastly, Stirner indicates
that mutual aid and equality are based not upon an abstract morality but upon
self-interest, both for defence against hierarchy and for the pleasure of co-
operative intercourse between unique individuals.

Stirner demonstrates brilliantly how abstractions and fixed ideas ( _"spooks"_
) influence the very way we think, see ourselves, and act. He shows how
hierarchy has its roots within our own minds, in how we view the world. He
offers a powerful defence of individuality in an authoritarian and alienated
world, and places subjectivity at the centre of any revolutionary project,
where it belongs. Finally, he reminds us that a free society must exist in the
interests of all, and must be based upon the self-fulfilment, liberation and
enjoyment of the individual.

[‹ G.5 Benjamin Tucker: Capitalist or Anarchist?](secG5.md "Go to previous
page") [up](secGcon.md "Go to parent page") [G.7 Lysander Spooner:
right-"libertarian" or libertarian socialist? ›](secG7.md "Go to next page")

