/**
 * @file
 *
 * One large string.
 */

/******************************************************************************
 * Copyright AllSeen Alliance. All rights reserved.
 *
 *    Permission to use, copy, modify, and/or distribute this software for any
 *    purpose with or without fee is hereby granted, provided that the above
 *    copyright notice and this permission notice appear in all copies.
 *
 *    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *    WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *    MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *    ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *    ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *    OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ******************************************************************************/

/* This is AES-CCM encrypted data for the "Big Data" test case in aestest.c
 * It is encoded as an array because some compilers have size limits for string
 * literals.
 * The plaintext consists of 63 repeated random bytes.
 */
static const char expectedBigData[] = {
    '0', 'B', 'F', '8', '9', 'E', '3', 'B', '7', 'D', 'B', '8', '6', '2', '4', 'B',
    '5', 'A', '7', 'D', 'E', 'C', '7', '2', 'F', 'D', '5', 'A', '3', '2', '3', '6',
    '9', 'A', '6', 'B', '8', '4', 'F', 'E', '0', '5', 'D', '7', '4', 'A', '1', '1',
    '5', 'E', '4', 'D', '4', '0', 'A', '9', '0', '5', '5', 'C', '6', 'C', '0', 'A',
    'D', '6', '5', '6', '0', '9', 'B', 'E', 'E', 'F', 'F', '9', '3', 'D', 'B', 'A',
    'C', 'C', 'A', '5', '0', '8', 'B', '1', 'E', 'E', 'C', '5', 'E', '9', '0', 'C',
    '3', '6', '8', 'D', '4', 'D', '7', 'A', 'F', 'D', 'D', '1', 'F', '5', '3', '3',
    '3', '8', '5', '1', '9', 'C', '3', 'A', '1', '1', '8', '6', 'E', '8', 'D', '7',
    '8', '6', '0', '1', '7', '0', '7', 'F', 'A', 'E', 'C', '9', '3', '4', 'E', '3',
    '1', '6', 'A', '1', 'D', 'F', '6', 'D', 'F', 'E', '1', '8', '6', 'D', '0', '3',
    '2', '0', '2', 'D', '0', '9', '3', 'B', '5', 'B', 'D', 'E', '8', '6', '6', '5',
    '5', '6', '4', 'E', 'F', '7', '4', '5', '0', 'F', '7', 'A', 'A', 'D', '4', 'E',
    'B', 'C', 'A', '6', '5', '7', 'D', '3', 'D', '6', '8', 'B', 'A', '5', 'B', '5',
    '4', '0', '8', 'B', '0', '9', 'C', 'D', 'B', 'E', 'C', '1', 'C', 'B', '4', '1',
    '7', '6', '4', 'E', '3', '5', 'A', 'C', '4', '4', '2', '0', 'B', '2', 'F', '8',
    '5', 'D', '5', '9', '2', 'B', '0', 'D', '9', '8', '6', 'D', 'D', '2', 'C', 'A',
    '1', '1', 'C', 'D', '7', '0', 'D', 'B', '1', '9', 'E', 'D', '8', '0', '1', 'D',
    'C', 'E', '8', '0', 'A', '1', '7', '5', '9', 'D', '9', '8', 'E', '8', '8', '6',
    'A', '1', 'B', '2', '1', '3', '1', '7', '5', 'C', 'E', 'F', 'D', '2', '1', '1',
    'E', '5', '4', '5', '7', '0', 'D', '0', '9', 'D', '9', '5', '7', 'F', '2', 'A',
    'B', 'D', '9', '1', '4', '4', 'E', '5', '6', 'F', '2', 'B', '5', '4', '8', '0',
    '5', '6', '9', '9', 'C', 'D', '0', '5', '9', 'F', '9', 'A', 'B', 'D', 'C', '0',
    '4', '9', 'B', 'A', '9', 'A', 'A', '3', 'F', 'F', 'E', '1', 'F', '3', '2', 'C',
    '5', '0', '2', '2', '5', '4', 'C', '5', 'D', '0', '4', '2', '7', 'F', 'F', '8',
    '4', '6', '6', 'E', '2', 'C', '6', 'D', '9', '3', '9', '9', '3', 'C', 'C', '3',
    'B', 'E', 'F', 'F', 'F', '0', '5', '3', 'B', 'A', '9', '3', '4', '9', '2', 'F',
    'F', '1', 'A', 'A', '2', '5', 'A', '1', 'E', 'C', '3', '5', '2', '2', '3', 'F',
    '9', '3', '4', '1', '9', '8', '3', 'E', 'C', 'C', '2', '6', 'F', '9', '4', '5',
    '5', 'D', '5', '9', '1', '8', '9', 'B', '5', 'D', '7', '0', '5', 'B', '0', '3',
    '9', '9', 'D', '8', '7', 'F', 'D', '9', 'E', '2', '5', '4', '3', '5', '7', '3',
    '5', '2', 'E', '7', '1', 'D', 'F', '7', '4', '1', '0', '0', 'B', '1', 'D', '9',
    '3', '5', '1', 'B', '8', 'C', '7', '5', '6', 'D', '9', 'A', '2', '9', 'B', 'E',
    'E', 'C', 'E', '3', '9', '4', 'A', '7', '4', '1', '4', '2', 'B', '1', '5', 'F',
    'B', '8', '1', 'E', 'C', '7', '0', 'E', 'E', '7', '9', 'E', '6', 'C', '3', 'A',
    'D', '7', '8', '7', '1', 'F', '4', '6', '6', '0', 'C', '7', 'E', '0', '3', 'B',
    'A', 'A', '2', '5', '8', 'C', '6', '8', 'F', '7', 'E', '8', '4', 'B', '5', 'D',
    'B', 'B', 'B', '1', '7', '1', 'B', 'C', 'C', 'F', '2', '5', 'F', '7', 'B', '8',
    '0', '2', '4', '5', 'A', '8', '4', 'A', '0', '5', '7', '4', 'B', 'D', '3', 'F',
    'C', '7', 'A', 'A', '3', '1', 'F', 'C', '1', 'A', 'B', 'E', '7', '5', 'D', 'E',
    '0', '0', 'C', '1', 'A', '4', 'C', '2', 'D', 'D', '6', '1', '6', 'D', 'F', '1',
    '4', '2', '8', '4', 'B', '7', '5', '4', 'E', '1', 'D', 'E', 'C', '8', '5', '0',
    '1', 'A', '8', '9', '2', 'E', 'B', '8', '1', '0', '7', '0', '9', 'E', 'A', '4',
    'B', '3', '8', 'C', '7', 'B', '0', '1', 'E', '1', '6', '0', 'E', 'D', 'D', '1',
    'E', '7', '0', '5', '7', '0', 'A', 'C', '4', 'B', 'A', '3', '6', '9', '5', 'D',
    '5', '9', 'D', '6', 'B', '3', 'A', 'D', 'C', 'A', '2', '9', '0', 'B', 'C', '7',
    '7', '8', '2', '2', '2', '4', '4', '7', '7', 'F', '6', '8', 'A', '3', 'E', 'B',
    '4', '1', '1', '3', '0', '4', '6', '8', 'C', '7', '5', '8', '3', '7', 'C', '6',
    '0', '5', '6', 'D', '5', 'E', '1', '8', '5', '6', 'B', '1', 'E', 'C', 'F', '6',
    '0', '4', 'D', '6', 'E', '5', '8', 'F', 'C', 'D', 'F', '4', 'B', 'F', '6', '3',
    'E', '5', '5', '2', '5', 'B', 'A', '0', '6', '1', '1', 'D', '4', 'B', '9', '9',
    '1', 'C', 'B', 'E', 'E', '4', '4', '6', 'E', 'E', 'A', '6', '3', '5', '1', 'C',
    'C', '1', '5', '9', '9', 'C', 'E', '1', '5', 'E', 'E', '6', 'F', '1', '7', 'F',
    '0', 'A', 'F', '3', 'B', '0', 'E', '4', 'C', '1', 'B', 'F', '8', 'B', '3', '3',
    '3', '5', 'B', '7', 'D', 'E', '9', 'A', '2', '5', '1', '4', '9', '6', 'B', '1',
    '3', '2', 'F', '1', '2', 'F', '4', 'B', '4', '4', '5', '2', 'E', '4', 'A', '6',
    'A', 'D', '7', '1', '9', '4', 'D', 'E', 'B', 'B', '5', 'C', '5', 'B', '2', 'C',
    'B', '8', '9', '5', '2', '6', '5', '9', '5', '1', '2', '9', '7', 'E', 'B', '2',
    '4', '0', '7', '4', '1', 'A', '6', '0', '2', '8', '0', 'D', 'F', '5', 'D', '6',
    '9', '8', '4', '1', 'E', '5', 'E', '6', 'B', '9', '7', 'B', 'B', 'E', 'C', '1',
    'E', '6', '1', '5', 'C', 'A', '3', '2', '6', '0', '5', '6', '1', 'F', '4', 'D',
    'F', 'F', '8', '6', 'D', '0', 'D', 'B', '2', 'B', 'A', '2', 'F', 'C', 'D', '6',
    'E', 'D', '3', 'F', '5', 'E', '4', '1', 'F', 'A', 'C', 'D', 'B', 'E', '8', 'D',
    '1', '5', '9', '1', '1', '6', 'F', '6', '1', 'B', '8', 'C', 'C', '2', '8', '7',
    '0', '9', '9', '5', '0', 'B', 'B', '1', 'B', '9', 'F', '5', '5', 'F', '8', '2',
    '6', '8', '8', '0', '5', 'C', '1', '1', '5', '4', '2', '9', 'F', '0', 'F', 'C',
    '8', '6', '5', 'E', '1', 'D', 'C', '7', '0', 'D', 'C', '2', 'A', '1', 'E', '9',
    'B', '4', 'C', '3', 'A', '7', '5', '8', '0', 'A', 'F', 'B', '7', 'F', '0', 'F',
    '9', '9', '5', '7', '8', '5', 'F', 'D', '6', '2', '8', 'C', 'A', '6', '7', '4',
    '6', 'F', '5', '5', 'D', '5', 'D', '9', 'F', '4', 'F', '4', 'F', 'F', '5', '4',
    '5', '3', 'A', 'F', 'B', 'F', '7', 'F', 'D', 'D', '5', 'D', 'B', '0', 'B', '6',
    'C', '7', 'E', 'A', '8', '4', '9', '6', 'C', 'E', 'D', '1', '7', '5', 'E', 'F',
    '2', '5', '2', 'D', 'C', '3', '3', 'E', '0', '0', 'F', '0', 'D', '0', 'B', '8',
    '3', 'E', 'F', '0', '7', '7', '8', '4', 'A', '1', '4', 'D', 'A', '0', 'D', '7',
    '2', 'D', '3', 'A', '0', '5', '5', '5', '0', '4', '9', 'D', '4', '1', 'B', '1',
    'A', '6', 'C', '0', 'E', '3', 'F', '0', 'A', '4', '4', 'D', '9', 'B', 'D', '0',
    '2', 'E', 'F', '4', '2', '0', 'A', '5', '9', '9', '7', '5', '8', '0', '2', '6',
    '8', '5', '7', '0', 'D', '3', '6', '2', 'F', 'B', 'A', 'B', 'D', '1', '7', '2',
    '9', 'E', '4', '9', '6', '2', '3', 'D', '5', '8', '4', 'F', '6', '8', 'C', 'B',
    '3', 'C', 'B', '5', '7', '9', '1', 'E', 'F', '1', '0', 'D', '4', '9', '7', '6',
    '4', 'A', '4', '1', '9', 'F', '9', 'A', '2', 'F', '9', '3', '0', '8', 'D', '9',
    '3', '5', '7', '9', 'E', 'A', '6', 'F', 'E', '1', '0', '9', '5', '6', 'D', 'F',
    'B', 'F', 'D', '5', '3', '6', '6', '2', '5', '7', '6', '4', '8', 'A', 'F', '4',
    '2', '6', '6', 'E', '6', '6', 'A', '8', '1', 'E', '6', '3', 'B', '9', 'B', 'B',
    'C', '0', '0', '7', '7', 'D', '9', 'A', '8', '8', '2', '8', 'B', '0', '0', '1',
    '7', '0', '3', '6', '1', 'C', 'D', 'D', 'B', '4', '0', '3', 'B', 'A', '1', 'B',
    'C', '2', 'A', 'F', '7', '9', '1', '8', 'A', '5', '5', 'B', '2', '6', 'E', 'B',
    '3', '5', '0', 'E', '5', '0', '2', '7', 'B', '5', 'A', 'B', 'E', 'C', '9', '0',
    '1', 'D', '6', '5', 'C', '8', '9', 'D', 'C', 'A', 'A', 'E', 'B', 'C', '0', 'A',
    '2', 'C', '5', 'F', '4', 'E', '5', '4', '0', '8', 'C', 'B', '3', '8', '9', '9',
    'F', '9', '6', 'E', '3', 'D', '9', '5', '7', 'C', '5', '7', '2', 'E', 'E', '6',
    '7', 'C', '6', 'C', '8', 'F', 'D', '5', '1', '2', 'A', 'A', '7', 'A', '5', 'F',
    '6', 'A', '4', 'D', '7', 'F', '3', '1', '3', '2', '1', '2', '6', 'F', '3', '5',
    'A', '2', 'B', '7', '6', '4', 'B', '6', 'F', '9', 'F', '3', '7', 'C', '3', 'D',
    '1', '1', '7', '9', 'B', '1', 'E', '7', '4', '6', '1', 'D', '5', '5', 'A', '3',
    'C', '2', '1', '6', '9', '0', '5', '3', '4', '6', 'D', 'A', '4', 'A', '3', '9',
    'E', 'C', 'E', 'D', '7', 'B', '1', '7', '1', 'B', 'E', '4', 'B', '1', 'D', 'B',
    '4', '8', '5', '0', '1', '9', 'B', '8', 'D', '9', '2', '1', '0', '6', 'D', 'A',
    '9', '5', '4', '5', '1', '5', '0', 'F', '9', 'A', '4', 'B', '4', '5', 'A', 'F',
    'D', '6', '3', 'B', '3', '4', '1', '9', '7', '2', '4', '8', '6', '1', 'F', '9',
    '2', 'C', 'A', 'A', 'B', 'B', 'B', 'C', '9', '1', '3', 'A', '8', 'D', 'D', '8',
    '1', 'B', '8', '0', '9', '9', 'C', '9', '9', '1', 'C', '2', 'E', '6', '1', '4',
    '3', '1', 'E', 'F', '5', '0', '2', '6', '3', '2', 'C', '1', '7', 'E', '0', '8',
    '5', '3', '7', '0', '9', '0', 'D', '8', '5', 'E', '7', '7', 'C', '9', '0', 'B',
    '4', '5', '3', '2', '4', '1', '0', 'A', 'E', 'A', '5', 'A', '8', '5', 'B', '2',
    '4', 'C', 'F', '0', 'D', '9', 'A', '3', 'F', '6', '9', '0', 'A', '5', '9', 'A',
    'A', 'E', 'C', 'E', '3', 'A', '0', 'B', 'C', 'B', 'D', '1', 'B', '5', '9', 'D',
    'E', 'A', '7', 'D', '4', 'B', '2', '1', 'E', 'C', '0', '2', '5', 'D', '5', '4',
    '4', 'F', '1', 'C', 'C', 'F', '6', 'E', '3', '2', '3', 'B', '2', '9', '8', '0',
    'C', 'C', '9', '9', '9', '2', 'F', 'E', '4', 'C', '3', '0', 'B', '2', '7', '8',
    '6', '3', 'D', 'E', '3', '8', '7', '2', '0', 'B', '7', 'C', '0', '3', '6', 'D',
    '7', '4', '5', 'F', '4', 'B', 'D', '5', 'B', '1', 'D', '6', '9', '3', '4', 'D',
    '6', '7', '3', '9', '4', 'C', '4', 'F', 'C', '0', '9', '5', 'A', '2', 'D', '3',
    '8', '3', '0', '1', '9', '5', 'E', '6', '0', '1', 'F', 'A', '7', 'E', '0', '7',
    '4', '3', '2', '9', '2', 'E', 'B', '1', '6', '3', 'C', '4', 'E', '2', 'E', 'A',
    '2', 'B', '0', 'A', '2', 'E', 'F', '0', '2', 'F', 'F', '1', '5', 'B', 'C', 'B',
    '9', '9', '9', '4', 'E', 'F', 'D', '7', 'E', '1', '5', '8', '9', 'F', 'A', '2',
    'F', '2', '1', '9', '5', '8', '2', 'C', '7', '2', '2', '3', '8', '1', 'C', 'D',
    'E', 'E', 'A', 'D', '2', '6', '0', '7', '2', '1', 'C', 'E', '4', 'C', '2', 'C',
    '8', 'E', 'B', 'B', 'F', '4', '3', 'A', '9', '1', '5', 'E', 'B', '6', '0', '1',
    '6', 'E', '3', '9', '8', 'A', '4', '2', 'C', '3', 'E', '5', '6', '2', '6', 'C',
    '4', 'A', '7', '0', '2', 'D', '5', '7', 'E', '7', 'B', 'A', 'B', 'F', 'F', 'C',
    '4', '6', '7', 'F', 'A', 'E', '9', 'B', '7', 'F', '5', '6', '9', 'A', '9', 'F',
    '2', 'B', 'A', '7', '9', '5', 'A', '0', 'D', '8', '0', '4', '1', 'C', 'D', '1',
    '7', 'F', '5', '2', 'C', 'E', '6', '3', '5', '3', '0', '7', 'A', '8', '7', '0',
    '5', 'C', '8', '5', '2', 'D', 'B', 'F', 'D', 'A', 'B', '1', 'D', '6', '6', '2',
    '5', 'E', 'B', '6', '8', '9', '3', '3', '3', 'F', 'D', '6', '1', 'A', '3', '0',
    '4', '9', 'C', '5', '7', 'A', '3', '5', '1', '5', '9', '6', 'F', 'D', '2', 'B',
    'B', '1', 'A', '3', '9', 'C', 'E', '5', '8', 'C', 'C', '6', 'A', 'A', 'D', '0',
    'E', 'B', '1', '0', 'E', 'D', '7', '3', '2', '3', '5', '9', 'C', 'E', '2', '0',
    '4', '7', '7', '5', '4', '6', '5', 'E', '6', '5', 'C', '5', 'E', '4', 'C', '4',
    '1', '6', '2', 'B', 'C', 'E', 'C', 'D', 'B', '9', '8', 'C', '5', '1', '0', '4',
    '0', '4', '9', '5', '9', '5', 'B', 'E', '1', 'F', 'A', '8', '1', '7', 'F', '1',
    '0', '4', 'D', '7', '4', '2', '5', '6', '0', '1', '1', '4', 'E', '5', '4', '8',
    '4', '4', 'A', 'F', '9', '4', '6', '5', 'F', 'B', '6', 'B', '9', '7', 'D', 'D',
    '7', '9', 'E', '2', '0', '0', '5', 'D', '1', '7', 'F', 'B', '7', '1', 'A', 'E',
    'B', '5', 'B', '2', '8', '9', '1', '6', '3', '4', '6', 'D', '5', 'F', 'F', '4',
    '5', '7', '4', '8', 'E', '6', 'A', '7', 'C', 'B', '3', '0', '0', '5', 'E', '2',
    '3', '3', '8', 'B', 'C', 'D', '6', '8', '4', 'D', 'A', '4', '1', '2', 'F', 'F',
    '3', 'C', 'A', '2', 'A', '8', '8', '8', '0', '3', 'E', 'D', '8', '5', '9', 'F',
    '8', '0', 'C', 'B', 'A', 'C', 'E', 'F', 'C', '3', '6', '5', 'A', '4', 'E', 'B',
    '8', '4', 'C', 'C', 'A', '0', '6', 'C', 'B', 'C', '4', 'B', '8', 'E', 'D', '4',
    '7', '1', '7', '0', 'A', 'D', '6', 'E', '0', '1', '9', '9', '3', 'E', '4', '7',
    '9', '8', 'B', 'C', '1', '1', '6', '3', 'C', '2', '2', '4', 'A', '8', '1', 'A',
    '6', 'A', 'F', '2', '8', '3', 'C', 'E', '5', '1', '8', '3', '8', 'D', '7', '3',
    '6', '0', 'A', '0', 'A', 'F', '3', '8', 'B', '1', '5', '0', '9', '1', '0', '8',
    '0', '2', '8', '7', '4', 'F', 'E', 'F', '3', '7', '2', '0', '4', 'C', '2', '2',
    '5', '1', '1', '7', '3', '2', '6', '6', '2', 'E', '9', '3', 'E', '7', 'B', '0',
    '3', '0', 'A', 'B', 'D', '9', '5', '1', '9', '1', '5', '1', '8', 'D', '7', '9',
    'F', '4', '9', '3', '1', '9', 'E', '4', 'E', '9', 'A', '2', 'C', 'E', 'F', '7',
    '2', '1', '7', '7', '4', '5', 'E', '9', 'D', '3', '5', 'F', '3', '1', '5', '4',
    '1', '3', 'A', 'C', '1', '6', '3', '3', '0', '7', 'A', 'E', '1', 'F', '7', '5',
    '8', '1', '6', 'A', 'B', 'B', 'E', '0', 'A', '5', 'A', 'C', 'C', '1', 'E', '7',
    '2', 'D', '6', 'E', 'B', 'D', 'E', 'F', '5', '8', '5', '4', 'F', '7', 'D', '6',
    '4', 'F', 'B', '2', '1', '0', 'E', '7', '0', '0', 'D', '2', '2', 'A', 'B', 'B',
    'E', '0', 'A', '9', '3', 'D', '5', 'F', '6', '1', 'E', '0', '5', '8', '7', '6',
    'A', '4', '3', '8', 'C', '8', '6', 'D', '2', 'A', '7', 'C', '6', '2', 'F', '4',
    '1', '7', '8', '1', '7', 'F', '7', '1', '7', '4', 'D', '0', '8', '9', 'D', '3',
    'B', '9', '4', '9', 'C', 'C', '0', 'C', 'B', '4', 'C', 'F', '4', '3', '9', 'F',
    '3', 'D', '7', 'F', '9', '8', 'B', 'D', '1', 'C', 'A', '0', 'A', '6', '6', '1',
    'F', 'E', '0', '9', 'B', '6', 'B', 'C', 'F', 'C', 'D', '2', '5', '3', '5', 'C',
    '8', '5', 'E', '6', '0', 'B', '4', '9', '9', 'D', 'A', 'A', '3', '4', '3', '9',
    '7', 'C', '6', '3', 'C', 'C', 'E', 'B', 'D', 'C', '1', '1', '8', '3', 'B', '9',
    '5', 'D', '8', 'F', '2', '3', '7', 'E', '0', '6', 'D', '7', 'C', '9', '3', 'A',
    'C', 'B', 'B', '3', '0', 'D', 'B', 'C', '5', 'D', 'F', 'A', 'E', 'A', 'C', 'B',
    '0', '7', '4', '2', '4', '0', '2', '5', 'F', '4', '4', 'C', '8', '0', '9', '8',
    '6', '9', 'A', '1', '2', '2', '5', 'E', '7', 'B', '8', '5', '9', 'F', 'D', '3',
    '0', '9', '2', 'F', '8', '3', '6', '5', 'F', '6', 'F', 'B', 'E', 'F', '4', '7',
    'F', '4', 'E', '8', '2', '5', 'C', '2', '2', 'D', '5', 'D', 'E', 'A', '2', 'B',
    '6', 'A', '6', 'C', 'D', 'E', '4', '9', 'B', 'D', '5', 'F', '9', 'F', '4', '5',
    '5', '6', 'D', '8', '4', '7', 'C', '1', 'A', '6', '5', '1', '0', '3', '3', '6',
    'D', 'C', 'A', 'D', '0', 'C', 'C', 'F', 'E', '6', '6', 'E', 'C', '1', '4', '2',
    '7', 'A', '0', '0', 'B', 'D', '5', '6', '6', '6', '4', '9', 'A', '3', '7', 'B',
    'D', 'C', '5', 'E', '6', '2', '6', '9', 'C', 'E', '2', '8', '8', '9', '6', 'F',
    '9', 'A', '4', '3', '6', 'D', 'C', '8', 'B', '3', 'C', '2', 'F', '3', '4', 'C',
    '7', '6', '6', '1', '7', 'E', '9', 'B', 'B', 'C', '2', '1', 'E', 'D', 'F', '3',
    'B', '9', 'F', 'D', '1', '5', '3', '5', '7', '5', 'D', 'B', 'C', '0', '0', '4',
    '4', '8', '5', '9', '1', '4', 'D', 'A', 'A', '2', '1', 'B', 'E', '8', '2', 'D',
    '1', '1', 'E', '7', '3', 'A', '8', '5', 'D', '5', 'D', 'C', '4', 'A', 'B', '2',
    '5', '9', 'A', 'B', '3', 'D', '2', 'A', '5', 'C', '3', 'F', 'E', 'F', 'F', '4',
    'A', 'F', '2', '2', '9', 'D', '2', '6', '0', '4', '1', '9', 'F', '3', '1', 'A',
    'B', '4', 'C', '1', '5', '0', '5', '7', '9', '2', '8', '2', 'D', 'B', '3', '9',
    'F', 'F', '2', '8', '1', '5', '7', 'F', 'D', 'B', '5', 'D', '4', '5', '4', '7',
    '6', 'E', '5', '1', '5', 'E', '8', '6', '7', '6', 'A', '4', '9', 'C', '5', '1',
    'D', 'F', 'A', '9', '3', 'A', 'F', 'B', 'F', 'C', '5', '0', '1', '6', 'A', 'D',
    'F', 'C', '3', '4', 'C', 'F', '9', 'B', '2', '2', '4', '9', '9', 'C', '3', '5',
    '5', '6', '5', 'F', 'E', '3', 'B', '9', '8', '2', '4', '6', 'B', '6', 'D', '3',
    '0', '1', '0', 'F', 'C', '9', '6', '0', 'D', '1', '6', '4', '2', '9', 'F', 'D',
    '2', '6', 'B', '7', 'F', '9', 'E', 'C', '3', 'C', 'C', '5', '4', 'C', '7', '7',
    'E', '9', '2', 'D', '2', 'E', 'F', 'D', '7', 'C', 'F', '5', 'F', 'B', 'B', 'D',
    '9', 'F', 'E', '2', '3', '9', '7', '7', 'E', 'F', '9', 'C', '8', '9', '9', '7',
    'B', '9', '0', '1', '9', 'D', 'C', 'B', '5', '5', '9', 'B', '4', '1', '3', 'D',
    '3', '5', 'B', '4', 'D', '4', '2', '1', '9', 'E', 'D', 'F', '5', '1', '3', '9',
    '5', '2', '3', '9', '5', '7', 'D', 'D', 'F', 'B', 'D', '9', 'C', '7', 'E', '1',
    'F', '2', '0', 'D', 'B', '6', '4', '5', 'D', 'C', '8', '6', 'F', '0', 'D', '4',
    'B', '4', '8', '7', 'E', 'E', 'D', 'E', 'C', '9', 'E', '3', '3', 'E', 'D', '8',
    'F', '8', '2', 'A', '1', '9', '2', '5', '5', '9', '0', '5', 'A', 'B', '5', 'A',
    'B', 'E', 'D', '0', '4', 'C', '6', '5', 'A', '5', '6', '0', '2', '1', '3', '9',
    'E', '1', 'E', '3', '5', '6', '1', 'C', 'F', '6', 'D', '7', 'C', '1', '5', '2',
    '4', '3', '3', '2', 'C', '4', 'D', '6', 'E', '7', '8', '5', 'B', 'B', 'C', '7',
    '4', '0', 'D', '0', 'E', 'C', '5', '7', 'C', 'F', 'F', '2', 'F', '6', 'F', '7',
    'F', '3', 'C', 'A', '1', '3', 'F', 'E', 'F', '2', '3', 'D', 'E', '6', 'A', '0',
    'E', 'A', '5', '7', '0', '0', 'F', '5', 'A', '2', '5', '1', '8', '6', '3', 'A',
    '4', 'D', '5', '6', '9', '3', 'D', 'A', 'F', '9', 'B', '7', '1', 'D', 'B', '7',
    '8', 'C', '3', '5', '8', '0', 'F', '7', '6', 'A', 'E', '6', 'A', '8', '4', '9',
    '2', '4', 'B', 'F', '0', 'C', '1', '6', 'C', 'B', '7', '6', '2', '8', '5', '8',
    'C', '1', '0', 'A', '1', '6', 'E', 'D', '3', '1', '5', '2', '9', '2', 'D', '0',
    'F', '4', '0', '4', 'D', '8', 'B', '8', 'B', 'F', 'E', 'B', 'A', '0', '3', '4',
    'F', 'D', '3', 'F', '9', 'C', 'F', '4', 'C', '8', '6', '5', '4', '4', 'B', 'F',
    '9', '2', 'B', '4', 'E', 'A', 'F', '8', '9', '4', 'B', '8', '0', '0', 'D', '9',
    '5', 'F', '7', '6', '0', 'B', '7', 'C', 'B', '1', 'B', '0', '2', '4', '9', '3',
    '2', '9', '1', 'E', 'A', '2', '1', '5', 'E', '1', '2', '7', 'A', 'F', 'A', 'A',
    'A', '7', 'C', '8', 'B', 'E', 'E', 'B', '6', '4', '9', '5', 'E', '9', 'A', '6',
    '8', '1', '9', 'F', '4', 'F', '8', 'E', '7', 'E', '9', '4', 'A', 'F', '7', 'D',
    '2', '9', '1', '7', 'B', 'F', '6', 'D', '1', '8', 'C', '0', '0', '0', '3', 'A',
    'E', 'D', 'A', 'C', 'C', '1', '8', '7', 'B', '3', '4', 'B', 'A', '7', '9', '6',
    '0', '7', 'E', 'B', 'D', '6', '4', '2', '0', '2', 'D', '8', 'E', 'F', '6', '6',
    '2', '6', '2', '8', 'B', 'A', '2', 'E', '8', 'A', 'B', '4', 'C', '6', '1', 'A',
    'B', '1', 'A', '5', 'B', '7', 'C', '5', '5', 'B', '5', 'B', 'D', '7', '3', 'A',
    'F', 'E', '3', '5', 'A', 'F', 'D', '1', '4', '6', '4', '8', 'B', '2', 'A', '0',
    '0', 'D', '0', 'F', 'E', 'F', 'F', 'A', 'D', '5', '9', '3', 'F', '5', 'B', '9',
    'E', 'C', 'D', '7', '3', '6', '1', 'D', '8', '2', '3', 'D', '4', '1', 'C', 'E',
    '3', 'F', '7', '9', '8', '2', '4', '3', 'C', '1', 'F', '8', '8', '6', '8', 'C',
    '1', 'D', '3', '3', '3', '9', 'B', '3', '6', 'E', '3', 'E', 'E', 'F', '3', '0',
    '2', 'F', '9', '1', '5', 'C', '8', '6', '8', 'E', '9', '1', '1', '2', '7', '7',
    '0', 'D', '6', '5', '0', 'C', 'B', 'B', 'D', 'B', 'F', '5', '2', '3', 'A', '2',
    'D', '4', '5', '5', '0', '2', '8', 'B', '7', 'E', '9', 'D', '6', 'D', '4', 'F',
    '6', 'D', 'E', 'D', '6', 'A', 'A', '7', '5', '1', '5', 'A', '8', '7', '5', 'D',
    '5', '5', 'E', 'D', 'D', '3', '5', '8', 'D', 'F', '1', '0', 'C', 'F', '3', '8',
    'F', 'B', '5', 'F', 'C', '0', 'D', '3', '1', '2', 'B', 'F', '4', '3', 'B', '2',
    '1', '5', '8', '8', 'B', '6', 'B', 'F', '6', '5', '6', '5', '7', '0', 'F', '0',
    '8', '0', 'F', '9', 'A', 'A', '3', 'F', 'D', '7', '0', '9', '4', '9', 'A', '4',
    'A', 'A', 'D', '9', 'E', 'F', '9', 'F', '8', '3', '4', '6', '8', 'C', '2', '9',
    'C', 'B', '3', '0', '8', '8', 'E', 'E', 'E', '6', 'A', '5', 'F', '6', '5', '0',
    '5', '8', '6', '7', 'E', 'B', '8', 'E', 'A', '5', '3', '9', '5', 'D', 'E', '8',
    'F', '5', '7', '4', 'C', '9', '7', '9', 'A', '0', '6', '1', 'C', 'E', 'C', 'F',
    '4', '6', 'D', 'F', '9', '9', 'B', '1', 'D', '1', '2', 'F', '5', 'A', '9', 'C',
    '8', '0', '5', '7', 'E', '6', 'C', '1', '2', 'D', '1', '1', '7', 'D', 'F', '1',
    '2', 'E', 'B', 'D', '4', '7', 'A', '1', '4', '7', '4', '8', '8', '7', 'C', '9',
    '0', '5', '3', '9', 'D', '3', 'E', '5', 'F', 'E', 'F', '9', '3', '3', 'B', 'F',
    '2', 'B', '2', '3', '0', '7', 'B', '2', 'B', '1', '6', '4', 'A', '1', '6', '8',
    'E', '4', 'F', '2', 'A', '6', '5', '6', '1', '6', '5', 'B', '2', 'E', '1', 'E',
    '1', 'E', '2', 'B', '4', 'E', 'A', 'B', 'A', 'B', 'E', '7', '8', 'C', '4', '8',
    'E', 'F', '3', '9', 'A', '7', 'B', '6', '4', '2', 'C', '7', '4', '3', '1', '7',
    'A', '9', '6', 'C', '2', 'C', '7', '0', '5', '5', '8', '2', 'A', '6', 'A', 'A',
    '3', 'F', 'A', '0', '4', '2', 'E', 'B', '5', '9', '3', '4', 'A', '8', '3', 'E',
    '0', '8', '8', 'C', '6', '1', '8', '3', '6', 'D', '9', '2', '5', 'F', 'A', '8',
    '7', '6', '3', 'B', 'B', 'B', '2', 'F', 'C', 'A', 'A', 'A', 'D', 'A', 'E', '5',
    '1', '6', '6', 'B', '3', '6', '5', 'B', '3', '3', '5', '3', '1', '1', '0', '5',
    '6', '4', 'D', '6', '4', '4', 'E', 'E', '8', 'C', 'F', '7', '0', '3', 'C', '2',
    'E', 'B', 'B', '1', 'B', '3', 'B', '8', '3', 'A', '8', 'D', '1', '3', '3', '8',
    'B', 'C', '3', '9', '7', 'B', '6', '0', '4', '3', 'C', 'E', '8', '6', '1', '1',
    'D', '2', 'D', '1', '1', 'F', 'C', 'D', '5', '2', '4', '2', 'D', '8', '6', '9',
    '5', '2', 'E', '6', 'E', '2', 'D', 'D', '8', 'F', '8', 'A', 'B', '5', '2', '7',
    '0', 'C', '3', '9', 'A', '2', 'C', '9', '7', '3', 'D', '7', '9', 'D', '6', 'D',
    '6', '5', '4', 'D', '5', '9', '4', '7', '0', 'F', '8', '6', '4', '0', 'D', '4',
    '3', '8', '8', 'E', 'E', '0', '4', 'F', '6', '9', '6', '1', '8', '8', 'B', '0',
    'B', '6', 'E', 'F', '8', 'F', '1', '5', 'E', 'C', 'B', 'F', '5', 'B', '1', '2',
    'D', '7', 'E', '3', '7', 'D', '0', 'E', '8', '3', '7', '1', '1', '6', '5', '4',
    '7', 'E', 'A', '2', 'D', '8', 'D', '4', '4', 'F', 'E', 'B', 'F', '0', '8', 'D',
    'B', '9', '3', '4', '6', '1', '6', 'E', '0', '6', '2', '3', '5', '2', '1', '1',
    '5', '1', '0', '2', 'D', '5', 'B', 'E', '4', '1', 'D', 'C', 'A', 'E', '2', '1',
    'C', 'F', '6', '0', 'D', '0', '7', '9', '8', 'F', 'A', '3', '2', '4', '1', '3',
    'E', '1', 'D', '9', '0', '1', '9', '0', 'E', 'B', 'A', '6', '4', '1', 'A', '2',
    'B', 'A', '5', '3', '7', '5', '6', '9', '8', '7', 'D', '8', 'A', 'A', '5', '3',
    '6', '0', '2', 'F', '2', '5', '9', '4', 'F', '8', '3', '5', '1', '6', 'A', 'D',
    '4', '0', 'F', '5', '7', 'C', 'F', '1', '5', 'C', '6', '0', '5', '1', 'B', 'D',
    '7', '2', 'B', 'A', '0', '8', '6', '1', 'C', '4', '9', '0', 'A', '5', '2', '2',
    '6', '9', 'E', '5', '5', '2', '2', 'F', 'D', '8', '2', '5', 'F', 'F', '0', 'F',
    '2', '5', '9', '0', '9', '7', 'F', '1', 'B', '5', '0', '2', '3', 'D', 'F', 'F',
    '8', 'A', 'C', '0', '3', 'F', '8', '0', '0', '1', 'C', '2', '1', 'B', '5', '0',
    '3', '8', 'E', '0', '0', 'E', '3', '8', 'B', '9', 'C', 'F', 'B', '2', '5', '3',
    'E', 'F', '3', 'B', 'D', '9', '1', '6', 'E', '6', 'A', '5', '8', '5', 'A', '9',
    '3', '7', '0', 'D', '3', '1', 'F', '7', 'B', '3', '6', '3', '7', '9', '4', '9',
    '4', '9', '0', '9', '2', '9', 'A', 'D', 'C', '1', '3', '3', 'C', '0', '0', '4',
    'E', '9', '5', '3', '2', '0', 'D', '9', 'D', '1', '3', 'F', 'E', 'A', '8', '4',
    '6', 'A', 'B', '5', '3', '0', '0', '9', '5', '0', 'D', '0', '2', 'C', 'E', '9',
    '6', 'B', 'A', '3', '5', 'D', '0', 'D', 'B', '9', '1', 'D', 'D', '2', 'B', '6',
    '8', '0', '2', '2', '5', '7', '4', '2', 'E', '6', '1', '3', 'A', '3', '4', '6',
    'A', 'A', '3', 'C', '0', '6', '8', '0', '1', '8', '4', 'B', 'C', 'C', '9', 'B',
    '2', '6', 'D', 'A', '6', '7', 'F', '6', '4', 'D', 'B', 'F', '0', '0', '8', '6',
    '9', 'E', '5', '1', '5', 'C', '0', '5', 'A', '0', '5', '8', 'D', '4', '3', '5',
    'D', 'F', '6', '9', '1', 'C', 'A', '0', '0', '1', '7', 'F', '8', '9', '1', 'D',
    'A', 'E', '4', '7', '6', 'B', '5', 'C', '9', '5', '4', '1', '3', 'E', 'E', '9',
    'B', '0', 'F', '8', '7', 'C', '1', '8', '1', 'F', 'D', 'F', 'E', '2', '5', 'D',
    '4', '0', '9', '3', 'C', 'B', '9', 'E', '1', '5', '4', '7', 'C', '5', '1', '4',
    '9', 'B', '4', '0', '8', '7', '4', '5', '1', 'E', 'F', 'F', 'F', 'B', '4', '4',
    '8', '7', 'D', '9', '4', '4', '1', '7', '1', '4', '1', 'C', 'F', '1', '8', '6',
    'B', 'F', 'D', 'E', '4', 'E', '2', '2', 'E', '9', 'F', '2', '3', '0', '6', 'E',
    '6', 'A', '0', '8', '8', 'D', 'E', '3', '6', '0', 'B', '1', 'C', '4', '8', '3',
    '0', 'A', '0', '1', 'A', 'B', '8', '9', '0', 'D', 'A', '4', '3', 'B', '8', '0',
    'D', 'E', '7', '3', 'B', 'E', 'B', 'C', '6', '7', 'E', '1', '8', '4', '8', '6',
    '4', '0', '5', 'B', '7', 'C', '7', '5', '8', '0', '2', 'F', '9', 'D', 'B', '2',
    '4', 'E', '3', 'C', '3', 'F', '0', '8', '1', 'A', '9', '7', '4', '0', '4', 'F',
    'E', '9', '3', '2', '3', '8', 'B', '1', '4', '5', 'E', '8', 'E', 'E', '5', '2',
    '7', '2', '0', 'D', 'E', '9', '6', '1', 'D', 'A', '7', 'A', 'A', 'D', '4', 'A',
    '7', '6', '7', '4', '6', '6', '3', 'F', '4', '4', '6', '1', '0', 'D', '6', '1',
    'F', '2', 'F', '9', '0', '1', 'B', '1', '2', 'A', '4', '3', '7', '0', '3', '4',
    'E', '3', '2', 'D', '7', '1', 'B', '9', '1', '7', '3', '4', '1', '0', 'E', '3',
    '0', '1', '8', 'B', '6', '4', 'F', '9', 'C', '5', '8', '1', 'E', '2', '8', 'F',
    'D', '5', 'C', '7', 'D', 'C', '5', 'B', 'A', '9', '2', '7', '4', '9', '7', 'B',
    '3', '8', 'E', 'B', 'F', '8', '2', '9', '4', '9', '2', 'B', 'E', '7', '6', 'D',
    '9', 'C', '8', '9', '9', 'E', '5', '9', '8', '7', 'C', 'C', '1', '5', 'A', '4',
    '5', '3', 'D', 'A', 'A', 'A', '6', 'F', 'B', 'D', '9', '4', '4', 'E', 'D', '1',
    '9', 'F', 'A', '9', '2', 'E', '9', '9', '4', '2', '1', '1', 'F', '8', '1', '7',
    '9', '8', '5', 'D', '2', 'B', '5', '8', 'F', '5', '1', '8', '3', '9', '2', '9',
    '3', '6', 'C', '2', '6', '7', '6', 'F', '2', '0', '6', '6', 'A', '0', '4', '6',
    '8', 'A', '7', 'F', 'C', 'E', 'D', 'A', '1', '8', '7', 'C', '7', '8', '4', '1',
    '4', '6', 'A', '0', '8', '7', '7', '7', 'F', '0', 'C', '1', '1', '3', '9', '0',
    '3', '0', '9', 'D', '1', '8', '9', '7', 'C', '0', '5', '4', '2', 'B', '7', '1',
    '7', '8', '8', '7', '6', '7', 'A', '1', '6', '4', '0', '2', '2', '8', '1', '3',
    '4', 'F', '2', '4', 'B', '7', '3', 'F', '8', '7', 'C', 'D', '7', '6', '8', '8',
    '8', '9', 'F', '2', 'E', '0', '4', 'E', 'F', 'D', '4', 'F', 'B', '2', '9', '4',
    '7', '8', '8', 'E', 'D', '3', '6', 'C', '3', '7', 'C', '4', '6', '2', '7', 'C',
    'C', '2', 'E', 'E', 'C', '0', 'F', 'A', '6', 'B', 'E', '8', '0', '8', '4', 'D',
    '1', 'A', '4', 'A', '6', '4', '8', 'B', 'E', 'C', '7', '1', '7', '3', '8', '5',
    '7', 'C', '0', '9', '0', 'C', 'A', 'A', 'C', '4', '4', 'D', '5', '8', '1', '4',
    '3', 'C', 'B', 'D', '2', '2', 'E', '0', '1', '8', 'A', '8', '8', '7', '0', '5',
    'F', 'E', 'D', 'F', '0', '7', '8', '5', '7', '1', '6', 'C', '5', 'E', '6', '6',
    'B', '1', 'A', '0', 'D', 'A', '6', '7', 'D', '1', '7', '5', '1', '4', '2', 'D',
    'C', '7', '1', 'A', 'B', '0', '3', '4', 'B', 'A', '0', '0', 'A', '6', '6', 'A',
    'A', 'A', '1', '2', '4', '3', '7', 'B', '1', '6', 'B', 'A', '2', 'C', '1', 'B',
    'D', '6', 'C', '2', '8', 'A', 'E', '8', '2', '6', '4', 'C', '6', 'D', '2', '5',
    '9', '9', 'C', 'D', '7', '4', '3', '4', 'E', 'D', '7', '0', '7', '6', '1', 'C',
    'F', '9', 'C', '8', '8', '4', 'A', 'A', '7', 'B', 'B', '2', '8', 'B', 'D', '3',
    '7', 'E', 'E', '7', 'F', 'E', 'E', 'B', '0', 'F', 'B', '4', '8', '0', 'A', '8',
    'F', '9', '6', '7', 'C', 'E', '0', 'D', '2', '3', '0', '3', 'A', '2', '9', '9',
    '0', 'A', 'B', 'C', '1', 'C', '5', 'E', '7', '7', 'F', '3', 'E', '2', 'E', 'C',
    '1', 'C', 'D', 'A', '6', '7', '3', 'D', 'A', '4', '3', '9', '8', '3', '0', '0',
    '1', '2', '7', '4', 'E', '8', '1', 'E', '4', '6', 'C', '7', 'A', '1', '7', '0',
    'D', '6', '6', 'C', '8', 'D', '5', '3', '6', '6', 'E', 'E', '5', '0', '8', '7',
    '3', 'A', 'F', '1', '4', 'A', '3', '0', '4', 'E', 'A', '0', '2', 'C', '5', 'F',
    'A', '6', 'B', '0', 'C', 'C', 'F', 'B', '0', '8', '2', 'F', '8', '8', '2', 'E',
    'E', 'A', '5', '8', '5', '7', 'F', '7', 'D', 'B', '9', '7', '9', '1', 'B', '0',
    '1', 'D', '3', '0', 'D', '4', '9', 'D', '2', '2', '9', '3', '5', 'B', '7', '6',
    '9', '8', '3', 'E', '7', '3', '1', 'B', '1', '9', 'A', '0', 'E', '9', '9', 'F',
    'E', '9', '3', '6', '4', '9', 'D', '6', '8', 'E', 'F', 'C', 'D', 'F', '6', 'D',
    '0', '0', '9', '3', '9', '4', '0', 'B', '7', 'D', '1', '1', '7', '8', 'A', 'D',
    'C', 'A', '4', 'C', '5', '3', 'F', 'F', '0', 'E', '2', 'C', '7', '2', '5', 'A',
    '1', '0', '5', '1', 'E', '6', '2', '2', '9', 'E', 'B', 'E', '6', '7', '0', '6',
    '4', '5', '6', '5', 'B', '6', '4', '3', '7', 'F', 'C', 'D', '5', 'D', 'F', 'E',
    'A', '5', '6', 'B', 'C', '5', '7', 'B', '7', 'C', 'A', '8', '0', 'C', '2', 'E',
    'A', '0', '8', '5', '0', '0', '9', '5', 'E', 'C', '9', '9', '8', '3', 'C', '4',
    'F', 'B', '2', 'A', 'F', 'A', '3', 'F', 'A', 'E', '3', 'C', 'B', 'B', '0', '8',
    '5', 'B', 'E', 'F', '9', '2', '0', '3', '8', 'B', '2', '9', '0', '5', 'D', '2',
    '8', '8', '3', 'A', 'F', '9', '8', 'E', '0', '8', '0', 'D', '2', 'E', '8', 'D',
    '2', 'D', '7', '8', '0', '3', 'C', '5', '0', '0', 'C', '4', '0', 'C', '8', 'E',
    'C', '5', '6', 'D', 'A', 'A', 'F', 'C', '3', 'D', '4', '3', 'D', '1', 'C', '7',
    '8', '5', '5', 'E', '3', '1', 'F', '5', 'F', 'F', '5', '3', '0', 'F', 'A', '9',
    '0', 'A', '4', '6', '6', '0', '0', 'B', 'F', '1', 'F', '8', '0', 'E', '1', '1',
    '7', '6', '3', '8', '6', 'C', '7', '6', '3', '3', 'F', '6', 'F', 'C', 'A', 'E',
    '6', '3', '2', '5', '0', 'C', '0', 'B', '0', 'C', '7', 'B', 'B', '1', '7', 'B',
    'D', 'F', '3', 'D', '4', 'A', '7', '6', 'D', '7', '6', 'E', '8', 'C', '2', 'E',
    '2', '4', '6', 'B', 'A', '1', '6', '3', '1', 'F', 'E', '1', 'D', '8', '2', 'D',
    'F', 'F', '4', '2', '7', 'C', 'F', 'C', '7', '8', 'A', '7', '5', 'B', '8', '0',
    'D', 'C', 'A', '2', 'C', 'D', 'D', '8', '0', '1', '8', 'D', '8', '3', '7', '0',
    'E', 'C', '3', '4', '7', '2', 'B', '4', 'F', 'B', '0', '8', '0', '9', '4', '5',
    '5', 'C', '0', '0', '3', '5', 'A', 'E', '9', 'A', '4', '4', 'D', '4', '3', 'B',
    '2', '9', 'A', '1', 'F', 'F', '8', '1', '5', '9', '8', 'A', 'A', '6', 'C', '2',
    'A', '9', '8', 'F', '7', 'B', 'E', '0', '8', '2', '5', '0', '9', 'F', '3', '9',
    '4', 'B', '3', '1', 'A', 'F', '1', '3', 'A', 'A', '1', '9', '8', 'D', '9', 'C',
    'A', '0', '6', '7', 'A', '0', '2', '6', '9', '0', '2', 'D', 'B', '3', '5', '6',
    '9', 'F', 'B', 'F', '3', '5', '5', '7', 'A', '7', '6', '6', 'D', 'B', '6', '7',
    '3', '9', '6', '3', '5', '0', '2', 'F', '5', '0', 'C', '7', 'E', '0', '3', '4',
    'C', '4', '4', 'D', 'C', 'A', '7', '3', '5', 'B', 'C', '4', 'F', 'B', 'E', 'C',
    '9', '1', '7', 'B', '5', '5', 'D', '1', 'F', 'F', '5', '1', 'E', 'C', '6', '3',
    '9', '6', '8', 'D', 'C', 'A', 'A', '2', '5', '8', '2', '5', 'F', '1', 'D', 'E',
    'D', '7', '8', '1', '4', 'A', '6', '1', '4', '4', '4', '5', '1', '0', '2', '1',
    '6', 'C', '8', '2', 'A', '5', '7', '7', '4', 'B', 'C', 'D', 'A', '2', '3', '9',
    '5', '0', 'C', 'E', '4', 'F', '9', 'D', 'F', 'B', '9', '6', '1', '0', '3', 'C',
    '5', '4', '8', 'E', '7', 'D', '3', '4', '0', '4', '8', '9', '3', 'A', '8', '4',
    'C', '6', '6', 'D', 'E', 'D', '1', '5', 'E', '5', 'C', '3', 'A', '0', 'D', '3',
    '0', 'D', '3', '8', '0', '6', '4', '4', '2', 'E', '3', 'D', '0', '9', '6', '0',
    '8', '9', '2', '1', '7', '1', 'B', 'A', '0', 'C', '7', '7', '1', '4', '7', '5',
    'D', 'E', 'F', '4', 'D', '4', 'F', 'F', 'D', '0', 'B', '6', '2', '2', '4', '4',
    '7', '1', '2', '3', 'E', 'F', '0', '0', '1', 'C', '7', 'A', 'A', 'B', 'A', '6',
    '5', 'C', '6', '5', '1', '2', '3', '3', '6', '9', '6', 'E', '6', '0', '9', '6',
    'F', '4', 'C', 'F', 'B', '8', '0', '6', '8', '4', '9', 'F', '7', 'E', 'C', '9',
    'A', '6', '4', '9', 'F', 'F', '8', '8', '0', '1', 'F', 'B', 'B', '8', '7', '8',
    '2', '1', 'F', 'A', '3', '1', '1', '3', '2', 'D', '8', '8', '5', 'A', 'C', 'F',
    '2', '4', '0', 'C', '5', 'A', '3', 'A', '4', '6', '1', 'E', '3', '2', '9', 'D',
    '4', 'A', 'E', '8', '4', 'C', 'E', '3', '1', 'E', '8', 'E', '6', 'D', '8', '4',
    'D', 'A', '0', 'C', 'E', '3', 'C', 'E', 'A', 'A', '9', '7', '1', '2', '5', '3',
    'C', '2', '6', '2', '2', '6', '6', 'D', 'A', '9', '5', '3', '1', '9', '2', 'B',
    '3', '9', '8', '1', '2', '4', '8', '2', 'F', '8', '1', '6', '1', 'E', '9', 'B',
    '4', '8', 'F', '1', '4', '1', '8', '3', 'A', 'E', '7', '3', 'F', '0', '8', '5',
    '5', 'D', '6', '9', '0', 'C', 'C', '5', '4', '6', '8', '1', '3', '8', 'F', 'B',
    'E', '5', '7', '3', '3', '2', 'C', '2', 'D', 'B', '3', 'F', '2', '5', '3', 'A',
    '4', '8', 'C', 'B', '9', 'F', '6', '9', 'D', 'D', '2', '0', '4', '7', '0', '5',
    'A', 'A', '8', '4', '6', 'E', 'C', '2', '3', '5', '9', '8', '1', 'B', '4', 'D',
    'B', '6', 'F', '9', 'F', '4', '1', '1', 'D', 'C', '3', 'F', '8', '5', '8', 'F',
    'D', '9', '3', 'B', '3', '8', 'B', '6', '8', '0', '1', '6', 'D', '5', 'E', '7',
    'B', '3', 'C', '2', '3', '7', '5', '8', '6', 'B', 'A', 'B', '2', 'D', 'E', '2',
    '9', '0', '4', 'F', 'A', '4', '8', 'F', '5', 'F', 'B', '9', '3', '5', '7', '3',
    '2', '1', 'C', '3', '8', 'F', '9', 'F', 'B', 'E', 'A', 'E', '9', '3', '0', 'D',
    '5', 'B', 'D', 'F', '7', '5', '6', '1', '6', 'B', 'D', '3', '8', '7', '0', '8',
    '9', '5', '5', '8', 'B', '0', '9', '1', '3', '9', '6', '3', 'C', 'E', 'F', 'D',
    '5', 'D', 'A', '6', '5', '5', 'B', '5', 'B', 'E', 'B', 'E', '7', '5', 'A', '7',
    '7', 'E', '1', 'A', 'F', 'B', '6', 'B', '6', '8', '2', 'B', '3', '7', 'A', 'C',
    'E', 'D', '8', '5', '8', '3', '2', '7', '7', 'B', '1', '5', '9', 'C', '7', '7',
    'D', 'E', '3', '7', 'D', '4', '6', 'A', '6', 'D', 'C', '1', '4', 'D', '5', '1',
    'E', 'F', '8', '5', '8', '0', 'C', 'A', '0', '9', 'A', '2', 'F', '8', '6', '9',
    '4', 'F', '1', 'A', 'C', 'C', 'F', 'D', '5', '3', '0', 'C', '4', '6', 'B', '3',
    'E', '1', 'F', 'C', 'F', '1', '5', '7', '0', '3', 'B', '7', 'C', 'D', 'C', '2',
    '2', '9', 'B', '2', '7', '8', 'D', 'C', '5', '5', '9', 'A', '0', 'F', '1', '6',
    '8', '5', 'F', '7', '6', '4', 'B', 'D', '0', 'E', '8', '6', '3', '3', 'C', '5',
    '1', 'C', 'C', 'C', 'C', '7', '3', '9', '5', '4', '4', 'B', '2', '3', 'A', 'B',
    'B', '4', '6', 'C', 'B', '4', 'D', '7', 'A', '9', '2', 'E', 'B', '1', '8', 'E',
    'C', '9', '6', '4', '5', 'C', 'D', '3', 'F', 'E', 'B', '9', 'E', 'E', '4', '7',
    '9', '5', 'C', '7', '3', '1', '6', '7', '0', 'C', 'D', '6', '2', 'F', '4', '5',
    'B', 'F', 'B', '8', 'C', '2', '5', '5', '0', '2', '6', 'C', '1', '6', '0', '4',
    '0', '4', 'F', '1', 'C', 'D', '9', '2', '5', 'E', '6', 'A', 'B', 'A', 'D', 'B',
    'E', '5', '6', 'F', 'C', '7', '0', '7', '8', '2', '6', '2', 'F', '4', 'A', '1',
    '2', '9', '9', 'A', '6', 'E', 'E', 'D', 'A', '7', '2', '6', 'D', 'B', '7', '0',
    '8', '2', 'B', '5', '5', '3', '3', 'F', '5', '9', 'E', 'C', '7', '7', 'F', '5',
    '4', '8', 'D', '2', '1', 'B', '9', '1', '2', '2', '2', 'A', 'E', 'A', 'A', 'C',
    '7', 'A', 'A', '2', '9', '7', '0', '4', '1', '3', '1', '8', '2', '0', 'D', '6',
    '7', '8', '6', '7', '2', '9', 'B', 'F', '5', '5', '1', '8', 'F', '6', 'F', 'F',
    '2', '1', 'A', '1', 'C', 'C', 'F', 'D', '5', '6', '3', 'B', '0', 'A', '4', '8',
    'F', '1', 'D', '4', 'F', '5', '2', '9', '1', '2', 'B', '8', 'B', '4', '0', '1',
    '5', '5', 'C', 'D', 'B', '2', '2', '3', '2', 'E', '6', '5', '2', '3', 'E', 'C',
    '7', 'D', 'D', '1', 'F', 'A', 'B', '1', 'F', 'D', '1', 'D', 'D', 'D', 'D', 'E',
    '7', '4', '5', '0', 'E', 'A', '5', '8', '8', '2', 'A', '0', '1', 'D', '2', '9',
    '6', '1', 'A', '9', 'B', 'B', '0', '7', 'D', '9', '3', '1', 'F', '7', 'D', '9',
    'B', '8', '2', '4', '6', '4', 'D', '6', '7', 'D', '9', 'A', '4', 'E', '4', 'E',
    'F', '6', '2', 'B', '8', 'D', 'A', 'B', 'B', '1', '5', '5', '4', '6', '9', '1',
    '7', 'C', '0', 'F', 'C', '9', '4', '3', '1', 'B', '3', 'F', 'F', '7', '0', '3',
    '0', '5', '9', 'F', 'E', '4', 'B', 'B', 'B', '5', '2', '1', '1', '2', 'E', '0',
    'D', '3', 'C', '2', 'C', '1', '4', '7', 'F', '0', '8', '5', '9', '2', '9', '5',
    'E', '6', 'A', 'C', 'F', '8', '3', 'E', 'F', 'B', '8', 'D', '0', '1', '1', '3',
    'D', '6', '5', '7', '1', 'E', '7', 'E', 'B', 'B', '1', 'E', 'D', 'F', '4', 'C',
    '0', 'C', '6', '6', '2', '7', '6', 'D', 'F', '7', 'A', '1', '4', '9', 'C', 'C',
    '2', '9', 'C', '3', '0', 'C', 'C', 'C', '4', 'B', 'F', '7', '7', 'B', 'C', '3',
    'C', 'F', '5', 'C', 'F', 'F', '6', '6', 'D', '1', '3', 'E', 'A', 'C', '8', 'A',
    'F', 'D', 'C', 'C', 'D', 'D', '9', 'A', '2', 'D', '5', '7', 'A', '4', 'C', '8',
    '4', 'A', '8', '7', '8', 'A', '3', '3', 'A', 'F', '2', '1', '0', 'A', '4', 'B',
    '8', '7', '8', 'B', 'F', 'C', '3', 'A', '1', '9', 'A', 'F', '3', '0', 'C', '1',
    'E', '9', '7', 'F', '4', 'F', '3', '1', '8', '2', '3', 'D', 'F', '8', '9', '3',
    '2', '0', 'A', '3', 'C', 'E', 'D', 'B', '8', '8', 'A', '5', '0', 'D', '7', '5',
    'B', '5', '8', 'A', '6', '8', 'C', '6', '4', '9', '8', '7', '5', '0', 'E', 'E',
    '6', 'A', '1', '0', 'B', '8', '9', '7', 'B', '3', '3', '6', 'F', '7', '1', '4',
    'E', '7', 'E', '4', 'E', '1', 'D', 'B', '0', '7', '2', '9', '5', 'E', '9', '6',
    'B', '1', '4', '1', 'D', '4', '1', '9', '4', '6', 'B', '0', '3', 'D', 'B', 'B',
    '9', 'B', '2', 'B', '4', 'C', 'B', 'E', 'D', '6', '7', 'D', '1', 'E', 'E', '4',
    '1', '5', '0', '2', 'E', '3', 'C', 'C', '3', 'B', 'A', '6', 'B', 'A', '6', '7',
    '7', '6', '2', 'E', 'E', '2', '9', 'F', '5', '4', 'C', '4', 'E', '8', '8', '8',
    'D', 'C', 'B', 'E', 'F', '6', '2', 'E', '2', '3', '9', '8', 'F', '7', 'B', '1',
    '9', '3', 'D', '3', '6', 'B', '3', '1', 'D', '8', '5', '6', '1', '5', '5', '3',
    '1', '7', 'E', 'D', '7', 'D', 'B', '4', '4', '4', 'D', '4', '2', 'B', 'A', 'A',
    'E', '9', 'A', '7', '0', 'B', '6', '3', '6', 'C', '3', '6', '0', 'A', 'E', '9',
    '1', 'E', '2', 'A', 'C', 'F', '5', 'A', 'A', '0', '1', '0', '2', '4', 'A', 'F',
    'B', 'C', 'F', '2', 'C', 'B', '7', '2', '1', '6', '4', '0', '4', '7', '3', 'B',
    'F', '2', '8', '6', '9', 'F', '8', '3', 'B', '0', 'B', 'A', '2', '7', '8', '0',
    '7', '4', '6', 'A', '8', '4', '3', 'B', 'D', '0', 'E', 'B', '5', 'B', '6', 'B',
    '0', 'A', '9', 'F', 'D', 'F', '5', 'A', '0', 'F', '3', '7', '0', 'A', '2', 'E',
    '5', '8', '9', '9', '2', 'A', '9', '3', '7', 'C', '9', 'E', 'A', 'C', 'F', '2',
    '4', '2', '2', 'D', '7', '8', 'B', '0', 'A', '9', '6', '5', '8', 'C', '6', 'C',
    '7', '8', 'A', '1', '4', 'D', '9', 'B', 'E', '8', 'A', 'B', 'B', '5', 'D', '2',
    'F', 'F', '4', '5', '9', '4', 'A', 'E', '4', '8', '7', '5', '2', '3', '4', '7',
    'C', '9', '7', 'D', '1', 'F', '8', 'B', '6', '7', '1', 'C', '6', '9', '9', '3',
    'F', '3', '9', '5', '5', '0', '6', '0', '7', '0', '6', 'D', '9', 'E', '8', '4',
    '0', 'A', '0', 'D', '3', 'C', '4', 'B', 'F', '7', 'C', '7', 'D', '6', '1', '5',
    'C', '0', '3', '3', '0', '2', '2', 'D', '6', '7', '4', 'E', '9', '4', 'F', '4',
    '8', '1', '7', 'F', '1', '9', '5', '9', 'C', '6', 'F', 'A', '1', '3', 'B', 'E',
    'F', 'F', 'C', '5', 'E', '6', '5', 'D', '2', 'D', '2', '5', '3', '8', '6', '1',
    'D', '7', '6', '5', 'B', '3', '5', '7', '4', '8', '8', 'A', '0', '4', 'D', 'A',
    '9', '4', 'B', 'D', '9', '5', '6', 'B', 'F', '6', '1', '3', '3', '0', 'E', 'B',
    '6', '8', '8', '1', '8', 'F', 'E', 'D', '1', 'D', '5', '7', '6', '7', '0', '9',
    'E', '5', 'F', '9', 'B', '7', 'F', '6', '9', 'A', '8', 'B', '9', '7', 'F', '7',
    '1', '3', '8', '9', '5', '7', 'D', '7', 'A', 'D', '6', 'C', '5', 'C', '7', 'D',
    'C', '2', 'F', '3', 'B', '2', '1', '0', 'B', 'D', '3', 'F', '6', '6', '6', 'B',
    '9', '1', '2', '8', 'C', '9', '1', '2', 'F', 'A', 'B', '1', '2', 'F', 'E', 'D',
    '2', '7', '8', 'B', 'D', 'A', 'D', '0', '4', '4', 'B', 'D', '8', 'F', '1', '1',
    '6', '5', '9', 'F', '3', '5', 'B', 'E', 'B', '8', '4', '6', 'D', 'C', '2', 'B',
    '5', '7', '8', '1', '0', 'B', 'A', '9', 'E', '8', 'E', 'B', 'E', '4', 'F', '4',
    '1', '1', 'B', '4', '6', 'A', 'C', '8', '0', '8', '4', '4', 'A', '4', '4', '0',
    'A', '5', 'F', '2', 'B', 'E', 'A', '8', 'D', '1', '4', 'F', '9', '6', 'F', '0',
    '4', '6', '8', '8', '7', '6', '0', 'E', '2', 'F', '3', '1', 'F', '3', '8', '0',
    'D', '3', 'C', 'B', 'F', 'C', 'A', '0', '1', 'D', 'A', '8', '1', '1', '6', '8',
    'D', 'E', 'B', '2', '9', '1', '4', 'B', 'B', 'C', 'E', '7', '1', '9', '3', '7',
    '5', '0', 'B', 'C', '8', '9', 'A', '6', 'D', 'A', 'B', '7', 'C', 'A', '1', 'E',
    '2', '4', 'C', 'D', '9', '5', '7', 'F', 'D', '0', '6', '7', 'B', '1', '2', '6',
    'C', '2', '4', '1', 'F', '1', '2', '1', '4', '2', '0', '0', '0', '5', '5', '7',
    '9', 'C', '3', 'E', '7', '6', 'D', '1', 'A', '8', 'E', '8', 'E', '9', '7', '0',
    'E', '4', '3', '9', 'E', 'B', '2', '6', 'B', '7', 'E', 'E', '6', '2', 'D', '6',
    '0', 'E', '7', 'E', '9', '9', '4', '8', '5', 'C', '3', '6', 'A', '2', '2', '5',
    'E', '8', 'C', '8', '0', '3', '4', '3', 'C', '7', 'B', '5', '3', 'F', 'F', 'A',
    '5', '8', '2', 'A', 'E', 'C', '2', '2', '3', '6', 'A', 'F', '1', '6', '5', 'F',
    'D', '4', 'D', '2', '4', '4', '5', 'B', '0', '6', '5', '4', '8', '1', '2', '8',
    'F', '3', 'E', 'B', 'E', '6', 'D', 'C', '4', 'F', '3', '1', 'F', '9', '5', '7',
    'C', '1', '4', 'D', 'A', '6', '8', 'F', '2', '6', '0', '4', '6', 'A', '3', 'F',
    '6', 'A', '6', 'C', 'D', '9', 'E', 'F', '6', '6', '7', '3', '8', 'E', 'D', '8',
    '9', '4', 'E', '4', '7', 'C', '1', 'C', 'A', '2', '5', 'F', '4', 'F', '2', '4',
    'E', 'D', 'A', 'B', 'D', 'D', 'A', '7', '0', '2', '0', '3', '8', 'F', 'C', '6',
    '1', '7', '6', 'A', '4', 'A', 'F', '5', 'A', '5', '5', 'D', '7', 'A', '6', 'E',
    '7', 'C', '2', '5', '0', '0', '2', '6', '8', 'C', 'C', 'C', '5', '6', 'E', '9',
    '2', '0', '9', '3', '7', '6', '7', 'C', '8', '0', '2', 'A', 'A', '0', '4', '9',
    'B', '3', '2', 'B', 'D', '1', 'B', 'F', '1', '8', '2', 'F', 'D', 'F', '0', '4',
    'D', 'A', '8', 'E', 'B', '0', '2', '8', 'E', '4', '0', '7', 'B', '2', 'C', 'B',
    '0', '0', '3', '2', '7', '9', '4', '9', '9', 'C', 'A', '8', 'F', 'D', 'B', '5',
    '7', '8', '8', 'A', 'D', '2', '0', 'D', 'D', '0', 'F', '5', '3', '8', 'D', 'D',
    '4', 'B', 'B', '7', 'B', 'B', '4', '7', 'A', 'C', '5', '5', '8', 'B', '4', 'F',
    '9', 'D', 'E', 'B', 'B', 'A', '6', 'A', '5', '9', 'D', '4', 'F', '0', '2', '1',
    'F', '0', 'D', 'C', '1', 'B', '8', '3', '9', '4', '2', '9', '7', '4', '3', '9',
    '5', '0', '3', '3', 'C', 'C', '2', 'A', '7', 'C', '8', 'F', 'F', '3', 'B', 'E',
    'B', '2', 'E', '0', 'D', '1', '0', '4', '4', '8', '8', '0', '3', 'D', '5', '6',
    'B', '7', '9', '7', '0', '7', 'A', '9', 'D', 'D', 'E', '9', '6', 'D', '8', '3',
    '5', '1', '8', 'E', '4', '8', '3', '2', 'F', 'F', '9', '8', 'A', '2', '0', 'F',
    'E', '9', '7', 'B', '6', '8', 'A', 'A', '7', 'C', '9', '8', 'F', 'E', 'D', 'C',
    '8', '2', '7', 'A', 'A', '5', '7', '9', 'F', '7', '7', '7', 'B', '9', '7', '5',
    '5', '3', 'D', '3', '2', 'C', '4', '0', '1', '4', '1', 'B', 'B', '4', '3', '1',
    'A', 'A', '2', 'A', '1', 'E', 'D', '5', '6', '8', '2', '6', '2', 'B', '5', '6',
    'E', '4', '8', '8', '4', '3', '3', '8', '8', 'A', '0', '2', '9', '4', '6', '3',
    '3', '0', '0', '6', '8', 'E', '4', 'B', 'A', '2', '0', 'C', 'A', 'D', '4', '7',
    '1', '1', 'E', 'A', '5', 'B', '8', 'B', '1', 'A', '0', '5', '9', '0', 'C', 'A',
    'F', '1', '6', '4', '8', '8', '7', '9', '6', '6', 'D', 'A', '2', 'B', 'F', 'A',
    'D', 'F', 'B', '9', '6', '3', 'E', '3', 'D', '4', '1', '1', 'E', '0', 'F', 'D',
    'A', '5', 'E', '8', 'F', '0', '6', '0', '8', '9', '8', 'A', '8', 'B', '3', '9',
    '0', '5', '4', '0', '3', '9', 'E', '8', '1', 'C', 'A', '5', 'D', '4', 'C', 'E',
    '9', 'C', '3', 'F', '6', '3', '7', 'D', 'E', '7', 'F', '4', 'E', 'F', 'D', 'C',
    '3', '1', 'A', 'A', '7', '1', '2', 'A', '0', '4', '4', 'A', '3', '8', '0', '0',
    'A', '7', '9', '7', '5', '0', '7', 'D', '5', 'F', '7', 'F', '5', '7', 'D', 'C',
    'C', 'A', '8', '3', '2', '7', '7', 'A', 'F', '2', '6', 'F', 'D', '2', 'B', 'E',
    '3', '7', '6', '6', '3', '1', 'A', 'F', '7', '5', '4', '4', '1', '8', 'F', '3',
    'E', '2', 'C', 'F', 'A', '1', '8', 'D', 'D', 'B', 'D', '0', '6', '2', '8', '1',
    '7', '0', '4', 'F', '5', '4', 'A', 'F', '5', 'B', '0', 'C', '5', '4', '5', '0',
    '2', '6', '5', '2', '4', '2', 'C', '2', '1', 'C', '5', 'D', '1', '8', '6', '7',
    '4', '1', '8', 'F', 'C', 'B', '5', '1', 'D', 'B', '1', 'E', '6', '9', 'E', '3',
    '9', '2', 'C', 'C', '7', 'F', '8', 'E', '6', '1', '2', '4', 'D', '1', '7', '8',
    '0', '9', '0', 'F', 'B', '6', '0', 'C', 'E', '1', 'D', 'E', '6', 'D', '7', '1',
    '4', '4', 'B', 'C', '8', '6', '1', '7', '5', '5', 'A', '7', '0', '9', '0', '3',
    '5', '6', '2', 'C', '2', '2', '8', '8', 'B', '9', '0', '8', '0', 'C', '4', 'F',
    'E', 'C', 'B', '5', '8', '0', '5', 'B', 'C', '1', 'F', 'D', 'A', '8', '2', 'B',
    '0', '5', 'D', 'C', '2', '6', '4', '9', '4', 'E', 'A', '2', 'E', '8', '7', '6',
    '3', '6', '2', '0', '8', '8', 'D', 'D', '2', '2', '5', 'C', '1', '7', 'D', 'A',
    '1', '8', '3', '4', 'F', '7', '6', '5', 'E', '7', '6', '3', '0', '7', '4', 'D',
    '0', 'C', '5', '9', '4', '5', 'C', '9', '9', '1', '5', '3', '3', '9', '2', 'E',
    '2', '9', '6', '7', 'F', 'D', 'C', 'A', 'F', 'D', 'D', '9', 'F', '1', '0', '7',
    '1', 'F', '9', '9', 'C', '8', '2', 'A', 'D', '2', '6', '4', '6', 'F', '4', '4',
    '1', 'C', '0', '8', '4', '5', '5', '0', '8', 'A', '9', 'A', '5', '9', '8', 'F',
    'F', 'D', '6', 'C', '7', '8', '4', '7', '6', '7', '4', '9', '1', '8', 'D', '0',
    '5', '1', 'B', 'C', 'C', '6', '7', '2', '2', 'A', '3', 'B', '3', '2', '8', 'E',
    'F', 'A', 'A', '4', '6', 'B', '1', '9', '2', '7', '2', '3', 'B', '6', 'E', 'C',
    '3', '3', 'A', 'E', 'A', 'E', '4', '8', 'B', 'C', 'D', '3', 'E', '2', '7', 'C',
    'A', '6', '9', '2', '9', 'F', 'D', '6', 'C', '0', '7', '6', '8', '3', 'A', 'F',
    '0', '9', 'C', '2', '1', 'D', '1', '1', '0', '4', 'A', '5', '2', '2', '7', '7',
    '3', '3', '6', 'F', '7', 'B', 'F', '1', '0', '1', '1', '4', '7', 'E', '0', '6',
    'D', 'B', '1', '5', '5', '9', '4', 'F', '5', 'E', '0', '9', '1', '1', '1', '3',
    '5', '9', 'E', '4', '4', '7', '1', '8', '0', '1', '5', '0', 'D', '3', 'D', '2',
    '8', '4', 'B', 'D', 'D', 'D', '8', '7', 'F', 'E', '4', 'B', '2', '4', 'C', '1',
    'B', '5', 'B', '6', '7', '3', '2', '3', '1', '9', 'C', '7', '0', 'F', 'D', '3',
    '7', 'A', 'C', 'D', 'F', 'C', '6', '4', 'C', '8', '2', '2', '9', '0', 'F', '2',
    '7', '1', '3', '9', '4', 'A', '3', '6', '0', '4', '8', 'B', '7', '5', 'C', '8',
    'D', 'C', '8', '3', 'C', 'E', 'D', '0', '0', 'C', '7', '0', '7', '9', '3', 'A',
    '6', '2', '8', 'E', 'E', 'C', '8', '6', '6', '3', '8', 'C', '3', 'B', '8', '3',
    '5', 'F', 'A', 'D', 'A', '1', 'F', '9', 'D', 'C', 'A', 'B', 'D', '9', 'E', '8',
    'D', '3', '5', '4', 'D', '5', '6', '2', '1', '2', 'B', '9', '3', 'C', 'D', '1',
    '8', '4', '2', '8', '4', '7', '9', '6', '0', '0', 'D', '1', '2', '3', '4', 'A',
    '8', '0', 'D', '0', 'D', '4', 'E', 'F', 'B', 'D', '5', 'D', '0', '5', 'D', '1',
    '9', 'A', '5', '7', '6', 'A', '4', 'C', 'A', '6', 'F', '6', '4', 'F', '8', '5',
    '9', 'E', '2', '4', '1', '7', 'A', 'A', 'E', '7', '7', '8', 'D', 'E', '1', 'E',
    'E', 'C', '2', 'E', '6', '6', 'A', '1', '6', '2', '0', '6', 'F', '3', '3', '2',
    '3', 'B', '9', 'A', '0', 'C', 'F', 'A', '8', '5', 'A', '7', 'A', '0', '1', '0',
    '3', 'F', 'C', '2', '7', '2', 'A', 'D', 'D', '7', '1', '5', 'C', 'F', '2', '7',
    'C', '8', 'C', '2', '3', 'A', 'F', 'E', '4', '3', '9', '2', '7', 'B', '5', '8',
    '4', 'E', 'B', 'B', 'E', '9', 'B', '0', 'B', 'B', 'B', 'C', 'E', 'A', '8', '5',
    '4', 'B', '5', '3', 'B', '6', 'F', '2', '4', 'C', '5', 'F', 'D', '8', '5', 'B',
    'F', '1', '3', '7', '5', 'B', 'D', 'E', '6', '4', 'C', 'E', '7', '7', '1', '2',
    'F', '4', '9', 'C', '0', 'C', '4', '1', 'A', '4', 'D', 'C', 'A', 'A', 'C', 'F',
    'F', '8', 'D', '5', '5', 'C', '7', '1', '6', '4', 'F', '8', 'B', 'A', 'D', 'A',
    'C', '5', 'F', 'D', 'F', '5', '5', '7', 'F', '7', '6', 'C', 'A', '9', '0', '7',
    '7', '8', 'C', '8', '1', 'E', '8', '1', 'D', '2', '3', '7', '7', 'D', '8', 'B',
    'B', '8', 'C', '3', 'C', 'A', '1', '3', 'D', '8', '6', 'F', '3', '0', 'A', '2',
    '7', '0', 'D', 'A', '1', '6', '9', '8', '4', 'D', '2', '1', '0', '4', 'B', 'F',
    'D', '9', '9', '5', '2', '8', '0', 'C', '6', '2', '3', 'E', '1', '5', '0', '9',
    '2', '2', '8', '0', '9', '0', '7', '3', '0', 'A', 'D', '5', '2', '9', '2', '1',
    'F', '0', 'E', 'A', 'B', 'A', 'B', 'B', 'E', 'D', '5', '9', '7', '0', '1', '4',
    '8', '2', '3', '0', '9', '7', '4', 'B', '0', '9', '6', '8', '0', '9', 'B', 'F',
    'B', '2', '0', 'C', '6', '0', '6', 'E', '5', '5', 'E', '0', 'C', 'D', '2', '1',
    '8', 'F', '0', '2', '3', '4', '7', 'C', '1', 'F', '1', '1', '9', '1', '9', '7',
    '1', '3', '8', '1', 'E', '0', 'A', '9', '6', '1', '0', '1', '1', 'E', '0', '4',
    '1', 'C', 'F', 'E', '8', 'B', '1', '0', 'E', 'A', '4', '6', 'F', '9', '4', '8',
    '4', '4', '2', '5', 'E', 'B', 'F', 'B', '5', '8', '2', '9', 'C', '5', 'A', '7',
    'B', 'A', '4', 'A', '4', '2', '1', 'F', '8', 'B', '0', '0', 'B', '2', 'B', '7',
    '2', '9', '2', 'F', 'B', 'A', 'E', '8', '3', '3', '3', 'A', '8', '9', '3', '4',
    '9', '2', '1', 'C', '2', 'D', 'F', 'C', '0', '9', 'B', '8', '0', '6', 'D', '0',
    'A', '6', '6', 'F', '2', '6', '7', '4', 'D', '9', 'B', '6', 'F', '3', '0', 'D',
    '7', 'D', 'F', 'E', '9', 'C', '6', '9', 'D', '3', '8', '2', '5', '6', '8', '5',
    '5', 'F', '0', '1', 'D', '1', '6', '4', '4', '8', '0', 'E', 'F', '4', '5', 'C',
    '5', '9', 'A', '5', 'A', '5', 'B', '4', 'E', 'C', '6', '3', 'B', '7', '5', 'F',
    'B', 'B', '4', '6', '0', 'F', '3', '8', 'D', '5', 'B', '4', '2', '7', 'E', 'B',
    '3', '4', '5', '4', '7', '7', '1', 'C', 'F', '5', '0', '8', '2', '2', 'A', '5',
    '4', 'D', 'D', '4', 'F', '6', '9', '3', '4', '5', 'E', 'E', 'F', '3', 'D', 'B',
    'C', '5', '0', 'E', '7', 'B', '0', '9', '1', 'C', 'B', '3', '5', 'C', '1', '9',
    '0', '5', '5', 'D', 'E', 'F', 'C', '2', '0', 'E', 'F', 'E', '8', '2', 'D', '3',
    '4', '8', '9', '8', '6', '1', '8', 'B', 'C', '2', 'C', '9', 'E', '2', '9', '3',
    '4', 'A', '6', '4', '9', 'B', '3', '6', 'B', 'E', '1', '6', 'B', 'A', '5', 'F',
    '4', 'E', '2', '4', '0', 'F', '6', '1', '2', 'E', '9', '5', '5', '7', 'C', '6',
    '9', '2', '9', 'F', '8', 'C', 'F', 'E', '5', '8', '8', '9', 'D', '3', '7', '8',
    'D', 'B', 'E', '4', 'E', 'B', '5', 'E', '2', 'A', '6', '6', 'D', 'E', 'D', '6',
    'B', '3', '7', 'F', 'D', '8', 'F', '0', '1', 'A', '8', '3', '2', '5', '2', '3',
    'A', '5', '8', 'A', 'A', '7', '1', 'E', 'D', '4', 'A', 'B', '6', '7', 'A', '3',
    '4', '6', '0', '0', '1', '9', '0', '0', 'A', 'D', 'E', '6', '1', 'E', 'D', '6',
    '9', '5', '9', 'C', '6', '7', '2', 'C', 'D', '9', 'C', 'B', '1', '4', '7', 'D',
    '5', '5', '9', 'A', 'E', '6', 'E', 'C', '2', '1', 'F', '1', '9', 'C', '5', '1',
    'A', 'C', '4', '4', '4', '9', 'D', 'F', 'F', '5', '4', '3', '5', '0', '6', '2',
    'F', '9', 'C', '0', 'E', '6', '8', 'F', '2', '4', 'C', '6', 'F', 'B', '8', '4',
    '6', 'D', '5', '5', '3', 'F', '6', 'E', '6', '0', '2', 'D', 'C', '3', '2', '8',
    '3', 'C', '2', 'D', '5', '9', '5', 'C', '3', '7', 'B', '7', 'E', '2', 'C', '4',
    '1', 'E', '9', '8', '8', '1', '0', '0', '4', '8', 'A', '2', 'E', '0', '2', '5',
    'E', '2', 'B', 'C', '6', '6', '9', 'B', '9', '8', '7', '5', '9', '0', '9', '4',
    '8', '8', 'B', 'E', 'B', '2', '2', '6', '6', 'E', '9', '1', '7', 'F', '9', 'E',
    '5', '2', '8', 'D', 'E', '6', 'B', '5', '8', '0', '0', '4', 'F', 'F', '2', '7',
    'C', '4', '6', 'A', 'C', '6', 'D', '2', 'B', '5', '5', 'A', '0', 'F', 'D', '5',
    'E', 'A', '4', '6', '6', '8', '7', '0', '4', '5', '6', 'D', 'A', '4', '7', '1',
    '1', 'D', '0', 'F', '3', '0', '1', '0', '9', 'B', 'F', 'C', 'F', 'A', 'A', '0',
    'D', 'B', '0', '1', '3', '0', 'F', 'D', 'C', '8', '5', '0', '5', '6', '0', 'A',
    '3', '6', '2', 'E', '0', 'B', 'C', '5', 'C', 'C', 'F', '7', 'E', '4', '0', 'B',
    '3', '8', '0', 'E', 'A', 'B', '1', '7', '3', 'C', '3', '8', '2', '3', '5', '7',
    'B', 'A', 'F', '7', '8', 'E', '9', '8', 'B', '6', 'D', 'C', 'D', 'F', 'B', '9',
    '6', '8', '8', '7', 'B', 'B', 'D', '4', 'B', '3', '6', '1', '6', 'B', '9', 'D',
    '3', '9', 'A', '4', '0', '6', 'C', '5', 'C', 'E', 'A', '0', '0', 'E', 'C', '9',
    '8', 'C', 'F', '7', '4', 'F', '7', '7', '4', '1', '5', '9', '3', '5', 'C', 'F',
    '3', '4', 'C', 'A', '4', '3', 'C', 'E', '9', '5', 'C', '4', '8', '3', 'C', '8',
    'C', 'F', 'E', '7', '5', 'D', '5', '8', '3', 'B', 'E', '1', '1', 'D', '6', '2',
    'A', '0', 'C', '7', '7', 'F', '5', '2', '7', 'B', '1', '9', '7', '9', '7', '2',
    'F', 'E', 'E', '7', '4', 'A', 'A', '9', '5', '8', 'D', '0', '5', 'E', 'D', 'F',
    '6', 'A', '3', 'E', 'F', 'C', '2', '2', '1', '3', '6', 'A', '5', '3', '9', '8',
    'F', 'A', '9', '9', 'A', 'F', '9', 'F', 'E', '1', '7', '6', 'F', '2', '4', 'D',
    '4', '9', '5', '7', '8', 'F', 'B', 'B', '5', 'E', 'F', '9', '6', 'F', '5', '8',
    'B', 'E', 'D', '4', '4', '6', '8', '3', '7', '3', '6', 'D', '5', '6', '9', '1',
    'A', '5', '2', '7', '2', '9', 'D', '7', 'E', 'A', '9', '1', '9', '8', '2', '8',
    'E', '7', 'D', 'C', '1', '8', '0', 'E', 'A', '2', 'A', '8', '6', 'E', '4', '4',
    'D', 'D', 'D', 'E', 'E', 'E', '3', 'C', 'D', '5', 'E', '7', '5', '7', '2', 'D',
    '5', '7', 'A', '9', '2', '3', '0', 'E', 'D', '7', '1', 'C', 'C', '4', '7', '3',
    '1', '0', '2', 'D', '8', 'F', '5', '5', '9', '7', '9', '6', 'F', 'A', 'D', '6',
    '4', '7', '6', '0', '9', '6', '2', '5', 'B', '6', 'E', 'D', '5', 'B', 'A', '1',
    'A', 'F', '6', '6', '7', 'B', '1', 'B', 'E', 'D', '4', 'E', '0', '3', '7', '8',
    'F', 'B', '7', 'A', 'F', 'F', '0', '1', '8', 'C', 'D', 'D', 'E', '5', 'B', '7',
    'E', '8', '1', 'A', 'F', '9', '0', 'F', 'B', 'F', '5', 'C', 'A', '2', 'D', '6',
    'C', 'C', 'E', '4', 'B', '6', '4', '0', '9', 'A', '5', 'F', 'B', '3', 'D', '7',
    '9', 'F', '0', '1', '3', 'A', 'B', '1', '1', 'B', 'A', 'F', 'F', 'E', 'A', '8',
    'A', '7', '8', 'A', 'E', 'D', 'F', '2', 'A', '3', 'C', 'F', 'D', 'A', 'D', 'B',
    'F', '1', 'A', '4', 'F', '9', 'E', '5', '9', '4', 'D', '6', '6', '1', 'D', '7',
    'E', '8', 'A', '9', '9', 'A', 'B', '0', '3', '1', '7', '5', 'E', 'D', '0', '7',
    'F', 'B', '7', '7', '3', '0', 'A', '8', '8', 'D', '4', 'C', 'D', '1', '3', 'D',
    '0', '2', '2', 'F', 'F', '7', 'B', '5', 'A', '9', '2', 'F', '6', '3', 'C', '6',
    'E', '8', '4', 'F', '1', '2', 'C', 'B', '2', '5', '1', 'C', 'C', 'B', 'D', '4',
    'F', 'B', '0', '4', '8', '9', 'F', '8', '6', '4', 'A', 'F', 'C', '2', '4', 'E',
    '2', '3', '6', '5', 'A', '9', '6', '5', '4', 'F', '3', 'A', '2', '1', '6', '6',
    'D', '0', '7', '0', 'E', '2', '0', '8', 'D', 'F', '3', '4', 'E', '1', '2', '1',
    '3', '1', '6', 'F', '8', 'E', '6', '5', '8', 'A', 'C', '2', '8', '6', '8', '2',
    '3', '6', '3', '6', 'A', '1', '7', 'B', '9', '5', '3', 'D', '1', '7', '5', 'D',
    '3', '0', 'F', '7', '1', '9', '0', 'D', '4', 'F', '2', 'A', '6', 'F', '7', '4',
    '3', 'D', '9', '8', '5', 'B', '9', 'F', '6', 'F', '7', '9', '1', '2', '6', '6',
    '1', '0', 'F', 'C', '9', 'D', '2', '3', '1', '9', '8', 'A', '9', '4', '9', '2',
    'B', '9', 'E', '4', 'A', 'B', 'A', 'B', '1', '5', '0', '8', 'B', '3', 'D', '3',
    '0', '5', '2', 'F', 'D', 'B', '9', '0', 'D', '9', '3', '2', '9', '8', '6', 'A',
    '9', 'D', 'E', 'E', '0', '8', '6', '0', 'D', 'E', '5', '0', 'C', 'F', '2', 'D',
    '1', '4', '0', '3', '5', '6', '5', 'D', '7', 'C', '8', 'E', '3', 'F', 'D', '3',
    '3', '7', '4', '5', '5', '7', '6', 'C', 'C', '4', '0', '1', '4', '0', '6', '5',
    '7', 'F', '1', '5', '3', '2', '3', '2', '3', '2', 'E', '5', 'B', '0', '9', '2',
    '2', 'E', 'C', '7', 'B', 'E', '9', 'C', '8', '6', '2', '0', '9', '3', 'E', '2',
    '6', '4', 'E', '7', 'A', '2', '1', 'D', 'C', '2', '8', '8', '3', '8', '4', 'D',
    'E', '7', 'A', '3', '7', '9', '6', 'D', 'D', '6', 'F', '8', '0', '3', '8', '4',
    '5', '7', 'B', '1', 'B', '4', '6', '5', '7', 'D', 'A', 'B', '2', 'D', '2', '2',
    'B', 'B', 'E', '2', '0', 'A', 'D', '3', 'C', 'B', '9', '9', '6', '9', '2', '6',
    '8', 'D', 'D', '9', '8', '5', 'B', '4', '8', 'D', '0', 'E', 'E', '4', 'A', '7',
    '5', '7', 'C', '5', '9', '9', 'B', 'C', '1', '5', 'F', 'A', '4', 'E', 'B', '2',
    '0', 'A', 'A', 'A', '5', '4', '6', '8', '0', 'B', '3', '2', '1', 'F', '5', '1',
    '9', 'F', '2', '2', '2', '7', '8', 'B', 'A', 'C', '0', 'E', '9', '0', '4', '2',
    '3', '6', '8', '5', '1', '9', '2', 'A', 'A', '6', '0', '3', '3', 'D', '3', '8',
    'A', 'B', 'C', '6', '6', '5', '8', '9', '1', 'A', 'C', '4', 'F', '1', '5', '3',
    '1', '5', 'C', 'C', '0', 'C', 'D', 'D', '4', 'C', '2', 'C', '4', '2', '4', '7',
    'F', '0', '0', '5', '6', '9', '7', 'E', '5', 'A', 'D', '9', '1', 'A', 'C', 'A',
    '7', '1', '5', 'B', '5', '6', 'E', 'C', '5', '4', 'E', '3', '3', '1', '6', '6',
    '8', 'A', '1', 'D', '5', '3', 'E', '6', '6', 'D', '8', '1', '6', 'C', '5', 'E',
    '8', '2', 'F', 'A', '8', 'F', 'C', '7', 'F', 'C', 'A', '9', '9', '4', 'F', '9',
    'A', 'F', '5', '1', 'B', '7', 'D', '7', '7', '1', '7', '8', '5', '2', '2', 'C',
    '6', '4', 'D', '7', '5', 'E', '7', 'D', '4', '8', 'A', 'B', '1', 'B', 'A', '9',
    '0', '4', 'B', '8', '7', '6', 'B', 'C', 'D', '4', '0', 'B', 'F', '8', 'E', '7',
    '9', '7', 'A', '2', 'C', '0', 'B', '5', '1', '3', 'B', 'A', 'A', '2', 'A', 'D',
    'F', '3', '1', 'A', '1', '0', 'B', '4', 'D', 'D', '8', '7', '2', 'E', '8', 'E',
    '4', '6', 'D', '5', '6', '4', 'F', 'A', '5', '4', 'C', '8', 'A', 'B', 'E', '0',
    '9', '7', '3', '3', '6', '9', '7', '9', '9', 'D', '8', '4', 'C', '8', '9', 'A',
    '5', 'F', 'A', 'C', 'A', '7', 'F', 'D', 'D', '6', 'F', '4', 'E', 'A', 'A', 'B',
    '2', 'F', '5', '8', '0', 'D', '8', 'E', '4', 'C', 'E', 'A', '1', '4', '7', '0',
    '1', '5', 'E', '9', 'C', '0', 'F', 'A', '4', 'C', 'F', '5', 'B', 'E', 'E', '8',
    '5', '3', '3', '4', 'D', '5', 'A', 'E', 'F', '1', '5', 'F', 'F', '2', '2', '7',
    '4', '6', 'A', 'C', 'B', '3', '9', '1', 'A', 'B', '2', '7', '8', 'A', '7', '2',
    '4', '1', 'E', '8', '6', '1', '8', '1', 'D', 'E', 'F', '0', 'D', 'C', 'A', 'E',
    '2', '3', 'E', 'A', '1', '9', '0', '8', '2', '7', '8', '4', 'E', '3', 'D', 'E',
    '2', 'B', 'F', 'B', '4', 'D', '9', '1', 'E', '8', 'E', '8', '4', 'A', '1', '8',
    '9', 'F', '1', '9', '3', '5', '7', '1', '8', '5', '1', '6', '6', '0', '9', 'C',
    '9', '0', 'C', '1', 'A', '1', '2', 'E', '6', '3', '5', 'D', 'E', '5', 'A', '3',
    '8', 'F', '3', '3', '5', '8', 'B', '5', 'D', 'A', 'C', '5', 'F', 'B', '2', 'B',
    'E', 'F', 'F', 'C', '9', 'C', '0', '2', '0', '3', '7', '3', 'E', '9', '9', 'A',
    '3', '6', 'A', '4', '3', 'C', 'C', 'D', '8', 'B', '5', '8', 'D', '8', 'E', '2',
    'B', '1', 'F', 'F', '0', 'D', '0', '2', 'E', 'D', 'C', '2', '4', '6', '9', '2',
    '8', '8', '4', '0', '9', '2', '4', '8', 'A', '8', '8', '1', '5', '5', 'A', '3',
    '2', '9', 'F', '1', 'C', '5', 'B', '1', 'C', '5', '3', '8', '8', 'E', 'A', 'D',
    'E', 'C', 'C', '8', '3', '0', '9', 'D', '0', '2', '1', '6', '9', 'D', 'B', 'E',
    '5', 'E', 'C', 'C', '5', 'C', 'B', '2', '9', 'A', 'D', 'E', '8', '7', 'F', '3',
    'B', '2', 'F', 'F', '0', '1', 'F', 'A', '7', 'F', 'C', 'D', '2', 'E', 'E', '7',
    '7', 'A', '7', '6', 'E', 'D', '1', '5', 'D', 'A', '0', '9', '2', '3', 'D', '5',
    '3', 'D', 'E', '6', '9', '0', '8', '8', '8', 'E', '7', '2', 'F', 'A', 'D', '4',
    '0', '9', 'C', 'C', 'E', '4', 'E', '1', 'D', 'F', '8', '7', '1', '7', '8', '1',
    '3', '5', '1', 'A', '3', '6', 'B', '3', 'B', 'F', 'A', 'A', '5', '6', '3', 'D',
    'F', 'A', 'E', '4', '9', '8', '6', '6', '3', '8', 'D', 'E', 'A', 'E', '7', '9',
    '8', 'F', 'B', 'B', '3', '4', '1', 'C', '7', '0', '8', '5', '3', '5', '0', '2',
    'B', '4', '8', '3', 'E', 'A', '7', '8', 'E', '7', '5', 'E', 'E', '8', '8', 'A',
    '9', 'D', '2', '0', '9', '3', '5', '6', 'C', '0', '9', 'B', '5', 'D', '4', 'E',
    'B', 'F', '4', '3', '3', '1', '5', 'E', '1', 'C', '2', '5', '8', '3', 'C', '9',
    'E', '5', '0', 'F', '5', 'D', 'C', 'B', '4', '4', '6', '2', 'F', '7', '4', '0',
    'D', 'A', 'C', 'B', '7', '0', 'E', '9', 'C', '2', '2', '3', 'B', 'A', '6', '7',
    '8', '0', 'D', 'F', 'A', 'D', '7', 'F', '7', '0', '9', 'E', '2', '7', '0', '3',
    '2', '9', '5', 'F', '1', '5', 'B', 'D', '7', '6', '5', 'C', '8', '7', 'A', '0',
    '8', '6', 'A', '6', '7', '7', 'C', 'D', '8', '9', '1', '5', 'B', '0', '0', 'E',
    'B', 'E', '5', 'F', '4', 'A', 'B', 'E', '0', '6', 'F', 'A', '7', '5', '4', '1',
    'D', '7', '9', 'D', 'E', '9', '0', '0', '6', '7', '7', '6', 'E', '2', '1', 'C',
    '6', '4', 'F', 'F', 'A', '2', 'D', 'A', '3', 'A', '1', '2', 'E', 'F', '2', '1',
    '1', 'E', '4', '2', '2', 'C', '3', '2', 'B', '9', 'C', '7', '3', '2', 'C', 'C',
    '2', 'A', '2', 'E', 'E', '6', '2', 'F', '2', 'A', '2', 'E', '4', '8', 'E', '5',
    '2', '8', '0', '3', '9', 'B', '1', 'C', '1', 'B', '4', '7', '9', '5', '5', 'F',
    'A', '7', 'B', '6', 'A', '3', 'D', '4', '3', 'C', '1', '2', '3', '4', 'D', 'E',
    '2', '4', 'A', 'E', '6', '7', '9', '9', '7', 'A', '8', 'C', '0', '9', 'D', 'B',
    '2', 'A', 'D', '6', '8', 'A', '4', '9', 'C', '4', '0', '0', '8', '1', 'B', '9',
    '5', '6', '5', 'E', '3', '3', '6', 'A', '0', 'F', '7', '4', '6', 'B', 'A', 'D',
    'F', '2', 'C', '6', '7', 'D', '9', 'E', '0', '4', 'B', '0', 'E', '9', '3', '4',
    'A', 'D', '2', 'F', '2', 'D', '6', 'A', 'F', '4', 'A', '2', 'F', '6', '0', 'A',
    'A', '8', 'E', 'F', '0', 'A', '1', 'A', '9', '8', 'C', '7', '3', 'A', 'A', '7',
    'A', 'C', 'C', '7', '2', 'E', '8', '6', '5', '8', '4', '7', 'D', 'F', '4', '3',
    '4', '8', 'B', '8', '6', '3', '0', '9', '6', '9', '6', '5', 'F', '8', 'A', '1',
    '7', 'E', '9', '6', 'A', '1', '9', 'E', '2', '4', '4', '3', '8', '9', 'E', 'D',
    '3', 'B', 'A', '2', 'A', 'A', 'C', '9', '4', '8', 'D', 'D', '1', '9', '9', 'B',
    '7', '0', 'F', 'A', '0', 'E', '3', '6', 'F', 'D', '6', '2', '5', 'D', '3', 'E',
    '0', '2', '0', '0', '3', 'C', '2', '8', '1', '0', '3', '8', '5', '1', 'D', 'B',
    '0', 'C', '2', '1', '6', 'C', 'F', '1', '6', '6', '9', 'C', 'F', '6', '0', 'F',
    'A', '1', 'B', '8', '8', 'C', '4', 'F', '3', '1', '8', 'A', 'A', 'C', '2', '0',
    '6', 'E', '2', '8', '7', '2', '2', 'F', '0', '2', 'B', '3', '8', '8', '6', '6',
    '2', '4', '9', '5', '1', '1', 'B', '5', '4', 'E', 'E', '7', '4', '5', '8', '3',
    '7', '7', 'F', 'C', '1', 'E', 'A', 'B', 'A', 'F', '5', '3', 'F', '6', '3', '2',
    '6', 'F', '1', '9', 'D', '9', '9', 'D', 'E', '2', '0', '5', '9', '2', 'D', '8',
    'F', '7', '8', 'B', 'F', 'A', '4', 'A', 'A', '6', 'D', '1', '4', '4', '0', 'F',
    '8', 'E', 'F', '3', '5', 'A', '3', '1', 'D', '0', '0', 'B', 'D', '6', '0', '6',
    '3', 'B', 'E', 'E', 'D', '4', '3', 'F', '1', 'A', 'B', '7', '7', '8', 'B', 'C',
    'B', 'F', '8', '1', '2', '4', '7', '9', 'D', '2', '7', '7', '8', '1', '7', '9',
    '4', '4', '3', '0', '6', 'C', '1', '8', '9', '9', 'E', '6', 'D', 'E', '0', 'C',
    '5', '0', '6', '6', '2', 'C', 'A', '6', 'A', '6', '3', '1', 'C', '7', '2', '9',
    'A', 'F', '9', 'C', '1', '8', 'B', '4', 'D', '6', 'F', '9', 'D', '3', 'F', 'D',
    '7', 'C', '4', 'A', 'A', '6', '4', '0', 'E', '9', '0', '9', 'C', '6', 'D', '0',
    '9', '2', 'D', 'F', 'A', '2', '4', 'D', 'F', '3', '0', '3', 'F', '0', '3', '2',
    '0', '1', '6', '8', '7', '2', '8', '4', 'F', '4', '6', '6', '8', 'E', '8', '1',
    '3', '0', 'C', '2', '7', 'B', '7', 'F', '7', '9', 'C', '6', '6', 'C', 'D', '3',
    '8', '4', '2', 'B', 'E', '9', '8', '8', '4', 'C', '8', 'D', 'F', 'B', '0', '3',
    '8', 'F', '3', '8', 'F', '0', '5', 'A', '5', '0', '5', 'D', 'C', '1', '2', '2',
    'D', '1', 'F', '1', '2', 'D', '3', '6', '4', 'A', 'F', '1', 'F', '6', '3', '3',
    'E', '1', '4', 'D', 'B', '9', '9', '4', '2', 'C', 'F', '3', '1', '3', '5', '5',
    'B', 'F', '3', 'B', 'B', '7', 'E', 'D', '5', '0', '2', '7', 'F', '1', '9', '0',
    '3', 'E', 'B', '8', '9', '3', '3', '3', '2', 'F', 'A', 'B', '7', 'B', 'E', '9',
    'E', 'A', '9', 'F', 'C', '9', 'A', '7', '0', '4', '9', '7', '0', '1', '6', '2',
    '2', 'A', '3', '3', 'F', '8', '5', 'D', 'E', 'B', '1', '0', '4', '5', '4', 'B',
    '7', '2', 'D', '4', 'F', 'E', '8', '8', '1', '5', '6', '6', '0', 'F', '4', '0',
    '4', '2', '2', 'C', 'B', 'C', '9', '7', 'E', '3', '6', 'A', '3', '7', '5', '4',
    'B', '5', 'E', 'E', 'F', '8', '0', '3', 'B', '8', '1', '6', '8', '6', 'D', '3',
    '9', '8', 'E', '5', '9', '9', '0', 'D', 'A', 'F', 'F', 'B', 'A', '5', '4', '1',
    'B', '9', 'C', 'E', '5', '0', '6', '6', '4', '6', 'B', '7', 'F', 'E', '3', '2',
    '4', '5', '8', '6', 'D', '2', 'B', '7', '7', '7', '4', 'E', '8', '6', '9', '5',
    'E', '1', '9', 'E', '1', 'E', '7', '4', '1', '8', '0', '5', '6', '4', '7', '6',
    '1', '4', '1', '5', '0', '2', '4', '2', 'A', 'D', '1', '0', 'D', '9', '7', '0',
    '1', 'F', 'E', 'B', 'A', '8', 'B', '2', '6', '1', '8', '8', '7', '0', '4', 'E',
    '5', 'F', '2', '3', '7', '5', '8', '2', '7', '1', 'D', 'B', '1', '2', '1', '9',
    'D', 'A', '3', '9', '0', '7', '4', '8', '3', '2', '8', 'B', 'E', 'F', 'E', '0',
    'C', '7', '0', 'D', 'A', 'E', 'D', 'A', 'B', '8', 'B', '7', 'C', '2', '7', '3',
    '3', 'E', '6', '5', 'B', '4', 'E', '8', '9', '2', 'F', 'F', '5', 'A', '3', '9',
    'E', '0', '2', '0', 'D', 'C', 'C', 'B', 'C', 'B', 'F', '7', '9', 'F', '2', '3',
    'E', 'E', 'F', '8', 'B', 'B', '4', 'D', '4', '3', '2', '4', 'B', 'A', 'D', 'C',
    '1', 'D', 'A', '9', 'D', 'A', 'C', 'C', '0', 'B', 'A', '1', 'E', 'C', '0', '8',
    'A', '0', '5', 'B', '6', 'A', 'A', '1', '9', '5', '1', '5', 'A', '6', '5', 'B',
    '9', 'D', 'D', 'F', '7', '5', '7', 'E', 'D', '7', 'E', 'F', '6', 'F', '7', 'F',
    'C', 'C', 'E', '9', 'A', 'D', '4', '6', '4', 'A', '8', '0', 'E', 'A', '9', '8',
    '2', 'F', 'D', '4', '0', '0', '3', 'D', 'B', 'B', 'B', 'E', '2', 'D', 'E', '1',
    '8', '3', 'F', 'F', '1', '0', 'E', 'D', 'C', '2', '2', 'D', '3', '7', '0', 'A',
    '4', '5', '2', '6', '2', '2', 'A', '0', '2', 'D', '8', '7', 'F', '1', 'A', '2',
    'B', 'A', '8', 'E', '9', '1', 'D', '7', 'E', '9', '9', '5', '8', '1', 'E', 'B',
    '6', '6', 'A', '0', 'C', '1', '2', 'D', 'F', 'F', '4', '9', '8', 'A', '8', '1',
    'C', 'A', 'A', 'A', 'B', 'B', '5', 'A', 'A', 'D', '1', '8', '8', '2', '4', '2',
    'E', 'D', '3', '1', '7', '8', '4', '1', '7', 'F', '0', '2', 'D', '8', '8', 'F',
    'B', 'B', '9', '0', '5', '6', 'E', '8', '0', 'C', '0', 'E', 'E', 'E', 'E', '2',
    '1', '4', 'D', '7', 'E', '4', 'D', '2', 'C', '7', '7', '6', '2', '0', 'C', '7',
    'C', '0', 'E', 'D', '9', '8', 'A', '6', '2', 'F', '6', '9', 'C', '8', 'B', '3',
    'D', '5', '9', 'A', '3', 'D', 'E', '4', 'D', '6', 'D', 'E', '1', '3', '2', 'E',
    '4', '6', '5', '1', 'A', '2', 'C', 'D', '5', '3', 'C', '1', '0', '6', 'A', '9',
    '7', '9', '1', '7', '7', '3', 'A', '2', 'D', '4', '6', '1', 'F', '4', '9', '7',
    '5', 'D', '3', '7', '4', '7', '4', '8', '3', '1', 'C', 'A', '7', 'F', 'F', 'A',
    '5', 'C', 'A', '0', '9', '0', '9', '4', '2', '6', '4', 'E', 'C', 'E', '3', '4',
    '5', 'A', '6', 'D', 'F', '3', '4', '1', '7', 'D', 'D', '5', 'C', 'B', '2', '8',
    'B', '9', '5', '1', '4', 'E', '0', 'F', '4', 'D', 'F', 'A', 'E', '7', 'E', '4',
    '5', '3', '0', '0', '4', 'C', 'D', 'C', '2', '9', '6', '8', 'D', 'F', '7', '0',
    '3', 'D', 'C', '1', '8', '4', 'B', 'E', 'A', '9', '8', '0', 'D', '8', '4', '0',
    '9', 'B', 'A', 'E', '5', 'B', '4', '3', 'C', '8', '8', '6', 'A', '0', 'A', '1',
    'C', '8', '6', '2', '5', '7', 'B', '2', 'D', '5', 'B', '1', '6', 'D', 'B', 'D',
    'E', '8', 'A', '3', 'C', '7', '0', '8', 'E', '1', '4', 'E', '6', 'E', 'F', '3',
    'A', '6', 'F', '8', 'F', 'C', 'E', '4', '4', '3', '8', '6', 'F', '8', '8', 'A',
    '6', 'C', '8', '5', '1', '5', '5', '0', '7', '7', '0', '1', '9', '3', 'D', 'D',
    'F', '1', '1', 'A', '3', '7', '1', '9', '9', 'C', 'F', '2', '3', '3', '4', '4',
    '9', 'F', '9', '0', '6', '0', '7', 'C', 'A', 'C', '4', 'C', '8', 'D', '0', '4',
    '7', '6', 'D', '1', 'D', '6', 'D', 'D', '5', 'E', '6', '3', 'F', '8', 'B', '9',
    'C', 'F', '2', '9', '7', '6', '7', '1', 'D', '3', '1', '2', '9', 'D', '5', '9',
    '7', 'E', '3', 'F', 'E', 'F', 'B', '8', '7', '1', '2', 'F', '9', 'A', '6', '0',
    '0', '1', '0', '1', 'E', '8', 'A', '8', '6', '4', '8', 'B', 'E', '2', '2', '4',
    '2', '7', 'E', 'B', 'C', 'C', '6', '1', 'C', 'F', '8', 'B', 'C', '2', 'F', '3',
    '9', '1', 'F', '2', 'E', 'B', '2', '3', '2', '6', '3', 'B', '3', '0', '3', 'F',
    '3', 'F', '6', '0', 'D', 'E', 'D', 'B', 'A', 'A', '3', '1', '6', 'A', '7', 'A',
    'C', '6', '2', '6', '5', '8', '7', '2', 'B', 'F', '7', 'D', 'B', '0', '8', '1',
    '3', 'C', '7', 'E', '2', 'B', '7', '1', 'A', '6', 'B', 'F', '2', 'A', '2', '4',
    '3', '3', '1', '2', '4', '7', '1', '1', '5', '7', 'E', '5', '5', 'E', 'C', 'A',
    '7', 'A', 'E', '4', 'D', 'F', '9', 'B', '9', 'C', '4', '6', '3', 'A', '7', '6',
    '8', '3', '6', '6', 'D', 'D', 'C', '6', '7', 'B', '0', 'D', '2', '4', '0', 'E',
    '5', '0', 'E', '4', '4', 'A', '0', '7', 'D', '2', '1', '0', '4', '1', 'B', '1',
    '2', '2', 'C', '3', '1', '6', 'D', 'A', 'C', '8', '5', 'E', 'B', '4', 'E', '7',
    '1', '4', 'C', 'B', '3', '8', 'E', 'D', '2', '1', '9', 'D', '2', '4', 'D', '4',
    '3', '8', '8', '7', 'B', '5', '0', 'B', '5', '6', '6', '0', '5', '2', '9', '7',
    'D', 'E', 'F', '8', 'D', '4', 'F', '9', 'B', '3', '7', 'E', '4', 'B', '0', '5',
    '0', 'A', '3', '7', '8', '4', 'B', '5', 'D', 'D', '1', '7', '6', '1', 'B', '7',
    '7', '6', '7', 'B', '9', '9', '2', '9', 'D', '9', '0', '2', '5', 'E', 'B', 'A',
    'E', '8', '5', '2', '7', 'F', 'F', '1', '4', '4', '1', '6', 'E', 'B', '0', 'B',
    '1', 'A', 'A', '2', '6', '8', 'E', '9', '7', '6', '0', 'D', '7', '9', '3', 'F',
    '2', 'D', '6', 'D', '2', '3', 'A', '6', 'F', 'D', 'F', 'C', 'C', '0', 'E', '9',
    '8', '7', '9', '5', '3', '9', 'F', 'B', '7', 'E', '4', '5', '7', 'F', 'E', '9',
    '8', '6', '3', 'E', '3', '3', '7', '9', '0', '2', '4', '4', '5', 'E', '5', '9',
    '2', '0', '4', '9', '1', 'B', '2', 'E', '9', '6', '9', 'F', '9', '0', '8', '4',
    'C', 'F', '2', '4', 'C', 'C', 'D', '4', '6', 'D', '1', 'E', 'B', '6', 'F', '1',
    'B', 'D', 'A', 'D', '7', '2', '4', '1', 'A', 'A', 'E', '5', '4', 'C', 'C', '6',
    '5', '8', '2', '4', 'A', '5', '1', 'E', '1', '1', 'A', '5', '0', 'B', '4', 'E',
    '0', '0', '8', 'B', '6', '6', '9', '0', 'C', '2', '4', '1', '6', '2', '6', '0',
    '0', 'A', 'D', '7', '7', '7', '1', 'C', 'D', '0', '8', 'F', 'F', '4', '7', '9',
    '2', 'E', 'C', '0', 'C', 'C', '2', 'F', '0', 'E', '3', 'E', '0', 'D', 'A', 'F',
    'C', 'E', 'A', '9', 'D', '7', '6', '9', '7', '2', '8', '3', '2', '7', 'C', 'A',
    '0', '3', '2', '6', '1', 'B', '7', '8', 'C', 'D', '6', 'B', '5', '5', '8', 'B',
    '1', '2', '7', '9', '4', 'B', '8', '2', '0', '9', 'C', '1', '9', 'C', '0', '2',
    '7', 'C', '7', 'D', '6', 'E', '3', '1', 'C', '4', '7', '0', '8', '0', '3', '4',
    'A', '4', '2', '9', '1', '8', '4', 'D', '5', '2', '3', 'A', '4', '2', '6', 'D',
    'C', 'F', '2', 'A', '1', 'B', 'F', '5', '6', '1', '7', '6', '1', '0', '2', 'F',
    'A', 'E', 'F', 'C', 'E', 'D', '8', 'E', 'B', '2', '1', 'A', '9', '2', '0', '8',
    'D', '9', 'A', 'D', 'C', '7', 'A', 'A', 'B', 'F', 'C', '2', '3', 'D', '2', 'D',
    'D', 'A', 'C', '7', '3', '9', '0', '5', 'F', '9', 'D', '4', 'E', 'B', 'A', '0',
    '6', '4', 'B', '2', '5', 'C', '1', 'D', '8', '8', 'F', 'A', '5', 'E', '0', '8',
    'F', '7', '7', '1', 'F', '1', 'E', 'C', 'C', '5', 'B', 'B', 'F', 'B', '9', 'E',
    '8', '8', 'E', '3', '0', '3', '4', '1', 'C', '2', '9', 'F', '1', '4', '5', '3',
    '2', '6', '4', 'D', '7', '0', 'D', 'E', '2', 'A', '1', '1', '1', 'D', '7', 'F',
    '3', 'E', '9', '0', '2', 'D', '2', 'C', 'F', '0', '1', '1', '1', '6', 'E', '4',
    'A', '2', 'B', 'C', 'C', 'F', '1', '8', '0', '2', 'B', '7', '1', '1', '5', '6',
    'F', '9', 'D', '2', '1', '8', '6', 'B', '4', '3', '0', '6', '5', 'E', 'F', 'B',
    'D', 'A', 'E', '5', 'C', '6', 'E', '6', '7', '5', '6', '0', '8', '4', '6', 'E',
    'F', '5', '9', 'A', 'D', '6', '8', '5', 'F', '9', '9', '5', 'B', '9', 'D', '7',
    '3', '4', '4', '0', 'E', 'C', '8', '5', '4', '2', '3', '5', '0', '4', 'C', 'F',
    'C', 'D', '9', '9', 'F', '4', 'E', '4', '0', '4', '5', 'D', '9', '6', 'D', '8',
    '7', '6', '7', 'B', '0', '1', '6', 'F', 'B', '6', 'C', '7', '2', 'B', 'C', 'D',
    'C', 'D', '1', 'E', '4', '9', 'F', '8', '6', 'F', '7', '1', 'D', '0', 'A', 'C',
    '5', '6', '5', '0', '5', '1', '3', '9', 'F', 'F', '9', '5', 'B', '9', 'F', '6',
    'B', '1', 'D', '9', '3', '5', '8', 'F', '6', '8', '1', '3', '9', '0', 'E', '3',
    '1', 'F', '7', '8', 'D', '2', '3', 'C', '5', '4', '2', 'A', 'B', '7', 'D', 'F',
    '1', '2', '3', '8', '4', '5', '0', '8', '5', '7', '3', 'B', 'C', '2', '0', 'B',
    'A', '2', 'D', 'C', '7', '3', 'A', '9', '2', 'D', '8', '9', 'F', 'A', '8', '6',
    'B', '3', 'F', '9', '1', '2', '5', '1', 'C', '9', 'F', '5', '4', '5', 'E', '3',
    '9', '3', '6', 'B', 'B', '3', 'C', '1', 'F', '1', '1', '8', 'B', 'C', '4', 'D',
    'D', 'B', '1', '4', '7', '2', '7', '9', '6', 'C', '2', '5', 'A', 'D', 'A', '5',
    '1', '0', 'A', '3', '1', '3', '1', '3', '5', '0', 'E', '1', 'B', '9', 'D', 'D',
    '5', '9', '7', 'E', '7', 'E', '7', '9', 'D', 'A', '6', '3', '3', '9', '7', 'F',
    '3', '8', '0', 'E', 'E', '5', '5', '4', 'E', '0', '9', 'B', 'B', '4', '3', 'D',
    '8', '5', '4', '3', '9', '1', '7', 'D', 'D', '5', '8', 'B', 'B', '9', '3', '2',
    '0', '3', '3', 'C', 'D', '1', '6', '8', 'B', 'D', '4', '5', 'E', '7', 'F', 'A',
    'E', '1', '1', '4', '4', '9', '2', '8', '0', '2', '6', '6', 'B', 'F', 'A', '9',
    'A', '5', '8', '6', '3', 'E', 'D', 'A', '5', 'A', '9', '6', 'D', '0', '7', '3',
    '1', '8', '5', 'A', '5', 'E', '9', 'D', 'F', '9', '2', 'B', '7', 'F', 'B', '3',
    '1', '0', 'F', 'B', '4', '5', '1', 'D', '7', 'B', '8', '7', 'F', '1', '2', 'F',
    'B', '4', 'B', 'C', '6', 'D', 'C', 'C', '7', '3', 'B', 'C', '0', 'A', '0', 'A',
    '8', '3', 'B', 'F', 'A', '3', 'B', '4', '0', '6', 'A', '6', 'D', 'F', 'F', '9',
    '9', 'A', 'D', '3', 'C', '2', '9', '9', 'E', '5', 'E', '5', '9', 'B', '5', '9',
    '3', '9', 'C', '0', '5', '1', '0', 'B', 'D', 'E', '1', '2', '0', '8', '2', 'D',
    'C', '5', '9', 'C', 'F', '1', 'E', '6', 'C', '3', '6', 'D', 'C', '5', '6', '5',
    '5', '3', '1', '4', 'A', '4', '6', '5', 'C', '4', '6', '9', '4', 'F', 'E', 'D',
    '3', '3', '3', '7', '1', 'C', '5', 'B', '3', '7', '7', '4', '2', '1', '9', '3',
    'F', 'F', '8', '8', '3', '5', '9', '1', 'B', '0', '4', '9', '7', '7', '5', '5',
    '6', 'F', '8', '5', 'E', '3', '6', '1', '6', '7', '0', '8', 'B', 'D', '9', '0',
    'B', '1', 'B', 'A', 'D', '6', '2', '3', 'A', 'A', 'E', '1', 'B', '5', 'C', '1',
    '4', '5', 'C', '9', '2', '4', 'F', 'A', 'F', '0', 'F', '9', '8', 'C', '8', 'C',
    'A', '3', '8', 'B', '9', '1', '3', '7', '2', '9', 'A', 'E', 'F', 'A', '2', '8',
    'E', 'F', '5', '1', '6', '4', '0', '3', 'B', 'C', '5', 'F', 'F', 'A', 'A', 'A',
    '0', '8', '5', 'F', 'B', '1', 'E', 'C', '2', '1', 'F', 'B', '3', '7', '1', '5',
    'F', 'C', 'B', '4', 'F', '0', 'F', '7', 'E', '1', '2', '1', '9', '6', 'E', '3',
    '8', '3', '4', 'F', 'D', '5', '1', 'E', 'A', '7', '9', '6', '3', '4', 'E', 'F',
    'E', '3', '6', '3', '6', 'F', '2', 'B', '2', '7', '4', 'C', '4', 'E', '2', 'C',
    '7', '6', '4', 'F', '0', 'D', 'B', '0', '3', '9', 'C', '5', '3', 'F', 'B', '7',
    '3', '8', '0', '8', '9', 'C', '5', '8', 'A', '0', '7', 'E', 'C', '3', '6', 'D',
    'B', 'C', 'C', '5', '4', 'D', '9', '2', '0', '1', '2', 'A', 'A', '6', '3', 'E',
    '0', '1', 'F', '5', 'D', 'F', '7', 'A', '1', '3', 'E', '6', '9', 'C', '1', '4',
    'C', '1', '4', '5', 'F', '0', '2', '5', '9', '5', 'A', 'F', '5', 'F', 'F', 'C',
    'E', '4', '7', '8', 'B', '5', 'B', 'E', 'D', '6', 'A', '8', '7', '8', '7', '8',
    'F', '7', 'F', '7', '6', 'B', '5', 'F', 'A', '9', 'A', '7', '4', '5', '8', 'A',
    '0', '5', 'D', '0', '3', '1', '8', '2', 'D', '6', '7', '6', 'E', '1', '9', '7',
    '1', '6', 'D', 'B', '6', 'A', '3', 'F', 'E', '9', '8', '4', 'E', '3', 'B', 'A',
    '0', '3', '1', '3', 'D', '1', '7', 'F', 'A', '6', '4', '3', 'B', 'E', '1', 'F',
    '7', '7', 'F', 'E', '6', '3', '3', '5', '0', '7', '9', '3', 'D', 'C', '0', 'C',
    'E', '1', '5', '6', '2', '8', 'B', '6', 'A', '3', '3', '2', '3', '6', 'D', '3',
    'F', 'D', '0', '3', '1', '5', '7', 'B', '0', '0', '3', 'D', 'F', '9', '8', 'C',
    '7', '2', 'A', '3', '3', '1', '2', '8', '0', '0', 'C', '2', 'E', '1', 'A', '1',
    'B', '2', 'F', 'C', '7', '7', 'B', '8', '6', '3', '0', '0', '5', '0', '4', '6',
    'B', 'E', 'D', 'A', '5', '1', 'F', 'B', '6', 'F', 'D', '3', 'B', '8', 'B', '1',
    '6', 'B', 'D', '8', '2', '1', 'B', '7', '7', 'E', '0', '3', '4', '9', '7', '1',
    'A', '9', 'D', '3', '9', '5', 'F', '5', '0', 'B', '9', '4', '7', 'A', '8', 'A',
    'A', '0', 'E', 'F', '2', '4', 'E', '4', '5', '2', 'A', 'A', 'B', 'E', '2', 'B',
    '3', 'D', '6', '5', 'E', '1', '6', 'E', 'E', '9', 'E', '5', 'F', '8', '7', '1',
    'C', '2', '8', '2', '8', '5', 'C', 'D', 'E', 'E', 'F', 'D', 'A', '0', '4', '0',
    'F', 'E', '9', 'C', 'A', '6', 'B', '1', 'B', '4', '2', '4', '6', 'C', '0', 'C',
    '4', '3', 'D', 'B', '4', '0', '8', '1', '8', '7', '5', '4', 'F', '5', '8', '1',
    '1', '7', '4', 'F', '9', 'D', 'C', '7', '2', '9', '6', '9', '3', '2', '6', '1',
    'D', '7', '0', 'A', '6', '5', 'F', 'F', '2', '2', '1', 'A', 'A', '5', '7', '8',
    '4', '7', 'F', 'B', 'F', '8', '0', 'B', 'C', '9', 'B', 'B', 'C', 'B', '8', '8',
    '8', '2', '5', '7', '9', '0', '2', 'B', '4', '4', '7', '6', '8', 'F', '8', 'B',
    '0', '7', '2', 'C', '7', '1', '5', '3', 'B', '8', 'A', 'C', 'C', '7', '0', '1',
    '0', '5', '2', 'C', '4', '9', '8', '8', 'A', '0', '7', '8', 'D', 'B', '5', '1',
    '8', 'A', '3', '3', '2', '7', 'B', '0', '5', '1', '3', '7', '8', 'F', '4', 'C',
    'C', 'F', '1', 'C', '9', 'B', '9', '6', '8', '2', '8', '1', 'E', '0', '9', 'E',
    '6', '4', '0', 'E', '1', 'B', 'D', '0', 'F', '5', '8', '8', 'E', '4', 'E', '4',
    '7', '9', '9', 'D', 'E', '2', 'D', 'D', 'E', '2', 'E', '9', '9', '3', '9', '7',
    '9', 'F', '9', '0', 'B', '2', 'F', '8', 'E', 'F', '5', '1', '8', '5', '1', 'B',
    '9', 'A', '8', '8', '4', '4', '8', 'B', 'E', 'D', 'C', 'F', '2', '2', 'B', 'F',
    '2', '8', 'E', '2', '9', '8', '6', 'C', '3', 'F', '0', 'F', '3', 'B', '5', 'B',
    '3', '4', '3', '5', '0', '2', '5', '8', '1', 'B', '6', 'A', '1', 'D', '9', '5',
    '0', '8', '7', 'E', '3', '0', '5', 'E', '7', '4', '6', '0', '8', 'C', 'E', '9',
    'C', '0', 'B', '4', 'F', '6', '5', '8', 'E', 'B', '2', 'D', '8', 'C', '2', '6',
    'B', '5', '0', '4', '2', '5', '7', '9', 'E', '4', '2', '2', 'E', '0', 'B', 'D',
    'F', 'C', '9', 'D', 'C', 'E', '0', '8', 'B', 'B', '1', '8', 'C', 'E', '9', '8',
    '0', '4', '0', '5', '6', 'D', '4', '2', 'E', '3', '1', '5', 'B', '8', '8', 'D',
    '0', '5', '0', 'C', 'D', '6', '2', 'B', '0', 'E', '7', '8', '9', '9', 'E', '4',
    '7', 'E', '8', '5', '6', '0', '8', 'C', '6', '2', 'A', '8', '4', 'D', 'B', '6',
    '8', '5', '5', '5', 'C', '7', 'E', '9', '6', 'A', '1', '8', '3', '7', '3', '8',
    '8', '1', '9', '5', '6', 'B', 'F', 'A', '5', 'F', 'E', '9', '1', '9', '8', '1',
    'A', '3', '8', '3', 'C', '7', 'A', 'A', 'E', '3', '3', '4', 'A', '0', '7', 'F',
    'B', '7', '3', '0', 'D', '2', '0', 'D', '8', '0', 'E', '8', '2', '2', 'A', '9',
    '0', 'E', '4', '8', '2', '3', '3', '6', 'A', 'B', '1', '4', '1', '9', '0', '4',
    '0', '5', '1', '8', '5', '4', '6', '4', '3', '3', '3', '5', 'F', 'F', '2', '9',
    'E', '4', 'C', '5', '1', '0', '7', '9', '8', 'E', '3', '0', '9', '3', '9', '3',
    'B', '9', '6', 'E', '8', 'E', '5', 'B', 'A', '2', 'B', 'E', '7', '3', '0', '4',
    '9', 'A', 'B', '5', '7', 'A', '4', '0', '6', '7', '6', 'D', '4', 'D', '6', '4',
    '4', '7', '7', '5', 'C', '9', '4', 'C', '3', '5', '6', '1', '8', '3', 'D', 'D',
    '9', '3', '4', '8', 'E', 'A', '5', 'B', '5', '5', 'A', 'A', 'E', '4', '4', '3',
    'D', '4', '8', '2', 'C', 'C', '5', '3', '3', 'E', '6', '0', '4', '4', '9', '9',
    'F', '0', 'C', 'B', '3', '4', 'C', '9', '3', '3', '9', 'D', '3', '3', '3', '6',
    '6', 'E', '6', '4', '1', '4', '9', '0', 'E', '0', 'E', '0', '3', '2', '7', '2',
    'D', 'B', 'E', '7', 'A', '3', '7', 'E', 'F', '4', 'B', '1', 'B', 'B', 'B', 'D',
    '5', '4', 'A', '0', '4', '2', '7', '5', '8', '4', 'C', '9', 'B', '9', '0', '0',
    '2', '4', '6', '9', 'C', '2', '3', 'C', '4', '4', '9', '7', 'C', '4', '0', '3',
    '9', '1', '5', '3', '9', '0', '9', 'B', 'F', '2', '1', 'F', 'C', '0', '1', 'B',
    '9', 'C', '1', '2', 'D', '1', '5', 'E', '6', '3', '9', 'A', '4', 'E', '0', 'A',
    'D', 'A', '5', '0', 'C', '3', 'B', 'F', '5', '9', '8', '2', '9', '5', 'E', '3',
    '1', '8', '7', 'E', '1', 'A', 'B', '6', 'B', 'D', 'B', '4', '7', '1', '8', '4',
    'B', '7', '0', '0', '7', '6', '3', '2', 'B', '1', 'B', '8', 'F', '0', '2', '0',
    '4', 'D', '1', 'F', '7', '2', '0', 'C', 'D', 'C', 'A', '4', 'D', '4', 'C', 'E',
    '4', '5', 'B', '7', 'C', 'D', 'D', '9', '1', '7', 'B', '8', 'D', '8', 'A', '6',
    'E', '0', '2', 'E', '7', 'F', '8', 'D', 'C', '6', 'E', 'E', '7', '7', '1', '8',
    '3', '9', '9', 'D', '4', '6', '8', 'C', 'B', '7', 'B', '7', 'B', '3', 'C', 'B',
    'A', '0', '1', '5', 'B', '1', 'B', '9', 'F', 'F', 'D', '6', 'F', 'F', 'A', 'B',
    '6', '4', 'B', '3', '8', '6', 'B', '3', '4', '7', '4', '2', '7', 'F', '9', '7',
    'B', '7', '8', 'A', '2', '1', '1', '8', 'A', '3', '4', '4', 'F', 'B', '2', 'A',
    '0', 'B', '2', 'A', 'D', '9', '5', '6', '7', '2', '5', 'E', 'B', '8', '5', '7',
    '1', 'B', '9', '8', '0', '4', 'B', '4', '9', 'C', '9', 'D', '6', '1', '6', 'A',
    '3', '2', 'D', 'A', '0', '1', '5', 'D', '1', 'F', '2', '2', 'B', 'A', '0', '0',
    '8', '8', 'B', 'F', '4', '1', '4', '0', '3', '5', '7', 'D', '5', '6', '7', '0',
    '1', '3', '2', 'E', '3', '4', '8', '9', '9', 'E', '0', '9', '8', '6', 'D', '8',
    '9', '7', 'F', 'C', 'E', 'F', '7', '6', '1', '3', '5', 'D', '9', 'C', '6', '5',
    '4', '0', 'E', '9', 'F', '5', 'D', 'D', '5', '8', '3', 'D', 'E', 'F', '2', '7',
    '3', '4', '9', '6', 'A', 'B', '6', 'F', '8', 'D', '1', 'F', '8', '0', '0', 'B',
    '0', '5', 'F', '2', '9', 'C', '3', 'E', '7', '8', 'B', 'F', '3', 'C', '1', 'C',
    '5', '1', '8', 'E', '9', '8', 'B', '3', '4', '1', '2', '1', '2', '1', '0', 'C',
    '2', 'D', 'B', 'E', '9', '2', 'C', '5', 'C', '8', '5', 'C', '9', '8', '6', 'D',
    '5', '2', '8', '8', '3', '2', 'A', '0', 'E', '7', '9', 'B', 'A', '2', '2', '1',
    'D', '5', 'E', 'D', 'C', '3', 'B', 'D', '4', 'C', '3', 'F', 'E', 'F', '0', '9',
    'F', '8', 'B', '0', '5', 'B', '7', '3', '3', 'A', '1', '7', '3', '2', '8', '8',
    '8', '6', '7', '6', '6', 'F', 'C', 'D', '5', '4', 'D', '9', 'F', 'D', 'A', '9',
    '2', '8', '4', 'B', 'A', '9', '2', 'B', '4', 'F', 'B', '2', 'D', '7', 'D', 'D',
    'C', '2', '4', '2', '7', 'E', 'F', '8', 'F', '7', '8', '3', '7', '3', '6', 'A',
    '0', '8', '7', '1', '8', '3', '4', '0', '5', 'D', '6', 'C', '2', '0', '0', 'C',
    '4', '4', '2', '0', '0', '6', '1', '7', '3', 'F', '9', 'D', '1', '3', 'E', 'A',
    '4', '6', '0', 'A', '6', 'A', '3', '6', 'A', 'E', '4', '5', 'D', '5', 'D', '4',
    '4', '8', '8', 'F', '2', '7', 'A', '7', 'E', 'C', '2', '3', 'F', '5', 'B', '4',
    'C', '1', 'E', 'F', 'F', 'C', 'F', '7', '3', '7', '9', '7', '2', 'A', '6', 'C',
    '8', '2', 'B', '3', 'C', '3', 'D', '1', '3', 'F', 'C', '1', '6', 'F', '0', '2',
    '3', 'E', '5', '3', '8', '8', 'B', 'E', '9', 'B', 'F', '1', '7', '3', 'A', '6',
    '5', '9', '5', '5', 'D', '2', '9', 'B', '7', '9', '1', '6', '3', '4', '5', '8',
    'F', '2', '2', 'E', '0', '9', '6', 'E', '0', '2', '9', '3', 'D', '8', '2', '0',
    '3', 'F', '1', 'D', 'F', '5', '6', 'F', '6', '8', '3', 'F', '0', 'F', 'A', 'F',
    '4', 'B', '1', '7', 'C', '0', '8', '0', 'E', 'D', 'F', '9', '6', 'C', 'B', '3',
    '6', '2', '0', 'A', '4', 'B', '6', 'B', '9', 'E', '0', '2', '5', '6', '9', '8',
    'D', '4', '0', 'D', '3', '9', 'A', '0', 'B', '4', '1', '5', 'B', '4', 'D', '7',
    '9', '2', '2', '6', 'A', 'E', '5', '3', 'C', 'D', '9', '4', 'B', 'E', '8', '4',
    'C', '8', '3', 'C', '2', '9', 'B', 'D', '3', 'C', '5', '6', '7', 'D', '1', '9',
    '4', 'D', 'D', 'F', '0', '8', '3', '1', '0', '3', '2', '2', 'A', '7', 'F', 'F',
    'C', '1', 'A', 'F', 'D', '0', 'F', '9', '3', 'A', '5', '2', '1', '5', 'C', 'E',
    'F', 'C', '1', 'E', 'A', '4', '6', 'F', '5', '8', '4', 'E', '2', '6', '2', '5',
    'C', '0', '1', '8', 'A', 'D', '8', 'D', '8', '2', 'C', 'A', 'E', '2', '1', '7',
    '8', '3', '0', '0', '5', '1', '4', 'A', '3', 'B', '3', '2', '1', '7', '0', '2',
    '8', '1', '6', '8', '0', 'E', '4', 'B', '0', 'E', '5', 'C', 'C', '2', '1', 'A',
    '1', '2', 'F', '2', 'F', '7', '8', '5', '6', 'D', '5', '4', 'E', '8', '4', '6',
    '7', '1', '6', 'F', '3', '0', '9', 'F', '8', '8', 'E', 'F', '4', '4', '1', '3',
    '8', '5', '3', '2', '5', 'F', '0', 'C', '2', '0', 'E', 'B', '5', 'B', 'D', '7',
    '6', '0', '7', 'A', '0', 'D', 'D', '6', 'A', '4', '8', '2', 'D', '8', 'A', '4',
    '6', '7', '4', 'C', '2', '2', '7', '1', '9', 'C', 'A', '3', '7', '6', 'F', '0',
    'A', 'B', '8', 'E', '0', 'C', 'A', 'A', 'E', '6', 'D', 'E', '4', '5', '4', 'D',
    '5', 'C', 'D', '7', '1', '3', 'E', '9', '9', '6', 'B', 'B', '2', '1', '9', '2',
    '7', '8', '1', '7', 'B', '3', '3', '0', '0', '5', '6', 'D', 'A', '4', '7', 'B',
    '7', '1', '0', '1', '0', '0', '0', '8', '8', '1', '7', '1', '8', '2', '6', '8',
    'A', 'F', '2', 'E', 'F', '8', 'A', '5', '4', '7', 'F', '3', '3', '7', '7', '0',
    '3', 'B', '6', 'C', '3', '4', '3', 'C', '0', '0', '2', '1', '4', '2', '3', 'A',
    '4', 'F', 'D', 'C', 'B', '0', 'C', '4', '8', 'C', '6', '6', '5', '4', '2', '8',
    '5', '7', 'E', '9', '0', '5', 'C', '1', '8', '9', '7', 'B', '0', '9', '7', '8',
    '2', '9', '1', '1', 'B', 'B', '0', '2', '4', '8', '4', '9', '9', '3', 'C', 'B',
    '6', '7', 'A', 'E', 'A', '6', '4', '8', 'A', 'B', '4', 'C', '3', 'C', 'F', 'B',
    '2', '8', 'E', '8', 'C', '4', '8', '4', 'E', '9', '2', 'B', '7', '9', '8', 'F',
    '8', '1', '8', 'E', '8', 'F', 'D', '3', '7', 'D', '2', '4', '5', '9', 'F', 'C',
    '0', '0', '3', 'F', '0', '4', '8', '4', '3', '2', 'A', 'A', 'B', '2', '3', '4',
    '1', 'C', 'A', 'E', '8', 'E', 'E', '7', '3', '2', 'F', 'B', '8', '9', '1', '0',
    'B', '2', '9', 'E', '2', '7', 'C', '3', '2', 'E', 'A', '0', '1', 'C', '0', '2',
    'C', '6', '7', '4', 'B', 'E', 'D', 'A', '3', '4', '9', 'D', 'A', 'B', 'E', '6',
    '6', '5', '1', '7', '1', 'F', 'C', '9', 'A', '8', '4', '1', 'A', '3', '4', '1',
    '6', '2', 'E', 'C', '2', '4', '2', 'D', 'F', '0', 'B', '7', '6', 'B', 'D', '5',
    '9', 'C', '4', 'B', 'B', 'A', '2', '2', 'C', '9', '5', '9', 'F', '5', '9', '7',
    '6', '7', 'C', '6', '9', 'E', '1', 'A', 'A', '8', '6', 'B', '8', 'B', 'D', 'D',
    'A', '4', '6', 'D', 'E', 'C', 'A', 'A', '2', 'A', '5', '0', '4', '9', 'A', '7',
    'B', '9', '7', 'D', '9', 'D', '8', '5', '0', 'B', '1', '8', 'F', 'E', '2', '1',
    'B', '5', '1', 'F', '1', '6', '9', 'B', '3', '3', 'C', '5', '5', 'C', '6', '7',
    'E', '8', 'A', '9', '6', 'F', '1', 'E', '6', 'A', '0', 'C', 'F', 'F', '4', 'C',
    'A', 'A', '3', '1', '1', '4', 'C', '4', 'A', '5', '9', '0', '6', 'D', 'A', '8',
    'D', 'F', 'C', '1', 'C', '0', '9', '6', '6', '3', 'C', 'A', 'B', '5', '0', 'D',
    'E', 'D', 'A', '4', '8', 'D', 'C', 'C', 'A', '9', '3', '6', '5', '3', '1', 'D',
    '7', 'C', 'B', 'E', '0', '8', 'E', '0', '7', '9', '1', '3', 'F', '7', '1', 'F',
    '1', 'A', '7', 'C', 'D', '4', '6', 'A', '6', 'A', '8', '8', 'A', '1', '7', '7',
    '7', '2', '8', 'D', '8', '3', 'F', 'F', '7', 'E', 'C', 'E', '3', '0', 'D', 'F',
    '2', 'E', '1', '6', 'F', '5', '8', '3', 'C', 'F', '4', '8', '5', '4', '2', '9',
    '3', 'E', 'A', '8', '8', 'F', '9', 'B', '7', '8', '0', 'E', 'E', '6', '0', '2',
    '2', '2', 'B', '2', '5', 'D', 'B', 'E', 'F', '2', '5', '2', 'C', 'C', 'A', 'D',
    '7', '1', '3', 'B', 'B', '1', 'D', '4', '0', '6', '5', '5', 'D', '5', '6', '3',
    '9', '0', '5', '0', '5', '9', 'F', '2', '3', 'F', 'A', 'D', '9', 'B', '0', '3',
    'F', '8', '4', 'F', 'E', 'E', '2', '6', '9', '7', '1', '9', '0', 'B', '7', '2',
    '7', '6', '5', '2', '5', 'A', 'F', '3', 'F', '5', '3', 'F', '9', '6', 'A', '8',
    '4', 'C', '5', '1', '1', 'C', '9', '4', '1', 'D', 'F', 'B', '9', 'E', 'B', '2',
    'A', 'B', '3', '0', 'E', 'A', 'C', 'B', '9', '9', 'F', '9', 'C', 'A', 'E', '0',
    '3', 'C', 'C', '9', '4', 'B', 'A', 'D', '5', '8', 'B', '6', 'A', '0', '6', '3',
    'F', 'D', '1', 'B', '3', '6', 'D', 'F', '4', '6', '9', '5', '8', 'C', '8', '6',
    '6', 'F', '0', 'A', 'F', '0', '9', 'D', '6', 'A', 'F', 'C', 'E', '7', 'B', '3',
    'A', '2', '8', 'C', '8', '5', 'C', '0', '4', 'F', '6', 'F', 'D', '0', 'B', '3',
    '1', 'B', '9', '6', '4', '9', '6', 'C', '3', '2', 'F', 'A', 'F', '8', '6', '0',
    'C', '4', 'F', 'E', 'D', 'A', '0', '0', '9', 'F', '7', '1', '7', 'B', '8', 'D',
    'F', 'E', 'C', 'B', '8', 'B', '4', 'B', '9', '9', '4', 'D', 'B', 'C', '0', 'C',
    'B', '1', '4', '2', '9', 'A', '8', 'F', '0', '6', '9', '4', '2', 'F', 'B', '7',
    '0', '9', '8', '9', '3', 'C', '2', '9', '2', '2', '6', '0', 'B', '5', '0', 'C',
    '4', '0', '1', '4', '3', '4', 'D', 'B', 'B', '9', '2', '1', '9', '7', '1', 'B',
    '7', '2', '5', '5', '5', 'B', '7', '9', '1', '4', '1', '8', '9', '4', 'B', 'C',
    '9', 'F', 'E', '4', 'A', '0', '5', 'B', '5', '4', '4', '3', '1', 'C', '6', 'D',
    '6', '0', '2', 'B', 'D', '1', '3', '6', 'D', 'E', '8', '6', '1', '5', 'D', '5',
    'F', '6', 'A', 'F', 'B', '3', '2', '1', 'C', 'E', 'E', '0', 'C', '5', 'B', 'D',
    'D', 'F', '4', '4', 'B', 'E', 'E', '3', '0', 'D', 'F', 'D', '7', '5', '1', 'C',
    '2', '2', '2', '2', 'C', '7', '3', 'A', '7', '8', '0', 'D', 'D', 'F', '4', 'B',
    '5', 'E', '0', '7', 'E', 'C', '2', 'D', '1', 'B', 'F', 'A', '5', '0', '9', '8',
    'A', '0', '4', 'E', '5', 'D', '4', 'A', 'C', '2', 'F', '1', '8', '2', 'C', '6',
    '8', '8', '0', 'F', '5', 'B', '7', '2', 'E', '1', '2', '7', '6', '4', '2', '2',
    'F', 'F', '4', '4', '1', 'E', '4', '3', 'B', '9', '7', 'C', 'D', 'F', 'A', '6',
    '6', 'C', '5', '4', 'A', '6', 'A', '1', '1', '4', '3', 'F', '5', '0', '7', '7',
    '0', '7', '8', '6', 'F', 'C', '5', '4', '8', '9', 'C', '1', '9', 'B', 'D', 'E',
    '9', 'B', 'F', 'C', '2', '0', '3', '5', 'D', '5', 'E', '8', '2', '2', '3', '0',
    'A', 'E', '7', '4', '5', 'A', 'C', '5', '2', '5', 'E', 'F', 'F', 'D', '7', 'B',
    'C', '0', '7', '7', '7', '8', 'F', '0', 'A', '7', 'E', 'B', 'A', '9', 'E', '6',
    'D', 'E', '8', 'E', 'A', 'F', 'F', 'A', '9', '2', '1', '0', '3', '9', '0', '1',
    'C', '2', '5', 'D', '4', '3', '2', '6', '6', '1', '1', '7', 'A', '1', 'F', 'C',
    'C', '6', '2', 'F', '6', '6', '0', 'B', 'A', 'A', '0', '8', '2', 'E', '3', 'F',
    '3', 'B', '5', '8', '1', 'B', '9', '8', '8', '1', '6', '1', '9', '4', 'B', '9',
    '5', 'D', '7', '1', '3', '5', 'E', 'C', 'E', '6', '7', '8', 'F', '6', '3', '0',
    'C', '1', '3', 'F', '9', 'F', 'B', '6', 'F', 'B', '6', '0', '9', 'A', 'F', 'F',
    'A', '2', '2', 'E', '0', 'A', 'A', 'F', 'E', '7', 'C', '6', '5', '6', '9', 'E',
    'A', 'C', 'B', '4', 'E', 'D', '5', '8', '9', '4', 'A', '2', '1', '3', '3', 'F',
    'F', 'F', '7', '4', '8', 'D', 'C', '8', '3', 'E', '7', '2', 'B', '2', '5', '4',
    'A', '8', '2', 'D', '4', 'D', '7', 'F', '3', 'D', 'C', 'C', '7', '8', '2', 'A',
    '6', '7', '8', '9', '7', 'F', '1', 'E', '9', '1', '5', 'C', '2', '3', '8', 'D',
    '6', '8', '5', '2', '4', 'A', 'C', '3', 'A', '0', 'A', '1', '9', 'C', '1', '5',
    'A', '2', 'A', 'E', 'D', 'F', 'B', '1', 'F', 'C', '4', '0', 'C', '2', '1', '9',
    '7', '3', 'E', '5', '0', 'D', '0', '9', 'D', '9', '5', '9', '7', 'E', '6', 'A',
    '7', '8', 'A', '3', '6', 'E', 'D', '9', '1', '5', '0', 'A', 'E', 'D', '3', '5',
    'C', 'A', 'E', '4', 'A', '8', '9', 'A', '3', '0', '7', '0', '8', 'C', '0', '4',
    '6', 'A', '8', 'B', '6', 'A', 'E', '5', '6', 'B', 'F', 'A', 'E', 'C', 'F', '4',
    'D', '3', 'B', '5', 'D', '1', '6', '5', '6', '2', '8', '2', '7', '0', '5', 'D',
    '2', '4', '3', 'D', '4', 'B', 'A', 'A', '0', '2', '7', '8', '7', '2', '9', '2',
    '7', 'E', 'A', 'C', 'F', '0', 'C', '3', 'B', 'E', 'F', '5', 'D', 'F', '5', '2',
    'D', 'B', '8', 'A', 'B', 'F', 'A', 'A', '3', '6', 'E', '0', '4', 'B', '3', '5',
    '3', 'E', '7', '1', 'B', 'D', 'A', '3', '7', '9', '7', '4', 'A', '2', '0', 'E',
    '4', '3', '6', 'F', 'B', 'F', '5', '7', '4', 'F', '2', 'A', 'B', '1', '8', '5',
    '7', '8', '9', 'C', '8', 'F', 'F', '0', '5', '3', '2', '1', '7', '3', 'D', 'C',
    'B', 'A', '8', '1', '0', 'C', '5', '3', '2', '6', '7', '9', '6', '4', '5', '0',
    '0', '1', '5', '3', '2', '6', '7', 'B', '8', '4', '4', '8', '0', '3', '2', 'F',
    '1', 'C', '5', 'F', '4', 'C', 'C', '9', 'C', '9', 'D', 'D', 'C', '0', 'D', '4',
    '0', '9', '7', 'C', 'F', '6', '8', 'A', '0', 'F', '4', 'B', '6', 'E', '1', '4',
    '7', 'C', 'D', 'F', '9', 'D', 'A', 'C', 'E', '3', '2', 'E', '9', '7', 'C', '4',
    '1', 'A', '4', '6', '3', '3', 'E', 'D', '5', 'A', '8', '1', '1', '4', 'E', 'D',
    '5', 'E', '5', '8', '2', '3', 'A', '5', 'F', '7', '1', '7', 'E', 'F', '8', '1',
    '0', '3', 'C', '9', '5', '7', '2', 'A', 'D', 'F', '7', 'C', 'C', '6', 'F', '4',
    '6', '9', '3', '1', 'A', 'D', '1', '9', 'E', '0', 'B', 'C', '2', '8', '6', '4',
    'E', 'F', '3', '8', '4', '5', 'C', '4', '4', '9', '6', '0', '3', '3', '1', 'D',
    '8', '4', 'C', '2', 'E', '4', '7', '2', '1', '5', '1', 'C', 'D', 'B', 'C', '2',
    'F', 'D', 'B', 'C', '5', '0', '2', '9', '6', 'E', 'A', '4', 'E', 'D', 'C', '5',
    '9', '3', '0', '9', '5', 'B', 'C', 'A', '4', '4', '2', '4', 'C', '7', '5', 'B',
    '7', 'D', '4', '7', 'E', 'D', '5', '4', 'C', 'D', '1', '5', 'D', 'C', '9', 'F',
    '4', '8', 'E', '6', '7', '7', 'A', '4', 'A', 'C', 'B', 'E', 'C', '3', '9', '7',
    '9', 'D', '6', 'F', '9', '2', 'A', 'C', 'F', '0', '5', '1', '0', '6', '3', 'B',
    '3', '0', 'F', '6', '5', 'B', '6', '6', '9', 'F', 'A', '3', 'F', 'B', 'E', 'B',
    'C', 'F', '6', '5', 'B', '7', '4', '8', 'B', '1', '7', 'C', 'B', 'B', '6', '1',
    'D', '6', '8', '8', 'B', 'C', '7', 'A', 'E', '4', '1', 'C', '5', '7', '2', '1',
    'C', 'A', '2', '6', '1', 'F', '9', '6', '5', 'C', '2', '3', '7', 'A', '5', 'D',
    '5', 'A', '4', '9', 'D', '5', '2', '5', '9', 'F', 'A', 'D', 'D', '8', '8', '0',
    '6', '0', 'D', '6', 'A', 'C', '0', '6', 'E', 'B', '0', '3', 'C', '0', '3', '2',
    '5', 'D', '9', '4', 'B', '6', '3', '1', '4', '9', '6', '7', '6', '0', 'A', '5',
    '6', 'A', 'B', '5', 'A', '1', '4', '9', '0', '4', '2', 'B', '8', '4', 'A', '8',
    'F', '7', '0', '1', 'D', '6', '7', '2', '7', '9', '4', '9', 'A', 'F', '8', '0',
    '7', 'A', 'A', '0', 'D', 'F', '3', '0', '3', '7', '8', '0', '7', 'C', '3', '6',
    '5', '2', '1', '6', 'B', '6', 'D', 'D', '5', '4', '5', 'E', '4', 'B', '0', 'A',
    '8', '5', '5', 'B', 'F', '7', '1', 'F', '9', 'E', '4', '8', '2', 'A', '2', '7',
    'C', 'E', 'F', '7', '1', 'C', '1', 'E', 'D', '6', '3', '3', '1', 'F', '4', 'F',
    'C', 'E', '5', '0', '1', '2', '7', '9', '8', '2', 'E', '7', '2', 'A', '2', '8',
    '6', '7', '8', 'C', 'D', 'F', 'C', '3', '6', 'A', 'A', '1', 'A', 'B', 'E', '2',
    '4', '8', 'D', '6', '7', 'C', '1', '8', 'E', '9', 'E', '9', '3', 'A', 'E', 'D',
    '0', 'C', 'E', 'F', '2', '8', '8', '0', 'A', '7', 'D', 'D', '1', 'E', 'E', '3',
    '5', '7', 'C', '4', 'D', '2', '4', '7', 'D', 'C', '3', '9', '8', 'E', 'A', '6',
    'A', '7', '0', '1', '4', '3', '2', 'D', '1', '9', 'F', 'E', 'C', '4', 'F', '0',
    'B', '5', 'A', '7', '2', '6', 'D', 'C', '1', '6', '0', '0', '8', '6', '6', '9',
    'B', '6', '4', 'E', '3', '2', '8', 'D', '6', '6', '4', 'F', '6', 'D', '4', '3',
    '9', 'E', '5', 'D', '2', 'A', '0', '0', '0', '2', '9', 'A', '0', '9', 'E', 'B',
    '9', '9', '7', '0', 'C', '1', '6', '1', 'C', '9', '6', 'A', '4', '2', 'D', 'E',
    'A', 'E', 'D', 'A', '5', '5', 'E', 'D', 'E', 'C', 'D', 'D', 'F', '4', '9', '1',
    '0', '2', '7', '8', '2', 'A', '4', '7', '7', '0', 'C', '4', '6', 'C', 'B', 'A',
    'A', 'F', 'B', '6', '9', '4', '9', 'D', '1', '3', '9', 'A', '2', '6', '8', 'D',
    '9', '2', 'F', 'B', 'F', '6', '1', 'B', '0', 'D', '1', 'F', 'D', '1', '3', '6',
    'B', '1', '8', '0', '6', 'D', '0', '3', '6', 'A', '3', 'F', '6', '3', '6', '5',
    'D', '7', '2', 'A', '2', 'E', '0', '6', '6', 'D', '4', '4', '6', 'D', '9', '7',
    '4', '1', 'B', '7', '0', 'E', '9', '7', '7', 'D', '9', 'E', '8', 'A', '9', '4',
    '8', 'C', 'C', '7', 'C', 'D', '8', '4', '4', 'A', 'E', 'D', '7', '1', '3', '6',
    'B', '8', '8', 'D', '5', '2', '8', '0', '8', 'A', '6', '1', '7', '8', '1', '1',
    'F', '3', 'D', '9', '3', '0', '8', 'F', '3', '4', '6', 'B', '4', '1', '2', '4',
    'B', '9', 'D', 'F', '8', '2', 'D', 'E', 'A', '2', 'D', '2', 'B', '8', '3', 'A',
    'D', 'B', '9', '9', 'C', '4', 'E', 'D', '3', '6', '4', '0', '4', '4', '2', '1',
    '3', '2', '4', '7', '4', 'D', 'D', '9', 'F', 'E', 'A', '3', '7', 'A', 'B', 'B',
    '3', 'F', '8', '0', 'E', '2', '1', 'D', '6', 'B', 'C', '8', '8', 'D', '8', '0',
    'A', 'D', '2', '4', 'D', '9', 'D', '9', '9', '8', '0', 'A', '7', '8', '3', '6',
    '3', '9', '5', 'A', '4', '5', '4', '3', '0', 'F', '9', '2', '8', 'C', '4', 'E',
    'D', 'A', '4', '8', '7', 'B', 'E', 'A', 'F', '1', '1', 'D', '5', '1', '2', '3',
    'A', '8', 'C', 'A', '2', 'F', '5', 'D', '9', 'D', '2', '7', '5', 'F', '1', '6',
    'B', '6', 'A', '2', '6', 'C', '6', 'E', '9', '3', '2', '4', '5', '6', '3', '0',
    '9', '2', 'E', '9', '9', 'F', '5', '7', '9', '4', 'C', '9', '4', '1', 'C', '6',
    '1', '9', '2', 'B', 'C', '4', '8', '5', 'B', '8', '8', 'F', '6', '0', 'E', '8',
    '2', 'E', '4', '6', '8', 'C', '6', 'D', '6', '5', 'A', '7', '7', 'F', '4', '1',
    'A', '9', '8', 'C', '5', '4', '5', 'C', 'C', 'C', 'E', '8', '4', '6', '0', 'E',
    'E', '5', 'B', '5', 'C', 'B', '4', 'B', '3', '7', 'A', '5', 'A', '6', 'D', 'D',
    'D', '4', '0', 'F', '9', '5', '6', '7', 'D', '7', 'A', '7', 'E', 'D', 'D', '2',
    'E', '3', 'E', '4', '8', '5', '5', '0', 'E', 'F', 'D', 'C', 'A', '7', 'A', '6',
    'D', 'D', '9', '9', 'A', 'A', '4', '3', '1', 'E', 'C', '1', '5', '9', '2', '3',
    '6', 'F', '3', '4', '4', 'E', 'D', '5', 'F', '3', '0', '1', 'A', '2', '1', 'D',
    '5', '5', 'C', 'D', '1', '5', '3', '3', 'C', 'D', '9', '0', '9', '6', '0', '6',
    'B', 'E', '0', '9', '5', 'C', '4', 'F', '9', 'F', '8', '8', '1', '5', 'F', 'B',
    'C', 'E', 'C', '4', '6', '7', '1', '1', '3', '1', '4', '9', '3', '5', 'E', 'B',
    'C', '3', '7', 'C', 'E', '7', '1', 'D', '1', 'C', '6', 'D', '4', '8', '4', 'B',
    '5', 'F', 'F', '1', '2', 'E', 'E', '0', 'E', '0', '6', '8', 'D', '9', '3', '9',
    'C', '7', '0', '1', '8', 'F', '8', 'A', '7', 'F', '0', '2', 'C', '8', 'C', '4',
    '8', '0', 'C', '7', '1', '3', '6', 'B', '8', '9', '4', '2', '5', 'E', '6', '1',
    '2', '3', '0', '3', 'A', 'B', 'A', 'D', '6', '4', 'E', 'F', '1', 'D', 'C', '3',
    '9', 'F', 'C', '4', '0', 'B', 'A', 'D', '1', '2', 'E', '4', '6', '4', '7', '3',
    '5', '7', '0', '9', '1', '4', '5', '3', 'E', '6', '6', '5', '6', '0', '9', '3',
    '9', '6', 'D', 'B', 'E', '0', '5', '0', '4', '6', 'E', 'F', 'D', 'C', 'D', '9',
    'D', '6', '6', 'B', 'C', '5', '8', 'D', '4', 'B', '7', '5', '0', '2', 'A', 'E',
    '7', 'D', 'C', '7', '1', 'C', '6', 'B', '2', '9', '9', '1', '5', '8', 'A', '2',
    '8', '0', '0', 'C', 'E', '2', 'F', '0', 'B', 'D', 'B', '2', 'E', 'E', '0', '1',
    '5', '3', '9', '5', '1', '7', 'F', '6', 'E', '2', 'F', '2', '2', '8', 'C', 'B',
    'C', '0', '0', 'A', '1', '4', 'A', 'D', 'F', '7', '7', 'B', 'D', '9', '4', '7',
    '7', '9', '1', '4', '9', '3', 'A', '1', '9', 'F', 'D', '5', 'B', '6', '1', '4',
    '3', '9', '7', '4', '8', 'E', '0', 'B', '1', 'C', '3', '5', '7', 'C', 'C', 'C',
    '2', '3', 'D', '9', 'C', '1', '7', '6', '3', '9', '2', 'B', 'F', 'D', 'C', 'E',
    '1', '6', '0', '4', '7', 'B', '0', '1', '4', 'D', 'E', '2', '8', 'B', '5', 'E',
    'D', '7', '4', '9', '5', '9', 'B', 'B', '0', 'D', '9', 'A', 'A', '3', '3', 'B',
    '9', 'D', 'D', '5', '8', '4', '2', '5', 'A', '3', '6', '4', '4', 'E', '9', '8',
    '5', '8', '9', '6', 'B', '6', '8', '0', '8', '6', 'E', '1', 'E', '4', 'E', '3',
    '6', '4', '2', 'A', '7', 'C', 'F', 'C', '0', '4', '0', '3', 'C', 'C', 'C', '9',
    'E', '7', '5', '2', '9', 'D', '5', 'B', '1', '2', 'C', 'C', '1', '4', '3', '0',
    '9', '9', '6', '4', '6', '8', '2', '8', '8', '8', '6', '9', 'E', '7', '2', '1',
    'B', '3', '5', '1', '0', '1', 'F', '2', 'A', '0', '6', 'B', 'D', 'E', '8', '2',
    '2', '2', 'E', 'A', '5', 'F', '1', 'A', '1', '9', '4', '1', '9', '9', '8', '6',
    '2', 'F', '7', '5', '6', 'C', '3', '5', '3', '1', '5', '3', 'B', '7', '1', '8',
    'F', '8', '7', 'B', 'F', '1', '8', '1', '6', 'F', '1', '5', '6', 'C', '8', 'E',
    'F', '0', '7', 'C', '1', '8', '7', '2', '6', '0', 'A', '0', 'E', 'A', 'B', '2',
    '8', '4', 'B', '5', 'B', '2', '4', '6', 'D', 'A', '7', '3', '5', 'D', '7', 'B',
    'A', 'B', '4', '7', '9', '0', '9', 'D', 'B', '6', '7', '8', '5', '9', '0', '4',
    '5', 'E', '7', '0', 'C', '9', 'D', '0', '4', '9', 'B', '4', '0', 'B', '6', '2',
    '3', '9', '1', '5', '3', '1', 'F', '0', '9', 'E', '0', 'B', '8', '4', 'B', 'B',
    '1', 'B', '9', '1', 'B', '6', '6', '3', '2', 'B', 'D', '9', '7', '9', 'C', '8',
    '5', 'F', '2', '0', '9', '0', 'C', '0', 'F', '9', '3', 'C', 'B', '6', '5', 'B',
    '7', 'B', 'E', '1', 'A', '3', 'C', '4', '3', 'E', '0', '5', '2', 'F', 'D', 'E',
    '9', '9', 'C', 'D', '8', '1', '6', '8', 'E', '0', '0', 'D', '2', '7', 'D', '3',
    '6', '0', 'A', '4', '4', '9', 'C', '0', 'D', 'C', '9', '5', 'E', '4', '7', '1',
    '0', 'D', '6', 'B', 'C', '6', 'E', '2', '1', '4', '0', 'E', 'D', '6', '2', 'C',
    '2', '9', 'A', 'F', 'A', 'D', '1', '2', '4', '7', '7', '4', 'A', 'B', '0', 'D',
    '9', 'B', '9', 'B', '6', 'A', '1', '8', '1', '1', 'F', '7', 'D', '7', 'C', '1',
    '8', '2', '7', 'D', 'C', '1', '2', '6', '0', 'C', '1', 'F', '1', 'E', 'E', 'A',
    '6', '2', 'B', '4', '3', 'E', '4', 'D', '9', 'C', 'E', '7', '3', 'C', '4', '7',
    '4', '2', '6', '6', '3', 'A', 'E', '1', '9', '5', '4', 'D', '6', '4', '9', '5',
    '5', '3', '7', '5', 'E', 'B', 'E', 'C', '0', '3', '4', 'E', 'E', '5', 'B', 'F',
    '8', '7', 'F', '2', 'F', '9', 'F', '3', 'D', '1', '5', 'C', '3', '3', 'F', 'B',
    '6', '6', '3', '3', '0', '2', '7', 'F', '7', '3', '4', '6', 'B', '0', 'E', '6',
    'E', 'E', '7', '0', '9', 'C', '8', '0', 'B', '2', '6', '3', '4', '9', 'F', 'E',
    '0', '8', '0', '1', '7', '3', '9', '7', '1', 'D', '0', 'A', '6', '1', '4', '9',
    '9', 'C', '1', '3', 'E', 'A', '4', '3', '6', '5', '5', 'A', '8', 'E', 'E', '1',
    '8', '1', 'B', '6', 'E', 'B', '2', '1', 'A', '0', '3', '4', '1', '5', '7', '3',
    'A', '6', '5', '1', '7', 'E', '0', '7', 'E', '9', '9', 'B', 'B', '8', '0', 'B',
    '9', '7', '8', '1', '9', '7', 'B', '4', '3', '7', '6', 'A', '4', '9', 'D', '4',
    'E', '9', 'A', 'C', 'B', 'C', '0', '5', 'C', 'A', '9', '8', 'B', '7', '0', '9',
    '4', 'F', '9', 'C', 'B', '4', 'D', '6', '7', '9', '6', '1', 'F', 'E', '2', '2',
    '8', 'B', '8', 'C', 'E', 'A', '2', '5', '0', 'E', 'B', '5', '3', '6', 'A', '7',
    '3', '6', 'F', '7', '5', 'D', '6', '2', 'A', '4', '9', '7', '7', '2', '4', 'B',
    '0', '5', '5', '5', 'F', '8', 'E', '7', '8', '7', '8', '2', '4', 'E', 'D', '8',
    'A', '3', 'C', 'A', '2', '9', '0', 'B', '0', '8', 'C', '0', '6', 'F', '6', '9',
    '0', 'A', '4', '6', '7', 'A', 'C', '4', '8', '9', 'A', '5', '7', '7', 'E', '8',
    '1', 'A', '7', '0', '9', '0', '1', 'E', '5', 'A', 'B', 'E', '5', '7', 'E', '9',
    '0', 'A', '6', '5', '9', '4', '5', '1', '9', 'F', 'F', '5', 'A', '3', '6', 'E',
    'E', '1', '0', '2', 'E', 'D', '3', '2', '9', 'E', '0', '8', '2', '5', 'C', 'D',
    '6', '4', 'F', 'C', '9', '4', '5', '0', 'E', '6', '5', 'C', '5', 'A', 'A', '1',
    '6', '8', '8', '8', '3', 'D', '8', '2', 'A', '4', 'E', 'B', 'B', '6', '2', '1',
    'D', 'D', '9', 'C', '3', 'E', 'E', '9', '3', '2', 'D', 'B', '7', 'B', '3', '5',
    '7', 'D', 'A', 'A', 'B', 'C', '7', '9', '5', '2', '6', '4', '3', '3', '6', '2',
    '9', 'B', '8', 'B', '7', '7', '3', '5', 'F', '1', 'A', 'D', '0', '4', '0', '3',
    'D', 'F', '0', '6', 'B', '1', 'C', '4', 'A', '8', 'D', '3', '4', '0', 'B', '4',
    '2', '1', 'E', '0', '0', 'E', '6', '7', 'C', '4', '7', '3', 'C', 'F', '0', '7',
    'B', '2', '6', '5', '0', 'C', '7', 'B', 'A', '0', '4', 'C', '9', 'C', 'D', '1',
    '0', '3', '6', '2', 'E', '5', '5', 'B', '7', '6', 'E', '8', '5', '4', 'D', '3',
    '1', '3', '0', '8', 'F', 'B', 'C', 'C', '7', '9', 'C', '2', '8', '6', 'C', '9',
    'B', '4', 'A', '2', '7', '5', 'B', '4', '8', 'A', 'B', '6', '1', 'F', '7', 'D',
    '8', 'F', 'B', '7', '9', '6', '8', '0', '8', '7', '8', '9', 'C', 'E', '1', 'A',
    '9', 'D', '8', '6', '8', '3', '4', '9', 'E', '6', '7', '0', 'B', '6', 'C', '5',
    'E', 'E', '1', '7', '1', '9', '8', 'A', '1', 'F', '3', 'E', '9', 'A', 'A', '0',
    '6', '7', 'F', 'B', '9', 'B', '4', 'C', '6', 'B', 'F', '3', 'F', 'C', '6', '7',
    'D', '5', 'F', 'E', '5', '8', 'C', '3', 'B', '5', 'B', 'A', '4', 'F', 'F', '9',
    'F', 'A', 'B', 'B', 'E', 'E', '7', '3', 'D', 'B', '1', 'F', 'B', '6', 'A', '3',
    '6', '8', '3', '0', 'A', 'F', 'B', '1', '8', 'F', '0', '4', '4', 'E', 'D', '9',
    'F', 'C', '9', 'E', 'C', '4', 'D', 'B', 'B', '8', '4', '1', '3', '0', 'E', '6',
    'A', '3', '0', '6', 'E', '5', 'D', 'A', '6', '0', 'F', '0', '6', '7', '3', '0',
    'B', 'B', '2', '4', 'C', 'B', '4', 'D', '0', '1', '9', '7', '9', '4', '7', '5',
    '1', '3', 'A', '8', '0', '1', '9', '2', 'C', '7', 'C', 'C', '0', '6', '8', '6',
    'D', '0', 'D', '6', '0', '5', 'F', '9', 'E', '5', '7', '1', '6', '2', '9', '3',
    '9', '3', '2', 'D', '9', '9', '9', '2', 'E', '9', 'A', '9', 'A', '7', 'F', 'D',
    'C', 'E', '1', '4', '4', '3', '8', '1', 'D', 'C', '1', '2', 'F', 'F', '7', '4',
    '2', '7', 'B', '6', '4', 'D', '8', 'E', '7', 'C', 'C', '0', '1', '5', '6', '6',
    '8', 'E', 'B', '3', 'A', 'B', '8', '1', '2', '7', '5', 'F', '0', 'A', 'A', '0',
    '6', 'F', '1', '2', '5', 'B', '4', '5', '1', 'B', 'E', '2', '0', '5', '2', '2',
    'C', '2', '6', '1', 'F', 'C', 'D', '4', '1', '8', '5', 'E', '0', '5', 'A', '7',
    '0', 'F', '6', '6', '1', 'F', 'D', '4', 'B', '7', 'F', '5', '3', '1', '6', '7',
    '4', '5', 'D', '6', 'C', '1', '6', '2', 'E', '4', 'A', '5', 'D', '4', '3', '5',
    'D', 'B', '1', 'F', 'D', '0', 'F', '5', '2', 'F', 'C', '2', '6', '0', '3', '2',
    '6', '3', 'A', '2', 'D', 'D', '8', '2', 'C', '2', 'A', '9', '9', '7', '7', 'D',
    'C', '9', 'A', 'B', '1', 'B', '2', '7', '9', 'C', '3', '0', '3', '5', 'E', 'E',
    '2', '5', 'E', '3', 'E', '7', '5', 'A', 'E', '2', '0', '0', '7', 'D', '3', 'A',
    '9', '6', '3', '9', '5', '0', '9', '6', 'E', 'E', '8', '1', '2', 'B', '2', '5',
    '0', '7', 'E', 'F', 'C', '6', '3', 'A', '2', '2', '3', 'D', '1', '2', '6', 'F',
    '8', '4', '8', 'D', 'D', '4', '8', '3', '8', '7', '0', '2', 'B', '9', '1', '8',
    'C', 'B', '8', '8', '8', 'E', '5', 'C', '0', '0', 'C', '6', '1', '4', '4', 'A',
    '4', '4', 'E', '9', '5', '2', '7', '6', '4', '0', 'B', '8', '6', '9', 'A', '6',
    '4', '5', '9', 'F', 'C', '4', '3', '0', '8', '9', '8', 'D', 'F', 'B', '6', '8',
    '2', 'C', '2', 'B', '3', '6', '9', '8', 'E', '7', 'C', '2', 'A', '8', 'F', '1',
    '5', 'A', 'C', 'D', 'D', '7', '1', '8', '0', 'C', 'D', 'A', 'C', 'E', '4', '7',
    'A', '9', 'F', '5', '3', 'F', 'F', '4', '6', 'B', 'D', '2', 'D', 'D', '3', '8',
    '6', '4', 'F', '3', '3', '5', '7', '1', 'B', '4', '6', '6', '0', 'F', '1', 'E',
    '9', '5', '5', '7', '0', '4', '3', 'E', 'D', 'B', '3', '5', '8', '9', 'B', '4',
    '8', '6', '0', '1', '2', '1', '6', 'D', '6', '8', 'D', '0', '0', '3', '6', 'E',
    'C', '1', '4', 'F', '2', '3', '7', '3', '2', '6', '2', '2', '3', '6', '7', '7',
    '5', '5', 'F', 'E', '2', '6', '3', '2', '3', 'E', '8', '3', '9', 'E', 'A', '4',
    'A', 'C', 'D', '4', '8', '9', '7', '1', '9', '5', 'E', '8', '0', '2', '5', 'D',
    '4', '8', '5', 'D', '9', '4', 'B', '0', '9', '9', 'E', 'F', '4', '3', '3', 'A',
    '8', 'A', '0', '8', '8', 'B', '5', '6', '9', '1', 'D', '7', 'F', '4', '8', 'D',
    '5', '7', '3', '5', '2', '7', 'D', '0', 'B', '7', 'A', 'F', 'B', 'D', '7', '2',
    '4', 'F', '8', '5', '3', 'D', '1', 'D', 'C', '6', '2', '7', 'D', 'F', '7', 'B',
    '5', 'B', '2', 'D', '8', '5', '3', 'D', 'A', 'D', '0', '2', '6', '0', 'A', '6',
    '2', 'E', 'C', '2', '9', '7', 'C', 'B', '3', 'D', 'B', 'C', '8', '2', 'F', 'C',
    '8', '1', 'B', '7', 'D', 'A', '8', '5', '5', '5', '6', '6', '2', '9', '8', 'C',
    'E', '1', '0', '4', 'F', '7', '7', 'F', '0', '6', '8', 'A', 'A', '6', '9', 'A',
    'B', '2', '4', '7', '5', '6', '3', '5', '1', '3', 'C', '9', '3', 'D', '7', '5',
    '3', '5', '3', '4', '7', '2', '3', 'A', '6', '8', '2', '5', '8', '8', 'A', 'D',
    '5', 'E', '4', 'B', '1', '5', 'F', '2', 'F', '8', 'E', 'B', '0', '8', '1', '7',
    '9', 'F', '9', '2', 'E', '0', 'F', 'E', '0', 'B', 'B', '7', 'F', 'F', '8', 'A',
    '8', '8', 'C', '9', '4', 'D', '8', '5', '9', '2', 'E', 'C', 'C', '8', '7', 'E',
    '5', '5', '8', '7', '6', 'D', 'D', '4', '6', '9', '1', '9', '5', 'D', '2', 'F',
    '8', 'D', '8', '4', '7', '7', '1', 'E', 'A', '2', 'B', '3', '3', '8', '2', 'F',
    '5', 'C', '2', 'C', 'D', '6', '9', '6', '4', '9', '5', 'E', 'E', '3', '7', '1',
    '4', 'D', '9', '6', '4', 'B', 'E', '2', 'D', 'C', 'C', '7', '8', 'C', '9', '5',
    'F', 'B', 'D', '1', 'C', 'B', 'F', '1', '2', '2', '0', '1', 'F', 'A', '6', '9',
    '4', '9', '7', '7', '8', 'B', 'C', 'A', '0', '3', 'A', 'A', 'C', '2', 'C', '1',
    '5', '5', '2', '3', '0', 'F', '7', 'E', '0', '9', '6', '1', 'F', 'E', 'C', '2',
    '9', '2', '3', 'A', 'C', '0', '3', 'E', 'F', '4', '6', '4', '6', '6', '9', '8',
    '0', '3', 'C', '7', 'C', '2', '2', '4', 'B', 'E', '1', '4', '0', '9', '1', 'D',
    '8', '1', '4', '5', 'B', '4', '3', '7', '8', '1', '9', 'A', 'C', '0', '9', '3',
    '2', 'F', '9', '8', 'A', 'C', '6', 'F', 'B', 'B', 'E', '7', 'F', 'B', 'B', '0',
    '0', '5', '2', '0', '2', '6', 'A', 'E', '5', '2', '5', 'A', 'F', 'C', '4', 'E',
    'B', 'E', '1', '7', '6', '5', 'D', 'D', 'A', '1', 'B', '6', '2', '6', '1', 'A',
    'A', '7', '3', '4', '7', '8', '5', '2', 'A', 'D', '9', 'D', '2', 'D', 'F', '4',
    'F', '3', '5', '8', 'E', '0', '7', 'E', 'D', '7', '7', '2', 'F', '9', '9', '8',
    '3', 'A', '5', '4', '8', 'C', '0', '4', 'B', '9', 'E', '1', '3', '3', 'B', '0',
    'B', 'B', 'A', '2', '5', '7', 'F', '9', '5', '0', '1', 'D', '6', '9', '6', '3',
    'F', '7', 'D', '9', 'E', '9', 'E', '4', 'A', 'B', 'F', '3', 'B', 'E', 'D', '1',
    '2', '5', '5', '7', '7', 'B', 'C', '5', 'B', '7', '6', '0', 'F', 'E', 'E', '1',
    '0', 'D', '0', 'A', '0', '8', '6', '9', 'C', 'F', 'A', 'B', '5', '5', 'B', 'A',
    'E', '6', 'C', '3', 'B', '8', '6', 'C', '0', '4', 'A', '8', '5', 'A', '1', '9',
    '9', 'C', '5', '1', '1', '0', 'C', 'C', '6', 'B', '5', '4', 'C', '7', '2', '9',
    '4', '7', '6', 'E', '0', '0', '9', '8', '1', '2', '7', 'F', 'D', '4', '4', '2',
    '4', '5', '0', '5', '1', 'C', 'E', '0', 'B', 'A', '5', '5', 'C', '2', 'F', 'D',
    '8', '5', 'D', '0', '5', 'C', 'F', 'E', 'A', '6', 'E', 'A', '9', '5', 'C', 'F',
    '2', '4', '7', '1', '5', 'D', '7', 'D', '6', 'D', '6', '8', '2', 'D', '9', '5',
    '1', 'A', '4', 'B', 'F', '2', 'A', '1', '1', '6', '8', 'D', '2', '9', 'B', 'E',
    '5', '1', 'B', 'E', '7', '4', '1', '9', '4', '0', 'B', '9', 'E', '0', '4', '9',
    '9', 'F', '0', '4', '6', '4', 'F', '4', '1', 'D', '5', 'B', '7', 'A', 'F', '4',
    '5', '4', '4', '7', '6', '5', 'A', '9', '9', 'B', 'A', '0', 'B', '8', '3', '2',
    '0', 'A', 'E', '6', 'A', 'E', '0', 'F', 'B', '3', '0', '6', '8', '6', '2', '2',
    'E', '2', '6', 'B', '9', '2', 'C', '0', '7', '9', '5', '9', '5', '2', '6', '3',
    'C', 'C', 'F', '1', 'C', '1', '6', '2', '8', '7', '1', 'F', '9', '0', 'E', '5',
    '9', 'A', 'C', '7', 'B', '5', '7', '7', '3', '4', 'D', 'E', 'A', 'D', 'A', 'B',
    '6', '3', '2', 'F', 'C', '2', '0', '3', 'F', 'A', 'E', 'D', 'D', '5', '6', '7',
    '8', '0', '8', '5', '8', '3', '9', '4', 'B', 'B', 'A', '1', '2', '5', '9', '8',
    '3', '7', '4', 'E', '0', 'F', '6', '8', 'A', '2', '6', '0', 'E', 'D', 'D', '4',
    '1', '3', '8', 'C', '5', 'F', '0', '2', '7', '8', 'A', '0', '7', 'C', '6', '3',
    'A', '5', '0', '4', '9', 'F', '0', '3', '3', '7', 'E', 'F', 'A', '6', '1', '4',
    '5', '4', '7', '2', '3', '0', 'A', '2', '7', '1', '7', '3', '4', '2', 'F', '6',
    '7', '7', '0', '7', '4', '5', 'E', '5', '8', 'C', '3', '9', '9', '1', '3', '0',
    '6', '8', 'F', '6', '9', '5', '1', '0', '1', '2', 'E', '9', 'E', 'A', '6', 'D',
    '1', 'B', '5', '5', '9', '5', 'F', 'B', '3', '6', '2', 'B', '9', '7', 'D', 'E',
    'A', 'B', 'E', '8', 'F', 'A', '7', '7', '7', '8', 'E', '5', '7', 'B', '4', 'D',
    '6', 'F', 'A', 'C', '1', '6', '5', '5', '0', '8', 'F', 'C', '9', '0', '5', '7',
    '0', 'E', '2', 'F', '7', '1', 'A', '2', 'B', '9', 'A', 'A', '7', '8', 'E', '4',
    'A', '2', '0', '4', '3', '9', '3', '8', 'C', 'F', '7', '9', 'D', 'A', '6', 'F',
    '4', '2', 'D', '4', '3', 'D', '8', 'D', '1', '3', '1', 'B', '4', '4', '6', 'F',
    '2', '8', '7', 'A', '5', 'B', '0', '7', '0', 'E', 'F', 'D', 'C', 'D', 'B', '2',
    '5', '2', 'D', '8', '6', '9', '3', '0', '6', '4', '6', '3', 'B', '3', 'B', '7',
    '5', '8', '7', '9', '0', '8', 'C', '9', '3', '7', '8', '2', '9', '2', '9', 'F',
    '5', '9', 'C', 'B', 'F', '5', 'C', 'C', '3', '8', '1', 'E', 'C', '5', '9', '0',
    'C', '8', '8', '7', '6', '8', 'E', '8', '2', 'F', '8', 'D', 'F', 'F', 'B', 'D',
    '5', '4', '8', '1', '1', '9', '5', '8', 'A', '5', '6', '7', '2', '3', 'E', '6',
    'A', '7', '6', 'C', '4', 'F', 'E', '9', '4', '4', '4', 'B', '0', 'E', '2', '2',
    '8', 'E', 'F', '8', '8', '3', '3', '8', 'A', 'F', '1', 'A', 'C', 'C', 'B', 'B',
    'C', '9', '5', '6', 'D', '4', 'B', '5', '9', '4', '0', '0', '7', '6', 'C', 'F',
    '7', 'E', '3', 'D', '7', 'A', '0', '1', '9', '2', 'F', '4', '0', 'C', '3', '6',
    '2', 'F', 'F', 'C', '9', '2', '1', '1', 'C', '7', 'F', '9', 'B', 'A', '8', '6',
    'D', '3', '0', '7', '6', '9', '2', '4', '9', 'E', '7', 'B', '7', 'C', '5', 'D',
    '7', '9', '1', '6', 'C', 'B', 'B', 'C', '2', '7', '4', '0', 'E', '0', '5', '6',
    '4', '6', 'A', '7', '3', '5', '3', '7', '4', '8', '6', '6', '7', 'A', '7', '6',
    '8', '1', 'A', '7', '4', 'B', '4', 'E', '9', 'B', '0', '0', 'B', '6', '8', 'A',
    'F', '0', 'E', 'F', 'F', '7', '8', 'B', '2', '6', 'A', 'B', '3', '8', 'A', 'A',
    '2', '2', '4', '3', 'C', '6', 'B', '8', '6', 'E', 'F', '0', '4', '1', 'A', '9',
    '9', 'C', 'A', 'C', '0', '5', 'C', 'E', '0', 'F', '2', '8', 'E', '4', '7', 'B',
    'D', '6', '0', 'B', '8', '2', 'C', '9', 'D', 'A', 'A', '1', '3', 'F', 'B', 'A',
    '5', '6', '4', 'B', 'D', '4', 'B', '1', '1', 'D', 'E', '5', '4', 'B', '5', '3',
    'B', '9', '0', '3', '1', 'A', '8', '5', '5', 'D', '5', '9', '4', 'F', 'B', 'A',
    '2', '0', '0', '1', '7', 'F', 'F', 'F', 'C', 'B', '6', 'E', '2', 'A', '5', '9',
    'C', '4', 'D', '8', '5', 'E', 'C', 'F', 'F', 'D', 'E', '1', '6', '3', '4', '4',
    'A', '2', 'A', 'C', '3', '0', '5', 'F', '3', '9', 'F', '0', 'D', 'A', '0', 'F',
    'E', '5', 'C', '9', '9', '1', '8', '3', 'E', '8', 'C', '7', '2', '7', '8', 'F',
    '8', '2', 'A', '9', '1', '3', '3', 'A', '0', '4', '8', 'B', '0', 'A', '3', 'E',
    'B', '6', 'B', 'E', '2', 'B', '2', 'F', '3', '0', '1', 'D', 'C', 'C', '1', 'E',
    '1', '9', '0', 'A', '6', '4', '9', '3', 'F', 'B', '2', '3', '2', '8', '7', '8',
    'A', 'A', '7', '7', 'F', 'B', '5', '4', '9', '4', 'F', '2', '6', 'D', '1', '2',
    '2', '2', 'C', 'F', '1', '0', '6', 'A', '2', 'B', 'D', 'F', 'A', 'D', 'A', 'C',
    '6', 'C', '2', '9', 'A', 'B', 'E', '7', 'E', '6', '2', 'B', '4', '0', '9', 'D',
    '6', '3', '8', '6', 'C', '4', 'F', 'B', '8', '7', 'B', '5', '1', '5', '2', 'C',
    '2', 'F', '3', '8', 'C', '6', '7', '7', '9', '0', 'D', '1', 'A', 'A', 'A', 'E',
    'B', '6', 'B', 'C', '8', 'B', 'C', '8', 'F', '4', '5', '2', 'C', '5', '2', 'D',
    'E', '9', '1', '2', '1', '1', '2', '3', '7', '3', 'D', '0', 'C', '4', '0', 'A',
    '8', 'D', '7', 'E', '5', '3', '8', '4', '7', 'A', '9', '7', 'D', 'C', 'F', 'F',
    '2', '1', '5', 'A', '5', '2', 'B', '7', '0', 'A', 'B', '7', 'D', '9', '9', '5',
    'E', 'C', '0', '1', '0', '5', '8', 'A', '8', 'F', 'B', 'C', '8', 'D', '3', 'D',
    'D', 'B', '8', '7', '4', 'A', '3', 'E', '8', 'E', 'D', '6', '2', '4', 'F', 'B',
    '9', 'E', 'A', 'B', 'E', '3', 'F', '3', '7', '7', '0', 'A', '8', '9', '0', 'B',
    'C', '8', '1', 'D', '9', '7', '5', '0', '7', '9', '2', '4', '3', 'E', '3', '4',
    '1', '9', '5', 'C', '5', '2', '6', 'A', '4', '2', '2', 'D', '8', 'A', '6', 'B',
    'A', 'E', '7', 'B', 'D', '3', '4', 'F', '5', 'C', 'A', '7', '2', 'E', '4', 'C',
    '4', 'F', 'E', '8', '7', '4', 'C', '2', '9', '5', '5', 'A', '4', 'B', '9', 'F',
    'A', 'B', 'C', 'D', 'F', 'D', '9', '3', '0', '9', 'F', 'F', 'A', '7', 'A', '1',
    '1', '8', '6', 'B', 'D', '7', '5', 'F', '8', '6', 'B', 'B', 'D', '8', '0', 'F',
    'F', 'D', '3', '1', '2', '6', '6', '9', 'E', '2', 'C', 'A', '2', '7', '7', 'F',
    'E', '6', '1', 'B', '0', 'E', '0', 'E', '5', 'E', '7', '9', '9', 'B', 'E', '0',
    'F', '4', 'E', '0', '5', 'A', '5', 'F', 'B', 'A', '8', '8', 'D', '5', '7', '2',
    '8', '4', '2', 'F', 'F', '1', 'B', '6', '9', 'C', '0', 'D', '0', 'C', '1', '1',
    'B', '0', 'E', '2', 'D', '9', 'B', '4', '6', 'C', '7', 'C', 'D', '7', '7', '1',
    '2', '8', '4', 'F', '6', 'C', 'D', 'E', 'D', 'A', '7', '1', 'B', 'C', '0', '2',
    'A', '2', '9', '7', '0', '7', '8', '6', '1', 'D', 'B', 'E', 'C', 'D', '4', '5',
    'E', '9', 'E', 'D', '8', '9', '3', '2', '3', 'E', 'F', 'D', '4', 'B', '8', 'B',
    '8', 'C', '7', 'B', 'A', 'C', '2', '7', '0', '3', 'E', '8', '5', '4', 'B', '1',
    'D', '6', '8', 'D', 'C', '1', '1', '6', '7', 'E', '9', '6', '3', '4', '3', 'D',
    'A', 'C', 'C', '3', '6', '7', 'E', '4', 'F', 'B', 'F', 'D', '1', 'D', '9', 'C',
    'D', '6', '6', '9', '4', '6', '7', 'A', '0', '5', 'F', '7', '4', '5', '4', 'C',
    '6', '6', 'E', '7', '3', '7', '1', '6', 'A', '3', 'E', 'F', 'E', 'E', '2', '2',
    'D', 'E', '6', '1', '8', '8', '2', 'B', '0', 'E', '8', 'F', '8', 'F', '8', 'A',
    'F', 'D', '5', '6', '5', '5', '0', '4', '4', 'D', '9', 'A', 'D', '0', '9', 'F',
    'D', 'A', 'E', 'A', 'E', 'B', 'B', '2', 'F', 'D', '5', '0', '0', '2', 'C', '3',
    '7', '6', 'F', '7', '0', '0', 'E', '7', '7', '8', 'C', '5', '1', '5', '7', '7',
    '6', '1', 'B', '0', '6', '2', 'F', '7', '5', '6', '2', '0', 'E', '1', '0', '1',
    'E', '7', '0', '8', 'E', '0', '7', '2', 'C', '9', 'C', '7', '2', 'C', 'E', '8',
    '5', '8', 'E', '2', 'C', '5', 'E', '0', 'C', '6', '7', 'C', '2', '7', '1', 'C',
    '0', '0', 'B', '8', 'F', '9', '5', 'A', 'F', '0', 'A', '6', 'D', 'F', '1', 'D',
    'E', 'C', '0', 'A', '1', '8', 'A', '1', '7', '3', '7', 'E', 'F', 'E', '4', '1',
    '6', '9', '4', 'C', 'D', '6', '6', 'E', 'E', '1', '8', '1', 'A', 'B', '5', '2',
    'B', 'B', '6', 'E', '7', 'C', '6', '0', '7', '3', '0', '5', '1', 'F', '2', 'C',
    'A', '7', 'E', 'D', 'A', 'D', '5', '6', '8', '1', '0', 'F', '9', '6', '7', 'B',
    '8', 'D', 'C', 'E', 'D', '3', '8', 'F', '1', 'A', '0', '4', 'C', '9', 'B', '6',
    '1', 'D', '6', '4', 'E', '4', '7', '2', 'F', '2', 'E', 'F', 'A', '4', 'B', '1',
    'C', '8', 'D', '8', '6', '6', '7', 'D', 'A', '6', '6', '4', 'A', '8', 'C', 'D',
    'A', '7', 'B', 'F', '2', 'A', 'C', '2', '4', 'B', 'E', 'A', '0', '6', '6', '7',
    'E', '5', '2', 'F', 'A', '6', '1', 'E', '2', '5', '3', '4', '1', '8', '1', '2',
    'E', '0', '7', 'D', 'C', '3', '8', 'E', '7', '1', '1', '8', 'B', '4', 'C', 'E',
    '1', 'B', 'F', '3', '6', '5', '6', 'B', '6', 'F', 'F', 'F', '1', 'A', '0', 'C',
    '6', 'C', '1', 'A', 'B', '3', '8', 'F', '0', '8', 'E', '2', '0', '7', '9', '0',
    'B', '1', '6', '7', '7', '9', '1', '2', '0', 'B', '0', 'C', '7', '7', '8', 'A',
    'E', '6', '0', '1', 'D', '7', 'D', 'C', '2', '3', '6', '7', '0', '7', 'C', '3',
    '1', 'B', '7', '4', '0', '0', 'C', 'F', '4', '9', 'B', '1', '0', '9', '8', 'C',
    '2', 'B', '6', '8', '2', 'A', 'F', 'F', 'A', '8', '3', 'D', '8', '2', '9', 'C',
    '9', 'A', '0', 'D', 'B', '7', '4', '5', '2', 'D', '0', 'B', '2', 'D', '7', '2',
    '5', '7', '1', '0', '9', '8', 'D', '8', 'F', 'C', '1', '3', 'E', 'C', 'A', '0',
    'B', 'B', '8', '5', 'E', 'C', '0', '9', '0', '7', 'D', 'C', '0', 'F', '9', '2',
    'A', '9', 'B', 'E', '8', 'C', '7', '9', 'A', 'D', 'B', 'D', '4', '0', '8', '0',
    '9', '7', '7', '8', '2', 'B', '9', '4', '9', '5', 'B', 'B', '6', 'F', '3', '2',
    '9', 'D', '2', 'D', '6', '4', 'D', '9', '1', '9', '5', '4', '7', '8', '0', '0',
    'E', '3', 'B', 'D', '5', 'E', '3', '7', '3', '9', 'C', '3', '1', '3', '6', '9',
    'F', 'F', 'C', 'A', '8', 'E', 'D', 'F', '7', '4', 'F', '3', '7', '1', 'F', 'E',
    'E', '7', 'C', '7', '8', '7', '6', 'A', '3', 'B', '4', '2', 'F', '6', '1', '3',
    '0', '5', 'A', '3', '2', '3', 'C', '9', '0', '7', '9', '8', 'C', '5', '9', '4',
    '3', 'D', 'D', 'B', '3', 'D', 'F', '2', 'B', '5', '3', 'B', '6', '5', '8', '0',
    '2', '8', '8', '5', '5', '8', 'B', 'E', 'E', 'B', 'D', '4', '8', '5', 'B', '0',
    'A', '6', 'A', 'A', '0', 'C', '9', '1', '5', '7', 'A', 'A', '3', 'D', 'C', '3',
    'C', '7', '8', '7', 'E', '5', 'C', 'C', '2', '7', 'E', '7', '7', '3', 'E', 'A',
    'E', '4', 'B', 'A', '9', '4', '0', 'F', 'B', '4', '4', 'E', '3', '0', '6', 'E',
    '8', 'D', '4', 'D', 'B', '7', '0', 'A', '3', '9', 'C', 'C', 'F', '0', 'B', '9',
    'D', '7', 'B', 'C', '8', 'E', 'B', '0', 'E', 'F', '1', '0', 'E', 'A', '9', '8',
    'D', 'E', '8', '5', '5', 'B', '6', 'C', '8', 'E', '4', '7', 'F', '3', '3', '3',
    'D', '9', 'C', '6', '3', '8', '4', 'D', '3', 'E', '5', '5', '3', '8', '0', '4',
    '0', '6', 'F', '9', 'E', '7', '4', '1', 'B', '7', '7', '4', 'B', '1', '6', '2',
    'F', '7', '5', 'D', '2', '7', '3', '7', '0', 'B', '6', '9', '2', '7', 'F', '7',
    '8', '3', 'F', '6', '7', '8', 'A', 'A', 'B', 'B', '7', 'A', '3', '3', '5', 'C',
    '8', 'E', '1', '2', '8', 'C', 'F', '0', '3', 'F', '3', 'A', '6', '2', 'F', 'E',
    'D', 'E', 'D', '9', '4', '8', '6', '7', 'D', 'F', 'F', '2', '2', 'B', '2', '9',
    '4', 'A', '7', '8', 'D', 'E', '4', 'B', '3', '0', '5', '8', '3', '2', 'E', 'F',
    '9', 'B', '5', '7', '1', 'C', 'B', 'E', 'E', '7', 'D', '2', '0', 'E', '4', '3',
    '1', '4', '6', '7', 'A', '2', 'C', 'B', 'D', 'E', '5', '8', 'F', '6', 'C', 'E',
    'E', 'F', 'E', 'F', 'A', 'B', 'A', '9', '0', '2', 'B', '8', '3', 'D', '7', '1',
    'F', 'F', 'E', '4', 'D', '8', 'D', 'C', '1', '7', 'B', 'D', '6', 'C', '3', '6',
    '9', 'C', '8', 'C', 'C', 'C', '5', '5', 'D', '6', '3', '4', '6', '3', '5', '5',
    'A', 'F', '7', 'E', 'B', 'E', '0', '9', '8', '7', 'B', 'F', 'B', '2', '3', '9',
    '0', 'C', '5', 'D', '9', 'A', '8', '1', '7', '3', '3', 'B', 'A', '4', '3', '5',
    '3', 'A', '8', 'F', '5', '1', '4', '8', '4', 'E', 'C', 'B', 'D', '8', '4', '3',
    'F', 'A', 'A', '1', '4', 'B', '0', '1', 'F', '5', '7', '4', 'A', 'F', '2', 'B',
    'C', 'D', 'D', 'C', '3', 'C', '4', 'B', '3', '8', '2', '1', '8', 'B', 'A', 'B',
    'A', '9', '5', 'D', '2', '4', '8', '0', '4', '0', '4', 'F', '2', '6', '8', 'F',
    '3', '1', '4', '8', '0', '0', '1', 'C', '5', '1', '6', 'D', '3', '0', 'E', 'E',
    'D', 'E', 'F', '6', 'F', '6', '1', '9', 'A', 'F', '2', '5', '6', 'F', 'E', '1',
    '4', '5', '5', 'C', '2', '6', '2', 'F', 'D', '7', 'B', '5', '8', '1', '0', '1',
    '7', '6', '6', 'E', '6', '4', 'F', 'B', 'E', 'A', 'F', '6', '0', '1', '5', '4',
    '9', '6', 'F', '2', 'B', '7', '7', 'B', '5', '9', '0', 'D', 'A', '5', '6', '7',
    '4', '4', 'E', '7', 'B', '2', '0', '5', '9', '5', '3', 'C', 'D', 'C', '6', 'E',
    'D', 'E', 'D', '8', '6', 'C', '0', 'F', 'B', 'E', 'D', 'D', '7', 'C', '5', '0',
    '9', 'B', '6', 'E', '5', '1', 'E', '3', 'B', 'B', '3', '8', '1', 'B', '4', '8',
    'E', '0', 'A', '9', '9', '4', '2', '3', 'B', '1', '4', '4', '2', 'A', 'B', 'E',
    'C', 'C', '2', '5', '5', 'E', 'F', '3', '6', 'C', 'F', '3', '7', '8', '0', 'A',
    '5', 'F', '9', '6', '4', '8', 'C', '1', 'F', '6', 'D', '8', 'E', '1', 'C', 'E',
    '3', 'A', '0', 'E', '8', '8', '4', 'B', '0', '5', '5', 'C', 'B', '8', '9', '7',
    'E', '0', '2', 'F', '3', '3', '3', '9', 'E', 'B', 'F', '6', '3', '2', 'B', '0',
    '5', '0', 'E', '2', '1', '9', '9', '3', 'D', '1', 'A', 'F', 'F', '9', '6', 'D',
    'A', '6', '7', '4', 'D', '1', '1', 'E', 'F', 'A', 'B', '9', '9', 'A', 'B', '2',
    '1', 'B', '2', 'E', '7', '3', 'B', '8', '8', '1', '3', 'C', '2', '6', 'E', '1',
    'A', '8', 'F', '7', 'B', '8', '4', '4', 'F', '3', 'D', '8', '7', 'C', '4', '1',
    '7', 'D', '3', 'A', '8', 'D', '1', '5', 'E', '4', '9', 'A', '8', '2', '2', '0',
    'E', '5', '8', '1', 'F', 'C', 'F', '5', '5', 'D', '2', '3', 'B', 'D', 'B', 'B',
    'C', '5', '2', 'B', '9', '6', '9', 'D', '9', '9', '8', '4', '4', 'C', 'E', '5',
    '6', '2', '1', '5', 'C', '0', 'A', 'B', '4', 'E', '0', '4', '7', '0', 'B', '8',
    'E', 'F', 'B', '8', '2', '2', '1', 'C', 'A', 'E', 'C', '7', '7', '5', 'F', '0',
    'F', 'B', '0', 'E', '2', '2', '6', 'E', '6', '6', '9', '8', '0', 'C', 'C', '1',
    '2', '5', 'C', 'A', '4', '8', '3', '2', '1', '0', '7', '8', '2', '3', '6', '2',
    'D', 'D', '1', '1', '7', '7', 'B', '7', 'B', '2', '5', '0', 'C', 'D', 'E', 'B',
    '7', 'D', '6', 'D', '0', 'E', 'C', '6', '4', '7', 'B', 'E', '1', 'B', 'D', '1',
    '2', '1', '4', '5', '1', '5', 'E', '6', 'E', 'C', '7', '1', 'D', 'D', '5', 'D',
    '8', '1', 'B', '9', '6', '6', '7', '6', '3', 'C', '6', '1', 'C', '1', '9', 'F',
    'E', '4', '3', '8', '5', 'C', '5', 'B', '4', '6', '1', 'C', '9', '7', '2', '4',
    '6', '9', 'D', 'B', '4', '9', 'F', '2', '0', 'A', 'A', '0', '5', '5', '6', '0',
    'F', 'A', 'B', '4', '8', '1', '8', '0', '4', '2', 'D', 'D', 'F', '9', 'C', '4',
    '7', 'E', '9', '8', '8', 'F', '6', '0', '6', '2', '2', 'C', '1', '6', '5', '9',
    'F', 'E', 'F', '2', 'E', '5', '5', '2', 'C', '8', 'F', '4', '8', '6', '6', 'C',
    '2', '5', 'D', 'F', '9', 'B', '9', 'F', '3', '2', '0', '6', '5', '3', '1', '3',
    'D', 'E', '3', 'B', 'A', '0', '4', '8', 'D', 'C', '4', 'D', '9', '1', 'F', '0',
    '4', '7', '6', 'E', 'F', '0', '4', 'C', 'C', '8', '3', '3', '6', 'C', '6', '3',
    '1', 'D', '4', 'C', '1', '1', '8', '0', '1', 'F', '5', 'C', '7', 'F', '9', '1',
    'B', 'B', 'B', 'F', '1', 'C', '6', '0', '2', '5', '4', '2', 'C', '8', 'C', 'E',
    'C', '6', '0', '3', 'E', 'A', '8', 'C', '6', '4', '1', '2', 'D', 'A', 'A', '1',
    '8', 'D', 'F', '0', 'B', '9', 'A', '8', 'C', '0', 'A', '0', 'B', '5', 'A', 'D',
    '9', '9', '1', '0', '7', '6', 'A', '8', '5', '9', 'F', '0', '0', 'F', '9', 'A',
    '2', '4', '0', '5', 'A', 'A', '7', '8', '5', '6', 'E', '1', '5', '0', 'E', '3',
    'A', '6', '1', '6', '7', 'A', '2', 'E', 'D', 'D', 'A', '0', '0', '7', '2', '8',
    '3', 'C', '1', '9', '3', '6', '5', '6', 'D', '7', '3', '4', '6', '7', '4', '9',
    '0', '9', '6', '3', '4', 'A', '7', 'C', '1', '7', '8', 'A', '1', 'D', 'A', '4',
    '4', '0', 'A', '6', 'D', 'E', 'F', '7', 'D', '2', '3', '3', 'D', '5', 'C', '7',
    '9', '3', '9', 'C', '3', '0', 'F', '7', '5', '6', 'C', 'B', '5', '1', '2', 'B',
    '4', '5', '7', '2', '1', 'A', 'B', '9', '3', '3', 'D', '1', 'F', '6', 'E', 'C',
    'D', 'E', '2', '7', '0', 'B', '4', 'D', '9', '2', '4', 'C', '0', '9', '9', 'A',
    'D', '9', 'B', '0', '6', 'A', 'F', 'B', 'D', '9', 'B', 'D', '7', 'C', 'A', '4',
    'B', '7', '1', 'C', '2', '5', '1', '7', 'F', '6', '0', '1', '5', 'E', '5', '0',
    '9', '7', 'A', '8', '5', 'E', 'A', '5', 'C', 'C', '2', '4', '0', '8', 'F', '3',
    '3', 'A', '1', '5', 'D', '3', 'F', 'C', 'E', '2', '7', 'D', 'C', 'C', '8', '2',
    '1', '3', '1', '7', '6', '9', '6', '4', '2', '4', '9', '1', '6', 'D', '4', '5',
    '4', '1', '2', '3', 'F', 'E', '2', 'F', 'E', '9', 'A', '5', '9', '0', 'A', '6',
    'C', '1', '6', 'F', 'D', '8', 'C', '2', 'C', '7', 'A', '0', '8', 'D', '6', '0',
    'C', '5', '7', '1', '0', 'B', '2', 'E', '2', 'B', '2', '1', '2', '2', '5', '7',
    '7', 'B', '4', 'C', '9', '5', 'D', '6', '4', 'E', 'E', '0', 'F', 'C', '2', '2',
    '8', '2', 'D', 'B', 'A', '7', 'C', 'A', 'C', 'A', 'B', 'E', 'B', 'C', '1', 'A',
    '0', '9', '9', '3', '4', '4', 'D', '9', '5', '6', 'A', '3', '9', '9', 'B', '9',
    '1', '4', '3', 'C', '4', '2', '2', '0', 'E', '3', '3', 'E', '4', '2', 'C', '1',
    '3', '2', 'D', '6', '0', '9', 'A', '2', '7', '4', '7', '5', '7', 'A', 'A', 'C',
    '2', 'E', 'C', '3', 'E', '4', 'F', '5', '7', '2', '2', '5', '8', '7', 'B', '8',
    '1', '1', 'E', '9', '1', '5', '0', '3', 'F', 'B', '3', 'E', 'A', '4', '0', '4',
    '2', 'A', 'E', '7', '4', '8', '2', 'F', '5', '8', 'D', '4', 'C', '1', 'F', 'C',
    'B', 'C', '1', '5', '0', 'C', '0', '7', 'E', '7', '6', 'A', '3', '7', '9', '4',
    '4', 'D', '7', 'D', '7', '6', '3', '3', '6', '4', 'E', '7', '7', 'F', 'D', '4',
    'B', '3', 'D', '7', '0', 'A', '8', 'E', '5', '4', 'E', 'E', '7', '7', '4', 'B',
    '8', '0', '0', 'F', 'B', '2', '4', '0', '6', 'D', '6', '4', 'C', '1', 'D', 'F',
    'C', '8', '6', '2', '4', '1', '2', '0', 'A', '2', '8', 'F', 'A', 'D', 'C', '8',
    '8', 'A', '1', '1', 'B', 'A', '3', '0', 'F', 'C', '1', '8', '5', 'F', '1', 'B',
    'A', '2', '8', 'D', '2', 'B', '4', 'B', 'D', '0', '6', 'A', '5', '0', 'A', '6',
    '2', '0', '2', 'F', '7', '3', 'C', '5', 'B', '9', '8', 'A', 'B', 'F', '4', '8',
    'E', 'B', 'D', '9', '3', '3', '3', 'D', 'D', '3', '1', '6', 'B', 'A', '8', '5',
    '1', 'E', 'A', 'A', '8', 'C', '6', 'F', '7', '5', 'A', '9', '2', '0', 'E', '3',
    '6', '4', 'B', 'B', '8', '1', 'E', '1', '1', 'D', '9', 'C', '3', '9', '0', 'D',
    '3', '7', 'C', '6', '3', '7', '4', 'A', '9', 'B', 'C', '4', 'E', '0', 'D', 'D',
    '3', '1', '7', 'D', 'C', '5', '6', '7', 'F', '1', '9', '9', 'A', 'B', 'A', '9',
    '5', '5', '5', 'D', '9', '2', 'B', 'B', '8', 'F', 'A', '1', 'B', '9', 'D', 'E',
    '3', '7', '7', 'F', '0', 'B', 'D', '4', '8', '5', '2', '6', 'A', 'F', '0', '4',
    '9', 'E', '3', '9', '7', 'C', 'A', '3', 'B', 'F', '7', '4', '8', '7', '8', 'D',
    'E', '6', '4', '6', '1', '5', '6', '8', 'F', '5', '8', 'E', '1', 'F', '4', 'D',
    '0', 'F', '8', 'B', '5', '0', '9', '8', '5', 'F', '2', '2', 'F', '1', '6', '5',
    '6', '8', '9', '1', 'B', '9', '2', '9', '7', '7', '0', '8', '3', '0', '1', '9',
    '9', 'F', 'A', 'B', '1', '3', '1', '6', 'F', '8', '9', '4', '4', 'B', '8', 'B',
    '0', 'B', '9', '5', 'E', 'C', '9', 'C', '4', 'A', '0', 'A', '5', '7', '7', '6',
    'A', '9', '5', '7', '4', 'A', 'E', '6', '7', 'D', 'B', '7', '0', '2', '0', 'C',
    'B', '4', '3', 'A', 'B', '0', 'B', 'E', 'A', 'B', '5', 'D', 'D', 'C', '4', '0',
    '5', '5', '9', '9', '3', 'C', '4', '0', 'F', '6', '0', 'E', 'D', 'E', '0', '5',
    '9', 'D', '6', '5', '0', 'B', 'C', '5', '8', 'D', '0', 'D', 'A', '1', 'C', 'B',
    'C', 'D', 'F', 'E', '8', 'E', 'D', '1', 'E', '4', 'A', '8', 'F', '4', 'D', 'C',
    '2', '3', 'A', 'B', 'F', '1', '4', '1', '8', 'E', 'E', '9', '5', '6', '2', '3',
    'E', 'A', '7', '6', '2', 'F', 'C', '6', '6', '8', 'B', '8', '3', 'A', '2', '6',
    '6', '2', '1', '8', 'D', 'F', '9', '7', 'D', 'E', '7', 'C', '5', '0', '3', 'C',
    'E', '7', 'E', '4', '2', 'C', 'B', 'A', '3', '3', '6', '7', '6', '5', 'C', 'D',
    '1', 'A', 'D', 'D', 'C', 'F', 'F', '5', 'B', '8', '9', 'C', 'B', '5', '3', 'E',
    'E', '1', '9', '3', '8', 'A', 'F', '4', '7', 'F', '2', '2', '9', 'C', '0', 'E',
    'D', '8', '3', '9', '8', 'F', '7', '6', '8', '6', '8', 'A', '6', '3', '1', '7',
    '8', '7', '0', '1', 'A', 'D', 'A', '3', 'B', 'F', '1', '2', '9', 'E', '6', '3',
    'B', 'D', '9', '2', '6', 'B', '3', '3', '1', 'D', '4', '6', 'B', 'E', '7', 'A',
    'D', '2', 'B', '2', 'D', '8', '5', 'A', '7', 'D', 'A', 'D', '3', 'D', '4', '1',
    'E', 'F', '0', 'A', '2', '5', '0', '4', 'C', 'E', '4', '3', 'D', 'F', '9', 'F',
    '0', 'D', 'A', 'A', '1', '3', '7', 'A', 'D', '8', 'C', '4', 'D', '6', '4', '7',
    'A', '0', '8', 'B', '7', '4', 'F', '2', '0', 'A', 'D', 'A', 'E', '0', '5', '0',
    '5', '0', '1', 'E', 'D', '5', '0', '7', '7', '3', '8', '0', '0', 'E', 'D', '8',
    '4', '8', '8', 'C', '3', '1', '8', '7', '2', '4', '7', '5', '9', '3', '8', '3',
    '7', '6', '9', '8', '2', '2', '3', '4', 'B', 'F', '9', '6', '7', '8', 'F', 'D',
    '6', '1', '7', 'F', 'D', 'B', 'F', 'B', 'D', '9', '6', '2', 'F', '6', '4', '8',
    'A', '6', 'A', '8', '6', '4', '3', 'E', '7', '7', '4', '9', '5', '0', 'C', '5',
    '0', 'E', '1', '6', '0', '2', '4', '8', '5', 'C', 'B', '7', '7', 'C', '5', '3',
    '4', 'B', '1', 'B', '2', 'C', '9', 'E', '5', 'F', 'B', '7', '2', '9', '8', '7',
    '3', '1', '0', 'D', '9', 'A', '6', '2', '4', 'A', 'C', 'B', 'F', 'C', '7', '0',
    '2', '2', '1', 'B', '2', 'E', 'A', 'B', '9', 'A', '8', '3', '5', '9', 'E', '4',
    '1', 'A', '4', 'B', 'A', '2', '5', '3', 'F', 'A', '7', 'D', '3', '3', '1', '3',
    'F', '0', 'C', '0', '6', 'B', '3', '7', '3', '2', '2', '4', '6', '3', '0', '5',
    'D', 'A', '8', '0', '0', '2', '1', '8', 'E', '8', '3', '2', '4', '1', 'A', '1',
    '0', '7', '2', 'C', '6', 'B', 'F', 'A', '9', '9', '2', '2', 'F', 'F', 'B', '4',
    '0', 'A', '9', '3', 'A', '8', '4', '3', '0', '0', '6', '9', 'E', '3', 'E', 'E',
    'F', '1', '2', '6', '4', '4', '7', '2', 'D', 'C', 'D', '5', '9', 'B', '2', 'E',
    '6', 'C', 'C', 'B', '9', 'B', 'C', 'B', '7', '7', '8', '9', '7', '5', 'B', 'F',
    '0', '0', '2', '4', '9', 'A', '1', '4', '3', 'B', 'F', '3', '4', '3', 'C', 'A',
    '3', '7', '9', '2', 'D', 'C', '6', '1', '1', '5', '9', '4', 'D', 'C', '8', '2',
    '2', '7', '7', '4', '1', '7', '3', '8', '4', 'D', 'E', '4', 'B', 'F', 'B', 'B',
    'C', '9', 'D', '0', '5', 'F', '4', '9', '0', '3', '6', '1', '4', 'A', '5', '5',
    '1', '9', 'B', '6', 'D', 'D', '9', '1', 'F', 'F', '0', 'D', '3', '8', '9', '7',
    '4', '5', '7', '3', '2', 'A', 'D', 'C', '3', '5', 'C', 'C', '8', 'C', '5', '0',
    '1', '5', '9', '8', 'A', 'E', '5', '3', '0', '0', 'D', '7', 'E', '4', '4', '4',
    '6', 'A', '2', 'C', 'A', '9', 'E', 'E', '6', '0', 'A', '6', 'E', 'B', '2', 'A',
    'D', 'E', '9', 'E', 'C', '0', '5', '6', 'C', 'D', '6', 'B', '2', 'D', '9', 'D',
    'B', '3', '2', 'A', '6', '0', '4', '9', '5', 'F', 'C', 'A', '6', '7', 'B', '5',
    '5', 'B', '0', 'D', '7', '5', '3', '3', '1', '9', 'C', '4', '2', '1', '7', '3',
    '4', '2', '2', '1', '3', 'B', '0', '3', '5', '7', '2', 'D', '1', '3', 'D', '3',
    '7', 'B', '9', '8', 'F', 'D', '8', 'F', '4', 'E', '8', 'A', 'B', 'A', '3', '3',
    '1', 'C', '9', 'E', 'F', 'D', '0', 'A', 'A', '4', '2', '2', '9', '6', '4', '1',
    '9', '0', 'C', '9', '6', '8', 'A', '5', '7', 'E', 'A', '3', 'F', 'A', '1', 'A',
    '6', 'C', '7', 'E', 'D', '3', '2', '8', '2', 'D', 'E', '7', 'D', '6', 'A', '0',
    '5', 'D', 'E', '1', '8', '5', '4', '4', 'C', '2', '8', '1', 'C', '5', '0', '5',
    'D', '5', '0', '7', '3', 'E', '7', '2', 'A', '6', '1', 'B', '7', 'B', 'E', '8',
    '8', 'D', 'B', 'B', '8', '9', '1', '8', '7', 'D', 'A', '1', '7', '2', 'B', 'D',
    '8', '0', '0', 'D', 'C', '1', '8', '9', '3', 'C', '2', 'B', 'A', '4', '6', '3',
    'C', '7', '8', '8', '2', 'D', '0', '4', '6', 'D', '0', 'F', 'F', '0', '6', '9',
    '7', '7', '0', 'D', '1', 'C', 'C', 'D', '3', 'E', 'B', '8', '1', '7', '6', 'D',
    '2', '9', '6', '0', '5', '7', '4', '8', '2', '5', '2', '1', '2', '5', 'C', 'F',
    '6', '6', '4', '9', 'B', 'D', '5', '1', 'A', 'D', '8', '9', '7', '2', 'D', '1',
    '7', '0', 'A', '3', '5', 'E', '1', 'C', '2', '4', '9', 'F', '7', '3', '9', '4',
    '4', '9', 'D', 'D', 'B', '7', 'D', 'F', '5', 'E', 'E', '3', '3', '7', 'C', '5',
    '6', '3', 'E', '5', '6', '9', 'F', '0', 'F', 'F', 'D', '0', '8', '5', '2', 'A',
    '4', '5', '7', '6', '8', 'C', 'A', 'A', '0', '3', 'F', '3', '2', '9', 'B', '3',
    'D', 'E', 'C', 'D', 'C', '3', 'F', 'F', 'E', '2', 'A', 'F', 'A', 'D', 'E', '1',
    '2', '9', '6', 'E', '6', '4', '9', '4', '3', 'D', 'C', '0', '3', '3', '0', 'A',
    '3', '6', 'C', '6', '3', '8', 'E', '0', '3', '6', '3', '4', 'D', '4', '5', '8',
    '0', '1', '1', '9', '0', '2', '3', 'B', 'E', 'E', '8', 'C', '3', 'B', '4', 'F',
    '5', '4', 'A', '4', '3', '9', 'D', '5', '2', 'D', 'D', 'F', '9', 'D', '4', '5',
    '0', '0', '7', '6', '8', '8', '5', 'B', 'F', '4', '4', 'E', '9', 'B', '2', '4',
    '7', '3', '1', '8', '9', 'D', 'B', 'E', '2', '8', 'D', '2', 'F', 'E', '0', '6',
    '6', '7', 'F', '8', '4', 'E', 'B', 'E', '4', 'E', '2', 'F', '7', 'F', '2', '2',
    '0', '1', '6', '4', 'B', 'D', '8', 'A', 'B', '4', '4', '4', '9', 'D', 'A', 'A',
    '5', 'B', '1', '8', 'F', 'C', 'C', '8', '4', '2', '8', 'E', '0', '6', '1', '6',
    '8', '1', '9', '5', '8', 'A', '3', '4', '4', '0', '7', '0', 'A', '3', '5', '6',
    'C', '2', 'D', '6', '0', 'B', 'F', '2', '0', '8', '7', '2', '9', 'E', 'D', 'B',
    '7', '3', '5', 'C', '1', 'B', '8', '9', 'B', 'E', '5', '7', '6', '2', '3', 'E',
    'A', 'B', '8', 'E', '9', '2', 'A', '7', '9', '3', 'A', 'E', 'B', '0', 'B', '5',
    '8', 'E', 'C', 'E', 'B', 'A', 'C', 'E', '6', 'B', 'F', '3', '5', 'A', '3', '0',
    '4', '8', 'E', '6', '1', 'B', 'B', '6', '9', 'D', 'B', 'C', '7', '0', '8', 'B',
    'D', '7', '9', '2', 'C', 'E', '3', '9', 'E', 'B', '9', '7', '1', '4', '6', 'F',
    '2', '8', '4', '7', '5', 'E', 'E', 'F', '3', 'D', 'E', '4', 'B', '2', '5', '5',
    '5', 'F', '2', '1', '9', 'D', '2', '2', 'B', 'A', 'A', 'F', '8', '7', '7', '5',
    '8', 'D', 'A', '2', '5', 'D', 'E', '2', '1', '8', 'D', '5', '7', '7', '2', '6',
    'C', '4', '7', 'A', '1', '0', '8', 'B', '4', 'E', '7', 'B', '9', '6', '0', 'A',
    'A', 'A', '2', 'E', 'E', '3', '7', 'D', 'C', 'A', 'C', '5', '4', '5', '2', '7',
    '6', '9', '3', '5', 'A', '8', '8', 'F', 'C', 'E', '0', 'C', '6', 'B', '6', '0',
    '2', 'E', '2', '2', '9', '4', '8', '3', '1', '0', 'A', '5', '6', 'C', '9', 'E',
    'A', '8', 'E', '9', '6', 'A', '7', 'C', 'D', 'A', 'F', 'E', '5', 'B', '8', '7',
    'B', '9', 'F', 'F', 'C', '3', '3', '7', '7', '2', '0', '8', 'C', '7', 'A', '5',
    '5', '7', 'C', 'B', 'E', '9', 'B', '3', 'B', 'A', 'E', '5', 'E', '2', '0', 'F',
    'B', '1', 'F', '8', 'A', '4', 'B', 'B', '3', '9', '3', 'B', 'E', '4', '4', '7',
    '4', '6', '3', 'F', 'F', 'D', '1', '7', '6', 'A', '4', '8', 'D', '7', '2', '9',
    'F', '3', 'C', 'E', 'A', '7', '4', 'A', '1', '0', '9', 'F', '0', '2', '8', 'A',
    '3', '5', 'C', '9', '3', '0', 'D', 'B', '7', '4', 'E', 'E', '2', 'B', '7', '2',
    'A', '6', '2', 'C', 'B', '3', '9', '2', '3', '7', 'A', '1', 'E', '0', 'F', '0',
    'E', '0', '7', '9', '8', '3', '5', '7', '3', '4', 'A', '4', 'D', '3', '2', '0',
    'A', '2', '2', '1', 'B', '0', '4', '5', '5', '9', 'D', '0', 'B', '3', '9', '6',
    'B', 'F', 'F', '3', 'E', '8', '2', '0', '6', 'D', '0', 'E', '7', 'D', 'F', '8',
    'D', '1', '0', '8', '2', 'C', '6', '8', 'C', 'E', '6', '5', '8', '2', '9', 'C',
    '5', '3', '2', 'C', '6', '2', '5', '2', '2', 'D', '2', '7', '3', 'A', 'A', 'F',
    '1', '6', 'D', '4', 'B', '2', 'E', '1', '4', 'D', '8', '3', '9', 'C', '6', '3',
    '4', '2', '9', '6', '2', '2', 'B', '5', '1', 'C', 'A', 'A', '8', 'C', '4', '5',
    '3', 'F', '4', '9', 'E', '0', '1', 'C', '0', 'C', '2', '0', '2', 'E', 'A', '6',
    '4', 'D', '5', '1', '6', '6', 'B', '6', '1', '3', '0', '9', 'D', '9', '9', 'E',
    '7', '3', '9', 'B', '0', 'D', '9', '2', 'E', '1', '3', '3', '4', 'D', 'F', 'A',
    '1', '5', 'C', 'D', '9', '5', 'D', 'E', '6', '4', 'D', 'B', 'A', '7', '7', '4',
    '1', 'A', '5', '2', '7', '4', 'B', '9', 'A', '6', 'D', '6', '9', '4', '5', 'D',
    '8', '6', 'F', '6', 'F', '5', '2', '7', '1', 'A', 'D', '6', '3', 'F', 'F', '4',
    'D', '3', 'E', 'F', 'E', '8', 'C', '2', '0', 'B', '1', 'A', '5', 'E', 'D', '5',
    '7', '4', '6', 'E', 'B', '5', '1', '4', 'D', '0', 'F', '5', '8', 'A', '0', 'F',
    '2', 'C', 'C', '1', 'D', '8', '9', 'E', 'F', '9', 'A', '3', 'D', '9', 'F', '6',
    'A', 'F', 'C', 'E', '6', '3', 'D', 'D', '6', '0', '8', '1', 'D', '0', '0', 'C',
    '7', '5', 'D', '8', 'D', '1', '1', '7', 'D', '0', 'A', 'B', 'B', '7', 'B', '2',
    '7', '7', '8', '7', 'A', '3', '8', '4', '5', '0', 'E', 'D', '6', '0', 'D', 'E',
    '4', 'E', 'F', 'B', 'E', 'B', 'A', 'A', '5', 'B', 'F', 'E', '9', '0', 'C', 'A',
    'D', '6', 'E', '7', 'D', '6', '9', '2', '2', '9', 'A', '5', 'D', '2', 'E', '2',
    '1', '2', '2', 'A', 'A', '9', '0', 'C', '1', '8', '4', '5', '7', '5', '9', '2',
    '8', 'A', '0', 'A', '8', 'F', 'C', 'C', 'C', '7', '0', 'C', 'D', '9', '0', '3',
    '4', 'C', '8', '1', '5', 'B', '4', '9', '8', 'A', '7', '5', 'C', 'B', '3', 'F',
    '3', '9', '4', 'E', '4', '0', '0', '5', '5', 'A', 'C', '8', 'A', '1', '4', '6',
    '0', 'A', '0', '0', '4', '1', 'A', '3', 'F', '8', '4', '3', '7', '3', '1', '5',
    'F', '1', 'F', '9', '8', 'B', '5', '8', '1', '8', '9', '8', '7', 'C', 'E', '1',
    'D', 'F', '1', '7', '4', 'E', 'F', 'B', 'C', 'F', '8', '5', '8', '0', 'A', '7',
    '6', '1', '6', '2', 'D', 'F', '1', '6', '0', '0', 'D', 'C', '1', 'D', '1', '3',
    'C', '3', '7', '9', '9', 'D', '8', '1', '7', 'B', '8', 'A', '8', '7', '6', 'B',
    'F', '5', 'D', '0', '7', '7', '2', '0', '4', '5', '0', '7', '1', '6', 'C', 'F',
    '0', '8', '6', '8', '2', '9', '1', '4', '4', '8', '6', '6', '3', '1', '4', 'D',
    '4', 'A', 'F', 'D', '5', '3', '2', '7', '0', 'C', 'D', '5', '5', '8', 'E', '4',
    '9', '4', '4', '7', 'A', '3', '5', '3', '8', '0', '5', '3', '0', 'B', 'D', '5',
    '1', '6', 'A', 'F', '0', '5', 'E', '6', '9', '8', 'B', 'A', '7', 'A', '5', '3',
    'D', '6', 'C', 'A', '9', 'A', '5', 'F', '9', 'A', 'D', 'C', '7', '6', 'E', 'F',
    'C', '4', '5', '4', '6', '9', '1', '0', '8', '8', '8', 'D', 'D', '3', '5', '2',
    'B', 'A', 'C', '0', 'C', 'B', '9', 'F', '0', 'A', '6', '7', 'D', '4', '5', '5',
    'E', 'C', '3', '7', '9', 'F', '1', '2', '2', '4', '4', '7', '6', 'F', 'C', '4',
    '1', '3', 'A', '3', '1', '6', '8', '2', '7', 'B', 'E', 'C', '8', 'A', '7', 'C',
    'F', 'E', '8', '4', '7', 'E', 'F', '8', '8', 'F', '0', 'F', 'E', 'B', 'A', 'B',
    '4', '8', '3', 'B', 'C', '1', '4', 'D', '7', '4', '5', '6', '3', '0', '8', 'A',
    'C', '9', '9', 'C', 'E', '5', '2', 'F', 'B', 'B', 'A', 'F', 'D', '1', '7', '1',
    '5', '1', '9', '6', '0', '4', 'B', 'F', '5', '5', '2', '3', '0', '3', 'C', 'F',
    'F', 'A', '0', '5', '9', 'E', 'F', '1', '2', 'F', '5', '2', 'D', '3', '5', '3',
    'E', '8', 'D', 'C', '0', 'F', 'D', 'B', '8', '5', 'B', '5', 'B', 'D', 'F', 'F',
    '8', '0', 'F', '9', 'E', 'D', 'B', 'D', '3', '0', 'B', '2', 'A', 'D', '6', '0',
    '0', 'D', 'A', '4', '2', '7', '0', 'C', '3', '1', '6', '7', '1', '3', 'E', '1',
    'A', 'E', '7', '9', '3', '4', '7', '8', '7', '3', 'E', '2', 'F', '5', '1', 'D',
    '0', '3', 'F', '1', '0', '7', 'E', '2', 'D', 'D', 'C', '5', '7', '3', 'F', '1',
    'E', '5', 'C', '2', '5', '8', '5', 'A', 'A', '6', '8', '3', '3', '3', '4', 'B',
    '0', '4', 'C', '0', '7', '6', '8', '9', '4', '3', '9', 'C', '6', 'A', '9', '7',
    'A', '1', 'A', 'D', 'D', '6', 'F', '3', '2', '1', '3', '6', 'E', '6', '0', 'E',
    'D', '4', 'B', '9', 'A', 'E', '3', '7', 'F', 'B', '0', 'B', '0', '9', 'F', '1',
    'C', '6', '2', '1', 'E', '2', '9', 'B', 'D', 'E', 'F', 'E', '6', 'D', '9', '1',
    'D', 'B', 'B', 'B', '3', '4', '5', 'E', '2', '4', 'D', '2', 'D', '8', 'C', 'B',
    'D', '2', '2', 'D', 'D', 'E', 'A', '0', 'A', 'B', 'D', '1', 'A', '4', '9', '1',
    '7', '7', '7', '9', 'E', '5', 'E', '9', 'A', 'B', 'F', '1', '1', '3', '9', '1',
    'F', '4', 'C', 'B', 'A', 'F', '1', '4', '2', '8', 'D', 'C', 'D', '0', '2', 'B',
    '3', 'A', 'B', 'B', '4', 'A', 'A', '3', '1', '9', '0', '7', 'C', '6', '7', '5',
    '4', 'D', '0', '9', 'A', '7', 'E', '1', '2', '0', 'D', '2', 'E', '0', '4', '5',
    'C', '1', 'F', '1', '7', 'C', 'B', 'E', 'C', '9', '2', '4', 'B', 'A', 'D', 'B',
    '6', 'F', '9', 'D', '0', '5', '0', '2', '8', '5', 'A', 'D', 'E', '6', '3', '2',
    '1', '4', '5', '8', '4', '5', '4', '4', '2', 'D', '6', 'F', 'F', '6', 'E', '4',
    '8', '4', '8', '8', '5', '0', 'D', 'F', '5', '4', '1', '1', '2', 'A', '0', '3',
    'B', '1', '4', '1', '0', 'F', 'C', 'E', '9', 'D', '6', '2', '8', '6', '3', '4',
    '8', '6', 'D', '9', '6', 'F', '9', '9', '1', '5', '3', 'A', 'C', '9', 'B', '8',
    '0', '5', '1', 'D', 'D', '0', '5', 'E', '3', '4', '4', '1', 'B', 'B', '7', '8',
    'B', '8', '6', 'A', 'B', '6', 'D', '2', 'D', 'C', '4', '6', '5', 'C', '0', 'A',
    '8', 'E', 'A', '6', '4', '5', 'C', '2', '4', '0', '7', 'E', '1', '9', 'C', 'E',
    'F', '9', '6', '5', '1', 'D', '0', '6', 'E', 'E', 'C', 'F', 'F', '6', 'C', '0',
    'D', '6', '2', 'F', '4', '3', '3', '0', '3', 'D', '0', '3', 'C', 'F', 'D', '3',
    '7', '3', '9', 'E', '6', 'C', 'E', '5', '4', '3', '6', 'D', '0', '2', '8', '9',
    '0', '8', 'A', 'D', '3', 'B', '4', '3', '3', 'B', '5', 'D', 'C', 'F', 'B', '1',
    'D', 'E', 'D', 'A', '0', '6', '4', 'D', '9', 'B', '1', '9', 'B', '5', 'E', '8',
    'B', '0', 'E', '6', '7', '1', '7', '1', '5', 'B', '4', '4', 'D', 'D', 'B', '1',
    '4', 'A', 'B', 'E', '1', '0', '8', '0', '4', 'B', '0', '3', '8', '0', '4', '4',
    '3', 'A', '1', 'A', 'E', '4', 'E', '4', '5', '4', '6', 'F', 'B', '4', '4', 'F',
    'E', 'F', '3', '1', 'E', 'A', '7', 'C', 'E', 'A', 'B', '1', '7', 'E', '0', '7',
    '1', '6', '2', '9', '8', '8', '8', '1', '7', '0', 'E', '1', '8', 'B', '4', 'E',
    '1', '0', 'D', '5', 'A', '8', '5', '7', '1', '4', '8', '1', 'D', 'B', 'B', '2',
    '9', 'E', 'B', '2', 'B', '0', '3', 'E', '4', 'D', '6', 'D', '7', 'F', 'D', '4',
    '1', '7', 'A', '3', 'E', '7', 'C', 'C', 'E', '9', 'F', '6', 'F', '8', 'F', 'C',
    '9', '2', '3', '6', '0', 'A', 'E', 'F', '0', '3', '6', '3', '4', '8', '8', '9',
    '5', 'E', '4', '7', '1', '8', '3', '1', '9', '6', 'A', 'C', '3', 'C', 'D', 'B',
    '7', '1', '3', '2', '2', 'C', '6', '0', 'F', '7', 'B', '0', 'C', '3', 'B', '8',
    '9', '4', 'B', '8', 'F', '6', 'F', '3', '3', 'A', 'F', '2', '8', '0', '7', '0',
    'F', '1', 'F', '3', '4', '8', '8', 'F', '9', 'A', '5', '3', 'B', '1', 'B', 'D',
    '9', '6', '7', 'B', '3', '8', '6', 'E', 'C', '4', 'A', 'B', 'B', '8', '9', '9',
    '7', '3', 'B', '4', 'E', 'C', 'C', '4', '7', '3', '8', 'D', '7', '7', '8', 'B',
    '5', '5', 'D', 'B', 'B', 'A', 'C', '7', '4', '5', 'B', '4', '0', 'C', '2', '3',
    '2', '1', '5', 'A', '3', '3', 'C', '1', '7', '4', '8', 'D', '5', 'B', 'C', 'D',
    'C', 'B', 'E', 'D', '6', '8', 'C', '4', '6', 'F', 'D', '3', '1', 'B', 'B', '8',
    '3', 'D', '8', 'B', 'A', 'C', '6', '0', '9', '9', 'C', '8', '9', '1', 'B', 'A',
    '3', '2', '7', '1', 'C', 'E', '6', 'E', 'A', '3', 'B', '6', 'F', 'F', '0', 'B',
    '2', 'A', 'E', 'B', '8', 'E', '7', '6', 'F', 'C', 'F', '4', '6', '6', '4', '0',
    '6', '3', 'B', 'F', 'B', '3', '9', '1', '6', 'A', 'D', '4', '9', '2', '5', '2',
    'F', 'C', '5', 'E', '3', '6', '6', '9', '7', '9', 'F', '5', '6', 'E', '3', '0',
    '0', '2', '8', 'B', 'D', '6', '8', '2', '1', '6', '4', '2', '5', '8', '8', '1',
    '1', '7', '9', '5', '5', 'D', '2', '3', '6', 'B', '5', 'E', '2', '3', 'F', '2',
    '9', 'D', '8', '0', 'F', '7', 'B', '6', '4', '2', '4', '9', '9', '3', 'B', '1',
    '0', '2', 'C', 'C', '5', '0', '1', '7', '7', 'E', '1', 'D', '9', 'C', '8', 'D',
    '1', 'D', '7', '1', '9', '5', 'D', '4', 'D', '2', '9', '9', '3', '9', 'F', '3',
    '8', '7', 'B', 'B', '2', 'A', '4', '7', '5', 'F', '9', '0', 'E', '1', '7', '1',
    'F', '9', 'F', '5', '3', 'E', '5', '2', '0', '4', '8', '3', '1', '9', '7', '2',
    'A', 'A', 'D', '4', '7', '0', 'C', '3', '7', 'E', 'B', 'C', '1', 'D', '4', '8',
    '9', '8', '9', '1', 'F', '8', '4', '2', '6', 'B', '4', '5', '0', 'C', '7', '0',
    '9', '6', '4', 'D', '0', 'A', '4', '8', 'E', '9', 'C', '9', '5', 'A', 'C', 'D',
    'C', 'C', 'F', 'C', 'C', '6', '9', 'A', '5', 'F', '6', 'A', '2', '9', 'B', '1',
    '5', '6', 'C', '5', 'B', 'F', '6', 'C', '3', '3', 'B', '0', 'F', '5', '0', 'F',
    '1', '3', '4', '2', 'F', '8', '8', 'D', '3', 'A', '3', '2', '3', 'B', '2', 'B',
    '2', '0', 'E', '5', '6', '9', '2', '5', '7', 'F', 'E', 'C', 'D', '3', '2', 'F',
    'F', '2', '4', '3', '3', '0', '7', '7', '2', '3', 'A', 'B', '8', 'A', '5', '4',
    '7', '1', '5', '8', '8', '5', 'B', 'E', '7', 'A', '7', '6', '7', 'B', 'C', '4',
    'D', '9', '4', 'C', '2', 'B', 'A', 'C', '0', 'B', '3', 'A', 'C', '4', '7', '6',
    '0', 'B', 'A', '2', 'D', 'A', '3', '4', '7', '0', '8', '4', '6', '5', 'F', '4',
    '6', 'B', 'A', '4', '0', '1', 'D', '2', 'C', '9', '2', 'B', '9', '0', '3', 'F',
    '1', 'E', '2', '3', '1', 'D', 'B', '0', 'E', 'A', '9', 'C', 'C', '2', '3', 'C',
    'B', 'D', 'D', '9', 'B', 'B', '2', '3', '5', '7', '4', '6', '2', 'F', 'F', '2',
    'C', '3', '5', '3', 'B', 'A', '1', '6', 'A', 'E', '8', 'C', '2', '6', '5', '8',
    '7', 'F', '8', '1', 'A', '5', 'C', 'B', '1', 'E', 'A', '2', '8', '1', '4', '0',
    '8', '7', '7', 'A', 'C', '7', 'E', '0', '2', '1', '7', 'E', 'D', '4', 'C', '6',
    'D', '6', 'E', '8', 'D', 'D', 'D', '2', '8', '2', 'E', 'E', '1', '8', 'C', 'C',
    '6', '0', '1', 'E', '4', 'F', '2', '7', '3', '9', 'E', '6', 'C', '1', 'C', 'A',
    'C', '2', '2', 'C', '9', 'B', '1', 'C', '2', 'F', '1', 'F', '6', '0', 'C', '5',
    'D', 'A', 'A', 'C', '0', 'D', 'D', '4', 'A', '6', 'D', '3', '8', 'F', '6', '4',
    'E', 'D', 'A', 'D', '5', '6', '1', '4', 'E', '0', '6', 'D', 'C', 'E', '9', '5',
    '8', '3', 'A', 'E', '7', 'F', '0', '5', 'A', '6', 'C', 'A', 'A', '0', '9', 'A',
    '9', 'A', '4', 'B', 'E', '4', '9', '7', '3', '7', '6', '9', '7', '8', 'E', '6',
    '8', 'E', 'E', 'B', '9', '0', 'E', '3', '6', '8', 'B', '1', 'E', '0', '0', 'B',
    'B', '0', '8', '3', '0', '2', 'F', 'F', 'C', '8', 'C', '5', 'D', 'E', 'E', 'F',
    '7', 'C', '0', '3', '8', '1', '3', '2', 'B', '9', 'F', '5', 'B', '5', '3', '9',
    '4', '1', '4', '7', 'A', 'B', 'B', 'A', '7', '0', '7', 'B', '3', 'A', '7', '5',
    'B', '4', '1', '0', '9', '4', 'C', '3', 'E', '7', '9', 'E', '3', 'B', '3', 'B',
    '5', '4', 'E', '3', '1', 'C', '8', '8', 'B', '2', '5', '2', '7', 'D', '9', '4',
    '2', 'D', 'C', 'E', '3', 'F', 'D', 'B', 'D', '0', '5', '9', '9', 'B', '3', 'F',
    'C', '0', 'E', 'E', '5', 'E', '8', 'B', '4', 'E', '5', '1', 'D', '0', '7', 'B',
    '7', '7', '0', '6', '9', '3', 'F', '9', 'E', '6', '1', 'D', '7', 'D', 'D', '5',
    '0', 'F', 'C', 'A', '8', '2', '2', 'C', '9', '1', 'B', '3', 'C', '7', '4', 'B',
    '4', 'F', '0', '2', '1', 'A', 'A', 'F', 'F', 'E', '4', 'C', 'A', '5', 'C', '7',
    'D', 'A', '0', 'D', '7', 'A', 'C', '2', '0', 'D', '3', '2', '0', '5', '6', '1',
    '9', '7', '7', '7', '4', 'C', 'D', '4', '1', '9', 'D', '6', '1', 'A', '1', 'F',
    '2', 'A', 'F', '2', 'C', '7', '0', 'C', '4', '1', '4', '9', 'B', 'C', '1', '3',
    '7', '6', '7', '5', 'C', '7', '0', '7', 'A', '4', '1', '2', 'E', '9', 'E', 'E',
    'E', '4', 'D', 'F', 'D', 'C', '3', '6', 'E', 'D', 'F', 'D', 'D', 'E', '0', '2',
    '0', '7', '8', '2', '3', '0', 'C', '0', '8', 'F', 'C', 'F', '2', '1', '6', 'E',
    'A', '9', 'F', 'E', 'C', '3', 'C', 'B', 'A', '1', '9', 'B', '5', '4', '7', '7',
    'F', '9', '6', 'C', '1', 'E', 'F', '3', '3', 'C', 'D', '2', '5', 'B', '2', '5',
    '7', '8', '8', 'C', 'B', 'D', 'F', 'E', '6', 'F', 'D', 'C', '6', 'D', 'D', '5',
    'D', '6', '1', '8', '7', '0', 'A', '3', '4', '7', '7', '4', '7', '0', 'E', 'B',
    'B', '4', 'A', '4', '5', 'D', 'B', '2', '7', 'E', '2', 'C', 'C', 'A', '8', '2',
    'E', 'F', '8', '4', '8', '9', 'C', 'E', '5', 'A', '0', '8', '8', '2', 'C', 'D',
    '4', '0', '5', '6', '2', '5', '2', 'E', 'E', '3', '8', '1', '1', '5', '6', '3',
    'E', 'B', '9', 'E', 'E', 'A', 'B', '6', 'B', '9', 'E', '6', '4', '0', 'D', '2',
    '9', 'D', '0', '7', '9', 'B', 'B', '3', '9', '5', '3', 'C', 'C', '2', '3', 'D',
    '3', 'D', '7', 'C', '3', 'C', 'D', '4', '2', '8', '4', '0', '3', 'C', '1', '3',
    '1', '9', '2', 'A', 'B', 'F', '2', 'B', '4', 'A', 'E', '3', '2', 'E', 'F', '7',
    '0', 'F', 'E', '0', '0', '1', '6', 'F', 'C', 'E', '2', 'B', '4', '8', '9', '6',
    'B', 'F', 'D', '5', 'B', '5', '0', '2', '0', '8', '4', 'E', 'D', 'B', '9', '2',
    'B', 'B', 'A', '9', '6', '8', 'D', '6', '3', '7', 'A', '6', 'B', '2', '1', '3',
    '6', '8', '8', 'F', '0', '2', '6', 'B', 'F', '5', '4', '3', 'A', 'A', '1', 'C',
    '4', 'D', '7', '5', 'D', '1', '0', 'E', '6', '3', '2', 'E', '0', '9', 'B', '2',
    '8', 'C', '8', '1', 'E', 'B', '4', '0', 'F', '2', 'E', '9', '6', 'F', '5', '0',
    'D', 'D', '6', '0', '6', 'C', 'F', '4', '5', 'D', '5', 'F', 'B', 'B', 'C', '9',
    'F', '2', '9', '2', 'A', '6', '5', 'D', '8', 'D', 'C', 'A', '0', '9', 'A', 'B',
    '2', 'A', '1', 'E', '2', '0', '4', 'C', '2', '6', '5', 'D', '3', '9', '3', 'C',
    'A', '7', '0', 'C', 'D', '5', '2', 'E', '2', 'F', '4', '2', '9', '9', '3', '4',
    'D', 'F', '4', 'D', '9', '1', 'F', '9', '4', '0', '9', 'D', '1', 'A', '7', '8',
    '8', '6', '9', 'A', '1', '8', '2', '0', 'A', '1', '8', '6', '1', '4', '9', '3',
    'B', '0', '3', '9', 'A', '3', '2', 'A', '4', '5', '9', '7', 'B', 'F', 'A', 'A',
    '2', 'B', '6', '6', '0', '5', '8', '6', 'C', '2', 'F', '9', 'C', 'B', 'A', 'B',
    'F', 'E', 'D', '5', '6', 'E', 'C', 'C', '7', '3', '9', '6', '9', '8', '4', '7',
    'B', '4', '0', '9', '7', '5', '5', '2', 'D', 'E', 'C', '4', '9', '5', 'A', '3',
    '3', '5', '3', 'D', '5', '1', '1', 'F', '3', '5', '7', 'E', '7', 'B', 'A', '0',
    '1', 'D', 'B', 'D', '6', 'B', 'D', '6', 'A', '8', 'B', '2', '0', '5', 'B', 'B',
    'B', '5', '5', '4', '7', '0', 'F', '6', 'F', '0', '1', '1', '5', 'E', '9', 'C',
    'E', '9', '1', '0', 'A', 'A', 'B', '7', 'B', 'F', '0', '7', 'F', '0', 'F', '4',
    'B', '8', '6', 'D', '3', '7', '8', 'A', '1', '1', '9', '0', 'C', '1', '5', '6',
    'A', 'B', '7', 'D', 'B', '9', '5', 'A', 'A', '8', '4', '3', 'C', 'A', '8', '6',
    '9', '0', 'C', 'D', '3', 'B', '8', 'E', '9', '1', 'F', '9', '4', '4', 'D', 'B',
    '7', '8', '5', '6', 'D', '1', 'D', '1', '4', '1', 'C', 'E', '8', '0', 'B', 'D',
    '4', '2', '3', '7', '6', '9', '3', '2', '7', '7', '6', '3', 'C', '0', 'C', '9',
    '5', '1', '9', '9', '6', 'F', 'F', '8', 'A', '4', '3', 'E', 'E', '5', '7', 'C',
    '5', 'A', '8', '3', 'D', '3', '9', '7', '9', '5', '0', '3', 'C', 'A', 'B', '1',
    '4', '1', '1', 'B', '5', 'A', '1', '7', 'F', '6', 'B', '9', '6', 'D', '4', '0',
    '6', 'A', '8', 'B', 'E', 'C', '9', '6', 'F', 'A', '2', 'E', 'C', '4', '0', 'E',
    '4', 'D', '8', '8', '0', 'A', '6', '4', 'C', 'E', '1', 'D', 'F', '3', '2', '6',
    'D', '2', '1', '7', '1', '3', 'F', 'D', '7', '4', '0', '2', 'C', '5', 'E', '5',
    '1', '1', 'D', '7', 'F', '9', '5', 'C', '8', 'C', 'F', '0', '4', '9', '1', '4',
    'C', '8', '4', '2', 'A', 'A', '5', '7', '4', 'B', '2', 'D', '5', 'E', '1', '2',
    '4', '9', 'D', '5', 'A', '2', '0', 'A', 'B', '0', 'C', '7', 'A', 'A', '4', '1',
    '7', '7', 'B', '8', '2', 'C', '4', '8', '2', '6', 'C', '5', 'B', 'A', '3', '5',
    'F', '4', 'C', '5', '9', '0', '9', 'B', 'E', '8', '3', '2', '3', 'A', 'E', '5',
    '3', '4', '3', '0', '4', 'C', '4', '6', '4', 'F', '7', '9', '4', 'C', '2', '0',
    '4', '2', '8', '0', '5', '1', 'D', 'B', '3', '9', '7', 'D', '0', '3', 'F', 'D',
    '4', '0', 'F', '8', 'D', 'F', '8', '3', 'A', 'A', 'C', '8', '9', '8', '9', '4',
    '5', 'B', '0', '8', 'B', '6', '8', '7', '6', '6', '7', '6', 'F', 'D', 'B', 'E',
    '9', '9', '0', '5', 'F', '9', '4', 'F', '8', 'C', '2', '8', '2', 'C', 'D', 'F',
    'F', 'A', '6', '5', 'D', '4', 'C', 'F', '2', 'A', '4', 'A', 'E', '6', '6', 'C',
    '6', 'F', '6', '2', '8', '3', '4', '5', 'E', '4', 'C', 'B', '8', '1', 'A', '6',
    'F', '1', '6', '6', 'E', 'C', '8', '5', '3', '0', 'A', '2', '7', 'F', '6', '8',
    '9', '9', 'A', '3', '6', 'E', 'E', 'E', '5', '4', '0', 'F', '2', '0', '8', 'A',
    '3', 'A', '1', '6', '9', '4', '3', '4', 'A', '8', '9', 'D', 'D', '2', 'F', '6',
    '3', '3', '2', '6', '6', 'C', 'A', '5', 'D', '0', 'D', '2', '3', 'C', '4', '4',
    '5', '3', '8', '6', 'B', 'F', 'B', 'D', 'D', 'C', '9', '2', 'E', '8', 'A', 'B',
    '6', '5', 'B', 'C', 'B', 'D', '8', '2', '9', '8', '3', '9', '6', 'F', 'A', '2',
    '5', '3', '0', '4', '2', '2', '2', 'D', 'A', 'D', '6', '4', '1', 'B', 'B', '7',
    '6', '7', 'A', '4', '1', 'F', 'B', '8', 'D', '9', '6', 'F', 'B', 'C', '8', '0',
    '2', '3', '6', '8', '6', '9', '1', '7', '7', '4', 'C', 'A', '0', '5', 'F', '5',
    '2', 'F', '9', 'C', '1', '8', 'B', '1', '4', 'B', '9', '0', 'A', 'A', '3', '1',
    '5', '6', '1', '5', '2', 'B', '0', 'E', '6', '8', '9', 'A', 'E', '7', '2', 'F',
    '6', '0', '5', '6', '6', '5', '5', '5', 'E', '7', '1', '6', 'A', '4', 'D', '0',
    'D', '2', 'C', '1', '5', 'B', '2', 'F', '6', '0', '7', 'A', 'D', '0', '4', 'E',
    'D', 'F', '4', '8', '4', '4', '1', '1', '2', '5', '7', '1', '5', '6', 'B', '9',
    '9', 'B', '0', '4', 'E', '7', '1', '1', '2', '5', 'D', '5', '3', 'D', '6', '1',
    '9', '6', 'D', 'B', 'B', 'B', 'B', 'B', '7', 'B', 'D', '2', '3', '5', 'C', '9',
    '1', 'F', '8', 'F', 'E', 'F', '5', '0', 'E', 'F', '7', '7', 'F', 'B', 'E', '5',
    'C', '0', 'E', 'B', 'B', '7', '3', '1', 'E', '0', 'A', '9', 'A', '0', '8', '1',
    '3', 'B', 'D', '4', 'F', 'D', 'A', 'F', 'B', '8', '7', 'E', 'B', 'E', '1', 'E',
    '5', '3', '1', 'A', '0', '4', '2', '5', 'F', '8', '8', '0', '8', '8', 'A', 'A',
    '3', 'F', '3', '7', 'D', 'C', '2', '5', 'E', 'E', 'D', '7', 'F', '7', 'B', 'D',
    '5', '9', '3', 'A', '5', 'D', '9', 'D', 'C', 'F', 'E', '9', '7', '3', '7', '6',
    '4', '7', '7', '4', '7', '1', '9', '7', '3', 'A', 'C', 'C', '6', 'A', 'F', '3',
    '8', '9', 'A', '4', 'C', 'C', '2', '6', '7', '8', 'A', 'E', 'C', '6', 'D', 'C',
    '7', '3', 'F', 'F', '4', '7', '1', '8', 'C', '3', 'F', '2', 'B', '4', 'F', '5',
    '5', '4', '8', '4', 'B', 'B', '5', '5', '2', 'C', 'D', 'F', 'B', '8', '4', '5',
    'C', '3', 'A', 'D', 'B', '7', 'B', '5', '1', 'E', '9', '9', '7', '9', '0', '8',
    '6', '3', '7', '5', 'D', '6', '4', '7', 'A', '2', 'B', 'D', '6', 'A', '0', '4',
    'D', '1', 'D', '8', '8', 'E', 'A', '3', '8', '3', '0', '9', 'B', 'B', 'E', 'E',
    'E', 'C', 'C', '4', '8', '6', '0', 'D', '5', '9', '2', '6', '6', '5', '6', '9',
    '0', '4', '5', '1', '9', 'E', '6', '0', '2', '8', 'F', 'F', 'E', 'C', 'C', '2',
    '5', '3', '8', 'E', '1', '8', '4', '8', '6', 'D', 'E', '8', 'C', '3', '9', 'D',
    'F', '2', '8', '7', '8', '0', 'B', '6', '6', '1', '7', '8', '1', '1', '0', 'B',
    '3', '1', 'D', '3', '7', 'B', '3', 'F', '5', '8', '0', '1', '4', '1', '5', '0',
    'D', '4', 'D', '3', '1', '7', '4', '8', '6', '7', 'A', '4', '1', '4', '8', '1',
    '5', '2', 'A', '9', 'A', '0', '3', '1', '3', '4', '6', '9', 'F', 'F', 'E', 'A',
    '2', 'C', '5', '0', '9', 'B', '9', '5', '9', 'F', '1', 'A', 'C', '2', 'F', 'B',
    '5', '1', 'B', '2', '3', '5', 'B', '2', '3', 'C', '2', 'E', '3', 'F', '7', '5',
    '6', 'A', 'D', '7', '2', 'C', '3', 'B', '7', 'D', 'C', 'B', 'D', '8', '4', 'B',
    '9', 'E', 'D', 'E', 'F', '7', 'A', 'C', '6', '6', '6', '6', 'A', '5', 'C', '5',
    'A', '3', '1', 'E', '2', '2', '2', '6', 'D', 'A', '3', 'F', '7', 'D', 'E', '4',
    '3', '9', '2', 'D', 'F', 'A', 'B', 'A', 'E', 'E', '2', '3', '1', 'B', '3', '3',
    '0', 'F', 'F', 'D', '0', '5', '3', 'B', '5', 'F', 'B', '5', 'D', '4', '6', '4',
    '6', 'E', '1', '7', '3', '5', '6', '9', 'B', '8', '7', '9', '2', 'E', '9', 'A',
    '8', 'F', 'D', '9', 'E', 'B', 'F', 'F', '6', '2', '5', 'B', '6', '9', 'C', '4',
    '8', '6', 'B', '8', '7', '8', '3', '5', '9', 'F', '5', 'F', '7', 'F', '6', '2',
    '3', 'C', '5', '3', '4', '7', '6', '2', 'E', 'B', '4', 'D', '7', '0', '3', 'D',
    'D', '3', 'B', '6', '7', '0', '7', 'A', 'E', '4', '1', 'F', 'D', 'D', 'F', '6',
    '2', '4', '7', 'F', '4', '1', '3', '8', 'C', 'E', 'F', 'F', 'C', '4', '1', '4',
    'A', '4', 'D', '3', '6', 'F', '7', '4', '5', '1', '9', 'D', 'A', '0', 'A', '1',
    '5', '4', '6', 'A', '8', '8', '4', '6', 'F', 'F', '8', 'D', 'C', '3', '7', '9',
    'D', '1', 'C', 'F', 'D', '2', '0', '8', '6', '3', '6', 'A', 'F', 'B', '5', 'F',
    '8', '7', '6', '3', 'B', 'F', '9', '5', 'C', '1', '4', '8', '9', '4', '9', '8',
    '9', '4', 'A', '2', '2', 'D', 'C', '5', '5', '9', '1', '8', 'A', '6', '2', '6',
    'A', '1', '6', 'F', '2', 'F', '5', 'F', '4', 'D', 'E', 'E', '1', '6', '9', '1',
    '6', '2', 'A', '7', 'B', 'E', 'B', '0', '0', '8', '1', 'B', 'B', '4', '9', '0',
    'C', '2', '9', '8', '3', '1', 'F', '5', '4', 'F', '8', '1', '6', '8', '5', '4',
    'E', '4', 'F', '6', 'C', '4', '2', '1', '5', 'D', 'E', '4', 'B', '0', '2', '7',
    '9', 'C', 'C', '5', 'B', '1', '7', 'A', '2', '9', 'F', '5', 'F', '5', '7', '3',
    '4', '5', '0', '9', 'F', '3', '1', '3', '5', 'D', '8', '3', '8', '4', '1', 'D',
    '0', 'F', '5', 'B', 'F', '8', 'B', '6', '0', '6', '4', '6', 'E', '3', '1', '5',
    '2', '4', '8', 'C', '5', '3', 'E', '4', 'E', 'A', '3', 'E', '6', '5', '2', 'A',
    '1', 'C', '3', '8', '2', '3', '8', '1', 'E', '2', 'C', 'E', '5', '3', 'E', 'B',
    '0', '3', '1', 'E', '4', 'C', '9', '2', 'B', '7', '8', 'C', 'E', 'F', '3', 'E',
    '9', 'D', 'C', '8', '4', '4', 'F', 'E', 'B', '6', '5', '7', '6', 'F', 'C', '3',
    '7', '1', 'F', '8', 'D', 'C', '3', '6', '8', '3', '3', '6', '2', '7', 'E', '9',
    'F', '1', 'A', 'F', 'D', 'A', '2', '8', 'A', 'F', 'E', '0', 'F', '8', '7', 'A',
    '8', '6', '9', '7', '4', 'B', 'E', '0', 'E', '4', 'D', '0', 'C', '2', '0', 'D',
    'F', '7', '0', '9', '9', '8', 'B', '0', '4', '0', '1', '4', 'D', '9', 'C', 'E',
    '0', '5', '4', '2', '9', 'E', 'B', '6', '9', 'D', '6', '4', '4', '0', 'A', '9',
    'A', '5', 'C', '4', 'A', 'C', '3', 'A', 'A', '9', 'B', '6', '8', '4', 'B', '4',
    'D', 'E', 'B', '6', 'A', 'E', '5', '4', '1', '1', '5', '0', '8', '8', 'F', '2',
    '1', 'A', 'F', '4', '2', '6', '6', '1', 'F', '0', '4', '7', '5', '2', '1', '5',
    '6', 'C', '3', 'E', 'F', '1', 'A', 'D', '1', '1', '1', '4', 'B', 'E', 'F', 'D',
    '4', 'E', '7', '6', '5', '1', 'C', '4', '2', 'D', '2', '9', 'B', 'F', '0', '5',
    'C', '2', '3', '0', '2', '0', '4', '2', '2', '4', '0', 'F', 'C', '0', '5', '5',
    'C', '2', '4', '5', '3', 'B', '0', 'F', 'E', 'E', 'B', '3', 'B', '4', 'F', '2',
    'B', 'A', 'A', '5', 'D', '6', '0', 'E', '0', 'D', 'A', 'E', '8', 'F', 'D', '8',
    '8', 'B', '8', '2', 'B', '6', '9', 'F', '4', '4', '3', '8', '3', 'D', '8', '9',
    '6', '5', '1', 'D', '6', 'A', '3', '6', 'C', 'B', '9', 'A', '8', 'B', '8', '5',
    '6', '7', '6', '8', 'B', '4', 'D', '5', '1', '8', '9', '1', 'E', 'F', '9', '2',
    'E', '8', 'F', 'A', '6', '8', 'A', 'D', '5', 'D', 'D', 'D', 'E', '0', '7', '4',
    'F', '3', 'D', '9', '8', '1', 'D', '8', '2', '9', 'F', 'D', 'D', '5', '4', '3',
    '2', '0', 'F', 'B', '4', '2', '7', '3', '1', '8', 'F', '6', '2', '6', 'E', '9',
    '2', '0', 'D', '1', 'F', '4', '7', '8', '6', '6', 'A', '7', 'D', '2', '8', '4',
    'E', '9', '1', '2', 'C', '4', '3', 'C', 'E', '2', 'D', '8', 'C', '6', 'C', 'A',
    '7', 'F', '3', '3', '7', '1', '6', '3', '5', '0', '3', '8', 'C', 'F', '1', '8',
    '2', '7', '0', 'B', '3', 'B', '8', '8', '5', 'C', '1', '4', '9', '0', '1', 'D',
    'F', 'E', '3', 'E', '9', '7', 'C', 'E', 'A', '4', '3', 'D', 'A', 'B', '9', '6',
    '8', '4', 'C', 'B', '5', 'E', '3', '4', '5', 'E', '8', '7', '5', 'E', '0', 'A',
    '6', 'D', 'F', '0', 'F', '6', 'B', '3', 'A', '7', 'E', 'B', '5', 'D', '9', '9',
    '3', '8', '9', 'E', 'E', '9', '3', '0', '7', '9', 'F', 'D', '3', '2', 'A', '2',
    'C', 'B', 'F', '0', '1', 'B', 'B', '5', '5', '0', '2', '9', '5', '2', 'B', 'A',
    'A', '3', '9', '0', '0', '1', '3', '0', '9', 'D', 'A', 'A', '1', 'F', '2', 'A',
    '6', '6', 'C', '0', 'E', '5', '5', 'B', 'B', 'E', '5', 'F', '1', 'A', 'C', '7',
    '5', 'C', '9', '5', '6', '8', 'A', 'A', '5', 'E', 'E', '4', '9', 'F', '9', '2',
    '0', '0', '4', '6', '0', '1', '4', 'E', '7', 'D', '8', '6', '2', '6', '6', '5',
    'B', '3', '0', '5', '6', '5', '1', '2', '1', '2', '0', 'B', '4', 'A', '9', '6',
    '4', 'E', '9', '3', 'C', 'A', 'D', '3', '6', 'E', '6', 'F', 'B', '8', 'B', '7',
    '0', '3', 'B', '4', '8', '0', '0', '3', '8', '0', '1', '7', '8', 'C', '5', '3',
    '2', '9', 'C', '0', 'C', '1', '4', 'E', 'A', '7', 'F', 'C', '9', '4', 'E', '0',
    '5', '9', '6', '3', 'E', '3', '0', '3', '4', '4', '9', '4', 'F', '5', '4', '3',
    '6', '5', '3', '9', 'C', '8', '7', '2', 'F', '9', '9', '5', '6', '4', 'F', 'D',
    '1', 'D', 'D', '0', 'E', '5', '1', '3', '1', 'D', 'D', '4', 'E', '0', '3', '2',
    '6', '9', '5', 'F', '3', '3', '4', 'C', 'E', 'C', 'D', '2', '0', 'C', 'D', '8',
    '1', '1', 'C', '1', 'E', 'A', '9', 'B', 'E', 'F', 'D', 'C', 'D', 'F', '1', '8',
    '5', '9', 'A', '9', 'B', '1', 'C', 'D', '8', '9', 'A', '1', '9', '3', '6', 'A',
    '5', 'E', 'F', 'D', '1', '3', '6', 'A', '4', 'A', '0', '0', '1', '5', '4', '7',
    '1', 'A', '6', '4', '6', 'B', 'C', 'A', '4', 'D', 'A', '3', 'B', '8', '5', 'E',
    '7', '7', '0', 'B', '7', 'D', '8', '0', '3', '4', '6', '3', '0', 'D', '1', '4',
    'D', 'D', '8', '3', 'C', '4', 'C', '8', 'F', 'E', '4', '8', 'D', 'D', '3', '0',
    '6', '7', 'F', '2', '5', 'C', '0', '7', '7', '4', '3', '4', '9', 'D', '9', '8',
    '0', '7', '1', '7', 'C', '3', '4', 'E', '7', 'D', '9', '1', '0', 'D', '1', 'A',
    'D', 'D', 'B', '6', 'A', 'C', '4', '6', 'F', '2', '8', '8', 'B', 'B', '5', '3',
    'C', 'E', 'A', '1', '0', '3', 'F', '0', 'A', 'B', '1', 'F', '2', '8', '2', '1',
    '6', '0', '6', '1', '7', '2', '9', 'B', 'A', '4', '0', '7', '7', '5', '2', '9',
    'C', '6', '8', '1', 'E', '7', 'D', '6', '5', '1', 'A', 'C', 'C', '7', 'B', 'D',
    '1', 'A', '8', 'B', '6', '6', 'D', 'A', '8', '7', '9', '2', '3', '1', '3', 'A',
    '0', '9', '1', '5', '8', 'C', 'C', 'C', '2', '0', '0', '6', 'E', 'C', 'A', '9',
    '4', 'C', '3', 'A', '2', '1', '2', 'B', '4', 'B', '7', '3', '7', 'C', '9', '6',
    '9', 'C', '6', 'D', 'B', '5', '7', '0', 'B', '7', 'E', '0', 'A', '4', '4', '3',
    '0', '9', '9', 'A', '7', '2', 'E', 'C', 'B', '5', '7', '1', 'C', 'A', 'A', '7',
    'B', 'F', 'C', '5', 'C', 'F', '5', '8', 'E', '9', 'D', '6', 'D', 'E', '3', '0',
    'A', '4', '2', 'F', 'D', 'D', '1', 'A', 'B', 'C', '8', 'A', 'D', 'F', 'C', '8',
    '1', 'F', 'F', '6', '8', 'D', '2', 'E', 'C', 'E', '9', '4', '2', 'B', 'C', 'A',
    '4', '0', '9', '6', '4', '3', '7', '3', '3', '0', '2', '0', 'F', 'C', '5', '6',
    '9', '8', '1', '1', '1', '8', 'D', '8', 'D', '0', 'A', '1', 'F', '5', 'F', '3',
    '0', '7', '5', 'B', '3', 'F', 'D', '1', '4', 'F', 'C', '7', '0', '2', '3', '7',
    '8', '6', '9', '1', 'A', 'C', '6', '7', '3', '0', '2', '3', '5', 'D', '5', 'E',
    '6', '7', 'C', '8', '6', '0', '9', '9', '2', '8', 'E', '2', '2', '7', '2', '4',
    '5', 'B', '8', '4', '4', 'E', '8', 'F', '6', 'E', '9', '2', 'C', 'D', '2', '0',
    '7', '6', '4', '8', 'C', 'D', '4', 'E', '5', 'A', '1', 'E', '4', '6', 'E', '8',
    'E', '0', '5', '8', 'F', 'C', 'F', '0', '4', 'F', '7', 'D', 'E', '8', '2', '5',
    'B', 'A', '6', '1', 'C', '5', 'C', '2', '0', 'E', 'D', 'C', '1', '3', '2', 'C',
    '8', '3', 'A', 'E', '1', '6', '2', 'B', '6', 'A', 'D', '0', '7', 'A', 'D', '4',
    '3', '4', '9', '2', '2', '1', '5', '1', '4', 'D', 'B', 'A', 'B', 'F', '5', 'C',
    'D', 'E', '4', 'C', '7', '4', 'E', 'E', '6', '2', 'B', 'D', '4', '1', '5', '2',
    '9', 'B', '0', 'F', 'A', '0', 'D', '7', '3', 'D', '8', '5', '1', 'D', '7', '2',
    '5', '5', '8', 'F', '1', '7', '9', '5', 'B', '8', '2', '7', '2', 'E', '8', 'F',
    'F', 'F', '2', 'A', 'D', '9', 'E', '9', '5', '4', 'D', '6', 'F', 'F', '9', '7',
    '5', 'F', '0', '8', '4', '1', '6', '8', '5', '2', 'A', 'B', 'F', '2', 'D', '8',
    '1', 'D', 'A', 'A', '5', '2', 'B', 'B', '4', '5', '2', 'F', '3', 'A', 'A', 'F',
    '6', '7', '8', 'E', '7', 'C', '0', '4', '1', '7', '6', 'C', 'A', 'D', '5', '6',
    'D', 'B', 'D', '1', 'C', 'B', '9', '3', 'B', '1', 'B', '7', '4', 'F', '8', '5',
    'B', '7', 'A', 'F', '5', 'C', '4', 'E', 'E', '0', '3', '1', '2', '3', 'A', '1',
    '7', '3', '8', '0', '1', '6', '9', '9', '8', '4', '0', 'F', '2', '1', '3', '0',
    'F', 'E', '2', 'D', 'C', 'D', '3', '5', '0', 'C', '7', 'D', 'C', 'C', '0', '0',
    'A', 'D', '0', 'E', 'D', 'F', '9', '1', '2', '9', 'E', '7', 'C', '2', 'E', '6',
    'A', '6', '5', 'D', '2', 'C', '3', 'B', '0', '6', '2', '3', 'B', '2', 'E', '7',
    '4', '9', '1', '6', 'A', '3', '5', '7', '0', 'D', '0', 'C', '9', '8', '1', 'E',
    'D', 'B', '0', '2', '8', 'D', '9', 'F', '1', '8', '9', '0', '0', 'A', 'A', '2',
    '0', '5', '3', '9', 'F', 'F', 'A', '3', 'E', '7', '7', 'F', '3', '6', 'D', 'C',
    '8', '4', '6', 'D', '1', 'B', '4', '8', '0', '2', 'B', '5', '8', '1', '2', '4',
    '1', 'A', 'E', 'D', '8', 'B', 'A', 'A', 'A', 'E', 'F', '5', 'F', 'D', 'A', '5',
    'A', '4', 'D', 'D', '5', '1', 'E', '2', '5', '2', '0', '7', 'E', 'F', 'C', '1',
    '0', 'B', '5', '1', '4', '7', '8', '3', '6', '1', 'E', 'C', 'A', '4', '1', '2',
    'F', 'B', '8', '6', 'B', 'E', '9', 'D', '8', 'B', '4', '8', 'F', '8', '5', '4',
    'C', '1', '6', 'C', '5', '8', '1', '6', '7', '2', 'C', 'C', '5', '3', 'A', '0',
    'C', '9', '4', 'A', '2', 'F', 'B', '7', '4', '6', 'F', '2', '6', 'B', 'F', 'C',
    '6', '2', 'A', 'D', 'D', '1', 'B', 'B', '0', '9', '9', '8', '3', '8', 'C', '4',
    '2', '9', '1', '0', '2', '7', '8', '6', '5', '7', '8', 'E', '7', 'A', '1', '0',
    '4', 'C', '3', 'C', 'D', '4', '4', '1', 'D', 'C', '5', '1', 'C', 'B', '5', '2',
    'B', '6', '1', '6', '6', '4', 'C', 'D', '7', 'C', '7', '1', 'A', '5', 'B', 'A',
    'F', 'D', 'D', '5', 'E', 'B', 'A', 'D', '6', 'A', '9', 'A', '6', 'B', '5', '3',
    '8', '0', 'C', 'A', 'B', 'A', 'D', '7', '1', '0', 'B', '1', 'F', 'B', '9', '8',
    '1', '4', 'F', '8', '7', 'F', '5', 'D', '5', '9', '5', '1', 'D', '9', '0', 'A',
    '1', '7', '4', '2', '4', 'C', '6', '6', '8', '3', '9', '8', '0', 'A', '8', 'D',
    'C', '1', '6', '9', '7', 'A', 'E', '6', '3', '8', '8', '4', 'F', '6', 'F', 'B',
    'A', '8', '5', '3', '9', 'E', '9', 'E', 'E', '6', 'B', 'D', '8', 'E', 'C', 'C',
    '6', 'D', '4', 'F', '1', 'A', '2', '8', 'B', '0', 'B', '2', 'D', '4', 'B', 'C',
    '8', 'C', '2', '4', '0', 'A', 'F', 'B', 'E', '1', 'C', '0', '2', 'B', 'D', 'A',
    'E', 'B', '9', '0', '9', '1', 'D', 'F', '6', 'B', '7', 'A', '0', '0', 'A', '6',
    'C', 'F', '6', 'A', '5', '9', '3', 'B', 'B', '2', '5', 'C', '7', 'D', '6', 'D',
    'F', '1', 'A', 'D', '6', 'C', 'B', 'C', '2', '1', 'E', 'B', 'F', '2', '5', '7',
    'C', '8', '1', '2', 'B', '1', '9', 'E', 'B', '2', '1', '5', 'A', 'D', '0', '0',
    '6', '1', '7', 'A', 'D', '0', '8', 'D', '2', '0', '0', 'D', '2', '8', '5', 'F',
    'A', '0', 'A', '6', '2', 'A', 'C', 'D', '5', 'D', '3', 'D', 'F', '3', '5', '5',
    '8', '8', 'D', '6', '3', '4', 'A', '1', '9', '8', 'D', '3', '7', 'B', '9', '5',
    '8', '9', '0', '8', '6', '8', 'D', 'D', 'E', 'D', '5', 'C', '2', 'F', '4', 'C',
    'C', '1', 'A', '8', '4', '2', 'C', 'A', '0', '6', '9', '4', 'F', 'A', '8', '5',
    'F', '0', '5', '1', '7', 'F', '1', '9', '1', '0', 'F', 'C', 'C', 'D', '1', '4',
    '2', 'A', 'E', 'B', '5', '6', '0', 'D', 'B', 'F', '6', '0', 'C', '3', 'F', 'A',
    '1', '6', 'B', '2', '9', 'B', '1', '9', '3', '7', 'E', 'A', 'A', '2', 'C', 'B',
    '7', '4', 'B', '0', '7', 'A', '6', '9', '5', 'F', 'E', 'A', 'E', '5', '1', '9',
    'F', '4', 'F', '8', '1', 'C', '8', 'F', 'B', '0', '8', '4', 'D', '0', 'D', 'F',
    '6', '6', '7', 'C', '2', '4', 'E', '3', 'F', 'E', '6', 'F', 'A', 'F', '8', '0',
    'A', 'E', '9', '8', '3', 'E', '9', 'F', 'E', 'C', '6', '5', '8', 'D', 'D', '1',
    '4', '9', 'A', '9', '8', '3', 'F', '1', '6', 'C', 'B', '5', 'D', '6', '6', '6',
    'D', '5', '9', 'A', 'F', 'C', '0', 'E', '7', '5', '2', '2', '3', '3', 'B', '7',
    '1', '2', '4', '9', 'F', 'E', '5', 'B', '9', 'C', 'E', '1', '9', '6', 'B', '1',
    '8', '9', 'F', 'E', '7', '9', '4', 'B', 'A', 'B', 'C', 'D', 'D', 'B', 'D', '0',
    '5', '8', 'F', 'D', '2', '2', '1', 'C', '0', '2', '7', '6', 'E', '2', '8', 'B',
    'D', '3', '4', 'D', 'C', 'A', 'A', 'B', 'E', '8', 'A', 'A', '1', 'D', 'C', '4',
    '9', '7', 'F', 'B', 'E', '9', '3', '1', '7', 'E', '4', '6', '7', '4', 'B', '8',
    '6', '6', '9', 'B', 'C', '4', 'C', '2', '1', '7', '4', '6', '2', 'F', '7', '7',
    '5', '4', 'E', '9', 'C', '3', 'A', '7', 'F', '1', '3', 'C', '7', '9', 'E', '2',
    '8', '8', '0', 'A', '4', '1', '8', '2', 'A', '9', 'D', '0', '0', '1', '2', '0',
    'D', 'C', 'B', 'E', 'D', '4', '5', '9', '6', '3', '5', 'E', 'B', 'E', '5', '3',
    '8', '9', 'B', '7', 'C', 'E', 'F', '4', '9', '2', 'B', '2', 'E', '6', 'C', '8',
    'B', '0', '0', 'D', 'E', 'C', '3', '9', 'F', 'D', 'F', 'D', '2', '4', '5', '4',
    '3', '0', '8', '9', '7', '4', '8', '9', '8', '4', '7', '8', '4', '7', '8', '3',
    'A', 'E', 'A', '0', '9', '9', 'B', 'D', '3', '7', '6', 'A', '7', '5', '4', '8',
    '6', 'F', '3', '4', '9', 'C', '8', '8', 'A', 'E', 'C', '5', 'D', 'E', '5', 'D',
    'A', '0', 'E', '1', 'E', 'D', '7', '6', '2', 'F', '9', '3', 'B', '3', 'C', 'A',
    '8', '4', '4', 'A', '1', '6', 'F', '9', '0', '1', 'C', '3', '9', '6', '6', '3',
    '4', '0', '7', '1', '2', 'E', '8', 'C', '1', 'F', 'B', 'D', '7', 'C', '2', '5',
    '9', 'C', '7', '7', 'D', '2', '6', 'B', '1', 'A', '3', '7', '5', '3', '6', 'C',
    '0', '8', '5', '8', '5', '9', '3', '5', 'F', 'B', '0', 'D', 'F', 'E', '5', '5',
    'D', 'B', 'D', '4', '8', 'E', '3', '1', 'B', '9', '5', 'D', '8', '6', '8', '0',
    '3', 'D', '0', '9', '2', 'C', '2', '4', 'B', '3', '5', '7', '6', '3', '4', 'F',
    'B', 'F', '0', '1', 'C', '6', 'C', 'B', '3', 'A', '6', '0', 'E', 'B', '6', 'E',
    '1', '5', '3', 'E', 'C', 'E', 'E', 'F', 'C', 'E', 'F', '4', '8', 'A', '4', '7',
    '3', '8', '4', '4', '7', 'E', 'F', '3', '6', '2', '1', 'F', '0', '8', '1', '8',
    '5', '2', '3', '7', '8', 'B', 'E', '9', '3', '8', '4', 'F', '4', 'B', '6', 'E',
    '2', '9', '5', 'B', '3', '7', '7', 'B', 'D', 'C', '6', '8', '3', '4', 'C', '7',
    'C', '0', '2', '0', 'A', '2', '6', '6', '3', '9', 'F', '4', 'C', 'B', '2', '9',
    '9', 'A', 'D', 'C', '5', '0', 'E', '5', 'F', 'E', '5', '7', 'C', '9', 'A', '0',
    'F', '2', '6', 'D', '6', '4', 'C', 'C', '6', '3', '1', 'E', 'F', '5', '7', '8',
    '9', 'D', 'F', 'C', '4', 'D', 'E', 'C', '9', '8', 'F', '1', '5', '9', '9', 'E',
    '0', '5', '4', '4', '4', '5', 'C', '4', '8', 'A', '6', 'A', 'E', '5', '4', '9',
    '9', '8', '1', '7', '1', '0', '5', '6', 'C', 'A', '2', '4', '8', 'A', '2', 'C',
    'B', '9', '4', '3', 'B', 'F', 'F', 'D', '6', '0', '0', '9', '9', '9', '3', '4',
    '3', 'D', 'F', '7', 'D', '0', '9', '1', '2', '0', '8', '6', '7', 'E', '0', '3',
    '2', 'C', '4', '4', '4', '6', '0', '1', 'E', 'A', 'A', 'A', '9', '1', '9', 'B',
    '1', 'C', '6', '5', '3', '4', '9', '3', '6', '7', '9', '5', '4', 'B', 'E', 'F',
    '4', 'A', '3', '1', 'E', 'D', '4', '2', '8', 'D', 'D', 'F', '4', '2', 'A', '2',
    '4', '6', '7', 'A', 'A', 'C', '6', '0', '1', '2', '1', '4', '0', 'F', '1', '7',
    '5', '5', 'F', 'E', '0', '2', '3', '8', '4', '8', 'B', '6', '3', 'A', '6', '6',
    '4', 'D', '0', '3', '9', '1', '3', 'C', '1', '7', '6', 'D', '4', '8', 'B', 'C',
    'A', 'E', '0', '0', 'E', '7', '6', 'A', 'C', 'B', 'B', '6', 'A', '1', '2', 'B',
    '1', '1', 'A', '5', '6', '1', '6', 'D', '1', 'C', '1', '8', '5', '2', '6', 'D',
    '5', 'F', '4', 'D', 'F', 'A', '8', '5', 'A', 'C', 'F', 'E', '4', '4', '1', '4',
    '7', '8', 'F', 'C', 'D', '9', '6', '2', 'C', '5', '6', '8', 'F', 'D', 'A', '2',
    '4', '6', '2', '1', '8', '1', 'D', '3', 'C', '9', 'D', '3', '1', '6', '9', '5',
    '8', '4', '8', 'E', 'B', '6', '1', 'C', '5', '2', '5', '6', '9', 'B', '4', 'C',
    '9', '4', '2', 'A', '9', '9', 'D', '4', 'C', 'E', '4', '8', '3', '7', 'B', '3',
    '3', 'C', 'B', '8', 'A', '5', '6', 'F', '8', '1', 'D', '4', '8', 'B', '1', 'B',
    '6', '2', '2', '8', 'B', 'D', '6', '7', '9', '4', '7', '5', '2', 'A', 'B', '3',
    'B', 'D', 'D', 'E', '5', '0', 'C', 'B', 'B', '4', 'E', 'F', 'A', '9', '4', '9',
    'B', 'D', 'E', '5', '4', '8', '8', '0', '0', 'A', '2', 'F', 'B', 'E', '2', 'B',
    'E', '5', 'C', '6', 'D', '7', '3', '5', '1', '8', '2', 'C', '6', '4', '5', '2',
    '3', 'F', 'C', 'E', 'E', '4', '7', '9', '8', '4', '4', 'C', '9', '8', 'C', 'A',
    '4', 'B', 'A', '2', '2', '1', 'B', 'B', '9', '8', '1', '0', 'B', 'D', 'D', '7',
    '0', '3', 'D', '0', '2', 'B', '1', '5', '3', '9', '3', '8', 'F', '5', '0', '9',
    'D', '5', 'D', 'F', '7', '3', 'A', '9', 'F', '0', '9', 'B', '6', '1', '6', 'A',
    'F', '9', '0', '1', 'B', 'D', 'F', '0', 'C', '6', '7', '5', '9', 'A', '5', '4',
    'B', '6', '6', '8', '0', 'B', '7', '8', '5', '4', 'D', '5', '0', 'D', '8', 'E',
    'D', 'D', '7', '1', '4', 'E', '9', 'A', '9', '0', 'E', '5', '5', '8', '4', '3',
    'A', 'F', '0', 'E', 'C', '5', 'B', 'C', 'C', 'A', '3', '5', '8', '8', '5', '0',
    '9', '6', '5', '5', '4', 'C', '0', '6', 'F', 'B', '9', '2', 'C', '0', 'C', '8',
    'B', '9', 'A', 'E', '9', '6', 'A', '7', 'B', '7', '0', '2', '2', 'A', '3', 'E',
    '7', '2', '8', '3', '4', 'E', '2', '0', '8', '1', '2', 'C', '1', '4', '4', 'F',
    'B', '3', 'F', '8', '1', '2', '3', '1', 'E', '7', '6', '5', '8', '8', '8', '5',
    '2', '0', 'A', '0', '9', '1', '0', '6', 'E', 'B', '7', 'D', '8', 'E', 'A', 'A',
    'C', 'B', 'F', '5', 'A', 'B', 'F', '2', '3', '1', '1', '2', '0', '8', '4', '6',
    'C', '5', '8', 'E', 'E', '3', '3', '1', '2', '1', '9', '1', '9', '3', '9', 'B',
    '6', '3', '4', '4', '5', '6', '3', 'B', '2', '1', 'D', '0', 'B', 'B', '4', '5',
    '4', 'D', 'C', '0', '8', '1', 'C', '0', '7', 'A', '7', '2', '1', '4', 'B', '3',
    '8', 'D', '4', '4', '7', '6', '4', '5', 'B', '3', '3', '1', 'F', '2', '9', '9',
    'C', 'E', '5', 'F', '4', 'F', 'F', 'F', '5', 'D', '8', '5', '4', '4', 'B', '4',
    'F', '7', '6', '2', '4', '3', 'E', '8', 'E', '7', 'E', '1', '3', '5', '6', 'A',
    '9', 'B', 'D', '4', 'A', 'A', 'F', '4', '2', 'C', '1', 'B', '8', 'A', '6', '6',
    'A', '7', '9', '3', '1', 'E', '9', '6', 'F', '0', 'C', 'A', '4', '3', '0', '9',
    '3', 'A', '0', '0', 'C', '9', '6', 'C', 'A', '4', '6', '2', '5', '9', '7', '2',
    '5', '1', '3', 'A', '1', '0', '7', '4', 'C', '7', '4', '9', '2', '3', '5', '0',
    '1', 'D', '2', '9', '6', 'B', 'E', 'E', 'A', '5', '9', '5', '0', 'C', 'D', '4',
    '9', '8', '5', '8', '7', 'B', 'D', '6', '6', '0', '6', 'A', 'E', '3', '6', 'D',
    '4', '4', 'C', 'C', '0', '9', '1', 'A', '3', 'E', '6', '2', '0', '8', '5', 'A',
    '1', '8', '7', '4', '9', '3', 'E', 'F', 'B', '7', 'C', 'E', 'E', '0', '8', '9',
    '6', '9', '4', '0', 'D', '0', 'C', '7', 'C', 'E', '5', '1', 'E', '8', '4', '4',
    '0', '5', '3', '3', '2', '3', '1', '5', '0', 'C', 'A', '7', '5', '6', '2', '3',
    '6', '6', '2', '5', 'E', 'A', '2', 'E', '9', '8', '8', 'F', '4', '8', 'A', '5',
    'D', '2', '5', 'E', 'D', '2', '3', '7', 'F', '2', 'F', 'C', 'A', '0', 'D', 'D',
    'C', '4', '1', '0', '2', 'F', 'F', '0', 'A', '8', 'F', '7', '7', '2', '7', '9',
    '3', '5', '4', 'E', '6', 'B', '8', '7', 'E', '9', 'C', '5', '0', '6', '7', '2',
    '4', '7', 'E', 'B', 'D', 'B', 'C', '1', 'F', 'E', 'A', '0', '5', '8', '2', 'C',
    '5', 'B', '3', '7', '5', 'C', '4', 'B', 'F', '5', '8', '1', 'A', '0', '5', '8',
    '0', '8', '4', '0', '5', '0', '4', 'E', '3', '2', 'C', 'C', '5', 'C', '9', '0',
    '5', 'B', 'D', '4', 'E', '1', '9', '2', '7', 'F', '5', '9', '1', 'C', 'C', '6',
    'C', '4', '5', 'C', 'F', '9', '2', '7', '9', 'C', '3', '3', 'A', '8', 'F', '7',
    'A', '1', '1', 'A', '3', '0', '5', '4', '0', '1', 'B', '7', 'B', '1', '1', '2',
    '8', '3', '7', '9', '6', '2', '9', 'B', 'D', 'A', 'B', 'E', 'A', '4', 'C', 'C',
    '2', 'D', 'C', 'C', 'B', '6', 'A', '1', '7', '5', 'A', 'C', '6', '3', 'F', '6',
    '5', 'E', 'C', '1', 'D', 'E', 'A', '1', 'D', 'D', 'F', '2', '9', 'C', 'F', '7',
    'D', 'A', '7', '9', '6', '1', 'D', '4', 'D', '3', '2', 'C', 'B', 'C', '2', '4',
    '9', 'E', 'F', '5', '2', 'D', 'F', '8', '4', '7', '7', 'B', 'E', 'A', '6', '5',
    '3', '9', '0', '0', '6', 'C', '1', '7', 'D', '5', 'B', '7', '2', '4', '1', '4',
    'D', 'D', 'E', 'A', '7', '6', '0', 'A', '9', '8', '3', 'D', 'B', '5', '0', '0',
    '5', 'A', 'C', '8', 'E', 'B', 'B', '4', '9', 'B', 'B', '9', '2', '5', '4', 'F',
    '2', 'C', 'C', '2', '1', 'C', '8', 'B', 'A', '7', '2', '3', '9', 'F', '1', '6',
    'A', '1', '1', '7', '2', 'E', '8', 'B', '8', '1', '5', '7', '4', 'B', 'E', '6',
    'C', 'C', 'E', 'C', '3', 'F', '1', '7', '8', '3', '4', 'D', '4', '2', '7', '9',
    '1', '7', '7', 'D', 'E', '3', '3', '6', '8', '2', '7', '5', '8', 'C', 'D', '4',
    'B', 'A', 'C', 'D', 'B', '2', '9', '3', '9', 'E', 'A', 'B', '5', '0', '0', 'C',
    'C', '9', '6', '5', '0', 'E', 'E', '4', '3', 'B', 'D', 'C', 'D', 'F', '6', '3',
    '8', 'B', '8', '9', '5', 'B', '3', '0', '3', '5', '9', 'C', '8', '4', '9', '7',
    '0', 'D', '3', 'D', 'C', '6', '0', '0', 'F', '4', '3', '9', '3', '6', 'E', 'D',
    '8', 'B', 'F', '3', '5', '5', '5', 'D', 'E', '1', 'B', '3', 'E', '4', '3', 'D',
    '8', 'B', 'E', '8', '7', '3', '2', '4', 'F', '6', 'F', '2', '0', '9', '1', '6',
    'F', '2', '4', '4', '2', '5', 'B', '2', 'F', 'B', '5', '1', 'D', '3', '5', '1',
    '4', 'E', 'A', 'E', 'C', 'E', 'F', '0', 'B', '2', '3', 'A', 'C', 'E', 'B', '4',
    '5', '2', 'B', '4', '8', '0', '2', 'A', 'D', '8', 'F', 'E', 'B', '0', '2', '1',
    'F', '2', '4', '9', 'C', '0', '5', 'F', 'A', 'E', '2', 'F', '6', 'F', '5', 'A',
    '9', '0', 'E', 'B', 'A', '1', 'A', '2', '7', '7', '1', 'C', '5', 'C', 'E', '5',
    'A', 'F', 'D', '7', '6', 'A', '1', 'B', '0', '8', '1', 'C', '6', '1', 'B', 'A',
    '1', '6', '4', '2', 'A', '7', 'A', '1', '6', '2', 'B', '1', 'E', 'A', '1', '7',
    '9', '5', '1', '9', 'A', '8', 'F', '7', 'C', '7', 'A', '5', '1', '2', 'E', '5',
    'D', '9', 'E', '2', '1', 'C', 'B', 'E', '9', '8', '4', '9', 'C', '5', 'F', '6',
    '6', 'A', '4', '7', 'A', 'C', '9', '0', 'F', '5', '3', '7', '4', '0', '8', '1',
    'A', '8', '2', '3', '4', '9', 'C', '2', '2', '4', 'A', '9', 'C', '2', 'F', 'A',
    'D', 'E', '8', 'A', 'A', 'E', 'D', '7', 'B', '3', 'B', '1', '7', '7', '7', '1',
    'A', 'B', '6', 'D', 'C', 'A', 'B', '8', 'E', 'F', '7', '5', '7', '7', 'A', 'C',
    '2', '1', 'D', '8', 'D', 'E', 'B', 'B', '4', 'C', '9', 'B', '2', 'F', 'C', '4',
    '2', '9', '0', 'E', '0', '5', 'B', '4', '4', 'D', 'D', '3', 'F', '1', 'A', '7',
    '6', '9', '5', 'E', 'B', '1', '0', '8', 'C', 'C', '9', '2', 'C', '7', '5', '3',
    '9', '1', 'E', 'E', 'B', 'E', 'B', '0', 'C', '2', '3', 'C', '9', '4', '6', '7',
    '7', '5', '1', 'A', 'A', 'C', '9', '2', '3', '7', '4', '3', '5', '2', 'B', 'D',
    'B', '6', '9', 'D', '2', 'C', '4', '0', '4', '3', '5', '0', 'E', 'A', '1', 'C',
    '7', '8', '7', 'E', 'E', 'D', 'E', 'A', 'E', '3', 'A', 'D', '6', '9', 'F', '3',
    'A', '9', '1', '4', '0', '3', 'D', '6', '4', 'B', '0', 'A', 'D', '8', 'C', '4',
    '2', '5', '5', '0', '2', '4', '8', '0', '4', '5', '9', '1', '1', '2', '1', '5',
    '5', 'E', '0', '6', '0', 'E', 'C', '9', 'E', '3', 'D', 'F', 'D', 'D', '6', 'F',
    'F', '3', 'C', 'D', 'E', '9', '2', '6', 'D', '4', '1', '3', '8', '3', '3', 'F',
    '3', 'B', '0', 'B', 'F', '3', '1', '6', '6', '7', 'F', 'D', '4', 'B', '9', 'D',
    '3', 'B', 'B', '9', '5', 'C', 'F', '1', '9', 'E', '0', '8', 'B', '8', 'A', '2',
    'D', 'F', '1', '9', '7', '4', 'D', '6', 'E', 'D', 'A', 'F', '0', '0', '3', '6',
    '2', 'E', '0', 'C', 'C', 'F', 'A', 'C', 'C', 'B', '1', 'D', 'B', 'F', '3', 'C',
    '5', '3', 'A', '7', '8', 'C', 'F', 'E', '8', 'E', '4', 'B', '4', '0', 'D', 'C',
    '8', 'B', '5', 'E', 'D', '1', '9', '2', 'B', '8', '3', '9', '8', 'C', 'E', '1',
    '9', '3', '5', '7', '8', 'D', '7', '5', '7', 'B', 'B', 'F', 'A', '4', 'B', 'D',
    '2', 'B', 'F', 'A', 'E', 'E', 'F', '5', 'A', '1', '6', '6', 'B', '1', '9', '3',
    '4', 'C', '8', 'E', 'C', 'D', '9', '2', '6', 'A', '6', 'B', 'F', 'F', '3', 'E',
    'D', '1', 'D', '4', '5', 'E', '6', '7', 'F', 'D', '8', '0', '9', 'E', 'F', 'C',
    '2', '4', '5', '0', '7', '9', '0', '4', '0', '9', '7', '2', '4', '4', '3', 'D',
    'E', '8', 'D', 'E', 'E', 'A', 'B', '6', '2', '0', 'B', '0', 'F', 'D', '7', '5',
    '4', '0', 'C', '3', '4', '0', 'D', '1', 'F', '1', '2', 'C', '9', 'C', 'D', '6',
    '9', '6', '8', 'E', '8', 'C', '2', 'F', 'D', 'B', '0', '3', '4', 'C', '7', 'C',
    '7', 'A', 'C', 'E', '5', '8', 'C', '6', '5', '0', '9', '6', '8', 'D', '5', '4',
    '0', 'C', '0', 'A', 'D', 'A', 'F', '6', 'B', 'E', 'D', '8', 'E', '5', 'B', 'D',
    'B', 'B', '6', 'E', '5', '3', '8', '4', '5', '5', 'E', 'B', '3', '7', '6', 'E',
    '1', '2', '7', '3', '4', 'E', '7', '1', 'B', 'D', '2', 'B', '8', '8', 'F', '9',
    '2', 'C', '7', '4', '1', 'E', 'C', 'E', '8', '1', '2', 'A', '2', '8', '3', '9',
    '2', '4', 'A', '7', '3', '5', 'E', 'F', 'B', '7', 'F', 'C', '3', 'D', '3', 'B',
    '8', 'E', 'E', '2', '3', 'B', '0', '0', '8', '5', 'D', '3', '5', 'D', 'C', '9',
    '7', 'B', '2', 'B', 'E', 'A', '5', '2', 'E', '7', '9', 'D', '1', '3', '7', '3',
    '5', '5', '2', '5', 'F', '0', '3', 'E', '8', 'B', '9', '8', '2', '7', '4', '3',
    '4', '7', '8', '1', '1', '6', '8', 'A', 'E', '0', 'F', 'E', 'A', 'E', '2', '9',
    '3', 'C', '6', '4', '3', '6', 'B', '6', '4', 'B', 'F', '4', 'A', '9', '2', 'B',
    'F', '1', '6', '3', '7', '6', 'A', '5', '9', 'D', '9', 'E', '8', 'C', '1', '5',
    '5', 'B', '0', '9', 'C', '9', 'E', '0', '4', '4', 'E', 'E', 'B', '0', 'F', '5',
    'A', '2', '7', '7', '4', '1', '6', '6', '3', 'F', 'F', 'D', 'D', '2', '0', '6',
    '2', '3', 'B', '9', '4', '6', 'C', '5', '1', 'C', '8', 'B', '4', '0', '0', '2',
    '8', '5', 'A', '2', '3', 'F', '0', '5', '3', '7', 'C', 'B', 'D', '2', '2', '5',
    'F', 'A', '5', '1', 'C', '3', 'A', 'D', '8', 'C', '6', '3', '5', '2', '3', '7',
    'C', '1', 'A', 'B', 'C', '7', '5', '4', 'D', '2', 'E', 'D', '3', '0', '9', '3',
    'C', '5', '4', 'F', '1', '3', '3', 'E', 'C', 'A', 'C', 'A', '1', '9', 'B', '2',
    '6', 'C', '1', '5', '7', '3', '4', '2', '6', 'C', 'A', '1', 'E', '6', '5', 'D',
    '8', '9', 'F', '7', '6', 'E', 'A', 'E', '1', '4', '9', 'F', '3', 'F', '1', 'C',
    '5', 'C', '2', '0', '7', 'A', 'D', 'A', 'F', '8', '6', 'E', 'E', '6', 'E', '4',
    'C', '1', '3', '4', '4', '1', 'C', 'A', '4', 'D', '6', 'E', 'E', '5', 'E', 'F',
    '5', '3', '5', '0', '7', 'B', 'F', 'D', '5', 'E', '7', '3', 'A', 'E', 'E', '2',
    '7', '2', '1', '4', 'F', '5', '0', 'E', 'A', '3', '4', '4', 'D', 'D', '3', '9',
    'B', '4', 'F', 'D', '8', '3', 'B', 'D', '9', '9', 'E', '7', 'A', '6', 'D', '5',
    '3', '5', '5', '4', '9', 'F', '9', 'A', 'B', '8', 'E', '6', '8', '4', '3', '6',
    '9', '2', 'C', 'E', '3', '4', '4', 'A', 'C', 'B', '7', '6', 'E', '7', '7', 'F',
    'F', '6', 'F', '2', '7', '8', '9', 'A', '6', '4', '8', 'A', 'B', '2', 'F', '4',
    '6', '6', '4', '6', '1', '1', 'D', '2', '2', '0', '6', '1', '8', '7', 'E', 'C',
    '3', 'C', '0', '6', '8', '8', 'E', '4', 'C', '6', '3', 'B', 'E', 'C', '9', '6',
    '6', 'B', '0', 'C', '6', '0', 'E', '5', 'D', '4', '9', '2', 'D', '9', '9', '0',
    '9', 'A', '4', '4', 'D', 'B', '6', '0', '7', '3', '7', '8', '6', '1', 'C', 'E',
    '8', '3', 'A', '7', '1', '4', 'F', 'B', '4', '4', '7', '8', '4', '3', '3', '7',
    '3', '0', '2', '2', 'E', '0', '2', '8', '0', 'A', 'B', '4', 'A', 'F', '7', '9',
    '7', '7', '1', '3', '2', '8', '0', 'E', '6', 'F', 'E', '9', '4', '2', '9', '4',
    '4', '8', 'F', '4', 'A', '7', '3', '1', '8', '9', '3', 'E', 'D', '6', 'B', '8',
    'F', 'B', 'B', '3', '6', 'C', '9', '6', '1', 'B', '4', 'F', '3', 'A', '7', '2',
    '0', 'D', '4', 'B', '1', '2', '8', '0', '9', '1', 'F', '4', 'C', '3', 'A', '0',
    '8', '3', '3', 'A', '9', '6', 'A', 'E', '3', '1', '6', '8', '9', 'A', '8', '9',
    '1', '3', '4', '2', '5', '8', '0', '7', '6', '9', 'F', '2', '8', '5', '1', 'E',
    '1', 'E', 'D', '2', '4', 'F', 'C', 'F', '1', '7', 'A', 'A', 'C', '3', 'C', '9',
    '6', '7', '1', '5', 'E', '3', 'A', '8', '5', '2', '5', '3', 'B', '9', '9', 'A',
    '1', '0', 'D', 'B', 'B', 'B', 'B', 'A', 'D', 'E', '1', 'B', '5', 'D', 'E', 'E',
    '6', 'B', '7', 'B', '2', 'B', 'D', '8', 'A', '8', '3', '5', 'E', 'D', 'C', 'A',
    '6', 'C', 'D', 'A', 'E', 'D', '9', '6', '7', '2', 'B', '0', 'A', '5', '3', '4',
    '3', 'D', '0', '0', 'A', '9', '2', '5', 'D', '4', 'B', '5', '7', 'F', '1', '4',
    '4', 'C', '5', '8', 'C', '0', 'F', '4', 'C', 'B', '7', 'D', 'C', '6', '1', 'D',
    'B', '4', '7', '8', 'C', 'D', 'C', '1', '1', 'D', '5', 'F', '4', '7', '4', 'A',
    '6', '4', '5', '2', 'D', '4', '5', 'A', '4', '6', '3', 'B', '3', '9', '3', 'C',
    '1', '3', '9', '0', 'D', '1', '0', '5', '5', '6', '9', '8', 'D', '0', '2', '2',
    'B', '7', 'F', '5', '2', 'F', '7', 'D', '7', 'F', '4', '9', '6', 'C', '7', 'D',
    '6', '1', '2', '6', '4', 'A', 'F', 'B', '4', 'D', '0', '5', '2', 'A', 'B', '7',
    'E', '9', '0', '4', '4', 'F', '4', 'C', '8', 'E', '2', '2', '3', '3', '9', '8',
    'D', '0', 'F', 'D', '5', 'D', '6', '5', '7', 'C', 'C', '8', '4', '0', '5', '1',
    '7', '0', 'A', '7', '7', '9', '9', '4', '4', '4', '4', 'E', 'C', 'D', '7', '3',
    '9', '2', '9', 'E', 'A', 'E', 'B', '1', '6', '6', 'C', 'F', 'D', '8', '7', '9',
    'D', 'C', '0', 'B', '3', '7', 'C', '4', 'A', '2', '4', 'A', '0', 'A', '0', '2',
    'C', '7', 'A', 'B', '6', '7', '2', '4', '5', 'E', 'B', '8', '3', 'A', 'D', '8',
    '7', '3', '1', '8', '8', '3', '5', 'A', '8', 'B', '4', '2', 'D', 'C', 'C', 'F',
    '7', '6', '4', '6', 'F', '6', '9', 'D', '4', '8', 'C', 'B', '5', '9', 'F', 'B',
    '1', '6', 'F', '8', '5', 'C', 'D', '3', '6', '2', '0', '1', '4', '4', 'E', 'E',
    '8', 'C', '3', '0', '1', '7', '8', '3', '5', '7', 'B', 'C', 'D', '3', '1', '0',
    'F', 'A', '4', '9', '5', '8', 'B', '7', '8', '6', '6', 'F', '0', '3', '6', '8',
    '7', '2', '3', '4', '8', '9', '8', 'E', '4', '3', '3', 'D', 'C', '6', 'D', '5',
    '3', '1', '9', 'B', '5', '1', '5', 'D', 'B', 'E', '8', '0', '7', '2', '5', '6',
    'D', 'A', 'D', 'B', '3', '2', '6', 'A', 'A', 'C', 'D', '7', '3', '0', 'F', 'B',
    '5', 'A', 'D', '5', 'D', '4', 'F', '6', 'D', 'B', '2', '4', '6', '1', '0', '6',
    '7', '0', '6', 'F', '8', '5', 'D', '8', '6', '6', '0', '4', '6', 'E', 'A', '2',
    '8', '5', '9', '9', '3', 'E', '8', '8', '2', 'E', 'D', '6', 'B', '9', 'F', '0',
    '7', '2', '6', '2', '8', 'A', 'A', '8', 'B', 'D', '5', '2', '5', 'B', '7', '9',
    '0', 'C', 'D', '6', '6', '0', '3', '7', '8', 'D', '6', 'A', '5', 'D', '3', 'F',
    'B', '6', '2', '9', '4', 'F', 'B', 'A', '1', 'C', 'B', '9', '4', '0', 'C', '6',
    'A', '6', '6', '9', 'B', '1', 'C', '7', '9', '2', '6', '8', 'F', '1', 'A', '6',
    '5', 'E', '1', '4', '9', '7', '9', '7', 'D', '5', '3', 'C', 'E', '2', '7', 'B',
    'D', '0', '0', 'B', '0', '0', '4', '8', '0', 'E', '7', '9', '4', '6', 'C', 'A',
    '4', '9', '9', '4', 'B', '5', '6', 'D', '8', '0', 'A', 'D', 'F', '7', 'F', '9',
    '2', 'D', 'B', '2', 'F', 'C', 'D', '8', '1', 'C', 'F', '7', 'E', 'D', 'E', '7',
    'F', 'A', '9', '0', '6', '2', '4', '4', '8', 'C', '2', '3', 'A', '6', 'B', '8',
    '2', 'B', 'B', '5', 'A', '0', '4', 'C', '2', '8', 'F', '9', '6', '1', '1', '8',
    'B', '3', '2', '5', '0', 'B', 'F', '7', '7', 'A', '2', 'C', 'A', 'A', '4', '4',
    '5', 'D', '5', '3', '4', 'B', 'B', '3', '6', '2', 'E', '0', '1', '4', '4', 'C',
    '5', 'D', 'E', '1', '2', '1', '2', 'A', 'C', 'D', '1', '8', 'C', 'C', '0', 'A',
    'E', '1', 'B', '0', '6', 'E', '7', 'A', 'A', '7', '2', '3', '4', '6', '6', 'C',
    'B', 'D', '8', '6', '5', '3', '4', 'C', 'D', '1', '0', 'E', 'F', '2', '4', '5',
    'A', '3', '0', 'B', '7', 'E', '3', 'A', '9', 'B', '3', 'F', '7', '6', '4', '7',
    '7', 'E', 'D', 'E', 'C', '2', 'B', 'B', '4', '3', '1', 'A', 'A', 'E', '8', 'E',
    '9', '7', '0', 'D', 'D', '2', '5', 'A', 'E', '9', 'F', 'A', '1', 'F', 'A', 'B',
    '9', 'C', '4', '9', 'C', 'E', 'E', 'D', 'D', '3', 'D', '5', '7', '9', '2', '1',
    '4', 'A', '4', 'C', '4', '2', '6', '6', '2', 'A', '5', '4', '2', 'A', '8', '2',
    'B', '6', 'D', 'D', '4', '0', '6', '1', 'D', '7', '8', 'F', 'B', '8', '9', '6',
    '1', '1', '8', 'B', 'A', '7', 'A', '2', '8', '4', '7', '9', 'A', '5', '4', '6',
    '7', '0', '4', '4', '2', 'D', '3', 'F', '8', 'F', 'D', 'E', '6', '8', '2', 'C',
    '4', 'E', 'A', '7', '8', 'C', '4', 'F', '7', '9', 'C', '5', 'F', 'E', '6', 'C',
    'A', 'E', 'E', '6', 'E', '8', '1', 'D', '6', '3', 'F', 'A', 'E', '6', '7', '6',
    '0', '1', '9', '2', 'C', 'D', '1', '3', '9', 'C', '6', '1', '1', '6', '3', '0',
    'B', '5', '9', 'D', '9', 'B', '9', '8', '0', '0', '1', 'E', '2', '6', 'C', 'A',
    '1', '9', '5', '5', '7', '4', '9', 'D', 'D', 'F', 'C', '1', '0', '5', '6', 'D',
    '3', '2', '2', 'A', '0', '6', '1', 'C', '0', '5', 'F', '8', 'E', '5', '2', '9',
    'D', '0', '2', '2', '7', '0', 'A', 'C', '3', '2', 'B', '0', 'E', '0', 'A', '9',
    '7', '0', '6', 'E', '1', 'D', '5', '4', 'A', '5', '3', '8', '3', '4', '5', '9',
    'D', 'D', '2', '4', 'A', '4', 'E', '5', '5', 'E', '3', 'A', 'F', '5', 'D', '0',
    '6', 'A', '9', '9', '4', '0', '7', 'F', 'F', '5', '9', '5', '3', 'B', '9', '1',
    '8', '0', '2', '1', '1', '3', '3', '0', 'B', '2', 'A', 'A', '7', '3', 'B', '9',
    '6', '8', '6', '3', '1', '5', '9', '6', '9', '8', 'E', '9', '8', 'A', 'B', '8',
    '5', '8', 'A', '3', '2', 'A', '8', 'E', 'F', 'C', '6', '0', '3', '9', '7', 'F',
    '2', 'A', '1', '6', 'A', '3', '7', '5', 'F', 'A', 'C', '7', '4', 'E', '8', 'F',
    '4', 'B', '8', '0', '0', 'B', '1', '6', 'F', '9', 'C', '8', '4', 'E', 'B', 'C',
    '2', 'B', '3', '3', '1', '7', '6', '0', '2', '7', '6', '3', '8', 'D', '9', '2',
    '4', '9', 'E', 'C', '5', '9', '4', 'A', '4', 'E', 'B', 'A', '2', '5', 'E', 'A',
    '2', '8', 'D', '5', '6', '4', '3', '6', '8', 'D', '3', 'B', 'B', '9', 'A', '3',
    'F', '7', '5', '6', 'E', 'D', '0', '5', '5', '3', '4', '7', '4', '8', 'F', '0',
    'D', '8', '8', '7', '2', '3', 'D', '5', '2', '9', '5', '0', '8', '7', '9', 'F',
    '9', '0', '1', 'B', 'B', '7', 'A', '8', '7', '4', 'D', '3', 'E', '4', 'F', '6',
    '7', 'C', '2', 'A', '9', '3', 'C', 'D', '2', '2', '2', '6', '1', '2', 'E', '9',
    'C', 'F', 'D', '3', 'A', 'D', '2', 'E', '5', 'A', '9', '6', '9', '1', 'B', '0',
    '2', '4', '0', '9', '3', 'D', '6', '0', 'D', '3', 'C', '9', '5', 'D', '9', '2',
    '1', '9', 'B', '1', 'B', '2', '3', '9', '7', 'B', 'D', '3', '0', '4', '9', '8',
    '9', 'B', '3', '4', '3', '8', '3', '6', 'E', '4', '8', '4', '4', '6', '9', 'B',
    '9', '4', '6', 'B', '9', '3', '9', '4', '0', '5', '6', '5', 'A', '8', 'D', 'F',
    '2', '1', '0', 'A', 'D', 'D', '7', 'D', 'C', '8', 'D', '1', '8', '3', '9', '2',
    '5', 'E', '2', '4', '4', 'F', '9', 'C', '5', '6', 'C', '6', 'B', 'A', '9', 'E',
    '2', '9', 'D', '1', '9', '3', 'B', '7', 'D', 'A', '6', '4', 'A', '5', '9', 'C',
    'A', 'A', '3', '6', '3', 'E', '7', '3', 'F', 'D', 'E', 'A', 'A', '5', '0', 'D',
    '1', 'F', '2', '4', '1', '4', '2', 'D', '6', 'A', '9', 'E', 'D', 'B', 'C', 'B',
    'B', '7', 'F', 'C', '6', '2', 'D', 'D', '9', 'C', 'C', '0', 'D', 'E', 'F', '8',
    '5', '8', '6', 'D', 'D', '9', '9', '9', '5', '2', '6', '4', '1', '1', '2', '1',
    '7', 'A', '2', '3', 'C', '0', '0', '1', '0', '9', '3', '3', '2', '7', '0', '3',
    'B', 'B', '6', '7', 'A', 'F', 'E', '4', '6', 'F', 'B', '9', '1', 'D', '3', 'D',
    'F', 'A', '4', '4', '6', 'A', 'E', 'F', '3', '7', '3', '3', 'B', '0', '1', 'A',
    '4', 'C', '3', '8', '8', '6', 'C', 'D', '8', '9', '4', '5', 'F', '1', '6', 'B',
    'C', 'B', '3', 'A', 'B', 'E', 'B', '4', 'E', '9', '6', '8', 'B', '6', 'B', '0',
    '6', '5', '6', '2', 'D', '1', '7', 'F', '3', '3', 'A', 'F', '4', '9', '5', 'F',
    'B', 'B', 'E', 'D', '3', '4', '1', 'B', '8', 'F', 'E', '1', 'D', 'C', '0', '8',
    '1', '1', '8', '0', 'F', '4', 'F', '4', '0', '8', 'C', '5', 'E', '8', '4', '7',
    'A', '3', 'F', 'D', '9', 'A', 'F', '4', 'F', '1', 'B', 'D', '7', '6', '2', '7',
    '4', '4', '0', '7', '1', '9', '4', '6', 'D', '9', 'E', 'C', '7', '1', 'B', 'F',
    '8', '6', 'A', 'B', '8', 'C', 'C', '1', '4', '4', 'D', 'B', '7', '1', '7', 'D',
    '1', '3', '8', '6', '7', 'E', '3', '9', '4', '1', '5', '0', '5', '1', 'B', '8',
    '4', '8', 'B', '2', '8', 'C', '8', '6', '5', '2', '5', 'F', 'F', 'B', '8', '7',
    '4', '2', 'F', 'F', '0', '0', '9', 'B', 'F', '1', '5', '9', '2', '3', '3', '0',
    '3', '3', '4', '3', '7', '6', '9', '8', '2', 'F', '4', 'D', '2', 'E', '7', '1',
    '4', 'D', '7', '9', 'F', '3', 'B', '1', '9', 'F', '9', '4', '3', '6', '2', '1',
    '8', '2', '7', 'C', '9', '4', 'E', 'A', '8', '2', '7', 'F', '5', '0', 'A', 'D',
    '0', '0', '7', '2', 'B', '1', '3', 'F', 'C', '4', '7', '6', '8', '3', '3', '9',
    'E', '7', '5', '7', '2', 'C', '2', '1', '9', '4', 'F', 'D', 'A', 'A', '7', 'A',
    '7', '1', '3', '8', 'A', '8', 'D', '8', '1', 'B', '1', 'D', '1', '9', '9', 'F',
    'B', '7', '4', '4', '9', 'D', '3', 'F', 'E', '9', '8', '8', 'A', 'A', '4', 'F',
    '9', 'B', '4', 'A', 'B', '4', 'E', '6', 'C', '9', 'D', 'F', '8', '9', '7', 'A',
    '9', '0', '5', 'F', '4', 'F', 'F', '6', 'A', '5', 'A', 'D', '8', '4', '7', '7',
    '5', 'C', '6', '2', 'F', '0', '9', 'D', 'C', '2', '6', 'D', '1', '7', '8', '0',
    '8', '5', '7', '3', 'B', '7', '6', '8', '8', 'F', 'D', '1', 'D', '0', 'B', '1',
    'A', 'D', '0', 'E', 'F', '5', '9', 'F', 'C', '6', 'E', 'C', 'A', 'F', '2', 'D',
    '4', 'C', 'F', '5', '5', '6', '2', '9', 'D', '9', '7', '3', '3', '8', '2', '1',
    '0', '1', '7', 'B', 'D', 'D', '0', '4', 'A', '4', '2', 'E', '4', '5', '2', '5',
    '1', 'E', 'C', '9', 'B', '0', 'A', '5', '9', '6', '9', 'B', '0', '9', '3', '1',
    '6', 'B', 'F', '1', 'D', '0', '5', '1', '3', '3', 'F', '2', 'E', '5', '8', 'A',
    '0', '0', '0', 'E', 'E', '4', '5', '2', '2', '9', '4', '2', '5', '9', 'E', '7',
    '5', 'A', 'C', 'F', '1', 'C', 'E', '3', 'E', '6', 'A', '4', '0', '2', '4', '3',
    '0', 'F', '7', 'D', 'D', '0', 'E', 'F', 'C', '3', '0', '0', '7', '3', '2', 'F',
    'D', '0', '2', '5', '2', '8', '5', 'F', '5', '9', '9', 'A', '5', '6', '4', 'B',
    '0', '5', '8', '3', 'D', '9', '9', '4', '1', '7', '0', 'B', '0', '5', '6', '6',
    'A', 'F', '1', '6', '7', '1', 'D', '4', '2', '0', 'E', '2', '6', '8', 'B', '1',
    '9', '2', '4', '8', 'B', 'F', '9', 'B', '0', 'D', 'B', 'C', '9', '6', 'F', 'E',
    '5', '4', '7', 'F', '2', 'B', '5', 'C', '1', 'C', '5', 'D', 'D', '5', '6', 'B',
    '7', '7', '9', '6', '0', '5', '8', 'B', 'E', 'F', '8', 'A', '3', 'D', '7', 'C',
    'D', '4', 'B', '5', '1', 'E', '4', '5', '6', 'B', '1', 'F', 'B', '1', '4', '8',
    '7', '7', 'C', 'C', 'B', '2', '5', '1', 'C', 'D', 'B', '3', 'A', 'F', '8', '6',
    '4', 'F', '1', 'D', '6', 'D', 'E', 'B', '2', 'C', '3', 'F', 'C', '9', 'C', 'F',
    '6', 'E', '3', '1', '5', '3', 'C', 'B', 'E', '1', 'A', '8', 'C', 'B', 'A', 'B',
    'E', 'C', 'A', '7', 'D', '7', '3', 'A', '1', '5', '6', '4', '3', 'C', '5', 'D',
    '2', 'D', 'C', 'F', 'A', '1', '4', '0', 'E', '5', '3', '4', '5', 'F', '3', '8',
    'C', '4', '8', 'B', '6', '3', '0', '4', '6', '0', '9', 'F', '9', '8', '3', '6',
    '1', '8', 'E', '3', '7', '6', '8', 'C', 'C', '7', 'B', 'D', '3', 'C', '5', '8',
    'E', 'C', '3', '6', '9', '4', '1', '5', '9', 'B', '6', 'B', '9', '5', '6', '8',
    'A', '7', 'F', '3', '7', 'A', 'E', '3', '8', '1', '4', '5', '8', '8', '4', '4',
    '8', 'A', 'A', '7', 'E', 'B', 'A', 'E', 'D', '9', '6', '3', 'D', '3', '5', '6',
    'B', '6', '8', '8', '9', 'D', '0', 'A', '2', '2', 'E', '7', 'A', '5', '4', '6',
    'D', 'B', 'E', '0', '6', '6', '9', '7', 'F', '8', '0', 'D', 'A', '0', 'D', '4',
    '7', '5', '1', 'C', '0', 'C', '8', 'D', '6', 'D', '5', 'D', 'E', '3', 'B', 'A',
    '0', '2', '5', '0', 'A', '7', '2', 'E', '6', '0', 'D', 'F', '9', '7', '9', '3',
    'F', 'A', '3', 'D', '3', '9', '5', '0', 'F', '9', 'A', '7', 'F', 'F', '2', '9',
    '2', 'B', '7', 'E', '8', '8', '4', '5', 'C', '5', '5', '9', 'B', '4', 'B', '9',
    '6', 'B', '9', '9', '7', '5', '1', '7', '5', '1', '8', 'A', 'A', '7', 'B', '7',
    '2', '2', '7', '3', 'D', '9', '1', '0', '2', '2', 'E', '8', 'F', '9', '3', 'D',
    '6', '8', '2', 'C', '7', '3', '2', '9', '7', '6', '1', '6', 'A', '0', 'D', '1',
    'B', '7', '5', '9', 'D', '9', 'D', 'D', 'C', '2', '3', '3', 'A', '2', 'E', '6',
    '2', '5', '2', '0', '2', '8', '7', '4', '2', '5', 'D', '8', 'D', '9', 'A', 'B',
    '3', '3', '8', 'D', '0', '1', '7', 'C', 'C', '0', '2', '5', '0', 'C', '8', '2',
    '5', '4', 'F', 'B', '9', '7', 'B', '6', '4', 'A', '5', '7', 'E', 'F', '7', '5',
    '6', 'A', '4', 'B', '6', '5', 'D', 'C', '9', '7', '4', 'F', '6', 'C', '1', 'C',
    '9', '0', '1', 'A', '2', '5', '9', '5', 'D', '6', '8', '4', '1', '5', '6', 'C',
    '0', '8', 'F', '2', 'B', '6', '1', 'B', '5', 'C', '3', 'E', '5', '9', 'F', '5',
    '7', '6', 'E', '9', 'C', 'F', 'E', '1', '8', '4', '3', '9', '9', 'F', '5', '9',
    '5', '7', 'C', '0', 'A', '7', 'B', 'E', '1', 'E', '4', '0', '2', 'E', '7', '2',
    'D', '5', '4', '4', '0', 'F', 'A', '2', '9', 'D', '3', 'C', 'D', '2', '0', '0',
    'A', '6', 'A', 'E', 'B', '8', 'D', '4', '7', '4', 'C', '5', 'F', '8', '8', '7',
    '1', '2', 'F', '4', '7', '4', '7', '4', '3', 'E', 'D', 'C', '4', '3', 'E', '9',
    'C', '8', 'A', '5', '0', '8', '9', '9', 'E', '9', '7', '7', '5', 'B', '8', '7',
    '9', 'F', 'B', '9', '4', '0', '3', '7', '0', '3', 'C', '5', 'A', 'F', 'E', 'F',
    '6', 'C', '4', 'A', '4', '9', '7', 'C', 'E', '6', 'B', 'A', '5', 'B', 'F', 'F',
    '2', '1', '9', '6', 'F', '6', '5', 'F', '0', 'C', '5', '4', 'D', '7', '3', 'E',
    '3', '0', '0', '2', 'E', '0', '2', '9', '1', '7', '2', 'B', '7', '7', '8', 'F',
    'D', 'F', '9', '7', '5', '8', '7', '9', '0', '7', '2', 'B', '2', 'C', '0', '5',
    'D', '2', 'E', '6', '1', 'A', '6', 'E', '5', '2', '4', 'A', '5', 'C', 'A', 'F',
    '5', '6', '9', '9', 'D', '2', '8', '3', 'F', '7', 'B', '3', 'A', '5', 'E', '5',
    'C', 'B', '7', '7', '2', 'D', '8', 'F', 'B', '8', '9', '1', 'E', '6', '6', 'F',
    'D', '5', '0', '2', '2', 'C', 'C', '5', '6', '9', 'A', '0', '3', '3', 'B', 'F',
    'D', '1', '2', 'D', 'C', '0', 'C', 'C', '9', 'C', 'E', 'E', 'B', 'E', 'F', 'F',
    '3', '9', '4', '5', '5', '5', '0', 'D', 'C', 'D', '5', '9', 'A', '2', '3', '0',
    'C', 'F', '3', '3', '8', '9', '9', '7', 'A', '2', '0', '8', '6', '4', 'F', '4',
    '9', '9', 'E', 'D', '7', 'F', 'E', '4', 'B', '4', '8', '3', '1', '3', '9', '0',
    '0', '2', '7', 'B', '4', '7', '8', '5', '6', '4', 'A', '8', '6', 'C', '3', '3',
    '4', 'C', 'B', 'C', '7', '8', '5', 'A', 'B', 'F', 'E', '8', '8', 'B', 'C', 'E',
    '0', '1', '2', '7', 'E', '8', '6', 'A', 'D', '6', '0', 'E', '2', '9', '9', 'E',
    '9', '6', '1', 'E', '6', 'E', '2', 'E', 'F', '4', 'D', 'F', '0', '7', 'C', '3',
    '3', '1', '2', 'D', 'A', 'C', '9', '2', '7', '1', '8', 'E', '7', 'C', '0', '7',
    '0', '7', '0', '3', 'B', '5', 'C', '7', 'C', '4', '4', 'F', '2', '5', '5', '4',
    '9', '5', 'F', 'A', '0', '7', '4', '6', '5', 'A', '5', '4', '5', '7', '0', '9',
    '7', '1', 'B', 'F', '0', '7', '7', '0', 'C', '7', '9', 'F', 'A', '4', 'B', 'B',
    '7', '1', '8', '4', '9', '5', 'C', '1', '4', '3', '6', '3', '2', '0', 'C', '0',
    '1', '4', '2', '0', '5', 'D', '3', '8', '1', '7', '9', '8', 'D', 'C', 'C', '8',
    'D', '3', '6', '4', 'C', '5', '6', '8', '4', 'A', '5', '0', '0', '6', 'B', '1',
    'B', '8', '0', '8', '9', '7', '5', 'F', '9', '7', '0', '3', '4', '3', '0', '0',
    '7', 'F', '3', '1', '8', '0', 'C', '2', '9', 'D', 'C', 'D', '7', '0', 'A', 'E',
    '9', '8', 'A', '2', '2', '8', '6', 'A', 'B', '5', 'D', '8', 'B', '4', 'C', '3',
    '3', 'A', '4', 'B', '0', 'E', '5', 'F', 'F', '3', 'A', '9', '8', '2', '8', 'D',
    '6', '6', '4', 'B', 'F', '1', '9', '4', '2', '9', 'B', '4', '3', 'C', '4', '3',
    '2', 'E', 'D', '7', 'A', 'D', '7', 'B', '0', 'C', 'B', '1', '5', '5', '5', '3',
    '6', '2', 'A', 'A', '3', 'A', 'B', '4', '9', '4', '0', '5', 'C', '9', '1', '0',
    'E', '5', 'C', 'A', '3', '5', 'B', 'A', 'B', '1', '9', '7', '7', 'C', '8', '1',
    'C', '7', '8', '7', '4', '6', 'E', '3', '0', 'C', 'F', '3', 'C', '0', '1', '3',
    '3', 'B', 'D', 'F', '7', '8', '2', 'B', '2', 'C', '8', '8', '8', '5', '7', '7',
    '7', '5', '9', 'F', 'B', 'B', 'A', '2', 'D', 'F', 'A', '7', 'D', '2', '2', '1',
    'E', '3', '7', '1', 'E', 'A', '9', 'E', '8', 'F', '7', 'F', '3', '0', '8', '6',
    '6', '2', 'F', 'B', 'A', '5', 'D', '3', 'C', '5', '6', 'B', 'C', 'C', '9', '5',
    'C', '1', '6', '3', '2', 'B', '9', '7', 'A', '0', '0', '5', '6', '1', '5', 'F',
    'E', 'B', '4', 'B', '2', '6', '2', 'D', '3', '8', 'E', '5', 'D', '9', '0', 'D',
    '5', '3', '8', 'E', '0', 'C', 'E', 'A', '4', '0', '0', '7', 'C', 'F', '4', '3',
    'B', '9', '3', '6', '4', 'E', '8', 'E', 'D', 'B', '0', 'C', '4', 'D', '5', 'F',
    '3', '9', '5', 'D', 'F', 'E', '7', 'A', '7', '1', '3', '8', '2', '4', 'B', 'E',
    '8', '5', 'C', '8', 'B', 'A', '5', 'C', '4', '0', '7', '7', 'F', '7', 'D', '6',
    '5', '1', '3', '3', 'C', '8', '5', '9', 'F', 'E', '3', 'C', 'B', 'B', 'E', '5',
    '6', '1', 'E', '0', '4', '2', 'D', '2', '5', '1', '7', 'C', '7', '6', '5', 'F',
    'B', '3', 'D', '6', '1', '5', '7', '0', '1', '3', '9', '7', 'B', 'C', '4', '8',
    'E', 'A', 'B', '2', 'B', '0', '1', '9', '0', '1', 'C', 'C', '8', 'E', 'B', '1',
    '0', '6', '3', '7', 'D', 'C', '5', '5', 'B', '9', 'C', '5', '1', '7', 'A', '5',
    '3', 'B', 'F', '9', '3', '7', 'B', 'B', '5', '7', '1', 'B', '9', '5', '9', '0',
    '2', '2', '1', '4', 'A', '6', 'F', 'D', '7', 'D', '0', '5', 'D', 'E', 'A', '3',
    '5', '1', '4', '8', '0', '4', 'A', 'E', 'B', '5', '0', '8', '9', 'C', 'B', '6',
    '1', '4', '9', '5', '1', '7', 'E', '7', '1', 'E', 'A', 'D', 'F', '1', '2', '1',
    '0', 'F', 'D', '6', '3', 'D', '7', 'B', 'D', '4', 'B', 'B', 'D', '7', 'B', '2',
    '2', '5', '2', 'A', '2', '4', 'D', '4', 'C', 'C', '3', '4', 'E', 'F', 'F', '3',
    'E', '1', 'B', 'A', '0', '1', 'A', 'E', '4', 'D', '2', '4', '5', '2', '2', 'D',
    '9', '9', '4', 'A', '7', '0', 'E', 'D', 'E', 'F', '4', '6', 'D', '5', '0', '0',
    '3', 'B', '1', '9', 'A', '3', '7', '0', '3', '8', 'C', 'B', '8', '4', '2', '0',
    'A', '9', 'B', 'B', '1', '2', 'A', 'F', '1', '6', '1', '2', '3', 'F', 'B', 'C',
    'E', '8', 'E', '5', 'E', '6', '4', 'A', '1', '2', '4', 'F', 'B', 'C', '6', '6',
    '1', 'E', '8', '4', 'E', '8', '3', '4', '5', 'B', '9', '3', 'F', '6', '5', 'E',
    '4', '1', '0', '1', '3', '8', 'F', 'C', '4', 'F', '9', '3', '6', '9', '9', '8',
    'B', 'C', 'E', 'F', 'F', '7', '8', '5', '1', '0', 'B', 'D', 'F', 'B', '9', '4',
    'A', '8', 'A', '5', '1', '6', '6', '0', '5', '6', '0', '2', 'E', '0', '5', 'D',
    '3', 'C', '5', 'D', 'E', 'B', 'F', '0', '4', '4', '8', '6', '0', 'E', '4', '0',
    'D', 'F', '1', '5', '7', '1', '5', '4', 'C', '5', '1', '3', 'D', 'D', 'F', '0',
    'B', '3', '9', '8', '2', '9', 'C', 'F', '1', '1', 'E', 'D', '0', '8', 'E', '9',
    '3', 'D', '6', 'F', 'F', '5', '8', '4', '9', '9', '4', '4', '5', '1', '7', 'A',
    '4', 'F', '4', '3', '3', 'D', 'B', '9', '3', '0', 'D', 'D', '7', '5', '4', '5',
    '7', '6', '0', 'D', '5', 'A', 'F', 'E', 'E', 'A', '4', '6', 'D', 'A', '4', '6',
    '5', '6', 'B', '5', 'B', '3', 'C', '4', '4', 'A', '1', '4', 'D', 'B', '4', '6',
    '4', 'C', 'D', 'F', '4', '8', '4', '0', '8', 'A', '1', '9', '2', 'B', 'B', '2',
    '9', 'E', 'B', '3', 'D', 'A', '6', 'D', '4', '6', '5', '5', 'A', '3', '4', '8',
    'A', 'C', 'E', 'F', '6', 'D', 'D', '3', 'F', '6', '0', '2', '8', '8', '3', '4',
    '0', 'B', '8', '0', 'E', 'E', '5', 'E', '9', '7', '6', '6', '3', '6', '7', '3',
    '1', 'B', 'D', 'D', '1', 'B', 'B', '9', '7', 'F', 'A', '6', 'D', 'B', '0', '7',
    '9', 'A', 'C', 'D', '9', '4', '4', '8', 'A', '1', 'F', 'E', 'F', '4', '6', 'C',
    'A', '3', '3', 'B', 'A', '8', '1', '2', '2', 'C', 'C', '9', '9', 'C', '1', 'C',
    'E', '2', '1', 'E', '9', 'D', 'D', '7', '9', '4', 'C', 'E', '2', 'A', 'D', '1',
    'D', '1', '1', '5', '5', '1', '1', 'E', 'C', '6', '3', '3', '9', '2', 'E', 'A',
    'D', '6', '4', '3', '2', 'E', '7', '2', '0', '2', 'E', 'B', 'A', '4', 'F', '6',
    '8', '2', '4', '0', '5', '0', '7', '7', '5', 'C', '6', '8', '3', '8', 'B', 'D',
    '6', '4', '2', 'C', 'D', '1', 'C', '9', 'F', '7', '7', 'D', 'D', '7', '8', 'A',
    '1', 'A', '8', '2', '9', 'B', '3', '5', 'A', '8', '5', '2', '6', '4', '4', 'D',
    '5', '8', '8', '8', 'A', '7', '0', '6', '5', 'C', '2', '6', 'B', '7', '7', 'F',
    '5', 'B', '8', '0', 'A', '7', '2', 'B', 'D', '9', 'A', '2', 'F', 'F', '7', 'C',
    'C', 'D', '4', '8', 'D', '3', '0', '8', '0', 'E', 'D', '5', 'C', '7', 'E', 'C',
    '6', '6', 'A', '6', '1', 'C', 'A', '0', 'C', 'C', '6', 'B', 'A', '4', '1', '7',
    '7', 'B', '5', 'D', 'F', '8', '4', '8', '4', '6', 'D', '4', 'D', '5', 'D', '5',
    'A', '9', '2', 'C', '7', '6', '9', '6', 'E', 'F', 'A', 'F', 'C', 'B', 'E', 'A',
    '8', '6', 'A', '1', 'C', '3', '9', '5', '2', '9', '9', 'E', '5', '8', '4', 'B',
    '7', 'E', '3', '0', '8', 'F', 'C', 'F', '8', 'C', 'D', 'F', '5', '5', '3', 'F',
    '5', '2', '4', '4', 'F', '5', '4', '6', '6', 'D', '5', '3', 'B', 'A', '1', '9',
    '7', '9', '6', 'F', 'A', '6', '3', '1', '3', 'C', '8', '4', '9', 'D', '9', '7',
    'A', '4', 'C', 'F', '1', '0', '5', 'B', '1', '0', 'E', 'A', '4', '9', 'C', 'D',
    'F', 'C', '2', 'D', '2', 'C', '3', '6', '4', 'F', '3', 'C', '4', 'C', '1', '7',
    'C', 'B', 'D', 'F', '3', '7', 'F', '1', '3', 'B', 'E', '4', '9', 'E', '5', '2',
    '5', '0', '9', '5', '7', '3', '1', '2', 'A', '3', '6', '3', '7', '0', 'B', 'E',
    '4', '4', '1', '4', 'E', 'D', 'D', '9', '2', 'E', 'F', '1', 'F', '2', '6', 'E',
    '3', 'A', '8', 'B', 'F', '7', 'D', '9', 'E', 'F', '0', 'F', '5', 'A', 'C', '9',
    '9', 'A', '0', 'A', '2', 'A', 'E', '5', 'F', 'B', 'D', 'E', '4', '5', 'B', 'D',
    'B', '2', '7', '3', '8', '0', '0', 'E', '0', 'F', '3', '0', '0', '3', '5', '5',
    'E', 'F', '7', 'B', '7', 'C', 'E', '6', '4', '9', 'E', '6', '5', '5', 'A', 'E',
    '1', '5', 'B', '1', '3', 'E', 'A', '5', '1', 'F', '9', '5', 'F', '2', '2', 'D',
    'B', '7', '1', '3', '9', '2', '8', 'F', 'C', '6', 'F', 'A', 'D', '4', '7', '5',
    'E', '0', 'B', 'E', 'E', 'C', '0', '7', 'D', '0', '7', '3', '0', '2', '4', 'E',
    '9', 'F', '0', '2', 'C', 'F', '4', 'E', 'D', '0', '5', '4', 'A', '6', '2', 'B',
    'F', '7', 'F', '1', '2', '5', '5', 'D', 'B', '8', '8', '4', 'C', 'A', 'F', 'E',
    '4', 'A', '8', '5', 'D', 'B', '4', 'D', '5', 'E', '5', '4', '3', '4', '0', 'B',
    '0', '9', '7', '5', '8', '1', 'B', 'B', '3', '2', 'B', 'F', '4', '5', '9', '5',
    'E', '0', '0', 'B', 'A', '2', '5', '1', 'D', 'D', 'A', '1', '6', '7', 'C', '4',
    'F', 'A', '3', 'B', '9', 'A', '0', '1', 'A', 'C', 'E', 'C', 'D', '3', '2', '7',
    'A', 'C', 'D', '4', '6', '8', '7', '8', '2', 'F', '8', '4', 'E', '1', 'D', '6',
    'A', '2', 'A', '6', 'F', '4', '1', '9', 'E', 'A', '5', '6', '2', 'E', '4', 'B',
    '3', 'E', '8', '9', '5', '9', 'D', '4', '4', '6', 'E', '2', '7', 'C', 'B', '2',
    '9', '9', 'E', '8', '8', '6', 'C', '3', '6', '6', 'F', '0', 'F', 'B', 'D', 'C',
    '1', '6', '7', '8', 'E', 'F', '7', '3', '9', '6', '5', 'B', '7', 'D', 'D', '6',
    '5', 'C', 'F', '2', 'A', 'A', '6', '6', '5', '1', 'D', '0', '0', 'E', 'B', '5',
    'B', '5', 'C', '2', '9', 'D', 'D', '7', 'E', 'C', 'F', '1', '4', '1', 'E', '1',
    'D', '8', '3', '4', '7', '9', '9', 'A', '7', 'A', '4', '1', 'B', '7', 'C', 'D',
    '6', '7', '2', 'A', '6', 'D', 'B', 'F', 'A', '9', 'D', '9', 'A', 'C', 'F', '4',
    '7', 'D', '5', '9', '9', '6', '2', '7', '1', '0', '9', '6', '1', 'C', 'F', '3',
    'D', 'F', '9', 'A', '4', '0', '2', '5', 'B', '0', 'E', '9', 'F', 'C', '3', '4',
    '9', 'E', 'A', 'E', 'F', '0', '3', 'A', '6', '4', '5', '5', '5', '9', '9', 'F',
    'E', 'C', '8', '5', '3', '1', '4', 'B', '3', '0', '1', '3', 'E', '0', 'B', '7',
    'D', 'F', 'C', 'D', '1', '9', 'B', 'E', '6', '7', '0', '3', 'F', 'F', 'D', '5',
    '0', '9', 'B', '3', '9', '2', 'B', '9', 'D', '6', 'B', '4', 'A', '9', 'A', '6',
    '0', '6', '3', 'C', 'C', 'D', '8', '1', 'E', '2', '4', '4', '4', '7', 'C', '8',
    'E', 'B', 'D', '1', '1', '5', '9', 'C', '5', '3', 'A', '2', '2', 'B', '2', '8',
    '4', '4', '7', '8', '0', '0', '1', 'B', '1', '8', '8', 'C', '0', 'F', '2', '1',
    'A', 'C', 'A', '9', '4', '5', '5', '3', '1', '7', 'D', '4', 'C', '0', '3', '7',
    'A', 'A', '6', '2', '8', '5', 'F', '1', 'F', '5', 'D', '8', '1', 'D', '3', '7',
    'D', 'F', '1', 'F', '7', '4', 'F', 'A', 'F', '3', 'D', '4', '9', 'C', '6', '5',
    'D', 'F', 'D', '3', '7', 'D', '2', '9', '6', '0', 'D', '7', '0', 'E', '0', '0',
    'D', 'F', '4', '4', 'C', '7', '0', '3', '8', '0', '2', '0', '5', '2', 'C', '4',
    'A', 'A', '5', '0', 'F', 'C', '1', '9', 'D', '8', 'D', 'B', 'B', '8', 'C', '7',
    'F', '1', 'F', '5', '1', 'D', '1', '4', 'B', 'C', 'A', '5', '8', 'F', '6', '2',
    '6', '9', '2', 'F', '0', 'E', 'E', '2', 'F', '0', 'A', '7', '6', 'F', '9', '0',
    '7', '6', '0', 'C', '2', 'C', '1', '2', '5', 'E', 'F', '7', '4', '1', 'D', 'D',
    '6', '4', '1', '4', 'E', '6', 'B', '7', '4', 'D', 'A', '1', '3', '2', 'B', 'A',
    'C', '6', '5', '0', 'D', 'F', '4', '6', 'D', 'F', 'E', '8', 'F', '7', '3', '8',
    'D', 'A', 'B', '8', '4', 'D', 'F', 'A', '4', '4', '1', 'E', '3', '8', 'D', '4',
    '3', '8', 'C', '1', '8', '3', '8', '3', '8', '4', '1', '8', 'C', '2', '7', 'A',
    'C', '4', '8', '7', '2', '7', '4', '1', '8', '6', 'D', '8', 'C', 'B', 'D', 'A',
    '4', '2', 'A', '1', '7', 'C', '1', '3', 'A', 'F', 'B', 'B', '7', 'A', '4', 'B',
    '8', '5', '1', 'D', '0', '1', '9', '3', 'F', '5', '7', '1', 'C', 'E', 'D', 'F',
    'C', 'C', 'C', 'E', 'F', '1', 'A', '3', 'D', '4', 'B', '8', '2', '2', '2', 'A',
    'A', '7', 'C', 'F', 'F', 'C', 'F', 'E', '8', 'A', 'E', '7', '0', '1', '6', '2',
    '2', '9', 'E', '8', '5', 'E', '1', '1', '6', 'B', '6', '2', '2', '6', '0', '5',
    '7', '1', '5', 'F', '2', 'D', 'C', 'B', '7', 'D', '9', '4', 'D', 'E', '0', 'D',
    '8', '3', 'B', '8', 'B', 'E', 'A', 'A', '2', '9', '8', '2', '7', '6', '4', 'F',
    'D', '7', 'C', '8', '6', '1', 'B', 'D', 'A', 'A', 'C', '4', 'E', '7', '2', '6',
    '2', 'C', '3', 'B', '0', 'F', '2', 'A', 'E', '2', '4', '6', '8', '6', '6', '4',
    'A', 'A', 'F', '3', '0', 'F', 'D', 'D', 'A', '6', '1', '0', 'E', '3', '9', '7',
    'D', 'F', '2', 'A', '6', '4', '1', 'F', '9', 'F', 'C', '0', '2', '9', '6', '9',
    'F', '8', '1', '0', 'E', 'B', 'C', 'B', '6', 'D', '9', 'B', 'F', 'D', 'C', '5',
    'B', 'A', 'B', '5', '6', 'A', '9', '0', 'E', '0', 'C', '3', '7', '9', '6', '3',
    'F', 'F', 'D', '0', '1', 'B', '0', 'D', '7', '2', '8', 'A', '0', '2', '8', 'C',
    'F', '2', 'E', 'C', '5', '0', '5', 'F', 'E', '3', '2', '6', '8', 'B', 'E', '5',
    '7', '3', '0', 'B', '5', 'F', '0', 'D', '3', 'D', '5', 'F', 'D', 'C', '9', '7',
    'B', '4', '6', '1', 'E', '3', 'B', 'C', '2', '2', '9', 'A', 'E', '6', 'D', 'A',
    '2', '2', '7', '7', 'E', '6', '0', 'E', 'A', '6', '0', 'C', '8', '3', '1', 'A',
    '5', '1', '5', 'B', 'F', 'B', '7', '2', '4', '1', '7', '6', '6', '0', '4', '0',
    'C', '8', '7', '9', 'F', 'B', '7', 'F', '4', 'A', 'A', '1', '0', 'D', '8', 'B',
    '4', '8', '6', 'F', '3', '5', 'A', 'B', 'F', '3', '7', '7', '6', '1', 'B', '2',
    '3', '8', 'B', 'F', 'F', '1', '7', '5', '4', 'C', 'C', 'D', 'C', '9', '1', 'D',
    'A', '7', '0', 'F', '7', '6', '7', '8', '5', '2', '1', '5', '5', '5', '5', '4',
    'E', '8', 'B', '1', '3', 'F', '5', '2', 'C', '8', 'C', '4', 'F', '9', 'C', '6',
    '6', '2', 'D', '6', '3', 'A', '9', '8', 'D', 'C', 'C', '9', '2', '3', '9', '7',
    '9', '8', 'E', '6', '0', 'E', '9', '9', '0', '8', 'B', '9', 'C', '2', 'B', 'F',
    '9', '4', '2', 'A', 'D', '4', '7', '5', 'E', '1', '2', 'C', '1', '7', '8', '4',
    'A', 'B', '0', 'A', '9', '9', '4', '8', '9', '7', '3', '5', '1', 'C', '5', 'B',
    '3', '4', '8', '3', 'C', '9', '5', 'E', '6', '8', '5', '0', '1', '1', '1', 'D',
    '5', 'F', '7', 'A', '3', 'E', '7', '4', 'F', '2', '7', 'A', '7', '3', '2', 'D',
    '2', 'F', '6', '3', 'C', '3', 'F', '4', 'D', '0', '2', '3', '8', '3', '5', '1',
    '2', '3', '7', 'C', 'E', '9', '4', '8', '4', '2', 'F', '1', 'C', '4', '0', '6',
    'E', '4', 'D', 'C', '4', '2', 'E', '8', 'C', '1', '4', '1', '3', '5', '0', '9',
    '6', '7', '3', '3', 'C', '0', '7', '2', 'D', '4', '3', '2', '1', 'F', '2', '3',
    'F', '5', '6', '8', '6', '8', '6', 'B', '5', '0', '0', 'D', '5', 'D', '9', '3',
    'B', '9', '1', 'D', 'A', '6', '5', '5', '6', '3', '7', '2', '9', '6', '4', '2',
    '4', 'B', '1', '7', 'D', '4', 'A', 'B', '6', '8', '3', '2', '5', 'E', '2', '7',
    'A', '9', '3', '8', 'C', 'A', 'D', '3', '6', 'A', '0', '5', '6', '1', 'E', '1',
    '7', '2', '9', '7', 'B', '0', 'E', '8', 'A', 'D', 'F', '4', 'B', '2', '7', '0',
    '6', '2', 'C', 'B', '4', '1', '7', '8', '2', 'F', 'F', 'B', '5', 'B', '7', '6',
    'E', '6', '3', '6', '6', 'D', 'B', '5', 'D', '3', '2', '9', '2', 'A', '6', 'D',
    '0', 'C', '7', 'D', '4', '3', 'F', 'A', '5', 'D', '8', '5', '7', '3', '8', 'E',
    'C', '0', 'B', '0', 'C', 'E', 'A', '6', '8', '6', 'A', 'C', '5', 'E', '2', '1',
    'B', 'F', '3', 'D', '7', 'D', '7', 'B', 'D', '3', 'C', '3', 'F', '8', '3', '4',
    '3', 'A', '8', 'B', '4', '7', 'C', 'F', '8', 'B', '5', '4', '9', '7', '9', 'D',
    'A', 'C', 'A', 'A', '0', '3', '3', '5', '8', '4', '1', 'B', '1', 'C', '2', '2',
    '0', '2', 'C', '8', '5', 'D', '9', '4', '5', '3', '2', '8', 'D', 'A', '0', '0',
    '5', 'D', 'B', '2', 'E', '9', '2', '4', '8', 'D', 'D', '5', 'D', 'F', 'B', '8',
    '6', '4', '4', '5', '7', '9', '1', '9', '7', 'A', '0', 'E', '3', '4', '8', 'C',
    'E', '7', 'C', '8', '4', '0', '9', '7', '2', '0', '4', '9', 'C', '9', '9', 'E',
    '0', 'C', '3', 'B', 'A', '7', '6', '0', '9', 'B', 'E', '6', '9', '5', '9', 'C',
    '1', '7', '6', '1', '8', 'E', '0', 'C', 'F', '8', '1', '4', '5', 'C', 'D', '6',
    'F', 'E', 'A', '5', '1', 'F', 'D', 'D', 'D', 'F', '1', '6', '2', '8', 'E', 'A',
    '3', 'F', '4', 'A', '4', 'D', '4', '0', '9', 'A', '4', '4', 'D', '2', '3', '0',
    '9', '8', 'F', '2', 'B', '2', '1', '7', 'B', '5', '5', 'A', 'D', '6', '6', 'E',
    '5', '0', '5', '0', '1', 'F', '4', 'C', 'B', 'A', '6', 'F', '8', '9', 'C', '1',
    '4', '2', '8', '2', '7', 'A', 'A', 'D', '9', '6', '2', '0', 'C', 'E', '9', '1',
    '2', '9', 'F', 'C', '5', '2', 'D', 'B', '5', '1', 'A', '1', '4', 'E', '0', 'E',
    'B', '1', '1', 'C', '4', '6', 'F', 'F', '9', 'A', '2', '4', 'E', '6', '4', '3',
    '4', '8', 'A', '0', 'C', '4', 'F', '5', '6', 'D', '1', '0', '4', 'F', '4', '4',
    'F', 'B', '0', 'B', 'D', 'D', '5', '5', 'D', 'A', 'B', 'C', 'A', '8', '9', '7',
    '7', '5', '8', '2', 'D', '1', 'B', 'E', '3', '9', '3', '9', 'F', '1', 'B', 'C',
    'A', '9', '9', 'E', '9', '7', 'F', '4', 'A', '2', '8', '0', 'D', 'E', 'C', '5',
    '0', '7', '8', '4', 'D', '5', '2', '7', '4', '0', '8', 'E', 'C', 'A', '0', 'F',
    'D', '2', '9', '0', '3', 'E', '4', 'A', 'D', 'A', '6', '7', 'C', '1', '7', '5',
    '9', 'B', 'C', '5', '4', '4', '5', 'C', 'C', '3', 'F', '9', 'A', '9', 'E', 'E',
    'B', '1', '4', '6', 'B', 'B', '9', '8', 'A', '9', '0', '9', '7', 'C', '0', '6',
    '2', 'E', '8', 'D', '4', 'B', '3', '4', '5', '2', '2', '5', '0', 'C', 'C', 'D',
    '4', '6', 'A', '4', 'B', '6', '6', '7', '6', 'C', '1', '2', '7', 'E', '0', 'B',
    'C', '9', '1', 'B', 'B', 'F', '5', '3', '6', '5', '9', '8', '0', '5', '6', 'E',
    'F', '1', '1', '1', '5', 'B', '1', '7', 'B', 'B', '9', '3', 'D', '8', '7', '6',
    'F', '8', 'F', '3', '2', '2', '5', '3', '8', '3', '9', '2', 'F', '7', 'F', '6',
    '4', 'D', 'A', '7', '3', 'F', 'F', '7', '0', '1', '3', 'A', 'E', 'F', '0', '5',
    '1', '1', '8', 'F', 'C', 'A', 'D', 'A', 'C', 'C', '5', 'B', '0', 'F', 'E', 'E',
    'D', '7', '5', 'B', 'D', '1', 'C', 'B', 'C', '7', '3', 'A', '2', '8', '7', 'E',
    'D', '8', '0', '1', 'D', '1', 'C', 'D', 'C', '9', '5', 'A', '5', '5', '3', '1',
    '2', '2', '1', 'E', '4', 'F', '0', 'C', '8', 'B', '2', 'B', '9', '3', '7', '9',
    '6', '6', '9', 'C', 'D', '6', '1', '4', '1', '7', 'B', '4', '8', '4', 'B', '5',
    '0', '8', '0', 'D', 'F', '5', 'D', '0', 'D', '2', '1', '7', '9', '2', '8', '8',
    '0', 'F', '8', '1', '8', '5', 'A', '1', 'E', '1', '4', '0', 'C', 'B', '6', '3',
    'A', '1', '1', '9', '6', '3', '1', '6', '8', 'F', '8', 'E', 'B', '6', 'E', '8',
    'F', '3', '9', 'D', 'F', 'D', '6', 'C', '2', '0', '8', '7', 'B', 'D', '3', '9',
    '6', '6', '1', 'E', 'D', 'C', 'D', 'B', '8', 'F', '1', 'A', '2', 'E', '7', '7',
    'E', '9', '8', '2', 'B', 'C', '9', '9', '8', 'D', '1', '6', '4', '1', 'B', 'F',
    '4', '9', '1', '3', 'A', 'D', '6', '4', '8', '5', 'D', '7', 'D', 'C', '6', '6',
    '8', 'C', '5', 'E', 'F', '0', '9', '3', 'D', 'B', '9', 'D', '4', '9', '6', 'D',
    'A', '0', '2', '3', '2', '5', '9', 'E', '0', '9', '3', 'F', '9', '7', '8', '8',
    'B', 'A', '5', 'A', '1', 'C', 'F', '0', '6', '8', '9', '6', 'E', 'F', '5', '1',
    '9', '0', '9', 'B', 'D', '2', '6', '3', '1', 'D', 'D', '7', 'F', '8', '1', '6',
    'A', '4', 'A', 'D', 'B', '3', '7', 'F', 'F', '0', '0', 'D', '6', '1', 'E', '3',
    '0', 'D', 'F', '7', '7', '1', '2', 'A', 'C', 'D', '3', 'E', '0', '5', '9', '3',
    'C', '8', '8', 'A', '0', 'C', 'E', 'A', 'B', '0', 'F', 'B', '7', 'A', 'D', '3',
    'B', 'B', '7', 'F', 'B', '8', 'B', '3', '6', 'B', 'B', 'F', '4', '8', '5', '6',
    '2', '5', 'E', '4', '2', 'D', 'D', '0', '1', '0', '2', '0', '3', '6', '7', '0',
    '5', '8', 'C', '0', '3', 'A', 'E', '6', '1', 'F', '9', 'F', 'C', 'D', '0', '1',
    'A', 'A', '0', '9', 'F', '9', '5', '3', 'A', '3', '6', 'C', 'D', 'B', '8', '1',
    'A', '1', 'B', '7', '4', '1', '8', '2', 'B', 'B', '2', '9', '9', '6', '2', '1',
    '5', '8', 'D', '0', 'E', '0', '5', '5', '1', 'B', '3', 'F', '5', '7', '6', '8',
    '5', 'A', '5', 'A', '0', 'E', '5', '9', '0', '6', '8', 'D', 'C', '1', '2', '5',
    'D', '2', '3', '5', '6', 'C', '5', 'C', '9', '2', 'C', '8', 'A', 'D', '1', '4',
    'D', '2', 'A', '8', 'D', '0', '8', 'F', 'E', '5', '4', '3', '4', 'F', '5', '7',
    '5', '3', '8', 'C', '1', '2', '6', '4', '0', '9', '1', 'E', '1', '0', '6', '4',
    'E', 'B', 'C', '8', 'C', '4', '4', '5', 'A', 'F', '6', 'F', 'A', '3', '9', 'A',
    '6', 'D', 'D', '1', '9', 'F', '4', '6', '3', '3', '9', 'D', 'E', '1', '3', '0',
    '5', '5', '1', '3', '9', '1', '7', '7', 'F', 'B', 'A', '9', 'B', 'E', 'B', '3',
    'A', '5', 'E', '3', 'F', 'C', '6', 'B', 'C', 'B', 'A', '0', '1', '0', '1', '8',
    '1', 'D', '8', '8', '0', '5', '9', 'E', '0', '6', '2', 'F', '9', 'D', '0', 'B',
    '1', '0', 'B', '5', 'D', '4', 'A', 'C', '1', 'A', '4', '8', '3', '5', '9', '7',
    '4', 'E', '5', 'F', 'F', '5', '1', '8', 'A', '3', '1', '9', '9', '0', '7', 'E',
    'F', '9', '5', '0', '4', '7', '5', '1', '4', '6', '1', '3', '3', '7', 'B', 'A',
    'B', 'E', 'C', '5', 'F', '6', '3', 'A', '7', 'A', 'B', '7', '3', '1', '0', 'B',
    '6', '6', 'F', 'D', 'A', 'A', 'E', 'D', '9', '3', 'E', 'D', '9', 'A', '1', '2',
    '9', 'C', 'A', 'B', '4', 'F', '8', '4', '2', 'E', 'D', '5', '1', 'D', '6', '9',
    'F', '8', '8', '2', '9', '4', '0', 'D', 'F', 'C', '8', '4', 'D', '6', '7', '9',
    '1', 'C', 'A', '3', '8', '8', '0', 'B', '1', '7', 'D', '2', '8', 'E', 'D', '4',
    '1', '1', '8', '0', '4', 'F', '9', '8', 'B', 'A', '2', '4', '8', '9', 'B', '8',
    '2', '6', 'E', '4', 'B', 'D', 'E', 'C', '3', '9', '3', 'F', '8', '3', '0', '6',
    '2', '6', '8', '8', 'A', 'E', '4', '4', 'B', '0', '9', '6', '0', '2', 'A', 'C',
    'E', '7', '7', '5', '2', '1', '0', 'F', 'D', 'E', '3', 'F', '4', 'C', '4', '4',
    'C', '9', '4', 'D', '5', 'D', 'F', 'A', '5', '2', '8', '6', '0', '2', 'B', '0',
    'A', '3', '3', 'E', '7', '7', 'A', 'E', '2', 'A', 'E', '6', 'F', '2', 'D', 'B',
    '9', '6', 'E', 'A', 'E', 'E', '7', 'D', '2', 'F', '1', '2', '8', '5', '4', '5',
    'D', '0', '2', '2', 'A', '2', 'D', '6', '3', 'A', 'D', '4', '5', 'F', '7', '4',
    '0', 'C', 'B', '7', 'A', 'C', 'B', '6', '1', '3', '7', '7', 'C', '1', 'B', '0',
    '1', '9', 'A', 'F', 'F', '8', '3', '4', '2', '3', '6', '3', 'D', '8', '8', 'E',
    '9', '2', 'A', 'B', '7', '6', '4', '3', '9', '7', 'A', '9', '6', '2', 'C', 'B',
    'E', '6', '6', '9', '8', 'B', '2', '5', '3', 'C', '3', '1', '9', 'C', '3', '0',
    '6', 'F', '5', '3', 'D', '9', '7', '3', 'B', '6', 'B', '0', '4', '8', 'D', '2',
    'B', '2', 'A', '3', 'F', 'A', 'A', 'B', '4', '6', '9', 'F', '9', 'E', '5', 'D',
    '6', 'F', '4', '6', 'C', '6', 'D', 'D', '0', '5', '7', 'C', '4', '1', '1', '1',
    '6', '0', 'B', '7', '3', 'A', '8', 'D', '5', '4', 'E', '0', '2', 'A', 'C', '7',
    '1', '3', '9', '6', 'B', '7', '0', '4', '3', 'B', '1', '2', '9', 'D', 'D', '6',
    'F', '5', '0', '6', '9', '8', '8', '5', 'C', '9', 'E', '8', '4', '4', 'A', 'F',
    '9', '1', 'D', '7', '3', '9', '4', '9', '5', '7', 'E', '0', 'F', 'D', '2', 'B',
    '7', '1', 'A', '9', '2', '0', 'B', '2', '5', 'B', 'E', '0', 'B', 'E', '3', 'B',
    '7', 'F', '8', 'A', '5', 'D', 'C', '5', 'E', '6', '3', '9', '7', '4', '0', 'E',
    '9', '8', 'E', '9', 'D', 'C', '1', '1', '8', '5', '3', 'C', '4', 'A', 'A', '2',
    'B', '9', '5', '9', '1', '7', '2', 'B', '7', '0', '1', '4', '4', '9', '1', 'D',
    '9', '2', 'C', 'B', 'A', '0', '7', 'A', '4', '5', '4', '0', '2', 'F', 'B', '8',
    '8', '6', '6', '6', 'C', '3', 'A', 'A', '7', '0', '4', 'B', 'B', '7', 'F', 'F',
    '1', '4', '2', 'E', 'C', 'D', '3', '4', 'F', 'F', '2', '2', '1', '7', '9', 'C',
    'D', 'B', 'B', '2', '9', '1', '0', '8', '7', '0', '0', '8', 'F', '0', '7', '4',
    '9', '5', 'D', 'A', '2', '8', 'B', '5', '7', 'E', 'F', 'D', 'B', '8', '6', '2',
    '5', '8', '4', 'B', '1', '2', '9', '7', 'D', 'E', '2', 'D', 'B', '0', 'A', '7',
    'D', '7', '3', 'F', 'E', '5', 'F', 'D', 'C', '1', 'F', '4', '1', '6', 'A', '4',
    'A', 'C', 'D', '8', '8', '7', '0', '3', 'F', '9', 'D', '7', '1', '4', '9', '8',
    'B', '7', 'D', '6', 'F', 'A', 'B', 'A', 'C', '0', '9', '4', 'D', '5', 'D', '9',
    '5', 'E', 'D', '1', '2', 'F', '5', '9', 'C', 'C', '8', '6', 'F', '3', '4', '6',
    'E', '4', '3', '9', 'D', '7', 'C', '9', 'F', '7', 'F', 'D', 'B', 'D', '9', '3',
    'C', 'C', 'C', '3', 'E', '2', '0', 'C', '5', 'D', '5', '1', '3', 'A', '3', 'D',
    'D', 'E', '5', '4', 'B', '7', '2', 'C', 'B', '7', '8', 'F', 'B', '1', '1', 'F',
    'C', '7', '9', '4', '1', '3', 'D', '6', 'C', 'D', 'D', '5', '7', 'E', '9', 'F',
    '3', 'A', 'C', 'B', '2', '3', '7', '9', 'B', '8', 'A', '9', '9', '2', 'F', '8',
    '3', 'C', '1', '3', '1', '0', 'C', 'C', 'F', '8', '9', '2', 'E', 'A', '3', '0',
    'E', '2', '0', '3', '1', '4', 'F', '9', 'E', 'D', 'F', 'C', '1', 'F', 'F', '1',
    'B', '3', '4', '8', '9', '1', 'B', 'F', '7', '8', '3', 'D', 'D', '3', '7', '0',
    'D', 'A', 'C', 'B', '4', '0', 'D', '3', 'C', '0', '0', 'B', 'F', '5', '2', '8',
    'B', 'E', '7', 'E', '7', '6', '2', '0', '7', '1', 'E', '0', 'C', '9', 'C', 'A',
    'F', '8', '6', '4', '2', 'B', '5', '7', 'D', 'D', '6', 'E', '2', 'F', '7', '1',
    'E', '9', '4', '6', 'B', '8', '0', '0', '4', 'D', '4', 'A', 'B', 'B', 'D', '3',
    '2', 'D', '9', 'C', 'B', '4', '4', '6', '9', '7', 'D', '4', 'F', '2', 'A', 'C',
    '5', 'B', 'C', '7', '8', '5', '7', 'A', '0', '4', '2', 'B', 'F', 'F', '3', '5',
    '1', 'A', '4', '9', '2', 'E', '7', 'C', '0', '8', '0', 'B', '6', '1', 'E', '1',
    'A', 'E', '0', '5', '4', 'F', '9', '1', 'F', '9', 'F', '0', '1', 'B', '1', 'F',
    'C', '6', '4', '5', '8', '2', '1', 'B', '0', 'E', 'F', '6', 'A', '0', '3', '8',
    '7', '2', 'A', '9', '5', '9', '7', 'C', '8', '4', '5', '2', 'D', '4', '8', '4',
    '2', '6', '2', '2', '0', '9', '3', 'B', '5', '5', 'A', 'F', '7', 'B', '0', '6',
    '1', '7', '8', '1', '2', 'B', 'A', '6', 'A', '2', '1', 'A', 'A', '1', '1', '3',
    '5', 'C', 'D', '5', '7', '4', '1', 'D', '3', '1', '6', '0', 'B', 'B', '5', 'D',
    'A', '4', 'B', '4', '0', '8', '3', '7', '2', '5', 'E', 'C', 'C', '0', '6', 'B',
    '8', '4', 'F', '0', '6', '2', '2', '4', '2', 'C', 'D', '3', '1', '4', '4', 'F',
    '3', 'C', '4', '0', '7', '0', '9', '2', 'A', '5', '3', '9', '1', '6', '9', '3',
    'F', 'B', '6', '2', 'C', '1', 'E', 'B', '0', 'A', 'C', '6', '8', 'E', 'C', 'C',
    '9', 'F', '5', '4', '8', 'A', '0', 'C', '5', '4', 'D', 'E', '6', '7', '0', '5',
    '7', '9', '5', 'C', 'F', 'D', '8', 'D', 'C', '6', 'B', '2', '7', '6', '8', 'A',
    'B', 'E', '2', '9', '9', '4', 'E', '2', 'E', '1', 'F', '4', '0', '2', '9', 'F',
    '1', '0', 'E', 'A', '6', '8', '7', '1', '2', '4', '0', '9', '8', '2', 'C', 'D',
    '3', '0', '7', '7', 'D', '7', '8', '2', '8', 'A', '2', '0', '2', 'B', '2', '4',
    '8', '1', '5', '1', '6', '5', '1', '9', '9', '7', '8', 'B', 'A', '4', '3', '1',
    'F', 'F', '1', 'D', 'C', '3', 'B', 'B', '5', '1', 'D', '5', '1', '0', 'F', '0',
    '3', 'C', 'F', '6', '9', 'D', 'C', 'A', '2', '1', 'B', 'F', 'C', '0', 'E', '9',
    'C', '4', '1', 'F', '6', '8', '5', '8', '8', 'B', '8', '5', '5', 'F', 'E', '2',
    '0', '2', '3', '3', 'B', 'C', '8', '5', '6', '8', '6', 'B', '7', '4', 'B', '6',
    '3', 'B', '9', '5', '5', '9', 'B', '9', '6', '7', 'C', '7', 'B', 'C', '0', '3',
    '5', 'A', '2', 'B', 'C', '3', 'C', 'D', 'A', '9', '7', '0', 'F', '4', '7', 'B',
    '8', 'E', '0', 'A', '8', '6', '8', '4', 'A', '1', 'F', '9', 'E', 'A', '1', 'D',
    'B', '2', '2', '8', '4', 'B', 'F', '7', '3', '6', '0', '1', 'B', 'D', 'E', '5',
    'C', '1', 'C', '0', '2', '7', '9', 'D', '4', '6', '1', '2', 'C', 'F', '0', '7',
    '5', 'B', '6', '1', 'E', 'C', 'D', 'F', '8', '5', '6', '0', 'E', '3', '7', '9',
    'B', '7', '1', '6', '7', 'A', '1', '2', 'A', '0', '2', 'E', '4', 'C', 'F', '0',
    '0', '1', 'C', 'E', '3', '6', 'E', '4', '8', 'F', '4', 'D', 'F', 'E', '6', '8',
    'B', 'C', 'E', '2', '4', '6', 'A', 'C', 'C', '2', 'F', 'B', 'D', '1', 'B', '4',
    '6', 'D', '7', '3', '5', '9', '2', '5', '4', '6', 'D', 'D', '4', '2', '4', '0',
    'A', '1', '1', 'C', 'A', '6', 'E', '2', '3', '7', 'C', 'A', '8', '7', '5', 'F',
    '2', '1', '2', 'E', 'A', '9', 'E', '2', '8', '0', 'A', '4', '7', '5', '0', '1',
    'B', '6', '0', '5', '1', '9', 'F', '2', '1', '0', 'A', '7', 'D', '7', '2', '9',
    '7', 'B', 'F', '5', '6', '0', 'F', 'B', '3', '0', '0', 'F', '8', '5', '1', '5',
    '2', '9', '7', '2', '9', '0', '5', '8', 'C', '6', 'D', 'A', 'C', '6', 'C', '5',
    '9', '7', '6', '9', '6', 'E', 'F', '6', '2', 'F', '6', '6', '5', 'E', 'A', 'C',
    'B', '8', '1', '5', '3', '1', '4', '4', '1', 'C', 'C', 'F', 'D', '3', '5', '4',
    '3', '5', '5', 'C', 'C', '1', '4', '2', 'C', 'E', '5', '2', 'C', '2', '3', '6',
    '9', 'F', '0', '7', '6', '3', 'C', '1', '7', 'F', 'B', 'A', '4', 'F', '0', '6',
    '1', '8', '1', '5', 'C', '2', 'E', 'E', '7', '2', 'C', '9', 'C', 'E', '0', 'E',
    '8', 'D', 'D', 'E', '7', '8', 'C', '9', 'A', '9', '5', '5', '2', 'D', 'A', 'C',
    '4', '7', '9', 'F', '7', '9', '0', 'A', '8', '2', 'A', '9', 'E', 'E', '0', 'D',
    '0', '4', '8', '2', '9', '4', 'D', 'F', '5', 'D', 'E', 'F', '4', '1', '7', '8',
    '9', 'B', '3', 'A', '4', '1', 'B', '5', 'C', '8', '0', '7', '7', 'F', 'E', '0',
    'A', '6', '5', '8', 'F', 'E', '7', '8', '4', '1', 'B', 'F', 'C', 'B', '0', '9',
    'C', '2', '2', '5', 'C', '2', 'B', '9', 'B', '6', '0', '7', 'B', 'C', 'A', 'E',
    '3', 'F', '4', 'A', '0', 'E', 'F', '6', '2', 'E', '0', '7', 'F', '6', 'B', 'C',
    '6', '7', '4', '9', '5', '0', 'F', '2', 'B', 'B', '5', '1', 'A', '8', '4', '6',
    '6', 'C', '4', 'E', '8', '5', '3', 'E', 'F', '3', '3', 'A', '9', '9', '1', '8',
    'C', 'A', 'A', 'F', 'D', 'D', 'C', '3', '7', '6', 'D', '9', '3', '6', 'D', '0',
    '6', '3', '4', '7', '5', '8', '9', 'F', 'F', '6', '9', '7', '6', 'F', '1', '4',
    'A', 'E', 'A', 'E', '6', '5', '8', 'D', '6', '4', '4', '7', 'E', '6', 'A', 'D',
    'E', '8', 'E', 'E', 'A', '6', 'D', '6', '9', '1', 'F', '8', '0', 'E', 'D', 'E',
    '1', 'D', 'B', '8', 'D', 'E', '8', '9', '8', '9', '4', 'D', 'D', '2', 'F', 'C',
    'C', '7', '5', '8', '7', '9', 'D', '5', '5', '7', 'B', 'A', 'C', '7', '9', '4',
    'A', 'A', '3', '0', 'B', '2', '4', '6', '1', '0', '9', '7', 'F', 'F', '3', '6',
    'D', 'C', 'E', '4', 'B', 'E', '3', '0', 'B', 'D', '7', '2', 'D', '4', 'C', 'C',
    '3', '6', '3', '1', '4', 'A', 'C', 'C', '0', 'E', '7', 'E', 'C', 'D', 'C', '9',
    'F', 'A', '0', '6', 'D', 'A', 'B', 'C', '9', '3', '8', '6', 'B', 'F', '5', 'E',
    'A', 'F', 'F', '9', '2', '6', 'E', '8', '2', '5', 'C', '9', '7', '2', '5', '5',
    'B', 'C', 'D', '6', 'A', '2', '8', 'D', '5', '8', '0', '2', '7', 'B', 'E', '7',
    '0', 'A', '7', 'F', 'A', '7', '8', '4', 'D', '2', 'E', 'F', '5', 'A', '8', '7',
    'B', '7', 'A', '0', 'E', '7', '3', '0', '0', 'F', 'D', 'E', 'D', '8', '2', '9',
    'F', 'F', '7', 'C', 'F', '5', 'B', '1', 'F', '1', 'B', '8', 'E', '1', 'B', '5',
    '1', '2', '8', '9', 'B', '9', '4', 'D', '9', '1', '2', '1', '6', 'F', '0', '1',
    '1', '1', '0', '0', 'E', '2', '1', 'E', '6', '9', 'B', '6', '1', '5', '5', 'E',
    '1', 'F', 'A', 'A', '3', 'C', '3', 'C', '2', 'B', 'E', '9', 'A', '4', '3', 'F',
    'D', '8', '1', 'A', 'C', '6', '8', '0', '4', 'B', 'F', 'D', '4', '1', '2', '6',
    'A', '2', '2', 'A', '8', 'F', '6', '0', 'E', 'F', '3', 'A', '7', '6', '8', '2',
    '3', '2', '2', 'B', 'B', 'C', '3', '3', '4', '5', 'B', '9', '5', '0', '2', '8',
    'C', '9', 'C', 'A', '0', '5', '3', '9', '9', '1', '2', 'B', '9', '0', '4', '2',
    '2', '7', 'E', 'F', 'C', '1', 'C', '9', '0', 'B', '6', '6', 'B', 'F', 'B', '9',
    'D', 'B', '9', 'D', '7', '2', '5', '8', '3', 'B', 'F', 'F', 'B', '8', 'A', '6',
    '7', 'F', 'B', '8', 'E', '2', '6', '2', '5', '9', '6', '5', '1', 'C', '3', 'B',
    '7', 'A', '8', 'C', '7', 'C', '9', 'E', 'F', '2', 'A', 'D', 'B', '4', '3', '9',
    'E', 'D', 'C', '3', '1', 'E', '4', '0', 'D', '6', 'C', '2', 'C', '4', '3', '8',
    'F', '2', '6', 'A', 'E', 'B', '0', 'F', '7', '7', '7', 'C', '9', '6', '4', '1',
    '6', '0', '1', '4', 'B', 'F', '5', '2', '6', '0', '9', 'D', 'F', 'A', '5', '7',
    '2', '5', 'F', '0', 'F', '5', '9', '7', '4', 'E', '6', '0', '5', '3', '8', '6',
    '9', '1', '5', 'D', 'E', 'C', 'B', 'E', 'B', '2', 'D', 'C', '3', '0', '8', '4',
    '2', 'A', '7', '5', '6', 'C', '1', 'A', 'E', '5', '0', '9', '7', '4', '4', 'B',
    '5', '0', 'E', 'B', '1', 'E', 'A', '0', 'F', 'D', '0', '0', 'B', '1', '6', 'D',
    'E', '5', '5', 'B', '7', 'E', '0', '6', '2', 'E', '5', 'B', '5', 'F', 'B', '0',
    'C', 'A', '4', '2', '2', '7', 'E', '8', 'E', '3', 'D', 'C', 'C', '3', 'D', '3',
    'F', '2', 'B', '3', 'B', 'D', '1', 'D', '9', '3', '7', '5', 'C', 'F', '1', 'C',
    '9', '5', '7', 'A', '1', '7', 'F', 'A', '8', '5', '6', '0', '2', '2', '2', '4',
    'C', '0', 'F', '6', '6', 'B', '9', '7', 'E', 'A', 'A', '3', '4', '5', '6', 'B',
    'E', '4', '5', '0', '5', '2', '7', 'F', '9', 'C', '6', 'B', '5', '5', 'F', 'C',
    '2', '3', '5', 'B', '6', 'A', '6', 'D', '8', 'A', 'F', 'B', '0', '8', '3', 'D',
    '8', '1', 'D', 'B', 'A', '7', '3', '7', 'D', '2', 'C', 'C', 'F', 'B', '0', '3',
    'A', '5', '2', '0', '8', '9', 'A', '3', 'C', '8', '6', '9', '6', '4', 'F', '2',
    'E', 'D', 'D', '5', '4', '9', 'B', 'E', '6', '9', '7', '3', '8', '7', '2', 'F',
    'E', 'D', '1', '9', '0', '8', 'F', 'B', 'F', '7', '3', 'D', 'F', '8', 'E', 'B',
    'D', 'D', 'C', '5', 'F', '5', '4', '8', 'E', '6', '5', 'C', '1', '2', '4', '5',
    '0', '6', '2', '6', '2', '7', '4', '0', 'B', '3', 'D', 'A', '1', 'D', 'B', 'E',
    '5', 'E', '3', 'A', 'A', 'D', '3', 'C', '1', '9', '5', 'C', '6', 'E', '3', '3',
    '7', 'D', '2', '4', 'F', 'C', '4', 'A', '2', '2', 'D', '6', '4', '9', 'C', '7',
    'F', '1', '5', 'C', '6', '7', 'D', '5', '9', '3', '1', 'B', '5', 'D', '5', '2',
    '4', '8', 'D', '1', '1', 'C', '2', '6', '2', '7', '7', 'C', '2', '3', '9', '1',
    '8', '4', 'E', 'E', '5', '6', 'D', '3', '1', 'A', '5', '3', 'B', '7', '7', '7',
    '4', 'E', '2', 'C', 'E', 'D', 'E', '5', '9', 'C', '7', 'E', '8', 'C', '4', 'E',
    'F', '2', '1', 'D', '2', '3', 'C', '2', '3', '0', '5', '4', '6', '4', '6', '0',
    '8', '2', '4', '5', 'C', '7', '6', '6', '0', 'D', 'C', '9', '9', '7', '0', 'A',
    '2', 'A', '1', '6', '7', 'E', '5', '1', 'B', 'F', '4', 'C', '7', '6', '1', 'A',
    'A', '3', '7', 'A', '7', 'B', '9', '2', '1', 'E', '4', '6', '0', '1', '2', '1',
    '5', '8', 'E', 'C', '4', 'B', '7', '7', 'A', '7', '4', 'B', 'B', '7', '9', '8',
    '4', 'F', '6', '7', 'E', '9', '7', '9', 'E', 'E', '6', '7', '2', '5', '1', '0',
    'A', '5', '1', 'A', '7', '6', '0', 'F', 'B', '6', '1', '4', 'D', 'D', '3', '0',
    '9', '9', '4', '8', '7', 'C', 'F', '8', '5', '4', '4', '3', 'C', 'C', '0', 'B',
    '8', 'F', 'C', '6', '3', 'F', 'F', '6', '3', '7', '2', '4', '5', '1', 'E', 'C',
    'B', '2', 'E', 'D', '5', 'D', 'C', 'E', '1', '4', '9', 'C', '4', 'A', '3', 'D',
    '5', '5', 'D', 'C', '4', '5', '5', '5', '1', 'C', '6', '9', 'F', '6', '0', '2',
    '9', 'D', 'C', '1', 'D', '0', '6', '3', 'C', 'A', 'C', '2', '6', 'A', '7', '4',
    '6', 'A', '7', '5', '9', 'F', '1', 'B', '7', '6', 'E', '2', '2', 'C', '7', '1',
    '8', '8', '6', 'C', '7', 'F', 'D', '0', '5', '4', '4', 'F', 'D', '7', '1', '8',
    'C', '0', '1', '6', '2', 'C', '3', '4', '8', 'A', '5', 'F', '8', '4', '4', '2',
    'A', 'F', '0', '0', '1', '2', 'B', 'E', '9', '2', '2', '0', 'D', 'E', 'F', '7',
    'C', 'C', '6', '5', '1', 'B', 'B', 'F', '2', '2', '4', '5', 'D', '0', '6', '7',
    'F', '8', '2', '0', 'D', '0', '6', '9', 'B', 'D', '7', 'C', '6', '7', '5', '2',
    '2', '7', 'A', 'F', '8', '5', 'B', 'B', '7', '3', '3', '9', 'F', '3', '7', '3',
    'A', 'A', '2', 'E', '9', 'A', '4', 'D', '9', '6', 'F', '4', 'D', '2', '4', '9',
    'A', 'A', '8', 'E', '6', '0', '9', '1', '1', 'E', 'C', '8', '0', '4', '4', 'B',
    '1', '1', '1', '6', 'D', '4', 'B', 'F', '0', '9', '4', '2', '2', 'A', '9', 'E',
    '3', 'D', '3', '1', 'B', '2', '3', '7', '5', '6', '9', '2', '2', '6', 'D', 'E',
    'B', '5', 'C', '6', '8', 'C', '1', '6', 'B', '0', '6', '3', '9', 'A', '1', '1',
    '9', '0', '8', 'B', '6', '1', '8', '2', '5', 'F', '5', '3', 'F', '4', 'B', 'B',
    '8', '8', 'F', '9', '1', '0', 'E', '0', '0', 'B', '9', '0', 'F', '1', 'C', 'E',
    '3', 'F', 'F', 'D', 'C', 'C', '5', '9', '3', '7', '2', '9', 'D', '4', 'C', 'D',
    '7', '8', '1', '4', '7', '5', 'D', 'D', '0', '5', '6', 'E', '6', '5', '7', '7',
    'B', 'F', 'D', '7', 'D', '4', 'E', '3', '4', '2', '0', 'E', '5', 'D', 'F', '8',
    'E', '6', '6', 'F', 'B', 'D', '9', '7', '6', 'B', '0', '3', 'A', '5', '2', 'F',
    '8', 'D', '7', '9', 'B', 'F', 'A', '4', 'A', '5', '4', '2', '1', '6', 'C', 'F',
    'B', '8', 'B', '5', '6', '4', '2', '4', '7', 'A', '8', '6', '4', '7', '8', 'B',
    '7', 'F', 'C', '5', '5', '0', '3', 'B', '8', '5', '5', '7', '6', 'A', '2', '3',
    'B', 'D', 'B', 'C', '2', '9', '2', 'E', '3', '5', '0', '6', '6', '6', '8', '8',
    'D', 'A', 'E', '3', '3', '1', '4', '1', '5', '2', 'C', '7', '5', '8', '0', '0',
    'E', 'E', '8', '4', '5', 'C', '8', '9', '9', '0', '6', '2', '0', '5', '5', '8',
    'B', 'E', '1', '9', '7', 'B', '9', '1', '4', 'F', '6', '3', 'A', 'F', '5', '4',
    '3', '8', 'D', '8', '1', 'B', 'F', '7', '2', 'B', '1', 'D', '6', 'C', '6', '3',
    'E', 'D', '3', 'A', 'A', '7', '8', '9', '0', '7', '6', '0', 'B', '7', 'B', 'E',
    '6', '3', 'F', '5', 'C', '0', 'B', '9', '7', '9', '0', '2', '8', 'C', 'C', '8',
    'D', '8', '7', '8', 'A', '2', 'A', 'D', '4', '2', '9', '5', 'A', 'E', '2', '8',
    'E', '6', '4', 'E', 'C', 'C', 'E', '9', '7', 'D', '7', 'B', 'A', 'C', '6', 'C',
    'D', '0', 'B', '8', '7', '7', '6', '8', '2', '3', 'D', 'D', '8', '0', '2', '8',
    '9', '9', 'F', '1', '6', '1', 'E', '7', 'B', 'E', 'A', 'F', '8', 'F', '3', '9',
    'D', 'F', 'E', '1', '0', '2', 'E', '4', '5', 'A', '2', '4', 'A', 'A', 'E', '4',
    '7', '6', 'B', 'E', '4', 'F', '2', '7', 'D', '1', '4', '0', '3', '2', 'D', '2',
    'D', 'E', 'B', 'B', '5', '5', 'F', 'D', 'C', '0', 'E', 'F', '0', 'B', '6', '2',
    '5', '9', '5', 'A', 'B', '0', 'D', 'E', '4', '7', '1', '4', '8', 'C', 'F', '2',
    '8', 'B', 'B', '5', '2', 'F', 'C', '9', 'D', '8', '1', '2', '2', '0', '2', '1',
    '1', 'B', 'E', '6', '7', 'E', 'C', '2', '5', 'A', 'C', 'D', '1', 'C', '4', 'C',
    'E', '0', '6', 'B', '7', 'B', '3', 'E', '5', 'C', 'B', 'A', '4', '6', '4', 'D',
    'C', '5', 'F', '5', '3', '2', '4', '0', '8', 'A', '0', '1', 'B', '0', '4', '3',
    '7', '1', '3', 'E', 'D', 'B', '0', '2', '7', 'F', '7', '0', '0', '4', '8', 'C',
    '1', '1', 'A', 'E', '6', '9', '8', '7', '0', '8', 'A', '6', 'A', 'C', 'F', 'E',
    '4', 'B', 'E', 'C', '1', 'B', 'B', '6', '8', 'A', '9', '4', '9', '6', '6', '3',
    'A', '2', '3', 'F', '1', '1', '7', '9', '8', 'E', '6', 'B', 'E', '7', '4', 'B',
    '8', 'B', '4', 'C', '1', 'C', '6', 'E', '9', 'E', '8', '2', '2', '1', '5', '2',
    '5', '5', 'B', 'C', 'E', 'E', '7', 'B', '6', 'E', '2', '3', '8', 'C', 'D', '7',
    '4', '4', 'D', '7', '1', '8', '5', 'F', '8', '3', 'C', '3', '9', '0', 'E', 'B',
    '2', 'F', '6', '7', '7', '7', '2', '6', '9', 'E', 'C', '8', '0', '3', 'F', 'C',
    '4', '6', '3', '0', 'B', '3', '1', '9', '3', '5', '1', '4', '3', 'A', 'A', 'B',
    '9', 'D', '8', '9', '7', '5', 'B', '2', '5', '7', 'D', 'E', 'B', 'C', '3', '7',
    'A', '0', '3', 'C', 'A', 'B', '6', 'E', 'E', '7', 'C', '3', 'F', '6', 'E', 'F',
    '4', '5', 'E', 'D', '2', '7', 'B', 'D', 'F', '0', '0', '0', 'F', '2', '9', 'E',
    'F', '6', '9', '8', '5', 'C', '6', '8', 'F', 'C', '2', 'E', '5', '6', '7', '8',
    '1', '2', 'D', '3', 'A', 'E', '7', '3', 'B', '7', '9', 'F', '1', '8', 'D', '7',
    'B', '7', '4', '8', '8', '1', '5', 'C', 'A', 'D', '7', '6', '5', 'E', 'A', 'D',
    '9', '4', '9', '7', 'E', '9', '8', '1', 'F', '9', 'B', '2', 'D', '4', 'C', '0',
    '1', '6', '1', 'E', '2', '8', '9', '7', '5', 'C', '4', 'D', 'F', '1', '0', 'D',
    '2', '9', '9', '7', '1', 'D', '3', '6', '2', 'C', 'F', 'E', 'B', 'A', '5', 'D',
    '9', 'B', 'A', '8', '2', 'B', '3', 'D', '3', '3', '3', '4', '6', '7', 'A', '9',
    'F', '5', 'C', 'D', 'E', '8', '5', '4', '6', 'B', 'A', '8', 'D', '9', 'B', 'C',
    '4', 'F', '0', 'D', 'C', '8', '4', '0', 'D', 'B', 'D', '8', '5', 'A', '1', '5',
    'A', '0', '1', '6', 'E', 'B', '0', '7', '8', '6', '3', '5', '7', 'A', '0', '2',
    'D', 'D', '9', 'E', 'A', 'B', '4', 'F', '2', 'B', '8', '3', 'B', '3', 'C', '9',
    '4', '7', '0', '3', 'F', 'C', 'D', '4', '4', 'B', '9', 'E', '0', '2', '9', '3',
    '6', 'B', '3', '5', 'B', 'C', '1', 'F', '3', 'E', '8', 'B', '5', '0', '4', 'E',
    '3', 'E', '6', '3', 'B', '8', '9', '0', '5', '6', 'F', 'C', 'D', 'C', '7', '8',
    'D', '7', 'F', '4', 'C', '8', '8', '5', '2', '2', '8', '5', '5', 'E', '7', '2',
    '6', 'C', '6', 'F', '9', '7', 'B', 'E', '5', '2', '3', '5', '4', 'E', '7', '3',
    '1', '4', '3', '1', 'E', '0', '0', '2', 'F', '2', '4', '5', 'B', '6', '6', 'A',
    '4', 'C', 'B', '6', '5', '9', 'F', 'E', '4', 'F', '5', '3', '8', '4', '6', 'A',
    'E', 'F', '4', 'B', '8', '3', 'D', '8', '8', 'E', 'A', '2', 'C', 'E', 'B', 'D',
    '7', '5', 'B', 'A', '6', 'C', '0', '7', '9', 'D', '5', 'E', '5', '6', '4', '0',
    '9', '1', '3', 'B', '3', '0', 'E', 'C', 'B', '5', '5', 'A', '6', 'F', 'A', '1',
    '6', '9', '2', 'A', '0', '7', 'C', 'E', 'E', 'E', '6', '5', 'F', '9', 'D', 'E',
    '3', '3', '7', 'E', '0', 'A', '3', 'E', '9', 'D', '2', '0', '4', '8', '8', '3',
    'C', '8', 'E', '6', '9', 'E', '1', '7', '5', '0', 'F', 'B', '5', '1', '4', 'F',
    'F', '7', 'D', '2', 'F', '9', '1', 'E', 'C', '6', '2', 'B', '7', '1', '1', '9',
    'A', '4', '6', '5', '3', 'D', 'B', '3', '8', 'D', '5', '4', '3', '5', '4', 'D',
    '0', '2', 'B', '2', '1', 'D', 'B', '6', 'A', '4', '3', '7', 'B', '6', 'D', '2',
    'D', '9', '0', 'F', '8', 'F', 'D', '9', 'B', '8', 'E', '0', '6', '5', 'C', '0',
    '2', '2', 'E', 'C', '4', '6', 'C', '0', 'D', 'F', '6', '1', '5', 'F', '4', '4',
    'B', '6', 'F', '2', '9', '0', '5', 'E', '8', '2', 'A', '0', '4', '0', '0', '7',
    'D', '0', 'F', 'D', 'D', '4', '8', 'D', '7', 'E', '1', '3', '2', 'D', 'E', 'B',
    '9', '2', 'C', '9', '3', '0', '5', '6', '0', '4', 'C', '2', 'F', 'E', '2', '9',
    '7', 'C', 'B', 'A', 'C', '7', 'C', '1', '0', '4', 'A', '7', '2', '0', '3', '0',
    '3', 'E', 'B', 'F', '0', '4', '1', '0', 'A', 'A', '1', 'B', 'C', '8', '3', '3',
    '6', '5', 'F', '0', 'F', 'B', 'D', '9', '4', '6', '4', '7', '5', '2', '1', '7',
    '8', '3', '2', '8', '1', 'D', '7', '0', '8', 'B', 'A', 'E', '8', '1', '0', 'B',
    '8', 'B', '0', '5', '5', 'F', '8', 'E', '0', '9', '5', '2', '3', 'C', 'A', 'E',
    '4', '1', 'A', '8', 'D', 'A', '9', '9', '2', 'D', '2', '3', 'C', '9', 'C', 'C',
    '8', 'F', '0', '7', 'B', 'F', '2', '5', 'F', '3', '8', 'F', '4', 'C', '0', 'A',
    '3', '0', '2', 'D', '1', 'F', '9', '8', 'C', '4', 'B', '8', '3', '0', '2', 'C',
    'D', '7', '9', '9', '2', 'E', '2', 'C', '3', '8', '1', '9', '5', 'B', 'D', '3',
    '1', '0', '0', 'E', '1', '3', '8', 'A', 'F', '4', '1', '6', 'E', 'E', '6', 'E',
    '6', 'E', '1', '8', 'F', '2', '6', '7', '8', '8', 'A', '5', '1', '9', 'C', '8',
    '9', '4', 'C', 'B', '8', '9', 'E', '9', '4', 'B', 'A', '9', '1', '8', '2', '5',
    'F', '0', '3', 'A', '5', '3', 'B', 'A', '8', 'C', '6', 'E', '8', 'E', '5', '9',
    'F', 'D', 'A', '3', '3', '3', '4', '2', 'A', 'F', '1', '2', '9', 'B', 'E', '6',
    '9', 'C', '4', '1', '9', '1', '5', '9', '4', '3', '0', 'C', 'D', 'B', 'B', 'F',
    '3', 'D', 'E', 'A', 'E', '8', '9', 'B', 'D', 'D', '7', 'E', 'B', 'D', '9', 'B',
    'E', 'A', '5', '2', '4', 'D', 'E', '8', '6', '7', '1', '1', 'C', '5', 'F', 'F',
    '9', 'C', 'A', 'D', '2', 'A', 'A', '2', '0', '3', 'E', '1', 'E', '8', 'D', '7',
    'D', '0', '1', '0', 'D', '6', '1', '5', 'F', '2', '8', '6', 'F', 'C', '7', 'B',
    '0', '5', 'A', '3', 'F', '9', 'E', '0', 'E', '7', 'B', '3', '8', '0', '4', 'A',
    'D', 'C', 'D', 'E', 'A', 'B', 'A', '5', 'D', '2', 'B', '1', '0', '5', 'F', '2',
    'A', '5', 'C', 'C', '0', '7', 'B', '6', '5', '6', 'D', 'E', '3', '2', '0', '7',
    '3', 'C', 'D', '7', '7', 'F', '7', '8', 'B', 'C', '6', '2', '4', 'C', '2', '9',
    'F', '0', 'B', '6', '1', 'D', '1', 'F', 'F', '4', '0', '0', 'E', '4', '5', '2',
    '3', 'B', '1', '2', '9', '7', 'A', '1', '0', '7', '4', '3', 'D', 'F', '7', '0',
    '2', 'C', '8', 'C', '1', 'B', '1', 'F', 'E', 'C', '8', '6', '5', '4', 'F', '6',
    '2', '6', 'F', '2', 'A', '4', '4', '0', '5', '2', 'F', 'D', '7', '8', '8', '1',
    '9', '8', '3', '3', '3', 'C', '5', '7', 'F', 'A', 'A', '8', '7', '8', '5', '4',
    '8', '5', 'E', '9', '4', 'A', '1', '2', '6', '6', '3', 'A', '0', '2', '8', '9',
    '4', '9', '6', '6', '5', '7', '9', 'E', '1', 'D', '9', 'E', '6', '6', '9', '9',
    '3', 'B', '9', 'A', 'C', '7', '1', '8', '9', '3', '5', 'C', '4', '4', 'C', '5',
    '4', '9', 'E', '6', '8', '7', 'E', 'B', '5', '1', '4', 'B', '3', '7', '5', 'A',
    'B', '6', '8', 'A', '0', '9', 'A', '7', '4', '0', '0', 'A', '1', '5', '1', '0',
    '1', '6', '6', '7', 'D', 'C', '3', 'E', 'C', '1', 'D', 'B', '4', '8', 'D', 'C',
    '6', '7', 'E', '3', '4', '3', 'B', '3', 'E', '7', 'E', '0', '2', '3', '3', 'A',
    'B', 'B', 'A', '1', '7', 'E', '5', '0', 'A', '0', '2', '5', 'E', '1', 'A', '3',
    'E', '1', '3', 'D', 'C', '9', '3', '0', '7', '8', '7', '7', '4', 'C', 'E', '4',
    '6', 'F', '5', '6', '0', 'C', '3', 'F', 'A', '3', 'D', 'D', '3', 'E', '1', 'E',
    '3', 'B', '2', 'F', 'E', '5', '5', 'F', 'C', '3', '1', '2', '5', '4', '2', 'B',
    '2', '8', '9', '9', '3', '3', 'E', 'E', '0', 'E', '8', '6', 'C', 'D', '3', 'D',
    '4', 'B', '1', '6', 'D', '6', '2', '0', '7', '9', '2', '4', '0', '3', '6', '0',
    '7', 'E', '5', '9', '4', '0', 'A', '2', '7', '5', '8', '8', 'F', '8', 'B', '9',
    'F', 'B', '6', '9', 'D', 'D', '2', 'A', '2', '3', 'E', '9', '8', '6', 'C', '5',
    '4', '1', 'E', 'D', '9', '8', '8', '1', '6', '9', 'A', 'B', 'D', '2', '1', 'F',
    '1', 'D', '1', 'B', '0', 'A', 'A', '8', 'C', '2', '8', '5', 'A', '6', 'D', '3',
    '7', '9', '1', '1', '9', '6', 'F', '1', 'A', '7', '2', '6', 'E', '1', '5', '2',
    'B', '1', '5', 'C', '5', 'D', 'B', '2', '6', '9', 'B', '8', 'E', 'D', 'A', '5',
    '0', '5', '8', '9', 'D', '5', '7', 'D', '0', '1', 'A', '0', '4', '1', '6', 'E',
    '9', '1', '4', '7', '6', 'F', '3', '3', '9', 'F', '0', 'B', '7', '5', '2', '5',
    '2', '0', '5', 'B', 'E', 'A', '9', '9', '5', '1', '4', '0', 'A', '8', 'B', 'C',
    'C', 'B', 'E', 'D', '6', '8', 'E', '4', 'A', '7', 'F', '7', '2', 'D', 'D', '7',
    '4', '4', '1', '8', 'A', '4', '2', '5', 'F', 'E', 'E', '4', '3', 'F', '3', '5',
    '0', 'F', 'C', '5', 'A', '2', '4', '9', 'A', 'C', '5', 'E', '8', '1', 'F', 'B',
    'C', 'C', '5', 'E', '0', '2', '6', '0', '7', '2', 'C', '9', '4', '9', 'D', '8',
    '4', '5', 'B', '4', '8', 'C', '6', 'B', 'B', 'C', 'C', '3', 'A', 'C', '2', 'D',
    '7', '7', '5', '7', '0', '6', '0', '2', '4', 'F', '9', '1', '7', 'E', '4', '4',
    'C', '8', '5', 'D', '0', '2', '7', 'C', 'B', '3', '4', '4', '1', 'F', '3', 'F',
    '2', '5', '6', 'C', '8', '7', '7', '2', 'A', '6', '9', 'F', '9', '2', '4', '6',
    '5', '6', '2', '2', '8', '8', '2', '3', '1', '3', '9', 'C', '9', 'E', 'E', 'C',
    '2', 'B', '9', '8', '7', '4', '4', '2', '9', '0', '4', '2', '9', '7', '9', 'E',
    '6', 'E', 'F', 'A', '4', '9', 'A', 'D', '8', '3', '6', 'C', '6', '3', 'A', '5',
    '2', 'B', '3', '0', '0', '3', 'A', 'E', '2', 'F', '3', 'D', 'E', '3', '5', '6',
    '2', 'B', '6', 'C', '6', '6', '7', 'B', '2', '0', '7', '5', '3', '8', '6', '9',
    '3', '5', 'E', 'B', '0', 'C', '5', '7', '1', '1', '1', '1', '7', '2', '1', 'E',
    '6', '3', '0', 'F', 'A', 'A', '0', 'D', 'C', '5', '9', '8', 'B', '8', '2', '4',
    '8', 'A', 'E', '7', 'E', '3', '2', 'F', 'F', 'A', '5', 'B', '7', '8', '2', '8',
    '7', 'B', 'E', '2', '3', 'D', '1', 'A', '5', '2', '7', '9', '8', '2', '8', '8',
    '7', '9', '4', '4', '9', '3', '8', '1', '8', 'D', '1', '3', '4', 'B', 'F', '7',
    '1', '8', '7', '1', '5', '3', '6', 'C', 'C', '8', 'C', '4', 'C', '9', '8', '4',
    '9', '0', '6', 'E', '7', 'C', '0', '6', '7', '5', 'B', 'D', '6', '2', '1', '8',
    'C', 'D', '3', '4', '1', '5', '1', 'F', 'A', '6', 'E', '2', '9', '0', '7', 'D',
    'D', 'E', '8', 'C', '4', '9', '8', 'A', '7', '4', '2', 'D', '4', 'D', '7', '8',
    '2', 'D', 'D', '6', '8', 'B', '1', '2', '4', '0', '7', '3', 'E', '0', '0', '8',
    'A', 'F', '9', '5', 'E', '0', '4', 'A', 'C', 'C', '7', 'D', '7', '8', 'B', '7',
    'B', '2', 'A', 'D', 'F', 'C', 'A', 'A', '9', 'E', '0', 'E', '5', '2', '4', '1',
    'D', '3', '2', '4', 'D', '5', 'B', '6', '8', 'D', '7', '4', '2', '7', 'C', '6',
    '5', '1', '0', '6', 'F', 'B', '6', '5', '4', 'C', '7', '1', '4', '1', '9', '8',
    '1', 'E', '0', '5', '0', 'C', '7', 'A', 'C', 'A', '0', '8', 'A', '7', '6', 'F',
    '2', 'F', '8', 'A', '1', '1', 'D', '4', 'D', '1', '7', '8', '7', '5', '1', '4',
    '2', 'D', '4', '1', '8', 'F', '3', '8', '4', 'D', '4', '9', '1', '1', 'F', 'D',
    'F', 'F', '8', '2', 'D', '0', 'D', '9', '9', 'F', 'D', 'A', 'D', 'A', 'B', '2',
    'D', 'B', '8', '2', '6', '0', '5', '2', '6', 'C', 'D', 'C', '2', 'A', '3', '7',
    'B', 'D', '9', '4', 'C', '2', 'C', '1', '2', 'B', '0', 'A', '3', '6', '2', 'A',
    '7', '0', '9', '8', '5', 'A', '9', '4', '2', '0', 'E', '4', 'E', '8', '9', '4',
    '8', '6', 'F', '5', 'A', 'F', 'C', '7', '4', '8', '8', '3', 'F', '1', 'C', '5',
    'F', '8', '1', '2', 'E', 'A', '7', 'A', '4', '7', '8', '9', '1', 'B', '0', '9',
    'E', 'D', '4', 'F', '8', '5', 'C', 'F', '0', '8', 'F', '0', '5', '5', 'B', 'F',
    '8', 'B', 'F', 'A', '4', '0', '3', 'F', '9', 'F', '0', '4', '1', 'E', 'F', '2',
    'F', '1', '7', 'D', 'D', 'F', '9', '2', 'A', '7', 'A', '8', 'B', '4', 'F', '4',
    '9', 'E', 'D', 'F', '5', '9', 'C', '9', '9', '8', 'A', 'A', 'C', 'C', '8', 'F',
    'F', '0', 'A', '8', '8', 'F', '5', '9', '3', '4', 'A', 'B', 'F', 'F', '1', '4',
    '1', 'D', '6', '2', '3', 'D', '2', '9', '2', 'E', 'A', 'E', '8', '3', '2', '6',
    'A', '6', '5', 'E', '6', 'E', 'E', '7', '1', '1', '0', 'C', 'E', '6', '3', '6',
    '2', '7', 'D', '6', '4', '3', '0', '1', 'D', 'C', '0', '4', 'C', '4', '7', '1',
    'F', 'A', '6', 'D', 'A', '8', 'E', 'A', '2', 'E', '6', '6', 'A', '3', '7', 'A',
    'C', '7', '4', '7', '8', 'D', 'C', 'F', '6', 'C', 'C', '3', 'B', '4', '0', '9',
    '2', '8', '2', '9', '0', '3', 'B', '1', '0', 'C', 'E', '4', '2', '1', 'B', '8',
    'E', '3', '9', 'B', '6', 'F', '9', '6', '7', '0', 'D', '7', 'E', '1', '7', '5',
    '9', 'D', '1', '5', 'E', '3', 'F', 'D', '4', '3', 'C', 'D', 'E', 'D', '5', '5',
    '4', 'F', '7', 'D', 'C', '9', '7', '3', 'E', 'E', '0', '3', '3', '5', 'A', '9',
    'B', '8', '8', '9', '7', '3', '5', '0', 'A', 'C', 'C', '6', 'E', '6', 'A', 'F',
    '8', '7', '8', 'F', 'E', 'F', '3', 'E', '1', 'D', '4', '2', 'B', 'E', '1', '9',
    '9', '3', 'A', 'B', 'A', 'F', '0', '9', '1', 'E', '9', 'F', '6', 'E', '0', '3',
    '9', 'F', 'D', '1', '8', '5', 'A', 'E', '4', 'A', 'E', 'E', 'B', 'F', '3', 'F',
    'D', 'E', 'B', 'F', '3', '8', 'A', '5', '0', 'A', 'B', '3', '2', 'C', '7', '2',
    '0', 'B', '4', '3', '7', '9', '6', '8', '2', '8', '0', 'B', '2', '3', '7', 'F',
    'A', '6', 'C', 'B', '7', 'F', 'C', '5', 'B', 'A', '4', '6', 'C', '3', 'A', '1',
    '2', 'E', 'B', '1', '3', '7', 'B', '4', '6', 'A', '6', 'E', 'B', 'D', '7', 'B',
    '8', '4', '0', '2', 'D', '1', '5', 'E', '3', 'E', '8', 'E', '8', 'D', 'A', '8',
    'A', '3', '1', '9', 'F', '7', '6', '6', '2', '4', '8', '5', '0', 'B', '1', 'D',
    '6', '8', '9', '1', 'C', '1', '8', 'F', '4', 'C', '5', '9', '1', '2', '4', '2',
    '9', 'B', '1', 'C', 'C', '7', 'E', 'D', '3', '3', 'E', 'A', '2', 'E', '5', '1',
    '5', '6', '8', '8', '1', '4', '2', '8', 'F', 'F', '5', 'B', 'F', '9', 'C', 'E',
    'A', 'C', 'D', '8', '3', 'E', 'C', '3', '3', '0', '5', '7', 'F', '2', '4', '6',
    'F', '3', '7', '2', '8', 'B', '3', '0', 'F', '4', 'E', '1', 'C', 'C', 'F', '9',
    'F', 'A', '7', '4', '6', 'A', 'E', 'A', 'B', '7', 'D', 'B', 'B', '4', '2', 'E',
    'F', 'E', '7', '8', '1', 'E', 'F', '6', '1', 'B', 'A', '3', 'C', '8', '6', '8',
    '2', 'F', 'A', '7', '4', 'F', '6', '1', '5', '2', 'F', '7', 'D', '0', 'B', '3',
    '4', '8', '9', 'D', '0', '9', '1', '1', '2', 'D', 'D', '4', '4', 'E', 'D', '3',
    'B', 'C', '8', 'F', '9', '3', '0', '4', 'F', 'C', 'A', '3', '2', 'A', '7', '7',
    'C', '2', '6', '8', '9', '7', 'C', '3', '6', '6', '9', 'C', '0', '8', 'C', 'F',
    '4', '4', '6', '2', 'F', '1', '5', '3', '9', '6', '6', 'E', '3', '3', 'A', 'A',
    'B', 'D', '9', 'C', 'D', 'E', '7', '2', '9', '8', '2', 'C', '7', 'F', 'D', 'E',
    'D', 'C', '3', 'B', '6', '5', 'F', '1', 'D', '7', '0', '1', '2', '4', '6', 'A',
    '5', '5', '0', '0', '6', '7', '6', '2', '2', '9', '3', '5', '4', 'D', '9', '8',
    'B', '0', '7', 'A', '0', 'F', '6', '9', '0', '0', 'D', '0', 'D', '7', 'D', 'C',
    '7', '9', 'F', '2', '7', 'C', '7', 'A', '2', 'B', '6', '6', '2', 'E', '5', 'D',
    'A', 'A', '7', 'D', '8', 'E', 'A', '1', '9', '9', 'D', '2', 'A', '2', 'E', '3',
    'C', 'A', '0', 'C', '5', '4', '1', '7', '0', 'D', '4', '9', '9', 'B', 'A', 'D',
    '8', 'B', '4', 'A', '5', 'E', '6', 'A', '1', '9', 'B', '5', '2', 'F', '3', 'F',
    '7', '6', '4', 'D', 'E', 'E', '8', '6', '0', '7', '0', '6', '5', '5', '7', 'B',
    '0', '6', 'C', '6', '0', 'F', 'B', '5', '5', '7', '8', '3', '0', '4', 'D', '3',
    'C', '4', '6', '6', '5', '2', '5', 'A', '4', '1', '1', '1', '2', '3', '2', '8',
    'E', '5', 'F', '5', '4', 'B', '0', '6', '6', '4', '0', '8', '8', '2', '2', 'E',
    'C', '9', '8', 'D', '9', 'F', 'C', '4', '4', '4', 'E', 'E', '7', 'B', 'B', 'B',
    '2', '3', '6', '2', '0', '5', '8', '9', '0', '2', '9', '0', '0', 'A', '8', '9',
    'A', 'B', '5', '7', 'B', '9', '9', '0', '4', 'F', 'A', '7', '2', '9', '4', '7',
    '7', 'A', '9', 'A', '3', '8', '5', '2', 'C', 'D', '9', '7', '9', '5', '9', 'D',
    'B', '3', '7', '9', '8', '4', '4', '3', '6', 'D', '5', 'F', '6', '5', 'A', 'F',
    '2', 'F', '1', '5', 'A', '7', '3', '1', '9', '9', '4', 'C', 'E', '5', '4', 'F',
    'B', '0', '8', 'A', '8', 'D', 'D', '9', '2', '9', '7', '4', 'A', '9', 'B', '8',
    'D', '3', '4', '8', 'A', '1', 'C', '7', '8', '2', '3', '4', 'C', '9', 'E', 'F',
    'F', '6', '0', '0', '5', 'F', '3', '9', '4', '3', 'F', 'C', '6', '1', '9', 'E',
    '7', 'E', '6', 'B', '4', 'C', 'F', '3', 'D', '0', '4', '9', 'F', 'F', '5', 'A',
    '4', 'A', '9', '5', '8', '0', '8', '6', 'B', '7', 'F', 'C', 'D', 'E', '9', '1',
    'A', 'F', '9', 'D', '6', '8', '4', 'F', '3', '6', 'B', '8', '0', '2', 'D', 'F',
    '8', '2', 'B', 'A', '8', 'A', '0', '6', 'F', 'F', 'F', 'B', 'A', 'E', '2', '1',
    '6', 'C', '4', '4', '7', '5', 'A', 'E', 'C', '6', 'B', '5', '2', '8', '6', '5',
    '5', 'C', 'A', '0', '4', '3', '6', '7', 'F', 'F', '6', '7', '1', '2', '2', '0',
    'B', '0', 'D', '0', 'E', '2', '3', 'A', '6', '6', 'A', 'D', 'A', 'B', 'A', 'F',
    '6', '1', 'C', '9', 'B', '9', '6', '4', '5', 'D', '8', '6', '5', 'D', 'D', '7',
    '6', '2', 'E', '1', '7', '6', 'B', 'F', 'C', 'B', 'B', 'E', 'E', '2', 'E', '6',
    'D', 'C', '9', 'D', '6', 'A', 'A', '7', '4', '5', '6', 'D', 'F', '2', '9', 'B',
    '1', '9', '7', '8', '8', '9', '0', 'B', '8', 'B', '5', 'E', 'E', '0', 'E', '7',
    '4', '7', '1', 'F', '6', '2', 'A', 'D', '7', '0', '6', '7', '8', '4', 'A', '2',
    'D', '6', '1', '2', '8', '7', 'A', 'F', 'E', '4', '1', 'B', 'D', '4', '1', 'D',
    'B', 'A', '3', '7', '3', '0', '4', '9', '7', '6', '4', 'F', '6', '7', '5', '3',
    '5', '6', '1', 'D', 'A', '9', '9', 'F', 'D', '2', '0', '5', '7', 'F', 'F', 'B',
    '3', '6', '1', '9', 'B', 'C', '6', '9', 'A', '4', 'B', '4', '9', '3', '7', 'D',
    'A', '6', '4', '6', '6', '9', 'C', 'D', '8', 'E', '2', 'B', '8', '5', 'B', 'F',
    'B', '8', '7', 'E', '8', 'E', 'D', 'F', '7', 'C', '9', '5', 'B', '1', '9', '2',
    '9', 'E', 'C', '2', '9', '8', '4', 'F', '8', '1', '7', '6', 'B', '7', 'F', '9',
    'D', 'B', '1', '5', '4', 'A', '3', '2', 'B', '5', '4', '8', '4', 'E', '7', '9',
    '6', 'B', 'F', '2', '3', '8', 'C', '8', '8', 'C', '8', 'C', 'E', 'B', '3', '1',
    '5', 'E', '1', 'B', '0', 'F', '6', '5', 'C', 'F', 'F', 'B', '5', 'A', '0', '4',
    '0', '9', '9', '5', '8', '2', '2', 'A', 'C', '6', '5', 'A', '3', '6', '5', '4',
    'F', '8', '9', 'D', '3', '5', '5', '5', '1', 'B', '2', '9', '7', '5', 'A', '3',
    '9', '6', '1', '3', '4', '3', '9', '3', 'F', '2', '1', '5', '6', '3', '7', 'B',
    'C', 'C', 'A', '9', 'B', '9', 'C', '0', '3', '5', 'C', 'D', '5', 'B', 'F', '1',
    'C', '1', '9', '6', 'F', '2', '0', 'B', 'C', '8', '1', '0', '2', 'B', '6', '3',
    '5', '9', '7', '6', '4', '2', 'D', '7', '7', '0', '3', 'D', '6', '3', 'B', '5',
    'F', '4', '7', '0', '6', 'F', '5', 'B', '3', 'B', '7', 'D', 'E', '4', '8', '0',
    '6', '9', 'E', 'A', '9', 'F', '9', '5', '0', '0', 'E', '4', '5', '9', '0', 'F',
    '4', '2', '7', '3', '5', '0', '8', '3', 'B', '4', 'A', '9', 'D', '8', '0', 'B',
    '5', '8', '9', '2', 'B', '1', 'A', 'E', '6', '2', '6', '4', '5', 'A', '8', '7',
    'F', 'B', 'F', 'A', '3', '0', 'B', '3', '2', 'D', 'F', '5', '8', 'F', 'A', '4',
    'E', 'A', 'E', '2', 'B', '6', '2', '5', '6', '4', 'A', '8', 'E', 'B', '5', 'D',
    '1', 'F', 'A', '2', 'D', 'E', 'D', '6', '8', 'B', '7', '9', '7', 'D', 'B', '6',
    '6', '7', '2', '1', 'D', '6', 'E', '3', 'C', '6', 'A', '2', '3', 'B', '1', 'A',
    '0', '5', '0', '2', '1', 'E', 'F', '0', '6', 'F', '6', 'C', 'F', '9', '3', 'D',
    '6', '2', 'C', '5', 'C', 'C', '4', '1', 'D', '6', '6', 'D', '1', 'D', '2', '5',
    'F', '8', 'D', 'E', '6', '0', '7', '2', 'E', '6', '9', '4', 'D', 'E', '1', '8',
    'D', 'A', '8', 'F', '5', '4', '9', '6', '5', '2', 'C', 'B', 'F', 'A', '1', '2',
    '6', '7', '2', 'E', '8', '4', '2', 'A', '8', 'A', '1', '4', 'E', '4', '8', '2',
    '6', 'C', 'C', '4', '6', 'E', 'D', '7', 'D', '3', 'F', 'E', '7', '0', 'D', '6',
    '6', '7', '0', 'C', '6', '7', 'A', '3', 'B', 'D', 'A', '3', 'E', '7', 'D', '8',
    '9', 'E', '0', 'C', '7', 'B', 'A', '2', '9', '5', 'D', 'A', '9', '6', '9', '8',
    '0', '9', '6', '7', '2', 'F', 'B', 'F', 'D', 'F', '8', '5', '0', '2', 'E', '1',
    '3', '6', '0', '4', '4', '3', '3', '1', '7', '6', 'E', 'B', '9', '9', '4', 'E',
    'F', 'B', '8', '2', 'F', '6', '9', '3', '1', 'D', '5', 'D', 'B', 'C', '2', 'B',
    'B', 'D', 'E', '2', 'B', '8', 'B', 'F', '4', '1', '4', 'F', 'A', '3', '3', '7',
    'F', '8', '2', 'F', '1', '7', 'D', '2', '5', 'F', '1', '4', 'F', '9', '6', 'D',
    '1', '3', 'E', '1', 'C', 'F', '2', '5', '8', '1', '1', '0', 'A', '4', 'F', '4',
    '7', '5', 'F', '8', 'A', '7', 'B', '5', '3', 'C', 'B', '5', '0', 'E', '6', 'C',
    '7', 'D', '1', '0', '6', '4', 'B', '2', 'A', '2', 'C', 'F', 'E', 'A', 'B', '6',
    '7', 'B', '5', '5', '0', '6', 'D', 'C', '8', '4', '8', '0', '6', '1', 'A', '8',
    'F', '2', 'D', '1', '2', '0', '0', '6', '5', '3', '6', 'B', '5', '2', '9', '0',
    '7', '3', '1', 'A', '7', 'B', '5', '1', '9', '4', '5', '4', 'B', '0', '9', 'A',
    'C', '8', 'A', '3', 'D', 'B', 'C', '7', 'C', '7', '3', '6', '6', 'F', '2', '8',
    '5', '3', 'B', 'A', '7', 'E', '2', 'F', 'E', '4', '9', '1', '6', '7', 'C', '5',
    '8', '7', '7', '1', 'C', '5', '9', '2', '9', '4', 'B', '3', '3', 'E', '4', '1',
    'E', '2', 'A', '2', '9', 'C', 'B', '4', 'A', '4', '9', '3', 'F', '8', '6', '8',
    'C', '9', '7', '0', '7', '0', 'F', '4', 'C', 'D', 'D', '2', '7', '8', 'E', 'C',
    '3', 'F', '0', '8', 'C', '0', 'B', 'E', '7', 'A', '8', '2', '1', '7', '5', '4',
    '4', 'C', '7', 'D', '0', 'A', '5', 'A', 'D', '1', '9', '1', '3', '2', '3', '2',
    '5', '6', '8', '1', '3', 'F', 'B', 'E', '1', 'D', '8', 'D', 'A', '9', '0', '2',
    '7', '9', '1', '5', '2', '7', 'B', '9', 'A', '3', '6', '8', '3', 'E', '8', 'E',
    '4', 'A', '6', 'B', '6', '1', 'A', '9', 'C', '1', '8', '5', '8', '8', 'E', '0',
    '0', '3', 'A', '5', '4', '9', 'A', '9', '3', 'A', 'C', 'B', '4', 'B', '7', 'E',
    '5', '2', '5', '0', '1', '1', 'C', 'D', 'A', '2', '2', '3', '2', '1', 'B', '8',
    '2', '8', 'D', '9', 'E', 'F', '7', '4', 'F', 'D', '6', 'A', '9', 'B', 'C', '6',
    '0', '8', '6', 'A', '5', '3', '4', '2', '0', '3', '7', 'F', 'E', '9', '2', 'A',
    '1', '6', '5', '1', '4', '5', '2', 'A', '6', '1', '7', 'F', '4', '1', '5', '6',
    '1', '0', '3', '0', '8', '5', '5', '4', '8', '4', '7', 'D', '7', '2', 'D', '1',
    '2', '2', '5', 'B', '8', '8', 'F', '7', 'E', '8', '5', '9', '4', '3', '1', 'A',
    'B', 'F', 'A', '1', '4', 'A', '9', 'B', 'C', '6', '7', '0', '8', '7', '4', 'E',
    '8', '7', '0', '1', '4', 'A', '7', '1', 'D', '2', '3', '1', '2', '4', 'E', 'C',
    '0', '5', 'B', 'E', '4', 'E', '1', 'A', 'A', '0', 'F', 'C', 'D', 'E', '3', '2',
    'D', 'E', 'C', '1', '2', '7', '0', '6', 'C', '7', '1', '9', '0', '7', 'E', '7',
    '2', 'B', '5', '7', '8', '1', 'A', '9', '7', '9', '0', '6', '7', 'C', '5', 'B',
    'E', '4', '0', '1', '5', '6', 'F', '4', '4', '5', '8', 'C', '5', '9', '5', '4',
    'D', '9', '7', '9', '6', '7', '2', 'A', '5', '3', '1', '0', 'E', 'D', '5', '4',
    '5', '9', 'D', '3', '5', 'C', 'E', '2', 'E', '8', '1', '4', '9', 'C', 'A', 'E',
    'C', '1', '7', 'B', '6', '2', '6', '2', '1', '3', '8', '4', 'E', 'D', '8', 'C',
    '8', '6', 'A', '5', '3', 'A', 'F', '7', '9', 'E', 'E', 'B', '4', 'B', '8', '8',
    '9', '4', '8', 'C', '0', '9', '6', '9', '3', '6', '4', '1', '8', '6', '9', '9',
    '7', '8', '7', 'D', '8', 'E', 'C', '1', 'D', 'B', '8', 'B', 'E', '9', 'E', 'E',
    '1', '0', 'D', '6', 'E', '5', '6', '2', '6', '2', '5', 'C', '6', '4', 'A', 'D',
    '1', 'E', '6', '7', '6', 'F', '3', '6', '2', '3', '5', '9', 'B', '3', 'E', 'A',
    '9', 'E', 'E', '6', '4', 'A', 'E', 'D', '2', 'B', '5', 'B', 'C', '3', '3', 'F',
    '7', 'E', '2', 'E', '0', '5', '9', '7', 'E', 'C', '2', 'A', '8', 'D', 'B', '8',
    '6', 'E', 'E', 'D', '0', '2', 'B', '2', '2', 'A', 'C', '6', '6', '3', 'C', '2',
    'A', '2', 'A', '1', '1', '4', '8', 'B', '0', '5', 'E', '9', '8', 'C', '4', '3',
    '2', '2', 'A', '7', 'B', 'E', '7', '5', '6', 'C', '7', '7', '9', '1', '0', '9',
    'E', 'B', '4', '6', '7', 'F', 'B', 'C', 'B', '8', '0', '6', '2', '2', '2', 'E',
    'A', '8', '5', '6', '0', 'C', 'C', 'C', '7', '9', '9', 'C', '6', '7', '8', '9',
    'D', '6', '4', '2', '2', '0', '1', '5', '0', 'B', 'D', 'E', '8', '9', '4', 'C',
    '9', 'B', '2', 'D', '2', '4', '4', '4', '7', 'C', '5', 'B', 'C', 'F', '3', '5',
    '9', 'B', 'B', '0', 'E', '2', '1', '5', '4', '6', '7', '7', 'C', '4', '8', '9',
    '9', '5', '4', '6', 'B', 'E', '9', '8', '1', '7', '2', '4', '7', 'B', 'E', 'E',
    '9', '7', '2', 'F', '6', '1', '3', '3', 'F', '8', '9', 'F', '0', '4', '6', '9',
    '1', 'B', 'B', '4', 'B', 'F', '1', 'C', 'C', '1', '3', '1', '5', 'E', '9', 'D',
    'C', '7', 'D', 'D', '6', 'A', '2', 'F', 'D', 'F', 'D', '4', 'F', '8', '4', '1',
    'C', 'A', '4', 'E', 'B', '6', '1', '6', 'F', '8', '8', 'E', '3', 'D', '0', '0',
    '9', '6', '1', '0', '5', '7', 'E', '0', '8', '9', '1', 'F', 'C', '8', 'C', '4',
    '2', '8', '0', '8', 'D', '7', '8', '4', '8', 'C', '3', '8', '2', '0', '1', '3',
    '2', '1', '6', '0', '2', '1', 'A', '7', 'B', '1', '1', '1', 'C', '6', '0', '0',
    'F', '3', '0', '2', '3', 'D', '4', 'C', '5', 'A', 'E', '3', '7', '3', 'B', '8',
    'E', 'C', 'B', '0', 'E', '0', '2', 'F', '0', '9', '8', '0', '1', '7', 'A', 'C',
    'C', '5', '7', '1', 'D', 'B', '5', '3', 'D', '5', 'D', '5', 'B', 'F', '4', 'E',
    '9', 'B', '0', 'C', 'D', '1', 'A', '5', 'E', '3', '6', '1', '9', 'C', '8', 'F',
    'E', '7', '3', '9', 'A', '8', 'E', '9', '1', '3', '6', '6', 'E', '2', 'E', 'B',
    '4', '2', '1', 'F', 'E', '8', '4', '0', '3', 'E', 'B', '0', '5', '7', 'F', '7',
    '0', 'A', '3', 'C', '3', 'A', '6', '6', '2', '5', '0', '8', '5', '7', 'A', 'E',
    'F', 'F', '7', '9', 'C', '9', 'D', 'F', 'D', 'A', '9', 'E', 'A', '9', '8', '5',
    '9', 'A', '5', '1', '0', '7', 'D', '7', 'E', '8', 'B', 'D', '1', '3', '0', '7',
    'B', 'E', 'B', '9', '2', 'A', '0', '1', '3', 'C', '6', 'B', '9', 'B', '9', '0',
    '6', 'A', '3', '0', '6', '7', '1', '1', 'E', '5', '1', '3', '0', 'F', '4', '9',
    'F', 'E', '6', 'E', 'E', '5', '2', '6', '6', '5', '5', 'A', 'B', '7', '1', '6',
    '0', '7', 'E', '4', '6', 'E', 'D', '2', '7', 'C', 'E', '5', 'D', '1', '3', '3',
    '8', 'A', 'D', 'B', '3', 'D', '9', 'B', '8', 'B', '0', 'E', '4', '0', 'C', '5',
    'D', '7', '7', 'A', 'D', '7', '7', 'E', '2', 'B', '1', '3', '5', '2', 'E', '3',
    '8', '3', 'C', 'A', '0', 'D', '0', '0', '0', 'E', 'A', '7', '6', '2', 'A', 'B',
    '2', '7', 'C', '4', '5', '3', '2', '7', 'C', '7', 'C', '1', '6', '7', '0', '1',
    '9', 'B', '0', 'F', '3', 'C', '6', '0', 'B', '7', 'E', '0', '6', '0', 'B', '6',
    '0', '7', '1', '6', 'A', 'B', '3', 'D', 'D', '0', '6', '7', '1', '1', 'F', '1',
    '8', '6', 'F', '1', '0', 'A', 'C', 'D', 'B', 'F', '2', '0', 'A', '3', '7', 'D',
    '4', 'D', '6', '3', 'A', 'E', '5', 'E', 'C', '9', 'F', 'A', '8', '0', '2', '0',
    '4', '7', '9', '3', '8', '7', 'B', 'E', '0', '9', 'F', 'A', '1', '5', 'F', '7',
    'D', '8', 'F', '5', '5', '9', '1', '5', '3', '1', '1', '2', 'C', 'E', '4', 'C',
    '1', '2', 'E', 'B', '6', 'C', 'D', '4', '9', 'E', '3', '4', '3', '5', '3', 'B',
    'D', 'E', 'C', '7', 'D', '9', '3', '9', '1', '4', '0', '2', '7', '8', '5', '6',
    '9', 'F', '2', '3', 'F', '6', '0', '8', 'E', 'C', '0', '8', '9', 'E', '5', '3',
    '3', '5', 'C', 'A', 'F', '9', '3', '6', '3', '8', 'F', '6', '5', 'B', '3', '1',
    '1', 'E', 'D', '8', '7', 'A', 'A', '4', '9', '8', '8', '7', '9', 'F', '5', '6',
    '5', '0', '5', 'C', '0', '2', '7', '9', '7', '2', '9', '6', 'C', '7', 'D', 'A',
    '5', '0', '6', 'C', '7', '0', '8', '6', '8', '4', '6', 'D', '0', '5', '3', '5',
    '7', '6', '1', 'F', '2', '3', 'F', 'B', '2', '7', '0', 'C', '5', '6', '8', 'D',
    '8', 'F', 'D', 'F', '6', '8', '0', '9', '3', '1', '0', '3', '7', '7', '9', 'A',
    '2', '0', 'A', '6', 'C', 'E', '4', '4', '2', '9', '8', 'E', 'B', '9', '6', 'B',
    '4', 'E', '5', '3', 'C', 'D', 'F', 'C', '3', 'A', '0', '2', '7', '6', '8', '9',
    '6', '5', '3', 'D', 'B', 'D', 'E', 'F', '1', '9', 'C', '8', '0', 'A', '7', 'B',
    '2', 'C', '3', '7', '3', 'F', 'D', '3', 'B', 'F', 'C', '2', '3', 'E', 'C', '0',
    'B', 'A', '3', 'A', 'B', '9', '0', '0', 'D', '3', '8', '1', '3', 'F', '0', '1',
    '2', '9', 'E', 'A', '0', 'A', '2', '0', '2', '7', 'D', '6', '8', '3', '8', '4',
    '5', '4', '8', 'E', 'F', 'B', '3', '5', 'C', '0', '5', '1', '2', '5', '3', 'D',
    'E', '7', '7', '2', 'A', 'E', 'C', '1', 'C', '1', '5', '5', '5', 'B', 'C', '3',
    '7', '7', 'E', '1', 'C', 'C', '1', 'E', '8', 'B', '9', '6', 'C', 'A', '5', '7',
    '2', 'D', '1', '7', '0', '0', '4', '0', '2', 'A', '5', '9', '0', '1', '2', 'E',
    'C', '0', 'D', '2', 'E', '2', 'D', '3', '1', '0', 'A', 'A', '7', '0', 'B', 'F',
    '8', 'B', 'B', '4', 'D', 'E', '9', 'A', 'E', '7', 'A', '1', '0', 'A', 'F', 'B',
    'E', '4', 'E', '6', '0', 'C', '6', '4', '0', 'A', '6', '6', 'D', '4', '4', '5',
    'B', '6', 'A', '9', 'F', '7', 'E', 'C', 'B', 'B', '7', 'B', 'E', 'E', '4', 'C',
    '0', 'D', '6', '3', 'C', '1', '7', '9', '5', '2', '2', 'F', 'E', 'E', '4', 'D',
    'A', '0', 'B', '1', '0', 'B', '9', '6', '1', '2', '0', '4', '7', '9', 'F', 'F',
    '5', 'F', '2', '2', '1', 'B', '7', '6', '7', '2', '4', '6', '9', '7', '3', 'A',
    '1', '6', '7', '1', '4', '0', '7', '5', '7', 'F', '1', 'D', 'D', '0', 'E', '6',
    '0', '1', 'F', '3', 'D', '7', '2', '8', '3', '8', 'B', '8', 'A', '0', '5', 'F',
    '9', '7', '8', 'F', '9', '5', 'B', '0', '1', '3', '0', 'E', '6', 'F', '6', '7',
    'E', '6', '0', '6', 'B', 'D', 'F', 'C', 'B', '0', '8', '5', '4', '3', '4', '4',
    'B', 'C', '8', '8', '6', '4', '1', 'E', '6', '8', 'F', 'D', 'B', 'F', 'F', '9',
    '0', '0', '2', 'A', 'B', '6', '2', '9', '7', 'F', 'C', 'F', 'F', 'C', 'C', '5',
    '6', '7', 'A', '3', '7', '7', '9', 'A', '1', '6', 'B', '6', '9', '3', '4', '5',
    '3', 'C', '2', 'D', '6', '2', '0', '8', 'A', 'A', '9', 'D', '2', '4', '4', 'A',
    '0', '1', 'C', '6', '9', '6', 'C', '7', '9', 'C', 'F', '5', '1', '2', '0', '1',
    '4', '4', 'D', '8', '4', '7', '3', 'B', '6', '4', 'D', 'F', '5', '6', '7', '4',
    'A', '3', '3', '9', '8', '1', '4', 'E', 'C', 'D', 'A', '5', '4', 'D', '9', '1',
    'A', 'F', 'E', 'B', 'D', '8', '6', 'A', '5', 'F', 'A', 'B', 'A', 'F', '3', 'D',
    '0', '0', '3', '9', '9', 'B', '9', '1', 'A', '8', '9', '6', '5', 'F', 'A', 'D',
    '8', '9', '4', 'A', '2', '1', 'A', '6', 'F', 'B', 'F', '7', 'D', '6', 'E', '7',
    '5', '8', '0', '3', '1', '2', 'B', 'F', '5', '7', '9', '1', '6', 'C', '4', 'F',
    '2', '5', '7', 'C', '7', '2', '8', '4', 'F', 'F', 'A', 'B', 'A', '7', '3', 'E',
    '5', '1', '5', 'B', '7', '0', 'A', '2', '9', 'D', '2', '9', '1', 'C', '4', 'C',
    '7', '8', 'D', '1', '0', '4', '8', '0', 'E', '7', '3', '1', '7', '1', '8', '7',
    '3', 'E', '7', '6', '2', '9', '6', '6', 'B', '8', 'A', 'B', 'F', '6', '9', '6',
    'C', 'A', '7', '6', '9', '5', '3', 'E', 'A', '4', '2', 'F', 'C', '2', '3', '0',
    '5', 'E', 'D', '6', '4', '7', 'D', '1', '8', 'A', 'A', '6', '4', '6', '6', '0',
    '3', '6', '0', '0', '4', 'D', 'C', 'B', '9', 'F', 'E', '5', '6', 'B', 'C', '2',
    '4', '1', '4', '3', '4', '8', '0', '5', 'C', 'D', '4', '6', '1', '1', 'D', '0',
    '9', '9', '1', 'F', '7', '8', '7', '7', '1', '2', '1', '6', 'C', '1', 'E', 'B',
    'A', '8', 'C', '5', '9', '7', 'B', 'C', '7', '6', 'B', 'E', '1', '6', '0', 'E',
    'A', 'C', 'D', 'C', '2', 'D', '7', '2', '8', 'D', '5', 'A', 'D', 'B', '6', '6',
    'B', '7', '1', '5', '5', '8', '7', 'E', '1', '6', 'D', '4', '0', '5', 'C', '3',
    '9', '6', 'A', '6', 'E', 'F', 'C', 'A', '3', '5', '0', 'F', '5', '3', '9', '9',
    'E', '3', '5', 'E', 'E', '3', 'B', 'F', 'E', 'C', 'B', '2', 'C', 'B', '7', '7',
    'D', '1', '3', 'B', 'A', '8', '4', 'F', '9', '0', 'C', '0', 'D', 'D', 'A', '8',
    '5', '9', '9', '2', '4', '6', '1', '8', '4', 'D', '8', 'E', 'B', '6', 'E', '6',
    '9', '5', 'C', 'F', '0', '6', 'A', 'B', '4', 'F', '0', '2', '3', 'F', '2', 'E',
    '3', '4', 'B', 'B', '1', 'E', '3', '5', '2', '6', '8', 'F', 'F', '5', 'A', '5',
    '1', '6', '3', 'D', 'F', '3', 'F', '2', 'B', 'F', '4', 'B', '2', 'B', 'C', '9',
    'C', '2', 'C', '2', '2', '4', '2', 'D', '2', '3', '4', 'F', 'E', 'C', 'C', 'C',
    '9', '9', '9', '9', 'A', '7', '3', '7', 'D', '6', 'C', '6', '6', 'B', '1', '6',
    '2', '6', '8', '1', '6', '5', '4', '3', 'C', 'E', '5', '7', '5', 'B', 'B', 'A',
    '1', '3', '5', '1', '7', '5', '5', '3', '4', '1', '9', '3', '4', 'A', '0', '1',
    '6', 'A', 'F', 'A', '2', '1', '3', '2', 'F', '1', '2', 'F', 'F', 'E', '3', '5',
    '0', 'A', '4', 'E', '0', '4', 'D', '8', '1', '6', 'F', 'F', 'E', 'B', '1', '0',
    '5', '7', '1', 'C', 'E', '6', 'B', '4', 'A', '8', '5', '2', '0', 'D', 'B', '3',
    '6', 'D', '7', 'F', '6', '9', 'D', 'A', '1', '0', '1', 'C', '0', '3', '5', '1',
    'C', '5', 'F', '4', 'D', 'A', '7', 'A', '7', '8', 'F', '6', '0', 'D', '4', '7',
    '7', '1', 'C', '7', '9', 'B', 'A', '6', 'D', 'F', 'B', '0', 'B', 'B', '7', 'E',
    '4', '7', 'B', 'D', '4', 'C', '0', 'D', '4', '9', '3', 'E', 'E', '0', 'B', '1',
    '5', '3', 'D', 'E', '7', '0', '1', '8', '1', 'D', '7', '4', 'C', '8', 'D', '3',
    'A', '6', 'B', '7', '2', '6', '7', '3', 'F', '4', 'A', '5', '6', 'D', 'A', '6',
    'B', 'C', 'F', '0', '2', '9', '0', '8', 'E', '2', 'B', 'B', 'D', 'A', 'A', '2',
    '4', 'C', '2', '7', 'A', '8', '0', '3', '0', '9', '9', '6', '4', '6', 'E', '0',
    '5', '8', '2', 'F', '2', '9', '9', '0', '1', '0', '7', '9', '0', '4', '7', 'B',
    'A', 'B', '9', '0', '0', 'D', 'D', '9', '8', 'F', '8', '5', '1', 'A', 'B', '3',
    'C', 'B', '6', '5', '0', '9', '3', '9', 'E', '6', '4', '5', '6', 'B', 'D', '1',
    '0', 'B', 'E', '3', '5', '4', 'C', 'C', 'A', '7', '3', 'F', 'C', '7', 'E', 'E',
    '1', '7', 'C', '2', 'C', '9', '9', 'E', '2', '0', '5', 'B', '3', '3', '9', '5',
    '0', '5', '8', '7', '2', 'D', '7', '4', 'E', '3', '2', '7', 'A', '2', '1', 'D',
    '8', '3', '3', '9', 'B', 'B', '4', '9', '5', 'B', '3', '3', '1', 'A', '4', '7',
    'A', '0', '1', 'D', '1', 'F', '0', '5', '7', '4', '8', '6', '6', '8', '6', 'D',
    '9', '7', 'E', 'F', '6', '6', 'B', 'F', '1', '7', '2', '3', '3', 'C', '4', 'F',
    '9', '5', '6', '3', '3', '1', '8', 'D', 'C', 'A', '2', '5', '0', '5', 'B', '1',
    'A', 'C', 'F', 'B', '1', 'E', '9', 'C', '5', '8', 'C', 'B', '8', '6', '2', '1',
    '1', '4', '1', '8', '7', '8', '5', '1', '9', 'B', 'B', '0', '1', '6', '9', 'B',
    '9', 'B', 'C', '5', 'D', '9', '8', '5', 'C', 'A', '1', '8', 'A', 'F', '8', '6',
    'C', 'F', 'F', '4', '9', 'D', '2', '3', '1', 'C', '3', 'A', '4', '5', '9', '6',
    '1', '8', 'D', 'D', 'B', '9', 'D', 'D', '9', '9', '1', '0', 'C', 'F', '4', '8',
    'A', 'B', 'D', '9', '9', '1', '0', '1', 'D', '4', 'D', '9', 'C', '0', '3', 'F',
    'A', '4', 'F', 'A', 'F', '5', 'B', '7', '0', 'A', 'E', 'B', '1', 'F', 'E', '3',
    'F', 'E', '9', '9', 'C', 'D', '9', '3', '6', 'E', '5', 'B', '0', '2', '2', '6',
    'C', '1', 'C', '7', 'D', 'D', '6', '8', '7', '2', '6', '2', 'C', 'D', '7', '0',
    '7', 'E', '8', 'D', 'F', 'D', '1', '3', 'B', 'A', '2', '7', '8', 'A', 'C', 'D',
    '0', 'E', '4', 'B', 'A', '0', '4', '4', '8', '9', '6', '0', 'B', 'F', '8', '0',
    '0', '5', 'F', '4', 'A', '0', '6', '5', 'B', 'D', '4', '3', 'C', 'A', '5', 'D',
    'A', '1', '6', 'C', '8', 'F', '2', 'B', 'D', '5', '8', '7', '2', '9', '8', 'E',
    'F', 'D', 'A', 'C', 'E', '7', '0', '7', '2', '1', '2', '8', '7', '0', '9', '4',
    '2', 'F', 'C', '1', '2', '9', '6', 'D', '2', '9', 'A', 'F', 'B', 'B', '3', '6',
    'E', '9', 'B', 'B', 'F', 'F', '8', '2', '9', 'D', '1', 'C', '2', '5', '0', 'E',
    'C', 'D', 'E', 'F', '3', '2', 'A', '1', '5', '3', '1', 'A', 'E', '8', '2', 'D',
    '4', 'D', '2', '3', '2', 'A', '9', '7', '6', '3', 'E', '4', '7', '0', 'E', 'C',
    '7', '8', '9', 'F', '1', 'C', '2', '6', 'E', '9', 'B', 'C', '2', 'C', '8', 'A',
    '9', '9', 'A', 'F', '6', '9', '1', 'E', '5', 'A', 'E', '3', '8', '6', 'C', 'C',
    '6', '2', '1', '8', '1', '6', 'F', '1', '0', '6', 'B', '3', '6', 'B', '0', '4',
    'A', '3', 'F', '9', '8', '2', 'D', '3', '3', 'B', 'C', '8', 'B', 'D', '7', '8',
    '1', 'C', '1', '9', 'B', '4', '5', '2', '6', 'D', '0', '2', '0', 'E', '5', 'C',
    '1', 'E', '7', '2', '5', '7', '2', 'F', 'D', '0', '0', '9', 'A', 'F', '4', '1',
    '8', 'B', '7', '8', '8', '6', '9', 'F', '5', '0', 'D', 'D', '0', 'E', 'C', '0',
    'B', 'C', '2', '8', 'F', '9', '1', 'B', 'B', 'D', 'D', '9', '5', '5', '6', '0',
    '0', '9', '7', '2', '2', '6', '9', '0', '2', 'E', 'F', 'C', 'A', 'E', 'A', 'E',
    '6', '8', 'E', 'F', '7', '8', '0', '0', '7', 'E', 'D', '0', 'B', '1', '4', '9',
    '7', '8', '8', 'F', 'F', 'D', 'B', '5', 'F', '8', '3', 'C', '2', '3', '5', '8',
    '2', '7', '6', 'D', '4', '7', 'F', '1', 'F', '6', '1', 'F', '8', 'C', 'A', '5',
    '3', 'A', 'C', 'C', '2', '4', '0', '5', '0', '9', 'E', '8', '4', '3', '3', 'D',
    '7', '1', 'E', '4', 'F', '1', '4', '7', 'C', '5', '3', '8', '4', 'B', 'A', '5',
    '5', 'B', 'B', '0', '8', '6', '3', '1', '2', 'F', 'B', 'E', 'A', '5', '8', 'D',
    'C', '4', 'E', '9', 'D', 'D', 'F', '9', 'D', '2', '6', 'A', '1', 'A', 'E', '6',
    'C', '7', '1', 'C', '0', 'C', '3', '6', '6', '9', '9', 'D', 'B', '3', 'F', '4',
    '4', '8', '0', '2', 'B', '6', '9', 'F', 'E', '4', '3', '5', '6', '8', '2', '0',
    '7', 'E', '9', '5', 'B', 'E', 'E', '3', '0', 'D', '9', 'C', 'D', '4', '0', '2',
    'A', '6', 'D', '9', 'A', 'D', 'D', '1', '9', 'D', '9', '2', '1', 'C', '7', '5',
    '9', '9', '6', '4', 'E', '3', '9', 'D', '3', '8', 'F', 'E', 'B', '5', '6', '7',
    '6', '5', '4', '9', '5', 'E', 'B', 'C', '8', '8', 'D', '7', '8', 'E', '5', 'E',
    'A', '4', 'C', '4', 'E', '4', 'D', '3', 'D', '4', '1', '1', '2', '7', 'A', 'A',
    'C', '1', 'E', '5', 'C', '9', 'A', '8', '4', 'E', '8', '5', '9', '4', '5', '5',
    'E', 'B', 'E', '1', '3', 'A', '9', 'E', '8', 'A', '1', 'B', 'F', 'C', 'E', '6',
    '9', '8', '0', '0', '3', '1', '8', 'D', 'F', '7', 'F', '0', '7', '3', '9', 'B',
    'B', '7', 'F', '4', '2', '0', 'A', 'C', '3', '1', '6', '1', '3', '1', '6', 'B',
    '5', 'C', '7', 'F', 'B', '8', '4', 'D', '2', '2', '4', 'B', '1', '4', '5', '5',
    '8', 'C', '5', '5', '2', '9', 'D', '4', 'B', 'D', '3', '6', '7', '2', '9', '2',
    '5', '5', '0', 'B', '8', 'C', 'A', '7', '2', '1', 'A', 'A', '4', 'C', '7', 'B',
    '9', '3', '4', '0', '1', '5', 'F', 'E', '2', '1', '9', '8', '7', '9', '1', '9',
    '2', 'C', 'A', '6', 'B', '2', 'A', '4', '6', '7', '3', '7', 'A', '9', '7', 'F',
    'F', '1', '1', '0', 'B', 'D', '4', '0', '3', 'A', '7', '2', '3', '4', '6', 'F',
    '8', 'B', '3', '2', 'A', 'A', 'E', '1', 'B', '2', '7', '5', '3', 'B', 'B', '1',
    '1', '8', '7', 'A', '0', '0', '9', 'B', 'D', '7', 'E', '6', 'E', 'D', '8', '8',
    '4', 'D', '3', 'D', '1', '1', '3', '3', '3', '9', '2', '7', '0', '8', '6', '9',
    'E', '4', '7', '1', '4', '1', '1', '5', 'C', '4', '6', 'E', 'A', 'E', '3', 'A',
    '7', '8', '0', '7', '8', 'B', '4', 'F', 'E', '1', 'E', '9', '1', 'C', 'C', '8',
    'B', '4', '7', '8', 'B', 'B', 'B', '8', '4', '1', 'D', '4', 'F', '3', 'B', '0',
    '9', '8', '6', 'B', 'C', '5', 'A', '9', '9', '3', '6', '8', '1', '9', 'D', '4',
    '8', '3', 'F', 'A', 'C', 'F', 'D', '5', '4', '2', 'D', 'B', 'D', 'B', '2', '1',
    'F', '6', '8', '0', 'F', '0', 'D', 'C', '2', 'F', 'F', '7', '5', '4', 'B', 'B',
    '5', 'B', 'C', 'B', '0', 'B', '8', 'A', '5', '6', 'D', '8', '5', '4', 'C', '5',
    'A', '5', '8', '5', '6', 'F', '6', '3', '8', '8', 'D', '2', '3', 'D', '1', '7',
    '8', '9', 'E', '1', '8', 'F', '4', '0', '1', 'D', 'D', 'E', '4', '6', '1', '5',
    '4', '8', 'B', '0', 'F', 'E', '3', 'C', 'A', 'A', '8', 'A', 'B', 'F', 'B', '1',
    '5', '1', '1', '8', 'B', '4', '6', '5', '3', 'A', '3', 'E', '1', '3', 'C', '7',
    'F', 'E', '2', '2', '4', 'F', 'F', '1', '2', 'C', 'A', '4', 'C', '5', '0', 'A',
    '2', '8', '5', '8', '9', 'F', '8', '3', 'D', 'A', 'F', '4', 'B', '1', '9', '4',
    '3', '5', 'F', 'E', '8', 'B', '3', 'A', '8', '0', '5', 'C', 'A', '7', '4', 'B',
    '5', 'E', '4', 'C', '5', '2', '8', '9', 'D', 'F', '0', '0', '4', 'A', '6', '9',
    '0', '4', '4', 'F', 'D', 'F', 'E', '9', '6', '4', '2', '6', 'A', '2', 'C', 'F',
    'C', 'B', '7', 'B', 'B', '5', 'F', 'D', '0', '9', '7', '8', 'E', '9', '5', '8',
    'C', '1', '7', '0', '1', '4', '6', '7', '9', '3', '8', 'A', '8', '4', 'A', '4',
    '7', 'C', '4', '4', 'E', '2', '6', 'B', '6', '5', 'D', '5', 'F', 'D', 'A', '0',
    'D', 'F', 'A', '1', 'B', '9', 'E', 'F', '1', '4', '2', '1', '7', '8', 'C', '2',
    'A', 'F', '0', 'A', '0', 'A', '0', '4', 'A', 'B', 'A', 'C', '1', 'E', 'F', 'A',
    'E', 'C', 'F', 'C', '5', '1', '6', '0', 'B', '3', 'B', '5', 'A', '7', '5', '3',
    '0', '4', 'B', '7', '7', '1', 'F', '9', '3', '6', '7', 'A', 'F', 'F', '8', '8',
    '8', '1', 'F', '6', 'F', '2', 'F', 'B', '3', '2', '3', 'A', 'A', 'C', '9', 'A',
    '5', '1', '1', 'B', 'C', '4', 'A', '2', '1', '6', 'F', '7', '3', 'C', '9', '9',
    '3', '8', '0', '5', '2', 'F', '6', '7', '0', '0', '2', '6', '7', '9', '1', '3',
    'B', 'C', 'D', '3', '2', '3', '7', '4', 'E', 'C', '0', '7', 'C', '0', '6', 'B',
    '3', '8', 'E', 'B', 'F', '9', 'E', 'C', '7', '6', 'E', 'F', 'F', '7', 'B', '8',
    '4', '3', '0', 'A', '2', '7', '0', 'E', 'C', 'F', '1', '8', '3', 'F', '3', '3',
    'F', '7', '8', '3', '2', 'B', '2', '4', '7', '6', '9', '0', 'F', '1', 'F', '5',
    'B', '0', 'E', '2', 'C', '8', 'B', '9', '5', '8', '4', '2', 'E', '9', '9', 'F',
    '2', 'C', '0', '5', '8', '2', '5', '5', 'B', 'F', 'A', 'F', 'C', '4', 'E', 'E',
    '1', 'A', 'B', 'B', '6', 'C', '6', '8', 'E', '9', '9', '9', 'C', 'A', 'E', '9',
    'E', 'D', '3', '0', 'E', 'A', '1', '0', 'D', '1', 'A', '9', 'D', '6', '1', '9',
    'A', '1', '3', 'C', 'D', '7', '7', '9', 'C', '8', '8', 'B', '9', '2', 'C', 'B',
    '6', 'B', '4', '6', '8', '2', '5', '4', '8', '8', '8', 'E', '8', 'B', '4', '9',
    '2', '7', 'F', '2', '2', '3', 'B', 'D', 'C', 'D', '6', 'A', 'C', '9', '5', 'A',
    'A', 'F', '9', '8', '4', '2', 'A', 'E', 'A', 'F', '7', '3', '0', '2', 'F', '5',
    'C', '3', 'D', '6', '6', '0', '2', '6', '5', 'A', 'D', '5', 'C', '0', '8', '0',
    '5', 'C', 'E', '8', '4', 'E', 'D', '1', '2', 'F', '3', '5', '0', 'B', '3', '8',
    'E', '2', '1', 'A', '7', '2', '7', 'E', 'A', 'B', '0', 'F', 'D', '2', 'C', '5',
    '8', 'E', '5', '6', '0', 'C', '4', '0', '6', 'E', '8', '9', 'C', '1', '2', 'A',
    '4', '1', 'F', 'B', 'B', '6', '1', 'F', 'E', '5', '6', '0', '6', '8', 'D', 'E',
    'D', 'A', '0', '2', '3', '3', 'E', '7', 'E', 'F', '9', '0', 'D', '4', '9', '5',
    '7', '1', '5', 'E', '0', '5', '0', '9', 'C', '9', '0', '5', '6', '6', '6', '4',
    '6', '9', '3', '1', 'C', 'C', 'B', 'B', '9', '0', '9', '6', '1', 'A', 'A', 'F',
    '0', '3', '8', '2', '4', '3', '6', 'C', '8', '6', 'D', '9', '9', '9', '3', 'C',
    '9', 'A', '9', '4', '3', '2', 'A', '3', '5', '7', 'B', 'F', 'F', '4', '7', '0',
    '7', '3', 'C', 'F', 'E', '7', '9', 'E', '2', '8', '7', '0', '9', 'E', 'D', 'D',
    'D', 'D', 'F', '8', 'B', '4', '3', '2', '5', '6', '1', 'F', '0', 'A', '3', 'A',
    'A', '6', 'A', 'C', '8', '0', '0', '7', 'F', 'E', '4', 'B', 'A', 'B', 'F', 'A',
    'F', 'C', '9', 'C', '8', 'E', '8', '9', '2', '8', '9', 'A', 'A', '1', 'B', 'D',
    '1', '5', 'F', '0', '1', '7', '4', 'A', '7', '5', 'D', '7', '1', '3', '3', '8',
    '1', 'B', 'D', 'E', '2', '7', '2', 'D', '1', '3', '5', '0', '9', 'E', '0', 'E',
    '0', 'B', '6', '3', 'C', '9', 'D', '3', '6', '9', '0', '1', '2', '7', '4', '3',
    'D', '4', '6', 'B', '7', 'A', '5', 'A', 'D', '1', 'B', '3', '6', '7', '1', 'B',
    'B', '8', 'E', 'A', '2', '0', '7', '9', 'B', 'E', '6', 'B', '5', 'D', '5', 'E',
    '7', 'F', 'B', 'C', '1', 'C', '3', 'C', 'E', 'E', '0', '6', '6', '6', 'A', 'E',
    '9', '3', '3', '7', '8', '0', 'C', '0', 'D', 'B', 'C', '6', 'E', '3', 'D', '0',
    'F', '1', '0', '6', 'A', '8', '2', '1', 'F', 'D', 'E', '6', '0', '4', '8', 'E',
    'E', '4', '1', '4', '6', 'D', '0', '3', '1', 'E', '1', '1', '5', 'B', '8', 'B',
    'D', '4', '1', 'C', 'F', '3', '0', '4', 'D', '6', 'F', '9', '3', 'A', 'D', 'B',
    '2', '8', 'F', '0', '6', '9', 'F', '3', '2', 'C', 'B', '3', 'A', '8', '8', '8',
    '2', 'D', 'A', '1', '3', '3', '7', '2', 'B', '6', '0', 'F', 'D', 'B', '7', '2',
    'B', '0', '3', '3', 'F', '6', '1', '1', 'C', 'F', 'C', 'C', '2', '5', '2', 'F',
    'B', '8', 'A', '5', '0', 'B', '8', '6', '5', '9', '0', '6', 'B', '4', 'E', 'C',
    '5', '2', 'A', '3', 'D', 'F', 'E', 'A', 'C', '9', '8', '7', 'D', '3', 'A', 'F',
    '5', '0', '1', 'D', '8', 'A', 'F', 'D', '0', '7', '9', 'F', '8', '1', 'C', '3',
    '5', '0', '3', '5', '0', '4', '1', 'B', 'C', 'E', 'C', '5', 'A', 'B', 'E', '6',
    '4', '1', '1', 'C', '4', 'A', '9', '1', 'B', '1', '7', '0', 'D', '6', 'E', 'E',
    'F', '6', '7', '3', '7', '1', 'A', '8', 'B', 'D', '4', 'E', 'B', '0', 'B', '4',
    'F', '2', '0', 'E', '8', '7', 'A', '5', '1', '9', '7', 'A', '3', '8', '5', '1',
    'B', 'A', '7', 'F', '5', 'C', '4', '8', 'E', 'B', '5', '0', '5', '2', '1', '2',
    'A', '1', '1', 'D', '6', '7', 'D', 'E', '8', '8', '8', 'A', 'C', 'E', '1', '2',
    'D', 'D', 'D', '5', '9', '1', 'B', 'A', '8', 'F', 'B', '4', '8', '1', 'D', '3',
    'A', '5', '4', 'A', '3', 'D', '8', '0', '7', 'A', 'B', '6', '4', 'F', 'D', '5',
    '4', '0', 'E', '3', '6', '6', 'D', '0', 'B', '4', '3', 'D', '4', '8', '9', '0',
    'F', '4', '5', '7', '4', '7', 'F', '5', 'D', '9', '3', '7', 'E', '6', '5', '3',
    '3', '2', '5', 'D', '4', '2', 'D', '4', 'B', 'C', '5', '8', 'A', 'C', 'A', '6',
    'C', 'B', '7', '2', '0', 'B', '5', '1', '4', 'E', '3', 'B', 'C', '8', '7', '7',
    'D', 'C', '7', '6', 'B', 'E', '2', '7', '0', 'D', 'F', '1', '9', '5', '3', 'A',
    '2', 'F', 'E', 'D', '3', 'A', '0', '8', '0', '8', 'F', 'D', 'E', 'D', 'A', '7',
    'F', 'A', '1', 'F', '1', '0', 'A', '6', '3', 'D', '0', 'A', 'D', '6', '1', '0',
    'A', 'F', '9', '0', '3', '0', '0', 'C', '2', 'C', '5', 'F', '7', '6', '9', '8',
    '6', 'C', 'C', 'E', 'E', '5', '4', '8', '6', '6', 'F', '5', '0', '4', '5', '7',
    'F', '1', 'F', '3', 'F', '4', 'F', 'F', '3', 'B', 'D', '8', '7', '1', 'D', '1',
    '5', 'A', '4', 'C', '2', '9', 'A', '5', 'C', '4', 'A', 'C', '6', 'E', 'D', '6',
    'A', 'B', 'E', '3', '6', '1', '2', '2', 'C', '8', '7', '6', 'C', 'A', '6', 'C',
    '3', '9', '6', '9', '6', 'D', '2', 'A', '7', 'A', 'B', '7', '9', 'B', '9', 'F',
    '1', '5', 'A', '8', 'D', '1', 'A', 'E', '8', 'B', 'B', 'A', '5', '6', '2', 'B',
    '9', '1', 'D', '5', 'B', 'F', '1', '6', '3', '8', '5', 'F', '4', '6', '5', 'A',
    '0', 'E', '7', '7', '8', '5', '0', 'D', '9', '8', '3', '7', '5', '8', 'B', '7',
    '1', 'B', 'C', '8', '9', 'C', '2', 'F', '0', 'B', '7', 'B', 'F', '6', '9', '9',
    '5', 'D', 'D', '2', '7', 'A', 'E', '4', '6', '1', '2', '3', 'B', 'E', 'E', '7',
    '1', 'E', '4', '8', '1', 'E', 'F', '6', 'B', '8', 'C', '4', 'A', '7', 'B', 'B',
    'E', '5', '9', 'F', '5', '4', 'B', '6', '5', 'F', '9', '8', '4', '1', 'C', '3',
    '2', '1', 'C', 'E', 'A', 'A', 'A', 'E', '2', 'F', '8', '7', 'A', 'E', '5', '4',
    'A', 'E', '9', 'A', '9', 'E', '3', 'A', '4', '2', '2', '8', 'F', 'F', '3', 'D',
    '8', 'D', '3', 'F', '4', '2', '0', '2', '3', 'E', '8', '7', '8', '0', 'A', '8',
    '0', '2', '2', '4', '4', '3', 'E', 'C', '0', '8', '5', '5', 'F', '7', 'A', 'C',
    '9', '1', 'E', '9', '9', '1', 'F', 'E', '5', 'B', '8', 'F', '2', '2', '4', '5',
    '2', '0', '3', 'B', '3', '2', '5', '0', 'F', '7', 'C', 'E', '1', '5', '7', '9',
    '9', '3', 'F', '1', '0', '2', 'E', '7', 'F', 'B', 'B', 'E', 'B', '8', 'C', 'E',
    '3', 'D', '7', '2', 'A', 'F', 'E', 'F', '1', 'D', '8', '4', 'E', 'A', '5', '8',
    '1', 'E', '5', '3', '4', 'E', 'F', '8', '6', '5', '9', '8', '0', '0', '0', 'E',
    '9', 'F', '3', 'F', '2', '2', '9', '5', '0', '1', '3', 'E', '8', '9', '5', '8',
    'F', '9', '4', 'A', '0', '1', 'B', '5', 'F', 'A', '2', '3', 'A', '8', 'D', '7',
    '8', '0', '8', '5', '3', 'E', '3', 'F', 'E', '4', 'A', '5', '6', '3', '0', '9',
    '1', '0', '0', '7', '4', '4', 'E', '0', '7', '8', '5', '7', '7', '3', '6', 'B',
    '8', '5', 'A', 'A', 'A', 'D', '5', '8', 'F', 'F', '7', '8', '0', '6', '8', '2',
    '8', '9', '3', '3', 'F', '2', 'F', '7', '2', '9', 'F', 'B', 'E', '6', '5', 'C',
    '8', 'C', '5', '4', 'F', '3', '2', '2', '3', 'C', '0', 'A', '9', '3', '2', 'A',
    '1', '2', '4', '4', '3', 'C', 'A', '0', '0', '4', '4', '0', '4', '4', 'B', '5',
    '5', '3', '0', 'C', 'E', 'D', 'D', '0', 'F', '9', 'C', '1', '5', '2', '3', 'F',
    '6', 'D', '2', '3', '2', '4', '3', '8', 'E', 'E', '4', '6', '1', '5', 'E', 'D',
    'B', '7', 'F', '0', 'A', 'C', 'F', '4', '6', 'E', '2', '2', '1', '7', 'D', 'E',
    '6', '2', '6', '9', 'D', '2', '2', '5', '0', '0', '5', '8', 'F', 'B', 'F', 'E',
    'E', 'D', '6', 'B', '9', '0', '5', 'F', '9', '0', '2', '9', '9', '1', '1', '3',
    '3', '6', '5', '7', '8', 'B', 'D', '5', '4', '8', '6', '5', '5', '6', '1', '2',
    'A', '0', 'E', '3', '5', '8', '9', 'F', 'D', '6', 'A', '3', 'B', 'E', '8', 'E',
    '9', '9', 'D', 'B', 'C', '8', '5', 'B', 'E', 'C', 'D', '6', '0', '3', '4', 'A',
    '2', '9', '9', 'B', 'D', '2', 'A', '8', '2', '4', '8', '7', '4', 'F', 'E', '1',
    'C', 'B', '8', '1', 'E', '9', 'B', 'E', 'D', 'E', 'B', '0', '4', '8', '3', 'A',
    'B', 'A', '0', 'C', '0', 'D', 'A', 'A', '6', '4', '6', '2', '6', '9', '1', '1',
    'B', 'A', '8', '9', '7', '3', 'E', '5', 'E', '3', 'E', '6', '2', 'F', '2', 'A',
    'D', 'D', 'A', '2', '2', 'F', 'B', 'B', '8', 'D', '0', 'F', '5', '5', 'C', '9',
    '4', '3', '0', '7', '7', '8', 'D', 'B', 'B', '3', '1', '5', 'F', 'A', 'F', 'B',
    '7', '2', 'A', '2', '3', 'A', '9', '5', '7', '7', '2', '2', 'A', '9', '5', 'E',
    '3', '3', '3', '2', '2', '2', 'C', 'D', 'C', 'B', '1', '2', 'A', '8', '9', '1',
    'D', '3', '0', '0', '8', '2', 'F', '8', '8', '7', '8', '3', 'F', 'A', '3', '7',
    'C', 'C', '3', 'F', '7', 'F', 'E', '5', '6', '8', '6', '3', '6', 'F', '5', 'D',
    'B', 'A', '1', 'D', 'E', 'D', '8', 'E', 'C', '9', 'C', '2', 'E', '1', 'A', 'E',
    'E', '6', 'B', 'E', 'A', 'A', '7', '3', '7', '0', '6', '6', '7', 'B', 'A', '8',
    '8', 'F', 'D', 'B', 'C', 'B', '1', '3', '9', '7', 'D', 'F', 'B', 'E', 'A', '8',
    '3', 'A', 'E', 'F', '8', '0', 'D', 'F', 'B', '2', '1', 'D', 'E', 'D', 'E', '0',
    '7', '1', '3', '7', '7', 'D', '7', 'A', '3', 'A', '2', '0', '4', '1', 'B', '0',
    '9', '8', 'A', 'D', 'F', 'B', '3', '5', 'C', '1', '8', 'F', 'A', 'C', '1', '8',
    '5', 'D', '3', 'A', '8', 'C', 'E', 'D', 'E', 'A', '7', '7', 'D', 'E', '2', '7',
    '9', 'E', 'C', 'F', '0', '8', '5', 'B', '8', 'A', '7', '8', '6', '9', 'A', 'D',
    '3', '0', '5', 'D', '5', '7', '9', '6', 'D', '2', 'E', 'C', '3', 'F', 'B', '2',
    '2', '1', 'F', '9', 'D', 'C', '3', '0', 'F', '4', 'B', 'F', 'A', '8', 'C', 'A',
    '8', 'D', '0', '6', '6', '6', '3', 'E', '9', '1', 'A', '5', '0', '6', '6', 'F',
    '1', '7', 'E', 'A', '3', 'A', '2', 'A', '7', '2', 'B', 'F', '7', '5', '8', '2',
    'D', '2', '6', '8', '3', 'C', '5', '1', '0', '4', '3', 'C', '1', '2', 'F', 'F',
    'C', 'E', 'A', '0', 'A', '9', '4', 'B', '1', '2', '9', '7', 'F', '9', '6', 'F',
    '4', '5', '5', 'E', '7', '1', '1', 'D', '1', 'D', '4', '3', '0', '7', '5', '7',
    '4', '8', 'E', 'B', '7', 'B', '8', 'C', '4', '0', '8', 'A', '0', '9', '1', '8',
    'E', '1', 'E', 'D', '1', '3', '5', '1', '0', '9', '2', '9', 'C', '5', '0', '1',
    '4', 'A', 'F', '6', 'D', '7', '3', '4', 'A', '7', '7', '5', '9', 'D', '3', 'F',
    'D', '7', '1', 'C', 'F', '6', '7', '3', 'A', '0', '0', '3', 'C', '5', '5', '9',
    '7', 'C', '1', 'B', 'D', '3', '0', '0', '6', '5', 'C', '8', '8', 'D', '1', 'E',
    'D', '3', '7', '8', '5', 'A', '3', 'A', '8', '5', 'F', 'F', '4', '4', '9', 'D',
    '0', 'C', '4', '7', '8', '7', 'D', '5', '1', 'C', 'C', '5', '2', '5', '7', 'B',
    'F', 'C', 'F', 'D', 'F', '5', 'A', '5', '7', 'D', 'E', '5', 'B', 'A', '2', 'F',
    'E', 'D', 'D', '3', '3', 'F', 'F', 'F', '3', 'E', '9', 'C', 'D', 'E', '8', '0',
    '0', '0', 'A', 'E', 'B', 'A', '5', 'E', 'B', '9', '4', 'A', 'A', '0', '9', '9',
    '3', '8', '3', 'F', '1', '4', '9', '3', 'C', 'D', 'D', '6', '7', '8', '8', 'E',
    '2', '6', '2', '1', '1', 'B', '5', '8', 'C', '0', '7', 'D', '7', 'E', 'F', 'D',
    'A', 'D', '8', '2', '4', '2', 'D', 'C', 'A', '0', '1', '7', '2', '3', '3', 'E',
    'E', 'B', 'B', 'B', '7', '6', '2', 'F', '7', '1', '0', 'D', 'F', 'E', '9', 'A',
    '2', '9', '0', 'F', '9', '5', '2', '2', '6', 'A', 'C', 'C', '2', '2', 'B', '7',
    'E', '0', '7', '7', '9', 'D', 'E', '4', '2', '7', '5', '5', '2', '7', '3', '5',
    '9', '5', '6', '2', 'A', '7', 'E', 'E', '7', '6', 'F', '3', '0', '2', 'C', 'B',
    '8', '7', '4', '1', 'D', 'C', '8', '5', 'B', '9', '6', 'B', 'D', '2', 'D', '0',
    '0', 'C', '1', 'A', '2', '4', '0', 'A', '9', '0', 'F', '4', 'F', '7', '9', '0',
    'C', '4', '3', '5', 'C', 'A', '6', 'F', '9', '0', '1', 'E', '7', 'C', '7', 'D',
    '2', '1', '8', '3', '6', '5', 'F', '3', '0', 'B', 'B', '7', 'F', '3', '4', 'E',
    '9', 'B', '5', '0', 'B', 'E', '1', 'D', '1', '0', 'C', '3', '3', '7', 'C', 'F',
    'D', 'E', '0', 'D', '3', '2', 'C', '7', '9', 'A', '0', '7', '3', '3', 'E', 'F',
    'D', 'B', '3', '2', 'D', '6', '7', 'E', '8', '9', '4', '7', 'D', '4', '3', '7',
    '8', 'C', '0', 'E', '5', '7', '9', '8', '5', '2', '1', '5', '3', '1', '0', '1',
    '1', 'C', 'F', 'D', '5', '5', 'E', '0', '7', 'D', '2', 'C', '7', '2', 'C', '8',
    '3', 'E', '8', 'B', 'B', 'B', 'D', '4', '1', 'F', 'D', 'C', 'D', '0', '3', 'C',
    '9', 'A', 'F', '6', 'D', 'B', 'F', '0', 'D', 'C', 'B', '8', '8', '0', '1', '4',
    '0', 'C', 'E', 'C', 'A', 'F', '6', '5', '4', 'A', 'E', 'E', '7', '8', 'D', '5',
    '1', 'E', 'A', '7', '1', '2', '1', 'C', 'D', '5', '0', '7', '1', '1', 'C', '8',
    '6', 'D', '1', 'B', '5', '1', 'C', 'D', 'C', 'D', 'E', '8', 'A', '2', 'B', 'B',
    '3', 'F', '0', 'C', '4', '5', 'D', '8', 'B', 'D', '7', '5', '7', '4', 'A', 'F',
    'A', 'E', '7', '7', 'A', 'F', '0', 'B', 'F', '8', '4', '3', 'E', '0', 'C', '7',
    '3', 'A', 'C', '0', 'C', 'F', 'C', '6', '2', 'F', '6', '9', 'E', '0', 'D', '3',
    '4', '8', 'E', 'F', '0', 'E', '8', 'A', '5', '6', '1', 'F', 'B', '2', '1', '9',
    '2', 'C', '7', '4', '6', '5', 'D', '6', '9', '8', '0', 'C', '4', '0', '6', '1',
    'A', 'B', '1', '1', 'A', '0', 'F', 'D', 'B', '9', '3', 'B', '6', '3', '1', '3',
    '8', '0', '9', '5', 'E', 'E', '1', 'D', '6', 'F', '5', 'F', '8', '3', 'C', 'D',
    'E', '4', 'D', '9', '2', '4', '4', '8', '8', '1', 'B', '5', '5', 'A', '8', '1',
    'D', '8', '0', '3', '3', 'F', 'A', '3', '4', 'B', '0', '2', 'A', 'B', '5', 'E',
    'D', '5', '7', '3', 'A', '0', 'C', 'B', 'F', '8', '7', '8', '2', '1', '9', 'C',
    'A', '5', '1', '2', '8', 'D', '2', '9', 'F', '1', 'E', '3', 'D', '6', '9', 'F',
    '8', '7', '9', '4', '8', '4', '2', '7', 'D', 'E', 'F', '5', 'D', 'D', 'F', 'A',
    '1', 'D', '7', '9', '2', '5', '4', '2', 'B', '6', '1', '6', '4', 'C', 'D', 'C',
    '5', 'B', '5', '4', '1', 'F', '0', '2', '5', '0', '8', 'A', 'A', '6', 'B', '1',
    '1', '2', '0', '3', '3', '8', '1', '5', '0', 'D', '4', '0', '3', '7', '2', 'A',
    '9', '6', '1', 'B', 'E', '5', 'B', '6', '4', '4', '3', 'D', 'E', '6', 'E', 'B',
    '7', '0', 'D', 'C', '0', '4', '1', 'A', 'D', 'F', '8', '0', '1', '5', '1', '6',
    'C', '4', '5', '0', 'F', '7', '0', 'A', '9', '6', 'B', 'E', 'A', '6', '2', '3',
    'B', '5', 'A', '8', 'F', 'C', '0', '6', '5', 'C', 'D', '0', '2', '7', '2', 'C',
    '2', '6', '8', '0', '6', '0', '7', '9', '2', 'D', 'B', 'B', '9', '8', 'F', '7',
    '0', '8', 'A', 'E', '1', '4', '0', 'A', '2', '7', '2', '1', 'F', 'A', '6', '1',
    '4', '2', 'F', 'D', '0', '3', '6', '5', '4', 'F', '4', 'C', '3', '3', '6', 'B',
    '5', '8', '8', '0', '9', '3', '6', '5', '7', '9', '5', '2', '4', '5', '5', 'F',
    'D', 'C', 'C', '1', '8', '2', '6', '7', 'E', 'E', '7', 'B', 'C', 'F', '3', '1',
    '3', 'E', 'D', '5', '2', '1', '7', '8', '9', 'F', 'B', '9', '8', 'B', 'C', 'C',
    '5', '6', 'F', '5', 'C', '9', 'A', '5', '7', '3', 'B', 'B', 'E', 'B', 'B', 'B',
    '4', '0', '3', '8', '9', '5', '2', '7', '9', 'E', '3', 'C', 'F', '3', '2', '4',
    '0', 'D', '7', '0', '3', 'E', 'C', '3', '7', '1', '2', '7', '3', 'A', '0', '0',
    '5', 'C', '9', '9', '8', 'F', '3', '0', 'C', '7', '3', 'E', 'F', '2', 'A', '6',
    'D', '6', '4', '1', '3', '8', '9', 'E', '3', '7', '4', '0', '9', '6', '6', 'C',
    '3', 'D', '1', '1', '9', 'E', 'A', 'E', 'D', '8', 'E', 'C', '8', 'C', 'E', '1',
    '0', '9', 'B', '2', 'D', '2', '3', '0', '3', '5', '7', '8', '0', 'A', '8', '4',
    'F', 'B', '0', '1', 'D', '3', '3', '4', '3', 'E', '3', 'B', 'E', '5', '8', '6',
    'A', '7', '7', '5', 'F', '1', 'E', '8', '6', 'A', '8', '1', '0', '3', '0', 'F',
    '3', 'D', 'B', '6', 'A', 'E', 'B', '6', '2', '6', 'E', 'E', '3', 'D', '8', '9',
    'C', 'B', '4', 'D', 'E', '8', 'A', 'E', '7', '7', '0', 'A', '5', 'A', '4', 'C',
    'F', '3', 'C', '1', 'C', '5', '2', 'F', '4', 'C', 'E', '2', 'A', '3', '7', '0',
    '3', 'C', 'D', '1', '4', '1', '4', '7', '1', '7', '0', 'A', 'B', '9', 'E', '1',
    '9', 'A', '2', '1', '2', 'B', '7', 'D', 'D', '5', '8', '6', '0', '6', 'B', 'A',
    'B', 'C', 'B', '0', '6', 'F', '8', 'A', 'E', 'A', '8', '5', '0', 'D', '7', '8',
    '1', 'A', '2', '6', '0', '7', 'D', '6', '0', '4', '8', '4', '8', '0', '7', '8',
    'D', 'C', 'F', 'D', 'F', '9', 'B', '9', 'D', 'E', '9', '3', 'A', '8', 'D', '8',
    '3', '3', '7', '3', 'E', 'F', '7', '8', '4', '7', '9', 'D', '1', 'E', '6', 'E',
    'B', 'E', 'A', '9', 'C', '0', '6', '0', '1', '2', '0', 'C', '5', 'E', '6', 'C',
    '0', 'F', 'C', '4', '7', '7', '8', 'B', 'A', 'C', 'A', '6', '4', '2', '7', 'D',
    '0', '9', 'F', '8', 'A', '4', 'A', '6', '2', '2', '5', 'F', 'B', '2', '8', '7',
    '7', '2', 'C', '9', '5', '6', 'C', '5', 'C', '8', '8', 'C', '2', '2', 'E', '6',
    '0', '8', '0', '0', '0', 'C', '1', '6', 'D', 'F', '9', '1', 'A', 'B', '4', '9',
    '6', 'D', '0', '9', '6', '5', '7', '3', '4', 'D', 'A', '8', 'F', '1', '0', '6',
    'D', '4', 'F', '5', 'F', '5', '4', '3', '5', 'E', '1', '0', '0', '8', '3', 'A',
    'E', '3', '5', '1', '4', 'E', 'A', 'D', 'F', '1', '2', '9', '2', 'E', '7', '8',
    'A', 'B', '6', '8', 'B', '5', '3', '2', 'A', '1', '1', 'C', '7', 'E', '0', 'E',
    'C', '1', '8', '1', '5', '5', '8', '9', 'E', '4', 'C', '1', 'B', 'D', '2', 'C',
    '7', '6', 'D', 'D', 'C', '5', 'D', '0', 'D', '2', 'C', '2', '5', '4', 'C', 'D',
    'A', '7', 'F', '3', 'F', 'C', '8', '3', '9', 'C', 'C', 'D', '2', 'C', '4', '9',
    'B', 'D', 'D', 'F', '5', '8', 'D', 'B', 'E', '4', '1', 'F', 'C', 'F', '9', '9',
    '5', '5', '8', '5', '5', '0', '4', '9', '2', 'B', 'C', '7', '4', '9', 'A', '1',
    '1', '3', 'D', '5', 'E', '2', 'A', '0', '1', 'C', '5', '5', 'C', 'E', 'E', '5',
    'A', 'D', '3', '0', '3', 'A', 'D', 'C', '5', '4', '0', 'B', '9', '1', '9', '0',
    'C', 'D', '0', '0', '9', 'B', 'D', '0', '9', '2', 'A', '2', '6', '7', 'C', 'A',
    '6', '9', '5', '9', 'B', '7', 'A', '8', '9', 'C', '6', 'A', '4', '5', 'B', '2',
    'C', '9', '0', '4', '8', '6', '8', '9', '5', '4', '7', '1', '3', '1', '1', 'E',
    'A', 'F', '3', 'B', '9', 'D', '7', '0', '7', '2', 'B', '2', '4', '6', 'A', '6',
    'C', 'F', '1', 'C', 'D', '0', '2', '3', '5', '2', '2', '5', 'E', '2', 'F', '0',
    '0', '8', 'C', 'F', '8', '4', '1', 'E', 'C', '8', '0', '2', '5', '6', 'B', '4',
    'C', '5', '9', 'B', '7', '1', '9', 'D', 'D', 'B', 'D', '1', 'C', '8', 'C', 'A',
    '2', '5', '0', '0', '6', '2', 'C', 'A', 'A', 'D', '8', 'A', 'E', '9', '8', '9',
    'B', '3', 'B', 'A', 'E', '9', 'B', '6', '4', '1', '6', '3', '6', 'C', 'D', 'F',
    'E', 'C', '7', 'C', '0', '8', 'F', 'D', 'F', 'B', 'E', 'C', '7', 'F', '2', 'E',
    'F', '2', '7', '8', '7', '1', 'A', 'D', '5', '2', '2', '8', 'D', 'B', '7', 'B',
    'C', 'B', '1', '2', 'C', '0', '3', '6', 'F', 'A', '1', '0', 'B', '7', '3', 'C',
    '1', '6', 'A', 'B', '4', 'F', 'B', '9', '6', '4', '5', 'A', 'E', '3', 'D', '8',
    '8', 'E', 'D', 'B', 'C', 'F', '0', '5', '4', '1', 'F', '3', '8', '3', 'A', '3',
    '6', 'A', '2', '6', '2', '9', 'F', 'D', '9', 'D', '2', '5', '5', '5', '3', '7',
    'B', 'D', '3', 'A', '1', '2', 'A', '0', '2', '9', '4', '8', '1', 'A', '9', '2',
    'D', 'F', '2', 'D', '2', '1', '5', '9', 'B', 'E', '5', 'B', '6', 'F', '2', 'C',
    '8', 'E', '2', '6', '0', '5', '3', '4', '3', 'C', '4', 'B', '7', 'B', '9', '4',
    'F', '5', '6', '3', 'C', 'A', '5', 'B', '5', 'A', 'F', '7', 'A', '8', 'A', '8',
    '1', '3', 'C', 'E', 'B', '4', '8', 'D', 'A', '4', '0', '4', '4', '6', 'E', 'E',
    'E', '3', '5', '9', '8', '7', '6', 'F', '4', '6', 'B', 'B', '3', '8', '1', '8',
    'C', 'B', '1', '5', '0', '3', '4', 'B', 'D', '3', '8', '1', 'D', 'B', '8', 'A',
    'A', '6', 'D', 'E', '1', '5', '7', '2', 'E', '5', 'C', '4', '6', 'A', 'B', 'B',
    'B', '8', '4', '4', 'E', '0', '5', 'A', 'C', '3', 'C', '5', '5', 'F', 'C', '0',
    '9', '5', '6', '7', 'C', '5', 'D', '7', '4', '5', '1', '1', 'B', '4', '0', 'E',
    '1', 'E', '6', '0', '1', 'F', 'F', '9', '8', 'A', '7', '3', '6', '3', '7', '4',
    '7', '3', 'C', '6', '0', '9', 'A', 'A', '5', 'E', '7', 'A', '8', '3', '4', '8',
    '5', '3', '7', '8', '0', '2', '2', '9', '4', '8', '9', 'D', 'B', 'B', 'A', 'C',
    'D', '2', '1', '6', '2', 'A', '1', '8', 'E', '6', 'E', '7', '5', 'F', '4', 'C',
    'F', '5', 'B', 'F', 'B', '1', '4', '1', 'F', 'C', 'D', '2', '5', '8', 'D', '6',
    '4', 'A', 'D', 'F', '9', '7', '5', '3', '8', '6', 'E', '9', 'C', '4', 'F', '9',
    '3', '4', '7', '0', 'B', '6', '4', '0', '4', '3', 'F', 'E', '0', 'A', '2', '3',
    '1', '8', 'F', 'A', 'D', '9', 'A', '7', '0', '1', '9', 'C', 'C', '1', '2', 'A',
    'F', 'B', '0', 'A', '9', 'B', '6', 'D', '4', '4', 'B', '5', 'F', '0', 'D', '2',
    'C', '2', '7', '1', '3', '9', '8', '7', '3', 'C', '5', '2', 'F', '8', 'D', '5',
    'D', '4', 'B', 'A', '9', '2', '8', '0', '0', '0', '3', 'D', '8', 'D', '3', 'E',
    '5', 'A', '6', '4', 'F', '8', '3', '4', '7', 'F', 'C', 'D', '5', '3', '9', '1',
    '9', '1', 'D', '7', 'F', '9', 'E', 'A', '0', '7', 'F', 'B', 'F', '5', '8', 'A',
    'A', '8', '2', 'A', 'C', '3', '1', '9', 'D', 'D', '4', 'A', 'B', '5', '9', '9',
    'E', '2', 'F', '2', '2', '0', '3', '3', 'A', '1', '5', '1', 'A', 'C', '7', 'A',
    'C', '8', 'C', '1', '0', '4', '5', 'F', 'C', 'C', 'E', '6', '1', 'B', '0', 'E',
    '4', '9', '2', 'A', '1', 'E', '8', '2', 'B', 'C', '3', 'C', 'A', 'B', '3', '0',
    '5', '7', 'A', '7', 'F', 'A', '3', '4', 'D', '3', '4', '6', '1', '9', '2', '4',
    'A', 'A', 'D', '1', 'B', '9', '4', '2', '0', 'F', 'E', '3', '8', '3', '2', '4',
    'F', 'E', 'A', 'E', 'B', '4', '6', '6', 'D', 'B', '7', '8', 'C', 'E', 'B', '8',
    '7', '9', 'C', '8', 'D', '5', '6', 'C', '4', 'B', 'B', '5', 'E', '3', '6', '6',
    '1', '7', 'D', 'E', '9', 'F', '3', 'A', 'C', 'B', '3', 'D', '7', 'D', '9', '3',
    '5', '4', 'F', '6', '2', 'D', '3', '4', '1', '6', 'B', 'C', '1', 'C', '7', 'A',
    'A', 'E', '1', 'E', '2', '8', 'E', '4', '9', '5', '0', '4', '3', '8', '0', 'D',
    '0', '0', 'A', '8', '6', '8', '4', 'A', '3', '5', '1', '9', 'D', '7', '1', '6',
    '5', 'B', 'B', 'C', '0', '9', 'C', '2', 'C', 'C', '7', '9', 'C', '7', '0', 'A',
    '0', '4', '4', '4', '9', '2', 'D', 'E', '5', '4', 'E', '3', 'A', 'E', '4', 'A',
    '3', '9', 'C', '4', '7', '3', '6', '9', '0', '9', '8', 'A', 'E', 'B', 'F', 'B',
    'E', 'A', '8', '2', '1', 'F', 'D', '6', 'C', 'D', '2', '4', '5', '7', '1', 'A',
    'B', '6', '0', '3', '2', 'F', 'C', '4', 'B', 'B', '0', '1', '2', '6', 'D', '1',
    'B', 'D', 'D', '0', 'D', 'A', 'D', 'F', 'D', '1', 'A', '4', '5', 'B', 'B', '7',
    'B', '0', '7', '4', 'C', '9', '3', 'D', '8', '7', '4', 'D', '4', '2', '2', 'E',
    '3', '6', '3', '0', '7', '4', '6', 'D', '9', 'F', 'B', '7', 'E', 'A', 'E', 'A',
    '9', '2', '0', 'D', 'F', '7', '4', '2', '1', 'E', '0', '0', '3', 'D', '6', 'C',
    '3', '9', '1', '1', '7', '4', '4', '5', '9', 'D', '5', 'B', '5', '6', 'D', 'C',
    'C', '3', '7', '6', '0', '5', 'C', '1', '1', 'B', 'E', '4', '0', '4', '9', '6',
    '3', 'D', 'A', 'C', '8', '6', '0', 'A', '0', '9', 'D', '1', '5', '3', '3', 'A',
    'D', '5', '6', '7', 'D', '6', '0', '6', '9', 'B', 'A', '9', '3', 'E', 'F', '6',
    'E', 'C', '8', 'D', 'C', 'B', '2', 'E', '9', '2', 'B', '1', '7', '9', '2', 'C',
    '6', 'A', '6', 'C', '7', '8', 'F', '3', '9', '9', '7', '7', '9', '4', '5', 'B',
    'F', '8', 'D', '7', 'F', '4', '5', 'D', '1', '2', 'C', '8', '5', 'E', '5', '5',
    '7', '7', '1', 'F', '4', '1', 'F', 'B', '3', '2', '4', '4', '3', 'D', '1', '6',
    '2', '7', '8', '5', '5', '6', 'C', '4', '3', '5', 'C', '5', '6', '5', '5', '0',
    '7', '8', '6', '1', '6', 'A', '6', '6', '4', 'B', 'F', '3', 'D', 'A', '0', 'F',
    'B', '3', '2', '8', '0', '4', 'F', '7', '4', 'B', '5', 'A', '6', 'D', '0', '6',
    'B', '1', '4', 'F', '3', '8', '2', 'B', '0', 'D', 'A', '6', 'F', 'D', '3', '1',
    '9', '2', '5', '1', '0', '1', 'B', '3', '6', '2', 'A', 'B', 'D', 'D', '4', 'D',
    '7', 'B', '3', '7', 'D', 'F', '9', 'F', 'A', '9', '7', '4', 'E', '0', 'A', 'D',
    'B', '6', '3', '7', '8', '3', '4', '1', '6', '9', '3', '9', '7', '5', 'D', 'A',
    '9', 'F', '9', '5', '0', '7', '4', '1', 'B', 'E', '2', '1', 'F', '5', '0', 'F',
    'B', '8', '4', '0', '5', 'C', '5', 'E', 'B', '9', '6', 'D', '2', 'F', '8', '7',
    '3', '0', 'C', '8', 'B', 'F', '4', '6', '4', '2', '4', '1', 'A', '2', '0', '1',
    'E', 'E', '1', '0', 'E', '8', '4', '0', '3', '0', 'D', '6', '3', 'E', '8', '4',
    '6', '8', 'D', '7', '0', '7', 'E', '6', 'B', 'C', 'E', '5', 'A', 'F', 'E', '0',
    '0', '5', '0', '5', 'C', 'D', 'C', 'F', '3', 'E', 'A', '8', '2', 'D', '0', 'F',
    '9', 'F', '3', '5', '3', '5', '8', 'E', 'C', '7', 'C', 'C', 'B', 'C', '7', 'F',
    'B', '1', '4', '5', '7', '8', '4', '3', '8', 'A', 'F', '7', '3', '0', 'F', 'B',
    '1', 'C', 'C', 'F', '0', 'E', 'E', '1', '3', '9', 'E', '0', '8', 'B', 'D', '8',
    'C', '2', 'C', 'A', 'A', 'E', '7', '0', '8', 'D', '6', '0', '2', 'B', 'C', 'E',
    '8', '7', 'A', '9', 'E', 'B', 'F', '9', 'C', '5', 'C', '8', 'B', '1', '9', 'B',
    '9', '5', '0', '5', '7', '6', '6', 'A', '4', 'F', '3', 'C', 'C', '5', '7', 'F',
    '2', '3', 'C', '4', 'D', 'C', '4', '7', '3', 'D', 'F', 'D', '2', '8', 'C', 'A',
    'B', '8', '8', 'C', '4', 'F', '7', 'D', 'E', 'C', '9', '4', '5', 'A', 'B', '2',
    '3', '1', '3', '6', '8', 'B', 'E', '5', '1', 'F', '6', 'C', 'F', '6', 'F', 'A',
    'A', 'F', '9', '7', '7', '4', 'A', 'A', '3', 'D', 'F', '2', '6', 'C', '3', '1',
    '7', '2', 'A', '2', '0', 'F', '9', '0', '0', 'E', 'B', '8', '3', 'F', '8', '6',
    '3', 'A', '2', '3', '9', 'E', '5', '3', 'A', '2', '8', 'C', '0', 'D', '2', 'D',
    'F', 'F', 'F', 'E', '6', 'D', '8', 'B', '4', '7', '4', '3', 'C', '4', '5', '4',
    '8', '1', 'A', '5', '3', 'D', '8', '8', '0', '0', '6', '0', 'C', '4', '4', '9',
    '1', 'F', '4', '1', 'D', '0', 'F', 'B', '7', 'D', 'C', '4', 'A', 'B', 'C', 'E',
    'E', '5', '4', '8', '4', 'B', '5', '0', 'D', '8', '6', '7', '6', '3', '3', '7',
    '8', '6', '7', '6', '3', '1', 'C', '1', '9', '1', '3', '3', 'F', '3', '9', '5',
    '4', 'D', 'A', '8', '0', '0', 'F', 'E', '4', 'F', 'A', '4', 'D', '1', '0', '8',
    'F', '6', 'B', 'F', 'A', '3', '4', '1', '3', '6', 'D', '9', '1', '3', 'B', '0',
    '9', '5', '0', 'F', '3', 'E', '8', '8', '2', 'A', 'F', '4', '8', '6', '0', 'D',
    '1', '1', '2', 'E', '7', '2', 'E', '5', '7', 'A', '4', '9', '8', '5', '0', 'A',
    '0', 'F', '7', '0', '3', '5', '6', 'A', '5', '1', '4', '4', '6', 'C', '3', 'B',
    '6', 'C', '4', 'A', '6', '4', '3', '1', 'E', '8', 'E', '5', '8', '0', '4', '7',
    '9', '8', '3', '3', '7', '3', 'C', 'F', '9', '2', '3', 'F', 'D', '3', 'A', 'A',
    'D', '3', '2', '4', 'E', 'A', '3', '6', '5', 'E', 'A', '1', 'C', 'C', '7', 'D',
    'E', '6', '9', '0', '4', 'B', 'D', 'F', '6', '9', '8', 'A', '3', '8', '4', 'E',
    '1', '4', 'C', '8', 'B', '8', '9', 'C', 'E', '3', 'B', '7', '8', '0', 'C', '5',
    '2', '7', '6', '0', '0', '4', 'F', '8', '4', 'A', '1', '8', 'F', 'C', 'D', 'C',
    '7', '5', '7', 'E', '2', 'A', '1', 'E', '2', 'C', '6', 'C', 'E', '4', '4', '0',
    '9', '4', '4', '2', 'C', '1', '8', '9', '1', '6', 'C', 'E', '6', '1', '1', '4',
    'B', '2', '5', 'C', '7', 'D', '6', '5', '0', '5', 'D', '0', '0', '3', 'F', 'B',
    'A', 'A', 'A', 'E', '8', '0', 'D', '2', '9', 'C', '6', '6', '8', 'E', '0', '0',
    'E', '1', '8', '9', '4', 'C', '7', '9', '7', 'B', '6', 'C', '1', 'E', 'B', '8',
    '4', 'A', '2', 'D', '0', '3', 'A', '4', '8', 'A', 'D', 'E', '8', '7', '7', '2',
    '6', '1', '8', '8', '0', '5', '9', 'E', 'B', '5', 'B', '3', '2', 'A', '0', '4',
    'A', 'A', '2', '4', '1', '2', '8', '7', '5', '7', 'F', '3', 'F', '1', '4', '1',
    '6', '6', '0', '8', '8', 'B', '9', '9', '9', 'D', 'C', '4', '9', 'F', '7', 'A',
    '9', '2', 'F', 'B', 'A', '3', 'C', 'F', '5', '6', '5', 'E', '2', '7', 'E', 'B',
    '8', '3', 'F', 'B', 'A', '1', 'A', '5', '4', '8', 'C', 'B', '5', '3', 'B', '8',
    '8', '3', 'D', '4', 'B', '5', 'D', '5', '7', '0', 'E', '8', 'D', '1', '5', '7',
    '9', '4', 'D', 'F', '6', 'F', 'A', '3', '2', 'F', '8', 'B', 'F', 'E', '9', 'D',
    'C', '7', 'E', '2', '3', 'D', '8', 'D', 'A', '7', 'E', '2', 'A', 'C', 'B', 'E',
    '9', 'F', 'B', 'E', 'F', '5', '3', '0', '3', 'E', '9', '8', '3', '7', 'B', '8',
    '8', '6', 'B', 'F', 'B', '3', 'E', '5', '4', '1', '9', '9', '8', '4', '1', '2',
    'A', '5', '2', '3', '7', '4', 'B', '6', '7', '0', '5', 'B', 'A', 'A', '7', '1',
    '7', '9', '1', 'A', '7', 'B', '7', 'F', 'B', '3', '5', '0', 'B', '0', '4', 'C',
    '4', 'A', 'A', '0', '4', '5', '7', 'F', '3', 'D', 'D', 'E', 'A', '9', '7', 'E',
    '4', '2', '7', 'B', '1', '5', 'D', '7', '0', '0', 'F', '3', '6', '9', 'A', 'F',
    'B', '1', '4', 'D', '3', 'E', '8', 'A', 'A', '5', 'E', '1', '2', '6', '1', 'B',
    '5', 'A', '4', '2', '7', '6', 'A', '9', '5', '4', 'C', '2', '4', '0', '6', 'F',
    'E', '5', '1', '2', 'A', '3', 'C', 'E', '8', '1', '6', 'E', '8', '4', '1', '7',
    'D', 'A', 'A', '0', 'B', '1', '4', 'A', '5', 'F', '9', '8', '0', '2', '2', '5',
    '1', '0', '1', 'D', '5', 'D', '6', '4', 'A', '9', 'E', '8', '1', 'E', '1', '2',
    'B', '7', '6', 'C', 'D', 'E', '6', 'C', '9', 'F', '7', '1', 'F', '3', 'C', 'B',
    '0', 'F', '0', '2', 'B', '8', '3', '7', 'D', '5', '3', '3', '9', 'B', 'D', '0',
    'B', 'C', '8', '6', '7', '6', 'D', '6', '0', '0', 'C', '8', 'A', '4', '4', 'B',
    '4', '7', '1', '6', 'E', '9', 'E', '9', '6', '4', '5', 'F', '7', '3', '5', 'D',
    'B', 'A', '8', '3', 'A', 'D', 'B', '1', 'A', '9', 'D', 'D', '8', 'B', '5', '9',
    '2', '7', '5', '4', '8', 'E', 'C', 'C', '9', '0', '5', '7', '9', '5', '8', 'E',
    'A', 'D', 'A', 'E', '8', 'E', '6', '4', '3', '0', '2', '1', 'F', '2', 'B', '3',
    'B', '0', '7', 'A', '0', '1', '1', 'E', '5', 'D', '8', 'A', '4', '1', 'E', 'F',
    '0', 'C', '6', '2', '2', '8', 'B', '8', 'D', '2', '2', '2', '9', '2', '9', '5',
    'D', 'A', '7', 'B', 'C', '8', '6', '6', 'F', 'A', 'A', '1', 'B', '3', '4', '3',
    '8', 'B', 'D', '6', '1', 'E', 'D', 'A', '0', 'A', 'E', 'E', '4', 'D', '9', '0',
    'A', 'F', '5', 'A', '8', '9', 'E', 'E', '5', '8', '8', '1', '4', 'A', 'C', '4',
    '7', '5', 'B', '9', 'B', '1', 'B', '2', '9', '8', '8', 'D', '4', 'D', '6', '7',
    '5', 'D', '0', '8', 'C', '9', '2', 'E', '6', '9', '0', '7', '9', 'C', '3', 'D',
    '2', '8', '6', '7', '1', 'E', 'A', 'C', '6', 'C', 'F', 'E', '2', '5', '2', 'E',
    'F', '1', '6', '1', '7', '5', '1', 'E', '5', '5', '5', 'D', 'A', '6', '3', 'F',
    '5', 'E', '0', '1', '2', '9', 'F', '7', '9', '2', '9', '3', 'E', '0', 'C', 'B',
    'C', '7', '1', '9', '4', 'B', 'F', '1', 'A', 'D', '4', 'A', '1', '6', '0', '2',
    'A', '6', 'E', 'E', '5', '3', '4', '9', 'F', 'E', '6', '4', '5', '5', 'B', 'E',
    '5', '1', 'C', 'B', 'D', '8', 'C', '7', '8', '6', '5', '8', '2', '3', '0', 'F',
    '7', '9', '3', 'F', '7', 'C', 'C', '5', '1', '7', '4', '5', 'F', 'E', 'F', 'B',
    '0', '3', '7', '2', '7', '1', '2', 'E', '3', 'B', '7', '7', '7', '1', '4', '1',
    'A', 'C', '1', '3', 'C', '4', 'A', '5', '3', 'A', '3', 'C', '7', 'D', 'E', 'E',
    'F', '2', '2', '2', 'D', '6', '0', '6', '3', '8', '5', '7', '1', '8', '7', '6',
    '5', '1', 'A', '8', '5', 'A', '2', '2', 'E', '5', '0', 'E', 'C', '7', 'A', '6',
    '5', '3', 'F', 'C', 'A', '6', 'D', 'B', '7', '4', '1', '9', '6', '4', '0', 'E',
    '3', '2', '3', 'D', '3', 'A', 'E', '8', 'B', '0', 'D', '3', '6', '7', 'C', 'A',
    'F', 'C', 'C', 'D', '1', '9', 'B', '3', '3', '2', '9', '0', '4', '8', 'E', 'E',
    '4', '3', '9', '2', '5', '5', '7', 'C', 'B', 'F', '8', 'C', 'E', 'F', 'C', '3',
    '1', '4', '2', '3', '7', '5', '5', '9', '4', 'D', '5', '5', '0', 'C', '9', 'F',
    '4', '7', '9', '4', '6', 'F', '5', '7', 'C', '5', 'B', '2', '3', 'E', '3', 'B',
    '4', '0', 'E', 'A', 'C', '6', 'E', '5', '4', '3', 'F', '4', 'E', '9', 'B', '1',
    'C', '2', '2', '5', '2', '3', 'A', '6', 'E', '9', 'C', '7', '7', '3', 'D', '5',
    '2', 'E', '7', '0', '7', '9', 'F', '1', '9', 'C', '0', '8', '0', 'F', '7', '4',
    '6', 'A', 'B', '3', '0', 'C', 'B', 'D', 'C', '1', 'A', 'B', 'F', 'F', '6', '1',
    '4', 'F', '3', '4', '4', '3', '2', '2', 'A', 'C', 'A', '5', '7', '3', 'E', '3',
    'E', '7', '8', '9', '0', '3', 'E', '0', 'E', '8', '4', '2', '9', '9', '0', '8',
    '0', 'F', 'D', '2', '6', '6', 'B', 'B', '4', 'A', '1', '2', 'F', 'C', '6', '4',
    'B', 'E', '4', '7', '2', '7', '9', 'B', '1', '8', '0', 'B', 'D', 'F', '6', 'A',
    'D', '0', 'B', '1', 'C', 'E', 'A', 'A', '9', '8', '9', 'E', '5', 'A', '3', '1',
    '7', '6', 'C', '9', '4', '0', 'C', '7', 'F', '3', '8', 'C', '8', '1', 'D', '1',
    'A', '4', 'E', '5', '1', '3', 'A', '1', 'F', 'D', '8', '8', '7', '3', '9', 'D',
    '4', '8', '6', 'F', '3', '5', '1', '7', '2', 'F', 'B', 'B', '2', '0', '8', 'C',
    'E', 'D', 'C', '6', 'C', 'C', '7', '2', 'F', '7', 'C', 'C', '5', '6', 'C', 'E',
    'E', '5', '0', '8', '3', '8', '8', '0', 'E', '7', '8', 'A', '4', 'E', 'E', 'B',
    'E', 'E', '5', '6', 'C', '6', '3', '0', '5', '3', '9', 'B', 'B', '1', 'A', 'B',
    'A', '5', '9', 'A', '0', '4', '9', '1', '5', 'B', 'F', 'B', '4', '8', 'C', 'E',
    '5', '3', '5', 'C', '5', '2', '7', '0', '3', '8', '0', 'C', '8', 'B', '0', 'C',
    '9', 'A', 'C', 'B', 'F', '3', '7', '0', '6', '0', 'A', '7', '9', 'C', 'E', '8',
    'E', '8', '6', '3', '7', '7', '5', '7', '0', '9', '8', '4', '1', '2', 'B', '4',
    'D', '2', '9', 'D', 'C', '5', 'B', 'C', '7', 'A', '1', '9', 'C', '8', 'C', 'A',
    '3', 'E', 'B', '4', 'A', '6', '7', '9', 'E', '1', '2', '3', '2', '8', 'C', '2',
    'C', '4', '8', '7', 'C', 'A', '2', '0', 'D', '2', '7', '5', '1', '3', '7', '7',
    '2', '4', '0', 'B', 'C', 'A', '5', '3', '5', '3', '2', '2', 'A', 'F', '1', 'B',
    '2', '7', '1', '5', '6', '3', 'F', '7', 'E', 'B', 'E', '2', 'F', '8', '8', 'D',
    'C', 'F', '2', '7', 'D', '6', 'C', '8', '9', 'F', '8', 'C', '3', 'D', '0', 'B',
    '7', '3', '5', 'B', '4', '8', 'F', '1', '6', '8', '9', '7', '4', 'E', '7', 'A',
    'E', '4', 'F', '8', '5', '3', '9', 'F', 'A', 'A', '2', '8', '2', 'D', '4', '1',
    '0', 'C', 'A', 'C', '4', '0', '3', '2', 'A', '0', 'E', '0', '2', 'F', '0', '0',
    'D', 'B', 'E', 'A', 'E', '1', 'D', 'E', '6', '7', '7', 'F', '0', '3', '5', 'C',
    '9', '2', '7', '5', '3', 'C', '7', '5', 'E', '1', '6', '9', 'B', 'F', '0', '0',
    'E', '9', '2', '4', '7', '8', '6', '0', '8', '4', 'D', 'E', '2', '5', '1', '9',
    '4', '9', '2', '2', '1', '6', 'A', 'D', '9', 'F', '7', 'C', '5', '4', 'B', '6',
    'D', '4', 'A', '7', 'A', '2', '7', '9', 'D', '1', 'F', '3', 'A', 'D', '0', 'B',
    '3', 'A', 'D', 'A', '3', 'A', '9', 'E', 'D', '5', 'F', 'A', 'A', 'B', '4', 'C',
    'A', '3', 'A', '0', '7', '7', '7', 'B', 'C', '8', '0', '0', 'A', '3', '8', '6',
    'C', '0', '1', '9', 'A', 'C', '8', 'D', '8', '7', 'F', 'E', '5', 'D', '7', '3',
    '6', '1', '4', '5', 'D', '0', '1', '4', '5', 'A', 'A', '1', 'E', 'E', 'E', 'F',
    '3', '2', '9', '0', '0', 'F', '4', 'F', 'B', 'A', '3', '1', '5', 'E', '8', '5',
    '5', '5', 'E', '9', '6', 'F', '9', '3', 'E', '6', '6', '3', 'F', '1', 'C', 'B',
    'E', '7', '9', '0', '9', 'F', 'D', '6', 'D', '6', '2', 'C', 'A', '5', '5', '4',
    '7', '4', '3', '1', '9', 'E', 'C', '6', 'B', 'D', 'F', 'F', '5', 'E', '4', '9',
    '5', '3', '8', '0', 'F', 'C', '9', '5', 'C', '8', 'F', 'B', '5', 'C', '1', '4',
    '6', '1', '7', '6', 'D', 'B', '0', '8', '3', '3', '5', 'D', '2', '4', 'C', '9',
    'B', 'A', 'F', 'A', '7', '4', '7', '2', '0', '6', 'D', 'F', '3', '2', 'F', 'F',
    '0', 'A', 'C', 'C', 'D', 'B', 'E', '1', '2', '1', 'A', '2', 'C', 'B', '7', '9',
    'B', 'F', '7', '9', '7', '8', 'B', 'D', '4', '4', '3', 'F', '0', '3', '3', 'E',
    'F', '9', '1', '1', '4', 'C', 'E', '9', '0', 'C', '6', '8', 'F', '5', '0', '9',
    'E', 'A', '9', '8', 'E', '0', '6', '1', 'E', 'F', '1', '8', '6', '7', '0', 'E',
    'C', 'D', 'D', 'A', '1', 'C', 'D', '0', '3', '1', '6', '0', '3', 'A', 'E', '3',
    '7', '9', '8', '9', '4', 'A', '2', 'F', 'D', '9', 'B', 'B', 'B', '7', 'E', 'C',
    '4', 'A', 'F', 'C', '7', 'F', 'B', 'C', 'F', '6', '9', 'C', '1', '4', '8', '8',
    '1', 'E', 'D', '0', 'F', '5', 'E', '4', '6', '1', '4', 'C', '4', '8', '6', '1',
    '8', 'B', 'A', '9', 'D', 'D', 'F', '2', '6', 'C', 'C', '9', '0', 'B', '3', '7',
    '1', 'C', '0', 'B', 'B', 'C', '8', '7', 'B', 'C', '8', '1', 'F', '8', 'F', '8',
    '1', '4', 'D', '8', '6', '3', 'C', 'D', '4', 'C', '4', '3', 'D', 'D', '0', '4',
    'D', '4', '1', '2', '8', 'A', '7', '8', 'B', '6', '1', 'E', 'E', '4', '2', '1',
    '6', '4', '5', 'D', 'C', '1', '0', 'B', 'F', '6', '3', '0', 'D', 'D', 'C', 'B',
    '1', 'C', '9', '9', 'D', '7', 'B', 'B', '3', '8', '9', '0', 'C', '0', '6', '2',
    '7', '9', '3', '4', '5', 'D', 'E', '6', '3', '4', '0', '9', '4', '8', '8', '5',
    '5', 'C', 'F', '6', '9', '6', '6', '9', '5', '4', '8', '0', '1', '4', '8', '0',
    '1', '5', '9', 'D', 'F', 'F', '4', '4', 'C', 'E', '4', '2', '3', '6', '8', '0',
    '9', '3', '0', 'B', '0', 'E', '1', '5', '1', 'F', '1', '1', 'E', '0', '2', '1',
    'D', '0', 'F', 'E', 'D', '0', 'E', '6', '3', '2', 'A', 'F', 'E', '5', '5', '4',
    '0', 'F', 'B', '3', 'D', '6', 'F', '3', 'D', '0', '4', 'D', '6', '0', '8', 'D',
    '4', '2', '8', '8', '8', '2', '6', '7', '7', 'B', '7', 'E', '6', '7', 'A', '6',
    '8', '8', '0', 'D', '5', 'D', '9', '6', '9', '2', '8', '7', 'E', 'D', '4', '4',
    'F', '0', 'F', '0', '0', '5', '1', '2', 'F', '8', '6', '2', '4', '3', '6', '5',
    '1', '7', 'B', '6', 'C', '8', '6', 'A', '7', '1', '5', '6', 'E', 'B', 'D', '5',
    '0', 'E', 'E', '5', 'F', '6', '1', '8', 'B', '5', '5', '1', '7', 'F', 'C', 'B',
    '6', '5', 'C', '3', 'C', 'D', '0', '6', '6', '1', '1', '2', '7', '4', '8', '6',
    'F', '9', '4', '7', '2', '2', 'E', '3', 'A', '7', 'D', '2', 'C', '5', '3', '5',
    'E', 'F', '2', '9', '5', '4', '4', '0', '1', 'A', '6', 'E', '4', '3', '3', '4',
    '6', 'E', 'D', 'A', '8', '0', '1', '0', '8', '3', '0', '6', 'C', '3', '5', 'A',
    '8', 'E', '7', '4', '2', '4', '3', 'F', '6', 'A', '0', '1', 'A', 'C', '8', '2',
    '4', '2', '9', 'D', 'B', 'F', '6', '5', '9', '1', 'A', 'C', '0', 'F', '3', 'B',
    'C', '2', 'E', '7', '1', '3', '2', '5', '5', '9', '3', '5', '5', 'A', '1', '6',
    '6', 'E', 'C', '2', 'A', '5', 'F', '0', 'B', '5', '5', '1', 'E', '9', 'C', '9',
    'B', '6', '4', '4', '0', 'B', '1', '7', '5', '3', 'C', '0', 'F', 'C', '0', 'D',
    'E', 'F', '3', '2', '7', '0', '5', '0', '7', '5', '6', '2', 'B', '2', '2', '6',
    '2', '4', '6', 'D', '6', '6', '2', 'A', '8', '9', '5', '5', 'D', '2', '1', '3',
    '1', 'A', '8', '7', '2', 'F', 'C', '9', '4', 'D', 'C', 'E', 'F', '2', '0', '3',
    '4', '9', 'E', 'F', 'B', '7', '8', 'B', '2', '1', '2', '0', '9', '2', 'F', '6',
    '4', 'C', '5', '2', '8', '8', '6', '3', '1', '0', '8', 'A', 'B', '2', 'B', 'A',
    'C', '5', '3', '3', 'F', 'A', '8', '5', 'F', 'D', '3', '0', '3', '6', 'B', '2',
    '7', 'C', '6', 'C', 'A', '8', 'C', 'F', '0', 'B', '5', 'A', '3', 'C', '3', '5',
    '8', '8', '4', '6', '1', 'A', 'C', '1', 'D', '1', 'B', 'F', '4', '5', '0', '1',
    '4', '1', 'F', '1', 'B', '1', 'C', 'F', '9', 'D', '0', '0', '1', 'A', '1', 'C',
    '1', 'B', '1', 'A', '2', '6', 'F', '6', '4', '1', '4', 'F', '8', '8', '8', 'F',
    '4', '5', '2', '7', 'E', '8', 'B', 'E', '0', '2', '9', 'E', '1', 'E', '1', '6',
    'E', 'E', 'F', '6', '3', 'C', '6', '6', 'A', '0', '6', 'E', '1', '3', '7', '4',
    '4', 'A', '3', 'D', 'F', '5', '0', '3', '3', '7', '7', '1', '6', 'E', '7', '3',
    '7', '6', 'B', '5', '3', 'A', 'C', 'C', 'A', '6', '0', 'D', 'D', '6', 'B', '3',
    'C', '5', '1', '2', 'D', 'D', '1', '8', '5', '7', '9', '3', '9', 'D', '7', '6',
    'F', '9', '4', '0', '2', '7', 'C', '2', 'D', '7', 'F', '8', 'C', 'E', '4', 'A',
    '5', 'C', '1', 'A', 'C', 'B', '4', 'B', '8', 'F', 'F', '5', '4', '2', '6', 'C',
    'E', '4', 'C', '3', 'F', 'C', '5', '8', 'A', '0', '8', '6', 'B', '0', '5', '7',
    'C', '8', '7', 'F', '2', '0', '3', '3', '2', 'C', '4', 'F', '3', '0', '7', 'D',
    '8', '0', '0', '2', '6', '9', '4', '7', '6', 'D', '4', 'E', '9', '9', 'D', '5',
    'F', '6', '7', 'E', '8', '7', 'E', '8', '8', '5', 'C', '9', 'B', 'D', '5', '3',
    'D', '0', 'C', '5', 'A', '6', '4', 'C', 'C', '4', 'D', 'E', '7', '5', 'A', 'C',
    'F', '9', '8', '6', 'A', '9', '7', '8', 'A', 'A', 'C', '3', 'A', '8', 'C', 'E',
    '8', '8', '6', '4', '3', 'C', '1', '8', '5', 'A', '6', '6', '4', 'F', '7', 'B',
    '7', '0', 'C', 'F', '5', '7', '4', 'B', '2', '6', 'F', '2', 'F', 'D', '2', '0',
    'C', 'B', '3', '9', 'E', '2', '4', '8', '6', 'D', '2', '9', '3', '2', '5', '7',
    '2', '2', '7', '3', '6', '4', '8', '1', '2', '6', '5', '6', '6', '8', 'F', '4',
    'E', '2', 'C', '8', '1', '0', 'E', '7', 'E', 'A', '9', 'D', 'B', 'A', 'A', '6',
    '4', '8', '8', '9', 'B', '8', '4', '8', '4', '7', 'A', 'C', '2', '7', 'B', '7',
    '9', 'A', 'D', 'C', 'C', 'A', '2', '7', '7', '3', '8', '6', 'B', 'B', 'E', '4',
    '9', '1', 'C', '3', '8', '1', '5', '5', 'F', 'B', 'E', 'D', '1', 'A', '6', '0',
    'E', 'D', '6', 'C', '6', 'F', 'A', '8', 'A', 'D', 'C', '1', 'D', '3', 'F', '3',
    'A', 'A', '0', 'A', 'E', '7', '9', '6', '7', '0', 'B', '8', 'C', 'C', '9', 'B',
    'B', '0', 'E', 'C', '7', '2', 'A', '7', '6', '5', '5', 'A', 'D', 'B', 'A', 'D',
    '6', '6', 'D', '2', 'B', '7', '2', '3', '2', 'C', '9', 'A', 'E', '1', '5', '0',
    '4', 'B', 'A', '6', '0', '9', 'C', '3', '1', '6', 'B', '6', '0', '7', 'D', 'E',
    'E', '9', '3', 'A', '4', '8', 'F', '2', '0', 'D', 'E', '3', 'C', '5', 'C', '4',
    '2', '4', '7', '8', '0', '8', 'E', '8', '4', 'C', 'D', 'B', '7', 'B', '7', 'C',
    '9', 'F', '5', '4', '1', 'A', 'A', 'F', '5', '0', '7', '6', '9', 'E', '4', 'C',
    'A', 'E', '7', '4', '1', 'B', '8', '9', '7', '3', 'A', 'C', 'C', '2', '2', 'A',
    '3', '2', 'E', '3', 'F', '9', '1', '2', '6', '8', 'C', '7', 'F', 'E', '0', '6',
    'B', '8', '2', '4', '1', 'D', 'F', 'A', '2', 'B', '8', '9', 'B', '6', '4', '0',
    '5', 'D', '6', '2', '3', '1', '3', '3', '1', 'C', 'E', 'C', '4', '6', '3', '4',
    '7', 'D', 'A', '6', 'C', 'D', '5', '1', '4', '2', 'A', '6', '4', '1', '9', 'F',
    'F', 'B', '3', '7', '1', 'C', '4', '8', 'E', '3', '6', 'E', '2', '6', '9', '3',
    '6', '4', '8', '8', '7', '3', 'F', 'A', '7', '7', '2', '4', 'F', '8', 'E', '8',
    '3', '8', 'F', '6', '6', '6', 'C', 'E', '9', '2', '2', '5', '6', 'B', '4', '0',
    'D', 'F', '2', '4', '5', 'C', 'B', 'B', 'F', 'A', '3', 'D', '1', '7', 'B', '7',
    '3', 'F', 'F', '7', 'B', 'C', '4', '4', '3', 'B', '6', '5', '2', '1', 'E', '8',
    '6', '4', 'F', '0', '0', 'D', '0', '2', '5', '5', 'D', 'B', '8', '1', '5', 'C',
    '3', 'F', 'C', 'D', '7', '5', '5', '6', '3', '9', '5', 'B', '1', '4', '8', '9',
    'F', '4', '5', 'F', '3', '9', 'C', 'A', '8', '2', '9', '9', '0', 'E', 'B', '2',
    '1', '7', '2', 'E', 'E', '6', 'C', '8', 'B', 'C', 'E', '2', '6', 'B', 'A', 'D',
    '2', '9', 'A', '5', 'B', 'D', '8', '5', '7', 'D', '0', 'A', '7', 'D', '8', '0',
    '8', '3', 'D', 'F', '9', '8', '4', 'C', '7', 'D', '0', '5', '7', '4', 'C', 'F',
    'D', '2', 'B', '1', '8', '0', '7', '8', '1', 'C', 'F', 'B', '7', '8', 'D', '6',
    '2', 'C', 'B', 'D', '3', '4', 'A', '3', '8', '8', '9', '7', '1', 'B', '8', '4',
    '7', 'B', 'F', '9', '1', 'E', 'E', '2', 'B', '1', 'F', '0', 'E', '2', 'D', '0',
    '4', 'E', '0', 'E', '6', 'A', '4', '4', '0', '2', '7', '8', 'D', '7', '2', '0',
    '2', 'C', 'B', '9', '5', '0', '4', '5', 'C', '0', '3', '9', 'D', '4', 'D', '3',
    '8', '1', 'B', '5', '2', '8', '7', '3', '5', '9', 'C', '6', '5', 'B', 'A', 'A',
    '4', 'E', '4', '3', '4', '6', 'B', '1', '7', '9', '6', 'E', 'F', '4', '2', '2',
    '4', 'E', 'C', '3', '9', '8', '2', '9', 'C', 'C', '5', '0', '4', '9', 'C', '4',
    '3', 'D', 'F', '7', '8', '3', '5', '0', '2', '1', 'A', 'B', '8', '3', '1', '0',
    'C', '1', '5', '8', '6', '8', '0', 'B', 'B', '4', '7', '2', '8', 'D', 'B', '2',
    'E', 'E', 'F', 'A', '7', '2', 'F', '5', 'C', '8', 'B', 'A', '5', 'D', 'C', 'C',
    'E', '3', 'B', '1', 'C', '2', '1', 'F', '3', 'C', 'C', '2', '3', 'B', '6', '6',
    '2', '2', '9', '8', '0', 'E', 'F', 'C', '8', '2', '7', '6', '4', '5', 'A', 'D',
    '8', 'D', '5', '8', 'E', 'D', '0', 'D', '3', '4', '0', '6', 'C', '0', 'F', '7',
    '0', '3', '0', '8', 'F', '6', '8', 'B', 'B', '4', '8', '0', '6', '2', '7', 'A',
    '0', 'D', '9', 'E', '5', '7', '5', 'D', 'D', '3', 'B', '4', '8', '3', '1', '9',
    '2', 'B', 'D', '7', '5', '4', '1', '0', 'B', 'F', 'D', '2', 'B', 'F', '6', '4',
    '7', '0', '6', '6', 'C', '5', 'C', '6', '0', '2', '2', 'F', 'E', '1', '3', 'C',
    '5', 'F', '3', '6', '9', '8', 'B', '8', 'D', '9', 'F', 'F', 'C', '4', '5', '3',
    '9', '8', 'F', '6', 'B', '1', 'A', 'E', '2', '7', '5', '5', '3', 'F', '0', '1',
    'D', '1', 'A', '7', '8', '7', '3', '8', 'B', '2', 'B', 'A', '6', '6', '0', '9',
    '3', 'A', '2', 'B', '5', 'E', '3', '7', 'D', 'D', 'F', '2', '2', '9', '2', 'F',
    'A', '8', '4', 'D', 'C', '0', '0', 'B', 'B', 'E', 'E', '3', 'C', 'B', 'A', '1',
    'C', 'D', '2', '0', '9', 'E', 'E', '8', '8', '7', 'F', 'F', '8', 'B', '5', '4',
    '0', 'C', '3', '7', '9', '7', 'E', 'C', 'D', '2', 'B', '8', '0', '7', '1', '4',
    '4', '9', '2', '0', '7', '9', '4', '0', '9', 'A', '0', 'B', 'F', '5', '1', '5',
    '0', '1', 'D', '1', '7', '2', '9', '6', 'F', '0', '5', '6', 'E', '1', '3', 'C',
    'D', '8', '1', '5', 'C', 'E', '0', '8', '6', '2', '9', 'F', 'B', '0', '2', '1',
    '9', 'E', 'F', 'F', 'B', 'B', '2', 'B', '9', '6', 'B', '7', '0', 'D', 'D', '6',
    '4', '4', 'E', 'C', 'A', '9', 'D', 'F', '5', '5', 'F', 'A', '2', '1', 'E', '2',
    '7', 'A', '5', '0', 'A', '8', 'E', '1', 'F', '3', '6', 'C', 'F', 'B', 'B', '4',
    '5', 'A', 'A', 'A', 'F', '5', '0', 'A', 'E', '8', 'E', '4', '5', '4', '2', '7',
    'E', '3', 'D', '9', '2', '6', 'E', '7', '4', '6', 'A', '6', '2', 'D', '7', '6',
    'B', 'F', 'D', '0', '0', '6', 'C', '5', '5', '3', '4', '9', 'B', '6', 'A', 'B',
    'D', '4', 'D', '4', '5', '1', '7', '0', '5', 'A', '1', 'F', '1', '1', 'B', '9',
    '1', '0', '5', '8', '2', 'B', '1', '1', 'A', '4', '2', '0', '3', '8', 'E', '9',
    'E', 'F', '5', 'E', '4', 'A', '4', 'E', '5', 'B', '5', '1', '2', '5', 'E', 'E',
    'D', '9', '6', 'D', 'D', '8', '4', '1', '0', 'D', '8', 'C', '6', '9', 'A', '6',
    '7', 'D', '6', '6', 'B', 'B', '2', '1', '8', '7', '9', '0', '0', 'D', 'C', '0',
    '6', 'B', '5', '7', '8', '4', '2', '9', '3', 'D', '8', '6', '6', '2', 'D', 'B',
    'B', '8', '5', 'C', '0', '5', '8', '4', 'A', 'B', '8', '6', '2', 'E', '2', '8',
    '1', '2', '4', '5', '2', '8', 'A', '1', 'A', '1', '9', 'F', '8', '6', '1', '1',
    '6', '0', '3', 'E', '5', '7', '9', '8', 'B', 'D', '2', '2', '6', '7', 'E', '6',
    'C', 'E', 'A', '4', '0', 'C', 'E', 'E', '7', '9', '5', 'E', '0', 'E', 'C', '1',
    '2', '7', '6', '5', '8', '2', '9', '2', '1', '9', 'F', 'A', 'E', 'F', '5', 'E',
    '8', 'D', '0', 'B', '3', '6', '0', '0', 'A', '9', 'D', 'A', '2', 'C', '3', '0',
    'E', '3', 'C', '5', 'F', '5', 'B', '8', 'C', '1', '1', '1', '4', '0', '2', '6',
    '8', '5', '3', '3', '5', '5', '4', '8', 'D', '2', '4', '2', '7', '1', 'E', '4',
    '9', '2', '5', '2', '7', '4', '1', 'C', '6', '4', 'A', '5', '7', 'B', '1', 'F',
    'E', 'F', 'C', '3', '8', 'F', '2', '3', '5', '0', '9', '3', 'D', '0', 'A', '5',
    '7', '0', 'A', '9', '8', '1', 'B', 'A', 'E', '1', '4', '7', '6', '0', 'B', '0',
    '9', '8', '7', '1', '4', 'B', 'B', '0', '3', '5', 'B', '7', '9', 'F', '0', 'A',
    'D', '0', 'B', '4', '7', 'D', 'E', '4', '5', 'E', 'F', '1', 'F', 'D', '3', '0',
    'A', '8', '3', '6', 'A', '0', '5', '6', 'D', '2', '2', '1', '0', '5', '0', '4',
    '9', '0', 'F', '6', '3', '2', 'F', 'B', '0', '2', 'F', '6', 'A', 'A', '1', '3',
    '4', 'A', 'E', 'D', 'E', '5', 'C', '4', '0', '8', 'D', '9', '0', '9', '7', '6',
    'E', '3', '8', 'A', 'C', '6', '3', '5', 'A', 'C', '2', '1', '3', '9', 'C', '7',
    '8', 'B', 'D', '4', 'B', '4', '2', '8', '8', 'C', '2', 'B', 'D', 'E', '1', 'B',
    'B', '9', '5', '3', '1', '3', '9', 'F', '2', '3', '1', '9', 'D', 'B', 'B', '5',
    '1', '3', '3', '5', '3', '7', '5', 'F', 'A', '0', '8', '4', '6', '1', '2', '6',
    '1', 'B', '8', '7', 'C', 'D', 'C', '2', '4', 'F', '6', '3', '4', 'F', '3', '1',
    '1', '0', '0', 'F', '0', 'C', 'F', 'F', '9', '8', '2', 'D', '5', '9', 'D', '7',
    'C', '3', '8', '7', '9', 'A', '5', '3', '9', '4', 'C', '4', 'A', 'B', '9', '3',
    'D', '2', 'D', '7', 'D', '8', '7', 'A', '5', 'C', 'E', '4', 'E', 'F', '1', '3',
    'B', 'D', 'D', 'F', 'E', '3', '7', 'F', '2', '7', 'D', 'E', '6', '9', '8', 'F',
    '3', '3', 'C', '4', 'A', 'D', '3', '2', '9', 'D', 'D', 'C', 'C', '2', '6', '4',
    '1', '7', '1', 'D', '5', '7', 'F', '1', '7', 'C', '7', '7', 'F', '0', 'A', 'D',
    'C', '4', '6', 'C', '3', 'E', 'E', '0', '9', 'F', '9', '7', '6', '6', '2', 'A',
    '3', 'B', '2', 'C', 'C', 'C', '5', 'C', 'F', '4', 'E', '2', '2', '7', '7', 'A',
    '1', '1', '8', '0', '8', '8', 'D', '4', '5', '8', 'D', 'A', '1', '9', 'F', '4',
    'E', '4', '8', '4', '4', '0', 'D', '1', 'C', '3', '0', 'A', '6', '6', '8', 'D',
    '7', '1', '6', '7', '3', '9', '5', '2', '8', 'D', '5', '1', '0', '9', 'E', 'F',
    'E', '9', 'F', '2', '4', 'F', 'C', 'B', '1', '6', 'C', '3', '4', 'A', '5', 'F',
    '2', 'D', '7', 'D', 'A', '3', 'C', 'D', '4', '2', '8', '2', 'A', 'E', '9', 'F',
    'D', '0', 'A', '9', 'A', '9', '5', 'E', '3', 'F', '8', '1', '5', '7', '5', '7',
    'E', '7', 'A', '3', 'F', '1', '2', '0', '9', '8', '9', 'C', 'D', 'D', '9', 'F',
    'A', 'A', 'E', 'C', '1', '2', '8', 'B', 'A', '5', '4', '1', '1', '7', 'A', '1',
    '6', '8', '1', '5', 'A', 'F', 'B', '1', '5', '7', '7', 'C', 'E', '7', 'E', '2',
    '2', 'B', '3', '7', '0', '3', 'C', 'F', 'A', 'F', '4', '5', '7', 'F', 'E', '4',
    '8', 'E', 'C', '9', '5', 'C', '1', '6', 'C', 'C', 'F', '8', 'A', 'A', '6', 'D',
    '3', 'E', '8', '3', '8', 'B', 'F', '4', 'F', 'B', 'F', '0', 'D', '2', '7', 'B',
    'C', 'D', 'A', '3', '1', '6', '8', 'F', '0', '2', '0', '8', 'F', 'E', 'C', '1',
    'F', 'A', '0', 'B', '0', '9', '0', '4', 'A', '7', '4', 'B', '2', '5', '8', '5',
    '7', '0', '7', 'A', '8', 'E', '1', 'A', '2', 'C', 'B', '8', '2', 'B', '1', '1',
    'A', '1', '0', '2', '4', 'C', '9', 'D', '9', 'A', '9', 'A', 'B', '9', '6', '7',
    'F', '1', '4', 'A', '1', '4', 'A', '9', 'E', '8', '2', '0', '4', 'C', 'D', 'D',
    '7', 'E', '1', 'F', '4', '1', 'B', '4', '6', 'A', '9', '7', '0', '7', 'D', 'B',
    'F', '3', '6', '5', '7', 'C', '6', '0', '3', '2', '6', '2', '4', 'A', '9', '5',
    'A', '7', '4', 'A', '5', '5', 'C', 'F', '1', 'C', 'B', '0', '9', 'F', '1', '5',
    'B', '8', '1', '0', '6', '4', 'A', 'A', 'F', '6', '7', '3', 'A', '1', '7', '9',
    '2', 'A', '6', 'D', '7', 'D', '2', '4', 'B', 'F', '0', '2', 'E', '5', '9', '0',
    '5', '5', '7', '4', '7', '2', '2', '3', 'A', '9', 'C', 'C', '2', 'A', '6', 'A',
    'B', 'B', '1', '9', '6', '9', 'F', '8', '1', 'D', '6', 'E', '9', 'B', '4', 'C',
    '5', 'F', '8', '4', 'D', '9', 'F', '2', 'B', '2', 'D', '5', '0', 'F', '0', '7',
    '4', '5', '2', '0', '7', '0', '2', '4', 'D', '0', '9', '6', '8', '8', '9', '1',
    'B', '5', '4', 'A', 'B', '7', '5', '4', '7', '6', '8', 'E', 'F', '6', 'C', '0',
    'F', '5', 'A', '2', '0', '7', 'A', '4', '7', 'D', '1', '3', 'E', '3', '4', 'A',
    '3', '8', '5', 'A', 'E', '9', '7', '2', '1', 'F', 'A', 'B', 'D', '1', '1', 'F',
    '9', 'E', '7', 'A', 'F', '9', 'B', 'F', '7', '9', '5', '4', 'F', '2', 'A', '5',
    '1', '5', '3', 'A', 'C', '4', '2', '7', '6', '7', 'C', '3', '9', 'C', '2', '4',
    '0', 'B', '8', 'D', 'E', '4', '4', 'F', '8', '3', '5', '6', '8', '3', '1', 'A',
    '3', '6', 'B', 'B', '6', '5', '7', 'D', '0', '6', '9', '9', 'D', 'C', '9', 'E',
    'D', '3', 'C', '5', 'E', '6', '1', 'A', '2', 'C', 'A', '2', 'C', 'C', '8', '5',
    '9', 'D', '3', '5', '3', '0', 'E', '6', '2', '3', '5', '9', '7', '4', 'F', '3',
    'B', '2', '2', '7', '0', 'E', '1', '7', 'A', '4', 'E', '8', 'A', 'B', 'C', '9',
    'B', 'C', 'D', 'B', '0', '8', 'C', '1', 'D', '2', 'E', '5', '9', 'F', '9', '8',
    'C', '2', '4', 'B', '9', '9', 'D', 'D', 'A', '1', '3', '6', 'B', '6', 'C', '0',
    '6', 'E', '7', 'A', '6', '4', '3', '8', '6', 'B', 'B', '5', '4', '0', '1', 'E',
    'B', '6', '5', '9', 'C', '1', '9', '0', '4', '0', 'F', '4', '3', 'B', 'E', 'D',
    'A', '0', '8', '1', 'F', 'D', '4', '0', '4', '8', 'E', '9', '5', 'F', '3', '2',
    '3', '4', '4', '8', 'D', '7', 'F', 'B', '8', '8', 'A', 'B', '3', '3', 'A', '3',
    '2', '6', '6', '1', '1', 'A', 'C', '4', 'B', 'D', '6', 'F', 'B', 'C', 'B', 'D',
    '1', '9', '8', 'D', 'D', '4', '0', '4', '2', 'D', 'B', '6', 'F', 'E', '1', '5',
    '7', 'D', '6', '0', 'A', '2', 'C', 'A', '9', 'D', '6', '9', '7', 'C', 'A', 'F',
    '6', '7', '9', '2', '1', '5', '8', '6', '1', 'D', 'D', 'E', '5', '5', '0', 'E',
    '2', 'B', 'C', '8', '4', 'A', '6', '9', '5', 'E', '9', '4', 'C', '3', '9', 'A',
    '7', 'B', '6', '0', 'F', 'C', '0', '8', '8', '9', 'D', 'E', '7', '2', '4', '6',
    '7', '7', '1', 'C', 'D', '3', '6', 'C', 'B', '5', 'B', 'C', '2', 'B', '4', 'E',
    '6', 'D', '5', '9', '8', 'A', 'D', '3', '6', 'F', 'A', '8', '3', '2', '0', 'D',
    '8', '0', '7', '5', 'B', '5', '4', '6', '0', 'C', 'A', '9', '8', '1', 'E', 'D',
    '1', '6', 'D', '6', '0', 'B', '7', '9', '1', '8', 'D', '8', '6', 'F', '2', 'B',
    '7', '4', '6', '3', '6', '9', 'F', 'B', '2', 'C', '5', '2', '1', '3', '7', 'C',
    '8', 'B', '7', '9', 'A', 'F', '1', '2', 'F', '9', '1', 'B', 'B', 'A', 'F', '9',
    'E', 'E', '0', '6', '5', '9', '3', '5', 'D', '7', 'C', 'E', '6', '7', '2', '4',
    'E', '2', '8', '0', 'C', '4', '7', '3', 'E', '5', '7', 'C', '4', '5', 'B', '8',
    '3', 'A', '7', '6', 'B', 'B', '5', 'B', '6', 'D', '7', '3', '4', '2', '3', '2',
    '7', '4', '8', '3', 'B', 'C', '9', 'F', 'D', '4', 'F', '1', '8', 'B', '6', 'F',
    '6', 'C', '6', '8', 'B', '1', 'E', '3', '1', '0', '3', 'A', '8', '9', 'A', '5',
    '3', 'F', '9', '7', 'B', '3', '8', '7', '0', 'A', '4', 'A', '8', 'E', '7', 'A',
    '9', '4', 'A', '2', '9', '3', '4', '8', 'F', 'B', 'D', 'A', 'E', 'C', 'E', '3',
    '2', '6', 'A', 'F', '6', '3', 'F', 'F', '1', '6', 'E', '9', '3', 'B', 'E', '0',
    'A', '5', '9', '6', '0', '9', '5', 'A', '3', 'D', '0', '2', '3', '5', '7', '8',
    '7', 'F', 'A', '1', '3', '1', '5', '1', '4', 'D', '3', '2', '7', '2', 'F', '8',
    '5', 'A', 'E', '0', '4', 'C', '4', '6', 'F', '2', 'D', 'D', '4', 'E', 'E', 'E',
    '5', 'C', 'C', '4', 'D', '1', '1', '5', '0', 'C', 'D', 'E', '0', '9', '1', '0',
    '2', 'D', '6', '7', '1', '0', '4', '9', 'A', '7', 'D', 'B', '7', '7', 'D', '1',
    'B', '6', '4', '3', '8', '9', 'C', '9', '1', '7', 'E', '7', '4', '8', 'A', '9',
    '8', 'E', '7', '5', '8', '0', '4', 'F', '5', '0', '8', '0', '7', 'C', '3', '7',
    '6', '0', 'F', 'F', '1', '5', '0', 'C', '3', '7', '1', '4', '9', '4', '5', '9',
    'B', '8', '5', 'E', '5', '0', '1', 'B', 'F', '6', '2', 'E', '4', '7', 'F', 'C',
    'C', '9', 'C', '2', '7', 'A', 'C', '5', '0', '3', '1', '1', '0', 'F', '4', '2',
    '3', 'F', '6', 'F', 'F', '4', 'E', '8', '1', '3', '8', '4', '7', '3', '0', '5',
    'A', '7', '4', '3', 'E', '5', '0', 'C', 'F', '0', 'E', 'E', 'C', 'B', 'A', '5',
    '5', '6', '8', '2', '3', 'E', '5', 'B', '8', '7', '9', '6', '3', '7', '9', 'B',
    'F', '2', '3', 'E', '2', '4', '9', 'D', '9', 'C', 'E', 'C', '2', '3', '1', '3',
    'F', '1', '9', '0', 'D', '8', '0', '5', '5', '0', 'A', 'E', '2', '8', '6', '3',
    '5', '0', '3', '0', '2', '5', '3', '9', '7', 'F', '2', 'D', '2', 'E', 'E', '8',
    'C', '8', 'E', 'A', 'A', '7', '6', '6', 'B', '2', '6', '3', '5', '4', '2', '9',
    '8', '2', '8', '7', '4', '8', '0', 'A', '2', '3', '7', '4', '9', 'F', '1', '9',
    '1', '6', 'C', 'A', '3', '6', '7', '4', '2', '1', '8', '5', 'A', '4', '8', '3',
    'C', '4', '2', '2', '7', 'C', '2', '0', '3', 'E', '7', '7', '5', '6', '8', '9',
    'B', '6', '7', 'E', '0', '7', '6', '9', '9', '9', '5', '0', 'B', '7', 'D', '5',
    '1', 'A', 'A', '8', '9', '2', '4', '6', '8', 'D', 'E', '6', '1', 'B', 'B', 'A',
    'A', '1', '7', 'A', 'C', '3', '7', '2', '1', '6', 'C', 'D', '5', 'A', '0', '6',
    '9', '9', '9', '8', 'E', '3', '1', '4', 'B', 'F', 'D', '3', 'B', '2', '0', '1',
    '5', 'D', '9', '7', '7', 'D', 'D', 'E', 'E', '1', '8', '9', '3', '2', 'E', '7',
    '8', '5', '1', '8', '5', 'B', '5', '8', '2', 'C', '9', '6', '9', 'C', '5', 'B',
    '9', '7', '2', 'A', '7', 'F', '3', '9', 'B', '9', 'E', 'A', '6', 'B', '9', '1',
    'F', '5', '2', '2', '1', 'D', 'D', 'E', 'F', 'E', '7', '0', 'C', '4', '1', '9',
    '6', '6', 'C', '4', 'E', '8', 'D', '7', 'E', '3', '7', 'A', '7', 'D', 'E', '2',
    '4', '4', 'B', '9', '9', 'D', '0', '9', '5', '2', '5', 'A', 'B', '9', '8', '4',
    '1', '6', 'F', 'C', '4', 'E', 'F', '2', 'A', 'F', 'F', '2', '5', '7', '4', '0',
    '0', '3', '0', 'B', '9', 'F', 'B', '0', '2', 'A', 'E', '9', '4', 'F', '9', '6',
    '0', '0', '3', '2', '1', '6', '6', 'F', '3', 'D', 'C', '3', '7', '1', '7', '5',
    'B', '1', '9', '2', 'F', '3', 'F', '0', '3', 'F', '8', '9', '6', 'A', '4', '4',
    '8', 'E', '1', 'F', 'B', '2', 'E', 'A', 'D', '0', '7', 'A', '0', '6', '3', '8',
    'E', 'E', '2', '2', '6', '6', '6', 'F', '1', '1', 'F', '6', 'C', '3', '0', '4',
    'E', '1', '8', '0', '6', '8', '2', '2', '9', '8', '9', 'D', 'C', '2', 'E', 'D',
    '1', 'C', '0', '0', 'A', '6', 'C', '2', '1', 'B', '8', '5', '5', 'E', '7', 'D',
    '5', 'C', '3', '8', '2', '4', 'A', '6', '2', '6', 'B', '8', '3', '7', '4', '0',
    'A', '6', '8', '1', '7', 'A', '2', '3', 'D', 'F', 'C', '6', 'F', '4', 'D', 'A',
    'C', 'E', 'A', 'B', 'F', '7', 'E', 'E', '1', '7', 'E', '6', '8', 'D', '7', '8',
    'B', '2', '2', '4', '8', '3', '9', 'B', '6', '7', '1', 'B', 'B', '5', 'B', 'D',
    '4', '9', '0', 'C', 'B', '8', '1', '3', 'C', 'E', '2', '0', '3', '6', '7', 'B',
    '7', '3', '6', 'F', 'C', '9', '9', '4', 'B', '4', '9', '9', 'F', '0', '4', '5',
    '1', '2', 'E', '4', '5', '7', 'A', '6', '2', 'D', 'D', 'D', '1', '8', '8', '6',
    'C', '4', 'B', '5', 'B', '5', 'D', 'E', '2', '8', 'E', '8', '5', 'A', '4', '6',
    'B', '9', '1', 'B', '1', '5', '7', '0', '6', '3', '9', 'D', '0', '5', 'F', '9',
    '6', 'E', 'B', '8', 'B', 'B', '5', 'F', '6', 'E', 'A', 'E', '3', '0', '9', 'E',
    '9', 'C', 'F', '1', '8', '9', 'D', '1', 'A', 'A', '2', '5', '1', '8', '3', 'C',
    '6', 'C', '5', 'A', '4', 'E', 'C', 'E', 'E', 'B', '8', 'D', '2', '8', '3', '8',
    'C', 'E', 'E', 'F', '1', '3', '9', 'F', '7', 'C', '1', '6', '9', '3', 'C', '3',
    'C', 'D', 'A', '2', 'F', '5', 'D', '9', '5', '6', '3', '8', '3', '9', 'F', '2',
    '3', 'F', 'A', '4', 'C', '3', '5', '5', '3', 'D', 'C', '7', '4', '3', '0', '0',
    'C', '3', '9', '0', '9', '9', '6', '7', 'E', '8', '3', '4', '0', '4', 'C', '5',
    'B', '2', '0', '3', '2', '9', 'D', '1', 'A', '2', '2', '9', 'C', '4', '4', '9',
    '0', 'B', '2', 'F', '1', '4', 'D', 'C', '8', 'B', 'B', 'E', '3', 'C', '9', '9',
    '9', '8', '8', 'F', '7', '1', 'A', '0', '4', 'B', 'C', 'B', 'B', '3', '7', '3',
    '7', 'A', 'B', '5', 'E', 'B', '8', '1', 'A', 'C', 'F', '5', '6', '4', 'F', 'D',
    'C', 'D', '3', 'B', '4', 'A', '6', 'C', 'D', '4', '2', 'A', '9', 'A', 'E', '8',
    '8', '3', 'D', '4', 'E', '5', 'B', '9', 'F', '6', 'E', '5', 'A', '0', '8', 'B',
    '3', '1', '9', '6', '7', '3', 'A', 'D', 'A', '7', 'D', '6', '5', 'A', 'E', '4',
    '2', '2', 'C', 'F', '2', '6', '2', 'E', '9', '5', '3', '6', '9', 'E', 'F', '5',
    '4', '0', '3', '3', '6', '9', '9', '7', '9', '8', '3', 'E', '3', 'C', 'E', '3',
    'D', 'C', '8', '8', '5', 'C', '7', '9', '4', '1', '3', '4', '8', '5', '1', '2',
    '0', '0', 'F', 'E', '4', '0', 'A', '1', 'E', 'E', '5', '4', 'A', '7', '5', '8',
    '3', '6', '0', 'E', '6', '6', 'E', 'D', 'C', '5', '2', '6', '6', 'C', 'D', 'B',
    '7', 'A', '8', '5', 'F', '7', '0', '6', 'E', '8', 'D', '3', 'C', '8', '6', 'B',
    '1', '4', 'C', 'F', '7', '1', '5', '2', '9', 'C', 'C', '8', '6', '8', '4', 'A',
    'B', 'D', '5', 'A', '4', 'C', 'D', 'C', 'E', '3', 'A', '6', 'F', 'A', '0', '8',
    '8', 'B', '7', '7', 'A', '8', '8', 'A', '1', '0', '7', '3', '1', '9', 'B', 'C',
    '7', 'B', 'C', 'B', '1', '2', 'B', '5', 'C', '4', '7', '5', '9', '7', 'D', '4',
    'F', '4', 'E', 'E', 'F', '8', 'B', '3', 'B', '1', '1', 'B', 'E', 'F', '9', '2',
    '3', '3', 'D', 'D', 'C', '5', '9', 'F', '8', '8', 'A', 'E', '6', 'D', 'E', 'D',
    '1', 'F', 'A', 'E', '8', 'F', '5', 'F', 'C', '3', '5', '0', 'B', '2', 'C', '6',
    '0', '5', 'A', '3', '7', '8', '9', '6', 'A', 'A', '8', '8', '4', '0', '3', 'E',
    '3', 'D', '1', '0', '5', '3', '2', '3', 'E', 'E', '1', 'A', 'B', '4', 'C', 'F',
    'B', '2', '4', '4', 'D', '8', 'E', '3', 'B', '7', 'C', '5', 'C', 'F', '4', 'E',
    'C', '9', 'E', '0', 'F', '3', '0', '8', '5', 'D', '9', '9', '0', 'B', '6', '5',
    'E', '5', '1', '7', '3', '4', '7', 'B', 'D', 'B', '9', '5', '9', 'A', '2', '2',
    '4', '1', '5', '8', '6', 'D', 'E', 'B', 'D', 'A', 'E', '9', 'B', 'B', '3', '4',
    '9', '3', 'B', '6', '4', '6', '2', '6', '2', '1', '1', 'A', 'F', '4', '7', '0',
    '0', '5', '6', '5', '1', '8', '4', 'A', 'B', '3', '2', '5', '2', 'D', '6', 'E',
    'A', '8', 'A', '9', '6', '6', '7', '0', '2', 'E', 'B', '0', '4', '6', '2', '9',
    'A', '4', '2', 'B', 'E', 'E', 'B', 'C', 'E', '5', '1', 'F', 'E', '6', 'F', '7',
    'E', '9', '9', '7', '7', 'C', '6', '7', 'D', '3', 'E', 'F', '9', 'A', 'B', 'E',
    '3', 'E', '5', '1', '2', '8', 'D', 'A', '5', '7', 'D', '6', '1', '3', '9', 'C',
    '8', 'D', '2', '3', '1', '2', '7', '1', 'E', 'A', '9', '3', '8', '2', '8', '6',
    '9', '5', '2', 'C', '4', 'B', '8', 'F', '5', 'A', 'B', 'D', '1', 'F', '2', '0',
    '5', '4', 'C', 'F', 'E', '9', '4', 'B', '6', '8', 'F', '2', '8', 'E', 'B', '0',
    '5', 'E', 'E', 'C', '3', '2', 'F', '6', '8', '0', 'B', '2', '5', '2', '9', '2',
    '7', '1', '8', '3', '4', '4', 'B', 'E', 'A', '8', 'A', 'E', '3', '8', 'E', '3',
    '1', 'B', 'F', '4', '4', '7', '1', '7', '0', '9', '5', '6', '6', 'B', '9', '1',
    '4', 'F', 'F', 'E', 'F', 'C', '2', 'C', '9', 'F', '2', 'E', '0', '6', 'A', '5',
    'E', '4', '9', 'C', 'D', '2', '1', '4', '7', 'C', '8', '4', '6', '8', 'B', '3',
    'C', '9', 'D', '5', 'C', '1', '5', '3', 'A', 'C', 'F', '4', 'F', 'C', '0', '3',
    'D', '9', '4', 'A', '9', '6', 'C', '9', 'B', '3', '9', '2', 'B', '5', 'A', '4',
    '2', '1', 'E', '7', '5', 'C', '0', 'C', '4', 'E', '1', 'C', '9', '8', 'B', '8',
    '3', '5', '7', 'A', 'A', '8', '6', '3', '6', 'E', 'D', '0', '3', '5', 'E', 'C',
    '8', '7', 'B', '2', '5', 'D', '2', '4', '1', 'E', '0', 'C', '2', '8', 'A', '5',
    '5', 'B', 'F', 'A', 'A', 'D', '4', '6', '2', '1', '2', 'C', 'A', 'C', '2', 'F',
    '3', '3', '7', '5', '6', '3', '7', '9', 'A', 'B', '4', '0', '5', '7', '3', '0',
    '6', '7', '6', '0', '3', '0', 'C', '1', '3', 'F', 'A', 'F', 'B', '9', '0', '9',
    '9', '9', 'B', 'A', 'C', 'C', 'B', '9', '7', '2', 'C', '2', '9', '6', '4', '3',
    '4', '5', '9', 'D', 'D', '1', 'B', 'B', '5', 'E', '9', '6', '5', '5', '7', 'B',
    'E', '1', 'F', 'B', 'F', '5', '2', '0', '2', '6', 'C', '5', 'D', '1', 'D', '4',
    'A', '2', 'A', 'E', 'C', '1', '6', '5', '9', '5', '2', 'B', '8', '3', 'E', '8',
    'D', '9', '2', '2', '3', 'B', '3', '4', '3', '4', 'F', '0', '8', '5', '0', '5',
    '2', '5', 'A', 'B', '8', '1', '6', '5', 'A', '3', 'A', 'A', 'F', '8', 'E', '2',
    '6', '0', '8', '8', '2', '5', '4', 'A', '3', '8', '6', '9', 'D', '7', '5', '3',
    '0', '0', 'C', 'F', '7', '1', '9', '0', '1', '2', '2', 'B', '4', '7', '5', 'D',
    '4', '3', 'F', 'C', '3', '0', '1', 'C', '8', 'E', '7', 'C', '5', 'E', '2', '7',
    'C', '2', 'E', '8', 'C', 'C', '5', 'F', '8', '4', '6', '3', 'D', '0', 'D', '7',
    '9', '6', '6', '6', '0', '1', '3', '9', 'A', '7', '3', '3', 'B', '1', 'D', '6',
    '2', 'D', 'B', 'E', '5', '9', '3', '5', 'F', 'E', '0', 'F', '5', 'D', '8', 'E',
    'A', 'B', '6', '0', '0', '2', '1', '2', '4', '9', 'D', 'F', 'F', 'D', '3', '9',
    'B', '7', '7', '5', '8', '6', '8', '0', '5', '2', 'B', 'F', '9', '1', 'E', '3',
    '0', '4', 'E', '9', 'B', '9', '5', '3', 'E', 'D', '7', '2', '0', '8', '4', 'A',
    '9', '6', 'E', 'E', '3', '5', '1', '5', '0', '3', 'D', '7', 'A', '3', '8', 'B',
    'D', '1', '7', 'E', '1', '1', '2', 'C', '8', '6', '7', '5', 'A', '5', 'C', 'D',
    '6', '0', '0', '1', '4', '0', '7', '0', '8', 'B', '6', '4', '6', 'D', '3', '2',
    '7', 'B', 'F', '5', 'F', 'B', '2', 'F', '0', '8', '9', '3', '6', '5', '0', '5',
    'B', '5', '3', '8', 'A', '3', '4', '4', '3', '7', '1', '1', 'C', '2', 'E', '2',
    '2', '2', '8', 'A', '5', '3', '2', '5', '1', '1', '5', '7', '9', 'A', 'B', 'F',
    '0', 'C', '2', '7', '9', '0', 'C', 'C', 'E', 'F', 'D', '5', '3', 'B', 'A', '6',
    'C', '3', 'B', '6', '9', '0', '4', '4', '8', '8', '4', '7', '9', 'C', '1', '7',
    '8', 'A', '3', 'A', '3', '7', '4', '5', '5', 'C', '5', '5', '7', 'C', '6', 'B',
    'B', 'A', 'A', 'F', 'D', 'C', '6', 'A', '4', '1', '1', '7', '1', '8', '6', 'F',
    'B', '0', 'B', '2', 'C', 'D', '8', '0', 'F', '8', '0', 'C', '9', 'D', 'D', '8',
    '1', 'B', '6', '6', '9', 'B', '5', '4', '8', 'A', '2', 'A', '0', '2', '1', '0',
    'A', 'D', 'B', 'F', '9', '1', '7', '5', '4', 'A', '7', '9', 'F', 'A', '5', 'A',
    '6', '5', 'F', '4', '9', '1', '5', '5', 'C', 'A', 'E', 'C', 'F', '4', '4', 'C',
    'C', '8', '9', '2', 'E', 'D', 'D', 'C', 'F', '6', 'E', '3', 'B', 'B', '7', '8',
    '8', '8', 'A', '6', 'B', 'A', 'D', 'E', '8', '4', 'D', '7', 'F', '8', '5', '2',
    '8', 'F', '4', '7', '2', '4', 'D', '8', 'B', '9', '0', '7', 'D', '0', '5', '6',
    '4', '2', '7', 'D', '8', '9', 'D', 'D', 'E', '2', '3', '8', '6', 'F', '5', 'C',
    'A', '8', '2', 'B', '0', 'B', 'B', 'A', '7', 'E', '4', 'A', '4', '9', '9', 'F',
    '5', 'A', '0', 'B', '5', '8', '1', '5', '2', 'D', 'F', 'B', '5', 'D', '5', 'F',
    'B', '5', '5', 'A', '4', '9', 'E', 'D', '7', '9', '5', 'D', '1', '5', 'E', '9',
    '3', '6', 'B', '5', 'C', '1', 'F', '4', '6', '7', '6', 'B', '6', '3', '6', '7',
    '2', '5', 'B', '9', 'F', 'D', '6', 'E', '6', '4', 'D', '5', '0', '6', 'D', 'D',
    '9', 'C', 'A', '4', 'F', '4', '5', 'E', '2', '5', '0', '5', '9', '1', 'C', '8',
    'A', '7', 'F', '0', '9', '3', 'E', 'F', '4', '1', '5', 'B', 'E', 'E', '9', 'A',
    '3', 'C', '3', 'B', '2', '5', '9', '1', 'A', 'D', '2', '7', 'E', 'D', 'B', '8',
    'B', '8', 'E', 'A', 'C', '0', '2', '4', '8', '4', '7', 'E', 'E', '3', '5', '9',
    'D', '9', 'E', '4', '2', 'B', 'A', 'C', 'F', '3', '9', '7', '0', '6', 'C', 'A',
    '8', 'B', '1', 'F', 'C', '9', 'A', '5', '8', '6', '4', 'D', 'B', 'C', '8', 'D',
    '9', 'E', 'F', '1', 'F', '0', '5', '4', '0', '0', '8', '3', 'E', '1', '8', '2',
    '9', '5', 'B', 'C', '9', '9', 'F', 'B', '1', '6', 'F', '5', 'F', '3', 'A', '5',
    'B', '9', '0', '7', '6', '0', '5', '5', '8', 'D', 'B', '2', '0', 'B', '3', 'D',
    '2', '1', 'B', 'B', '1', 'E', '8', 'F', '3', '8', '3', 'D', 'D', 'D', 'C', 'F',
    '3', 'D', '2', 'D', '5', '6', 'F', '5', 'F', '3', '1', 'D', '5', '5', 'F', 'C',
    '3', '2', '9', '3', 'B', '3', '3', 'E', '2', '1', '2', '8', '6', '4', '9', '0',
    '5', 'F', 'A', '3', '2', '9', '7', '9', 'D', 'F', 'A', '5', 'B', '9', '8', '5',
    '4', '3', 'F', 'E', '2', '1', '5', '6', 'E', '5', '6', 'C', 'E', '4', 'F', 'D',
    '1', '0', 'F', 'F', '5', '2', '4', '6', 'A', '0', '2', '5', '4', '5', '4', '9',
    'B', '5', '5', 'B', 'E', 'E', 'D', '6', '2', '6', '3', '1', '3', 'C', 'F', 'E',
    '3', 'C', 'A', 'C', '6', 'D', '9', '2', '9', '4', '1', 'D', '0', '1', 'E', 'B',
    '6', '0', '6', 'C', '1', 'C', '1', '8', '3', 'D', '2', '0', '9', 'C', '2', 'F',
    '0', 'F', '3', 'F', '6', '0', '8', 'D', '7', '4', '0', '0', 'D', '7', '1', '4',
    '1', 'E', 'B', 'A', 'C', '8', '1', '8', '1', 'D', 'F', 'D', 'A', '0', '3', 'A',
    'C', '8', '0', '0', '4', '8', '6', '8', 'F', 'D', '9', '6', '2', '1', 'A', '1',
    'F', '9', 'D', '9', 'A', '0', 'D', 'E', 'F', '6', '6', 'C', '1', 'C', '3', '1',
    '9', 'E', '3', '7', 'A', '5', 'B', 'F', '5', '9', '8', '0', '2', 'C', 'A', '1',
    'E', '5', 'C', '9', '4', '7', '1', 'E', 'A', 'F', '5', '1', 'B', 'A', '2', '2',
    '6', '5', '1', '7', '3', '8', '5', '0', '8', '6', '9', 'B', '2', 'F', '6', 'F',
    'E', 'F', 'D', 'F', '1', '1', '7', '5', 'D', '6', 'D', 'A', '8', '3', 'A', '6',
    '8', '5', 'D', 'C', '4', '5', 'C', 'C', '9', '9', '4', '9', '4', '7', '2', '1',
    '6', '5', 'F', 'C', '5', '7', '7', '3', '6', '2', '3', '0', '2', 'A', 'A', 'F',
    'C', '4', '8', 'C', 'B', '6', '5', '1', '0', 'E', '6', 'D', 'C', '2', '2', 'D',
    '0', '0', '5', '5', '1', '1', 'A', 'C', '9', 'E', '5', '2', 'D', '9', '1', '0',
    '2', '5', '8', 'F', 'F', '5', '5', '5', '2', 'F', '2', '9', '4', 'E', '0', '7',
    'C', '0', '2', '1', '7', 'C', '9', '6', '2', 'B', '3', 'E', 'B', '2', '0', 'B',
    '2', 'E', 'F', '1', 'B', 'F', 'F', 'D', 'D', '4', 'F', '9', 'F', 'B', '9', 'B',
    '5', 'B', '4', '8', '7', 'F', '5', '2', '5', '4', 'D', '7', '4', '3', '8', '4',
    '7', '2', '4', 'E', 'C', '5', 'A', 'A', '3', 'D', 'B', '8', '0', '4', 'E', '7',
    '0', '3', '9', '2', '9', '3', '6', 'F', 'D', '3', '1', '4', '1', 'B', '7', '7',
    'F', '1', 'D', '0', 'B', '1', '3', '2', 'F', '9', 'C', '0', '1', '4', '6', '4',
    'E', 'E', '0', '3', '4', '7', '0', 'A', 'B', 'C', '0', '8', 'D', '8', 'D', '7',
    '7', 'B', 'D', '8', '2', '7', '6', '4', 'F', '0', 'F', '2', '2', '1', '6', '6',
    '3', '5', '7', 'A', '9', 'C', '0', 'A', 'A', 'F', 'F', 'A', '1', '4', '3', 'A',
    '0', 'D', '1', '5', 'F', '2', 'D', '2', 'B', 'B', '6', 'A', '4', '0', '4', '9',
    'C', '9', 'B', '9', '7', '5', '2', '2', '1', '6', '9', '4', '4', 'A', 'B', '0',
    '2', '5', '6', 'E', 'B', 'E', 'C', '9', '3', '9', '6', '5', 'D', '2', '3', '3',
    'E', '2', '4', '8', 'C', 'A', 'D', 'D', '1', '9', 'C', '5', '1', '6', '9', '2',
    '7', '7', '6', '7', '8', '9', 'C', 'E', '3', '1', 'B', 'F', '0', '0', 'E', '3',
    '5', 'B', 'C', 'F', '0', '0', '1', '2', 'D', '3', 'E', '0', '4', '1', '5', 'C',
    '9', 'D', 'E', '1', 'F', '3', 'C', 'E', '5', 'D', '2', 'F', '6', 'C', 'E', '3',
    '7', '9', '0', '5', '9', 'D', 'D', '4', '0', '6', '7', '5', '7', '6', '6', '6',
    '3', 'F', '8', '4', '4', 'F', '1', '6', 'C', '4', 'D', '5', 'E', '5', 'B', 'D',
    '3', 'E', '3', 'C', 'F', 'F', '9', 'F', 'A', 'B', '4', 'C', '5', '6', 'E', 'B',
    'D', '1', '0', '4', '1', '7', 'F', 'F', '5', 'F', '2', '8', '5', '2', '7', '2',
    '6', '0', 'E', '9', 'F', 'B', 'C', 'D', 'D', '8', '9', '9', '0', 'A', '8', '1',
    '1', 'A', 'E', '8', '9', 'A', 'E', '5', '4', '7', '6', '4', '6', 'C', 'F', '6',
    '1', '1', 'A', '7', 'E', '0', '3', '6', 'E', 'E', 'F', '7', 'B', 'C', '9', '3',
    '3', 'E', '8', '0', '5', 'E', '0', '2', 'F', '4', '4', '1', '7', '9', 'C', '4',
    '1', '6', 'E', '3', '6', '4', '5', '4', 'C', 'B', '1', '3', '8', 'B', '2', 'C',
    '6', 'E', 'C', 'B', 'E', 'D', 'E', '9', 'A', 'A', 'C', '0', 'E', '8', 'B', '2',
    '5', 'D', 'E', 'D', '1', 'C', '5', 'A', '5', '2', '9', '2', '8', '2', '3', 'B',
    '9', '9', 'B', '5', 'C', '6', '7', '7', 'D', '8', '6', 'D', 'F', '4', '5', '6',
    '5', 'B', 'C', '3', '1', 'C', '5', '5', 'C', '5', '2', 'F', '1', 'E', '9', 'A',
    '6', 'D', 'D', '8', '3', 'F', 'E', 'D', '3', '2', 'F', 'C', 'C', '4', '3', 'F',
    'B', '0', '5', '6', '6', 'A', 'C', '1', '4', '2', '9', '9', '6', '0', 'D', '5',
    '8', 'B', '3', '1', '4', '7', '4', 'C', '1', '3', '9', '9', '8', '5', '3', 'C',
    '1', '7', '9', 'F', '8', 'A', '7', 'A', '8', 'B', 'C', '3', '3', 'B', '3', 'A',
    '3', 'E', '1', '5', '4', '1', '8', '4', '4', 'C', 'F', '2', '4', 'B', '3', '1',
    'F', '8', '0', '7', '8', 'C', 'D', '6', '4', '8', '3', 'E', 'D', '5', 'D', '2',
    'A', 'E', '7', 'E', '2', 'A', 'C', 'D', '9', '8', 'E', 'A', '7', '3', 'A', '1',
    'B', '7', 'C', 'D', 'F', '2', 'C', '3', '4', 'E', '2', '3', '1', 'B', 'A', '7',
    '6', '8', '6', '1', 'F', '6', '3', '4', '3', '9', 'A', 'C', 'D', '1', 'B', 'C',
    '1', 'A', '4', 'F', '8', '4', '8', 'B', '3', '6', '7', 'E', 'D', '3', '9', '6',
    'C', '9', 'D', '8', '1', 'E', '0', '5', '1', '4', '6', '9', '3', '7', '4', '7',
    '7', '6', 'E', '3', '2', 'C', '3', '7', '1', 'C', '6', '1', 'A', 'A', '1', '8',
    '8', '4', '0', 'C', '7', '5', '7', '1', 'C', 'E', 'A', '2', '5', '7', '2', 'D',
    'C', '8', '1', '0', '0', 'A', '6', '2', '4', 'D', 'D', 'A', '4', '2', 'C', '4',
    '5', '6', 'C', '1', '9', 'D', '4', '0', '6', 'E', 'E', '3', '5', '6', 'C', '4',
    '6', '5', '6', 'E', '4', '9', 'D', '7', '4', '6', '0', 'C', 'A', '7', '2', '4',
    '5', '7', '5', 'C', 'A', '4', 'F', 'F', '9', 'C', 'E', '9', '4', '5', '1', '4',
    '6', 'C', 'A', '1', 'A', 'A', '8', '1', '8', '9', '4', '6', '2', '2', 'C', '7',
    '3', '3', '1', '4', '8', '4', '1', 'D', 'E', '7', '3', '5', '6', '9', '9', 'A',
    'D', '6', '2', '2', '7', 'B', '4', '4', 'C', '2', 'C', '3', 'B', '7', 'E', 'B',
    '1', '0', 'D', 'E', 'E', '2', '6', '1', 'E', '6', '4', '1', 'C', 'A', '6', '4',
    'F', 'A', '3', '0', 'D', 'E', '1', '4', '9', 'B', 'C', '7', '3', '1', 'C', 'A',
    'D', '5', 'D', '7', '7', '6', '4', '5', 'D', '4', '9', '0', 'C', 'D', '6', '8',
    'F', 'F', '6', '6', 'C', 'D', '2', '3', '2', '3', '0', 'C', 'F', 'F', '8', '0',
    '5', '4', 'D', '9', 'F', '9', '7', '3', 'E', 'F', '5', '1', '1', '2', 'E', 'B',
    'E', 'C', 'C', '8', '2', 'C', '8', '1', '1', 'A', 'E', 'D', 'C', '8', '0', 'E',
    'A', '3', 'F', 'C', '4', '6', '1', 'C', '2', '6', '5', '8', 'D', '3', '2', '8',
    '8', '6', '8', '2', '2', '5', '4', '8', '7', '9', 'C', '9', '3', '2', 'C', '0',
    '2', '9', '9', '6', '0', '7', '5', '9', '0', 'F', '2', '0', '6', '8', '4', '4',
    'B', 'A', '2', '5', '8', 'C', '0', 'E', '0', '1', 'B', '1', 'F', '2', 'B', 'E',
    '0', '6', 'C', '4', 'B', 'A', '0', 'D', '2', 'F', 'E', '6', '0', 'D', 'F', '6',
    '3', '1', '4', '2', 'A', '9', '3', 'B', '5', '3', '8', '2', 'C', '9', '6', 'A',
    '4', 'F', '5', 'B', '8', '9', '8', '2', '7', '7', 'C', 'D', '4', '8', '4', 'D',
    '8', 'F', 'C', 'A', '6', 'B', 'E', '0', '1', '6', 'E', '7', 'A', '0', '7', '3',
    'E', '3', 'F', '8', 'F', '8', '9', 'A', '0', '1', '9', '7', '2', '7', '4', '9',
    'B', 'E', 'C', '9', '6', '5', 'B', 'E', '6', '3', '7', '8', 'C', '6', 'C', '3',
    '7', '9', 'D', 'A', '2', '2', '5', 'C', 'B', '3', '5', '1', 'D', '5', '1', 'F',
    '7', 'A', '4', '1', '4', '5', '9', '6', '2', '2', '3', '1', '5', '3', '6', 'E',
    '7', 'E', 'B', 'C', 'C', '8', 'C', '9', 'C', '2', '5', 'A', '0', '9', '4', '2',
    'D', '9', '3', '9', '2', '0', 'E', '3', '4', '2', 'A', '2', 'A', '4', 'D', 'A',
    '8', 'D', 'D', 'C', '9', 'F', '0', '3', 'F', 'F', 'F', 'C', '3', '5', '4', 'A',
    '3', '6', '4', 'F', '7', '9', '6', '7', 'D', '5', '0', 'A', 'B', '4', '3', '7',
    'C', '9', '1', 'D', '9', '0', 'D', '4', 'C', 'A', '4', '8', 'E', 'E', '2', '5',
    'E', '4', '2', 'E', '8', '3', '3', 'B', '9', 'E', '5', '4', '4', 'A', '5', '5',
    '3', '5', '7', 'A', 'A', 'A', '8', '9', 'F', '8', '5', '9', 'A', '8', '3', '1',
    '5', '3', '3', '1', '8', '3', 'A', '6', '4', 'C', '0', '2', 'E', 'A', 'F', 'C',
    'A', 'D', '2', '2', 'C', '4', 'F', 'D', 'C', '6', '5', 'A', '0', 'A', '3', '7',
    'B', '6', 'C', '8', '6', 'D', 'F', 'B', '0', '7', '6', '1', '8', 'C', 'E', '1',
    'B', 'F', 'A', '1', '7', 'F', '9', '9', '1', '2', 'F', '7', '2', 'B', '1', '0',
    '2', '6', '6', 'C', '9', '7', '0', '1', '7', 'F', 'D', '8', 'B', '2', 'E', '4',
    'D', '7', 'D', '6', '4', '4', '7', '3', '7', '2', '0', 'A', 'C', 'D', '0', '0',
    '0', '7', 'C', 'B', '8', '9', '0', '1', 'F', '8', '2', '6', '6', '8', 'B', 'F',
    '3', '8', '1', '9', 'B', 'C', '1', 'D', '4', 'E', '5', '9', 'E', '4', 'D', '9',
    '8', '5', 'D', '9', '9', '7', 'B', '9', 'A', '0', '5', '3', '8', 'E', '7', '6',
    '7', 'B', '4', '6', '6', '4', '2', '2', 'F', 'B', '8', '0', '4', '5', '8', '6',
    '9', '6', '6', 'F', '0', 'B', '7', '2', '2', '2', '4', 'C', 'A', 'C', '4', 'A',
    'D', 'B', '8', 'E', 'B', '2', 'E', 'E', '4', 'D', '0', 'C', '4', '7', 'D', '9',
    'B', 'E', '8', '9', 'B', '8', 'A', '6', 'A', 'B', '2', '4', '8', '2', 'E', '6',
    '8', 'D', '3', 'E', '3', '2', '0', '5', '2', '1', '9', '8', 'C', 'A', '5', '0',
    'F', '6', '8', 'C', 'A', '6', '4', 'E', 'B', '0', '0', '3', 'A', '9', '5', 'C',
    'E', '8', '8', 'A', '0', '5', 'E', '9', '0', '8', 'B', '5', '9', 'A', 'B', '9',
    'D', '8', '8', '0', '1', 'F', '1', '4', '6', 'F', '3', '6', 'F', 'B', '3', '1',
    'F', '7', 'F', '7', 'C', '0', '5', '0', '0', '5', '9', '6', 'A', '2', 'C', '8',
    '3', 'A', 'C', '3', '3', '2', '3', 'A', 'B', 'F', 'F', '3', '2', 'B', '2', '3',
    '3', 'E', 'E', 'F', '2', '0', '4', '6', 'F', 'A', '4', '9', '3', '5', 'F', '2',
    '7', '0', '4', '9', '6', '8', '1', 'F', 'B', '3', '1', '6', '2', 'C', '5', '6',
    'C', 'F', 'A', 'A', 'B', '5', '6', '3', 'E', 'F', '2', '4', 'C', 'C', '5', '6',
    '2', '6', '1', 'F', 'B', 'A', 'C', '6', 'E', '0', 'B', '1', 'A', 'B', 'F', '0',
    '9', '2', '1', 'E', 'E', 'D', '5', 'B', '1', '5', 'C', '3', '9', '6', '5', '6',
    'B', 'F', 'E', 'C', 'D', '3', '9', '5', 'B', 'C', '4', '6', 'A', '8', '9', '0',
    '1', '5', 'E', 'F', '3', 'A', 'F', 'A', 'F', '7', '5', '2', 'C', 'A', 'B', 'F',
    '4', 'C', '8', '7', '2', 'F', 'A', 'B', '5', '6', '6', '0', '8', 'A', '9', '6',
    '5', 'D', '0', '9', 'A', '0', '7', 'F', '1', 'E', 'E', '8', '4', 'E', '0', '9',
    '7', 'A', '9', '0', '7', '2', '7', '2', 'B', '2', 'E', 'E', '5', 'D', 'F', 'D',
    '5', '8', '0', '4', '5', 'B', 'D', '5', '9', '3', '5', '8', 'C', '9', '9', '2',
    '7', '3', '4', '8', '4', 'E', '7', '4', '4', 'E', '1', '5', '4', '8', 'D', '2',
    '5', '7', 'A', '4', '4', '6', 'D', 'C', 'A', '2', 'F', '1', '6', '6', '9', 'B',
    '3', '4', '6', '4', '9', 'F', '5', '6', '3', 'F', 'F', '8', 'D', 'D', 'D', '8',
    'E', '7', 'B', '4', 'B', '9', '7', '9', 'C', 'E', '4', '3', '9', '1', 'D', 'F',
    '2', '4', 'A', 'C', '3', 'A', '7', '1', '9', 'C', '7', 'F', '4', '7', '3', 'F',
    '4', '3', '3', 'D', 'C', '1', '0', 'F', '5', '6', '3', '8', '6', 'F', '9', '8',
    '3', '5', 'F', '7', '4', '9', 'D', '5', '0', '1', '0', '8', '5', '4', 'F', '3',
    '8', '4', '3', 'F', '4', '8', 'A', '0', '8', 'E', '4', '3', 'A', 'A', '1', '8',
    'A', '6', '3', '7', '0', '9', '1', 'A', '7', '3', 'B', '6', '8', 'B', '3', '4',
    '9', '1', '1', '5', '6', '2', '9', '4', '6', 'F', '8', '7', '4', 'D', '4', 'A',
    'C', 'B', '7', 'F', '5', '8', 'D', '6', '9', '2', '9', 'B', '6', 'F', 'A', '0',
    '6', 'C', '5', '2', 'F', 'E', '2', '8', '5', '9', 'F', '9', 'A', 'A', 'D', '1',
    '8', 'E', 'A', 'C', '7', '8', 'B', '4', '6', 'C', 'D', 'A', '6', '2', 'D', '1',
    'D', '5', '4', 'C', 'A', '9', 'D', '3', '2', 'F', 'F', 'D', '4', '8', '8', 'E',
    '2', '6', '7', '1', '8', '6', '3', '1', '6', '0', 'A', 'E', 'B', '9', '8', '0',
    'C', 'B', 'B', '5', 'D', '0', '5', '3', '4', 'A', 'C', '8', 'C', '4', '9', 'A',
    '5', 'A', '1', 'A', '5', '9', 'B', '0', '8', '9', '0', '1', 'A', '1', '8', 'B',
    'A', 'C', '4', '3', '8', 'C', 'F', '9', '3', '9', '8', '7', '8', '4', '1', 'E',
    '9', '9', 'A', 'F', '1', '9', 'A', '8', '4', 'C', '9', '3', 'B', 'C', 'C', '1',
    '6', '4', '0', '6', '6', 'F', '9', '6', 'B', '2', '3', '4', 'B', 'F', '9', 'E',
    'E', '7', '1', 'A', 'B', '8', 'A', '6', '4', 'A', '2', 'D', 'B', 'A', 'C', 'E',
    'E', 'A', '3', 'B', '2', '0', '3', '5', '4', 'E', 'A', 'B', '9', '6', 'F', '0',
    '4', 'A', '7', 'D', '0', 'A', '5', '8', 'E', '7', '2', 'E', '2', 'F', '3', '0',
    '4', 'A', '6', '8', '4', '0', '9', 'D', '4', '6', '5', 'D', '1', '7', '9', '4',
    '9', 'F', '5', '1', '4', '9', '7', '0', '6', '0', '4', '7', '8', '4', '5', '1',
    '5', '6', '1', '2', '9', '5', 'F', '4', '5', 'E', '0', '9', '2', '0', '7', '6',
    'E', '2', 'E', 'E', 'E', '0', 'E', '0', '4', '5', '3', '6', '6', 'D', '7', '9',
    '3', '6', '3', '5', 'D', '1', 'A', '7', '3', 'B', '4', '2', 'F', 'C', '6', '5',
    'D', '3', '2', '6', 'C', '4', '7', '0', '9', 'C', '6', 'C', '9', '4', '8', '3',
    'A', 'B', 'C', 'B', 'C', 'A', 'F', 'E', '7', '9', '4', '2', '7', 'E', 'A', 'C',
    '9', '0', '5', '5', '5', 'C', '4', 'C', '9', '7', '7', 'D', '7', '0', '2', '6',
    '7', '3', 'F', '7', 'E', '3', '9', '8', '1', 'B', '3', 'B', '1', '9', '1', 'D',
    'B', '0', 'B', '3', '7', '4', 'D', '4', 'F', '1', '3', '5', '4', 'C', '1', 'F',
    '8', 'B', '4', '7', 'A', '5', '0', '1', '0', '3', 'F', '7', 'C', '5', '7', 'F',
    '9', 'C', 'A', 'F', '3', '9', '2', 'A', '9', '2', 'F', '2', '8', 'F', 'D', 'E',
    '2', '8', '9', '0', '2', 'D', 'C', '4', 'F', '2', 'C', 'C', 'C', '2', '2', '1',
    'E', '8', '7', 'C', 'B', '0', 'C', '5', 'F', 'A', '5', '3', '7', 'A', '7', 'F',
    '3', 'B', '0', 'C', '4', '7', '7', '6', '9', '1', 'D', '0', '3', '9', '1', '3',
    'E', '2', '3', '1', '4', '5', '7', '3', '1', '9', '4', 'F', '1', 'A', '7', '5',
    '8', 'E', '3', '2', 'C', '4', '3', '4', 'A', '5', 'C', '2', '7', '7', 'A', 'D',
    'B', 'C', '8', '2', '2', '6', '2', '4', 'A', 'C', 'F', '3', 'E', 'B', 'E', '1',
    'E', '6', '3', '5', '5', '8', 'D', 'F', '0', '0', 'E', 'B', '6', '3', '4', '1',
    '8', '2', '7', '0', 'A', '4', '9', 'A', 'E', '5', '8', 'D', '4', '1', '9', '7',
    '1', '7', '2', '9', 'F', 'E', 'E', '8', 'B', 'F', '6', '8', '7', '7', 'D', '0',
    'F', 'A', '8', 'A', 'F', 'F', 'D', 'E', 'E', 'E', '7', '3', '1', '0', '3', 'F',
    'C', '3', 'B', '8', '8', '5', '7', '4', 'C', '9', 'B', 'E', 'B', '8', 'A', '3',
    '4', 'C', 'A', '5', 'C', '3', 'F', '1', '1', 'A', '7', '0', '5', '1', '1', 'D',
    '5', 'D', '6', '8', 'E', '9', 'F', 'B', '5', 'C', 'D', 'E', '3', '7', '9', '9',
    'D', '8', '3', '0', '3', '1', '2', 'A', 'F', 'B', '1', '5', '1', 'D', 'D', '9',
    '4', '4', '0', '5', 'C', '1', '7', '0', '7', '6', 'B', 'C', '0', '9', 'A', '7',
    '2', 'D', '1', '8', 'C', 'C', '7', '7', '9', 'E', '3', '0', 'B', '5', 'D', '0',
    '9', 'F', '8', '4', 'E', '2', '3', '4', 'D', 'C', 'B', '5', 'C', '6', 'E', '0',
    'A', '7', 'E', '3', '1', '5', '4', 'A', '7', '5', '9', '0', '8', '7', '8', '5',
    '8', '9', 'D', 'B', '3', 'D', '3', '7', '6', 'F', 'D', 'A', '9', '1', '5', '6',
    '2', 'D', '8', '7', 'B', '7', '7', 'E', '6', 'B', 'D', 'B', '8', '9', '5', '6',
    'A', 'F', 'A', '6', 'F', '3', '5', 'A', '3', 'C', '4', '5', '9', 'E', 'B', '4',
    '2', 'B', '6', 'F', '6', 'D', 'E', '6', '2', 'A', 'B', '7', 'E', 'F', '5', '4',
    'D', '9', 'D', 'E', '6', '1', '5', '5', '9', '5', '2', '5', 'F', 'C', '0', '3',
    'C', '4', '0', '1', '2', '3', '1', '8', '8', 'E', '9', 'F', 'D', '2', 'C', '3',
    'A', '5', '3', '9', '0', '9', '1', '9', 'F', '5', 'D', '9', '1', '3', 'F', 'B',
    'C', 'F', '8', '5', '3', '4', 'B', 'E', '6', 'C', '7', 'E', '0', 'A', '0', '1',
    '6', '3', 'D', 'C', '5', 'F', '7', '9', '3', '5', 'A', 'B', 'A', 'B', 'A', 'F',
    '3', '2', '9', '8', '8', '9', '0', '6', '1', '2', '2', '6', 'C', '0', '5', '4',
    '3', '1', 'A', '6', '6', 'A', '3', 'A', '9', 'C', '8', '9', '3', 'D', 'D', 'D',
    'D', 'E', '8', '6', '1', '9', 'E', '9', '2', '6', '1', 'E', '5', 'F', '4', 'A',
    '4', '2', '0', '6', 'B', 'D', '4', '9', 'D', '5', 'E', '2', '9', '2', 'E', '1',
    'A', '2', '6', '2', '0', '9', '7', '5', '2', '3', '6', '7', 'F', 'B', '5', '7',
    '5', '0', '5', '6', '6', 'C', '6', '3', '4', '0', '2', 'B', 'A', '8', '6', 'E',
    '7', '4', 'E', '6', '2', '6', '0', 'C', '5', 'C', '0', '3', '5', '5', 'A', 'F',
    'D', '9', 'B', 'C', 'F', '9', '9', '1', 'D', 'E', 'B', '2', 'E', '1', 'E', 'B',
    '9', 'B', '0', '3', '2', 'C', 'C', '2', '9', 'B', 'C', '5', 'A', '2', '1', 'A',
    '5', '7', 'A', '2', '6', '4', '4', 'D', '6', 'F', '8', '6', 'E', '2', 'A', 'C',
    '4', 'E', 'A', 'E', '4', '6', 'E', '9', '3', '5', '5', '7', '6', '5', 'E', '9',
    'B', 'F', 'B', 'D', 'E', 'E', '6', '0', 'E', '1', '4', '7', '6', '4', '3', 'D',
    'E', '5', '4', '5', 'B', '2', '4', '8', 'F', 'F', '3', '4', '1', '5', '4', '7',
    '7', '9', '2', '9', '4', '1', '0', 'E', '9', 'C', 'C', '2', '1', '2', '7', '8',
    '1', '3', '2', '7', '4', 'B', 'B', '9', 'D', '3', '2', '5', '4', 'C', '0', 'B',
    'E', '6', '8', '0', '3', 'F', '1', 'B', '1', '8', '6', '9', '4', '1', '5', '0',
    'A', 'C', '0', 'C', '7', '0', '5', '8', '2', 'A', 'F', '7', 'C', '4', 'E', '0',
    '3', 'F', '5', '2', 'C', 'D', '7', '2', 'B', '8', '9', '2', 'D', 'B', 'E', '7',
    '3', 'D', '9', '1', '8', '7', '9', 'A', '6', '2', 'E', 'F', '9', 'B', '2', '6',
    '6', '8', '3', 'D', '7', 'B', '4', '8', '1', '7', '6', '7', '6', '8', '9', '5',
    '9', '0', '0', '0', 'B', 'B', '9', '2', '3', 'F', '2', 'A', 'E', '8', 'B', '4',
    'C', '2', '5', '2', '3', 'E', 'E', '7', '9', '3', '0', 'E', '7', '9', 'D', 'F',
    'A', 'C', '0', 'F', '2', 'E', 'B', '3', 'D', '0', 'A', '6', 'B', '1', '0', '6',
    '7', '6', '3', 'F', '8', 'D', '2', '3', 'A', 'A', '0', '1', '0', '1', '1', 'F',
    'E', '4', '1', '7', '8', '1', 'B', '4', '6', 'F', '0', '8', '7', 'F', 'A', 'E',
    'A', '8', '4', '4', '9', 'F', '1', 'B', '7', '2', '8', '2', '4', 'B', '1', 'E',
    'F', '5', 'E', '2', '9', '5', 'B', '5', '6', 'E', 'B', '9', '7', 'B', 'E', 'A',
    '1', '0', 'F', 'D', '4', '8', '2', '5', '7', '6', 'F', '7', '5', '4', 'F', 'A',
    '8', '7', '9', 'A', '6', '1', 'E', '1', '9', '5', '8', '2', 'D', '4', 'E', 'A',
    '6', '2', '5', '0', 'A', '0', 'E', 'A', 'A', 'E', 'A', '0', '8', 'C', '1', '6',
    '7', 'B', '1', 'A', '0', 'C', 'C', 'E', '2', 'C', '8', '2', '9', '1', 'B', 'E',
    'A', 'D', '1', '1', '8', '2', '7', '4', '0', '7', 'A', '7', 'F', '7', '0', '7',
    '7', '1', 'D', '5', '0', 'D', '7', '3', 'A', '6', 'F', '7', '6', 'C', 'E', 'D',
    '2', '3', '0', '1', 'C', 'D', '4', 'E', 'A', 'E', 'F', 'F', '9', '1', '8', '5',
    '7', '7', 'C', 'F', '6', 'A', '5', '6', '0', 'E', '6', '5', 'A', '5', '2', '4',
    '4', '1', 'B', '7', '0', '2', '3', 'F', '6', '5', 'A', '4', '3', '2', '8', '0',
    '7', 'B', '1', '5', 'B', '6', 'D', '5', '3', 'C', '1', '9', 'E', 'F', '0', 'D',
    '2', '7', 'B', 'A', '3', '8', '6', '6', '2', '4', 'A', '9', '7', 'F', 'D', '1',
    'F', '9', 'A', 'C', '4', '3', 'C', 'B', '7', '1', '0', 'D', '7', '8', '6', '6',
    'A', 'B', '0', 'B', 'C', 'B', '7', '1', '8', '0', 'A', 'C', '1', '2', '0', '9',
    'B', '7', '7', '1', '6', '0', 'D', '0', '0', '1', '7', '0', '1', '1', '4', '9',
    'D', '2', '7', '3', '1', 'A', '5', '4', '2', '3', 'B', 'E', '1', '6', '2', '4',
    '0', 'C', 'C', '7', 'B', '4', '7', '3', '7', 'E', '3', 'D', 'A', '7', 'F', '5',
    '5', 'D', '7', '2', '9', '9', 'F', '5', '9', '7', 'C', 'F', '6', '7', '0', '9',
    '1', '0', '8', 'D', '6', '8', '2', 'D', '2', 'C', '5', 'A', '0', '3', 'F', '1',
    '3', '1', 'C', 'F', '8', '7', 'C', '0', 'F', 'F', '5', 'D', '6', 'F', '5', '1',
    '4', 'B', 'C', '2', 'F', '6', '7', '4', 'D', 'E', 'D', 'F', 'F', '7', 'B', '7',
    '4', 'D', '1', 'D', 'C', '9', '7', 'E', '9', 'A', 'E', '5', '7', 'C', '6', '0',
    '8', '2', '4', 'E', 'A', '1', '8', '5', '2', '0', 'F', '7', '8', 'B', '6', 'F',
    'A', 'A', '3', '6', 'C', '9', 'C', '5', '2', 'C', 'B', '1', 'F', 'D', '9', '1',
    '4', 'B', '0', '7', 'D', 'D', 'A', '4', '6', '6', '4', 'D', 'F', 'A', '4', '0',
    '0', '6', 'D', '1', 'B', 'A', '8', '3', 'F', 'F', '4', '5', '1', '1', 'E', '8',
    '2', '7', '5', 'C', '0', '9', '3', 'A', '7', '5', 'C', '5', '2', 'F', 'F', '9',
    'E', 'C', '2', 'F', 'F', '7', '4', 'A', '8', '3', 'A', 'E', '2', 'E', '6', '7',
    '8', 'D', 'D', '3', '5', '1', 'F', '2', '0', 'C', '5', '6', 'B', '5', '4', 'D',
    '7', '9', 'B', '2', 'C', '5', '8', 'A', '6', 'A', '9', '5', 'E', '6', 'E', '7',
    'B', 'E', '9', '2', 'E', '4', '0', 'C', '5', '5', 'F', 'C', 'F', '4', '9', '8',
    'F', 'E', '7', 'E', '7', 'A', '3', '8', '1', '2', 'D', '8', '8', '0', 'D', '5',
    '6', '6', 'A', '4', 'A', '4', '9', '1', '2', 'D', '4', '6', '4', '9', '0', '8',
    'C', 'A', 'C', 'F', '4', 'F', '5', '8', '3', '6', 'D', 'E', '1', '5', '1', '2',
    '3', 'E', '8', 'A', '5', 'A', '6', '1', '6', '8', '4', '4', '7', 'B', 'C', '6',
    '8', '4', '9', 'E', 'F', '1', 'A', '8', '1', 'B', 'D', '7', '8', '0', '0', '2',
    'E', '7', 'A', 'A', '0', '0', 'C', '1', 'B', 'F', '4', '6', '3', 'A', 'E', 'F',
    '1', 'F', 'D', 'E', '0', '4', 'E', '7', 'B', 'C', '1', '7', '7', 'D', '9', 'E',
    '3', '5', '8', 'F', '7', 'A', '4', '3', 'F', '0', 'E', '1', '2', 'D', 'E', '9',
    '1', '5', '3', 'F', '7', '5', 'D', 'F', '0', '9', '8', '8', '5', 'E', '9', 'B',
    '6', '0', '0', 'F', '6', 'C', 'F', 'B', '8', '9', 'A', '3', 'D', '2', 'D', '1',
    '4', 'A', '7', 'A', 'B', '0', 'C', '7', 'C', '6', '8', '9', '8', 'B', 'D', '2',
    '5', 'F', '4', '8', '9', '2', '0', 'C', '8', 'E', 'D', 'B', 'E', '8', 'A', '3',
    '5', 'A', '1', 'E', 'A', '7', 'F', '5', '4', 'F', '3', '3', '8', '9', '5', '2',
    '5', 'F', 'F', '5', '8', 'D', 'E', 'C', '7', 'A', '3', '0', 'C', 'E', '7', '8',
    'A', 'F', '4', 'B', '8', 'E', '1', 'B', 'A', 'F', '8', 'B', '0', '9', 'F', 'E',
    'E', '1', '3', 'B', 'A', '9', '6', 'A', 'C', '0', '3', '7', 'A', '6', '3', 'F',
    '2', '8', 'F', '5', 'C', '9', '7', '8', '6', 'C', '5', '1', '2', '4', '6', '3',
    '6', '5', 'E', 'D', 'F', 'F', '4', '9', '7', '9', '6', '8', 'C', '5', '5', '7',
    '3', 'B', '6', '1', '9', '4', '2', 'B', '6', 'C', 'E', '6', 'B', 'E', 'B', '2',
    '6', '6', '0', '0', 'B', 'C', '6', '3', '0', 'D', '0', '5', 'D', '9', '9', '6',
    'C', '5', '7', 'A', 'B', 'D', 'F', '2', 'B', 'B', 'B', 'E', 'A', '6', '0', 'B',
    'C', '6', 'B', 'F', '4', '2', 'E', '7', 'D', '3', 'B', '2', '0', '5', '5', 'F',
    'E', '1', '3', 'F', 'F', 'F', 'F', '7', 'E', 'A', '8', 'E', '2', 'C', 'B', '3',
    'A', '8', 'C', 'B', 'A', '9', '5', 'A', 'D', 'F', '6', 'A', 'F', 'C', '9', '0',
    'F', '5', 'D', '0', 'F', 'D', 'B', '0', '5', 'B', 'B', '5', 'A', '6', 'F', '3',
    '6', 'E', '0', '7', '4', '2', 'E', 'B', '0', 'A', '7', '7', '8', '5', '3', '9',
    '1', '2', 'D', '1', '4', 'F', 'E', 'E', '6', 'F', '3', 'D', '5', 'D', 'B', '7',
    '1', '8', 'F', 'A', 'E', 'F', '3', '6', '9', '2', '8', 'D', 'B', 'C', '1', '0',
    '0', '3', '9', 'C', 'B', '0', 'F', 'C', '3', 'E', 'F', 'E', 'E', 'D', '5', '9',
    '2', '9', '5', 'B', '0', '7', '1', '5', 'D', '8', 'A', '1', 'E', '3', '2', '7',
    '7', 'A', '8', 'C', '2', '9', '4', 'C', 'E', 'C', 'E', 'E', '5', 'C', 'B', '0',
    '4', '1', '5', 'D', '9', '2', '1', 'D', '3', '2', '7', '4', 'E', '5', '7', 'B',
    '2', '9', '4', 'C', 'C', 'D', 'F', '6', '5', '4', 'E', '1', '9', '9', '2', '8',
    '8', '8', '1', '8', 'C', '7', '9', '3', 'B', '7', 'B', '8', '0', '4', 'B', '2',
    'B', 'B', 'D', 'F', 'C', 'F', '3', '9', '2', 'F', 'C', '5', 'A', 'D', '4', '6',
    'D', 'E', '6', '4', '2', 'A', 'A', '9', '8', '8', '3', '8', 'F', 'C', '1', '0',
    'B', '0', 'C', 'B', 'B', 'C', 'B', 'A', '5', '8', 'C', 'D', '8', '0', '5', '0',
    '0', '6', 'A', '9', 'B', 'E', '6', '8', '2', 'E', '2', '8', 'D', 'C', '6', '1',
    'A', 'D', 'B', '0', 'B', 'B', '7', '6', 'C', 'E', 'A', 'C', '6', '6', 'C', 'B',
    '6', 'B', '3', 'F', 'F', 'D', '7', 'D', '3', '9', '1', 'D', 'E', '2', '0', 'C',
    '4', '1', '5', '9', 'C', '3', '9', '9', '4', 'E', 'E', '3', 'D', '7', '7', 'D',
    '1', '7', '8', '0', '8', '3', 'E', '0', 'C', 'E', '1', '7', '9', '9', 'F', 'E',
    '7', 'D', '1', '7', '6', 'C', 'B', 'D', '2', 'F', 'E', '5', '6', 'B', 'E', '7',
    '6', '6', '2', '2', '7', 'E', 'F', 'A', '0', '5', '5', '3', '2', 'B', '0', '2',
    '9', 'B', 'C', 'F', 'D', '8', '8', 'F', 'B', '0', 'D', 'E', '3', '5', '7', '5',
    '1', '5', '7', '6', '0', 'C', '2', '1', 'F', '3', '7', '7', '3', '2', '3', '8',
    '6', '2', 'E', '1', 'B', '1', '6', '9', '8', 'A', '2', '9', 'A', 'B', 'F', '7',
    'D', 'C', 'D', 'E', '3', 'C', '4', '2', '3', '1', 'D', '0', '0', '6', '1', '1',
    'C', '5', '6', '6', '3', '5', 'B', 'E', '4', 'D', 'B', '7', '3', '2', '6', '4',
    'C', '7', 'D', '7', '4', 'D', '3', 'C', 'F', '5', 'D', 'D', 'A', '9', '9', '7',
    '3', '1', '3', '5', '8', '5', 'E', 'E', '7', '1', '0', '9', '4', '2', 'B', 'A',
    '5', 'A', '3', 'C', '0', 'E', '7', 'A', '5', 'A', '3', '9', 'B', '4', '7', 'B',
    '0', '3', '2', 'C', '5', '6', '7', '9', 'B', '6', '1', '6', 'A', '9', 'B', '2',
    '2', '6', '1', '6', '7', '6', '3', '6', 'C', '8', 'E', 'D', '2', 'B', '9', 'A',
    '3', '2', '5', '2', '6', '0', '1', 'A', 'F', '9', 'E', '3', '6', '4', 'E', 'B',
    '0', '4', '0', 'F', '5', '6', 'D', 'B', '2', 'D', '7', '1', '6', '8', 'D', '2',
    '1', '9', '6', '4', '7', 'D', '0', '6', '7', '1', '8', '5', '9', '8', '2', '4',
    'A', 'E', 'F', '5', '3', 'C', '7', '1', '6', '1', '4', 'F', 'B', '3', 'D', '0',
    '8', 'E', '7', '6', '6', 'E', 'B', '9', 'F', '7', 'E', 'F', '1', 'E', '4', '8',
    '8', '4', '6', '5', '9', 'C', 'C', 'D', '0', '2', '1', '8', 'D', 'C', '0', 'B',
    '0', '3', 'E', '0', '4', '0', '5', '9', 'A', '0', '7', '5', '4', '2', '5', '2',
    'C', '8', 'F', '4', '5', '8', 'D', '4', '6', '5', '3', 'B', '8', '2', 'A', '3',
    'C', '1', 'E', 'B', '6', '0', 'D', '9', 'E', '2', 'F', '6', '5', '2', '9', 'C',
    '4', '9', 'F', '2', 'B', '4', 'C', '3', '3', 'E', '3', 'E', 'D', '7', '6', '4',
    '3', '4', 'D', 'B', '2', 'A', 'D', '5', 'A', '4', 'A', '7', 'D', 'A', 'B', '8',
    'F', 'C', '1', '7', 'D', '8', '5', '1', 'D', '8', '3', '7', '7', '0', '6', 'F',
    '2', '6', '7', '2', '2', '5', '5', 'A', '4', 'F', 'F', 'B', '7', '1', 'B', '4',
    'E', 'C', '0', 'D', 'F', 'E', '3', 'B', '7', '4', 'E', 'B', 'F', '9', 'E', '9',
    'E', 'A', '8', 'F', '3', '5', 'C', 'B', 'E', '6', 'C', '3', '6', '7', '4', 'A',
    '1', 'F', '2', '2', '4', 'C', '2', '2', '2', 'B', 'E', 'C', 'C', '3', '6', 'F',
    'B', 'C', 'F', 'A', '1', 'F', 'C', '0', '3', '7', '7', 'A', '9', 'C', 'A', 'D',
    'A', '1', 'E', '9', '1', '8', '7', 'C', 'B', 'F', 'C', '6', '1', 'B', 'B', '8',
    '9', 'F', '3', 'B', 'B', 'C', '7', '9', '4', '7', '4', '1', 'F', '9', '1', '5',
    '2', 'C', '9', '6', '4', '1', '9', '3', 'E', 'A', 'A', 'E', 'A', 'B', 'F', '5',
    '1', '3', '5', 'B', 'E', 'C', '6', '2', '8', '5', 'B', '9', '8', 'E', '9', 'E',
    '8', '7', '7', '1', 'A', '6', 'E', 'B', '2', '7', '8', 'B', 'C', 'C', 'D', 'F',
    '8', '1', 'D', '3', 'E', 'D', '3', '9', '1', '4', '6', '1', '4', '5', 'C', 'B',
    '5', 'A', '9', 'D', '4', '7', '6', '4', '6', '4', 'B', '8', 'D', '1', '8', '3',
    '3', '0', 'E', '2', '1', 'B', 'F', '4', '0', 'D', '1', 'C', '7', '9', 'C', 'E',
    '2', '4', '6', '7', 'D', 'E', '8', '5', '6', 'C', 'D', '6', 'F', '2', '2', 'C',
    '5', '2', '3', '6', 'B', 'C', '2', 'C', '9', '7', 'B', '8', '3', 'B', '2', '6',
    '8', 'F', '1', 'B', '0', 'C', 'C', 'C', '3', '8', '6', '1', 'B', 'B', 'D', '8',
    '1', 'F', 'C', '5', 'D', 'F', '4', 'C', 'B', '2', '3', '7', '7', 'A', 'A', 'E',
    '2', '8', '0', 'B', '7', '5', 'E', '2', '0', '1', '9', '3', '4', 'D', '8', '9',
    '5', 'A', '8', '6', 'B', 'E', '1', '1', '4', '8', 'E', 'B', '1', '7', '6', '9',
    'E', '7', 'A', 'B', 'D', '2', '9', '0', 'A', '4', '8', '7', 'E', 'C', '5', 'F',
    '1', '0', '4', 'E', '3', '4', 'A', '1', 'D', '8', '3', 'B', '3', 'D', '8', '9',
    '1', 'A', 'C', '2', 'F', '4', '1', 'E', '3', '5', '1', 'A', '9', 'C', '6', '6',
    '2', 'D', '3', '7', '7', '2', 'A', 'F', '5', 'B', '6', '3', '6', '4', 'C', '2',
    '9', '4', 'F', '1', '5', '7', 'F', 'A', 'C', '7', '2', '2', '2', '6', 'A', 'D',
    '0', '7', '8', 'C', '7', '7', '4', 'F', 'E', 'A', 'F', 'A', 'D', '3', 'B', '2',
    'F', '0', '2', 'C', 'F', 'F', 'C', '9', 'F', '2', '9', 'B', 'B', 'F', '5', '7',
    '5', '0', '7', 'F', 'B', '6', '7', '8', 'D', 'E', '4', 'C', 'A', 'E', 'C', '9',
    'F', 'F', '9', 'B', '5', '8', '6', '1', '6', 'A', '6', '6', '0', '4', '5', 'F',
    'E', 'F', '0', 'D', '0', '4', '1', 'F', 'C', 'A', '2', '3', '2', 'B', '3', '9',
    '5', 'F', '8', 'E', '1', '1', '1', '6', '8', '8', '8', '5', '4', '1', 'F', '3',
    'B', '0', '2', 'C', '6', 'E', 'D', '5', '3', 'A', 'E', '5', '9', '6', '6', '4',
    '9', '1', '4', '9', 'D', '5', '2', '6', 'F', 'E', 'C', '2', '4', '8', '5', '5',
    'E', 'E', 'C', '8', '8', '1', '2', 'F', '1', '2', '9', '3', 'C', '3', '1', 'B',
    'D', '0', '8', '2', 'D', '2', '1', 'A', 'D', '2', '6', '5', 'C', '0', '6', 'B',
    'C', '1', '5', 'D', 'A', '2', '0', 'D', '2', '4', '1', '0', 'B', '6', '3', 'A',
    'D', '5', 'F', '1', '5', '3', 'B', 'B', 'E', '9', 'B', 'E', '6', '7', 'B', 'D',
    '9', '3', '7', '3', '3', '6', '4', 'D', 'B', 'B', '2', '1', 'F', '7', 'A', '3',
    'D', '1', '8', '4', '3', 'F', '0', '0', 'F', '6', '7', 'A', '2', '5', 'A', '7',
    '9', 'B', '1', '9', '1', '5', '9', '0', '4', '9', '6', '8', '0', '2', 'C', 'D',
    'E', 'D', '8', '5', '6', '8', '0', '8', '4', '8', '1', '0', '2', '2', 'A', '0',
    'D', '2', '4', '0', '0', 'C', '3', '5', '2', 'B', '8', '2', '0', '1', 'E', '6',
    'E', '5', '5', 'C', '2', '1', '1', 'B', 'F', '1', 'C', '4', '7', '7', '6', '2',
    'F', 'C', 'F', '1', 'F', '2', '5', 'E', '2', 'A', '6', 'F', '6', '6', '6', 'F',
    'B', '5', '5', '0', '5', '3', '1', 'C', 'F', '9', 'D', '4', 'E', 'B', 'A', 'A',
    'E', '8', 'C', '8', '7', 'C', 'A', '5', '5', 'B', '7', '0', 'A', '6', '1', 'D',
    'C', '6', 'C', 'A', '5', '8', 'A', '8', 'A', 'B', '9', '3', '6', '6', '5', '3',
    'A', '9', 'A', 'A', '9', '9', '3', '6', '8', '7', '6', 'C', 'C', '3', 'A', 'B',
    '6', '3', '0', '0', 'C', '8', 'D', '3', '7', '7', 'A', 'C', '2', '7', '9', '5',
    '9', '5', 'C', 'C', '5', 'E', '2', '2', 'D', '8', '6', '6', '7', '2', '7', '3',
    'F', 'C', 'C', '4', '5', 'A', '6', '1', '0', '7', '5', '8', 'A', '5', '6', '9',
    '9', 'B', '0', '6', '0', 'B', '3', 'C', '8', '0', '6', '6', '0', '2', '6', '6',
    'E', '9', '2', '7', 'D', 'E', '1', 'D', '0', 'F', 'E', '7', '6', '1', 'F', '3',
    'D', '2', 'E', 'E', 'B', '5', 'D', '0', '8', '9', '4', '7', 'D', '7', '6', '7',
    '3', 'F', '7', '4', '1', '8', '8', 'E', 'D', '5', '5', 'B', '0', '2', '9', 'B',
    'C', '7', '0', '5', 'C', '5', '8', 'A', '1', 'B', '3', '0', 'C', '6', 'D', '4',
    '8', 'D', '0', '8', 'A', '8', '7', 'D', 'C', '4', 'A', '3', '9', '2', 'A', 'B',
    'A', 'F', '6', 'D', '3', '0', '0', '5', '4', '1', '9', '7', '8', 'E', 'A', '5',
    '0', '5', '7', 'A', '4', '4', '5', '0', '7', '5', 'D', '4', 'A', '8', 'F', '9',
    'D', '2', '1', 'D', '6', '7', '0', 'E', '4', '6', 'D', 'F', 'D', '9', '0', 'A',
    '0', '9', '2', '8', '9', 'C', '9', 'E', 'E', 'D', 'E', '7', '2', 'D', '4', 'F',
    '7', '9', '0', 'E', 'E', '0', '4', '5', '6', '8', '4', 'B', '1', '5', '9', 'C',
    '9', 'E', 'D', '6', '2', 'F', '7', '7', 'A', '0', 'E', '9', '5', '9', 'D', 'F',
    'F', '7', 'A', '7', '2', '4', 'C', '3', 'F', '9', 'D', '4', '7', 'F', 'B', '8',
    'C', '2', 'E', 'D', '9', '9', '5', 'C', 'C', '6', 'F', '8', '3', 'E', '6', '2',
    'A', 'D', '9', 'F', 'F', '8', '5', '2', 'F', '9', 'B', '2', '2', 'A', '5', '5',
    '5', 'E', '3', '5', '2', '1', '2', '8', '3', '9', 'C', '1', '9', 'A', '3', '8',
    '5', '9', 'C', '5', '0', 'F', '2', '8', '0', 'B', '6', '1', 'B', 'B', '4', '3',
    'A', '3', 'D', '5', 'E', 'E', '0', '1', 'F', '7', 'C', '6', '9', '4', '5', 'A',
    'D', 'C', 'C', '0', '0', '7', 'A', 'E', '9', '3', 'E', '0', '9', '5', 'B', 'E',
    '0', '4', 'E', 'C', '9', 'B', '5', '5', 'F', '4', 'D', 'F', 'C', '0', 'D', 'A',
    '6', '7', '5', '3', 'B', '1', 'A', '2', '0', '4', '7', '9', '3', '7', '8', '0',
    'D', '1', 'F', '9', '6', '4', '7', '4', 'B', '4', '0', '2', '0', '7', '9', '5',
    'C', 'F', '6', '9', 'A', 'E', 'D', 'E', 'E', 'D', '1', '7', 'D', 'F', '7', '1',
    'A', '5', '8', 'E', 'F', 'E', '4', '3', 'B', 'A', '9', '9', '8', '4', 'E', '3',
    'D', '3', '4', 'C', '0', 'B', '3', '1', 'E', '8', 'D', '1', '1', '6', '4', '1',
    'A', '7', '0', '7', 'F', '3', '9', '0', '1', 'F', '0', '0', 'E', 'D', 'D', '0',
    'D', '1', '1', '6', 'D', '8', '2', 'B', 'F', '6', '0', 'E', '8', '8', '1', '5',
    'C', 'A', '1', 'F', 'B', '8', '6', 'A', '2', '1', 'B', '0', 'F', '5', '4', '6',
    '9', '5', '1', '9', '2', 'B', '7', 'E', 'F', 'F', '6', 'F', '7', '8', 'A', '6',
    'F', 'B', '4', 'D', '8', '0', '2', '2', 'C', '2', '7', 'F', 'F', '6', '2', '5',
    '9', 'B', '4', '3', '4', '6', '1', '9', '4', '2', '6', '8', '0', '3', 'D', '5',
    '2', '5', 'F', '5', '5', 'E', '4', 'E', 'D', 'B', '9', '4', '4', 'C', 'A', '1',
    'A', '1', 'D', 'D', 'C', '8', '8', '9', '2', '6', '1', 'A', 'D', 'B', '8', '2',
    'E', 'E', 'B', '0', 'B', '1', '1', '8', '5', 'B', '8', 'A', '3', '9', '3', 'F',
    'D', 'E', '3', '2', '2', '7', '5', 'E', 'D', 'A', 'D', '1', '7', '9', 'F', '0',
    '2', '0', '0', '7', 'E', '2', '7', '6', '1', '2', '4', '3', 'C', '2', 'D', '4',
    '2', '0', '5', '4', '0', '9', 'B', 'D', '0', '4', 'F', '7', '3', 'F', 'D', 'D',
    '3', '6', 'D', '3', '0', 'D', '2', '4', 'E', '9', '6', '8', '7', 'F', '1', '9',
    'B', '8', '8', '7', 'C', '8', 'C', '1', 'F', '2', 'F', '0', 'B', 'F', '8', '9',
    '6', '4', '5', '9', '7', '8', '2', '0', '1', '8', '9', '1', '8', '5', 'F', '3',
    '7', '4', 'F', '0', '1', '8', '0', '6', 'D', 'F', '6', '2', 'D', 'F', '2', 'A',
    'B', 'B', '6', 'C', '3', '8', '4', 'E', 'D', '7', 'C', 'A', 'F', '2', 'E', 'B',
    'F', '4', '6', '8', '8', 'A', 'F', '1', '9', 'A', 'E', '3', '7', '5', '7', 'D',
    '4', 'D', '4', '6', '4', '3', '6', 'C', 'F', '4', 'B', '6', '0', '3', '1', 'E',
    '3', '6', 'F', '7', '6', 'B', 'A', '1', '4', 'C', '4', '0', '8', '1', 'C', 'C',
    'E', 'E', '8', 'B', 'D', 'D', '4', '1', '9', '1', '0', '3', '5', '0', 'B', '6',
    '7', 'E', '0', '3', '8', 'F', '4', '5', '8', 'F', '3', '2', '2', 'B', 'C', 'E',
    '2', '4', 'F', '2', '4', '6', 'C', 'F', 'E', '9', 'C', '2', '0', '3', 'E', 'B',
    'A', '1', '5', '8', '3', '4', '5', '9', 'A', '3', 'F', '4', '5', '0', 'B', '9',
    '5', '5', 'A', '5', '1', '5', '5', '1', 'E', '6', '7', '7', '4', '4', '7', '3',
    '0', 'E', '0', '7', '9', '7', '4', '4', '2', '0', 'C', '2', '4', 'F', '5', 'E',
    '0', '2', 'D', 'F', '5', '3', 'C', 'F', '7', '7', 'D', 'D', '2', '2', '3', '5',
    'B', '3', 'F', '9', '0', '3', '8', 'A', '2', 'D', '1', '5', '0', 'B', '6', '2',
    '3', '4', '0', '7', '6', 'F', '4', 'C', '8', '6', '1', '0', 'A', '9', '7', '7',
    '3', 'F', 'C', '7', 'B', '7', '3', '1', '9', '3', 'A', '8', 'F', 'B', 'E', 'B',
    'D', 'E', 'E', 'E', '5', '3', '1', '8', 'C', '1', '5', 'C', '9', '0', '8', 'F',
    'F', '1', 'E', '6', '9', 'A', '1', 'E', '6', 'D', '9', '7', '4', 'A', '6', '3',
    '1', 'E', '0', '2', '4', 'E', '9', '0', '5', '7', '2', 'D', 'D', 'E', '7', '6',
    '7', 'E', '3', '3', '2', '9', 'C', 'E', '4', '2', '7', '1', '0', '6', '7', 'F',
    'D', '8', '9', '7', '1', '4', '5', 'E', '4', '0', 'E', 'C', '2', 'F', 'F', 'A',
    'F', '0', 'C', 'B', '0', '1', 'B', '8', 'D', '2', 'E', '9', 'D', 'F', '3', '9',
    '5', 'A', '3', 'F', '9', 'E', '5', 'D', '1', '5', 'A', '6', '1', '7', 'E', 'E',
    'A', 'F', '4', 'A', '0', 'A', '3', '2', '5', '8', 'C', 'B', 'D', '3', '0', 'E',
    'E', '6', '0', '5', 'F', '1', '1', 'D', 'D', 'B', 'E', 'C', '0', 'F', '8', '9',
    'D', 'D', '1', '1', '7', '2', 'B', '9', 'D', '6', 'C', 'A', '9', 'D', '4', '6',
    'B', '2', 'B', '6', '4', '7', 'C', '4', 'C', '8', '7', '9', '0', '2', '6', 'F',
    '2', 'E', '2', 'E', 'F', '3', '8', '7', 'D', 'B', 'B', 'E', 'D', '8', 'E', '6',
    'A', 'D', 'E', '6', 'A', 'B', '1', 'D', '7', 'E', 'B', '9', '4', 'B', 'C', '0',
    '5', 'B', '9', '6', '3', 'C', '5', '6', 'B', '6', '1', '6', '9', '9', '8', '3',
    '8', '1', 'B', 'F', 'B', '6', '5', '0', '5', '9', 'E', 'B', '0', '6', 'B', '0',
    '8', '6', '9', 'E', 'F', '9', 'D', '8', 'E', '7', '4', '2', '8', '1', 'B', '1',
    '8', 'C', 'F', 'D', '9', '7', '5', '0', '8', '3', '2', '6', '5', '2', '7', '0',
    '5', '4', '5', '5', '7', '3', '1', 'E', '9', 'C', '8', 'E', 'C', 'D', '6', '6',
    '7', '8', '3', '9', '9', 'B', '5', '0', '2', '7', 'C', '3', '3', 'A', '6', 'C',
    '3', 'B', 'A', '5', '3', '7', '1', '0', '4', '0', '4', '9', '8', 'F', '6', 'A',
    'A', '8', 'B', 'D', '3', '3', '7', '8', '0', 'D', '4', 'B', '4', 'B', '9', '1',
    '8', 'B', '0', 'A', 'A', 'F', '1', 'F', 'E', '7', '1', '4', 'E', '3', '3', '0',
    '9', 'D', 'B', '7', 'C', 'F', '4', '7', '8', 'A', 'B', '4', '0', 'E', 'D', '3',
    '7', '6', 'E', '8', 'F', 'D', 'E', '0', '6', 'D', '9', '3', '4', '1', 'D', 'A',
    'D', '9', 'D', '6', 'D', '0', 'D', '6', '7', '1', '0', 'E', 'A', 'B', '8', '6',
    'C', 'D', '5', 'D', '7', '8', '1', '5', 'B', 'B', 'E', 'D', 'C', '8', '7', '7',
    '2', 'F', '1', 'A', '7', '7', '6', '9', '4', '9', 'E', 'C', '6', '7', '6', '5',
    '1', 'C', 'A', '6', 'F', 'D', '4', '4', 'B', '6', '3', 'C', '1', 'C', '7', '9',
    'C', '4', '5', 'C', '2', '8', 'C', '4', 'A', 'E', '5', '8', 'C', 'D', 'C', '1',
    '6', '1', '6', 'B', '1', '5', 'D', '8', '0', '2', 'F', '2', '3', 'A', '6', '1',
    'F', 'A', '8', '9', '1', 'B', 'F', 'E', 'A', '3', '0', 'F', '7', 'D', '9', '2',
    'C', 'D', 'D', '8', 'B', 'E', '8', '7', '4', '5', '4', 'A', '1', '0', '7', '8',
    'E', 'B', 'D', '0', 'E', '6', '6', '5', 'C', '1', '2', '5', '4', '7', '5', '3',
    'E', '9', 'E', '7', 'B', 'F', 'A', '5', '9', '2', 'F', '3', '1', 'C', 'C', '2',
    'A', 'F', '7', 'D', '9', '9', '5', 'C', '1', 'F', 'B', '6', '1', '8', '6', '2',
    'D', '0', 'A', '0', '7', '3', '6', 'E', 'B', '8', '7', 'E', 'A', '3', '1', '1',
    '1', '0', '8', '5', '1', 'A', 'E', 'B', 'B', '2', '9', '2', '2', '7', 'E', '1',
    'E', '4', 'A', '3', '6', '0', 'D', '6', 'F', 'D', '1', '9', 'A', '3', '8', '3',
    '4', 'D', '9', 'F', 'B', '1', 'B', '8', '5', '0', 'B', '1', '7', 'A', 'B', 'E',
    'D', '4', 'B', 'E', 'B', '3', 'C', '3', '7', '5', '5', '6', '6', 'A', '2', '2',
    '8', 'A', '9', '5', '5', '0', '7', 'B', '8', '9', 'A', '1', 'F', 'E', '3', '5',
    'D', 'C', '8', 'B', 'F', '8', '4', 'F', '0', 'F', '2', 'E', '3', '4', 'C', '7',
    '0', '3', '0', 'D', '7', 'F', '8', 'F', 'D', '9', 'F', '3', 'C', 'B', 'E', '2',
    '2', '5', '7', 'B', 'B', 'E', '7', '1', '3', '4', 'E', 'B', '9', '9', '3', '7',
    'C', '3', 'A', '3', 'B', '4', 'A', 'C', '4', '7', '2', 'D', 'A', 'F', '9', 'F',
    'C', '0', '6', '6', 'C', '9', '5', 'A', 'C', '2', '3', '4', '6', '6', 'B', 'A',
    '0', 'B', '8', 'E', 'E', '0', '9', '5', 'C', 'C', '7', '5', 'F', '6', '6', 'D',
    '2', '6', 'A', 'C', '0', '7', 'F', '5', '7', 'D', 'F', '9', 'B', '0', 'B', '6',
    'A', '1', '2', 'A', 'E', 'A', 'B', 'D', 'D', 'C', '0', '9', '5', '0', 'E', 'E',
    '0', 'E', '8', '3', '0', 'D', '4', 'C', 'C', '7', '7', '1', '9', '9', 'C', '8',
    'F', '5', 'F', 'C', '4', '5', '5', '9', '1', 'E', '1', '0', '0', 'A', '0', '6',
    'B', '5', '1', '7', '9', '8', 'D', '0', '7', 'E', '6', 'F', 'B', 'E', '5', '2',
    'B', 'B', '1', '4', '2', '8', '3', '8', '0', '4', '2', 'B', '6', 'E', '1', '1',
    'C', '4', 'C', '5', '9', '0', 'E', '8', '2', 'C', '5', '8', '7', '9', 'D', 'F',
    'E', '1', '4', '4', '5', 'F', '0', 'C', '1', '7', '8', '8', '4', '5', 'D', '0',
    '8', '3', '9', 'D', '3', '0', '0', 'F', 'D', '0', '4', 'C', '2', '0', 'B', 'F',
    '9', '0', '7', '4', '8', '1', 'D', 'A', '6', 'D', '8', '3', '6', '3', '6', '8',
    '9', '7', 'E', 'A', '3', '1', '6', '8', 'D', '5', '3', '5', 'D', '0', '7', '1',
    '6', 'E', '6', '6', '7', '4', '8', '0', 'A', '0', 'D', 'E', '0', '0', '4', '9',
    '0', 'C', 'A', '3', 'C', '9', 'F', '7', '2', '5', '4', '9', '6', 'F', 'F', '6',
    'D', '3', 'F', 'D', '6', '2', '4', 'E', '5', 'C', 'C', '4', '2', '8', '3', 'A',
    '6', '0', '8', 'E', '2', '1', '6', '4', '4', '8', '1', '1', 'C', 'C', '1', '7',
    '0', '2', 'C', '6', '0', 'C', '7', '9', 'E', '8', 'C', '1', '4', 'E', '6', 'F',
    'C', '2', '7', 'C', '4', '2', 'D', 'B', '9', '4', '6', '2', '6', '8', 'D', 'D',
    'E', 'C', 'C', '0', '4', '5', 'B', '9', '2', '3', 'E', 'A', '7', 'C', '6', '6',
    '3', '3', '4', '1', '4', 'E', 'A', 'E', '0', 'A', '7', 'D', '6', 'B', '8', '9',
    '2', 'A', 'B', '1', '3', 'C', 'E', 'E', '5', '1', '8', '5', '2', '3', '0', 'D',
    '9', 'D', 'B', '6', '5', '4', 'F', '1', '1', 'A', 'D', '6', 'E', '8', 'C', '0',
    'E', '5', '8', 'F', '6', '1', 'B', '8', '1', 'E', 'F', '8', 'B', '6', '5', '6',
    '3', 'E', '5', '9', 'B', '7', '4', '3', 'A', '5', '6', '5', '3', '2', 'B', 'F',
    'E', 'E', 'D', 'A', '4', '0', 'A', 'D', '9', 'B', '7', '5', '9', 'C', '7', '1',
    '5', '1', '9', 'A', 'B', '5', '3', 'C', 'C', '1', 'D', 'B', 'D', 'E', 'B', '8',
    '7', '9', '3', '3', '5', 'E', '8', '1', '6', 'F', '7', '3', '8', 'A', 'F', 'B',
    '6', 'D', '4', 'E', '7', 'D', '1', '6', '3', '2', 'C', '4', '8', '2', '1', '6',
    '3', '6', 'F', '3', 'E', 'E', 'B', 'B', '1', '2', '7', 'F', '0', '9', '8', '6',
    'D', '2', '2', 'D', '2', '6', 'A', '7', '5', '7', '5', '3', 'C', '4', '8', 'B',
    '2', 'D', 'B', '9', '3', 'B', 'F', 'B', 'C', '7', 'B', '4', '2', '8', 'E', 'B',
    '0', '9', '0', '0', 'D', '7', '9', 'F', '4', '5', '7', '2', '3', 'D', '3', '4',
    '9', 'C', '5', '8', '7', '7', '1', 'E', '2', '2', 'C', 'C', '3', '1', 'F', 'F',
    'A', '5', 'D', 'D', '6', '5', '8', '6', 'F', '9', 'F', 'C', 'E', 'C', 'C', 'A',
    '8', '7', '6', '2', '0', '8', 'A', '4', '8', 'C', '5', '9', '3', 'C', 'E', '5',
    'C', 'F', 'A', 'C', 'D', '0', 'E', 'F', '9', '4', '8', '6', 'F', '4', 'A', '6',
    '3', '8', 'F', '4', 'E', '4', '9', '7', '7', 'F', '5', 'B', 'F', 'F', '0', 'F',
    'D', '5', '3', 'A', 'D', 'E', '0', '0', 'F', '1', '9', 'D', '5', 'B', '6', 'A',
    'D', '3', 'E', '3', '7', '3', 'B', '8', 'D', '3', '6', 'E', 'E', '7', '4', '1',
    '0', 'B', '5', '1', '6', 'C', '9', '6', 'B', '4', '7', '5', '3', '6', '7', '6',
    '0', '2', '2', '3', 'A', '5', '7', '7', '2', '3', '7', '7', '5', '1', '2', 'C',
    '0', '6', 'B', 'F', 'D', 'F', '2', '9', '3', 'A', '1', 'A', 'D', '0', 'F', '4',
    '9', '8', '5', 'F', 'B', '5', '5', '5', 'F', '6', '9', '1', '8', 'C', '8', '7',
    '3', 'C', '8', 'A', 'D', '8', '2', 'E', '1', 'D', 'C', 'D', '6', '1', 'D', '5',
    'E', '8', 'F', 'D', '0', '8', '9', '3', 'F', 'B', 'D', '4', '3', '8', '7', '2',
    'E', '4', '4', 'E', 'E', '9', '0', '4', '9', 'B', 'D', '3', '7', 'F', '5', '4',
    '6', 'D', '2', 'D', '6', '8', '8', 'E', 'C', 'D', 'A', '6', '5', '2', 'C', 'D',
    '0', '4', 'B', '2', 'A', 'D', '0', '2', '6', '9', '9', '3', '7', '1', '4', '3',
    '4', '1', '1', '6', '2', '1', 'B', '8', '3', '4', 'F', '8', '2', 'E', '8', '7',
    '6', '5', '5', 'B', '7', 'A', 'B', '1', '9', '6', 'F', '4', '6', '5', '7', '8',
    '9', 'F', 'F', 'A', 'F', 'E', '0', '9', '4', 'A', 'F', '7', '3', 'F', 'E', '7',
    'D', 'D', '4', '0', '9', '9', 'E', '0', '4', '1', '4', '4', 'B', 'D', '5', 'D',
    '2', '4', '7', '6', '6', '8', 'E', 'F', 'B', '8', '3', '9', '7', 'A', '8', '8',
    '9', 'F', '5', '8', '2', '9', '0', '9', '5', 'D', '2', 'B', 'F', 'B', '9', '4',
    'C', '1', '1', 'D', 'B', '1', 'D', 'D', '5', '4', 'F', 'B', 'C', '5', 'A', '0',
    '0', 'B', 'F', '2', 'D', 'F', '6', 'F', '9', '0', 'E', 'A', 'D', '4', 'A', '1',
    '2', '5', 'E', '1', '6', '4', '6', 'B', 'A', '0', 'E', '1', 'D', 'F', 'F', '2',
    '5', 'C', '5', 'A', '5', '9', '6', 'D', 'B', 'A', '8', 'F', '7', 'E', 'C', 'E',
    '5', '0', 'F', '1', 'B', '7', 'C', 'D', '4', 'D', '3', '3', '6', 'C', 'D', 'C',
    '8', 'E', 'C', '9', 'A', '2', '5', 'B', '8', '7', '5', '3', '8', '8', 'F', '6',
    '0', 'A', '3', 'A', '9', 'A', '7', '4', 'A', '9', 'B', 'D', '9', '0', '1', '3',
    '7', 'A', '8', '2', '4', '7', 'B', '1', '1', 'F', '0', '2', '9', 'A', 'E', '2',
    '4', 'F', 'B', 'F', '2', '6', 'A', '3', 'C', '2', 'F', '2', 'F', 'B', 'B', 'B',
    '4', 'F', 'F', 'D', '9', 'E', 'A', 'B', '5', '0', '4', 'A', 'E', '5', 'E', '1',
    'A', 'D', 'C', 'A', 'B', '9', 'D', 'A', '0', '7', '0', 'A', 'F', '0', '9', '1',
    'A', '3', '9', 'B', '4', '3', '1', '7', '6', 'B', '5', 'E', 'E', '2', '4', 'B',
    '2', 'A', '2', 'E', '1', 'D', '9', '7', '7', '9', '3', 'D', '9', '6', 'A', '9',
    '9', 'A', '7', '6', '5', '8', 'E', 'F', '8', '1', '8', 'E', '0', '1', '0', '4',
    'B', 'D', '7', '1', 'E', '6', 'F', 'B', '6', 'D', '5', '3', '6', '6', '2', 'B',
    'F', '0', '1', 'F', '9', '8', '2', '4', 'F', 'C', '4', 'B', '0', 'E', 'A', '9',
    '1', '0', '3', '1', '8', '4', '0', '8', 'A', '0', 'F', '4', 'A', '6', 'A', '1',
    '3', 'A', 'F', '5', 'F', 'B', 'F', '0', '6', 'D', 'F', '7', '4', '5', '6', '6',
    '2', '9', '4', 'C', 'A', 'D', 'F', 'A', 'E', '2', '1', 'B', '7', '0', '6', 'F',
    'E', '8', '9', '6', '6', '4', 'F', '6', 'B', 'D', '6', '9', '0', 'E', '1', '7',
    'C', '4', 'E', 'A', 'F', 'C', '1', '1', 'E', '5', 'B', '2', '4', '4', 'D', '9',
    'F', '9', '9', '0', '9', '7', 'E', '2', '5', 'D', '9', 'D', '7', '0', '9', '1',
    '1', '5', '4', 'C', 'C', '7', 'F', '2', 'E', '8', '4', 'D', 'E', '8', '9', '7',
    'A', '6', '0', 'A', '8', 'E', '2', 'D', 'F', 'F', '5', '8', '4', 'B', '9', 'B',
    'E', 'C', '8', 'C', 'E', 'F', 'C', '5', '8', '6', '0', 'C', '2', '7', '8', 'B',
    '6', '0', '7', '0', '6', '4', '6', '3', '2', 'D', 'E', 'F', '7', '4', '7', '7',
    'D', 'A', '8', 'C', 'B', '0', '1', 'D', '1', '5', '0', '7', 'C', '6', '2', '9',
    'E', '0', '2', 'A', '3', 'B', '7', '6', '5', '1', '7', '8', '3', '8', 'B', '1',
    '7', '0', '1', 'C', '7', '7', '9', '2', 'E', 'C', 'A', '3', '3', '2', '4', 'F',
    'A', '7', '4', '0', '8', 'D', '4', 'C', 'A', 'A', 'A', '4', '7', 'A', '1', '3',
    'A', '8', 'D', '5', 'F', '5', 'F', '0', '9', 'D', 'B', '6', '7', '6', '6', 'D',
    'F', '5', '5', '6', '0', '8', '5', '2', '2', '3', 'C', '0', '7', 'B', 'C', '9',
    '7', '6', 'E', '7', 'C', '5', 'D', '8', '2', '9', '6', '0', 'D', '1', '4', '4',
    '7', '2', '2', '9', '9', '2', '4', '1', 'C', '1', '5', '7', 'F', '8', '1', 'C',
    '1', '8', '9', '0', '6', '5', 'E', 'D', 'B', '8', 'A', '5', '1', '6', '6', 'D',
    '7', 'F', '2', 'B', '4', '5', 'D', '5', '7', '3', 'A', '6', 'D', '6', 'F', '6',
    '2', '9', '4', '1', '5', 'B', '6', '6', '0', 'C', '9', '5', 'C', 'C', 'D', '3',
    '3', '3', 'B', '2', 'D', '4', '6', 'E', '2', 'A', '7', 'F', '4', '3', 'F', 'A',
    'A', 'D', '9', '1', 'B', '0', '7', '9', 'A', '0', 'B', '1', 'C', '4', '5', '6',
    '8', 'C', '3', 'A', '6', 'D', 'F', '5', '0', '2', '1', '3', '8', '4', '8', '5',
    '6', '3', '5', '0', 'C', '2', 'C', 'B', '7', 'C', '6', '7', '6', '1', 'E', '3',
    '3', 'F', '2', 'A', 'D', 'B', '9', '9', 'F', '0', '9', '0', '7', '9', 'C', 'B',
    '5', 'F', '8', 'B', 'D', '4', '9', 'A', '7', '0', 'E', 'E', '4', '2', '4', '6',
    '1', '3', 'C', '8', 'E', 'F', '5', '3', '0', 'A', 'C', '7', 'C', '1', 'B', '1',
    'B', 'B', '7', '3', 'F', '3', '3', '1', 'E', '5', '8', 'E', '8', '2', '4', '0',
    '4', '8', '5', 'E', '9', 'F', '7', '3', '9', 'A', '9', 'E', '8', '2', '9', '4',
    '1', '9', 'A', 'A', '8', 'B', 'D', 'C', '5', '9', '3', '8', '9', '0', 'D', '8',
    'D', '9', '2', '2', 'C', '8', 'B', '2', '1', 'B', 'F', '7', 'A', '5', '9', '7',
    'E', 'F', 'A', '2', 'F', '4', '8', '9', 'B', '7', '3', '5', '9', 'D', 'B', 'E',
    '4', '4', 'E', '4', 'A', 'D', '2', '5', '6', 'D', '4', '1', '0', '8', '4', 'E',
    '6', 'F', 'F', '0', '3', '1', 'F', '6', '7', '8', '0', '2', '1', '8', '1', 'A',
    'C', 'D', '8', 'A', '5', '2', '2', 'C', '8', '6', 'B', 'C', '4', '1', '0', '0',
    'B', '7', '4', '7', '8', '9', 'F', 'C', '0', '4', 'A', 'E', '9', '6', '2', 'D',
    'F', '0', '2', '7', '5', 'F', '3', '7', '7', '7', '4', 'C', '7', 'D', '9', '3',
    '0', 'C', '7', '5', 'B', 'C', 'A', 'A', 'D', '6', '3', '7', '7', 'F', '7', 'E',
    'C', 'C', '1', '2', 'E', '9', 'B', 'F', '6', '4', '4', '2', 'A', 'A', 'D', '8',
    '0', '2', '1', '0', '1', '5', 'D', '9', '0', '8', 'B', '9', 'B', 'C', '3', 'D',
    'C', 'E', 'E', '3', 'C', '3', 'B', 'C', '5', '2', '8', '8', '6', 'F', '5', '9',
    '0', '9', 'F', '4', '1', 'E', '2', 'B', '2', '2', '2', '4', '7', 'D', 'B', '9',
    '1', 'E', 'E', '2', '7', '0', 'E', '7', '3', 'E', 'F', '2', '7', 'A', 'C', '5',
    '6', '9', '9', '6', 'B', 'D', 'C', 'D', '8', '7', 'C', '9', '1', 'F', '2', 'E',
    'F', '2', 'B', 'E', '6', '7', '9', 'F', '4', '0', '7', 'D', '8', '9', 'A', '8',
    '0', 'B', 'D', '7', '4', 'F', '4', '7', '9', '5', '9', '7', '6', '7', '4', '3',
    'E', 'B', 'F', '9', '1', 'C', '5', '2', '1', 'B', '0', '7', '0', '0', '4', 'A',
    '9', '2', '2', '7', '7', 'B', '1', 'D', '2', '0', '3', 'A', '2', 'C', '7', '4',
    'D', '3', '1', '8', '4', '3', '5', 'F', '1', '3', '0', '1', 'C', '7', '9', '0',
    '6', '9', '7', 'A', '0', 'D', '0', '7', '9', 'B', '4', '6', '3', 'B', '2', '3',
    '4', '8', 'F', 'C', 'D', '4', '0', 'B', 'E', 'D', '6', 'A', '7', '3', '4', '1',
    'A', '0', '7', '2', '0', '1', '9', 'E', '6', '3', 'A', 'E', 'E', '6', '3', 'C',
    'F', '8', '1', '9', '8', '0', 'B', '5', '6', '8', 'F', 'B', 'E', '4', '2', '9',
    '9', 'A', 'C', '6', 'E', '1', '4', '9', '2', '5', '1', '5', '2', 'A', 'A', '6',
    '9', '2', '7', '1', 'E', '1', '3', '5', 'C', '6', '9', '7', 'A', '6', '4', 'B',
    'E', '2', '8', '6', '1', 'C', 'F', '4', '3', '9', 'D', 'C', 'A', 'E', '0', '4',
    '7', '1', 'A', '4', '0', '9', 'E', '9', 'C', 'B', 'B', '2', '1', '9', 'B', 'A',
    'E', '9', '4', 'E', 'D', '8', '2', '0', '0', '6', '2', 'B', '8', '4', '3', '2',
    '5', '5', '9', 'B', 'D', '6', 'E', '9', '0', 'B', 'E', 'C', '3', 'F', 'D', 'F',
    '8', '6', 'B', '8', '0', 'F', '7', '6', '5', '2', '7', '8', '7', '3', 'C', 'F',
    '0', '0', 'C', '7', '8', '9', 'C', 'C', 'E', '1', '7', 'F', 'E', '3', '9', '7',
    'F', '9', 'A', '7', '8', '6', '1', '3', 'B', '4', 'A', '3', 'F', '0', 'E', '4',
    '8', '8', '7', '2', '0', '1', 'F', '0', 'C', '5', '6', '5', '1', 'A', '3', 'A',
    'A', 'C', 'F', 'F', '4', '2', 'C', 'E', '8', '0', 'A', 'C', '8', '8', 'B', '4',
    '4', 'E', '7', 'C', '6', '3', '4', '6', '6', '8', 'A', 'D', '2', '8', '9', 'B',
    '2', '2', '9', 'A', 'A', '9', '7', 'F', 'C', '2', 'C', 'D', '3', '9', '7', '0',
    'F', '9', 'A', 'A', '6', '5', 'D', 'B', '4', '8', '6', '1', '0', 'B', 'B', 'D',
    '2', 'F', 'B', 'C', '6', '9', '4', '7', '9', '8', 'D', '8', '7', 'F', '8', '5',
    '2', '6', '9', '8', '3', '5', '8', '3', '9', 'D', '0', '4', '9', '5', 'B', 'B',
    'D', '6', '4', '8', 'A', '2', 'E', '8', '8', '1', '4', '3', 'C', 'E', '7', 'C',
    '2', '4', '4', '7', '9', '0', '9', 'D', '5', '3', '3', '4', '5', '0', 'E', '4',
    'C', 'A', '9', '3', '6', 'D', '3', '7', '5', '0', 'C', '6', '6', '7', '0', '7',
    'B', 'C', '8', 'B', '0', '4', '3', '8', 'F', '7', 'C', '5', '5', 'A', '3', '7',
    'B', '5', '5', '4', 'A', '6', '0', '0', 'D', 'A', 'D', '1', 'D', '7', '0', '9',
    '5', 'A', 'C', 'F', '0', 'E', '0', '7', '8', '7', 'E', 'D', '8', '9', '3', 'D',
    'F', '6', '0', 'D', 'B', 'E', 'C', '4', 'A', 'D', '4', 'F', '1', 'B', '3', '1',
    '4', '3', '7', 'B', '7', '5', 'C', 'E', '8', '5', 'D', '8', '3', 'F', 'F', '4',
    'A', 'A', '1', 'D', 'C', '9', '8', 'B', '7', 'E', '2', '0', '9', '8', 'D', '6',
    '8', 'B', 'F', 'E', 'B', '7', '5', '1', 'E', '6', 'B', 'B', '1', '1', '5', '8',
    '3', 'E', 'E', 'F', '2', 'A', '2', '4', '8', '7', 'D', '2', '3', '2', '8', 'C',
    'F', 'C', 'B', 'E', '0', 'F', '1', 'F', 'D', 'E', '7', '3', 'A', 'A', '1', '5',
    '7', '6', '8', '6', '5', '9', 'F', 'C', 'C', '7', 'D', 'C', '7', 'E', 'C', '6',
    'C', '2', '5', 'B', '0', 'C', '4', '6', '0', 'F', '8', 'C', 'D', '6', 'B', '6',
    '8', '2', 'B', '2', 'D', 'E', 'A', '6', 'D', 'F', '8', '9', 'E', 'A', 'D', '4',
    '3', '5', 'B', 'C', '4', '9', 'E', 'A', 'B', 'F', '3', '0', 'F', 'E', '0', '0',
    'B', '2', '1', 'F', '4', 'F', 'B', 'A', 'D', '8', 'A', '2', 'D', 'D', '2', 'E',
    'A', 'B', '5', '9', '4', 'D', 'D', '7', '3', 'C', '6', '9', 'F', 'C', '5', '4',
    '1', '4', '5', '9', '0', '2', 'D', '6', '8', 'C', 'A', 'E', 'D', 'E', 'A', '7',
    '5', '6', 'F', '4', 'A', '9', '5', '4', '2', '0', '7', '0', 'C', '2', 'A', '4',
    '6', '6', '7', '3', 'E', 'B', '5', 'C', 'B', '8', '6', '8', '6', 'A', '4', 'D',
    '6', '5', '8', '0', '5', '6', '3', '6', '0', 'C', '5', 'D', '6', '9', 'D', '9',
    '6', '1', 'B', '0', '1', '3', '5', '6', 'C', '9', 'C', '3', 'D', '1', 'B', 'B',
    'A', 'D', 'A', '4', 'F', 'E', '6', '0', 'C', '8', '1', '5', '4', 'A', 'C', '7',
    '7', '8', 'C', '3', 'B', '0', '3', 'B', 'D', '6', '9', '2', '5', 'E', '5', 'F',
    '9', '1', 'E', 'B', '0', 'E', 'E', 'B', 'B', '4', '5', '3', '4', 'E', '4', 'D',
    '1', '9', '7', '0', '1', 'A', 'D', '1', '9', '1', '3', 'F', 'A', '0', 'A', 'A',
    'F', 'A', 'A', 'D', 'D', 'F', 'F', 'C', 'D', '2', '7', 'A', '6', '3', '3', 'D',
    'D', 'B', '9', 'E', '1', 'C', '3', '0', '2', 'F', '9', 'C', 'F', '8', '3', '5',
    'D', 'C', '4', '0', '3', '8', '3', 'F', '5', 'D', '9', '5', 'F', 'C', '9', 'B',
    'B', 'F', '2', 'B', 'B', '8', 'E', 'D', '1', 'C', '8', '5', '8', '3', '5', '8',
    'C', '5', 'E', '5', '8', 'F', 'A', '4', '1', '9', '3', '5', '3', 'D', '2', '3',
    '1', '6', '0', 'D', '5', 'E', '3', '7', '1', '8', 'B', 'F', '9', '9', '8', '7',
    '8', 'D', 'C', 'C', '0', '1', '4', 'B', '8', '1', 'C', '6', 'F', 'F', 'B', '6',
    'C', '3', 'D', '5', '9', 'F', 'C', '9', '7', '4', '9', 'F', '7', '6', 'D', '3',
    '9', 'B', '5', 'E', '3', '1', '4', '7', '2', 'B', '9', 'F', '8', 'E', '7', '8',
    '5', '7', 'C', '6', '7', 'D', '9', '3', '3', 'E', '7', 'A', '3', 'D', '0', '8',
    '1', '0', '3', 'A', 'A', 'E', '4', '4', '3', 'D', '0', '3', '9', 'A', '9', '9',
    '8', '5', 'F', '1', '8', '0', '6', '4', '9', '1', '6', 'D', 'A', '6', '5', 'D',
    'F', 'D', '7', 'B', 'F', 'E', 'D', '3', 'D', 'F', '0', '5', '2', '0', 'D', '2',
    '4', '7', '2', 'F', '6', '9', 'B', '1', 'C', '2', 'C', '5', 'D', '7', '6', '2',
    '8', '1', 'F', '4', '0', '7', '8', '1', 'E', 'A', 'C', '3', '8', '8', '3', '6',
    'E', 'B', '5', '2', 'D', '2', 'B', 'D', '7', '1', 'D', 'A', '8', 'F', 'A', '7',
    '1', 'E', 'E', 'A', 'C', '6', '8', '6', '0', '8', 'E', 'F', '0', '6', '5', '8',
    '2', 'E', '9', '8', '0', '1', '3', 'D', '0', 'A', '3', 'E', 'D', 'B', 'C', '4',
    'A', '3', '5', 'A', 'A', 'C', 'F', '5', '1', 'B', '6', 'C', '6', '2', 'E', 'A',
    'E', 'C', 'C', 'B', '5', 'F', '8', '7', 'F', '3', '0', 'F', 'E', '0', '2', '1',
    '0', '5', '7', 'A', 'F', '7', '2', '1', 'E', 'F', 'E', '1', 'B', '0', 'A', '1',
    '6', '9', '7', '5', '4', '9', 'D', 'F', 'F', '4', '0', '2', '7', '8', '7', 'A',
    '1', '8', '4', 'E', 'C', 'F', '3', 'C', '7', '9', '5', '3', '5', 'D', 'F', '1',
    'A', '2', '1', '0', '4', '1', '3', '9', 'C', '6', '5', 'E', '2', '8', 'A', 'A',
    '4', '3', 'E', '8', '3', '7', 'D', '8', 'A', 'E', '7', '6', '9', 'A', '1', '2',
    '9', 'B', '9', '1', '7', 'E', 'E', '5', 'E', 'B', '6', 'B', 'D', 'E', '7', '4',
    'F', 'C', '6', 'F', 'B', '4', '1', '1', 'F', 'F', '8', 'D', '2', '8', '8', '0',
    '8', '2', 'E', '6', '0', '3', 'F', 'C', 'D', 'E', 'A', '2', '0', '9', '2', '0',
    '4', '5', '4', '5', 'C', 'D', '3', '8', '1', '6', 'C', 'E', 'C', '2', '9', 'D',
    '8', '5', '5', 'E', 'B', '1', 'A', '1', '6', '7', '9', 'C', '6', '3', '3', '1',
    '3', 'A', '8', '4', '2', 'B', 'D', 'A', '8', 'C', '3', '2', '5', 'A', 'A', 'B',
    '9', '6', 'F', '6', '0', 'B', 'D', '7', '8', '2', '5', 'B', '2', '2', '4', '0',
    '0', '4', '3', 'F', '3', '1', '1', '6', '6', '2', '1', '2', 'E', 'E', '8', '9',
    'F', '8', '4', 'B', '9', 'D', 'C', '0', 'F', '1', 'D', 'B', 'D', 'D', 'D', '9',
    'F', 'F', 'E', 'E', '2', '4', '7', '2', 'D', '8', 'A', '2', 'A', '8', 'A', '6',
    '1', 'A', '2', '0', 'B', 'A', '1', 'B', '1', '6', 'B', '7', '4', 'F', 'A', '5',
    '8', '7', '6', '1', 'E', 'F', 'D', '9', '7', '3', '9', 'C', '2', '4', 'A', '7',
    'D', '4', '8', '2', 'D', '4', 'E', 'C', '8', '0', '6', '8', '4', 'A', '1', 'D',
    '6', 'F', '6', '1', 'A', '7', '6', 'D', '9', 'F', '7', '6', '6', '5', '4', 'A',
    'A', '6', '2', 'F', '1', '0', 'D', '0', '2', 'F', '0', '9', '1', '9', '5', '2',
    'D', 'D', 'D', '6', 'A', 'F', '4', '8', 'D', 'F', '7', '9', 'D', '3', '9', 'D',
    'E', '1', 'D', '3', '6', '2', '1', '6', 'E', 'C', '7', '2', 'F', '8', '2', '0',
    '7', '3', 'A', '4', 'E', 'A', '4', '6', 'C', '3', '8', '2', 'A', '8', '8', 'A',
    '4', 'C', '2', 'F', '5', '6', 'F', '6', '1', '0', '7', '6', '7', '5', '4', 'B',
    '4', 'C', '7', '2', '3', '7', '4', 'C', 'E', '9', '3', 'C', 'E', 'D', '6', 'B',
    '0', '0', '6', 'F', '1', '2', 'B', 'E', '7', 'E', '7', 'A', '2', 'D', '1', 'E',
    'E', '7', 'C', '5', 'B', '1', '0', 'B', 'D', '4', '4', '7', '4', '2', 'C', '1',
    '3', 'B', 'C', '7', 'C', '6', '1', 'E', '5', 'B', '2', 'B', '5', '6', '2', 'D',
    'A', '1', '5', 'E', '3', '3', '1', '6', '7', 'F', '5', '9', '5', '3', '8', 'F',
    '5', 'E', 'F', '8', '6', 'D', '0', '4', '2', 'D', '1', '7', '1', 'C', 'F', '2',
    'F', 'A', '6', '6', 'B', 'E', 'D', '1', '9', '6', '3', 'C', '2', '4', '2', '3',
    '5', 'A', '5', 'D', '3', '2', 'A', '7', 'D', 'C', '9', '3', '6', '1', 'A', '0',
    '7', '4', 'D', '1', '1', 'E', '6', '4', 'C', 'E', 'D', '2', '3', '1', '1', '7',
    '6', 'A', '0', '7', '8', '8', '2', '3', 'D', '4', '6', '3', '7', '8', '2', 'A',
    'E', '7', '3', '4', 'C', '6', 'A', 'C', '0', '7', '8', 'C', '1', '8', '5', '0',
    '1', '0', '8', '1', '0', 'D', '6', '8', '9', '1', '6', '8', 'E', 'B', 'F', '3',
    'C', 'F', 'D', '7', '5', 'E', 'B', '3', '0', '6', '2', '3', '5', '7', '5', 'A',
    '6', '4', 'B', '8', '5', 'C', 'A', 'E', 'D', 'B', 'E', 'C', 'E', 'B', '3', 'A',
    'D', 'B', '6', 'F', '9', '0', 'B', '4', 'A', '1', 'F', '8', 'E', 'A', 'A', 'C',
    '6', 'C', '4', 'E', 'E', '8', '3', '6', '1', 'F', '6', 'C', 'E', '1', '7', 'F',
    '4', '7', '6', '5', 'F', '1', '7', 'C', '3', 'E', 'C', '0', '4', '2', '8', '3',
    'B', '7', 'B', 'D', '0', 'C', 'C', '0', 'C', '2', 'A', '8', '8', '2', 'A', 'D',
    'B', '5', 'E', '4', '3', '1', '1', '6', '4', '8', '8', '6', '7', 'C', 'C', 'A',
    '0', '0', '4', 'F', 'D', '1', 'B', 'F', '8', '2', 'C', '1', 'D', '7', '9', 'A',
    'F', '7', '7', 'C', '4', '6', '4', 'A', '3', 'E', '7', '8', 'C', '2', '1', '0',
    'B', '0', 'F', 'C', 'B', '2', '2', 'C', '7', 'B', '3', 'A', '8', '3', '4', 'D',
    '8', '0', '5', '3', '8', '3', 'F', '9', 'E', 'B', 'C', '5', '1', '2', '6', 'D',
    '9', '2', 'D', 'E', 'B', 'C', '3', '6', 'A', 'D', '7', '7', 'A', '9', 'D', '9',
    '2', '9', '0', '3', '3', 'E', '7', 'E', '1', '4', 'D', '9', 'E', 'E', '7', 'E',
    '4', '8', '0', 'D', '6', '2', '1', 'E', 'C', 'C', 'D', '0', 'C', '5', '0', '8',
    '8', '4', 'F', 'C', 'F', '5', 'D', '3', '8', '7', '4', '9', '2', '3', '4', '5',
    '2', '2', '8', 'A', 'A', '8', '0', '2', 'E', 'C', 'F', '8', '8', '5', 'A', '9',
    '6', 'B', '5', 'B', '6', '9', '9', '5', 'A', '4', '4', '7', '4', 'C', '5', '8',
    '0', '7', '7', 'F', '5', 'A', 'D', '9', '0', 'E', '0', '8', '2', 'F', '0', 'A',
    '4', '1', '2', 'F', 'E', 'B', '8', '8', '3', 'D', '5', 'D', '4', 'B', 'B', 'D',
    'A', '8', 'E', '9', 'D', '6', 'C', 'C', '1', '3', '1', 'D', '7', 'A', 'E', '1',
    'B', '2', '4', '3', '0', 'F', 'C', '5', '2', '7', '9', '0', '8', '1', 'D', 'B',
    'C', '6', '4', 'F', '9', '8', 'E', '7', '1', '0', '5', 'A', '2', 'B', '8', '3',
    'F', '0', '3', '3', 'D', '8', '4', 'A', '5', '5', 'E', 'A', '1', '1', '3', '4',
    'E', '4', 'A', '4', 'C', '4', 'B', '6', '2', '7', '8', '8', '2', '7', '9', 'D',
    'C', '6', 'E', '1', 'F', '3', '4', 'F', '0', '3', 'D', 'C', '1', '2', '8', '9',
    '4', '5', '7', '7', 'E', 'C', '4', 'C', 'F', 'C', '7', 'C', '0', '0', 'D', '4',
    'B', '7', 'E', 'B', '4', '6', '3', 'D', 'D', '3', 'D', '9', '5', 'E', '2', '3',
    '5', '7', '8', 'D', '8', 'C', '2', 'C', '6', '1', '4', 'B', 'E', '6', 'A', 'A',
    '3', 'D', 'A', 'C', '0', 'D', 'A', '3', 'E', 'C', '9', '2', 'C', '1', '9', 'A',
    '2', 'F', '7', 'E', 'B', '4', 'A', '7', '4', '7', '2', '4', '5', '5', 'C', 'D',
    'A', '1', '4', '4', 'F', '0', '6', 'E', 'E', '3', 'D', 'D', 'F', '2', '0', '6',
    '0', '8', '4', '8', '6', '6', '1', 'C', '0', 'C', 'B', '7', '3', 'F', 'A', '3',
    '9', '1', '2', '1', 'A', '6', 'E', '7', '8', 'B', '6', '3', '6', 'D', '2', '4',
    '4', '3', '3', 'B', 'A', 'C', 'C', 'A', '2', '7', 'E', '6', '7', 'B', '2', 'A',
    '0', '3', '1', '7', 'A', 'F', '5', 'E', 'E', '7', 'A', 'E', 'A', '6', '1', 'E',
    '8', 'E', '2', 'F', '4', 'D', '1', 'D', 'B', '6', 'D', '3', '6', 'D', '1', 'E',
    '9', '0', '3', '3', '9', '8', '2', 'C', '9', '1', '5', '9', 'D', '7', 'B', '5',
    'F', 'F', '4', '9', '3', 'E', '4', '1', 'D', '0', '4', 'B', '6', '4', '1', '2',
    'D', '3', '7', 'F', '9', '7', 'F', 'C', '7', '6', 'D', 'C', '4', 'C', 'D', 'B',
    '7', '1', 'F', 'E', '1', '7', '2', 'C', 'C', '1', '2', 'B', 'D', '2', '4', 'D',
    '3', '9', 'B', '6', 'D', '7', '6', '6', '9', '1', '0', '0', 'B', 'C', '3', '3',
    'B', '8', '5', 'C', '5', '1', 'D', 'B', '6', 'D', '7', '6', 'E', '2', 'A', 'A',
    '6', '0', 'B', 'F', '0', '4', 'E', '1', 'D', '0', 'D', '5', '8', '8', 'A', '7',
    '9', '6', '4', '1', 'D', 'B', 'C', '4', '7', '8', '7', 'B', '3', '0', '5', 'B',
    'E', '9', '0', 'E', '6', '1', '8', '1', '6', '5', 'E', '1', 'E', '3', '8', 'C',
    '6', 'F', '4', 'E', '3', '6', 'C', '4', 'A', '0', '9', 'E', 'C', 'A', 'B', '8',
    'E', 'B', 'B', '7', 'C', 'E', '0', '1', '0', '0', '9', '5', '5', 'D', '6', '4',
    '4', '9', '2', 'D', '4', '1', '2', '0', '8', '1', 'D', '8', '6', '3', 'B', '3',
    '4', '5', '5', '0', 'E', 'B', '7', '5', 'E', 'C', 'D', '1', '1', '2', '1', 'F',
    'A', 'F', 'D', '5', 'B', '0', '2', '8', 'B', '1', '6', '9', 'C', 'A', 'D', '4',
    '9', '4', 'D', 'D', 'C', 'C', '3', '7', '8', '9', '0', 'A', '6', 'E', '2', 'F',
    '6', '9', '1', 'E', 'E', '1', '8', '5', '6', 'D', '3', 'D', 'E', '6', '2', '6',
    '9', '0', 'A', '7', 'C', '3', '8', '8', '8', '5', '4', '5', '6', 'F', '9', '0',
    'C', '5', '6', '4', '1', '1', '8', '7', 'A', '3', 'F', '5', '9', 'F', '6', '2',
    '3', '5', '1', '6', '5', '7', 'F', '4', '1', '7', '5', '2', 'A', 'D', '2', 'D',
    '5', 'E', '4', 'B', '1', '5', 'E', '1', 'A', 'E', 'D', '8', 'F', '1', '5', '2',
    'B', '7', '1', '5', 'D', '9', '5', 'A', '1', '5', '0', '6', '8', '9', 'A', '3',
    '7', '5', '9', '8', '4', '8', '9', '8', 'D', '3', '8', '5', 'D', '9', '6', '1',
    '5', '4', 'E', '9', '4', '3', '9', '2', 'F', 'E', '3', 'E', 'F', '2', '9', '9',
    '3', 'B', 'D', '4', '6', 'B', '1', 'E', 'E', 'B', 'E', '3', '6', 'A', '5', '6',
    '8', 'D', '9', '2', 'D', 'A', 'C', 'C', 'C', '7', 'C', '1', '4', 'B', 'E', '1',
    '1', 'C', '9', '1', '7', 'D', '4', 'D', '9', 'C', '4', 'F', '4', '1', '7', '6',
    '5', 'A', '5', '3', '2', '8', '1', '6', '9', 'A', '2', 'E', '0', '6', '7', '2',
    'F', '9', '5', '9', '0', '8', 'D', '0', 'A', '9', 'A', 'D', '5', '4', '3', '9',
    'C', '4', 'B', 'A', '8', 'C', '8', 'E', '4', '3', '9', 'D', '9', '0', '7', 'B',
    '0', '1', 'B', 'B', '0', '0', '1', '3', '4', '8', '1', '3', '6', '7', '8', '9',
    'A', 'A', '3', '4', '5', '2', '9', '1', '2', 'D', '1', '1', 'E', '1', 'A', 'B',
    '3', 'D', '2', '8', '9', 'A', '8', 'E', 'E', 'B', '0', '1', 'A', 'F', '2', 'F',
    '5', 'A', '8', '3', '0', 'A', '1', '2', 'B', 'C', 'D', 'B', 'C', '6', '6', 'F',
    '0', '0', '5', '5', 'E', '9', '0', '6', 'E', '0', 'E', '6', '3', '1', '3', '3',
    'A', 'F', '3', '9', 'A', 'C', 'B', '1', 'B', '0', '7', 'F', 'A', 'A', 'F', '9',
    '6', '6', '9', '5', 'C', '0', '0', '9', 'B', '7', '2', '8', '2', 'D', 'D', 'E',
    'F', '2', '4', '3', '2', '8', '8', '1', '2', 'E', 'A', 'A', 'A', 'D', '3', 'C',
    'C', '1', 'E', 'D', '6', 'D', 'F', '1', 'A', 'C', 'F', '6', 'F', 'D', '3', '7',
    '7', '8', 'C', 'B', 'B', '4', '1', 'F', 'E', '3', '5', '9', '5', 'A', '2', '9',
    '9', '4', '7', '6', 'C', 'B', '1', 'E', '6', '5', '6', '5', '6', 'E', '4', 'A',
    'E', '4', 'E', 'C', '7', 'A', '1', '1', '2', 'C', '4', 'C', '9', '4', '0', '9',
    '2', '3', '6', '2', '2', 'C', '9', '4', '9', '8', 'E', '7', 'B', '2', '1', '8',
    'D', '7', '8', 'F', '6', 'F', '4', 'F', '3', '9', 'B', 'D', '2', '7', 'A', 'B',
    '6', 'E', '0', '9', 'B', 'F', '3', '8', '1', 'C', 'A', '9', '6', 'C', '6', '6',
    'A', '8', 'F', '0', 'C', '8', 'F', '0', '4', '7', 'E', '0', 'D', 'F', 'D', 'F',
    '1', 'A', 'D', 'A', 'D', 'D', 'C', '7', '7', 'B', '2', '1', 'D', '1', '5', 'E',
    '8', '3', '9', '2', '3', '3', 'F', '8', '5', '2', '3', '9', '9', 'D', '1', '5',
    'F', '9', 'C', 'E', '6', 'D', '3', '3', '8', '3', '4', '4', 'C', 'A', 'D', '4',
    '3', 'A', '5', '9', '1', '1', '2', '2', 'C', '4', '8', '8', 'B', '2', '2', '2',
    '0', 'A', '3', '4', 'D', '8', '2', '1', '5', 'C', '3', 'F', '4', '4', 'A', '7',
    '0', 'E', '1', '2', '4', '9', '6', '9', 'F', '8', '1', '6', '7', '5', 'B', 'F',
    '0', '1', '0', '5', '8', '7', '7', '9', '0', '3', '3', 'F', '2', '3', 'D', 'B',
    'E', '9', '6', '7', 'B', 'F', '2', 'A', 'E', 'E', 'F', '2', 'B', 'C', '1', 'F',
    'F', '9', '7', 'A', 'F', 'E', '5', '7', '5', '7', 'C', '0', '9', 'E', 'F', '0',
    'B', '3', '3', 'F', '7', '2', 'E', '2', '6', '0', 'C', '5', 'C', '5', '7', '2',
    'B', '6', 'A', '8', '7', '1', '8', 'A', '1', '6', '3', 'A', 'D', 'C', '5', '0',
    'E', 'E', '7', 'E', '2', '1', '0', '8', '9', '7', 'F', '6', '6', '3', '7', 'F',
    'D', '2', 'C', 'E', 'F', '8', '7', '2', '1', '3', '8', '3', '5', 'C', '1', 'D',
    '6', 'D', 'C', '4', 'D', '5', '1', '3', 'F', 'B', '2', '4', '0', '0', '0', 'B',
    '6', '4', 'B', 'D', '2', 'D', 'F', 'D', '0', '3', 'F', 'C', 'F', '3', 'E', 'C',
    '9', '1', '6', '8', '6', '8', 'B', 'E', '1', '2', 'D', '8', '5', '7', 'C', '9',
    'D', '4', '2', 'E', '5', 'E', '5', '7', '1', '7', 'E', '5', 'B', '0', '3', '5',
    'C', 'E', '1', 'B', '9', 'D', '0', 'B', '9', 'B', '5', '5', 'A', '5', 'B', '7',
    'A', '3', '6', '3', '1', 'A', 'E', '9', 'E', 'F', '9', '1', '0', '1', 'A', '2',
    '5', '4', 'F', '4', '0', 'D', '7', '7', 'A', '8', '4', 'D', '3', 'D', '4', '7',
    '5', '9', 'D', '3', 'E', '5', '1', '0', '2', '7', 'E', 'A', '8', '1', '8', '3',
    'A', '5', 'D', 'D', 'C', '4', 'F', '7', '9', 'F', '8', '0', '2', '2', 'A', '1',
    'E', 'F', '6', '2', 'A', '4', '8', '3', '4', '2', 'B', '6', '3', '0', 'D', '5',
    '1', '7', 'D', '0', 'E', 'F', '4', '5', '5', 'D', '8', 'C', 'E', '9', '9', '8',
    '0', 'F', '1', 'A', '8', 'B', '6', '5', '7', 'A', 'A', 'C', 'B', '0', '6', 'C',
    '9', '0', 'B', 'E', 'A', 'A', 'E', '9', '5', 'C', '0', '8', '4', '2', 'E', '6',
    '9', '3', '0', 'A', '6', '5', '7', '8', 'E', '7', 'D', '3', '5', '2', '1', '8',
    '3', 'E', '9', '2', 'C', '2', 'B', '8', 'C', '4', '3', '6', 'B', 'D', 'D', 'C',
    '2', '5', '3', 'C', 'F', '4', '7', 'E', '9', 'F', '1', '3', '7', '7', '0', 'E',
    '8', '0', 'E', '1', 'B', 'E', '9', '6', '5', '3', '8', '2', 'D', '7', 'B', '7',
    'A', '3', '9', 'C', 'B', 'D', 'E', '6', 'F', '2', '4', 'C', '3', '1', '4', '9',
    '5', '4', 'E', 'E', 'B', '1', '6', '5', '8', '3', 'D', '4', '4', '9', 'A', '7',
    '8', '1', '8', '4', 'A', 'C', '8', 'C', 'C', 'F', '8', '5', '4', 'F', '1', '8',
    '4', '5', 'C', 'E', '1', 'D', 'D', 'F', 'C', 'C', '8', '5', '4', 'E', '9', 'F',
    '7', '7', 'E', '0', 'B', 'C', '9', 'C', 'A', 'B', '5', '6', '2', 'A', 'A', 'E',
    '0', '8', '4', 'D', '7', 'C', '7', '9', '3', 'F', '2', '3', '7', 'F', '6', '8',
    '5', 'B', 'D', '4', 'B', 'A', 'D', '2', 'F', '6', 'C', '1', '3', '8', 'A', '1',
    'E', '0', 'E', '8', 'C', 'B', '4', 'D', 'F', '7', '3', '8', '4', '1', '9', '8',
    '4', 'F', 'D', '8', '5', 'C', '2', 'C', '6', '9', 'B', '2', '9', 'E', 'A', '8',
    '3', '1', 'E', '6', '3', '3', '7', '6', 'F', '6', '0', '8', '5', '6', '0', 'B',
    'E', '7', 'C', 'A', 'E', 'A', 'A', '2', 'F', '2', '7', '3', '9', 'C', 'A', '9',
    'D', '0', 'C', '7', 'B', '8', 'E', '0', '5', 'A', 'F', 'E', '8', '8', '3', '9',
    '1', '0', '4', 'D', '9', 'F', '7', '0', 'B', '0', 'C', '2', '9', '0', 'A', '0',
    '5', '9', '9', 'B', '2', 'F', 'D', 'D', '8', 'E', 'B', 'C', '1', '6', 'C', '0',
    '4', 'B', '6', '4', '4', 'F', '5', '1', 'E', '6', '1', '0', 'B', '2', 'F', '6',
    '8', '1', '2', 'F', '7', '1', '5', '1', '4', 'F', '0', 'B', 'C', 'C', '8', 'B',
    '6', 'E', 'F', 'D', '6', '2', 'D', '8', 'A', '2', '6', '2', '6', 'E', 'A', 'A',
    'A', '8', 'A', '4', '5', '2', 'D', '8', 'B', 'E', '8', 'E', 'F', '0', '1', 'B',
    '6', '0', 'E', '1', '0', 'B', 'F', '4', '9', 'B', 'B', 'D', '2', '5', '1', 'F',
    '0', '6', '3', '4', '5', '1', 'A', 'D', '6', 'A', 'D', 'A', '3', 'D', '4', '6',
    'F', '9', '1', '0', '9', '6', '6', '6', '1', 'D', '2', 'D', '6', 'F', 'B', '8',
    '2', '4', 'B', '0', 'F', '2', '1', '4', '5', '0', '3', '9', '4', 'A', '8', '1',
    'D', '5', 'C', 'B', '5', 'C', '8', 'D', '6', '1', 'A', 'B', '1', '3', '0', '6',
    '1', 'C', '2', '0', '7', 'E', '7', '7', '9', '1', '7', 'F', '6', '0', '0', '0',
    '2', 'D', 'E', '9', '7', '4', 'B', '2', '3', '3', 'F', '9', '4', '5', '2', 'C',
    'F', '9', '5', '0', '3', '0', '6', 'A', 'D', 'E', '4', '2', 'D', '8', 'B', 'A',
    '9', '5', '6', '2', '2', 'E', '9', 'A', '4', '6', '0', '6', '6', '3', '7', '7',
    'D', '8', '2', 'D', '2', 'A', 'E', 'E', 'F', 'D', '6', 'C', '6', '6', 'B', 'F',
    '2', '8', '0', 'D', 'F', '5', '8', '3', 'E', '4', 'E', 'F', 'D', '4', 'D', 'A',
    'F', 'C', 'C', 'D', 'E', '2', 'F', 'D', '6', '2', 'E', '6', '4', 'B', 'B', '2',
    'C', 'F', '2', '8', 'F', '6', '9', 'F', '3', 'A', '1', '8', '8', 'D', '0', 'C',
    'D', 'F', 'C', '0', '2', '9', '1', 'C', 'D', 'C', 'B', 'B', '8', '4', 'F', 'F',
    'B', 'C', '0', 'D', 'A', '0', '7', 'E', '8', '9', '3', 'B', '2', '1', 'E', 'E',
    'F', 'D', '8', '0', '6', 'B', 'A', '2', '6', 'C', 'E', 'A', 'A', 'A', '5', '1',
    '2', 'D', '3', 'C', '0', 'C', '8', 'E', '1', '2', '5', 'C', '3', 'D', 'B', 'B',
    'C', '9', '9', '0', 'A', 'F', 'E', '7', '9', '2', 'F', '0', '8', 'C', '6', 'D',
    'F', 'D', '1', 'F', '3', '3', '2', '6', '6', '3', '9', '0', 'E', '3', 'B', 'E',
    '3', '9', '3', '7', '0', 'A', '1', '3', '1', 'F', '2', 'E', 'E', 'D', 'F', 'B',
    '7', '2', '5', '3', 'C', 'A', 'B', 'D', 'E', '5', '5', '3', '7', 'A', '9', '9',
    'D', '2', '3', '8', 'E', '4', 'B', '9', '6', '6', '1', 'F', 'A', 'F', '7', '6',
    'D', '0', '8', '8', '8', 'D', 'A', 'E', 'B', 'F', '3', '1', '2', 'F', '4', '4',
    '9', '3', '0', '9', 'E', '2', 'E', '8', '8', 'E', '4', '5', '7', '8', '2', '6',
    '2', '2', '2', '1', 'A', '4', '5', '8', '6', '4', '0', '1', 'C', 'D', '8', '2',
    '3', '8', '8', '0', '4', '8', '3', 'F', '9', '4', 'A', '8', '4', '7', 'A', 'E',
    '1', '9', 'A', 'E', '7', '8', 'A', '6', '2', 'B', '8', '3', '1', 'F', 'D', 'D',
    '7', '1', 'B', '1', '4', 'B', 'C', 'C', '2', '2', '3', '4', '5', '1', '5', 'C',
    '2', '1', '8', '9', 'E', 'F', '8', '0', 'A', '0', '6', '1', 'B', '9', 'D', '6',
    '5', '6', 'F', '3', 'E', '6', '0', '5', '8', 'B', '1', '7', '8', '7', '4', '1',
    '1', '2', '6', '9', 'C', '5', '1', 'C', '3', '8', '0', '3', '1', '8', '9', '3',
    'A', 'D', 'F', '5', 'C', '7', '1', '6', '8', '2', '4', 'E', 'E', '4', 'E', 'F',
    '3', 'E', '5', '6', '0', 'B', '5', '6', 'B', 'B', 'D', '0', '1', 'C', '2', 'A',
    '4', 'C', 'D', '1', 'D', '0', 'E', 'B', 'E', 'A', 'F', '3', '4', '6', '0', 'E',
    '0', 'B', 'E', '0', '9', '4', 'F', 'E', '5', '9', '2', '6', '7', '4', 'F', '5',
    'D', '8', '8', 'B', 'D', '7', '9', '2', '1', '5', '5', '7', 'A', 'C', 'C', 'B',
    'C', '8', 'A', '3', '8', 'E', '2', 'D', '9', '7', '3', '1', '3', '2', 'F', 'A',
    'E', '8', '9', 'D', 'D', '9', '7', 'F', 'A', 'B', 'C', '0', 'A', '3', '6', 'B',
    '5', '1', 'D', '5', '5', '1', 'B', '6', 'B', '9', '2', '0', 'E', '6', '6', '3',
    '1', 'B', '4', '6', '9', '5', '8', '2', 'C', 'D', '3', 'B', 'B', '7', 'A', '2',
    'C', 'F', '2', '1', '3', '5', '6', '0', 'D', '3', '5', '2', '2', '1', 'A', '5',
    'C', '1', 'E', 'A', '0', '8', '8', 'A', '3', 'F', 'D', '6', '2', '9', '2', 'F',
    '7', 'D', 'E', '3', '3', '9', '2', '8', '5', 'D', 'A', '2', '8', '5', '8', 'C',
    '7', '5', 'A', '9', '3', '9', 'A', '8', '0', '7', '7', '3', 'F', 'F', '6', '6',
    '0', '4', '5', '1', 'F', 'E', 'A', '7', '2', 'F', '4', '9', '1', '2', '2', '9',
    '6', '8', 'A', 'E', '3', '7', '3', 'B', '0', 'B', '2', '3', '2', '6', '0', '9',
    '1', '3', 'F', '4', '0', 'E', '8', '8', '8', '9', 'E', '9', 'E', '0', '9', '7',
    '7', '5', '4', 'D', '1', 'D', 'D', '7', '4', '2', '2', '3', 'E', '2', 'F', '4',
    '9', 'B', '9', 'D', '1', 'B', 'C', 'E', '2', 'B', '1', '5', '1', '9', '0', '8',
    '4', '5', '2', '5', 'C', '2', '5', 'E', '8', 'B', '8', 'D', '1', '9', 'A', 'A',
    'B', '3', '4', 'B', '0', '2', 'C', '2', '3', '2', 'A', '0', 'D', '3', 'D', '9',
    '3', '0', 'B', 'F', '1', 'E', '0', 'B', '4', '3', '4', '9', '1', '2', 'A', '8',
    'D', '3', '5', 'B', 'C', '6', '6', 'D', 'A', '5', '2', '7', '4', 'D', 'D', '6',
    'B', 'C', '5', 'E', 'E', '3', '5', '3', '8', '8', '9', 'E', '0', 'D', '7', '5',
    '3', 'D', 'D', '1', 'C', '6', '9', '8', '2', '1', '3', '9', 'A', '6', 'E', 'F',
    '1', 'E', 'E', '2', '1', '2', '0', '1', 'A', 'B', 'F', '7', 'B', '0', '4', '5',
    '9', '4', 'F', '8', '0', '2', 'D', 'C', '6', '2', '2', '8', 'B', 'B', 'A', '7',
    '8', '0', 'F', '1', '2', 'E', 'A', '9', '2', '9', '9', 'A', '6', 'F', 'D', 'A',
    '4', 'A', '9', '1', '9', '2', 'F', 'B', '0', '5', '3', '0', '3', '7', '4', '2',
    '0', '8', '6', '1', 'F', 'D', '0', '8', '9', 'E', '6', 'A', 'F', 'F', '1', 'A',
    '0', 'A', 'E', 'F', 'E', '5', '0', '6', '8', '7', '3', '9', '7', 'E', '1', '4',
    '8', '9', 'F', '4', '3', '7', '7', '7', '6', 'C', '4', '7', '9', '0', 'C', 'E',
    '4', '0', '3', '2', '1', 'B', '7', '3', '7', '2', '7', 'F', '0', '9', '9', '6',
    'C', '7', '9', 'F', 'E', '0', '3', '8', 'F', '0', 'D', '8', '2', '4', 'E', 'D',
    '1', 'A', '6', '8', 'C', '5', 'E', '3', 'F', '1', '4', '0', '5', '4', 'D', 'D',
    '7', 'E', 'F', '9', 'D', '6', '0', 'E', '8', 'A', 'D', 'B', 'E', '1', 'B', 'F',
    '4', '0', '7', 'E', '6', 'F', '6', 'C', '8', '5', '4', 'C', '5', 'D', 'A', '8',
    '6', '6', '4', '1', '0', '2', '3', 'D', '0', '2', '6', '0', 'A', '5', '8', 'B',
    '4', 'D', '8', '8', '6', '5', 'C', '3', '8', 'C', 'B', 'B', 'C', '1', '4', 'E',
    '9', '8', '4', '9', 'D', 'B', 'A', '3', 'F', 'F', 'E', '2', 'F', '8', '2', '0',
    '7', 'A', '2', 'E', 'E', 'E', '5', '2', '6', '7', '9', '6', '8', '5', 'B', '6',
    'F', 'D', 'E', '9', 'B', '9', 'B', '7', 'B', '1', '5', '7', '4', '1', '5', 'D',
    '3', '7', '2', 'C', 'C', '8', '3', 'C', '1', '7', '1', '0', '4', 'B', 'F', '7',
    '7', 'B', '3', 'D', 'D', '2', 'D', '3', '3', 'B', 'F', '2', 'C', 'F', 'F', '1',
    'A', 'B', 'B', '5', 'F', '9', '7', '7', '2', '0', 'C', '2', '6', '5', '8', 'B',
    '6', 'B', '2', 'F', '2', '6', 'C', 'F', '0', '7', '0', '9', '8', '9', 'C', '5',
    '0', 'F', '6', '6', '3', '1', '3', 'B', 'C', 'E', 'A', '9', '0', 'A', '2', 'B',
    '0', 'F', 'E', 'F', 'B', '3', 'B', '7', '1', '1', 'A', '1', '2', 'F', 'A', '9',
    '1', 'C', 'F', 'F', '6', '2', 'F', '3', '7', 'A', 'B', 'C', '3', 'F', '7', '4',
    '5', '6', 'C', '2', '7', '1', 'A', 'E', 'D', '8', 'A', 'F', '7', '2', '8', '1',
    'D', '5', '4', '5', 'C', '1', '4', '6', '3', 'F', '5', 'A', 'D', 'B', 'B', 'F',
    '6', '3', 'A', 'C', '4', 'C', 'B', '5', '1', '9', '1', 'F', '1', 'A', '2', '3',
    '9', '2', '6', '3', 'E', '0', '9', 'F', '3', '7', 'A', '6', 'D', '7', '9', 'B',
    '9', 'A', 'E', 'B', 'D', 'B', 'C', 'C', '8', 'D', 'E', '1', '2', '7', '3', 'D',
    'D', '8', '4', 'A', '3', '7', '9', '5', '7', 'D', '6', '2', '5', '9', '3', 'B',
    '4', '6', '6', '9', '1', '1', 'F', 'A', '7', 'B', '0', '8', 'C', '0', 'D', '8',
    'A', 'F', 'C', 'C', 'D', 'C', '6', 'E', '9', 'E', '4', '8', '1', '1', 'D', '4',
    '1', 'A', '0', '7', '1', '4', '9', '3', 'C', '9', 'E', '7', 'A', '8', '3', '9',
    'A', 'D', '5', '7', '5', 'E', 'D', '3', 'F', '2', 'E', '2', '4', '0', '3', '4',
    '6', '1', '5', '7', 'C', '9', 'B', 'C', '9', '3', '9', '5', '7', 'D', 'E', '6',
    '0', 'F', '8', 'E', 'D', 'E', '4', '3', '0', 'B', 'A', '0', '0', 'E', '9', '3',
    '6', 'E', '7', '2', '1', 'D', 'F', '9', '7', '0', 'A', 'E', 'A', 'D', '7', 'A',
    'D', '7', '9', 'D', 'E', '3', 'D', '7', 'B', '5', 'E', '5', '5', '8', 'E', '5',
    'D', '0', 'C', '1', '3', 'B', '0', 'C', '0', '3', '3', 'E', 'C', 'B', '6', 'B',
    'E', '2', 'C', '7', 'E', '7', 'D', '6', '3', 'D', 'C', '0', '9', '6', 'F', '5',
    'B', 'C', 'D', '5', 'B', 'F', '8', '2', 'D', 'B', 'D', '0', '3', '4', '3', '7',
    'A', '5', '1', '9', 'D', '7', '7', '4', 'A', 'C', '5', 'B', 'B', '9', 'A', 'D',
    '7', 'E', 'D', '4', '5', 'B', '4', '1', '3', 'F', '6', '7', '5', '7', '8', '5',
    '2', '6', '6', '3', 'A', '1', '6', 'D', '0', '1', 'D', 'E', '2', '3', 'D', '5',
    'B', 'A', '6', 'D', '9', '8', '4', 'A', '9', 'B', '6', 'F', '2', 'F', 'A', '5',
    '4', '7', '2', 'D', 'A', 'D', '3', '8', '6', '2', 'F', '1', 'B', 'F', 'D', '7',
    '6', '4', 'E', '6', '9', '1', 'E', '7', '9', '4', 'C', 'A', '6', '0', '1', '9',
    'C', '9', '4', 'B', '9', 'A', '0', 'D', 'F', '0', '8', 'B', '9', 'D', 'C', '6',
    '8', '6', '1', 'D', '4', 'C', 'F', 'D', '0', '8', '0', '2', 'A', 'E', 'C', '4',
    'E', 'C', '9', 'D', '2', '2', '4', 'B', 'C', 'C', '2', 'C', 'F', '4', '8', 'E',
    'B', '3', '6', '0', '7', '4', '0', '0', 'E', 'D', 'F', '2', 'A', 'D', '3', 'C',
    'A', '8', '7', 'F', '0', '4', '9', '5', '5', '6', '3', '8', 'F', '1', '3', '4',
    '9', '5', '1', 'F', 'F', '0', '9', 'E', '7', '7', 'A', 'E', '1', '9', '4', '2',
    '0', '2', 'E', '2', 'A', '8', 'F', 'F', '5', 'D', '0', '1', '3', '0', '0', '6',
    'C', '4', 'C', 'F', '6', '0', 'E', '3', 'E', '8', '9', '7', '6', '3', 'D', '5',
    '8', 'D', '4', '3', '4', '0', '4', '6', 'D', '1', '3', 'C', '2', '5', 'C', '0',
    '2', '8', '4', '9', 'E', '2', 'E', '8', 'E', 'A', '3', 'D', '3', 'F', 'F', '4',
    '5', 'F', '5', '0', '4', '2', 'D', '1', 'A', '6', '5', 'E', 'E', 'D', '0', 'F',
    '9', 'C', '7', 'A', 'D', 'D', '9', '0', '2', '6', '6', '6', '2', '2', '3', '4',
    '7', '8', 'F', 'A', 'B', '9', '3', 'D', '1', 'C', '4', '6', '3', 'C', '6', '7',
    '4', 'A', '2', '2', 'D', '2', '5', 'E', 'F', '7', 'D', '4', 'C', 'A', 'E', '4',
    '4', '1', 'F', 'C', 'A', '5', '8', '5', '2', 'E', '8', 'C', 'B', '9', 'E', '7',
    'A', '7', '4', 'F', 'A', '9', '7', '9', '0', 'B', '6', '0', 'D', 'A', '7', 'F',
    'B', 'D', '5', 'E', 'E', '7', '1', '4', 'C', '2', '5', '5', 'F', 'C', 'B', '8',
    '9', '9', 'C', '3', '4', '1', '1', '5', '9', '1', '0', '7', 'F', '2', '9', 'F',
    'A', '8', '7', 'D', '5', 'B', '0', 'E', '1', 'D', 'E', 'B', '4', '9', '5', 'F',
    '5', '2', '2', 'C', '3', '4', '6', 'A', '9', 'A', '1', 'F', '1', 'C', 'C', 'B',
    'F', '9', '2', 'E', '7', '1', 'A', '9', '2', '6', '8', 'E', '0', '7', '6', '7',
    '7', '2', 'B', 'C', 'F', '5', 'E', '0', '3', 'D', 'A', '4', '0', 'F', 'F', 'F',
    '8', '7', 'F', '8', 'F', '1', '8', '1', 'D', '1', '3', 'F', '6', '6', 'F', '3',
    '2', 'E', 'D', '8', '8', '1', '9', '1', 'B', '0', '0', 'F', '6', 'E', 'E', 'C',
    '5', '8', '5', '9', 'B', 'F', '1', 'F', '5', 'A', '3', '8', 'F', 'C', 'C', 'B',
    '2', '0', '7', 'C', 'D', '7', '6', '0', 'A', 'B', 'F', '5', '7', '8', '3', '0',
    'D', '7', 'E', '1', '6', '6', 'A', '9', 'C', '5', 'C', 'C', '2', '2', '3', '9',
    '9', 'C', '2', 'C', '2', 'E', 'A', '7', 'C', '6', 'C', 'E', 'F', 'E', '7', 'F',
    '7', 'F', '2', 'E', 'E', 'E', '5', '5', 'A', '5', 'D', 'B', '5', '0', 'F', '7',
    '1', '7', '3', 'C', 'A', '2', '9', '6', '5', '5', 'B', '7', 'A', 'F', '0', '7',
    '1', 'B', '1', 'D', 'D', '6', '0', 'E', '2', 'D', '1', 'B', '3', '2', '4', 'F',
    'E', '5', '4', '9', 'D', 'A', '0', '9', '9', '3', '1', 'C', '7', 'C', '9', 'A',
    '9', 'D', 'D', '5', '1', '2', '6', 'B', '7', 'D', '7', '7', '3', 'C', 'C', '9',
    '9', '4', '3', 'E', 'C', '4', '0', '5', '2', 'B', 'C', 'E', '5', 'D', '3', 'C',
    'B', '6', 'E', '7', '1', '7', 'D', '3', 'F', '6', 'A', '3', '9', 'C', 'A', 'F',
    '2', '5', 'E', '6', 'F', '2', 'D', '8', '0', '1', '2', '9', '0', 'B', '8', '5',
    'D', '6', '4', '9', '8', 'A', '7', '4', '2', '1', '9', '3', '0', '0', 'D', '0',
    'A', '0', '4', '1', '3', '3', 'F', 'B', 'C', '2', 'B', 'A', 'C', 'E', '4', '9',
    'D', 'C', '2', '5', '1', '7', '4', '6', 'C', 'A', '2', '4', '0', '9', '0', '8',
    'C', '3', '2', 'F', '3', '3', '5', '4', '7', '2', '1', '3', 'C', 'F', 'A', 'F',
    'C', '5', '3', '4', 'D', '9', 'F', '2', '1', '6', '6', '6', '0', '0', '5', '2',
    '0', '2', '8', '1', '0', '3', '8', '7', '9', '2', 'A', '4', 'B', 'F', 'D', '4',
    'C', 'F', '4', '2', 'D', '5', 'F', '2', 'A', 'C', '9', '3', '2', '5', '7', '2',
    '2', '3', '9', 'A', '2', '5', 'B', 'D', 'E', 'C', '8', '2', '7', '3', '9', 'C',
    'B', 'B', 'C', 'C', 'A', '8', '3', 'F', '2', 'C', 'C', '9', 'A', '7', 'C', 'F',
    'A', '4', '6', '9', 'F', '8', '4', 'F', '5', '0', '1', '6', 'C', '5', '2', 'E',
    '3', '8', '5', 'A', '6', 'A', '2', 'E', 'C', '7', '1', '4', '6', '9', 'C', '5',
    '5', '8', 'D', '1', 'A', '8', '7', '1', '4', '1', '0', '5', '5', '8', 'E', '3',
    'A', '4', '2', '0', '8', 'F', 'A', 'C', 'D', '8', '0', 'F', 'E', '8', '8', '0',
    '9', '2', 'B', '5', 'A', 'C', 'F', 'B', 'A', 'D', 'B', 'A', 'C', 'A', '8', '5',
    '5', '7', '2', '0', 'E', '2', 'E', '8', '2', '7', '2', '2', 'D', 'C', '7', '3',
    'F', 'A', '5', '5', 'D', '4', '4', 'E', '2', '5', 'F', '3', 'A', 'B', 'D', '4',
    '5', '6', 'C', '1', 'D', 'E', '8', 'F', 'F', '8', 'B', '6', 'F', 'B', '9', 'B',
    '8', '9', 'A', '5', '6', '2', 'C', '0', '5', 'C', 'D', '0', 'B', '3', 'A', '8',
    '6', '3', '9', 'A', '2', 'B', 'F', 'C', 'C', 'A', '7', '8', '0', '0', '7', '4',
    '6', '9', 'A', '3', 'F', '1', '0', '8', 'E', '4', 'A', '1', '7', '2', '8', 'D',
    'A', '7', '1', 'C', 'A', '3', 'F', '6', 'A', 'E', 'F', 'D', '2', 'A', '8', 'B',
    'B', '0', '8', '6', '9', '1', 'E', '6', '9', '7', '8', '2', '0', '6', 'C', '8',
    'E', 'E', 'B', '2', '3', '6', '0', '3', '2', 'B', '9', '8', '3', 'F', 'E', '1',
    'C', '6', '0', 'D', '7', 'F', '1', '2', '4', '7', '2', '3', 'A', '5', '8', 'C',
    'E', 'F', '0', '9', '7', '0', 'E', 'B', '9', '4', '5', '8', '6', '1', '1', 'E',
    '9', '9', '4', 'A', '7', '0', '5', '9', '3', '5', '6', '2', 'D', '1', '4', 'A',
    'C', '2', '1', 'F', '0', '3', '8', 'B', 'A', '3', '3', '1', '8', '5', '8', '3',
    'C', '1', 'D', 'F', '8', '2', '0', '8', 'F', '8', '3', 'C', 'F', '7', 'D', '5',
    'F', 'E', '1', '2', '1', 'B', '7', '8', '4', 'F', '0', '0', '8', 'E', 'B', '6',
    'C', 'D', '6', 'A', 'C', 'F', '7', 'B', '1', '0', '7', '2', '5', '1', '5', '9',
    'B', 'D', '0', '5', '5', 'E', '1', 'C', '4', '2', 'B', '0', '1', '4', '1', '4',
    'C', '1', '8', 'F', '7', 'A', 'B', '1', '7', '4', '5', '0', '6', '1', '9', 'D',
    '8', '7', '5', '4', 'C', '3', 'A', 'A', 'D', '5', '8', '5', '9', 'D', 'A', '5',
    '6', '3', 'E', '0', '8', '8', '1', 'A', '2', 'A', 'A', '4', 'B', 'B', 'D', '4',
    '9', 'D', 'A', '3', 'A', '9', 'D', 'F', '3', 'A', '0', '7', '0', '6', 'B', '2',
    'A', 'A', '7', '8', '2', '5', '5', 'D', 'B', '6', '1', 'D', '1', '5', '5', 'D',
    '0', '6', '8', '9', '4', 'B', '0', 'F', 'F', 'F', '1', '7', '0', '8', '1', 'B',
    '5', 'A', '7', '7', '9', '4', 'D', '2', '6', '4', '8', 'D', '7', '8', 'D', 'B',
    '4', '7', '3', 'C', 'B', '1', '3', '2', '2', '9', '4', '7', 'C', '4', 'A', '3',
    '6', 'B', 'F', '9', 'F', '2', '3', '9', '6', '0', '1', '2', 'A', '4', '7', 'B',
    '1', '7', '7', '1', '0', '0', '0', '2', '9', '0', '4', 'B', '2', '9', '4', 'C',
    '7', '9', '8', 'E', 'D', 'A', '6', '5', '1', 'B', 'E', 'F', '9', 'B', '8', '9',
    '9', 'F', '1', '4', '7', '3', '0', 'D', '1', '7', '1', '7', '2', '0', 'D', '6',
    '1', '7', 'A', '6', 'E', 'C', '0', 'E', '8', '5', '6', 'A', '2', '8', '4', '5',
    '7', '0', 'F', '0', '7', '2', '8', 'A', '4', '5', 'A', '3', '0', '6', 'C', '3',
    '1', '7', '6', 'B', '4', '0', 'B', 'A', '5', '1', '9', '2', '2', '1', '1', '8',
    '7', '0', '7', '5', '2', 'A', 'D', '8', '2', 'C', '6', 'E', '6', 'A', 'C', '2',
    '4', 'C', 'F', '6', '1', '3', 'A', '1', 'B', 'C', '9', '0', '8', 'E', '2', 'C',
    '8', '8', 'E', 'A', 'F', 'A', 'C', 'C', '4', 'C', '0', '1', '0', 'F', '8', 'C',
    'C', '6', '9', 'F', 'A', '7', '1', '6', '6', '3', '7', '9', 'B', '2', '8', 'C',
    '6', '2', 'B', 'A', 'D', '4', '1', 'A', '2', '5', '3', '8', '7', '0', '3', '9',
    '7', 'A', '9', '2', '7', 'E', 'F', '4', 'C', '5', '6', '4', '0', 'C', 'A', '0',
    'E', '7', '6', 'D', '5', '0', '0', '9', '9', '7', '0', '1', 'D', '1', '0', '7',
    '9', '6', 'A', '7', '7', '2', '6', '9', '6', '2', '6', '1', 'C', '2', '0', '7',
    '0', '3', '2', 'D', 'E', '1', '7', 'A', '7', '6', 'F', '1', '1', 'A', '3', '5',
    'F', '4', 'F', '8', '9', 'D', 'A', 'B', 'B', 'F', '3', '5', '3', '0', 'E', '5',
    'E', '0', 'C', 'B', 'B', '0', '0', '1', '6', '9', 'A', '6', '7', '4', '5', '8',
    'D', 'D', 'E', '2', 'D', 'E', 'A', '0', '0', '2', 'D', '8', 'B', '3', 'D', 'F',
    '5', '3', '6', 'A', '4', '6', '6', 'F', 'F', '2', '9', '2', 'A', '8', 'F', 'A',
    '1', 'A', 'B', '0', 'F', 'C', '5', '1', 'E', 'D', '4', '4', 'C', '9', '8', 'A',
    '5', '4', 'B', '5', 'E', 'B', 'D', 'F', '1', '2', '5', '4', 'F', '9', '1', 'B',
    'A', 'D', '5', '4', '3', '2', 'C', '6', 'B', 'B', '9', 'A', '0', 'E', 'B', '6',
    '5', '7', 'E', '1', '5', '5', '4', 'E', '1', '8', 'C', '8', 'E', 'C', 'E', '6',
    '0', 'D', 'F', '2', '3', '6', 'A', 'A', '9', 'E', '3', '8', '9', '8', '1', 'B',
    'F', '7', '8', 'E', '3', '6', '8', '7', 'E', '3', '3', '2', 'C', '5', 'E', 'E',
    'D', '8', '7', 'A', 'A', '8', '7', '8', '8', 'C', '5', 'D', 'F', '8', '0', '7',
    'D', '8', '9', 'D', '3', 'F', 'C', '7', '9', '4', 'D', '1', '9', '7', 'D', '4',
    '1', '4', '4', '4', '0', '4', 'C', '6', 'A', '2', '5', '5', 'C', '2', '7', '1',
    'B', '6', '6', 'D', 'F', '3', 'C', '2', 'E', 'F', 'C', '6', '3', '7', 'E', 'C',
    '6', 'D', '0', 'C', 'C', '5', '9', '2', '1', '4', '8', 'C', '8', 'E', 'F', '4',
    '5', 'B', '6', '0', 'F', '9', '4', 'A', 'C', 'B', '9', '9', '1', '7', 'A', 'B',
    'F', '8', 'D', 'B', 'D', 'C', 'C', '2', '0', '4', 'C', 'C', '8', '8', '1', '8',
    'F', 'B', '5', 'F', '5', '3', '3', '6', 'C', 'C', 'D', 'B', 'E', 'E', '1', '7',
    '2', 'C', '8', '8', '8', '6', '3', '4', 'F', '3', '4', '1', 'E', '3', '3', '8',
    'B', '8', '6', 'F', 'F', '5', '6', 'C', '9', '9', 'A', 'E', '0', '4', '6', 'B',
    '0', 'E', 'A', '4', '2', '8', 'C', '8', 'C', 'B', '2', '3', 'D', '6', 'E', 'B',
    '2', '7', '0', 'F', '3', 'B', 'A', '9', 'E', '2', '3', 'C', '2', 'F', 'C', 'D',
    '9', 'B', 'D', '9', '6', 'B', 'C', '9', '4', '9', 'F', '3', '6', '2', 'F', '5',
    '0', '2', '8', '9', '7', '0', 'A', '4', '2', 'D', 'D', '3', '2', '4', 'B', '8',
    'B', '8', '2', 'B', '7', '6', 'A', '5', 'E', 'A', 'E', '8', '3', '2', '1', '2',
    '4', 'A', '7', 'E', '1', 'C', 'D', '1', '6', '2', '9', 'B', 'B', '2', '8', 'A',
    '0', '3', '0', '7', '5', '1', '4', '6', 'C', '1', '7', '0', '9', 'D', '4', '6',
    'D', 'F', '5', '6', '8', '8', '8', 'C', 'A', '5', '4', 'E', 'D', '3', 'A', 'B',
    '1', 'F', 'A', '8', 'B', '0', '8', 'F', '5', 'C', 'F', '6', '2', 'F', '6', 'B',
    'C', '3', 'B', 'F', '5', 'F', '3', '5', '4', 'C', 'B', 'E', 'C', '4', '9', '3',
    '8', '0', 'A', '7', 'A', '7', 'C', '1', 'A', '3', 'E', '4', '6', 'B', 'E', '7',
    '3', 'E', 'E', '2', 'F', 'E', 'C', '2', 'C', '7', '8', 'A', 'F', '3', '8', '1',
    '1', 'B', '4', '9', '6', '2', '7', '3', '3', '2', 'E', 'C', '0', 'D', '1', '2',
    '5', 'E', '9', 'D', 'A', '7', '9', '6', '9', '7', '7', '2', '4', '5', '6', '4',
    'B', '1', '3', 'B', 'C', 'A', '8', '1', '9', '4', 'C', 'E', 'D', '7', 'D', '8',
    '0', '9', '6', '4', '0', '4', '9', '4', '6', 'B', '3', '8', '1', 'F', 'A', 'E',
    'C', '7', '1', 'A', 'D', '5', '4', 'A', 'F', 'B', '6', '9', '4', '9', 'B', 'A',
    '1', 'D', '1', '2', '7', '0', 'D', '8', '1', '6', 'F', '9', '8', '4', 'F', 'D',
    'A', 'E', '6', '7', 'A', 'B', '9', '8', 'A', 'F', 'B', 'A', '5', 'F', 'B', '3',
    '4', '6', '6', '2', 'F', 'A', '3', '1', 'B', '1', '4', '7', '5', '5', '6', 'D',
    'D', '6', 'C', 'D', 'D', '4', '8', 'F', '9', '5', 'A', '1', 'D', '3', '2', '7',
    'D', '2', '3', '4', '6', '1', 'F', '0', '5', 'A', 'E', 'C', 'D', 'A', '6', '9',
    '5', '0', '2', 'E', 'F', '1', '9', 'C', 'F', 'A', 'A', '5', '3', '6', '0', 'B',
    '6', '8', '3', '1', '0', 'C', '0', '0', 'C', 'B', '3', 'C', 'E', '0', 'A', 'D',
    '9', '8', 'C', '7', 'A', 'B', '0', '2', 'C', '4', '9', '6', 'A', '6', 'C', '5',
    'D', '9', '4', '7', '6', 'D', '5', 'E', 'A', 'A', '2', '8', '2', '9', '1', '7',
    '2', 'A', '8', '6', '8', '3', '7', '7', '5', 'C', 'D', '8', '7', 'E', 'D', '1',
    '8', '8', '1', '3', 'F', 'B', 'D', '7', '9', '1', '0', '4', '3', '5', '7', '2',
    '0', '0', '6', '9', '4', 'B', '2', '4', 'D', '5', '3', '8', '7', '8', '5', '9',
    '7', 'B', '1', 'B', 'F', '3', 'C', '3', 'D', 'E', '8', '4', 'F', 'D', 'F', '0',
    '0', '1', '7', 'F', 'C', '9', '5', 'F', '5', '1', 'D', '0', '0', '5', 'F', '2',
    'E', 'C', '4', '5', '5', 'A', '9', '2', '3', '6', 'A', '5', '3', '4', 'E', 'F',
    '7', '5', 'F', 'C', 'F', '7', '8', '7', 'B', 'B', '0', '9', '9', '2', 'A', 'B',
    'B', '5', '2', 'A', 'D', 'D', 'C', 'D', 'D', '6', '1', 'D', 'F', '8', '4', '9',
    '2', '1', 'F', '2', '2', '5', '0', '0', 'C', 'F', 'D', '5', '5', 'C', '1', '5',
    'D', '1', 'A', '0', '3', '0', 'C', 'E', 'F', 'E', '3', '2', 'C', '1', 'B', 'E',
    '6', '8', '4', '5', 'F', 'D', 'E', 'A', '8', 'E', 'A', '0', '5', '1', '4', 'D',
    '7', 'B', '5', '9', '1', '6', 'C', '1', '2', '3', 'A', '8', 'D', 'A', 'F', 'E',
    '7', '4', '2', 'C', 'F', 'B', '4', 'E', '5', '8', '7', 'F', 'B', '3', '4', '6',
    '9', 'B', 'F', '5', '5', '7', 'C', 'A', 'C', '7', '1', '8', 'F', '2', '0', '0',
    'D', '9', '9', 'A', '9', '8', '4', '9', 'D', 'D', 'E', '4', 'D', '6', '3', '9',
    '7', '6', '5', '4', 'F', '5', 'D', '8', 'E', '5', '2', '2', 'B', '8', '5', '0',
    '3', '2', '0', '8', 'B', '4', '8', 'F', 'A', '0', '6', 'D', '6', 'C', 'D', '1',
    '4', '1', 'F', '5', '3', '4', '4', '2', '5', '9', '9', '2', '6', 'B', '1', 'D',
    'A', '1', '6', 'E', 'E', '7', 'D', 'A', 'B', '0', '1', 'E', '4', 'B', '7', '2',
    '1', 'E', '9', 'F', '2', 'B', 'E', 'C', '8', '9', 'A', '9', 'F', 'D', '4', 'A',
    'A', 'E', '4', 'F', 'F', '2', 'C', '8', 'B', 'A', '4', 'E', '9', 'D', '3', '2',
    'A', '7', '1', 'D', 'C', 'D', 'F', '9', 'F', '1', 'D', 'B', 'B', '7', 'F', '2',
    '5', '2', '5', '8', '7', '4', '1', '8', '8', '7', '7', '5', '8', '1', 'A', 'D',
    'A', '8', 'A', 'F', 'C', '8', 'D', '4', '9', '8', 'E', '5', '8', '0', 'C', '2',
    '0', 'F', '3', '4', '4', '3', '2', 'F', '5', '1', '7', '9', '9', 'D', 'A', '2',
    '9', '3', '4', '1', 'B', '9', '0', '7', 'D', '1', '3', 'F', '9', 'D', 'A', '7',
    '1', '5', '6', 'E', '6', 'F', '2', '5', 'D', 'B', '4', 'A', '2', 'E', 'A', 'E',
    'F', '8', '1', '5', '0', 'F', '0', '1', 'F', '1', '8', '7', 'D', 'E', '7', 'A',
    '7', 'F', '8', 'B', '0', 'C', '6', '1', '2', 'B', '3', '3', '0', '1', '9', 'B',
    '5', '7', 'E', '1', '5', 'F', '2', '5', 'B', '7', 'E', '9', '9', '0', '7', 'D',
    '5', 'E', '3', 'C', 'F', '4', '3', '1', '3', 'A', '6', '2', 'D', 'B', 'E', 'F',
    '7', 'B', 'F', '2', '9', 'D', '5', '3', '3', 'D', '9', '6', '2', '9', 'A', '6',
    'C', '4', '9', 'B', '7', '0', 'B', '6', '7', '8', '6', 'F', 'B', '7', '7', '1',
    '1', '2', 'D', 'E', 'B', '0', '9', '2', 'E', '0', '8', '9', '6', '7', 'D', '5',
    'A', '4', '0', '6', '2', 'E', '5', 'F', 'A', 'D', 'A', '0', '7', 'F', 'C', '3',
    'B', 'C', 'E', 'B', '7', '2', '3', '5', 'B', '2', '7', 'A', '7', '9', '9', '3',
    'F', '4', '4', '0', '8', 'E', 'D', 'C', 'C', 'E', '3', 'E', 'B', '1', '0', 'D',
    '3', '5', 'D', '7', '7', '4', '7', '5', 'E', '8', '4', '9', 'F', 'B', '2', '3',
    '1', 'B', 'B', 'B', 'B', '0', '7', 'F', '7', '3', '2', 'E', '8', '5', '9', '4',
    '1', '1', 'F', '6', 'E', '0', 'F', '8', '0', 'E', '8', '7', 'B', '7', '3', '4',
    '8', 'E', '7', '2', '5', '2', '1', 'C', '6', 'D', '1', '4', 'B', 'B', 'C', 'F',
    '3', '7', '8', '8', 'A', 'D', '5', 'E', '3', '6', 'E', '8', '2', '8', '8', 'C',
    '8', 'D', '8', '7', 'A', 'D', '2', 'D', '3', '0', '1', '8', '7', 'B', '3', '2',
    'D', '6', '0', '8', '7', '3', 'C', '9', '7', '2', '0', '2', '4', '2', 'F', 'C',
    '1', 'D', '5', '3', 'B', 'F', '9', '3', '6', '3', '7', 'D', '0', 'D', 'A', '3',
    '3', 'A', 'B', '1', '7', '0', '5', '6', '6', '2', '4', 'E', '1', '6', '5', 'F',
    'F', 'C', '3', 'B', '6', '0', 'E', 'B', '1', '2', '9', '5', '1', 'A', '0', '0',
    '9', 'F', '3', '9', '1', '1', 'E', '9', '1', '0', 'D', '1', 'B', '4', 'D', 'C',
    'B', '9', 'E', '0', '1', '1', '7', '2', 'A', '0', 'F', 'C', 'D', 'B', '6', 'A',
    '0', 'D', 'C', 'C', '0', '9', '8', '8', '7', '9', 'B', '0', 'B', 'D', '7', '0',
    'E', '5', '4', '1', '9', '8', 'A', 'A', '3', '5', '7', 'E', 'A', '0', 'D', '3',
    'C', '3', '5', 'F', '3', '8', '2', '3', '7', '9', 'B', '2', '8', '7', '4', 'D',
    '5', '2', 'D', 'F', '2', '7', 'C', '8', '9', '9', 'C', '6', '5', '3', 'B', '4',
    '4', 'C', '9', 'E', 'A', '8', '7', '1', '1', 'F', 'E', '7', '5', '0', '0', '7',
    'D', 'A', '5', '8', 'D', 'E', 'F', 'D', '3', '9', '1', '8', '8', 'A', 'D', '5',
    'D', 'A', 'F', '1', 'A', '2', '2', '8', '7', '7', '8', 'E', '5', '2', 'D', 'C',
    '8', '2', 'C', 'D', '9', '7', 'F', 'A', '2', '5', 'C', 'E', 'B', 'C', 'F', 'F',
    '8', '4', '0', 'E', 'F', 'C', '0', 'B', '2', 'F', 'F', '6', 'C', '8', 'B', '8',
    '4', '8', '0', 'C', '8', '7', 'A', 'E', '8', '7', '8', '4', 'E', '7', 'D', 'E',
    '1', 'C', '2', 'F', 'D', 'E', '1', '6', 'C', 'C', '2', 'A', '3', '8', '4', '8',
    '6', 'D', '4', '9', 'A', '1', 'B', 'B', '7', 'B', '4', 'F', 'C', '3', 'B', '0',
    '4', 'B', 'B', '7', '5', '8', '4', '1', '4', '8', '0', 'F', '3', 'D', '9', 'C',
    '9', '1', '4', 'E', '4', 'A', '2', 'B', 'D', '2', '7', '4', '3', '1', '5', '7',
    '9', 'A', 'F', '4', 'F', 'B', 'E', 'C', 'F', '8', '7', '1', '5', '9', 'F', '3',
    'C', '7', '5', '9', '2', '8', '8', '6', 'F', '5', '9', '2', '5', '4', '5', '5',
    '5', '1', '2', 'B', '8', 'A', '7', '3', 'B', '0', '2', '0', '9', 'F', '2', '7',
    '8', '2', '3', '1', '4', '4', '0', '1', 'E', 'E', 'A', 'D', '0', 'E', 'A', '4',
    'C', 'C', '7', 'A', 'F', 'A', '6', '4', 'F', '7', 'E', 'B', '2', '0', '8', '4',
    'F', '1', '9', '8', '9', '9', '7', 'C', '7', '3', '8', '2', '4', '6', 'A', '4',
    'B', '4', '1', '0', '2', '5', '7', 'C', 'A', 'B', 'D', '9', '6', '9', '2', 'D',
    '1', 'B', 'E', '7', '6', 'C', '8', 'C', 'C', '7', '7', '9', '6', '6', '9', '6',
    '7', 'F', 'B', '5', '7', 'C', 'A', 'A', '0', '5', 'F', '9', '7', 'D', '5', 'A',
    'B', '6', '6', '9', 'F', '2', '0', 'F', 'E', '7', '1', '5', '6', 'E', 'C', '6',
    '6', 'E', '5', 'D', 'E', '7', '9', 'A', '8', '9', 'D', 'D', 'F', '4', '1', '0',
    'E', '2', 'A', '8', '9', '3', 'C', '6', '3', '4', 'E', '5', '9', '8', '7', '6',
    '7', '7', '3', '6', '0', 'F', '2', '5', '7', '3', 'C', 'D', 'F', '9', 'C', '1',
    '9', '0', '5', '3', '3', '1', 'C', '7', '2', '4', '5', '5', 'F', '2', 'E', 'C',
    'F', 'C', '2', '7', 'D', '8', 'C', 'A', 'E', 'D', 'D', 'D', 'B', 'D', '0', '6',
    '2', '2', 'C', '3', 'E', 'F', 'B', 'A', 'B', '9', '8', '0', 'B', '2', '5', 'D',
    'A', 'E', 'A', 'F', '4', '1', 'B', '0', '5', '6', '2', '0', '1', '0', '9', '4',
    '0', 'B', 'E', '5', 'E', '9', 'F', 'E', 'F', 'B', '7', 'B', 'D', 'B', '4', 'D',
    '3', 'B', 'B', 'D', '1', 'F', 'C', '7', '4', '0', '6', 'E', 'E', '9', '8', '0',
    'B', '2', 'B', 'D', 'A', '0', '3', 'E', 'E', '5', '6', 'A', '9', '0', 'E', '1',
    '8', 'B', '6', '0', 'E', 'A', '0', '0', '4', '1', '1', 'B', '4', '3', 'A', '6',
    'B', '6', 'B', 'E', '0', 'B', '2', '3', '3', '6', 'C', 'B', '1', 'E', 'A', 'D',
    '6', '9', '8', 'F', '8', 'B', '8', '4', '0', '6', '6', 'F', '7', 'D', '9', '8',
    '5', 'A', '2', '8', 'A', 'F', '1', '4', 'A', '1', '4', 'A', '8', 'A', '5', '3',
    '9', '9', '5', 'D', '5', '5', '1', '5', 'B', '8', '6', '8', 'F', '7', '7', '6',
    'B', '7', 'A', 'A', 'E', 'D', 'B', '4', 'D', 'A', '6', '6', 'D', '2', '6', '5',
    'C', '1', 'D', '5', '5', '9', '6', '1', '7', '5', 'D', '5', 'D', '4', 'C', 'C',
    'C', '0', '5', '0', '2', 'A', '4', '2', '5', 'B', '3', '3', '4', '8', '9', '3',
    '3', 'D', '9', '6', '3', 'F', '8', 'F', '4', '9', '6', '3', '5', '7', 'D', '5',
    '1', 'E', 'E', '8', '9', '9', '8', 'F', '8', 'B', '8', 'C', '5', 'F', '4', 'C',
    '0', '7', 'F', 'C', '3', '7', 'C', '2', 'F', 'F', 'F', '3', '0', '1', '5', '2',
    '0', 'C', '8', 'E', 'E', '1', '7', '0', '3', 'C', '7', 'E', '7', '5', '4', '2',
    '0', '0', 'F', '3', '2', '0', '4', '8', '7', '5', 'A', 'A', '0', 'E', 'F', '8',
    '7', '0', '1', '1', 'B', 'F', '2', '0', 'B', '3', 'A', '5', 'A', '7', '8', 'C',
    '2', '1', '1', 'A', '3', 'A', '1', 'D', '7', '1', '0', 'C', '0', 'E', '0', '6',
    '6', 'F', '4', '9', '1', 'C', 'B', 'C', '6', '7', 'C', '5', '2', '7', '5', 'F',
    'F', 'F', 'F', '1', 'A', 'D', 'D', 'D', '6', 'A', 'C', '4', '8', '0', '5', '0',
    'D', 'C', '3', 'E', '0', 'F', 'C', '7', '1', '0', '1', 'E', '8', 'C', '0', '5',
    '7', 'E', 'B', 'F', '1', 'A', 'F', '4', '0', 'E', 'E', 'D', '1', 'F', 'F', 'E',
    'A', 'F', 'B', '2', 'F', '2', '4', 'F', '5', '4', '7', 'D', '2', '2', '8', '1',
    'B', 'C', 'F', '7', 'C', '0', '4', '7', '1', 'E', '7', 'E', 'B', '8', 'C', 'F',
    '7', '1', '9', '5', '2', 'A', '5', 'A', '4', 'E', 'D', '6', 'D', '5', '8', '9',
    '5', '1', '2', 'C', '4', '2', 'C', '3', 'B', 'C', '2', '9', '6', 'F', 'D', '0',
    'C', '6', 'D', '6', '4', 'F', 'C', '3', '7', 'C', '5', '9', 'E', 'C', '2', '0',
    'E', '8', 'C', '3', '5', '5', '8', '9', 'A', 'C', '9', '1', '6', 'D', '5', '8',
    '6', 'C', '4', '3', '2', '5', 'C', 'F', 'F', '6', 'B', 'E', '4', '2', '5', '6',
    '1', 'B', 'C', 'E', '6', '6', '1', '4', '0', '7', '6', '9', 'E', '9', 'B', '3',
    'E', 'C', '5', '8', 'A', '0', '9', 'D', 'A', 'D', '6', 'A', '2', 'C', 'C', '8',
    '7', '9', '6', 'C', '0', 'D', 'B', '7', '0', 'C', 'F', 'F', '4', 'C', '4', '8',
    'C', 'B', 'F', 'D', 'B', '4', 'B', '7', '8', 'F', '9', 'B', 'E', '1', 'A', 'D',
    '3', '2', '4', 'D', '3', '2', '2', '7', 'C', '4', 'E', '1', '6', '4', '0', 'E',
    '5', '1', 'E', '7', '9', '5', 'C', '8', 'E', '5', 'C', 'B', 'D', '0', '5', '6',
    'B', '2', '7', 'F', 'B', 'F', '4', 'D', '3', 'C', '1', 'D', '1', 'E', '5', 'B',
    'E', 'E', 'E', '8', 'D', 'B', 'D', 'B', '5', 'C', '4', '9', '4', 'A', '4', '4',
    'E', '7', '9', '6', 'A', 'D', 'A', 'A', '7', '0', 'E', 'F', 'F', '3', 'F', '1',
    '0', 'D', 'B', 'E', 'C', 'F', 'B', '2', '2', '5', '4', '6', '4', 'C', '1', '0',
    'D', 'C', 'D', 'A', '4', '7', '6', 'C', '5', '9', '1', '1', '4', '6', 'C', '7',
    '5', '8', 'E', '3', '2', '5', 'A', '4', 'C', '9', 'D', 'C', '2', '5', '9', '2',
    '0', 'B', '3', '6', 'B', 'D', '1', '4', 'D', 'C', '7', '4', '2', 'E', 'C', 'F',
    '8', 'B', '8', 'D', 'E', '5', '5', '4', '7', '5', 'D', 'C', 'E', '0', 'E', '2',
    'E', '8', '6', '5', '5', 'C', '7', 'C', '4', 'B', '0', 'D', 'A', 'B', 'E', 'E',
    'B', '8', '4', '8', 'B', '2', '4', '2', 'A', '1', 'F', '6', 'D', '0', '4', '2',
    '7', '4', 'E', 'D', 'F', '1', '7', '1', '6', '6', 'B', 'E', '0', 'A', 'B', 'E',
    '2', '8', '4', '1', '5', '8', 'F', '3', '2', '1', 'F', '6', '5', '8', '7', 'B',
    '7', 'A', '2', '0', 'D', 'C', '3', 'A', 'C', '6', 'C', '5', '6', '4', 'D', 'E',
    '7', '9', 'D', '9', 'A', '2', 'E', '0', 'C', '3', '5', 'F', 'E', '2', 'A', '6',
    '4', 'A', '0', '7', 'C', '3', 'F', '3', 'A', 'F', '9', '9', '3', 'A', '2', '4',
    'C', 'A', '6', 'C', '7', 'B', '6', '2', '7', 'D', 'C', '0', 'C', '8', '5', '4',
    'C', 'F', '9', 'E', '4', 'F', '1', 'F', '0', '4', 'C', '3', '3', '3', '2', 'C',
    '3', '1', '4', '1', '4', 'F', 'B', 'B', '9', 'B', '4', 'E', '8', 'C', '1', '1',
    '4', 'D', '6', 'F', '4', 'B', '9', '6', '3', 'C', '3', 'B', '2', '9', '0', '9',
    '6', '7', '1', '6', '9', 'C', 'C', 'A', '5', '8', 'F', 'C', '0', '3', 'A', '2',
    'B', 'C', '6', '3', 'E', '3', 'D', '2', '4', 'E', '2', 'A', '2', '4', 'B', '6',
    'C', '3', '7', 'A', '6', '0', 'B', 'A', '7', 'D', '3', '9', 'B', '7', 'B', '8',
    '3', 'A', '9', '5', '4', '4', 'E', 'A', 'F', 'B', 'D', 'B', '5', '3', '5', 'D',
    'C', '4', 'C', 'A', '4', '8', '4', 'E', '2', '1', 'B', 'D', '5', 'E', 'B', '7',
    '2', 'F', 'D', 'C', '3', '5', '3', '9', 'B', 'E', 'E', '4', 'E', 'F', '1', 'E',
    '7', 'C', '9', 'C', '2', '6', '3', 'D', '6', '6', '0', 'C', 'F', '4', '8', 'B',
    '6', '6', 'F', '2', 'D', 'F', 'C', '6', '2', '9', '4', '4', 'E', '8', '2', '1',
    'A', '7', '5', '6', 'E', '4', '2', '2', '5', '9', 'B', '4', 'D', 'D', '0', '8',
    '6', '7', '6', 'D', 'D', 'A', 'A', 'D', '0', '0', '4', '8', 'F', 'C', 'F', 'B',
    '9', '3', 'E', '4', '3', '5', 'D', '9', '0', '6', 'F', 'A', 'F', 'E', '1', '5',
    '0', 'E', 'E', 'F', 'B', '9', 'E', '8', '5', '4', '4', 'A', '0', 'C', '5', 'F',
    '7', 'C', 'F', 'C', '5', 'A', '8', '6', '3', '9', '1', 'B', '8', 'F', 'F', '1',
    '4', '8', '5', '6', '3', '4', '7', 'B', '6', 'C', '4', '5', 'E', '0', '7', 'B',
    'F', 'B', 'F', '5', '2', '5', 'E', 'B', '9', '2', '1', '2', '4', 'E', '6', 'A',
    '8', '8', '7', '4', 'E', '4', 'E', '3', 'F', '4', '4', 'C', '2', '4', '8', 'C',
    '8', 'B', '5', '5', '4', '3', '5', '8', '7', '3', '3', '1', '2', '6', 'E', '7',
    'E', '9', 'C', '3', '5', '0', '1', '0', '9', 'C', '5', 'D', '6', '3', 'B', '4',
    '7', 'E', '3', '3', '3', 'A', 'A', 'B', '8', '8', '4', 'E', '3', '0', '5', '6',
    'F', 'A', '1', '2', 'F', '6', 'D', '3', '3', '5', 'B', 'B', 'E', '1', 'A', '4',
    '6', '9', '0', 'B', '5', 'C', '2', 'E', '7', 'A', 'E', 'B', '4', '6', '6', 'D',
    'D', '9', '6', 'C', '6', '5', '1', '6', 'C', 'B', '3', '2', '4', 'F', 'C', 'F',
    '5', '4', '7', 'D', '4', '6', '7', '4', '4', '6', '1', '6', 'D', '9', '7', 'C',
    '0', '2', '1', '0', '3', '5', '0', '8', '4', '1', 'E', 'D', '3', 'C', '4', 'E',
    '0', 'F', 'D', '0', 'F', '0', 'C', '0', 'E', '1', 'A', 'F', 'E', '4', 'B', 'F',
    'E', 'E', '7', '3', '9', '4', 'D', 'B', '1', 'A', '6', '2', '9', '3', '7', '2',
    '9', 'A', '8', '5', '6', '1', 'E', 'A', 'B', '5', '5', '2', 'F', '4', 'C', 'D',
    '1', '0', '8', '7', '9', '9', '4', '7', '0', '2', 'D', 'E', '7', '4', 'E', '7',
    '9', 'D', 'C', '1', '5', 'B', '0', '9', 'C', '0', 'E', '8', '2', '2', '0', '9',
    '0', '6', '5', 'A', '1', '5', '2', '8', 'A', '2', '9', 'F', '4', '3', '5', 'A',
    'D', 'F', 'B', '4', '5', '8', '0', 'F', '7', '0', 'B', '5', '7', 'D', '5', '1',
    '3', 'D', 'B', 'B', 'E', 'B', 'B', 'A', 'C', '1', 'F', '3', '9', 'F', '2', 'E',
    'B', '5', 'A', '5', '6', 'A', 'F', 'E', 'F', 'E', 'F', '8', 'C', '3', 'E', '3',
    '5', '5', '5', '1', '9', '8', 'A', 'D', 'D', 'C', '4', '8', '4', '9', '5', 'D',
    'A', 'C', '6', '9', '9', 'F', 'A', '4', '4', '7', 'D', '4', '0', 'B', '0', 'D',
    'C', '8', 'E', 'E', 'D', 'F', '6', '1', 'E', 'B', '7', '5', '7', '3', '5', 'D',
    '7', '5', '5', '7', 'B', '9', '4', '8', 'E', 'C', 'A', 'D', '4', 'E', 'E', 'B',
    '2', 'F', '0', '5', '8', '0', '0', '5', 'F', '2', 'E', '3', '2', '5', '9', '8',
    '7', '4', '8', '7', '3', '8', '4', 'E', 'F', '1', '8', '5', '9', '8', '8', 'E',
    'B', 'F', 'E', '1', '6', 'E', '1', 'D', 'D', 'F', 'C', 'C', '1', '7', '4', '5',
    '1', 'F', '6', '7', '3', '5', 'B', 'A', '0', '9', '0', '8', 'A', '9', '4', '8',
    '7', '9', 'E', '6', '6', 'A', '2', '7', '8', '3', '2', 'E', '0', 'D', '7', '2',
    'A', 'E', 'B', '0', '3', '6', '3', '9', '8', '6', 'A', '5', '3', '2', 'E', '7',
    '5', '7', '8', 'A', '1', 'D', 'A', '1', '5', '1', '5', 'C', 'A', '1', 'E', '6',
    '8', 'D', 'F', 'F', 'F', '9', '6', '3', 'C', '3', '4', '5', '1', '0', '1', 'A',
    '8', 'A', '5', '9', 'F', '6', '2', '1', '1', '7', 'F', 'F', '3', 'D', 'B', 'D',
    'C', '8', 'D', 'B', 'B', '4', 'B', 'F', 'D', 'F', 'A', '9', 'F', '5', '3', 'B',
    '1', 'C', 'F', '6', '0', 'E', '9', '0', '8', '0', '7', 'C', 'D', '5', '1', '2',
    '8', 'F', '7', '4', '9', '5', 'C', '5', '3', '5', '1', 'D', 'B', '7', '0', '3',
    '7', 'F', '0', '8', '8', 'E', '2', 'A', '9', '5', 'B', 'E', 'B', '8', '1', 'B',
    '2', '5', '0', '2', 'A', '6', 'F', '2', '6', '6', '1', '3', '2', '9', '4', '1',
    '6', '3', 'E', '0', 'E', '4', '2', 'C', '4', '6', '5', '2', '5', '2', '6', '4',
    '9', 'C', 'D', '9', '0', '4', 'F', 'E', '6', 'C', '1', 'E', 'B', '4', 'E', '7',
    '8', '2', '8', '5', 'F', '0', '2', '6', '8', 'E', '3', '5', '0', '7', '1', '7',
    'C', '1', 'D', '9', 'F', '8', '3', 'A', '3', '9', '6', '5', '3', '5', '2', '9',
    '6', 'E', '6', '0', 'E', 'D', '6', '5', 'E', 'F', '3', '7', '0', '9', '1', '5',
    'A', '4', '6', 'B', 'B', '4', 'D', '4', '5', 'A', '7', '1', '2', '3', '0', '7',
    'C', 'A', '5', 'B', '2', '1', '5', 'D', '8', '4', '1', 'C', '3', '4', 'D', 'B',
    '2', '8', '6', '7', '1', 'E', '4', '6', '2', '8', '7', '7', 'E', '0', '1', 'B',
    '1', '6', 'B', 'C', 'D', '1', '4', 'B', '8', 'F', 'C', '5', 'D', 'A', '6', '3',
    '5', 'E', '6', 'B', '6', '1', '0', '8', '9', '1', '1', '9', '6', '3', '4', 'A',
    'B', 'D', '1', 'B', 'B', 'E', '6', '7', 'E', 'C', 'C', 'B', 'F', '3', 'A', 'C',
    'B', 'B', '0', '8', 'C', 'D', '7', 'E', 'E', 'E', '0', '5', '5', '7', 'B', '1',
    '8', '9', '7', '9', '6', '0', '6', '7', '2', '9', 'C', '7', '3', '8', 'B', 'F',
    '8', 'F', '5', 'E', '7', '0', 'A', 'E', 'C', 'C', 'F', 'C', '8', 'A', '4', 'C',
    '2', 'E', 'D', '9', '3', '7', '9', 'A', 'D', 'A', '2', 'F', '4', 'B', 'D', '1',
    '3', 'C', 'D', '6', '1', '9', 'D', '6', 'B', '5', '1', '7', '7', '1', 'D', '9',
    '4', '7', '2', 'F', 'D', '9', '7', '1', '2', '8', '2', '9', '1', 'A', 'D', '0',
    '0', 'E', '3', '3', '1', '2', '5', 'B', '8', '2', '9', '9', '2', '9', '8', '5',
    '5', 'A', 'C', '5', '7', '8', '9', '7', '8', 'A', 'A', 'C', '7', 'E', '7', '9',
    '4', '4', '2', '8', '1', '0', '6', '3', 'D', 'A', '9', '6', 'E', 'A', 'F', '3',
    '7', 'C', '8', 'D', '0', '0', '0', '5', 'A', '4', 'B', '0', '7', 'A', '7', '0',
    '9', '3', 'F', '4', 'F', 'F', '5', 'C', 'E', '3', '4', '9', '8', '9', '2', 'D',
    'D', '8', '0', 'D', '3', 'D', 'B', 'B', '1', '6', '3', '2', '8', '0', '5', '8',
    'E', '6', '7', 'C', 'F', '2', '4', '5', 'C', '6', 'A', '4', 'C', '9', '9', '3',
    '7', '4', 'A', 'F', '0', 'F', '6', '7', 'F', '1', '5', '1', 'F', '1', '1', 'C',
    'F', 'B', '5', '3', '6', '8', 'A', '2', '6', '3', '0', '5', '0', '0', '7', 'A',
    '1', 'F', '7', 'A', '6', '1', '3', '0', '3', '3', '0', '2', 'E', '7', '4', '3',
    'D', '5', '7', '0', '1', '5', '1', 'F', '4', 'E', 'B', '0', 'F', '5', '8', '1',
    '9', '7', '2', '2', 'F', '5', 'D', '2', '0', 'A', '7', '2', 'E', '8', '9', '1',
    '0', '0', '9', '1', '5', 'E', 'F', '1', 'D', '8', 'D', '7', 'B', '0', 'F', '4',
    '0', 'B', '5', 'C', '8', 'A', '8', '8', '4', '3', '9', 'F', '3', '2', 'F', '8',
    '5', 'F', 'C', '4', '2', '5', '3', 'B', '1', '0', '4', 'A', '9', '7', '2', '2',
    '0', 'D', 'C', '5', 'D', 'A', '0', 'D', 'F', 'D', '4', '1', '5', '2', 'A', '1',
    '5', '5', 'A', '1', 'F', '6', 'A', '9', '9', 'C', '1', 'B', '4', 'A', 'A', '7',
    'F', 'D', 'E', '7', '5', '5', 'C', '7', '8', 'E', 'B', '3', 'D', 'C', '3', '8',
    '1', 'F', '1', 'B', '4', '6', '7', 'C', '0', '2', 'A', '2', 'B', '8', '3', 'F',
    'A', '4', 'B', '9', 'C', '4', '4', '6', '2', '4', 'A', '7', 'A', '2', 'A', 'D',
    '3', '3', '6', '9', 'D', '7', 'A', '1', '2', 'E', '7', '7', 'F', 'E', '9', '8',
    'F', '2', '9', '1', '3', '8', 'F', 'C', '3', '4', 'C', 'C', 'C', '8', '6', '1',
    '3', 'C', '8', 'A', 'D', 'C', '2', 'A', 'A', '3', 'F', '0', 'A', 'A', '7', '5',
    '7', 'E', 'F', '8', '6', '3', 'A', 'E', '7', '6', '4', '4', '8', '1', 'E', 'B',
    '2', '8', '3', '5', 'B', 'A', '7', '7', '0', '5', '9', 'F', 'F', 'D', '3', 'B',
    'F', '1', 'B', '6', 'E', '2', '9', '8', '7', '4', 'A', 'B', '3', '6', '6', '5',
    'C', '0', '7', '3', '0', '3', '1', '1', '6', 'A', '2', '7', '1', 'B', 'A', 'A',
    'F', 'F', 'E', '3', 'E', '7', 'E', '2', '0', '9', 'B', '1', 'A', '3', '7', '8',
    '8', '5', 'B', 'A', 'B', '9', '6', '5', '9', '6', '0', '6', '0', 'D', '5', '1',
    '9', '4', '9', '3', 'F', '9', 'D', '3', '7', '1', '1', 'E', 'C', '0', '6', 'C',
    '1', 'C', 'F', '6', '0', '4', '4', '2', '1', '0', 'F', '8', '3', 'D', 'B', 'B',
    'D', '1', 'B', '1', '8', '9', '8', '4', 'F', '2', '2', 'B', 'C', '7', '2', '1',
    'F', '9', '5', 'E', 'C', '8', 'A', 'B', 'D', '8', '0', '8', 'D', '5', 'A', 'F',
    'C', '0', '7', '1', '8', 'E', 'D', '8', '2', '2', 'A', '4', 'E', '6', '0', '4',
    'A', '6', '7', 'A', '7', '0', '3', 'A', '2', '2', '8', '2', 'A', '1', 'A', 'B',
    '1', '0', '0', '2', 'C', 'D', 'B', 'B', '5', 'F', '8', '6', 'F', '5', 'B', 'F',
    'D', '9', 'A', 'E', '4', '0', 'E', '4', 'A', '8', '8', '0', 'D', '1', 'A', '7',
    'A', 'A', '2', '4', '8', 'F', '3', '8', '3', 'B', 'F', '9', '3', 'F', '1', '1',
    'F', 'E', '8', '7', '0', 'B', '0', 'D', '4', 'B', 'D', '1', 'D', '2', '0', 'C',
    '6', 'E', 'B', '0', 'F', '4', 'C', 'C', 'F', 'B', 'E', 'A', 'C', 'F', '3', '9',
    '8', '9', '7', 'A', 'C', '9', '7', '5', '1', '1', '9', 'D', 'B', '2', '7', 'C',
    '3', '9', '6', 'C', 'E', '5', '5', 'D', 'B', '2', '0', '1', '6', 'D', '6', '1',
    '2', 'D', 'C', '3', '5', 'B', '2', 'B', '4', 'C', 'A', 'F', '1', '4', 'F', 'D',
    '5', 'C', 'F', '7', 'E', '6', 'C', 'F', '1', '6', '6', '7', 'F', 'A', '3', 'D',
    'C', '2', '6', 'C', '5', '6', 'E', 'C', '8', '3', 'E', 'F', '5', '6', 'B', 'E',
    'C', '3', 'C', '5', 'B', 'F', '6', 'B', '8', '9', '1', '8', '4', 'E', '2', '6',
    'E', '9', '2', 'C', 'D', '2', '0', '7', '9', 'A', 'F', 'D', '4', '7', 'A', 'F',
    '4', '8', '9', '6', '0', 'A', '8', 'D', '2', 'A', '9', '8', 'D', '9', 'A', '9',
    '5', '7', '7', 'C', 'A', '7', '3', '7', '1', '0', 'B', '1', '5', 'B', '7', 'B',
    '8', '8', 'C', 'E', '3', '7', 'A', 'E', '8', '2', 'D', 'B', '4', 'C', '8', '5',
    '9', '8', '3', 'C', 'F', '8', '7', '8', '6', 'F', '4', 'E', '2', 'F', 'D', '1',
    '4', '5', '5', '5', '6', '4', 'E', '8', 'A', 'A', '0', '5', 'E', '6', 'A', '4',
    'A', '0', '7', '3', 'E', '4', '4', '7', '0', '6', 'E', 'A', '3', '2', 'E', '4',
    '6', '0', 'B', 'B', '6', '4', '9', '1', '3', 'E', '0', '2', 'A', 'D', '0', 'D',
    '1', '0', 'B', '9', '3', '5', 'A', '6', 'E', '0', '5', '4', '3', 'E', '8', '3',
    '2', '9', 'B', '3', '5', '0', '1', '6', '1', 'D', '8', '5', '6', '0', '7', 'C',
    'A', 'E', '5', 'A', '5', 'E', 'C', '3', '8', '2', 'A', '5', 'A', 'B', '8', 'D',
    '0', '4', '5', '6', '4', 'C', '2', '5', '7', '8', '9', '3', 'A', '2', '5', 'D',
    'A', 'F', '3', '0', '7', '7', '6', 'C', 'C', 'C', '1', '5', '1', '4', 'A', '3',
    'A', 'C', 'F', '6', '8', 'B', '6', '7', '3', '3', 'F', '2', 'A', '8', 'A', '9',
    '6', 'B', 'B', '9', '6', '4', 'B', '3', '1', '0', '8', '9', '5', '1', '7', 'D',
    'F', '0', 'E', 'A', '6', '2', 'B', 'B', '3', '3', 'D', '8', 'D', 'B', 'A', '4',
    '8', '1', 'F', 'F', 'A', 'F', '8', '6', '1', '5', 'C', '2', 'D', '0', '2', 'E',
    '0', '5', '0', '5', '0', 'B', 'E', 'C', 'D', '0', 'F', '4', '7', 'A', '9', '0',
    'E', '7', 'D', '8', 'D', 'A', 'A', 'F', '9', '9', '2', '7', 'D', 'B', '6', 'E',
    'C', '3', '8', '0', '4', '7', '4', '5', '2', 'F', '6', '1', '0', '9', 'F', '3',
    'D', '4', 'F', '5', '2', '3', '5', 'B', 'F', '7', '6', '9', '7', '0', '9', 'A',
    'B', '2', '7', '5', '2', '5', '2', '8', '9', 'C', 'E', '5', '7', 'C', '5', '2',
    '1', 'A', '3', '8', 'F', '3', 'B', '0', '1', '0', 'A', 'E', '0', '0', 'E', 'B',
    'B', '7', 'C', '9', 'C', '6', 'D', 'C', '1', '4', '5', '7', '1', '2', 'A', '6',
    '7', '6', '3', 'C', 'B', '7', '6', '9', 'F', '2', '8', 'E', '3', '9', 'B', '4',
    'C', '9', 'C', 'D', '3', '8', 'A', 'C', '2', '4', '6', '5', 'A', 'F', 'E', 'C',
    '7', '9', '1', '6', 'B', '1', 'F', '5', 'C', 'C', 'C', 'B', 'C', '0', 'A', 'C',
    '1', '8', 'F', '5', 'F', 'C', 'B', '3', '1', '3', '2', '9', '3', 'B', '9', 'E',
    'A', '5', '8', '2', '0', '3', '3', '5', 'B', '9', '1', '4', '7', '8', 'B', 'B',
    'E', '9', 'A', 'B', '8', '9', '7', 'A', 'D', '7', 'B', 'E', '6', '9', 'A', '8',
    '2', 'F', '2', 'F', 'D', '2', '2', '4', '0', 'B', '2', '5', '6', '5', 'C', 'F',
    'A', 'F', '0', 'A', '5', '3', 'A', 'A', '6', '6', 'E', '7', 'D', 'D', 'C', '7',
    '5', 'F', '6', 'A', '1', 'A', '0', 'A', 'C', '1', '3', '4', '1', '4', '6', '1',
    'C', 'D', '1', 'D', 'F', '7', 'A', '0', 'A', 'D', '2', 'E', '7', 'F', 'D', 'D',
    'C', '4', 'E', '6', '6', '3', 'B', '5', '1', '6', '4', '0', '4', 'E', 'C', '6',
    '7', 'C', 'F', '8', '6', '0', '3', 'D', '2', '6', '3', '9', '0', 'A', '7', '7',
    '7', 'A', 'E', 'B', '4', '7', 'D', '4', '1', '6', '4', '7', 'E', 'E', '6', '8',
    '7', 'C', '4', '4', '3', '0', '4', 'E', '7', 'C', '7', '8', '4', 'B', '4', '4',
    '3', 'B', '0', 'D', 'B', '2', 'A', '4', '8', '5', 'E', 'D', '2', '0', '6', '6',
    'E', '2', '5', '2', '9', '2', '0', '1', '1', 'D', '1', '7', 'A', 'B', '0', '0',
    '0', '4', '5', 'B', '3', '7', '1', 'A', '9', 'E', '2', 'B', '3', '6', '6', '4',
    '2', '1', 'B', '5', 'A', '4', '0', 'B', '4', '8', '0', 'F', '2', 'F', '5', '6',
    '7', 'E', '5', '4', 'C', '5', 'C', '6', 'A', '9', 'C', '2', 'C', 'A', '6', 'A',
    'F', '6', 'B', '8', 'B', '1', '0', 'F', '5', '3', 'A', '4', 'A', '3', 'A', '1',
    'B', 'C', '9', '1', '5', '7', '1', '1', 'D', '6', '2', 'D', 'C', 'B', '5', 'A',
    '8', '0', '7', '7', 'A', '5', '7', 'B', '5', '5', '0', '1', 'B', 'C', 'E', '1',
    'D', 'A', 'A', '2', '4', '2', '3', '6', '4', 'D', '7', 'C', 'F', '5', 'E', 'F',
    '8', '5', '3', '0', 'D', 'C', 'F', 'B', '7', '5', '5', '9', '7', '0', 'A', '6',
    '8', '2', 'B', '6', 'C', '4', '0', 'A', '9', '4', 'A', 'D', 'C', '6', '1', '7',
    '5', '6', 'D', '8', 'D', '4', 'B', 'A', '0', '6', '1', 'D', '0', '9', '3', '4',
    'F', 'E', 'B', '7', '6', 'D', '2', 'B', '9', 'D', '0', '8', '0', '5', 'D', '4',
    '9', '3', '8', '9', 'B', '0', '1', '2', 'A', 'C', 'A', '8', 'D', 'C', 'C', '6',
    '6', '2', '8', '7', '5', 'A', '0', '8', 'D', '9', 'C', '7', '3', '0', '2', '6',
    '8', '6', '1', '6', '0', '5', '6', '4', '7', '9', '6', '5', '9', '7', '2', '0',
    '0', '5', 'B', '1', '1', '0', 'F', 'C', '7', '9', '3', '8', '1', '0', 'F', 'F',
    'D', '6', 'F', '3', 'B', '4', '5', '8', '4', '4', '8', '1', '1', '0', '7', '8',
    'C', '5', '2', 'D', '5', 'F', 'D', 'F', 'F', '8', '0', 'D', '4', 'A', '6', '6',
    '5', '3', '0', 'E', 'D', '9', '8', 'A', 'B', 'C', '9', '0', '6', 'A', '6', 'A',
    '0', '5', '5', 'B', '9', 'C', 'D', '0', 'F', '0', 'D', '2', 'F', '6', '7', 'B',
    '7', '7', 'E', 'E', '8', '3', '2', 'C', 'D', 'B', '8', '7', 'C', 'D', '7', 'F',
    '9', 'A', '5', '8', '6', 'B', '9', '4', 'C', '8', '3', 'B', 'E', '4', '9', '6',
    '1', '0', '7', '3', 'E', '1', '5', 'E', '2', '8', '9', 'B', '5', '4', 'B', '8',
    '3', '8', '1', 'C', 'E', 'B', '7', 'F', 'C', 'F', 'C', '0', '4', 'E', '1', '9',
    'F', '6', 'D', '4', 'C', '5', '0', '1', '5', '4', '5', '3', '2', '9', '1', '0',
    '9', 'B', '7', 'E', 'E', 'B', 'E', '1', 'F', '3', 'E', '2', 'F', 'E', '6', 'D',
    '7', '7', '2', 'A', '6', '4', 'B', 'D', 'E', '9', '8', '2', 'F', 'A', 'C', '5',
    '8', '7', 'C', '2', 'A', '4', 'F', '5', '9', '7', '2', '6', '4', '1', 'A', '5',
    '6', '0', '6', 'F', 'F', 'E', '9', '4', 'C', '2', '8', 'A', '4', '2', '9', 'B',
    '5', '2', 'F', 'A', '0', '8', 'E', '6', '4', '4', 'D', 'B', 'C', '3', '3', '6',
    '6', 'F', '4', 'F', '4', '9', '8', 'E', 'A', '3', '9', '5', 'E', 'C', '0', '1',
    '4', '9', 'B', '8', '4', '5', '7', 'E', 'A', '8', '5', 'C', '8', '8', '4', '9',
    'E', '2', '5', 'A', '9', '5', '0', 'F', 'D', 'C', 'E', '2', '2', 'E', '0', '6',
    'E', '5', 'E', 'C', '6', '9', '6', '6', '1', '6', 'E', 'B', '2', '4', '5', 'C',
    'E', '7', 'E', 'A', 'C', 'F', 'B', '6', '3', 'B', '7', 'D', 'A', 'E', '3', '0',
    'B', '8', '2', '5', 'B', '9', '9', '4', '5', '4', 'B', '4', 'F', '7', 'C', '3',
    '9', '7', 'F', '8', '7', 'A', 'C', 'F', '2', '2', 'C', 'D', 'A', '5', 'C', '7',
    '0', 'B', '8', '9', '0', '2', '7', 'C', '2', '8', '5', 'B', '5', '0', 'F', 'A',
    'D', '9', '5', '8', '0', 'B', '5', '0', '9', '2', '1', '1', '4', 'F', '6', '2',
    '7', '3', 'D', 'D', '3', 'E', '1', 'C', '7', '7', '0', 'E', '0', '9', '6', 'C',
    '3', '5', '1', '1', 'D', 'D', '7', 'C', '3', '4', '0', 'A', '0', '5', '3', '0',
    '2', 'E', 'B', '7', '7', '1', '4', '6', '4', '0', 'D', 'E', '4', 'B', '7', 'A',
    'C', 'B', '7', '2', '4', '2', '3', '7', 'C', '0', '4', 'B', 'D', '9', '4', 'F',
    '3', '4', 'F', 'D', 'E', 'B', '4', '2', '4', 'B', '5', 'C', '7', '9', '9', 'A',
    '8', 'B', '9', 'F', '6', '6', '7', 'B', '7', '0', 'E', '4', '2', '2', '4', '8',
    'E', '5', 'A', 'A', '7', '6', '4', 'D', '9', '7', 'F', '1', 'E', 'A', '7', '3',
    '2', '8', 'E', 'B', '8', 'B', '6', '4', '4', '6', 'C', '9', '3', '0', '5', '2',
    'F', 'B', '1', '7', '7', '8', 'B', '9', '6', 'F', 'B', '1', '8', 'A', '3', '1',
    '1', 'B', 'D', '8', '6', 'D', 'F', 'C', '7', '2', 'B', 'C', 'A', '9', '8', '3',
    '5', 'D', '0', 'F', 'F', '9', 'B', '7', '6', '5', 'B', '7', '6', '8', '4', '0',
    '8', 'D', '2', '1', '2', 'F', '9', '1', '3', 'E', 'E', '8', 'C', '0', 'F', '1',
    '5', '7', '0', 'B', '8', 'F', 'E', '4', 'B', 'C', 'F', 'E', '9', 'E', '0', '4',
    '5', '6', 'F', '0', '6', 'B', '3', 'C', '2', '1', 'A', '2', '7', 'B', '2', 'B',
    'A', '2', '0', '7', 'D', '2', '6', '0', 'F', '3', 'B', '6', 'F', 'B', '1', '6',
    '6', 'D', 'B', '4', '4', '3', 'D', '7', '9', 'F', 'A', '8', '7', '5', '4', '2',
    'C', 'B', '7', '3', '1', '3', '9', 'F', '8', 'B', 'F', 'E', '8', '1', '6', '9',
    '4', '3', '2', '1', 'A', '2', 'A', '5', 'A', '9', '5', '8', '7', '0', 'C', 'A',
    'B', 'B', 'D', 'D', '0', '8', '6', '1', '2', '1', '5', '0', 'C', '2', '6', '0',
    '4', '7', '7', '3', '4', '4', '8', 'D', '2', '3', '0', 'B', '5', 'E', '0', '5',
    '7', '4', 'A', '5', 'A', '1', 'E', '9', 'B', '1', '6', '3', '8', '1', 'F', 'D',
    '7', 'D', '9', '6', '5', '3', '3', '1', '5', 'E', '9', 'D', '6', '1', '1', '1',
    '6', '9', '7', 'C', '2', '9', '7', 'E', '3', '5', '1', '9', '4', '6', 'A', '3',
    'B', '6', 'D', '9', 'E', '6', 'F', 'F', '1', 'E', '4', 'A', 'D', '9', 'B', '2',
    'A', '6', 'F', '3', 'E', '5', '5', '4', '4', 'D', 'C', '0', 'D', 'B', '1', '5',
    '0', 'C', '5', '6', 'C', '8', '4', 'A', '2', '9', 'A', '0', '8', 'A', 'A', '5',
    'D', 'D', 'C', '8', '6', 'E', 'A', 'D', '7', 'F', '3', '5', '6', 'F', 'D', 'E',
    '8', '4', '8', 'B', '1', '0', '9', 'C', '1', '3', '2', '9', '9', 'A', '6', 'E',
    'B', '5', 'C', '4', 'B', '8', '3', '9', 'B', '3', '7', '7', '9', '1', '6', '2',
    '8', '2', '2', '3', 'E', '6', '7', '4', 'F', '0', '9', '9', '0', '8', '5', '3',
    '7', '1', '3', '0', '2', 'F', '0', '7', '9', '5', '3', 'F', '2', 'D', '6', '2',
    '8', '9', 'E', 'E', 'F', 'A', 'A', '5', '4', '3', '2', '7', '2', '5', '0', '4',
    'C', 'C', '5', 'A', 'B', '1', '0', '2', 'F', '1', '9', '9', '1', '1', '3', '8',
    '9', '9', '7', '0', '7', '6', '9', '9', '6', 'B', 'A', '3', '7', '6', 'D', '4',
    '1', '5', '0', 'B', '3', 'D', '9', '6', 'B', 'C', 'B', '7', 'B', '4', 'F', 'F',
    '4', '7', '4', '8', '9', '1', 'B', '4', '5', 'A', '6', '7', 'E', '7', 'F', '9',
    'F', '5', '3', '6', '5', 'C', '2', '4', '5', '5', 'D', '4', '8', 'C', '3', '6',
    'E', '8', '0', '6', '0', '7', 'B', '0', 'B', '9', '7', 'E', '4', '0', '9', 'D',
    'C', 'F', 'E', 'B', 'D', 'D', 'B', 'D', 'E', '1', '8', '4', 'C', '3', '3', '9',
    '3', '6', '9', '0', 'C', '8', 'E', '7', '0', '4', 'A', '9', '5', 'B', '5', 'B',
    'A', '2', '3', 'F', '3', '5', '2', '0', 'D', 'C', '5', '4', 'C', '7', '0', '4',
    'F', '0', 'C', 'E', '2', '7', 'B', 'A', 'C', 'C', '0', 'A', 'E', '3', 'B', '0',
    '6', 'C', '4', 'A', '4', '2', '8', 'E', '5', '2', 'E', 'F', '3', '8', '4', '4',
    '5', 'E', 'A', '2', 'F', '1', '3', '9', '9', 'D', '6', 'D', '6', '8', '4', '5',
    '7', '0', 'C', 'B', '5', 'E', '3', 'A', 'C', 'B', '8', 'B', '2', '6', 'B', 'D',
    '2', '8', '0', '3', '9', '8', 'F', 'C', 'D', '1', 'C', '0', '5', '2', '2', 'E',
    '9', 'B', '5', '0', 'B', '5', '0', '0', 'C', 'D', '4', '2', 'F', '5', '8', 'D',
    'A', '8', '5', '9', '3', '3', '6', '0', '2', '8', 'D', '2', 'E', '3', 'F', '3',
    '2', '4', '4', 'B', '2', 'A', '7', 'A', 'F', '9', 'D', '7', 'C', '9', 'B', '3',
    'B', '7', 'C', 'F', '3', '7', 'A', '5', '0', '1', '5', '9', '3', '8', '3', '4',
    '1', '9', 'D', '2', 'C', 'A', 'E', '7', 'D', 'D', 'D', 'F', 'D', '7', '4', 'C',
    '5', 'B', '2', '3', '5', '0', 'A', '8', '8', 'D', '3', 'C', '7', '1', 'B', 'E',
    '6', '0', '5', '7', '3', '5', '0', 'D', '1', 'E', 'A', 'C', 'E', 'C', '3', '8',
    '1', '1', 'B', '6', 'A', 'D', 'A', 'C', 'F', '1', '5', '1', '4', 'B', '4', '8',
    '0', '6', '3', 'F', '3', '0', '4', 'E', 'E', 'D', '8', '3', '3', '8', 'E', '3',
    'C', '3', '2', '2', 'D', '5', 'E', 'E', 'A', '2', '1', 'E', '6', '9', '6', 'D',
    'F', '6', '6', 'C', 'E', '6', 'A', 'C', '1', 'E', 'D', '2', '1', '8', 'C', 'E',
    '7', '8', '0', 'D', 'B', '3', '7', '3', '8', '4', '0', 'A', 'B', '1', 'E', '5',
    'A', '2', 'F', '8', 'E', '2', '6', '9', '9', '1', 'C', '5', '2', 'E', 'C', '4',
    '3', '5', '3', '5', '4', '6', '7', '1', '1', '6', '4', '7', 'C', '7', '6', 'E',
    '4', 'E', 'E', '0', '3', '3', '1', '0', '4', '7', '7', 'C', 'F', 'F', '3', 'C',
    '0', '6', '0', '2', '1', 'E', 'B', '7', 'A', '6', '0', '9', '0', '4', '9', '6',
    '2', '7', 'C', '3', '2', 'A', '2', 'B', '9', 'A', 'B', '9', 'C', '0', '1', 'A',
    '3', 'A', '0', 'E', 'C', 'B', 'E', 'F', 'F', '4', 'C', '5', '9', 'E', 'B', 'F',
    '6', 'B', 'B', 'F', '5', '0', '6', '4', '3', '2', 'A', '0', '7', '6', 'F', 'A',
    '8', 'B', '4', 'C', '7', '7', '2', 'D', '1', '8', 'E', 'F', '3', '5', 'D', '3',
    '3', '2', '9', '8', '8', 'C', '5', '9', '3', '5', 'A', '7', '1', '5', '6', 'B',
    '1', '6', 'D', 'E', '8', '2', 'B', '1', 'F', '3', '2', '7', 'A', '3', '0', '5',
    '5', '2', '2', '7', 'C', 'F', 'E', 'A', 'D', '3', 'C', '7', '0', '3', 'E', '7',
    '3', '5', 'F', '1', '3', 'F', '8', '6', '3', '7', 'E', 'B', '2', 'D', 'A', '2',
    'D', '2', 'E', '5', '6', 'E', 'C', 'F', '4', '8', 'B', '0', 'A', '0', '2', 'D',
    '5', 'C', '0', 'A', 'B', '3', 'A', '7', 'E', 'D', '8', '1', '0', 'C', '6', '4',
    '8', 'C', '9', '8', '0', '9', '9', '2', 'F', 'E', 'E', 'B', '9', '9', 'E', 'D',
    '2', 'E', '0', 'C', 'C', 'F', 'F', '0', '0', 'C', '8', 'E', 'F', '7', '3', 'E',
    '6', 'D', 'D', 'A', 'C', '8', '6', '2', '4', '0', '8', '3', '9', 'E', '2', 'A',
    '9', '3', 'C', '5', '5', '9', '3', 'C', '3', '6', '3', 'B', 'F', '7', '6', '1',
    '2', '1', 'A', '0', 'C', 'C', '7', '7', '7', '4', '9', '5', '7', '2', '5', 'C',
    '5', 'E', '4', 'B', 'C', '3', '5', 'B', 'C', 'F', '4', '1', '2', 'B', '1', 'B',
    '0', '5', '2', 'C', '9', 'C', 'A', '0', 'A', '2', 'B', '3', 'F', 'A', 'D', 'A',
    '0', '7', 'D', '4', '7', '4', 'D', 'D', 'D', '0', 'C', 'C', '2', 'C', 'E', '8',
    '5', '3', 'D', 'A', '4', '3', '8', '5', 'C', '2', '0', '2', '0', '2', '4', '3',
    'E', '5', '1', '9', 'A', '1', '9', 'D', '8', 'D', '9', '3', '4', '6', 'C', 'E',
    'E', '3', 'E', 'D', 'A', '0', '2', '9', '3', '8', '3', '9', '9', '6', 'D', 'C',
    '5', 'C', '3', 'A', 'C', 'F', '5', 'C', '6', 'A', 'F', '0', 'A', '0', '5', 'D',
    'E', '2', 'C', '7', '1', '0', 'D', '5', 'C', '7', '5', 'D', 'C', 'D', '2', 'D',
    'F', '9', '1', '5', 'D', '7', '6', '7', '9', '3', '3', '7', '9', 'D', '6', 'F',
    'C', 'B', '9', '0', '7', 'A', '3', '0', '8', '9', '3', '1', 'E', '0', '5', '5',
    '1', 'E', 'F', '0', 'B', '7', '3', '5', 'F', 'C', 'D', 'C', '9', 'C', '8', 'C',
    '8', '4', '1', '3', '1', '4', 'F', '2', '9', 'C', '9', 'B', '0', '6', 'B', 'D',
    '4', '1', '0', 'E', 'D', '8', '8', '2', 'A', 'C', '9', '1', '1', 'C', '0', '6',
    '2', 'B', 'B', '2', 'A', 'E', '9', '1', '7', '3', '7', '1', 'D', '0', 'E', '6',
    '0', 'D', 'E', '4', 'A', 'A', '9', '8', '0', '0', '2', '6', 'F', 'C', 'B', 'E',
    '3', '1', 'A', '7', '9', '3', 'A', '7', '1', '1', 'E', 'A', 'F', '3', 'A', '3',
    '7', '0', '4', '8', 'E', 'B', 'B', 'F', 'A', '5', '7', 'D', '0', '7', '2', '9',
    'B', 'D', 'D', '8', '0', '2', 'F', 'D', 'B', 'D', '2', '0', '9', 'F', 'F', '5',
    '8', 'E', 'B', 'C', '0', '7', '8', '9', 'F', 'A', '8', 'D', 'F', '3', '5', '1',
    '4', '1', 'C', 'F', '1', '1', '5', 'E', 'C', '5', '8', 'F', '9', '9', '5', '2',
    '4', '2', '4', 'B', '0', '3', 'E', '5', '5', '7', '4', '3', 'B', '1', 'A', '2',
    '8', '2', '5', '7', 'F', '4', '3', 'B', '6', '4', 'B', 'B', '3', '4', 'D', 'F',
    '3', '9', '7', '5', '7', 'A', '1', '8', '5', '8', 'A', '2', '1', 'E', 'C', 'B',
    '4', '8', '1', 'C', '7', '1', '2', '3', '7', 'E', '9', '9', '8', 'F', '8', '6',
    'D', '3', 'A', 'F', '1', 'B', '9', 'D', 'B', '0', '6', '3', 'D', 'E', '3', 'A',
    '0', 'B', '6', 'B', '8', '9', '3', 'F', '7', '7', '8', '0', '4', 'B', 'E', '3',
    'F', 'C', '9', 'E', '6', 'F', '9', '3', 'E', '6', 'A', '6', 'E', '5', '9', 'F',
    'B', 'B', 'A', '7', '0', '9', 'D', 'E', '9', 'C', '7', 'D', 'D', 'D', 'C', '2',
    '6', '3', '2', 'D', '1', '3', '0', '2', '0', '4', 'B', '4', '5', 'C', '1', '6',
    '1', '8', '5', '5', '7', '5', '6', '7', 'C', 'B', 'D', '2', 'E', '9', '7', '1',
    'D', '1', '0', '9', 'F', '5', 'B', '2', '1', 'E', '5', 'A', '3', 'A', '0', '3',
    'F', 'D', '0', 'E', 'D', 'F', 'D', 'B', 'B', 'F', '3', '2', 'F', '0', 'B', '9',
    'E', '5', '9', '7', '8', '8', 'C', '3', '9', 'A', 'B', '7', 'A', '9', '2', 'A',
    '8', 'C', '7', 'D', '8', 'E', 'B', 'C', '2', '7', '5', '7', 'D', 'C', '1', '3',
    'D', '0', 'E', '1', 'A', '9', '3', 'D', '5', '3', 'B', 'B', '4', '3', '3', 'F',
    'C', '1', '4', 'F', 'F', 'D', '3', '8', 'B', 'B', 'F', '8', 'B', '6', 'B', '4',
    '7', 'B', '2', '0', '7', '6', 'C', '6', '7', '8', '3', '0', '1', '9', 'E', 'A',
    '5', 'C', 'D', '9', '6', 'A', '1', '4', 'C', '2', 'D', '2', 'F', 'B', 'C', '3',
    '4', '0', '9', '1', '5', '6', 'C', '1', 'B', '6', 'E', 'F', '7', 'D', '2', '1',
    '2', '8', 'A', 'C', '0', 'E', 'B', '6', '0', '5', '5', '1', '7', 'C', 'D', '5',
    '3', '5', '8', '6', '0', '5', 'D', 'C', '8', '3', '0', 'D', 'D', '0', '5', '8',
    '3', '9', '0', 'C', '6', 'F', 'C', '3', 'F', 'C', '0', 'B', '8', '3', '4', '2',
    '2', 'B', '4', 'B', '2', '3', '8', '0', 'A', '3', 'D', '4', 'C', '9', '5', 'B',
    '6', '2', 'D', '6', '6', '8', '6', '9', '1', '6', '8', '5', '0', '1', '7', '5',
    'A', 'A', 'A', 'B', 'D', '7', 'D', '0', '3', '3', 'B', 'F', '6', 'B', '2', 'C',
    'D', 'E', '5', '4', '6', '7', '3', 'E', '8', '0', 'A', '4', '7', '2', 'B', '8',
    'A', '2', '9', '0', 'C', 'B', 'F', 'B', '8', '3', '1', '1', '8', 'B', 'A', 'C',
    'F', 'A', 'A', 'A', 'E', '7', '4', '0', 'B', 'F', '8', '8', '8', 'E', '7', 'E',
    '7', 'F', '8', 'C', '1', 'A', '8', 'E', 'C', '6', 'F', 'F', '2', 'C', '4', '9',
    '5', 'F', '7', 'B', 'F', 'F', '5', '8', '1', '6', '7', 'F', 'C', '8', '0', '5',
    '9', '7', '1', 'E', '2', '6', '5', '0', '7', 'C', '7', 'F', '1', '5', 'C', '1',
    'D', '8', 'E', 'F', '8', 'E', '8', '7', '9', '1', 'E', '3', 'B', 'D', '7', '9',
    '1', 'F', 'C', 'A', '8', '2', '1', 'B', 'B', '9', 'C', '7', 'D', '4', '5', '8',
    'C', 'D', 'F', '3', 'A', '7', '8', '4', 'C', 'D', 'A', 'F', 'F', '5', '0', '3',
    'D', 'B', 'F', '9', 'D', 'C', '4', 'D', 'C', 'B', 'A', 'F', '4', '3', '6', '6',
    '2', '7', '7', 'A', '5', 'A', 'E', '7', '1', '5', '7', '8', 'E', '7', 'C', '6',
    '0', '3', 'C', 'E', 'A', '8', 'A', 'A', '1', '0', '8', '9', '4', 'A', 'A', '4',
    '4', '9', 'B', '5', 'C', '4', '0', 'C', '3', 'B', '8', 'A', '3', 'F', 'E', '5',
    'C', '1', '8', 'D', '1', '2', 'B', '7', '9', 'F', 'B', '4', '2', '8', '2', 'F',
    '9', 'B', '7', '5', 'B', '3', 'C', 'C', '1', 'C', '4', '9', '6', '7', 'A', '1',
    '9', '7', '7', '2', '6', 'B', 'E', '0', 'F', '0', '8', '8', '1', '4', '1', 'A',
    '4', '3', '6', '9', '8', 'A', 'A', '2', 'F', 'F', '3', '7', 'A', '9', 'E', 'C',
    'A', '1', '0', 'E', '4', 'D', 'B', 'C', '1', 'A', '7', 'C', '1', 'B', 'F', '6',
    '2', '1', '4', 'C', '6', '2', '4', '5', '6', '2', 'E', 'D', '9', 'A', '7', 'C',
    '0', 'B', '2', '8', '5', 'E', '8', 'C', 'E', '1', 'A', 'E', 'C', '3', '0', 'C',
    'C', '5', 'F', '6', 'A', '0', 'A', '9', 'E', 'B', '8', 'C', '6', 'C', 'E', 'D',
    '9', 'F', '3', 'C', 'E', '3', '4', 'B', '4', '4', 'E', '3', 'C', '2', '8', 'F',
    'E', 'D', 'B', 'D', 'C', '8', 'A', '9', '7', 'D', 'F', 'A', 'B', '8', '2', 'B',
    'D', 'E', '1', '3', 'F', '2', '3', '6', 'C', '3', 'F', '3', 'F', '9', 'B', 'C',
    '0', '0', '8', 'C', 'F', '9', '3', '9', '3', 'A', 'B', '4', 'C', '2', '6', '8',
    'B', '3', 'C', '9', '4', '2', '7', 'D', '8', 'D', 'C', 'F', '2', '9', '7', 'F',
    '3', '2', 'C', '1', '6', '7', '4', '6', '8', 'A', '8', '6', '0', 'C', '6', 'E',
    '9', '6', '7', '6', '0', '3', 'C', '4', '6', '1', 'D', 'B', 'F', '8', '0', '6',
    '7', '6', '6', 'F', '4', '2', 'C', '0', 'B', '4', '0', '9', '2', 'E', 'A', 'E',
    'C', 'A', '7', 'F', '6', '0', 'B', '9', '3', '4', 'E', '1', '8', '9', 'A', '7',
    '5', '3', '8', '2', '4', '1', '4', '7', 'E', 'B', '7', 'D', '3', '1', 'E', 'B',
    'B', '7', 'F', 'B', '1', '6', '4', '5', 'B', 'D', '0', 'D', 'B', '8', '5', 'E',
    '0', '6', 'B', '2', '5', 'C', '7', '4', 'C', '0', 'F', '8', '4', 'E', 'B', 'B',
    'F', '6', '0', '3', 'B', '3', '1', '6', '9', 'E', 'F', 'B', '0', 'B', '4', '0',
    'D', '2', '1', '4', 'E', '6', '2', '9', '9', 'A', '2', 'E', 'F', 'A', '7', '2',
    '5', '1', '1', '3', '7', '4', '7', 'E', '6', '0', '7', 'E', '2', 'D', 'E', 'B',
    'C', '7', 'F', '6', '3', 'E', 'F', 'C', 'B', '3', '2', '0', 'F', '5', '6', '8',
    '6', '8', '7', 'E', '9', '5', '0', '4', '7', '7', '0', 'A', 'D', 'C', '0', '4',
    '6', '2', 'D', 'F', '4', 'E', 'D', '3', '8', '0', '6', 'B', '2', 'A', '6', '9',
    '0', 'A', '4', '0', '5', 'B', 'F', 'E', 'B', '0', '8', 'C', '5', '4', '8', '6',
    'E', 'D', 'A', '0', '3', '2', 'C', 'B', '5', '2', '3', '1', '7', 'C', 'F', 'F',
    '0', '9', '2', '7', '4', '7', 'E', 'D', 'D', 'B', 'B', '5', 'B', '9', '6', '5',
    '4', '9', '7', '8', 'A', '3', '9', 'C', '0', '7', 'E', 'D', 'A', 'D', '6', '3',
    'B', 'C', 'B', 'E', 'C', '3', '2', '2', 'E', 'E', '5', 'B', '2', '0', 'D', '6',
    'F', '8', 'A', '7', 'F', 'C', 'B', '6', 'A', '7', 'D', 'A', 'C', '4', '1', 'F',
    'F', '7', '8', '6', '8', '2', 'D', 'A', 'B', '3', '8', '2', '3', '7', 'B', 'E',
    'F', 'D', 'E', 'B', '5', '1', '9', '7', '8', 'B', '0', 'A', 'C', 'C', 'E', 'C',
    'C', '9', '8', 'E', 'E', '5', 'D', '1', '3', 'B', '9', 'C', 'E', 'F', 'A', '0',
    '8', '2', 'F', '3', '8', '1', 'D', 'B', 'E', '5', '9', 'A', 'E', '9', 'C', '1',
    '1', '3', 'D', '2', '3', 'B', '9', '0', '8', 'C', '2', 'E', '7', '5', 'C', '4',
    '3', '3', 'F', 'B', 'F', '7', 'A', 'D', 'F', '1', 'C', 'D', '6', '2', '3', 'F',
    'F', '4', 'F', 'A', 'B', 'E', '8', '7', 'E', '4', '3', 'C', '2', '2', '6', '7',
    '0', '4', '7', '3', '0', 'F', '0', '6', '4', '0', 'F', '9', 'D', '4', '8', '3',
    'C', '1', 'D', 'D', 'C', 'E', '3', '5', 'F', 'E', '4', '4', '6', 'A', 'D', '6',
    '0', '7', 'C', 'D', '7', 'B', '4', '8', 'F', '0', '4', 'C', '0', '2', '0', '6',
    '6', 'C', '8', '0', 'F', '2', 'F', 'B', 'B', '6', 'D', 'B', 'D', 'C', '1', 'B',
    '1', 'D', '5', '2', 'E', '2', '0', '2', '1', 'D', '6', 'A', '8', 'B', '8', '2',
    'D', '2', '9', '5', '5', '5', '8', '9', 'C', '3', '3', 'C', 'A', 'F', '3', 'B',
    '2', '4', '2', 'F', '9', '2', 'B', '9', '0', 'B', '2', '9', '0', '8', '2', '0',
    'F', '6', '4', '2', 'F', '1', '9', 'B', 'D', 'F', '5', '8', 'F', 'B', '8', 'A',
    '4', '2', '3', '2', '0', '0', 'F', '0', '9', '6', '2', '9', '1', 'D', 'D', '3',
    '3', '7', '7', '7', '1', '2', 'D', '6', '3', 'F', '6', 'D', '7', 'C', 'F', 'C',
    '2', '5', 'A', '9', 'D', '8', '0', '4', '4', '8', 'D', '6', '7', 'F', '6', 'C',
    '1', '4', 'D', '1', '5', 'D', '8', '1', '4', '0', '3', '9', '8', '7', 'E', 'A',
    'A', '8', '7', 'B', 'E', 'F', 'C', '6', 'E', 'E', '2', '6', '7', '8', '1', 'B',
    '6', '0', 'A', '7', '4', '7', '5', '5', '3', '3', '3', '6', 'A', '0', '2', '9',
    'F', '8', 'E', 'D', 'B', '6', '3', 'A', 'D', '2', '0', 'B', '9', '0', '9', '2',
    'C', '7', 'A', 'B', '4', 'A', 'A', 'B', '9', '2', 'A', '7', '2', '0', 'A', '7',
    '0', 'D', 'C', '3', 'D', '6', '9', 'B', 'E', '0', '7', 'D', '1', '1', '0', '2',
    '4', 'F', '6', '0', '6', '1', 'B', '6', '5', 'F', '9', '7', 'C', '8', '9', '8',
    '8', 'F', 'B', '8', '6', '4', 'A', '5', '8', 'F', '6', '2', 'B', '7', 'D', '2',
    '4', '0', 'D', '4', '3', '1', '1', '7', 'A', 'F', '7', '1', '4', 'B', '1', '4',
    'D', 'E', '4', '7', '6', '0', '2', 'E', 'B', '4', '8', 'D', 'D', '1', '3', 'B',
    'D', '8', 'D', '8', '8', 'F', '3', 'B', '3', 'C', 'E', 'F', '1', 'A', '8', '9',
    'D', 'E', '7', 'A', '0', '1', '2', '2', '8', '3', 'A', 'E', 'A', '0', 'D', 'C',
    '5', '8', '5', '1', 'B', 'E', '5', '0', '3', '2', 'B', '7', '9', '2', 'E', '8',
    '9', '8', 'E', '7', '2', 'B', '1', '4', '5', 'A', 'C', '6', '0', 'A', 'B', 'B',
    'B', '1', '2', '1', '2', '2', '4', '3', '9', '0', 'D', 'A', 'D', 'E', '3', '8',
    '4', '0', 'F', '2', '9', '0', '3', '0', 'E', 'B', '5', 'E', 'D', '8', 'A', 'B',
    'A', '1', 'D', 'A', '1', 'F', '3', '0', 'E', '5', '9', '6', 'A', 'A', '3', '5',
    '5', '7', '3', 'D', '5', '2', 'D', 'D', 'D', 'E', 'B', '6', 'A', 'A', 'A', 'C',
    '6', 'C', 'D', '4', '2', 'E', 'D', '2', 'B', 'B', 'D', 'A', 'E', '1', 'F', '8',
    'F', 'E', 'B', '2', 'E', '9', '1', '9', '7', '9', 'B', '6', 'F', '5', '0', 'A',
    'A', 'A', '9', '2', '0', '5', 'E', '7', '6', 'C', '4', 'C', '6', '4', 'F', '5',
    '9', '0', '5', '6', 'F', 'F', 'C', '7', 'E', 'A', '2', '3', 'D', '1', 'B', '3',
    '8', '7', 'B', '2', '3', 'B', 'C', 'B', '6', '1', '0', '2', '4', '8', 'B', '1',
    'E', 'C', '6', '3', '9', '1', '2', '9', 'B', 'C', '9', '4', 'A', '4', 'A', '6',
    'B', '2', '3', '9', '9', '6', '9', '2', '7', 'C', 'A', '2', 'C', '9', '7', 'F',
    'B', 'B', 'E', 'D', '3', '4', '0', '5', '5', 'D', 'A', '1', '8', 'F', '8', '3',
    '2', 'A', '0', 'F', '4', '2', '8', '4', '8', '8', '8', '5', 'E', '5', '2', 'D',
    '3', 'A', '6', 'B', 'F', '7', '2', 'E', '5', '4', '8', '5', '4', 'B', 'D', '6',
    '7', '8', '6', '8', 'C', '0', '2', '0', '9', '5', '8', '7', 'F', 'F', 'C', '3',
    'B', '6', '5', '9', 'B', '2', 'A', '1', '5', 'A', '6', '7', '9', 'C', 'B', '1',
    'F', 'A', '9', '6', 'E', '7', '4', '9', 'D', '0', 'C', 'A', 'A', 'A', '8', '7',
    '7', '9', 'D', '3', 'B', 'A', '2', '9', '8', '4', '7', '0', '0', 'C', 'C', '3',
    '3', '4', '0', '5', '7', 'F', '6', 'E', '0', '3', 'D', '4', '7', '1', 'F', '3',
    '4', '4', '3', '6', '6', '7', 'D', 'E', '9', '0', '6', 'C', '7', '7', 'B', '9',
    '3', '0', 'A', '7', '5', 'B', 'F', 'F', '2', '2', 'F', 'C', '0', '4', '3', '6',
    '3', '5', '6', 'E', '8', '6', 'F', '9', '3', '9', '6', '1', 'F', '0', '3', '9',
    '1', 'D', 'B', '7', '3', 'D', '1', '8', '4', '9', 'B', '6', '1', 'F', '8', 'E',
    '6', '0', 'A', '6', 'F', 'C', '9', '1', 'A', '0', '3', 'A', '3', '9', '2', 'C',
    'F', '8', '6', '4', '2', '0', '8', 'F', '3', '3', 'C', 'E', '6', '4', '1', '7',
    'E', '8', '7', '4', 'D', 'E', '2', '5', '3', '2', '9', '8', '7', '3', '7', 'E',
    '5', 'F', '8', '6', '2', '1', 'D', '5', '7', 'D', 'A', 'A', '5', 'B', 'F', 'B',
    '1', '5', '3', 'B', 'F', 'E', '2', '1', 'C', '8', '2', 'D', 'B', 'F', '2', 'F',
    'F', '0', 'C', '3', '3', 'A', '2', '4', '9', '4', 'C', '5', 'E', '7', '8', '8',
    '1', 'D', 'D', '1', 'F', '9', 'C', '1', '4', '3', 'C', 'E', 'C', '7', '5', 'E',
    'A', '2', 'F', '0', '4', '7', '0', '5', '6', '7', '7', '6', '9', '6', 'B', '5',
    'E', '2', '8', 'C', 'C', '5', '8', '3', '8', 'F', 'A', 'B', '9', 'D', 'F', '0',
    '1', '9', 'F', 'F', 'C', '8', 'A', '5', '9', '3', '0', 'E', 'B', 'A', '5', '9',
    '5', 'B', '4', '2', 'D', '0', '4', 'F', '0', '0', '8', '9', '8', 'C', 'F', '8',
    '8', 'E', '5', 'C', '8', '7', '6', 'E', '3', '9', 'D', '3', 'C', 'D', 'F', '9',
    '6', '6', '7', '7', '9', 'C', '1', 'B', 'E', 'F', '3', '8', 'A', '2', '2', '8',
    '0', '4', '0', 'B', '8', '0', 'E', '0', 'B', '5', '1', 'C', '4', '3', '1', '3',
    '5', '4', '6', '9', '1', 'A', '8', '1', 'D', 'A', '1', 'A', '3', '2', '0', '5',
    '0', '2', '2', 'A', '5', 'C', '3', '3', '4', 'D', '3', 'C', 'F', 'D', 'B', '3',
    'C', 'F', '5', '8', 'E', '6', '8', '8', '5', '2', '9', 'A', '1', 'E', '2', 'F',
    '9', '2', 'C', '6', 'B', '0', 'E', '1', 'B', '0', '7', 'F', 'F', '2', 'B', '6',
    'B', 'C', '9', '4', 'D', '3', 'C', 'B', '9', '2', 'D', '2', '5', 'C', 'A', '6',
    'D', 'C', '5', '8', 'B', 'C', '0', '2', 'D', 'E', 'D', '1', 'A', 'D', 'A', '0',
    '5', '7', '2', '3', '8', 'B', '7', '5', '2', '3', '1', '7', 'B', 'E', '0', '8',
    '3', 'D', '1', '2', '2', 'B', '4', 'D', 'D', '9', 'D', '7', 'E', '7', '8', '3',
    '1', '9', 'B', '7', '3', '2', '1', '2', '9', '2', '3', '2', 'F', '0', '9', '1',
    'C', 'C', '9', 'D', '6', 'A', 'E', 'F', 'C', '0', '6', '0', 'B', '2', '1', '3',
    '6', '5', '1', '9', '2', '6', '0', '5', '2', '1', '6', 'A', 'C', '6', 'B', 'F',
    '8', '6', 'E', 'E', '7', 'A', 'F', 'C', 'B', 'D', '6', '1', '6', '8', '7', '6',
    'F', 'A', 'B', '0', '5', '6', '4', '5', 'B', '5', '4', 'D', '9', '3', 'B', 'B',
    'D', '9', 'E', '8', '3', '4', 'F', 'E', '9', '3', '3', '1', '7', '3', '4', 'A',
    '6', 'B', '1', '5', '8', '0', 'B', '8', '1', '0', '7', 'F', '5', '7', '4', '5',
    '0', 'D', 'A', '5', '2', '6', 'E', '7', 'B', '2', 'C', 'A', '3', '9', '6', 'A',
    'C', '0', '4', '1', '2', '2', '2', 'C', '6', 'C', 'B', '1', '0', '7', '0', '8',
    'B', '3', '7', 'E', '3', '9', 'E', 'E', '3', '3', 'F', '6', 'A', '1', '2', '2',
    'B', '5', '9', 'F', 'E', 'F', '2', 'E', 'E', 'E', '1', '2', 'B', '2', '1', '7',
    'A', '3', 'A', '8', '1', '0', '9', 'F', '0', 'A', 'E', '3', 'F', 'C', '8', '2',
    '4', '0', '3', 'A', '5', '0', '7', '9', 'E', 'A', '7', '5', '1', 'F', '8', '8',
    '9', '2', 'B', '1', '5', '6', '4', '9', '8', '0', '8', 'E', 'B', '1', '2', 'A',
    '0', '4', '7', '7', '7', 'F', '6', '1', 'A', 'E', '3', '9', 'A', '4', '6', 'A',
    '4', 'A', 'D', '8', '8', '5', '8', 'D', 'F', '3', '5', 'F', '4', '2', '5', 'C',
    '2', '6', 'E', '8', '6', '0', '2', 'D', '6', '2', 'E', '7', '8', 'B', 'A', '7',
    '2', '4', 'B', '6', '4', '5', '1', 'A', '7', '7', 'B', 'E', 'D', '0', '0', '1',
    'F', '1', '9', '4', 'C', '6', '5', 'C', 'C', '2', '1', '7', '0', 'F', '5', '1',
    '2', 'C', 'C', 'C', '5', '7', '5', '9', 'F', '5', 'C', 'F', 'D', '5', '6', '6',
    'A', 'E', 'F', '3', 'B', 'E', '1', 'F', '1', '9', 'F', '3', 'E', '5', 'A', 'D',
    'E', 'E', '6', '9', '7', '1', '1', 'F', '5', '7', '1', 'C', 'D', '0', '7', 'E',
    '8', '2', 'B', '0', '4', 'B', '8', '8', 'E', '6', '4', '7', '5', 'C', '4', '2',
    '2', '2', '1', 'F', '7', '1', 'E', '6', '7', '0', '3', '3', '7', 'F', '2', '9',
    'F', 'C', '7', 'B', '8', '2', 'B', '8', '7', '4', '7', 'D', '8', 'F', 'F', 'A',
    '7', '0', '7', '6', '4', '3', '6', '7', 'E', '3', '5', 'E', 'F', 'B', '4', '1',
    '8', 'B', 'C', '3', '1', 'D', 'F', '3', '6', 'B', '4', 'B', '1', 'C', 'E', '7',
    '6', '8', '1', '5', '7', 'A', '4', '9', '0', 'C', '6', 'C', '9', 'B', 'F', '1',
    'A', 'D', 'D', '1', '6', 'C', 'E', '7', 'A', 'E', '3', '3', 'B', '1', '3', 'C',
    'E', 'E', 'E', '6', '2', '4', '4', 'B', '4', '0', '7', 'D', 'B', '7', 'C', 'B',
    'E', '8', '9', '1', 'A', 'A', '9', '1', '8', 'C', 'C', 'F', '6', 'F', '7', '9',
    '7', 'D', '6', '9', '6', 'D', '9', '4', 'C', '8', '4', '2', '2', 'C', 'C', '7',
    '4', '2', 'B', '2', '3', 'E', '4', 'D', 'C', '8', 'B', '1', '4', '1', '4', '7',
    '2', 'D', '7', '2', '8', '2', '6', '2', 'D', '0', '3', 'D', 'D', '1', '2', '4',
    '1', '3', '8', '4', '3', 'E', '5', '5', '8', 'B', '9', '8', '1', 'B', 'F', '6',
    '6', '1', '4', 'C', 'E', '0', '0', 'A', '1', '4', '7', '9', 'E', 'B', 'D', '8',
    '2', '1', '0', 'D', '0', '7', 'F', '8', '8', 'E', '4', 'C', 'F', 'D', '0', '3',
    '0', '2', 'A', '3', '0', '7', '2', '3', '0', 'D', '9', 'E', 'F', 'C', '2', '9',
    'A', '8', 'C', '5', 'C', 'D', '1', 'E', '2', 'F', 'F', '8', '1', 'D', '1', '5',
    '0', '5', '2', 'A', 'A', '0', '4', '2', 'B', 'D', '5', 'A', 'D', 'D', '2', 'B',
    '7', 'E', '1', '0', '0', '9', 'F', 'A', '0', '7', 'A', '6', '9', '6', 'A', '6',
    '7', '2', '9', 'A', '1', '1', '3', 'F', 'E', 'F', '6', '6', '2', '2', '2', 'A',
    'D', 'C', 'B', 'F', '3', '2', 'C', '9', '2', '9', '1', '8', 'A', 'F', '8', '4',
    '0', '5', '4', '7', '0', '7', '5', '5', 'A', '4', '3', '2', '8', '4', 'D', '9',
    '3', 'F', '3', 'D', '4', 'C', '9', 'F', 'F', '7', '6', '5', '2', '3', 'D', '9',
    'F', 'E', '3', 'E', '1', '5', '4', '9', '6', 'F', '1', 'B', 'D', '5', '1', 'D',
    '6', '2', '9', 'B', '7', '1', '6', 'D', '5', '0', '4', 'A', '0', 'C', '4', '7',
    '2', '2', '5', '5', 'E', '0', '0', '3', '8', '3', '3', 'D', '3', '7', 'F', '7',
    'F', '2', 'F', 'E', 'C', 'A', '8', '6', '3', '8', 'F', '4', '2', '6', '3', 'B',
    '7', '4', '9', 'F', '0', '8', 'D', 'D', 'A', '7', '3', '8', '3', '9', 'A', '8',
    '5', '2', '0', '1', '7', '3', '7', '8', '3', 'C', '7', 'A', '0', 'A', '3', '1',
    'D', '2', '7', '2', 'C', 'E', '3', 'F', '0', '8', 'A', 'C', '0', '4', '2', 'A',
    '1', '9', '7', '1', 'F', 'B', '8', '0', '6', 'C', '1', '8', '2', '3', '1', 'E',
    '1', '9', '1', '0', 'F', 'F', 'B', '1', 'F', '6', '9', '0', 'C', '1', 'C', '9',
    '4', 'F', '1', '9', '5', '5', '4', '4', '6', 'E', '8', '4', '0', 'E', '9', '2',
    'B', 'A', '3', 'E', '7', 'F', 'A', '0', 'A', '0', '3', '6', '8', 'B', '0', '4',
    'F', '5', '8', 'F', '9', 'D', '4', 'F', '9', '5', '0', '2', 'C', '0', 'F', 'E',
    'B', '0', '4', '0', '4', '3', '7', 'C', '3', '8', '0', 'F', 'D', '2', '0', 'F',
    '5', 'A', '5', 'E', '5', '9', '0', 'B', '5', '7', 'F', 'F', 'A', '1', '8', '9',
    '7', '0', '0', '1', '8', '0', '9', 'A', '6', '4', '5', '0', '2', '2', '0', 'D',
    '0', '9', '8', 'E', 'E', '8', 'D', 'D', '9', 'C', 'F', '0', 'D', 'D', 'E', 'C',
    'A', 'C', '7', '4', 'E', '7', 'E', 'B', 'B', 'D', '1', 'F', 'D', '8', 'B', '2',
    '0', 'B', '8', '9', '0', '3', '9', '1', 'E', '1', '2', 'B', 'A', '4', '5', 'C',
    '5', 'B', '4', '2', '0', '5', 'F', '7', 'C', '3', 'E', '8', '7', '9', '3', 'B',
    'B', '9', '1', '7', '5', '2', '4', 'F', '5', '9', '7', '3', 'D', '6', 'D', '1',
    '1', '8', '7', 'D', '1', '5', '2', 'F', '9', '0', '5', '4', 'B', '6', 'D', '0',
    '7', '3', 'D', '2', 'D', '2', 'D', '8', 'C', '2', '0', 'E', '3', 'A', '4', '5',
    '0', 'D', '2', '7', 'E', '9', 'C', '5', '8', '1', '8', 'A', '7', '2', '1', 'A',
    '3', 'E', '4', 'A', '3', 'C', 'A', '9', '4', 'A', '9', '4', '7', 'E', '7', '5',
    '1', 'E', '0', '5', 'C', 'E', '9', 'C', '6', '0', '0', '1', 'C', 'C', '0', '8',
    'E', '1', '1', 'D', '4', '7', 'D', '5', 'D', 'A', 'C', '4', '5', '8', 'F', '0',
    'B', '5', 'A', '3', '1', '4', '8', 'E', '5', '0', 'E', '4', 'E', '8', '9', '3',
    '4', '9', '3', 'C', '1', '9', '1', '8', 'F', 'F', '8', 'B', 'D', '7', '7', '5',
    'E', '9', '1', 'B', '4', 'B', 'B', '6', '1', '5', '1', 'A', 'A', '2', '0', '2',
    '5', '9', '6', 'C', 'A', '3', '5', 'F', '9', '6', '6', '6', '0', '4', '7', 'F',
    '5', '5', 'B', 'E', '6', 'E', '5', '9', 'C', '5', 'A', '0', 'F', 'A', 'E', '6',
    'C', '7', '5', 'E', '7', '5', '3', '9', '9', '9', 'D', '3', 'C', '1', '5', 'F',
    '6', 'F', '4', '6', '2', '7', 'B', 'A', '3', '4', '7', '1', '1', '7', '8', '2',
    '1', 'B', 'C', '1', '1', '0', '9', '4', '7', '4', '2', 'A', '0', '3', '8', '2',
    '8', '3', '9', 'D', 'A', '5', '0', '0', '6', 'E', '9', '0', 'A', '4', 'F', '1',
    '5', 'B', 'F', 'E', 'D', '3', 'E', '8', 'A', '1', '9', '7', '8', 'F', '4', '0',
    '3', '7', '7', '6', '8', 'E', '3', '0', '3', '3', '1', '4', '3', 'A', 'B', '5',
    '4', '3', 'C', '0', 'F', 'A', 'D', 'B', '3', 'F', '1', '2', 'B', '5', '0', '8',
    '4', '0', '2', 'B', 'E', '6', '2', 'F', 'F', '9', '1', '4', 'B', 'C', '4', 'B',
    '1', 'A', 'F', 'C', '8', '3', '2', '8', 'E', '2', '3', '8', '7', 'A', '7', '7',
    '5', 'F', '5', '8', '4', 'F', 'F', '7', '8', 'B', '5', '3', 'A', '2', '8', '7',
    '6', '6', 'B', 'E', '4', 'A', 'C', '8', '1', '6', 'A', '1', '0', '7', '2', '2',
    '4', '6', 'E', '5', 'A', '3', '5', 'E', 'D', 'F', '5', 'D', '0', '1', 'F', 'C',
    '1', '5', 'D', '0', '6', 'B', 'E', 'C', '1', 'C', '4', '7', '8', '1', '2', '0',
    '4', 'B', 'E', '6', 'E', '2', 'B', '2', '9', 'D', '9', 'B', '8', '4', '5', 'A',
    '0', '6', '2', 'B', 'D', 'A', 'F', '9', '3', '3', '8', '3', '7', '9', '6', 'E',
    '5', '7', '8', 'C', '6', '4', '1', '7', 'F', '9', '7', 'D', '2', '1', 'C', 'C',
    '7', '2', '3', '4', '9', 'E', '3', 'B', 'E', '2', 'D', '3', '7', '5', '6', '6',
    '1', '5', '7', 'A', '8', '3', '6', 'D', '0', '2', 'E', '4', '0', 'F', 'A', '2',
    'A', '6', '6', '8', 'B', 'C', '6', '1', 'B', '3', 'B', 'C', '3', '7', '8', '2',
    '1', '7', '5', '1', '7', '4', 'E', 'A', '2', 'F', 'D', 'B', '7', '2', '6', '2',
    '6', '1', '7', '0', '8', '0', '2', '5', 'B', 'E', 'F', '8', '7', 'A', 'E', '0',
    'D', 'F', '5', '0', '8', '5', '2', '7', '1', '9', '8', 'D', 'C', '0', 'A', 'E',
    '5', '9', '1', '6', 'A', 'A', '6', '7', '8', 'D', '8', '4', '9', '9', '5', 'F',
    '2', '1', '3', '0', 'B', 'A', 'D', 'A', '7', '0', 'B', '7', '1', '5', 'E', 'C',
    'C', '1', 'A', 'D', 'D', 'E', '0', '3', '7', '9', '8', '6', '9', '2', '6', 'E',
    '1', '9', '1', 'C', '3', 'C', 'C', '3', 'B', 'E', 'E', '2', '5', '9', '0', 'F',
    'C', '9', '5', 'F', 'B', 'C', 'C', '3', '3', '3', '5', '9', '9', '2', '4', '0',
    '9', 'E', '2', 'C', '3', 'D', '6', '2', 'D', '8', '0', 'A', '2', 'D', '6', '4',
    'B', '7', '1', '4', '1', '3', '6', '2', '6', '9', 'C', 'A', '9', 'A', '7', '8',
    '2', '1', '8', '4', 'E', 'C', 'C', 'C', 'B', '1', 'C', '0', '1', '0', '9', '5',
    '5', '1', '7', 'B', 'A', '5', 'F', '4', '2', '5', 'D', 'C', '0', 'C', '9', 'D',
    '6', '2', '2', '1', 'F', '8', 'F', 'C', 'F', '5', 'C', '0', '3', '4', '9', '6',
    'B', '1', '8', '0', '8', '6', '8', 'F', '5', '6', '6', '6', '4', 'E', 'A', '3',
    'F', 'B', '3', 'B', 'C', '2', 'E', '1', '3', 'F', 'F', '7', 'F', '1', '8', '2',
    '0', '8', 'E', '8', '5', '2', 'B', '9', '3', '4', '1', '2', '3', '7', '5', '5',
    'F', '8', '4', '9', 'C', '6', '6', '6', '8', 'F', 'F', '1', '7', 'C', '7', 'F',
    '9', '2', '0', '6', 'B', '3', '1', '2', 'B', 'A', '2', 'F', '4', 'D', 'E', '9',
    '7', '7', '9', '3', '9', '6', '1', '8', 'F', '2', 'A', '0', '2', '1', '4', 'C',
    'E', 'A', 'C', '0', 'B', '3', 'E', '2', 'C', '2', '1', 'D', 'B', '9', '2', '0',
    'A', 'D', 'D', 'C', '9', '2', 'A', '0', '4', '9', 'C', 'A', '3', 'C', '8', 'C',
    'A', 'A', '5', '8', '9', '3', '7', '5', '4', '9', 'A', '9', '5', 'F', '1', 'D',
    '9', 'A', '4', 'F', '9', '9', '9', 'C', 'F', '2', 'E', '9', '5', 'F', 'B', 'A',
    'B', 'D', 'D', '4', 'A', 'B', 'D', '5', '4', '9', '8', '7', '3', '6', '6', 'A',
    '1', 'C', '2', 'B', 'E', 'D', '4', '9', '2', 'D', '6', '3', '5', '0', '8', 'A',
    'B', '1', '0', '0', 'C', 'D', '9', '8', 'D', '9', '5', 'F', '7', 'F', 'B', '6',
    '3', '8', '3', 'B', '7', 'A', 'F', '6', 'E', '3', '3', 'D', '9', '0', '2', 'F',
    'F', 'A', '9', 'F', '2', '1', 'F', '7', '6', '3', '0', '5', 'D', 'C', '6', '0',
    'B', 'A', 'E', 'E', '3', 'B', 'C', '5', '6', '6', '3', 'A', '8', '0', '8', 'B',
    '3', '2', 'F', 'C', 'C', '8', '0', 'A', '6', '2', '5', 'E', '2', '8', '5', '4',
    'E', '6', '0', '3', '4', '9', '9', '9', '5', 'F', '5', '6', '6', 'F', 'C', '8',
    '1', '6', '8', '6', 'F', '0', '6', 'D', '9', '7', 'B', 'B', '3', 'B', 'A', '5',
    'D', 'E', 'E', '6', 'E', '3', '7', '1', '8', 'E', 'C', 'C', '5', '0', '4', '2',
    '9', 'B', '5', 'B', 'C', '4', '8', '3', 'D', '3', '7', '3', '9', 'E', 'B', 'A',
    '2', 'D', 'B', '2', '5', 'F', 'C', 'D', 'F', '9', '4', 'D', '7', 'F', '8', 'D',
    'D', '4', '1', 'E', '5', 'F', 'D', 'E', '4', '0', '0', '7', 'F', 'A', '7', '4',
    '6', '4', 'C', 'C', '1', '1', '5', '8', 'A', '0', '1', '2', '9', '0', 'A', '7',
    '1', '6', '6', 'A', 'F', 'F', '6', 'D', '4', 'D', 'F', 'B', '5', 'C', 'D', '0',
    '2', 'E', 'C', '3', '0', '3', 'E', '5', 'D', '8', '6', '6', '1', '5', 'D', '1',
    '4', 'D', '3', '3', 'D', '8', '4', 'E', '4', '3', 'C', '0', '1', 'B', 'E', '5',
    '7', 'E', '2', 'D', '5', '6', '6', '1', '4', '1', '5', 'C', 'C', '9', 'D', '0',
    '0', 'C', 'C', 'D', 'B', '9', 'A', '8', '9', '3', 'C', '5', '7', '3', '5', 'A',
    '3', '6', '8', '8', 'F', 'B', 'C', '7', '8', '2', '0', '3', '5', 'E', '3', 'B',
    '7', '0', '4', 'E', '0', '8', '9', '3', '6', 'E', '2', '6', 'C', 'E', '4', '1',
    'B', '5', '8', 'B', 'D', 'F', '3', '5', '2', 'E', 'E', 'A', '8', 'F', '3', 'A',
    '3', '8', '4', '8', '0', 'C', '2', '5', '9', '8', '8', '5', 'F', '2', 'B', 'C',
    'E', '8', 'E', 'B', 'C', 'F', '9', 'F', '8', '4', '7', 'E', '3', 'A', 'F', '6',
    '0', '5', 'F', '8', 'E', 'B', 'F', '3', 'A', '8', '2', '6', '1', '1', '3', '8',
    '7', '8', '2', 'C', '7', '3', '2', '6', 'E', '4', 'B', 'D', 'D', '6', '3', 'B',
    'D', '4', 'F', 'A', '3', '0', 'E', '6', '3', 'B', 'A', '0', '9', '5', '0', '3',
    '7', 'E', '2', '5', '7', 'E', '4', '9', '7', '5', 'C', '1', '5', '6', '8', '9',
    '9', '4', 'E', '8', '8', '7', '3', '1', '3', 'F', 'A', '5', 'E', '0', '8', 'F',
    'A', '4', '8', '9', '6', 'B', 'D', 'D', 'E', '3', '1', 'C', '3', 'A', '9', '1',
    'F', '6', 'C', 'E', 'E', 'C', '8', 'F', '4', 'B', 'C', '1', '0', '3', 'E', 'A',
    '2', '7', '4', 'A', 'C', '0', '9', '2', '2', 'C', '6', '3', '2', '5', '4', '7',
    '8', '1', 'F', 'C', '3', '9', 'E', '0', 'F', 'C', '5', '6', '6', '5', '4', '8',
    '7', '5', '6', '1', '7', '7', '3', 'D', '8', 'E', '6', '7', '9', 'A', 'F', 'F',
    '9', '4', '0', '9', '1', '0', 'E', '2', 'A', 'D', '3', 'C', 'C', '6', 'F', 'B',
    '0', '0', 'E', '7', '6', 'A', '5', '8', '5', 'C', '4', '4', 'A', '5', '4', 'E',
    '0', '8', 'F', '1', '9', 'B', '4', '8', '4', '8', 'C', 'E', 'A', '3', '4', 'F',
    '5', 'A', 'F', 'E', '7', 'B', '7', 'C', 'B', 'D', '8', '8', 'F', '1', 'B', '6',
    'D', '6', '6', '7', 'B', '6', '4', '0', '4', 'A', 'B', '1', '2', 'F', '0', 'D',
    'C', 'F', '6', 'F', '1', '3', '9', '9', '2', '2', '6', 'B', '1', '3', '3', '0',
    'E', '7', '5', 'A', 'C', 'D', '2', 'B', 'B', 'E', '7', '5', '3', 'F', 'D', 'E',
    '2', 'B', '5', '6', 'F', 'E', '3', '3', '7', '3', '2', '1', 'C', '4', '3', 'D',
    '2', '0', '6', 'C', 'A', '6', '5', 'D', 'F', '0', '6', '1', 'B', 'F', 'A', '7',
    '1', 'B', 'B', '2', '6', 'C', '0', '6', 'F', '8', 'D', 'B', 'D', '9', '0', 'B',
    'C', 'D', '9', 'D', 'F', 'F', 'E', '5', 'B', '8', 'A', '4', '1', 'C', 'D', '2',
    'F', '3', '2', '4', '1', '1', 'C', 'E', 'E', '0', 'E', '4', '4', '6', 'F', '4',
    'E', 'C', '3', 'A', '3', '7', '9', 'C', '7', '2', '3', '5', '9', 'C', '7', '2',
    '2', '3', 'F', 'F', 'B', '2', '4', 'B', 'E', 'F', '6', 'F', 'A', 'C', '4', '7',
    '9', 'C', '5', 'F', '8', '4', '6', '1', 'D', 'E', 'C', '9', '6', '6', '2', '0',
    '4', '4', '2', '9', 'F', '4', 'A', '5', 'E', 'F', '8', '7', 'B', 'D', '9', 'F',
    '6', '4', 'B', 'C', 'A', '9', 'A', '5', 'E', '2', '2', '3', 'D', 'F', 'B', 'E',
    'E', '8', 'D', 'B', '8', '8', 'B', '8', 'E', '0', '9', '2', '0', 'B', 'E', '6',
    '2', 'D', '1', 'C', 'A', '5', '5', 'E', 'E', 'E', '1', 'C', '5', '6', '7', 'D',
    '6', '2', 'D', '4', '2', '0', 'F', '1', 'E', 'C', 'B', '2', 'B', 'E', '0', '6',
    '1', 'B', 'B', '3', 'A', 'A', '3', 'C', 'C', '7', '9', '0', '5', '6', '0', '0',
    '3', '5', 'A', 'E', '2', 'F', '6', 'E', '3', '5', '3', '3', '3', '5', '9', '1',
    '8', '8', 'F', 'A', '2', 'A', 'B', 'B', '8', '2', 'F', '6', '8', '6', '7', '4',
    'F', '3', '6', '9', 'B', 'E', '1', 'F', '5', '0', 'F', '2', '1', '5', 'E', '2',
    'E', 'F', '3', '4', '5', '1', 'E', '4', '7', '2', 'B', '2', '9', '6', '5', '5',
    '6', '3', 'E', 'F', '4', '6', 'B', 'B', 'C', '0', '7', 'B', '4', '8', '1', 'B',
    'E', '9', '4', '9', '1', 'A', '2', '8', '8', '3', '7', '8', 'E', 'C', '2', '7',
    'D', 'F', '7', 'C', '8', '9', 'D', 'D', 'A', 'F', 'E', 'D', 'D', '4', '9', '9',
    '1', 'B', '6', '5', 'B', 'F', 'E', '7', 'F', 'E', '3', '0', '6', '8', 'D', '2',
    'A', 'E', 'A', 'D', '8', '7', 'A', '1', '2', '5', 'B', '6', '0', 'B', '4', 'B',
    '7', '3', '4', 'A', 'D', '0', '2', '8', '9', '4', '2', '6', '1', '9', '9', '5',
    '3', 'C', '0', '0', 'F', 'A', 'B', '6', '8', '7', '5', '2', 'B', 'A', '0', '9',
    'A', '5', 'B', 'E', '7', '6', 'C', '4', '0', '2', '8', '5', 'B', '9', '0', '8',
    '0', '2', '6', 'F', 'A', 'D', '6', '3', '9', '4', 'F', '8', 'A', 'A', '0', '8',
    'D', '8', '9', '6', '5', '2', 'E', 'D', '2', '5', 'C', 'C', 'E', 'A', 'C', '0',
    '8', '5', '3', '3', '5', '1', '6', '7', '1', '7', 'F', '4', 'E', '4', '4', '0',
    '7', '8', 'F', '3', '9', 'A', '3', 'B', 'C', '3', 'D', '2', '4', '4', '6', '6',
    'F', '2', '0', 'E', '2', '9', '5', 'D', '9', '4', '7', '5', '2', '5', '1', '3',
    'B', '5', 'F', 'D', 'A', '1', '0', '9', '4', '6', 'A', '3', '4', '0', '1', '2',
    '2', 'C', 'E', '4', '3', '0', 'B', '7', 'B', '2', 'A', '4', '2', '2', '2', '1',
    '2', '6', 'D', 'F', '2', '0', 'F', '7', '5', '6', '9', '8', '9', 'A', 'C', '1',
    'C', 'D', 'F', 'A', '5', '7', '7', '2', 'E', '5', '2', '3', '3', '8', 'B', '9',
    '5', '0', '0', '4', '2', 'A', 'A', '6', '2', '4', '3', 'C', 'C', '4', '4', '5',
    '5', '0', '5', 'B', '2', '3', '3', 'D', 'D', 'A', 'C', '9', '5', 'E', '3', '5',
    'C', 'A', 'E', '4', '6', 'A', '9', '7', '1', '3', 'B', 'E', 'B', '5', '0', 'D',
    'E', '8', '0', '3', '4', '4', '4', '2', '4', '9', 'E', '5', '2', 'A', '8', '5',
    'A', '3', '7', 'A', '3', '3', 'D', '9', '3', '1', '6', 'B', 'D', 'B', 'B', 'F',
    'F', '9', 'F', '2', '5', '2', 'C', 'B', 'D', 'B', '3', '8', '6', 'C', '1', '0',
    'A', '8', '8', 'E', 'A', 'C', '7', '1', 'B', '0', 'F', '6', 'B', '9', '2', '8',
    'B', 'D', '6', '3', 'B', '8', 'A', 'B', '2', '8', '4', '4', 'F', 'D', '7', 'F',
    '2', '4', 'F', 'C', 'B', 'F', 'D', '9', '3', '9', '3', 'C', 'D', '7', 'C', 'A',
    '8', '3', '7', 'F', '4', '3', 'C', 'E', '3', 'C', '3', 'F', '3', '5', '1', 'D',
    '9', 'B', 'A', '8', '0', '5', 'E', '7', '9', 'C', 'E', 'D', '2', 'E', '4', 'D',
    '0', 'C', 'C', '2', '7', 'B', '2', '3', '5', '6', '3', '7', 'A', 'A', 'F', '0',
    'F', 'D', 'E', 'C', 'B', '3', '8', '4', '3', '2', '7', 'C', '2', '1', '5', 'C',
    '5', 'A', '7', '4', 'A', '6', 'D', '3', '7', '9', '6', '7', 'B', 'A', 'C', '1',
    '5', 'B', '7', '2', '0', '2', '3', '6', '7', 'E', '2', '4', '2', '6', '8', '3',
    '3', 'A', '1', '9', '5', 'C', '4', '6', 'C', 'B', 'A', '5', 'B', '1', '8', 'A',
    '0', '3', '7', '7', '4', '3', '1', '9', '2', 'B', 'D', 'E', '9', '1', '4', 'F',
    '3', 'A', '0', '6', 'F', 'A', 'E', 'A', '0', '0', '3', '7', 'E', '2', '5', '1',
    'A', 'C', '0', 'E', '6', '1', '8', '7', 'E', '4', '5', '7', 'E', '9', '0', 'A',
    '2', 'C', 'E', '1', '2', '9', '4', '2', '0', 'A', 'F', '1', 'C', 'C', '8', '0',
    '6', '6', '1', '4', 'C', 'A', '5', 'B', '7', 'F', 'D', 'A', '8', 'A', '9', '1',
    '5', 'F', '2', '4', '6', 'E', '3', '2', 'D', '6', '1', '8', '5', 'D', '9', '6',
    '4', '8', 'A', '6', 'A', 'F', 'C', '6', '9', '0', '7', '1', '5', '6', 'A', '6',
    'A', '3', 'F', '8', 'B', '7', 'E', 'F', 'F', '4', '8', '4', 'D', '4', 'A', '4',
    'C', '2', '8', 'A', 'A', '4', '1', 'F', '5', 'F', '3', '7', '6', '6', '5', '2',
    '1', 'D', 'D', '4', '6', '2', '5', 'C', '7', '4', 'C', '5', '8', 'A', '8', '6',
    '6', 'D', 'F', '6', '6', '6', '9', 'A', '7', '3', '5', '5', 'B', '2', '0', 'E',
    '5', '9', '3', '1', 'B', 'F', 'D', 'A', '3', '1', '2', '7', '7', 'A', 'F', 'D',
    '2', 'A', '3', 'F', '0', 'B', 'A', 'B', '9', 'A', '1', '7', 'B', '4', 'C', 'F',
    'C', '3', 'B', 'E', '1', 'F', '7', 'E', 'D', 'F', 'B', '1', 'E', '3', '0', 'F',
    '9', 'B', '0', 'C', '1', 'F', 'C', '7', '0', 'F', 'F', '8', '1', 'F', 'F', '2',
    'C', '4', '5', '7', 'E', '6', '4', '6', '1', '0', 'F', '5', '0', 'D', '7', 'F',
    '0', '5', '5', '9', '1', '4', '8', '2', '7', '1', '9', '0', '1', '0', 'B', '9',
    '1', '8', '8', '1', '7', '5', '9', '6', '0', '6', 'E', 'F', 'A', '0', 'A', 'F',
    '1', 'D', '8', '7', '9', '3', 'C', '5', '6', 'F', '1', '5', '9', 'F', '0', '1',
    '1', 'B', 'E', 'C', '4', '5', '7', '7', '6', '8', 'B', '3', '1', '9', '7', '5',
    'E', '8', '2', '0', '7', '2', 'B', '5', 'E', '9', '3', 'C', 'C', 'C', 'A', 'B',
    '0', '8', '6', 'E', '7', 'A', '4', 'E', '7', 'B', 'A', 'D', '0', 'C', 'F', '9',
    '5', '4', '2', 'F', 'C', 'F', '9', 'C', '1', 'F', '1', 'D', '6', 'F', 'E', '1',
    '9', '1', '6', '5', '4', '8', 'B', '0', 'E', '9', '0', 'F', '7', '7', '3', 'B',
    '5', '2', 'C', 'C', '2', '4', '9', '6', 'F', '7', '8', 'B', '3', '4', '7', 'D',
    '2', 'E', 'D', '6', '7', '5', '3', '8', 'E', '7', 'E', '9', '7', '0', 'E', 'D',
    '2', 'D', 'C', '4', '9', '0', '0', 'F', '6', 'E', '9', 'B', 'E', '5', '1', '9',
    '0', 'A', '4', 'B', '2', '4', '4', '4', '7', '1', '6', 'F', '4', '9', '1', '1',
    'D', '3', '1', '9', 'D', '3', 'A', '7', '0', 'F', '5', '9', 'C', 'D', 'A', 'E',
    '9', 'A', '0', 'A', 'C', '9', 'E', 'D', '1', '4', '3', 'D', '1', 'E', 'F', 'B',
    'C', 'E', '7', 'D', '2', '0', '1', '2', '7', 'E', '1', '2', '8', '9', '9', 'B',
    '2', '6', '7', '5', '9', 'A', '7', '3', '6', '9', '3', '9', '2', 'D', '9', 'F',
    '1', 'F', '2', '7', 'D', '0', '2', '2', 'C', 'B', '5', '1', 'E', '1', '2', 'D',
    '7', '4', 'E', '2', 'B', '1', '7', '7', '7', '9', '5', 'B', 'F', 'E', '0', '1',
    '0', '7', '2', 'A', '5', '5', 'D', '3', '0', '7', '2', '1', 'C', '3', '5', 'E',
    '6', 'F', '6', '1', 'C', '2', '9', 'A', '2', '4', 'A', '9', 'E', '7', '3', 'B',
    '7', '0', '7', '8', '4', 'F', 'E', 'D', '0', '1', '8', '7', '9', '5', 'B', '4',
    'D', '0', 'A', '3', 'C', 'B', '6', '6', '2', 'F', '2', '4', '0', '3', '7', '2',
    '5', '2', '9', 'A', '1', 'B', 'B', '9', '5', '0', '0', 'D', '4', '0', 'B', 'A',
    'A', '3', 'C', '9', '1', '6', '9', '8', 'B', '8', '8', 'E', '3', '5', 'F', 'D',
    'A', '4', 'D', '8', '7', '5', '0', '2', '1', '0', '2', 'D', '7', 'F', '4', '8',
    '5', 'A', 'C', '2', '4', 'B', '5', '8', '9', 'C', 'E', 'E', 'A', 'E', '9', '4',
    'D', '3', '9', 'D', 'A', '4', 'E', 'D', '0', 'B', '4', 'A', 'A', 'C', 'D', '8',
    'C', '9', '6', '9', '8', '2', '3', 'E', '4', 'E', 'C', 'B', '4', '3', '3', '9',
    'E', '5', 'F', 'B', 'E', 'B', '3', 'F', '6', 'F', '7', '5', '0', '6', '9', '6',
    '8', '7', 'E', 'F', 'A', '7', '6', 'B', '6', '0', '0', 'C', '5', '9', '5', '9',
    '7', '8', 'F', '4', 'F', 'C', '5', '6', '9', '4', 'A', '0', 'F', 'C', '7', 'D',
    '4', '6', 'F', 'C', '0', '7', '2', 'F', 'A', 'A', '7', 'A', '0', 'C', '2', '1',
    'A', '6', 'E', '6', 'C', '0', '7', 'C', '6', '4', '6', '2', '9', '9', '8', '4',
    'E', '2', 'A', '9', 'D', '5', '1', 'C', '8', 'B', '4', '6', '5', '1', '6', '9',
    '2', 'D', '1', '5', 'A', 'A', '2', '2', '5', '4', '9', '8', '2', 'F', 'E', 'B',
    'D', '2', '8', 'C', 'B', 'A', 'F', 'E', '7', 'C', 'D', '3', '7', '4', '3', '1',
    'A', 'E', 'E', 'D', 'B', '5', 'D', 'D', 'F', '3', '8', 'A', '0', '0', '5', '4',
    'C', '1', '9', '3', 'B', 'E', '7', '6', 'F', '3', 'A', '5', 'C', '2', 'F', '7',
    '2', '1', '9', '5', '9', '6', 'F', 'F', '3', '2', 'E', 'C', '8', '3', 'F', '1',
    'A', '3', '1', '7', 'C', '9', '7', '0', '7', '8', 'F', 'A', 'E', '6', 'E', 'D',
    'B', 'F', '3', '3', 'E', '6', '3', '5', 'B', '7', 'C', '3', '5', '7', 'E', '4',
    '2', '1', '0', '6', 'D', 'A', 'D', '2', '1', 'F', '9', 'E', 'B', 'F', '3', '6',
    '2', 'B', 'C', '4', '0', 'E', 'F', 'E', 'D', 'E', '1', '4', 'D', '7', '4', 'E',
    '3', '4', 'A', 'D', '7', '1', '2', 'B', '8', '6', '1', '6', '6', 'E', '3', '7',
    'B', '4', '3', '9', 'D', '4', '0', '1', '6', '7', '5', '1', '9', 'D', '1', 'C',
    'F', 'E', '4', '8', '3', '7', '5', 'B', '3', '2', '2', 'A', '0', '7', 'A', '3',
    '3', '3', 'F', 'E', '2', 'D', '3', '2', '8', '4', '2', '0', '1', '7', 'D', '1',
    '8', 'B', '8', '4', 'F', 'F', '8', '2', '3', 'A', '0', '3', '0', '1', '3', '4',
    '4', 'C', 'A', '3', '2', '0', 'E', '8', 'B', '7', '8', 'E', '1', 'C', '0', 'A',
    '4', 'B', '4', '9', '6', '2', 'E', 'E', 'D', '0', 'E', '2', '9', '6', '1', 'D',
    '1', '8', 'E', 'C', '3', '1', '3', '6', '6', '4', '5', '7', 'A', '6', 'A', '3',
    '6', 'C', '8', 'D', '9', '2', 'F', '9', '1', '1', '8', 'E', '3', '9', '1', '3',
    '3', '4', 'F', '9', 'D', '2', '7', 'A', '0', 'C', '9', '1', '8', 'D', '4', '1',
    '3', '5', '9', 'E', '1', '1', '2', '5', '5', 'B', '5', 'F', '9', '6', '0', '2',
    'F', '8', '0', '1', 'F', 'A', 'D', '5', '8', '6', '8', '9', 'E', '9', '3', '5',
    '0', '4', 'D', 'B', 'B', '3', 'C', '8', '6', '3', '0', '7', '0', 'E', '2', '0',
    'C', '8', '6', 'F', 'F', 'B', '2', 'A', '3', 'D', 'D', '5', '2', '9', '4', '9',
    'E', 'D', '9', '8', '3', '2', '0', 'A', 'D', '0', 'A', 'F', '3', '7', 'D', 'B',
    '9', 'B', 'F', '2', 'D', '1', 'C', '9', '4', 'D', 'F', 'B', 'A', '2', '0', '4',
    '7', '9', 'B', '1', 'E', '9', '0', '2', 'E', '2', '8', '9', '7', '8', '8', 'F',
    '6', '0', '0', 'E', '6', '9', 'D', '1', 'B', 'E', '9', 'B', '2', '7', '5', 'B',
    'E', 'C', 'B', '9', '2', '1', '8', 'E', 'C', '9', 'F', '4', '3', 'F', 'F', '3',
    '1', '1', '3', 'E', 'C', '4', 'A', 'F', '3', '1', '3', '2', 'B', '1', '0', '4',
    '2', '1', 'B', 'C', '6', '0', '9', '2', '8', '0', '0', 'A', 'F', '6', '7', '9',
    'B', '7', '2', '9', 'A', '1', '7', '3', 'A', '8', 'D', 'B', '1', '9', '8', '8',
    '2', '4', 'E', '1', '3', 'F', '8', 'C', 'B', 'D', '0', 'E', 'C', '4', 'A', 'C',
    '7', '3', '2', '3', 'B', '6', '4', '0', '1', '9', '5', '9', 'C', 'F', '1', '1',
    '5', '8', 'E', 'F', '4', 'D', '9', '9', '4', '6', 'F', 'E', 'F', '4', 'D', 'D',
    '4', 'A', '5', 'B', 'B', '2', '9', '2', '2', '0', '9', 'A', '0', '6', '2', '5',
    '7', '0', '0', '4', '2', '0', 'A', '9', '5', '9', 'C', '8', '9', 'C', 'F', '0',
    '2', '0', 'D', '2', '7', '8', '3', '0', 'D', '7', '3', 'A', '0', '5', '3', '7',
    '0', 'B', '2', '1', '9', 'E', '5', '7', '3', '2', '8', '0', '0', 'C', 'D', '7',
    '9', '5', 'A', 'B', '1', '4', '7', 'A', '7', 'E', '2', '5', 'A', 'D', 'E', '4',
    'A', '1', 'B', '7', 'D', '4', 'F', '3', 'D', '6', '5', '7', '9', '8', '8', '7',
    '2', '6', '3', '3', 'E', 'F', 'F', 'C', 'D', '9', 'B', '5', '0', 'D', '9', '6',
    'F', '8', '3', '2', '8', 'B', '7', '1', '3', 'F', 'E', '9', '4', 'F', 'F', 'F',
    '9', '1', 'C', '3', '1', '9', '4', '7', '3', 'F', '7', '2', 'E', '8', 'B', '0',
    'C', '2', '4', '1', '3', 'C', '6', '6', '5', '9', 'C', '3', '6', 'F', 'F', '8',
    '0', '5', 'B', '4', '5', '1', 'F', 'F', 'D', 'B', '9', 'F', '1', 'C', 'A', 'E',
    '8', '7', '5', '8', '8', '2', 'F', 'D', '0', '8', '9', 'C', '9', '2', '3', '9',
    '9', '0', 'B', '7', '8', '0', 'A', '3', 'F', 'B', 'D', 'B', '3', 'B', '6', 'F',
    'F', 'C', 'F', '9', 'B', 'B', 'B', '5', 'C', 'B', '3', '7', '5', '3', '9', '7',
    '9', '9', 'C', 'F', 'B', 'D', 'F', '3', '2', '1', '0', 'C', '8', 'C', '7', '0',
    '6', '3', 'B', 'A', 'A', '7', '3', 'B', 'C', '5', '8', '8', '1', '3', '9', 'B',
    'D', 'F', '6', '4', '7', '3', 'F', '2', '5', '5', '0', '1', '0', '3', '4', '2',
    'F', 'B', 'A', '8', '8', '5', 'C', 'C', '3', '9', '5', '8', '2', '9', '9', 'C',
    '8', '4', 'D', '7', 'C', 'C', '8', 'B', '1', 'F', '2', '8', '1', 'F', '8', '9',
    '8', '9', '6', '7', '4', 'B', '2', 'B', '2', '7', '5', '7', 'A', 'E', '8', 'E',
    '8', '5', 'B', '0', '9', 'A', '1', '0', 'E', '6', '1', '8', 'D', 'B', '5', '1',
    '4', '2', '7', '6', '1', '2', '8', '1', '0', 'B', '3', '3', '1', 'D', '9', '4',
    '1', 'A', '0', 'D', '4', '2', '6', '5', 'F', '8', '2', '5', 'D', '5', 'C', 'F',
    '2', '7', 'B', 'E', '8', 'F', '2', 'C', '9', 'B', '9', 'C', 'F', 'E', 'D', '8',
    '5', 'C', '3', '1', '4', 'E', '4', 'F', 'C', '5', '1', 'F', 'D', '4', 'B', '6',
    'C', 'F', '7', 'A', '4', 'C', '5', '1', '7', '6', '6', '9', 'A', '3', '9', 'A',
    'B', 'D', 'E', 'F', '3', 'D', '4', '9', '0', '2', '1', 'A', 'A', '8', 'A', '6',
    '4', 'F', '7', '5', '5', '6', '5', '6', '8', '4', 'E', 'F', '2', '5', 'D', '2',
    '4', '8', 'A', '0', 'D', 'E', 'E', 'B', '1', '1', 'A', 'E', 'E', '9', '2', 'C',
    '0', '2', 'B', 'A', '4', 'E', '7', 'C', '5', '5', '6', '7', 'F', '5', '3', '8',
    '0', '3', 'C', '2', 'D', '4', 'A', 'B', 'C', '8', 'E', 'E', '7', '1', '7', 'E',
    'D', 'B', 'A', '8', '4', 'C', '2', '7', '1', 'F', '5', '1', '1', '1', 'F', '8',
    'C', '4', 'D', 'D', '5', '9', 'D', 'D', '0', '2', 'C', 'F', 'B', '7', '3', '2',
    '2', '5', 'E', '4', '2', '5', '5', '4', '0', '8', '0', 'C', '4', '1', '3', 'D',
    '9', '9', '6', 'A', '3', 'A', '9', '3', 'C', '1', '5', '7', '9', '0', '3', '4',
    'A', '8', '7', 'D', '1', 'E', '8', '4', 'B', '4', 'D', '9', 'A', '8', 'B', '0',
    '6', '9', '5', '9', 'E', 'A', '4', '3', 'E', '6', '7', '7', '3', '1', '2', '5',
    '3', '2', '6', '0', '9', 'E', '7', '5', '3', '4', 'A', 'B', '6', '4', 'C', '0',
    'C', '8', 'A', '5', '8', 'F', 'E', 'F', 'B', 'F', '2', '6', '0', '0', 'E', '5',
    '0', '4', '4', 'F', 'B', 'B', 'C', 'F', 'D', '9', '8', 'A', '6', '4', 'E', 'F',
    'C', '1', 'A', '4', '6', 'E', 'F', '6', '1', 'F', 'A', 'B', '1', 'D', 'E', 'F',
    'B', 'F', '0', '4', '1', '5', '9', '2', '7', '9', 'D', 'D', 'C', '8', 'F', '7',
    '8', '2', '5', '2', '3', '5', '2', '1', '1', '1', '8', '9', '8', 'F', 'F', 'E',
    '6', 'E', '0', 'A', '9', '8', '4', '8', 'C', '3', '8', 'C', 'C', 'B', '5', 'E',
    '9', '8', '2', '4', 'E', '3', 'F', '9', '7', '6', '1', '5', '6', 'C', 'C', 'A',
    '7', '6', 'A', '8', 'B', '5', 'C', '2', '0', 'E', 'F', '0', 'D', '3', 'F', 'A',
    '0', 'E', '0', '9', '7', '5', 'F', '9', 'C', 'C', '6', '6', '8', '6', '8', 'A',
    '8', '1', '1', 'B', 'C', 'F', '2', '2', '7', 'F', 'A', '8', '2', '4', 'D', 'D',
    '1', 'C', '8', '3', '1', '6', '5', '6', '0', 'F', '5', '3', 'B', '8', '7', '7',
    '3', '2', '1', '3', 'E', '5', '7', '7', '1', '0', '9', '7', 'C', '5', '7', 'B',
    '9', '7', 'D', 'A', '4', 'B', '2', 'C', '5', '7', 'C', 'B', 'F', '7', '1', '2',
    'B', '7', '4', 'C', 'D', 'D', '6', 'B', 'B', '6', '4', 'A', 'F', 'F', '8', '7',
    '3', 'B', '4', '4', 'A', '1', '0', 'E', 'F', 'F', 'C', '7', 'F', 'F', '5', '0',
    '5', 'B', 'C', '7', '3', 'C', 'F', '9', '0', 'E', '6', 'B', '0', 'C', '8', '9',
    '2', '6', 'A', 'C', 'D', '1', 'D', '7', '0', '7', '5', '8', '2', '2', 'C', '0',
    'A', '8', '5', 'D', '2', 'B', '8', 'F', 'A', 'B', '7', '8', '3', '2', '8', '4',
    'F', 'A', 'E', 'E', '4', '2', '3', '3', 'A', 'A', 'C', '9', '2', 'E', '0', 'C',
    'B', 'F', 'D', '6', 'C', '6', '9', '0', 'A', '6', 'E', '2', '7', 'F', '2', '3',
    '9', 'D', '3', 'F', '7', '3', '6', '1', '0', '6', '5', '7', '7', 'F', '6', '2',
    'F', '5', 'F', '3', 'C', '1', '8', '9', '1', '0', 'C', '3', '0', '3', 'F', 'A',
    '2', '8', 'F', 'F', 'B', 'D', '6', '0', '1', 'C', 'A', '8', 'E', '6', '3', 'C',
    '2', 'D', 'C', 'B', '9', '9', 'B', 'C', '6', 'C', '9', '8', 'C', 'A', '5', '1',
    '2', '8', '0', '6', '0', 'B', '9', '0', 'E', '0', 'B', '6', 'B', '8', 'F', '3',
    'F', '0', 'B', 'A', '5', 'F', 'A', 'E', '4', '4', '6', '2', '0', 'F', '8', '7',
    '3', 'C', '1', '0', 'B', 'F', 'F', '9', '8', '5', 'A', '5', '2', '2', '3', '3',
    '1', '7', 'E', '6', '0', 'D', '9', 'A', 'B', '4', 'C', '3', '1', '5', '4', '9',
    'D', '6', '6', '7', 'B', '5', '7', 'A', '9', 'D', 'A', '1', '3', 'F', '3', '5',
    '7', 'F', 'F', 'A', '7', '7', '8', 'C', '5', 'B', 'A', 'D', '1', '4', 'B', '2',
    '7', '8', '4', '6', '9', 'C', '8', '7', '0', '7', 'E', '1', '1', '7', '3', 'D',
    '1', 'B', 'B', 'F', '3', 'A', '0', 'C', '4', 'D', 'A', 'B', 'D', '6', '2', '6',
    'C', 'E', 'B', '3', '2', 'E', '6', '2', '1', '7', '4', 'E', '1', '2', '2', 'E',
    '0', '1', 'A', 'C', 'A', '9', '9', 'C', '8', '2', '2', 'D', '0', 'B', 'C', '1',
    '1', '9', '4', '1', 'A', '4', '9', '8', '3', '4', '3', '6', '9', '9', '7', 'E',
    '9', '3', 'A', '2', '8', 'A', '3', '7', '5', '9', '2', 'D', 'D', '7', '6', 'E',
    'A', '1', '8', '6', '9', 'A', '9', '2', '6', 'F', '6', 'F', '4', '1', '0', '1',
    '7', 'E', '0', 'E', 'F', 'B', '4', '9', 'C', 'F', 'C', 'C', 'F', 'C', 'C', 'F',
    '2', '0', 'D', '0', '7', 'D', '0', '1', '0', 'F', '9', 'A', '4', '0', 'E', 'D',
    '0', '5', '1', 'F', 'D', 'D', 'C', 'B', 'A', '9', 'E', '9', '2', 'C', '2', 'C',
    'E', '8', '5', 'B', '9', '2', '5', '6', '4', '2', 'A', '2', '1', 'D', '2', '0',
    'F', '1', '0', '6', '1', '9', 'F', '0', 'B', '5', '2', 'A', '0', 'C', 'A', '5',
    '2', '3', 'F', '1', '4', '4', '8', 'B', '7', '8', '8', '8', 'C', '9', '4', '7',
    '5', 'D', '0', 'E', '5', '5', 'C', '9', 'E', 'C', '9', '5', 'E', '0', '8', '6',
    '3', 'A', 'D', '3', 'E', 'F', '7', '8', 'A', 'B', 'B', '0', '7', '3', 'E', '3',
    '5', 'A', 'C', '2', '6', '7', 'D', '5', 'D', 'C', 'D', '6', 'C', '3', 'D', 'E',
    'E', 'C', '7', '4', 'E', '1', '5', '4', '2', '3', '2', 'A', '1', 'D', '3', '3',
    '0', 'C', 'D', '0', 'B', '5', '4', 'A', '3', '5', '8', '1', '4', '1', 'A', 'C',
    '6', '6', 'D', '6', 'D', '4', 'E', 'E', '4', '5', 'A', 'A', 'A', '8', '5', '3',
    'A', '5', '1', '8', '2', '7', '7', '1', '0', 'D', 'B', 'E', '4', '8', 'B', '4',
    '5', '5', 'C', '6', '6', '9', '9', '2', '2', '0', 'F', 'D', 'C', '4', '1', '9',
    'A', '4', '3', '9', '7', 'D', '1', '5', 'A', 'A', '1', '3', '2', '1', 'E', '6',
    '3', 'A', '0', 'C', '9', '7', '0', 'D', 'D', '8', 'A', '6', '0', 'D', 'A', '3',
    'A', '0', '9', 'F', '8', 'A', '9', 'B', '2', 'A', '3', '0', '9', '7', '2', '4',
    'B', '2', '3', '6', '3', '8', '1', '2', 'D', 'E', 'F', '2', '5', 'F', 'B', '5',
    '1', 'B', 'D', '4', 'E', 'F', '8', '1', '6', '2', '2', 'E', '2', 'E', 'D', 'B',
    '8', '0', '4', '9', '4', '0', '7', '2', '4', '0', '9', '2', '4', '3', '1', '7',
    'A', 'E', '1', 'C', '1', 'D', 'F', '0', 'D', '5', 'B', '5', 'B', 'D', '1', '0',
    '7', '6', '6', 'B', '1', '7', '5', '9', '1', '0', '3', 'F', '7', '6', '5', '3',
    '5', 'C', '3', 'D', 'D', '9', '1', '8', '4', 'F', '3', 'E', '4', '5', '4', '7',
    '6', '5', 'D', '7', '4', '6', 'D', 'F', '5', '3', 'B', '6', '3', '2', 'A', 'C',
    '4', '6', 'E', '7', '9', 'F', '9', '3', '6', '8', '5', 'D', '0', '6', 'A', 'C',
    '8', '6', '2', '8', 'D', 'B', '9', '6', '5', '4', 'E', '6', 'D', '0', '9', 'D',
    '3', '2', 'F', 'D', '1', 'E', '3', '3', 'E', '3', '9', '2', '8', 'F', '9', '0',
    '9', 'E', '4', 'E', 'F', 'E', '0', '8', '0', '7', '0', '0', 'D', '5', '5', '9',
    'C', '5', 'B', '4', 'B', '6', '9', 'F', '8', '7', 'E', 'E', 'B', 'A', '9', '3',
    '6', '0', '5', 'F', 'F', '8', '0', '3', '8', '9', '6', 'C', '9', 'C', '6', 'C',
    'C', '5', '7', '2', 'E', '3', '9', '0', '6', '2', 'A', 'F', '4', '9', '0', 'B',
    '4', 'F', '6', 'D', 'F', '5', 'E', '3', '2', '4', '9', '5', '9', '8', 'E', 'F',
    '2', '0', '6', 'B', '7', 'A', '0', '1', '6', 'C', '5', 'A', '1', '7', '0', 'D',
    'F', '7', '2', 'E', '2', '2', '3', 'D', 'C', '7', '8', 'C', '8', '4', '0', '3',
    '3', 'C', '5', '5', 'D', '1', '2', '2', '5', 'B', 'C', '3', '5', '8', '2', 'C',
    'F', 'C', 'C', 'A', '7', '1', '9', '5', 'B', '3', '2', '3', 'D', 'C', '7', '4',
    '0', '0', '3', 'C', '6', '8', '2', 'B', 'F', '5', 'D', '8', '4', '0', 'F', 'E',
    '5', '5', '6', '6', 'C', 'D', '1', 'F', '1', '3', 'C', 'B', '9', 'E', '0', '0',
    'D', '5', '3', '5', '7', 'A', 'E', '0', '6', '4', '1', 'B', 'A', '2', '9', 'B',
    '8', 'C', '1', 'C', 'C', 'C', '3', '5', '8', '6', '8', '6', '7', 'C', 'D', '3',
    '8', '2', '3', '9', 'C', '2', 'D', 'E', '5', '1', '0', 'C', 'F', 'F', 'F', '4',
    '9', 'B', '3', 'C', '5', '6', '2', '4', '1', '6', 'B', '7', 'A', 'A', 'E', 'D',
    'C', 'B', 'A', 'D', '4', '1', '9', '7', '3', '7', 'F', 'E', 'B', 'D', '0', '0',
    '3', '3', '0', '3', '7', 'C', 'F', '3', 'F', 'D', '7', '1', 'D', 'C', 'A', '2',
    '0', '9', '4', 'C', 'D', '0', '6', '7', 'D', '3', 'A', 'C', 'F', 'E', '7', 'F',
    'C', 'B', '7', 'E', '8', 'B', '5', '0', '5', '0', '0', '6', '4', 'C', 'A', '4',
    '9', '3', 'D', '0', '7', '9', '0', '1', 'A', 'E', '9', '2', '7', '8', '7', '9',
    '0', 'E', 'B', 'A', 'A', '0', 'B', 'F', '3', '2', '6', '8', '3', 'F', '5', '9',
    '9', 'F', 'B', '5', '3', '8', '0', '8', 'D', '8', 'A', '2', '6', 'F', '8', 'A',
    '2', 'A', 'B', '3', '9', '1', 'D', '9', 'F', '0', 'C', '1', '5', 'A', '9', '3',
    'D', '0', 'C', '4', 'B', '3', 'B', 'C', 'E', 'D', '7', '3', 'F', 'B', '1', 'F',
    'C', '7', '4', '1', '0', 'F', 'C', 'E', '9', 'A', 'C', 'C', 'D', 'A', '6', 'A',
    'F', '4', 'A', '1', '8', '5', '0', '2', 'B', '8', '5', '6', '3', 'C', '2', '1',
    '6', 'F', '9', '5', '9', '9', '6', 'D', 'D', 'F', '8', '5', '0', '1', 'C', 'B',
    '3', '3', '1', '2', '9', '4', 'F', '9', 'C', '2', '0', '8', '2', '8', '5', '7',
    '7', '7', 'E', '0', '0', '5', '3', 'F', '5', 'E', '9', '9', '4', '0', 'C', '3',
    '8', '0', 'B', '4', '9', 'C', 'F', 'F', '9', 'B', 'A', 'D', 'C', 'E', '8', '4',
    'D', 'A', 'B', 'D', 'B', 'B', 'E', 'D', 'E', '1', 'B', 'F', '6', '8', 'C', '1',
    '7', 'D', 'C', '2', 'C', '8', '5', '0', '6', '7', '7', 'A', 'C', 'D', '1', '8',
    '9', '9', 'B', 'D', '4', '0', '5', '3', 'B', 'E', '4', '1', 'D', '1', '5', '9',
    '4', 'C', '1', '8', '1', '7', '0', 'A', '1', '0', 'C', 'A', 'A', '4', '7', '7',
    '6', 'E', '0', '8', '4', '5', '6', '9', '4', 'A', 'B', 'D', 'A', '6', 'D', 'C',
    'E', '9', '7', '1', '2', '5', 'A', 'D', '3', 'F', 'B', 'A', 'C', '2', 'B', 'E',
    'F', '6', '7', 'C', '2', 'E', '4', '7', '0', '9', '7', '5', '6', '3', 'B', 'D',
    '0', '1', '7', '4', '4', 'C', 'A', '4', 'D', '3', '0', 'E', 'B', 'A', 'D', 'B',
    '2', '4', '3', 'E', '3', 'A', '0', 'D', 'A', 'F', '8', '6', '0', '7', '7', '6',
    '1', '6', '8', 'D', '1', 'E', '9', '8', '1', '3', '3', '7', 'D', '0', 'D', '5',
    'A', '5', 'D', 'C', '3', 'B', '8', '8', 'D', 'C', '9', 'D', 'A', 'C', '1', '9',
    '1', '4', 'D', '3', '6', 'F', '2', 'E', '5', 'F', '2', '7', '0', '9', '9', '3',
    'E', '3', 'A', 'E', 'D', '9', '9', '6', '4', '2', '4', '1', '6', 'A', '4', '3',
    'C', 'C', '6', 'B', 'D', '0', 'D', '0', '5', '7', 'C', 'B', 'C', '2', 'D', 'F',
    '1', '1', '7', 'F', '9', '4', 'F', '1', '2', '8', '8', '1', '0', '0', '0', '5',
    '6', 'A', '5', 'B', '3', 'B', 'F', '6', '7', '7', '6', 'C', '4', '6', 'F', '9',
    'E', '1', '1', '9', '1', 'C', '8', '2', '1', '3', 'A', '0', '2', '1', 'F', '8',
    'B', 'D', '8', '4', 'F', '3', 'A', 'A', '8', '1', '3', 'D', 'F', 'B', 'C', '2',
    'C', '9', 'B', 'A', 'F', '1', '7', '1', 'C', 'D', '1', 'C', '1', 'B', '0', '0',
    '1', 'A', 'C', '6', 'D', '9', 'B', 'F', '3', '7', '5', 'A', 'D', 'A', '6', '9',
    'D', 'B', '1', '8', '5', 'D', '4', 'E', '6', 'F', '6', '8', 'E', '7', 'D', '4',
    '7', '4', 'C', '1', '6', '2', 'B', '7', 'E', '0', 'E', 'D', 'F', '3', '9', '7',
    '0', 'C', '0', 'D', '2', 'D', 'D', '5', '2', '5', 'E', '3', '5', '6', 'D', 'F',
    '8', 'B', 'D', '3', 'C', '7', 'A', 'B', '2', 'D', '0', '9', '5', 'E', 'E', '2',
    'D', 'E', '7', '0', '4', '2', '2', '2', 'C', 'E', 'D', 'C', 'E', '9', '3', '5',
    '0', '8', 'D', '7', 'B', 'E', '1', 'D', '3', '6', '5', '8', 'F', '2', '3', '7',
    '6', '0', 'B', '7', '7', '7', '2', '9', '2', 'B', '5', '3', '6', 'B', '1', '1',
    'E', '9', 'C', 'A', '3', '5', 'C', 'D', '1', '6', '1', '1', '2', 'B', 'B', 'E',
    'E', '5', 'D', '2', 'C', 'B', '6', '7', '5', '4', '2', 'E', '8', '3', '3', 'C',
    '4', '5', 'C', '3', '7', 'E', 'C', 'A', '3', 'C', '1', '6', '6', '0', '0', 'E',
    'C', 'B', 'D', 'B', 'C', '4', 'D', '1', 'E', 'A', '2', '5', 'C', '3', '1', '6',
    '6', '6', '3', 'C', '5', '4', 'D', '5', '5', 'A', 'B', '4', '7', '2', '5', 'B',
    '3', 'B', '6', 'B', 'C', '1', '9', '9', 'F', '0', '5', '7', '2', '4', 'C', '6',
    '0', 'D', '8', 'C', '8', 'D', 'E', '3', '4', '1', '3', 'D', '3', '2', '6', 'D',
    '6', 'A', '0', 'C', 'A', 'F', '4', '8', '3', '7', '6', 'E', '1', '1', '5', 'F',
    '8', '1', 'B', '6', '4', 'B', 'A', '4', '7', '5', '3', '5', 'A', 'F', 'E', '9',
    '3', '8', 'A', '1', '9', 'F', '7', 'D', '2', 'F', '1', 'F', '1', 'D', 'D', 'E',
    '6', 'E', 'E', 'A', '3', '6', '6', '3', '9', '1', 'A', '1', '8', '9', '7', '1',
    '0', '3', '3', 'B', '3', '1', '6', 'B', '4', 'E', 'E', '2', '0', 'D', 'B', 'A',
    '6', 'E', 'F', '8', '5', '4', '6', 'F', '2', 'A', '8', '1', '9', '4', '1', '1',
    'C', '5', 'C', '9', '0', 'F', '7', 'E', '9', '7', 'C', '1', 'F', 'F', 'C', '0',
    '3', '5', 'E', 'E', '7', '2', '1', '3', '1', '1', '1', 'E', '4', 'C', '7', '1',
    'F', 'A', '9', 'B', '3', 'D', 'A', '1', 'C', '3', 'A', '9', 'D', '2', '1', 'F',
    '8', '2', 'E', '9', '2', '3', 'B', 'E', '1', '1', '1', '1', '7', '3', 'D', '9',
    '6', '4', 'F', '4', '8', 'A', '0', '2', '3', '7', '0', 'F', '5', 'E', '7', '5',
    '7', 'B', 'D', '9', '9', '2', '7', '8', 'F', '0', '3', '4', 'D', 'E', '1', 'F',
    '7', '3', 'C', 'B', 'F', '1', 'F', 'B', 'D', '2', '9', '7', '9', '3', '5', '5',
    '6', '1', '5', '5', '5', 'A', '1', '8', '9', '2', '1', '1', 'A', '0', 'A', '6',
    '9', '0', '9', '2', '5', 'A', '8', '1', 'E', 'B', '6', 'A', '8', '6', 'C', '3',
    'F', '9', '6', 'B', '7', '6', '0', '8', '5', '7', '1', 'E', 'B', 'E', '6', '5',
    '9', '2', 'C', 'F', 'D', 'F', 'D', 'E', 'E', '6', '7', '7', '3', 'E', '9', '6',
    'C', 'C', '3', '8', '2', '6', 'C', '2', '2', '0', '3', 'D', '5', 'F', '7', '0',
    'F', 'F', '0', '0', 'B', 'C', 'C', '0', 'E', 'A', 'B', '8', 'D', 'D', 'F', '6',
    'F', 'F', 'C', '0', '2', '5', '9', 'B', 'A', '1', 'D', '6', 'E', '7', 'A', '1',
    'A', '7', 'A', '9', '3', '1', '0', '6', '6', 'D', '6', '9', '6', '5', '6', '5',
    '5', '7', '3', '0', '7', '1', 'B', '5', '8', '5', '0', 'F', 'D', '7', '9', '3',
    '1', '5', '3', '8', '2', '8', '6', 'A', 'B', '0', 'E', '8', '0', 'B', 'E', '4',
    '5', '6', '6', 'C', '1', 'D', '2', '5', '5', '9', 'A', '8', '9', '1', '1', '9',
    '6', '4', 'E', '8', 'A', '4', '5', '2', 'F', 'F', '1', 'B', 'B', 'D', 'C', '6',
    '2', 'E', '4', '7', 'B', 'A', '5', '1', 'C', 'A', 'E', '8', '8', '4', 'E', 'F',
    '2', 'E', '7', '9', 'E', '0', '8', 'B', '9', '6', '5', '5', '2', 'B', 'C', '8',
    'C', 'E', 'E', 'C', 'F', 'C', '3', 'A', 'E', 'E', '2', '4', '1', '1', '3', '5',
    '5', '5', '5', 'D', '1', 'B', '3', '5', 'A', '0', 'B', 'B', 'A', '4', 'E', '9',
    '3', '2', 'E', 'E', 'A', '8', 'A', '3', '9', 'A', 'A', 'C', 'D', '2', '4', '9',
    '7', '5', 'C', '5', '4', '4', '0', '8', 'F', '2', '9', '8', 'F', '5', '3', 'B',
    '0', '7', '8', '2', 'C', '7', '3', '4', '1', '6', 'B', '2', '4', '3', '9', '4',
    '3', '6', '1', '5', '5', 'D', 'D', '7', 'A', '2', '9', '8', 'B', 'A', '1', 'C',
    'C', '6', 'C', '9', '8', '6', '5', '7', '3', '1', '3', 'B', '6', 'C', 'F', '8',
    '8', 'F', '9', '3', '9', '7', '3', '1', 'A', '1', 'B', '9', '9', '6', '1', 'B',
    '6', 'C', '4', '4', '0', '5', '0', '2', '2', '2', 'F', '7', 'F', '9', '9', 'E',
    'A', '0', '5', '0', 'B', '4', 'D', 'C', 'F', '5', 'B', '9', 'B', 'C', '6', '0',
    'A', '2', '7', '0', 'C', '3', '8', '6', 'B', '0', '3', 'D', 'E', 'B', 'C', '9',
    '7', 'C', 'B', '9', 'E', '8', 'B', 'D', '1', '4', '0', 'E', '6', '7', 'D', '2',
    '2', '9', '3', '2', 'B', 'F', '2', 'F', 'F', '7', '4', 'F', '0', '5', '1', '4',
    'F', 'E', 'A', '3', '4', '8', '4', 'A', '7', 'A', '4', 'E', '0', 'D', '3', 'A',
    'E', '5', '8', 'A', 'A', 'D', '2', 'C', '1', '7', '1', '9', 'E', '1', '6', 'B',
    '5', '1', '8', 'E', '9', '9', 'A', '3', '3', '9', 'B', '5', '7', '3', '2', 'E',
    'F', '9', 'A', '8', '9', 'C', '4', '8', 'B', 'A', 'E', '4', '4', 'A', '4', 'F',
    '6', '7', '5', '8', 'C', '6', '6', '2', '5', '3', '2', '7', 'C', 'B', 'B', '3',
    '2', '0', 'B', '2', 'B', '3', '4', '9', 'C', 'E', '1', '6', '8', 'C', '0', 'C',
    '2', 'A', '8', 'B', '6', 'C', '9', 'F', 'D', 'F', '5', '6', 'C', '2', 'D', '7',
    'C', '7', '4', 'F', '6', 'F', '8', 'F', '4', '2', '6', 'D', '6', '9', 'B', 'D',
    '5', 'E', '3', '3', '7', '8', '7', '9', '3', 'D', '8', '1', '1', 'D', 'D', '3',
    '8', '4', '8', 'C', '2', '3', '3', '8', 'F', '8', '4', '8', '9', 'A', '7', '2',
    '8', '4', '7', '2', '8', '8', 'E', '3', '6', '5', '0', 'C', '4', '9', '6', 'C',
    '7', '3', '4', 'F', 'B', '8', 'C', 'F', '5', 'E', '2', '3', 'D', '7', 'D', 'F',
    '0', '9', 'C', 'D', 'F', '2', 'D', '2', 'A', 'A', '7', '3', '8', 'B', '1', '2',
    'B', '1', 'C', 'D', '9', '3', 'C', '6', '1', '8', 'C', '9', 'B', 'E', '6', '2',
    'B', '5', 'E', '7', '0', '3', '9', '0', '7', 'D', '4', 'D', '7', 'E', '9', '2',
    '4', 'C', 'D', '8', 'A', 'A', 'C', '1', '7', '1', 'F', 'D', '8', '6', '6', '2',
    'D', '8', '2', 'A', '2', '3', '8', '3', 'D', '9', 'B', 'C', 'A', 'F', 'F', '0',
    '2', '3', 'A', 'C', 'D', '9', 'E', '2', '9', '4', 'B', 'D', '8', '4', '5', 'F',
    '0', 'F', '2', '6', 'B', '4', '9', '6', '9', '2', '6', 'E', '3', '8', 'B', '3',
    '9', '8', 'F', '8', 'A', 'D', '5', '8', '2', 'C', '7', 'B', '0', 'A', 'E', '9',
    'D', '9', '5', '7', '2', 'F', 'A', 'D', '9', '4', 'E', '3', '8', '1', 'E', '2',
    '5', '5', 'F', '8', '3', '8', '2', '1', 'F', '9', '9', 'A', 'F', '9', 'D', '4',
    'A', '2', '7', '7', '2', '3', 'A', '3', '2', '6', 'C', '2', '9', '5', '8', 'F',
    '8', '3', '4', '7', '4', '4', 'C', 'C', 'E', '7', '6', '1', 'B', '1', 'B', 'C',
    'C', 'D', 'B', 'C', '8', '0', '3', '9', '0', 'F', '8', '2', '1', '9', 'D', '7',
    '6', '9', '1', '1', '5', 'E', 'B', 'B', 'B', 'F', 'C', 'F', '3', '3', 'C', 'B',
    'C', '0', '9', '6', '9', '3', 'D', '2', 'B', '9', 'B', 'B', '0', 'A', '5', 'E',
    '9', '1', '3', '6', 'A', '6', '3', '9', 'B', '0', '0', '1', '7', 'E', '7', '6',
    '0', 'D', '9', '7', '9', 'E', '9', '0', '8', 'E', '6', 'A', '6', '7', 'C', 'A',
    'D', 'C', '8', 'A', '5', '9', '6', 'D', '0', '8', '1', '8', 'D', 'E', 'C', '3',
    'D', '5', '3', '4', 'E', 'D', '1', '0', '2', '1', 'C', '3', '2', '1', '9', '6',
    '8', '3', '5', 'D', '1', 'F', '7', '4', '5', '9', '5', 'A', '2', '7', 'C', '8',
    'C', '3', 'D', 'A', 'D', 'C', 'D', '4', 'C', 'A', 'D', 'D', '2', '6', '6', 'B',
    '9', '9', 'B', '6', '3', '2', '0', '4', '6', '6', '8', 'A', 'B', '1', 'F', 'E',
    '8', '3', '8', '4', '8', '2', '3', '4', 'C', 'B', 'A', '5', '3', '9', 'F', '1',
    '2', '2', '2', '3', 'A', 'D', 'E', '3', '2', 'D', '2', '1', '5', 'C', '1', 'B',
    '7', '3', 'F', 'A', 'C', '1', '2', '6', '0', '5', '0', '4', 'E', '3', 'F', '5',
    '1', '3', 'C', '1', 'F', '6', '3', '0', '0', 'B', '4', '5', '1', 'E', '5', 'A',
    'F', '6', '2', '2', '7', '5', '7', '3', '5', 'D', 'B', '3', 'A', '2', 'D', 'A',
    'F', '1', 'A', '4', '5', '0', 'F', '4', '0', 'F', '8', '3', '4', '1', 'A', 'D',
    'A', 'C', 'D', '6', 'A', 'F', '4', 'F', 'C', '5', '7', 'E', 'F', 'F', '7', 'E',
    '7', '0', 'F', '5', 'F', '1', '3', 'A', '8', '6', 'A', '6', '8', '5', '4', '0',
    'F', '1', '1', '5', '2', 'E', 'C', '5', '3', '2', 'C', 'C', '0', '4', '9', '9',
    '0', '2', 'D', '5', 'B', 'D', 'C', '8', '5', '6', 'B', '3', 'D', 'F', '5', 'B',
    'A', 'D', '8', '6', '5', 'D', 'D', 'E', 'D', '8', 'B', '2', '5', '5', '8', 'D',
    '6', '5', 'C', 'C', '9', 'E', 'E', '3', 'B', '1', 'D', '7', 'A', '9', '6', '5',
    '1', 'A', 'C', '6', '4', '2', 'A', 'D', '7', 'B', '3', 'B', '5', '7', 'D', '8',
    'C', '2', 'D', '9', '4', '7', 'C', '6', '3', '2', '5', 'A', 'D', 'C', '7', '9',
    'C', '6', '1', '1', '8', 'E', '6', '1', '3', 'C', '8', 'C', '0', '2', '6', '7',
    '7', 'A', '4', '7', 'E', 'E', '3', 'F', 'E', '4', '3', 'A', '0', '0', '8', '5',
    'E', '5', 'F', 'D', '9', '1', '2', '1', '4', '6', '6', '1', '1', 'F', '3', '7',
    '1', '7', '7', '8', '7', '6', '6', 'C', '1', 'B', 'C', '4', '0', '8', '3', '6',
    '0', '9', 'F', '5', '0', '1', '3', '5', 'E', '0', '9', 'A', '4', 'E', 'C', 'E',
    '4', '6', 'D', '5', '9', 'A', '2', 'F', '8', '1', '2', '7', '7', 'A', 'A', '8',
    'D', 'E', 'A', '4', '6', 'D', '4', '6', '5', 'F', '8', '2', 'B', '7', 'A', 'E',
    '5', '9', '3', 'D', '5', '5', 'F', '4', '6', '1', 'F', 'A', 'F', 'F', '2', 'C',
    'A', '0', '6', '9', '0', 'F', '3', '9', 'F', 'E', 'B', '5', 'B', 'A', '9', '8',
    'F', '8', 'C', '0', '1', 'C', 'E', '1', '1', '9', '5', '0', '5', 'E', 'D', '2',
    'D', '1', 'D', 'D', '1', '0', '1', 'D', '1', '4', '7', '1', '9', 'A', 'D', '1',
    'B', 'E', '1', 'E', '9', '0', 'E', 'C', 'E', '6', '9', '7', '9', 'C', '2', 'E',
    '4', 'B', 'A', '2', 'D', '8', '3', 'F', '8', '0', '7', 'A', 'B', '8', 'A', 'E',
    '1', '9', 'A', '1', 'E', '4', '2', 'C', 'D', '7', '4', '7', 'D', 'C', '0', '4',
    '9', 'A', '6', '5', 'E', 'D', 'A', 'F', '4', '1', '2', '3', 'D', '6', '6', 'F',
    '5', '9', '2', '4', 'E', 'B', '1', '9', '5', 'D', '0', '8', 'A', '0', '3', 'B',
    '7', '6', '3', '1', 'F', 'E', 'A', '6', '8', '1', '7', 'D', '0', '2', '9', '0',
    '4', '3', '0', '0', '6', '8', 'E', 'B', '7', '2', '0', 'B', '6', '3', '2', 'A',
    'F', '2', '4', '7', '3', '0', 'F', '4', 'C', 'F', '9', 'E', '5', '4', '8', '0',
    'F', 'E', 'C', 'E', 'D', 'D', '8', '6', 'E', 'F', 'C', '9', '4', '3', 'F', 'E',
    '0', '6', 'F', 'C', 'A', 'E', '6', '7', '3', '9', '1', '8', 'C', 'C', 'B', '2',
    '0', '0', '3', '1', '7', '6', '9', 'E', 'E', '3', '1', '0', 'C', 'E', 'E', '5',
    'A', 'E', '9', '4', '4', '9', '4', '5', 'E', '2', '6', '3', 'E', '8', 'B', '6',
    'E', '9', '3', '7', '0', 'A', '8', '0', '3', 'E', '4', '1', 'C', '1', 'A', '7',
    '1', '1', '4', 'F', '3', 'E', 'E', '6', '5', '3', '0', 'A', '1', '4', '4', '3',
    '4', '0', 'F', 'D', '4', 'E', '1', '8', '0', '4', '6', '7', 'B', '3', 'A', '9',
    'E', '0', '7', '3', '5', '6', 'E', '7', '9', '8', '6', 'B', '7', '0', '3', '2',
    '9', '3', 'E', '9', '8', 'F', '3', 'F', 'A', 'C', 'A', '1', '7', '0', '4', 'E',
    'A', 'E', '3', '1', '4', '8', '3', '8', '6', '5', '1', '9', 'E', 'B', 'F', '2',
    '4', '9', 'B', 'A', 'F', 'B', '7', 'B', 'A', '2', 'D', '6', '9', '7', 'F', 'C',
    '0', '2', '8', '0', '1', '2', 'F', '1', '7', '2', '7', 'B', '0', '4', 'E', 'A',
    'E', '2', 'B', '2', '9', '7', 'C', '9', 'A', 'C', '0', 'D', 'A', '3', 'C', 'A',
    '5', '3', 'E', '2', '3', '8', 'B', '5', '2', '0', '2', '4', 'A', 'B', '3', '2',
    'D', '9', '9', 'D', 'B', '9', '1', '7', '4', 'A', 'D', '0', 'F', 'E', 'E', '6',
    'A', '2', 'F', '2', '9', '1', '8', '2', '7', '8', 'D', 'E', '6', 'F', 'B', 'F',
    '7', '8', '1', '7', '3', '4', '6', '6', '5', '4', '3', '2', '8', '5', 'F', '5',
    '2', 'C', '1', '3', '2', '5', '2', '6', '1', '2', '8', '7', '7', '2', 'B', 'C',
    '3', '5', '0', '2', 'B', 'F', '3', 'F', '8', '1', '7', '1', '8', 'B', '9', '2',
    '2', '5', '3', '8', '9', 'D', '3', '5', '0', '8', '2', 'B', '1', '8', 'D', '0',
    '9', '5', '5', 'C', 'B', '2', 'B', '1', '4', 'D', 'B', '1', '7', '0', '8', 'D',
    '6', '3', '9', '8', '8', '7', 'C', '0', '5', 'A', '6', 'E', '7', '6', '9', '0',
    '8', '2', '2', '4', '3', 'E', '1', 'F', 'B', '7', 'A', 'E', 'F', '8', 'A', 'B',
    'B', 'D', '7', 'B', '4', '3', '9', 'C', 'A', '4', '1', '4', '7', '9', '0', 'C',
    '6', '5', '3', '6', 'A', '3', '9', '1', '1', '1', '0', 'A', '1', 'C', '9', 'F',
    'C', 'A', '2', 'F', 'F', '4', '4', 'D', '5', '6', '1', '5', 'B', 'A', 'E', '9',
    'E', 'C', '7', '1', 'F', 'A', '8', '0', 'B', '5', 'F', '9', 'F', '2', 'D', 'C',
    '7', '7', '0', '8', 'A', 'E', '4', '4', 'B', 'A', '5', '8', 'E', 'D', '2', '1',
    '2', '4', '8', 'F', '0', '3', '8', '0', '6', '2', '8', '6', '4', '6', 'E', 'F',
    '7', '2', 'A', '4', 'D', 'A', 'E', 'B', '5', '1', '8', '8', '0', '7', '8', '7',
    '0', '8', 'C', '5', '4', '1', 'F', '8', '0', '7', '1', 'C', '4', '8', '9', '7',
    '2', 'C', 'D', 'A', '0', '7', 'D', '6', 'C', '3', '2', 'C', 'B', '6', '9', '0',
    '0', '9', '8', '0', 'D', '8', 'A', 'D', '3', '0', '7', 'D', 'B', 'B', 'E', 'A',
    '4', '5', 'A', '7', '6', 'F', '5', '7', '9', '1', 'C', '8', 'C', 'F', 'A', '9',
    'B', '2', '8', '5', 'E', '5', 'B', 'F', 'B', '0', '2', '5', 'A', '2', 'A', '0',
    '5', 'C', 'C', '8', '9', '4', '7', 'D', '0', '6', '5', '2', '9', '3', 'A', '8',
    '6', '4', '5', 'F', '6', '8', '5', 'F', 'B', 'D', 'D', 'E', '3', 'B', '1', 'D',
    'A', 'D', '3', '5', 'A', '5', '1', '0', '4', '0', '1', 'D', 'A', 'E', '1', 'F',
    '8', '3', '1', 'F', '5', '9', '0', '6', '6', 'F', 'A', 'B', '5', '0', 'F', 'B',
    'D', 'C', 'B', 'E', 'A', '3', '4', '1', '4', '4', 'B', '9', '9', '8', 'D', '4',
    '1', '3', '6', 'E', 'B', 'F', '5', '5', 'F', '1', 'C', '9', '9', '6', '7', '3',
    'A', '1', '7', '8', '1', '9', '9', 'D', '5', 'A', 'B', '8', '3', '8', '2', '1',
    '9', '9', '5', 'F', '3', 'F', '8', '0', 'A', 'A', 'E', '7', '8', 'D', '2', 'E',
    '2', '2', '4', '2', 'F', '7', '2', 'D', '1', '3', '9', '2', '1', '1', 'C', '9',
    '2', 'E', '2', 'D', 'B', 'E', 'B', '8', '5', '1', 'C', '1', 'A', '7', 'C', 'D',
    'C', 'E', '8', 'A', 'E', 'F', '8', 'D', '6', '2', 'A', '6', 'D', '7', '2', '7',
    'D', '0', '0', 'C', '8', 'F', 'A', 'F', 'F', '1', 'F', 'F', 'F', 'D', '7', '2',
    'E', '9', 'C', '3', '0', '1', '2', '7', 'E', '0', 'D', '0', '9', '5', 'C', '4',
    '8', 'F', 'C', '6', '7', '3', '1', 'E', 'A', 'A', '3', '0', 'A', '0', '3', '9',
    '2', 'B', 'A', 'B', 'E', '0', 'C', 'B', '2', 'F', '9', '3', '3', '8', '4', 'A',
    '5', '3', 'A', '6', 'A', '6', 'F', 'D', '0', '9', 'B', '5', '3', '0', '1', '1',
    'C', '7', 'B', '1', 'F', 'F', 'F', '8', '5', 'A', '4', 'E', '1', '2', '7', '2',
    '5', 'C', '0', '9', '4', '2', '0', '7', 'F', '1', '4', 'A', 'B', '2', '4', '2',
    'D', 'A', 'B', '9', 'A', '9', 'F', 'A', 'D', 'B', '9', '3', 'C', '9', 'B', '0',
    '9', '8', '2', '5', '3', '8', '0', '0', '3', '3', '9', 'B', 'F', '8', '5', '0',
    'E', '3', 'B', '0', '8', 'E', 'A', '5', 'E', '9', 'E', '8', 'F', '7', '8', 'A',
    '3', 'B', '3', 'D', 'B', 'C', '0', 'D', 'F', '2', '4', 'C', '5', 'D', '2', 'D',
    '3', 'C', '4', '6', 'F', '1', '1', '7', '5', '5', 'A', 'A', 'B', 'A', 'B', 'D',
    'D', '1', 'F', '9', '1', 'F', '6', '0', '4', 'F', '1', '4', 'B', 'A', 'B', '9',
    '0', '9', '3', '4', '2', '0', '7', 'F', '8', 'C', '0', '8', '5', 'A', '7', '0',
    '1', 'D', 'A', 'B', 'B', '3', 'E', '0', '2', '1', '4', '7', '4', 'A', '0', 'B',
    '4', '3', '5', '8', 'D', '5', '9', '7', 'D', '7', '2', 'B', '3', 'C', '3', '4',
    'A', 'E', '2', '7', 'E', '6', '1', '7', 'C', 'A', 'B', '1', 'D', '1', '6', '5',
    '5', '9', '5', '4', '2', '6', '9', '5', '3', '6', '2', '5', '7', '4', '2', '4',
    'D', 'D', '9', '4', '4', '8', 'D', '1', '0', '5', 'F', '8', 'A', 'A', '4', '4',
    'E', '1', 'D', 'F', '6', '5', '9', '8', '7', '3', 'A', '6', '0', '4', '4', 'D',
    '1', 'F', 'F', '8', '4', '3', '8', '9', 'F', 'D', '3', '9', '2', '3', '2', '2',
    'C', '2', 'D', '4', '7', 'C', '3', 'C', '5', 'C', '9', 'C', '4', 'E', '6', '5',
    '1', '4', '4', '8', '2', '9', '8', 'F', '0', '6', 'E', '9', '5', '4', 'F', '0',
    '4', '6', '6', '9', '0', '3', 'B', '8', '2', 'E', '7', '8', '2', '0', 'A', 'F',
    '8', '7', '3', '2', '8', '9', 'F', '7', '0', '8', '2', 'D', '3', 'F', 'C', '2',
    '6', 'F', '7', 'E', '9', '1', '0', '6', '9', '7', '0', '1', 'A', '3', '7', 'E',
    'F', 'C', '8', 'E', 'D', '0', '4', '0', '7', '9', '6', '0', '4', 'F', 'F', 'B',
    '7', 'F', 'F', '6', '3', '3', '5', '5', '7', '2', '3', '7', 'B', 'D', '2', '5',
    '1', 'C', 'F', '7', '2', 'A', 'D', '8', '4', 'C', '9', '9', '3', 'B', '7', '9',
    '2', 'D', 'B', '8', '9', 'C', '8', '2', '1', 'B', 'C', 'C', 'D', '5', '7', '3',
    '7', 'B', '7', '8', '5', '3', 'A', 'C', '8', '0', '1', '1', 'D', 'F', '8', '4',
    'A', 'D', '1', '6', 'A', '2', '0', 'B', '4', 'C', '9', 'C', '1', 'B', 'D', '0',
    '0', '3', 'A', '7', '4', '0', 'F', '0', '5', 'D', '7', '9', '3', '2', 'E', 'F',
    '7', '1', '6', '5', '8', 'E', '6', 'C', 'C', '0', 'D', '9', '0', 'B', '2', '9',
    'E', '3', '4', 'B', '8', '9', '8', 'F', '7', 'D', 'E', '9', '4', 'B', '7', 'A',
    '6', '7', 'A', '1', '1', '6', '8', 'B', '9', '9', 'D', '2', '7', '3', 'C', '5',
    'E', '2', 'E', 'B', '6', '4', '6', '4', 'B', '8', '6', '6', 'B', 'E', '0', '8',
    '5', 'B', 'D', '9', '3', 'E', 'B', 'A', '3', '8', 'D', '7', '8', '9', 'B', 'A',
    '2', '0', 'F', '8', '0', 'E', 'B', 'B', '0', '9', 'E', 'B', '9', '8', '7', 'D',
    '7', '3', 'D', '0', '7', 'B', 'A', '6', 'C', '9', 'D', 'B', 'E', '1', '6', '0',
    '2', '6', '3', '8', 'F', 'C', 'E', '5', '3', '1', 'A', '8', '5', '1', 'E', 'C',
    '9', 'C', 'F', '7', 'A', 'D', 'A', '9', 'D', '2', '1', '1', '4', '3', '8', '9',
    'B', 'A', 'C', '4', 'D', '6', 'C', '1', 'E', '3', '2', '8', '4', '7', '1', 'C',
    'C', 'E', 'B', '4', '5', 'E', 'C', '4', 'C', '2', '7', 'C', 'F', '5', '2', 'D',
    'A', '1', '8', 'D', 'E', '8', 'A', '6', '9', '5', 'B', 'D', '7', 'F', 'E', 'F',
    'F', '5', '7', 'E', 'D', 'B', 'A', '3', 'C', '7', 'F', 'E', '9', '5', '6', '8',
    '9', '3', '3', '2', '9', '7', '0', '4', 'B', 'F', 'D', '8', 'B', '7', 'F', '9',
    '7', '8', '7', 'E', 'E', 'A', '4', '9', 'B', 'B', '9', '9', 'E', '1', 'A', 'E',
    '7', '1', '4', 'D', 'D', 'E', '1', 'D', '6', 'B', 'C', '8', '7', '8', '4', '9',
    '3', '3', 'E', 'A', '3', '1', 'C', '9', 'B', '6', '8', 'C', 'F', '7', 'E', '9',
    '1', '5', '3', '8', '5', '5', 'B', '0', '1', '5', '6', 'B', 'F', '3', '5', '6',
    '6', '6', '0', 'A', 'E', '6', '8', '2', '4', '7', 'E', '0', 'F', '3', 'D', '4',
    'A', '2', 'E', '5', '5', '7', 'F', '9', '4', '3', '3', '2', '4', '2', '7', 'F',
    'B', '2', '8', '1', '0', '3', 'A', 'D', '6', '1', '6', '5', '4', '2', '8', '8',
    '5', '2', '0', '0', '8', 'A', 'E', 'C', 'A', '5', 'E', 'F', 'E', 'E', '9', 'C',
    '4', 'D', '5', '3', '6', 'D', '1', '7', '8', '8', '9', '5', 'E', '2', '9', 'B',
    '7', '4', '0', '7', '4', '4', 'B', '9', 'E', '8', 'A', 'A', '9', 'A', '6', 'A',
    '9', 'F', '4', '0', 'A', '5', 'C', '9', 'D', '0', 'C', 'B', '3', '2', 'C', '6',
    '2', '9', 'A', '8', 'E', '9', 'D', 'F', '1', '8', 'D', 'E', 'E', 'E', 'C', 'A',
    '2', '3', '0', '2', 'F', '8', 'C', 'F', '0', '2', '2', '7', 'D', '8', '4', '6',
    '7', 'E', '8', '9', '5', '3', '1', 'C', 'F', '7', 'F', '1', '5', '3', '8', '8',
    'F', '7', 'B', '5', 'E', '6', 'A', '5', 'E', 'F', '4', '5', 'C', 'F', 'F', 'B',
    '7', 'E', '7', 'F', '3', 'F', '6', 'C', '6', '7', '4', 'D', '2', 'D', 'B', 'F',
    'C', '0', '2', '2', 'C', '4', 'F', 'C', 'E', '5', '1', '7', '7', 'D', '8', 'A',
    '6', '8', '7', 'A', '0', 'B', 'F', '4', 'D', '9', 'A', 'A', '7', 'E', '6', '8',
    '1', '2', '4', '1', '4', '6', '1', 'D', '4', '3', '6', 'C', '8', '6', 'B', '9',
    '7', '1', '8', 'F', '5', 'D', 'E', '5', '7', '1', '5', 'C', '4', '1', 'B', 'B',
    '7', '9', '2', '4', '9', '0', '4', '5', '4', '9', 'C', 'A', 'C', 'B', '8', 'A',
    '1', 'C', 'C', '0', 'C', 'A', '0', 'C', 'A', '8', '2', 'B', 'E', '8', '7', '8',
    '4', 'C', '0', 'B', 'B', '3', 'A', '0', 'D', '6', '8', 'E', 'B', 'E', '3', 'C',
    '3', '2', '9', 'B', '0', 'E', '7', 'D', 'F', 'E', '4', '5', '0', '8', 'B', '9',
    'C', 'D', 'C', '7', '1', 'B', 'E', '6', 'C', 'D', '5', '2', '8', '8', 'B', 'F',
    'D', '0', '6', '9', '5', '1', 'E', '4', '1', 'A', 'A', '7', '5', '7', 'C', '0',
    'C', '8', 'F', '6', '9', '2', 'C', '0', '8', 'E', '2', '0', '5', 'C', 'F', '8',
    'C', '4', 'A', '2', '9', 'E', 'A', '8', 'F', '1', '3', 'C', '4', '5', '7', '2',
    'B', '2', 'C', 'E', '9', '9', 'B', 'F', 'B', '7', 'D', '6', 'E', '7', '2', '2',
    'C', '2', '0', 'E', '7', '8', '7', '4', 'F', '2', '2', '8', '2', '8', '0', '3',
    '0', '6', '8', 'D', '3', '9', '5', '8', '1', 'E', '1', 'E', '0', 'B', '2', '5',
    'E', '9', '2', '7', '1', '5', 'E', 'D', '7', '9', 'C', '9', 'E', 'E', 'F', 'B',
    'D', '6', '1', '8', '6', '8', '5', 'F', '5', '3', '0', '6', '2', 'F', '7', 'A',
    'E', 'B', '6', '1', '3', '4', '7', '1', '7', 'B', '8', 'D', '9', 'A', 'F', 'A',
    '0', 'C', '0', 'B', 'D', '4', 'A', '6', '2', '2', '7', 'B', '1', '3', 'B', 'F',
    'A', '7', '3', 'C', 'E', '1', '6', '0', 'A', '8', '7', '2', 'A', '9', '0', 'F',
    'E', 'E', 'A', 'D', 'F', 'B', '6', '8', 'B', 'C', 'C', '4', '1', 'E', '2', 'A',
    '7', 'E', 'F', 'C', '7', '5', 'B', 'F', 'D', '5', '9', 'A', 'B', '1', '6', 'B',
    '2', '6', '1', 'B', '3', 'D', '6', '3', '9', '8', '7', '5', '8', '5', '4', '7',
    '0', 'E', '2', 'D', '7', 'F', '3', 'E', 'F', 'F', '0', 'F', 'C', '5', 'B', 'F',
    '2', '8', 'F', '1', '8', '4', '9', 'B', 'D', '8', '2', '4', '3', '4', 'C', '2',
    'D', 'A', 'F', '6', '5', 'D', '4', '2', '5', 'A', '1', '8', '3', '0', '9', 'E',
    '7', '1', 'A', '6', 'B', '2', '0', '8', 'B', '7', '6', 'F', 'B', '9', '8', '1',
    'E', '2', '8', '2', 'A', '3', '8', '9', '4', 'C', 'B', '2', '2', '3', '9', '9',
    'E', '4', '1', 'B', '2', 'F', '7', 'F', 'F', 'E', 'D', '3', 'C', '2', '4', '3',
    'A', 'B', 'A', 'D', 'B', '2', 'A', 'F', '9', '1', '2', '6', '9', 'E', '6', 'D',
    '9', 'A', '7', '7', 'D', '4', '2', '4', 'B', '9', 'E', 'F', 'C', 'C', 'B', '4',
    'E', '1', '9', '3', '1', '5', '6', '6', 'A', '5', '9', 'D', '2', '5', '9', '7',
    'C', 'E', '2', 'B', '8', 'A', 'D', '6', 'D', '3', '8', 'E', '3', '6', 'A', 'D',
    '1', '3', 'F', '9', '5', '2', 'E', 'A', 'A', 'A', '6', '4', '1', 'C', 'A', '2',
    '0', 'C', 'D', 'A', 'E', '7', '6', '8', 'B', '5', '1', '0', 'C', '7', '3', '8',
    '1', '9', '8', '6', 'B', '7', '8', 'E', 'B', '8', '5', 'F', 'D', '1', 'B', 'A',
    'F', 'E', '5', '6', 'C', '7', '7', 'E', '7', 'B', '4', '3', '0', '9', '2', 'C',
    'E', '6', '8', '1', '7', 'B', '1', 'E', '0', 'C', '7', '4', '8', 'D', 'E', '5',
    'E', 'F', '6', 'A', 'A', '0', 'F', 'B', '1', '8', '2', '2', '7', '8', 'B', '4',
    'C', '1', '1', 'A', 'D', '5', '1', '9', '6', '1', '5', '6', 'B', '4', '8', 'E',
    '8', '9', '5', 'C', '0', '3', 'B', 'F', '2', '6', '1', 'D', '7', '6', '4', '4',
    '4', '4', 'C', 'A', '2', '1', 'C', 'C', '7', '3', '7', 'A', 'C', 'F', 'D', '0',
    '4', 'B', '7', '7', '8', '8', '6', 'F', 'D', 'F', 'A', '0', 'D', '5', '9', 'E',
    '5', 'D', 'F', 'D', 'E', '7', 'F', '8', '8', 'C', 'D', 'F', '4', '1', '6', '2',
    'E', 'F', 'C', 'F', '4', 'D', '3', '1', '6', 'D', 'E', 'D', 'C', '2', '0', 'C',
    '6', '6', '2', 'A', '5', '6', '1', '2', '3', '1', 'D', '4', 'D', '4', '4', '8',
    '5', '9', 'A', 'A', '8', '3', 'A', '2', 'D', '4', '9', '8', '9', 'A', '5', '0',
    '8', '3', '0', '1', '8', '5', '6', '7', 'D', 'A', 'C', '8', '6', 'E', 'F', '9',
    'C', '2', '4', '1', 'F', '6', '8', 'F', '7', '1', 'D', '3', '8', '1', '2', '9',
    '3', '0', '9', '3', '4', 'D', '9', 'F', '9', '8', '0', '4', '3', 'B', '0', '3',
    'E', '0', 'B', 'C', '3', '4', '4', '5', 'E', 'F', 'D', '1', 'C', '4', '3', '2',
    '3', '4', 'D', '2', '9', '2', '5', 'C', '3', '3', '3', '7', '1', '5', '4', '8',
    '2', '0', '8', 'F', 'F', '8', '7', 'E', '6', 'C', '9', 'F', 'E', '7', 'C', '9',
    '1', 'B', 'D', 'E', 'E', '4', '2', '7', '6', 'F', '6', '5', 'A', '4', '7', '5',
    '0', 'D', '0', '4', 'F', 'D', '2', '6', 'B', 'D', '3', '3', '8', '3', '2', '4',
    'C', 'D', 'B', 'E', '3', '9', 'E', 'C', '6', 'C', '6', '8', '5', 'B', '1', 'C',
    '3', '4', 'C', 'B', '8', '7', '5', '6', '6', 'C', 'D', 'B', 'D', '6', '6', '2',
    '6', '4', 'B', 'E', 'A', 'C', '6', '7', '4', 'C', '6', '3', 'B', '5', '8', '3',
    'F', '1', 'D', '2', 'A', '8', '5', '9', 'E', 'B', '2', 'B', 'C', 'D', 'F', 'A',
    'C', '5', 'E', '4', '5', '2', '8', '0', 'D', '9', 'C', '3', 'C', '4', '5', '1',
    '2', '0', '6', '8', '5', 'A', '4', '0', 'D', 'A', '6', 'D', '3', '6', '7', 'F',
    '8', '1', '2', 'A', '2', '9', '9', '5', '3', '0', 'B', '5', '8', 'D', '5', '4',
    '8', 'E', 'D', '9', '5', '4', 'F', 'D', 'E', 'E', '3', '2', '8', '0', 'D', 'B',
    'D', 'D', '9', 'B', '2', '3', '1', '7', '3', 'C', '0', 'D', '5', 'C', 'D', '4',
    '5', '0', 'E', '5', '0', '9', '2', 'A', '7', '2', '6', '5', '6', '5', 'F', '3',
    'C', '9', '0', '4', 'F', 'C', 'E', 'C', '1', '5', 'B', 'C', '8', '8', '2', 'F',
    'F', 'B', '3', '0', '8', '2', 'A', '3', '5', '0', 'C', '8', '9', '2', '6', '7',
    '4', 'E', '4', 'E', 'E', '7', '3', '4', 'F', '9', '2', 'F', '7', 'F', '3', '1',
    '8', '1', 'E', '7', '9', '9', '0', 'C', 'A', '9', 'F', '6', 'D', 'E', 'A', '4',
    '1', '7', 'E', 'F', '8', '1', 'F', 'C', 'D', 'F', '7', '7', 'E', '9', '6', '8',
    'D', 'A', 'F', '4', '2', '6', '6', 'F', 'E', '2', '7', '7', 'D', 'B', 'F', 'D',
    '1', '7', '6', '9', '7', 'B', 'C', '4', '9', 'E', 'D', 'A', '3', 'D', '5', '8',
    'F', '3', '2', '7', 'B', '1', 'A', '4', '6', '6', '1', 'E', '3', '5', '4', '0',
    'E', 'A', '7', 'C', 'A', 'E', 'F', 'B', 'F', 'B', '5', '4', '7', 'B', 'D', 'C',
    'C', '8', '1', '6', '9', '8', '3', '2', 'B', '6', '0', 'D', 'E', '5', 'D', '0',
    '7', '4', '9', '9', 'E', '2', '2', 'F', 'F', '5', 'C', '7', '1', 'D', 'C', 'C',
    '2', '2', 'E', '0', '5', 'C', '9', 'C', '6', 'C', '6', '1', '3', '1', '3', '9',
    'C', 'F', '2', 'F', '0', '2', '4', '5', '8', '4', '6', '3', 'E', '5', '2', '2',
    '7', '3', 'F', 'D', '0', 'D', '6', '0', '2', 'E', '6', 'F', '0', '8', 'A', '0',
    'A', 'C', 'D', '7', '4', '6', '5', '4', 'C', '0', '3', '8', 'C', 'C', '4', '1',
    '2', '2', 'C', '4', 'F', 'B', 'E', 'A', '6', 'C', '1', '9', '5', '5', '2', 'F',
    '5', '3', '7', '0', 'A', 'F', '0', '0', 'B', '7', '0', '8', '0', 'F', '5', '2',
    'F', '2', 'B', '1', '4', '8', 'D', '3', 'E', '8', '5', '3', 'D', '7', 'C', '1',
    '0', 'B', '8', '1', 'E', '1', '1', '7', 'E', '8', 'C', 'D', '5', 'B', '7', 'E',
    '6', 'F', 'B', 'C', '1', '1', '8', 'F', '3', '0', 'D', 'B', '5', '1', 'D', '7',
    '4', '6', 'A', 'E', '9', '0', '0', '2', 'D', '8', 'C', '8', 'F', 'E', 'D', 'C',
    '9', '4', '7', 'E', 'D', 'F', '5', '3', 'D', '2', '3', '7', '1', 'A', '8', '4',
    'D', 'E', 'B', '9', '8', '8', '5', '8', '8', 'C', 'E', 'D', 'E', '4', '6', '7',
    '3', '8', 'D', 'A', 'D', 'B', '1', '5', '3', '6', '2', 'C', '8', '7', 'C', '0',
    '8', 'C', '2', '5', 'C', '8', '4', '1', '9', 'D', '4', '8', 'F', '7', '8', 'C',
    '4', 'E', '2', '5', 'F', 'F', 'B', 'C', '3', '9', '9', 'D', 'C', '6', '3', 'A',
    'E', '3', 'D', 'B', '2', 'D', '3', '6', '0', 'F', '8', '3', '1', 'A', '0', '7',
    'B', 'A', 'D', '6', '9', '7', 'A', '0', '9', '7', '8', '7', '3', 'C', '6', 'D',
    '0', '4', '6', 'C', 'B', '3', '4', '8', '6', 'E', '7', '5', 'C', '8', '6', '0',
    '4', '6', 'D', '7', '4', '5', 'E', '8', '5', '0', 'B', '3', '1', '9', 'F', '6',
    '0', '2', 'E', 'C', 'F', 'F', '0', '4', '0', '0', '7', 'E', 'A', 'B', 'A', '5',
    '0', '0', 'F', '0', '0', '7', 'D', '2', '9', 'E', '1', 'D', 'B', '8', '1', '8',
    'D', '2', '8', '4', 'D', '0', 'C', 'B', '0', 'A', '7', '8', '6', '3', '2', '8',
    '8', 'C', '5', 'C', '5', 'D', 'D', '7', 'F', 'E', '8', 'F', 'F', '2', '2', '8',
    'F', '0', 'E', '6', '1', '6', '0', 'B', 'D', '3', '2', '6', '8', 'A', '6', '8',
    'D', 'B', '0', '1', 'C', '3', '5', 'C', 'B', '1', '8', '2', '9', '0', 'E', 'C',
    'B', '8', 'D', 'A', '2', '3', '6', 'C', 'C', '0', '4', '3', '4', '0', 'B', 'F',
    '9', '6', '3', '6', 'E', '8', '2', '1', '8', '9', '6', '1', 'E', '2', 'B', '3',
    '7', '1', '5', '9', '0', 'A', '2', 'F', '0', '6', 'C', 'C', 'A', '7', '5', 'E',
    '9', '0', '9', '8', '3', 'A', 'A', 'F', 'B', '6', '9', '2', 'E', 'D', 'E', '3',
    'E', 'D', 'B', '3', '0', 'E', '7', 'D', 'D', '8', 'A', 'C', 'C', 'F', 'E', 'C',
    'D', '4', '6', 'F', 'F', 'B', '2', '5', '8', '6', '8', 'B', '1', '7', '4', '8',
    'A', 'A', '3', '1', '7', '3', '6', '3', '9', '1', 'B', '3', 'B', 'F', 'D', '3',
    '9', '2', 'A', '7', '8', '0', '7', 'D', 'D', '3', '4', '4', '2', 'D', '0', 'E',
    '2', '9', '1', '5', '4', 'C', '0', '1', '7', 'B', 'E', '3', '1', '6', 'C', '0',
    '5', '3', '4', '5', 'C', '4', 'B', '6', '2', 'A', '1', 'A', 'F', '2', '0', '5',
    'E', '5', 'E', 'A', 'A', 'F', '9', '9', '8', 'E', '5', 'B', 'C', 'B', '0', '3',
    '5', '5', 'C', '6', 'A', 'A', '8', '6', '0', '1', '9', 'D', 'A', '1', '3', '0',
    '9', 'A', '8', 'B', 'E', '1', '5', '9', '9', '2', 'A', '2', 'E', '0', '0', 'D',
    'A', 'F', '7', 'C', 'D', 'D', '6', '0', 'D', 'B', '4', '8', 'F', '1', '3', 'B',
    'C', '9', '5', '7', 'E', '8', 'A', 'B', '8', 'B', 'B', 'E', '8', '6', '5', 'D',
    '6', '5', 'A', '5', '5', 'C', '2', '4', '3', '2', '5', '7', 'A', 'A', '8', '5',
    '9', '7', 'F', 'D', '7', '6', 'A', 'F', '8', '1', 'C', 'A', '4', 'A', '3', 'C',
    'D', '8', '3', '7', '8', '7', '4', '6', 'C', '7', '4', 'E', '0', '6', '0', 'F',
    '0', '0', 'F', '8', '5', '3', '5', 'C', '7', '1', '8', '8', '1', '0', '8', 'B',
    'B', '6', '3', 'B', 'D', '5', '7', 'C', '1', '8', '5', 'E', 'C', '8', '5', '2',
    'D', '8', '9', 'E', '9', 'D', '1', '3', '4', '9', '1', '0', '4', '9', '9', '6',
    'E', '6', '1', 'E', 'F', 'A', '1', 'D', '8', 'B', 'B', 'A', 'A', 'E', 'C', 'B',
    '6', '2', '3', '3', '5', 'F', '7', '4', '8', '3', '6', 'F', 'B', '3', 'D', '8',
    '5', 'A', 'E', 'A', 'F', '3', 'E', '2', '3', '7', 'C', '1', '3', '7', '7', '7',
    'B', '1', 'B', 'E', 'C', 'D', 'E', '6', 'D', '9', 'E', 'C', '8', '4', '6', '7',
    '7', '6', '8', '7', 'A', 'F', '6', '1', '9', 'E', 'E', '7', '4', '0', '0', '2',
    '1', 'A', '0', '6', 'E', 'C', 'A', '2', '2', '1', '3', '0', '6', '8', '7', '0',
    '6', '1', '3', '5', 'C', '8', 'F', '9', '0', 'F', 'F', '3', 'F', '8', '0', '6',
    '3', '2', '2', '1', 'C', '4', 'D', '9', 'D', 'C', '9', 'B', '9', '8', '1', '9',
    'C', '4', '2', '8', '2', '2', '1', '1', '2', '0', '7', 'D', 'D', 'F', 'E', 'A',
    '3', 'B', '1', 'A', 'F', 'B', 'F', 'D', '1', '6', '7', '7', 'C', '2', '7', '0',
    'E', 'B', '5', 'E', '4', 'B', '7', '7', '2', '9', 'E', '9', '7', 'F', 'F', '4',
    '6', 'E', '0', '3', '6', 'E', 'D', '4', 'A', '7', 'E', '7', '1', 'C', '8', '4',
    'D', 'C', '7', '7', '2', 'A', 'A', '8', '4', 'D', '8', 'D', 'C', 'D', '2', 'E',
    '3', 'B', 'D', '6', '6', '3', 'D', 'B', 'E', '3', '1', '5', '2', '2', '8', 'A',
    '5', 'E', '9', '1', '2', '3', 'A', '6', '3', 'C', '9', '0', '5', '4', '5', 'B',
    '7', '2', 'D', '1', 'B', 'E', 'C', '3', '9', '2', '1', '2', 'D', '0', 'C', '1',
    'D', 'C', 'A', 'E', '9', '5', '8', '3', 'E', '1', '2', '7', '3', 'C', 'D', '7',
    'F', 'F', '9', '3', '3', 'A', 'A', 'E', '8', 'A', 'C', '5', '2', '5', '1', '8',
    '0', 'F', '6', 'E', '7', 'F', '3', '3', '7', 'B', '7', '1', '8', '3', 'A', '2',
    '6', '6', '8', '1', 'B', 'A', '4', 'A', '8', '3', 'C', '1', '5', '4', 'D', '6',
    'B', '3', '2', '8', '0', 'C', '3', '3', 'E', 'F', '8', '2', '9', 'F', 'F', 'E',
    '4', '3', '2', '1', '3', '9', '6', 'F', '6', '0', '2', '1', 'F', 'E', '4', 'B',
    '3', '3', 'D', 'D', 'A', '5', '6', '5', '1', '0', '8', 'B', 'B', '2', '2', 'D',
    '1', 'B', 'C', '8', '9', '5', '7', 'E', '4', '9', 'A', 'C', 'E', '9', '9', '6',
    'D', '0', 'E', '2', 'C', 'A', 'C', '6', '3', '3', 'B', '4', '0', '8', '3', '2',
    '7', '1', 'F', 'A', '7', '0', '2', '4', '1', 'D', '1', '6', '7', '8', 'A', '7',
    '7', 'A', '5', '7', '0', '8', '3', 'A', '8', '6', 'E', '0', 'D', 'F', '6', 'E',
    'C', '7', 'B', 'B', '0', '6', 'F', 'E', '7', '1', '5', 'D', 'C', 'E', 'D', '2',
    '1', '1', '1', '1', '9', '2', '9', 'D', '7', '5', '6', '9', 'E', 'F', 'C', '2',
    '1', 'C', 'F', '6', '7', '4', '9', '9', 'C', '9', '1', 'E', '3', '0', 'A', 'A',
    '5', 'A', 'A', 'E', 'B', '6', 'F', 'D', '5', 'C', 'E', 'D', '9', 'C', '4', '2',
    'A', 'D', 'B', 'D', '6', '5', 'D', '3', '3', '6', '3', 'E', 'B', '9', 'E', '8',
    '0', 'A', 'B', '2', '7', '7', '6', 'C', '3', 'D', '1', '2', '0', 'F', '4', 'A',
    '9', 'E', 'B', '9', 'C', '8', 'C', '4', '5', '1', '2', 'E', '3', '4', 'D', 'C',
    'B', '2', '9', 'A', '9', '7', '2', '5', '1', 'D', '4', '9', 'E', 'C', 'D', '7',
    'C', '8', '0', '6', 'F', 'B', '9', '5', '9', 'F', '7', 'E', 'F', '1', '1', 'D',
    'E', 'E', '4', 'F', 'A', 'A', '4', '2', '9', '8', '4', '0', '5', 'C', 'E', 'D',
    '2', '3', '1', '6', 'B', 'E', '1', '1', 'B', 'E', 'F', 'C', '0', '7', 'C', '5',
    '6', 'E', '3', '6', '0', '1', '5', '4', '1', '0', '3', '5', '3', 'A', '2', '2',
    'D', 'B', '5', 'D', 'A', 'F', '5', '2', 'F', '1', '6', 'A', '7', 'C', '7', '1',
    '0', '4', '7', '8', '8', '5', 'C', 'F', 'B', 'C', '5', 'A', '2', 'E', 'C', '6',
    '9', '3', '5', '0', '7', 'F', 'E', '6', '8', 'C', '5', '4', 'E', '5', 'A', 'C',
    'C', 'A', 'D', '2', 'F', '7', '3', 'D', '9', '9', 'F', '8', '1', '9', '3', '4',
    '5', '1', 'F', '0', 'B', 'E', 'B', 'F', '3', '4', 'C', '4', 'D', '3', '4', '3',
    'F', '5', '5', 'F', 'E', '6', 'E', 'B', '1', 'C', '4', '6', 'F', 'D', '9', 'A',
    '3', '2', '0', '6', '4', '0', 'F', 'C', '2', '9', '5', 'D', '0', 'C', '1', '0',
    'B', '1', '3', 'C', '5', 'D', 'A', 'F', '9', '2', 'E', 'B', '8', '4', 'F', '4',
    '5', '9', '1', '9', '1', 'F', 'E', '5', '7', '4', '8', 'C', '4', '3', 'A', '5',
    'A', '3', '7', '4', '8', '0', '7', '6', 'B', '0', 'F', 'C', '8', '1', '1', '8',
    '9', 'C', '8', 'F', '2', 'D', 'F', '7', '7', '8', '4', 'A', 'C', 'B', '4', '5',
    '4', '6', '5', '6', 'E', '1', '5', '3', 'C', '0', 'D', '6', 'F', 'E', 'F', '6',
    '9', 'B', '5', '7', '8', '8', '2', '1', 'D', '3', '5', '0', '4', '9', '2', 'E',
    'D', '0', '0', '4', 'F', 'E', 'C', '8', '6', '5', 'D', '3', '8', '9', '3', '2',
    '4', 'D', '4', 'F', 'E', 'B', '8', 'F', 'E', '1', '8', '1', '6', '2', 'C', '8',
    '1', '1', '0', '3', '1', '5', 'B', 'E', '7', '3', '2', 'C', '0', '6', 'C', '0',
    '4', '4', 'B', '2', '2', '3', 'E', 'A', '8', '5', '2', '1', '8', '5', 'A', 'E',
    '3', 'C', '2', 'F', '2', '9', '6', '6', '1', 'F', 'F', '0', '6', '3', '6', 'E',
    'C', '1', '7', '3', '8', '9', 'D', '2', 'A', 'B', '0', 'F', '9', 'D', '8', '8',
    'C', 'D', '9', '0', '2', '2', 'C', 'B', '0', '3', 'F', 'A', '9', '2', '8', '8',
    '6', '2', '6', '0', 'E', '4', '5', 'A', 'F', 'B', '5', '4', '5', 'E', '7', '7',
    '7', 'B', 'E', 'C', '7', '1', '9', '7', 'A', 'F', '0', '9', '3', '6', 'F', 'A',
    'A', 'F', '4', '8', '5', '5', '2', '6', 'A', 'B', '0', 'A', '7', 'B', '2', '2',
    'D', 'F', '6', 'C', '2', '2', '5', '8', '5', '6', 'D', '8', '9', 'B', '9', '5',
    'D', '7', '1', 'C', 'D', '5', '7', '2', '7', 'E', '0', '9', '9', '6', '9', '0',
    '6', '5', '7', '5', 'F', 'C', 'F', 'C', 'D', '8', '0', 'A', 'F', '9', '4', '4',
    'E', 'F', '9', '5', '2', 'F', '8', '8', '7', '5', 'C', 'D', '4', '8', '4', '1',
    'B', '9', '3', 'F', 'B', '3', '9', '3', '9', '8', '9', 'B', '4', '3', 'A', 'A',
    '6', '1', '4', 'C', 'D', 'B', 'F', '1', '9', 'C', 'D', '2', 'E', '1', '5', 'E',
    'A', '3', '0', '8', '5', '9', '6', '8', 'D', 'F', '4', 'C', 'D', '5', 'B', 'D',
    '4', '8', 'D', 'E', 'C', 'F', '5', 'F', 'F', 'D', '7', 'B', '5', '9', '8', '6',
    'A', '8', 'B', '8', 'B', '4', 'E', '4', 'D', '9', '1', 'C', 'D', '7', '1', 'F',
    '8', '5', '0', '9', '6', '2', 'E', 'A', '6', '4', '4', 'C', 'B', '4', 'F', '4',
    '8', '5', '2', '1', '6', '8', 'D', '2', '7', '8', 'A', '1', 'C', '2', 'D', '2',
    'C', '6', 'B', '2', 'E', '9', 'C', 'B', '7', '7', 'F', '5', 'D', '3', '1', '5',
    '3', '9', 'D', '3', '5', '2', 'F', '2', 'E', 'F', '8', 'D', '2', '5', '2', '5',
    'E', '3', '8', 'F', '4', 'F', 'C', '5', '9', 'D', '2', '7', '2', '8', 'A', '9',
    'F', '4', '3', 'E', '6', 'C', '6', 'C', '9', 'F', '7', '1', '8', '5', '2', '8',
    'B', '2', 'B', '1', 'F', '6', 'B', 'B', 'D', '9', '7', 'B', '0', 'D', 'F', '0',
    '6', 'E', '8', 'A', '3', 'D', '7', 'E', 'F', 'E', 'B', 'B', '2', '5', 'F', 'F',
    '0', '3', '2', 'B', 'E', '5', 'C', '7', 'B', 'C', 'A', '8', 'E', 'F', '8', 'A',
    '8', '3', '4', '8', 'C', 'A', '0', '2', 'D', '2', 'A', '1', '1', 'D', 'B', '0',
    '8', '5', 'A', '8', '7', '0', 'D', 'D', 'B', '7', 'D', '7', '2', 'D', '3', '7',
    '4', '0', '4', 'D', 'E', '1', '9', 'E', '7', 'F', '5', 'E', 'D', 'E', 'A', '0',
    '9', '6', '6', '7', '1', '4', 'F', '2', 'E', '4', '4', '6', '1', '7', '4', '6',
    '5', '2', 'D', 'E', '6', 'D', '6', 'B', '3', '3', '2', 'D', '7', 'F', '2', '8',
    '9', 'B', 'A', '2', 'A', 'A', '6', '3', 'D', 'A', '5', '4', 'C', '4', '3', 'C',
    'B', 'D', 'C', '4', '5', '4', 'C', '0', 'D', '4', '6', '5', '6', 'A', '0', '6',
    '9', '1', '1', 'E', 'E', '7', '8', 'F', 'D', '3', '4', '8', 'C', '5', 'D', '0',
    '1', '1', 'D', 'E', '6', '3', '5', '9', '7', '9', '7', 'B', '2', 'E', '5', 'C',
    'B', '6', '8', '1', '9', '9', '5', '8', '4', '6', '6', 'A', '5', '2', 'B', '0',
    '1', '3', '7', '9', '7', 'A', '8', 'E', '3', '7', 'F', 'F', '9', '7', 'F', '5',
    'B', 'F', 'A', '6', '9', '7', 'A', '1', '6', '2', '3', '3', '6', '1', 'A', '5',
    '3', '2', '4', 'A', 'E', 'D', 'D', 'A', 'D', 'D', '1', '4', 'B', 'D', '0', '9',
    'D', 'A', '0', '6', '1', '2', 'F', '3', '0', '4', 'F', '3', '9', 'F', 'B', 'E',
    '4', 'E', 'E', 'F', 'A', '4', '8', 'B', '0', '5', '6', '7', 'E', '4', 'D', 'E',
    '3', 'B', '3', 'C', '4', 'C', '4', '2', '1', '5', '8', '4', '6', 'A', 'C', '8',
    '1', '3', '2', '1', '0', '7', '6', '3', '5', 'C', 'B', 'B', 'A', '6', '4', 'F',
    'E', 'F', '4', '4', 'E', 'F', 'F', 'E', 'F', 'D', '4', 'D', 'C', 'E', '3', 'D',
    'A', '3', '4', '2', 'D', '0', 'B', 'C', 'C', '7', '4', 'B', '2', '2', '2', '7',
    '6', '1', 'D', '6', '8', 'F', '1', 'E', '9', 'A', '7', 'C', 'F', '6', '3', 'C',
    'A', 'F', 'E', '9', 'F', '0', 'C', '5', 'B', '8', 'D', '7', '7', '1', '4', '9',
    '0', '5', '5', '5', 'A', '4', '1', 'F', 'B', '3', 'B', '3', 'B', '3', '1', '7',
    '2', 'A', '0', 'D', 'B', 'C', 'B', '7', 'E', 'A', '4', '9', '0', '0', '5', 'E',
    '3', '4', '6', '7', '2', 'E', 'F', '4', '7', '3', 'E', '6', 'E', '8', '2', '0',
    '3', 'B', 'E', '4', '5', 'D', '6', '5', '9', 'F', '5', '7', 'B', '9', '9', '8',
    '1', '0', '9', 'B', '3', '3', '4', 'D', 'E', 'C', 'C', '2', '2', '7', '6', '1',
    '9', 'F', '9', 'E', 'C', 'D', '6', '6', '0', '0', 'C', 'F', '2', '8', '6', '0',
    '6', 'F', 'F', '4', '0', 'E', '1', '7', '8', 'A', '1', '4', 'F', 'E', 'B', 'F',
    'A', '6', 'F', 'F', '4', '6', '6', '4', '8', 'B', '0', '6', '8', '3', '3', '0',
    '4', 'E', '0', '9', '9', '1', '5', '9', '8', 'E', '0', '1', 'E', '9', 'C', '6',
    '6', '2', '4', 'A', '9', '7', '7', 'D', '4', 'D', 'C', '6', '2', '2', 'B', '6',
    '1', 'F', '3', '6', '1', '4', '1', '3', 'D', '2', '2', '0', '5', 'A', '2', '1',
    '5', '3', '5', '3', '7', 'C', '2', 'A', '1', '7', 'A', 'F', '7', '9', '0', '6',
    'C', '0', '5', '7', '4', '6', '7', 'B', '4', '9', 'E', 'F', '1', '9', '5', 'D',
    'B', 'A', '2', '0', 'A', '5', 'D', 'E', '0', '1', 'E', '7', '2', 'B', 'E', '3',
    'E', '8', '8', '2', '5', '2', '3', '6', '4', '2', '3', '6', '0', 'B', '4', '0',
    'F', 'E', 'C', '8', '4', '7', '4', 'F', 'C', 'E', '5', '0', '4', 'A', '4', '5',
    'E', '3', 'C', '1', '1', '5', '1', '8', 'B', 'D', 'A', '6', '8', 'E', 'A', '7',
    '4', '2', '2', '0', '1', '2', 'C', '7', '2', '5', '6', 'A', '0', '3', '3', 'F',
    'D', '9', 'B', '5', '3', '1', '5', '0', 'B', '8', '6', '1', 'C', '8', 'B', '0',
    '3', 'A', '6', '1', '8', '1', '1', '0', '8', '8', '2', 'F', '8', '7', '9', '7',
    '9', '5', 'C', '7', 'A', '5', '8', '5', '7', 'E', 'C', 'C', '6', 'F', '3', 'E',
    'A', '3', '7', '2', '8', 'F', '2', '0', '2', '0', 'C', 'C', 'B', '9', '2', '1',
    '0', '4', '3', 'F', '4', 'C', '9', 'A', '0', '7', 'E', '0', 'A', '5', '5', '3',
    'E', 'E', 'D', 'A', '9', '7', 'B', 'E', 'C', 'F', '9', 'F', '9', '9', 'F', '8',
    'A', '6', '6', 'E', '9', 'A', 'A', '2', '4', '6', '6', '7', '7', 'B', 'C', 'B',
    '0', 'F', 'B', 'B', '9', '5', '7', '5', '8', 'F', 'C', 'A', '6', 'D', 'B', 'F',
    'B', '8', 'D', 'B', 'C', '7', '8', '1', 'F', 'A', '5', 'C', '0', 'F', 'B', 'F',
    'F', '2', 'F', '4', '5', 'A', '8', '4', '5', '2', '2', '3', '1', '8', '2', 'F',
    'D', '9', '4', '6', '5', '8', '3', 'C', '1', 'A', '6', '3', 'C', 'C', '5', '6',
    'E', 'F', 'E', 'A', 'D', '4', 'F', '6', '1', '7', '3', '2', '9', 'C', '0', 'A',
    'E', '2', 'F', 'A', 'D', 'C', 'D', '4', 'A', '0', '6', 'B', '7', '0', 'D', 'B',
    'E', '5', '9', 'C', '7', '5', '4', '7', '8', '7', 'C', 'D', '2', 'D', '8', '7',
    'B', 'B', 'D', '7', '9', '4', 'E', 'F', '4', '3', 'C', '8', 'A', '4', 'C', 'C',
    '9', '0', '3', '4', '5', '5', '6', 'B', 'D', 'D', 'C', '4', '0', 'A', 'C', 'E',
    '3', 'C', 'B', 'C', '8', '6', 'C', '7', 'A', '0', 'F', 'E', '0', 'E', '6', '0',
    'A', '4', '9', '0', 'E', '6', 'F', '9', 'D', '7', 'D', 'A', '8', '9', 'D', 'E',
    '8', '6', 'D', 'C', '5', 'D', '1', 'B', '7', '8', 'B', 'E', '0', '1', '4', '9',
    'A', '0', 'E', '5', 'B', 'A', '6', '2', '0', '1', 'D', '4', '8', '5', 'E', 'A',
    'B', 'D', 'D', 'A', 'F', '5', '6', 'E', '5', 'F', 'B', '4', '6', 'F', 'C', '4',
    '8', '4', 'B', 'D', '9', 'B', '8', 'C', '3', 'F', 'B', '8', '5', 'E', '3', 'C',
    '3', 'E', '5', 'F', '5', 'F', 'C', '3', 'B', '1', 'E', '2', 'D', 'A', '1', '5',
    '5', '0', 'F', 'E', 'F', '9', 'B', '7', '4', '7', '0', '4', '0', '6', 'E', '9',
    'B', '0', 'C', 'E', '4', '5', '6', 'A', '8', '9', '0', '0', '7', 'F', '9', '1',
    'D', '8', '3', '8', 'A', '0', '2', '2', '8', '4', '3', '3', '8', 'D', 'A', '5',
    'E', '1', '4', 'F', '5', '5', '9', 'F', '7', '9', 'F', 'E', 'C', '1', '8', '4',
    '0', '7', '3', '3', '2', '5', '5', 'C', '0', 'D', 'D', 'A', '9', '2', '9', 'B',
    'D', '7', 'D', 'C', '4', '7', 'D', '7', 'E', '9', 'C', '4', 'D', 'D', 'E', 'E',
    '5', 'E', 'B', 'E', '0', '4', '8', '7', 'F', 'A', 'F', '9', 'B', '3', 'D', 'A',
    'C', '7', '3', 'C', '5', '3', '9', 'D', '6', '1', '6', '4', 'B', '5', '3', '8',
    '4', '2', '2', 'E', 'E', 'D', '1', '1', '2', 'C', 'D', '1', 'F', '1', 'F', '8',
    '6', 'E', 'E', '1', '1', '6', '5', '6', '5', '9', 'A', '8', '4', '0', '8', 'D',
    '1', 'B', 'D', '3', '1', 'A', '9', '0', '8', '2', '4', '7', '9', '3', '7', '5',
    '0', '6', '0', 'E', 'D', '5', 'D', 'B', '7', 'F', '9', '6', '1', '1', 'C', 'B',
    '0', '4', '5', '1', '3', 'E', '7', '6', 'B', '5', '7', '6', 'F', 'D', '3', '5',
    'A', '8', '1', 'E', '7', '4', 'F', '9', 'A', '9', '9', '6', 'E', 'A', '7', '4',
    '2', 'F', 'C', '3', '7', 'E', 'E', 'E', 'E', 'A', '6', '5', '1', '5', 'A', 'E',
    '3', '1', 'B', '0', '5', '3', 'F', 'F', '4', 'E', '0', '9', 'F', 'D', '4', 'F',
    'F', 'F', '1', 'B', 'E', '6', 'F', 'B', 'C', 'A', '1', 'F', 'C', '8', 'F', '4',
    'A', 'B', '1', '2', '4', 'D', '8', '9', '4', '8', 'B', 'E', '3', 'B', '4', '9',
    '6', '6', 'B', '9', 'D', 'B', '7', '7', '2', 'A', 'E', '0', 'C', '3', '0', '1',
    '1', '5', '6', '3', 'B', '2', '2', '3', 'F', 'C', '3', 'B', 'F', '9', 'A', 'C',
    'A', '7', '6', '1', '4', '5', '4', '8', 'F', 'D', '4', '4', 'E', '0', '2', '1',
    'C', '8', 'F', '6', '5', '2', '2', '3', 'B', '0', '7', 'C', '6', '3', 'F', '3',
    'C', '8', '0', 'F', '8', '1', '0', '0', 'E', '7', '9', 'B', 'F', '2', 'D', 'B',
    '6', 'D', '7', 'E', '9', 'C', 'F', '1', 'D', '4', '7', '8', 'B', 'A', '6', '7',
    '9', '6', '8', 'A', 'D', 'B', 'C', '4', 'A', '4', 'B', 'C', '1', 'D', '3', 'C',
    'E', '8', '1', '7', '0', 'A', 'E', '7', 'C', '6', '8', 'C', 'A', '7', 'F', '7',
    '3', 'D', '4', 'A', 'B', '8', '1', 'D', '5', 'C', '6', '4', '5', 'E', '4', 'A',
    'E', '0', '6', '6', 'B', '7', 'B', 'B', '5', '6', '9', 'C', 'B', '5', 'F', 'B',
    '8', '1', '6', '9', '3', 'A', 'A', 'F', 'C', 'D', '5', '3', '7', '5', 'B', '1',
    '3', 'F', '8', '6', '0', 'A', '0', '4', 'D', 'F', '4', '3', '0', '6', '8', '4',
    '1', '1', 'A', 'B', 'D', '9', '2', '9', '1', '4', '6', '1', 'C', 'C', '3', 'E',
    'A', 'A', '8', '3', 'D', '9', 'F', 'E', 'E', '8', 'A', 'C', '4', 'A', 'F', 'E',
    'C', 'E', 'A', 'A', '7', '2', '1', '9', 'F', '0', '0', '8', '5', 'A', '9', '2',
    '3', '0', 'D', '7', '9', '8', 'F', '0', '3', '8', '2', '7', '0', 'A', '8', '1',
    'D', 'A', '7', '2', 'D', '1', '3', 'A', 'B', '1', '4', '9', '2', '3', '3', '1',
    '2', 'C', 'B', 'A', '3', 'C', 'F', '1', '5', 'C', 'B', '4', '0', '2', 'A', '3',
    '2', '5', '4', 'B', 'E', '0', 'D', '9', 'E', '8', '6', '2', '5', '1', '5', '7',
    'C', '7', 'A', '4', '3', 'D', '6', 'E', 'F', 'C', '3', 'F', '8', 'E', '2', '5',
    'C', '5', 'F', 'E', 'C', '6', '0', '4', '8', '7', '9', '0', 'B', '9', 'A', '8',
    '9', 'B', '9', '7', '2', 'E', '4', '6', '9', '6', 'B', '9', '1', '0', '9', '2',
    'D', '3', '8', '3', '6', '4', 'E', 'F', 'C', '4', '8', '3', '5', '6', '0', '7',
    '0', 'C', '6', 'B', '5', '6', '9', 'D', 'D', 'C', 'D', 'C', '2', '1', 'B', 'B',
    '1', '4', '0', '3', '4', '7', '0', '9', '4', '8', '6', 'A', '3', '5', '8', '1',
    '5', 'F', 'C', '9', '5', 'A', '6', '1', '3', 'D', '8', '0', '6', '8', '7', '4',
    'E', 'D', '5', 'E', 'B', 'A', 'F', 'A', '4', 'E', '0', 'E', '2', '5', '8', '6',
    '3', 'D', '3', 'B', 'E', 'E', 'E', '1', '9', '6', '4', '6', '2', '8', 'E', '8',
    '7', '6', '0', 'E', 'A', '9', 'D', 'F', 'E', '3', '7', '9', 'E', '3', 'D', '3',
    '1', '1', 'B', '1', 'B', '0', 'F', '6', 'D', '9', 'C', 'A', '6', '2', 'B', '5',
    'A', '2', 'E', '4', '2', 'A', 'D', 'A', 'B', 'D', 'E', '4', '7', '9', '4', '3',
    '1', 'B', 'D', 'D', '5', 'E', '3', 'A', 'A', '5', '3', '4', 'A', '4', '9', 'B',
    'C', 'D', '7', '0', '0', 'B', '1', 'D', '7', 'F', 'B', '9', 'E', 'C', '5', '6',
    'B', '0', '2', '9', '6', '5', 'F', '6', '6', '7', 'C', 'A', 'B', '4', '9', '3',
    '8', '0', '2', '8', '4', '3', '4', '3', '6', 'E', '4', 'B', '1', '1', 'A', '2',
    '5', '9', '4', '5', '2', '1', '6', 'A', '7', 'C', '7', '5', '1', 'D', '2', '2',
    '1', '9', 'A', 'A', '8', '5', '2', 'E', '5', 'C', 'F', '7', '6', 'F', '1', '4',
    'B', '4', 'A', '5', '1', '9', '6', 'D', 'D', '5', 'C', '8', '6', 'B', 'A', 'D',
    '1', '3', '7', '9', '7', '9', '1', '2', 'A', 'F', 'A', 'D', '3', '8', 'B', 'C',
    '5', 'A', '3', '6', 'F', '4', '7', 'E', 'C', '2', '8', '9', '1', '4', '7', '7',
    '9', 'D', '0', 'D', 'D', 'A', '1', '3', '0', '1', '5', '3', '7', '7', 'F', '2',
    'B', '9', 'B', 'D', '2', '3', 'C', '0', '5', '3', 'F', '4', 'F', '2', '5', '6',
    '0', '5', '3', '8', '7', 'C', 'B', '1', '8', 'A', 'A', 'A', '7', '3', '7', 'A',
    'F', '6', 'D', '7', '4', 'C', 'B', '0', 'C', 'B', '2', '7', '3', '4', '2', '5',
    'F', 'C', '8', 'E', 'A', 'F', '6', 'F', 'F', '1', '8', '4', '1', 'D', '4', 'E',
    '9', 'E', 'D', 'D', '2', '6', 'D', '2', '4', '1', '7', 'B', 'F', 'C', '6', 'E',
    'C', '3', '0', '4', '0', 'D', 'B', 'C', '6', '7', '6', 'E', 'E', 'D', 'D', '5',
    '3', '4', '5', 'E', '7', '8', 'E', 'A', '5', '9', '3', '2', '7', '3', 'B', '1',
    '1', '6', 'D', 'B', 'A', '8', 'E', '4', 'E', '0', 'D', '8', 'E', 'A', 'E', '9',
    '3', '4', '8', '3', '5', '6', '9', '7', '4', 'F', '2', 'E', 'F', '6', '8', 'A',
    'F', 'A', '3', 'B', 'F', '3', 'F', 'C', '2', '6', 'F', 'B', 'E', '3', '5', 'D',
    '6', 'B', 'D', '0', '9', '5', 'E', '9', '5', '2', 'B', '7', '0', 'D', 'D', 'E',
    'B', 'E', 'B', 'E', '0', '3', 'F', '7', 'C', '6', 'D', '1', '3', '3', '3', '4',
    '3', 'F', 'A', 'B', 'D', 'B', '3', 'E', 'F', '7', '1', '8', 'C', '1', '9', '5',
    '6', '4', '9', 'C', '5', '7', 'F', '4', 'B', '2', '5', '4', '9', 'D', '6', '3',
    '3', 'B', '1', '9', '1', '2', '0', 'E', '8', '1', '4', '9', 'C', '7', 'D', '6',
    'D', '8', '7', '6', '7', 'F', 'C', '6', 'F', '1', 'A', '3', '2', '7', '9', '1',
    '5', '7', 'F', '2', '3', '7', 'B', '9', '8', '0', 'C', '4', '0', 'C', '1', '5',
    'E', 'F', '6', '2', '7', 'D', '3', '4', '8', '7', 'F', '0', '2', 'B', '9', '1',
    'C', 'F', 'B', '0', '4', '8', '0', '6', '5', '9', '9', '3', 'D', '1', '4', '3',
    'F', '3', 'F', 'A', '3', '7', 'F', '7', '2', '4', '4', 'A', 'E', '6', '5', '8',
    '9', '9', '0', 'E', 'E', '5', 'D', '0', '9', '9', '0', 'C', '9', '8', '9', '1',
    '7', '8', 'F', '0', '3', '6', 'E', '7', '0', '4', '9', 'C', '3', '1', 'D', '4',
    '5', 'B', '8', 'D', '7', 'B', '6', '8', '3', 'C', 'B', '7', 'D', '6', '2', '3',
    'C', '5', '8', '2', '9', '4', '5', '2', '7', 'A', '2', '6', '6', 'E', '3', '4',
    '0', '3', '2', '5', '1', 'E', '8', 'A', '8', 'B', 'A', '1', '6', '4', '9', '3',
    '6', '2', '9', '9', '7', '6', '1', 'A', 'C', '2', '3', 'F', 'E', '6', 'D', '1',
    'E', '6', '7', '3', '2', '8', '2', '0', '7', 'F', '2', 'D', '4', '5', '4', '3',
    '0', '8', 'C', '2', '7', 'B', '3', 'A', 'D', '9', 'C', 'B', 'F', 'E', '3', 'E',
    '9', '5', '6', 'E', '1', '4', 'B', '9', '9', '7', '0', '0', '6', '2', '1', 'D',
    'C', '9', '3', '5', '0', 'A', 'E', 'E', '8', '3', 'F', 'C', '5', 'E', '3', '1',
    '1', 'D', 'B', '3', '1', '8', 'A', 'F', '9', '7', 'E', '2', 'D', '1', '4', '4',
    '7', '1', '1', '3', '3', '3', 'A', 'A', '3', '2', '4', 'D', 'B', '0', 'B', '5',
    'B', 'C', '6', '3', 'D', 'E', '0', '5', 'A', '9', '0', '5', 'E', 'D', '0', 'D',
    'D', '5', '1', '4', '2', 'D', '9', '2', 'F', 'E', 'D', '4', '7', '3', 'D', '8',
    '3', '1', '6', '8', '9', '4', 'B', 'A', '9', '3', '6', 'A', '9', '2', 'F', 'B',
    'C', '7', 'C', 'C', 'C', '8', 'F', '8', '9', '3', 'C', '7', '1', '6', 'D', 'E',
    '1', '6', '0', '2', '2', '4', 'B', '0', '4', '2', '9', '9', '0', 'F', '5', '2',
    '7', '0', '5', 'C', '6', 'A', '9', '1', '7', '3', '2', '5', '5', '9', 'A', '8',
    '8', '4', 'F', '4', 'C', 'F', '2', '4', '9', '8', '6', 'C', '8', '1', '6', 'D',
    '6', 'A', '5', '6', '9', '8', '0', '2', '5', '1', '3', '9', '0', 'E', 'E', '1',
    'E', 'F', '5', '2', 'D', 'C', 'B', 'F', 'F', '8', '3', '7', 'C', '3', '1', '7',
    'E', '3', 'A', '4', '6', '3', '5', '0', '4', 'C', '3', '8', '6', '4', '5', '5',
    'A', '2', 'A', '6', 'F', '0', 'A', 'B', '3', '3', 'E', '3', '5', 'C', 'C', '1',
    '3', 'D', 'D', '3', 'B', '9', '0', 'D', '8', 'A', '0', '5', '2', '0', '0', 'B',
    '1', 'A', 'E', 'C', 'C', '9', '3', 'C', '3', 'A', '0', 'A', 'B', '5', 'D', '8',
    '6', '3', '1', 'E', '4', '3', '3', 'E', 'C', '9', '2', '1', '1', '4', 'D', '0',
    '3', '7', 'D', '2', '8', 'A', '8', '5', '0', 'E', 'D', '0', '2', 'D', '7', 'D',
    'C', 'F', '1', 'E', 'B', 'C', '1', 'E', '7', '3', 'F', 'D', 'B', 'C', '5', 'C',
    '4', 'E', 'E', 'B', 'F', 'E', '8', '7', '0', '7', '5', 'F', '0', 'C', '9', '2',
    'D', '2', 'E', '3', 'E', 'A', '0', 'F', '8', '9', 'B', '1', 'D', '1', 'D', 'B',
    'F', 'C', '4', 'B', 'E', 'D', '8', 'B', '3', 'F', '4', '1', '9', '1', '2', '5',
    '7', '3', '8', '1', 'B', '2', '9', 'F', 'A', 'F', 'E', '9', '7', '9', '3', '3',
    '5', 'C', '9', '4', '3', 'D', '9', '9', '1', 'F', '3', '7', 'B', 'A', '3', '1',
    '2', 'A', '2', '5', '2', '8', 'E', '7', '2', '6', '0', '7', '1', '7', '8', 'D',
    '1', '8', 'C', '3', '3', '0', '9', '5', 'D', 'F', '1', 'C', '6', '5', '5', 'F',
    'D', '0', 'E', 'C', '3', '4', 'A', '7', '6', '6', 'D', '2', 'A', 'B', '9', 'E',
    '2', '3', '3', 'B', '0', '6', 'A', '6', 'F', '5', 'B', '4', '5', '9', '1', '5',
    '0', 'E', '2', '9', 'A', '5', '4', '4', 'F', '6', '6', '3', '9', 'E', 'D', '1',
    '9', '3', '6', '2', '3', 'B', '6', '1', '0', 'B', '0', '4', 'C', 'D', 'C', '0',
    '8', '5', '4', '3', '9', '6', '0', '1', 'F', '1', 'C', 'D', '6', '8', 'F', 'D',
    '0', '1', 'F', '1', 'A', '9', '6', 'C', '6', 'B', '4', 'D', '0', 'D', 'B', '3',
    '3', '8', '5', '5', 'E', 'D', 'C', '3', '2', 'B', '4', '7', '8', 'D', '1', '8',
    '6', '2', '2', '2', 'E', '0', '5', '0', 'B', '8', '6', '5', '1', '5', '1', '5',
    '3', 'B', '9', 'F', '0', '9', 'B', 'E', '8', '1', '0', 'C', 'C', 'C', 'C', 'B',
    'F', '3', '6', 'C', 'B', '4', '6', '3', '1', '5', '5', '7', 'B', 'F', '6', '6',
    'C', 'E', '1', '4', 'A', '3', '6', '1', '9', '8', '8', 'C', 'B', 'C', '0', 'B',
    'F', '1', '1', 'D', 'A', '9', 'C', 'B', '3', '5', 'B', 'A', '9', '6', '0', '6',
    '6', 'E', '2', 'B', '4', '7', '9', '8', 'C', '1', '7', '8', '0', 'F', 'C', '1',
    'C', '3', '2', '6', 'D', '2', 'A', '7', 'D', '2', 'B', 'E', 'F', '5', 'D', 'F',
    'E', '7', 'E', 'A', '6', '7', 'F', '7', '3', '6', '2', 'B', '4', '0', 'C', 'E',
    '3', '9', '8', '2', 'D', '6', 'A', '7', 'D', '6', '0', '4', '9', '5', '0', '9',
    '6', '3', 'F', 'D', '5', '9', 'C', '2', '4', 'E', '9', '1', '8', '5', '8', 'E',
    '4', 'A', 'E', 'B', '4', 'C', '1', '2', '1', '4', '3', '3', 'B', '6', '0', 'A',
    '2', 'A', '1', '2', '4', '9', 'D', '7', '3', '3', '7', '4', '4', 'B', '9', 'F',
    '5', '9', '6', 'C', 'A', 'B', '8', '1', '6', '2', 'A', '2', 'C', '9', '1', '0',
    '1', '9', '9', '0', '7', '1', 'B', '1', '0', '5', '8', 'D', '5', 'E', '0', '7',
    'C', 'F', '9', '8', 'B', '8', '2', '9', '1', 'A', '1', '4', '6', 'B', 'A', 'F',
    '3', 'E', '4', 'D', '4', 'E', 'F', 'A', 'F', 'E', '0', 'F', '4', '6', '2', 'A',
    'C', 'A', '9', 'B', 'B', 'C', '9', '2', 'A', 'C', 'F', '3', '3', 'A', '8', '8',
    '9', 'E', '6', '9', 'A', 'B', '7', 'A', 'F', '1', '9', 'A', 'B', '6', 'B', 'B',
    'E', '4', '9', '1', 'F', 'E', '3', '0', '2', 'A', '7', '0', 'F', 'C', '0', '7',
    '9', 'D', '1', '3', '3', '6', '6', '1', '4', '5', '0', '6', '4', '6', '1', 'A',
    'E', 'F', '5', '9', '5', 'E', '4', '4', '4', '6', 'F', 'B', '8', '5', '5', '3',
    '9', 'E', '0', 'A', '7', 'E', '0', '5', '3', '9', '5', 'A', '3', '0', '7', '3',
    '7', '7', '5', '3', 'C', '1', '2', 'D', '3', 'D', 'A', '6', 'A', 'A', '1', '1',
    '5', '0', 'D', '7', '2', 'A', '1', 'E', '3', '1', '8', '1', '8', 'E', '6', '7',
    '5', 'B', 'B', '2', 'C', '9', '6', '7', '7', 'A', '1', '9', '2', '6', '4', '2',
    '0', 'F', '0', 'B', 'C', 'B', 'C', '9', 'D', '3', '4', '8', 'B', '7', 'B', '7',
    '7', '3', 'E', '0', '2', '2', 'A', 'F', '8', '4', 'B', '5', '5', 'B', '0', 'F',
    '7', 'C', 'D', 'E', '6', 'F', '9', '3', '2', '5', 'D', '7', '1', 'D', 'E', 'B',
    '2', '9', '1', '4', '0', '7', '2', '3', '8', '8', '7', '7', 'F', '0', '7', '0',
    'A', '8', '4', 'F', '1', '0', '8', '6', '4', 'E', '6', 'A', '8', 'A', '0', 'F',
    '7', '1', '9', '6', '5', '7', '9', '1', 'D', '3', 'B', 'F', '1', '8', 'D', '4',
    '4', 'F', 'C', '0', '9', 'F', 'B', 'C', '4', 'E', 'E', 'E', 'E', 'E', '2', '7',
    '5', '9', '3', '9', '0', '0', '5', '4', '5', '3', '6', 'A', 'B', 'B', 'A', '9',
    'E', '3', 'B', 'A', '0', '9', '9', '1', '4', 'E', '1', '0', 'A', '6', '6', '8',
    'F', '5', 'D', 'C', '0', 'D', '5', '5', 'F', '3', '5', 'D', '2', 'B', 'E', '3',
    'E', '2', 'A', '3', '3', '8', 'D', '8', '5', '9', 'B', '4', '2', 'F', '0', '4',
    '7', 'A', 'E', '0', '3', '0', '4', '8', '3', '5', 'F', '9', 'C', '1', '6', 'B',
    '1', 'F', 'D', 'B', '7', '4', '8', '2', '1', 'F', 'D', '0', 'E', 'C', 'D', 'B',
    '2', 'C', '2', 'D', '8', '9', '6', '2', '2', '7', 'C', 'A', 'C', 'F', '7', '2',
    'B', '9', 'A', 'F', 'D', 'D', '4', '2', 'D', '1', 'E', '2', 'A', 'B', 'F', '3',
    'D', '5', '0', '1', 'C', '3', 'F', 'E', '9', '0', '1', '2', 'B', '9', 'B', '1',
    '0', '2', '7', '7', 'B', '6', '4', '9', 'A', '2', '5', 'F', 'A', '2', 'F', 'C',
    'E', 'D', '7', '9', '5', 'E', 'F', '3', 'D', 'A', 'F', 'D', '9', '9', '5', '3',
    'D', '5', '6', '5', '8', '9', '0', 'F', '9', 'B', '2', '3', 'B', 'E', '3', '6',
    '2', 'A', '0', 'D', 'E', '5', '8', 'F', '9', '8', 'A', '1', 'B', 'D', '0', 'A',
    '2', 'A', '8', '9', 'D', 'C', '6', 'D', '6', '7', 'E', '6', '7', 'E', '0', '7',
    '7', 'A', 'E', '7', '0', '5', 'F', '2', 'B', '1', '0', '5', '5', '9', '8', '7',
    '4', '6', '1', '3', '2', '6', '0', '4', 'B', '2', 'C', '6', '2', '7', '5', '7',
    '9', 'C', '8', '5', '9', 'C', 'B', 'D', '2', '5', 'A', '3', '2', 'B', 'E', 'C',
    'B', 'E', '8', '6', 'B', 'E', 'D', 'B', '0', '6', 'A', 'F', '8', 'C', '2', '3',
    '2', '4', '9', 'C', 'C', 'F', 'A', '4', '6', 'F', '6', '4', 'D', '6', '8', '9',
    '3', 'E', 'B', 'D', '7', '2', 'A', '5', '8', '6', '5', 'B', '5', 'F', 'B', 'C',
    '8', 'B', '2', '0', '5', 'C', 'A', 'D', 'C', '6', '2', '9', 'E', 'F', 'F', 'F',
    '6', '8', '5', 'F', '1', 'B', '5', 'A', '9', 'A', 'E', '4', '3', '6', 'F', '7',
    '1', '1', '0', '0', 'F', '8', '1', '1', '6', 'C', '4', '4', '2', '0', '2', '2',
    '3', 'B', 'A', '2', 'B', 'A', '4', '4', 'D', 'A', '9', '8', '4', 'D', 'D', '6',
    'B', '2', '7', '3', 'A', '8', '3', 'B', 'C', 'D', '7', '5', 'A', 'A', '3', 'A',
    'A', '0', '3', '1', '3', 'C', '3', '8', 'C', '8', 'A', 'B', '2', 'B', '9', '1',
    '6', '0', 'D', '8', 'F', '2', 'B', '8', '8', '1', '1', 'A', 'E', '7', 'A', '7',
    '5', '7', '2', '8', '0', '5', '0', 'E', '5', '1', 'F', 'A', 'B', 'C', '3', '3',
    '8', '5', '3', '8', '7', 'F', 'E', 'C', '1', 'C', 'F', '8', '6', '4', '7', '5',
    '5', '6', '2', 'A', '7', 'D', 'F', '8', '3', 'E', '1', '8', '9', '3', 'A', 'A',
    'F', '9', '5', '4', 'A', '0', '6', '1', '9', '9', '3', '2', 'C', 'F', 'E', '9',
    '4', 'C', '2', '7', '0', '1', '1', '4', 'C', '4', '1', '7', 'A', '4', 'B', '7',
    'E', 'B', '1', 'F', '0', '5', '9', '7', '4', '3', 'C', '9', '5', '8', '2', '9',
    'E', '2', '0', '7', '3', '1', 'D', 'E', 'F', 'F', '0', '9', '3', '3', '8', 'D',
    '7', 'C', '9', '9', 'D', 'C', 'F', 'F', '4', '7', 'F', '4', 'F', 'B', '3', '7',
    '5', '6', '2', '0', '5', '8', '2', '8', 'B', 'B', 'A', '8', 'C', '0', 'A', 'A',
    'A', '8', 'A', '5', '6', '6', '9', 'B', '0', '9', '6', '8', '0', '7', 'E', 'A',
    '4', '8', 'A', '9', 'B', '4', '9', 'D', 'C', 'C', 'C', '8', '6', '8', 'B', '9',
    'B', '8', '4', '0', '3', '6', 'C', 'F', '7', 'E', '4', 'C', 'E', 'E', 'F', 'C',
    'A', '5', '8', '1', '4', '7', 'E', 'D', 'A', '7', '7', 'C', 'A', '5', '1', 'C',
    '5', '2', '3', '4', '1', '6', 'E', 'B', '2', '9', '8', '9', '7', 'F', '4', '3',
    'E', '0', '5', 'A', '6', 'C', 'A', '2', 'F', 'F', '9', '6', 'D', '4', '4', 'F',
    '2', '5', '5', '4', '5', '6', '1', 'D', '8', 'C', '9', '9', 'E', '0', 'E', '9',
    'C', 'C', '6', 'E', 'F', '9', '6', '2', '0', 'E', 'C', '0', '1', 'F', 'D', '3',
    'C', 'D', 'A', '2', '2', 'A', 'F', '4', '6', '9', 'E', '0', '0', '2', 'E', '4',
    'C', 'E', '4', '4', 'A', '5', 'C', 'C', '2', '5', 'B', '7', 'C', '8', '7', 'A',
    '4', '0', '2', '1', '0', '1', '0', '7', 'C', '7', '5', '5', '8', '0', 'A', 'D',
    'A', '9', '1', '0', 'A', '2', '4', 'F', 'B', '3', '9', 'E', '3', 'D', '4', '9',
    'F', '1', '2', 'A', 'A', '5', '7', '7', '1', 'D', '6', '9', 'E', '4', '3', '2',
    '5', '8', '3', 'F', '6', 'D', 'F', '1', 'E', '6', 'D', 'B', '1', '2', '3', '6',
    'F', '4', 'D', '5', '1', 'B', 'E', '3', '9', '2', 'A', '4', '2', '6', '7', '5',
    'E', '1', '7', '1', '9', '4', '6', 'E', 'A', '7', 'E', '4', 'D', 'B', '4', '3',
    'B', 'E', '4', '1', '1', '7', '3', 'A', '6', 'C', '6', '8', '1', '8', '2', '9',
    '4', '5', '9', 'B', 'D', '5', '0', 'E', '2', 'A', '5', 'B', '7', '9', 'B', '5',
    '0', 'F', '9', 'C', '1', '7', '8', '5', '6', 'F', '9', 'F', '2', 'B', '7', 'B',
    '9', '5', 'F', '6', '6', '4', '4', 'C', '8', '3', '6', 'C', '7', '8', '2', 'D',
    '4', '8', '3', '6', '5', '5', '5', '6', '9', '5', '7', '8', '5', '6', '2', '4',
    'F', '2', '3', '6', '2', 'C', '0', 'D', 'D', '9', '0', '4', '8', '1', 'D', '4',
    'F', 'B', '2', 'C', 'A', '6', '9', '5', 'F', '2', '5', 'D', '6', '8', '9', '2',
    '1', '2', 'E', 'E', '9', 'D', 'B', '9', '3', '7', 'D', '7', 'E', '6', '0', 'D',
    '3', 'F', 'A', '5', 'D', '3', '6', 'E', '5', '9', '0', '8', 'D', '2', 'D', 'D',
    '0', 'F', '0', 'C', '5', '7', '2', 'C', '4', '3', 'F', '2', '2', '3', '9', '9',
    '3', 'E', 'B', '0', 'A', '4', 'C', 'E', '8', '1', 'E', '7', '1', '6', '3', '4',
    'F', '5', 'E', '7', '5', 'A', 'F', '6', '9', '1', '1', '5', '3', '2', '7', '5',
    '8', 'E', 'D', '7', 'E', 'F', '9', '8', '1', '6', 'B', 'D', '4', 'A', 'B', 'F',
    '4', '8', 'D', 'C', '7', 'F', 'F', '6', '7', '2', '8', 'E', 'F', 'C', '0', '6',
    '0', 'B', '2', '8', '5', 'C', 'E', '2', '2', 'C', '1', '1', '5', 'F', 'A', '7',
    '4', '6', 'B', '7', 'B', '6', 'F', '6', '7', '1', 'C', '7', '3', 'D', 'B', '2',
    'B', 'C', '7', 'E', '3', '2', '4', '7', '8', '9', 'B', '9', '0', 'F', '5', 'E',
    '4', '7', '7', 'B', '7', '4', '7', 'F', 'B', '9', '4', '4', 'A', '2', 'C', '3',
    '2', 'B', '8', 'A', '3', '9', '3', '1', '9', '8', 'D', 'A', '2', 'B', '7', 'F',
    '8', 'D', '4', 'D', 'F', 'E', 'C', '0', '8', '6', '6', '3', '7', 'F', 'E', 'E',
    '9', '5', 'C', 'C', 'F', '9', '7', 'B', '0', '0', '7', '2', '0', '3', 'A', '1',
    '5', '9', 'A', '5', '1', '4', '8', 'E', '2', '2', 'A', '0', '6', '2', '1', '0',
    '4', 'F', 'D', '9', 'A', '6', '4', '4', '2', '3', 'B', 'A', 'D', '5', '7', '4',
    '8', 'D', '5', 'A', '3', 'C', 'D', '2', '9', '2', 'D', 'F', 'C', '7', '7', 'D',
    'D', 'E', '0', '6', '7', '6', '7', '1', '2', '5', '0', '2', 'F', 'E', 'E', '6',
    '0', '1', 'B', 'E', 'A', '1', 'E', 'C', '8', '2', 'A', 'D', '2', '1', 'F', '5',
    'B', '7', '8', '6', '6', 'A', 'A', '9', '1', '7', '1', '9', '0', '6', '8', '4',
    '0', 'A', '5', '1', 'A', 'E', '7', 'A', '1', 'B', 'F', 'A', '2', 'C', 'F', 'F',
    'F', 'B', '2', '3', 'A', 'E', 'C', 'C', '7', 'C', 'B', '5', '1', '7', '5', '4',
    '8', 'E', '1', '1', '7', 'E', 'A', 'D', 'A', '3', '6', '9', 'C', '8', 'E', '0',
    '0', '5', '0', 'B', '3', '4', 'A', 'D', '5', 'C', 'E', '9', '5', '6', 'F', 'C',
    '1', 'D', '1', 'D', 'A', '0', '2', 'A', '2', '6', '2', 'D', 'D', '5', '2', 'C',
    'D', '5', '4', '1', '9', '4', '1', '2', '9', '5', 'C', '2', 'D', '4', '9', 'C',
    '7', 'B', 'D', '9', 'E', '5', '8', 'D', '6', 'A', 'E', '0', '6', '8', 'A', 'B',
    'E', 'F', 'B', 'B', 'F', 'D', 'F', '3', 'E', 'F', '5', '0', 'D', '6', '9', '7',
    'D', '6', 'F', '3', '2', '5', '9', 'C', 'E', '6', '6', '8', '4', 'E', '1', 'E',
    'D', 'C', '9', '6', '1', '0', 'C', 'F', '6', 'F', '3', 'D', 'F', '9', 'A', 'D',
    '3', '0', '5', 'F', 'D', '4', 'C', '2', 'F', '4', 'A', 'E', '6', 'F', '9', '7',
    '2', '5', '6', 'B', '9', 'D', 'A', '8', '7', 'B', '5', '2', '7', '8', 'C', 'F',
    'F', '2', '0', 'B', '5', 'F', 'C', '9', '1', 'F', 'F', 'E', '2', '0', '2', 'F',
    'F', '4', '9', '0', 'B', '9', '9', 'C', '2', 'B', 'C', '2', '4', 'C', 'F', 'D',
    'D', '3', '2', 'F', '1', 'C', 'B', 'B', '4', 'D', 'F', '0', '0', '6', 'C', '5',
    '4', 'D', 'D', 'B', '1', '2', '6', 'E', '5', '4', '0', '0', 'C', '9', '1', '1',
    '6', 'A', 'B', '2', '4', '6', '7', '2', '2', 'E', 'F', '4', '6', '3', 'F', 'F',
    '1', '4', 'B', '1', 'D', '4', 'C', '9', 'E', '6', 'C', 'A', 'A', '7', '3', 'D',
    'C', '0', 'D', 'E', '6', '9', '9', '5', '8', 'E', '4', '0', '3', '1', 'B', 'B',
    '7', '0', 'B', '5', 'F', 'E', 'B', 'E', '3', 'C', 'F', '0', 'B', '2', '0', '2',
    'B', '5', '3', 'C', 'E', '3', '1', '4', '7', 'F', 'D', '9', 'F', 'B', 'A', '8',
    '3', 'A', '9', '0', 'B', '0', '7', '1', '0', '9', '2', 'B', '7', '8', 'F', '3',
    'F', '6', '0', '6', '3', '4', 'B', '1', '8', 'F', '4', 'B', 'A', '1', 'C', '3',
    'F', 'F', 'F', '4', 'F', '9', 'F', '5', '3', '3', '0', '7', 'B', '7', '1', '6',
    '1', 'B', '3', '1', 'F', '3', '0', 'E', 'E', '0', 'A', '3', 'C', 'F', '1', 'B',
    'E', '9', 'E', '6', '0', 'A', '8', '9', '6', '0', 'F', 'E', '4', 'D', '2', 'E',
    '1', 'F', '2', '4', 'A', '0', '9', 'F', '0', '7', '1', 'C', 'A', '3', '4', '8',
    'A', 'B', '1', '5', '5', '7', '9', 'C', 'A', 'F', '5', 'D', 'B', 'D', '7', '6',
    'E', 'E', '6', '1', '4', '3', 'D', 'B', 'C', '5', '3', '8', '3', '1', 'B', 'A',
    '9', '9', '5', '1', '3', 'D', '9', '8', 'A', '3', '7', '6', 'B', '9', '1', '6',
    '8', 'F', 'C', '9', '3', '3', 'B', 'C', '0', '0', '5', '0', '6', 'C', '2', 'C',
    '1', '3', 'A', '1', '0', '0', '8', 'F', '7', '8', '8', 'D', 'A', '4', '4', '8',
    'E', '8', '3', '6', 'D', 'B', 'B', 'E', '3', '3', '0', '3', '4', 'C', '4', '1',
    '8', '4', '3', '1', 'C', 'F', '7', 'E', '4', 'E', 'D', 'B', '0', '3', '5', '7',
    '8', 'E', 'D', '7', 'E', '3', 'D', 'D', 'A', '3', 'D', '2', 'A', '5', 'F', '3',
    '3', '0', 'D', '0', '7', '2', '9', '2', '2', 'F', '0', '5', '9', 'F', 'F', 'D',
    'B', '2', '5', 'F', 'C', '2', '1', '6', '1', 'B', '9', 'F', '4', 'F', '8', 'E',
    '6', '9', '2', '0', '8', 'E', 'F', '6', '0', '4', '3', '5', 'A', 'B', 'F', 'C',
    '3', '5', '6', '2', 'F', 'A', 'B', 'C', 'F', '4', '2', '4', '8', '7', '4', 'A',
    'F', '8', 'A', '5', '5', '6', '9', '0', '5', '7', 'E', '7', '8', '2', '3', '2',
    '9', 'A', 'E', '2', 'D', 'C', 'F', 'F', '1', '8', 'A', '3', 'D', 'D', '4', 'D',
    '4', '8', '2', 'D', '4', '6', '7', 'D', '6', '5', '3', '3', 'B', '3', '1', 'A',
    'B', '7', 'F', '4', 'F', 'F', '1', '3', 'E', '4', '0', '2', '0', 'D', '9', 'A',
    '7', 'E', 'E', 'B', '2', '9', '1', '6', '6', 'A', 'F', '2', '9', 'F', 'A', 'A',
    '8', '6', '5', '9', 'D', '8', '0', 'C', '4', 'B', 'E', '7', '3', 'B', 'F', '4',
    'D', 'C', 'B', 'C', '9', '4', '2', '0', '6', 'A', 'E', '7', 'C', '8', 'D', '8',
    'E', 'A', '3', 'D', '2', 'F', '7', '5', '3', '0', 'E', '9', '8', 'A', 'B', '3',
    '7', '4', '2', 'B', '4', 'F', '4', '0', '5', 'E', '2', '4', '4', 'E', '5', '4',
    '6', '8', '8', '8', '9', '6', '9', 'F', '3', '7', '9', '7', '8', '7', 'B', '7',
    'C', '0', '7', '9', 'B', '3', '9', '6', '3', 'A', '6', '7', '3', '9', '6', 'E',
    'F', '9', '1', 'D', '0', 'A', '6', '0', 'F', '4', '2', '7', '5', '2', '8', 'D',
    'A', '1', '5', '5', 'D', '3', 'B', '3', '9', '3', '1', '4', '2', '0', '7', 'F',
    '6', 'F', 'A', '6', '5', '1', '5', '9', 'B', '2', '0', '5', 'B', 'D', '8', '3',
    '0', '4', 'A', '0', '7', 'E', 'C', '8', '2', '0', '2', 'F', 'F', '4', '4', '1',
    '8', 'D', '7', '5', '5', 'A', 'C', '0', '3', '2', 'F', '0', '0', 'C', '9', 'B',
    'C', '2', 'A', '5', '7', 'D', '6', '6', '0', '3', 'E', 'A', '8', 'E', '2', '7',
    'E', 'C', '5', 'E', 'F', '0', '8', '7', '4', '8', '2', '5', '6', '8', 'B', '1',
    '7', '7', '6', 'E', '6', '9', '6', 'D', '8', '5', 'F', '7', '3', '8', '0', '4',
    '1', '8', 'F', '7', '8', '3', '5', 'B', '5', 'A', '6', '1', '7', 'A', 'E', 'A',
    'A', '0', '3', '1', 'D', '9', '5', '6', '1', 'D', '9', '5', '4', '6', '7', '7',
    'F', 'C', '5', '9', 'F', 'B', '6', '7', 'F', 'C', 'D', 'C', 'E', '5', '9', '7',
    '4', '6', '4', '6', 'E', '5', '3', '4', 'F', '7', 'D', 'B', '1', '2', '3', 'B',
    'F', 'F', '1', '1', 'E', '6', 'A', '9', '2', 'E', 'B', '5', 'F', '2', 'D', 'B',
    'B', 'F', '7', '2', '4', '4', '7', '8', 'F', '9', '3', '1', '5', 'C', '1', '4',
    'C', '0', '2', '1', 'C', '6', 'F', '7', '2', '7', '9', 'D', '7', 'D', '3', 'D',
    '5', '4', '6', '3', '7', '2', 'C', '3', 'B', '7', '9', 'B', '4', '6', '7', '7',
    '0', '4', 'E', '7', '2', 'B', 'B', 'B', 'B', 'E', 'A', '6', '5', '3', '6', '7',
    'E', '0', '2', '8', '8', 'D', 'A', '0', '1', '2', '3', '5', '7', '0', 'B', 'D',
    'D', 'A', '9', '1', '5', 'E', 'C', 'D', 'F', '7', '3', '7', '0', '9', '8', 'A',
    '6', '2', '9', '2', 'C', '1', 'F', 'C', '4', '9', '9', 'C', '1', '7', 'D', '4',
    'F', '4', '9', 'E', 'C', '5', 'F', '0', '1', 'D', '4', '0', '3', 'D', 'B', '8',
    '9', 'A', '8', '7', '5', '0', '3', 'C', '9', 'B', '5', 'F', '2', 'A', 'E', '6',
    'C', '7', '4', 'E', 'D', '4', 'E', '4', '4', '9', 'A', '9', '6', '8', '1', 'E',
    '9', '0', '5', '4', 'F', '0', '7', '5', '2', '6', '6', '2', 'D', 'E', 'F', '9',
    'D', '7', '8', '5', '3', 'E', '1', 'B', 'C', '1', '0', 'C', 'C', '8', 'E', '1',
    '6', 'B', '6', '6', '5', 'C', '7', 'B', '0', '4', 'A', '2', '0', '6', '2', 'B',
    'A', '6', '8', 'F', 'B', '0', 'F', 'E', '2', 'C', 'C', '9', '6', '9', '5', '5',
    '7', '4', '8', '2', '0', '5', 'E', '6', '8', 'B', '4', 'C', '1', '9', '7', '5',
    '4', 'B', '5', '8', 'C', '6', '7', '7', '3', 'A', 'F', 'A', 'C', '7', 'E', '9',
    '6', '8', 'A', '8', '7', '8', '9', 'F', '3', '3', 'A', 'A', '9', 'E', '4', 'C',
    'F', 'A', '6', '5', '4', 'F', '9', 'E', '8', '5', 'D', 'B', 'A', '3', '0', 'C',
    'F', 'B', '8', '5', '4', 'E', '6', 'C', 'E', 'B', '3', 'C', '1', 'A', '0', '4',
    'C', '7', '7', 'E', 'C', '7', '3', '8', '4', '1', 'A', '7', 'E', 'B', '6', '1',
    '7', '9', '3', '8', '3', '4', '0', '1', 'E', '7', 'A', 'D', '5', 'A', 'B', 'F',
    'C', '6', '1', '6', '5', '0', 'A', '7', '8', 'E', 'E', '3', '6', 'B', 'E', '7',
    '6', '4', 'A', '8', '5', '4', '3', '5', 'B', '3', 'D', '6', 'E', '3', '6', '9',
    '1', 'D', '4', '3', 'E', '6', 'A', '4', '2', 'B', 'D', '9', '1', '7', 'E', '6',
    '7', '7', '3', '4', '3', 'F', '2', 'E', 'D', '2', '1', 'B', '5', 'D', 'E', '3',
    'F', 'F', '1', '8', '2', 'F', '6', '8', '7', '0', '8', 'E', '4', 'E', 'E', 'C',
    '6', 'C', 'F', '6', '5', '3', 'D', 'C', '7', '9', 'E', 'D', '4', '7', '6', '9',
    'C', '7', 'D', '5', '2', '4', '5', '7', '8', '0', '3', '6', 'A', '8', '4', 'E',
    '5', '0', 'A', '4', 'C', 'E', '4', '3', '1', '5', 'A', 'F', 'F', 'C', 'E', '7',
    '1', '2', '0', '5', 'A', '3', 'F', 'B', 'D', 'B', 'A', '9', '6', 'B', 'A', '5',
    '8', '4', '0', '6', 'B', '4', '6', 'A', '0', '5', '3', 'B', 'D', 'D', '1', 'E',
    '2', '3', '2', 'E', 'F', '4', 'B', 'B', '8', '7', 'C', '6', '2', '0', '5', 'C',
    '9', '0', '5', 'B', 'A', 'B', '0', '3', '6', '0', '1', '2', '9', '0', '2', '1',
    '1', '2', '6', '7', '1', 'D', '8', '0', '5', '3', 'B', '1', '6', 'E', '3', 'B',
    'D', '4', 'B', '3', '6', 'F', '4', '7', '0', '5', '7', 'E', '2', '2', 'E', 'C',
    '5', 'B', '7', '8', 'E', 'E', 'C', '2', '5', 'C', 'D', 'E', '8', '3', '6', '1',
    '0', 'A', 'D', '1', '7', '6', 'C', '0', 'E', '1', '9', '6', '2', 'B', 'D', '4',
    '8', 'B', 'C', '3', '2', 'A', '0', '0', 'B', '9', '8', '2', '1', 'C', '1', 'C',
    '4', '4', 'E', 'F', 'B', '6', '6', '6', '7', '8', '2', 'A', '2', 'B', '9', '4',
    '7', 'D', '5', '7', '5', '4', '2', '8', 'F', '6', '0', '8', '4', '9', '9', 'A',
    '8', 'C', '4', 'D', 'B', 'A', '4', 'A', '8', '5', 'B', '3', '5', '2', 'A', 'C',
    'A', 'B', 'A', 'C', '8', '3', 'E', 'B', '8', '8', 'F', '9', '3', '4', 'B', '6',
    '3', '8', 'E', '4', '3', 'F', '6', '9', 'E', 'C', '5', '7', '4', 'F', 'B', '6',
    '0', '6', 'D', '7', 'D', '7', '0', '5', '4', 'D', '0', '4', '3', '9', '5', 'C',
    '3', '4', 'C', '4', '1', '9', '5', '0', 'F', 'A', 'E', '0', '8', '6', 'C', '4',
    '4', '3', '3', '7', '4', '9', '7', 'D', '4', 'B', 'E', '5', 'E', '0', 'F', '5',
    '9', '6', 'D', '0', 'B', '1', '0', 'B', 'B', '0', '8', '7', '5', '9', 'B', 'B',
    'D', '7', '1', '3', 'C', '4', 'C', 'C', '4', '7', '0', '4', 'C', '0', '7', '8',
    '3', '8', '3', '2', '2', '7', '4', 'C', '4', 'E', 'B', '1', '0', '3', '6', 'F',
    'B', '0', '2', '1', '3', '2', 'C', 'D', '5', 'A', '5', '9', '0', '0', '8', '5',
    'A', '1', 'B', 'C', '0', '8', 'A', 'E', '5', 'E', 'A', 'B', 'C', 'C', 'C', 'F',
    'D', 'E', '7', 'B', 'D', 'B', '4', 'A', '5', '2', '0', '7', 'D', '8', '0', 'E',
    '7', '8', 'B', 'F', 'F', '0', 'F', '8', 'D', '8', '9', 'A', '6', '8', 'B', '9',
    'E', '9', 'D', '4', 'B', 'F', 'A', 'A', '6', 'D', 'A', '3', '7', '8', 'F', '0',
    '7', '8', '3', '2', 'C', '1', '7', '0', 'D', '2', '3', 'E', '4', '6', 'E', '8',
    '1', '9', '4', '8', '9', '9', 'A', 'F', '5', '1', 'C', 'C', '2', 'D', '9', 'F',
    'F', 'B', '5', 'A', '6', '1', 'A', '0', 'E', '9', '7', '2', '7', '0', '8', 'B',
    '9', 'A', '8', 'E', '1', '8', '0', '5', 'F', '6', '5', 'B', '8', '2', '4', 'F',
    '1', '6', '0', '8', 'C', '4', 'A', '0', 'B', '9', '2', 'E', '6', '0', 'E', 'E',
    '4', '6', 'D', '5', '5', '0', '3', 'C', '3', 'C', 'E', 'C', '3', '5', 'E', '6',
    '5', '9', '7', '6', 'F', 'E', '8', '1', 'D', 'B', 'A', 'F', '3', 'D', '4', '1',
    '3', '1', 'A', 'E', 'D', '3', '4', '5', '7', '4', '4', '6', '3', '2', '7', 'B',
    'D', 'C', '7', '2', '2', 'D', '0', '9', '0', '1', '2', 'A', '4', 'E', '6', '8',
    'C', 'B', '5', 'D', 'C', '3', '1', 'D', '2', 'F', 'F', 'B', 'E', 'F', '2', 'F',
    '5', 'E', '5', '9', '0', 'E', 'B', 'A', '0', '7', 'D', '1', 'D', '0', '3', '5',
    '6', 'A', 'C', 'F', '1', '2', '9', '4', '3', 'C', 'A', '9', '6', '4', '3', 'C',
    '4', '3', 'B', 'E', '3', '6', '2', '4', '8', 'F', '0', '2', '6', 'C', '9', '7',
    '3', '3', '3', '3', '6', 'A', 'D', 'B', '9', 'A', '4', '9', '4', 'C', 'C', '0',
    '8', '3', '0', '0', 'F', '4', 'D', 'F', 'F', '6', '2', '0', 'A', '5', '9', '4',
    '0', '3', 'C', '5', '0', 'F', '3', '9', 'C', 'B', 'E', 'E', '5', '3', '9', 'C',
    'D', '3', 'B', 'C', '7', 'F', '1', '6', '8', '3', 'E', 'E', '5', 'C', 'E', '6',
    'C', '7', '4', '0', 'B', '1', 'E', '8', 'B', 'E', 'F', 'B', '7', '2', '9', '8',
    '1', 'E', '0', '7', 'C', 'B', '1', '8', '3', 'D', '1', '5', '6', 'E', 'D', '9',
    '7', '0', '5', 'F', '6', '3', '9', '4', '2', '1', 'C', 'B', '5', '4', 'D', '8',
    'D', '4', '1', 'C', 'B', '9', '7', 'F', '9', 'B', 'A', '3', '9', 'E', '9', 'B',
    '2', 'F', '2', 'C', 'B', '4', '8', '1', 'F', '1', '4', '9', 'D', '0', '5', '0',
    '7', 'B', 'A', '9', '1', 'F', '4', '4', '0', 'A', '2', '0', '7', '9', '1', '5',
    'D', '4', '2', 'A', '2', '9', '6', '1', '6', '8', 'A', '2', 'F', '9', '7', '6',
    'E', '4', '4', 'E', '4', '9', 'C', 'A', 'C', '2', 'C', '3', '7', '7', '9', '4',
    '5', 'B', '6', 'B', '7', 'A', '4', '7', '0', 'D', '7', '8', '3', '5', '4', '9',
    '0', '5', '3', 'E', '7', '6', 'E', 'D', 'C', 'C', '8', '9', '1', 'C', '3', '5',
    '0', 'F', '8', '5', 'E', 'B', '8', 'D', '7', 'B', '5', 'D', '8', '0', '7', '7',
    'A', '7', 'D', '5', 'A', '0', 'B', '9', '7', 'A', 'C', '3', 'C', 'E', 'D', 'D',
    'F', '3', 'D', 'A', '3', '6', '8', '7', 'B', '4', 'F', '8', 'C', 'B', '1', 'C',
    '4', '9', 'E', 'A', '9', 'E', '3', 'E', 'E', '3', 'D', '0', 'B', '6', '8', '8',
    '5', '9', '3', 'D', '2', '4', 'A', 'C', '6', 'B', '0', '4', '5', '8', '0', 'C',
    '8', 'D', 'E', '3', '4', 'D', '1', '7', 'B', '5', 'C', 'A', 'E', 'F', '2', '5',
    'D', '7', '4', 'C', '6', '6', '6', '2', '2', '5', 'F', 'C', '9', '4', '6', 'C',
    '1', '0', 'B', 'D', 'A', 'E', '1', 'A', '5', '2', '1', '0', 'D', '9', 'C', '4',
    '5', '4', '3', 'D', 'A', 'D', '4', 'A', '8', 'A', '6', '7', '7', 'E', 'E', '2',
    '0', '5', 'C', '9', '4', '6', '2', '2', 'E', '6', '0', 'A', 'C', 'E', 'F', 'D',
    '0', 'D', 'E', 'C', 'D', '9', '4', 'C', '7', 'E', 'F', 'C', '4', '1', '9', '4',
    'D', '6', '5', '3', '6', '8', 'D', 'D', 'F', 'E', '8', '0', '1', '2', 'B', 'E',
    '1', 'E', '1', 'E', '3', '2', 'C', 'F', '3', '9', '3', 'C', 'F', 'E', '0', '4',
    '3', 'F', 'B', '0', '8', '3', '2', '3', 'F', 'A', '2', '1', 'D', 'D', '6', '6',
    '8', '8', '1', '7', '3', 'B', '8', 'B', '8', '1', 'D', '4', '4', 'A', 'D', '4',
    'D', '9', '6', 'C', '5', 'C', 'D', '2', '6', 'D', 'D', '3', '0', '2', 'A', '6',
    'E', '9', 'F', '1', '1', '7', '0', '4', '4', '3', 'D', '0', '4', '1', '2', '1',
    '5', 'E', '4', '4', '7', 'C', 'C', 'D', 'E', '6', '9', 'F', '3', '9', 'A', 'F',
    'F', 'B', '3', '5', 'B', '2', '2', '7', 'A', 'C', 'B', '2', '8', '4', '6', '9',
    'B', 'C', 'B', '1', '8', '2', '4', '0', '0', 'B', 'B', '3', '4', '0', '1', 'D',
    '3', '6', '2', 'E', '2', '1', 'E', '4', 'D', '8', '0', '5', '8', 'B', 'A', 'F',
    '4', '4', 'D', 'E', 'D', 'D', '1', '2', '7', 'B', 'E', '7', 'E', '8', '5', 'E',
    '2', 'E', '6', '6', 'B', '2', '5', '4', 'F', '3', 'A', '1', 'F', 'A', 'F', 'F',
    'D', 'F', '9', 'A', '8', '9', '1', '8', '5', 'E', 'D', '8', 'A', '5', 'B', '5',
    'A', '8', 'D', 'D', '6', '0', 'A', '7', 'D', '6', '2', 'F', '1', 'F', 'B', '7',
    'E', '0', 'B', '6', '2', 'A', 'F', 'D', '6', '5', '9', '1', 'C', '3', 'C', 'B',
    '7', 'E', '1', 'E', '6', 'B', 'C', 'F', '7', 'A', '0', '7', 'D', '0', '0', '8',
    'A', '9', '4', 'E', 'E', '2', '4', 'E', '4', '5', '4', '8', '4', 'C', '0', '6',
    '7', '8', '6', 'A', 'D', 'D', '4', 'A', '2', 'A', '8', '0', 'C', 'A', '9', 'E',
    '7', '3', '1', '0', 'C', '4', 'A', '1', '0', '9', 'A', '3', '8', '0', '3', '6',
    'F', 'B', '6', '7', '5', 'C', 'D', '7', '2', '1', '0', '2', 'A', 'D', '5', '8',
    '1', 'C', 'B', '6', '9', '6', '8', 'A', '5', '3', 'C', 'E', 'A', '8', 'A', '5',
    '9', 'A', '7', '1', 'F', 'F', 'B', 'F', '4', '9', '5', '2', '8', '8', 'A', 'C',
    '9', '2', '8', 'F', '6', 'C', '4', 'F', '1', 'B', '2', '2', '3', '9', '1', '9',
    '0', 'C', 'B', '7', '6', '9', '9', 'D', 'A', '2', 'D', '9', 'D', '5', '0', 'F',
    '9', 'B', 'D', '2', 'B', 'B', '1', '5', '7', '0', '5', '7', 'A', '7', '3', '1',
    '5', '6', '9', '2', 'D', 'E', 'B', 'A', '2', 'C', '4', '8', 'E', '1', '4', 'E',
    '2', '3', '4', 'F', '0', '5', 'D', 'D', '9', '2', '2', '8', '8', '2', 'B', 'C',
    '4', '4', '0', 'A', '8', 'F', '5', '0', '2', '9', 'D', '3', '6', '4', '9', '1',
    'B', '8', 'E', '7', '9', '0', '2', 'E', '6', '4', 'D', '9', 'D', 'A', 'B', '6',
    '8', 'F', '0', '3', '4', 'F', 'B', 'A', '0', '3', '6', 'F', '0', 'A', '6', 'E',
    '6', 'F', '7', 'F', '7', '8', 'C', '9', '5', '6', '8', 'C', '1', '4', '5', '1',
    'C', 'A', 'D', '0', '0', '6', 'E', 'D', 'D', 'A', 'B', 'A', '2', 'A', 'C', 'D',
    '0', 'C', '8', 'F', '2', 'E', '7', '3', '6', 'C', 'A', 'E', '9', '5', '5', 'A',
    '6', '5', '7', '7', '6', 'A', '1', 'E', 'A', 'D', 'B', '6', '5', 'C', '6', '1',
    '6', '0', '6', 'A', 'B', '1', '9', '2', '0', '6', '4', 'D', 'B', '0', '7', '8',
    '3', '1', '6', '8', 'C', 'C', 'F', '1', 'E', '7', 'B', '8', 'C', '5', '5', 'B',
    'C', 'C', '0', 'A', '6', 'E', 'D', '1', 'F', '7', 'F', '3', 'B', '1', '7', '4',
    '5', '1', '9', '4', 'D', 'E', 'D', '3', 'B', '4', '2', '0', 'C', 'A', '7', '1',
    '0', 'C', '2', 'C', 'D', 'B', 'C', 'C', '3', '0', 'D', '7', 'E', '1', '2', 'F',
    'A', '3', '2', 'F', 'D', '2', 'B', '7', 'B', '3', '2', '5', '4', '9', '9', '3',
    '9', '3', 'E', '1', 'C', '7', '3', '8', '7', 'C', '2', '1', '7', 'A', '4', 'B',
    '8', '1', 'C', '4', '3', 'E', 'D', '3', 'F', '2', 'C', 'B', '7', 'F', '0', '2',
    '8', 'C', 'F', '8', '5', '0', '0', '3', '5', 'E', '0', 'F', '3', 'C', '9', 'A',
    'C', '1', '1', '8', 'B', '2', 'B', '7', '0', '1', '6', '9', '7', '0', 'C', 'B',
    '6', '0', 'F', 'B', '8', '9', 'B', 'A', '9', '2', '8', 'F', '1', '8', 'B', '8',
    'D', 'E', '6', '7', 'A', 'E', 'F', '1', 'B', '4', '7', '9', 'B', '8', 'E', '4',
    '4', '1', '3', 'B', 'B', 'B', '3', '0', '5', '5', '2', '6', 'A', 'C', '7', '0',
    '7', '9', '3', 'F', 'A', '6', 'C', 'B', 'F', 'B', 'C', '3', '4', '7', 'A', '0',
    'A', '7', 'C', 'D', '6', '4', 'C', 'B', 'D', '1', '5', 'D', 'C', 'B', 'B', 'D',
    'A', 'B', '5', 'F', 'B', 'F', '0', '3', '8', 'F', '0', '7', '6', 'B', '8', '3',
    'B', 'F', '2', '5', 'A', '0', 'B', 'B', '3', '0', '3', 'F', 'B', 'A', '5', '5',
    'C', 'D', '7', 'E', 'C', 'E', 'E', '7', '0', '6', 'F', '4', '2', '1', '3', '1',
    '5', 'D', '8', '3', '3', '7', 'D', 'E', 'D', 'F', '6', 'E', 'A', 'E', 'A', '4',
    '7', '1', 'E', '1', 'A', '9', 'D', 'E', '5', 'F', 'A', 'F', 'D', '0', '8', 'C',
    '2', '5', '8', '7', 'C', 'C', '4', 'A', 'F', '7', '9', 'D', 'B', '4', 'E', 'E',
    '5', '1', '4', 'A', '6', '7', '7', '6', '5', '4', '8', '7', '1', '4', '4', 'D',
    '6', '4', '7', 'C', '8', '1', '9', 'A', 'E', 'F', '2', '0', '9', '4', '2', '4',
    '6', '1', 'B', 'E', 'E', '4', '4', 'E', 'C', 'C', '7', '1', '3', '7', '6', 'C',
    '6', '5', '9', 'C', '9', '6', '4', '0', 'E', '1', '3', '4', '3', '9', 'B', '7',
    '1', 'F', 'F', '7', '3', 'A', '3', 'C', '6', 'B', '5', '6', '5', '2', 'F', '8',
    '7', '5', 'D', 'B', '9', '6', '8', '3', 'A', '6', '2', 'A', '1', '9', '1', '0',
    'A', '1', '2', '7', '3', '3', '8', '9', '3', 'D', 'E', 'F', '9', '0', 'D', 'F',
    'E', 'B', 'D', '9', '6', 'A', '4', '0', '9', 'A', '9', 'F', '2', '3', '9', '1',
    'B', '2', 'D', '9', 'E', '7', 'E', 'E', '2', '6', '6', '2', 'E', 'B', 'B', 'E',
    '3', '4', '4', '3', '6', 'B', '9', '8', '2', 'C', '0', '2', 'D', '5', '4', 'F',
    'B', 'A', '7', '1', '5', 'E', '6', '3', 'E', '8', 'E', '3', '1', '4', '7', 'F',
    '8', 'C', '0', '2', '4', 'E', 'B', '6', 'D', 'F', 'E', '8', '4', '2', '4', 'E',
    'B', 'F', 'C', '7', '7', '6', 'E', '7', '7', 'E', '4', '2', 'A', '1', '9', '1',
    'C', '7', 'D', '5', '5', '8', '9', '6', '6', 'D', '8', '5', '8', '6', '5', 'D',
    '2', '2', 'B', '0', 'A', '4', '7', '4', '8', 'E', '9', '4', '1', '2', 'D', 'F',
    '7', 'D', '3', '1', '0', 'A', '5', '4', 'F', '0', '7', '7', '1', '0', '0', 'B',
    'F', '3', 'F', '3', 'E', '9', 'E', 'B', '2', 'F', '8', '9', '3', 'B', '3', '6',
    '6', '2', '3', 'C', 'E', '7', '4', '4', '3', 'D', '6', 'B', '8', 'B', '8', 'C',
    'B', '8', '8', '5', '9', 'B', '3', '4', 'E', 'F', 'D', 'B', '6', 'D', '4', '8',
    '4', '1', 'C', 'B', '3', 'B', '6', 'D', '8', '1', '5', '1', 'A', 'D', '1', 'F',
    'E', 'F', '2', 'C', '9', '6', '0', '7', '9', '6', '1', '8', 'D', '1', '5', '6',
    '6', 'F', '8', '9', '3', '0', '8', '9', 'A', 'A', '5', '7', '5', '1', 'D', 'C',
    '2', '7', 'C', 'E', '5', '2', '8', 'E', '8', '1', '6', '8', 'E', '7', '7', '3',
    '0', '5', 'A', '6', '7', '0', '5', '5', '5', '6', '8', '0', '8', '0', 'D', '5',
    '4', 'C', '2', '7', 'A', '5', '6', 'E', '7', 'D', '6', 'D', '0', '9', '4', 'C',
    'C', '8', '9', 'D', '9', '5', '9', '3', '3', '3', '9', 'D', 'C', '0', 'E', '3',
    '1', 'D', 'F', '1', 'C', '8', 'F', '2', 'B', '7', '9', '8', 'E', '6', '4', '1',
    'A', '4', '9', '2', '8', '0', '5', 'A', 'B', 'E', '8', 'A', '5', '7', '5', '0',
    'C', 'F', '5', '1', 'B', '1', '2', '6', 'A', 'E', '6', 'E', 'E', '4', 'D', '9',
    '4', '3', 'A', 'A', '7', '8', 'C', 'D', 'D', '9', '6', '1', 'B', '4', '8', '9',
    '8', 'D', 'D', 'C', '9', '3', '6', 'A', '6', '8', '7', '1', 'C', 'B', '5', '5',
    '6', '9', 'C', 'A', '3', 'E', 'D', 'B', '0', '1', '5', 'C', 'D', 'E', 'B', '2',
    '2', 'E', 'B', '4', '7', '9', '7', '4', '3', '7', '0', 'C', '6', '4', '1', '0',
    '5', 'F', '3', '6', 'F', '4', 'B', 'A', '5', '5', 'C', '0', '7', 'F', '6', '0',
    'A', '2', 'B', 'F', '7', '8', '2', 'D', '0', '0', 'F', 'E', '9', '3', '6', '6',
    'B', 'A', '2', '3', 'A', 'D', '7', '1', '5', '1', '7', 'F', 'B', '2', 'A', '9',
    '7', '5', 'A', '8', 'B', 'E', 'A', '7', 'D', '1', '8', 'F', '4', '7', 'E', '7',
    '5', 'C', '0', '6', 'C', '4', '0', '8', '8', '7', 'C', '5', '1', '0', '5', 'A',
    '5', '0', 'A', 'D', '3', 'D', 'D', '0', 'C', 'B', '1', '6', '5', 'E', '3', '4',
    'D', 'B', '2', '9', '9', 'F', '8', '2', '9', '8', '2', '5', '4', '6', 'C', 'B',
    'A', 'C', '3', 'C', '8', '9', '5', 'E', '6', '9', '8', '3', 'A', 'A', 'D', '4',
    '8', '0', '6', '2', 'C', 'E', '6', 'F', '6', 'B', 'D', '7', 'A', '5', '1', '6',
    '0', 'B', '2', 'D', 'E', 'B', 'D', '0', 'F', 'C', '6', 'F', '9', '5', '2', 'A',
    'A', 'C', '1', '7', 'A', '1', '9', '8', 'A', '3', 'C', 'A', 'F', 'B', 'E', 'B',
    'A', '9', '6', '4', '3', '5', 'F', '9', '9', '2', '7', 'F', '1', '9', '4', '5',
    '9', 'E', 'E', '5', '0', '5', 'F', '2', '0', 'B', 'F', '7', 'E', 'C', 'C', '5',
    'D', 'B', '9', '4', '8', '0', '7', '4', '3', '1', 'F', '5', 'C', '8', '6', '7',
    '4', '4', '4', '4', 'D', '5', '2', 'D', '2', '1', '6', '3', 'B', 'D', 'D', '5',
    '1', 'E', 'A', '9', '3', '2', '9', '8', '4', '7', 'A', '4', '3', '5', '5', 'D',
    'A', '3', '2', '7', '4', '3', 'E', 'B', '7', 'B', '4', '7', 'C', '7', 'A', '9',
    '7', '0', 'F', '0', '4', 'E', '4', '0', 'F', '0', '5', '0', '1', '3', '9', '8',
    '2', '1', '8', '9', 'B', '8', 'D', 'C', '4', '6', '6', '4', 'D', 'D', 'E', '1',
    '6', '7', '8', 'F', 'F', 'F', '4', 'D', '5', '2', 'E', '4', '0', '0', 'C', 'A',
    '2', 'C', '3', '0', '4', '1', 'E', '2', '5', 'D', 'F', 'C', 'B', 'A', '4', '3',
    '7', 'A', 'D', '0', '1', '4', 'B', '1', '3', '6', '5', 'B', '4', '2', '8', '2',
    'C', '7', 'A', '5', 'F', '3', 'C', 'C', '3', 'E', 'D', '4', 'C', '5', '4', 'E',
    '7', '9', '7', 'B', 'C', '9', '1', 'B', 'E', '1', 'F', '9', 'A', 'D', '9', 'B',
    'F', '7', '7', '0', '7', 'E', 'A', '3', '9', 'E', '8', 'F', 'E', '7', 'A', '0',
    'C', 'C', 'D', '7', 'C', 'F', 'E', '1', '1', '6', '0', '9', 'B', '6', 'C', 'D',
    '2', 'C', '3', 'C', '1', 'D', 'F', 'A', '0', 'E', 'C', '3', 'E', 'F', 'F', 'B',
    'D', '2', '7', '0', 'D', '5', '2', 'D', '5', '3', '3', '7', 'C', 'D', 'D', '5',
    'D', 'C', '6', '9', 'A', '5', '6', 'D', '2', '0', 'C', '1', '2', 'A', '9', 'C',
    'B', '2', 'F', '9', '9', '0', '4', '1', 'E', 'B', 'C', 'F', 'A', 'C', 'D', '3',
    'F', '3', '3', 'E', 'D', '3', '9', 'A', 'F', 'A', '9', '3', '4', '2', '7', 'F',
    '9', '6', '0', 'A', 'B', 'F', '4', '6', '4', '6', 'C', '9', '4', 'E', '1', '8',
    'D', 'E', '1', '5', '1', '3', '0', 'F', '1', '5', '0', 'F', 'C', 'C', 'B', 'F',
    '4', '5', '6', 'C', '9', 'A', 'F', 'D', '1', 'B', '7', '6', '8', '8', '7', '1',
    '0', '9', '0', '5', 'D', '9', 'D', '9', '4', '5', '4', 'A', '9', 'A', '1', '8',
    'A', '8', '2', 'D', 'B', '3', 'A', '9', '6', 'F', '4', '0', 'C', '0', '9', '1',
    'E', 'E', 'D', '4', '7', 'D', '2', '7', '9', '9', '5', 'F', 'D', '6', '2', 'A',
    '2', 'F', 'D', 'B', '7', 'D', '5', '8', '6', 'D', '5', '9', 'B', '3', 'E', '8',
    '8', 'F', 'A', 'B', 'F', 'F', 'E', '0', 'D', 'C', 'D', 'E', '7', '8', '7', '7',
    'E', 'B', '5', '5', '9', '8', '7', '1', 'E', 'A', '5', 'C', '4', '4', '7', 'A',
    '2', '8', 'D', 'D', '7', '6', 'D', 'A', '0', 'F', '4', '4', '5', 'E', '6', '4',
    '2', '6', '0', '9', '9', 'E', '6', '7', '5', '5', '5', 'D', '2', '6', 'A', '1',
    'F', 'E', '5', '3', '4', '1', '3', '7', 'B', 'B', '4', '3', 'C', 'D', 'E', '1',
    '0', '2', '2', '8', '1', '4', '1', '9', '7', 'B', '7', '8', '8', 'F', 'B', 'A',
    '7', '2', '9', '8', '5', '3', 'D', '2', '7', '9', '2', 'C', 'F', '2', '4', 'B',
    '3', 'C', '7', '6', '2', 'E', 'C', '2', 'A', 'C', 'A', '4', 'E', 'F', '5', '8',
    '4', '4', '9', '7', 'E', 'A', '0', 'A', '0', '9', '3', '2', '0', '4', '7', 'F',
    'A', 'A', '8', '9', '0', 'C', '5', 'A', 'F', '4', '8', '4', '3', 'B', '9', 'A',
    'B', '9', '7', 'F', 'A', '3', '0', '6', 'F', 'B', 'A', 'A', 'B', 'C', '5', '5',
    'E', '0', 'E', 'D', 'E', '4', 'F', '3', 'B', '6', '3', '9', '8', 'F', 'E', 'C',
    '3', 'A', '3', '0', 'E', '7', '0', '6', '4', '4', '0', 'E', '7', 'D', '7', '8',
    '6', 'F', 'A', 'F', '2', 'F', '4', '5', 'E', '8', 'F', '7', '3', '2', 'A', '7',
    '9', 'F', 'F', '3', '6', '9', '3', '0', '5', 'D', '9', 'D', '4', '5', '9', '2',
    'A', '3', '6', '4', '3', '7', '1', '3', '3', 'F', 'C', 'D', 'E', 'D', '6', '4',
    '9', 'F', '6', '4', 'A', 'A', 'C', '9', '2', 'E', '6', 'F', '7', '6', '3', 'C',
    '0', 'C', 'C', 'E', 'F', '8', 'E', '7', 'C', '7', 'E', '8', '6', '8', '1', 'D',
    'D', '0', '7', '2', 'E', '6', 'A', 'F', '5', 'C', 'B', 'E', '2', '8', '8', 'F',
    'A', 'E', '8', 'B', '8', '1', '6', 'A', '0', 'A', '6', 'B', '6', '6', '4', 'B',
    '7', 'F', '4', '6', 'A', '3', '8', '2', 'A', 'F', '2', '8', '0', 'B', '8', '8',
    'F', 'E', '8', '8', '9', '4', 'E', '3', '7', 'A', '1', '7', '7', '4', '2', '2',
    '2', '8', '0', 'D', '5', '9', '6', '5', '7', '6', 'C', '9', 'E', 'D', 'C', '2',
    '6', '5', '1', '9', '7', 'D', '3', 'E', '8', 'C', '8', '6', '4', '4', '2', '1',
    '4', '3', '2', '6', 'B', '1', 'B', '4', 'E', '2', '3', '6', 'C', 'D', 'C', 'C',
    'E', '1', 'C', 'C', '9', '7', '7', '6', '9', '5', '3', 'E', '4', '9', '6', '8',
    '2', '9', '9', 'E', 'C', '3', '3', '6', '5', '0', 'E', '8', 'C', '1', '0', 'A',
    'B', '2', '7', 'A', '6', 'A', '4', 'E', 'A', 'D', 'D', '5', '7', '1', 'A', '4',
    '0', '1', 'E', 'F', '9', 'D', 'B', 'A', '4', '5', 'D', 'A', 'B', '8', 'B', '4',
    'F', '1', 'F', 'E', 'D', '9', '4', 'F', '6', 'A', '8', '1', '9', '4', '5', '7',
    'A', 'B', '0', '5', '4', '8', '0', 'F', '9', '5', 'E', '3', '9', '3', 'C', '1',
    '9', 'E', 'D', 'F', '6', '6', 'F', 'D', '3', '6', '6', 'D', 'E', '2', 'F', 'E',
    '9', '4', '2', '9', '0', '8', 'C', '0', 'F', '4', '8', '8', 'B', '6', '4', '0',
    '5', 'E', 'B', 'B', '6', 'B', '1', '9', '7', 'D', '0', '3', '9', '6', '4', 'F',
    '7', '3', '8', '3', '1', '4', '6', '8', 'B', '5', '3', '1', '5', '8', '4', '2',
    '3', 'B', '1', 'F', '8', 'A', '2', 'A', 'C', 'D', '2', '9', 'C', '7', 'B', 'E',
    '7', '9', '1', 'A', 'E', '3', '4', 'F', 'B', '2', 'C', 'F', 'B', '1', '9', 'D',
    '5', '8', '7', 'F', '5', '7', '9', '6', '9', '5', '5', 'A', 'D', 'B', '6', '4',
    'F', '9', 'F', '6', '8', '3', '9', 'C', '6', '0', '2', '7', '9', 'D', '5', '1',
    'C', 'B', '2', '4', '2', '7', '3', '1', '4', '1', '5', '9', '1', '9', '5', '7',
    '6', '9', '7', 'A', '0', 'D', '3', '6', 'E', '3', '2', '2', 'C', '0', 'D', 'F',
    '0', '6', 'A', '2', '8', '4', 'D', '1', 'A', '5', 'B', 'A', 'B', 'C', 'F', '6',
    '6', '9', 'B', 'B', '2', '9', '4', '7', '7', 'E', 'F', '2', '6', '2', 'B', 'F',
    '3', 'C', '3', 'B', '8', '3', '7', '7', '3', 'D', '8', 'C', '3', '5', 'E', 'D',
    '7', '8', 'D', '4', '8', 'C', '4', '2', '5', 'F', 'D', '2', 'D', 'C', '2', '8',
    'A', '2', '9', '4', '1', '3', '1', '9', 'F', '6', 'A', '6', 'E', 'A', 'F', 'B',
    'D', '8', '1', '8', 'E', '6', 'A', '0', '3', '0', 'E', '9', 'B', '6', 'E', '8',
    '1', '2', '3', '0', 'C', 'C', '5', '0', 'B', '0', '3', '2', 'E', '2', 'D', '3',
    'A', '2', '1', 'C', '1', '9', '8', 'B', '5', '1', '8', '0', '6', '2', '6', '4',
    '7', '1', '2', '7', '8', '0', 'F', 'C', '0', '8', '3', '9', '7', '4', '0', '7',
    '2', '9', '6', '0', '5', '9', '5', 'D', '4', '2', '6', '8', 'B', 'F', '3', '2',
    '1', '0', 'E', '1', '4', '1', '6', '5', '3', '1', 'E', 'D', 'E', '8', '8', 'D',
    '3', 'B', 'B', '1', 'E', 'C', '3', '8', '5', '6', '9', 'E', '8', 'C', '9', 'F',
    '1', 'B', '4', 'B', '9', '6', '9', '1', 'F', '1', '3', '3', '2', '6', '3', 'F',
    '3', 'B', 'A', '7', '1', 'D', '2', '3', '3', 'E', '4', '6', '7', '6', '0', '1',
    'F', '8', '3', '6', 'D', '8', '2', 'A', '8', '5', '9', '1', '3', '2', '8', 'B',
    'B', '2', 'D', 'C', '1', '3', 'A', '5', '2', 'D', '6', '6', '4', 'D', '4', 'A',
    '4', '2', '3', 'B', 'B', 'C', 'B', 'F', '0', '9', 'F', '9', 'C', '3', '8', 'F',
    '2', 'E', 'D', 'F', 'C', '4', '0', '7', 'A', 'C', 'D', '1', 'E', 'A', '8', 'B',
    '9', '9', 'C', '2', 'F', 'E', 'F', 'C', '8', 'F', '2', '3', 'F', 'D', '7', 'A',
    '2', '7', '2', '7', '0', '5', '0', '7', '7', '6', '7', '4', 'B', '4', 'D', '3',
    'B', '3', '5', '1', 'F', '7', 'E', '5', '9', '3', '3', 'D', 'D', '4', 'A', '9',
    '4', '7', 'D', 'D', '1', '5', '6', 'D', '9', 'C', '3', '3', 'E', '7', '9', 'C',
    '4', 'E', '9', 'C', '2', '9', '0', 'E', 'A', 'C', '7', 'D', 'B', 'C', '4', '6',
    'C', '4', 'B', '6', 'D', 'C', '4', '7', 'D', '0', '5', '8', '3', 'D', 'F', 'B',
    '0', '9', 'A', '5', 'F', '0', '7', '1', '1', '5', '9', '4', '1', 'A', '3', 'A',
    '1', '6', '3', 'D', '5', 'E', '9', '1', '7', 'F', 'C', '2', '3', 'E', '1', 'A',
    'D', 'B', '5', 'E', 'C', '3', 'A', 'E', 'C', '3', 'B', '7', 'F', '9', '1', 'D',
    '4', '3', '7', '5', 'E', '1', '2', 'B', '7', 'D', 'D', '6', '7', 'A', '7', 'A',
    'E', '3', '1', '0', '2', 'C', '1', 'D', 'A', '4', '4', '3', '4', '8', 'D', '3',
    '2', 'E', '3', 'F', 'F', 'B', '8', '9', '2', '6', '1', '8', '6', '9', '4', '3',
    'B', '1', 'C', '5', '4', 'B', '6', 'B', '8', 'B', '4', '1', 'D', '6', '7', '1',
    '2', '9', '7', '2', '5', '7', '3', '6', '2', '5', 'A', '3', '5', 'F', 'A', 'B',
    '7', '5', '9', '6', 'A', '3', '2', '5', 'F', 'D', '8', '9', 'E', 'E', 'A', '9',
    '7', '5', 'F', '4', '4', '6', '8', 'F', 'D', 'B', '0', '2', '3', 'F', 'B', '2',
    'C', '2', '0', '6', '9', '9', '4', '9', 'D', '2', '5', 'C', '0', '6', 'A', 'C',
    '6', '3', '0', '6', '5', '3', '2', 'B', '4', '4', 'E', '1', '7', '8', '3', 'E',
    '3', '8', '5', 'C', '2', '8', '9', '1', '5', '4', 'D', 'B', '1', '8', '2', 'D',
    '3', 'C', '0', '4', '8', '7', 'E', '4', 'E', 'A', 'F', '4', 'F', '3', 'E', '2',
    'D', '0', '4', '1', '7', '9', 'D', '6', '3', '7', 'F', '4', 'E', 'C', '1', '3',
    'D', '8', '4', 'D', 'F', '8', '0', '3', '8', '5', 'F', '7', 'E', 'C', '8', '6',
    '2', '5', '6', '6', '5', 'D', 'F', '8', 'D', 'D', 'F', '0', '4', '0', 'F', '1',
    '5', '6', 'B', '7', 'E', '2', 'D', '3', 'C', 'F', 'C', '0', '2', 'D', 'B', 'E',
    'D', 'A', '1', '6', '6', '5', '1', 'F', '5', 'F', 'C', '9', 'D', '2', '5', '4',
    '3', 'C', 'A', '4', '5', '6', '2', 'B', '6', 'D', '6', '0', '7', '6', '8', '6',
    'A', '5', '0', 'F', 'C', '8', 'E', '9', '9', '6', '6', '1', '1', 'E', 'B', '3',
    '7', '8', 'C', '3', '9', 'B', '6', 'D', 'F', 'A', '4', '6', '3', '2', '0', '0',
    'C', 'A', '9', 'C', '4', 'B', 'A', '7', '8', '0', '6', 'D', 'F', 'A', '7', '9',
    '5', 'E', '6', '0', '0', '7', 'A', 'D', '4', '4', '0', '9', '3', '6', '9', '9',
    'F', '0', '3', 'D', '8', '9', 'C', '2', 'B', '0', '1', 'B', '3', '0', 'C', '2',
    'C', '1', '6', '1', '3', 'C', '0', 'E', '4', '6', 'D', 'C', '9', 'B', '0', '5',
    '4', '9', '4', 'F', '7', '8', '8', '4', '5', '1', '2', 'E', 'D', '9', '1', '0',
    '2', '7', 'E', '6', '6', '3', 'B', 'E', 'A', '7', 'D', '0', 'C', '3', '5', 'A',
    '7', '6', '1', '7', '9', 'F', '6', '7', '9', '9', 'D', '7', '8', '3', '7', 'C',
    'D', 'D', 'A', '2', 'F', '5', 'B', 'D', '6', 'A', '4', '9', '0', '6', '6', '7',
    '0', '7', '7', 'F', '9', '2', '1', 'B', '0', 'C', 'D', '4', '5', 'A', 'A', 'A',
    '9', '7', '9', '8', '4', '7', 'C', '6', '1', '3', '1', 'E', '4', 'E', '5', 'F',
    '7', '4', 'C', '9', '4', 'E', '0', '4', '6', '0', '0', '4', '1', '0', '6', 'C',
    'E', '3', '1', 'E', '2', 'A', '4', 'C', 'B', '3', 'C', 'A', 'E', 'C', 'F', '9',
    '6', 'E', 'D', 'E', '3', 'C', '1', '9', '4', '9', '8', '5', 'D', 'C', '5', '7',
    '2', '2', '2', '3', '8', '0', '9', 'F', 'F', '1', '5', '8', '5', '3', '6', '0',
    'F', '5', 'E', '1', '1', '6', 'E', '3', '2', '3', 'E', '8', '3', '7', '3', 'B',
    '8', 'F', 'F', '7', '9', '9', 'D', 'D', 'D', '8', '2', 'E', '1', 'F', '7', '8',
    '8', '8', '5', '9', 'C', '8', 'C', '3', 'D', '1', 'A', '7', 'B', 'A', '6', '8',
    '1', 'D', 'B', 'C', '6', 'C', '2', 'F', '3', 'F', '7', '3', '7', '1', 'B', '0',
    '6', 'D', '4', 'E', '5', '4', '4', 'D', '1', 'D', 'A', 'E', 'F', 'F', '1', '0',
    '7', '0', '5', 'E', '6', '7', '4', 'A', '3', '9', 'E', '1', '4', 'A', '2', '2',
    'A', '2', 'D', '1', 'A', 'A', 'F', 'F', '1', '0', 'E', '0', '6', '8', '0', '8',
    'B', 'A', '5', '7', '2', 'F', 'E', 'B', '8', '7', 'E', '6', 'B', '1', '7', '5',
    'A', '9', '8', 'A', 'A', '8', '8', 'C', 'F', 'E', '4', '5', '7', '5', '4', '0',
    'B', '0', '9', '4', '7', '3', 'A', '6', '8', 'C', '2', '9', 'B', 'A', '5', 'A',
    '6', '8', '8', '6', 'C', 'D', '4', '9', '7', '9', '6', 'F', '9', 'C', 'F', '8',
    '6', '3', 'B', '1', '1', '1', '5', 'E', 'B', 'A', 'B', '7', '6', '4', 'C', 'F',
    'F', '0', '8', 'F', '6', '5', '4', '4', 'D', '9', 'A', 'F', '1', 'C', '2', '4',
    '6', 'F', 'B', '8', '1', 'E', '5', '2', '4', '7', '5', 'B', '1', 'E', 'C', '8',
    '0', 'E', 'E', 'A', '6', '1', 'E', '9', '2', '3', '3', 'F', 'B', '4', 'C', '3',
    '1', '2', '8', '5', '9', 'E', 'C', 'A', '3', '1', 'D', 'A', 'F', '5', '4', 'A',
    'F', 'E', '7', '0', '6', '4', 'C', '3', 'A', '1', '1', '0', '8', '8', '1', '2',
    '8', '0', 'F', 'C', '5', '6', '4', '9', '4', '5', '6', '5', '2', 'F', '0', '8',
    '7', 'D', 'B', 'A', '4', '4', '7', 'C', 'D', 'A', '9', '6', '9', 'F', 'F', '4',
    '4', 'C', '1', '3', 'A', '8', '7', 'B', 'D', 'B', 'C', 'C', '5', '2', '9', '1',
    '7', '1', '7', '3', 'D', '3', '8', 'B', 'C', '8', '1', '3', '6', '0', '8', '8',
    'C', 'A', '5', '5', 'C', '7', 'F', '2', 'E', '0', 'C', 'F', '9', 'D', '9', '9',
    '4', 'C', '9', '0', 'B', 'A', '0', '4', 'A', '8', '0', 'B', 'F', 'A', '6', 'D',
    'C', '8', '3', 'E', '4', 'B', 'F', 'E', '2', '5', '3', '0', '3', '0', '0', 'D',
    '3', '6', 'D', '0', 'E', '1', '4', 'A', '0', '8', '0', 'E', 'F', '8', '3', '9',
    'C', 'D', '1', '1', 'D', 'A', '8', '1', '1', '7', '2', 'C', '6', 'B', '6', '0',
    'B', 'A', 'B', '8', 'D', '6', '5', '3', 'C', '7', '4', '6', 'B', '0', 'D', '1',
    '1', '0', '3', '9', '3', '8', '7', '5', '4', '2', '0', 'D', 'A', '1', '4', '3',
    '5', '1', 'E', 'C', '1', 'B', 'B', '6', '7', 'A', '3', '1', 'B', '1', 'B', 'A',
    '1', '9', '7', '9', 'A', '7', 'D', 'B', '5', '5', '8', '3', 'D', '2', 'B', '3',
    '4', 'B', 'D', 'B', 'E', 'D', '0', '8', '8', '9', '3', 'E', '1', '8', 'A', '4',
    'D', '8', '7', '9', '5', 'D', '8', '5', '1', '2', '1', 'A', 'B', '8', '7', '8',
    'E', '1', '9', '3', '9', '4', '4', '9', '7', '5', '3', 'D', '4', '6', '6', 'E',
    '7', 'D', 'A', 'B', 'F', 'B', 'D', '3', 'A', '0', 'F', '3', 'F', '8', '9', '8',
    'E', '7', '9', '0', '8', 'B', '1', '2', 'A', '8', '7', 'A', '4', '8', 'C', '9',
    '6', 'D', '5', 'B', 'A', '1', '2', '2', 'B', '7', '9', '9', '5', '4', 'B', '6',
    'A', '1', '5', '8', '3', 'F', '1', '3', '3', '6', '7', 'C', '5', '4', 'B', '5',
    'A', '3', '6', 'C', '1', 'E', '4', '4', '0', 'F', 'E', 'C', 'E', 'E', '2', 'D',
    'C', 'E', 'D', '5', '1', '2', 'B', '6', '4', '9', 'D', '0', '4', '6', '9', '7',
    '7', '1', '4', '3', '9', '2', '5', '6', 'E', '6', '1', '1', '0', '1', 'D', '7',
    'E', '3', '1', '8', '1', '0', '0', '5', '1', '0', 'B', 'F', 'E', 'C', 'E', 'C',
    '2', '6', 'F', 'C', '8', 'D', 'D', '1', '3', '4', '8', 'E', '7', 'D', 'B', '6',
    'B', '8', '0', '4', 'A', '0', '6', '3', 'F', '3', '4', '3', '8', '5', 'C', '3',
    'F', '1', '7', '2', 'D', '2', '8', 'B', '1', '1', '0', 'F', '6', 'E', 'A', 'E',
    '6', '5', '2', '9', '5', '5', '7', 'E', '8', '2', '4', '3', '0', 'B', '2', 'B',
    '5', 'F', '4', 'D', 'D', 'A', '8', '8', '6', '3', 'F', 'E', '1', '7', '3', 'C',
    'D', '0', '8', '6', '0', 'C', '1', 'B', '7', '3', 'D', '7', 'D', '3', 'A', '9',
    'B', 'B', '2', 'B', 'D', '7', '0', 'B', '7', '5', '5', '0', '7', 'F', '2', '5',
    '6', '0', '2', '2', '7', '2', '5', '4', '7', '3', '9', '3', '8', '6', 'F', 'D',
    '8', '5', 'A', 'E', '8', '9', '1', 'A', 'D', '3', '4', 'B', '0', '4', 'A', '1',
    '6', 'C', '6', 'C', '7', 'D', 'A', '6', '4', '4', 'E', 'D', 'C', 'D', '4', 'F',
    'C', '1', '2', 'C', '9', 'C', '5', 'F', '1', 'E', 'C', 'D', '8', '5', 'E', '5',
    'F', '1', '8', 'A', '3', '1', 'C', '2', 'B', 'C', '2', 'F', 'F', '9', '3', '6',
    'B', '3', '8', 'D', '2', '7', 'F', '6', 'B', 'E', '8', '6', '4', 'B', '7', '5',
    '0', '2', '9', '9', 'C', '4', 'D', '6', '5', '2', 'C', '8', '3', 'D', '7', '7',
    'C', '1', '8', 'A', '5', 'B', '9', 'F', '8', '4', 'C', '1', '9', '5', 'E', '8',
    '6', 'E', '2', 'B', '1', '5', '5', 'B', '2', 'E', 'F', '3', 'D', 'A', 'A', '9',
    '8', '7', 'F', 'F', '5', '6', '2', '3', '3', 'F', 'C', '0', '7', '5', '9', '5',
    '3', '7', 'C', '6', 'F', '6', 'B', '0', '9', 'C', '9', '5', '5', '0', '8', '5',
    '1', 'B', '8', '4', 'C', '1', '1', '7', '8', '1', '6', '1', '3', 'E', '5', 'E',
    '7', 'C', '3', '8', 'D', '5', 'D', '8', 'D', 'D', '1', '2', 'F', 'B', '0', '4',
    '0', 'D', '0', '5', 'C', '3', '2', 'B', '5', 'A', '6', '2', '6', 'B', '8', '8',
    '1', '5', 'A', 'C', '5', '8', '5', '2', 'B', '5', 'B', 'D', 'F', '5', 'E', '8',
    '0', '9', 'E', 'C', 'B', '2', '4', '3', '6', '1', 'F', '5', '6', 'C', '0', 'F',
    '7', 'A', '8', '7', '2', '6', '7', '0', '4', '7', '9', '3', 'F', 'A', '2', '6',
    '7', '3', 'D', '9', '8', 'C', '5', 'D', 'B', 'E', '0', '8', 'D', '3', 'D', 'D',
    '3', '7', '0', '4', 'F', 'A', '9', '8', '1', '2', 'B', 'D', 'C', '1', '9', '2',
    '2', 'E', 'A', '7', '4', 'D', 'A', '5', '9', '0', '6', '2', '0', 'B', '1', '9',
    '8', 'F', '0', '8', 'C', '2', 'D', 'A', 'A', '0', '0', '4', 'E', '2', '5', 'D',
    'A', '1', '8', 'C', '3', '4', '0', 'D', 'C', '0', 'E', '8', '2', 'A', 'E', '3',
    '8', '3', 'D', '4', '3', 'C', '1', 'E', '7', '7', 'E', '7', 'E', 'E', '9', 'D',
    '7', '3', '1', 'F', '7', 'E', '9', 'B', '8', '7', '1', '2', 'B', 'E', 'F', '7',
    '0', 'A', '7', 'F', '5', 'E', '6', '3', '9', 'B', '5', '7', 'A', '1', 'B', 'E',
    'E', '2', '1', 'C', '8', 'F', '1', '3', 'B', '2', 'D', '8', '3', 'A', '6', '9',
    'F', 'C', 'A', '4', 'C', 'D', '7', '5', '3', '4', '5', '9', 'E', '4', 'E', '9',
    '3', '5', '9', 'E', 'E', '1', '2', '4', 'D', '5', '4', '1', 'F', '2', 'D', 'D',
    '1', 'E', '7', '1', 'F', 'A', '6', '3', '5', '5', '8', 'A', '0', 'D', 'A', 'F',
    'E', 'C', '3', 'D', '1', 'A', '6', '5', '8', 'D', 'C', '7', '2', '2', '7', '9',
    '8', 'D', '9', '0', '9', 'A', 'C', '4', '2', '1', '9', '4', '6', '7', 'B', '3',
    '5', '5', '4', '9', '3', '5', 'D', '1', 'C', '8', 'C', 'F', 'F', 'F', 'B', 'A',
    '5', '2', '1', 'D', 'E', '4', 'F', '3', '3', 'A', '0', '4', '2', 'A', 'E', '4',
    '8', '4', 'E', '4', '3', 'B', '1', '8', '7', '8', '7', 'B', 'D', '0', '5', '1',
    '9', '2', '3', 'D', '1', 'B', '3', '7', '2', '2', '2', '4', '0', '4', 'B', 'E',
    '1', 'A', '9', 'C', '3', 'D', 'F', 'A', '9', 'A', '3', '1', 'D', '2', '6', '9',
    '9', '9', 'A', '1', '9', '8', '1', 'E', '1', '1', '2', '8', '4', '7', '6', '3',
    '4', '5', '4', '0', 'F', '9', '2', '0', 'C', '8', '8', '5', '8', 'D', '1', 'B',
    '6', '4', 'F', '3', '9', 'E', '2', 'B', '6', '6', 'F', 'D', 'E', '3', '7', '6',
    '3', '7', '0', '1', '6', '8', '9', 'E', 'E', 'E', '8', '2', '7', 'C', '0', '5',
    '5', '5', '1', '3', '3', 'B', 'A', '7', '2', '7', 'B', '4', '2', '5', '8', '1',
    '3', '4', '8', 'F', 'A', '9', 'E', 'D', '8', '0', '3', 'F', '9', '3', '1', 'E',
    '8', 'F', '6', 'D', '9', '0', 'F', '8', '9', 'C', '4', '7', '8', 'E', '6', 'D',
    '5', 'C', '0', '5', '6', 'E', '2', 'A', 'F', '6', '1', '4', '2', '6', 'A', '4',
    '2', '4', 'E', 'E', 'B', '0', 'B', '9', '1', '7', '3', '8', 'C', 'C', '2', '3',
    '0', '8', '8', 'F', '4', '5', 'B', 'D', '5', 'B', '8', '3', '7', 'A', '8', 'F',
    'B', 'A', 'E', '6', '4', '7', '6', 'F', '0', '0', 'F', 'F', 'F', '3', 'B', 'C',
    'C', '8', 'B', '8', 'B', 'C', '7', '1', 'D', 'A', '5', 'B', '1', '2', '1', 'F',
    '3', '8', '2', 'B', 'B', 'D', '0', 'A', 'E', '7', '3', 'F', 'E', 'A', '8', '0',
    'E', 'B', '8', '6', '6', '5', '5', '5', '1', 'A', '9', '2', '6', '8', 'B', 'B',
    'F', 'E', '8', 'D', '4', '1', 'C', 'E', 'C', '9', 'E', '0', '6', '9', 'F', '4',
    'D', 'B', '0', 'B', '0', '1', 'D', '0', 'F', 'D', 'A', 'A', '5', '4', 'D', 'F',
    '8', 'B', '4', '2', '9', 'A', 'A', 'D', '0', '4', '1', '7', 'A', '9', '9', 'A',
    '7', '2', '9', '8', '3', 'B', '7', 'F', 'E', '5', '5', 'A', '5', '2', '8', 'E',
    '5', '0', 'C', '5', '9', '3', '3', 'B', '2', 'F', 'A', '6', 'B', '5', '3', 'E',
    'D', '8', 'B', 'E', 'F', '7', 'C', 'B', '9', 'B', 'C', '3', '5', '9', 'A', 'E',
    'D', '1', '9', 'F', '5', '7', 'A', 'D', 'A', '6', '0', '6', '5', '3', '7', '1',
    '3', 'C', '2', 'E', '7', '4', '8', '2', 'A', 'B', 'A', 'A', 'C', 'A', '5', 'F',
    '5', 'A', 'C', 'A', '3', 'F', '9', 'A', 'B', '4', '4', 'D', 'D', 'F', '1', '1',
    '2', '9', '1', 'F', '6', '5', '2', 'B', '5', 'D', 'D', '0', '4', '6', 'C', '1',
    'E', '1', '8', 'F', 'F', '2', '7', '1', '1', 'B', 'C', 'D', '5', 'D', 'D', 'E',
    '7', '5', '9', '8', 'C', '9', 'C', 'C', 'C', 'B', '7', '0', '8', 'B', '9', 'C',
    'B', 'C', 'E', '6', 'E', 'C', 'E', '5', '9', 'F', 'B', 'C', 'B', '2', '1', 'A',
    '3', '4', '9', '4', 'F', '1', 'E', '3', '0', '7', 'B', '1', '4', '5', 'B', 'B',
    '5', '6', '2', '0', '4', '5', '9', '7', '3', '5', '9', '3', 'E', '1', 'D', '0',
    '5', '4', '3', '5', '9', 'A', '7', '6', '4', 'A', '2', 'A', 'B', '1', '1', 'B',
    '8', '4', '3', 'B', 'C', '7', '5', '7', 'B', '1', '1', 'B', 'E', '6', '2', '8',
    '3', '6', 'D', 'F', '1', 'A', 'C', '7', 'A', 'B', '8', '3', '5', '8', 'C', 'A',
    '1', 'A', '5', '8', '2', '9', 'D', '0', '5', 'C', 'B', '1', '6', '6', '6', '5',
    '0', '0', 'A', '1', 'B', 'B', 'A', '8', '2', 'A', '6', '8', 'A', '2', '9', '4',
    '3', 'E', 'E', 'F', '3', '9', '6', 'A', '6', '3', '7', 'A', '3', '8', 'B', '2',
    '5', '3', '0', '4', '1', '6', 'A', 'C', 'A', '3', '4', '0', 'F', '4', 'A', '2',
    '0', '9', 'A', '1', '0', '4', '5', '4', 'F', '6', '8', '5', '0', '7', 'B', '7',
    '8', 'C', '7', 'F', 'F', '2', '5', '5', '6', 'E', '1', '1', '0', 'A', 'E', '7',
    'E', '1', 'E', '8', '6', '6', 'A', '2', '0', '7', '8', '4', 'C', '2', 'C', '3',
    'D', 'B', '0', '6', '9', '1', '4', '3', 'D', 'B', '4', '0', '5', 'D', 'B', 'D',
    'C', 'D', '4', '1', '7', 'E', '6', '0', '6', 'F', 'C', '3', '3', 'E', '0', '0',
    'F', '5', '6', 'C', '4', 'D', '3', 'D', 'A', '4', '1', '1', '0', '7', 'E', 'C',
    'C', '9', '5', 'E', 'C', '8', 'C', '6', '8', '5', '3', 'D', 'C', '0', '9', '3',
    'C', 'D', 'E', '5', '9', 'C', 'A', 'E', '3', 'D', '5', '2', '7', '2', 'F', '4',
    '3', '5', '4', '1', 'E', 'A', 'A', 'E', '1', 'D', '7', 'A', 'D', '7', '7', '3',
    '1', '1', 'B', '8', '8', 'F', 'C', '0', 'F', '7', 'E', 'F', '1', 'A', '4', 'D',
    '5', 'A', 'F', '0', '5', '4', '5', '2', 'D', 'B', '5', '8', 'F', '8', 'F', 'F',
    '3', '1', 'D', 'E', '4', 'D', 'F', '6', '9', 'A', '6', '8', '4', 'B', 'B', '3',
    'B', '0', '4', '1', '0', '3', 'E', 'F', '6', 'F', 'C', '0', '8', '4', 'E', 'A',
    'D', '7', '2', '1', '0', 'E', 'A', 'C', 'D', 'A', '6', '9', '9', '8', '6', '2',
    '6', '2', 'C', 'D', '5', '7', 'B', 'A', '3', '5', '1', '4', '2', '1', '5', '7',
    'B', 'A', 'F', 'B', 'F', '6', 'E', 'C', '0', '4', '5', 'E', 'A', 'F', '6', '3',
    '8', '1', '3', 'F', 'F', '8', 'E', 'F', 'F', 'B', 'D', '3', '8', 'C', '6', 'E',
    'C', '1', '0', '0', '5', '0', '3', '7', '0', '0', 'F', '4', '1', '0', '5', '6',
    '1', 'D', 'F', '9', 'F', '4', '8', 'B', 'A', 'E', 'C', 'D', '9', 'A', 'E', 'B',
    '7', 'B', '0', '4', 'E', '9', '2', 'C', '8', 'A', 'D', '8', '9', '8', '3', '8',
    'F', '5', '7', 'C', 'A', 'A', '4', '2', '7', 'D', 'D', '3', 'A', '0', '3', '1',
    'D', '9', 'C', 'B', '3', '6', '1', 'E', '8', 'C', 'F', 'D', 'E', '4', '8', '5',
    'F', '7', '4', 'C', '7', '7', '4', '3', '3', '0', '0', '4', 'A', '2', 'E', '8',
    '3', '1', 'A', '5', 'F', 'E', '5', 'E', '8', 'A', '6', 'D', '6', '2', 'E', 'F',
    '8', '4', '8', '6', 'A', 'A', '8', '7', '5', '6', '4', '5', '9', '2', '1', '2',
    '3', '2', '2', '4', '0', '1', '3', '6', '2', 'D', '3', 'E', '9', '0', 'A', '4',
    '6', 'C', '1', '0', '1', 'E', '4', 'D', 'B', '6', '8', '8', 'D', 'E', '3', '9',
    '6', '6', '9', '1', '6', '4', '4', 'F', 'E', 'E', 'A', 'B', '4', 'C', '9', 'F',
    'B', 'F', '9', 'E', '7', '4', '7', 'E', '9', '1', '7', '9', '1', '8', 'D', 'F',
    'D', '1', '4', '2', '9', '6', '3', 'B', '5', '4', '9', '6', 'A', '4', '0', '3',
    '4', 'C', '6', '4', 'F', 'C', 'F', 'D', 'D', '8', 'F', 'D', '0', '8', 'F', '6',
    'F', 'E', 'D', '3', 'D', '2', 'C', '4', '6', '5', '2', '3', 'B', '9', '3', 'F',
    '3', '0', 'C', '1', 'E', 'C', 'C', '8', 'C', '8', '1', 'C', '6', 'D', '2', 'A',
    '9', '1', '1', '3', 'C', 'A', '1', '9', 'C', '0', '6', '1', 'C', '1', '6', '4',
    'E', 'A', '2', '6', 'B', '3', 'C', '2', '0', 'E', 'A', '5', '4', 'E', 'B', '1',
    '0', '9', '6', '2', '3', 'E', '1', '4', '3', '9', '5', 'F', '2', '1', 'F', 'D',
    '3', '3', '1', '1', '5', '6', '2', '0', '3', '5', '4', '3', '1', 'C', '7', 'C',
    'A', '0', '3', '4', '1', 'C', '0', '4', '9', 'A', '9', '1', '4', '5', 'A', 'D',
    '0', '4', '6', '7', '2', '4', '9', 'B', 'D', 'D', 'F', '0', '7', '7', 'B', '7',
    '0', 'C', '7', 'C', 'A', 'A', '9', 'A', '3', '4', 'F', '1', '6', '6', '4', '7',
    '1', 'E', 'E', '3', '5', 'E', 'B', '8', '1', '6', '3', 'C', '7', '0', '5', '4',
    '0', '9', 'E', '2', '8', 'E', 'F', 'D', '8', 'E', 'A', '5', 'D', '9', '0', '0',
    'F', '6', '4', '7', '0', '6', 'C', '9', '5', '5', '2', 'E', 'E', 'D', 'D', '5',
    'F', '3', 'E', '6', '7', '8', 'B', 'E', '8', '9', '5', '2', 'D', '8', '9', '2',
    'F', 'E', 'A', 'A', '7', '6', '2', '6', '0', '1', '9', '4', '4', '6', '3', 'C',
    'D', '8', '9', '1', '4', '4', '3', '3', 'A', 'F', 'B', '8', 'E', '8', '0', '2',
    '4', '8', '1', 'D', 'E', '8', 'D', 'D', 'B', '9', '6', 'C', '7', '3', 'C', '4',
    '5', 'B', '8', '9', 'F', '2', '0', 'A', 'F', '2', '0', '6', '8', '8', '0', '0',
    'B', '9', '9', '4', '7', '1', 'C', 'B', 'D', '1', '5', '3', 'B', 'C', '0', 'F',
    'F', '9', '7', 'C', 'A', '3', '9', 'A', '0', '2', '5', 'B', '5', 'D', '6', '7',
    'D', 'C', '8', '1', '9', 'E', '4', '4', '2', '7', 'D', '9', 'C', '8', 'F', '0',
    '6', 'B', '1', '0', 'B', '6', '5', '0', '7', 'B', 'A', 'B', 'E', '0', '1', '4',
    'B', '0', 'E', '0', '9', '0', '5', 'F', '0', 'A', 'D', 'E', '3', '4', 'B', '6',
    'C', 'D', '0', '7', '0', '3', 'B', 'E', '0', '2', '8', '2', 'B', '4', '7', '6',
    'A', '7', 'A', '5', '4', 'C', '7', 'F', 'E', 'E', '4', 'F', '2', '1', 'D', '1',
    '5', 'A', '2', '7', '8', 'F', '2', 'D', '1', 'A', '6', 'D', '8', 'B', '0', 'D',
    '3', 'F', 'E', '9', 'B', '0', 'C', '2', '6', '9', '9', 'A', 'B', '0', '6', '0',
    'B', 'E', '3', '6', '8', '9', '7', '1', '7', 'A', '8', 'E', 'D', '9', 'F', '3',
    '5', 'D', '6', '2', '5', 'D', '3', '2', '3', '2', '4', 'F', 'D', '0', 'D', '5',
    '1', '7', '2', 'E', 'F', '4', '5', 'C', 'F', '7', '8', '8', 'A', 'F', '8', '6',
    'F', '9', '5', 'E', '5', 'D', 'E', '4', 'F', '8', '9', 'A', '5', 'D', '3', 'E',
    '6', '0', '3', 'A', '4', '3', '2', 'B', 'A', '4', '4', '1', '8', '3', 'F', '5',
    '0', 'C', '0', 'A', 'A', '6', '4', '1', '6', '8', '8', '2', '5', 'A', '1', 'C',
    'F', '1', '4', 'E', '2', 'B', '8', 'F', '6', 'E', '2', 'B', '0', '9', 'C', '8',
    'D', '1', 'A', '2', '2', 'E', '9', '5', 'D', 'B', '7', 'C', '3', '9', '7', 'C',
    'D', 'D', '9', '8', '4', 'D', '0', 'E', 'D', '3', 'E', '3', 'B', '8', '0', '7',
    '7', 'A', 'B', '4', '4', '9', '6', '1', 'E', 'E', '1', 'D', '5', '9', '4', 'C',
    'E', '8', 'A', '4', 'E', '1', '7', 'E', '7', '1', '2', '7', '6', 'E', '7', 'C',
    '4', 'E', '8', '8', '3', '6', '4', '1', '6', '5', 'D', '7', '8', 'B', 'E', 'A',
    'C', '8', 'D', '4', '0', '8', 'E', '8', 'F', 'D', '8', '4', 'C', '9', '6', '4',
    'E', 'C', 'B', 'D', '4', 'C', '0', '8', 'E', '2', 'D', '9', '5', 'B', 'B', '1',
    '0', 'D', '8', 'B', '4', '9', 'E', '9', 'C', '2', 'D', 'F', '7', '1', 'E', '7',
    '2', '4', '4', '6', '6', '8', 'E', '5', 'D', 'C', '1', '3', 'E', 'F', 'F', '0',
    'C', '9', 'D', '8', 'A', '2', 'F', '3', '9', '1', '1', '8', 'D', '3', 'E', '0',
    '3', '9', 'B', '0', '2', '4', '7', 'F', '2', '7', '1', '7', '5', 'F', 'F', '2',
    'C', 'D', 'D', '8', 'D', 'A', '2', '3', '2', 'F', '5', 'B', '1', 'B', '3', '7',
    '4', '2', '1', '6', '2', '4', '6', '7', '4', '3', 'D', 'B', '9', '3', '1', '2',
    '0', 'D', '8', 'B', '1', '0', 'C', 'D', '9', '1', '1', '3', '4', '5', '6', '9',
    '3', '6', '5', '1', 'A', 'A', 'F', '1', 'E', '0', 'E', 'E', '1', '9', '2', 'C',
    '3', '8', 'B', '8', '6', '8', '0', 'B', '6', '0', 'A', '8', 'F', 'A', 'E', '2',
    '7', '9', '3', '8', 'B', '9', 'E', '4', 'C', '1', '3', 'B', '3', '4', 'C', 'E',
    'B', '7', '3', 'B', 'A', '1', '1', '5', '7', '6', '6', '6', '1', 'A', '9', '7',
    '9', 'C', '2', 'A', '8', '6', '1', '5', '0', 'B', '8', 'E', '5', '3', 'B', 'C',
    'F', '4', '3', 'D', 'E', '0', '5', 'E', 'F', 'B', '1', 'B', '5', 'E', 'C', 'F',
    '2', 'C', 'A', '5', '1', 'B', 'F', 'F', '9', 'B', '0', '9', '0', 'F', '1', 'A',
    'E', 'F', 'B', 'D', '3', '2', '0', 'E', '1', 'B', '4', 'C', '8', '0', '2', '7',
    '0', '7', '5', '9', 'F', '2', '8', '0', '5', '4', '6', '1', '9', '7', '5', '8',
    'B', '7', 'D', '9', '6', '7', '4', '6', '0', 'B', 'D', '7', '9', '2', 'F', 'F',
    '6', '3', '2', 'E', '2', '2', '7', 'B', 'D', 'F', 'E', '7', '8', 'F', 'B', 'A',
    'C', 'B', '1', '8', 'C', 'E', 'B', 'B', '6', '5', '3', '0', 'F', 'E', '6', '4',
    'E', '3', '2', 'A', '6', 'C', 'A', '9', '6', 'C', '9', '6', '0', '4', '2', '4',
    '3', 'A', 'D', 'F', '2', '8', 'E', 'F', 'D', '4', '9', '8', '3', 'C', 'B', '6',
    '5', '1', '1', '3', 'F', '2', '4', '8', '3', '9', '0', '1', '6', 'F', 'E', '5',
    '4', 'D', '7', '5', '9', '6', '4', '0', 'F', 'C', '9', 'B', 'D', 'B', '4', 'C',
    '5', 'A', 'A', 'F', 'E', '1', 'A', '8', 'A', 'C', 'A', 'D', '2', '6', '4', '2',
    '2', '3', 'D', '3', 'A', 'C', 'B', 'C', 'E', '5', '4', '1', '3', '3', '4', 'C',
    '2', 'A', '2', 'F', 'E', '5', '7', '5', '7', 'F', '5', '2', '0', '1', '3', 'F',
    '5', '0', '3', '5', '2', '0', '1', '7', '9', 'E', 'D', '8', '8', 'E', '2', '8',
    '3', '6', 'C', 'C', 'C', '5', 'F', '4', 'F', 'D', 'F', '3', 'D', 'E', '4', '8',
    '0', '1', '5', '7', '9', 'B', '1', '3', '1', 'D', '3', '4', 'E', '7', '5', 'B',
    '7', '0', 'C', '9', 'B', '2', '3', '3', 'E', 'D', '0', '0', '3', '3', '5', 'E',
    'B', '9', '9', 'A', 'A', '1', '9', '8', 'B', '2', '6', 'A', '3', '0', 'E', '3',
    'B', 'B', 'B', '8', '4', '7', '4', '0', '2', '0', '7', '0', '4', '3', '5', '6',
    '5', 'C', '6', 'D', '3', 'D', '0', 'F', '7', '0', 'A', '9', '1', '3', 'B', '7',
    '3', 'F', 'F', '8', '6', '1', 'F', 'E', 'E', '3', '2', '9', 'B', '2', '2', '1',
    '6', '1', 'F', '1', '4', '2', 'C', '3', 'C', 'A', '4', '6', '0', '3', '1', '5',
    'A', 'E', '0', '4', '5', '6', '0', 'D', '0', '4', '1', '9', 'E', '3', 'E', '0',
    'C', '8', 'A', '1', 'B', '9', 'D', 'C', '0', '1', '4', '2', '8', '6', '5', 'A',
    '4', '8', '5', '4', '7', '2', '3', 'A', 'E', 'A', '9', 'D', '8', '2', '7', 'F',
    'A', 'A', '4', '9', 'F', '0', 'C', 'C', '6', 'C', '8', '6', 'C', '0', 'A', '0',
    '4', '7', '5', '8', '1', 'E', 'F', 'F', '9', '3', 'A', 'A', '3', '2', '3', '9',
    'F', 'E', 'D', '4', '0', 'D', '4', '4', '4', '5', 'E', '3', 'D', '8', '4', '8',
    'C', '6', '5', 'A', '1', 'C', '2', 'A', '0', '9', '0', '1', 'E', 'A', '3', '4',
    'F', 'E', '1', '4', 'D', '0', 'A', '2', '4', '0', '6', '0', 'C', '7', 'F', '7',
    'F', 'E', 'C', '5', '9', '6', '0', 'B', 'E', '6', '7', '5', 'D', '5', '7', '0',
    'D', '9', '4', 'F', '5', 'C', 'B', '7', '2', 'D', 'E', 'A', '7', '0', '9', 'E',
    'E', '3', '8', '6', 'D', '4', '2', '1', 'C', 'D', '5', 'B', 'D', '9', '1', '1',
    'E', 'A', 'D', '2', 'F', 'A', '3', '4', 'D', '5', 'C', '5', '2', 'E', 'E', '7',
    '8', 'C', '1', 'F', '0', '1', 'C', 'D', '7', 'D', 'E', 'A', '2', 'B', '8', 'E',
    '8', 'C', '7', 'C', '4', '4', '0', 'C', 'C', 'B', '6', '1', '8', '1', '5', 'F',
    '8', 'F', '7', '5', 'A', '3', '4', '3', '3', '8', 'D', 'F', '7', '0', '0', '0',
    '2', '9', '4', 'C', '3', 'D', '7', '5', 'D', '7', '6', 'E', '0', '6', 'A', '7',
    '9', 'E', '9', '2', '4', 'B', 'C', 'B', '5', '1', '3', 'B', 'A', 'D', 'D', '1',
    '9', '3', 'A', '6', '0', '8', 'D', '4', 'E', '0', '4', '7', '1', '7', 'A', '2',
    '0', '0', '9', '9', '5', '1', 'A', 'D', '8', 'A', 'E', '9', 'D', '2', '5', '5',
    'C', '6', '8', 'B', 'A', '8', 'D', 'D', '7', '2', 'F', 'B', '0', '8', '6', 'E',
    '9', '2', 'E', '8', '5', 'E', '6', '9', '6', '4', 'C', '6', '8', 'C', '5', 'E',
    '6', '5', 'F', 'D', '1', 'A', 'C', 'A', 'E', '6', '4', '1', '1', '6', 'A', 'D',
    'E', 'D', '7', 'B', '7', '0', '3', 'D', 'B', '7', '5', '3', '2', 'E', 'A', '5',
    'A', '1', 'E', '1', '0', '2', 'B', '6', '9', 'F', 'F', '5', 'C', '4', '2', '4',
    '0', '3', 'A', '3', '5', '7', '4', '3', '5', '7', '0', '0', '4', 'E', '1', '0',
    '5', 'C', 'C', '1', '2', '7', '9', '5', '8', 'B', 'D', 'F', '7', '9', '7', '5',
    '5', '3', '9', 'A', 'D', '4', '8', 'E', '1', 'F', '1', 'B', '7', '4', 'F', '9',
    'C', 'D', 'E', '7', '9', '7', '5', '7', 'D', '6', 'A', 'D', '1', 'E', 'C', 'F',
    '7', '3', '7', '5', '9', 'A', '7', '5', '2', '5', 'B', '2', 'D', '4', 'E', 'B',
    '4', '4', '5', '1', 'C', 'A', '1', 'C', '6', 'B', '1', '9', 'E', '4', 'A', '4',
    '2', '3', 'D', '5', '2', '1', '1', '2', 'B', 'C', '6', 'D', '0', 'F', 'C', 'C',
    '6', 'D', '0', '0', 'F', '9', 'C', 'F', '9', 'E', 'D', 'B', '8', '3', '4', '8',
    '2', '7', '7', '6', 'E', '9', '4', 'E', '3', '8', '3', '7', '2', '1', '0', 'C',
    'F', 'F', '5', 'A', '1', '0', 'E', 'F', '1', 'F', 'F', '9', 'B', 'C', '4', '5',
    '3', '5', '2', 'F', '8', 'C', 'D', '6', '3', '8', 'C', '5', 'E', '4', '3', '0',
    '9', '3', '4', '7', '0', '6', '7', 'C', '1', 'C', 'B', '3', '9', '8', '4', '0',
    '2', '1', '1', '9', '2', '9', '4', '7', 'D', '0', '3', '0', '5', '7', '0', '3',
    'C', 'F', 'A', '6', '2', 'F', '8', 'E', '6', '2', '9', '7', '6', '1', '5', '4',
    'E', '5', 'B', '3', '5', '8', '0', 'F', 'B', '8', '0', 'A', '8', '1', 'C', 'F',
    '8', '9', '3', '5', '4', '2', '2', '0', '5', '2', '1', '1', '6', '2', 'B', 'C',
    'E', 'F', '1', '8', '7', 'A', '5', '5', 'F', 'E', '3', '1', 'F', '9', '4', '8',
    'A', 'C', '3', 'C', '9', '2', '3', 'B', '5', '4', '3', '4', 'C', '2', 'E', '3',
    '8', '5', '5', 'B', 'C', '3', 'D', '9', 'C', '3', '8', 'C', '5', '6', 'A', '8',
    'A', '0', 'C', '0', '5', 'D', 'C', '0', '8', 'A', '8', '8', '9', 'B', 'D', 'E',
    '8', '4', '5', '3', 'D', '2', 'F', '0', 'C', '0', '7', '3', '5', 'F', '3', '5',
    '0', '4', '3', '6', '2', '1', 'E', '6', '3', 'D', 'D', 'E', 'C', '6', '3', '2',
    'B', '8', 'A', '6', 'F', 'D', '2', 'C', '6', '6', 'F', '7', '4', '9', '7', '4',
    '9', 'E', '2', 'C', '2', 'F', '7', '8', '9', '3', '3', 'E', 'A', '9', '1', '0',
    'F', '1', '6', 'C', '4', '1', '3', '5', 'D', 'B', '6', '7', 'C', 'C', '8', 'A',
    '1', '8', 'E', 'D', 'A', '9', 'D', '9', '8', 'D', 'B', '5', 'D', '6', 'C', '4',
    '5', '8', '2', '1', 'B', '8', '9', '5', '1', '7', '1', '5', 'E', '8', 'F', 'D',
    'D', 'D', 'E', 'A', '0', 'B', '3', '9', 'C', '3', '3', '2', 'B', 'A', '7', '1',
    'C', 'C', '3', '9', 'F', 'D', '0', 'F', 'B', 'E', '4', 'F', '4', 'E', 'D', 'D',
    '2', 'A', '4', '1', 'F', '8', '4', '8', '8', '4', '5', '0', '1', 'B', '2', 'A',
    '6', '4', '1', 'F', 'C', '0', '6', 'D', 'A', '6', '8', 'D', '9', '0', '5', '1',
    '9', '6', '7', 'F', '0', '9', 'A', 'D', 'C', '8', '1', '5', '0', '5', '0', '4',
    '3', '7', 'D', 'A', 'E', 'B', 'F', 'F', 'D', '7', '9', '8', '1', '9', '0', '6',
    '1', '8', '9', '9', '5', '4', '7', 'C', 'D', 'B', '9', '6', '9', '6', 'B', 'D',
    '8', 'B', '3', 'D', '9', 'A', 'E', 'B', 'A', '7', 'B', '3', 'C', 'F', '1', 'F',
    'F', '1', '5', 'C', '5', '9', '1', '4', '7', '6', '5', 'F', '8', 'B', 'A', '0',
    'A', 'E', '2', '3', '6', 'E', '4', 'F', '2', '4', 'D', '7', 'B', '7', '2', '5',
    '6', 'C', '9', '9', 'F', '7', 'D', '6', 'D', 'E', '6', 'B', 'E', 'A', 'E', 'B',
    '8', '8', 'D', 'A', '1', '1', 'A', 'A', '2', '1', '3', '7', '8', 'B', 'F', 'D',
    '0', '5', '9', '2', '2', '7', '2', 'B', '4', 'A', 'B', '7', 'D', 'C', 'D', 'B',
    '7', '5', '3', 'D', 'E', '8', 'E', '8', 'C', 'F', '6', '1', '1', '1', 'F', '0',
    'B', '0', 'A', '0', 'D', 'F', '3', '6', '3', '6', 'A', '1', 'E', '6', '7', '7',
    '2', '2', '9', '4', '6', 'B', '7', 'E', '9', '8', 'F', '2', '3', 'A', 'B', '8',
    '6', '5', '3', 'B', 'E', 'A', '9', '3', 'E', '4', '2', 'E', '1', '1', '1', 'C',
    '3', '4', 'B', 'A', '2', 'E', 'C', 'F', '2', '8', '9', '6', '8', '4', '7', '2',
    '3', '1', '6', 'D', '9', '9', '7', 'E', '0', 'D', '8', '9', 'A', '7', '9', 'A',
    '1', '4', '6', '9', 'F', '5', 'C', '2', '4', '5', 'B', '6', '7', '2', 'E', 'C',
    '8', '1', '5', 'B', '5', '8', 'B', 'B', '6', 'C', '3', 'E', 'D', '0', 'A', '0',
    'E', '9', 'C', 'F', '3', 'F', '1', 'B', '5', 'D', '8', '8', '6', 'D', 'C', '5',
    '2', 'C', 'B', '3', '8', '2', 'F', '3', 'F', '1', 'B', 'A', 'D', '4', 'A', '4',
    '4', '5', '6', '8', '7', '4', '6', '3', 'F', '6', '3', 'C', '6', 'B', 'E', '4',
    '0', 'D', '6', 'A', '9', '7', 'E', '0', '4', '2', '8', '2', 'D', 'B', '7', '5',
    '3', '7', '1', '4', '3', 'D', 'B', '4', '4', 'D', '9', '1', '2', 'A', '3', '7',
    'E', '9', '4', 'F', '3', '2', 'D', 'F', 'C', 'D', '6', 'F', '2', 'E', '6', 'A',
    '6', '4', 'F', '4', 'A', '9', '8', '3', '7', 'C', '0', '0', '7', '2', 'D', 'F',
    'F', '0', 'A', 'B', '8', '1', 'E', 'B', 'E', '3', 'A', '7', '1', '2', '5', 'C',
    '7', '4', 'B', 'D', '0', 'D', 'C', '5', '9', 'E', '4', 'D', '4', '2', '0', '4',
    '9', '7', '5', '0', '1', 'D', '8', '2', 'F', '1', '7', '3', 'F', '0', '4', 'F',
    '9', '7', 'B', '0', '2', '6', '5', 'E', 'C', '1', '6', '4', '8', 'B', '6', 'E',
    '6', '8', 'B', '5', '9', '8', 'D', '5', '4', '1', '3', '7', '1', '6', 'C', 'B',
    '1', '9', 'C', 'F', '9', '8', '4', '8', '5', '5', '1', '2', '7', 'E', '7', '1',
    '4', '0', 'F', 'A', '0', '4', '2', 'F', '1', '1', 'D', '5', 'F', 'A', '5', '2',
    '7', 'C', 'F', '6', 'B', '4', '3', 'A', '9', '4', '3', 'C', 'B', '7', '5', 'E',
    'D', '8', '3', 'A', 'A', '9', '6', 'D', 'D', '2', '9', '8', 'E', '8', 'A', '4',
    'D', '9', '9', '3', 'D', '7', '0', '4', 'B', '9', '2', 'A', 'E', '8', 'A', 'A',
    '4', '2', '7', '6', '9', '2', '6', '7', '4', '5', 'C', '0', 'A', '2', 'D', 'A',
    'A', '6', '6', 'E', '4', '7', '5', '0', '2', '5', '8', '4', '4', 'D', 'F', '3',
    '7', 'D', 'A', 'E', '1', 'F', '3', '9', '9', 'B', '3', 'D', '6', '9', '3', '8',
    '8', '6', '7', 'F', 'A', 'F', '2', '6', '3', '7', 'D', '8', '3', '3', '1', 'B',
    '8', '8', '3', '1', '0', '9', 'E', '7', 'F', '3', '1', '7', '9', '5', 'B', 'D',
    'F', '6', '0', '8', 'D', '1', '9', 'B', '3', '1', 'F', 'C', '1', '6', '5', '2',
    'A', '8', 'A', '4', '1', '8', '0', '4', '1', '6', '5', 'E', '0', 'F', 'C', 'F',
    '9', '9', '5', '9', '0', 'C', 'B', 'C', '4', 'D', 'F', '1', '3', '0', '1', 'B',
    '0', '9', '3', 'A', '5', '4', '2', '2', 'A', '9', 'D', '6', '6', '9', 'F', 'E',
    '3', 'B', '6', 'D', 'B', 'E', 'C', '3', '8', '4', '4', 'A', '6', 'E', '0', '3',
    '0', '2', 'D', '6', 'F', '7', '1', '4', '7', 'A', '7', '0', 'C', 'F', 'B', '2',
    'A', 'E', 'A', '0', '9', '8', '3', '1', '3', 'B', '1', 'E', 'B', '1', 'E', 'F',
    '0', '2', '9', 'D', 'E', '5', '5', 'B', '5', 'E', '5', '5', '9', '3', '7', '2',
    '8', 'D', '6', '2', '3', 'E', '8', '4', 'E', '5', 'F', 'A', '3', '7', '4', '0',
    'B', '0', 'D', '0', '3', '2', 'A', '4', 'F', 'F', 'F', '3', '7', '0', '7', '8',
    '2', '6', '6', '4', '8', '6', '8', '7', '6', 'A', '1', '9', '7', '3', 'A', '1',
    '9', '0', '7', 'E', '8', '6', 'D', 'E', 'A', '3', '6', 'F', '3', 'A', '4', '2',
    '8', '0', 'F', 'A', '5', '6', '3', '4', '5', '4', '1', 'E', '1', '3', '0', 'A',
    'B', 'D', '3', 'B', '9', '4', '5', '4', '4', 'F', 'E', '7', '4', 'B', '1', '7',
    'E', 'F', 'D', '1', 'F', '8', '7', 'D', '8', '4', '3', '4', '2', 'A', '8', 'D',
    '4', 'E', 'D', '5', '2', 'F', 'F', 'B', '5', '0', 'E', '8', 'A', '1', '5', '9',
    '6', '9', '3', '3', '7', '7', '0', '2', '6', '9', 'A', '6', '3', '4', '4', 'C',
    '4', '6', 'F', 'F', '9', '0', 'B', 'B', '3', '1', 'C', '9', '2', '1', '2', '7',
    '9', 'C', 'C', '2', '5', 'D', '3', 'B', 'D', '6', 'D', '5', '8', '3', '5', '1',
    '0', '7', '0', 'A', 'D', '8', 'A', '8', '2', '3', '0', 'E', '0', '4', '5', '2',
    '1', '5', '7', 'F', 'D', '9', '5', 'F', 'D', '9', '7', 'B', 'D', 'B', '4', '9',
    'B', 'C', '6', 'A', '6', 'D', '7', '3', '2', 'A', 'C', '1', '1', '5', 'C', '4',
    '0', '7', 'B', '4', '8', 'F', 'C', '0', 'C', '5', 'E', 'C', '2', '0', 'A', '1',
    'E', '3', '5', '4', 'C', '4', '9', '8', '6', 'D', '4', 'F', '3', '9', 'A', '8',
    '9', '9', 'E', 'D', '0', '1', 'D', 'B', '9', '2', '0', '5', 'D', '1', 'A', 'A',
    'F', '9', 'C', 'B', '7', 'F', 'B', '6', '6', 'D', '9', '3', '0', 'B', '6', '7',
    '0', 'D', '9', '3', '1', '2', 'E', '2', 'A', 'A', '1', '2', '6', '4', '4', '5',
    '9', '9', '8', '9', '8', 'A', '9', '0', '6', '3', '7', 'B', '9', 'A', 'E', 'C',
    '0', '9', 'E', 'E', 'B', '5', '2', '8', 'E', '4', 'F', 'B', '9', 'D', 'C', 'F',
    'F', '7', '8', 'F', '0', 'C', 'E', '0', 'B', '6', 'D', 'A', 'B', 'A', '9', 'A',
    'B', '3', '8', '5', '1', '1', '3', '2', 'A', 'D', 'A', '8', '6', '9', '6', '4',
    '6', 'C', '3', 'E', 'A', 'F', '9', '9', 'B', '7', 'D', '9', 'A', '4', '7', '5',
    '1', 'C', '8', '8', '8', '3', '8', 'A', '5', '3', '2', '5', 'C', 'F', '7', '1',
    'B', 'C', '2', '7', '5', '6', '0', 'C', 'B', '8', 'D', 'E', 'B', '5', '0', '8',
    '5', '2', 'B', '0', '7', '2', '3', 'D', 'B', '1', '1', 'F', 'C', '5', '9', '7',
    'D', 'D', '2', '7', 'D', '4', '6', '6', 'F', 'E', '4', 'F', '3', '7', 'E', '0',
    '1', 'D', 'D', 'D', '6', '4', '6', '2', 'E', 'A', 'B', 'C', '3', '3', 'B', '8',
    'B', '2', 'A', 'F', 'C', '5', '3', 'B', '2', 'A', '1', 'F', 'B', '2', '6', '7',
    '6', 'B', 'C', '9', 'D', 'E', '0', '6', '0', 'D', '5', '1', '8', 'E', '6', '6',
    '0', '6', '4', 'B', '9', '5', 'A', 'D', 'B', '8', '8', 'E', 'A', 'B', '2', 'D',
    '5', 'F', '8', 'F', 'B', 'B', 'F', '8', '2', '1', 'A', '7', '9', '1', 'C', 'E',
    '1', '1', '5', 'C', 'F', 'D', 'C', 'B', '3', 'B', '5', '4', 'E', 'B', '5', '9',
    '5', '7', '5', 'B', '2', '6', 'A', '0', 'F', '6', '9', '7', 'F', '7', '4', '9',
    '0', '3', 'F', 'B', 'D', '2', '8', '9', 'C', 'F', '3', 'A', '8', 'A', '9', '9',
    '7', '8', '9', '9', 'C', '6', 'D', 'F', '0', 'F', '8', '5', '9', 'E', '3', '0',
    '4', '9', '2', 'F', 'C', '2', 'E', 'A', '9', '2', 'F', 'A', 'E', 'C', 'F', 'A',
    'A', '3', '3', '6', 'D', 'E', '0', 'B', '3', 'A', 'C', '4', 'D', '8', 'E', 'B',
    '0', '3', '2', '7', 'C', 'C', '1', 'E', '5', '3', '6', '3', 'A', '3', 'F', '6',
    'B', '7', '5', '6', '8', '3', '0', 'B', '9', '2', '8', '2', '7', 'C', '4', '2',
    '8', 'A', 'C', 'B', 'C', '5', '0', 'B', 'B', 'B', '4', '0', '6', '7', '5', '9',
    '4', '7', 'A', '0', '2', 'D', '1', 'B', '3', 'F', 'B', 'A', '1', 'A', 'F', '5',
    '3', '5', '5', 'E', '9', '7', '9', 'B', 'C', 'B', '8', '6', 'D', '9', 'D', '2',
    '4', '3', '2', '2', '1', '4', 'A', '5', '0', '6', 'C', 'C', '2', '9', '8', '8',
    'A', 'A', '3', 'D', '5', '7', '9', '9', '3', 'C', '4', '4', 'B', 'F', '8', 'E',
    'A', '5', 'D', 'D', '7', '8', '7', '2', 'E', '2', 'A', 'C', 'A', '9', '8', '7',
    'D', '6', 'A', '0', '2', '4', '8', 'E', '2', 'D', 'F', '5', '7', '5', '0', '8',
    '4', '5', '8', 'B', '4', 'E', 'E', '9', '0', '9', 'B', '2', '9', 'A', '5', '0',
    '9', 'A', '3', 'E', 'A', 'E', '5', '5', 'E', '4', '9', '8', '3', '7', '0', 'E',
    'C', '6', '1', 'A', '8', '9', 'A', 'F', 'F', '2', '3', 'D', '0', '1', '6', '4',
    'C', 'B', '5', '0', 'B', '8', '1', '8', 'A', '9', 'C', '8', 'E', '8', '5', '9',
    '5', 'D', '7', 'C', 'A', 'D', 'D', 'F', '6', 'E', '0', '2', '4', '0', '6', '5',
    '1', '1', 'B', 'E', '6', 'B', '1', 'D', 'E', '1', '2', 'F', '0', '7', 'A', '3',
    'E', '8', '8', '4', 'B', '3', 'F', 'C', '9', '0', '9', 'A', '9', 'E', 'C', '3',
    '4', '8', 'C', 'C', '4', '2', '0', '6', '4', 'F', 'C', '5', '6', '6', 'A', '8',
    '4', '4', 'F', 'B', '7', '3', '2', 'D', 'E', '3', '2', '5', '1', 'A', 'C', 'F',
    '2', 'C', '7', '9', 'A', '7', 'C', '9', '6', 'F', '3', '3', '9', 'B', '1', '6',
    'F', 'D', '0', 'C', 'F', '1', '0', '0', '2', '1', '2', '4', 'E', 'F', 'F', '4',
    '0', 'B', '1', '8', 'D', '4', 'E', '7', 'C', 'A', '3', '2', '7', '8', '9', 'A',
    '8', 'B', 'D', '6', '3', 'A', 'F', '7', '3', '7', '1', '8', '6', 'B', '7', '4',
    '5', 'C', '8', 'F', 'F', '9', '5', '2', 'B', '1', '8', 'F', '1', '7', 'E', '7',
    'F', 'E', '2', 'A', '0', '0', '4', '7', '2', 'A', '3', 'B', '0', 'B', '1', '8',
    'E', '8', 'B', 'A', 'A', '9', '2', '5', '8', '4', 'D', 'A', 'E', 'D', '8', '9',
    'C', '6', 'B', '5', '1', 'E', 'C', 'F', '3', 'B', '0', '4', '2', 'B', '3', 'F',
    '0', '2', 'D', '1', '4', '2', 'C', '9', '7', '6', '3', 'D', 'D', 'C', 'E', '3',
    'E', '5', '2', 'C', 'E', 'E', 'B', '1', '9', '9', '0', 'C', 'E', '8', '0', '2',
    '5', '6', 'E', '4', '0', 'A', 'C', 'A', '1', '2', 'D', '3', '9', '9', 'E', '9',
    'C', 'F', 'D', '5', '6', '9', 'E', '9', 'B', 'B', '3', 'C', 'F', '1', 'A', 'A',
    '3', '1', '9', '1', '3', '8', 'A', 'D', '2', '2', 'A', '4', 'D', 'D', '6', '1',
    '9', '4', '0', 'C', '9', '8', 'B', '0', '2', '0', '4', '1', 'C', '9', 'C', 'D',
    'F', '7', '6', 'A', 'B', 'B', 'D', '9', '7', '9', 'A', 'D', '6', 'C', 'C', 'D',
    'B', 'B', '7', '1', '8', '1', '9', 'C', 'D', 'B', '2', '1', '8', 'E', '6', '7',
    'C', '0', 'B', '7', '4', '2', 'B', 'B', '9', 'B', 'C', '2', 'D', '6', 'A', 'D',
    '9', '3', 'E', '4', '1', '5', '5', '8', '0', '0', 'A', '2', '9', '5', '9', '4',
    '7', 'B', '2', 'B', '4', 'F', '7', '8', '1', '3', '5', '1', '7', 'D', 'C', 'C',
    '3', '2', '8', 'E', '3', 'D', '2', '1', '2', 'F', 'B', 'E', '9', '4', 'B', '0',
    '0', '6', '5', '9', 'F', 'A', '3', '3', '3', '0', '2', '0', 'E', '0', '0', '1',
    '9', 'C', '1', '2', 'D', 'E', '1', '6', 'F', 'F', '7', '5', '9', '4', '3', '8',
    '4', '2', '4', '2', '0', '6', '2', '5', 'B', '4', 'A', '3', '5', '8', 'D', 'D',
    '9', '6', '0', 'D', '9', '8', 'E', '8', '8', '9', '2', '7', 'D', '6', 'D', '2',
    'B', 'D', 'A', '5', '2', 'F', '7', 'F', '1', 'D', '4', '2', 'C', '4', '4', 'E',
    '6', '2', '7', '2', '9', '6', '2', '6', '5', '5', 'D', 'C', '8', 'C', '8', '9',
    'A', '6', '6', '6', 'E', 'A', '5', '6', '2', '9', 'F', '1', '3', '1', '6', 'F',
    'D', 'B', '5', '9', 'D', '5', '4', '9', '2', '6', '2', '3', 'A', 'C', 'B', '9',
    '0', '9', 'F', 'E', '4', '0', 'F', 'E', '8', '7', 'C', 'B', '5', '3', 'F', '2',
    '2', '3', '5', 'C', '8', '2', 'E', 'A', 'A', '4', '0', 'D', 'F', '6', '0', '3',
    '3', '2', 'E', 'A', '2', '4', 'A', 'B', 'D', '7', '4', '3', 'E', 'D', 'C', '4',
    '6', '1', '6', '7', '4', 'D', 'B', '1', '1', '5', '0', 'A', 'F', '5', '7', '4',
    'A', 'C', '7', 'C', '5', 'F', '8', 'A', '7', '8', '2', 'B', 'B', 'E', '1', '6',
    'C', '6', 'F', '7', 'A', '7', '9', '0', 'D', '1', 'B', '1', 'A', '0', '2', 'B',
    '7', '3', 'D', '6', 'C', 'F', 'E', 'C', '0', 'D', '0', '3', '1', '9', '7', 'A',
    '3', '0', '5', 'E', '9', 'A', '9', '5', 'F', '9', '1', '0', '9', 'E', '2', '9',
    '8', 'E', 'F', '1', '7', '7', '5', 'A', '6', 'D', 'C', 'F', '1', '6', '9', 'D',
    'B', 'B', 'B', '1', '8', 'A', '6', '3', '9', '0', 'E', 'F', 'F', '9', '9', 'B',
    'E', '0', '3', '1', 'F', '8', 'A', 'C', 'A', '2', '2', '3', '3', '1', '2', '8',
    '3', 'A', '0', '7', '7', 'A', '7', '6', '6', '5', '0', 'B', '0', '6', 'B', '3',
    'D', '9', '6', '5', '8', 'A', '8', 'F', '0', '8', '7', '0', 'A', '2', 'E', '5',
    'F', 'D', 'D', 'D', 'B', '4', 'A', 'E', '8', 'E', 'D', 'B', '9', 'C', 'B', '2',
    '7', '9', 'F', 'B', '8', '5', '1', 'A', 'D', 'D', 'D', 'F', '7', '4', '5', 'C',
    '8', '7', '8', 'B', '6', '3', '8', '2', '8', '3', 'B', '6', 'E', 'C', 'D', 'B',
    'C', 'C', '7', '4', '3', '1', '8', '7', '9', 'C', '1', '5', '0', 'C', 'A', '8',
    'C', 'D', 'E', 'E', 'D', '1', '4', '4', '2', '5', 'D', 'F', 'C', 'E', '7', 'F',
    '0', 'B', '0', '9', 'A', 'B', 'F', '9', '1', '2', '6', '8', '5', '3', 'D', 'B',
    '0', '6', 'A', '8', '2', '1', '4', '3', 'A', '3', 'D', '8', 'F', 'D', '2', 'F',
    '5', 'D', 'B', 'D', 'D', '5', 'F', 'A', '3', 'C', 'F', 'E', '4', '2', '5', 'C',
    'C', '5', '6', '4', '9', '8', '4', '6', 'E', '4', 'A', '7', 'A', '0', '5', '1',
    'A', '3', '4', '0', '0', '7', '9', '0', 'F', '8', '3', '9', '6', '7', 'F', '6',
    '6', 'E', 'A', '6', 'D', '8', 'B', '8', '0', '2', '9', '6', 'E', '0', 'A', '9',
    'A', '5', '8', 'D', 'A', '9', '2', '3', '7', '4', '4', '8', 'E', '9', '3', 'F',
    'F', '4', '2', '9', '8', 'C', '4', '1', '9', '8', 'A', '2', '7', '9', '4', 'F',
    '9', '5', '5', '6', 'F', '1', '4', '1', '6', '1', '5', '6', '7', '5', '6', 'F',
    'C', 'F', '6', '8', 'F', 'C', 'A', '8', 'F', '0', '6', 'E', '5', '0', '2', '5',
    'A', 'A', 'E', '4', '9', '8', '0', 'C', '9', '3', 'A', '7', 'F', '9', '8', 'D',
    'D', '1', '0', '4', '4', 'E', 'F', '2', '6', '1', 'A', 'E', 'B', 'C', 'A', '5',
    'B', '2', '6', 'F', '2', '7', '1', '5', 'D', '0', '9', 'E', 'C', '2', '8', 'A',
    '2', '8', '4', 'B', 'B', '0', '3', '1', '2', '9', '9', '3', 'A', 'D', 'E', '8',
    'D', '0', 'A', '2', '8', '2', '3', '7', 'F', '0', '1', '0', 'D', 'E', '0', '4',
    '3', 'D', '3', 'D', '0', '0', '5', '4', 'C', '6', '9', '1', 'E', '7', '3', '6',
    '4', '7', 'C', '8', 'B', 'F', 'C', 'E', '4', 'D', '9', '7', '4', '5', '1', 'C',
    '0', '3', 'F', 'A', '4', 'A', 'D', 'B', '0', 'A', '5', '3', '9', '3', '7', '0',
    'B', 'E', '9', 'C', 'D', '4', '1', '8', '9', 'F', 'C', '8', '3', '8', 'D', '3',
    '7', '6', 'E', '3', '7', '8', '5', 'B', '6', 'F', 'F', '5', '8', '3', '0', 'D',
    'A', '9', '5', '9', 'A', '5', '1', '4', '0', '9', 'B', '0', 'E', 'E', '9', 'B',
    '3', '5', '3', 'C', '0', 'A', 'C', 'C', 'A', '6', 'E', '0', '2', '1', 'D', 'C',
    '9', '4', '3', '0', 'B', '6', '7', '8', '5', 'E', '6', 'C', 'D', '3', 'D', 'B',
    '1', 'A', 'E', '9', 'A', 'B', '1', '3', 'B', 'E', '5', '2', 'E', '5', '1', 'F',
    '4', 'B', '2', '5', '9', 'D', '4', '7', 'B', '7', '1', 'D', 'A', '0', 'A', 'B',
    '6', 'D', '9', '9', 'A', 'F', '9', 'B', '4', 'A', 'A', '2', 'A', '7', '9', '3',
    'D', 'A', 'E', '6', '9', '0', '4', '2', '6', '3', '9', 'F', 'C', 'A', '3', '1',
    '3', '3', 'B', 'C', '9', '9', 'C', '7', 'D', 'E', 'C', 'A', '9', '1', '5', '0',
    'F', '7', '1', '7', '1', 'D', 'D', '9', '9', 'C', '9', '7', '0', '0', '7', 'E',
    '6', '4', '4', '3', '1', '6', 'A', '0', 'B', '8', '6', '2', '0', '9', '1', '7',
    'D', '8', '3', '6', 'C', '0', '6', 'D', '3', 'F', 'D', '2', '6', '8', 'F', '5',
    '8', '0', 'D', '6', 'E', '7', '1', '7', '1', '1', '6', '7', 'A', 'A', '4', 'E',
    'E', '0', '3', '7', 'B', '4', 'F', '0', '8', 'B', 'F', 'A', 'F', 'F', '2', '6',
    '7', '8', 'F', '4', '3', '0', '6', '2', 'D', 'F', 'B', 'D', '7', 'E', '2', '3',
    '5', '5', '4', '0', 'B', '0', 'B', 'E', '3', '5', '4', 'C', '6', '4', 'D', '9',
    '7', '0', '0', '4', 'F', 'C', '4', '1', 'E', 'C', '4', '2', '8', '5', 'B', '5',
    '8', 'A', 'F', '4', 'B', 'B', 'F', '0', '1', '0', '5', '9', 'B', '6', 'B', '3',
    '4', '3', '6', '9', 'F', '1', 'E', 'E', 'A', '8', '5', '7', 'E', '2', '0', 'A',
    'D', '3', 'C', 'D', '7', '5', 'B', '4', 'E', 'F', '0', '1', 'D', '6', '1', '6',
    'A', 'E', '8', '3', '8', '6', '9', 'F', '0', 'E', 'E', '0', '9', '4', '8', '8',
    '9', 'B', 'D', 'A', '5', '6', '8', '3', 'C', '0', '5', '3', 'A', '1', '2', 'B',
    '0', '8', '3', '5', 'B', '8', 'C', '7', '5', '7', '6', '6', '6', '4', 'E', '2',
    'F', '0', 'B', 'C', '6', '6', '4', '9', 'F', 'F', 'A', 'E', '8', 'F', 'D', '2',
    '1', '5', 'B', '7', '1', '1', '1', 'A', '7', '5', '8', '7', '3', '1', '6', 'D',
    '0', '9', 'D', 'C', 'C', '3', 'C', '0', '2', '1', '4', '3', '3', 'F', '5', '5',
    'B', '1', '8', '4', '4', 'C', '3', 'F', '3', 'A', '2', '8', '0', '8', '0', 'F',
    '8', 'D', '7', 'E', 'B', 'A', 'A', 'B', '8', '4', '0', '6', '5', '2', '9', 'C',
    'E', 'B', 'C', '7', '9', '6', 'C', 'A', '2', '6', '5', '3', '5', '3', '2', '3',
    'D', 'D', '3', 'A', '9', '8', 'E', 'F', 'A', '3', '7', 'E', '4', 'D', '9', '2',
    'C', 'A', '5', '1', '8', 'A', '3', '7', '8', '1', '5', '8', '5', 'B', '4', '3',
    '4', 'D', 'E', '6', 'C', '2', '7', '9', 'A', '0', '2', '0', 'A', 'B', '3', '3',
    '1', 'D', '0', 'E', 'C', '9', '2', 'D', '1', 'B', '8', '8', '8', '4', 'C', '6',
    '5', 'E', '5', '2', '6', '9', '0', '8', '0', 'B', '9', '7', '4', 'A', '8', '3',
    '7', '8', 'F', '1', '6', '1', '3', 'F', 'C', 'F', 'C', '4', 'F', '3', '4', 'E',
    '3', '3', 'F', 'B', '0', '0', 'A', '0', '0', 'B', 'B', '1', '4', '7', 'C', '1',
    '5', 'F', 'A', '1', 'C', '7', 'F', 'D', '5', '7', 'B', '0', 'B', 'C', '9', 'E',
    'B', '3', 'C', 'F', '6', '5', '5', '6', '5', 'E', 'C', '3', '7', '8', 'E', '8',
    '6', 'C', 'A', '1', 'C', '3', '4', '8', 'D', '2', '4', 'B', '8', '0', '4', 'A',
    '8', '4', 'B', '3', 'B', '0', '4', '2', '5', '6', 'D', '4', '5', '5', 'A', '8',
    '6', '5', 'D', '4', '2', 'B', 'E', '7', '3', 'A', '5', '4', '5', '0', '8', '7',
    '1', '1', 'C', '6', '2', 'B', 'C', '7', '9', 'A', 'C', 'C', 'E', '9', 'A', '8',
    'B', '7', '6', '9', '5', '3', '8', 'C', '1', 'B', 'F', '0', 'E', '8', '7', '3',
    '1', '3', '0', 'D', 'D', '0', '6', '0', 'A', '6', '4', 'C', '7', '1', 'E', 'C',
    '1', '7', '2', '8', 'F', '7', '4', '3', 'C', 'C', 'B', 'A', 'C', '3', '1', '4',
    '7', '5', 'F', '6', '5', '9', '8', 'E', '5', 'B', 'F', 'C', '1', 'E', '3', 'A',
    '2', '6', '1', '1', 'B', '6', '1', '7', '2', '2', '1', '3', '4', '5', '8', '5',
    'C', 'F', '9', '7', '3', 'B', '4', '1', '1', 'E', 'E', '7', '5', '4', 'C', '2',
    '5', 'E', '7', '6', 'B', 'B', 'A', 'B', '8', '6', '2', 'C', 'D', 'B', '3', '4',
    'A', '2', 'A', '2', '5', 'B', 'F', 'B', '3', '3', 'D', 'D', '0', '3', '5', '4',
    'B', '4', '7', '3', 'E', '1', '3', '2', 'B', '1', '8', 'C', '2', '7', 'B', '0',
    '4', 'B', 'C', 'B', '4', 'E', '0', '7', 'B', 'C', '4', '7', '2', 'F', '5', '8',
    'F', 'F', '7', '8', 'A', 'F', '5', '0', '6', 'D', 'F', '2', '6', 'E', '3', 'E',
    'D', '1', 'B', '0', '1', '4', '1', '7', 'D', 'A', 'F', '7', '4', '7', 'E', 'C',
    '1', '0', 'D', 'E', '4', '5', '1', 'C', 'F', 'F', 'B', '2', '5', 'F', '9', '7',
    '0', '6', 'B', 'E', '8', '0', '7', '6', '8', '8', '6', '1', '1', '1', '9', '7',
    'B', 'C', '9', '7', '4', '1', '8', 'C', '4', 'E', 'B', 'E', '2', '2', '8', '5',
    'F', '7', '8', '2', '0', '2', '6', '9', '1', '0', 'B', '1', '3', 'D', '1', 'F',
    'E', '9', '2', '7', 'A', '1', '0', 'F', '6', 'D', '8', 'D', '8', 'B', 'F', '4',
    '3', '8', 'B', '2', '7', 'F', '7', '1', 'F', '2', '4', 'E', 'F', 'B', '8', '5',
    '5', '7', '0', 'D', 'A', 'A', 'E', '4', '2', 'F', 'B', 'F', 'D', '3', 'B', '9',
    '5', 'D', '7', '0', '3', '1', '2', 'D', 'F', 'B', 'F', '1', 'A', '3', '0', '2',
    'E', '7', '9', 'A', '2', '9', '6', '3', '9', '3', '6', '4', 'E', '6', 'C', '4',
    '9', 'E', '4', '1', '8', '7', '0', 'F', '6', '2', 'B', '3', 'F', '2', '8', '1',
    'C', 'C', 'D', '9', 'D', '6', '7', '2', '1', '4', '1', '6', '9', '9', 'F', '9',
    '5', 'A', '4', 'B', '6', 'C', '6', 'A', 'E', 'C', '5', '5', '7', '7', 'C', 'B',
    '0', 'B', 'C', '4', '4', '2', 'E', '4', 'F', 'D', 'F', '6', '1', '6', '6', '9',
    '3', 'B', '0', '5', 'F', '6', 'F', 'D', 'C', '5', 'D', 'C', '8', '8', 'E', '7',
    '2', 'F', '7', 'D', '9', '4', '5', '8', '0', 'A', '1', '2', 'C', '2', 'F', 'D',
    '9', 'C', '5', '1', '0', 'B', '8', 'F', '6', '9', '1', '8', 'D', '1', '1', '6',
    '4', '5', 'C', '1', 'C', 'A', '6', 'A', 'C', 'A', 'D', '7', 'A', '7', 'E', '3',
    'A', 'F', 'A', 'A', 'A', '5', '3', '8', '7', '1', 'B', '2', '6', '4', '4', '2',
    '1', '0', '4', 'A', '7', 'A', '5', 'D', 'D', 'A', '7', 'C', 'F', 'C', 'E', 'C',
    '3', '0', 'F', '9', 'F', '7', '9', '7', '9', 'C', 'B', '3', 'E', '9', '8', 'E',
    '2', 'F', 'F', 'C', '8', '9', 'C', 'F', 'A', 'B', 'A', '3', '7', 'C', 'E', 'F',
    'D', 'E', '0', 'D', 'D', '2', '9', 'B', '5', '7', '4', '3', 'D', '9', '2', '1',
    'B', '7', '2', 'F', '1', '5', 'C', 'F', 'D', '5', '4', '8', 'D', '3', '8', 'A',
    'C', '3', 'F', '3', 'C', '8', 'B', 'E', 'C', 'E', '4', '7', '4', '8', 'A', 'A',
    'D', '7', '4', '0', '6', 'E', 'D', '6', '2', '9', '5', '7', 'A', '2', 'B', 'B',
    'A', '3', 'F', '9', 'D', '8', '3', '0', 'E', '5', '8', 'A', 'D', '5', '6', '8',
    '2', '9', '8', 'A', 'E', '6', '4', 'C', 'B', 'D', '4', '3', '2', '2', 'E', '7',
    '4', '6', 'E', 'A', 'F', '4', '4', '5', 'E', 'C', '5', '8', '8', '1', '4', '9',
    '8', 'B', '0', '1', '8', '4', '1', 'C', 'E', 'D', '7', '1', 'D', '2', '7', '9',
    '6', '9', '7', 'D', 'D', 'C', '2', '6', '0', '2', '9', 'D', '3', '2', '0', '5',
    '9', '1', '6', '7', '6', '4', '7', '2', 'F', '1', 'B', '1', '2', '6', '3', '5',
    '3', '4', '4', '1', '5', 'C', '2', '1', '8', '4', '9', 'E', '4', '9', 'A', 'B',
    'E', 'F', '7', '8', '8', 'F', 'C', '8', '5', '9', 'B', '2', '9', 'D', '1', 'C',
    'E', '4', 'A', '3', '8', 'F', '4', '5', '7', 'F', '2', '4', '0', '0', '5', 'B',
    '2', '0', '9', '2', '9', 'A', '0', 'F', '7', 'B', '2', '3', '2', '4', 'D', '4',
    'C', '6', '0', '8', '5', 'D', '2', '7', '3', '5', 'C', '6', 'D', '5', '2', '8',
    '4', '4', 'A', '3', '5', '5', '2', '0', 'E', '3', 'C', 'A', '0', '8', '3', '8',
    'A', '7', 'E', 'F', 'E', 'C', 'E', '4', '8', '9', 'F', '1', '5', 'D', '2', '4',
    '2', '4', 'B', '8', '1', '0', '2', '2', 'E', 'D', 'D', 'F', '0', '3', 'A', 'E',
    'B', 'B', '4', '8', '2', '1', '3', '8', '3', '9', '8', 'B', '7', '1', 'A', 'C',
    'B', '1', 'D', 'C', '3', '8', '4', '8', 'E', '3', '8', '7', 'A', '1', '9', 'B',
    '3', 'E', 'E', '7', '0', 'C', 'A', '7', 'A', 'A', '0', '8', '8', '5', '3', '4',
    '1', 'C', 'D', '7', '5', '1', 'E', 'D', 'B', 'E', 'B', '1', '9', '0', '5', 'C',
    'D', '0', 'A', '1', '3', '6', '4', 'E', '2', 'F', '4', '2', '5', '3', 'F', '9',
    'E', '4', '7', '8', 'A', 'D', 'D', '2', '7', '8', 'E', '2', '1', '7', '9', 'F',
    '7', 'C', '4', 'A', 'F', '5', '0', '4', '0', '6', '4', 'F', '0', 'D', '5', '0',
    'E', 'E', 'E', '4', '8', 'E', '4', '7', '9', '1', '0', '0', '1', '4', '1', '1',
    'D', 'B', 'D', 'A', 'B', '4', '2', '9', 'E', '2', '2', 'C', 'B', 'B', 'F', '1',
    '2', '4', 'B', '7', '3', '9', 'E', '1', '4', 'F', '6', '7', 'A', 'C', '0', 'D',
    '5', '6', 'A', 'E', '1', '2', '7', '3', '4', 'E', 'C', 'B', 'B', '1', '9', 'F',
    '5', '7', '9', '6', '9', '8', '0', '7', '8', '4', '7', 'E', '8', 'E', 'E', '9',
    '8', '4', '1', 'A', 'E', 'E', '8', '6', '8', '4', 'A', '1', '5', 'E', 'C', '8',
    '6', 'E', 'F', 'B', '1', '2', '5', '6', 'D', 'C', '3', 'C', '4', '3', '5', 'F',
    '6', '4', 'D', '6', 'A', 'E', '4', '3', 'F', '7', '2', '9', 'A', '4', 'B', '5',
    '5', '0', '1', 'D', '4', '6', '4', 'C', '8', '7', 'E', '0', '1', 'E', '0', 'B',
    'F', 'A', '4', 'C', '4', '7', '7', '8', 'F', 'E', 'B', '5', '9', '8', '6', 'C',
    '2', '4', '4', '1', '1', 'C', '1', '8', '6', 'E', '2', '6', '0', '8', '6', '5',
    '6', 'C', 'B', 'E', '7', '4', '5', 'D', 'A', '3', '6', 'D', '6', 'F', '6', '1',
    'A', '1', '1', '8', '9', '9', '2', 'E', 'B', 'B', '3', '0', 'B', '6', '0', 'F',
    'F', '5', '7', '6', '6', 'E', '7', '6', '2', '5', 'A', '9', '1', '7', '8', 'E',
    'C', '0', '3', '0', 'E', '4', '3', 'E', 'A', '6', '0', '9', 'E', '0', '8', 'A',
    '4', 'C', 'A', '8', '3', '5', '1', '4', '2', '5', '0', 'B', '1', 'D', '5', '7',
    '3', 'F', '3', '8', '2', '1', 'A', 'B', '6', 'C', '1', 'D', '9', '1', '5', '2',
    'B', 'C', 'B', '6', '2', '4', '1', 'F', 'D', '8', '6', 'A', '4', '2', 'C', 'F',
    'A', 'C', 'E', '3', '7', '7', 'B', '3', 'F', '1', '2', 'A', '4', '4', 'E', '6',
    '2', 'E', '9', 'C', '1', '3', 'D', 'D', '8', '7', '7', 'F', 'F', '9', '0', '2',
    'C', 'F', 'D', '6', 'E', '6', '8', '9', 'C', '4', 'B', 'C', '4', '5', '0', '2',
    'F', '7', '9', '5', 'C', '3', '1', '4', 'D', '2', '9', 'C', 'F', '3', '4', '5',
    '3', '0', '7', '0', 'B', 'D', 'A', '8', '8', 'D', '3', '9', 'B', '2', 'A', '9',
    'E', 'F', 'E', 'F', 'D', '0', 'C', 'C', 'A', '6', '0', 'E', 'C', 'C', '3', '3',
    'B', 'B', '0', '4', '4', 'E', '6', 'B', '1', '0', 'A', 'B', '2', 'A', 'C', '6',
    'B', '1', 'F', 'B', 'E', '5', 'E', 'C', '8', 'D', 'C', '8', '0', '8', '8', '5',
    '2', 'C', '6', '1', 'D', 'B', '8', 'C', '3', '2', 'C', '2', '1', 'E', '4', 'D',
    '6', '9', '3', '4', '1', '1', '6', 'A', '2', '5', '5', '3', 'E', 'C', '2', '4',
    '4', '6', 'C', '3', 'A', '6', 'E', '9', '9', '5', '7', '9', 'C', 'C', 'E', 'B',
    '7', 'B', '8', '1', 'A', '9', '0', '2', 'A', '7', 'D', 'F', '0', '8', 'C', 'F',
    '6', '4', '2', 'D', 'F', '9', '8', 'D', '5', 'B', 'E', 'C', 'F', '5', 'E', '0',
    'F', 'D', '2', '6', '0', '0', '3', '2', '6', 'A', '6', '7', '1', '4', '6', '3',
    '8', '5', '4', '9', 'F', '5', '4', '9', '4', '7', '6', 'F', 'A', 'F', 'E', '2',
    '7', '1', '7', 'D', '5', 'E', '4', 'C', '6', '5', '8', '0', 'A', '7', 'F', 'F',
    '5', 'E', '0', '7', '7', '6', '9', 'E', 'A', '2', '5', '9', 'E', 'F', 'B', '9',
    'F', '9', 'D', '7', '1', 'E', 'E', '8', 'F', 'F', 'E', 'A', 'A', '8', '1', '5',
    '3', '5', '3', '2', 'B', 'C', 'E', '6', 'C', 'A', '2', '6', 'C', '3', 'E', 'A',
    'D', '3', '5', '9', '9', '1', 'C', '8', 'E', '4', '1', '5', 'F', '8', '5', 'C',
    '0', '2', 'C', '0', '0', 'D', '7', '4', '6', 'C', 'D', '3', 'E', '9', '8', '9',
    '4', 'C', '4', '5', '7', '3', 'E', 'F', 'E', '9', 'B', '1', '1', '5', '9', 'B',
    '3', '4', '9', 'B', 'A', '5', 'C', '2', '8', '8', '7', '6', '3', '8', 'E', '9',
    'D', 'E', '9', '0', '9', '5', '2', '1', '3', 'B', '6', '8', 'A', 'C', '5', '0',
    '3', '0', '5', 'C', '3', 'A', '7', '1', '6', '4', '9', 'A', 'B', '8', '9', 'C',
    'E', '6', 'B', 'A', 'A', '4', '1', 'D', '1', '6', 'E', '9', '4', '4', '0', '8',
    '0', '7', '2', '8', '9', 'B', '9', 'E', 'F', 'B', 'B', 'B', '1', 'D', '1', '1',
    'B', '0', 'B', '5', '7', 'F', '7', 'D', '4', '4', '6', '3', '5', '9', '0', 'D',
    'F', '7', '1', '9', '5', 'D', '9', 'A', '3', '9', 'F', '4', 'E', '9', 'D', 'B',
    'F', 'B', '4', '2', 'D', 'A', '5', '4', 'C', '0', 'B', '4', '5', '4', '7', '0',
    '5', 'D', 'A', '3', 'A', 'D', '9', 'C', '6', '6', '1', 'F', 'C', '7', '9', '3',
    'C', 'D', 'A', 'B', '7', 'D', '1', '6', '9', '0', '2', '1', 'D', '4', '0', '8',
    '8', 'B', 'B', '7', 'E', '8', '2', '9', 'C', '7', 'B', 'A', '8', '5', 'D', 'A',
    'D', '8', 'C', 'D', '5', 'B', '0', '1', '4', '1', 'A', 'B', 'E', '3', '7', '8',
    '3', '9', '8', 'D', '2', '1', '6', '6', '9', '2', 'C', '7', 'C', '7', '4', '4',
    '7', 'D', '1', '7', '8', '6', '7', '9', '1', 'B', '6', '1', '7', '9', '9', 'A',
    'D', '2', 'B', '7', 'D', 'D', '4', 'F', '5', 'B', '7', 'A', '8', '3', '6', 'F',
    '8', '6', '8', 'F', '0', '9', 'C', 'B', '9', 'A', 'D', '7', 'C', '1', '8', 'C',
    '1', '5', '5', 'B', 'B', 'D', 'C', 'E', 'D', '4', '6', '6', '5', 'E', '9', '7',
    '4', 'D', '6', 'A', '7', 'E', 'F', '5', 'D', '2', '2', 'D', '4', '8', 'A', '6',
    '9', '0', '1', 'B', '1', '0', 'D', '9', '9', '5', 'D', 'C', '4', '3', '7', 'F',
    'D', '8', '9', '0', 'A', '9', '2', '9', '4', '3', '4', 'A', '4', 'A', '5', '8',
    '4', '6', 'C', 'E', '2', '9', '8', 'C', '3', '4', 'E', '4', 'E', '8', '3', '5',
    'E', '2', '0', '9', 'C', '8', '7', '5', 'B', '9', '8', 'E', '5', '7', 'D', '6',
    '5', 'F', '5', '4', '2', 'B', 'B', '0', '6', '4', 'E', '6', 'F', 'A', '2', '4',
    '8', '1', '0', 'F', '1', 'C', '5', 'D', 'F', 'A', '8', '8', 'A', '6', '0', '6',
    '5', 'E', '6', '4', '1', 'D', '5', 'E', '7', '7', '9', 'B', 'F', '8', '8', 'B',
    'F', '0', '0', '8', 'D', 'E', '2', '8', '7', '3', 'F', 'B', '3', '0', '1', '9',
    '0', '2', 'F', 'B', '0', '5', 'B', 'D', '9', '0', 'C', 'F', 'A', 'E', '5', 'F',
    '0', '1', 'C', '0', '7', '3', '6', '7', 'B', '2', '6', '5', 'D', '3', 'C', '1',
    '6', 'A', '4', '2', 'C', 'C', '5', '1', 'F', 'A', '7', '7', 'E', 'E', '2', '9',
    '0', '9', 'D', '8', '4', '9', 'C', '5', '1', 'B', '6', '2', '8', '0', '9', 'F',
    '0', '5', '1', 'E', 'A', '5', '3', 'B', '1', 'C', 'A', 'D', '9', 'C', '7', 'B',
    '7', 'D', '6', '2', '2', 'D', 'F', '1', '9', '3', '6', '5', '8', '4', '2', 'B',
    'A', '5', 'C', '4', '1', '7', 'B', '9', '5', 'F', '8', '1', '1', '2', 'C', '7',
    'A', 'B', '2', '1', 'C', 'B', 'E', 'A', '9', '3', 'E', 'B', '0', '1', '4', '5',
    'F', '8', '2', '1', '3', 'A', '2', '6', 'E', '5', '7', 'C', 'F', 'B', '0', 'C',
    '7', '6', '2', '9', '2', '8', 'C', '3', '2', 'C', '8', '6', 'D', '0', '9', 'D',
    '6', '9', '4', '6', '1', '3', '1', '0', 'D', 'E', '8', '2', '3', 'F', 'E', '4',
    '7', 'D', '3', 'B', '3', '9', '0', 'B', '9', '7', '6', '9', 'B', '0', 'D', '1',
    'C', '4', '6', '7', 'B', '9', 'D', 'F', '6', '6', 'C', 'F', '8', '5', '0', '1',
    'D', '7', 'B', 'B', '1', 'C', '6', 'B', '3', '5', 'F', '1', 'D', '1', 'B', '8',
    '9', '8', '0', '1', '7', '3', '4', '1', '9', '4', '0', '6', '3', 'A', 'C', '1',
    'E', '1', '7', '9', '5', '5', 'B', '9', '2', 'B', '3', '7', 'F', '4', '1', '6',
    '9', 'B', '3', '1', '6', 'F', 'D', 'D', '3', '6', 'F', 'F', '7', '1', '3', 'B',
    '4', '6', '1', '1', '1', 'F', '0', '7', 'A', 'F', '5', 'C', 'A', 'F', 'F', 'C',
    'E', 'A', '6', '4', '8', '6', '7', '5', '1', 'E', 'A', '1', '2', '3', '3', 'F',
    'C', '3', 'F', 'E', '9', '8', '0', 'E', '4', 'A', '5', 'C', 'B', '5', '9', 'A',
    'D', 'C', '2', 'B', '4', '4', 'D', 'E', '8', '5', 'A', 'C', 'A', '0', 'D', '2',
    '0', '8', '7', 'E', '7', 'A', 'B', '4', '4', '5', 'C', '8', '3', 'A', 'E', '6',
    'F', '9', '1', 'B', 'A', '7', '9', '0', '8', '4', '9', 'C', '3', '1', '3', '7',
    '3', 'E', '5', '4', '9', '6', 'A', '7', 'D', 'B', 'F', 'E', '3', '3', '3', 'A',
    '7', '7', '1', '3', '5', 'F', '0', 'A', '2', '5', 'D', '2', 'D', '3', 'C', '7',
    'A', 'B', '3', 'D', '5', '6', 'F', '2', '2', 'D', '7', 'A', '5', '1', '9', 'C',
    '1', 'D', '8', 'F', 'B', '9', '8', '1', '8', 'A', '2', '5', '0', '3', 'C', '0',
    '6', 'A', '8', 'D', 'A', '2', 'E', '3', 'A', 'F', 'A', '2', '8', '6', '9', 'E',
    'A', '2', 'A', '5', '9', '7', '5', '7', '9', '8', '7', '9', '1', 'A', '6', '8',
    '3', '1', 'B', '4', '9', 'D', 'E', '7', 'F', '4', '7', '2', 'F', 'F', '8', '4',
    'D', '9', '4', '5', 'D', '7', '7', '9', '2', '1', 'F', 'D', 'D', 'C', '1', '5',
    'B', '9', 'D', '0', '9', 'B', 'F', 'C', '3', '7', '2', '0', '0', '3', '1', '5',
    '8', 'A', '1', '4', 'E', '9', '8', '9', '9', '8', '3', 'D', 'A', '2', 'C', 'D',
    'D', 'C', 'A', 'F', 'C', '1', 'E', '2', 'F', '0', '2', '8', '9', '9', '8', '2',
    'C', 'F', '8', '0', 'C', '8', '0', '5', '6', '3', '3', '3', 'B', 'E', '5', 'F',
    'B', '2', 'C', '2', '1', '3', 'A', '6', '8', 'D', 'D', '3', '4', 'B', 'C', 'E',
    '1', '6', '8', '8', '9', 'D', '5', '4', '3', '2', 'F', '1', '6', '6', '4', '9',
    '0', '6', '0', '3', 'B', '0', '7', 'C', 'E', '9', '7', '9', 'D', 'B', '5', 'A',
    '7', '1', '9', '9', '6', 'E', '7', '7', 'C', '9', '5', '1', '8', 'C', '2', '9',
    '3', '4', '5', '9', 'F', 'C', 'C', '1', '1', 'D', '8', '2', '5', '0', '6', 'E',
    '5', 'E', 'B', '1', 'F', '5', '1', '9', 'B', 'A', 'B', '5', 'A', 'A', 'D', '9',
    '2', '9', '1', '3', 'B', '0', '2', '8', '5', '0', 'F', '2', '7', '2', 'D', '2',
    '2', 'C', '6', '5', 'C', 'B', '6', '9', 'E', '6', 'A', 'F', '5', '4', '9', '7',
    'F', '3', '0', 'F', 'B', '8', 'F', '7', 'B', '9', 'D', '5', '7', '4', '1', '2',
    '0', '5', 'C', 'D', '2', '0', '4', '4', '3', '3', '9', 'D', '9', '0', '1', '8',
    'B', '7', '3', '7', '9', '4', 'C', '9', '2', '8', 'D', '6', '4', '9', 'D', 'C',
    'D', '4', '8', 'B', '3', 'F', 'D', '3', '1', '4', '3', '8', 'B', 'F', 'D', '6',
    '4', '5', '8', '9', '2', '6', '5', '7', 'E', 'A', '4', 'C', 'F', '8', '3', 'B',
    'F', '2', 'D', '1', '9', '1', 'A', '1', '0', '2', '3', '8', '6', 'D', '6', '5',
    '7', '3', '2', '1', '6', 'E', 'C', 'E', '5', '2', 'F', '7', '3', 'B', 'E', 'E',
    '8', 'B', 'F', '2', 'B', 'F', 'E', 'D', '1', 'B', 'D', 'A', '2', 'D', 'C', 'D',
    'E', '5', '0', 'C', 'E', 'C', 'F', 'B', 'F', '0', '9', '0', '7', 'A', '8', 'E',
    '3', 'F', '8', 'B', '8', '6', 'C', '7', '0', '3', '7', '1', '3', 'C', 'D', 'F',
    'A', 'E', '0', 'A', '7', '9', '2', '3', '1', 'F', 'D', 'F', '5', '4', '0', '2',
    '7', 'F', 'D', '8', 'E', '9', 'A', 'D', '4', 'B', '3', 'A', '6', '6', '9', '7',
    '8', 'E', 'A', '5', '6', '9', 'D', '1', '0', '7', '9', '1', 'E', '6', '3', 'E',
    '0', '9', '3', 'F', 'A', '7', 'A', 'E', '5', '6', 'B', '8', 'F', 'B', '0', 'A',
    'F', '3', '8', '5', '2', 'A', 'A', 'C', '2', 'E', 'F', '3', 'E', 'D', '1', '4',
    'B', '6', '0', 'A', '2', '2', '3', '4', '4', '5', '9', 'E', '0', '7', '6', '9',
    '0', '5', '3', '0', 'E', 'D', '3', 'D', '8', '2', '4', '6', '4', 'E', 'A', '7',
    'B', 'F', '2', 'A', '2', '4', '5', '9', '8', '9', '4', 'D', '9', 'E', 'D', 'D',
    '1', '5', '6', '1', 'E', '2', '6', '4', '9', 'F', '7', 'E', 'D', '8', 'C', '5',
    'C', 'F', '3', '5', '8', '1', 'E', '5', '3', '9', 'D', '7', '5', '9', '7', '2',
    '8', 'E', '1', 'B', '8', '5', '7', '2', '9', '4', 'E', '3', '0', '6', '6', 'C',
    'B', '5', '2', '2', '5', 'F', '3', 'D', '0', 'B', 'A', 'E', 'B', 'D', '7', '4',
    'D', '4', '2', 'F', 'B', '3', '3', 'D', '2', '2', 'B', '7', '1', '8', '0', '9',
    'C', 'A', 'D', 'F', '5', '7', 'D', '4', '2', 'D', 'D', '4', '1', '4', '3', '3',
    'B', '2', '6', '9', 'E', '9', 'A', '6', '0', '2', 'C', '4', '8', '5', 'F', '8',
    '5', 'F', '4', '7', '2', 'F', '6', '5', 'D', '6', '2', '5', '7', 'E', '6', 'F',
    '0', 'E', 'D', 'C', 'A', '0', '7', '5', '4', 'B', '2', '0', '4', '6', '0', 'C',
    '7', 'B', '5', 'F', '8', '5', '7', 'F', '5', 'E', '0', '5', 'A', 'D', '7', 'B',
    '2', '4', 'B', 'E', 'B', '4', '4', '0', 'E', '1', '3', 'B', 'A', '6', 'B', '4',
    'A', '3', '3', '1', '3', 'B', 'C', 'F', '8', '3', 'E', 'D', '6', '5', '5', 'A',
    '4', 'C', '1', '8', 'B', '6', 'F', '2', '9', '7', '6', '2', '2', '2', '5', 'C',
    'C', 'B', 'D', 'F', '0', '7', '8', '0', 'A', 'A', 'D', '6', '4', 'E', 'B', 'F',
    '8', 'D', 'B', '9', 'B', '9', 'E', '2', '7', 'E', '3', 'B', '0', '5', '7', 'B',
    '6', 'D', '8', '6', '4', '3', '8', 'B', 'C', 'F', 'F', '8', 'B', '5', '6', 'B',
    '0', 'C', '7', 'C', '7', '7', '5', '1', '2', 'C', '6', 'E', '2', 'B', '9', '6',
    '2', 'F', 'A', '7', 'A', '2', 'B', '2', 'D', '7', '8', '3', 'F', '1', '5', 'C',
    '2', '7', '9', 'B', 'F', 'B', 'B', '3', '2', '1', 'D', 'C', '8', 'B', '9', 'C',
    'E', 'A', 'C', 'A', '6', 'A', 'D', 'E', 'B', 'C', '4', 'B', 'F', '4', '8', '4',
    '2', 'B', '2', '3', '2', 'D', 'F', '5', '5', '5', '3', '3', '5', '5', '0', '8',
    'E', 'E', '2', '7', 'E', 'D', '7', '2', 'C', '5', '2', 'B', '8', '3', '8', '0',
    'A', '4', '6', '5', 'E', '4', '6', '0', 'B', '5', '5', '3', '9', 'E', '2', 'D',
    '1', '4', 'D', '3', 'E', '0', 'A', '9', '4', '6', 'A', '3', 'B', 'D', '9', '4',
    'E', '2', 'F', 'B', 'C', '2', '3', '7', '5', '1', '8', '4', '5', 'D', '9', '1',
    '0', '4', '5', 'F', '8', '2', 'C', '9', 'E', '8', '6', '2', 'A', '9', '2', 'D',
    '1', '0', 'A', '9', '8', 'A', 'A', '5', 'F', '5', '4', '5', 'F', '2', 'C', 'D',
    'E', '4', 'B', 'A', 'D', '7', '6', '2', '2', '9', 'D', '7', 'C', 'F', 'E', '9',
    '9', '1', 'A', '5', 'C', '7', '4', 'D', 'B', 'D', '9', '4', 'F', '0', '1', '2',
    '2', '0', 'F', '6', 'B', '1', 'E', 'D', '1', '3', '3', '0', '5', 'F', '4', 'C',
    '8', 'F', 'A', '5', '5', '4', 'C', '0', 'E', 'A', 'F', '3', '3', '5', '9', 'F',
    'C', '3', '7', '3', '7', '2', '3', '9', '1', '0', 'C', '5', '7', '4', '6', 'F',
    '9', 'F', '6', '3', '8', '6', '4', 'A', '4', 'C', '3', 'E', '4', '6', '6', 'A',
    'B', '9', 'B', '4', '7', 'A', '3', 'A', 'E', '2', 'A', '0', '4', '7', '3', '1',
    '5', '0', '8', '4', 'F', 'D', '6', 'C', '1', 'F', 'B', 'E', 'F', 'E', '0', 'F',
    'D', '9', 'F', '5', 'F', 'C', '2', 'C', 'C', '5', '4', 'E', '3', '7', 'D', '1',
    '4', 'D', '5', 'F', '6', 'F', '3', '3', '9', 'F', '3', 'F', '5', 'F', '4', '7',
    'A', '7', '2', '4', '3', 'B', 'E', '3', 'A', 'A', '9', '0', 'C', '0', '9', '3',
    '8', '4', '7', 'D', '6', '2', 'F', '9', '9', '7', '4', 'F', 'D', 'F', '2', '0',
    '1', '9', '2', 'E', 'C', '1', '3', 'D', '3', 'E', 'A', 'F', 'F', 'D', 'B', '1',
    '8', 'D', '3', '8', 'F', 'F', 'A', '5', '4', 'E', 'A', '6', 'F', '9', '5', '4',
    'D', '6', 'C', '5', '8', '5', '7', '5', '4', '5', 'B', '8', '0', '8', 'B', 'F',
    'B', '1', 'A', '8', 'B', 'D', 'D', 'B', '5', 'D', 'B', '4', 'A', 'C', 'F', 'B',
    '8', '4', '0', '5', 'B', '5', '1', '3', '4', '5', 'E', 'B', 'B', '7', '7', '5',
    '1', '3', '3', '9', '4', '2', '7', '4', 'F', '4', '5', '4', 'D', '6', '1', 'E',
    'B', '2', '1', '3', 'E', '7', '2', '8', '0', 'D', '2', 'E', '7', '3', 'F', '1',
    '5', 'D', 'D', 'A', '9', '7', '3', '8', '3', 'D', '6', '2', 'B', '1', 'E', 'F',
    '6', 'C', '8', 'B', '8', '6', 'F', '0', '3', 'D', '8', 'C', 'E', '6', 'D', '7',
    'B', 'E', 'C', '2', 'D', '3', '2', 'C', '4', '8', 'F', 'D', '3', 'B', '7', '3',
    '1', '4', 'D', 'C', 'D', 'C', 'A', '5', 'B', 'E', '3', '8', 'A', 'E', '5', 'F',
    '0', '3', '1', '3', 'B', 'B', '9', 'F', '8', '0', '1', 'C', '5', 'E', '3', 'D',
    'B', 'B', '0', '7', 'C', '8', '1', '3', '2', '2', 'E', '4', '2', '7', '4', 'A',
    '2', '0', '4', 'A', '7', '1', 'A', '7', '0', '3', '3', '2', '2', '3', '5', '3',
    '7', 'D', '7', '7', '2', '1', '7', '5', 'B', '9', 'B', 'B', 'F', '0', '3', '9',
    '5', 'B', 'C', '8', '6', '7', '2', '5', '2', '2', 'C', 'E', 'A', '3', 'C', '5',
    'E', 'B', 'C', 'D', '5', '6', '3', '5', '8', '3', '9', '2', '1', '0', 'B', '3',
    '0', '1', '6', 'C', '8', 'D', 'B', '7', '3', '6', '8', 'D', 'A', '0', '4', 'F',
    'C', '2', '6', '1', '3', 'C', '1', '8', '7', 'F', '4', '2', 'F', '0', '1', 'B',
    '8', 'B', '4', 'A', '4', 'F', '3', 'B', 'F', '0', 'A', '8', 'B', 'A', 'E', '1',
    'E', '1', 'A', '2', 'C', 'A', '2', '3', '8', '2', 'F', 'D', '3', 'C', 'A', 'E',
    '0', 'D', 'D', '6', 'D', 'E', '7', 'F', '5', '7', '1', '4', 'F', '0', 'F', '3',
    '6', 'F', 'E', 'B', 'E', '0', '6', '8', 'F', '5', '8', '5', 'A', 'E', 'A', 'E',
    '1', 'E', 'C', 'B', '6', 'A', 'A', '6', '4', '4', '0', 'B', 'C', '9', '4', 'E',
    '4', '2', '6', 'C', '2', '3', '6', '6', '3', '0', 'D', '0', 'F', '1', 'F', '3',
    'A', 'F', '1', 'C', '0', 'F', '8', '0', '1', '1', '1', '7', 'A', '6', '1', 'A',
    'A', 'E', 'C', '1', '2', '3', 'F', '3', 'B', 'B', '9', 'E', '9', '9', 'C', '5',
    '0', 'C', 'D', '4', '0', 'D', '9', '1', 'B', '6', '0', 'F', '0', '8', '1', '0',
    '9', '9', 'F', '6', 'A', 'C', 'A', 'A', '3', 'F', 'E', 'D', '1', '8', '2', 'C',
    'C', 'A', '2', '1', '5', '5', 'C', '8', '8', '9', 'C', '5', 'E', '4', '8', '5',
    '0', 'D', 'B', '7', '0', '2', 'A', '1', '6', '7', '1', '4', 'B', '7', '4', 'A',
    'D', '9', 'F', '4', 'F', 'D', '4', '2', 'F', '2', '3', '3', '4', 'C', 'D', 'D',
    '9', 'F', '1', '7', 'B', '1', '2', '2', 'E', '4', '8', 'D', 'F', '0', 'E', 'A',
    '6', '8', '1', '6', '8', '3', '3', 'C', '6', 'C', '7', '4', 'E', 'F', 'E', 'A',
    'E', 'B', '8', '5', 'F', 'A', '4', 'E', 'E', '7', 'D', '7', 'E', 'E', '4', '8',
    '0', 'F', '1', 'A', 'F', 'E', 'A', '5', '3', '5', 'B', '6', '0', '3', '1', '2',
    '0', '8', '6', 'C', '5', '7', '6', '5', '7', 'E', '0', '6', 'F', '9', '3', '3',
    '2', '3', '0', 'E', '8', 'D', '5', '0', 'A', '8', '7', 'E', '3', 'E', 'B', 'E',
    'D', '6', 'A', 'D', '5', '3', 'F', '0', 'A', 'B', '8', '8', '7', '6', '9', '3',
    '7', '5', '7', '2', 'C', 'F', '6', '5', 'B', '4', '4', '8', '6', '1', 'C', '0',
    'B', 'D', '3', '2', 'B', '4', '8', '6', '2', '7', '7', '0', '9', '3', 'A', '3',
    '6', 'E', '5', '5', '3', '8', '1', 'B', '8', '0', 'D', 'E', 'B', '9', '8', '6',
    'C', 'B', 'D', '8', '8', 'E', '8', 'D', 'B', 'F', 'B', '9', 'B', '2', 'A', '1',
    '9', '2', '6', 'F', '7', 'D', '4', 'A', 'F', '5', 'E', '5', '9', '0', '7', 'E',
    '9', '7', '3', '1', 'E', 'B', '7', 'F', '9', '8', '3', '2', '2', '2', 'F', '2',
    '5', '4', 'F', '2', '8', '6', 'B', '1', 'E', '3', '7', '4', '5', '5', 'A', 'E',
    '1', 'C', 'D', '3', '5', 'C', '2', '7', '3', '9', '0', '8', 'C', 'B', 'E', '7',
    'E', 'F', '4', '8', 'A', 'C', 'A', '3', '7', '2', '4', 'F', '7', '5', 'B', 'C',
    '6', '6', '5', '8', '8', 'D', '9', 'C', '0', 'B', '7', '5', 'F', 'D', 'C', 'B',
    '9', '5', 'E', '8', 'F', '8', 'D', '7', 'A', 'C', 'F', '8', '9', 'B', '0', '8',
    'C', '4', 'A', '7', '7', 'A', '9', 'E', '2', 'A', '3', '6', '7', 'A', 'A', 'C',
    '8', 'F', 'C', '8', 'E', '4', 'E', '7', '5', 'E', '9', 'B', '8', 'D', '4', '0',
    'B', '7', 'C', '2', '6', '9', '4', 'B', 'F', '6', 'F', 'A', '2', 'B', 'D', 'F',
    '3', '4', '7', 'F', 'E', 'E', 'F', 'E', '5', 'F', 'A', 'E', 'C', 'A', '3', '3',
    'D', 'E', '3', '9', '0', '2', '7', '3', 'B', '5', '0', '5', '9', '4', '7', '1',
    '9', '4', '5', '5', '0', '5', '5', '6', '0', '5', '0', 'A', 'B', '5', '1', '7',
    '0', '0', '5', '0', 'D', 'F', '9', 'E', '7', '4', 'D', 'A', '6', '8', 'A', '4',
    'B', '3', '2', 'F', '4', '1', '1', '8', '9', 'D', '3', '4', '7', 'E', 'F', '3',
    '3', '5', 'F', '0', '5', 'C', 'A', 'B', '4', '9', '4', 'F', 'F', 'F', '0', 'E',
    '3', 'E', '6', '0', '4', 'E', '5', 'D', '5', '7', 'F', '5', '3', 'B', 'C', '3',
    'E', '1', 'A', '0', 'B', 'B', '5', '3', '8', 'B', 'F', '5', '5', '0', '6', '2',
    'A', '7', '2', 'B', '2', '5', 'E', '3', 'D', 'C', 'D', 'B', 'C', 'E', 'B', '0',
    '0', '4', '6', 'E', '4', '0', '6', '2', '0', 'D', '8', '3', '3', '9', '0', 'F',
    '9', 'D', '8', 'D', 'F', '6', 'A', 'B', '2', '9', 'D', '5', '5', '3', 'B', '9',
    'E', 'F', 'F', '4', '6', '8', '9', 'D', '1', '2', '7', '4', '2', '0', '0', '7',
    '5', 'E', '9', '5', '8', '9', '2', '4', '6', 'A', 'C', '6', 'B', '9', 'E', '6',
    '8', '1', 'A', '7', '0', 'C', '7', '5', '2', 'D', '7', '6', 'E', '3', '0', '8',
    'A', 'D', 'A', '6', '4', '3', '8', '3', '1', '8', 'E', 'F', 'E', '9', '3', 'C',
    '7', '0', '2', '3', '2', '3', 'B', 'F', '5', '3', 'C', '2', '4', '8', '0', 'A',
    '5', '5', 'C', '2', 'E', '5', '7', '6', '6', 'A', '9', '1', '2', '6', 'D', 'B',
    'C', 'D', '0', 'E', '7', '3', '4', '9', 'B', 'A', 'D', '0', '2', 'B', '1', '9',
    '5', '5', '3', '0', '0', 'F', '8', 'B', '4', '3', '7', '7', '8', '8', 'A', 'B',
    '3', '3', 'A', 'B', '9', 'B', '0', 'F', 'F', '4', '7', '9', 'D', '6', '7', 'B',
    'C', 'F', 'C', 'E', 'C', 'B', '9', 'F', '0', '0', '8', '2', '1', 'C', '7', '9',
    'D', '2', 'E', '1', 'E', '4', 'D', '7', 'F', '5', '9', 'A', '0', '6', '8', 'E',
    '8', '7', '6', '2', '3', '9', '1', 'E', 'F', '6', '6', '2', '2', '9', '9', '8',
    'E', '6', '5', 'E', '1', 'C', '4', '6', 'F', '2', '7', 'E', 'F', 'A', '8', '9',
    'B', 'B', '8', 'F', 'B', 'E', 'F', '3', 'B', '8', '3', 'A', '2', '6', 'F', '5',
    '5', '3', 'D', 'E', '0', '9', '8', '7', '5', '4', 'C', '1', '0', '2', '6', '3',
    'E', '2', '7', '4', '3', '5', 'E', 'F', '7', '0', 'C', 'E', 'C', 'E', 'B', '1',
    '0', 'E', 'E', '1', '7', '9', '0', 'A', '6', 'D', '2', 'D', '3', '5', 'D', '8',
    '6', '8', 'E', 'D', 'D', '2', 'F', '7', '7', '1', '7', '6', 'E', '6', 'F', '0',
    '7', 'D', '6', 'F', 'A', '2', 'D', '8', '9', '0', '6', '5', '8', '0', 'A', 'B',
    'D', '1', '5', '1', 'C', 'B', 'D', 'D', '0', '4', 'E', 'E', '5', '0', '8', '6',
    '8', '1', 'E', '2', '6', '5', '7', 'F', '9', 'A', 'F', 'A', '0', 'A', '5', '6',
    '9', 'F', 'B', '3', 'E', '1', '6', '2', 'E', '5', '5', '0', '5', '0', '4', '6',
    'A', '1', 'B', '9', '1', '8', 'C', 'D', '1', '0', '9', '6', '9', '7', '4', '6',
    '8', '8', '4', '8', '1', '2', '2', '8', '4', '1', '8', '6', '4', '6', '6', '7',
    '7', '9', 'B', '1', '4', '7', '3', '2', 'E', '7', 'C', 'A', '4', '8', 'B', 'B',
    '4', '4', 'A', '9', '6', 'E', 'B', '6', '4', '5', '4', '0', '9', 'A', 'C', 'D',
    '1', 'E', '7', '0', '6', '9', '0', 'F', '2', '4', '8', 'D', '0', '6', 'D', '6',
    '7', '4', '1', '3', '2', '6', '7', '2', '7', '9', '3', '4', '6', 'A', '2', '6',
    '3', '9', 'C', '9', '5', '4', '3', '8', 'B', '7', 'E', '2', '1', 'F', '8', 'B',
    '5', '1', '9', '8', '9', '4', 'F', 'A', '4', '0', 'C', 'F', '3', '7', 'B', '6',
    '8', 'A', '3', 'A', '2', '9', '8', '8', 'E', '8', '8', '7', '7', '5', '5', '4',
    '0', 'D', '3', '0', '4', 'E', 'D', '6', 'E', 'B', 'B', '7', '9', '5', 'A', 'F',
    '6', 'C', '7', '8', '4', '6', '4', '2', '3', '6', '2', 'F', '7', '2', '9', '6',
    '0', '7', '1', '4', '2', '9', 'C', '5', '3', '0', '2', '6', '6', '4', '6', '5',
    'E', 'F', '8', 'B', 'D', 'F', '4', '3', '6', '6', '0', '6', '1', '7', '9', '9',
    'E', '7', '0', '3', '2', '8', '0', '0', '8', '7', 'C', 'B', '7', '7', '2', '3',
    '6', '0', '9', 'B', '1', '9', 'E', 'D', 'F', '5', 'C', 'D', 'E', '5', '8', 'B',
    'D', '1', '2', 'A', 'A', 'F', '1', '6', '7', 'B', '2', '5', 'E', '9', '5', '4',
    '3', 'B', 'E', '2', 'B', '9', '8', '3', '8', '4', '8', 'C', '5', '0', '8', '7',
    '6', '2', 'E', '2', 'D', '0', 'E', 'A', 'E', 'C', '7', '8', '9', 'D', 'A', '3',
    '5', '1', '8', '9', '9', 'B', 'F', '4', 'C', 'F', '1', 'C', '6', '8', '5', '5',
    '9', '7', '9', 'B', 'F', '1', 'E', '0', '6', '4', '7', '9', 'D', '2', '9', 'B',
    'B', '4', '2', '2', '8', '3', '7', '2', 'E', '1', '9', '9', 'C', '8', 'A', '4',
    '9', 'B', '7', '1', '3', '1', '3', '4', '3', '7', '6', '8', '6', '8', '0', '7',
    '2', '1', '5', 'D', '6', 'E', '9', 'D', 'D', 'F', 'D', 'B', 'E', '2', 'D', 'E',
    '5', '7', 'B', '1', '9', '0', '4', '3', 'A', '5', '5', 'A', '8', '3', 'A', '0',
    '5', '6', '9', '2', '0', 'C', 'F', '7', '9', 'A', 'D', 'D', 'D', '8', '0', 'F',
    'C', '5', 'A', '5', '9', '3', '7', 'D', '6', 'B', '4', 'D', 'D', '7', '0', '5',
    '2', '4', '2', 'E', 'D', '2', '1', 'D', 'A', '2', 'F', 'D', 'D', '2', '2', '7',
    '5', 'F', '4', 'D', 'C', '8', '0', '1', '9', 'F', '7', '8', 'C', 'B', '2', '7',
    '2', 'A', '4', '6', 'B', '7', '8', '7', '5', 'E', '2', 'F', '5', 'E', 'A', 'E',
    '6', '5', 'F', '6', '9', '8', '4', '8', '5', 'B', '6', '9', '9', '9', '0', '3',
    'B', '5', '3', 'C', 'F', '3', 'D', '3', '4', '7', 'A', '5', '8', '6', 'E', 'E',
    'C', '0', '1', '1', '0', '1', 'A', '8', '7', '6', 'C', '8', 'B', '4', '4', '4',
    '3', '7', '3', '3', '7', 'D', '9', 'D', '0', 'A', 'A', '5', '6', '1', '3', 'F',
    '5', 'C', '1', 'B', '7', '3', '8', '7', '3', '2', 'E', '9', 'E', '0', 'D', '4',
    '0', '0', '5', '1', 'F', 'C', 'E', 'E', '4', '7', '1', 'A', 'C', '3', '9', 'D',
    '8', 'C', '5', '3', '8', '3', '1', 'D', '8', '0', 'B', '1', '7', '2', 'E', '6',
    '5', '8', 'E', '4', 'F', 'C', 'C', '3', '7', '2', '4', 'B', 'E', '2', '8', '6',
    'C', '6', '5', '7', 'B', 'F', '5', '5', '8', 'B', '9', '3', 'A', 'F', '5', '0',
    '1', 'F', 'F', 'F', '6', '6', '0', '4', 'B', '3', '8', '2', '3', '3', '3', '7',
    'E', 'B', 'D', '0', '1', '0', '6', '0', '6', '5', '6', '0', '3', '1', '3', '1',
    '6', '8', 'D', '9', '2', '3', 'F', '0', '3', 'A', 'B', 'C', '1', '1', 'F', 'E',
    '1', '8', '9', 'F', 'B', '3', '1', '0', '6', 'F', '8', '5', '0', 'A', '6', '7',
    'E', 'B', '6', '4', '1', '6', 'B', '7', '0', '4', 'A', '4', 'B', 'B', 'B', '5',
    'F', 'C', '9', '3', '6', '9', '0', '9', '0', '4', '5', '0', '4', 'E', 'C', '9',
    'D', '4', '1', '4', '5', '5', '7', '2', '1', '0', '5', 'C', '1', 'A', 'D', '5',
    '5', 'C', '2', 'D', 'D', 'F', 'F', '1', '4', 'C', 'A', '5', 'E', '7', 'D', '4',
    '5', '4', '5', '5', '0', '3', '2', 'D', '3', 'E', 'E', 'D', 'F', 'E', 'D', 'A',
    'D', '5', '9', 'D', 'B', 'E', '2', '5', '1', 'F', 'A', '3', '7', 'A', '0', 'D',
    '9', '6', 'B', '3', '1', '8', 'C', '2', '1', '6', 'F', '7', '0', '6', '5', '4',
    '8', '4', '1', '2', '9', 'E', '4', '8', '5', 'C', '4', 'E', '3', 'B', '4', 'D',
    '8', '3', '1', 'A', '3', '9', 'C', 'E', '6', '3', '0', 'F', '9', '5', '4', 'B',
    '5', '9', 'C', 'C', '8', 'E', '2', '4', '7', '6', '1', '2', '7', 'A', 'F', '0',
    '1', '0', 'C', 'C', '7', '6', '6', '0', '9', 'E', '7', '4', 'A', '5', 'F', '4',
    'D', '9', 'D', '7', '5', '9', '2', '3', '7', '2', '8', 'A', '5', 'F', '5', '4',
    'E', '6', 'D', 'C', '1', '5', 'D', '1', 'E', '1', 'F', '3', '1', '9', '9', '2',
    '2', '7', 'C', 'F', '1', '5', '9', '8', '0', '5', '5', 'D', '3', '4', '9', 'B',
    '2', '8', 'C', 'C', '6', '0', '6', '1', 'D', '1', 'C', '5', 'B', '1', '2', 'C',
    '8', '7', '2', '0', '2', '1', '6', '3', '7', '3', 'F', '0', '1', 'D', 'E', '0',
    '3', 'C', '5', 'F', '3', '4', '5', '0', '9', '1', 'B', '0', 'D', '8', 'F', '6',
    '5', '1', '3', '7', '0', '7', '3', '8', '7', '3', 'F', '8', 'A', 'D', '3', '1',
    '6', '8', '3', 'E', '5', 'A', 'C', '1', '0', 'E', 'F', '7', 'D', '3', '8', 'D',
    '7', '5', '6', '4', 'E', 'F', '9', 'E', 'D', '7', 'D', '7', 'D', '8', '5', 'B',
    'B', '0', '4', 'D', '4', 'E', '2', '4', 'D', 'D', '6', '0', 'D', 'F', '0', '6',
    '5', 'E', '5', 'B', 'D', '6', '5', '9', 'E', 'B', '1', 'C', 'B', '9', 'D', '7',
    'C', 'F', '0', '2', 'C', '7', 'A', 'C', '0', 'B', '6', '3', '8', '2', 'F', '0',
    '2', '7', '8', '3', '1', '2', '1', 'F', 'C', '0', 'C', '9', '3', 'B', '6', 'D',
    '2', '9', '2', '5', 'F', 'E', 'A', '1', 'E', '8', '6', 'A', '1', 'D', 'B', '3',
    'A', '6', 'A', '6', '2', '4', 'D', 'A', 'B', '2', 'D', '2', '3', '6', 'A', 'A',
    '4', 'E', '8', 'B', 'F', 'A', '9', 'E', '9', '2', 'A', '6', 'A', '6', '6', '9',
    'C', '5', 'D', '6', '8', '5', '9', '7', '0', 'B', '8', '8', 'A', 'D', 'E', '9',
    'A', 'F', '5', 'B', '8', 'D', '7', 'D', 'C', 'F', '2', '8', '8', 'F', 'B', 'C',
    '6', 'E', 'D', '0', '3', '7', '6', '1', '0', '9', '6', 'F', '4', '7', 'F', '3',
    '2', '5', '8', 'C', 'A', 'C', '6', 'D', 'B', 'E', '1', 'E', '1', 'D', '3', 'C',
    '3', '7', '0', 'E', 'B', 'D', '8', '9', '2', 'A', '2', 'D', '7', 'A', '6', 'B',
    'D', '4', '4', '1', 'E', '3', '7', '5', '9', 'A', '6', 'C', 'A', 'A', '2', 'A',
    'B', '7', '9', 'C', 'C', 'F', 'A', 'F', 'E', '8', 'E', 'A', '5', '4', 'A', '0',
    '4', '2', 'C', '6', '2', '2', 'D', '9', '7', '8', 'A', '6', 'E', '7', 'E', 'C',
    'D', '7', 'A', 'C', 'D', '4', 'D', '5', '0', '8', 'D', '0', '1', 'F', '2', '6',
    '5', 'B', '4', '1', '3', '6', '4', '6', '3', '9', '8', '6', '1', 'E', 'E', '0',
    'D', '9', '5', 'A', '2', 'A', '7', 'E', 'A', '2', '8', '1', '8', '4', 'B', '4',
    '8', '9', '7', '7', '3', 'C', 'A', '1', '4', '3', '5', 'B', 'A', '9', 'A', 'F',
    '0', '1', '8', 'B', '6', '9', '4', 'A', '0', 'E', 'E', '1', '4', '6', '3', 'F',
    '9', '5', '4', 'A', 'A', 'B', 'D', '0', '3', '6', '9', '9', 'E', '7', 'C', 'E',
    '0', 'F', '3', '5', '6', 'F', 'B', 'B', 'B', '9', 'D', '2', 'E', 'D', 'B', '5',
    '7', '2', '6', '5', '8', 'B', '5', 'B', '9', 'A', 'B', 'C', '0', '6', 'D', '9',
    '2', '7', '0', '3', 'B', 'E', 'E', 'D', '3', '2', 'B', 'A', '7', '6', '8', '7',
    '8', 'D', 'C', 'B', '8', 'B', '5', '3', 'F', '6', '5', 'B', '7', '8', '3', 'A',
    'D', '8', '7', 'C', '3', 'A', '3', '7', 'C', '3', '1', 'B', 'F', '4', '8', '3',
    '5', '5', 'D', 'D', '3', '9', '0', 'A', '5', '8', '9', 'B', '8', '8', '5', 'E',
    'C', 'A', 'A', '5', 'B', 'A', 'D', '6', '4', 'C', 'A', 'C', '2', 'E', '5', '7',
    'D', 'F', '8', 'B', '1', '2', 'C', '5', '6', '7', 'B', '5', '3', '9', '9', '8',
    'D', 'F', '4', '9', '1', '9', '8', 'E', 'B', '6', 'A', '4', '8', '7', '1', 'E',
    '5', '0', 'F', '2', '7', 'F', '3', 'D', '2', '3', '1', 'C', '5', '2', '1', '1',
    '3', '6', 'E', '0', '1', 'F', '3', '1', '3', '3', 'C', 'C', '9', 'D', '8', 'D',
    '1', '5', '6', '3', 'C', 'C', '0', '8', 'E', '3', '1', '2', '4', 'E', '4', 'B',
    '7', '6', 'C', 'E', '8', '0', 'F', '1', '1', '5', 'E', '7', '6', 'E', 'B', '4',
    '2', 'E', '3', 'E', '7', 'D', 'E', 'C', 'B', 'B', '1', '6', '8', 'B', '0', 'F',
    '1', '6', '8', '3', '9', '4', '4', '8', '8', 'B', 'E', '5', 'E', '7', '0', 'D',
    'E', 'D', '6', 'C', 'C', '5', '7', '3', '2', 'F', 'D', '0', '8', '3', '2', '3',
    'F', '2', 'F', 'B', '9', '6', 'E', 'F', '6', '9', 'A', '0', '3', '4', '5', '6',
    '4', '5', '5', 'F', 'A', '7', '5', '6', '2', '8', '7', 'E', 'E', 'D', 'F', '4',
    'F', '5', '5', '9', 'A', 'C', '2', 'B', 'D', 'A', '5', '6', '3', '5', '8', 'C',
    '7', 'B', '5', '4', '8', '4', '1', '9', 'D', '9', 'C', '6', '1', '1', 'F', 'D',
    '6', 'B', '2', 'B', 'E', 'B', '0', 'A', 'F', '8', '3', '6', '5', '0', '8', '9',
    '9', 'E', '6', '5', '6', 'C', 'E', '3', '8', 'D', '8', 'C', 'C', '5', '7', '8',
    'C', '4', '4', '3', '9', 'B', '4', 'C', '5', '7', 'D', '6', '5', 'B', '5', '0',
    '7', '2', 'C', '3', '5', 'F', '5', '0', '0', '5', 'C', 'B', '6', '8', '3', '6',
    'C', 'C', '9', '3', 'D', '2', 'F', 'C', '7', 'A', 'D', '7', '0', '6', 'B', '4',
    'C', 'A', '2', 'E', '0', '2', '1', '2', '2', '9', 'C', '1', '3', '2', 'D', 'F',
    'D', '5', '9', 'A', '1', '1', '8', '7', 'A', '9', '5', '2', '8', '5', 'C', '1',
    'B', '4', 'B', '2', '3', 'D', 'E', '2', 'A', '3', '4', '7', '8', '1', '3', '5',
    '2', '6', '6', 'B', '7', '7', '0', '9', '9', '8', 'B', '8', '1', '7', '7', 'A',
    '6', '2', '0', '5', '\0'
};
