// ---------------------------------------------------------------------------
// - Mthsid.hxx                                                              -
// - afnix:mth module - serial decoding definition                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2019 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_MTHSRL_HXX
#define  AFNIX_MTHSRL_HXX

#include "Mthsid.hxx"
#include "Rblock.hpp"
#include "Rpoint.hpp"
#include "Rvector.hpp"
#include "Rmatrix.hpp"
#include "Permute.hpp"
#include "Utility.hpp"
#include "Rsamples.hpp"

namespace afnix {
  // the engine dispatch function
  static Serial* srl_deod_mth (const t_word sid) {
    switch (sid) {
    case SRL_RVEC_SID:
      return new Rvector;
      break;
    case SRL_RPNT_SID:
      return new Rpoint;
      break;
    case SRL_RBLK_SID:
      return new Rblock;
      break;
    case SRL_RMTX_SID:
      return new Rmatrix;
      break;
    case SRL_RSPL_SID:
      return new Rsamples;
      break;
    case SRL_PRMT_SID:
      return new Permute;
      break;
    default:
      break;
    }
    throw Exception ("serial-error", "invalid mth module sid code",
		     Utility::tohexa (sid, true, true));
  }
  
  // bind the dispatch function
  static t_word SRL_DEOD_DID = Serial::addsd (SRL_DEOD_MTH, srl_deod_mth);
}

#endif
