'\" t
.\"	aegis - project change supervisor
.\"	Copyright (C) 1990-1995, 1997-1999, 2001, 2002, 2006-2008 Peter Miller
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 3 of the License, or
.\"	(at your option) any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program. If not, see
.\"	<http://www.gnu.org/licenses/>.
.\"
.if n .ftr CB B
.if n .ftr CI I
.if n .ftr CW R
.if n .ftr C  R
.TH "Read Me" Aegis Aegis "Reference Manual"
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.so version.so
.SH NAME
aegis \- project change supervisor
.XX "" "The README File"
.br
.if t .ds C) \(co
.if n .ds C) (C)
Copyright \*(C) \*(Y) Peter Miller
.PP
.I Aegis
is distributed under the terms of the
GNU General Public License.
See the LICENSE section, below, for more details.
.PP
.B aegis
(ee.j.iz)
.I n.,
a protection,
a defense.
.SH DESCRIPTION
.I Aegis
is a CASE tool with a difference.
In the spirit of the UNIX Operating System,
.I Aegis
is a small component designed to work with other programs.
.PP
Many CASE systems attempt to provide everything,
from bubble charts to source control to compilers.
Users are trapped with the components supplied by the CASE system,
and if you don't like one of the components (it may be too limited,
for instance), then that is just tough.
.PP
In contrast,
UNIX provides many components of a CASE system \- compilers,
editors,
dependency maintenance tools (such as make),
source control tools (such as RCS).
You may substitute the tool of your choice
if you don't like the ones supplied with the system \- gcc, jove, cake,
to name just a few.
.I Aegis
adds to this list with software configuration
management,
and true to UNIX philosophy,
.I Aegis
does not
dictate the choice of any of the other tools (although it may stretch them
to their limits).
.PP
Enough hype, what is it that
.I Aegis
does?
Just what is software configuration management?
This question is sufficiently broad as to require a book in answer.
In essence,
.I Aegis
is a project change supervisor.
It provides a
framework within which a team of developers may work on many changes to a
program independently,
and
.I Aegis
coordinates integrating these
changes back into the master source of the program,
with as little disruption as possible.
Resolution of contention for source files,
a major headache for any project with more than one developer,
is one of
.I Aegis'
major functions.
.PP
It should be noted that
.I Aegis
is a developer's tool,
in the same sense as make or RCS are developer's tools.
It is not a manager's tool \- it
does not provide progress tracking or manage work allocation.
.br
.ne 1i
.SH BENEFITS
So why should you use
.IR Aegis ?
.PP
.I Aegis
uses a particular model of the development of software
projects.
This model has a master source (or baseline) of a project,
and a team of developers creating changes to be made to this baseline.
When a change is complete,
it is integrated with the baseline,
to become the new baseline.
Each change must be atomic and self-contained,
no change is allowed to cause the baseline to cease to work.
"Working" is defined as passing it's own tests.
The tests are considered part of the baseline.
.I Aegis
provides support for the developer so that an entire copy of
the baseline need not be taken to change a few files,
only those files which are to be changed need to be copied.
.PP
In order to ensure that changes are unable to
cause the baseline to cease to work,
.I Aegis
mandates that changes be accompanied by at least one test,
and that all such tests be known to complete successfully.
These steadily accumulated tests form an ever increasing
regression test suite for all later changes.
There is also a mandatory review stage for each change to the baseline.
While these requirements may be relaxed per-change or even per-project,
doing so potentially compromises the "working" definition of the baseline.
.PP
The win in using
.I Aegis
is that there are
.I O(n)
interactions between
developers and the baseline.
Contrast this with a master source which is
being edited directly by the developers - there are
.I O(n!)
interactions between
developers - this makes adding "just one more" developer a potential disaster.
.PP
Another win is that the project baseline always works.
Always having a working baseline means that a version is always available for
demonstrations,
or those "pre-release snapshots" we are always forced to provide.
.PP
The above advantages are all very well - for management types.
Why should Joe Average Programmer use
.IR Aegis ?
Recall that RCS provides file locking,
but only for one file at a time.
.I Aegis
provides the file locking,
atomically,
for the set of files in the change.
Recall also that RCS locks the file the instant you start editing it.
This makes popular files a project bottleneck.
.I Aegis
allows concurrent editing,
and a resolution mechanism just before the
change must be integrated,
meaning fewer delays for J.A.Programmer.
.PP
Aegis also has strong support for geographically distributed development.
It supports both push and pull models, and many distribution topologies.
Aegis' normal development process is used to validate received change
sets before committing them.
.br
.ne 1i
.SH ARCHIVE SITE
The latest version of
.I Aegis
is available by HTTP from:
.RS
.TS
tab(;);
l l s
l l l.
URL:;http://www.canb.auug.org.au/~millerp/
File:;aegis.html;# the Aegis page
File:;aegis.\*(v).README;# Description, from tar file
File:;aegis.\*(v).lsm;# Description, in LSM format
File:;aegis.\*(v).ae;# the complete source, aedist format
File:;aegis.\*(v).spec;# RedHat package specification
File:;aegis.\*(v).tar.gz;# the complete source
.TE
.RE
.PP
This directory also contains a few other pieces of software written by me.
Some are referred to in the
.I Aegis
documentation.
Please have a look if you are interested.
.SS Mirrors
See http://www.canb.auug.org.au/~millerp/
for a list of mirror sites.
.br
.ne 2i
.PP
Aegis is also carried by \f(CWmetalab.unc.edu\fP in its Linux archives.
You will be able to find Aegis on any of its mirrors.
.RS
.TS
tab(;);
l l s
l l l.
URL:;ftp://metalab.unc.edu/pub/Linux/devel/vc/
File:;aegis.\*(v).README;# Description, from tar file
File:;aegis.\*(v).lsm;# Description, in LSM format
File:;aegis.\*(v).spec;# RedHat package specification
File:;aegis.\*(v).ae;# the complete source, aedist format
File:;aegis.\*(v).tar.gz;# the complete source
.TE
.RE
This site is extensively mirrored around the world,
so look for a copy near you (you will get much better response).
.br
.ne 1i
.SH MAILING LIST
A mailing list has been created so that users of
.I Aegis
may exchange ideas about how to use
.IR Aegis .
Discussion may include,
but is not limited to:
bugs, enhancements, and applications.
The list is not moderated.
.PP
The address of the mailing list is
.RS
.ft CW
aegis-users@auug.org.au
.ft R
.RE
Please
.if n DO NOT
.if t \fBdo not\fP
attempt to subscribe by sending email to this address.
It is for content only.
.SS How To Subscribe
To subscribe to this mailing list, visit the
Aegis-users mailing list page
(\f[CW]http://\%www.auug.org.au/\%mailman/\%listinfo/\%aegis-users\fP)
and go through the \fBsubscribe\fP dialogue.
.SS Archive
The mailing list is archived at eGroups.
The URL is \f(CWhttp://www.egroups.com/list/aegis-users/info.html\fP
.SS No Files By EMail
The software which handles this mailing list
.if n CANNOT
.if t .B cannot
send you a copy of
.IR Aegis .
Please use FTP or ftp-by-email, instead.
.br
.ne 1i
.SH BUILDING
Instructions on how to build and test
.I Aegis
are to be found in the
.I BUILDING
file included in this distribution.
.br
.ne 1i
.SH SOME HISTORY
The idea for
.I Aegis
did not come full-blown into my head in the shower,
as some of my programs do,
but rather from working in a software shop
which used a simplistic form of something similar.
That system was held together by chewing-gum and string,
it was written in a disgusting variant of Basic,
and by golly the damn thing worked (mostly).
.I Aegis
is nothing like it,
owes none of its code to that system,
and is far more versatile.
It turns out that the system used is nothing new,
and is described in many SCM textbooks;
it is the result of systematically resolving development issues
for large-ish teams.
.PP
Since that company decided to close down our section
(the company was under attack by a hostile takeover bid)
we all moved on simultaneously (all 60 of us),
sometimes working together,
and sometimes not,
but always keeping in touch.
With suggestions and conversations with
some of them early in 1990,
the manual entries for
.I Aegis
took shape,
and formed most of the design document for
.IR Aegis .
.PP
Since getting the first glimmerings of a functional
.I Aegis
late in 1990 it
is increasingly obvious that I never want to be without it ever again.
All of my sources that I modify are instantly placed under
.IR Aegis ,
as is anything I distribute.
All code I write for myself,
and all new code I write for my employer,
goes under
.IR Aegis .
Why?
Because it has fewer bugs!
.PP
Example: one of the sources I carry with me from job to job is "cook",
my dependency maintenance tool.
Cook had existed for 3 years before
.I Aegis
appeared on the scene,
and I used it daily.
When I placed cook under
.IR Aegis ,
I found 6 bugs!
Since then I have found a few more.
Not only are there now fewer bugs,
but they never come back,
because the regression test suite always grows.
.SS Branching
In 1997 the full branching support was released (it took nearly 18 months
to retro-fit.  The underlying data structures for projects and change
sets need to be merged.  While I noticed back in 1990 that they were
very similar, it wasn't until branch support design was well underways
that they should have been the same  data structure from the beginning.
.SS Geographically Distributed Development
In 1999 a conversation on the \f(CWaegis-users\fP mailing list resulted
in the creation of \fIaedist\fP, a program which packages and unpackages
Aegis changes so they can be sent by e-mail, or WWW or whatever.
With 20:20 hindsight, this could have been done way back in 1991,
because the basic idea builds on Aegis change process model.
.br
.ne 1i
.so windows.so
.br
.ne 1i
.SH LICENSE
.I Aegis
is free software;
you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation;
either version 3 of the License,
or (at your option) any later version.
.PP
.I Aegis
is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License along
with this program. If not, see <http://www.gnu.org/licenses/>.
.PP
It should be in the
.I LICENSE
file included in this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l r l.
Peter MillerE-Mail:;millerp@canb.auug.org.au
\f(CW/\e/\e*\fR;WWW:;http://www.canb.auug.org.au/~millerp/
.TE
.bp
.SH RELEASE NOTES
For excruciating detail,
.XX "" "Release Notes"
and also acknowledgments of those who generously sent me feedback,
please see the
.I etc/CHANGES.*
files included in this distribution.
.\" .SS Statistics
.\" The following statistics were collected from the project source files:
.\" .so proj_metric.so
.SS Upgrading
In general, all the machines on your network need to be running the same
release of Aegis.  While the database format is backwards compatible,
it is rarely forwards compatible in the face of new capabilities.
.so new.so
