/*
 *  acm - Commands interpreter
 *  Copyright (C) 2007 Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include "players.h"
#include "pm.h"
#include "terminal.h"

#define commands_IMPORT
#include "commands.h"

#define MAX_ARGC 5


static void split_cmd(char *cmd, int *argc, char *argv[])
{
	int n;
	char *p;

	n = 0;

	p = strtok(cmd, " \t");
	while( p != NULL && n < MAX_ARGC ){
		argv[n] = p;
		n++;
		p = strtok(NULL, " \t");
	}
	*argc = n;
}


static void parse_set(viewer *u, int argc, char *argv[])
{
	if( argc != 3 ){
		terminal_write(u, "ERROR: expected `set VAR VALUE'\r\n");
		return;
	}

	if( strcmp(argv[1], "xView") == 0 )
		u->v->Middl.x = atoi(argv[2]);
	
	else if( strcmp(argv[1], "yView") == 0 ){
		u->v->Middl.y = atoi(argv[2]);
	
	/*********
	} else if( strcmp(argv[1], "dist") == 0 ){
		u->v->dist = atof(argv[2]);
		resizePlayerWindow(u->c, u, u->width, u->win_height, FALSE, u->hud_mode);
	
	} else if( strcmp(argv[1], "xscaleFactor") == 0 ){
		u->xscaleFactor = atof(argv[2]);
		resizePlayerWindow(u->c, u, u->width, u->win_height, FALSE, u->hud_mode);
	
	} else if( strcmp(argv[1], "Scale") == 0 ){
		u->v->Scale.x = atof(argv[2]);
		u->v->Scale.y = atof(argv[2]);
		u->v->Scale.z = atof(argv[2]);
		resizePlayerWindow(u->c, u, u->width, u->win_height, FALSE, u->hud_mode);
	************/
	
	
	} else
		terminal_write(u, "ERROR: unknow variable\r\n");
}


static void print_double(viewer *u, char *name, double value, char *unit)
{
	char s[100];

	terminal_write(u, name);
	terminal_write(u, " = ");
	sprintf(s, "%f", value);
	terminal_write(u, s);
	terminal_write(u, " ");
	terminal_write(u, unit);
	terminal_write(u, "\r\n");
}


void commands_execute(viewer *u, char *cmd)
{
	int argc;
	char *argv[MAX_ARGC];

	split_cmd(cmd, &argc, argv);

	if( argc == 0 )
		return;

	if( strcmp(argv[0], "help") == 0 ){
		terminal_write(u, "Currently availablecommands\r\n"
			"   help\r\n"
			"   create\r\n"
		);

	} else if( strcmp(argv[0], "v") == 0 ){
		print_double(u, "Vs0", u->c->cinfo->Vs0, "KT");
		print_double(u, "Vs1", u->c->cinfo->Vs1, "KT");
		print_double(u, "Vfe", u->c->cinfo->Vfe, "KT");
		print_double(u, "Vno", u->c->cinfo->Vno, "KT");
		print_double(u, "Vne", u->c->cinfo->Vne, "KT");
		print_double(u, "Alpha Stall", units_RADtoDEG(u->c->cinfo->alpha_stall), "DEG");
		print_double(u, "MTOW", u->c->cinfo->MTOW, "lb");
		print_double(u, "Total Mass",
			u->c->cinfo->emptyWeight + u->c->fuel + u->c->payload, "lb");
	
	} else if( strcmp(argv[0], "create") == 0 ){
		/****
		if( players_new(STDERR_FILENO, ":0.0", "Mate", "|-geometry|937x737+0+0|-scale|1.5|-no-sound|1|-plane|C-172|-force|Other|-fuel|100|-payload|150"
			) != 0 ){
			terminal_write(u, "FAILED\r\n");
		}
		*****/
		/*****
		if( planes_newPlane("C-172") != 0 ){
			terminal_write(u, "FAILED\r\n");
		}
		******/
		/*****
		newDrone(u->c, "C-172");
		ptbl[1].type = CT_PLANE;
		*****/
	
	} else if( strcmp(argv[0], "set") == 0 ){
		parse_set(u, argc, argv);
	
	} else {
		terminal_write(u, "ERROR: unknown command. Type `help' for help.\r\n");
	}
}


/* End of the commands module */
