#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <assert.h>
#include <string.h>

#include "../../../src/dis/dis/dis.h"


int main(int argc, char** argv)
{
	dis_entity_type et;
	
	assert( ! dis_parseEntityType(NULL, &et) );
	assert( ! dis_parseEntityType("", &et) );
	assert( ! dis_parseEntityType("......", &et) );
	assert( ! dis_parseEntityType("zzzz", &et) );
	
	assert( dis_parseEntityType(" 1.2.3.4.5.6.7  ", &et) );
	assert( strcmp(dis_entityTypeToString(&et), "1.2.3.4.5.6.7") == 0 );
	
	// min
	assert( dis_parseEntityType("0.0.0.0.0.0.0", &et) );
	assert( strcmp(dis_entityTypeToString(&et), "0.0.0.0.0.0.0") == 0 );
	
	// max
	assert( dis_parseEntityType("255.255.65535.255.255.255.255", &et) );
	assert( strcmp(dis_entityTypeToString(&et), "255.255.65535.255.255.255.255") == 0 );
	
	// out of the range:
	assert( ! dis_parseEntityType("999.0.0.0.0.0.0", &et) );
	assert( ! dis_parseEntityType("0.999.0.0.0.0.0", &et) );
	assert( ! dis_parseEntityType("0.0.99999.0.0.0.0", &et) );
	assert( ! dis_parseEntityType("0.0.0.999.0.0.0", &et) );
	assert( ! dis_parseEntityType("0.0.0.0.999.0.0", &et) );
	assert( ! dis_parseEntityType("0.0.0.0.0.999.0", &et) );
	assert( ! dis_parseEntityType("0.0.0.0.0.0.999", &et) );
	
	// too many digits:
	assert( ! dis_parseEntityType("999999.0.0.0.0.0.0", &et) );
	
	et = (dis_entity_type){0, 0, 0, 0, 0, 0, 0};
	assert( strcmp(dis_entityTypeToString(&et), "0.0.0.0.0.0.0") == 0 );

	return 0;
}

