/*
 *  acm : an aerial combat simulator for X
 *  Magnetic compass module
 *  Copyright (C) 2007  Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * This module simulates the magnetic compass for didactic purposes.
 * Components of the local magnetic vector are calculated by the wmm module.
 * 
 * The compass rotates under the effect of the torque produced by the Earth
 * magnetic field and it is braked by its inertia and by the viscosity of
 * the fluid.
 * 
 * @file
 */

#ifndef _magnetic_compass_h
#define _magnetic_compass_h

#include "pm.h"

#ifdef magnetic_compass_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Enables the magnetic compass for this particular viewer.
 * If u->magnetic_compass is NULL, instantiate with a pointer to internal data.
 */
EXTERN void magnetic_compass_enable(viewer *u);

/**
 * Disable the magnetic compass for this particular viewer.
 */
EXTERN void magnetic_compass_disable(viewer *u);

/**
 * Release magnetic_compass data u->magnetic_compass.
 */
EXTERN void magnetic_compass_free(viewer *u);

/**
 * Magnetic compass state update.
 */
EXTERN void magnetic_compass_update(viewer * u);

/**
 * Draw magnetic compass only if MH display is enabled; does nothing in TH mode.
 * If no magnetic compass active in this viewer, do nothing.
 */
EXTERN void magnetic_compass_draw(viewer * u);

#undef EXTERN
#endif
