; This file was initially generated automatically from legacy documentation
; strings.  See source files in this directory for copyright and license
; information.

(in-package "ACL2")

(include-book "xdoc/top" :dir :system)

(defxdoc mem::address-p
  :parents (mem::memory)
  :short "Recognizes valid addresses for a particular memory"
  :long "@({
     (MEM::address-p addr mem)
 })

 <p>@('address-p') is guarded with @('(memory-p mem)').</p>

 <p>@('address-p') returns true if @('addr') is a valid address for @('mem') --
 that is, if @('(and (natp addr) (< addr (size mem)))').  It is not @(see
 mem::private), and is left enabled by default.</p>

 <p>See @(see mem::memory).</p>")

(defxdoc mem::load
  :parents (mem::memory)
  :short "Access memory, retrieving the value at some address"
  :long "@({
     (MEM::load addr mem)
 })

 <p>@('load') has a guard that requires @('(memory-p mem)') and also requires
 @('(address-p addr mem)').</p>

 <p>@('load') looks up the current value stored at @('addr') in @('mem') and
 returns that value to the user.  This is analagous to @('nth'), @('assoc'),
 @('aref1'), and so forth.  The implementation of load is @(see
 mem::private).</p>

 <p>See @(see mem::memory), see @(see mem::memory-p), see @(see mem::address-p)
 and also see @(see mem::store).</p>")

(defxdoc mem::memory
  :parents (mem::memory)
  :short "Special records designed for array-like usage"
  :long "<p>Memories are specialized records that are designed for array-like
 usage.  Memories have a fixed size, and elements are accessed by the natural
 numbers 0, 1, ..., size-1, where size is the maximum size of the memory.</p>

 <p>Unlike arrays, memories are based on binary trees.  As a result, loading
 and storing into memories is slower than array access in a typical programming
 language, and requires an O(log_2 n) search for the right element.  However,
 there are benefits to this system as well.  We populate the tree structure as
 needed when writes occur, allowing us to conceptually represent very large
 arrays so long as we use them sparesely.  Hence, memories are well suited for
 uses such as simulating the memory systems of processors or virtual machines
 with many gigabytes of memory, only some of which is used during
 simulation.</p>

 <p>Memories are as easy to reason about as records (see misc/records.lisp) and
 we provide the same core 'record theorems' about them.  However, the load and
 store operations on memories are guarded more strongly than the records
 book.</p>

 <p>See @(see arrays) and also see @(see stobjs) for more efficient
 implementations of small arrays.  The records book (misc/records.lisp)
 provides the same reasoning strategy as memories, and may be an appropriate
 substitution for memories depending upon your needs.</p>")

(defxdoc mem::memory-p
  :parents (mem::memory)
  :short "Recognizes valid @(see mem::memory) structures"
  :long "@({
     (MEM::memory-p mem)
 })

 <p>@('memory-p') has a guard of @('t') and can be called on any object.</p>

 <p>@('memory-p') returns @('t') if @('mem') is a memory, @('nil')
 otherwise.</p>

 <p>The implementation of memory-p is @(see mem::private).</p>

 <p>See @(see mem::memory) and also see @(see mem::new)</p>")

(defxdoc mem::new
  :parents (mem::memory)
  :short "Create a new memory object with a given capacity"
  :long "@({
     (MEM::new size)
 })

 <p>@('new') is guarded so that @('size') must be a positive integer.</p>

 <p>@('new') creates a new memory structure with the given capacity.  For
 example, @('(new 30)') creates a memory that can hold 30 elements.  The
 capacity of a memory is fixed througout its lifetime.  The implementation of
 @('new') is @(see mem::private).</p>

 <p>See @(see mem::memory), see @(see mem::memory-p) and also see @(see
 mem::address-p).</p>")

(defxdoc mem::private
  :parents (mem::private)
  :short "Redundantly define, then serverely restrict the usage of some function"
  :long "@({
  Example:
     (private foo (x y)
        (if (atom x)
            ...))
 })

 <p>@('private') is a macro which may be useful for authors of libraries, or to
 users who want to enforce severe discipline upon themselves.</p>

 <p>The macro is similar to defund (See @(see defund)) in that it first
 introduces a defun and then immediately disables its definition.  However,
 @('private') goes further -- it also disables the resulting type-prescription
 rule and sets up theory invariants that prohibit the user from ever enabling
 the definition or the type prescription.</p>

 <p>Why would we want such a thing?  A nice way to develop libraries is to use
 redundant definitions (See @(see set-enforce-redundancy)) in an interface
 file, so that users never even see the local lemmas and so forth that you used
 to get the proofs to go through.  This gives you the freedom to change and
 remove those definitions at will.</p>

 <p>Unfortunately, you cannot do the same for functions, because ACL2 needs the
 functions available in the interface book if they are ever used.  With
 @('private'), you can identify functions that you want to keep control over
 and that the user should either (1) not be using at all, or (2) only be
 reasoning about using the theorems your have provided.</p>

 <p>To use private, simply copy your @('(defun foo ...)') form into your
 interface file, then replace @('defun') with @('private').</p>")

(defxdoc mem::size
  :parents (mem::memory)
  :short "Returns the capacity of a memory structure"
  :long "@({
     (MEM::size mem)
 })

 <p>@('size') is guarded with @('(memory-p mem)').</p>

 <p>@('size') returns the capacity of a memory, i.e., the number of elements
 that the memory can hold.  Addresses for @('mem') are naturals in the range
 @('0') through @('(size mem) - 1').</p>

 <p>A memory's size is specified when it is created with @('new'), and is fixed
 throughout its lifetime.  The implementation of @('size') is @(see
 mem::private).</p>

 <p>See @(see mem::memory) and also see @(see mem::new).</p>")

(defxdoc mem::store
  :parents (mem::memory)
  :short "Update memory, overwriting an address with a new value"
  :long "@({
     (MEM::store addr elem mem)
 })

 <p>@('store') has a guard that requires @('(memory-p mem)') and also requires
 @('(address-p addr mem)').</p>

 <p>@('store') returns a copy of @('mem'), except that the element at address
 @('addr') is overwritten with @('elem').  This is analagous to
 @('update-nth'), @('acons'), @('aset1'), and the like.  The implementation of
 @('store') is @(see mem::private).</p>

 <p>See @(see mem::memory), see @(see mem::memory-p), see @(see
 mem::address-p), and also see @(see mem::load).</p>")
