/*
    ACfax - Fax reception with X11-interface for amateur radio
    Copyright (C) 1995-1998 Andreas Czechanowski, DL4SDC

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    andreas.czechanowski@ins.uni-stuttgart.de
*/
    
/*
 * widgets.c - prepare, create and configure all these widgets we need
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef USE_XAW3D
/* #include <X11/Xaw3d/ThreeD.h> */
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/MenuButton.h>
#include <X11/Xaw3d/Toggle.h>
#include <X11/Xaw3d/Viewport.h>
#include <X11/Xaw3d/Box.h>
#include <X11/Xaw3d/SimpleMenu.h>
#include <X11/Xaw3d/SmeBSB.h>
#include <X11/Xaw3d/AsciiText.h>
#include <X11/Xaw3d/Scrollbar.h>
#else
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>
#endif

#include "FChooser.h"
#include "Canvas.h"
#include "fax_funcs.h"
#include "global.h"
#include "widgets.h"

/* extern XtAppContext	mainapp; */
/* Widget	toplevel; */
Widget	last;		/* just for convenience.... */

struct modem_ws		mod_s;
struct runctl_ws	run_s;
struct dirctl_ws	dir_s;
struct polctl_ws	pol_s;
struct adjctl_ws	adj_s;
struct numval_ws	num_s;
struct file_menu	file_m;
struct info_popup	info_s;
struct file_browser	fileb_s;

Widget	fax_shell,
	fax_form,
	disp_form,	/* form for the image-display */
	vport,		/* a viewport to look thru onto the canvas */
	canvas;		/* widget holding picture using XImages */


Pixmap	px_horiz,
	px_vert,
	px_right,
	px_left,
	px_top,
	px_bottom,
	px_normal,
	px_invers,
	px_nphs,
	px_iphs,
	px_azimut,
	px_shift,
	px_stop,
	px_syn,
	px_run,
	px_mam,
	px_mfm,
	px_narrow,
	px_middle,
	px_wide;

XtTranslations txt_trans;	/* translations for numeric entries */
XtTranslations name_trans;	/* translations for name-entry */

static void fchs_cb(Widget, XtPointer, XtPointer);
static void file_ok_cb(Widget, XtPointer, XtPointer);
static void file_cancel_cb(Widget, XtPointer, XtPointer);
static void end_simple_info(Widget, XtPointer, XtPointer);

/*
 * all the following widget-creation functions return their "top-level"
 * widget (a form-widget) so that these blocks can be arranged in a
 * frame (also a form-widget) using the XtNfromVert and XtNfromHoriz
 * parameters.
 */

/* create the modem-control-widgets */
Widget cr_modemform(Widget parent)
{
  int iwd;

  mod_s.form = XtVaCreateManagedWidget("modemform", formWidgetClass, parent,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		/* XtNfromVert, menuform, */
		/* XtNfromHoriz, filebut, */
		NULL);
  XtVaGetValues(mod_s.form, XtNdefaultDistance, &iwd, NULL);

  /* the modem control widgets */
  mod_s.modemdesc = XtVaCreateManagedWidget("modemdesc", labelWidgetClass, mod_s.form,
		XtNwidth, (6*32+5*iwd),
		XtNborderWidth, 0,
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  last = mod_s.modemdesc;

  mod_s.modinfo = XtVaCreateManagedWidget("modinfo", labelWidgetClass, mod_s.form,
		XtNwidth, (2*32+iwd),
		XtNheight, 32,
		XtNborderWidth, 0,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  mod_s.mmode = XtVaCreateManagedWidget("mmode", toggleWidgetClass, mod_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNlabel, "",
		XtNfromVert, last,
		XtNfromHoriz, mod_s.modinfo,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  mod_s.filinfo = XtVaCreateManagedWidget("filinfo", labelWidgetClass, mod_s.form,
		XtNwidth, (2*32+iwd),
		XtNheight, 32,
		XtNborderWidth, 0,
		XtNfromVert, last,
		XtNfromHoriz, mod_s.mmode,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  mod_s.mfilter = XtVaCreateManagedWidget("mfilter", menuButtonWidgetClass,
		mod_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNlabel, "",
		XtNfromVert, last,
		XtNfromHoriz, mod_s.filinfo,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNmenuName, "filtermenu",
		NULL);
  mod_s.mflpd = XtVaCreatePopupShell("filtermenu", simpleMenuWidgetClass,
		mod_s.mfilter,
		NULL);
  mod_s.mflt1 = XtVaCreateManagedWidget("mflt1", smeBSBObjectClass, mod_s.mflpd,
		NULL);
  mod_s.mflt2 = XtVaCreateManagedWidget("mflt2", smeBSBObjectClass, mod_s.mflpd,
		NULL);
  mod_s.mflt3 = XtVaCreateManagedWidget("mflt3", smeBSBObjectClass, mod_s.mflpd,
		NULL);

  last = mod_s.modinfo;

  mod_s.fmdevinfo = XtVaCreateManagedWidget("fmdevinfo", labelWidgetClass, mod_s.form,
		XtNborderWidth, 0,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  mod_s.fmdevval = XtVaCreateManagedWidget("fmdevval", asciiTextWidgetClass, mod_s.form,
		XtNlength, 4,
		XtNwidth, 44,
		XtNstring, "",
		XtNeditType, XawtextEdit,
		XtNtranslations, txt_trans,
		XtNfromHoriz, mod_s.fmdevinfo,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  last = mod_s.fmdevinfo;

  mod_s.siginfo = XtVaCreateManagedWidget("siginfo", labelWidgetClass, mod_s.form,
		XtNborderWidth, 0,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  mod_s.sigbar = XtVaCreateManagedWidget("sigbar", scrollbarWidgetClass, mod_s.form,
		XtNwidth, 160,
		XtNheight, 16,
		XtNsensitive, True,
		XtNorientation, XtorientHorizontal,
		XtNminimumThumb, 2,
		XtNfromHoriz, mod_s.siginfo,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  return mod_s.form;
}

/* create the run-control widgets (stop, sync, run) */
Widget cr_faxctrls(Widget parent)
{
  Widget n_form;
  int iwd;

  n_form = XtVaCreateManagedWidget("faxctrls", formWidgetClass, parent,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		/* XtNfromVert, menuform, */
		/* XtNfromHoriz, modemform, */
		NULL);
  XtVaGetValues(n_form, XtNdefaultDistance, &iwd, NULL);

  /* the run-control widgets (stop, sync, run) */
  run_s.form =  XtVaCreateManagedWidget("runctlform", formWidgetClass, n_form,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNborderWidth, 0,
		NULL);

  run_s.runinfo = XtVaCreateManagedWidget("runinfo", labelWidgetClass, run_s.form,
		XtNwidth, (3*32+2*iwd),
		XtNheight, 32,
		XtNborderWidth, 0,
		/* XtNshadowWidth, 2, */
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  last = run_s.runinfo;
  run_s.rmstop = XtVaCreateManagedWidget("rmstop", toggleWidgetClass, run_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNradioData, FAX_APT,
		XtNlabel, "",
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  run_s.rmsyn = XtVaCreateManagedWidget("rmsyn", toggleWidgetClass, run_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNradioGroup, run_s.rmstop,
		XtNradioData, FAX_PHAS,
		XtNlabel, "",
		XtNfromHoriz, run_s.rmstop,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  run_s.rmrun = XtVaCreateManagedWidget("rmrun", toggleWidgetClass, run_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNradioGroup, run_s.rmstop,
		XtNradioData, FAX_RX,
		XtNlabel, "",
		XtNfromHoriz, run_s.rmsyn,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  /* the direction control widgets (with description) */
  dir_s.form =  XtVaCreateManagedWidget("dirctlform", formWidgetClass, n_form,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNfromHoriz, run_s.form,
		XtNborderWidth, 0,
		NULL);
		
  dir_s.dirinfo = XtVaCreateManagedWidget("dirinfo", labelWidgetClass, dir_s.form,
		XtNwidth, (3*32+2*iwd),
		XtNheight, 32,
		XtNborderWidth, 0,
		/* XtNshadowWidth, 2, */
		/* XtNfromHoriz, last, */
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  last = dir_s.dirinfo;
  dir_s.dirhv = XtVaCreateManagedWidget("dirhv", toggleWidgetClass, dir_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNlabel, "",
		/* XtNfromHoriz, runinfo, */
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  dir_s.dirlr = XtVaCreateManagedWidget("dirlr", toggleWidgetClass, dir_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNlabel, "",
		XtNfromHoriz, dir_s.dirhv,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  dir_s.dirtb = XtVaCreateManagedWidget("dirtb", toggleWidgetClass, dir_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNlabel, "",
		XtNfromHoriz, dir_s.dirlr,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  /* the polarity switch (normal or inverse) */
  pol_s.form =  XtVaCreateManagedWidget("polartyform", formWidgetClass, n_form,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNfromHoriz, dir_s.form,
		XtNborderWidth, 0,
		NULL);
		
  pol_s.polinfo = XtVaCreateManagedWidget("polinfo", labelWidgetClass, pol_s.form,
		XtNwidth, (2*32+iwd),
		XtNheight, 32,
		XtNborderWidth, 0,
		/* XtNshadowWidth, 2, */
		/* XtNfromHoriz, last, */
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  pol_s.norinv = XtVaCreateManagedWidget("norinv", toggleWidgetClass, pol_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNlabel, "normal",
		/* XtNfromHoriz, dirtb, */
		XtNfromHoriz, pol_s.polinfo,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  /* the phase-in-polarity control */
  pol_s.phsinfo = XtVaCreateManagedWidget("phsinfo", labelWidgetClass, pol_s.form,
		XtNwidth, (2*32+iwd),
		XtNheight, 32,
		XtNborderWidth, 0,
		/* XtNshadowWidth, 2, */
		XtNfromVert, pol_s.polinfo,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  pol_s.posneg = XtVaCreateManagedWidget("posneg", toggleWidgetClass, pol_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNfromHoriz, pol_s.phsinfo,
		XtNfromVert, pol_s.norinv,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  /* the re-adjustment buttons (line shifting and frequency-correction) */
  adj_s.form =  XtVaCreateManagedWidget("adj_sform", formWidgetClass, n_form,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNfromHoriz, pol_s.form,
		XtNborderWidth, 0,
		NULL);
		
  adj_s.adjinfo = XtVaCreateManagedWidget("adjinfo", labelWidgetClass, adj_s.form,
		XtNwidth, (2*32+iwd),
		XtNheight, 32,
		XtNborderWidth, 0,
		/* XtNshadowWidth, 2, */
		/* XtNfromHoriz, last, */
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  last = adj_s.adjinfo;
  adj_s.lshift = XtVaCreateManagedWidget("lshift", commandWidgetClass, adj_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		/* XtNfromHoriz, posneg, */
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  adj_s.azimut = XtVaCreateManagedWidget("azimut", commandWidgetClass, adj_s.form,
		XtNwidth, 32,
		XtNheight, 32,
		XtNfromHoriz, adj_s.lshift,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  return n_form;
}

/* create form with numerical FAX-parameters */
Widget cr_faxparams(Widget parent)
{
  int iwd;

  num_s.form = XtVaCreateManagedWidget("faxparams", formWidgetClass, parent,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		/* XtNfromVert, menuform, */
		/* XtNfromHoriz, faxformA, */
		NULL);
  XtVaGetValues(num_s.form, XtNdefaultDistance, &iwd, NULL);

  /* the numerical entry fields */
  num_s.numinfo = XtVaCreateManagedWidget("numinfo", labelWidgetClass, num_s.form,
		XtNwidth, (11*32+18*iwd),
		XtNborderWidth, 0,
		/* XtNshadowWidth, 2, */
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  last = num_s.numinfo;
  num_s.lpmtxt = XtVaCreateManagedWidget("lpmtxt", labelWidgetClass, num_s.form,
		XtNborderWidth, 0,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  num_s.lpmval = XtVaCreateManagedWidget("lpmval", asciiTextWidgetClass, num_s.form,
		XtNlength, 4,
		XtNwidth, 44,
		XtNstring, "",
		XtNeditType, XawtextEdit,
		XtNtranslations, txt_trans,
		XtNfromHoriz, num_s.lpmtxt,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  num_s.ioctxt = XtVaCreateManagedWidget("ioctxt", labelWidgetClass, num_s.form,
		XtNborderWidth, 0,
		XtNfromHoriz, num_s.lpmval,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  num_s.iocval = XtVaCreateManagedWidget("iocval", asciiTextWidgetClass, num_s.form,
		XtNlength, 4,
		XtNwidth, 44,
		XtNstring, "",
		XtNeditType, XawtextEdit,
		XtNtranslations, txt_trans,
		XtNfromHoriz, num_s.ioctxt,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  num_s.statxt = XtVaCreateManagedWidget("statxt", labelWidgetClass, num_s.form,
		XtNborderWidth, 0,
		XtNfromHoriz, num_s.iocval,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  num_s.staval = XtVaCreateManagedWidget("staval", asciiTextWidgetClass, num_s.form,
		XtNlength, 4,
		XtNwidth, 44,
		XtNstring, "",
		XtNeditType, XawtextEdit,
		XtNtranslations, txt_trans,
		XtNfromHoriz, num_s.statxt,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);

  num_s.stotxt = XtVaCreateManagedWidget("stotxt", labelWidgetClass, num_s.form,
		XtNborderWidth, 0,
		XtNfromHoriz, num_s.staval,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		NULL);
  num_s.stoval = XtVaCreateManagedWidget("stoval", asciiTextWidgetClass, num_s.form,
		XtNlength, 4,
		XtNwidth, 44,
		XtNstring, "",
		XtNeditType, XawtextEdit,
		XtNtranslations, txt_trans,
		XtNfromHoriz, num_s.stotxt,
		XtNfromVert, last,
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNtop, XtChainTop,
		XtNbottom, XtChainBottom,
		NULL);

  return num_s.form;
}

/* create the menu-bar with the menuButtons and their pulldown-menus */
Widget cr_menubar(Widget parent)
{
  Widget n_form;

  n_form = XtVaCreateManagedWidget("menuform", formWidgetClass, parent,
		XtNborderWidth, 0,
		NULL);

  file_m.butn = XtVaCreateManagedWidget("filebut", menuButtonWidgetClass, n_form,
		XtNwidth, 80,
		XtNheight, 20,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNmenuName, "file_mw",
		NULL);
  file_m.menu = XtVaCreatePopupShell("file_mw", simpleMenuWidgetClass, file_m.butn,
		NULL);
  file_m.autosave = XtVaCreateManagedWidget("autosave", smeBSBObjectClass, file_m.menu,
		NULL);
  file_m.saveas = XtVaCreateManagedWidget("saveas", smeBSBObjectClass, file_m.menu,
		NULL);
  file_m.close = XtVaCreateManagedWidget("close", smeBSBObjectClass, file_m.menu,
		NULL);
  file_m.quit = XtVaCreateManagedWidget("quit", smeBSBObjectClass, file_m.menu,
		NULL);

  return n_form;
}

Widget cr_infopop(Widget parent)
{
  info_s.shell = XtVaCreatePopupShell("info_shell", applicationShellWidgetClass,
		parent,
		XtNallowShellResize, True,
		/* XtNwidth, 260, */
		/* XtNheight, 120, */
		NULL);
  info_s.form = XtVaCreateManagedWidget("info_form", formWidgetClass, info_s.shell,
		XtNresizable, True,
		NULL);
  info_s.text = XtVaCreateManagedWidget("info_text", labelWidgetClass, info_s.form,
/*
		XtNlabel, "1234567890123456789012345678901234567890\n\nX",
*/
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNresizable, True,
		NULL);
  info_s.butn = XtVaCreateManagedWidget("info_butn", commandWidgetClass, info_s.form,
		XtNlabel, "big_enough",
		XtNfromVert, info_s.text,
		NULL);

  return info_s.shell;
}

void create_filebrowser(Widget parent)
{
  XtAccelerators okacc;		/* accelerators for OK-button */
  XtAccelerators canacc;	/* accelerators for cancel-button */

  fileb_s.shell = XtVaCreatePopupShell("file_shell", transientShellWidgetClass,
		parent,
		XtNtitle, "File selector",
		NULL);

  okacc = XtParseAcceleratorTable("#override\n\
		<Key>Return: set() notify() unset()\n\
		<Key>Linefeed: set() notify() unset()");

  canacc = XtParseAcceleratorTable("#override\n\
		<Key>Escape: set() notify() unset()");

  fileb_s.form = XtVaCreateManagedWidget("file_form", formWidgetClass, fileb_s.shell,
		NULL);
  fileb_s.fchs = XtVaCreateManagedWidget("file_fch", xfwfFileChooserWidgetClass,
		fileb_s.form,
		XtNwidth, 320,
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNtop, XtChainTop,
		XtNbottom, XtChainBottom,
		NULL);
  fileb_s.okbut = XtVaCreateManagedWidget("file_ok", commandWidgetClass,
		fileb_s.form,
		XtNwidth, 64,
		XtNheight, 24,
		XtNlabel, "Ok",
		XtNaccelerators, okacc,
		XtNfromHoriz, fileb_s.fchs,
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNtop, XtChainTop,
		XtNbottom, XtChainBottom,
		NULL);
  fileb_s.cancel = XtVaCreateManagedWidget("file_cancel", commandWidgetClass,
		fileb_s.form,
		XtNwidth, 64,
		XtNheight, 24,
		XtNlabel, "cancel",
		XtNaccelerators, canacc,
		XtNfromHoriz, fileb_s.fchs,
		XtNfromVert, fileb_s.okbut,
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNtop, XtChainTop,
		XtNbottom, XtChainBottom,
		NULL);
  fileb_s.fname = XtVaCreateManagedWidget("file_name", asciiTextWidgetClass,
		fileb_s.form,
		XtNlength, 40,
		XtNwidth, 384,
		XtNeditType, XawtextEdit,
		XtNfromVert, fileb_s.fchs,
		XtNleft, XtChainLeft,
		XtNright, XtChainRight,
		XtNtop, XtChainTop,
		XtNbottom, XtChainBottom,
		NULL);

  XtSetKeyboardFocus(fileb_s.form, fileb_s.fname);
  XtInstallAccelerators(fileb_s.fname, fileb_s.okbut);
  XtAddCallback(fileb_s.okbut, XtNcallback, file_ok_cb, (XtPointer)NULL);
  XtAddCallback(fileb_s.cancel, XtNcallback, file_cancel_cb, (XtPointer)NULL);
  XtAddCallback(fileb_s.fchs, XtNcallback, fchs_cb, (XtPointer)NULL);
}

/* callback for the fileChooser-widget: update the filename-display */
static void fchs_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
  char *fname;

  XtVaGetValues(fileb_s.fchs, XtNcurrentFile, &fname, NULL);
  XtVaSetValues(fileb_s.fname, XtNstring, fname, NULL);
  /* anything else to do ? */
}

/* callback for Ok-button: get name from filename-display */
static void file_ok_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
  char *fname;
  char *path;

  XtVaGetValues(fileb_s.fname, XtNstring, &fname, NULL);
  XtVaGetValues(fileb_s.fchs, XtNcurrentDirectory, &path, NULL);
  /* look if there is an absolute pathname given */
  if (*fname == '/') {
    strcpy(fileb_s.name, fname);
  } else {
    strcpy(fileb_s.name, path);
    strcat(fileb_s.name, fname);
  }
  /* remember directory for next time */
  strcpy (fileb_s.fsarg->dir_io, path);
  /* call the function */
  fileb_s.fsarg->file_act(fileb_s.name);
  XtPopdown(fileb_s.shell);
}

static void file_cancel_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown(fileb_s.shell);
}

void query_filename(struct fileshell_args *fst)
{
  if (fst->title) {
    XtVaSetValues(fileb_s.shell, XtNtitle, fst->title, NULL);
  }
  if ((fst->dir_io) && (*fst->dir_io)) {
    XtVaSetValues(fileb_s.fchs, XtNcurrentDirectory, fst->dir_io, NULL);
  }
  fileb_s.fsarg = fst;
  fprintf(stderr, "popping up fileb_s.shell\n");
  XtPopup(fileb_s.shell, XtGrabNone);
}

void create_widgets(Widget toplevel)
{
  /* Dimension iwd; */
  Widget wd_menu, wd_modem, wd_fctl, wd_fpar;

  fax_shell = XtVaCreatePopupShell("fax_shell", applicationShellWidgetClass,
		toplevel,
		XtNtitle, "ACfax control",
		NULL);

  fax_form = XtVaCreateManagedWidget("fax_form", formWidgetClass, fax_shell,
		XtNborderWidth, 0,
		NULL);

  fprintf(stderr,"creating menu-line\n");
  wd_menu = cr_menubar(fax_form); 
  fprintf(stderr,"creating modem-form\n");
  wd_modem = cr_modemform(fax_form);
  fprintf(stderr,"creating fax-ctrls\n");
  wd_fctl = cr_faxctrls(fax_form);
  fprintf(stderr,"creating fax-params\n");
  wd_fpar = cr_faxparams(fax_form);

  fprintf(stderr,"setting placement-order\n");
  XtVaSetValues(wd_modem, XtNfromVert, wd_menu, NULL);
  XtVaSetValues(wd_fctl, XtNfromVert, wd_modem, NULL);
  XtVaSetValues(wd_fpar, XtNfromVert, wd_fctl, NULL);
  fprintf(stderr,"creating info-popup\n");
  cr_infopop(toplevel);
  create_filebrowser(toplevel);

  fprintf(stderr,"creating disp_form\n");
  disp_form = XtVaCreateManagedWidget("disp_form", formWidgetClass, toplevel,
		NULL);
/*
  modebut = XtVaCreateManagedWidget("modebut", menuButtonWidgetClass, form,
		XtNwidth, 112,
		XtNheight, 32,
		XtNresizable, False,
		/ XtNlabel, "Mode..", /
		XtNfromHoriz, filebut,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNmenuName, "modes",
		NULL);
*/

/*
  optbut = XtVaCreateManagedWidget("optbut", menuButtonWidgetClass, form,
		XtNwidth, 80,
		XtNheight, 32,
		/ XtNlabel, "Options..", /
		XtNfromHoriz, filebut,
		XtNleft, XtChainLeft,
		XtNright, XtChainLeft,
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNmenuName, "options",
		NULL);
*/


  vport = XtVaCreateManagedWidget("vport", viewportWidgetClass, disp_form,
		XtNwidth, 750,
		XtNheight, 540,
		XtNallowHoriz, True, 
		XtNallowVert, True,
		XtNuseRight, True,
		XtNleft, XtChainLeft,
		XtNtop, XtChainTop,
		XtNright, XtChainRight,
		XtNbottom, XtChainBottom,
		NULL);

  canvas = XtVaCreateManagedWidget("canvas", canvasWidgetClass, vport,
/*
		XtNwidth, C_WIDTH,
		XtNheight, C_HEIGHT,
*/
		XtNleft, XtChainLeft,
		/* XtNright, XtChainLeft, */
		XtNtop, XtChainTop,
		/* XtNbottom, XtChainTop, */
		NULL);
  
  fprintf(stderr,"create_widgets done.\n");
}

void simple_info(char *str)
{
  XtVaSetValues(info_s.shell, XtNtitle, "Info", NULL);
  XtVaSetValues(info_s.text, XtNstring, str, NULL);
  XtVaSetValues(info_s.butn, XtNlabel, "-OK-");
  XtAddCallback(info_s.butn, XtNcallback, end_simple_info, (XtPointer)NULL);
  XtPopup(info_s.shell, XtGrabNone);
}

static void end_simple_info(Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown(info_s.shell);
}

void create_pixmaps(Widget wid)
{
#include "bitmaps/horiz.bit"
#include "bitmaps/vert.bit"
#include "bitmaps/left.bit"
#include "bitmaps/right.bit"
#include "bitmaps/top.bit"
#include "bitmaps/bottom.bit"
#include "bitmaps/nphs.bit"
#include "bitmaps/iphs.bit"
#include "bitmaps/normal.bit"
#include "bitmaps/invers.bit"
#include "bitmaps/azimut.bit"
#include "bitmaps/shift.bit"
#include "bitmaps/stop.bit"
#include "bitmaps/syn.bit"
#include "bitmaps/run.bit"
#include "bitmaps/ammod.bit"
#include "bitmaps/fmmod.bit"
#include "bitmaps/narrow.bit"
#include "bitmaps/middle.bit"
#include "bitmaps/wide.bit"
  Window win;
  Display *dpy;

  win = XtWindow(wid);
  dpy = XtDisplay(wid);
  px_horiz = XCreateBitmapFromData(dpy, win, horiz_bits, horiz_width, horiz_height);
  px_vert = XCreateBitmapFromData(dpy, win, vert_bits, vert_width, vert_height);
  px_right = XCreateBitmapFromData(dpy, win, right_bits, right_width, right_height);
  px_left = XCreateBitmapFromData(dpy, win, left_bits, left_width, left_height);
  px_top = XCreateBitmapFromData(dpy, win, top_bits, top_width, top_height);
  px_bottom = XCreateBitmapFromData(dpy, win, bottom_bits, bottom_width, bottom_height);
  px_nphs = XCreateBitmapFromData(dpy, win, nphs_bits, nphs_width, nphs_height);
  px_iphs = XCreateBitmapFromData(dpy, win, iphs_bits, iphs_width, iphs_height);
  px_normal = XCreateBitmapFromData(dpy, win, normal_bits, normal_width, normal_height);
  px_invers = XCreateBitmapFromData(dpy, win, invers_bits, invers_width, invers_height);
  px_azimut = XCreateBitmapFromData(dpy, win, azimut_bits, azimut_width, azimut_height);
  px_shift = XCreateBitmapFromData(dpy, win, shift_bits, shift_width, shift_height);
  px_stop = XCreateBitmapFromData(dpy, win, stop_bits, stop_width, stop_height);
  px_syn = XCreateBitmapFromData(dpy, win, syn_bits, syn_width, syn_height);
  px_run = XCreateBitmapFromData(dpy, win, run_bits, run_width, run_height);
  px_mam = XCreateBitmapFromData(dpy, win, ammod_bits, ammod_width, ammod_height);
  px_mfm = XCreateBitmapFromData(dpy, win, fmmod_bits, fmmod_width, fmmod_height);
  px_narrow = XCreateBitmapFromData(dpy, win, narrow_bits, narrow_width, narrow_height);
  px_middle = XCreateBitmapFromData(dpy, win, middle_bits, middle_width, middle_height);
  px_wide = XCreateBitmapFromData(dpy, win, wide_bits, wide_width, wide_height);

  XtVaSetValues(dir_s.dirhv, XtNbitmap, px_horiz, NULL);
  XtVaSetValues(dir_s.dirlr, XtNbitmap, px_right, NULL);
  XtVaSetValues(dir_s.dirtb, XtNbitmap, px_bottom, NULL);
  XtVaSetValues(pol_s.norinv, XtNbitmap, px_normal, NULL);
  XtVaSetValues(pol_s.posneg, XtNbitmap, px_nphs, NULL);
  XtVaSetValues(adj_s.lshift, XtNbitmap, px_shift, NULL);
  XtVaSetValues(adj_s.azimut, XtNbitmap, px_azimut, NULL);
  XtVaSetValues(run_s.rmstop, XtNbitmap, px_stop, NULL);
  XtVaSetValues(run_s.rmsyn, XtNbitmap, px_syn, NULL);
  XtVaSetValues(run_s.rmrun, XtNbitmap, px_run, NULL);
  XtVaSetValues(mod_s.mmode, XtNbitmap, px_mfm, NULL);
  XtVaSetValues(mod_s.mfilter, XtNbitmap, px_middle, NULL);
}

/*
 * update the signal level display; sig has range 0 to 1.0
 */
void
set_sigdisplay(double sig)
{
  XawScrollbarSetThumb(mod_s.sigbar, 0, sig);
}
