/*
 * $Header: /home/orchestra5/davy/stuff/misc/xsat/RCS/CanvasP.h,v 1.1 92/04/10 14:08:05 davy Exp $
 *
 * Copyright 1992 by David A. Curry
 * Adapted for use with ACfax by Andreas Czechanowski
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * Private include file for the canvas widget.  Based on the include file for
 * the Template widget in the X11R5 distribution.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * 1285 Electrical Engineering Building
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log:	CanvasP.h,v $
 * Revision 1.1  92/04/10  14:08:05  davy
 * Initial revision
 * 
 */
#ifndef _CanvasP_h
#define _CanvasP_h

#include <X11/CompositeP.h>
#include "Canvas.h"

typedef struct {
	int empty;
} CanvasClassPart;

typedef struct _CanvasClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite;
	CanvasClassPart		canvas_class;
} CanvasClassRec;

extern CanvasClassRec canvasClassRec;

typedef struct {
	Cursor	idle_cursor;		/* cursor when not drawing	*/
	Cursor	busy_cursor;		/* cursor when drawing		*/
	XtCallbackList callbacks;	/* callbacks for button-press	*/

	GC	copyGC;			/* GC for copying pixmaps	*/
	GC	drawGC;			/* GC for drawing on picture	*/
	GC	clearGC;		/* GC for clearing pixmaps	*/

	Pixmap	picture;		/* "main" backup-pixmap 	*/
	unsigned pxmw;			/* width of created pixmap	*/
	unsigned pxmh;			/* height of created pixmap	*/
} CanvasPart;

typedef struct _CanvasRec {
	CorePart	core;
	CompositePart	composite;
	CanvasPart	canvas;
} CanvasRec;

#endif /* _CanvasP_h */
