      SUBROUTINE TRACEOO(TYPE,IRREPIN,POP,VRT,LENW,LENZ,W,Z)
C
C THIS ROUTINE ACCEPTS A SYMMETRY PACKED FOUR-INDEX ARRAY AND FORMS
C  ONE OF THE FOLLOWING SUMS.  THE RETURNED ARRAY (Z) IS ALSO SYMMETRY
C  PACKED. (ALL SUMS BELOW ARE OVER M).
C
C           Z(EB) =  SUM   W(ME-BM)     (TYPE = 'OVVO')
C           Z(EB) =  SUM   W(EM-MB)     (TYPE = 'VOOV')
C           Z(EB) =  SUM   W(EM-BM)     (TYPE = 'VOVO')
C           Z(EB) =  SUM   W(ME-MB)     (TYPE = 'OVOV')
C
C
C INPUT: TYPE    (CHARACTER*4)
C        IRREPIN (INTEGER): THE IRREP OF GAMMA(MB) AND GAMMA(EM).
C        POP (INTEGER [8]): OCCUPATION NUMBERS BY IRREP.
C        VRT (INTEGER [8]): # OF VIRTUAL ORBITALS BY IRREP.
C        NSIZ (INTEGER)   : THE DIMENSION OF W (WHICH IS A SQUARE MATRIX).
C        W (DP ARRAY)     : THE FOUR-INDEX ARRAY TO BE SUMMED OVER.
C
C OUTPUT: Z (DP ARRAY)    : THE SUMS DESCRIBED BY THE EQUATIONS ABOVE.
C
CEND
C
C COMPUTE OFFSETS FOR VARIOUS 2 DISTRIBUTION TYPES (OV AND VO) AND
C THE TARGET DISTRIBUTION TYPE (VV).
C
      IMPLICIT INTEGER (A-Z)
      DOUBLE PRECISION Z(LENZ),W(LENW,LENW)
      CHARACTER*4 TYPE
      DIMENSION IOFFVO(8),IOFFOV(8),IOFFVV(8),POP(8),VRT(8)
      COMMON /SYMINF/ NSTART,NIRREP,IRREPA(255),IRREPB(255),
     &                DIRPRD(8,8)
      INDX(I,J,N)=I+(J-1)*N
      IOFF1=0
      IOFF2=0
      IOFF3=0
      DO 1000 IRREP=1,NIRREP
       IRREPX=DIRPRD(IRREP,IRREPIN)
       IOFFVO(IRREP)  =IOFF1
       IOFFOV(IRREP)  =IOFF2
       IOFFVV(IRREP)=IOFF3
       IOFF1=IOFF1+POP(IRREP)*VRT(IRREPX)
       IOFF2=IOFF2+VRT(IRREP)*POP(IRREPX)
       IOFF3=IOFF3+VRT(IRREP)*VRT(IRREP)
1000  CONTINUE
      CALL ZERO(Z,IOFF3)
      IF(TYPE.EQ.'OVVO')THEN
       DO 10 IRREPMJ=1,NIRREP
        IRREPBE=DIRPRD(IRREPMJ,IRREPIN)
        DO 20 M=1,POP(IRREPMJ)
         J=M
         DO 30 B=1,VRT(IRREPBE)
          DO 40 E=1,VRT(IRREPBE)
           INDEXR=INDX(B,M,VRT(IRREPBE))+IOFFVO(IRREPMJ)
           INDEXL=INDX(J,E,POP(IRREPMJ))+IOFFOV(IRREPBE)
           INDTAR=INDX(E,B,VRT(IRREPBE))+IOFFVV(IRREPBE)
           Z(INDTAR)=Z(INDTAR)+W(INDEXL,INDEXR)
40        CONTINUE
30       CONTINUE
20      CONTINUE
10     CONTINUE 
      ELSEIF(TYPE.EQ.'VOVO')THEN
       DO 110 IRREPMJ=1,NIRREP
        IRREPBE=DIRPRD(IRREPMJ,IRREPIN)
        DO 120 M=1,POP(IRREPMJ)
         J=M
         DO 130 B=1,VRT(IRREPBE)
          DO 140 E=1,VRT(IRREPBE)
           INDEXR=INDX(B,M,VRT(IRREPBE))+IOFFVO(IRREPMJ)
           INDEXL=INDX(E,J,VRT(IRREPBE))+IOFFVO(IRREPMJ)
           INDTAR=INDX(E,B,VRT(IRREPBE))+IOFFVV(IRREPBE)
           Z(INDTAR)=Z(INDTAR)+W(INDEXL,INDEXR)
140       CONTINUE
130      CONTINUE
120     CONTINUE
110    CONTINUE
      ELSEIF(TYPE.EQ.'OVOV')THEN
       DO 210 IRREPMJ=1,NIRREP
        IRREPBE=DIRPRD(IRREPMJ,IRREPIN)
        DO 220 M=1,POP(IRREPMJ)
         J=M
         DO 230 B=1,VRT(IRREPBE)
          DO 240 E=1,VRT(IRREPBE)
           INDEXR=INDX(M,B,POP(IRREPMJ))+IOFFOV(IRREPBE)
           INDEXL=INDX(J,E,POP(IRREPMJ))+IOFFOV(IRREPBE)
           INDTAR=INDX(E,B,VRT(IRREPBE))+IOFFVV(IRREPBE)
           Z(INDTAR)=Z(INDTAR)+W(INDEXL,INDEXR)
240       CONTINUE
230      CONTINUE
220     CONTINUE
210    CONTINUE
      ELSEIF(TYPE.EQ.'VOOV')THEN
       DO 310 IRREPMJ=1,NIRREP
        IRREPBE=DIRPRD(IRREPMJ,IRREPIN)
        DO 320 M=1,POP(IRREPMJ)
         J=M
         DO 330 B=1,VRT(IRREPBE)
          DO 340 E=1,VRT(IRREPBE)
           INDEXR=INDX(M,B,POP(IRREPMJ))+IOFFOV(IRREPBE)
           INDEXL=INDX(E,J,VRT(IRREPBE))+IOFFVO(IRREPMJ)
           INDTAR=INDX(E,B,VRT(IRREPBE))+IOFFVV(IRREPBE)
           Z(INDTAR)=Z(INDTAR)+W(INDEXL,INDEXR)
340       CONTINUE
330      CONTINUE
320     CONTINUE
310    CONTINUE
      ENDIF
      RETURN
      END
