C  Copyright (c) 2003-2010 University of Florida
C
C  This program is free software; you can redistribute it and/or modify
C  it under the terms of the GNU General Public License as published by
C  the Free Software Foundation; either version 2 of the License, or
C  (at your option) any later version.

C  This program is distributed in the hope that it will be useful,
C  but WITHOUT ANY WARRANTY; without even the implied warranty of
C  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C  GNU General Public License for more details.

C  The GNU General Public License is included in this distribution
C  in the file COPYRIGHT.
      Subroutine MakGen ( NCent, Ref, Perm, GenBy )
C:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
C Purpose:
C     Given two permutation lists, produce (update) the GENBY list
C     of which centers are *generated* by symmetry operations on other
C     centers and which are unique.
C
C Usage:
C     Calling this routine with the permutation due to each sym. op.
C     of the group gives a list of the symmetry unique centers 
C     (those with GENBY = 0) or a center (GENBY <> 0) which, under
C     the operations of the group, will generate the center in question.
C
C Arguments:
C     NCent    Length of arrays (number of centers) (input)
C     Ref      Reference permutation list (input)
C              NOTE: Must remain unchanged between successive calls
C     Perm     Permutation due to symmetry operation (input)
C     GenBy    "Generated By" list (modified)
C              For each center, contains 0 if the center is "unique"
C              or the number of another center which generates this
C              one by operations of the group.
C              NOTE: The elements of GENBY refer to the actual
C                    center numbers - it is NOT in the order of the
C                    reference permutation list
C              NOTE: Must be all zeros on *first* call to MakGen
C
C Internal Variables:
C     Cent1    Holds the lesser of Ref(i) and Perm(i)
C     Cent2    Holds the greater of Ref(i) and Perm(i)
C
C Method:
C     Compare Ref and Perm elementwise to see how each center transforms.
C     To avoid ambiguity always take the lesser of the two centers as
C     the "source" and the greater of the two as the "resultant."  
C     [ This has the side effect that in a symmetry equivalent group,
C     the lowest numbered center will be deemed "unique" and the rest
C     will be its "dependents." ]
C
C     For each element, we need update GenBy only if there has been
C     an interchange of centers [Ref(i) <> Perm(i)] and if the resultant
C     is presently unique.  [ If the resultant is *not* unique, then its
C     generator must be somewhere in the list too & it will be dealt
C     with in a way that will also update all of its dependents too
C     (see below). ]
C
C     The source, then, is either unique or a dependent.  If it is unique,
C     we merely mark the resultant as being generated by the source, and
C     proceed to check the rest of the list to see if the present result-
C     ant has any dependents.  If so, they are actually dependents of the
C     source via some combination of symmetry operations, and they are
C     marked as such.
C
C     If the source is already a dependent of another center, then
C     the GenBy list is "switched" so that the original source of this
C     source becomes, instead, a dependent of this source.  Then we
C     proceed to update the rest of the list - any center which was
C     dependent on the *original* source now becomes a dependent of
C     the *present* source (via a combination of operations).
C:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
C
C $Log: makgen.f,v $
C Revision 1.4  2010/10/07 14:33:58  ponton
C Add symcor changes, fix bugs in optimization code, change numerical lib calls to use proper routines
C
C Revision 1.2  2010/02/10 17:20:48  ponton
C Add GNU GPL info to each source file
C
C Revision 1.1.1.1  2009/07/01 18:54:34  ponton
C Initial import for ACESIII Release 3.0
C
C Revision 1.1.1.1  2003/04/02 19:21:35  aces
C INITIAL 2.4 IMPORT
C
C Revision 4.0  89/03/14  01:15:47  bernhold
C Baseline for Sun & VAX prior to porting everywhere
C 
C Revision 3.0  89/01/29  23:10:26  bernhold
C First working release for VAX
C 
C Revision 1.1  89/01/28  12:09:38  bernhold
C Initial revision
C 
C:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
      Implicit integer (a-z)
      dimension ref(ncent), perm(ncent), genby(ncent)
C
C     Loop over all centers...
C
      Do 100 i = 1, ncent
C
C        See if it's interesting
         Cent1 = Min( Ref(i), Perm(i) )
         Cent2 = Max( Ref(i), Perm(i) )
         If ( genby( Cent2 ) .eq. 0 .AND.
     $                     Cent1 .ne. Cent2 ) then
            If ( genby( Cent1 ) .eq. 0 ) then
C
C              If the generated center is unique, simply update
               genby( Cent2 ) = Cent1
               tmp = Cent2
            else
C
C              If its not, then fix the original source
               tmp = genby( Cent1 )
               genby(tmp) = Cent1
            endif
C
C           Update other dependents of the generated center
C           or the original source (using TMP, set above)
            Do 200 j = 1, ncent
               If ( genby(j) .eq. tmp ) genby(j) = Cent1
 200        continue
C
         endif
C
 100  continue
C
      return
      end
