Accelio – Open-Source IO, Message, and RPC Acceleration Library
===============================================================


What is Accelio?
----------------

Accelio provides an easy-to-use, reliable, scalable, and high performance data/message delivery middleware that maximizes the efficiency of modern CPU and NIC hardware and that reduces time-to-market of new scale-out applications.

Who can take advantage of it?
-----------------------------

Developers interested in a highly efficient, high-performance reliable messaging implementations for applications such as clustering, scale-out block/file/object storage, BigData and NoSQL applications, fast message bus, etc’            

Key Features and Capabilities:
------------------------------

*	Simple and abstract API for application developers focused on high-performance asynchronous communication APIs
* Reliable message delivery (end-to-end)
* Request/Reply (Transaction) or Send/Receive models
* Connection and resource abstraction to max scalability and availability
* Zero copy data delivery, with optional built-in memory management
* Designed to maximize the benefits of RDMA, hardware offloads, and multi-core CPUs and multi-threaded applications
* Supports multiple transport options (RDMA, TCP, Shared-Memory, etc.)
* Integration with common event loop mechanisms (epoll, libevent, ACE, etc.)
* Fast event notifications, optional busy wait polling, or combined models for lowest message latency
* Native support for service and storage clustering/scale-out
* Message combining and batch message processing optimization 


To understand more details about the code structure and various examples see the README file

Managed as a modular Open-Source project, Accelio can be extended with new functionality, new transport implementations or services, and further stability and performance optimizations, which can be implemented by a broad group of developers.

The project web site (accelio.org) is currently under construction


What is the library’s status?
-----------------------------

The library is under development



