---
authors: SS, XG, YG, NAP
---

# The optic utility  

Frequency dependent linear optical dielectric function and second order nonlinear optical susceptibility.  

This file explains the i/o parameters needed for the calculation of the
frequency-dependent linear optical dielectric function and second-order
nonlinear optical susceptibility, in the RPA approximation (sum-over-states
using independent electronic states) thanks to the Optic utility of the Abinit package.
The user is advised to be familiar with the main [[help:abinit]] before reading the present file.

A knowledge of the computation of the linear response $\partial /\partial k$ perturbation,
explained in the [[help:respfn]], is also advised.

It will be easier to discover the present file with the help of the [[tutorial:optic|optic tutorial]].  

## 1 Introduction
  
The Optic utility allows the computation of the frequency-dependent linear optical dielectric
function and second-order nonlinear optical susceptibility including the nonlinear susceptibility and 
the linear electro-optical coefficient. An introduction to such computations is given in [[cite:Sharma2004]],
online at <http://arxiv.org/abs/cond-mat/0305016>.
Other useful references include [[cite:Hughes1996]],
[[cite:Draxl2006]], online at <http://arxiv.org/abs/cond-mat/0402523>,
and [[cite:Sharma2003]], online at <http://arxiv.org/abs/cond-mat/0211512>.

Before going to the detailed explanation of the Optic utility, the user is
advised to become familiar to the theory behind it, explained in these
references. Familiarity at least with [[cite:Sharma2004]] is strongly advised.

The specific purpose of the Optic utility is to read in the momentum matrix elements 
generated by Abinit (actually matrix elements of the $\partial H/\partial k$ operator), and
then use the approach of [[cite:Sharma2004]] to determine the
linear (Eq. 46) and nonlinear (Eqs. 49-51) optical response of the material under investigation.

Note that optic works in the independent-particle approximation (no excitons), 
and without local-field effects. For higher level of theories, use the Bethe-Salpeter equation, see the [[tutorial:bse|BSE tutorial]].
The intraband Drude term (for metals only) is also not included.
Usually it has only small effect at visible frequencies, but important effect
at smaller frequencies. See e.g. [[cite:Cazzaniga2010]], Fig. 3.


## 2 How to run Optic
  
The use of Optic is quite simple:
    
    optic optic.abi > optic.log 2> optic.stderr
    
However, before being able to use Optic, you must have obtained, from the main
Abinit program, four different files, corresponding to the physical system that you want to study:

  * The ground state wavefunction file, indexed with _WFK 

  * Three files containing the matrix elements of the $\partial H/ \partial k$ operators of the unperturbed wavefunctions, 
    one for each direction of space

Supposing you have read the [[help:abinit|main Abinit help file]], the
production of the first file should not require any additional explanation.
However, the way to obtain the three other files, containing the matrix elements of the dH/dk operators is worth explaining.  

A straightforward relationship exists between the dH/dk matrix
elements and the matrix elements of the momentum operator.
The computation of the dH/dk matrix elements is the initializing step in the
treatment of the response to an electric field in DFPT.
The long-wave method as well as the Berry-phase treatment of electric field,
allow to establish the equivalence between the off-diagonal matrix elements of
the position operator, and the off-diagonal matrix elements of the derivative
with respect to the wavevector ($\partial /\partial k$), for the periodic part of the Bloch
functions (see for example section VI of [[cite:Gonze1997]], and [[cite:Nunes2001]]).
Such calculation involve applying the dH/dk operator to the unperturbed wavefunctions,
in the Sternheimer equation.

The main Abinit program has the capability to compute derivatives of
wavefunctions with respect to their wavevector. This is explained in [[help:respfn]]. 
Such a calculation implies treating three d/dk perturbations, indexed by the numbers 3*natom+1, 3*natom+2 and
3*natom+3 (thus for example, for a unit cell with 2 atoms, perturbations number 7, 8
and 9). In the two-atom case, the associated files needed for Optic have the index _1WF7 , _1WF8 , and _1WF9.
However, as mentioned above, the computation of the dH/dk matrix elements is only the initializing step
in such calculations. Still, the $\partial H/\partial k$ will be made available in such files.

The formalism implemented in Optic treats explicitly the eigenstates lying in
the range of energy between the lowest occupied wavefunction and the highest
one plus the maximal excitation energy (chosen by the user). 
All the other ones are neglected. This has two important consequences for the preliminary runs:

  * The ground calculation must produce explicitly all the eigenstates and eigenvalues 
    for that target range of energy, so it cannot be restricted to the occupied wavefunctions only

  * One does not need the full change of Bloch wavefunctions with respect to $\partial /\partial k$, but 
    only the matrix elements of $\partial H/\partial k$ between the wavefunctions of this range of energy

Because of the latter, the computation of the response to $\partial /\partial k$ perturbations
is much shorter than usual: indeed, the matrix elements between the
explicitly ground-state wavefunctions are computed at the very beginning of
the abinit(respfn) run. It is not necessary to make a full calculation of the
modification of the wavefunctions due to a change of wavevector. This explains why [[nstep]] has been set to 0 in such calculations.

<a id="input"></a>
## 3 Optic input file and input variables
  
Please note that the format of input files for Optic has changed as of Abinit
v8.0. Since very few input parameters are required for Optic, the optic.in file
contains them with the namelist format. The order of the three parts, namely
FILES, PARAMETERS and COMPUTATIONS must be kept unaltered.
    
```fortran
    &FILES
     ddkfile_1 = 'toptic_1o_DS4_1WF7',
     ddkfile_2 = 'toptic_1o_DS5_1WF8',
     ddkfile_3 = 'toptic_1o_DS6_1WF9',
     wfkfile = 'toptic_1o_DS3_WFK'
    /
    &PARAMETERS
     broadening = 0.002,
     domega = 0.0003,
     maxomega = 0.3,
     scissor = 0.000,
     tolerance = 0.002
    /
    &COMPUTATIONS
     num_lin_comp = 1,
     lin_comp = 11,
     num_nonlin_comp = 2,
     nonlin_comp = 123,222,
     num_linel_comp = 1,
     linel_comp = 123,
    /
```

The list of input variables for the optic input file is presented in [[topic:Optic]].

<a id="output"></a>
## 4 Optic output files
  
#### **4.1. Linear optical response data files**

Name: case_a_b-linopt.out  
Contains the following 3 data sets

  * 1) Column 1 - energy(eV), column 2 - imaginary part of the ab component of the frequency-dependent linear dielectric tensor.
  * 2) Column 1 - energy(eV), column 2 - real part of the ab component of the frequency-dependent linear dielectric tensor.
  * 3) Column 1 - energy(eV), column 2 - absolute value of the ab component of the frequency-dependent linear dielectric tensor.
  * 4) Column 1 - energy(eV), column 2 - imaginary part of the ab component of the frequency-dependent linear refractive index ($\kappa$).
  * 5) Column 1 - energy(eV), column 2 - real part of the ab component of the frequency-dependent linear refractive index ($n$).
  * 6) Column 1 - energy(eV), column 2 - frequency-dependent reflectivity at normal incidence.
  * 7) Column 1 - energy(eV), column 2 - absorption coeff (in m-1) = $\omega \Im(\epsilon) / c n(\epsilon)$

In the header of the file you can find information about the calculation. 

In case [[nsppol]]==2, the spin-decomposition of items 1 and 2 above is provided in columns 3-4 for the imaginary part, and 3-5
for the real part (the spin-independent contribution $\delta(ab)$ is mentioned as well).

#### **4.2. Non-linear optical response data files**

Name: case_a_b_c-ChiKIND1.out  
KIND1:This can be TotIm, TotRe or TotAbs  
Contains: column 1 - energy(eV), column 2 and 3 - imaginary (KIND1=TotIm),
real (KIND1=TotRe) or absolute (KIND1=TotAbs) value of the abc component of
the nonlinear optical susceptibility. Second column contains values in
electro-static units (esu) and third column contains values in the SI units.  

Name: case_a_b_c-ChiKIND2.out  
KIND2:This can be Im, Re or abs  
Contains: column 1 - energy(eV), column 2, 3 inter and column 4, 5 intra band
contributions to the imaginary (KIND2=Im), real (KIND2=Re) or absolute
(KIND2=Abs) value of the abc component of the nonlinear optical
susceptibility. These components are labeled as inter and intra in Eqs. 49-51 in [[cite:Sharma2004]]

All the values are in electro-static units (esu). In the header of all the
above files you can find information about the calculation. 

<a id="troubleshooting"></a>
## 5 Troubleshooting
  
1) All I get are zeros in my *-linopt.out file. Why?

There are several possibilities.  
Let us explore some of them here:

  * (i) The component of the dielectric tensor that you are looking at could be zero due to symmetry of the crystal. 
    Normally zz component is a good place to start. It is almost never zero. So check the file case__0003_0003-linopt.out.

  * (ii) If the components zz is zero this is more serious, if you are using the default input file t57.in 
    then please check that on the line number 10 the second number is 33. 
    If you are not using the default input file please calculate the 33 (or zz) component and make sure it is not zero.

  * (iii) If even zz component is zero then possibilities are endless maximum frequency on 
    line number 6 of t57.in is too small, or the number of bands used for performing ground state calculation are too small.

2) All I get is zeros in my *-ChiKIND.out file. Why?

The two most common mistakes are:

  * (i) You are calculating the second order response for material with inversion symmetry, so 
    in this case all the components will be correctly zero or very small (order $10^{-15}$).

  * (ii) Most components out of the 27 are zero due to the symmetry of the crystal. Please calculate a different component.
