!{\src2tex{textfont=tt}}
!!****m* ABINIT/defs_suscep
!! NAME
!! defs_suscep
!!
!! FUNCTION
!! This module contains definitions for the ACFD routines in the 07suscep
!! directory and for the routines who call the ACFD routines, especially when
!! optional arguments are defined.
!!
!! COPYRIGHT
!! Copyright (C) 2004-2014 ABINIT group (YP)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! TODO
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module defs_suscep

 use defs_basis

 implicit none
 !
 ! Preassigned meshes, mainly for test purposes
 !

 ! Preassigned frequencies for He
 real(dp),dimension(16),parameter :: freqs_pa_he = &
 & (/ &
 & 0.25446043828621D-01, &
 & 0.12923440720030D+00, &
 & 0.29707742431130D+00, &
 & 0.50000000000000D+00, &
 & 0.70292257568870D+00, &
 & 0.87076559279970D+00, &
 & 0.97455395617138D+00, &
 & 0.10161774228811D+01, &
 & 0.10893061626347D+01, &
 & 0.12396401470009D+01, &
 & 0.15102849384065D+01, &
 & 0.20000000000000D+01, &
 & 0.29596894298366D+01, &
 & 0.51729234959795D+01, &
 & 0.12197435546413D+02, &
 & 0.62814542856848D+02  &
 & /)

 ! Preassigned weights for He
 real(dp),dimension(16),parameter :: weights_pa_he = &
 & (/ &
 & 6.47424830844300e-02, &
 & 1.39852695744640e-01, &
 & 1.90915025252535e-01, &
 & 2.08979591836735e-01, &
 & 1.90915025252535e-01, &
 & 1.39852695744640e-01, &
 & 6.47424830844300e-02, &
 & 4.19626394506177e-02, &
 & 1.07177462259922e-01, &
 & 2.00241231157897e-01, &
 & 3.56225687373540e-01, &
 & 6.60478710002520e-01, &
 & 1.36804295333940e+00, &
 & 3.48685872889034e+00, &
 & 1.34381848942709e+01, &
 & 1.60340827693244e+02  &
 & /)

 ! Preassigned frequencies for He, good up to 8 Ha
 real(dp),dimension(20),parameter :: freqs_pa_he_8ha = &
 & (/ &
 & 3.2616839353535D-02, &
 & 1.6867079163877D-01, &
 & 4.0073803962622D-01, &
 & 7.0825575733844D-01, &
 & 1.0639070762730D+00, &
 & 1.4360929237270D+00, &
 & 1.7917442426616D+00, &
 & 2.0992619603738D+00, &
 & 2.3313292083612D+00, &
 & 2.4673831606465D+00, &
 & 2.5330480079804D+00, &
 & 2.6808740599932D+00, &
 & 2.9772368184517D+00, &
 & 3.4882210592266D+00, &
 & 4.3520860640268D+00, &
 & 5.8745732022902D+00, &
 & 8.8244958621825D+00, &
 & 1.5596223422737D+01, &
 & 3.7054429752041D+01, &
 & 1.9161881175107D+02  &
 & /)

 ! Preassigned weights for He, good up to 8 Ha
 real(dp),dimension(20),parameter :: weights_pa_he_8ha = &
 & (/ &
 & 8.3339180385855D-02, &
 & 1.8681418643823D-01, &
 & 2.7385795314497D-01, &
 & 3.3658339913749D-01, &
 & 3.6940528089344D-01, &
 & 3.6940528089344D-01, &
 & 3.3658339913749D-01, &
 & 2.7385795314497D-01, &
 & 1.8681418643823D-01, &
 & 8.3339180385855D-02, &
 & 8.5557098804143D-02, &
 & 2.1482393162869D-01, &
 & 3.8839363381970D-01, &
 & 6.5527058667334D-01, &
 & 1.1194843651077D+00, &
 & 2.0397442712039D+00, &
 & 4.1936529031966D+00, &
 & 1.0658209106693D+01, &
 & 4.1040260028453D+01, &
 & 4.8960460407439D+02  &
 & /)

 ! Preassigned frequencies for H_2
 real(dp),dimension(18),parameter :: freqs_pa_h2 = &
 & (/ &
 & 0.25446043828621E-01, &
 & 0.12923440720030E+00, &
 & 0.29707742431130E+00, &
 & 0.50000000000000E+00, &
 & 0.70292257568870E+00, &
 & 0.87076559279970E+00, &
 & 0.97455395617138E+00, &
 & 0.10110054728832E+01, &
 & 0.10598482531771E+01, &
 & 0.11559677956368E+01, &
 & 0.13165723758669E+01, &
 & 0.15753698412085E+01, &
 & 0.20000000000000E+01, &
 & 0.27380125414631E+01, &
 & 0.41588353129728E+01, &
 & 0.74115800054568E+01, &
 & 0.17708925439166E+02, &
 & 0.91863882962169E+02  &
 & /)

 ! Preassigned weights for H_2
 real(dp),dimension(18),parameter :: weights_pa_h2 = &
 & (/ &
 & 6.4742483084430D-02, &
 & 1.3985269574464D-01, &
 & 1.9091502525254D-01, &
 & 2.0897959183674D-01, &
 & 1.9091502525254D-01, &
 & 1.3985269574464D-01, &
 & 6.4742483084430D-02, &
 & 2.8450313764414D-02, &
 & 7.0530853203843D-02, &
 & 1.2446622249436D-01, &
 & 2.0210470080423D-01, &
 & 3.2611286320820D-01, &
 & 5.4585017355580D-01, &
 & 9.8508508022906D-01, &
 & 2.0166493177745D+00, &
 & 5.1166020539137D+00, &
 & 1.9691381197993D+01, &
 & 2.3489276722304D+02  &
 & /)

 ! Preassigned frequencies for Be and Be_2
 real(dp),dimension(24),parameter :: freqs_pa_be2 = &
 & (/ &
 & 0.39542363203530D-02, &
 & 0.20600400194256D-01, &
 & 0.49605477316673D-01, &
 & 0.89412665139915D-01, &
 & 0.13787681224089D+00, &
 & 0.19238542101122D+00, &
 & 0.25000000000000D+00, &
 & 0.30761457898878D+00, &
 & 0.36212318775911D+00, &
 & 0.41058733486009D+00, &
 & 0.45039452268333D+00, &
 & 0.47939959980574D+00, &
 & 0.49604576367965D+00, &
 & 0.50550273644159D+00, &
 & 0.52992412658854D+00, &
 & 0.57798389781839D+00, &
 & 0.65828618793344D+00, &
 & 0.78768492060426D+00, &
 & 0.10000000000000D+01, &
 & 0.13690062707315D+01, &
 & 0.20794176564864D+01, &
 & 0.37057900027284D+01, &
 & 0.88544627195828D+01, &
 & 0.45931941481085D+02  &
 & /)

 ! Preassigned weights for Be and Be_2
 real(dp),dimension(24),parameter :: weights_pa_be2 = &
 & (/ &
 & 1.01210011913282D-02, &
 & 2.30303749594320D-02, &
 & 3.47183775549475D-02, &
 & 4.45364951904775D-02, &
 & 5.19540118842225D-02, &
 & 5.65707950657250D-02, &
 & 5.81378883077175D-02, &
 & 5.65707950657250D-02, &
 & 5.19540118842225D-02, &
 & 4.45364951904775D-02, &
 & 3.47183775549475D-02, &
 & 2.30303749594320D-02, &
 & 1.01210011913282D-02, &
 & 1.42251568822072D-02, &
 & 3.52654266019211D-02, &
 & 6.22331112471786D-02, &
 & 1.01052350402114D-01, &
 & 1.63056431604097D-01, &
 & 2.72925086777900D-01, &
 & 4.92542540114519D-01, &
 & 1.00832465888723D+00, &
 & 2.55830102695685D+00, &
 & 9.84569059899664D+00, &
 & 1.17446383611522D+02  &
 & /)

end module defs_suscep
!!***
