!!****h* BigDFT/lazy_60
!! NAME
!!   lazy_60
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 60)
!!
!! SOURCE
!!
integer, parameter :: m=62
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp, 0._dp, 0._dp, &
     -1.80960777804178984e-19_dp,0._dp,1.10513064480060885e-17_dp,0._dp,&
       -3.32141991973710259e-16_dp,0._dp,6.54883738891560793e-15_dp,0._dp,&
       -9.5279163579909433e-14_dp,0._dp,1.09084919935365698e-12_dp,0._dp,&
       -1.02354148279779304e-11_dp,0._dp,8.09410105920413478e-11_dp,0._dp,&
       -5.50587106934234749e-10_dp,0._dp,3.27218841600752522e-9_dp,0._dp,&
       -1.71999647508087864e-8_dp,0._dp,8.07595396530604197e-8_dp,0._dp,&
       -3.41497481961512632e-7_dp,0._dp,1.30947169656570694e-6_dp,0._dp,&
       -4.58013372208926991e-6_dp,0._dp,0.0000146880150398035208_dp,0._dp,&
       -0.0000433840444231233622_dp,0._dp,0.000118515001353520526_dp,0._dp,&
       -0.000300581525171972349_dp,0._dp,0.000710396937937769235_dp,0._dp,&
       -0.00157035112596770041_dp,0._dp,0.00325946830347917649_dp,0._dp,&
       -0.00638065613347741822_dp,0._dp,0.0118436928230099234_dp,0._dp,&
       -0.0209956372771539552_dp,0._dp,0.0359258682297967678_dp,0._dp,&
       -0.0604028333973506096_dp,0._dp,0.103355959368799932_dp,0._dp,&
       -0.196868494035809394_dp,0._dp,0.631336894666561161_dp,1._dp,0.631336894666561161_dp,&
       0._dp,-0.196868494035809394_dp,0._dp,0.103355959368799932_dp,0._dp,&
       -0.0604028333973506096_dp,0._dp,0.0359258682297967678_dp,0._dp,&
       -0.0209956372771539552_dp,0._dp,0.0118436928230099234_dp,0._dp,&
       -0.00638065613347741822_dp,0._dp,0.00325946830347917649_dp,0._dp,&
       -0.00157035112596770041_dp,0._dp,0.000710396937937769235_dp,0._dp,&
       -0.000300581525171972349_dp,0._dp,0.000118515001353520526_dp,0._dp,&
       -0.0000433840444231233622_dp,0._dp,0.0000146880150398035208_dp,0._dp,&
       -4.58013372208926991e-6_dp,0._dp,1.30947169656570694e-6_dp,0._dp,&
       -3.41497481961512632e-7_dp,0._dp,8.07595396530604197e-8_dp,0._dp,&
       -1.71999647508087864e-8_dp,0._dp,3.27218841600752522e-9_dp,0._dp,&
       -5.50587106934234749e-10_dp,0._dp,8.09410105920413478e-11_dp,0._dp,&
       -1.02354148279779304e-11_dp,0._dp,1.09084919935365698e-12_dp,0._dp,&
       -9.5279163579909433e-14_dp,0._dp,6.54883738891560793e-15_dp,0._dp,&
       -3.32141991973710259e-16_dp,0._dp,1.10513064480060885e-17_dp,0._dp,&
       -1.80960777804178984e-19_dp,&
     0._dp, 0._dp, 0._dp   /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

