/*
 * @(#)MballGLP.h
 *
 * Copyright 2024  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for MballGL */

#ifndef _MballGLP_h
#define _MballGLP_h

#include "MballGL.h"
#include <GL/gl.h>
#include <GL/glu.h>
#ifndef WINVER
#include <GL/glx.h>

/* This gets around C's inability to do inheritance */
typedef struct _MballGLClassPart {
	int ignore;
} MballGLClassPart;

typedef struct _MballGLClassRec {
	CoreClassPart coreClass;
	MballClassPart mballClass;
	MballGLClassPart mballGLClass;
} MballGLClassRec;

extern MballGLClassRec mballGLClassRec;
#endif

#define SCALE (float) (1.5)

#define TOP_WEDGE 0
#define TTR_WEDGE 1
#define TR_WEDGE 2
#define RIGHT_WEDGE 3
#define BR_WEDGE 4
#define BBR_WEDGE 5
#define BOTTOM_WEDGE 6
#define BBL_WEDGE 7
#define BL_WEDGE 8
#define LEFT_WEDGE 9
#define TL_WEDGE 10
#define TTL_WEDGE 11

#define SPHERE_STACKS 60
#define SPHERE_SLICES 120

#define BORDER_WEDGE (MAX_WEDGES)
#define NO_WEDGE (MAX_WEDGES+1)
#define NO_BAND (IGNORE_DIR)
#define NO_ROTATION (2*MAX_ORIENT)
#define NO_STYLE (IGNORE_DIR)
#define REV(a) (MAX_SIZE-a-1)
#define MAX_TURN_INC 10

typedef struct _MballMove {
	int         wedge, direction;
	int         band;
	Boolean     control;
} MballMove;

typedef struct _MballSlice {
	int         edge, rotation;
} MballSlice;

typedef struct _MballGLPart {
	double      angleStep;
	double      rotateStep;
	int         numTurnInc;
	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
	/*Point       cubeSizex, cubeSizey, cubeSizez;*/
	Point       faceSize, viewSize;
	Point       viewMiddle;
	MballMove   movement;
	int         step;
	int         slicesPerWedge;
	int         stacksPerBand;
} MballGLPart;

typedef struct _MballGLRec {
	CorePart    core;
	MballPart     mball;
	MballGLPart   mballGL;
} MballGLRec;

extern Boolean positionToSectorGL(MballGLWidget w, int x, int y,
	int *sector, int *view);
extern Boolean narrowSelectionGL(MballGLWidget w,
	int *wedge, int *band, int *direction);
/*extern void drawFrameGL(MballGLWidget w, Boolean focus);*/
extern void drawAllPiecesGL(MballGLWidget w);
/*extern void moveAllPiecesGL(MballGLWidget w, int wedge, int direction,
	int fast);*/
extern void movePiecesGL(MballGLWidget w, int wedge, int band,
	int direction, Boolean control, int fast);
#ifdef WINVER
extern void resizePuzzleGL(MballGLWidget w);
extern void exposePuzzleGL(MballGLWidget w);
#endif

#endif /* _MballGLP_h */
