#!/bin/bash
# bbou@ac-toulouse.fr
# 2006-08-22 11:46:20     
# _check-kerberos.sh

### P A R A M S

if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi

### I N C L U D E

. ./_include.sh

###  S T A R T

case ${DISTRIBUTION} in
	Redhat|Fedora|Mandriva)
		krbpkg="krb5-workstation"
		krbpkgs="krb5-workstation"
		;;
	Suse)
		krbpkg="krb5-client"
		krbpkgs="krb5-client"
		;;
	Debian|Ubuntu)
		krbpkg="krb5-user"
		krbpkgs="krb5-user"
		;;
	*)
		echo "Distribution not supported"
		exit
		;;
esac

echo "+KERBEROS"
for i in ${krbpkg}; do
	if ! ${PACKAGETEST} ${i} 2> /dev/null > /dev/null; then
		echo "[FAIL] ${i} is not installed" >&2
		exit 1
	else
		[ -z "${MYVERBOSE}" ] || echo "${i} installed"
	fi
done

echo "+KERBEROS LIBRARY VERSIONS"
krb_vers=`${PACKAGEVERSION} ${krbpkgs}`
krb_majvers=$(echo ${krb_vers} | sed "s/\..*$//")
echo "kerberos ${krb_vers} (major ${krb_majvers})"
