% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.prepareHTS.R
\name{ascat.prepareHTS}
\alias{ascat.prepareHTS}
\title{Extract both logR and BAF values from sequencing data}
\usage{
ascat.prepareHTS(
  tumourseqfile,
  normalseqfile,
  tumourname,
  normalname,
  allelecounter_exe,
  alleles.prefix,
  loci.prefix,
  gender,
  genomeVersion,
  nthreads = 1,
  tumourLogR_file = NA,
  tumourBAF_file = NA,
  normalLogR_file = NA,
  normalBAF_file = NA,
  minCounts = 10,
  BED_file = NA,
  probloci_file = NA,
  chrom_names = c(1:22, "X"),
  min_base_qual = 20,
  min_map_qual = 35,
  ref.fasta = NA,
  skip_allele_counting_tumour = F,
  skip_allele_counting_normal = F,
  seed = as.integer(Sys.time())
)
}
\arguments{
\item{tumourseqfile}{Full path to the tumour BAM/CRAM file.}

\item{normalseqfile}{Full path to the normal BAM/CRAM file.}

\item{tumourname}{Identifier to be used for tumour output files.}

\item{normalname}{Identifier to be used for normal output files.}

\item{allelecounter_exe}{Path to the allele counter executable.}

\item{alleles.prefix}{Prefix path to the allele data (e.g. "G1000_alleles_chr").}

\item{loci.prefix}{Prefix path to the loci data (e.g. "G1000_loci_chr").}

\item{gender}{Gender information, either 'XX' (=female) or 'XY' (=male).}

\item{genomeVersion}{Genome version, either 'hg19' or 'hg38'.}

\item{nthreads}{The number of parallel processes for getting allele counts (optional, default=1).}

\item{tumourLogR_file}{Path to the tumour logR output (optional, paste0(tumourname,"_tumourLogR.txt")).}

\item{tumourBAF_file}{Path to the tumour BAF output (optional, paste0(tumourname,"_tumourBAF.txt")).}

\item{normalLogR_file}{Path to the normal logR output (optional, paste0(tumourname,"_normalLogR.txt")).}

\item{normalBAF_file}{Path to the normal BAF output (optional, paste0(tumourname,"_normalBAF.txt")).}

\item{minCounts}{Minimum depth required in the normal for a SNP to be considered (optional, default=10).}

\item{BED_file}{A BED file for only looking at SNPs within specific intervals (optional, default=NA).}

\item{probloci_file}{A file (chromosome <tab> position; no header) containing specific loci to ignore (optional, default=NA).}

\item{chrom_names}{A vector containing the names of chromosomes to be considered (optional, default=c(1:22,'X')).}

\item{min_base_qual}{Minimum base quality required for a read to be counted (optional, default=20).}

\item{min_map_qual}{Minimum mapping quality required for a read to be counted (optional, default=35).}

\item{ref.fasta}{FASTA file used for generating CRAMs (optional, default=NA).}

\item{skip_allele_counting_tumour}{Flag, set to TRUE if tumour allele counting is already complete (files are expected in the working directory on disk; optional, default=FALSE).}

\item{skip_allele_counting_normal}{Flag, set to TRUE if normal allele counting is already complete (files are expected in the working directory on disk; optional, default=FALSE).}

\item{seed}{A seed to be set when randomising the alleles (optional, default=as.integer(Sys.time())).}
}
\description{
Method derived from the Battenberg package (https://github.com/Wedge-lab/battenberg).
}
\author{
sd11, tl
}
