// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectSent_HeaderFile
#define _IFSelect_SelectSent_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_SelectSent.hxx>

#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
#include <IFSelect_SelectExtract.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Handle_Interface_InterfaceModel.hxx>
class Interface_EntityIterator;
class Interface_Graph;
class Standard_Transient;
class Interface_InterfaceModel;
class TCollection_AsciiString;


//! This class returns entities according sending to a file
//! Once a model has been loaded, further sendings are recorded
//! as status in the graph (for each value, a count of sendings)
//!
//! Hence, it is possible to query entities : sent ones (at least
//! once), non-sent (i.e. remaining) ones, duplicated ones, etc...
//!
//! This selection performs this query
class IFSelect_SelectSent : public IFSelect_SelectExtract
{

public:

  
  //! Creates a SelectSent :
  //! sentcount = 0 -> remaining (non-sent) entities
  //! sentcount = 1, atleast = True (D) -> sent (at least once)
  //! sentcount = 2, atleast = True -> duplicated (sent least twice)
  //! etc...
  //! sentcount = 1, atleast = False -> sent just once (non-dupl.d)
  //! sentcount = 2, atleast = False -> sent just twice
  //! etc...
  Standard_EXPORT IFSelect_SelectSent(const Standard_Integer sentcount = 1, const Standard_Boolean atleast = Standard_True);
  
  //! Returns the queried count of sending
  Standard_EXPORT   Standard_Integer SentCount()  const;
  
  //! Returns the <atleast> status, True for sending at least the
  //! sending count, False for sending exactly the sending count
  //! Remark : if SentCount is 0, AtLeast is ignored
  Standard_EXPORT   Standard_Boolean AtLeast()  const;
  
  //! Returns the list of selected entities. It is redefined to
  //! work on the graph itself (not queried by sort)
  //!
  //! An entity is selected if its count complies to the query in
  //! Direct Mode, rejected in Reversed Mode
  //!
  //! Query works on the sending count recorded as status in Graph
  Standard_EXPORT virtual   Interface_EntityIterator RootResult (const Interface_Graph& G)  const;
  
  //! Returns always False because RootResult has done the work
  Standard_EXPORT   Standard_Boolean Sort (const Standard_Integer rank, const Handle(Standard_Transient)& ent, const Handle(Interface_InterfaceModel)& model)  const;
  
  //! Returns a text defining the criterium : query :
  //! SentCount = 0 -> "Remaining (non-sent) entities"
  //! SentCount = 1, AtLeast = True  -> "Sent entities"
  //! SentCount = 1, AtLeast = False -> "Sent once (no duplicated)"
  //! SentCount = 2, AtLeast = True  -> "Sent several times entities"
  //! SentCount = 2, AtLeast = False -> "Sent twice entities"
  //! SentCount > 2, AtLeast = True  -> "Sent at least <count> times entities"
  //! SentCount > 2, AtLeast = False -> "Sent <count> times entities"
  Standard_EXPORT   TCollection_AsciiString ExtractLabel()  const;




  DEFINE_STANDARD_RTTI(IFSelect_SelectSent)

protected:




private: 


  Standard_Integer thecnt;
  Standard_Boolean thelst;


};







#endif // _IFSelect_SelectSent_HeaderFile
