/* moonshot-identity-management-view.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-identity-management-view.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include "config.h"
#include <stdio.h>
#include <atk/atk.h>
#include <gio/gio.h>


#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;
typedef struct _IdentityManagerViewPrivate IdentityManagerViewPrivate;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;

#define TYPE_CUSTOM_VBOX (custom_vbox_get_type ())
#define CUSTOM_VBOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_VBOX, CustomVBox))
#define CUSTOM_VBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_VBOX, CustomVBoxClass))
#define IS_CUSTOM_VBOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_VBOX))
#define IS_CUSTOM_VBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_VBOX))
#define CUSTOM_VBOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_VBOX, CustomVBoxClass))

typedef struct _CustomVBox CustomVBox;
typedef struct _CustomVBoxClass CustomVBoxClass;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_IDENTITY_REQUEST (identity_request_get_type ())
#define IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_REQUEST, IdentityRequest))
#define IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_REQUEST, IdentityRequestClass))
#define IS_IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_REQUEST))
#define IS_IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_REQUEST))
#define IDENTITY_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_REQUEST, IdentityRequestClass))

typedef struct _IdentityRequest IdentityRequest;
typedef struct _IdentityRequestClass IdentityRequestClass;

#define IDENTITY_MANAGER_VIEW_TYPE_COLUMNS (identity_manager_view_columns_get_type ())

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_queue_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _IdentityManagerAppPrivate IdentityManagerAppPrivate;

#define TYPE_ID_CARD_WIDGET (id_card_widget_get_type ())
#define ID_CARD_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD_WIDGET, IdCardWidget))
#define ID_CARD_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD_WIDGET, IdCardWidgetClass))
#define IS_ID_CARD_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD_WIDGET))
#define IS_ID_CARD_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD_WIDGET))
#define ID_CARD_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD_WIDGET, IdCardWidgetClass))

typedef struct _IdCardWidget IdCardWidget;
typedef struct _IdCardWidgetClass IdCardWidgetClass;

#define TYPE_IDENTITY_DIALOG (identity_dialog_get_type ())
#define IDENTITY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_DIALOG, IdentityDialog))
#define IDENTITY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_DIALOG, IdentityDialogClass))
#define IS_IDENTITY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_DIALOG))
#define IS_IDENTITY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_DIALOG))
#define IDENTITY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_DIALOG, IdentityDialogClass))

typedef struct _IdentityDialog IdentityDialog;
typedef struct _IdentityDialogClass IdentityDialogClass;
typedef struct _IdentityDialogPrivate IdentityDialogPrivate;

#define ID_CARD_TYPE_DIFF_FLAGS (id_card_diff_flags_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _IdentityRequestPrivate IdentityRequestPrivate;

#define TYPE_ADD_PASSWORD_DIALOG (add_password_dialog_get_type ())
#define ADD_PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_PASSWORD_DIALOG, AddPasswordDialog))
#define ADD_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_PASSWORD_DIALOG, AddPasswordDialogClass))
#define IS_ADD_PASSWORD_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_PASSWORD_DIALOG))
#define IS_ADD_PASSWORD_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_PASSWORD_DIALOG))
#define ADD_PASSWORD_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_PASSWORD_DIALOG, AddPasswordDialogClass))

typedef struct _AddPasswordDialog AddPasswordDialog;
typedef struct _AddPasswordDialogClass AddPasswordDialogClass;
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define WEB_PROVISIONING_TYPE_PARSER (web_provisioning_parser_get_type ())
#define WEB_PROVISIONING_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParser))
#define WEB_PROVISIONING_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))
#define WEB_PROVISIONING_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))

typedef struct _WebProvisioningParser WebProvisioningParser;
typedef struct _WebProvisioningParserClass WebProvisioningParserClass;

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;

struct _IdentityManagerView {
	GtkWindow parent_instance;
	IdentityManagerViewPrivate * priv;
	IdentityManagerApp* parent_app;
	IdentityManagerModel* identities_manager;
	GtkCheckButton* remember_identity_binding;
};

struct _IdentityManagerViewClass {
	GtkWindowClass parent_class;
};

struct _IdentityManagerViewPrivate {
	gboolean use_flat_file_store;
	GtkUIManager* ui_manager;
	GtkEntry* search_entry;
	CustomVBox* custom_vbox;
	GtkVBox* service_prompt_vbox;
	GtkButton* edit_button;
	GtkButton* remove_button;
	GtkButton* send_button;
	GtkListStore* listmodel;
	GtkTreeModelFilter* filter;
	GSList* candidates;
	GQueue* request_queue;
	IdCard* selected_card;
	gchar* import_directory;
};

typedef enum  {
	IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL,
	IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS
} IdentityManagerViewColumns;

struct _IdentityManagerApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdentityManagerAppPrivate * priv;
	IdentityManagerModel* model;
	IdCard* default_id_card;
	gboolean explicitly_launched;
	IdentityManagerView* view;
};

struct _IdentityManagerAppClass {
	GTypeClass parent_class;
	void (*finalize) (IdentityManagerApp *self);
};

struct _IdentityDialog {
	GtkDialog parent_instance;
	IdentityDialogPrivate * priv;
	gboolean complete;
	gboolean clear_trust_anchor;
};

struct _IdentityDialogClass {
	GtkDialogClass parent_class;
};

typedef enum  {
	ID_CARD_DIFF_FLAGS_DISPLAY_NAME,
	ID_CARD_DIFF_FLAGS_USERNAME,
	ID_CARD_DIFF_FLAGS_PASSWORD,
	ID_CARD_DIFF_FLAGS_ISSUER,
	ID_CARD_DIFF_FLAGS_RULES,
	ID_CARD_DIFF_FLAGS_SERVICES,
	ID_CARD_DIFF_FLAGS_TRUST_ANCHOR
} IdCardDiffFlags;

struct _IdentityRequest {
	GObject parent_instance;
	IdentityRequestPrivate * priv;
	IdCard* id_card;
	gboolean complete;
	gboolean select_default;
	gchar* nai;
	gchar* password;
	gchar* service;
	GSList* candidates;
};

struct _IdentityRequestClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	IdentityManagerView* self;
	GtkAboutDialog* about;
};


static gpointer identity_manager_view_parent_class = NULL;
static MoonshotLogger* identity_manager_view_logger;
static MoonshotLogger* identity_manager_view_logger = NULL;
static gint identity_manager_view_LATEST_EDIT_YEAR;
static gint identity_manager_view_LATEST_EDIT_YEAR = 2016;
extern GdkColor identity_manager_view_white;
GdkColor identity_manager_view_white = {0};

GType identity_manager_view_get_type (void) G_GNUC_CONST;
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
GType identity_manager_model_get_type (void) G_GNUC_CONST;
GType custom_vbox_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
GType identity_request_get_type (void) G_GNUC_CONST;
#define IDENTITY_MANAGER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewPrivate))
enum  {
	IDENTITY_MANAGER_VIEW_DUMMY_PROPERTY
};
static GType identity_manager_view_columns_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
void make_color (guint16 red, guint16 green, guint16 blue, GdkColor* result);
static void _g_object_unref0_ (gpointer var);
static void _g_queue_free__g_object_unref0_ (GQueue* self);
#define IDENTITY_MANAGER_VIEW_WINDOW_WIDTH 700
#define IDENTITY_MANAGER_VIEW_WINDOW_HEIGHT 500
#define IDENTITY_MANAGER_VIEW_menu_layout "<menubar name='MenuBar'>" "        <menu name='HelpMenu' action='HelpMenuAction'>" "             <menuitem name='About' action='AboutAction' />" "        </menu>" "</menubar>"
IdentityManagerView* identity_manager_view_new (IdentityManagerApp* app, gboolean use_flat_file_store);
IdentityManagerView* identity_manager_view_construct (GType object_type, IdentityManagerApp* app, gboolean use_flat_file_store);
static void identity_manager_view_build_ui (IdentityManagerView* self);
static void identity_manager_view_setup_list_model (IdentityManagerView* self);
static void identity_manager_view_load_id_cards (IdentityManagerView* self);
static void identity_manager_view_connect_signals (IdentityManagerView* self);
static void identity_manager_view_report_duplicate_nais (IdentityManagerView* self);
gboolean identity_manager_model_find_duplicate_nai_sets (IdentityManagerModel* self, GeeArrayList** duplicates);
const gchar* id_card_get_nai (IdCard* self);
const gchar* id_card_get_display_name (IdCard* self);
gchar* id_card_get_services_string (IdCard* self, const gchar* sep);
static void identity_manager_view_on_card_list_changed (IdentityManagerView* self);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
static gboolean identity_manager_view_visible_func (IdentityManagerView* self, GtkTreeModel* model, GtkTreeIter* iter);
const gchar* id_card_get_issuer (IdCard* self);
GeeArrayList* id_card_get_services (IdCard* self);
static gboolean _identity_manager_view_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static void identity_manager_view_search_entry_text_changed_cb (IdentityManagerView* self);
static void identity_manager_view_redraw_id_card_widgets (IdentityManagerView* self);
static gboolean identity_manager_view_search_entry_key_press_event_cb (IdentityManagerView* self, GdkEventKey* e);
void custom_vbox_clear (CustomVBox* self);
GeeLinkedList* identity_manager_model_get_card_list (IdentityManagerModel* self);
static void identity_manager_view_add_id_card_data (IdentityManagerView* self, IdCard* id_card);
GType id_card_widget_get_type (void) G_GNUC_CONST;
static IdCardWidget* identity_manager_view_add_id_card_widget (IdentityManagerView* self, IdCard* id_card);
GType identity_dialog_get_type (void) G_GNUC_CONST;
static IdCard* identity_manager_view_update_id_card_data (IdentityManagerView* self, IdentityDialog* dialog, IdCard* id_card);
const gchar* identity_dialog_get_display_name (IdentityDialog* self);
void id_card_set_display_name (IdCard* self, const gchar* value);
const gchar* identity_dialog_get_issuer (IdentityDialog* self);
void id_card_set_issuer (IdCard* self, const gchar* value);
const gchar* identity_dialog_get_username (IdentityDialog* self);
void id_card_set_username (IdCard* self, const gchar* value);
const gchar* identity_dialog_get_password (IdentityDialog* self);
void id_card_set_password (IdCard* self, const gchar* value);
gboolean identity_dialog_get_store_password (IdentityDialog* self);
void id_card_set_store_password (IdCard* self, gboolean value);
void id_card_update_services_from_list (IdCard* self, GeeArrayList* services);
GeeArrayList* identity_dialog_get_services (IdentityDialog* self);
void id_card_clear_trust_anchor (IdCard* self);
GdkPixbuf* get_pixbuf (IdCard* id);
const gchar* id_card_get_username (IdCard* self);
const gchar* id_card_get_password (IdCard* self);
IdCardWidget* id_card_widget_new (IdCard* id_card, IdentityManagerView* manager_view);
IdCardWidget* id_card_widget_construct (GType object_type, IdCard* id_card, IdentityManagerView* manager_view);
void custom_vbox_add_id_card_widget (CustomVBox* self, IdCardWidget* id_card_widget);
static void identity_manager_view_widget_selected_cb (IdentityManagerView* self, IdCardWidget* id_card_widget);
static void _identity_manager_view_widget_selected_cb_id_card_widget_expanded (IdCardWidget* _sender, gpointer self);
static void identity_manager_view_widget_unselected_cb (IdentityManagerView* self, IdCardWidget* id_card_widget);
static void _identity_manager_view_widget_unselected_cb_id_card_widget_collapsed (IdCardWidget* _sender, gpointer self);
void id_card_widget_expand (IdCardWidget* self);
IdCard* id_card_widget_get_id_card (IdCardWidget* self);
gboolean id_card_is_no_identity (IdCard* self);
void custom_vbox_receive_expanded_event (CustomVBox* self, IdCardWidget* id_card_widget);
gboolean identity_manager_view_selection_in_progress (IdentityManagerView* self);
void custom_vbox_receive_collapsed_event (CustomVBox* self, IdCardWidget* id_card_widget);
gboolean identity_manager_view_add_identity (IdentityManagerView* self, IdCard* id_card, gboolean force_flat_file_store, GeeArrayList** old_duplicates);
IdCard* identity_manager_model_find_id_card (IdentityManagerModel* self, const gchar* nai, gboolean force_flat_file_store);
gint id_card_Compare (IdCard* self, IdCard* other);
GType id_card_diff_flags_get_type (void) G_GNUC_CONST;
void identity_manager_model_add_card (IdentityManagerModel* self, IdCard* card, gboolean force_flat_file_store, GeeArrayList** old_duplicates);
static void identity_manager_view_add_identity_cb (IdentityManagerView* self);
IdentityDialog* identity_dialog_new (IdentityManagerView* parent);
IdentityDialog* identity_dialog_construct (GType object_type, IdentityManagerView* parent);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
static void identity_manager_view_edit_identity_cb (IdentityManagerView* self, IdCard* card);
IdentityDialog* identity_dialog_new_with_idcard (IdCard* a_card, const gchar* title, IdentityManagerView* parent);
IdentityDialog* identity_dialog_construct_with_idcard (GType object_type, IdCard* a_card, const gchar* title, IdentityManagerView* parent);
IdCard* identity_manager_model_update_card (IdentityManagerModel* self, IdCard* card);
static void identity_manager_view_remove_identity (IdentityManagerView* self, IdCard* id_card);
gboolean identity_manager_model_remove_card (IdentityManagerModel* self, IdCard* card);
static void identity_manager_view_remove_identity_cb (IdentityManagerView* self, IdCard* id_card);
gboolean warning_dialog_confirm (GtkWindow* parent, const gchar* message, const gchar* dialog_name);
static void identity_manager_view_set_prompting_service (IdentityManagerView* self, const gchar* service);
static void identity_manager_view_clear_selection_prompts (IdentityManagerView* self);
void identity_manager_view_queue_identity_request (IdentityManagerView* self, IdentityRequest* request);
IdCardWidget* custom_vbox_find_idcard_widget (CustomVBox* self, IdCard* card);
void identity_manager_view_make_visible (IdentityManagerView* self);
IdCard* identity_manager_view_check_add_password (IdentityManagerView* self, IdCard* identity, IdentityRequest* request, IdentityManagerModel* model);
GType add_password_dialog_get_type (void) G_GNUC_CONST;
AddPasswordDialog* add_password_dialog_new (IdCard* id_card, IdentityRequest* request);
AddPasswordDialog* add_password_dialog_construct (GType object_type, IdCard* id_card, IdentityRequest* request);
const gchar* add_password_dialog_get_password (AddPasswordDialog* self);
void add_password_dialog_clear_password (AddPasswordDialog* self);
gboolean add_password_dialog_get_remember (AddPasswordDialog* self);
void id_card_set_temporary (IdCard* self, gboolean value);
static void identity_manager_view_send_identity_cb (IdentityManagerView* self, IdCard* id);
void identity_request_return_identity (IdentityRequest* self, IdCard* id_card, gboolean update_card);
static void identity_manager_view_on_about_action (IdentityManagerView* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_, GtkDialog* a, gint b);
static void ___lambda6__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void set_bg_color (GtkWidget* w);
static GtkActionEntry* identity_manager_view_create_actions (IdentityManagerView* self, int* result_length1);
static void _vala_array_add1 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void _identity_manager_view_on_about_action_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add2 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value);
static void identity_manager_view_create_ui_manager (IdentityManagerView* self);
void moonshot_logger_error (MoonshotLogger* self, const gchar* message, GError* e);
static void identity_manager_view_set_atk_name_description (IdentityManagerView* self, GtkWidget* widget, const gchar* name, const gchar* description);
GdkPixbuf* find_icon_sized (const gchar* name, GtkIconSize icon_size);
static void _identity_manager_view_search_entry_text_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _identity_manager_view_search_entry_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
CustomVBox* custom_vbox_new (IdentityManagerView* window, gboolean homogeneous, gint spacing);
CustomVBox* custom_vbox_construct (GType object_type, IdentityManagerView* window, gboolean homogeneous, gint spacing);
static void __lambda7_ (IdentityManagerView* self, GtkButton* w);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GtkWidget* identity_manager_view_make_rigid (GtkButton* button);
static void __lambda13_ (IdentityManagerView* self, GtkButton* w);
static void identity_manager_view_import_identities_cb (IdentityManagerView* self);
static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda14_ (IdentityManagerView* self, GtkButton* w);
static void ___lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda15_ (IdentityManagerView* self, GtkButton* w);
static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda16_ (IdentityManagerView* self, GtkButton* w);
static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda17_ (IdentityManagerView* self);
static void ___lambda17__gtk_object_destroy (GtkObject* _sender, gpointer self);
static void _identity_manager_view_on_card_list_changed_identity_manager_model_card_list_changed (IdentityManagerModel* _sender, gpointer self);
static gboolean __lambda18_ (IdentityManagerView* self);
static gboolean identity_manager_view_confirm_quit (IdentityManagerView* self);
static gboolean ___lambda18__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
GType web_provisioning_parser_get_type (void) G_GNUC_CONST;
WebProvisioningParser* web_provisioning_parser_new (const gchar* path);
WebProvisioningParser* web_provisioning_parser_construct (GType object_type, const gchar* path);
void web_provisioning_parser_parse (WebProvisioningParser* self);
IdCard** web_provisioning_parser_get_cards (WebProvisioningParser* self, int* result_length1);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
gboolean trust_anchor_is_empty (TrustAnchor* self);
gchar* trust_anchor_format_datetime_now (void);
void trust_anchor_set_datetime_added (TrustAnchor* self, const gchar* datetime);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
static void identity_manager_view_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType identity_manager_view_columns_get_type (void) {
	static volatile gsize identity_manager_view_columns_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_view_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL", "idcard-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL", "logo-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL", "issuer-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL", "username-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL, "IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL", "password-col"}, {IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS, "IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType identity_manager_view_columns_type_id;
		identity_manager_view_columns_type_id = g_enum_register_static ("IdentityManagerViewColumns", values);
		g_once_init_leave (&identity_manager_view_columns_type_id__volatile, identity_manager_view_columns_type_id);
	}
	return identity_manager_view_columns_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 477 "moonshot-identity-management-view.c"
}


static void _g_queue_free__g_object_unref0_ (GQueue* self) {
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_queue_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_queue_free (self);
#line 486 "moonshot-identity-management-view.c"
}


static gpointer _identity_manager_app_ref0 (gpointer self) {
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return self ? identity_manager_app_ref (self) : NULL;
#line 493 "moonshot-identity-management-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 500 "moonshot-identity-management-view.c"
}


IdentityManagerView* identity_manager_view_construct (GType object_type, IdentityManagerApp* app, gboolean use_flat_file_store) {
	IdentityManagerView * self = NULL;
	IdentityManagerApp* _tmp0_ = NULL;
	IdentityManagerApp* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	IdentityManagerApp* _tmp3_ = NULL;
	IdentityManagerModel* _tmp4_ = NULL;
	IdentityManagerModel* _tmp5_ = NULL;
	GQueue* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self = (IdentityManagerView*) g_object_new (object_type, NULL);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = app;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _identity_manager_app_ref0 (_tmp0_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_identity_manager_app_unref0 (self->parent_app);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->parent_app = _tmp1_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = use_flat_file_store;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->use_flat_file_store = _tmp2_;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->parent_app;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = _tmp3_->model;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->identities_manager);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->identities_manager = _tmp5_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = g_queue_new ();
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__g_queue_free__g_object_unref0_0 (self->priv->request_queue);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->request_queue = _tmp6_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = _ ("Moonshot Identity Selector");
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp7_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_default_size ((GtkWindow*) self, IDENTITY_MANAGER_VIEW_WINDOW_WIDTH, IDENTITY_MANAGER_VIEW_WINDOW_HEIGHT);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_build_ui (self);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_setup_list_model (self);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_load_id_cards (self);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_connect_signals (self);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_report_duplicate_nais (self);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return self;
#line 566 "moonshot-identity-management-view.c"
}


IdentityManagerView* identity_manager_view_new (IdentityManagerApp* app, gboolean use_flat_file_store) {
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return identity_manager_view_construct (TYPE_IDENTITY_MANAGER_VIEW, app, use_flat_file_store);
#line 573 "moonshot-identity-management-view.c"
}


static void identity_manager_view_report_duplicate_nais (IdentityManagerView* self) {
	GeeArrayList* duplicates = NULL;
	IdentityManagerModel* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->identities_manager;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_model_find_duplicate_nai_sets (_tmp0_, &_tmp1_);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (duplicates);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	duplicates = _tmp1_;
#line 591 "moonshot-identity-management-view.c"
	{
		GeeArrayList* _list_list = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _list_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _list_index = 0;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = duplicates;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_list_list = _tmp3_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = _list_list;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = _tmp5_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_list_size = _tmp6_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_list_index = -1;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		while (TRUE) {
#line 619 "moonshot-identity-management-view.c"
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			GeeArrayList* list = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			gchar* message = NULL;
			const gchar* _tmp13_ = NULL;
			GeeArrayList* _tmp14_ = NULL;
			gpointer _tmp15_ = NULL;
			IdCard* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			GtkMessageDialog* msg_dialog = NULL;
			const gchar* _tmp49_ = NULL;
			GtkMessageDialog* _tmp50_ = NULL;
			GtkMessageDialog* _tmp51_ = NULL;
			GtkMessageDialog* _tmp52_ = NULL;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp7_ = _list_index;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_list_index = _tmp7_ + 1;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp8_ = _list_index;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp9_ = _list_size;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				break;
#line 659 "moonshot-identity-management-view.c"
			}
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp10_ = _list_list;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp11_ = _list_index;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			list = (GeeArrayList*) _tmp12_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp13_ = _ ("The following identities use the same Network Access Identifier (NAI)," \
"\n" \
"'%s'.");
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp14_ = list;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, 0);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp16_ = (IdCard*) _tmp15_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp17_ = id_card_get_nai (_tmp16_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp18_ = _tmp17_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp19_ = g_strdup_printf (_tmp13_, _tmp18_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp20_ = _tmp19_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp21_ = _ ("\n" \
"\n" \
"Duplicate NAIs are not allowed. Please remove identities you don't nee" \
"d, or modify");
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp23_ = _tmp22_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp24_ = _ (" user ID or issuer fields so that they are no longer the same NAI.");
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp26_ = _tmp25_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_free0 (_tmp23_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_free0 (_tmp20_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp16_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			message = _tmp26_;
#line 705 "moonshot-identity-management-view.c"
			{
				GeeArrayList* _card_list = NULL;
				GeeArrayList* _tmp27_ = NULL;
				GeeArrayList* _tmp28_ = NULL;
				gint _card_size = 0;
				GeeArrayList* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _card_index = 0;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp27_ = list;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp28_ = _g_object_ref0 (_tmp27_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_card_list = _tmp28_;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp29_ = _card_list;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp31_ = _tmp30_;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_card_size = _tmp31_;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_card_index = -1;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				while (TRUE) {
#line 733 "moonshot-identity-management-view.c"
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					IdCard* card = NULL;
					GeeArrayList* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gpointer _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					IdCard* _tmp40_ = NULL;
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					IdCard* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp32_ = _card_index;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_card_index = _tmp32_ + 1;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp33_ = _card_index;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp34_ = _card_size;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (!(_tmp33_ < _tmp34_)) {
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						break;
#line 764 "moonshot-identity-management-view.c"
					}
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp35_ = _card_list;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp36_ = _card_index;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp36_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					card = (IdCard*) _tmp37_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp38_ = message;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp39_ = _ ("\n\nDisplay Name: '%s'\nServices:\n     %s");
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp40_ = card;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp41_ = id_card_get_display_name (_tmp40_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp42_ = _tmp41_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp43_ = card;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp44_ = id_card_get_services_string (_tmp43_, ",\n     ");
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp45_ = _tmp44_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp46_ = g_strdup_printf (_tmp39_, _tmp42_, _tmp45_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp47_ = _tmp46_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp48_ = g_strconcat (_tmp38_, _tmp47_, NULL);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (message);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					message = _tmp48_;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (_tmp47_);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (_tmp45_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_object_unref0 (card);
#line 806 "moonshot-identity-management-view.c"
				}
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (_card_list);
#line 810 "moonshot-identity-management-view.c"
			}
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp49_ = message;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp50_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", _tmp49_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			g_object_ref_sink (_tmp50_);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			msg_dialog = _tmp50_;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp51_ = msg_dialog;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_dialog_run ((GtkDialog*) _tmp51_);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp52_ = msg_dialog;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_object_destroy ((GtkObject*) _tmp52_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (msg_dialog);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_free0 (message);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (list);
#line 834 "moonshot-identity-management-view.c"
		}
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_list_list);
#line 838 "moonshot-identity-management-view.c"
	}
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (duplicates);
#line 842 "moonshot-identity-management-view.c"
}


static void identity_manager_view_on_card_list_changed (IdentityManagerView* self) {
	MoonshotLogger* _tmp0_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, "on_card_list_changed", NULL);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_load_id_cards (self);
#line 856 "moonshot-identity-management-view.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1384 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1384 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 876 "moonshot-identity-management-view.c"
}


static gboolean identity_manager_view_visible_func (IdentityManagerView* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	IdCard* id_card = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	IdCard* _tmp2_ = NULL;
	GSList* _tmp3_ = NULL;
	gchar* entry_text = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = model;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = *iter;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_get (_tmp0_, &_tmp1_, IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, &id_card, -1);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp2_ == NULL) {
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = FALSE;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (id_card);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 918 "moonshot-identity-management-view.c"
	}
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->candidates;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp3_ != NULL) {
#line 924 "moonshot-identity-management-view.c"
		gboolean is_candidate = FALSE;
		GSList* _tmp4_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		is_candidate = FALSE;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = self->priv->candidates;
#line 932 "moonshot-identity-management-view.c"
		{
			GSList* candidate_collection = NULL;
			GSList* candidate_it = NULL;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			candidate_collection = _tmp4_;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			for (candidate_it = candidate_collection; candidate_it != NULL; candidate_it = candidate_it->next) {
#line 940 "moonshot-identity-management-view.c"
				IdCard* _tmp5_ = NULL;
				IdCard* candidate = NULL;
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp5_ = _g_object_ref0 ((IdCard*) candidate_it->data);
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				candidate = _tmp5_;
#line 947 "moonshot-identity-management-view.c"
				{
					IdCard* _tmp6_ = NULL;
					IdCard* _tmp7_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp6_ = candidate;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp7_ = id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp6_ == _tmp7_) {
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						is_candidate = TRUE;
#line 959 "moonshot-identity-management-view.c"
					}
#line 151 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_object_unref0 (candidate);
#line 963 "moonshot-identity-management-view.c"
				}
			}
		}
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = is_candidate;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (!_tmp8_) {
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			result = FALSE;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (id_card);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			return result;
#line 977 "moonshot-identity-management-view.c"
		}
	}
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->search_entry;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = gtk_entry_get_text (_tmp9_);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	entry_text = _tmp11_;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = entry_text;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp13_ == NULL) {
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = TRUE;
#line 994 "moonshot-identity-management-view.c"
	} else {
		const gchar* _tmp14_ = NULL;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = entry_text;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = g_strcmp0 (_tmp14_, "") == 0;
#line 1001 "moonshot-identity-management-view.c"
	}
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp12_) {
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = TRUE;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (entry_text);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (id_card);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 1013 "moonshot-identity-management-view.c"
	}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = entry_text;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, " ", 0);
#line 1019 "moonshot-identity-management-view.c"
	{
		gchar** search_text_collection = NULL;
		gint search_text_collection_length1 = 0;
		gint _search_text_collection_size_ = 0;
		gint search_text_it = 0;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		search_text_collection = _tmp17_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		search_text_collection_length1 = _vala_array_length (_tmp16_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		for (search_text_it = 0; search_text_it < _vala_array_length (_tmp16_); search_text_it = search_text_it + 1) {
#line 1031 "moonshot-identity-management-view.c"
			gchar* _tmp18_ = NULL;
			gchar* search_text = NULL;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp18_ = g_strdup (search_text_collection[search_text_it]);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			search_text = _tmp18_;
#line 1038 "moonshot-identity-management-view.c"
			{
				const gchar* _tmp19_ = NULL;
				gchar* search_text_casefold = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				IdCard* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				IdCard* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				IdCard* _tmp42_ = NULL;
				GeeArrayList* _tmp43_ = NULL;
				GeeArrayList* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp19_ = search_text;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (g_strcmp0 (_tmp19_, "") == 0) {
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (search_text);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					continue;
#line 1063 "moonshot-identity-management-view.c"
				}
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp20_ = search_text;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp21_ = g_utf8_casefold (_tmp20_, (gssize) -1);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				search_text_casefold = _tmp21_;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp22_ = id_card;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp23_ = id_card_get_issuer (_tmp22_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp24_ = _tmp23_;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (_tmp24_ != NULL) {
#line 1079 "moonshot-identity-management-view.c"
					gchar* issuer_casefold = NULL;
					IdCard* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gboolean _tmp31_ = FALSE;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp25_ = id_card;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp26_ = id_card_get_issuer (_tmp25_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp27_ = _tmp26_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp28_ = g_strdup (_tmp27_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					issuer_casefold = _tmp28_;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp29_ = issuer_casefold;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp30_ = search_text_casefold;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp31_ = string_contains (_tmp29_, _tmp30_);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp31_) {
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						result = TRUE;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (issuer_casefold);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text_casefold);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (entry_text);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_object_unref0 (id_card);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						return result;
#line 1122 "moonshot-identity-management-view.c"
					}
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (issuer_casefold);
#line 1126 "moonshot-identity-management-view.c"
				}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp32_ = id_card;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp33_ = id_card_get_display_name (_tmp32_);
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp34_ = _tmp33_;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (_tmp34_ != NULL) {
#line 1136 "moonshot-identity-management-view.c"
					gchar* display_name_casefold = NULL;
					IdCard* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					gboolean _tmp41_ = FALSE;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp35_ = id_card;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp36_ = id_card_get_display_name (_tmp35_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp37_ = _tmp36_;
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp38_ = g_utf8_casefold (_tmp37_, (gssize) -1);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					display_name_casefold = _tmp38_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp39_ = display_name_casefold;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp40_ = search_text_casefold;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp41_ = string_contains (_tmp39_, _tmp40_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp41_) {
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						result = TRUE;
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (display_name_casefold);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text_casefold);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (search_text);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (entry_text);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_object_unref0 (id_card);
#line 187 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						return result;
#line 1179 "moonshot-identity-management-view.c"
					}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_free0 (display_name_casefold);
#line 1183 "moonshot-identity-management-view.c"
				}
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp42_ = id_card;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp43_ = id_card_get_services (_tmp42_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp44_ = _tmp43_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp46_ = _tmp45_;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (_tmp46_ > 0) {
#line 1197 "moonshot-identity-management-view.c"
					{
						GeeArrayList* _service_list = NULL;
						IdCard* _tmp47_ = NULL;
						GeeArrayList* _tmp48_ = NULL;
						GeeArrayList* _tmp49_ = NULL;
						GeeArrayList* _tmp50_ = NULL;
						gint _service_size = 0;
						GeeArrayList* _tmp51_ = NULL;
						gint _tmp52_ = 0;
						gint _tmp53_ = 0;
						gint _service_index = 0;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp47_ = id_card;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp48_ = id_card_get_services (_tmp47_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp49_ = _tmp48_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp50_ = _g_object_ref0 (_tmp49_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_service_list = _tmp50_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp51_ = _service_list;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp52_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp51_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp53_ = _tmp52_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_service_size = _tmp53_;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_service_index = -1;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						while (TRUE) {
#line 1231 "moonshot-identity-management-view.c"
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							gchar* service = NULL;
							GeeArrayList* _tmp57_ = NULL;
							gint _tmp58_ = 0;
							gpointer _tmp59_ = NULL;
							gchar* service_casefold = NULL;
							const gchar* _tmp60_ = NULL;
							gchar* _tmp61_ = NULL;
							const gchar* _tmp62_ = NULL;
							const gchar* _tmp63_ = NULL;
							gboolean _tmp64_ = FALSE;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp54_ = _service_index;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_service_index = _tmp54_ + 1;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp55_ = _service_index;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp56_ = _service_size;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							if (!(_tmp55_ < _tmp56_)) {
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								break;
#line 1257 "moonshot-identity-management-view.c"
							}
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp57_ = _service_list;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp58_ = _service_index;
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _tmp58_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							service = (gchar*) _tmp59_;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp60_ = service;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp61_ = g_utf8_casefold (_tmp60_, (gssize) -1);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							service_casefold = _tmp61_;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp62_ = service_casefold;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp63_ = search_text_casefold;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_tmp64_ = string_contains (_tmp62_, _tmp63_);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							if (_tmp64_) {
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								result = TRUE;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_free0 (service_casefold);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_free0 (service);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_object_unref0 (_service_list);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_free0 (search_text_casefold);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_free0 (search_text);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_free0 (entry_text);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								_g_object_unref0 (id_card);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
								return result;
#line 1301 "moonshot-identity-management-view.c"
							}
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_g_free0 (service_casefold);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
							_g_free0 (service);
#line 1307 "moonshot-identity-management-view.c"
						}
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_object_unref0 (_service_list);
#line 1311 "moonshot-identity-management-view.c"
					}
				}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_free0 (search_text_casefold);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_free0 (search_text);
#line 1318 "moonshot-identity-management-view.c"
			}
		}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		search_text_collection = (_vala_array_free (search_text_collection, search_text_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1323 "moonshot-identity-management-view.c"
	}
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = FALSE;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (entry_text);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (id_card);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 1333 "moonshot-identity-management-view.c"
}


static gboolean _identity_manager_view_visible_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = identity_manager_view_visible_func ((IdentityManagerView*) self, model, iter);
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 1342 "moonshot-identity-management-view.c"
}


static void identity_manager_view_setup_list_model (IdentityManagerView* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GtkTreeModelFilter* _tmp2_ = NULL;
	GtkTreeModelFilter* _tmp3_ = NULL;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = gtk_list_store_new ((gint) IDENTITY_MANAGER_VIEW_COLUMNS_N_COLUMNS, TYPE_ID_CARD, gdk_pixbuf_get_type (), G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->listmodel = _tmp0_;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->listmodel;
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp1_, NULL);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->filter);
#line 211 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->filter = _tmp2_;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->filter;
#line 213 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_filter_set_visible_func (_tmp3_, _identity_manager_view_visible_func_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
#line 1369 "moonshot-identity-management-view.c"
}


static void identity_manager_view_search_entry_text_changed_cb (IdentityManagerView* self) {
	GtkTreeModelFilter* _tmp0_ = NULL;
#line 216 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->filter;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_filter_refilter (_tmp0_);
#line 219 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_redraw_id_card_widgets (self);
#line 1383 "moonshot-identity-management-view.c"
}


static gboolean identity_manager_view_search_entry_key_press_event_cb (IdentityManagerView* self, GdkEventKey* e) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 222 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = *e;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _tmp0_.keyval;
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = gdk_keyval_name (_tmp1_);
#line 224 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (g_strcmp0 (_tmp2_, "Escape") == 0) {
#line 1404 "moonshot-identity-management-view.c"
		GtkEntry* _tmp3_ = NULL;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = self->priv->search_entry;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_entry_set_text (_tmp3_, "");
#line 1410 "moonshot-identity-management-view.c"
	}
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = FALSE;
#line 229 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 1416 "moonshot-identity-management-view.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1428 "moonshot-identity-management-view.c"
}


static void identity_manager_view_load_id_cards (IdentityManagerView* self) {
	MoonshotLogger* _tmp0_ = NULL;
	CustomVBox* _tmp1_ = NULL;
	GtkListStore* _tmp2_ = NULL;
	GeeLinkedList* card_list = NULL;
	IdentityManagerModel* _tmp3_ = NULL;
	GeeLinkedList* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 233 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, "load_id_cards", NULL);
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->custom_vbox;
#line 235 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_clear (_tmp1_);
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = self->priv->listmodel;
#line 236 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_list_store_clear (_tmp2_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->identities_manager;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = identity_manager_model_get_card_list (_tmp3_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	card_list = _tmp4_;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = card_list;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp5_ == NULL) {
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (card_list);
#line 239 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return;
#line 1468 "moonshot-identity-management-view.c"
	}
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp6_ = NULL;
		GeeLinkedList* _tmp7_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _id_card_index = 0;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = card_list;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_id_card_list = _tmp7_;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = _id_card_list;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = _tmp9_;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_id_card_size = _tmp10_;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_id_card_index = -1;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		while (TRUE) {
#line 1497 "moonshot-identity-management-view.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			MoonshotLogger* _tmp17_ = NULL;
			IdCard* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			IdCard* _tmp24_ = NULL;
			IdCard* _tmp25_ = NULL;
			IdCardWidget* _tmp26_ = NULL;
			IdCardWidget* _tmp27_ = NULL;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp11_ = _id_card_index;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_id_card_index = _tmp11_ + 1;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp12_ = _id_card_index;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp13_ = _id_card_size;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				break;
#line 1528 "moonshot-identity-management-view.c"
			}
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp14_ = _id_card_list;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp15_ = _id_card_index;
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card = (IdCard*) _tmp16_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp17_ = identity_manager_view_logger;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp18_ = id_card;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp19_ = id_card_get_display_name (_tmp18_);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp20_ = _tmp19_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp21_ = string_to_string (_tmp20_);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp22_ = g_strconcat ("load_id_cards: Loading card with display name '", _tmp21_, "'", NULL);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp23_ = _tmp22_;
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			moonshot_logger_trace (_tmp17_, _tmp23_, NULL);
#line 243 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_free0 (_tmp23_);
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp24_ = id_card;
#line 244 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			identity_manager_view_add_id_card_data (self, _tmp24_);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp25_ = id_card;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp26_ = identity_manager_view_add_id_card_widget (self, _tmp25_);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp27_ = _tmp26_;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp27_);
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (id_card);
#line 1570 "moonshot-identity-management-view.c"
		}
#line 242 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_id_card_list);
#line 1574 "moonshot-identity-management-view.c"
	}
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (card_list);
#line 1578 "moonshot-identity-management-view.c"
}


static IdCard* identity_manager_view_update_id_card_data (IdentityManagerView* self, IdentityDialog* dialog, IdCard* id_card) {
	IdCard* result = NULL;
	IdCard* _tmp0_ = NULL;
	IdentityDialog* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	IdCard* _tmp4_ = NULL;
	IdentityDialog* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	IdCard* _tmp8_ = NULL;
	IdentityDialog* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	IdCard* _tmp12_ = NULL;
	IdentityDialog* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	IdCard* _tmp16_ = NULL;
	IdentityDialog* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	IdCard* _tmp20_ = NULL;
	IdentityDialog* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	GeeArrayList* _tmp23_ = NULL;
	IdentityDialog* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	IdCard* _tmp27_ = NULL;
	IdCard* _tmp28_ = NULL;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (dialog != NULL, NULL);
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (id_card != NULL, NULL);
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card;
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = dialog;
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = identity_dialog_get_display_name (_tmp1_);
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_display_name (_tmp0_, _tmp3_);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = id_card;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = dialog;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = identity_dialog_get_issuer (_tmp5_);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = _tmp6_;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_issuer (_tmp4_, _tmp7_);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = id_card;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = dialog;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = identity_dialog_get_username (_tmp9_);
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = _tmp10_;
#line 253 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_username (_tmp8_, _tmp11_);
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = id_card;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = dialog;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = identity_dialog_get_password (_tmp13_);
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = _tmp14_;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_password (_tmp12_, _tmp15_);
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = id_card;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = dialog;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = identity_dialog_get_store_password (_tmp17_);
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp19_ = _tmp18_;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_set_store_password (_tmp16_, _tmp19_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp20_ = id_card;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp21_ = dialog;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp22_ = identity_dialog_get_services (_tmp21_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp23_ = _tmp22_;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_update_services_from_list (_tmp20_, _tmp23_);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp23_);
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp24_ = dialog;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp25_ = _tmp24_->clear_trust_anchor;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp25_) {
#line 1686 "moonshot-identity-management-view.c"
		IdCard* _tmp26_ = NULL;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp26_ = id_card;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		id_card_clear_trust_anchor (_tmp26_);
#line 1692 "moonshot-identity-management-view.c"
	}
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp27_ = id_card;
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = _tmp28_;
#line 263 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 1702 "moonshot-identity-management-view.c"
}


static void identity_manager_view_add_id_card_data (IdentityManagerView* self, IdCard* id_card) {
	GtkTreeIter iter = {0};
	GdkPixbuf* pixbuf = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	IdCard* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	IdCard* _tmp6_ = NULL;
	IdCard* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	IdCard* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card != NULL);
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->listmodel;
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_list_store_append (_tmp0_, &_tmp1_);
#line 270 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	iter = _tmp1_;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card;
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = get_pixbuf (_tmp2_);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (pixbuf);
#line 271 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	pixbuf = _tmp3_;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->listmodel;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = iter;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = id_card;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = id_card;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = id_card_get_issuer (_tmp7_);
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = _tmp8_;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = id_card;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = id_card_get_username (_tmp10_);
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = id_card;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = id_card_get_password (_tmp13_);
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = _tmp14_;
#line 272 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_list_store_set (_tmp4_, &_tmp5_, IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, _tmp6_, IDENTITY_MANAGER_VIEW_COLUMNS_LOGO_COL, pixbuf, IDENTITY_MANAGER_VIEW_COLUMNS_ISSUER_COL, _tmp9_, IDENTITY_MANAGER_VIEW_COLUMNS_USERNAME_COL, _tmp12_, IDENTITY_MANAGER_VIEW_COLUMNS_PASSWORD_COL, _tmp15_, -1);
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (pixbuf);
#line 1771 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_widget_selected_cb_id_card_widget_expanded (IdCardWidget* _sender, gpointer self) {
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_widget_selected_cb ((IdentityManagerView*) self, _sender);
#line 1778 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_widget_unselected_cb_id_card_widget_collapsed (IdCardWidget* _sender, gpointer self) {
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_widget_unselected_cb ((IdentityManagerView*) self, _sender);
#line 1785 "moonshot-identity-management-view.c"
}


static IdCardWidget* identity_manager_view_add_id_card_widget (IdentityManagerView* self, IdCard* id_card) {
	IdCardWidget* result = NULL;
	IdCard* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	MoonshotLogger* _tmp7_ = NULL;
	IdCard* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	IdCardWidget* id_card_widget = NULL;
	IdCard* _tmp13_ = NULL;
	IdCardWidget* _tmp14_ = NULL;
	CustomVBox* _tmp15_ = NULL;
	IdCardWidget* _tmp16_ = NULL;
	IdCardWidget* _tmp17_ = NULL;
	IdCardWidget* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	IdCard* _tmp20_ = NULL;
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 280 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (id_card != NULL, NULL);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = id_card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp0_ == NULL) {
#line 1817 "moonshot-identity-management-view.c"
		MoonshotLogger* _tmp1_ = NULL;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp1_ = identity_manager_view_logger;
#line 283 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		moonshot_logger_trace (_tmp1_, "add_id_card_widget: id_card == null; returning.", NULL);
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = NULL;
#line 284 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 1827 "moonshot-identity-management-view.c"
	}
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = self->priv->selected_card;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp3_ == NULL) {
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = "[null selection]";
#line 1835 "moonshot-identity-management-view.c"
	} else {
		IdCard* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = self->priv->selected_card;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = id_card_get_nai (_tmp4_);
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = _tmp5_;
#line 289 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = _tmp6_;
#line 1848 "moonshot-identity-management-view.c"
	}
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = identity_manager_view_logger;
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = id_card;
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = id_card_get_nai (_tmp8_);
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = _tmp9_;
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = g_strdup_printf ("add_id_card_widget: id_card.nai='%s'; selected nai='%s'", _tmp10_, _tmp2_);
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_;
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp7_, _tmp12_, NULL);
#line 287 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp12_);
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = id_card;
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = id_card_widget_new (_tmp13_, self);
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp14_);
#line 292 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_card_widget = _tmp14_;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = self->priv->custom_vbox;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = id_card_widget;
#line 293 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_add_id_card_widget (_tmp15_, _tmp16_);
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = id_card_widget;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp17_, "expanded", (GCallback) _identity_manager_view_widget_selected_cb_id_card_widget_expanded, self, 0);
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = id_card_widget;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp18_, "collapsed", (GCallback) _identity_manager_view_widget_unselected_cb_id_card_widget_collapsed, self, 0);
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp20_ = self->priv->selected_card;
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp20_ != NULL) {
#line 1892 "moonshot-identity-management-view.c"
		IdCard* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		IdCard* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = self->priv->selected_card;
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = id_card_get_nai (_tmp21_);
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = _tmp22_;
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = id_card;
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp25_ = id_card_get_nai (_tmp24_);
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp26_ = _tmp25_;
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = g_strcmp0 (_tmp23_, _tmp26_) == 0;
#line 1913 "moonshot-identity-management-view.c"
	} else {
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = FALSE;
#line 1917 "moonshot-identity-management-view.c"
	}
#line 297 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp19_) {
#line 1921 "moonshot-identity-management-view.c"
		MoonshotLogger* _tmp27_ = NULL;
		IdCardWidget* _tmp28_ = NULL;
		IdCard* _tmp29_ = NULL;
		IdCard* _tmp30_ = NULL;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp27_ = identity_manager_view_logger;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		moonshot_logger_trace (_tmp27_, "add_id_card_widget: Expanding selected idcard widget", NULL);
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp28_ = id_card_widget;
#line 299 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		id_card_widget_expand (_tmp28_);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp29_ = id_card;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp30_ = _g_object_ref0 (_tmp29_);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (self->priv->selected_card);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->selected_card = _tmp30_;
#line 1942 "moonshot-identity-management-view.c"
	}
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = id_card_widget;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 1948 "moonshot-identity-management-view.c"
}


static void identity_manager_view_widget_selected_cb (IdentityManagerView* self, IdCardWidget* id_card_widget) {
	MoonshotLogger* _tmp0_ = NULL;
	IdCardWidget* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	IdCardWidget* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	IdCard* _tmp11_ = NULL;
	IdCard* _tmp12_ = NULL;
	gboolean allow_removes = FALSE;
	IdCardWidget* _tmp13_ = NULL;
	IdCard* _tmp14_ = NULL;
	IdCard* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GtkButton* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GtkButton* _tmp19_ = NULL;
	CustomVBox* _tmp20_ = NULL;
	IdCardWidget* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card_widget != NULL);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card_widget_get_id_card (_tmp1_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = id_card_get_display_name (_tmp3_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _tmp4_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = string_to_string (_tmp5_);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = g_strconcat ("widget_selected_cb: id_card_widget.id_card.display_name='", _tmp6_, "'", NULL);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = _tmp7_;
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, _tmp8_, NULL);
#line 316 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp8_);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = id_card_widget;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = id_card_widget_get_id_card (_tmp9_);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = _tmp10_;
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->selected_card);
#line 318 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->selected_card = _tmp12_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = id_card_widget;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = id_card_widget_get_id_card (_tmp13_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = _tmp14_;
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = id_card_is_no_identity (_tmp15_);
#line 319 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	allow_removes = !_tmp16_;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = self->priv->remove_button;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = allow_removes;
#line 320 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, _tmp18_);
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp19_ = self->priv->edit_button;
#line 321 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, TRUE);
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp20_ = self->priv->custom_vbox;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp21_ = id_card_widget;
#line 322 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_receive_expanded_event (_tmp20_, _tmp21_);
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp22_ = identity_manager_view_selection_in_progress (self);
#line 324 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp22_) {
#line 2045 "moonshot-identity-management-view.c"
		GtkButton* _tmp23_ = NULL;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = self->priv->send_button;
#line 325 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, TRUE);
#line 2051 "moonshot-identity-management-view.c"
	}
}


static void identity_manager_view_widget_unselected_cb (IdentityManagerView* self, IdCardWidget* id_card_widget) {
	MoonshotLogger* _tmp0_ = NULL;
	IdCardWidget* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	CustomVBox* _tmp11_ = NULL;
	IdCardWidget* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 328 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card_widget != NULL);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card_widget;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card_widget_get_id_card (_tmp1_);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = id_card_get_display_name (_tmp3_);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _tmp4_;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = string_to_string (_tmp5_);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = g_strconcat ("widget_unselected_cb: id_card_widget.id_card.display_name='", _tmp6_, "'", NULL);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = _tmp7_;
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, _tmp8_, NULL);
#line 330 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp8_);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->selected_card);
#line 332 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->selected_card = NULL;
#line 333 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->remove_button;
#line 333 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = self->priv->edit_button;
#line 334 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = self->priv->custom_vbox;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = id_card_widget;
#line 335 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_receive_collapsed_event (_tmp11_, _tmp12_);
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = self->priv->send_button;
#line 337 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, FALSE);
#line 2119 "moonshot-identity-management-view.c"
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (self) {
#line 2127 "moonshot-identity-management-view.c"
		gchar* _tmp0_ = NULL;
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 2135 "moonshot-identity-management-view.c"
	} else {
		gchar* _tmp1_ = NULL;
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 2144 "moonshot-identity-management-view.c"
	}
}


gboolean identity_manager_view_add_identity (IdentityManagerView* self, IdCard* id_card, gboolean force_flat_file_store, GeeArrayList** old_duplicates) {
	GeeArrayList* _vala_old_duplicates = NULL;
	gboolean result = FALSE;
	GtkMessageDialog* dialog = NULL;
	IdCard* prev_id = NULL;
	IdentityManagerModel* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	IdCard* _tmp7_ = NULL;
	MoonshotLogger* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	IdCard* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	IdCard* _tmp20_ = NULL;
	gint ret = 0;
	GtkMessageDialog* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	GtkMessageDialog* _tmp59_ = NULL;
	gint _tmp60_ = 0;
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (id_card != NULL, FALSE);
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->identities_manager;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card_get_nai (_tmp1_);
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = force_flat_file_store;
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = identity_manager_model_find_id_card (_tmp0_, _tmp3_, _tmp4_);
#line 350 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	prev_id = _tmp5_;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = prev_id;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp7_ != NULL) {
#line 2199 "moonshot-identity-management-view.c"
		IdCard* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = prev_id;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = id_card_get_display_name (_tmp8_);
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = _tmp9_;
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = _tmp10_;
#line 2211 "moonshot-identity-management-view.c"
	} else {
#line 352 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = "null";
#line 2215 "moonshot-identity-management-view.c"
	}
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = identity_manager_view_logger;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = force_flat_file_store;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = bool_to_string (_tmp12_);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = _tmp13_;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = id_card;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = id_card_get_display_name (_tmp15_);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = _tmp16_;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = g_strdup_printf ("add_identity(flat=%s, card='%s'): find_id_card returned %s", _tmp14_, _tmp17_, _tmp6_);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp19_ = _tmp18_;
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp11_, _tmp19_, NULL);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp19_);
#line 351 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp14_);
#line 353 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp20_ = prev_id;
#line 353 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp20_ != NULL) {
#line 2245 "moonshot-identity-management-view.c"
		gint flags = 0;
		IdCard* _tmp21_ = NULL;
		IdCard* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		MoonshotLogger* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = prev_id;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = id_card;
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = id_card_Compare (_tmp21_, _tmp22_);
#line 354 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		flags = _tmp23_;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = identity_manager_view_logger;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp25_ = flags;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp26_ = g_strdup_printf ("%i", _tmp25_);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp27_ = _tmp26_;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp28_ = g_strconcat ("add_identity: compare returned ", _tmp27_, NULL);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp29_ = _tmp28_;
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		moonshot_logger_trace (_tmp24_, _tmp29_, NULL);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp29_);
#line 355 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp27_);
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp30_ = flags;
#line 356 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp30_ == 0) {
#line 357 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if ((&_vala_old_duplicates) != NULL) {
#line 2289 "moonshot-identity-management-view.c"
				GeeArrayList* _tmp31_ = NULL;
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp31_ = gee_array_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (_vala_old_duplicates);
#line 358 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_vala_old_duplicates = _tmp31_;
#line 2297 "moonshot-identity-management-view.c"
			}
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			result = FALSE;
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (prev_id);
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (dialog);
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if (old_duplicates) {
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				*old_duplicates = _vala_old_duplicates;
#line 2309 "moonshot-identity-management-view.c"
			} else {
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (_vala_old_duplicates);
#line 2313 "moonshot-identity-management-view.c"
			}
#line 361 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			return result;
#line 2317 "moonshot-identity-management-view.c"
		} else {
			gint _tmp32_ = 0;
#line 362 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp32_ = flags;
#line 362 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			if ((_tmp32_ & (1 << ID_CARD_DIFF_FLAGS_DISPLAY_NAME)) != 0) {
#line 2324 "moonshot-identity-management-view.c"
				const gchar* _tmp33_ = NULL;
				IdCard* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				IdCard* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				IdCard* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				GtkMessageDialog* _tmp43_ = NULL;
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp33_ = _ ("Would you like to replace ID Card '%s' using nai '%s' with the new ID " \
"Card '%s'?");
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp34_ = prev_id;
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp35_ = id_card_get_display_name (_tmp34_);
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp36_ = _tmp35_;
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp37_ = prev_id;
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp38_ = id_card_get_nai (_tmp37_);
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp39_ = _tmp38_;
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp40_ = id_card;
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp41_ = id_card_get_display_name (_tmp40_);
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp42_ = _tmp41_;
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp43_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp33_, _tmp36_, _tmp39_, _tmp42_);
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_object_ref_sink (_tmp43_);
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (dialog);
#line 363 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				dialog = _tmp43_;
#line 2364 "moonshot-identity-management-view.c"
			} else {
				const gchar* _tmp44_ = NULL;
				IdCard* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				IdCard* _tmp48_ = NULL;
				const gchar* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				GtkMessageDialog* _tmp51_ = NULL;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp44_ = _ ("Would you like to update ID Card '%s' using nai '%s'?");
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp45_ = id_card;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp46_ = id_card_get_display_name (_tmp45_);
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp47_ = _tmp46_;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp48_ = id_card;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp49_ = id_card_get_nai (_tmp48_);
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp50_ = _tmp49_;
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp51_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp44_, _tmp47_, _tmp50_);
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				g_object_ref_sink (_tmp51_);
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (dialog);
#line 372 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				dialog = _tmp51_;
#line 2396 "moonshot-identity-management-view.c"
			}
		}
	} else {
		const gchar* _tmp52_ = NULL;
		IdCard* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		GtkMessageDialog* _tmp56_ = NULL;
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp52_ = _ ("Would you like to add '%s' ID Card to the ID Card Organizer?");
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp53_ = id_card;
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp54_ = id_card_get_display_name (_tmp53_);
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp55_ = _tmp54_;
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp56_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO, _tmp52_, _tmp55_);
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_object_ref_sink (_tmp56_);
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (dialog);
#line 381 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		dialog = _tmp56_;
#line 2421 "moonshot-identity-management-view.c"
	}
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp57_ = dialog;
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp58_ = gtk_dialog_run ((GtkDialog*) _tmp57_);
#line 388 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	ret = _tmp58_;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp59_ = dialog;
#line 389 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _tmp59_);
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp60_ = ret;
#line 392 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp60_ == ((gint) GTK_RESPONSE_YES)) {
#line 2437 "moonshot-identity-management-view.c"
		IdentityManagerModel* _tmp61_ = NULL;
		IdCard* _tmp62_ = NULL;
		gboolean _tmp63_ = FALSE;
		GeeArrayList* _tmp64_ = NULL;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp61_ = self->identities_manager;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp62_ = id_card;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp63_ = force_flat_file_store;
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_model_add_card (_tmp61_, _tmp62_, _tmp63_, &_tmp64_);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 393 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_vala_old_duplicates = _tmp64_;
#line 394 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = TRUE;
#line 394 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (prev_id);
#line 394 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (dialog);
#line 394 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (old_duplicates) {
#line 394 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			*old_duplicates = _vala_old_duplicates;
#line 2464 "moonshot-identity-management-view.c"
		} else {
#line 394 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_vala_old_duplicates);
#line 2468 "moonshot-identity-management-view.c"
		}
#line 394 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 2472 "moonshot-identity-management-view.c"
	} else {
#line 397 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if ((&_vala_old_duplicates) != NULL) {
#line 2476 "moonshot-identity-management-view.c"
			GeeArrayList* _tmp65_ = NULL;
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp65_ = gee_array_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_vala_old_duplicates);
#line 398 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_vala_old_duplicates = _tmp65_;
#line 2484 "moonshot-identity-management-view.c"
		}
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		result = FALSE;
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (prev_id);
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (dialog);
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (old_duplicates) {
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			*old_duplicates = _vala_old_duplicates;
#line 2496 "moonshot-identity-management-view.c"
		} else {
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_vala_old_duplicates);
#line 2500 "moonshot-identity-management-view.c"
		}
#line 400 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return result;
#line 2504 "moonshot-identity-management-view.c"
	}
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (prev_id);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (old_duplicates) {
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*old_duplicates = _vala_old_duplicates;
#line 2514 "moonshot-identity-management-view.c"
	} else {
#line 340 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_vala_old_duplicates);
#line 2518 "moonshot-identity-management-view.c"
	}
}


static void identity_manager_view_add_identity_cb (IdentityManagerView* self) {
	IdentityDialog* dialog = NULL;
	IdentityDialog* _tmp0_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	IdentityDialog* _tmp12_ = NULL;
#line 404 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 406 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_dialog_new (self);
#line 406 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp0_);
#line 406 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	dialog = _tmp0_;
#line 407 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_result_ = (gint) GTK_RESPONSE_CANCEL;
#line 408 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	while (TRUE) {
#line 2541 "moonshot-identity-management-view.c"
		IdentityDialog* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		IdentityDialog* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 408 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp1_ = dialog;
#line 408 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp2_ = _tmp1_->complete;
#line 408 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (!(!_tmp2_)) {
#line 408 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2554 "moonshot-identity-management-view.c"
		}
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = dialog;
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = gtk_dialog_run ((GtkDialog*) _tmp3_);
#line 409 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_result_ = _tmp4_;
#line 2562 "moonshot-identity-management-view.c"
	}
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _result_;
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	switch (_tmp5_) {
#line 411 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		case GTK_RESPONSE_OK:
#line 2570 "moonshot-identity-management-view.c"
		{
			IdentityManagerModel* _tmp6_ = NULL;
			IdentityDialog* _tmp7_ = NULL;
			IdCard* _tmp8_ = NULL;
			IdCard* _tmp9_ = NULL;
			IdCard* _tmp10_ = NULL;
			IdCard* _tmp11_ = NULL;
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp6_ = self->identities_manager;
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp7_ = dialog;
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp8_ = id_card_new ();
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp9_ = _tmp8_;
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp10_ = identity_manager_view_update_id_card_data (self, _tmp7_, _tmp9_);
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp11_ = _tmp10_;
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			identity_manager_model_add_card (_tmp6_, _tmp11_, FALSE, NULL);
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp11_);
#line 413 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp9_);
#line 414 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2598 "moonshot-identity-management-view.c"
		}
		default:
		{
#line 416 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2604 "moonshot-identity-management-view.c"
		}
	}
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = dialog;
#line 418 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _tmp12_);
#line 404 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 2613 "moonshot-identity-management-view.c"
}


static void identity_manager_view_edit_identity_cb (IdentityManagerView* self, IdCard* card) {
	IdentityDialog* dialog = NULL;
	IdCard* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	IdentityDialog* _tmp2_ = NULL;
	gint _result_ = 0;
	gint _tmp7_ = 0;
	IdentityDialog* _tmp15_ = NULL;
#line 421 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 421 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (card != NULL);
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = card;
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _ ("Edit Identity");
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = identity_dialog_new_with_idcard (_tmp0_, _tmp1_, self);
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp2_);
#line 423 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	dialog = _tmp2_;
#line 424 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_result_ = (gint) GTK_RESPONSE_CANCEL;
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	while (TRUE) {
#line 2643 "moonshot-identity-management-view.c"
		IdentityDialog* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		IdentityDialog* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = dialog;
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp4_ = _tmp3_->complete;
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (!(!_tmp4_)) {
#line 425 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2656 "moonshot-identity-management-view.c"
		}
#line 426 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = dialog;
#line 426 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = gtk_dialog_run ((GtkDialog*) _tmp5_);
#line 426 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_result_ = _tmp6_;
#line 2664 "moonshot-identity-management-view.c"
	}
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = _result_;
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	switch (_tmp7_) {
#line 428 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		case GTK_RESPONSE_OK:
#line 2672 "moonshot-identity-management-view.c"
		{
			IdentityManagerModel* _tmp8_ = NULL;
			IdentityDialog* _tmp9_ = NULL;
			IdCard* _tmp10_ = NULL;
			IdCard* _tmp11_ = NULL;
			IdCard* _tmp12_ = NULL;
			IdCard* _tmp13_ = NULL;
			IdCard* _tmp14_ = NULL;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp8_ = self->identities_manager;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp9_ = dialog;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp10_ = card;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp11_ = identity_manager_view_update_id_card_data (self, _tmp9_, _tmp10_);
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp12_ = _tmp11_;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp13_ = identity_manager_model_update_card (_tmp8_, _tmp12_);
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp14_ = _tmp13_;
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp14_);
#line 430 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (_tmp12_);
#line 433 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			identity_manager_view_report_duplicate_nais (self);
#line 434 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2703 "moonshot-identity-management-view.c"
		}
		default:
		{
#line 436 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			break;
#line 2709 "moonshot-identity-management-view.c"
		}
	}
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = dialog;
#line 438 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _tmp15_);
#line 421 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 2718 "moonshot-identity-management-view.c"
}


static void identity_manager_view_remove_identity (IdentityManagerView* self, IdCard* id_card) {
	MoonshotLogger* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	IdentityManagerModel* _tmp7_ = NULL;
	IdCard* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	GtkButton* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 441 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card != NULL);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = id_card;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = id_card_get_display_name (_tmp1_);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = string_to_string (_tmp3_);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = g_strconcat ("remove_identity: id_card.display_name='", _tmp4_, "'", NULL);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = _tmp5_;
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, _tmp6_, NULL);
#line 443 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp6_);
#line 445 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->selected_card);
#line 445 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->selected_card = NULL;
#line 446 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = self->identities_manager;
#line 446 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = id_card;
#line 446 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_model_remove_card (_tmp7_, _tmp8_);
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->edit_button;
#line 449 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
#line 450 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = self->priv->remove_button;
#line 450 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
#line 451 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = self->priv->send_button;
#line 451 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
#line 2779 "moonshot-identity-management-view.c"
}


static void identity_manager_view_redraw_id_card_widgets (IdentityManagerView* self) {
	GtkTreeIter iter = {0};
	IdCard* id_card = NULL;
	CustomVBox* _tmp0_ = NULL;
	GtkTreeModelFilter* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->custom_vbox;
#line 459 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	custom_vbox_clear (_tmp0_);
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->filter;
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp1_, &_tmp2_);
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	iter = _tmp2_;
#line 461 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp3_) {
#line 2804 "moonshot-identity-management-view.c"
		{
			gboolean _tmp4_ = FALSE;
#line 463 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp4_ = TRUE;
#line 463 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			while (TRUE) {
#line 2811 "moonshot-identity-management-view.c"
				GtkTreeModelFilter* _tmp7_ = NULL;
				GtkTreeIter _tmp8_ = {0};
				IdCard* _tmp9_ = NULL;
				IdCardWidget* _tmp10_ = NULL;
				IdCardWidget* _tmp11_ = NULL;
#line 463 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				if (!_tmp4_) {
#line 2819 "moonshot-identity-management-view.c"
					GtkTreeModelFilter* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp5_ = self->priv->filter;
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (!_tmp6_) {
#line 470 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						break;
#line 2830 "moonshot-identity-management-view.c"
					}
				}
#line 463 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp4_ = FALSE;
#line 465 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp7_ = self->priv->filter;
#line 465 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp8_ = iter;
#line 465 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, IDENTITY_MANAGER_VIEW_COLUMNS_IDCARD_COL, &id_card, -1);
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp9_ = id_card;
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp10_ = identity_manager_view_add_id_card_widget (self, _tmp9_);
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp11_ = _tmp10_;
#line 468 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (_tmp11_);
#line 2849 "moonshot-identity-management-view.c"
			}
		}
	}
#line 454 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (id_card);
#line 2855 "moonshot-identity-management-view.c"
}


static void identity_manager_view_remove_identity_cb (IdentityManagerView* self, IdCard* id_card) {
	gboolean remove = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
#line 474 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 474 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id_card != NULL);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = _ ("You are about to remove the identity '%s'.");
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = g_strconcat ("<span font-weight='heavy'>", _tmp0_, NULL);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _tmp1_;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = g_strconcat (_tmp2_, "</span>", NULL);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = _tmp3_;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = id_card;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = id_card_get_display_name (_tmp5_);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = _tmp6_;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = g_markup_printf_escaped (_tmp4_, _tmp7_);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = _tmp8_;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = g_strconcat (_tmp9_, "\n\n", NULL);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = _tmp10_;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _ ("Are you sure you want to do this?");
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = _tmp13_;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = warning_dialog_confirm ((GtkWindow*) self, _tmp14_, "delete_idcard");
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = _tmp15_;
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp14_);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp11_);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp9_);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp4_);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp2_);
#line 476 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	remove = _tmp16_;
#line 482 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = remove;
#line 482 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp17_) {
#line 2933 "moonshot-identity-management-view.c"
		IdCard* _tmp18_ = NULL;
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp18_ = id_card;
#line 483 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_remove_identity (self, _tmp18_);
#line 2939 "moonshot-identity-management-view.c"
	}
}


static void identity_manager_view_set_prompting_service (IdentityManagerView* self, const gchar* service) {
	GtkLabel* prompting_service = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* selection_prompt = NULL;
	const gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkVBox* _tmp8_ = NULL;
	GtkVBox* _tmp9_ = NULL;
	GtkVBox* _tmp10_ = NULL;
#line 486 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 486 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (service != NULL);
#line 488 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_clear_selection_prompts (self);
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = _ ("Identity requested for service:\n%s");
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = service;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp4_);
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _tmp4_;
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp3_);
#line 490 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	prompting_service = _tmp5_;
#line 491 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_label_set_line_wrap (prompting_service, TRUE);
#line 494 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) prompting_service, (gfloat) 0, (gfloat) 0.5);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = _ ("Select your identity:");
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp7_);
#line 496 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	selection_prompt = _tmp7_;
#line 497 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) selection_prompt, (gfloat) 0, (gfloat) 1);
#line 499 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = self->priv->service_prompt_vbox;
#line 499 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp8_, (GtkWidget*) prompting_service, FALSE, FALSE, (guint) 12);
#line 500 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = self->priv->service_prompt_vbox;
#line 500 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp9_, (GtkWidget*) selection_prompt, FALSE, FALSE, (guint) 2);
#line 501 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = self->priv->service_prompt_vbox;
#line 501 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp10_);
#line 486 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (selection_prompt);
#line 486 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (prompting_service);
#line 3012 "moonshot-identity-management-view.c"
}


static void identity_manager_view_clear_selection_prompts (IdentityManagerView* self) {
	GList* list = NULL;
	GtkVBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
#line 504 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 506 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->service_prompt_vbox;
#line 506 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
#line 506 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	list = _tmp1_;
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = list;
#line 3031 "moonshot-identity-management-view.c"
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		w_collection = _tmp2_;
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
#line 3039 "moonshot-identity-management-view.c"
			GtkWidget* _tmp3_ = NULL;
			GtkWidget* w = NULL;
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp3_ = _g_object_ref0 ((GtkWidget*) w_it->data);
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			w = _tmp3_;
#line 3046 "moonshot-identity-management-view.c"
			{
				GtkVBox* _tmp4_ = NULL;
				GtkWidget* _tmp5_ = NULL;
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp4_ = self->priv->service_prompt_vbox;
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp5_ = w;
#line 509 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				gtk_container_remove ((GtkContainer*) _tmp4_, _tmp5_);
#line 507 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_g_object_unref0 (w);
#line 3058 "moonshot-identity-management-view.c"
			}
		}
	}
#line 504 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_list_free0 (list);
#line 3064 "moonshot-identity-management-view.c"
}


void identity_manager_view_queue_identity_request (IdentityManagerView* self, IdentityRequest* request) {
	gboolean queue_was_empty = FALSE;
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_ = NULL;
	IdentityRequest* _tmp2_ = NULL;
	IdentityRequest* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 514 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 514 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (request != NULL);
#line 516 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_selection_in_progress (self);
#line 516 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	queue_was_empty = !_tmp0_;
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->request_queue;
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = request;
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 517 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_queue_push_tail (_tmp1_, _tmp3_);
#line 519 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = queue_was_empty;
#line 519 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp4_) {
#line 3095 "moonshot-identity-management-view.c"
		IdentityRequest* _tmp5_ = NULL;
		GSList* _tmp6_ = NULL;
		GtkTreeModelFilter* _tmp7_ = NULL;
		IdentityRequest* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkCheckButton* _tmp10_ = NULL;
		CustomVBox* _tmp11_ = NULL;
		IdCard* _tmp12_ = NULL;
		IdCardWidget* _tmp13_ = NULL;
		IdCardWidget* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 521 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = request;
#line 521 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = _tmp5_->candidates;
#line 521 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->candidates = _tmp6_;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = self->priv->filter;
#line 522 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_tree_model_filter_refilter (_tmp7_);
#line 523 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_redraw_id_card_widgets (self);
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = request;
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = _tmp8_->service;
#line 524 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_set_prompting_service (self, _tmp9_);
#line 525 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = self->remember_identity_binding;
#line 525 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_widget_show ((GtkWidget*) _tmp10_);
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = self->priv->custom_vbox;
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = self->priv->selected_card;
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = custom_vbox_find_idcard_widget (_tmp11_, _tmp12_);
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = _tmp13_;
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp15_ = _tmp14_ != NULL;
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_tmp14_);
#line 527 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp15_) {
#line 3143 "moonshot-identity-management-view.c"
			GtkButton* _tmp16_ = NULL;
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp16_ = self->priv->send_button;
#line 529 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, TRUE);
#line 3149 "moonshot-identity-management-view.c"
		}
#line 532 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_make_visible (self);
#line 3153 "moonshot-identity-management-view.c"
	}
}


/** Makes the window visible, or at least, notifies the user that the window
     * wants to be visible.
     *
     * This differs from show() in that show() does not guarantee that the 
     * window will be moved to the foreground. Actually, neither does this
     * method, because the user's settings and window manager may affect the
     * behavior significantly.
     */
void identity_manager_view_make_visible (IdentityManagerView* self) {
#line 545 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 547 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_urgency_hint ((GtkWindow*) self, TRUE);
#line 548 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_present ((GtkWindow*) self);
#line 3173 "moonshot-identity-management-view.c"
}


IdCard* identity_manager_view_check_add_password (IdentityManagerView* self, IdCard* identity, IdentityRequest* request, IdentityManagerModel* model) {
	IdCard* result = NULL;
	MoonshotLogger* _tmp0_ = NULL;
	IdCard* retval = NULL;
	IdCard* _tmp1_ = NULL;
	IdCard* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	IdCard* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean idcard_has_pw = FALSE;
	gboolean _tmp10_ = FALSE;
	IdentityRequest* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean request_has_pw = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (identity != NULL, NULL);
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 551 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 553 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, "check_add_password", NULL);
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = identity;
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 554 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	retval = _tmp2_;
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = identity;
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = id_card_get_password (_tmp4_);
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = _tmp5_;
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp6_ != NULL) {
#line 3220 "moonshot-identity-management-view.c"
		IdCard* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = identity;
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = id_card_get_password (_tmp7_);
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = _tmp8_;
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = g_strcmp0 (_tmp9_, "") != 0;
#line 3232 "moonshot-identity-management-view.c"
	} else {
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp3_ = FALSE;
#line 3236 "moonshot-identity-management-view.c"
	}
#line 555 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	idcard_has_pw = _tmp3_;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = request;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = _tmp11_->password;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp12_ != NULL) {
#line 3246 "moonshot-identity-management-view.c"
		IdentityRequest* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = request;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = _tmp13_->password;
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = g_strcmp0 (_tmp14_, "") != 0;
#line 3255 "moonshot-identity-management-view.c"
	} else {
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = FALSE;
#line 3259 "moonshot-identity-management-view.c"
	}
#line 556 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	request_has_pw = _tmp10_;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = idcard_has_pw;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (!_tmp16_) {
#line 3267 "moonshot-identity-management-view.c"
		IdCard* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp17_ = identity;
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp18_ = id_card_is_no_identity (_tmp17_);
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp15_ = !_tmp18_;
#line 3276 "moonshot-identity-management-view.c"
	} else {
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp15_ = FALSE;
#line 3280 "moonshot-identity-management-view.c"
	}
#line 557 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp15_) {
#line 3284 "moonshot-identity-management-view.c"
		gboolean _tmp19_ = FALSE;
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = request_has_pw;
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp19_) {
#line 3290 "moonshot-identity-management-view.c"
			IdCard* _tmp20_ = NULL;
			IdentityRequest* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			IdentityManagerModel* _tmp23_ = NULL;
			IdCard* _tmp24_ = NULL;
			IdCard* _tmp25_ = NULL;
#line 559 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp20_ = identity;
#line 559 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp21_ = request;
#line 559 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp22_ = _tmp21_->password;
#line 559 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			id_card_set_password (_tmp20_, _tmp22_);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp23_ = model;
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp24_ = identity;
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp25_ = identity_manager_model_update_card (_tmp23_, _tmp24_);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (retval);
#line 560 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			retval = _tmp25_;
#line 3315 "moonshot-identity-management-view.c"
		} else {
			AddPasswordDialog* dialog = NULL;
			IdCard* _tmp26_ = NULL;
			IdentityRequest* _tmp27_ = NULL;
			AddPasswordDialog* _tmp28_ = NULL;
			gint _result_ = 0;
			AddPasswordDialog* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			AddPasswordDialog* _tmp48_ = NULL;
			AddPasswordDialog* _tmp49_ = NULL;
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp26_ = identity;
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp27_ = request;
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp28_ = add_password_dialog_new (_tmp26_, _tmp27_);
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			g_object_ref_sink (_tmp28_);
#line 562 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			dialog = _tmp28_;
#line 563 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp29_ = dialog;
#line 563 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp30_ = gtk_dialog_run ((GtkDialog*) _tmp29_);
#line 563 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_result_ = _tmp30_;
#line 565 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp31_ = _result_;
#line 565 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			switch (_tmp31_) {
#line 565 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				case GTK_RESPONSE_OK:
#line 3349 "moonshot-identity-management-view.c"
				{
					IdCard* _tmp32_ = NULL;
					AddPasswordDialog* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					AddPasswordDialog* _tmp36_ = NULL;
					IdCard* _tmp37_ = NULL;
					AddPasswordDialog* _tmp38_ = NULL;
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_ = FALSE;
					AddPasswordDialog* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
					gboolean _tmp43_ = FALSE;
					IdentityManagerModel* _tmp45_ = NULL;
					IdCard* _tmp46_ = NULL;
					IdCard* _tmp47_ = NULL;
#line 567 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp32_ = identity;
#line 567 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp33_ = dialog;
#line 567 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp34_ = add_password_dialog_get_password (_tmp33_);
#line 567 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp35_ = _tmp34_;
#line 567 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					id_card_set_password (_tmp32_, _tmp35_);
#line 570 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp36_ = dialog;
#line 570 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					add_password_dialog_clear_password (_tmp36_);
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp37_ = identity;
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp38_ = dialog;
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp39_ = add_password_dialog_get_remember (_tmp38_);
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp40_ = _tmp39_;
#line 571 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					id_card_set_store_password (_tmp37_, _tmp40_);
#line 572 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp41_ = dialog;
#line 572 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp42_ = add_password_dialog_get_remember (_tmp41_);
#line 572 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp43_ = _tmp42_;
#line 572 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp43_) {
#line 3398 "moonshot-identity-management-view.c"
						IdCard* _tmp44_ = NULL;
#line 573 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp44_ = identity;
#line 573 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						id_card_set_temporary (_tmp44_, FALSE);
#line 3404 "moonshot-identity-management-view.c"
					}
#line 574 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp45_ = model;
#line 574 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp46_ = identity;
#line 574 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp47_ = identity_manager_model_update_card (_tmp45_, _tmp46_);
#line 574 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_object_unref0 (retval);
#line 574 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					retval = _tmp47_;
#line 575 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					break;
#line 3418 "moonshot-identity-management-view.c"
				}
				default:
				{
#line 577 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					identity = NULL;
#line 578 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					break;
#line 3426 "moonshot-identity-management-view.c"
				}
			}
#line 581 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp48_ = dialog;
#line 581 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			add_password_dialog_clear_password (_tmp48_);
#line 582 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp49_ = dialog;
#line 582 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_object_destroy ((GtkObject*) _tmp49_);
#line 558 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (dialog);
#line 3439 "moonshot-identity-management-view.c"
		}
	}
#line 585 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = retval;
#line 585 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 3446 "moonshot-identity-management-view.c"
}


static void identity_manager_view_send_identity_cb (IdentityManagerView* self, IdCard* id) {
	gboolean _tmp0_ = FALSE;
	IdentityRequest* request = NULL;
	GQueue* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	IdCard* identity = NULL;
	IdCard* _tmp3_ = NULL;
	IdentityRequest* _tmp4_ = NULL;
	IdentityManagerModel* _tmp5_ = NULL;
	IdCard* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkTreeModelFilter* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	IdCard* _tmp20_ = NULL;
	IdentityRequest* _tmp26_ = NULL;
	IdCard* _tmp27_ = NULL;
	GtkCheckButton* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GtkCheckButton* _tmp31_ = NULL;
	GtkCheckButton* _tmp32_ = NULL;
#line 588 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 588 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (id != NULL);
#line 590 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_selection_in_progress (self);
#line 590 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (_tmp0_);
#line 592 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = self->priv->request_queue;
#line 592 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = g_queue_pop_head (_tmp1_);
#line 592 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	request = (IdentityRequest*) _tmp2_;
#line 593 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = id;
#line 593 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = request;
#line 593 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = self->identities_manager;
#line 593 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = identity_manager_view_check_add_password (self, _tmp3_, _tmp4_, _tmp5_);
#line 593 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity = _tmp6_;
#line 594 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = self->priv->send_button;
#line 594 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
#line 596 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->candidates = NULL;
#line 598 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = identity_manager_view_selection_in_progress (self);
#line 598 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (!_tmp8_) {
#line 3506 "moonshot-identity-management-view.c"
		IdentityManagerApp* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 600 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->candidates = NULL;
#line 601 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_clear_selection_prompts (self);
#line 602 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = self->parent_app;
#line 602 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = _tmp9_->explicitly_launched;
#line 602 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (!_tmp10_) {
#line 607 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_widget_hide ((GtkWidget*) self);
#line 3521 "moonshot-identity-management-view.c"
		}
	} else {
		IdentityRequest* next = NULL;
		GQueue* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		IdentityRequest* _tmp13_ = NULL;
		IdentityRequest* _tmp14_ = NULL;
		GSList* _tmp15_ = NULL;
		IdentityRequest* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 610 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = self->priv->request_queue;
#line 610 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = g_queue_peek_head (_tmp11_);
#line 610 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = _g_object_ref0 ((IdentityRequest*) _tmp12_);
#line 610 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		next = _tmp13_;
#line 611 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = next;
#line 611 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp15_ = _tmp14_->candidates;
#line 611 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->candidates = _tmp15_;
#line 612 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp16_ = next;
#line 612 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp17_ = _tmp16_->service;
#line 612 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		identity_manager_view_set_prompting_service (self, _tmp17_);
#line 598 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (next);
#line 3554 "moonshot-identity-management-view.c"
	}
#line 614 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = self->priv->filter;
#line 614 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_tree_model_filter_refilter (_tmp18_);
#line 615 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_redraw_id_card_widgets (self);
#line 617 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp20_ = identity;
#line 617 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp20_ != NULL) {
#line 3566 "moonshot-identity-management-view.c"
		IdCard* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 617 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = identity;
#line 617 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = id_card_is_no_identity (_tmp21_);
#line 617 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = !_tmp22_;
#line 3575 "moonshot-identity-management-view.c"
	} else {
#line 617 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = FALSE;
#line 3579 "moonshot-identity-management-view.c"
	}
#line 617 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp19_) {
#line 3583 "moonshot-identity-management-view.c"
		IdentityManagerApp* _tmp23_ = NULL;
		IdCard* _tmp24_ = NULL;
		IdCard* _tmp25_ = NULL;
#line 618 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = self->parent_app;
#line 618 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = identity;
#line 618 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp25_ = _g_object_ref0 (_tmp24_);
#line 618 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_tmp23_->default_id_card);
#line 618 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_->default_id_card = _tmp25_;
#line 3597 "moonshot-identity-management-view.c"
	}
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp26_ = request;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp27_ = identity;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp28_ = self->remember_identity_binding;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp29_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp28_);
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp30_ = _tmp29_;
#line 620 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_request_return_identity (_tmp26_, _tmp27_, _tmp30_);
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp31_ = self->remember_identity_binding;
#line 622 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp31_, TRUE);
#line 623 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp32_ = self->remember_identity_binding;
#line 623 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp32_);
#line 588 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (identity);
#line 588 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (request);
#line 3623 "moonshot-identity-management-view.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return _data3_;
#line 3632 "moonshot-identity-management-view.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 3641 "moonshot-identity-management-view.c"
		IdentityManagerView* self;
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self = _data3_->self;
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_data3_->about);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (self);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_slice_free (Block3Data, _data3_);
#line 3651 "moonshot-identity-management-view.c"
	}
}


static void __lambda6_ (Block3Data* _data3_, GtkDialog* a, gint b) {
	IdentityManagerView* self;
#line 675 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self = _data3_->self;
#line 675 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (a != NULL);
#line 675 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _data3_->about);
#line 3664 "moonshot-identity-management-view.c"
}


static void ___lambda6__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 675 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda6_ (self, _sender, response_id);
#line 3671 "moonshot-identity-management-view.c"
}


static void identity_manager_view_on_about_action (IdentityManagerView* self) {
	Block3Data* _data3_;
	gchar* copyright = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* license = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	GtkAboutDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_data3_->_ref_count_ = 1;
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_data3_->self = g_object_ref (self);
#line 628 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_LATEST_EDIT_YEAR;
#line 628 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = g_strdup_printf ("Copyright (c) 2011, %d JANET", _tmp0_);
#line 628 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	copyright = _tmp1_;
#line 630 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = identity_manager_view_LATEST_EDIT_YEAR;
#line 630 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = g_strdup_printf ("\n" \
"Copyright (c) 2011, %d JANET(UK)\n" \
"All rights reserved.\n" \
"\n" \
"Redistribution and use in source and binary forms, with or without\n" \
"modification, are permitted provided that the following conditions\n" \
"are met:\n" \
"\n" \
"1. Redistributions of source code must retain the above copyright\n" \
"   notice, this list of conditions and the following disclaimer.\n" \
"\n" \
"2. Redistributions in binary form must reproduce the above copyright\n" \
"   notice, this list of conditions and the following disclaimer in the" \
"\n" \
"   documentation and/or other materials provided with the distribution" \
".\n" \
"\n" \
"3. Neither the name of JANET(UK) nor the names of its contributors\n" \
"   may be used to endorse or promote products derived from this softwa" \
"re\n" \
"   without specific prior written permission.\n" \
"\n" \
"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \\" \
"\"AS IS\\\"\n" \
"AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, " \
"THE\n" \
"IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PUR" \
"POSE\n" \
"ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS" \
" BE LIABLE\n" \
"FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUEN" \
"TIAL\n" \
"DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOOD" \
"S\n" \
"OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n" \
"HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, ST" \
"RICT\n" \
"LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY " \
"WAY\n" \
"OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF" \
"\n" \
"SUCH DAMAGE.\n", _tmp2_);
#line 630 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	license = _tmp3_;
#line 663 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 663 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp4_);
#line 663 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_data3_->about = _tmp4_;
#line 665 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _ ("Moonshot project UI");
#line 665 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_about_dialog_set_comments (_data3_->about, _tmp5_);
#line 666 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_about_dialog_set_copyright (_data3_->about, copyright);
#line 667 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_about_dialog_set_website (_data3_->about, PACKAGE_URL);
#line 668 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = _ ("Visit the Moonshot project web site");
#line 668 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_about_dialog_set_website_label (_data3_->about, _tmp6_);
#line 671 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_about_dialog_set_version (_data3_->about, PACKAGE_VERSION);
#line 672 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_about_dialog_set_license (_data3_->about, license);
#line 673 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_modal ((GtkWindow*) _data3_->about, TRUE);
#line 674 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_window_set_transient_for ((GtkWindow*) _data3_->about, (GtkWindow*) self);
#line 675 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_data ((GtkDialog*) _data3_->about, "response", (GCallback) ___lambda6__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 676 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	set_bg_color ((GtkWidget*) _data3_->about);
#line 678 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_dialog_run ((GtkDialog*) _data3_->about);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (license);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (copyright);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	block3_data_unref (_data3_);
#line 626 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_data3_ = NULL;
#line 3746 "moonshot-identity-management-view.c"
}


static void _vala_array_add1 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if ((*length) == (*size)) {
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*array = g_renew (GtkActionEntry, *array, *size);
#line 3757 "moonshot-identity-management-view.c"
	}
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(*array)[(*length)++] = *value;
#line 3761 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_on_about_action_gtk_action_callback (GtkAction* action, gpointer self) {
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_on_about_action ((IdentityManagerView*) self);
#line 3768 "moonshot-identity-management-view.c"
}


static void _vala_array_add2 (GtkActionEntry** array, int* length, int* size, const GtkActionEntry* value) {
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if ((*length) == (*size)) {
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*array = g_renew (GtkActionEntry, *array, *size);
#line 3779 "moonshot-identity-management-view.c"
	}
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	(*array)[(*length)++] = *value;
#line 3783 "moonshot-identity-management-view.c"
}


static GtkActionEntry* identity_manager_view_create_actions (IdentityManagerView* self, int* result_length1) {
	GtkActionEntry* result = NULL;
	GtkActionEntry* actions = NULL;
	GtkActionEntry* _tmp0_ = NULL;
	gint actions_length1 = 0;
	gint _actions_size_ = 0;
	GtkActionEntry helpmenu = {0};
	GtkActionEntry _tmp1_ = {0};
	GtkActionEntry _tmp2_ = {0};
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkActionEntry* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GtkActionEntry _tmp6_ = {0};
	GtkActionEntry about = {0};
	GtkActionEntry _tmp7_ = {0};
	GtkActionEntry _tmp8_ = {0};
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkActionEntry* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GtkActionEntry _tmp12_ = {0};
	GtkActionEntry* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
#line 681 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 682 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = g_new0 (GtkActionEntry, 0);
#line 682 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	actions = _tmp0_;
#line 682 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	actions_length1 = 0;
#line 682 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_actions_size_ = actions_length1;
#line 684 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.name = "HelpMenuAction";
#line 684 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.stock_id = NULL;
#line 684 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.label = "_Help";
#line 684 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.accelerator = NULL;
#line 684 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.tooltip = NULL;
#line 684 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_.callback = (GCallback) NULL;
#line 684 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	helpmenu = _tmp1_;
#line 690 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = helpmenu;
#line 690 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_.label;
#line 690 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = g_dgettext (NULL, _tmp3_);
#line 690 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	helpmenu.label = _tmp4_;
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = actions;
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5__length1 = actions_length1;
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = helpmenu;
#line 691 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_vala_array_add1 (&actions, &actions_length1, &_actions_size_, &_tmp6_);
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.name = "AboutAction";
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.stock_id = GTK_STOCK_ABOUT;
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.label = "About";
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.accelerator = NULL;
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.tooltip = "About this application";
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_.callback = (GCallback) _identity_manager_view_on_about_action_gtk_action_callback;
#line 693 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	about = _tmp7_;
#line 704 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = about;
#line 704 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = _tmp8_.label;
#line 704 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = g_dgettext (NULL, _tmp9_);
#line 704 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	about.label = _tmp10_;
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = actions;
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11__length1 = actions_length1;
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = about;
#line 705 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_vala_array_add2 (&actions, &actions_length1, &_actions_size_, &_tmp12_);
#line 707 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = actions;
#line 707 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13__length1 = actions_length1;
#line 707 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (result_length1) {
#line 707 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		*result_length1 = _tmp13__length1;
#line 3889 "moonshot-identity-management-view.c"
	}
#line 707 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = _tmp13_;
#line 707 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 3895 "moonshot-identity-management-view.c"
}


static void identity_manager_view_create_ui_manager (IdentityManagerView* self) {
	GtkActionGroup* action_group = NULL;
	GtkActionGroup* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkActionEntry* _tmp2_ = NULL;
	GtkActionEntry* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GtkUIManager* _tmp4_ = NULL;
	GtkUIManager* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
#line 711 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 713 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = gtk_action_group_new ("GeneralActionGroup");
#line 713 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	action_group = _tmp0_;
#line 714 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = identity_manager_view_create_actions (self, &_tmp1_);
#line 714 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 714 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3__length1 = _tmp1_;
#line 714 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_action_group_add_actions (action_group, _tmp3_, _tmp1_, self);
#line 714 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 715 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->ui_manager;
#line 715 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_ui_manager_insert_action_group (_tmp4_, action_group, 0);
#line 3929 "moonshot-identity-management-view.c"
	{
		GtkUIManager* _tmp5_ = NULL;
#line 718 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = self->priv->ui_manager;
#line 718 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_ui_manager_add_ui_from_string (_tmp5_, IDENTITY_MANAGER_VIEW_menu_layout, (gssize) -1, &_inner_error_);
#line 718 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3938 "moonshot-identity-management-view.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		MoonshotLogger* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		e = _inner_error_;
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_inner_error_ = NULL;
#line 722 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = stderr;
#line 722 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = e;
#line 722 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = _tmp7_->message;
#line 722 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 723 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = identity_manager_view_logger;
#line 723 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = e;
#line 723 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = _tmp10_->message;
#line 723 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = g_strconcat ("create_ui_manager: Caught error: ", _tmp11_, NULL);
#line 723 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = _tmp12_;
#line 723 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		moonshot_logger_error (_tmp9_, _tmp13_, NULL);
#line 723 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp13_);
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_error_free0 (e);
#line 3982 "moonshot-identity-management-view.c"
	}
	__finally5:
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (action_group);
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		g_clear_error (&_inner_error_);
#line 716 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		return;
#line 3995 "moonshot-identity-management-view.c"
	}
#line 725 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = self->priv->ui_manager;
#line 725 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_ui_manager_ensure_update (_tmp14_);
#line 711 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (action_group);
#line 4003 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_search_entry_text_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 762 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_search_entry_text_changed_cb ((IdentityManagerView*) self);
#line 4010 "moonshot-identity-management-view.c"
}


static gboolean _identity_manager_view_search_entry_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = identity_manager_view_search_entry_key_press_event_cb ((IdentityManagerView*) self, event);
#line 763 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 4019 "moonshot-identity-management-view.c"
}


static void __lambda7_ (IdentityManagerView* self, GtkButton* w) {
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (w != NULL);
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_add_identity_cb (self);
#line 4028 "moonshot-identity-management-view.c"
}


static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda7_ ((IdentityManagerView*) self, _sender);
#line 4035 "moonshot-identity-management-view.c"
}


static void __lambda13_ (IdentityManagerView* self, GtkButton* w) {
#line 805 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (w != NULL);
#line 805 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_import_identities_cb (self);
#line 4044 "moonshot-identity-management-view.c"
}


static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 805 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda13_ ((IdentityManagerView*) self, _sender);
#line 4051 "moonshot-identity-management-view.c"
}


static void __lambda14_ (IdentityManagerView* self, GtkButton* w) {
	IdCard* _tmp0_ = NULL;
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (w != NULL);
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->selected_card;
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_edit_identity_cb (self, _tmp0_);
#line 4063 "moonshot-identity-management-view.c"
}


static void ___lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda14_ ((IdentityManagerView*) self, _sender);
#line 4070 "moonshot-identity-management-view.c"
}


static void __lambda15_ (IdentityManagerView* self, GtkButton* w) {
	IdCard* _tmp0_ = NULL;
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (w != NULL);
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->selected_card;
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_remove_identity_cb (self, _tmp0_);
#line 4082 "moonshot-identity-management-view.c"
}


static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda15_ ((IdentityManagerView*) self, _sender);
#line 4089 "moonshot-identity-management-view.c"
}


static void __lambda16_ (IdentityManagerView* self, GtkButton* w) {
	IdCard* _tmp0_ = NULL;
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (w != NULL);
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->selected_card;
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_send_identity_cb (self, _tmp0_);
#line 4101 "moonshot-identity-management-view.c"
}


static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda16_ ((IdentityManagerView*) self, _sender);
#line 4108 "moonshot-identity-management-view.c"
}


static void identity_manager_view_build_ui (IdentityManagerView* self) {
	gint num_rows = 0;
	gint num_cols = 0;
	gint button_width = 0;
	GtkTable* top_table = NULL;
	gint _tmp0_ = 0;
	GtkTable* _tmp1_ = NULL;
	GtkTable* _tmp2_ = NULL;
	GtkAttachOptions fill_and_expand = 0;
	GtkAttachOptions fill = 0;
	gint row = 0;
	GtkVBox* _tmp3_ = NULL;
	GtkTable* _tmp4_ = NULL;
	GtkVBox* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkAttachOptions _tmp8_ = 0;
	GtkAttachOptions _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* search_tooltip_text = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkEntry* _tmp17_ = NULL;
	GdkPixbuf* _tmp18_ = NULL;
	GdkPixbuf* _tmp19_ = NULL;
	GtkEntry* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkEntry* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkEntry* _tmp24_ = NULL;
	GtkEntry* _tmp25_ = NULL;
	GtkEntry* _tmp26_ = NULL;
	GtkEntry* _tmp27_ = NULL;
	gchar* search_label_markup = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkLabel* full_search_label = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	GtkVBox* search_vbox = NULL;
	GtkVBox* _tmp37_ = NULL;
	GtkVBox* _tmp38_ = NULL;
	GtkEntry* _tmp39_ = NULL;
	GtkAlignment* search_spacer = NULL;
	GtkAlignment* _tmp40_ = NULL;
	GtkAlignment* _tmp41_ = NULL;
	GtkVBox* _tmp42_ = NULL;
	GtkAlignment* _tmp43_ = NULL;
	GtkVBox* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkTable* _tmp46_ = NULL;
	GtkVBox* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	GtkAttachOptions _tmp52_ = 0;
	GtkAttachOptions _tmp53_ = 0;
	gint _tmp54_ = 0;
	CustomVBox* _tmp55_ = NULL;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp56_ = NULL;
	GtkViewport* _tmp57_ = NULL;
	GtkViewport* _tmp58_ = NULL;
	GtkViewport* _tmp59_ = NULL;
	CustomVBox* _tmp60_ = NULL;
	GtkScrolledWindow* id_scrollwin = NULL;
	GtkScrolledWindow* _tmp61_ = NULL;
	GtkScrolledWindow* _tmp62_ = NULL;
	GtkScrolledWindow* _tmp63_ = NULL;
	GtkScrolledWindow* _tmp64_ = NULL;
	GtkViewport* _tmp65_ = NULL;
	GtkTable* _tmp66_ = NULL;
	GtkScrolledWindow* _tmp67_ = NULL;
	gint _tmp68_ = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	GtkAttachOptions _tmp71_ = 0;
	GtkAttachOptions _tmp72_ = 0;
	const gchar* _tmp73_ = NULL;
	GtkCheckButton* _tmp74_ = NULL;
	GtkCheckButton* _tmp75_ = NULL;
	GtkTable* _tmp76_ = NULL;
	GtkCheckButton* _tmp77_ = NULL;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	GtkAttachOptions _tmp81_ = 0;
	GtkAttachOptions _tmp82_ = 0;
	GtkButton* add_button = NULL;
	const gchar* _tmp83_ = NULL;
	GtkButton* _tmp84_ = NULL;
	GtkButton* _tmp85_ = NULL;
	GtkTable* _tmp86_ = NULL;
	GtkButton* _tmp87_ = NULL;
	GtkWidget* _tmp88_ = NULL;
	GtkWidget* _tmp89_ = NULL;
	gint _tmp90_ = 0;
	gint _tmp91_ = 0;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
	gint _tmp94_ = 0;
	GtkAttachOptions _tmp95_ = 0;
	GtkAttachOptions _tmp96_ = 0;
	gint _tmp97_ = 0;
	GtkButton* import_button = NULL;
	const gchar* _tmp98_ = NULL;
	GtkButton* _tmp99_ = NULL;
	GtkButton* _tmp100_ = NULL;
	GtkTable* _tmp101_ = NULL;
	GtkButton* _tmp102_ = NULL;
	GtkWidget* _tmp103_ = NULL;
	GtkWidget* _tmp104_ = NULL;
	gint _tmp105_ = 0;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	gint _tmp109_ = 0;
	GtkAttachOptions _tmp110_ = 0;
	GtkAttachOptions _tmp111_ = 0;
	gint _tmp112_ = 0;
	const gchar* _tmp113_ = NULL;
	GtkButton* _tmp114_ = NULL;
	GtkButton* _tmp115_ = NULL;
	GtkButton* _tmp116_ = NULL;
	GtkTable* _tmp117_ = NULL;
	GtkButton* _tmp118_ = NULL;
	GtkWidget* _tmp119_ = NULL;
	GtkWidget* _tmp120_ = NULL;
	gint _tmp121_ = 0;
	gint _tmp122_ = 0;
	gint _tmp123_ = 0;
	gint _tmp124_ = 0;
	gint _tmp125_ = 0;
	GtkAttachOptions _tmp126_ = 0;
	GtkAttachOptions _tmp127_ = 0;
	gint _tmp128_ = 0;
	const gchar* _tmp129_ = NULL;
	GtkButton* _tmp130_ = NULL;
	GtkButton* _tmp131_ = NULL;
	GtkButton* _tmp132_ = NULL;
	GtkTable* _tmp133_ = NULL;
	GtkButton* _tmp134_ = NULL;
	GtkWidget* _tmp135_ = NULL;
	GtkWidget* _tmp136_ = NULL;
	gint _tmp137_ = 0;
	gint _tmp138_ = 0;
	gint _tmp139_ = 0;
	gint _tmp140_ = 0;
	gint _tmp141_ = 0;
	GtkAttachOptions _tmp142_ = 0;
	GtkAttachOptions _tmp143_ = 0;
	gint _tmp144_ = 0;
	gint _tmp145_ = 0;
	const gchar* _tmp146_ = NULL;
	GtkButton* _tmp147_ = NULL;
	GtkButton* _tmp148_ = NULL;
	GtkButton* _tmp149_ = NULL;
	GtkTable* _tmp150_ = NULL;
	GtkButton* _tmp151_ = NULL;
	GtkWidget* _tmp152_ = NULL;
	GtkWidget* _tmp153_ = NULL;
	gint _tmp154_ = 0;
	gint _tmp155_ = 0;
	gint _tmp156_ = 0;
	gint _tmp157_ = 0;
	gint _tmp158_ = 0;
	GtkAttachOptions _tmp159_ = 0;
	GtkAttachOptions _tmp160_ = 0;
	gint _tmp161_ = 0;
	GtkVBox* main_vbox = NULL;
	GtkVBox* _tmp162_ = NULL;
	GtkWidget* menubar = NULL;
	GtkUIManager* _tmp163_ = NULL;
	GtkWidget* _tmp164_ = NULL;
	GtkWidget* _tmp165_ = NULL;
	GtkVBox* _tmp166_ = NULL;
	GtkWidget* _tmp167_ = NULL;
	GtkWidget* _tmp168_ = NULL;
	GtkVBox* _tmp169_ = NULL;
	GtkTable* _tmp170_ = NULL;
	GtkVBox* _tmp171_ = NULL;
	GtkVBox* _tmp172_ = NULL;
	gboolean _tmp173_ = FALSE;
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 730 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	set_bg_color ((GtkWidget*) self);
#line 732 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_create_ui_manager (self);
#line 734 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	num_rows = 18;
#line 735 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	num_cols = 8;
#line 736 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	button_width = 1;
#line 738 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = num_rows;
#line 738 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = (GtkTable*) gtk_table_new ((guint) _tmp0_, (guint) 10, FALSE);
#line 738 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp1_);
#line 738 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	top_table = _tmp1_;
#line 739 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = top_table;
#line 739 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp2_, (guint) 12);
#line 741 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	fill_and_expand = GTK_EXPAND | GTK_FILL;
#line 742 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	fill = GTK_FILL;
#line 743 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = 0;
#line 745 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 745 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp3_);
#line 745 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->service_prompt_vbox);
#line 745 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->service_prompt_vbox = _tmp3_;
#line 746 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = top_table;
#line 746 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = self->priv->service_prompt_vbox;
#line 746 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = row;
#line 746 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = row;
#line 746 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = fill_and_expand;
#line 746 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp9_ = fill_and_expand;
#line 746 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp4_, (GtkWidget*) _tmp5_, (guint) 0, (guint) 1, (guint) _tmp6_, (guint) (_tmp7_ + 1), _tmp8_, _tmp9_, (guint) 12, (guint) 0);
#line 747 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp10_ = row;
#line 747 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp10_ + 1;
#line 749 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp11_ = _ ("Search for an identity or service");
#line 749 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 749 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	search_tooltip_text = _tmp12_;
#line 750 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp13_ = (GtkEntry*) gtk_entry_new ();
#line 750 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp13_);
#line 750 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 750 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->search_entry = _tmp13_;
#line 752 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp14_ = self->priv->search_entry;
#line 752 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp15_ = _ ("Search entry");
#line 752 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp16_ = _ ("Search for a specific ID Card");
#line 752 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_set_atk_name_description (self, (GtkWidget*) _tmp14_, _tmp15_, _tmp16_);
#line 753 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp17_ = self->priv->search_entry;
#line 753 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp18_ = find_icon_sized ("edit-find", GTK_ICON_SIZE_MENU);
#line 753 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp19_ = _tmp18_;
#line 753 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_from_pixbuf (_tmp17_, GTK_ENTRY_ICON_SECONDARY, _tmp19_);
#line 753 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp19_);
#line 755 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp20_ = self->priv->search_entry;
#line 755 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp21_ = search_tooltip_text;
#line 755 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_tooltip_text (_tmp20_, GTK_ENTRY_ICON_SECONDARY, _tmp21_);
#line 758 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp22_ = self->priv->search_entry;
#line 758 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp23_ = search_tooltip_text;
#line 758 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _tmp23_);
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp24_ = self->priv->search_entry;
#line 760 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_icon_sensitive (_tmp24_, GTK_ENTRY_ICON_SECONDARY, FALSE);
#line 762 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp25_ = self->priv->search_entry;
#line 762 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object ((GObject*) _tmp25_, "notify::text", (GCallback) _identity_manager_view_search_entry_text_changed_cb_g_object_notify, self, 0);
#line 763 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp26_ = self->priv->search_entry;
#line 763 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp26_, "key-press-event", (GCallback) _identity_manager_view_search_entry_key_press_event_cb_gtk_widget_key_press_event, self, 0);
#line 764 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp27_ = self->priv->search_entry;
#line 764 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_entry_set_width_chars (_tmp27_, 24);
#line 766 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp28_ = search_tooltip_text;
#line 766 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp29_ = g_strconcat ("<small>", _tmp28_, NULL);
#line 766 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp30_ = _tmp29_;
#line 766 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp31_ = g_strconcat (_tmp30_, "</small>", NULL);
#line 766 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp32_ = _tmp31_;
#line 766 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp30_);
#line 766 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	search_label_markup = _tmp32_;
#line 767 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp33_ = (GtkLabel*) gtk_label_new (NULL);
#line 767 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp33_);
#line 767 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	full_search_label = _tmp33_;
#line 768 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp34_ = full_search_label;
#line 768 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp35_ = search_label_markup;
#line 768 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_label_set_markup (_tmp34_, _tmp35_);
#line 769 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp36_ = full_search_label;
#line 769 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp36_, (gfloat) 1, (gfloat) 0);
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp37_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp37_);
#line 771 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	search_vbox = _tmp37_;
#line 772 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp38_ = search_vbox;
#line 772 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp39_ = self->priv->search_entry;
#line 772 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp40_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, (gfloat) 0, (gfloat) 0, (gfloat) 0);
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp40_);
#line 773 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	search_spacer = _tmp40_;
#line 774 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp41_ = search_spacer;
#line 774 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp41_, 0, 2);
#line 775 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp42_ = search_vbox;
#line 775 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp43_ = search_spacer;
#line 775 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 0);
#line 776 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp44_ = search_vbox;
#line 776 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp45_ = full_search_label;
#line 776 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp44_, (GtkWidget*) _tmp45_, FALSE, FALSE, (guint) 0);
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp46_ = top_table;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp47_ = search_vbox;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp48_ = num_cols;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp49_ = button_width;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp50_ = row;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp51_ = row;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp52_ = fill_and_expand;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp53_ = fill;
#line 779 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp46_, (GtkWidget*) _tmp47_, (guint) 5, (guint) (_tmp48_ - _tmp49_), (guint) (_tmp50_ - 1), (guint) (_tmp51_ + 1), _tmp52_, _tmp53_, (guint) 0, (guint) 12);
#line 780 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp54_ = row;
#line 780 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp54_ + 1;
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp55_ = custom_vbox_new (self, FALSE, 2);
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp55_);
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->custom_vbox);
#line 782 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->custom_vbox = _tmp55_;
#line 784 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp56_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
#line 784 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp56_);
#line 784 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	viewport = _tmp56_;
#line 785 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp57_ = viewport;
#line 785 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp57_, (guint) 2);
#line 786 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp58_ = viewport;
#line 786 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_viewport_set_shadow_type (_tmp58_, GTK_SHADOW_NONE);
#line 787 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp59_ = viewport;
#line 787 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp60_ = self->priv->custom_vbox;
#line 787 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp60_);
#line 788 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp61_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 788 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp61_);
#line 788 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	id_scrollwin = _tmp61_;
#line 789 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp62_ = id_scrollwin;
#line 789 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_scrolled_window_set_policy (_tmp62_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
#line 790 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp63_ = id_scrollwin;
#line 790 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_scrolled_window_set_shadow_type (_tmp63_, GTK_SHADOW_IN);
#line 791 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp64_ = id_scrollwin;
#line 791 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp65_ = viewport;
#line 791 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_scrolled_window_add_with_viewport (_tmp64_, (GtkWidget*) _tmp65_);
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp66_ = top_table;
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp67_ = id_scrollwin;
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp68_ = num_cols;
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp69_ = row;
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp70_ = num_rows;
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp71_ = fill_and_expand;
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp72_ = fill_and_expand;
#line 792 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp66_, (GtkWidget*) _tmp67_, (guint) 0, (guint) (_tmp68_ - 1), (guint) _tmp69_, (guint) (_tmp70_ - 1), _tmp71_, _tmp72_, (guint) 6, (guint) 0);
#line 795 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp73_ = _ ("Remember my identity choice for this service");
#line 795 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp74_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp73_);
#line 795 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp74_);
#line 795 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->remember_identity_binding);
#line 795 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->remember_identity_binding = _tmp74_;
#line 796 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp75_ = self->remember_identity_binding;
#line 796 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp75_, TRUE);
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp76_ = top_table;
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp77_ = self->remember_identity_binding;
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp78_ = num_cols;
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp79_ = num_rows;
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp80_ = num_rows;
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp81_ = fill_and_expand;
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp82_ = fill_and_expand;
#line 797 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp76_, (GtkWidget*) _tmp77_, (guint) 0, (guint) (_tmp78_ / 2), (guint) (_tmp79_ - 1), (guint) _tmp80_, _tmp81_, _tmp82_, (guint) 3, (guint) 0);
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp83_ = _ ("Add");
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp84_ = (GtkButton*) gtk_button_new_with_label (_tmp83_);
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp84_);
#line 799 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	add_button = _tmp84_;
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp85_ = add_button;
#line 800 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp85_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp86_ = top_table;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp87_ = add_button;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp88_ = identity_manager_view_make_rigid (_tmp87_);
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp89_ = _tmp88_;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp90_ = num_cols;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp91_ = button_width;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp92_ = num_cols;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp93_ = row;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp94_ = row;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp95_ = fill;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp96_ = fill;
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp86_, _tmp89_, (guint) (_tmp90_ - _tmp91_), (guint) _tmp92_, (guint) _tmp93_, (guint) (_tmp94_ + 1), _tmp95_, _tmp96_, (guint) 0, (guint) 0);
#line 801 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp89_);
#line 802 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp97_ = row;
#line 802 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp97_ + 1;
#line 804 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp98_ = _ ("Import");
#line 804 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp99_ = (GtkButton*) gtk_button_new_with_label (_tmp98_);
#line 804 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp99_);
#line 804 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	import_button = _tmp99_;
#line 805 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp100_ = import_button;
#line 805 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp100_, "clicked", (GCallback) ___lambda13__gtk_button_clicked, self, 0);
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp101_ = top_table;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp102_ = import_button;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp103_ = identity_manager_view_make_rigid (_tmp102_);
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp104_ = _tmp103_;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp105_ = num_cols;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp106_ = button_width;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp107_ = num_cols;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp108_ = row;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp109_ = row;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp110_ = fill;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp111_ = fill;
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp101_, _tmp104_, (guint) (_tmp105_ - _tmp106_), (guint) _tmp107_, (guint) _tmp108_, (guint) (_tmp109_ + 1), _tmp110_, _tmp111_, (guint) 0, (guint) 0);
#line 806 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp104_);
#line 807 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp112_ = row;
#line 807 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp112_ + 1;
#line 809 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp113_ = _ ("Edit");
#line 809 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp114_ = (GtkButton*) gtk_button_new_with_label (_tmp113_);
#line 809 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp114_);
#line 809 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->edit_button);
#line 809 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->edit_button = _tmp114_;
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp115_ = self->priv->edit_button;
#line 810 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp115_, "clicked", (GCallback) ___lambda14__gtk_button_clicked, self, 0);
#line 811 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp116_ = self->priv->edit_button;
#line 811 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp116_, FALSE);
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp117_ = top_table;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp118_ = self->priv->edit_button;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp119_ = identity_manager_view_make_rigid (_tmp118_);
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp120_ = _tmp119_;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp121_ = num_cols;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp122_ = button_width;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp123_ = num_cols;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp124_ = row;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp125_ = row;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp126_ = fill;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp127_ = fill;
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp117_, _tmp120_, (guint) (_tmp121_ - _tmp122_), (guint) _tmp123_, (guint) _tmp124_, (guint) (_tmp125_ + 1), _tmp126_, _tmp127_, (guint) 0, (guint) 0);
#line 812 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp120_);
#line 813 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp128_ = row;
#line 813 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp128_ + 1;
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp129_ = _ ("Remove");
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp130_ = (GtkButton*) gtk_button_new_with_label (_tmp129_);
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp130_);
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->remove_button);
#line 815 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->remove_button = _tmp130_;
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp131_ = self->priv->remove_button;
#line 816 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp131_, "clicked", (GCallback) ___lambda15__gtk_button_clicked, self, 0);
#line 817 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp132_ = self->priv->remove_button;
#line 817 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp132_, FALSE);
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp133_ = top_table;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp134_ = self->priv->remove_button;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp135_ = identity_manager_view_make_rigid (_tmp134_);
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp136_ = _tmp135_;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp137_ = num_cols;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp138_ = button_width;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp139_ = num_cols;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp140_ = row;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp141_ = row;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp142_ = fill;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp143_ = fill;
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp133_, _tmp136_, (guint) (_tmp137_ - _tmp138_), (guint) _tmp139_, (guint) _tmp140_, (guint) (_tmp141_ + 1), _tmp142_, _tmp143_, (guint) 0, (guint) 0);
#line 818 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp136_);
#line 819 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp144_ = row;
#line 819 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp144_ + 1;
#line 822 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp145_ = row;
#line 822 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp145_ + 1;
#line 823 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp146_ = _ ("Send");
#line 823 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp147_ = (GtkButton*) gtk_button_new_with_label (_tmp146_);
#line 823 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp147_);
#line 823 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->send_button);
#line 823 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->send_button = _tmp147_;
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp148_ = self->priv->send_button;
#line 824 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp148_, "clicked", (GCallback) ___lambda16__gtk_button_clicked, self, 0);
#line 826 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp149_ = self->priv->send_button;
#line 826 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp149_, FALSE);
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp150_ = top_table;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp151_ = self->priv->send_button;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp152_ = identity_manager_view_make_rigid (_tmp151_);
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp153_ = _tmp152_;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp154_ = num_cols;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp155_ = button_width;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp156_ = num_cols;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp157_ = row;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp158_ = row;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp159_ = fill;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp160_ = fill;
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_table_attach (_tmp150_, _tmp153_, (guint) (_tmp154_ - _tmp155_), (guint) _tmp156_, (guint) _tmp157_, (guint) (_tmp158_ + 1), _tmp159_, _tmp160_, (guint) 0, (guint) 0);
#line 827 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (_tmp153_);
#line 828 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp161_ = row;
#line 828 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	row = _tmp161_ + 1;
#line 830 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp162_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 830 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp162_);
#line 830 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	main_vbox = _tmp162_;
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp163_ = self->priv->ui_manager;
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp164_ = gtk_ui_manager_get_widget (_tmp163_, "/MenuBar");
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp165_ = _g_object_ref0 (_tmp164_);
#line 844 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	menubar = _tmp165_;
#line 845 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp166_ = main_vbox;
#line 845 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp167_ = menubar;
#line 845 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp166_, _tmp167_, FALSE, FALSE, (guint) 0);
#line 846 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp168_ = menubar;
#line 846 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	set_bg_color (_tmp168_);
#line 848 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp169_ = main_vbox;
#line 848 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp170_ = top_table;
#line 848 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) _tmp169_, (GtkWidget*) _tmp170_, TRUE, TRUE, (guint) 6);
#line 850 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp171_ = main_vbox;
#line 850 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp171_);
#line 851 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp172_ = main_vbox;
#line 851 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp172_);
#line 853 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp173_ = identity_manager_view_selection_in_progress (self);
#line 853 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (!_tmp173_) {
#line 4875 "moonshot-identity-management-view.c"
		GtkCheckButton* _tmp174_ = NULL;
#line 854 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp174_ = self->remember_identity_binding;
#line 854 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp174_);
#line 4881 "moonshot-identity-management-view.c"
	}
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (menubar);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (main_vbox);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (import_button);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (add_button);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (id_scrollwin);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (viewport);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (search_spacer);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (search_vbox);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (full_search_label);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (search_label_markup);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (search_tooltip_text);
#line 728 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (top_table);
#line 4907 "moonshot-identity-management-view.c"
}


gboolean identity_manager_view_selection_in_progress (IdentityManagerView* self) {
	gboolean result = FALSE;
	GQueue* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 857 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 858 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->priv->request_queue;
#line 858 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = g_queue_is_empty (_tmp0_);
#line 858 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = !_tmp1_;
#line 858 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 4925 "moonshot-identity-management-view.c"
}


static void identity_manager_view_set_atk_name_description (IdentityManagerView* self, GtkWidget* widget, const gchar* name, const gchar* description) {
	AtkObject* atk_widget = NULL;
	GtkWidget* _tmp0_ = NULL;
	AtkObject* _tmp1_ = NULL;
	AtkObject* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (widget != NULL);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (name != NULL);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (description != NULL);
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = widget;
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = gtk_widget_get_accessible (_tmp0_);
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 863 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_widget = _tmp2_;
#line 865 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = name;
#line 865 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_object_set_name (atk_widget, _tmp3_);
#line 866 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = description;
#line 866 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	atk_object_set_description (atk_widget, _tmp4_);
#line 861 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (atk_widget);
#line 4962 "moonshot-identity-management-view.c"
}


static void __lambda17_ (IdentityManagerView* self) {
	MoonshotLogger* _tmp0_ = NULL;
#line 872 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 872 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, "Destroy event; calling Gtk.main_quit()", NULL);
#line 873 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_main_quit ();
#line 4974 "moonshot-identity-management-view.c"
}


static void ___lambda17__gtk_object_destroy (GtkObject* _sender, gpointer self) {
#line 871 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__lambda17_ ((IdentityManagerView*) self);
#line 4981 "moonshot-identity-management-view.c"
}


static void _identity_manager_view_on_card_list_changed_identity_manager_model_card_list_changed (IdentityManagerModel* _sender, gpointer self) {
#line 875 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_on_card_list_changed ((IdentityManagerView*) self);
#line 4988 "moonshot-identity-management-view.c"
}


static gboolean __lambda18_ (IdentityManagerView* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 876 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_confirm_quit (self);
#line 876 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = _tmp0_;
#line 876 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 5001 "moonshot-identity-management-view.c"
}


static gboolean ___lambda18__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = __lambda18_ ((IdentityManagerView*) self);
#line 876 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 5010 "moonshot-identity-management-view.c"
}


static void identity_manager_view_connect_signals (IdentityManagerView* self) {
	IdentityManagerModel* _tmp0_ = NULL;
#line 869 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 871 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object ((GtkObject*) self, "destroy", (GCallback) ___lambda17__gtk_object_destroy, self, 0);
#line 875 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = self->identities_manager;
#line 875 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object (_tmp0_, "card-list-changed", (GCallback) _identity_manager_view_on_card_list_changed_identity_manager_model_card_list_changed, self, 0);
#line 876 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda18__gtk_widget_delete_event, self, 0);
#line 5026 "moonshot-identity-management-view.c"
}


static gboolean identity_manager_view_confirm_quit (IdentityManagerView* self) {
	gboolean result = FALSE;
	MoonshotLogger* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 879 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = identity_manager_view_logger;
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = identity_manager_view_selection_in_progress (self);
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = bool_to_string (_tmp1_);
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = _tmp2_;
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = g_strconcat ("delete_event intercepted; selection_in_progress()=", _tmp3_, NULL);
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp5_ = _tmp4_;
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	moonshot_logger_trace (_tmp0_, _tmp5_, NULL);
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp5_);
#line 880 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (_tmp3_);
#line 882 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp6_ = identity_manager_view_selection_in_progress (self);
#line 882 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp6_) {
#line 5063 "moonshot-identity-management-view.c"
		gboolean _result_ = FALSE;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GQueue* _tmp12_ = NULL;
		gconstpointer _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp7_ = _ ("Do you wish to use the %s service?");
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp8_ = g_strconcat ("<span font-weight='heavy'>", _tmp7_, NULL);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = _tmp8_;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = g_strconcat (_tmp9_, "</span>", NULL);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = _tmp10_;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = self->priv->request_queue;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = g_queue_peek_head (_tmp12_);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = ((IdentityRequest*) _tmp13_)->service;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp15_ = g_markup_printf_escaped (_tmp11_, _tmp14_);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp16_ = _tmp15_;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp17_ = g_strconcat (_tmp16_, "\n\n", NULL);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp18_ = _tmp17_;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = _ ("Select Yes to select an ID for this service, or No to cancel");
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = _tmp20_;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = warning_dialog_confirm ((GtkWindow*) self, _tmp21_, "close_moonshot_window");
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = _tmp22_;
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp21_);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp18_);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp16_);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp11_);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp9_);
#line 883 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_result_ = _tmp23_;
#line 889 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = _result_;
#line 889 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp24_) {
#line 891 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			result = TRUE;
#line 891 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			return result;
#line 5137 "moonshot-identity-management-view.c"
		}
	}
#line 896 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = FALSE;
#line 896 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 5144 "moonshot-identity-management-view.c"
}


static GtkWidget* identity_manager_view_make_rigid (GtkButton* button) {
	GtkWidget* result = NULL;
	GtkVBox* fixed_height = NULL;
	GtkVBox* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
#line 899 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_val_if_fail (button != NULL, NULL);
#line 902 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 902 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp0_);
#line 902 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	fixed_height = _tmp0_;
#line 903 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = button;
#line 903 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_box_pack_start ((GtkBox*) fixed_height, (GtkWidget*) _tmp1_, FALSE, FALSE, (guint) 0);
#line 905 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	result = (GtkWidget*) fixed_height;
#line 905 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	return result;
#line 5169 "moonshot-identity-management-view.c"
}


static void identity_manager_view_import_identities_cb (IdentityManagerView* self) {
	GtkFileChooserDialog* dialog = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GtkFileChooserDialog* _tmp85_ = NULL;
#line 908 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_return_if_fail (self != NULL);
#line 909 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = _ ("Import File");
#line 909 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp1_ = _ ("Cancel");
#line 909 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp2_ = _ ("Open");
#line 909 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, _tmp1_, GTK_RESPONSE_CANCEL, _tmp2_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 909 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_object_ref_sink (_tmp3_);
#line 909 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	dialog = _tmp3_;
#line 916 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp4_ = self->priv->import_directory;
#line 916 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp4_ != NULL) {
#line 5201 "moonshot-identity-management-view.c"
		GtkFileChooserDialog* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 917 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp5_ = dialog;
#line 917 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp6_ = self->priv->import_directory;
#line 917 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp5_, _tmp6_);
#line 5210 "moonshot-identity-management-view.c"
	}
#line 920 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp7_ = dialog;
#line 920 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp8_ = gtk_dialog_run ((GtkDialog*) _tmp7_);
#line 920 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	if (_tmp8_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 5218 "moonshot-identity-management-view.c"
		gchar* filename = NULL;
		GtkFileChooserDialog* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gint import_count = 0;
		WebProvisioningParser* webp = NULL;
		const gchar* _tmp17_ = NULL;
		WebProvisioningParser* _tmp18_ = NULL;
		GtkFileChooserDialog* _tmp19_ = NULL;
		WebProvisioningParser* _tmp20_ = NULL;
		MoonshotLogger* _tmp21_ = NULL;
		WebProvisioningParser* _tmp22_ = NULL;
		IdCard** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		IdCard** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		WebProvisioningParser* _tmp29_ = NULL;
		IdCard** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		IdCard** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gint _tmp80_ = 0;
#line 923 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp9_ = dialog;
#line 923 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp10_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp9_);
#line 923 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		filename = _tmp10_;
#line 924 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp11_ = filename;
#line 924 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp12_ = g_file_new_for_path (_tmp11_);
#line 924 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		file = _tmp12_;
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp13_ = file;
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp14_ = g_file_get_parent (_tmp13_);
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp15_ = _tmp14_;
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp16_ = g_file_get_path (_tmp15_);
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (self->priv->import_directory);
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		self->priv->import_directory = _tmp16_;
#line 925 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (_tmp15_);
#line 927 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		import_count = 0;
#line 929 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp17_ = filename;
#line 929 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp18_ = web_provisioning_parser_new (_tmp17_);
#line 929 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		webp = _tmp18_;
#line 930 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp19_ = dialog;
#line 930 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		gtk_object_destroy ((GtkObject*) _tmp19_);
#line 931 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp20_ = webp;
#line 931 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		web_provisioning_parser_parse (_tmp20_);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp21_ = identity_manager_view_logger;
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp22_ = webp;
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp23_ = web_provisioning_parser_get_cards (_tmp22_, &_tmp23__length1);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24_ = _tmp23_;
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp24__length1 = _tmp23__length1;
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp25_ = g_strdup_printf ("%i", _tmp24__length1);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp26_ = _tmp25_;
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp27_ = g_strconcat ("import_identities_cb: Have ", _tmp26_, " IdCards", NULL);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp28_ = _tmp27_;
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		moonshot_logger_trace (_tmp21_, _tmp28_, NULL);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp28_);
#line 932 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (_tmp26_);
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp29_ = webp;
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp30_ = web_provisioning_parser_get_cards (_tmp29_, &_tmp30__length1);
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp31_ = _tmp30_;
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp31__length1 = _tmp30__length1;
#line 5325 "moonshot-identity-management-view.c"
		{
			IdCard** card_collection = NULL;
			gint card_collection_length1 = 0;
			gint _card_collection_size_ = 0;
			gint card_it = 0;
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			card_collection = _tmp31_;
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			card_collection_length1 = _tmp31__length1;
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			for (card_it = 0; card_it < _tmp31__length1; card_it = card_it + 1) {
#line 5337 "moonshot-identity-management-view.c"
				IdCard* _tmp32_ = NULL;
				IdCard* card = NULL;
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				_tmp32_ = _g_object_ref0 (card_collection[card_it]);
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
				card = _tmp32_;
#line 5344 "moonshot-identity-management-view.c"
				{
					IdCard* _tmp33_ = NULL;
					IdCard* _tmp35_ = NULL;
					TrustAnchor* _tmp36_ = NULL;
					TrustAnchor* _tmp37_ = NULL;
					gboolean _tmp38_ = FALSE;
					gboolean _result_ = FALSE;
					IdCard* _tmp61_ = NULL;
					gboolean _tmp62_ = FALSE;
					gboolean _tmp63_ = FALSE;
					gboolean _tmp64_ = FALSE;
#line 936 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp33_ = card;
#line 936 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp33_ == NULL) {
#line 5360 "moonshot-identity-management-view.c"
						MoonshotLogger* _tmp34_ = NULL;
#line 937 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp34_ = identity_manager_view_logger;
#line 937 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						moonshot_logger_trace (_tmp34_, "import_identities_cb: Skipping null IdCard", NULL);
#line 938 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_object_unref0 (card);
#line 938 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						continue;
#line 5370 "moonshot-identity-management-view.c"
					}
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp35_ = card;
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp36_ = id_card_get_trust_anchor (_tmp35_);
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp37_ = _tmp36_;
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp38_ = trust_anchor_is_empty (_tmp37_);
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (!_tmp38_) {
#line 5382 "moonshot-identity-management-view.c"
						gchar* ta_datetime_added = NULL;
						gchar* _tmp39_ = NULL;
						IdCard* _tmp40_ = NULL;
						TrustAnchor* _tmp41_ = NULL;
						TrustAnchor* _tmp42_ = NULL;
						const gchar* _tmp43_ = NULL;
						MoonshotLogger* _tmp44_ = NULL;
						IdCard* _tmp45_ = NULL;
						const gchar* _tmp46_ = NULL;
						const gchar* _tmp47_ = NULL;
						const gchar* _tmp48_ = NULL;
						IdCard* _tmp49_ = NULL;
						TrustAnchor* _tmp50_ = NULL;
						TrustAnchor* _tmp51_ = NULL;
						const gchar* _tmp52_ = NULL;
						const gchar* _tmp53_ = NULL;
						IdCard* _tmp54_ = NULL;
						TrustAnchor* _tmp55_ = NULL;
						TrustAnchor* _tmp56_ = NULL;
						const gchar* _tmp57_ = NULL;
						const gchar* _tmp58_ = NULL;
						gchar* _tmp59_ = NULL;
						gchar* _tmp60_ = NULL;
#line 942 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp39_ = trust_anchor_format_datetime_now ();
#line 942 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						ta_datetime_added = _tmp39_;
#line 943 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp40_ = card;
#line 943 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp41_ = id_card_get_trust_anchor (_tmp40_);
#line 943 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp42_ = _tmp41_;
#line 943 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp43_ = ta_datetime_added;
#line 943 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						trust_anchor_set_datetime_added (_tmp42_, _tmp43_);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp44_ = identity_manager_view_logger;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp45_ = card;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp46_ = id_card_get_display_name (_tmp45_);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp47_ = _tmp46_;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp48_ = ta_datetime_added;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp49_ = card;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp50_ = id_card_get_trust_anchor (_tmp49_);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp51_ = _tmp50_;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp52_ = trust_anchor_get_ca_cert (_tmp51_);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp53_ = _tmp52_;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp54_ = card;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp55_ = id_card_get_trust_anchor (_tmp54_);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp56_ = _tmp55_;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp57_ = trust_anchor_get_server_cert (_tmp56_);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp58_ = _tmp57_;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp59_ = g_strdup_printf ("import_identities_cb : Set ta_datetime_added for '%s' to '%s'; ca_cert" \
"='%s'; server_cert='%s'", _tmp47_, _tmp48_, _tmp53_, _tmp58_);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp60_ = _tmp59_;
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						moonshot_logger_trace (_tmp44_, _tmp60_, NULL);
#line 944 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (_tmp60_);
#line 941 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (ta_datetime_added);
#line 5460 "moonshot-identity-management-view.c"
					}
#line 949 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp61_ = card;
#line 949 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp62_ = self->priv->use_flat_file_store;
#line 949 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp63_ = identity_manager_view_add_identity (self, _tmp61_, _tmp62_, NULL);
#line 949 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_result_ = _tmp63_;
#line 950 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_tmp64_ = _result_;
#line 950 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					if (_tmp64_) {
#line 5474 "moonshot-identity-management-view.c"
						MoonshotLogger* _tmp65_ = NULL;
						IdCard* _tmp66_ = NULL;
						const gchar* _tmp67_ = NULL;
						const gchar* _tmp68_ = NULL;
						const gchar* _tmp69_ = NULL;
						gchar* _tmp70_ = NULL;
						gchar* _tmp71_ = NULL;
						gint _tmp72_ = 0;
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp65_ = identity_manager_view_logger;
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp66_ = card;
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp67_ = id_card_get_display_name (_tmp66_);
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp68_ = _tmp67_;
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp69_ = string_to_string (_tmp68_);
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp70_ = g_strconcat ("import_identities_cb: Added or updated '", _tmp69_, "'", NULL);
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp71_ = _tmp70_;
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						moonshot_logger_trace (_tmp65_, _tmp71_, NULL);
#line 951 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (_tmp71_);
#line 952 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp72_ = import_count;
#line 952 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						import_count = _tmp72_ + 1;
#line 5505 "moonshot-identity-management-view.c"
					} else {
						MoonshotLogger* _tmp73_ = NULL;
						IdCard* _tmp74_ = NULL;
						const gchar* _tmp75_ = NULL;
						const gchar* _tmp76_ = NULL;
						const gchar* _tmp77_ = NULL;
						gchar* _tmp78_ = NULL;
						gchar* _tmp79_ = NULL;
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp73_ = identity_manager_view_logger;
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp74_ = card;
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp75_ = id_card_get_display_name (_tmp74_);
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp76_ = _tmp75_;
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp77_ = string_to_string (_tmp76_);
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp78_ = g_strconcat ("import_identities_cb: Did not add or update '", _tmp77_, "'", NULL);
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_tmp79_ = _tmp78_;
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						moonshot_logger_trace (_tmp73_, _tmp79_, NULL);
#line 955 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
						_g_free0 (_tmp79_);
#line 5532 "moonshot-identity-management-view.c"
					}
#line 933 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
					_g_object_unref0 (card);
#line 5536 "moonshot-identity-management-view.c"
				}
			}
		}
#line 958 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_tmp80_ = import_count;
#line 958 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		if (_tmp80_ == 0) {
#line 5544 "moonshot-identity-management-view.c"
			GtkMessageDialog* msg_dialog = NULL;
			const gchar* _tmp81_ = NULL;
			GtkMessageDialog* _tmp82_ = NULL;
			GtkMessageDialog* _tmp83_ = NULL;
			GtkMessageDialog* _tmp84_ = NULL;
#line 959 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp81_ = _ ("Import completed. No identities were added or updated.");
#line 959 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp82_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", _tmp81_);
#line 959 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			g_object_ref_sink (_tmp82_);
#line 959 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			msg_dialog = _tmp82_;
#line 965 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp83_ = msg_dialog;
#line 965 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_dialog_run ((GtkDialog*) _tmp83_);
#line 966 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_tmp84_ = msg_dialog;
#line 966 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			gtk_object_destroy ((GtkObject*) _tmp84_);
#line 958 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
			_g_object_unref0 (msg_dialog);
#line 5568 "moonshot-identity-management-view.c"
		}
#line 920 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (webp);
#line 920 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_object_unref0 (file);
#line 920 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
		_g_free0 (filename);
#line 5576 "moonshot-identity-management-view.c"
	}
#line 969 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp85_ = dialog;
#line 969 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	gtk_object_destroy ((GtkObject*) _tmp85_);
#line 908 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (dialog);
#line 5584 "moonshot-identity-management-view.c"
}


static void identity_manager_view_class_init (IdentityManagerViewClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
	GdkColor _tmp1_ = {0};
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	g_type_class_add_private (klass, sizeof (IdentityManagerViewPrivate));
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	G_OBJECT_CLASS (klass)->finalize = identity_manager_view_finalize;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = get_logger ("IdentityManagerView");
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_logger = _tmp0_;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	make_color ((guint16) 65535, (guint16) 65535, (guint16) 65535, &_tmp1_);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	identity_manager_view_white = _tmp1_;
#line 5605 "moonshot-identity-management-view.c"
}


static void identity_manager_view_instance_init (IdentityManagerView * self) {
	GtkUIManager* _tmp0_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv = IDENTITY_MANAGER_VIEW_GET_PRIVATE (self);
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->use_flat_file_store = FALSE;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_tmp0_ = gtk_ui_manager_new ();
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->ui_manager = _tmp0_;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->remember_identity_binding = NULL;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->selected_card = NULL;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self->priv->import_directory = NULL;
#line 5625 "moonshot-identity-management-view.c"
}


static void identity_manager_view_finalize (GObject* obj) {
	IdentityManagerView * self;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_identity_manager_app_unref0 (self->parent_app);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->ui_manager);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->custom_vbox);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->service_prompt_vbox);
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->edit_button);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->remove_button);
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->send_button);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->filter);
#line 64 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->identities_manager);
#line 67 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	__g_queue_free__g_object_unref0_0 (self->priv->request_queue);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->remember_identity_binding);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_object_unref0 (self->priv->selected_card);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	_g_free0 (self->priv->import_directory);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-identity-management-view.vala"
	G_OBJECT_CLASS (identity_manager_view_parent_class)->finalize (obj);
#line 5663 "moonshot-identity-management-view.c"
}


GType identity_manager_view_get_type (void) {
	static volatile gsize identity_manager_view_type_id__volatile = 0;
	if (g_once_init_enter (&identity_manager_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdentityManagerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) identity_manager_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdentityManagerView), 0, (GInstanceInitFunc) identity_manager_view_instance_init, NULL };
		GType identity_manager_view_type_id;
		identity_manager_view_type_id = g_type_register_static (GTK_TYPE_WINDOW, "IdentityManagerView", &g_define_type_info, 0);
		g_once_init_leave (&identity_manager_view_type_id__volatile, identity_manager_view_type_id);
	}
	return identity_manager_view_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



