#!/usr/bin/perl -w

##############################################################################
#                                   MELTING                                  #
# This program   computes for a nucleotide probe, the enthalpie, the entropy #
# of the helix-coil transition, and then its melting temperature.            #
# Three types of hybridisation are possible: DNA/DNA, DNA/RNA, and RNA/RNA.  #
#         Copyright (C) Nicolas Le Novre and Marine Dumousseau 1997-2013    #
##############################################################################
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA#
#
#     Nicolas Le Novere
#     Babraham Institute, Babraham Research Campus
#     Babraham CB22 3AT Cambridge United-Kingdom.
#     n.lenovere@gmail.com
#      
#     Marine Dumousseau
#     EMBL-EBI, Wellcome-Trust Genome Campus
#     Hinxton CB10 1SD Cambridge United-Kingdom. 
#     marine@ebi.ac.uk  

       ###################################################################
       # Usage is: ./multi.pl config_file < inputfile > outputfile       #
       # Where inputfile contains one sequence per line. No space before #
       # sequence and at least one space before extra information        # 
       # Write the parameters of melting in an input file. See manual.   #
       ###################################################################

use strict;

my @linecontent; # contains the elements of a line generated by the function split

my $infile;      # contains the parameters of the run except the sequence
my @sequences;   # contains all the sequences from which to predict the Tm
my $seq;         # one sequence

my @rawresults;  # contains the raw output of MELTING
my ($tm,$H,$S);  

if (not defined $ARGV[0]){
    print "Except the sequences, all parameters have to be contained in a \n",
    "configuration file, and the script run as:\n",
    "  prompt> ./multi.pl config_file < inputfile > outputfile\n";
    exit;
}
# Read the sequences to analise
while (<STDIN>){
    if ( $_ !~ /^(\s*\#.*|\s+)$/){ # do not take into account comment and blank lines
	chomp;
	@linecontent = split(" ");          # Note that each line could contain
	push(@sequences,$linecontent[0]); # other elements used in derived programs
    }
}

print "sequences                        DeltaH   DeltaS  Tm (deg C) \n";
foreach $seq (@sequences){
    @rawresults = `melting -I$ARGV[0] -S$seq -q`;
    foreach (@rawresults){
	@linecontent = split(" ");   
	if ($linecontent[0] =~ /melting/i ){ $tm = $linecontent[2];    
	} elsif ($linecontent[0] =~ /enthalpy/i ){ $H = $linecontent[1];    
	} elsif ($linecontent[0] =~ /entropy/i ){ $S = $linecontent[1];    
	}
    }
    printf "%-30s  %6.0f  %5.1f  %4.1f\n",$seq, $H, $S, $tm;
}





