/* action.c generated by valac 0.26.1, the Vala compiler
 * generated from action.vala, do not modify */

/*      action.vala*/
/*      */
/*      Copyright 2011 Hong Jen Yee (PCMan) <pcman.tw@pcman.tw@gmail.com>*/
/*      */
/*      This program is free software; you can redistribute it and/or modify*/
/*      it under the terms of the GNU General Public License as published by*/
/*      the Free Software Foundation; either version 2 of the License, or*/
/*      (at your option) any later version.*/
/*      */
/*      This program is distributed in the hope that it will be useful,*/
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*      GNU General Public License for more details.*/
/*      */
/*      You should have received a copy of the GNU General Public License*/
/*      along with this program; if not, write to the Free Software*/
/*      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,*/
/*      MA 02110-1301, USA.*/
/*      */
/*      */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fm-file-info.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define FM_TYPE_FILE_ACTION_OBJECT (fm_file_action_object_get_type ())
#define FM_FILE_ACTION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FM_TYPE_FILE_ACTION_OBJECT, FmFileActionObject))
#define FM_FILE_ACTION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FM_TYPE_FILE_ACTION_OBJECT, FmFileActionObjectClass))
#define FM_IS_FILE_ACTION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FM_TYPE_FILE_ACTION_OBJECT))
#define FM_IS_FILE_ACTION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FM_TYPE_FILE_ACTION_OBJECT))
#define FM_FILE_ACTION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FM_TYPE_FILE_ACTION_OBJECT, FmFileActionObjectClass))

typedef struct _FmFileActionObject FmFileActionObject;
typedef struct _FmFileActionObjectClass FmFileActionObjectClass;

#define FM_TYPE_FILE_ACTION_TYPE (fm_file_action_type_get_type ())
typedef struct _FmFileActionObjectPrivate FmFileActionObjectPrivate;
typedef struct _FmFileActionCondition FmFileActionCondition;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fm_file_action_condition_free0(var) ((var == NULL) ? NULL : (var = (fm_file_action_condition_free (var), NULL)))

#define FM_TYPE_FILE_ACTION_TARGET (fm_file_action_target_get_type ())

#define FM_TYPE_FILE_ACTION (fm_file_action_get_type ())
#define FM_FILE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FM_TYPE_FILE_ACTION, FmFileAction))
#define FM_FILE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FM_TYPE_FILE_ACTION, FmFileActionClass))
#define FM_IS_FILE_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FM_TYPE_FILE_ACTION))
#define FM_IS_FILE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FM_TYPE_FILE_ACTION))
#define FM_FILE_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FM_TYPE_FILE_ACTION, FmFileActionClass))

typedef struct _FmFileAction FmFileAction;
typedef struct _FmFileActionClass FmFileActionClass;
typedef struct _FmFileActionPrivate FmFileActionPrivate;
typedef struct _FmFileActionProfile FmFileActionProfile;
#define __g_list_free__fm_file_action_profile_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__fm_file_action_profile_free0_ (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FM_TYPE_FILE_ACTION_MENU (fm_file_action_menu_get_type ())
#define FM_FILE_ACTION_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu))
#define FM_FILE_ACTION_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FM_TYPE_FILE_ACTION_MENU, FmFileActionMenuClass))
#define FM_IS_FILE_ACTION_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FM_TYPE_FILE_ACTION_MENU))
#define FM_IS_FILE_ACTION_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FM_TYPE_FILE_ACTION_MENU))
#define FM_FILE_ACTION_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FM_TYPE_FILE_ACTION_MENU, FmFileActionMenuClass))

typedef struct _FmFileActionMenu FmFileActionMenu;
typedef struct _FmFileActionMenuClass FmFileActionMenuClass;
typedef struct _FmFileActionMenuPrivate FmFileActionMenuPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FM_TYPE_FILE_ACTION_ITEM (fm_file_action_item_get_type ())
#define FM_FILE_ACTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FM_TYPE_FILE_ACTION_ITEM, FmFileActionItem))
#define FM_FILE_ACTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FM_TYPE_FILE_ACTION_ITEM, FmFileActionItemClass))
#define FM_IS_FILE_ACTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FM_TYPE_FILE_ACTION_ITEM))
#define FM_IS_FILE_ACTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FM_TYPE_FILE_ACTION_ITEM))
#define FM_FILE_ACTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FM_TYPE_FILE_ACTION_ITEM, FmFileActionItemClass))

typedef struct _FmFileActionItem FmFileActionItem;
typedef struct _FmFileActionItemClass FmFileActionItemClass;
typedef struct _FmFileActionItemPrivate FmFileActionItemPrivate;
#define __g_list_free__fm_file_action_item_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__fm_file_action_item_unref0_ (var), NULL)))
#define _fm_file_action_item_unref0(var) ((var == NULL) ? NULL : (var = (fm_file_action_item_unref (var), NULL)))
typedef struct _FmParamSpecFileActionItem FmParamSpecFileActionItem;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

typedef enum  {
	FM_FILE_ACTION_TYPE_NONE,
	FM_FILE_ACTION_TYPE_ACTION,
	FM_FILE_ACTION_TYPE_MENU
} FmFileActionType;

struct _FmFileActionObject {
	GObject parent_instance;
	FmFileActionObjectPrivate * priv;
	FmFileActionType type;
	gchar* id;
	gchar* name;
	gchar* tooltip;
	gchar* icon;
	gchar* desc;
	gboolean enabled;
	gboolean hidden;
	gchar* suggested_shortcut;
	FmFileActionCondition* condition;
	gboolean has_parent;
};

struct _FmFileActionObjectClass {
	GObjectClass parent_class;
};

typedef enum  {
	FM_FILE_ACTION_TARGET_NONE,
	FM_FILE_ACTION_TARGET_CONTEXT = 1,
	FM_FILE_ACTION_TARGET_LOCATION = 1 << 1,
	FM_FILE_ACTION_TARGET_TOOLBAR = 1 << 2
} FmFileActionTarget;

struct _FmFileAction {
	FmFileActionObject parent_instance;
	FmFileActionPrivate * priv;
	FmFileActionTarget target;
	gchar* toolbar_label;
	GList* profiles;
};

struct _FmFileActionClass {
	FmFileActionObjectClass parent_class;
};

struct _FmFileActionMenu {
	FmFileActionObject parent_instance;
	FmFileActionMenuPrivate * priv;
	gchar** items_list;
	gint items_list_length1;
	GList* cached_children;
};

struct _FmFileActionMenuClass {
	FmFileActionObjectClass parent_class;
};

struct _FmFileActionItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FmFileActionItemPrivate * priv;
	gchar* name;
	gchar* desc;
	gchar* icon;
	FmFileActionObject* action;
	FmFileActionProfile* profile;
	GList* children;
};

struct _FmFileActionItemClass {
	GTypeClass parent_class;
	void (*finalize) (FmFileActionItem *self);
};

struct _FmParamSpecFileActionItem {
	GParamSpec parent_instance;
};


extern gchar* fm_desktop_env;
gchar* fm_desktop_env = NULL;
extern gboolean fm_actions_loaded;
gboolean fm_actions_loaded = FALSE;
extern GHashTable* fm_all_actions;
GHashTable* fm_all_actions = NULL;
static gpointer fm_file_action_object_parent_class = NULL;
static gpointer fm_file_action_parent_class = NULL;
static gpointer fm_file_action_menu_parent_class = NULL;
static gpointer fm_file_action_item_parent_class = NULL;

GType fm_file_action_object_get_type (void) G_GNUC_CONST;
GType fm_file_action_type_get_type (void) G_GNUC_CONST;
void fm_file_action_condition_free (FmFileActionCondition* self);
enum  {
	FM_FILE_ACTION_OBJECT_DUMMY_PROPERTY
};
FmFileActionObject* fm_file_action_object_new (void);
FmFileActionObject* fm_file_action_object_construct (GType object_type);
FmFileActionObject* fm_file_action_object_new_from_key_file (GKeyFile* kf);
FmFileActionObject* fm_file_action_object_construct_from_key_file (GType object_type, GKeyFile* kf);
gchar* utils_key_file_get_locale_string (GKeyFile* kf, const gchar* group, const gchar* key, const gchar* def_val);
gboolean utils_key_file_get_bool (GKeyFile* kf, const gchar* group, const gchar* key, gboolean def_val);
gchar* utils_key_file_get_string (GKeyFile* kf, const gchar* group, const gchar* key, const gchar* def_val);
FmFileActionCondition* fm_file_action_condition_new (GKeyFile* kf, const gchar* group);
FmFileActionCondition* fm_file_action_condition_new (GKeyFile* kf, const gchar* group);
static void fm_file_action_object_finalize (GObject* obj);
GType fm_file_action_target_get_type (void) G_GNUC_CONST;
GType fm_file_action_get_type (void) G_GNUC_CONST;
void fm_file_action_profile_free (FmFileActionProfile* self);
enum  {
	FM_FILE_ACTION_DUMMY_PROPERTY
};
static void _fm_file_action_profile_free0_ (gpointer var);
static void _g_list_free__fm_file_action_profile_free0_ (GList* self);
FmFileAction* fm_file_action_new (const gchar* desktop_id);
FmFileAction* fm_file_action_construct (GType object_type, const gchar* desktop_id);
FmFileAction* fm_file_action_new_from_keyfile (GKeyFile* kf);
FmFileAction* fm_file_action_construct_from_keyfile (GType object_type, GKeyFile* kf);
gchar** utils_key_file_get_string_list (GKeyFile* kf, const gchar* group, const gchar* key, gchar** def_val, int def_val_length1, int* result_length1);
FmFileActionProfile* fm_file_action_profile_new (GKeyFile* kf, const gchar* profile_name);
FmFileActionProfile* fm_file_action_profile_new (GKeyFile* kf, const gchar* profile_name);
gboolean fm_file_action_match (FmFileAction* self, GList* files, FmFileActionProfile** matched_profile);
gboolean fm_file_action_condition_match (FmFileActionCondition* self, GList* files);
gboolean fm_file_action_profile_match (FmFileActionProfile* self, GList* files);
static void fm_file_action_finalize (GObject* obj);
GType fm_file_action_menu_get_type (void) G_GNUC_CONST;
enum  {
	FM_FILE_ACTION_MENU_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
FmFileActionMenu* fm_file_action_menu_new (const gchar* desktop_id);
FmFileActionMenu* fm_file_action_menu_construct (GType object_type, const gchar* desktop_id);
FmFileActionMenu* fm_file_action_menu_new_from_keyfile (GKeyFile* kf);
FmFileActionMenu* fm_file_action_menu_construct_from_keyfile (GType object_type, GKeyFile* kf);
gboolean fm_file_action_menu_match (FmFileActionMenu* self, GList* files);
void fm_file_action_menu_cache_children (FmFileActionMenu* self, GList* files, gchar** items_list, int items_list_length1);
gchar* fm_file_action_parameters_expand (const gchar* templ, GList* files, gboolean for_display, FmFileInfo* first_file);
static void fm_file_action_menu_finalize (GObject* obj);
gpointer fm_file_action_item_ref (gpointer instance);
void fm_file_action_item_unref (gpointer instance);
GParamSpec* fm_param_spec_file_action_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fm_value_set_file_action_item (GValue* value, gpointer v_object);
void fm_value_take_file_action_item (GValue* value, gpointer v_object);
gpointer fm_value_get_file_action_item (const GValue* value);
GType fm_file_action_item_get_type (void) G_GNUC_CONST;
enum  {
	FM_FILE_ACTION_ITEM_DUMMY_PROPERTY
};
static void _fm_file_action_item_unref0_ (gpointer var);
static void _g_list_free__fm_file_action_item_unref0_ (GList* self);
FmFileActionItem* fm_file_action_item_new_for_action_object (FmFileActionObject* action_obj, GList* files);
FmFileActionItem* fm_file_action_item_new_from_menu (FmFileActionMenu* menu, GList* files);
FmFileActionItem* fm_file_action_item_construct_from_menu (GType object_type, FmFileActionMenu* menu, GList* files);
FmFileActionItem* fm_file_action_item_new_from_action (FmFileAction* action, FmFileActionProfile* profile, GList* files);
FmFileActionItem* fm_file_action_item_construct_from_action (GType object_type, FmFileAction* action, FmFileActionProfile* profile, GList* files);
static FmFileActionItem* fm_file_action_item_new (FmFileActionObject* action, GList* files);
static FmFileActionItem* fm_file_action_item_construct (GType object_type, FmFileActionObject* action, GList* files);
const gchar* fm_file_action_item_get_name (FmFileActionItem* self);
const gchar* fm_file_action_item_get_desc (FmFileActionItem* self);
const gchar* fm_file_action_item_get_icon (FmFileActionItem* self);
const gchar* fm_file_action_item_get_id (FmFileActionItem* self);
FmFileActionTarget fm_file_action_item_get_target (FmFileActionItem* self);
gboolean fm_file_action_item_is_menu (FmFileActionItem* self);
gboolean fm_file_action_item_is_action (FmFileActionItem* self);
gboolean fm_file_action_item_launch (FmFileActionItem* self, GAppLaunchContext* ctx, GList* files, gchar** output);
gboolean fm_file_action_profile_launch (FmFileActionProfile* self, GAppLaunchContext* ctx, GList* files, gchar** output);
GList* fm_file_action_item_get_sub_items (FmFileActionItem* self);
static void fm_file_action_item_finalize (FmFileActionItem* obj);
void fm_load_actions_from_dir (const gchar* dirname, const gchar* id_prefix);
GList* fm_get_actions_for_files (GList* files);
void fm_load_all_actions (void);
void fm_file_actions_set_desktop_env (const gchar* env);
void _fm_file_actions_init (void);
static void _g_free0_ (gpointer var);
void _fm_file_actions_finalize (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType fm_file_action_type_get_type (void) {
	static volatile gsize fm_file_action_type_type_id__volatile = 0;
	if (g_once_init_enter (&fm_file_action_type_type_id__volatile)) {
		static const GEnumValue values[] = {{FM_FILE_ACTION_TYPE_NONE, "FM_FILE_ACTION_TYPE_NONE", "none"}, {FM_FILE_ACTION_TYPE_ACTION, "FM_FILE_ACTION_TYPE_ACTION", "action"}, {FM_FILE_ACTION_TYPE_MENU, "FM_FILE_ACTION_TYPE_MENU", "menu"}, {0, NULL, NULL}};
		GType fm_file_action_type_type_id;
		fm_file_action_type_type_id = g_enum_register_static ("FmFileActionType", values);
		g_once_init_leave (&fm_file_action_type_type_id__volatile, fm_file_action_type_type_id);
	}
	return fm_file_action_type_type_id__volatile;
}


FmFileActionObject* fm_file_action_object_construct (GType object_type) {
	FmFileActionObject * self = NULL;
	self = (FmFileActionObject*) g_object_new (object_type, NULL);
	return self;
}


FmFileActionObject* fm_file_action_object_new (void) {
	return fm_file_action_object_construct (FM_TYPE_FILE_ACTION_OBJECT);
}


FmFileActionObject* fm_file_action_object_construct_from_key_file (GType object_type, GKeyFile* kf) {
	FmFileActionObject * self = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GKeyFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GKeyFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GKeyFile* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GKeyFile* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GKeyFile* _tmp14_ = NULL;
	FmFileActionCondition* _tmp15_ = NULL;
	g_return_val_if_fail (kf != NULL, NULL);
	self = (FmFileActionObject*) g_object_new (object_type, NULL);
	_tmp0_ = kf;
	_tmp1_ = utils_key_file_get_locale_string (_tmp0_, "Desktop Entry", "Name", NULL);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = kf;
	_tmp3_ = utils_key_file_get_locale_string (_tmp2_, "Desktop Entry", "Tooltip", NULL);
	_g_free0 (self->tooltip);
	self->tooltip = _tmp3_;
	_tmp4_ = kf;
	_tmp5_ = utils_key_file_get_locale_string (_tmp4_, "Desktop Entry", "Icon", NULL);
	_g_free0 (self->icon);
	self->icon = _tmp5_;
	_tmp6_ = kf;
	_tmp7_ = utils_key_file_get_locale_string (_tmp6_, "Desktop Entry", "Description", NULL);
	_g_free0 (self->desc);
	self->desc = _tmp7_;
	_tmp8_ = kf;
	_tmp9_ = utils_key_file_get_bool (_tmp8_, "Desktop Entry", "Enabled", TRUE);
	self->enabled = _tmp9_;
	_tmp10_ = kf;
	_tmp11_ = utils_key_file_get_bool (_tmp10_, "Desktop Entry", "Hidden", FALSE);
	self->hidden = _tmp11_;
	_tmp12_ = kf;
	_tmp13_ = utils_key_file_get_string (_tmp12_, "Desktop Entry", "SuggestedShortcut", NULL);
	_g_free0 (self->suggested_shortcut);
	self->suggested_shortcut = _tmp13_;
	_tmp14_ = kf;
	_tmp15_ = fm_file_action_condition_new (_tmp14_, "Desktop Entry");
	_fm_file_action_condition_free0 (self->condition);
	self->condition = _tmp15_;
	return self;
}


FmFileActionObject* fm_file_action_object_new_from_key_file (GKeyFile* kf) {
	return fm_file_action_object_construct_from_key_file (FM_TYPE_FILE_ACTION_OBJECT, kf);
}


static void fm_file_action_object_class_init (FmFileActionObjectClass * klass) {
	fm_file_action_object_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = fm_file_action_object_finalize;
}


static void fm_file_action_object_instance_init (FmFileActionObject * self) {
}


static void fm_file_action_object_finalize (GObject* obj) {
	FmFileActionObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION_OBJECT, FmFileActionObject);
	_g_free0 (self->id);
	_g_free0 (self->name);
	_g_free0 (self->tooltip);
	_g_free0 (self->icon);
	_g_free0 (self->desc);
	_g_free0 (self->suggested_shortcut);
	_fm_file_action_condition_free0 (self->condition);
	G_OBJECT_CLASS (fm_file_action_object_parent_class)->finalize (obj);
}


GType fm_file_action_object_get_type (void) {
	static volatile gsize fm_file_action_object_type_id__volatile = 0;
	if (g_once_init_enter (&fm_file_action_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FmFileActionObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileActionObject), 0, (GInstanceInitFunc) fm_file_action_object_instance_init, NULL };
		GType fm_file_action_object_type_id;
		fm_file_action_object_type_id = g_type_register_static (G_TYPE_OBJECT, "FmFileActionObject", &g_define_type_info, 0);
		g_once_init_leave (&fm_file_action_object_type_id__volatile, fm_file_action_object_type_id);
	}
	return fm_file_action_object_type_id__volatile;
}


GType fm_file_action_target_get_type (void) {
	static volatile gsize fm_file_action_target_type_id__volatile = 0;
	if (g_once_init_enter (&fm_file_action_target_type_id__volatile)) {
		static const GEnumValue values[] = {{FM_FILE_ACTION_TARGET_NONE, "FM_FILE_ACTION_TARGET_NONE", "none"}, {FM_FILE_ACTION_TARGET_CONTEXT, "FM_FILE_ACTION_TARGET_CONTEXT", "context"}, {FM_FILE_ACTION_TARGET_LOCATION, "FM_FILE_ACTION_TARGET_LOCATION", "location"}, {FM_FILE_ACTION_TARGET_TOOLBAR, "FM_FILE_ACTION_TARGET_TOOLBAR", "toolbar"}, {0, NULL, NULL}};
		GType fm_file_action_target_type_id;
		fm_file_action_target_type_id = g_enum_register_static ("FmFileActionTarget", values);
		g_once_init_leave (&fm_file_action_target_type_id__volatile, fm_file_action_target_type_id);
	}
	return fm_file_action_target_type_id__volatile;
}


static void _fm_file_action_profile_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (fm_file_action_profile_free (var), NULL));
}


static void _g_list_free__fm_file_action_profile_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _fm_file_action_profile_free0_, NULL);
	g_list_free (self);
}


FmFileAction* fm_file_action_construct (GType object_type, const gchar* desktop_id) {
	FmFileAction * self = NULL;
	GKeyFile* kf = NULL;
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	kf = _tmp0_;
	_tmp1_ = desktop_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (((FmFileActionObject*) self)->id);
	((FmFileActionObject*) self)->id = _tmp2_;
	{
		GKeyFile* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GKeyFile* _tmp5_ = NULL;
		_tmp3_ = kf;
		_tmp4_ = desktop_id;
		g_key_file_load_from_file (_tmp3_, _tmp4_, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_key_file_free0 (kf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = kf;
		self = (FmFileAction*) fm_file_action_construct_from_keyfile (object_type, _tmp5_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_key_file_free0 (kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_key_file_free0 (kf);
	return self;
}


FmFileAction* fm_file_action_new (const gchar* desktop_id) {
	return fm_file_action_construct (FM_TYPE_FILE_ACTION, desktop_id);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


FmFileAction* fm_file_action_construct_from_keyfile (GType object_type, GKeyFile* kf) {
	FmFileAction * self = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GKeyFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GKeyFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GKeyFile* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar** profile_names = NULL;
	GKeyFile* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gint profile_names_length1 = 0;
	gint _profile_names_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (kf != NULL, NULL);
	_tmp0_ = kf;
	self = (FmFileAction*) fm_file_action_object_construct_from_key_file (object_type, _tmp0_);
	((FmFileActionObject*) self)->type = FM_FILE_ACTION_TYPE_ACTION;
	_tmp1_ = kf;
	_tmp2_ = utils_key_file_get_bool (_tmp1_, "Desktop Entry", "TargetContext", TRUE);
	if (_tmp2_) {
		FmFileActionTarget _tmp3_ = 0;
		_tmp3_ = self->target;
		self->target = _tmp3_ | FM_FILE_ACTION_TARGET_CONTEXT;
	}
	_tmp4_ = kf;
	_tmp5_ = utils_key_file_get_bool (_tmp4_, "Desktop Entry", "TargetLocation", FALSE);
	if (_tmp5_) {
		FmFileActionTarget _tmp6_ = 0;
		_tmp6_ = self->target;
		self->target = _tmp6_ | FM_FILE_ACTION_TARGET_LOCATION;
	}
	_tmp7_ = kf;
	_tmp8_ = utils_key_file_get_bool (_tmp7_, "Desktop Entry", "TargetToolbar", FALSE);
	if (_tmp8_) {
		FmFileActionTarget _tmp9_ = 0;
		_tmp9_ = self->target;
		self->target = _tmp9_ | FM_FILE_ACTION_TARGET_TOOLBAR;
	}
	_tmp10_ = kf;
	_tmp11_ = utils_key_file_get_locale_string (_tmp10_, "Desktop Entry", "ToolbarLabel", NULL);
	_g_free0 (self->toolbar_label);
	self->toolbar_label = _tmp11_;
	_tmp12_ = kf;
	_tmp14_ = utils_key_file_get_string_list (_tmp12_, "Desktop Entry", "Profiles", NULL, 0, &_tmp13_);
	profile_names = _tmp14_;
	profile_names_length1 = _tmp13_;
	_profile_names_size_ = profile_names_length1;
	_tmp15_ = profile_names;
	_tmp15__length1 = profile_names_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp16_ = profile_names;
		_tmp16__length1 = profile_names_length1;
		{
			gchar** profile_name_collection = NULL;
			gint profile_name_collection_length1 = 0;
			gint _profile_name_collection_size_ = 0;
			gint profile_name_it = 0;
			profile_name_collection = _tmp16_;
			profile_name_collection_length1 = _tmp16__length1;
			for (profile_name_it = 0; profile_name_it < _tmp16__length1; profile_name_it = profile_name_it + 1) {
				gchar* _tmp17_ = NULL;
				gchar* profile_name = NULL;
				_tmp17_ = g_strdup (profile_name_collection[profile_name_it]);
				profile_name = _tmp17_;
				{
					GKeyFile* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					FmFileActionProfile* _tmp22_ = NULL;
					_tmp18_ = kf;
					_tmp19_ = profile_name;
					_tmp20_ = string_strip (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = fm_file_action_profile_new (_tmp18_, _tmp21_);
					self->profiles = g_list_prepend (self->profiles, _tmp22_);
					_g_free0 (_tmp21_);
					_g_free0 (profile_name);
				}
			}
		}
		self->profiles = g_list_reverse (self->profiles);
	}
	profile_names = (_vala_array_free (profile_names, profile_names_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


FmFileAction* fm_file_action_new_from_keyfile (GKeyFile* kf) {
	return fm_file_action_construct_from_keyfile (FM_TYPE_FILE_ACTION, kf);
}


gboolean fm_file_action_match (FmFileAction* self, GList* files, FmFileActionProfile** matched_profile) {
	FmFileActionProfile* _vala_matched_profile = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	FmFileActionCondition* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GList* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_matched_profile = NULL;
	_tmp1_ = ((FmFileActionObject*) self)->hidden;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = ((FmFileActionObject*) self)->enabled;
		_tmp0_ = !_tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		if (matched_profile) {
			*matched_profile = _vala_matched_profile;
		}
		return result;
	}
	_tmp3_ = ((FmFileActionObject*) self)->condition;
	_tmp4_ = files;
	_tmp5_ = fm_file_action_condition_match (_tmp3_, _tmp4_);
	if (!_tmp5_) {
		result = FALSE;
		if (matched_profile) {
			*matched_profile = _vala_matched_profile;
		}
		return result;
	}
	_tmp6_ = self->profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp6_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			FmFileActionProfile* profile = NULL;
			profile = (FmFileActionProfile*) profile_it->data;
			{
				FmFileActionProfile* _tmp7_ = NULL;
				GList* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = profile;
				_tmp8_ = files;
				_tmp9_ = fm_file_action_profile_match (_tmp7_, _tmp8_);
				if (_tmp9_) {
					FmFileActionProfile* _tmp10_ = NULL;
					_tmp10_ = profile;
					_vala_matched_profile = _tmp10_;
					result = TRUE;
					if (matched_profile) {
						*matched_profile = _vala_matched_profile;
					}
					return result;
				}
			}
		}
	}
	result = FALSE;
	if (matched_profile) {
		*matched_profile = _vala_matched_profile;
	}
	return result;
}


static void fm_file_action_class_init (FmFileActionClass * klass) {
	fm_file_action_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = fm_file_action_finalize;
}


static void fm_file_action_instance_init (FmFileAction * self) {
}


static void fm_file_action_finalize (GObject* obj) {
	FmFileAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION, FmFileAction);
	_g_free0 (self->toolbar_label);
	__g_list_free__fm_file_action_profile_free0_0 (self->profiles);
	G_OBJECT_CLASS (fm_file_action_parent_class)->finalize (obj);
}


GType fm_file_action_get_type (void) {
	static volatile gsize fm_file_action_type_id__volatile = 0;
	if (g_once_init_enter (&fm_file_action_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FmFileActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileAction), 0, (GInstanceInitFunc) fm_file_action_instance_init, NULL };
		GType fm_file_action_type_id;
		fm_file_action_type_id = g_type_register_static (FM_TYPE_FILE_ACTION_OBJECT, "FmFileAction", &g_define_type_info, 0);
		g_once_init_leave (&fm_file_action_type_id__volatile, fm_file_action_type_id);
	}
	return fm_file_action_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


FmFileActionMenu* fm_file_action_menu_construct (GType object_type, const gchar* desktop_id) {
	FmFileActionMenu * self = NULL;
	GKeyFile* kf = NULL;
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	kf = _tmp0_;
	_tmp1_ = desktop_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (((FmFileActionObject*) self)->id);
	((FmFileActionObject*) self)->id = _tmp2_;
	{
		GKeyFile* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GKeyFile* _tmp5_ = NULL;
		_tmp3_ = kf;
		_tmp4_ = desktop_id;
		g_key_file_load_from_file (_tmp3_, _tmp4_, 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_key_file_free0 (kf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = kf;
		self = (FmFileActionMenu*) fm_file_action_menu_construct_from_keyfile (object_type, _tmp5_);
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_key_file_free0 (kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_key_file_free0 (kf);
	return self;
}


FmFileActionMenu* fm_file_action_menu_new (const gchar* desktop_id) {
	return fm_file_action_menu_construct (FM_TYPE_FILE_ACTION_MENU, desktop_id);
}


FmFileActionMenu* fm_file_action_menu_construct_from_keyfile (GType object_type, GKeyFile* kf) {
	FmFileActionMenu * self = NULL;
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	g_return_val_if_fail (kf != NULL, NULL);
	_tmp0_ = kf;
	self = (FmFileActionMenu*) fm_file_action_object_construct_from_key_file (object_type, _tmp0_);
	((FmFileActionObject*) self)->type = FM_FILE_ACTION_TYPE_MENU;
	_tmp1_ = kf;
	_tmp3_ = utils_key_file_get_string_list (_tmp1_, "Desktop Entry", "ItemsList", NULL, 0, &_tmp2_);
	self->items_list = (_vala_array_free (self->items_list, self->items_list_length1, (GDestroyNotify) g_free), NULL);
	self->items_list = _tmp3_;
	self->items_list_length1 = _tmp2_;
	return self;
}


FmFileActionMenu* fm_file_action_menu_new_from_keyfile (GKeyFile* kf) {
	return fm_file_action_menu_construct_from_keyfile (FM_TYPE_FILE_ACTION_MENU, kf);
}


gboolean fm_file_action_menu_match (FmFileActionMenu* self, GList* files) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	FmFileActionCondition* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = ((FmFileActionObject*) self)->hidden;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = ((FmFileActionObject*) self)->enabled;
		_tmp0_ = !_tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = ((FmFileActionObject*) self)->condition;
	_tmp4_ = files;
	_tmp5_ = fm_file_action_condition_match (_tmp3_, _tmp4_);
	if (!_tmp5_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void fm_file_action_menu_cache_children (FmFileActionMenu* self, GList* files, gchar** items_list, int items_list_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = items_list;
	_tmp0__length1 = items_list_length1;
	{
		gchar** item_id_prefix_collection = NULL;
		gint item_id_prefix_collection_length1 = 0;
		gint _item_id_prefix_collection_size_ = 0;
		gint item_id_prefix_it = 0;
		item_id_prefix_collection = _tmp0_;
		item_id_prefix_collection_length1 = _tmp0__length1;
		for (item_id_prefix_it = 0; item_id_prefix_it < _tmp0__length1; item_id_prefix_it = item_id_prefix_it + 1) {
			const gchar* item_id_prefix = NULL;
			item_id_prefix = item_id_prefix_collection[item_id_prefix_it];
			{
				gboolean _tmp1_ = FALSE;
				const gchar* _tmp2_ = NULL;
				gchar _tmp3_ = '\0';
				_tmp2_ = item_id_prefix;
				_tmp3_ = string_get (_tmp2_, (glong) 0);
				if (_tmp3_ == '[') {
					const gchar* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gchar _tmp8_ = '\0';
					_tmp4_ = item_id_prefix;
					_tmp5_ = item_id_prefix;
					_tmp6_ = strlen (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = string_get (_tmp4_, (glong) (_tmp7_ - 1));
					_tmp1_ = _tmp8_ == ']';
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					gchar* output = NULL;
					gint exit_status = 0;
					gchar* command = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					GList* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gboolean _tmp20_ = FALSE;
					_tmp9_ = item_id_prefix;
					_tmp10_ = string_slice (_tmp9_, (glong) 1, (glong) (-1));
					_tmp11_ = _tmp10_;
					_tmp12_ = files;
					_tmp13_ = fm_file_action_parameters_expand (_tmp11_, _tmp12_, FALSE, NULL);
					_tmp14_ = _tmp13_;
					_g_free0 (_tmp11_);
					command = _tmp14_;
					_tmp17_ = command;
					_tmp20_ = g_spawn_command_line_sync (_tmp17_, &_tmp18_, NULL, &_tmp19_, &_inner_error_);
					_g_free0 (output);
					output = _tmp18_;
					exit_status = _tmp19_;
					_tmp16_ = _tmp20_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (command);
						_g_free0 (output);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					if (_tmp16_) {
						gint _tmp21_ = 0;
						_tmp21_ = exit_status;
						_tmp15_ = _tmp21_ == 0;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						gchar** item_ids = NULL;
						const gchar* _tmp22_ = NULL;
						gchar** _tmp23_ = NULL;
						gchar** _tmp24_ = NULL;
						gint item_ids_length1 = 0;
						gint _item_ids_size_ = 0;
						GList* _tmp25_ = NULL;
						gchar** _tmp26_ = NULL;
						gint _tmp26__length1 = 0;
						_tmp22_ = output;
						_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ";", 0);
						item_ids = _tmp24_;
						item_ids_length1 = _vala_array_length (_tmp23_);
						_item_ids_size_ = item_ids_length1;
						_tmp25_ = files;
						_tmp26_ = item_ids;
						_tmp26__length1 = item_ids_length1;
						fm_file_action_menu_cache_children (self, _tmp25_, _tmp26_, _tmp26__length1);
						item_ids = (_vala_array_free (item_ids, item_ids_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (command);
					_g_free0 (output);
				} else {
					const gchar* _tmp27_ = NULL;
					_tmp27_ = item_id_prefix;
					if (g_strcmp0 (_tmp27_, "SEPARATOR") == 0) {
						self->cached_children = g_list_append (self->cached_children, NULL);
					} else {
						gchar* item_id = NULL;
						const gchar* _tmp28_ = NULL;
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						FmFileActionObject* child_action = NULL;
						GHashTable* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
						gconstpointer _tmp33_ = NULL;
						FmFileActionObject* _tmp34_ = NULL;
						FmFileActionObject* _tmp35_ = NULL;
						_tmp28_ = item_id_prefix;
						_tmp29_ = string_to_string (_tmp28_);
						_tmp30_ = g_strconcat (_tmp29_, ".desktop", NULL);
						item_id = _tmp30_;
						_tmp31_ = fm_all_actions;
						_tmp32_ = item_id;
						_tmp33_ = g_hash_table_lookup (_tmp31_, _tmp32_);
						_tmp34_ = _g_object_ref0 ((FmFileActionObject*) _tmp33_);
						child_action = _tmp34_;
						_tmp35_ = child_action;
						if (_tmp35_ != NULL) {
							FmFileActionObject* _tmp36_ = NULL;
							FmFileActionObject* _tmp37_ = NULL;
							FmFileActionObject* _tmp38_ = NULL;
							_tmp36_ = child_action;
							_tmp36_->has_parent = TRUE;
							_tmp37_ = child_action;
							_tmp38_ = _g_object_ref0 (_tmp37_);
							self->cached_children = g_list_append (self->cached_children, _tmp38_);
						}
						_g_object_unref0 (child_action);
						_g_free0 (item_id);
					}
				}
			}
		}
	}
}


static void fm_file_action_menu_class_init (FmFileActionMenuClass * klass) {
	fm_file_action_menu_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = fm_file_action_menu_finalize;
}


static void fm_file_action_menu_instance_init (FmFileActionMenu * self) {
}


static void fm_file_action_menu_finalize (GObject* obj) {
	FmFileActionMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu);
	self->items_list = (_vala_array_free (self->items_list, self->items_list_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free__g_object_unref0_0 (self->cached_children);
	G_OBJECT_CLASS (fm_file_action_menu_parent_class)->finalize (obj);
}


GType fm_file_action_menu_get_type (void) {
	static volatile gsize fm_file_action_menu_type_id__volatile = 0;
	if (g_once_init_enter (&fm_file_action_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FmFileActionMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileActionMenu), 0, (GInstanceInitFunc) fm_file_action_menu_instance_init, NULL };
		GType fm_file_action_menu_type_id;
		fm_file_action_menu_type_id = g_type_register_static (FM_TYPE_FILE_ACTION_OBJECT, "FmFileActionMenu", &g_define_type_info, 0);
		g_once_init_leave (&fm_file_action_menu_type_id__volatile, fm_file_action_menu_type_id);
	}
	return fm_file_action_menu_type_id__volatile;
}


static void _fm_file_action_item_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (fm_file_action_item_unref (var), NULL));
}


static void _g_list_free__fm_file_action_item_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _fm_file_action_item_unref0_, NULL);
	g_list_free (self);
}


FmFileActionItem* fm_file_action_item_new_for_action_object (FmFileActionObject* action_obj, GList* files) {
	FmFileActionItem* result = NULL;
	FmFileActionItem* item = NULL;
	FmFileActionObject* _tmp0_ = NULL;
	FmFileActionType _tmp1_ = 0;
	g_return_val_if_fail (action_obj != NULL, NULL);
	item = NULL;
	_tmp0_ = action_obj;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == FM_FILE_ACTION_TYPE_MENU) {
		FmFileActionMenu* menu = NULL;
		FmFileActionObject* _tmp2_ = NULL;
		FmFileActionMenu* _tmp3_ = NULL;
		FmFileActionMenu* _tmp4_ = NULL;
		GList* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp2_ = action_obj;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu));
		menu = _tmp3_;
		_tmp4_ = menu;
		_tmp5_ = files;
		_tmp6_ = fm_file_action_menu_match (_tmp4_, _tmp5_);
		if (_tmp6_) {
			FmFileActionMenu* _tmp7_ = NULL;
			GList* _tmp8_ = NULL;
			FmFileActionItem* _tmp9_ = NULL;
			FmFileActionItem* _tmp10_ = NULL;
			GList* _tmp11_ = NULL;
			_tmp7_ = menu;
			_tmp8_ = files;
			_tmp9_ = fm_file_action_item_new_from_menu (_tmp7_, _tmp8_);
			_fm_file_action_item_unref0 (item);
			item = _tmp9_;
			_tmp10_ = item;
			_tmp11_ = _tmp10_->children;
			if (_tmp11_ == NULL) {
				_fm_file_action_item_unref0 (item);
				item = NULL;
			}
		}
		_g_object_unref0 (menu);
	} else {
		FmFileAction* action = NULL;
		FmFileActionObject* _tmp12_ = NULL;
		FmFileAction* _tmp13_ = NULL;
		FmFileActionProfile* profile = NULL;
		FmFileAction* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		FmFileActionProfile* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp12_ = action_obj;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, FM_TYPE_FILE_ACTION, FmFileAction));
		action = _tmp13_;
		_tmp14_ = action;
		_tmp15_ = files;
		_tmp17_ = fm_file_action_match (_tmp14_, _tmp15_, &_tmp16_);
		profile = _tmp16_;
		if (_tmp17_) {
			FmFileAction* _tmp18_ = NULL;
			FmFileActionProfile* _tmp19_ = NULL;
			GList* _tmp20_ = NULL;
			FmFileActionItem* _tmp21_ = NULL;
			_tmp18_ = action;
			_tmp19_ = profile;
			_tmp20_ = files;
			_tmp21_ = fm_file_action_item_new_from_action (_tmp18_, _tmp19_, _tmp20_);
			_fm_file_action_item_unref0 (item);
			item = _tmp21_;
		}
		_g_object_unref0 (action);
	}
	result = item;
	return result;
}


FmFileActionItem* fm_file_action_item_construct_from_action (GType object_type, FmFileAction* action, FmFileActionProfile* profile, GList* files) {
	FmFileActionItem* self = NULL;
	FmFileAction* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	FmFileActionProfile* _tmp2_ = NULL;
	g_return_val_if_fail (action != NULL, NULL);
	g_return_val_if_fail (profile != NULL, NULL);
	_tmp0_ = action;
	_tmp1_ = files;
	self = (FmFileActionItem*) fm_file_action_item_construct (object_type, (FmFileActionObject*) _tmp0_, _tmp1_);
	_tmp2_ = profile;
	self->profile = _tmp2_;
	return self;
}


FmFileActionItem* fm_file_action_item_new_from_action (FmFileAction* action, FmFileActionProfile* profile, GList* files) {
	return fm_file_action_item_construct_from_action (FM_TYPE_FILE_ACTION_ITEM, action, profile, files);
}


static gpointer _fm_file_action_item_ref0 (gpointer self) {
	return self ? fm_file_action_item_ref (self) : NULL;
}


FmFileActionItem* fm_file_action_item_construct_from_menu (GType object_type, FmFileActionMenu* menu, GList* files) {
	FmFileActionItem* self = NULL;
	FmFileActionMenu* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	FmFileActionMenu* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	g_return_val_if_fail (menu != NULL, NULL);
	_tmp0_ = menu;
	_tmp1_ = files;
	self = (FmFileActionItem*) fm_file_action_item_construct (object_type, (FmFileActionObject*) _tmp0_, _tmp1_);
	_tmp2_ = menu;
	_tmp3_ = _tmp2_->cached_children;
	{
		GList* action_obj_collection = NULL;
		GList* action_obj_it = NULL;
		action_obj_collection = _tmp3_;
		for (action_obj_it = action_obj_collection; action_obj_it != NULL; action_obj_it = action_obj_it->next) {
			FmFileActionObject* _tmp4_ = NULL;
			FmFileActionObject* action_obj = NULL;
			_tmp4_ = _g_object_ref0 ((FmFileActionObject*) action_obj_it->data);
			action_obj = _tmp4_;
			{
				FmFileActionObject* _tmp5_ = NULL;
				_tmp5_ = action_obj;
				if (_tmp5_ == NULL) {
					self->children = g_list_append (self->children, NULL);
				} else {
					FmFileActionItem* subitem = NULL;
					FmFileActionObject* _tmp6_ = NULL;
					GList* _tmp7_ = NULL;
					FmFileActionItem* _tmp8_ = NULL;
					FmFileActionItem* _tmp9_ = NULL;
					_tmp6_ = action_obj;
					_tmp7_ = files;
					_tmp8_ = fm_file_action_item_new_for_action_object (_tmp6_, _tmp7_);
					subitem = _tmp8_;
					_tmp9_ = subitem;
					if (_tmp9_ != NULL) {
						FmFileActionItem* _tmp10_ = NULL;
						FmFileActionItem* _tmp11_ = NULL;
						_tmp10_ = subitem;
						_tmp11_ = _fm_file_action_item_ref0 (_tmp10_);
						self->children = g_list_append (self->children, _tmp11_);
					}
					_fm_file_action_item_unref0 (subitem);
				}
				_g_object_unref0 (action_obj);
			}
		}
	}
	return self;
}


FmFileActionItem* fm_file_action_item_new_from_menu (FmFileActionMenu* menu, GList* files) {
	return fm_file_action_item_construct_from_menu (FM_TYPE_FILE_ACTION_ITEM, menu, files);
}


static FmFileActionItem* fm_file_action_item_construct (GType object_type, FmFileActionObject* action, GList* files) {
	FmFileActionItem* self = NULL;
	FmFileActionObject* _tmp0_ = NULL;
	FmFileActionObject* _tmp1_ = NULL;
	FmFileActionObject* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	FmFileActionObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	FmFileActionObject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	g_return_val_if_fail (action != NULL, NULL);
	self = (FmFileActionItem*) g_type_create_instance (object_type);
	_tmp0_ = action;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->action);
	self->action = _tmp1_;
	_tmp2_ = action;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = files;
	_tmp5_ = fm_file_action_parameters_expand (_tmp3_, _tmp4_, TRUE, NULL);
	_g_free0 (self->name);
	self->name = _tmp5_;
	_tmp6_ = action;
	_tmp7_ = _tmp6_->desc;
	_tmp8_ = files;
	_tmp9_ = fm_file_action_parameters_expand (_tmp7_, _tmp8_, TRUE, NULL);
	_g_free0 (self->desc);
	self->desc = _tmp9_;
	_tmp10_ = action;
	_tmp11_ = _tmp10_->icon;
	_tmp12_ = files;
	_tmp13_ = fm_file_action_parameters_expand (_tmp11_, _tmp12_, FALSE, NULL);
	_g_free0 (self->icon);
	self->icon = _tmp13_;
	return self;
}


static FmFileActionItem* fm_file_action_item_new (FmFileActionObject* action, GList* files) {
	return fm_file_action_item_construct (FM_TYPE_FILE_ACTION_ITEM, action, files);
}


const gchar* fm_file_action_item_get_name (FmFileActionItem* self) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	result = _tmp0_;
	return result;
}


const gchar* fm_file_action_item_get_desc (FmFileActionItem* self) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->desc;
	result = _tmp0_;
	return result;
}


const gchar* fm_file_action_item_get_icon (FmFileActionItem* self) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->icon;
	result = _tmp0_;
	return result;
}


const gchar* fm_file_action_item_get_id (FmFileActionItem* self) {
	const gchar* result = NULL;
	FmFileActionObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->action;
	_tmp1_ = _tmp0_->id;
	result = _tmp1_;
	return result;
}


FmFileActionTarget fm_file_action_item_get_target (FmFileActionItem* self) {
	FmFileActionTarget result = 0;
	FmFileActionObject* _tmp0_ = NULL;
	FmFileActionType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->action;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == FM_FILE_ACTION_TYPE_ACTION) {
		FmFileActionObject* _tmp2_ = NULL;
		FmFileActionTarget _tmp3_ = 0;
		_tmp2_ = self->action;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FM_TYPE_FILE_ACTION, FmFileAction)->target;
		result = _tmp3_;
		return result;
	}
	result = FM_FILE_ACTION_TARGET_NONE;
	return result;
}


gboolean fm_file_action_item_is_menu (FmFileActionItem* self) {
	gboolean result = FALSE;
	FmFileActionObject* _tmp0_ = NULL;
	FmFileActionType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->action;
	_tmp1_ = _tmp0_->type;
	result = _tmp1_ == FM_FILE_ACTION_TYPE_MENU;
	return result;
}


gboolean fm_file_action_item_is_action (FmFileActionItem* self) {
	gboolean result = FALSE;
	FmFileActionObject* _tmp0_ = NULL;
	FmFileActionType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->action;
	_tmp1_ = _tmp0_->type;
	result = _tmp1_ == FM_FILE_ACTION_TYPE_ACTION;
	return result;
}


gboolean fm_file_action_item_launch (FmFileActionItem* self, GAppLaunchContext* ctx, GList* files, gchar** output) {
	gchar* _vala_output = NULL;
	gboolean result = FALSE;
	FmFileActionObject* _tmp0_ = NULL;
	FmFileActionType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->action;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == FM_FILE_ACTION_TYPE_ACTION) {
		FmFileActionProfile* _tmp2_ = NULL;
		_tmp2_ = self->profile;
		if (_tmp2_ != NULL) {
			FmFileActionProfile* _tmp3_ = NULL;
			GAppLaunchContext* _tmp4_ = NULL;
			GList* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp3_ = self->profile;
			_tmp4_ = ctx;
			_tmp5_ = files;
			fm_file_action_profile_launch (_tmp3_, _tmp4_, _tmp5_, &_tmp6_);
			_g_free0 (_vala_output);
			_vala_output = _tmp6_;
		}
		result = TRUE;
		if (output) {
			*output = _vala_output;
		} else {
			_g_free0 (_vala_output);
		}
		return result;
	}
	result = FALSE;
	if (output) {
		*output = _vala_output;
	} else {
		_g_free0 (_vala_output);
	}
	return result;
}


GList* fm_file_action_item_get_sub_items (FmFileActionItem* self) {
	GList* result = NULL;
	gboolean _tmp0_ = FALSE;
	FmFileActionObject* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->action;
	if (_tmp1_ != NULL) {
		FmFileActionObject* _tmp2_ = NULL;
		FmFileActionType _tmp3_ = 0;
		_tmp2_ = self->action;
		_tmp3_ = _tmp2_->type;
		_tmp0_ = _tmp3_ == FM_FILE_ACTION_TYPE_MENU;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp4_ = NULL;
		_tmp4_ = self->children;
		result = _tmp4_;
		return result;
	}
	result = NULL;
	return result;
}


static void fm_value_file_action_item_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fm_value_file_action_item_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fm_file_action_item_unref (value->data[0].v_pointer);
	}
}


static void fm_value_file_action_item_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fm_file_action_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fm_value_file_action_item_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fm_value_file_action_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FmFileActionItem* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fm_file_action_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fm_value_file_action_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FmFileActionItem** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fm_file_action_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fm_param_spec_file_action_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FmParamSpecFileActionItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FM_TYPE_FILE_ACTION_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fm_value_get_file_action_item (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FM_TYPE_FILE_ACTION_ITEM), NULL);
	return value->data[0].v_pointer;
}


void fm_value_set_file_action_item (GValue* value, gpointer v_object) {
	FmFileActionItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FM_TYPE_FILE_ACTION_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FM_TYPE_FILE_ACTION_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fm_file_action_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fm_file_action_item_unref (old);
	}
}


void fm_value_take_file_action_item (GValue* value, gpointer v_object) {
	FmFileActionItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FM_TYPE_FILE_ACTION_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FM_TYPE_FILE_ACTION_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fm_file_action_item_unref (old);
	}
}


static void fm_file_action_item_class_init (FmFileActionItemClass * klass) {
	fm_file_action_item_parent_class = g_type_class_peek_parent (klass);
	((FmFileActionItemClass *) klass)->finalize = fm_file_action_item_finalize;
}


static void fm_file_action_item_instance_init (FmFileActionItem * self) {
	self->ref_count = 1;
}


static void fm_file_action_item_finalize (FmFileActionItem* obj) {
	FmFileActionItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION_ITEM, FmFileActionItem);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->desc);
	_g_free0 (self->icon);
	_g_object_unref0 (self->action);
	__g_list_free__fm_file_action_item_unref0_0 (self->children);
}


GType fm_file_action_item_get_type (void) {
	static volatile gsize fm_file_action_item_type_id__volatile = 0;
	if (g_once_init_enter (&fm_file_action_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fm_value_file_action_item_init, fm_value_file_action_item_free_value, fm_value_file_action_item_copy_value, fm_value_file_action_item_peek_pointer, "p", fm_value_file_action_item_collect_value, "p", fm_value_file_action_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FmFileActionItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileActionItem), 0, (GInstanceInitFunc) fm_file_action_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fm_file_action_item_type_id;
		fm_file_action_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FmFileActionItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fm_file_action_item_type_id__volatile, fm_file_action_item_type_id);
	}
	return fm_file_action_item_type_id__volatile;
}


gpointer fm_file_action_item_ref (gpointer instance) {
	FmFileActionItem* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fm_file_action_item_unref (gpointer instance) {
	FmFileActionItem* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FM_FILE_ACTION_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void fm_load_actions_from_dir (const gchar* dirname, const gchar* id_prefix) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	{
		GDir* dir = NULL;
		const gchar* _tmp0_ = NULL;
		GDir* _tmp1_ = NULL;
		GDir* _tmp2_ = NULL;
		_tmp0_ = dirname;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		dir = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = dir;
		if (_tmp2_ != NULL) {
			const gchar* name = NULL;
			GKeyFile* kf = NULL;
			GKeyFile* _tmp3_ = NULL;
			_tmp3_ = g_key_file_new ();
			kf = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					GDir* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					gchar* full_path = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					if (!_tmp4_) {
					}
					_tmp4_ = FALSE;
					_tmp5_ = dir;
					_tmp6_ = g_dir_read_name (_tmp5_);
					name = _tmp6_;
					_tmp7_ = name;
					if (_tmp7_ == NULL) {
						break;
					}
					_tmp8_ = dirname;
					_tmp9_ = name;
					_tmp10_ = g_build_filename (_tmp8_, _tmp9_, NULL);
					full_path = _tmp10_;
					_tmp11_ = full_path;
					_tmp12_ = g_file_test (_tmp11_, G_FILE_TEST_IS_DIR);
					if (_tmp12_) {
						gchar* _tmp13_ = NULL;
						const gchar* _tmp14_ = NULL;
						const gchar* _tmp22_ = NULL;
						_tmp14_ = id_prefix;
						if (_tmp14_ != NULL) {
							const gchar* _tmp15_ = NULL;
							const gchar* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
							const gchar* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							_tmp15_ = id_prefix;
							_tmp16_ = string_to_string (_tmp15_);
							_tmp17_ = name;
							_tmp18_ = string_to_string (_tmp17_);
							_tmp19_ = g_strconcat (_tmp16_, "-", _tmp18_, NULL);
							_g_free0 (_tmp13_);
							_tmp13_ = _tmp19_;
						} else {
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							_tmp20_ = name;
							_tmp21_ = g_strdup (_tmp20_);
							_g_free0 (_tmp13_);
							_tmp13_ = _tmp21_;
						}
						_tmp22_ = full_path;
						fm_load_actions_from_dir (_tmp22_, _tmp13_);
						_g_free0 (_tmp13_);
					} else {
						const gchar* _tmp23_ = NULL;
						gboolean _tmp24_ = FALSE;
						_tmp23_ = name;
						_tmp24_ = g_str_has_suffix (_tmp23_, ".desktop");
						if (_tmp24_) {
							gchar* _tmp25_ = NULL;
							const gchar* _tmp26_ = NULL;
							gchar* id = NULL;
							gchar* _tmp34_ = NULL;
							GHashTable* _tmp35_ = NULL;
							const gchar* _tmp36_ = NULL;
							gconstpointer _tmp37_ = NULL;
							_tmp26_ = id_prefix;
							if (_tmp26_ != NULL) {
								const gchar* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
								const gchar* _tmp29_ = NULL;
								const gchar* _tmp30_ = NULL;
								gchar* _tmp31_ = NULL;
								_tmp27_ = id_prefix;
								_tmp28_ = string_to_string (_tmp27_);
								_tmp29_ = name;
								_tmp30_ = string_to_string (_tmp29_);
								_tmp31_ = g_strconcat (_tmp28_, "-", _tmp30_, NULL);
								_g_free0 (_tmp25_);
								_tmp25_ = _tmp31_;
							} else {
								const gchar* _tmp32_ = NULL;
								gchar* _tmp33_ = NULL;
								_tmp32_ = name;
								_tmp33_ = g_strdup (_tmp32_);
								_g_free0 (_tmp25_);
								_tmp25_ = _tmp33_;
							}
							_tmp34_ = g_strdup (_tmp25_);
							id = _tmp34_;
							_tmp35_ = fm_all_actions;
							_tmp36_ = id;
							_tmp37_ = g_hash_table_lookup (_tmp35_, _tmp36_);
							if (((FmFileActionObject*) _tmp37_) == NULL) {
								gboolean _tmp38_ = FALSE;
								GKeyFile* _tmp39_ = NULL;
								const gchar* _tmp40_ = NULL;
								gboolean _tmp41_ = FALSE;
								_tmp39_ = kf;
								_tmp40_ = full_path;
								_tmp41_ = g_key_file_load_from_file (_tmp39_, _tmp40_, 0, &_inner_error_);
								_tmp38_ = _tmp41_;
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									_g_free0 (id);
									_g_free0 (_tmp25_);
									_g_free0 (full_path);
									_g_key_file_free0 (kf);
									_g_dir_close0 (dir);
									if (_inner_error_->domain == G_FILE_ERROR) {
										goto __catch2_g_file_error;
									}
									goto __finally2;
								}
								if (_tmp38_) {
									gchar* type = NULL;
									GKeyFile* _tmp42_ = NULL;
									gchar* _tmp43_ = NULL;
									FmFileActionObject* action = NULL;
									gboolean _tmp44_ = FALSE;
									const gchar* _tmp45_ = NULL;
									FmFileActionObject* _tmp52_ = NULL;
									const gchar* _tmp53_ = NULL;
									gchar* _tmp54_ = NULL;
									GHashTable* _tmp55_ = NULL;
									const gchar* _tmp56_ = NULL;
									gchar* _tmp57_ = NULL;
									FmFileActionObject* _tmp58_ = NULL;
									FmFileActionObject* _tmp59_ = NULL;
									_tmp42_ = kf;
									_tmp43_ = utils_key_file_get_string (_tmp42_, "Desktop Entry", "Type", NULL);
									type = _tmp43_;
									action = NULL;
									_tmp45_ = type;
									if (_tmp45_ == NULL) {
										_tmp44_ = TRUE;
									} else {
										const gchar* _tmp46_ = NULL;
										_tmp46_ = type;
										_tmp44_ = g_strcmp0 (_tmp46_, "Action") == 0;
									}
									if (_tmp44_) {
										GKeyFile* _tmp47_ = NULL;
										FmFileAction* _tmp48_ = NULL;
										_tmp47_ = kf;
										_tmp48_ = fm_file_action_new_from_keyfile (_tmp47_);
										_g_object_unref0 (action);
										action = (FmFileActionObject*) _tmp48_;
									} else {
										const gchar* _tmp49_ = NULL;
										_tmp49_ = type;
										if (g_strcmp0 (_tmp49_, "Menu") == 0) {
											GKeyFile* _tmp50_ = NULL;
											FmFileActionMenu* _tmp51_ = NULL;
											_tmp50_ = kf;
											_tmp51_ = fm_file_action_menu_new_from_keyfile (_tmp50_);
											_g_object_unref0 (action);
											action = (FmFileActionObject*) _tmp51_;
										} else {
											_g_object_unref0 (action);
											_g_free0 (type);
											_g_free0 (id);
											_g_free0 (_tmp25_);
											_g_free0 (full_path);
											continue;
										}
									}
									_tmp52_ = action;
									_tmp53_ = id;
									_tmp54_ = g_strdup (_tmp53_);
									_g_free0 (_tmp52_->id);
									_tmp52_->id = _tmp54_;
									_tmp55_ = fm_all_actions;
									_tmp56_ = id;
									_tmp57_ = g_strdup (_tmp56_);
									_tmp58_ = action;
									_tmp59_ = _g_object_ref0 (_tmp58_);
									g_hash_table_insert (_tmp55_, _tmp57_, _tmp59_);
									_g_object_unref0 (action);
									_g_free0 (type);
								}
							} else {
							}
							_g_free0 (id);
							_g_free0 (_tmp25_);
						}
					}
					_g_free0 (full_path);
				}
			}
			_g_key_file_free0 (kf);
		}
		_g_dir_close0 (dir);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GList* fm_get_actions_for_files (GList* files) {
	GList* result = NULL;
	gboolean _tmp0_ = FALSE;
	GHashTableIter action_it = {0};
	GHashTable* _tmp1_ = NULL;
	FmFileActionObject* action_obj = NULL;
	GList* items = NULL;
	GHashTable* _tmp13_ = NULL;
	GHashTable* _tmp25_ = NULL;
	_tmp0_ = fm_actions_loaded;
	if (!_tmp0_) {
		fm_load_all_actions ();
	}
	_tmp1_ = fm_all_actions;
	g_hash_table_iter_init (&action_it, _tmp1_);
	action_obj = NULL;
	while (TRUE) {
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		FmFileActionObject* _tmp4_ = NULL;
		FmFileActionObject* _tmp5_ = NULL;
		FmFileActionType _tmp6_ = 0;
		_tmp3_ = g_hash_table_iter_next (&action_it, (gpointer*) NULL, (gpointer*) (&_tmp2_));
		_g_object_unref0 (action_obj);
		_tmp4_ = _g_object_ref0 (_tmp2_);
		action_obj = _tmp4_;
		if (!_tmp3_) {
			break;
		}
		_tmp5_ = action_obj;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == FM_FILE_ACTION_TYPE_MENU) {
			FmFileActionMenu* menu = NULL;
			FmFileActionObject* _tmp7_ = NULL;
			FmFileActionMenu* _tmp8_ = NULL;
			FmFileActionMenu* _tmp9_ = NULL;
			GList* _tmp10_ = NULL;
			FmFileActionMenu* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			_tmp7_ = action_obj;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu));
			menu = _tmp8_;
			_tmp9_ = menu;
			_tmp10_ = files;
			_tmp11_ = menu;
			_tmp12_ = _tmp11_->items_list;
			_tmp12__length1 = _tmp11_->items_list_length1;
			fm_file_action_menu_cache_children (_tmp9_, _tmp10_, _tmp12_, _tmp12__length1);
			_g_object_unref0 (menu);
		}
	}
	items = NULL;
	_tmp13_ = fm_all_actions;
	g_hash_table_iter_init (&action_it, _tmp13_);
	_g_object_unref0 (action_obj);
	action_obj = NULL;
	while (TRUE) {
		gconstpointer _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		FmFileActionObject* _tmp16_ = NULL;
		FmFileActionObject* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp15_ = g_hash_table_iter_next (&action_it, (gpointer*) NULL, (gpointer*) (&_tmp14_));
		_g_object_unref0 (action_obj);
		_tmp16_ = _g_object_ref0 (_tmp14_);
		action_obj = _tmp16_;
		if (!_tmp15_) {
			break;
		}
		_tmp17_ = action_obj;
		_tmp18_ = _tmp17_->has_parent;
		if (_tmp18_ == FALSE) {
			FmFileActionItem* item = NULL;
			FmFileActionObject* _tmp19_ = NULL;
			GList* _tmp20_ = NULL;
			FmFileActionItem* _tmp21_ = NULL;
			FmFileActionItem* _tmp22_ = NULL;
			_tmp19_ = action_obj;
			_tmp20_ = files;
			_tmp21_ = fm_file_action_item_new_for_action_object (_tmp19_, _tmp20_);
			item = _tmp21_;
			_tmp22_ = item;
			if (_tmp22_ != NULL) {
				FmFileActionItem* _tmp23_ = NULL;
				FmFileActionItem* _tmp24_ = NULL;
				_tmp23_ = item;
				_tmp24_ = _fm_file_action_item_ref0 (_tmp23_);
				items = g_list_append (items, _tmp24_);
			}
			_fm_file_action_item_unref0 (item);
		}
	}
	_tmp25_ = fm_all_actions;
	g_hash_table_iter_init (&action_it, _tmp25_);
	_g_object_unref0 (action_obj);
	action_obj = NULL;
	while (TRUE) {
		gconstpointer _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		FmFileActionObject* _tmp28_ = NULL;
		FmFileActionObject* _tmp29_ = NULL;
		FmFileActionObject* _tmp30_ = NULL;
		FmFileActionType _tmp31_ = 0;
		_tmp27_ = g_hash_table_iter_next (&action_it, (gpointer*) NULL, (gpointer*) (&_tmp26_));
		_g_object_unref0 (action_obj);
		_tmp28_ = _g_object_ref0 (_tmp26_);
		action_obj = _tmp28_;
		if (!_tmp27_) {
			break;
		}
		_tmp29_ = action_obj;
		_tmp29_->has_parent = FALSE;
		_tmp30_ = action_obj;
		_tmp31_ = _tmp30_->type;
		if (_tmp31_ == FM_FILE_ACTION_TYPE_MENU) {
			FmFileActionMenu* menu = NULL;
			FmFileActionObject* _tmp32_ = NULL;
			FmFileActionMenu* _tmp33_ = NULL;
			FmFileActionMenu* _tmp34_ = NULL;
			_tmp32_ = action_obj;
			_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu));
			menu = _tmp33_;
			_tmp34_ = menu;
			__g_list_free__g_object_unref0_0 (_tmp34_->cached_children);
			_tmp34_->cached_children = NULL;
			_g_object_unref0 (menu);
		}
	}
	result = items;
	_g_object_unref0 (action_obj);
	return result;
}


void fm_load_all_actions (void) {
	GHashTable* _tmp0_ = NULL;
	gchar** dirs = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint dirs_length1 = 0;
	gint _dirs_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	_tmp0_ = fm_all_actions;
	g_hash_table_remove_all (_tmp0_);
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	dirs = _tmp2_;
	dirs_length1 = _vala_array_length (_tmp1_);
	_dirs_size_ = dirs_length1;
	_tmp3_ = dirs;
	_tmp3__length1 = dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp3_;
		dir_collection_length1 = _tmp3__length1;
		for (dir_it = 0; dir_it < _tmp3__length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				_tmp4_ = dir;
				_tmp5_ = g_build_filename (_tmp4_, "file-manager/actions", NULL);
				_tmp6_ = _tmp5_;
				fm_load_actions_from_dir (_tmp6_, NULL);
				_g_free0 (_tmp6_);
			}
		}
	}
	_tmp7_ = g_get_user_data_dir ();
	_tmp8_ = g_build_filename (_tmp7_, "file-manager/actions", NULL);
	_tmp9_ = _tmp8_;
	fm_load_actions_from_dir (_tmp9_, NULL);
	_g_free0 (_tmp9_);
	fm_actions_loaded = TRUE;
}


void fm_file_actions_set_desktop_env (const gchar* env) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (env != NULL);
	_tmp0_ = env;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (fm_desktop_env);
	fm_desktop_env = _tmp1_;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void _fm_file_actions_init (void) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (fm_all_actions);
	fm_all_actions = _tmp2_;
}


void _fm_file_actions_finalize (void) {
	_g_hash_table_unref0 (fm_all_actions);
	fm_all_actions = NULL;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



