// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// RUN: %clang_cc1 -triple riscv64 -emit-llvm %s -o - | FileCheck %s
// RUN: %clang_cc1 -triple riscv64 -target-feature +f -target-abi lp64f -emit-llvm %s -o - \
// RUN:     | FileCheck %s
// RUN: %clang_cc1 -triple riscv64 -target-feature +d -target-feature +f -target-abi lp64d -emit-llvm %s -o - \
// RUN:     | FileCheck %s
// RUN: %clang_cc1 -triple riscv64 -target-abi lp64e -emit-llvm %s -o - \
// RUN:     | FileCheck %s

#include <stddef.h>
#include <stdint.h>

struct tiny {
  uint16_t a, b, c, d;
};

struct small {
  int64_t a, *b;
};

struct small_aligned {
  __int128_t a;
};

struct large {
  int64_t a, b, c, d;
};

// Ensure that ABI lowering happens as expected for vararg calls.
// Specifically, ensure that signext is emitted for varargs that will be
// passed in registers but not on the stack. Ensure this takes into account
// the use of "aligned" register pairs for varargs with 2*xlen alignment.

int f_va_callee(int, ...);

// CHECK-LABEL: define dso_local void @f_va_caller
// CHECK-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL:%.*]] = alloca [[STRUCT_TINY:%.*]], align 2
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL1:%.*]] = alloca [[STRUCT_SMALL:%.*]], align 8
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL4:%.*]] = alloca [[STRUCT_SMALL_ALIGNED:%.*]], align 16
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL6:%.*]] = alloca [[STRUCT_LARGE:%.*]], align 8
// CHECK-NEXT:    [[BYVAL_TEMP:%.*]] = alloca [[STRUCT_LARGE]], align 8
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL12:%.*]] = alloca [[STRUCT_SMALL_ALIGNED]], align 16
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL16:%.*]] = alloca [[STRUCT_SMALL]], align 8
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL21:%.*]] = alloca [[STRUCT_SMALL_ALIGNED]], align 16
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL25:%.*]] = alloca [[STRUCT_SMALL]], align 8
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL30:%.*]] = alloca [[STRUCT_SMALL_ALIGNED]], align 16
// CHECK-NEXT:    [[DOTCOMPOUNDLITERAL34:%.*]] = alloca [[STRUCT_SMALL]], align 8
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_TINY]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 0
// CHECK-NEXT:    store i16 6, ptr [[A]], align 2
// CHECK-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_TINY]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 1
// CHECK-NEXT:    store i16 7, ptr [[B]], align 2
// CHECK-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_TINY]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 2
// CHECK-NEXT:    store i16 8, ptr [[C]], align 2
// CHECK-NEXT:    [[D:%.*]] = getelementptr inbounds [[STRUCT_TINY]], ptr [[DOTCOMPOUNDLITERAL]], i32 0, i32 3
// CHECK-NEXT:    store i16 9, ptr [[D]], align 2
// CHECK-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL1]], i32 0, i32 0
// CHECK-NEXT:    store i64 10, ptr [[A2]], align 8
// CHECK-NEXT:    [[B3:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL1]], i32 0, i32 1
// CHECK-NEXT:    store ptr null, ptr [[B3]], align 8
// CHECK-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL4]], i32 0, i32 0
// CHECK-NEXT:    store i128 11, ptr [[A5]], align 16
// CHECK-NEXT:    [[A7:%.*]] = getelementptr inbounds [[STRUCT_LARGE]], ptr [[DOTCOMPOUNDLITERAL6]], i32 0, i32 0
// CHECK-NEXT:    store i64 12, ptr [[A7]], align 8
// CHECK-NEXT:    [[B8:%.*]] = getelementptr inbounds [[STRUCT_LARGE]], ptr [[DOTCOMPOUNDLITERAL6]], i32 0, i32 1
// CHECK-NEXT:    store i64 13, ptr [[B8]], align 8
// CHECK-NEXT:    [[C9:%.*]] = getelementptr inbounds [[STRUCT_LARGE]], ptr [[DOTCOMPOUNDLITERAL6]], i32 0, i32 2
// CHECK-NEXT:    store i64 14, ptr [[C9]], align 8
// CHECK-NEXT:    [[D10:%.*]] = getelementptr inbounds [[STRUCT_LARGE]], ptr [[DOTCOMPOUNDLITERAL6]], i32 0, i32 3
// CHECK-NEXT:    store i64 15, ptr [[D10]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[DOTCOMPOUNDLITERAL]], align 2
// CHECK-NEXT:    [[TMP1:%.*]] = load [2 x i64], ptr [[DOTCOMPOUNDLITERAL1]], align 8
// CHECK-NEXT:    [[COERCE_DIVE:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL4]], i32 0, i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = load i128, ptr [[COERCE_DIVE]], align 16
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[BYVAL_TEMP]], ptr align 8 [[DOTCOMPOUNDLITERAL6]], i64 32, i1 false)
// CHECK-NEXT:    [[CALL:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i64 noundef 3, double noundef 4.000000e+00, double noundef 5.000000e+00, i64 [[TMP0]], [2 x i64] [[TMP1]], i128 [[TMP2]], ptr noundef [[BYVAL_TEMP]])
// CHECK-NEXT:    [[CALL11:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, fp128 noundef 0xL00000000000000004001400000000000, i32 noundef signext 6, i32 noundef signext 7, i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[A13:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL12]], i32 0, i32 0
// CHECK-NEXT:    store i128 5, ptr [[A13]], align 16
// CHECK-NEXT:    [[COERCE_DIVE14:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL12]], i32 0, i32 0
// CHECK-NEXT:    [[TMP3:%.*]] = load i128, ptr [[COERCE_DIVE14]], align 16
// CHECK-NEXT:    [[CALL15:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, i128 [[TMP3]], i32 noundef signext 6, i32 noundef signext 7, i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[A17:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL16]], i32 0, i32 0
// CHECK-NEXT:    store i64 5, ptr [[A17]], align 8
// CHECK-NEXT:    [[B18:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL16]], i32 0, i32 1
// CHECK-NEXT:    store ptr null, ptr [[B18]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load [2 x i64], ptr [[DOTCOMPOUNDLITERAL16]], align 8
// CHECK-NEXT:    [[CALL19:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, [2 x i64] [[TMP4]], i32 noundef signext 6, i32 noundef signext 7, i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[CALL20:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, i32 noundef signext 5, fp128 noundef 0xL00000000000000004001800000000000, i32 noundef signext 7, i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[A22:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL21]], i32 0, i32 0
// CHECK-NEXT:    store i128 6, ptr [[A22]], align 16
// CHECK-NEXT:    [[COERCE_DIVE23:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL21]], i32 0, i32 0
// CHECK-NEXT:    [[TMP5:%.*]] = load i128, ptr [[COERCE_DIVE23]], align 16
// CHECK-NEXT:    [[CALL24:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, i32 noundef signext 5, i128 [[TMP5]], i32 noundef signext 7, i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[A26:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL25]], i32 0, i32 0
// CHECK-NEXT:    store i64 6, ptr [[A26]], align 8
// CHECK-NEXT:    [[B27:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL25]], i32 0, i32 1
// CHECK-NEXT:    store ptr null, ptr [[B27]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load [2 x i64], ptr [[DOTCOMPOUNDLITERAL25]], align 8
// CHECK-NEXT:    [[CALL28:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, i32 noundef signext 5, [2 x i64] [[TMP6]], i32 noundef signext 7, i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[CALL29:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, i32 noundef signext 5, i32 noundef signext 6, fp128 noundef 0xL00000000000000004001C00000000000, i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[A31:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL30]], i32 0, i32 0
// CHECK-NEXT:    store i128 7, ptr [[A31]], align 16
// CHECK-NEXT:    [[COERCE_DIVE32:%.*]] = getelementptr inbounds [[STRUCT_SMALL_ALIGNED]], ptr [[DOTCOMPOUNDLITERAL30]], i32 0, i32 0
// CHECK-NEXT:    [[TMP7:%.*]] = load i128, ptr [[COERCE_DIVE32]], align 16
// CHECK-NEXT:    [[CALL33:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, i32 noundef signext 5, i32 noundef signext 6, i128 [[TMP7]], i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    [[A35:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL34]], i32 0, i32 0
// CHECK-NEXT:    store i64 7, ptr [[A35]], align 8
// CHECK-NEXT:    [[B36:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[DOTCOMPOUNDLITERAL34]], i32 0, i32 1
// CHECK-NEXT:    store ptr null, ptr [[B36]], align 8
// CHECK-NEXT:    [[TMP8:%.*]] = load [2 x i64], ptr [[DOTCOMPOUNDLITERAL34]], align 8
// CHECK-NEXT:    [[CALL37:%.*]] = call signext i32 (i32, ...) @f_va_callee(i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3, i32 noundef signext 4, i32 noundef signext 5, i32 noundef signext 6, [2 x i64] [[TMP8]], i32 noundef signext 8, i32 noundef signext 9)
// CHECK-NEXT:    ret void
//
void f_va_caller(void) {
  f_va_callee(1, 2, 3LL, 4.0f, 5.0, (struct tiny){6, 7, 8, 9},
              (struct small){10, NULL}, (struct small_aligned){11},
              (struct large){12, 13, 14, 15});
  f_va_callee(1, 2, 3, 4, 5.0L, 6, 7, 8, 9);
  f_va_callee(1, 2, 3, 4, (struct small_aligned){5}, 6, 7, 8, 9);
  f_va_callee(1, 2, 3, 4, (struct small){5, NULL}, 6, 7, 8, 9);
  f_va_callee(1, 2, 3, 4, 5, 6.0L, 7, 8, 9);
  f_va_callee(1, 2, 3, 4, 5, (struct small_aligned){6}, 7, 8, 9);
  f_va_callee(1, 2, 3, 4, 5, (struct small){6, NULL}, 7, 8, 9);
  f_va_callee(1, 2, 3, 4, 5, 6, 7.0L, 8, 9);
  f_va_callee(1, 2, 3, 4, 5, 6, (struct small_aligned){7}, 8, 9);
  f_va_callee(1, 2, 3, 4, 5, 6, (struct small){7, NULL}, 8, 9);
}

// CHECK-LABEL: define dso_local signext i32 @f_va_1
// CHECK-SAME: (ptr noundef [[FMT:%.*]], ...) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[FMT_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VA:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[V:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[FMT]], ptr [[FMT_ADDR]], align 8
// CHECK-NEXT:    call void @llvm.va_start(ptr [[VA]])
// CHECK-NEXT:    [[ARGP_CUR:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[ARGP_NEXT:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR]], i64 8
// CHECK-NEXT:    store ptr [[ARGP_NEXT]], ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARGP_CUR]], align 8
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[V]], align 4
// CHECK-NEXT:    call void @llvm.va_end(ptr [[VA]])
// CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[V]], align 4
// CHECK-NEXT:    ret i32 [[TMP1]]
//
int f_va_1(char *fmt, ...) {
  __builtin_va_list va;

  __builtin_va_start(va, fmt);
  int v = __builtin_va_arg(va, int);
  __builtin_va_end(va);

  return v;
}

// An "aligned" register pair (where the first register is even-numbered) is
// used to pass varargs with 2x xlen alignment and 2x xlen size. Ensure the
// correct offsets are used.

// CHECK-LABEL: define dso_local fp128 @f_va_2
// CHECK-SAME: (ptr noundef [[FMT:%.*]], ...) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[FMT_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VA:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[V:%.*]] = alloca fp128, align 16
// CHECK-NEXT:    store ptr [[FMT]], ptr [[FMT_ADDR]], align 8
// CHECK-NEXT:    call void @llvm.va_start(ptr [[VA]])
// CHECK-NEXT:    [[ARGP_CUR:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR]], i32 15
// CHECK-NEXT:    [[ARGP_CUR_ALIGNED:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[TMP0]], i64 -16)
// CHECK-NEXT:    [[ARGP_NEXT:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR_ALIGNED]], i64 16
// CHECK-NEXT:    store ptr [[ARGP_NEXT]], ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load fp128, ptr [[ARGP_CUR_ALIGNED]], align 16
// CHECK-NEXT:    store fp128 [[TMP1]], ptr [[V]], align 16
// CHECK-NEXT:    call void @llvm.va_end(ptr [[VA]])
// CHECK-NEXT:    [[TMP2:%.*]] = load fp128, ptr [[V]], align 16
// CHECK-NEXT:    ret fp128 [[TMP2]]
//
long double f_va_2(char *fmt, ...) {
  __builtin_va_list va;

  __builtin_va_start(va, fmt);
  long double v = __builtin_va_arg(va, long double);
  __builtin_va_end(va);

  return v;
}

// Two "aligned" register pairs.

// CHECK-LABEL: define dso_local fp128 @f_va_3
// CHECK-SAME: (ptr noundef [[FMT:%.*]], ...) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[FMT_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VA:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[V:%.*]] = alloca fp128, align 16
// CHECK-NEXT:    [[W:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[X:%.*]] = alloca fp128, align 16
// CHECK-NEXT:    store ptr [[FMT]], ptr [[FMT_ADDR]], align 8
// CHECK-NEXT:    call void @llvm.va_start(ptr [[VA]])
// CHECK-NEXT:    [[ARGP_CUR:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR]], i32 15
// CHECK-NEXT:    [[ARGP_CUR_ALIGNED:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[TMP0]], i64 -16)
// CHECK-NEXT:    [[ARGP_NEXT:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR_ALIGNED]], i64 16
// CHECK-NEXT:    store ptr [[ARGP_NEXT]], ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load fp128, ptr [[ARGP_CUR_ALIGNED]], align 16
// CHECK-NEXT:    store fp128 [[TMP1]], ptr [[V]], align 16
// CHECK-NEXT:    [[ARGP_CUR1:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[ARGP_NEXT2:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR1]], i64 8
// CHECK-NEXT:    store ptr [[ARGP_NEXT2]], ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[ARGP_CUR1]], align 8
// CHECK-NEXT:    store i32 [[TMP2]], ptr [[W]], align 4
// CHECK-NEXT:    [[ARGP_CUR3:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR3]], i32 15
// CHECK-NEXT:    [[ARGP_CUR3_ALIGNED:%.*]] = call ptr @llvm.ptrmask.p0.i64(ptr [[TMP3]], i64 -16)
// CHECK-NEXT:    [[ARGP_NEXT4:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR3_ALIGNED]], i64 16
// CHECK-NEXT:    store ptr [[ARGP_NEXT4]], ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load fp128, ptr [[ARGP_CUR3_ALIGNED]], align 16
// CHECK-NEXT:    store fp128 [[TMP4]], ptr [[X]], align 16
// CHECK-NEXT:    call void @llvm.va_end(ptr [[VA]])
// CHECK-NEXT:    [[TMP5:%.*]] = load fp128, ptr [[V]], align 16
// CHECK-NEXT:    [[TMP6:%.*]] = load fp128, ptr [[X]], align 16
// CHECK-NEXT:    [[ADD:%.*]] = fadd fp128 [[TMP5]], [[TMP6]]
// CHECK-NEXT:    ret fp128 [[ADD]]
//
long double f_va_3(char *fmt, ...) {
  __builtin_va_list va;

  __builtin_va_start(va, fmt);
  long double v = __builtin_va_arg(va, long double);
  int w = __builtin_va_arg(va, int);
  long double x = __builtin_va_arg(va, long double);
  __builtin_va_end(va);

  return v + x;
}

// CHECK-LABEL: define dso_local signext i32 @f_va_4
// CHECK-SAME: (ptr noundef [[FMT:%.*]], ...) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[FMT_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VA:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[V:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[TS:%.*]] = alloca [[STRUCT_TINY:%.*]], align 2
// CHECK-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SMALL:%.*]], align 8
// CHECK-NEXT:    [[LS:%.*]] = alloca [[STRUCT_LARGE:%.*]], align 8
// CHECK-NEXT:    [[RET:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[FMT]], ptr [[FMT_ADDR]], align 8
// CHECK-NEXT:    call void @llvm.va_start(ptr [[VA]])
// CHECK-NEXT:    [[ARGP_CUR:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[ARGP_NEXT:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR]], i64 8
// CHECK-NEXT:    store ptr [[ARGP_NEXT]], ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARGP_CUR]], align 8
// CHECK-NEXT:    store i32 [[TMP0]], ptr [[V]], align 4
// CHECK-NEXT:    [[ARGP_CUR1:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[ARGP_NEXT2:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR1]], i64 8
// CHECK-NEXT:    store ptr [[ARGP_NEXT2]], ptr [[VA]], align 8
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 2 [[TS]], ptr align 8 [[ARGP_CUR1]], i64 8, i1 false)
// CHECK-NEXT:    [[ARGP_CUR3:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[ARGP_NEXT4:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR3]], i64 16
// CHECK-NEXT:    store ptr [[ARGP_NEXT4]], ptr [[VA]], align 8
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[SS]], ptr align 8 [[ARGP_CUR3]], i64 16, i1 false)
// CHECK-NEXT:    [[ARGP_CUR5:%.*]] = load ptr, ptr [[VA]], align 8
// CHECK-NEXT:    [[ARGP_NEXT6:%.*]] = getelementptr inbounds i8, ptr [[ARGP_CUR5]], i64 8
// CHECK-NEXT:    store ptr [[ARGP_NEXT6]], ptr [[VA]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[ARGP_CUR5]], align 8
// CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[LS]], ptr align 8 [[TMP1]], i64 32, i1 false)
// CHECK-NEXT:    call void @llvm.va_end(ptr [[VA]])
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_TINY]], ptr [[TS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr [[A]], align 2
// CHECK-NEXT:    [[CONV:%.*]] = zext i16 [[TMP2]] to i64
// CHECK-NEXT:    [[A7:%.*]] = getelementptr inbounds [[STRUCT_SMALL]], ptr [[SS]], i32 0, i32 0
// CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[A7]], align 8
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i64 [[CONV]], [[TMP3]]
// CHECK-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_LARGE]], ptr [[LS]], i32 0, i32 2
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr [[C]], align 8
// CHECK-NEXT:    [[ADD8:%.*]] = add nsw i64 [[ADD]], [[TMP4]]
// CHECK-NEXT:    [[CONV9:%.*]] = trunc i64 [[ADD8]] to i32
// CHECK-NEXT:    store i32 [[CONV9]], ptr [[RET]], align 4
// CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[RET]], align 4
// CHECK-NEXT:    ret i32 [[TMP5]]
//
int f_va_4(char *fmt, ...) {
  __builtin_va_list va;

  __builtin_va_start(va, fmt);
  int v = __builtin_va_arg(va, int);
  struct tiny ts = __builtin_va_arg(va, struct tiny);
  struct small ss = __builtin_va_arg(va, struct small);
  struct large ls = __builtin_va_arg(va, struct large);
  __builtin_va_end(va);

  int ret = ts.a + ss.a + ls.c;

  return ret;
}
