/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef CONNECTIONCONTROLLER_H
#define CONNECTIONCONTROLLER_H

#include <QWidget>
#include <QPixmap>
#include <QApplication>
#include <QDesktopWidget>
#include <QSettings>
#include <QFile>
#include "auth/auth_server.h"
#include "../../../commons/cd/change_dir.h"
#include "../../../commons/logger.h"
#include "file_manager_server.h"
#include "../shell/exec_thread.h"
#include "../xml/xml_creator_server.h"
#include "../xml/xml_parser_server.h"

class ConnectionController : public QObject
{
    Q_OBJECT

public:
    ConnectionController(QObject *parent = 0);
    int start_server(QString password, QString ip, int port, int f_port);
    void stop_server();
    void stop_shell_thread();

public slots:
    void received_stream_slot(QString message, int client_nbr);
    void tcp_state(int state, int client_nbr);
    void auth_succeeded_slots(int client_nbr);
    void tell_client_transfer_state_slot(int state, int client_nbr);
    void tell_client_command_result(const QString & str, const QString & client_nbr);
    void master_client_error_slot(int client_nbr);
    void file_client_error_slot(int client_nbr);

private slots:

signals:
    void received_stream_signal(QString message);
    void signals_state(int state, int client_nbr);
    void auth_succeeded(int client_nbr);

private:
    void shootScreen();
    QPixmap screenshotPixmap;
    QString path;
    QString slash;
    auth_server *master_server;
    auth_server *file_server;
    XmlCreatorServer *xml_creator;
    FileManagerServer *file_manager;
    Exec *exec;
    QSettings *settings;
    Logger *m_logger;
};

#endif
