require File.expand_path('../../../spec_helper', __FILE__)
require File.expand_path('../fixtures/classes', __FILE__)
require File.expand_path('../shared/iteration', __FILE__)

ruby_version_is "1.9" do
  describe "Hash#keep_if" do
    it "yields two arguments: key and value" do
      all_args = []
      new_hash(1 => 2, 3 => 4).keep_if { |*args| all_args << args }
      all_args.should == [[1, 2], [3, 4]]
    end

    it "keeps every entry for which block is true and returns self" do
      h = new_hash(:a => 1, :b => 2, :c => 3, :d => 4)
      h.keep_if { |k,v| v % 2 == 0 }.should equal(h)
      h.should == new_hash(:b => 2, :d => 4)
    end

    it "returns self even if unmodified" do
      h = new_hash(1 => 2, 3 => 4)
      h.keep_if { true }.should equal(h)
    end

    it "raises an RuntimeError if called on a frozen instance" do
      lambda { HashSpecs.frozen_hash.keep_if { true } }.should raise_error(RuntimeError)
      lambda { HashSpecs.empty_frozen_hash.keep_if { false } }.should raise_error(RuntimeError)
    end

    it_behaves_like(:hash_iteration_no_block, :keep_if)
  end
end
