<?php

//    index.php
//    Home page
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: index.php,v 1.22 2004/05/26 09:38:56 angusgb Exp $

include ("./include/global.inc.php");

//
// Show Summary function
// Declaration for PHP3 compatibility
// 

function ShowSummary($dbname, $strSQL, $strHeader)
{
	global $MyDB;
?>

<div class="header">
<h4><?php echo $strHeader; ?></h4>
</div>

<div class="content">
<?php

$result = $MyDB->CreateHTMLTable($strSQL, $dbname, true);

if ($result<0)
{
   DisplayErrMsg($MyDB->errmsg);
   return;
}
else if (!result):
?>
<p><?php echo $strNoOccurrencies; ?></p>
<?php
endif;
?>
</div>
<?php
}

if (!empty($dbname))
{
   $pagetitle = "Database: $dbname";
   $linkbar = "<a href=\"index.php\">" . $strMainPage . "</a>";
   $linkbar = $linkbar . " | " .
      "<a href=\"drop.php?dbname=" . $dbname . "\">" . $strDBDeletion . "</a>";
}
else
{
   $pagetitle = $strMainPage;
   $linkbar="";
}

?>
<?php include ("./include/header.inc.php"); ?>

<!-- Check the presence of any ht://Check databases -->
<?php

if (empty($dbname))
{
   // No database selected

   if (!is_array($dblist) || ! $numdbs=count($dblist))
   {
      if ($MyDB->GetHtCheckDBList())
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }

      // Redirect the dinamically created list to the managed one
      $dblist = $MyDB->HtDBs;

      // Set the number of databases
      $numdbs = count ($dblist);

   }

   if ($numdbs)
   {
      if ($numdbs == 1)
         $dbname = $dblist[0];
      else
      {
         // At least one database found
         eval ("\$strNumDBs=\"$strNumDBs\";");
      
?>
<h3><?php echo $strNumDBs; ?></h3>

<?php echo $strChooseaDB; ?>:<br>
<form>
   <select name="dbname">
<?php
         for ($i = 0; $i < $numdbs; $i++)
         {
?>
      <option><?php echo $dblist[$i]; ?></option>
<?php
         }
?>
   </select>
   <input type="submit" value="<?php echo $strSelectaDB; ?>">
</form>

<?php
      }
   }
   else
   {
      // No database found
      eval ("\$strNoDBs=\"$strNoDBs\";");
?>
<h3><?php echo $strNoDBs; ?></h3>
<?php
   }
}

if (! empty($dbname) )
{
   // A database has been selected

   eval ("\$strDBSelected=\"$strDBSelected\";");
?>
<?php echo $strDBSelected; ?><br>

<div class="header">
<h3><?php echo $strGeneralInfo; ?>:</h3>
</div>

<div class="content">
<?php

   $strSQL = "Select * from htCheck";

   // Get general info from htCheck table

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

      $row = $MyDB->FetchArray();
?>

<?php echo $strUser; ?>: <strong><?php echo $row["User"]; ?></strong><br>
<?php echo $strStartTime; ?>: <strong><?php echo $row["StartTime"]; ?></strong><br>
<?php echo $strEndTime; ?>: <strong><?php echo $row["EndTime"]; ?></strong><br>

<?php

   }
   
   $MyDB->Free();


   $result=$MyDB->GetGeneralInfo($dbname);

   if ($result<0)
   {
      DisplayErrMsg($MyDB->errmsg);
      return;
   }
   else
   {
?>

<?php echo $strServersEncountered; ?>: <strong><?php echo number_format($MyDB->Info["Server"]); ?></strong><br>
<?php echo $strScheduledURLS; ?>: <strong><?php echo number_format($MyDB->Info["Schedule"]); ?></strong><br>

<?php echo $strRetrievedURLS; ?>: <strong><?php echo number_format($MyDB->Info["Url"]); ?></strong><br>
<?php echo $strHTMLStatements; ?>: <strong><?php echo number_format($MyDB->Info["HtmlStatement"]); ?></strong>
   (<?php echo $strHTMLAttributes; ?>: <strong><?php echo number_format($MyDB->Info["HtmlAttribute"]); ?></strong>)<br>
<?php echo $strLinks; ?>: <strong><?php echo number_format($MyDB->Info["Link"]); ?></strong><br>
</div>

<div class="header">
<h3><?php echo $strOperations; ?>:</h3>
</div>

<div class="content">
<ul>
<li><a href="qryurls.php?dbname=<?php echo $dbname; ?>"><?php echo $strShowListUrlsFltr; ?></a></li>
<li><a href="listlinks.php?dbname=<?php echo $dbname; ?>"><?php echo $strShowListLinks; ?></a></li>
<li><a href="listurls.php?dbname=<?php echo $dbname; ?>&all=1"><?php echo $strShowListUrls; ?></a></li>
<li><a href="qryachecks.php?dbname=<?php echo $dbname; ?>"><?php echo $strShowListAchecks; ?></a></li>
</ul>
</div>

<?php

   // HTTP results

   $strSQL = "Select StatusCode as '". $strStatusCode . "', ReasonPhrase as '"
      . $strReasonPhrase ."',"
      . " count(*) as '". $strNumber . "' from Url group by StatusCode, ReasonPhrase";

   ShowSummary($dbname, $strSQL, $strHTTPRequestsResults);

   // Servers seen

   $strSQL = "Select Server, Port, HttpServer as '"
      . $strWebServerInfo . "', HttpVersion as '" . $strProtocol . "',"
      . " Requests as '" . $strRequests . "' from Server where Requests > 1"
      . " order by Requests DESC";
   
   ShowSummary($dbname, $strSQL, $strServersSeenOrdIDServer);

   // Connection results

   $strSQL = "Select ConnStatus as '". $strConnectionStatus . "',"
      . " count(*) as 'Num.' from Url group by ConnStatus";
   
   ShowSummary($dbname, $strSQL, $strConnectionResults);

   // Content-Type results

   $strSQL = "Select ContentType as 'Content Type',"
      . " count(*) as '". $strNumber . "' from Url group by ContentType";
   
   ShowSummary($dbname, $strSQL, $strContentTypeResults);

   // Cookies

   $strSQL = "SELECT Name, Value, Path, Domain, SrcUrl as '$strUrl' from Cookies";
   
   ShowSummary($dbname, $strSQL, $strCookiesReport);
   }
}

?>

<br>

<?php include ("./include/footer.inc.php"); ?>
