% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printL.r
\name{printL}
\alias{printL}
\title{printL}
\usage{
printL(..., dec = NULL, maxoneline = 5)
}
\arguments{
\item{...}{any number of objects to \code{print()}}

\item{dec}{optional decimal places to the right of the decimal point for rounding}

\item{maxoneline}{controls how many elements may be printed on a single line for \code{vector} objects}
}
\value{
nothing
}
\description{
Print an object or a named list of objects.  When multiple objects are given, their names are printed before their contents.  When an object is a vector that is not longer than \code{maxoneline} and its elements are not named, all the elements will be printed on one line separated by commas.  When \code{dec} is given, numeric vectors or numeric columns of data frames or data tables are rounded to the nearest \code{dec} before printing.  This function is especially helpful when printing objects in a Quarto or RMarkdown document and the code is not currently being shown to place the output in context.
}
\examples{
w <- pi + 1 : 2
printL(w=w)
printL(w, dec=3)
printL('this is it'=c(pi, pi, 1, 2),
       yyy=pi,
       z=data.frame(x=pi+1:2, y=3:4, z=c('a', 'b')),
       qq=1:10,
       dec=4)
       
}
\seealso{
\code{\link[=prn]{prn()}}
}
\author{
Frank Harrell
}
