

#include "multiselecttool.h"

#include <QMouseEvent>
#include <QKeyEvent>


// multiSelect::multiSelect(QDialog * ){
multiSelect::multiSelect(QWidget * )
	:QDialog()
{
	canUseKRegExpEditor=false;
	setupUi(this);
	setWindowTitle(windowTitle()+" - GwenRename");
	readHistory();
}


// multiSelect::multiSelect(QDialog *, iconload * ic ){
multiSelect::multiSelect(QWidget *, iconload * ic )
	:QDialog()
{
	canUseKRegExpEditor=false;
	setupUi(this);
	
	regExpDialog=0L;	
	if ( !KServiceTypeTrader::self()->query("KRegExpEditor/KRegExpEditor").isEmpty() ) {
		//qWarning("The editor is available, so lets use it.");
		connect( editRegExp, SIGNAL(clicked()), this, SLOT( slotEditRegExp() ) );
		canUseKRegExpEditor=true;
	}else{
		canUseKRegExpEditor=false;
		editRegExp->setEnabled(false);
	}
	
	
	setWindowTitle(windowTitle()+" - GwenRename");
	readHistory();
	txtSelect->setEditText("");
	numOfHistoryItems=txtSelect->count();
// 	txtSelect->setSizeLimit(HISTORY_ITEMS); old impl
	txtSelect->setMaxVisibleItems(HISTORY_ITEMS);
	
	lblIcon->setPixmap(ic->Icon(9));
	editRegExp->setIcon(KIcon(ic->Icon(5)));
	buttonOk->setIcon(KIcon(ic->Icon(6)));
	buttonCancel->setIcon(KIcon(ic->Icon(7)));
	buttonHelp->setIcon(KIcon(ic->Icon(16)));
}

multiSelect::~multiSelect(){

}


// FIX ME!!!
// When kregexp is available
void multiSelect::slotEditRegExp(){
	//qWarning("multiSelTool::slotEditRegExp - starting");
	if ( ! regExpDialog ){
		//qWarning("multiSelTool::slotEditRegExp - ! regExpDialog");
// 		regExpDialog = KParts::ComponentFactory::createInstanceFromQuery<QDialog>( "KRegExpEditor/KRegExpEditor" ); old impl
    regExpDialog = KServiceTypeTrader::createInstanceFromQuery<QDialog>( "KRegExpEditor/KRegExpEditor", QString(), this );
		
		//qWarning("multiSelTool::slotEditRegExp - ! regExpDialog - ok ");
	}
	if ( ! regExpDialog )
		return;
	//qWarning("multiSelTool::slotEditRegExp - KRegExpEditorInterface");
// 	KRegExpEditorInterface *iface = static_cast<KRegExpEditorInterface *>( regExpDialog->qt_cast( "KRegExpEditorInterface" ) ); old impl
  KRegExpEditorInterface *iface = qobject_cast<KRegExpEditorInterface *>( regExpDialog );
	//qWarning("multiSelTool::slotEditRegExp - KRegExpEditorInterface - ok");
	if ( !iface )
		return;
	//qWarning("multiSelTool::slotEditRegExp - iface->setRegExp( txtSelect->text() )");
	iface->setRegExp( txtSelect->currentText() );
	//qWarning("multiSelTool::slotEditRegExp - iface->setRegExp( txtSelect->text() ) - ok");
	//qWarning("multiSelTool::slotEditRegExp - regExpDialog->exec()");
	bool ok = regExpDialog->exec();
	//qWarning("multiSelTool::slotEditRegExp - regExpDialog->exec() - ok");
	if ( ok ){
		//qWarning("multiSelTool::slotEditRegExp - txtSelect->setText( iface->regExp() )");
// 		txtSelect->setCurrentText( iface->regExp() ); old impl
		txtSelect->setEditText( iface->regExp() );
		//qWarning("multiSelTool::slotEditRegExp - txtSelect->setText( iface->regExp() ) - ok");
	}
}


void multiSelect::buttonOkClicked(){
	int found=-1;
	QString searchTerm=txtSelect->currentText();
	for(int i=0;i<HISTORY_ITEMS;i++)
// 		if(txtSelect->text(i)==searchTerm){ old impl
		if(txtSelect->itemText(i)==searchTerm){
// 			qWarning("i=%d, found text = %s",i,searchTerm.latin1());
			found=i;
			break;
		}
	if(found==-1){
		numOfHistoryItems++;
// 		txtSelect->insertItem(searchTerm,0); old impl
		txtSelect->insertItems(0,QStringList(searchTerm));
// 		qWarning("writing current text = %s",searchTerm.latin1());
		writeHistory();
	}else{
		if(found!=0){
			txtSelect->removeItem(found);
// 			txtSelect->insertItem(searchTerm,0); old impl
			txtSelect->insertItems(0,QStringList(searchTerm));
// 			qWarning("writing current text = %s",searchTerm.latin1());
			writeHistory();
		}
	}
// 	txtSelect->setCurrentText(searchTerm); old impl
	txtSelect->setEditText(searchTerm);
//  	qWarning("going back");
	accept();
}


void multiSelect::readHistory(){
	QString tmp;
	QString group;
	QStringList t;
	KConfig config("gwenrenamerc");
// 	config.setGroup("SelectionHistory"); old impl
	KConfigGroup grp=config.group("SelectionHistory");
	for(int i=HISTORY_ITEMS-1;i>=0;i--){
		group=QString("Exp%1").arg(i);
// 		tmp=config.readEntry(group,QString::null); old impl
		tmp=grp.readEntry(group,"");
		if(!tmp.isEmpty())
// 			txtSelect->insertItem(tmp,0); old impl
			t<<tmp;
	}
	if (!t.isEmpty()) txtSelect->insertItems(0,t);
}


void multiSelect::writeHistory(){
	QString group;
	KConfig config("gwenrenamerc");
// 	config.setGroup("SelectionHistory"); old impl
	KConfigGroup grp=config.group("SelectionHistory");
	for(int i=0;i<HISTORY_ITEMS;i++){
		group=QString("Exp%1").arg(i);
// 		config.deleteEntry(group); old impl
		grp.deleteEntry(group);
		if(i<numOfHistoryItems)
// 			config.writeEntry(group,txtSelect->text(i)); old impl
// 			grp.writeEntry(group,txtSelect->text(i)); old impl
			grp.writeEntry(group,txtSelect->itemText(i));
	}
}


void multiSelect::keyPressEvent( QKeyEvent *e ){
	e->accept();
// 	if(e->key()==Qt::Key_F1 && e->state()==Qt::NoButton) old impl
	if(e->key()==Qt::Key_F1 && e->modifiers()==Qt::NoButton)
		showHelp();
// 	else if(e->key()==Qt::Key_Escape && e->state()==Qt::NoButton) old impl
	else if(e->key()==Qt::Key_Escape && e->modifiers()==Qt::NoButton)
		reject();
}


void multiSelect::showHelp(){
	KRun::runCommand(QString("khelpcenter \"help:/gwenrename/search-window.html\""),this);
}


void multiSelect::reaxPart( bool state ){
if(state && canUseKRegExpEditor)
	editRegExp->setEnabled(true);
else
	editRegExp->setEnabled(false);
}


void multiSelect::changeLabel( bool state ){
	if(state)
		chkAdd->setText(i18n("Remove from current selection"));
	else
		chkAdd->setText(i18n("Add to current selection"));
}



void multiSelect::resizeEvent ( QResizeEvent *e ){
	setMaximumSize(width(), height());
	e->ignore();
}






#include "multiselecttool.moc"