'''OpenGL extension NV.shader_buffer_store

This module customises the behaviour of the 
OpenGL.raw.GL.NV.shader_buffer_store to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension builds upon the mechanisms added by the
	NV_shader_buffer_load extension to allow shaders to perform random-access
	reads to buffer object memory without using dedicated buffer object
	binding points.  Instead, it allowed an application to make a buffer
	object resident, query a GPU address (pointer) for the buffer object, and
	then use that address as a pointer in shader code.  This approach allows
	shaders to access a large number of buffer objects without needing to
	repeatedly bind buffers to a limited number of fixed-functionality binding
	points.
	
	This extension lifts the restriction from NV_shader_buffer_load that
	disallows writes.  In particular, the MakeBufferResidentNV function now
	allows READ_WRITE and WRITE_ONLY access modes, and the shading language is
	extended to allow shaders to write through (GPU address) pointers.
	Additionally, the extension provides built-in functions to perform atomic
	memory transactions to buffer object memory.
	
	As with the shader writes provided by the EXT_shader_image_load_store
	extension, writes to buffer object memory using this extension are weakly
	ordered to allow for parallel or distributed shader execution.  The
	EXT_shader_image_load_store extension provides mechanisms allowing for
	finer control of memory transaction order, and those mechanisms apply
	equally to buffer object stores using this extension.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/shader_buffer_store.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.NV.shader_buffer_store import *
from OpenGL.raw.GL.NV.shader_buffer_store import _EXTENSION_NAME

def glInitShaderBufferStoreNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION