/*
 * Decompiled with CFR 0.152.
 */
package thredds.viewer.gis.shapefile;

import java.io.InputStream;
import javax.swing.ImageIcon;
import thredds.ui.BAMutil;
import thredds.viewer.gis.MapBean;
import thredds.viewer.gis.shapefile.EsriShapefileRenderer;
import thredds.viewer.ui.Renderer;
import ucar.nc2.ui.util.Resource;
import ucar.util.prefs.ui.Debug;

public class ShapeFileBean
extends MapBean {
    private String name;
    private String desc;
    private String iconName;
    private String shapefileName;
    private Renderer rend = null;

    public ShapeFileBean(String name, String desc, String iconName, String shapefileName) {
        this.name = name;
        this.desc = desc;
        this.iconName = iconName;
        this.shapefileName = shapefileName;
    }

    public Renderer getRenderer() {
        if (this.rend == null) {
            this.fetchMap();
        }
        return this.rend;
    }

    private void fetchMap() {
        long startTime = System.currentTimeMillis();
        InputStream is = Resource.getFileResource(this.shapefileName);
        if (is == null) {
            System.err.println("ShapeFileBean read failed on resource " + this.shapefileName);
        } else {
            this.rend = EsriShapefileRenderer.factory(this.shapefileName, is);
        }
        if (Debug.isSet("timing.readShapefile")) {
            long tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.readShapefile: " + (double)tookTime * 0.001 + " seconds");
        }
    }

    public ImageIcon getIcon() {
        return BAMutil.getIcon(this.iconName, true);
    }

    public String getActionName() {
        return this.name;
    }

    public String getActionDesc() {
        return this.desc;
    }
}

