/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class OpenlabRawReader
extends FormatReader {
    protected int[] offsets;
    private int bytesPerPixel;

    public OpenlabRawReader() {
        super("Openlab RAW", "raw");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 79 && block[1] == 76 && block[2] == 82 && block[3] == 87;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.in.seek(this.offsets[no / this.core.sizeC[0]] + 288);
        this.in.read(buf);
        if (this.bytesPerPixel == 1) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("OpenlabRawReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying Openlab RAW format");
        byte[] header = new byte[4];
        this.in.read(header);
        String check = new String(header);
        if (!check.equals("OLRW")) {
            throw new FormatException("Openlab RAW magic string not found.");
        }
        this.status("Populating metadata");
        int version = this.in.readInt();
        this.addMeta("Version", new Integer(version));
        this.core.imageCount[0] = this.in.readInt();
        this.offsets = new int[this.core.imageCount[0]];
        this.offsets[0] = 12;
        this.in.readLong();
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.in.read();
        this.core.sizeC[0] = this.in.read();
        this.bytesPerPixel = this.in.read();
        this.in.read();
        long stamp = this.in.readLong();
        Date timestamp = null;
        SimpleDateFormat sdf = null;
        if (stamp > 0L) {
            stamp /= 1000000L;
            stamp = (long)((double)stamp - 2.1143592E9);
            timestamp = new Date(stamp);
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.addMeta("Timestamp", sdf.format(timestamp));
        }
        this.in.skipBytes(4);
        byte[] s = new byte[256];
        this.in.read(s);
        int len = s[0] > 0 ? s[0] : s[0] + 256;
        this.addMeta("Image name", new String(s, 1, len).trim());
        this.core.sizeC[0] = this.core.sizeC[0] <= 1 ? 1 : 3;
        this.addMeta("Width", new Integer(this.core.sizeX[0]));
        this.addMeta("Height", new Integer(this.core.sizeY[0]));
        this.addMeta("Bytes per pixel", new Integer(this.bytesPerPixel));
        int plane = this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel;
        for (int i = 1; i < this.core.imageCount[0]; ++i) {
            this.offsets[i] = this.offsets[i - 1] + 288 + plane;
        }
        this.core.sizeZ[0] = this.core.imageCount[0];
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYZTC";
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = false;
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        switch (this.bytesPerPixel) {
            case 1: 
            case 3: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 2: {
                this.core.pixelType[0] = 3;
                break;
            }
            default: {
                this.core.pixelType[0] = 6;
            }
        }
        store.setImage((String)this.getMeta("Image name"), timestamp == null ? null : sdf.format(timestamp), null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

