# 🛠️ &amp; 🔁 / ⌛

ℹ 🔃 `async def` ❕ *➡ 🛠️ 🔢* &amp; 🖥 🔃 🔁 📟, 🛠️, &amp; 🔁.

## 🏃 ❓

<abbr title="too long; didn't read"><strong>🆑;👩‍⚕️:</strong></abbr>

🚥 👆 ⚙️ 🥉 🥳 🗃 👈 💬 👆 🤙 👫 ⏮️ `await`, 💖:

```Python
results = await some_library()
```

⤴️, 📣 👆 *➡ 🛠️ 🔢* ⏮️ `async def` 💖:

```Python hl_lines="2"
@app.get('/')
async def read_results():
    results = await some_library()
    return results
```

!!! note
    👆 💪 🕴 ⚙️ `await` 🔘 🔢 ✍ ⏮️ `async def`.

---

🚥 👆 ⚙️ 🥉 🥳 🗃 👈 🔗 ⏮️ 🕳 (💽, 🛠️, 📁 ⚙️, ♒️.) &amp; 🚫 ✔️ 🐕‍🦺 ⚙️ `await`, (👉 ⏳ 💼 🌅 💽 🗃), ⤴️ 📣 👆 *➡ 🛠️ 🔢* 🛎, ⏮️ `def`, 💖:

```Python hl_lines="2"
@app.get('/')
def results():
    results = some_library()
    return results
```

---

🚥 👆 🈸 (😫) 🚫 ✔️ 🔗 ⏮️ 🕳 🙆 &amp; ⌛ ⚫️ 📨, ⚙️ `async def`.

---

🚥 👆 🚫 💭, ⚙️ 😐 `def`.

---

**🗒**: 👆 💪 🌀 `def` &amp; `async def` 👆 *➡ 🛠️ 🔢* 🌅 👆 💪 &amp; 🔬 🔠 1️⃣ ⚙️ 🏆 🎛 👆. FastAPI 🔜 ▶️️ 👜 ⏮️ 👫.

😆, 🙆 💼 🔛, FastAPI 🔜 👷 🔁 &amp; 📶 ⏩.

✋️ 📄 📶 🔛, ⚫️ 🔜 💪 🎭 🛠️.

## 📡 ℹ

🏛 ⏬ 🐍 ✔️ 🐕‍🦺 **"🔁 📟"** ⚙️ 🕳 🤙 **"🔁"**, ⏮️ **`async` &amp; `await`** ❕.

➡️ 👀 👈 🔤 🍕 📄 🔛:

* **🔁 📟**
* **`async` &amp; `await`**
* **🔁**

## 🔁 📟

🔁 📟 ⛓ 👈 🇪🇸 👶 ✔️ 🌌 💬 💻 / 📋 👶 👈 ☝ 📟, ⚫️ 👶 🔜 ✔️ ⌛ *🕳 🙆* 🏁 👱 🙆. ➡️ 💬 👈 *🕳 🙆* 🤙 "🐌-📁" 👶.

, ⏮️ 👈 🕰, 💻 💪 🚶 &amp; 🎏 👷, ⏪ "🐌-📁" 👶 🏁.

⤴️ 💻 / 📋 👶 🔜 👟 🔙 🔠 🕰 ⚫️ ✔️ 🤞 ↩️ ⚫️ ⌛ 🔄, ⚖️ 🕐❔ ⚫️ 👶 🏁 🌐 👷 ⚫️ ✔️ 👈 ☝. &amp; ⚫️ 👶 🔜 👀 🚥 🙆 📋 ⚫️ ⌛ ✔️ ⏪ 🏁, 🤸 ⚫️❔ ⚫️ ✔️.

⏭, ⚫️ 👶 ✊ 🥇 📋 🏁 (➡️ 💬, 👆 "🐌-📁" 👶) &amp; 😣 ⚫️❔ ⚫️ ✔️ ⏮️ ⚫️.

👈 "⌛ 🕳 🙆" 🛎 🔗 <abbr title="Input and Output">👤/🅾</abbr> 🛠️ 👈 📶 "🐌" (🔬 🚅 🕹 &amp; 💾 💾), 💖 ⌛:

* 📊 ⚪️➡️ 👩‍💻 📨 🔘 🕸
* 📊 📨 👆 📋 📨 👩‍💻 🔘 🕸
* 🎚 📁 💾 ✍ ⚙️ &amp; 🤝 👆 📋
* 🎚 👆 📋 🤝 ⚙️ ✍ 💾
* 🛰 🛠️ 🛠️
* 💽 🛠️ 🏁
* 💽 🔢 📨 🏁
* ♒️.

🛠️ 🕰 🍴 ✴️ ⌛ <abbr title="Input and Output">👤/🅾</abbr> 🛠️, 👫 🤙 👫 "👤/🅾 🔗" 🛠️.

⚫️ 🤙 "🔁" ↩️ 💻 / 📋 🚫 ✔️ "🔁" ⏮️ 🐌 📋, ⌛ ☑ 🙍 👈 📋 🏁, ⏪ 🔨 🕳, 💪 ✊ 📋 🏁 &amp; 😣 👷.

↩️ 👈, 💆‍♂ "🔁" ⚙️, 🕐 🏁, 📋 💪 ⌛ ⏸ 🐥 👄 (⏲) 💻 / 📋 🏁 ⚫️❔ ⚫️ 🚶, &amp; ⤴️ 👟 🔙 ✊ 🏁 &amp; 😣 👷 ⏮️ 👫.

"🔁" (👽 "🔁") 👫 🛎 ⚙️ ⚖ "🔁", ↩️ 💻 / 📋 ⏩ 🌐 📶 🔁 ⏭ 🔀 🎏 📋, 🚥 👈 🔁 🔌 ⌛.

### 🛠️ &amp; 🍔

👉 💭 **🔁** 📟 🔬 🔛 🕣 🤙 **"🛠️"**. ⚫️ 🎏 ⚪️➡️ **"🔁"**.

**🛠️** &amp; **🔁** 👯‍♂️ 🔗 "🎏 👜 😥 🌅 ⚖️ 🌘 🎏 🕰".

✋️ ℹ 🖖 *🛠️* &amp; *🔁* 🎏.

👀 🔺, 🌈 📄 📖 🔃 🍔:

### 🛠️ 🍔

👆 🚶 ⏮️ 👆 🥰 🤚 ⏩ 🥕, 👆 🧍 ⏸ ⏪ 🏧 ✊ ✔ ⚪️➡️ 👫👫 🚪 👆. 👶

<img src="/img/async/concurrent-burgers/concurrent-burgers-01.png" class="illustration">

⤴️ ⚫️ 👆 🔄, 👆 🥉 👆 ✔ 2️⃣ 📶 🎀 🍔 👆 🥰 &amp; 👆. 👶 👶

<img src="/img/async/concurrent-burgers/concurrent-burgers-02.png" class="illustration">

🏧 💬 🕳 🍳 👨‍🍳 👫 💭 👫 ✔️ 🏗 👆 🍔 (✋️ 👫 ⏳ 🏗 🕐 ⏮️ 👩‍💻).

<img src="/img/async/concurrent-burgers/concurrent-burgers-03.png" class="illustration">

👆 💸. 👶

🏧 🤝 👆 🔢 👆 🔄.

<img src="/img/async/concurrent-burgers/concurrent-burgers-04.png" class="illustration">

⏪ 👆 ⌛, 👆 🚶 ⏮️ 👆 🥰 &amp; ⚒ 🏓, 👆 🧎 &amp; 💬 ⏮️ 👆 🥰 📏 🕰 (👆 🍔 📶 🎀 &amp; ✊ 🕰 🏗).

👆 🏖 🏓 ⏮️ 👆 🥰, ⏪ 👆 ⌛ 🍔, 👆 💪 💸 👈 🕰 😮 ❔ 👌, 🐨 &amp; 🙃 👆 🥰 👶 👶 👶.

<img src="/img/async/concurrent-burgers/concurrent-burgers-05.png" class="illustration">

⏪ ⌛ &amp; 💬 👆 🥰, ⚪️➡️ 🕰 🕰, 👆 ✅ 🔢 🖥 🔛 ⏲ 👀 🚥 ⚫️ 👆 🔄 ⏪.

⤴️ ☝, ⚫️ 😒 👆 🔄. 👆 🚶 ⏲, 🤚 👆 🍔 &amp; 👟 🔙 🏓.

<img src="/img/async/concurrent-burgers/concurrent-burgers-06.png" class="illustration">

👆 &amp; 👆 🥰 🍴 🍔 &amp; ✔️ 👌 🕰. 👶

<img src="/img/async/concurrent-burgers/concurrent-burgers-07.png" class="illustration">

!!! info
    🌹 🖼 <a href="https://www.instagram.com/ketrinadrawsalot" class="external-link" target="_blank">👯 🍏</a>. 👶

---

🌈 👆 💻 / 📋 👶 👈 📖.

⏪ 👆 ⏸, 👆 ⛽ 👶, ⌛ 👆 🔄, 🚫 🔨 🕳 📶 "😌". ✋️ ⏸ ⏩ ↩️ 🏧 🕴 ✊ ✔ (🚫 🏗 👫), 👈 👌.

⤴️, 🕐❔ ⚫️ 👆 🔄, 👆 ☑ "😌" 👷, 👆 🛠️ 🍣, 💭 ⚫️❔ 👆 💚, 🤚 👆 🥰 ⚒, 💸, ✅ 👈 👆 🤝 ☑ 💵 ⚖️ 💳, ✅ 👈 👆 🈚 ☑, ✅ 👈 ✔ ✔️ ☑ 🏬, ♒️.

✋️ ⤴️, ✋️ 👆 🚫 ✔️ 👆 🍔, 👆 👷 ⏮️ 🏧 "🔛 ⏸" ⏸, ↩️ 👆 ✔️ ⌛ 👶 👆 🍔 🔜.

✋️ 👆 🚶 ↖️ ⚪️➡️ ⏲ &amp; 🧎 🏓 ⏮️ 🔢 👆 🔄, 👆 💪 🎛 👶 👆 🙋 👆 🥰, &amp; "👷" 👶 👶 🔛 👈. ⤴️ 👆 🔄 🔨 🕳 📶 "😌" 😏 ⏮️ 👆 🥰 👶.

⤴️ 🏧 👶 💬 "👤 🏁 ⏮️ 🔨 🍔" 🚮 👆 🔢 🔛 ⏲ 🖥, ✋️ 👆 🚫 🦘 💖 😜 ⏪ 🕐❔ 🖥 🔢 🔀 👆 🔄 🔢. 👆 💭 🙅‍♂ 1️⃣ 🔜 📎 👆 🍔 ↩️ 👆 ✔️ 🔢 👆 🔄, &amp; 👫 ✔️ 👫.

👆 ⌛ 👆 🥰 🏁 📖 (🏁 ⏮️ 👷 👶 / 📋 ➖ 🛠️ 👶), 😀 🖐 &amp; 💬 👈 👆 🔜 🍔 ⏸.

⤴️ 👆 🚶 ⏲ 👶, ▶️ 📋 👈 🔜 🏁 👶, ⚒ 🍔, 💬 👏 &amp; ✊ 👫 🏓. 👈 🏁 👈 🔁 / 📋 🔗 ⏮️ ⏲ ⏹. 👈 🔄, ✍ 🆕 📋, "🍴 🍔" 👶 👶, ✋️ ⏮️ 1️⃣ "🤚 🍔" 🏁 ⏹.

### 🔗 🍔

🔜 ➡️ 🌈 👫 ➖🚫 🚫 "🛠️ 🍔", ✋️ "🔗 🍔".

👆 🚶 ⏮️ 👆 🥰 🤚 🔗 ⏩ 🥕.

👆 🧍 ⏸ ⏪ 📚 (➡️ 💬 8️⃣) 🏧 👈 🎏 🕰 🍳 ✊ ✔ ⚪️➡️ 👫👫 🚪 👆.

👱 ⏭ 👆 ⌛ 👫 🍔 🔜 ⏭ 🍂 ⏲ ↩️ 🔠 8️⃣ 🏧 🚶 &amp; 🏗 🍔 ▶️️ ↖️ ⏭ 💆‍♂ ⏭ ✔.

<img src="/img/async/parallel-burgers/parallel-burgers-01.png" class="illustration">

⤴️ ⚫️ 😒 👆 🔄, 👆 🥉 👆 ✔ 2️⃣ 📶 🎀 🍔 👆 🥰 &amp; 👆.

👆 💸 👶.

<img src="/img/async/parallel-burgers/parallel-burgers-02.png" class="illustration">

🏧 🚶 👨‍🍳.

👆 ⌛, 🧍 🚪 ⏲ 👶, 👈 🙅‍♂ 1️⃣ 🙆 ✊ 👆 🍔 ⏭ 👆, 📤 🙅‍♂ 🔢 🔄.

<img src="/img/async/parallel-burgers/parallel-burgers-03.png" class="illustration">

👆 &amp; 👆 🥰 😩 🚫 ➡️ 🙆 🤚 🚪 👆 &amp; ✊ 👆 🍔 🕐❔ 👫 🛬, 👆 🚫🔜 💸 🙋 👆 🥰. 👶

👉 "🔁" 👷, 👆 "🔁" ⏮️ 🏧/🍳 👶 👶. 👆 ✔️ ⌛ 👶 &amp; 📤 ☑ 🙍 👈 🏧/🍳 👶 👶 🏁 🍔 &amp; 🤝 👫 👆, ⚖️ ⏪, 👱 🙆 💪 ✊ 👫.

<img src="/img/async/parallel-burgers/parallel-burgers-04.png" class="illustration">

⤴️ 👆 🏧/🍳 👶 👶 😒 👟 🔙 ⏮️ 👆 🍔, ⏮️ 📏 🕰 ⌛ 👶 📤 🚪 ⏲.

<img src="/img/async/parallel-burgers/parallel-burgers-05.png" class="illustration">

👆 ✊ 👆 🍔 &amp; 🚶 🏓 ⏮️ 👆 🥰.

👆 🍴 👫, &amp; 👆 🔨. ⏹

<img src="/img/async/parallel-burgers/parallel-burgers-06.png" class="illustration">

📤 🚫 🌅 💬 ⚖️ 😏 🌅 🕰 💸 ⌛ 👶 🚪 ⏲. 👶

!!! info
    🌹 🖼 <a href="https://www.instagram.com/ketrinadrawsalot" class="external-link" target="_blank">👯 🍏</a>. 👶

---

👉 😐 🔗 🍔, 👆 💻 / 📋 👶 ⏮️ 2️⃣ 🕹 (👆 &amp; 👆 🥰), 👯‍♂️ ⌛ 👶 &amp; 💡 👫 🙋 👶 "⌛ 🔛 ⏲" 👶 📏 🕰.

⏩ 🥕 🏪 ✔️ 8️⃣ 🕹 (🏧/🍳). ⏪ 🛠️ 🍔 🏪 💪 ✔️ ✔️ 🕴 2️⃣ (1️⃣ 🏧 &amp; 1️⃣ 🍳).

✋️, 🏁 💡 🚫 🏆. 👶

---

👉 🔜 🔗 🌓 📖 🍔. 👶

🌅 "🎰 👨‍❤‍👨" 🖼 👉, 🌈 🏦.

🆙 ⏳, 🏆 🏦 ✔️ 💗 🏧 👶 👶 👶 👶 👶 👶 👶 👶 &amp; 🦏 ⏸ 👶 👶 👶 👶 👶 👶 👶 👶.

🌐 🏧 🔨 🌐 👷 ⏮️ 1️⃣ 👩‍💻 ⏮️ 🎏 👶 👶 👶.

&amp; 👆 ✔️ ⌛ 👶 ⏸ 📏 🕰 ⚖️ 👆 💸 👆 🔄.

👆 🎲 🚫🔜 💚 ✊ 👆 🥰 👶 ⏮️ 👆 👷 🏦 👶.

### 🍔 🏁

👉 😐 "⏩ 🥕 🍔 ⏮️ 👆 🥰", 📤 📚 ⌛ 👶, ⚫️ ⚒ 📚 🌅 🔑 ✔️ 🛠️ ⚙️ ⏸ 👶 👶.

👉 💼 🌅 🕸 🈸.

📚, 📚 👩‍💻, ✋️ 👆 💽 ⌛ 👶 👫 🚫--👍 🔗 📨 👫 📨.

&amp; ⤴️ ⌛ 👶 🔄 📨 👟 🔙.

👉 "⌛" 👶 ⚖ ⏲, ✋️, ⚖ ⚫️ 🌐, ⚫️ 📚 ⌛ 🔚.

👈 ⚫️❔ ⚫️ ⚒ 📚 🔑 ⚙️ 🔁 ⏸ 👶 👶 📟 🕸 🔗.

👉 😇 🔀 ⚫️❔ ⚒ ✳ 🌟 (✋️ ✳ 🚫 🔗) &amp; 👈 💪 🚶 🛠️ 🇪🇸.

&amp; 👈 🎏 🎚 🎭 👆 🤚 ⏮️ **FastAPI**.

&amp; 👆 💪 ✔️ 🔁 &amp; 🔀 🎏 🕰, 👆 🤚 ↕ 🎭 🌘 🌅 💯 ✳ 🛠️ &amp; 🔛 🇷🇪 ⏮️ 🚶, ❔ ✍ 🇪🇸 🔐 🅱 <a href="https://www.techempower.com/benchmarks/#section=data-r17&hw=ph&test=query&l=zijmkf-1" class="external-link" target="_blank">(🌐 👏 💃)</a>.

### 🛠️ 👍 🌘 🔁 ❓

😆 ❗ 👈 🚫 🛐 📖.

🛠️ 🎏 🌘 🔁. &amp; ⚫️ 👻 🔛 **🎯** 😐 👈 🔌 📚 ⌛. ↩️ 👈, ⚫️ 🛎 📚 👍 🌘 🔁 🕸 🈸 🛠️. ✋️ 🚫 🌐.

, ⚖ 👈 👅, 🌈 📄 📏 📖:

&gt; 👆 ✔️ 🧹 🦏, 💩 🏠.

*😆, 👈 🎂 📖*.

---

📤 🙅‍♂ ⌛ 👶 🙆, 📚 👷 🔨, 🔛 💗 🥉 🏠.

👆 💪 ✔️ 🔄 🍔 🖼, 🥇 🏠 🧖‍♂, ⤴️ 👨‍🍳, ✋️ 👆 🚫 ⌛ 👶 🕳, 🧹 &amp; 🧹, 🔄 🚫🔜 📉 🕳.

⚫️ 🔜 ✊ 🎏 💸 🕰 🏁 ⏮️ ⚖️ 🍵 🔄 (🛠️) &amp; 👆 🔜 ✔️ ⌛ 🎏 💸 👷.

✋️ 👉 💼, 🚥 👆 💪 ✊️ 8️⃣ 👰-🏧/🍳/🔜-🧹, &amp; 🔠 1️⃣ 👫 (➕ 👆) 💪 ✊ 🏒 🏠 🧹 ⚫️, 👆 💪 🌐 👷 **🔗**, ⏮️ ➕ ℹ, &amp; 🏁 🌅 🔜.

👉 😐, 🔠 1️⃣ 🧹 (🔌 👆) 🔜 🕹, 🤸 👫 🍕 👨‍🏭.

&amp; 🏆 🛠️ 🕰 ✊ ☑ 👷 (↩️ ⌛), &amp; 👷 💻 ⌛ <abbr title="Central Processing Unit">💽</abbr>, 👫 🤙 👫 ⚠ "💽 🎁".

---

⚠ 🖼 💽 🔗 🛠️ 👜 👈 🚚 🏗 🧪 🏭.

🖼:

* **🎧** ⚖️ **🖼 🏭**.
* **💻 👓**: 🖼 ✍ 💯 🔅, 🔠 🔅 ✔️ 3️⃣ 💲 / 🎨, 🏭 👈 🛎 🚚 💻 🕳 🔛 📚 🔅, 🌐 🎏 🕰.
* **🎰 🏫**: ⚫️ 🛎 🚚 📚 "✖" &amp; "🖼" ✖. 💭 🦏 📋 ⏮️ 🔢 &amp; ✖ 🌐 👫 👯‍♂️ 🎏 🕰.
* **⏬ 🏫**: 👉 🎧-🏑 🎰 🏫,, 🎏 ✔. ⚫️ 👈 📤 🚫 👁 📋 🔢 ✖, ✋️ 🦏 ⚒ 👫, &amp; 📚 💼, 👆 ⚙️ 🎁 🕹 🏗 &amp; / ⚖️ ⚙️ 👈 🏷.

### 🛠️ ➕ 🔁: 🕸 ➕ 🎰 🏫

⏮️ **FastAPI** 👆 💪 ✊ 📈 🛠️ 👈 📶 ⚠ 🕸 🛠️ (🎏 👑 🧲 ✳).

✋️ 👆 💪 🐄 💰 🔁 &amp; 💾 (✔️ 💗 🛠️ 🏃‍♂ 🔗) **💽 🎁** ⚖ 💖 👈 🎰 🏫 ⚙️.

👈, ➕ 🙅 👐 👈 🐍 👑 🇪🇸 **💽 🧪**, 🎰 🏫 &amp; ✴️ ⏬ 🏫, ⚒ FastAPI 📶 👍 🏏 💽 🧪 / 🎰 🏫 🕸 🔗 &amp; 🈸 (👪 📚 🎏).

👀 ❔ 🏆 👉 🔁 🏭 👀 📄 🔃 [🛠️](deployment/index.md){.internal-link target=_blank}.

## `async` &amp; `await`

🏛 ⏬ 🐍 ✔️ 📶 🏋️ 🌌 🔬 🔁 📟. 👉 ⚒ ⚫️ 👀 💖 😐 "🔁" 📟 &amp; "⌛" 👆 ▶️️ 🙍.

🕐❔ 📤 🛠️ 👈 🔜 🚚 ⌛ ⏭ 🤝 🏁 &amp; ✔️ 🐕‍🦺 👉 🆕 🐍 ⚒, 👆 💪 📟 ⚫️ 💖:

```Python
burgers = await get_burgers(2)
```

🔑 📥 `await`. ⚫️ 💬 🐍 👈 ⚫️ ✔️ ⌛ ⏸ `get_burgers(2)` 🏁 🔨 🚮 👜 👶 ⏭ ♻ 🏁 `burgers`. ⏮️ 👈, 🐍 🔜 💭 👈 ⚫️ 💪 🚶 &amp; 🕳 🙆 👶 👶 👐 (💖 📨 ➕1️⃣ 📨).

`await` 👷, ⚫️ ✔️ 🔘 🔢 👈 🐕‍🦺 👉 🔀. 👈, 👆 📣 ⚫️ ⏮️ `async def`:

```Python hl_lines="1"
async def get_burgers(number: int):
    # Do some asynchronous stuff to create the burgers
    return burgers
```

...↩️ `def`:

```Python hl_lines="2"
# This is not asynchronous
def get_sequential_burgers(number: int):
    # Do some sequential stuff to create the burgers
    return burgers
```

⏮️ `async def`, 🐍 💭 👈, 🔘 👈 🔢, ⚫️ ✔️ 🤔 `await` 🧬, &amp; 👈 ⚫️ 💪 "⏸" ⏸ 🛠️ 👈 🔢 &amp; 🚶 🕳 🙆 👶 ⏭ 👟 🔙.

🕐❔ 👆 💚 🤙 `async def` 🔢, 👆 ✔️ "⌛" ⚫️. , 👉 🏆 🚫 👷:

```Python
# This won't work, because get_burgers was defined with: async def
burgers = get_burgers(2)
```

---

, 🚥 👆 ⚙️ 🗃 👈 💬 👆 👈 👆 💪 🤙 ⚫️ ⏮️ `await`, 👆 💪 ✍ *➡ 🛠️ 🔢* 👈 ⚙️ ⚫️ ⏮️ `async def`, 💖:

```Python hl_lines="2-3"
@app.get('/burgers')
async def read_burgers():
    burgers = await get_burgers(2)
    return burgers
```

### 🌅 📡 ℹ

👆 💪 ✔️ 👀 👈 `await` 💪 🕴 ⚙️ 🔘 🔢 🔬 ⏮️ `async def`.

✋️ 🎏 🕰, 🔢 🔬 ⏮️ `async def` ✔️ "⌛". , 🔢 ⏮️ `async def` 💪 🕴 🤙 🔘 🔢 🔬 ⏮️ `async def` 💁‍♂️.

, 🔃 🥚 &amp; 🐔, ❔ 👆 🤙 🥇 `async` 🔢 ❓

🚥 👆 👷 ⏮️ **FastAPI** 👆 🚫 ✔️ 😟 🔃 👈, ↩️ 👈 "🥇" 🔢 🔜 👆 *➡ 🛠️ 🔢*, &amp; FastAPI 🔜 💭 ❔ ▶️️ 👜.

✋️ 🚥 👆 💚 ⚙️ `async` / `await` 🍵 FastAPI, 👆 💪 ⚫️ 👍.

### ✍ 👆 👍 🔁 📟

💃 (&amp; **FastAPI**) ⚓️ 🔛 <a href="https://anyio.readthedocs.io/en/stable/" class="external-link" target="_blank">AnyIO</a>, ❔ ⚒ ⚫️ 🔗 ⏮️ 👯‍♂️ 🐍 🐩 🗃 <a href="https://docs.python.org/3/library/asyncio-task.html" class="external-link" target="_blank">✳</a> &amp; <a href="https://trio.readthedocs.io/en/stable/" class="external-link" target="_blank">🎻</a>.

🎯, 👆 💪 🔗 ⚙️ <a href="https://anyio.readthedocs.io/en/stable/" class="external-link" target="_blank">AnyIO</a> 👆 🏧 🛠️ ⚙️ 💼 👈 🚚 🌅 🏧 ⚓ 👆 👍 📟.

&amp; 🚥 👆 🚫 ⚙️ FastAPI, 👆 💪 ✍ 👆 👍 🔁 🈸 ⏮️ <a href="https://anyio.readthedocs.io/en/stable/" class="external-link" target="_blank">AnyIO</a> 🏆 🔗 &amp; 🤚 🚮 💰 (✅ *📊 🛠️*).

### 🎏 📨 🔁 📟

👉 👗 ⚙️ `async` &amp; `await` 📶 🆕 🇪🇸.

✋️ ⚫️ ⚒ 👷 ⏮️ 🔁 📟 📚 ⏩.

👉 🎏 ❕ (⚖️ 🌖 🌓) 🔌 ⏳ 🏛 ⏬ 🕸 (🖥 &amp; ✳).

✋️ ⏭ 👈, 🚚 🔁 📟 🌖 🏗 &amp; ⚠.

⏮️ ⏬ 🐍, 👆 💪 ✔️ ⚙️ 🧵 ⚖️ <a href="https://www.gevent.org/" class="external-link" target="_blank">🐁</a>. ✋️ 📟 🌌 🌖 🏗 🤔, ℹ, &amp; 💭 🔃.

⏮️ ⏬ ✳ / 🖥 🕸, 👆 🔜 ✔️ ⚙️ "⏲". ❔ ↘️ <a href="http://callbackhell.com/" class="external-link" target="_blank">⏲ 🔥😈</a>.

## 🔁

**🔁** 📶 🎀 ⚖ 👜 📨 `async def` 🔢. 🐍 💭 👈 ⚫️ 🕳 💖 🔢 👈 ⚫️ 💪 ▶️ &amp; 👈 ⚫️ 🔜 🔚 ☝, ✋️ 👈 ⚫️ 5️⃣📆 ⏸ ⏸ 🔘 💁‍♂️, 🕐❔ 📤 `await` 🔘 ⚫️.

✋️ 🌐 👉 🛠️ ⚙️ 🔁 📟 ⏮️ `async` &amp; `await` 📚 🕰 🔬 ⚙️ "🔁". ⚫️ ⭐ 👑 🔑 ⚒ 🚶, "🔁".

## 🏁

➡️ 👀 🎏 🔤 ⚪️➡️ 🔛:

> 🏛 ⏬ 🐍 ✔️ 🐕‍🦺 **"🔁 📟"** ⚙️ 🕳 🤙 **"🔁"**, ⏮️ **`async` &amp; `await`** ❕.

👈 🔜 ⚒ 🌅 🔑 🔜. 👶

🌐 👈 ⚫️❔ 🏋️ FastAPI (🔘 💃) &amp; ⚫️❔ ⚒ ⚫️ ✔️ ✅ 🎆 🎭.

## 📶 📡 ℹ

!!! warning
    👆 💪 🎲 🚶 👉.

    👉 📶 📡 ℹ ❔ **FastAPI** 👷 🔘.

    🚥 👆 ✔️ 📡 💡 (🈶-🏋, 🧵, 🍫, ♒️.) &amp; 😟 🔃 ❔ FastAPI 🍵 `async def` 🆚 😐 `def`, 🚶 ⤴️.

### ➡ 🛠️ 🔢

🕐❔ 👆 📣 *➡ 🛠️ 🔢* ⏮️ 😐 `def` ↩️ `async def`, ⚫️ 🏃 🔢 🧵 👈 ⤴️ ⌛, ↩️ ➖ 🤙 🔗 (⚫️ 🔜 🍫 💽).

🚥 👆 👟 ⚪️➡️ ➕1️⃣ 🔁 🛠️ 👈 🔨 🚫 👷 🌌 🔬 🔛 &amp; 👆 ⚙️ ⚖ 🙃 📊-🕴 *➡ 🛠️ 🔢* ⏮️ ✅ `def` 🤪 🎭 📈 (🔃 1️⃣0️⃣0️⃣ 💓), 🙏 🗒 👈 **FastAPI** ⭐ 🔜 🔄. 👫 💼, ⚫️ 👻 ⚙️ `async def` 🚥 👆 *➡ 🛠️ 🔢* ⚙️ 📟 👈 🎭 🚧 <abbr title="Input/Output: disk reading or writing, network communications.">👤/🅾</abbr>.

, 👯‍♂️ ⚠, 🤞 👈 **FastAPI** 🔜 [⏩](/#performance){.internal-link target=_blank} 🌘 (⚖️ 🌘 ⭐) 👆 ⏮️ 🛠️.

### 🔗

🎏 ✔ [🔗](/tutorial/dependencies/index.md){.internal-link target=_blank}. 🚥 🔗 🐩 `def` 🔢 ↩️ `async def`, ⚫️ 🏃 🔢 🧵.

### 🎧-🔗

👆 💪 ✔️ 💗 🔗 &amp; [🎧-🔗](/tutorial/dependencies/sub-dependencies.md){.internal-link target=_blank} 🚫 🔠 🎏 (🔢 🔢 🔑), 👫 💪 ✍ ⏮️ `async def` &amp; ⏮️ 😐 `def`. ⚫️ 🔜 👷, &amp; 🕐 ✍ ⏮️ 😐 `def` 🔜 🤙 🔛 🔢 🧵 (⚪️➡️ 🧵) ↩️ ➖ "⌛".

### 🎏 🚙 🔢

🙆 🎏 🚙 🔢 👈 👆 🤙 🔗 💪 ✍ ⏮️ 😐 `def` ⚖️ `async def` &amp; FastAPI 🏆 🚫 📉 🌌 👆 🤙 ⚫️.

👉 🔅 🔢 👈 FastAPI 🤙 👆: *➡ 🛠️ 🔢* &amp; 🔗.

🚥 👆 🚙 🔢 😐 🔢 ⏮️ `def`, ⚫️ 🔜 🤙 🔗 (👆 ✍ ⚫️ 👆 📟), 🚫 🧵, 🚥 🔢 ✍ ⏮️ `async def` ⤴️ 👆 🔜 `await` 👈 🔢 🕐❔ 👆 🤙 ⚫️ 👆 📟.

---

🔄, 👉 📶 📡 ℹ 👈 🔜 🎲 ⚠ 🚥 👆 👟 🔎 👫.

⏪, 👆 🔜 👍 ⏮️ 📄 ⚪️➡️ 📄 🔛: <a href="#in-a-hurry">🏃 ❓</a>.
