/* Greek transliteration for GCIDE.  This file is part of GNU Dico.
   Copyright (C) 2012-2021 Sergey Poznyakoff

   GNU Dico is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Dico is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Dico.  If not, see <http://www.gnu.org/licenses/>. */

#include <config.h>
#include <stdlib.h>
#include "gcide.h"

struct xlit {
    char *seq;
    char *grk;
};

/* NOTE: 1. According to WEBFONT.ASC, "[r]oman j, v, u are unused".
            Nevertheless, "u" is used in place of "y" (meaning υ) so often
	    that I decided to support both forms.
	 2. It is not clear whether trema (:) should appear after accents
	    or vice-versa.  The table below supports both forms.
*/

static struct xlit xlit[] = {
    { "'A", "Ἀ" },
    { "'A,", "ᾈ" },
    { "'A^", "Ἆ" },
    { "'A`", "Ἄ" },
    { "'A~", "Ἂ" },
    { "'A~,", "ᾊ" },
    { "'A~,", "ᾌ" },
    { "'A~,", "ᾎ" },
    { "'E", "Ἐ" },
    { "'E`", "Ἔ" },
    { "'E~", "Ἒ" },
    { "'H", "Ἠ" },
    { "'H,", "ᾘ" },
    { "'H^", "Ἦ" },
    { "'H`", "Ἤ" },
    { "'H~", "Ἢ" },
    { "'H~,", "ᾚ" },
    { "'H~,", "ᾜ" },
    { "'H~,", "ᾞ" },
    { "'I", "Ἰ" },
    { "'I^", "Ἶ" },
    { "'I`", "Ἴ" },
    { "'I~", "Ἲ" },
    { "'O", "Ὀ" },
    { "'O`", "Ὄ" },
    { "'O~", "Ὂ" },
    { "'W", "Ὠ" },
    { "'W,", "ᾨ" },
    { "'W^", "Ὦ" },
    { "'W`", "Ὤ" },
    { "'W~", "Ὢ" },
    { "'W~,", "ᾪ" },
    { "'W~,", "ᾬ" },
    { "'W~,", "ᾮ" },
    { "'`O", "Ὄ" },
    { "'a", "ἀ" },
    { "'a,", "ᾀ" },
    { "'a^", "ἆ" },
    { "'a^,", "ᾆ" },
    { "'a`", "ἄ" },
    { "'a`,", "ᾄ" },
    { "'a~", "ἂ" },
    { "'a~,", "ᾂ" },
    { "'e", "ἐ" },
    { "'e`", "ἔ" },
    { "'e~", "ἒ" },
    { "'h", "ἠ" },
    { "'h,", "ᾐ" },
    { "'h^", "ἦ" },
    { "'h^,", "ᾖ" },
    { "'h`", "῎η" },
    { "'h`,", "ᾔ" },
    { "'h~", "ἢ" },
    { "'h~,", "ᾒ" },
    { "'i", "ἰ" },
    { "'i^", "ἶ" },
    { "'i`", "ἴ" },
    { "'i~", "ἲ" },
    { "'o", "ὀ" },
    { "'o`", "ὄ" },
    { "'o~", "ὂ" },
    { "'r", "ῤ" },
    { "'u", "ὐ" },
    { "'u^", "ὖ" },
    { "'u`", "ὔ" },
    { "'u~", "ὒ" },
    { "'w", "ὠ" },
    { "'w,", "ᾠ" },
    { "'w^", "ὦ" },
    { "'w^,", "ᾦ" },
    { "'w`", "ὤ" },
    { "'w`,", "ᾤ" },
    { "'w~", "ὢ" },
    { "'w~,", "ᾢ" },
    { "'y", "ὐ" },
    { "'y^", "ὖ" },
    { "'y`", "ὔ" },
    { "'y~", "ὒ" },
    { "A", "Α" },
    { "A", "Α" },
    { "A,", "ᾼ" },
    { "A`", "Ά" },
    { "A~", "Ἁ" },
    { "B", "Β" },
    { "CH", "Χ" },
    { "Ch", "Χ" },
    { "D", "Δ" },
    { "E", "Ε" },
    { "E", "Ε" },
    { "E`", "Έ" },
    { "E~", "Ἑ" },
    { "F", "Φ" },
    { "G", "Γ" },
    { "H", "Η" },
    { "H", "Η" },
    { "H,", "ῌ" },
    { "H`", "Ή" },
    { "H~", "Ἡ" },
    { "I", "Ι" },
    { "I", "Ι" },
    { "I`", "Ί" },
    { "I~", "Ἱ" },
    { "K", "Κ" },
    { "L", "Λ" },
    { "M", "Μ" },
    { "N", "Ν" },
    { "O", "Ο" },
    { "O", "Ο" },
    { "O`", "Ό" },
    { "O~", "Ὁ" },
    { "P", "Π" },
    { "PS", "Ψ" },
    { "Ps", "Ψ" },
    { "Q", "Θ" },
    { "R", "Ρ" },
    { "S", "Σ" },
    { "T", "Τ" },
    { "U", "Υ" },
    { "U", "Υ" },
    { "U`", "Ύ" },
    { "U~", "Ὑ" },
    { "W", "Ω" },
    { "W", "Ω" },
    { "W,", "ῼ" },
    { "W`", "Ώ" },
    { "W~", "Ὡ" },
    { "X", "Ξ" },
    { "Y", "Υ" },
    { "Y", "Υ" },
    { "Y`", "Ύ" },
    { "Y~", "Ὑ" },
    { "Z", "Ζ" },
    { "\"A", "Ὰ" },
    { "\"A,", "ᾉ" },
    { "\"A^", "Ἇ" },
    { "\"A^,", "ᾏ" },
    { "\"A`", "Ἅ" },
    { "\"A`,", "ᾍ" },
    { "\"A~", "Ἃ" },
    { "\"A~,", "ᾋ" },
    { "\"E", "Ὲ" },
    { "\"E`", "Ἕ" },
    { "\"E~", "Ἓ" },
    { "\"H", "Ὴ" },
    { "\"H,", "ᾙ" },
    { "\"H^", "Ἧ" },
    { "\"H^,", "ᾟ" },
    { "\"H`", "Ἥ" },
    { "\"H`,", "ᾝ" },
    { "\"H~", "Ἣ" },
    { "\"H~,", "ᾛ" },
    { "\"I", "Ὶ" },
    { "\"I^", "Ἷ" },
    { "\"I`", "Ἵ" },
    { "\"I~", "Ἳ" },
    { "\"O", "Ὸ" },
    { "\"O`", "Ὅ" },
    { "\"O~", "Ὃ" },
    { "\"R", "Ῥ" },
    { "\"U", "Ὺ" },
    { "\"U^", "Ὗ" },
    { "\"U`", "Ὕ" },
    { "\"U~", "Ὓ" },
    { "\"W", "Ὼ" },
    { "\"W,", "ᾩ" },
    { "\"W^", "Ὧ" },
    { "\"W^,", "ᾯ" },
    { "\"W`", "Ὥ" },
    { "\"W`,", "ᾭ" },
    { "\"W~", "Ὣ" },
    { "\"W~,", "ᾫ" },
    { "\"Y", "Ὺ" },
    { "\"Y^", "Ὗ" },
    { "\"Y`", "Ὕ" },
    { "\"Y~", "Ὓ" },
    { "\"a", "ἁ" },
    { "\"a,", "ᾁ" },
    { "\"a^", "ἇ" },
    { "\"a^,", "ᾇ" },
    { "\"a`", "ἄ" },
    { "\"a`", "ἅ" },
    { "\"a`,", "ᾅ" },
    { "\"a~", "ἂ" },
    { "\"a~", "ἃ" },
    { "\"a~,", "ᾃ" },
    { "\"e", "ἑ" },
    { "\"e`", "ἕ" },
    { "\"e~", "ἓ" },
    { "\"h", "ἡ" },
    { "\"h,", "ᾑ" },
    { "\"h^", "ἧ" },
    { "\"h^,", "ᾗ" },
    { "\"h`", "ἤ" },
    { "\"h`", "ἥ" },
    { "\"h`,", "ᾕ" },
    { "\"h~", "ἣ" },
    { "\"h~,", "ᾓ" },
    { "\"i", "ἱ" },
    { "\"i^", "ἷ" },
    { "\"i`", "ἵ" },
    { "\"i~", "ἳ" },
    { "\"o", "ὁ" },
    { "\"o`", "ὅ" },
    { "\"o~", "ὃ" },
    { "\"r", "ῥ" },
    { "\"u", "ὑ" },
    { "\"u^", "ὗ" },
    { "\"u`", "ὕ" },
    { "\"u~", "ὓ" },
    { "\"w", "ὡ" },
    { "\"w,", "ᾡ" },
    { "\"w^", "ὣ" },
    { "\"w^", "ὧ" },
    { "\"w^,", "ᾧ" },
    { "\"w`", "ὥ" },
    { "\"w`,", "ᾥ" },
    { "\"w~,", "ᾣ" },
    { "\"y", "ὑ" },
    { "\"y^", "ὗ" },
    { "\"y`", "ὕ" },
    { "\"y~", "ὓ" },
    { "a", "α" },
    { "a,", "ᾳ" },
    { "a^", "ᾶ" },
    { "a^,", "ᾷ" },
    { "a`", "ά" },
    { "a`,", "ᾴ" },
    { "a~", "ὰ" },
    { "a~,", "ᾲ" },
    { "b", "β" },
    { "ch", "χ" },
    { "d", "δ" },
    { "e", "ε" },
    { "e`", "έ" },
    { "e~", "ὲ" },
    { "f", "φ" },
    { "g", "γ" },
    { "h", "η" },
    { "h,", "ῃ" },
    { "h^", "ῆ" },
    { "h^,", "ῇ" },
    { "h`", "ή" },
    { "h`,", "ῄ" },
    { "h~", "ὴ" },
    { "h~,", "ῂ" },
    { "i", "ι" },
    { "i:", "ϊ" },
    { "i:^", "ῗ" },
    { "i:~", "ῒ" },
    { "i:`", "ΐ" },
    { "i^", "ῖ" },
    { "i^:", "ῗ" },
    { "i`", "ί" },
    { "i`:", "ῒ" },
    { "i`:", "ΐ" },
    { "i~", "ὶ" },
    { "k", "κ" },
    { "l", "λ" },
    { "m", "μ" },
    { "n", "ν" },
    { "o", "ο" },
    { "o`", "ό" },
    { "o~", "ὸ" },
    { "p", "π" },
    { "ps", "ψ" },
    { "q", "θ" },
    { "r", "ρ" },
    { "s", "σ" },
    { "t", "τ" },
    { "u", "υ" },
    { "u:", "ϋ" },
    { "u:^", "ῧ" },
    { "u:`", "ΰ" },
    { "u:~", "ῢ" },
    { "u^", "ῦ" },
    { "u^:", "ῧ" },
    { "u`", "ύ" },
    { "u`:", "ΰ" },
    { "u~", "ὺ" },
    { "u~:", "ῢ" },
    { "w", "ω" },
    { "w,", "ῳ" },
    { "w^", "ῶ" },
    { "w^,", "ῷ" },
    { "w`", "ώ" },
    { "w`,", "ῴ" },
    { "w~", "ὼ" },
    { "w~,", "ῲ" },
    { "x", "ξ" },
    { "y", "υ" },
    { "y:", "ϋ" },
    { "y:^", "ῧ" },
    { "y:`", "ΰ" },
    { "y:~", "ῢ" },
    { "y^", "ῦ" },
    { "y^:", "ῧ" },
    { "y`", "ύ" },
    { "y`:", "ΰ" },
    { "y~", "ὺ" },
    { "y~:", "ῢ" },
    { "z", "ζ" },
    { NULL }
};

const char *
gcide_grk_to_utf8(const char *input, size_t *prd)
{
    struct xlit *p, *found_xlit = NULL;
    size_t found_len = 0;

    if (input[0] == 's' && input[1] == 0) {
	*prd = 1;
	return "ς";
    }
    for (p = xlit; p->seq; p++) {
	int i;

	for (i = 0; input[i]; i++)
	    if (input[i] != p->seq[i])
		break;

	if (p->seq[i]) {
	    if (found_len && i == 0)
		break;
	    continue;
	}

	if (i > found_len) {
	    found_len = i;
	    found_xlit = p;
	}
    }

    if (found_len) {
	*prd = found_len;
	return found_xlit->grk;
    }

    return NULL;
}
