!{\src2tex{textfont=tt}}
!!****f* ABINIT/opernlc_ylm
!! NAME
!! opernlc_ylm
!!
!! FUNCTION
!! * Operate with the non-local part of the hamiltonian,
!!   in order to reduce projected scalars
!! * Operate with the non-local projectors and the overlap matrix,
!!   in order to reduce projected scalars
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  atindx1(natom)=index table for atoms (gives the absolute index of
!!                 an atom from its rank in a block of atoms)
!!  cplex=1 if <p_lmn|c> scalars are real (equivalent to istwfk>1)
!!        2 if <p_lmn|c> scalars are complex
!!  dgxdt(cplex,ndgxdt,nlmn,nincat)=grads of projected scalars (only if optder>0)
!!  dimenl1,dimenl2=dimensions of enl (see enl)
!!  enl(dimenl1,dimenl2)=
!!  ->Norm conserving : ==== when paw_opt=0 ====
!!                      (Real) Kleinman-Bylander energies (hartree)
!!                      dimenl1=lmnmax  -  dimenl2=ntypat
!!  ->PAW :             ==== when paw_opt=1, 2 or 4 ====
!!                      (Real, symmetric) Dij coefs to connect projectors
!!                      dimenl1=lmnmax*(lmnmax+1)/2  -  dimenl2=natom
!!  gx(cplex,nlmn,nincat*abs(enl_opt))= projected scalars
!!  iatm=absolute rank of first atom of the current block of atoms
!!  indlmn(6,nlmn)= array giving l,m,n,lm,ln,s for i=lmn
!!  itypat=type of atoms
!!  lambda=factor to be used when computing (Vln-lambda.S) - only for paw_opt=2
!!  natom=number of atoms in cell
!!  ndgxdt=second dimension of dgxdt
!!  ndgxdtfac=second dimension of dgxdtfac
!!  nincat=number of atoms in the subset here treated
!!  nlmn=number of (l,m,n) numbers for current type of atom
!!  optder=0=only gxfac is computed, 1=both gxfac and dgxdtfac are computed
!!  paw_opt= define the nonlocal operator concerned with:
!!           paw_opt=0 : Norm-conserving Vnl (use of Kleinman-Bylander ener.)
!!           paw_opt=1 : PAW nonlocal part of H (use of Dij coeffs)
!!           paw_opt=2 : PAW: (Vnl-lambda.Sij) (Sij=overlap matrix)
!!           paw_opt=3 : PAW overlap matrix (Sij)
!!           paw_opt=4 : both PAW nonlocal part of H (Dij) and overlap matrix (Sij)
!!           paw_opt=-1: PAW augmentation occupancies (rhoij)
!!  sij(nlm*(nlmn+1)/2)=overlap matrix components (only if paw_opt=2, 3 or 4)
!!
!! OUTPUT
!!  if (paw_opt=0, 1, 2 or 4)
!!    gxfac(cplex,nlmn,nincat)= reduced projected scalars related to Vnl (NL operator)
!!  if (paw_opt=3 or 4)
!!    gxfac_sij(cplex,nlmn,nincat)= reduced projected scalars related to Sij (overlap)
!!  if (optder==1.and.paw_opt=0, 1, 2 or 4)
!!    dgxdtfac(cplex,ndgxdtfac,nlmn,nincat)= gradients of gxfac related to Vnl (NL operator)
!!
!! NOTES
!! Operate for one type of atom, and within this given type of atom,
!! for a subset of at most nincat atoms.
!!
!! PARENTS
!!      nonlop_ylm
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine opernlc_ylm(atindx1,cplex,dgxdt,dgxdtfac,dimenl1,dimenl2,enl,gx,&
&                      gxfac,gxfac_sij,iatm,indlmn,itypat,lambda,natom,ndgxdt,&
&                      ndgxdtfac,nincat,nlmn,optder,paw_opt,sij)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: cplex,dimenl1,dimenl2,iatm,itypat,natom,ndgxdt,ndgxdtfac
 integer,intent(in) :: nincat,nlmn,optder,paw_opt
 real(dp) :: lambda
!arrays
 integer,intent(in) :: atindx1(natom),indlmn(6,nlmn)
 real(dp),intent(in) :: dgxdt(cplex,ndgxdt,nlmn,nincat),enl(dimenl1,dimenl2)
 real(dp),intent(in) :: gx(cplex,nlmn,nincat),sij(((paw_opt+1)/3)*nlmn*(nlmn+1)/2)
 real(dp),intent(out) :: dgxdtfac(cplex,ndgxdtfac,nlmn,nincat),gxfac(cplex,nlmn,nincat)
 real(dp),intent(out) :: gxfac_sij(cplex,nlmn,nincat*(paw_opt/3))

!Local variables-------------------------------
!scalars
 integer :: ia,ijlmn,ilm,ilmn,iln,index_enl,j0lmn,jjlmn,jlm,jlmn,mu
 real(dp) :: enlr,sijr
!Arrays
 real(dp) :: gxj(cplex)
 real(dp),allocatable :: gxfj(:,:)

! *************************************************************************

 if (paw_opt==-1) return

!Accumulate gxfac related to nonlocal operator (Norm-conserving)
!-------------------------------------------------------------------
 if (paw_opt==0) then                  ! Enl is E(Kleinman-Bylander)
  do ia=1,nincat
   do ilmn=1,nlmn
    iln=indlmn(5,ilmn)
    enlr=enl(iln,itypat)
    gxfac(1:cplex,ilmn,ia)=enlr*gx(1:cplex,ilmn,ia)
   end do
  end do
 end if

!Accumulate gxfac related to nonlocal operator (PAW)
!-------------------------------------------------------------------
 if (paw_opt==1.or.paw_opt==2.or.paw_opt==4) then        ! Enl is psp strenght Dij
  gxfac(1:cplex,1:nlmn,1:nincat)=zero                    ! or (Dij-lambda.Sij)
  do ia=1,nincat
   index_enl=atindx1(iatm+ia)
   do jlmn=1,nlmn
    j0lmn=jlmn*(jlmn-1)/2
    jjlmn=j0lmn+jlmn
    enlr=enl(jjlmn,index_enl)
    if (paw_opt==2) enlr=enlr-lambda*sij(jjlmn)
    gxj(1:cplex)=gx(1:cplex,jlmn,ia)
    gxfac(1:cplex,jlmn,ia)=gxfac(1:cplex,jlmn,ia)+enlr*gxj(1:cplex)
    do ilmn=1,jlmn-1
     ijlmn=j0lmn+ilmn
     enlr=enl(ijlmn,index_enl)
     if (paw_opt==2) enlr=enlr-lambda*sij(ijlmn)
     gxfac(1:cplex,ilmn,ia)=gxfac(1:cplex,ilmn,ia)+enlr*gxj(1:cplex)
     gxfac(1:cplex,jlmn,ia)=gxfac(1:cplex,jlmn,ia)+enlr*gx(1:cplex,ilmn,ia)
    end do
   end do
  end do
 end if

!Accumulate gxfac related to overlap (Sij) (PAW)
!------------------------------------------- ------------------------
 if (paw_opt==3.or.paw_opt==4) then                    ! Use Sij, overlap contribution
  gxfac_sij(1:cplex,1:nlmn,1:nincat)=zero
  do ia=1,nincat
   do jlmn=1,nlmn
    j0lmn=jlmn*(jlmn-1)/2
    jjlmn=j0lmn+jlmn
    jlm=indlmn(4,jlmn)
    sijr=sij(jjlmn);gxj(1:cplex)=gx(1:cplex,jlmn,ia)
    gxfac_sij(1:cplex,jlmn,ia)=gxfac_sij(1:cplex,jlmn,ia)+sijr*gxj(1:cplex)
    do ilmn=1,jlmn-1
     ilm=indlmn(4,ilmn)
     if (ilm==jlm) then
      ijlmn=j0lmn+ilmn
      sijr=sij(ijlmn)
      gxfac_sij(1:cplex,ilmn,ia)=gxfac_sij(1:cplex,ilmn,ia)+sijr*gxj(1:cplex)
      gxfac_sij(1:cplex,jlmn,ia)=gxfac_sij(1:cplex,jlmn,ia)+sijr*gx(1:cplex,ilmn,ia)
     end if
    end do
   end do
  end do
 end if

! Accumulate dgxdtfac related to nonlocal operator (Norm-conserving)
!-------------------------------------------------------------------
 if (optder==1.and.paw_opt==0) then    ! Enl is E(Kleinman-Bylander)
  do ia=1,nincat
   do ilmn=1,nlmn
    iln=indlmn(5,ilmn)
    enlr=enl(iln,itypat)
    do mu=1,ndgxdtfac
     dgxdtfac(1:cplex,mu,ilmn,ia)=enlr*dgxdt(1:cplex,mu,ilmn,ia)
    end do
   end do
  end do
 end if

! Accumulate dgxdtfac related to nonlocal operator (PAW)
!-------------------------------------------------------------------
 if (optder==1.and.(paw_opt==1.or.paw_opt==2.or.paw_opt==4)) then  ! Enl is psp strenght Dij
  allocate(gxfj(cplex,ndgxdtfac))                                  ! or (Dij-lambda.Sij)
  dgxdtfac(1:cplex,1:ndgxdtfac,1:nlmn,1:nincat)=zero
  do ia=1,nincat
   index_enl=atindx1(iatm+ia)
   do jlmn=1,nlmn
    j0lmn=jlmn*(jlmn-1)/2
    jjlmn=j0lmn+jlmn
    enlr=enl(jjlmn,index_enl)
    if (paw_opt==2) enlr=enlr-lambda*sij(jjlmn)
    do mu=1,ndgxdtfac
     gxfj(1:cplex,mu)=dgxdt(1:cplex,mu,jlmn,ia)
     dgxdtfac(1:cplex,mu,jlmn,ia)=dgxdtfac(1:cplex,mu,jlmn,ia)+enlr*gxfj(1:cplex,mu)
    end do
    do ilmn=1,jlmn-1
     ijlmn=j0lmn+ilmn
     enlr=enl(ijlmn,index_enl)
     if (paw_opt==2) enlr=enlr-lambda*sij(ijlmn)
     do mu=1,ndgxdtfac
      dgxdtfac(1:cplex,mu,ilmn,ia)=dgxdtfac(1:cplex,mu,ilmn,ia)+enlr*gxfj(1:cplex,mu)
      dgxdtfac(1:cplex,mu,jlmn,ia)=dgxdtfac(1:cplex,mu,jlmn,ia)+enlr*dgxdt(1:cplex,mu,ilmn,ia)
     end do
    end do
   end do
  end do
  deallocate(gxfj)
 end if

end subroutine opernlc_ylm
!!***
