!{\src2tex{textfont=tt}}
!!****f* ABINIT/ylmcd
!! NAME
!! ylmcd
!!
!! FUNCTION
!!
!!  This subroutine computes dth and dphi, the first derivatives of
!!  (complex) Ylm as a function of th and phi (the angles of the spherical coordinates)
!!  It works for all spherical harmonics with il <=2
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2007 ABINIT group (FB, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  il=angular quantum number
!!  im=magnetic quantum number
!!  kcart=cartesian coordinates of the vector where the first derivatives of Ylm are evaluated
!!
!! OUTPUT
!!  dth=derivative of Y_lm with respect to \theta
!!  dphi=derivative of Y_lm with respect to \phi
!!
!! SIDE EFFECTS
!!
!! NOTES
!!  Using double precision complex even thou it does not conform the ABINIT
!!  convention
!!  case l=3 must be implemented
!!
!! PARENTS
!!      ccgradvnl_ylm
!!
!! CHILDREN
!!      leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine ylmcd(il,im,kcart,dth,dphi)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: il,im
 complex(dpc),intent(out) :: dphi,dth
!arrays
 real(dp),intent(in) :: kcart(3)

!Local variables-------------------------------
!scalars
 integer,parameter :: lx=3
 real(dp),parameter :: pad=tol8
 real(dp) :: cosphi,costh,costhreephi,costwophi,r,rxy,sinphi,sinth,sinthreephi
 real(dp) :: sintwophi
 character(len=500) :: message

! *************************************************************************

 if(il<0)then
  write(message,'(a,a,a,a,a,a,i6)') ch10,&
&  ' ylmcd: ERROR -',ch10,&
&  '  The argument l should be positive,',ch10,&
&  '  however, l=',il
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if
 if(il>lx)then
  write(message,'(a,a,a,a,i6,a,a,i6)') ch10,&
&  ' ylmcd: ERROR -',ch10,&
&  '  The maximum allowed value for l is,',lx,ch10,&
&  '  however, l=',il
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if
 if(abs(im)>abs(il))then
  write(message,'(4a,i6,2a,i6,a,i6)') ch10,&
&  ' ylmcd: ERROR -',ch10,&
&  '  m is,',im,ch10,&
&  '  however it should be between ',-il,' and ',il
  call wrtout(std_out,message,'COLL')
  call leave_new('COLL')
 end if

 r=sqrt(kcart(1)**2+kcart(2)**2+kcart(3)**2)
 if(r<pad)r=r+pad
 rxy=sqrt(kcart(1)**2+kcart(2)**2)
 if(rxy<pad)rxy=r+pad

 !(th,ph) spherical representation.
 costh= kcart(3)/r
 sinth= rxy/r
 cosphi= kcart(1)/rxy
 sinphi= kcart(2)/rxy
 costwophi= 2.d0*cosphi**2 - 1.d0
 sintwophi= 2.d0*sinphi*cosphi
 costhreephi=cosphi*costwophi-sinphi*sintwophi
 sinthreephi=cosphi*sintwophi+sinphi*costwophi

 if (il==0) then
   dth  = (0.d0,0.d0)
   dphi = (0.d0,0.d0)
 else if (il==1) then
  if (abs(im)==0) then
   dth= -sqrt(3.d0/(4.d0*pi))*sinth
   dphi= (0.d0,0.d0)
  else if (abs(im)==1) then
   dth= -sqrt(3.d0/(8.d0*pi))*costh*cmplx(cosphi,sinphi)
   dphi=-sqrt(3.d0/(8.d0*pi))*sinth*cmplx(-sinphi,cosphi)
  end if
 else if (il==2) then
  if (abs(im)==0) then
   dth= -sqrt(5.d0/(16.d0*pi))*6.d0*costh*sinth
   dphi= (0.d0,0.d0)
  else if (abs(im)==1) then
   dth= -sqrt(15.d0/(8.d0*pi))*(costh**2-sinth**2)*cmplx(cosphi,sinphi)
   dphi= -sqrt(15.d0/(8.d0*pi))*costh*sinth*(0.d0,1.d0)*cmplx(cosphi,sinphi)
  elseif (abs(im)==2) then
   dth= sqrt(15.d0/(32.d0*pi))*2.d0*costh*sinth*cmplx(costwophi,sintwophi)
   dphi = sqrt(15.d0/(32.d0*pi))*sinth**2*(0.d0,2.d0)*cmplx(costwophi,sintwophi)
  end if
 else if (il==3) then
  if (abs(im)==0) then
   dth = sqrt(7.d0/(16*pi))*(-15.d0*costh**2*sinth + 3.d0**sinth)
   dphi= (0.d0,0.d0)
  else if (abs(im)==1) then
   dth= -sqrt(21.d0/(64.d0*pi))*cmplx(cosphi,sinphi)*(5.d0*costh**3-costh-10.d0*sinth**2*costh)
   dphi=-sqrt(21.d0/(64.d0*pi))*sinth*(5.d0*costh**2-1)*(0.d0,1.d0)*cmplx(cosphi,sinphi)
  else if (abs(im)==2) then
   dth=sqrt(105.d0/(32.d0*pi))*(2.d0*sinth*costh**2-sinth**3)*cmplx(costwophi,sintwophi)
   dphi=sqrt(105.d0/(32*pi))*sinth**2*costh*(0.d0,2.d0)*cmplx(costwophi,sintwophi)
  else if (abs(im)==3) then
   dth=-sqrt(35.d0/(64.d0*pi))*3.d0*sinth**2*costh*cmplx(costhreephi,sinthreephi)
   dphi=sqrt(35.d0/(64.d0*pi))*sinth**3*(0.d0,3.d0)*cmplx(costhreephi,sinthreephi)
  end if
 end if

 !treats the case im < 0
 if (im<0) then
  dth = (-1.d0)**(im)*conjg(dth)
  dphi= (-1.d0)**(im)*conjg(dphi)
 end if

end subroutine ylmcd
!!***
