/*
 * SPDX-FileCopyrightText: Copyright (c) 2020-2020 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/******************************************************************************
 *
 *   File: gpu_mgmt_api.c
 *
 *   Description:
 *       This file contains the functions managing the GPU information
 *       encapsulated by GPUDB object or probed state GPU.
 *
 *****************************************************************************/

#include "core/core.h"
#include "gpu_mgr/gpu_mgmt_api.h"
#include "gpu_mgr/gpu_db.h"

NV_STATUS
gpumgmtapiConstruct_IMPL
(
    GpuManagementApi                *pGpuMgmt,
    CALL_CONTEXT                    *pCallContext,
    RS_RES_ALLOC_PARAMS_INTERNAL    *pParams
)
{
    return NV_OK;
}

void
gpumgmtapiDestruct_IMPL
(
    GpuManagementApi    *pGpuMgmt
)
{
}

NV_STATUS
gpumgmtapiCtrlCmdSetShutdownState_IMPL
(
    GpuManagementApi *pGpuMgmt,
    NV0020_CTRL_GPU_MGMT_SET_SHUTDOWN_STATE_PARAMS *pParams
)
{
    return gpudbSetShutdownState(pParams->uuid);
}
