/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.monitor.WindowMetrics;
import org.fest.swing.monitor.Windows;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.util.Pair;
import org.fest.swing.util.RobotFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowStatus {
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private static final int ARBITRARY_EXTRA_VALUE = 20;
    private static int sign = 1;
    private final Windows windows;
    final Robot robot;

    WindowStatus(Windows windows) {
        this(windows, new RobotFactory());
    }

    WindowStatus(Windows windows, RobotFactory robotFactory) {
        this.windows = windows;
        Robot r = null;
        try {
            r = robotFactory.newRobotInPrimaryScreen();
        }
        catch (AWTException ignored) {
            LOGGER.log(Level.WARNING, "Error ocurred when creating a new Robot", ignored);
        }
        this.robot = r;
    }

    Windows windows() {
        return this.windows;
    }

    @RunsInEDT
    void checkIfReady(Window w) {
        if (this.robot == null) {
            return;
        }
        try {
            this.checkSafelyIfReady(w);
        }
        catch (Exception ignored) {
            LOGGER.log(Level.WARNING, "Error ocurred when checking if window is ready", ignored);
        }
    }

    private void checkSafelyIfReady(final Window w) {
        Pair<WindowMetrics, Point> metricsAndCenter = WindowStatus.metricsAndCenter(w);
        final WindowMetrics metrics = (WindowMetrics)metricsAndCenter.i;
        this.mouseMove(w, (Point)metricsAndCenter.ii);
        if (!this.windows.isShowingButNotReady(w)) {
            return;
        }
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                WindowStatus.this.makeLargeEnoughToReceiveEvents(w, metrics);
            }
        });
    }

    @RunsInEDT
    private static Pair<WindowMetrics, Point> metricsAndCenter(final Window w) {
        return GuiActionRunner.execute(new GuiQuery<Pair<WindowMetrics, Point>>(){

            @Override
            protected Pair<WindowMetrics, Point> executeInEDT() {
                WindowMetrics metrics = new WindowMetrics(w);
                return new Pair<WindowMetrics, Point>(metrics, metrics.center());
            }
        });
    }

    @RunsInEDT
    private void mouseMove(Window w, Point point) {
        int x = point.x;
        int y = point.y;
        if (x == 0 || y == 0) {
            return;
        }
        this.robot.mouseMove(x, y);
        Dimension windowSize = ComponentSizeQuery.sizeOf(w);
        if (windowSize.width > windowSize.height) {
            this.robot.mouseMove(x + sign, y);
        } else {
            this.robot.mouseMove(x, y + sign);
        }
        sign = -sign;
    }

    @RunsInCurrentThread
    private void makeLargeEnoughToReceiveEvents(Window window, WindowMetrics metrics) {
        if (!this.isEmptyFrame(window)) {
            return;
        }
        int w = Math.max(window.getWidth(), this.proposedWidth(metrics));
        int h = Math.max(window.getHeight(), this.proposedHeight(metrics));
        window.setSize(new Dimension(w, h));
    }

    @RunsInCurrentThread
    private boolean isEmptyFrame(Window w) {
        Insets insets = w.getInsets();
        return insets.top + insets.bottom == w.getHeight() || insets.left + insets.right == w.getWidth();
    }

    @RunsInCurrentThread
    private int proposedWidth(WindowMetrics metrics) {
        return metrics.leftAndRightInsets() + 20;
    }

    @RunsInCurrentThread
    private int proposedHeight(WindowMetrics metrics) {
        return metrics.topAndBottomInsets() + 20;
    }

    static int sign() {
        return sign;
    }
}

