/*
 * This file is part of the WebKit open source project.
 * This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebDOMTestTypedefs.h"

#include "KURL.h"
#include "SVGPoint.h"
#include "SerializedScriptValue.h"
#include "TestTypedefs.h"
#include "WebDOMSVGPoint.h"
#include "WebDOMString.h"
#include "WebExceptionHandler.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>
#include <wtf/text/AtomicString.h>

struct WebDOMTestTypedefs::WebDOMTestTypedefsPrivate {
    WebDOMTestTypedefsPrivate(WebCore::TestTypedefs* object = 0)
        : impl(object)
    {
    }

    RefPtr<WebCore::TestTypedefs> impl;
};

WebDOMTestTypedefs::WebDOMTestTypedefs()
    : WebDOMObject()
    , m_impl(0)
{
}

WebDOMTestTypedefs::WebDOMTestTypedefs(WebCore::TestTypedefs* impl)
    : WebDOMObject()
    , m_impl(new WebDOMTestTypedefsPrivate(impl))
{
}

WebDOMTestTypedefs::WebDOMTestTypedefs(const WebDOMTestTypedefs& copy)
    : WebDOMObject()
{
    m_impl = copy.impl() ? new WebDOMTestTypedefsPrivate(copy.impl()) : 0;
}

WebDOMTestTypedefs& WebDOMTestTypedefs::operator=(const WebDOMTestTypedefs& copy)
{
    delete m_impl;
    m_impl = copy.impl() ? new WebDOMTestTypedefsPrivate(copy.impl()) : 0;
    return *this;
}

WebCore::TestTypedefs* WebDOMTestTypedefs::impl() const
{
    return m_impl ? WTF::getPtr(m_impl->impl) : 0;
}

WebDOMTestTypedefs::~WebDOMTestTypedefs()
{
    delete m_impl;
    m_impl = 0;
}

unsigned long long WebDOMTestTypedefs::unsignedLongLongAttr() const
{
    if (!impl())
        return 0;

    return impl()->unsignedLongLongAttr();
}

void WebDOMTestTypedefs::setUnsignedLongLongAttr(unsigned long long newUnsignedLongLongAttr)
{
    if (!impl())
        return;

    impl()->setUnsignedLongLongAttr(newUnsignedLongLongAttr);
}

WebDOMString WebDOMTestTypedefs::immutableSerializedScriptValue() const
{
    if (!impl())
        return WebDOMString();

    return impl()->immutableSerializedScriptValue()->toString();
}

void WebDOMTestTypedefs::setImmutableSerializedScriptValue(const WebDOMString& newImmutableSerializedScriptValue)
{
    if (!impl())
        return;

    impl()->setImmutableSerializedScriptValue(WebCore::SerializedScriptValue::create(WTF::String(newImmutableSerializedScriptValue)));
}

int WebDOMTestTypedefs::attrWithGetterException() const
{
    if (!impl())
        return 0;

    WebCore::ExceptionCode ec = 0;
    int result = impl()->attrWithGetterException(ec);
    webDOMRaiseError(static_cast<WebDOMExceptionCode>(ec));
    return result;
}

void WebDOMTestTypedefs::setAttrWithGetterException(int newAttrWithGetterException)
{
    if (!impl())
        return;

    impl()->setAttrWithGetterException(newAttrWithGetterException);
}

int WebDOMTestTypedefs::attrWithSetterException() const
{
    if (!impl())
        return 0;

    return impl()->attrWithSetterException();
}

void WebDOMTestTypedefs::setAttrWithSetterException(int newAttrWithSetterException)
{
    if (!impl())
        return;

    WebCore::ExceptionCode ec = 0;
    impl()->setAttrWithSetterException(newAttrWithSetterException, ec);
    webDOMRaiseError(static_cast<WebDOMExceptionCode>(ec));
}

WebDOMString WebDOMTestTypedefs::stringAttrWithGetterException() const
{
    if (!impl())
        return WebDOMString();

    WebCore::ExceptionCode ec = 0;
    WebDOMString result = impl()->stringAttrWithGetterException(ec);
    webDOMRaiseError(static_cast<WebDOMExceptionCode>(ec));
    return static_cast<const WTF::String&>(result);
}

void WebDOMTestTypedefs::setStringAttrWithGetterException(const WebDOMString& newStringAttrWithGetterException)
{
    if (!impl())
        return;

    impl()->setStringAttrWithGetterException(newStringAttrWithGetterException);
}

WebDOMString WebDOMTestTypedefs::stringAttrWithSetterException() const
{
    if (!impl())
        return WebDOMString();

    return static_cast<const WTF::String&>(impl()->stringAttrWithSetterException());
}

void WebDOMTestTypedefs::setStringAttrWithSetterException(const WebDOMString& newStringAttrWithSetterException)
{
    if (!impl())
        return;

    WebCore::ExceptionCode ec = 0;
    impl()->setStringAttrWithSetterException(newStringAttrWithSetterException, ec);
    webDOMRaiseError(static_cast<WebDOMExceptionCode>(ec));
}

void WebDOMTestTypedefs::func(const WebDOMlong[]& x)
{
    if (!impl())
        return;

    impl()->func(toWebCore(x));
}

void WebDOMTestTypedefs::setShadow(float width, float height, float blur, const WebDOMString& color, float alpha)
{
    if (!impl())
        return;

    impl()->setShadow(width, height, blur, color, alpha);
}

void WebDOMTestTypedefs::nullableArrayArg(const WebDOMDOMString[]& arrayArg)
{
    if (!impl())
        return;

    impl()->nullableArrayArg(toWebCore(arrayArg));
}

WebDOMSVGPoint WebDOMTestTypedefs::immutablePointFunction()
{
    if (!impl())
        return WebDOMSVGPoint();

    return toWebKit(WTF::getPtr(impl()->immutablePointFunction()));
}

void WebDOMTestTypedefs::methodWithException()
{
    if (!impl())
        return;

    WebCore::ExceptionCode ec = 0;
    impl()->methodWithException(ec);
    webDOMRaiseError(static_cast<WebDOMExceptionCode>(ec));
}

WebCore::TestTypedefs* toWebCore(const WebDOMTestTypedefs& wrapper)
{
    return wrapper.impl();
}

WebDOMTestTypedefs toWebKit(WebCore::TestTypedefs* value)
{
    return WebDOMTestTypedefs(value);
}
