/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * JDK-8137134: invokespecial on indirect super interface is generated by Java adapter generator
 *
 * @test
 * @run
 */

var B = Java.type("jdk.nashorn.test.models.B");
var b1 = new B() {}
print(b1.a());
print(b1.b());

var b2 = new B() {
    b: function() {
        return "from B.b in script";
    }
};

print(b2.a());
print(b2.b());

var b3 = new B() {
    a: function() {
        return "from A.a in script";
    },
    b: function() {
        return "from B.b in script";
    }
};

print(b3.a());
print(b3.b());
