/* arm.v5a-linux.elf-entry.h
   created from arm.v5a-linux.elf-entry.bin, 13391 (0x344f) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V5A_LINUX_ELF_ENTRY_SIZE    13391
#define STUB_ARM_V5A_LINUX_ELF_ENTRY_ADLER32 0xef3cc668
#define STUB_ARM_V5A_LINUX_ELF_ENTRY_CRC32   0x745e4624

unsigned char stub_arm_v5a_linux_elf_entry[13391] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 184, 11,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  17,  0, 14,  0,240,  1,240,231, 14,240,160,225,  0,  0, 82,227,
/* 0x0040 */   7,  0,  0, 10,  0, 64,160,225,  1, 48,209,228,  1, 32, 66,226,
/* 0x0050 */   1, 48,192,228,  3,  0,  0, 26,  4,  0,160,225, 14,240,160,225,
/* 0x0060 */   0,  0, 82,227, 15,  0,  0, 10,  0, 48,160,225,  1, 16,192,228,
/* 0x0070 */   1, 32, 82,226, 12,  0,  0, 26,  3,  0,160,225, 14,240,160,225,
/* 0x0080 */   0,  0, 82,227, 23,  0,  0, 10,  1, 48,209,228,  1, 32, 82,226,
/* 0x0090 */   1, 48,192,228, 19,  0,  0, 26, 14,240,160,225,  7,192,160,225,
/* 0x00a0 */   7,192,160,225,129,112,160,227,  1,124,135,227,  0,  0,  0,239,
/* 0x00b0 */  12,112,160,225, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x00c0 */   6,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x00d0 */   7,192,160,225,  1,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x00e0 */  14,240,160,225,  7,192,160,225,148,112,160,227,  0,  0,  0,239,
/* 0x00f0 */  12,112,160,225, 14,240,160,225,  7,192,160,225,118,112,160,227,
/* 0x0100 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0110 */  93,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0120 */   7,192,160,225, 20,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0130 */  14,240,160,225,  7,192,160,225, 19,112,160,227,  0,  0,  0,239,
/* 0x0140 */  12,112,160,225, 14,240,160,225,  7,192,160,225, 39,112,160,227,
/* 0x0150 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0160 */   5,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0170 */   7,192,160,225,  3,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0180 */  14,240,160,225,  7,192,160,225,106,112,160,227,  0,  0,  0,239,
/* 0x0190 */  12,112,160,225, 14,240,160,225,  7,192,160,225,122,112,160,227,
/* 0x01a0 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x01b0 */  10,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x01c0 */   7,192,160,225,  4,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x01d0 */  14,240,160,225,  0,112,160,227,  7,118,160,225,  0,112,199,225,
/* 0x01e0 */   7,  0, 64,224,  7, 16,129,224,  7,192,160,225,144,112,160,227,
/* 0x01f0 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,240,  1,240,231,
/* 0x0200 */  14,240,160,225, 48, 64, 45,233, 16, 80,157,229, 12, 64,157,229,
/* 0x0210 */  37, 86,160,225,  0,192,224,227, 12,198,160,225, 12,192,192,225,
/* 0x0220 */  12,  0, 64,224, 12, 16,129,224,  7,192,160,225,192,112,160,227,
/* 0x0230 */   0,  0,  0,239, 12,112,160,225, 48,128,189,232, 14,192,160,225,
/* 0x0240 */  15,224,160,225, 12,240,160,225,  0,  0,  0,  0,254,255,255,234,
/* 0x0250 */ 254,255,255,234, 63, 32,  0,226, 31, 48,  0,226, 26,  0, 83,227,
/* 0x0260 */   5,  0,  0,154, 32,  0, 16,227, 70, 32, 66, 18, 43, 32, 66,  2,
/* 0x0270 */  64,  0,130,226, 30,255, 47,225,  2,192,160,225, 17,  0,  0,234,
/* 0x0280 */   0, 32,208,229, 32, 32,130,227,  0, 48,209,229, 32, 48,131,227,
/* 0x0290 */   3, 32, 82,224, 21,  0,  0, 26,  1,  0,128,226,  1, 16,129,226,
/* 0x02a0 */   1,192, 76,226,  1,  0,124,227,  9,  0,  0, 26,  0, 32,160,227,
/* 0x02b0 */   2,  0,160,225, 30,255, 47,225,112, 64, 45,233, 64,208, 77,226,
/* 0x02c0 */   0, 80,160,225,  1, 96,160,225, 13,  0,160,225,255, 16,160,227,
/* 0x02d0 */  64, 32,160,227,254,255,255,235,  5,  0,160,225, 13, 16,160,225,
/* 0x02e0 */ 254,255,255,235,  0, 64, 80,226, 41,  0,  0,186,184, 48,221,225,
/* 0x02f0 */  15, 58,  3,226,  1,  9, 83,227,  0, 64,160,  3, 54,  0,  0,234,
/* 0x0300 */   2,  0,116,227, 47,  0,  0, 26,  5,  0,160,225,  7, 29,160,227,
/* 0x0310 */ 254,255,255,235,  0, 64,160,225,  0, 48, 86,226,  1, 48,160, 19,
/* 0x0320 */ 164, 63, 19,224, 54,  0,  0, 10,  5,  0,160,225,  4, 16,160,225,
/* 0x0330 */ 254,255,255,235,  4,  0,160,225, 64,208,141,226,112,128,189,232,
/* 0x0340 */ 240, 65, 45,233,  0,128,160,225,  1, 96,160,225, 64,  0,  0,235,
/* 0x0350 */  47,100, 97,116, 97, 47,100, 97,116, 97, 47,  0, 14, 16,160,225,
/* 0x0360 */  11, 32,160,227,254,255,255,235,  0, 64,160,227,  0, 64,192,229,
/* 0x0370 */   8,  0,160,225,  1, 16,160,227, 23,  0,  0,235, 78,  0,  0,235,
/* 0x0380 */  47,112,114,111, 99, 47,115,101,108,102, 47, 99,109,100,108,105,
/* 0x0390 */ 110,101,  0,  0, 14,112,160,225,  7,  0,160,225,  4, 16,160,225,
/* 0x03a0 */   4, 32,160,225,254,255,255,235,  0, 64,160,225,  6, 16,160,225,
/* 0x03b0 */ 100, 33,159,229,254,255,255,235,  0, 80,160,225,  4,  0,160,225,
/* 0x03c0 */ 254,255,255,235,  0,  0, 85,227, 94,  0,  0,170,  7,  0,160,225,
/* 0x03d0 */ 254,255,255,235,  0, 48,160,227,  5, 48,198,231,  0, 48,214,229,
/* 0x03e0 */   0,  0, 83,227,  6, 16,160,  1,140,  0,  0, 10,  6, 16,160,225,
/* 0x03f0 */   1, 48,241,229,  0,  0, 83,227,101,  0,  0, 26,140,  0,  0,234,
/* 0x0400 */   1, 48,116,229, 47,  0, 83,227,105,  0,  0, 26,  1,112,100,224,
/* 0x0410 */  10,  0,136,226,  4, 16,160,225,  7, 32,160,225,254,255,255,235,
/* 0x0420 */   0, 80,160,225,  0, 96,160,227,  0, 96,192,229,  8,  0,160,225,
/* 0x0430 */   6, 16,160,225, 23,  0,  0,235, 13,  0,112,227,142,  0,  0, 26,
/* 0x0440 */ 127,  0,  0,235, 99,111,109, 46,116,101,114,109,117,120, 47,102,
/* 0x0450 */ 105,108,101,115,  0,  0,  0,  0, 14, 16,160,225, 11,  0,136,226,
/* 0x0460 */  16, 32,160,227,254,255,255,235,  4, 16,160,225,  7, 32,160,225,
/* 0x0470 */ 254,255,255,235,  0, 80,160,225,  0, 96,192,229,  8,  0,160,225,
/* 0x0480 */   1, 16,160,227, 23,  0,  0,235,142,  0,  0,234,  1, 64,160,225,
/* 0x0490 */ 105,  0,  0,234,145,  0,  0,235, 47, 99, 97, 99,104,101,  0,  0,
/* 0x04a0 */  14, 16,160,225,  5,  0,160,225,  6, 32,160,227,254,255,255,235,
/* 0x04b0 */   0, 64,160,225,  0, 96,160,227,  0, 96,192,229,  8,  0,160,225,
/* 0x04c0 */   1, 16,160,227, 23,  0,  0,235,158,  0,  0,235, 47,117,112,120,
/* 0x04d0 */   0,  0,  0,  0, 14, 16,160,225,  4,  0,160,225,  4, 32,160,227,
/* 0x04e0 */ 254,255,255,235,  0, 64,160,225,254,255,255,235,  0, 80,160,225,
/* 0x04f0 */ 254,255,255,235,  0,  0,196,229, 37,  3,160,225,254,255,255,235,
/* 0x0500 */   1,  0,196,229, 37,  6,160,225,254,255,255,235,  2,  0,196,229,
/* 0x0510 */   3, 96,196,229,  6,  0,160,225,240,129,189,232,255, 15,  0,  0,
/* 0x0520 */ 240, 65, 45,233,  1,218, 77,226, 12,208, 77,226,  0,112,160,225,
/* 0x0530 */   1,128,160,225,  2, 96,160,225,185,  0,  0,235,117,112,120,  0,
/* 0x0540 */  14, 64,160,225,  4,  0,160,225, 16, 16,160,227,254,255,255,235,
/* 0x0550 */   0, 80,160,225, 22,  0,112,227,196,  0,  0, 26,  4,  0,160,225,
/* 0x0560 */   0, 16,160,227,254,255,255,235,  0, 80,160,225,  0,  0, 85,227,
/* 0x0570 */ 215,  0,  0,170,202,  0,  0,235, 47,100,101,118, 47,115,104,109,
/* 0x0580 */   0,  0,  0,  0, 14,  0,160,225,  8, 18,159,229,  7, 45,160,227,
/* 0x0590 */ 254,255,255,235,  0, 80, 80,226,215,  0,  0,170,213,  0,  0,235,
/* 0x05a0 */ 109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,  0,  0,  0,
/* 0x05b0 */  14,  0,160,225,254,255,255,235, 12, 64,141,226,  4,  0,160,225,
/* 0x05c0 */ 254,255,255,235,220,  0,  0,235, 97,110,100,  0, 14,  0,160,225,
/* 0x05d0 */   4, 16,160,225,  3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,
/* 0x05e0 */ 238,  0,  0, 10,228,  0,  0,235, 76,105,110,  0, 14,  0,160,225,
/* 0x05f0 */   4, 16,160,225,  3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,
/* 0x0600 */ 238,  0,  0, 26,130, 48,212,229, 52,  0, 83,227,  1, 64,160,131,
/* 0x0610 */  16,  1,  0,138,  0,  0, 86,227,247,  0,  0, 26,254,255,255,235,
/* 0x0620 */   0, 96, 80,226,112, 49,159,  5,  1, 42,141,  2, 12, 32,130,  2,
/* 0x0630 */   3, 96,194,  7, 12, 96,141,  2, 38,  0,117,227, 15,  1,  0, 26,
/* 0x0640 */   0,  0, 86,227, 15,  1,  0, 10,  0, 48,214,229,  0,  0, 83,227,
/* 0x0650 */   4,  1,  0, 26,  6,  0,160,225,  2, 27,141,226, 12, 16,129,226,
/* 0x0660 */  57,  0,  0,235,  0,  0, 80,227, 76,  1,  0,186,  6,  0,160,225,
/* 0x0670 */ 194, 16,160,227,  7, 45,160,227,254,255,255,235,  0, 80, 80,226,
/* 0x0680 */   5,  0,160,177, 76,  1,  0,186,  6,  0,160,225,254,255,255,235,
/* 0x0690 */   0, 64,160,227, 16,  1,  0,234,  0, 64,160,227,  0,  0, 87,227,
/* 0x06a0 */  23,  1,  0, 10,254,255,255,235,  0,  0,224,225,  7,  0,  0,224,
/* 0x06b0 */   7,112, 96,224,  0,128,136,224,  0,  0, 88,227, 50,  1,  0, 10,
/* 0x06c0 */   0,  0, 84,227, 33,  1,  0, 10,  5,  0,160,225,  8, 16,160,225,
/* 0x06d0 */ 254,255,255,235,  0,  0, 80,227, 50,  1,  0,170, 76,  1,  0,234,
/* 0x06e0 */   5,  0,160,225,  1, 16, 72,226,  0, 32,160,227,254,255,255,235,
/* 0x06f0 */   1, 26,224,227,  0, 64,160,227,  1, 58,141,226, 12, 48,131,226,
/* 0x0700 */   1, 64,195,231,  5,  0,160,225,  1, 16,131,224,  1, 32,160,227,
/* 0x0710 */ 254,255,255,235,  5,  0,160,225,  4, 16,160,225,  4, 32,160,225,
/* 0x0720 */ 254,255,255,235,  0,  0, 87,227,  1,192,160,  3, 62,  1,  0, 10,
/* 0x0730 */ 254,255,255,235,  0, 32,160,225,  0, 48,215,225, 74,  1,  0, 10,
/* 0x0740 */   5,  0,160,225,  7, 16,160,225,  0, 32, 98,226,254,255,255,235,
/* 0x0750 */  74,  1,  0,234,  0, 80,141,229,  0, 48,160,227,  4, 48,141,229,
/* 0x0760 */   7,  0,160,225,  8, 16,160,225,  3, 32,160,227, 12, 48,160,225,
/* 0x0770 */ 254,255,255,235,  1, 10,112,227,  1, 48,133,146,  3,  0,128,145,
/* 0x0780 */  76,  1,  0,234, 17,192,160,227, 62,  1,  0,234, 12,208,141,226,
/* 0x0790 */   1,218,141,226,240,129,189,232,  2, 64, 64,  0,  0,240,255,255,
/* 0x07a0 */ 240, 64, 45,233,  8,208, 77,226,  0,112,160,225,  1, 96,160,225,
/* 0x07b0 */   4,  0,  0,235,117,112,120,  0, 14, 64,160,225,  4,  0,160,225,
/* 0x07c0 */  16, 16,160,227,254,255,255,235,  0, 80,160,225, 22,  0,112,227,
/* 0x07d0 */  15,  0,  0, 26,  4,  0,160,225,  0, 16,160,227,254,255,255,235,
/* 0x07e0 */   0, 80,160,225,  0,  0, 85,227, 53,  0,  0,170, 21,  0,  0,235,
/* 0x07f0 */  47,100,101,118, 47,115,104,109,  0,  0,  0,  0, 14,  0,160,225,
/* 0x0800 */ 212, 16,159,229,  7, 45,160,227,254,255,255,235,  0, 80, 80,226,
/* 0x0810 */  53,  0,  0,170, 21,  0,117,227,  5, 64,160, 17, 74,  0,  0, 26,
/* 0x0820 */  47,  0,  0,235, 85, 80, 88, 45, 53, 46, 48, 32,119, 97,110,116,
/* 0x0830 */ 115, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 40, 41,
/* 0x0840 */  44, 32,111,114, 32,110,101,101,100,115, 32, 47,100,101,118, 47,
/* 0x0850 */ 115,104,109, 40, 44, 79, 95, 84, 77, 80, 70, 73, 76, 69, 44, 41,
/* 0x0860 */  10,  0,  0,  0, 14, 16,160,225,  2,  0,160,227, 61, 32,160,227,
/* 0x0870 */ 254,255,255,235,127,  0,160,227,254,255,255,235,  5,  0,160,225,
/* 0x0880 */   6, 16,160,225,254,255,255,235,  0,  0, 80,227,  0, 64,160,177,
/* 0x0890 */  74,  0,  0,186,  0, 80,141,229,  0, 48,160,227,  4, 48,141,229,
/* 0x08a0 */   7,  0,160,225,  6, 16,160,225,  3, 32,160,227,  3,  0, 87,225,
/* 0x08b0 */   1, 48,160,  3, 17, 48,160, 19,254,255,255,235,  0, 64,160,225,
/* 0x08c0 */ 254,255,255,235,  4,  0, 80,225,  1, 48,132,130,  3, 64,133,128,
/* 0x08d0 */   4,  0,160,225,  8,208,141,226,240,128,189,232,  2, 64, 64,  0,
/* 0x08e0 */   0,  0,  0,  0,  3, 64, 45,233, 20,208, 77,226, 36,  0,141,226,
/* 0x08f0 */  95,  0,  0,235, 95,  0,  0,235,  6,  0,176,232,  6,  0, 81,227,
/* 0x0900 */  10,  0,  0, 10,  0,  0, 81,227,  4,  0,  0, 26,  1, 42,160,227,
/* 0x0910 */   2, 32,224,225,  1, 32,130,226,  2,128,160,225, 72, 16, 31,229,
/* 0x0920 */  76,  0, 79,226,  1,  0, 64,224,  8,  0,141,229,  1,144,160,225,
/* 0x0930 */  88,  0, 31,229, 28,  0,141,229,128,  0,  0,235,  4,160,142,226,
/* 0x0940 */   0,112,154,229,  1, 12,160,227, 45,  0,128,226,  0, 96,135,224,
/* 0x0950 */  16, 96,141,229, 13,176,160,225,  0,208, 77,224,  7,208,205,227,
/* 0x0960 */   0,  0,160,227, 13, 16,160,225,  1,  0,161,232, 11,  0, 81,225,
/* 0x0970 */  32,  0,  0, 58, 13, 32,160,225,  6, 16,160,225,  0,  0,160,227,
/* 0x0980 */ 254,255,255,235,  2, 11, 16,227, 42,  0,  0, 90,240,  1,240,231,
/* 0x0990 */  32, 22,160,225,  1, 22,160,225,  1,  0, 64,224,  1,  0, 64,226,
/* 0x09a0 */   7, 32,129,224, 20, 32,130,226,  7, 32,194,227,  8,  0,189,232,
/* 0x09b0 */   8,  0,162,232, 11,  0, 93,225, 49,  0,  0, 58, 12, 16,141,229,
/* 0x09c0 */   0,176,160,225, 20, 64,135,226,  7, 64,196,227, 28, 48,157,229,
/* 0x09d0 */   8, 32,160,225, 28,  0,129,232,128,  0, 45,233, 13, 48,160,225,
/* 0x09e0 */  12, 32,129,226,  8,  0,218,229,  1,  0, 45,233,  4, 16,154,229,
/* 0x09f0 */  12,  0,138,226, 99,  0,  0,235,  8,208,141,226, 16, 32,157,229,
/* 0x0a00 */  12, 16,157,229, 11,  0,160,225,  7,192,160,225,  4,112,160,227,
/* 0x0a10 */   0,  0,  0,239, 12,112,160,225,  0, 80,160,227, 11, 64,160,225,
/* 0x0a20 */  18, 48,160,227,  5, 32,160,227, 16, 16,157,229, 12,  0,157,229,
/* 0x0a30 */ 192,112,160,227,  0,  0,  0,239, 11,  0,160,225,  6,112,160,227,
/* 0x0a40 */   0,  0,  0,239,  8,  0,157,229,  4, 16, 26,229,  1, 64,128,224,
/* 0x0a50 */   2, 16,193,227,  1, 80, 73,224, 48,  0,141,232, 12,192,157,229,
/* 0x0a60 */  12,240,140,226,  4, 16,144,228,  0,  0, 81,227, 95,  0,  0, 26,
/* 0x0a70 */  14,240,160,225,  0, 16,129,224, 62, 64, 45,233,  0, 80,224,227,
/* 0x0a80 */   2, 65,160,227,124,  0,  0,234, 26,  0,189,232,  1,  0, 64,224,
/* 0x0a90 */   3, 32, 66,224,  0, 32,132,229, 48,128,189,232,  4, 64,148,224,
/* 0x0aa0 */  14,240,160, 17,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,
/* 0x0ab0 */  14,240,160,225,  1, 16,160,227, 14,192,160,225,109,  0,  0,235,
/* 0x0ac0 */   1, 16,177,224,109,  0,  0,235,117,  0,  0, 58, 12,240,160,225,
/* 0x0ad0 */   1, 48,208,228,  1, 48,194,228,109,  0,  0,235,122,  0,  0, 42,
/* 0x0ae0 */ 115,  0,  0,235,  3, 48, 81,226,  0, 16,160,227,134,  0,  0, 58,
/* 0x0af0 */   1, 80,208,228,  3, 84,133,225,  5, 80,240,225,104,  0,  0, 10,
/* 0x0b00 */ 109,  0,  0,235,  1, 16,177,224,109,  0,  0,235,  1, 16,177,224,
/* 0x0b10 */ 141,  0,  0, 26,115,  0,  0,235,  2, 16,129,226, 13, 12,117,227,
/* 0x0b20 */   1, 16,129, 50,  5, 48,210,231,  1, 16, 81,226,  1, 48,194,228,
/* 0x0b30 */ 143,  0,  0, 42,124,  0,  0,234,  0,  0,224,227,  0,  6,160,225,
/* 0x0b40 */  14,240,160,225,  0, 46,115,121,109,116, 97, 98,  0, 46,115,116,
/* 0x0b50 */ 114,116, 97, 98,  0, 46,115,104,115,116,114,116, 97, 98,  0, 69,
/* 0x0b60 */  76, 70, 77, 65, 73, 78, 89,  0, 46,114,101,108, 69, 76, 70, 77,
/* 0x0b70 */  65, 73, 78, 90,  0, 46,114,101,108, 72, 85, 77, 70, 95, 65,  0,
/* 0x0b80 */  46,114,101,108, 72, 85, 77, 70, 95, 76,  0, 46,114,101,108, 85,
/* 0x0b90 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,114,101,108, 85,
/* 0x0ba0 */  77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108, 69, 76, 70,
/* 0x0bb0 */  77, 65, 73, 78, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0be0 */  27,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bf0 */  52,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c00 */   1,  0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  1,  0,  0,  0,
/* 0x0c10 */   6,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0, 24,  2,  0,  0,
/* 0x0c20 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c30 */  36,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c40 */  12, 18,  0,  0, 56,  0,  0,  0, 15,  0,  0,  0,  2,  0,  0,  0,
/* 0x0c50 */   4,  0,  0,  0,  8,  0,  0,  0, 53,  0,  0,  0,  1,  0,  0,  0,
/* 0x0c60 */   6,  0,  0,  0,  0,  0,  0,  0, 76,  2,  0,  0,  4,  0,  0,  0,
/* 0x0c70 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c80 */  49,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c90 */  68, 18,  0,  0,  8,  0,  0,  0, 15,  0,  0,  0,  4,  0,  0,  0,
/* 0x0ca0 */   4,  0,  0,  0,  8,  0,  0,  0, 64,  0,  0,  0,  1,  0,  0,  0,
/* 0x0cb0 */   6,  0,  0,  0,  0,  0,  0,  0, 80,  2,  0,  0,  4,  0,  0,  0,
/* 0x0cc0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cd0 */  60,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ce0 */  76, 18,  0,  0,  8,  0,  0,  0, 15,  0,  0,  0,  6,  0,  0,  0,
/* 0x0cf0 */   4,  0,  0,  0,  8,  0,  0,  0, 75,  0,  0,  0,  1,  0,  0,  0,
/* 0x0d00 */   6,  0,  0,  0,  0,  0,  0,  0, 84,  2,  0,  0, 76,  5,  0,  0,
/* 0x0d10 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d20 */  71,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d30 */  84, 18,  0,  0,208,  2,  0,  0, 15,  0,  0,  0,  8,  0,  0,  0,
/* 0x0d40 */   4,  0,  0,  0,  8,  0,  0,  0, 91,  0,  0,  0,  1,  0,  0,  0,
/* 0x0d50 */   6,  0,  0,  0,  0,  0,  0,  0,160,  7,  0,  0, 64,  1,  0,  0,
/* 0x0d60 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d70 */  87,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d80 */  36, 21,  0,  0,128,  0,  0,  0, 15,  0,  0,  0, 10,  0,  0,  0,
/* 0x0d90 */   4,  0,  0,  0,  8,  0,  0,  0,105,  0,  0,  0,  1,  0,  0,  0,
/* 0x0da0 */   6,  0,  0,  0,  0,  0,  0,  0,224,  8,  0,  0,100,  2,  0,  0,
/* 0x0db0 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0dc0 */ 101,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0dd0 */ 164, 21,  0,  0,216,  0,  0,  0, 15,  0,  0,  0, 12,  0,  0,  0,
/* 0x0de0 */   4,  0,  0,  0,  8,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x0df0 */   0,  0,  0,  0,  0,  0,  0,  0, 68, 11,  0,  0,114,  0,  0,  0,
/* 0x0e00 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e10 */   1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e20 */  96, 14,  0,  0,128,  2,  0,  0, 16,  0,  0,  0,  8,  0,  0,  0,
/* 0x0e30 */   4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x0e40 */   0,  0,  0,  0,  0,  0,  0,  0,224, 16,  0,  0, 43,  1,  0,  0,
/* 0x0e50 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  2,  0,
/* 0x0e80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  8,  0,
/* 0x0e90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 10,  0,
/* 0x0ea0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 12,  0,
/* 0x0eb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x0ec0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  4,  0,
/* 0x0ed0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  6,  0,
/* 0x0ee0 */   1,  0,  0,  0, 88,  2,  0,  0,  0,  0,  0,  0, 16,  0, 12,  0,
/* 0x0ef0 */  15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,
/* 0x0f00 */  20,  0,  0,  0,236,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0f10 */  27,  0,  0,  0,100,  2,  0,  0,  0,  0,  0,  0, 16,  0, 12,  0,
/* 0x0f20 */  43,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0f30 */  50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,
/* 0x0f40 */  58,  0,  0,  0,160,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0f50 */  64,  0,  0,  0, 76,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0f60 */  72,  0,  0,  0,216,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0f70 */  82,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0f80 */  88,  0,  0,  0,204,  2,  0,  0,128,  2,  0,  0, 18,  0,  8,  0,
/* 0x0f90 */ 112,  0,  0,  0,208,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0fa0 */ 117,  0,  0,  0,  0,  0,  0,  0, 64,  1,  0,  0, 18,  0, 10,  0,
/* 0x0fb0 */ 139,  0,  0,  0,100,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0fc0 */ 145,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,
/* 0x0fd0 */ 160,  0,  0,  0,140,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0fe0 */ 166,  0,  0,  0,176,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x0ff0 */ 176,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1000 */ 191,  0,  0,  0,104,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1010 */ 204,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 16,  0, 12,  0,
/* 0x1020 */ 211,  0,  0,  0, 60,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1030 */ 216,  0,  0,  0,120,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1040 */ 223,  0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1050 */ 230,  0,  0,  0,148,  1,  0,  0,196,  0,  0,  0, 18,  0, 12,  0,
/* 0x1060 */ 253,  0,  0,  0,200,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1070 */   5,  1,  0,  0,196,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1080 */  11,  1,  0,  0, 80,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x1090 */  16,  1,  0,  0, 24,  2,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x10a0 */  21,  1,  0,  0,156,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x10b0 */  26,  1,  0,  0, 40,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x10c0 */  31,  1,  0,  0, 20,  1,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x10d0 */  37,  1,  0,  0,136,  0,  0,  0,  0,  0,  0,  0, 16,  0,  2,  0,
/* 0x10e0 */   0,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0, 77,
/* 0x10f0 */  70, 76, 71,  0,103,101,116,112,105,100,  0,117,112,120, 95,109,
/* 0x1100 */ 109, 97,112, 95, 97,110,100, 95,102,100,  0,109,101,109, 99,112,
/* 0x1110 */ 121,  0, 79, 95, 66, 73, 78, 70, 79,  0, 80,115,121,110, 99,  0,
/* 0x1120 */ 109,101,109,112, 99,112,121,  0,102,116,114,117,110, 99, 97,116,
/* 0x1130 */ 101,  0,108,115,101,101,107,  0,117,112,120, 95,109,109, 97,112,
/* 0x1140 */  95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100,  0,
/* 0x1150 */ 109,109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x1160 */ 100, 95,102,100, 95,108,105,110,117,120,  0,117,110, 97,109,101,
/* 0x1170 */   0,101,110,100, 95,100,101, 99,111,109,112,114,101,115,115,  0,
/* 0x1180 */ 119,114,105,116,101,  0,102,100, 97,116, 97,115,121,110, 99,  0,
/* 0x1190 */ 103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104,  0,109,
/* 0x11a0 */ 101,109,102,100, 95, 99,114,101, 97,116,101,  0, 95,115,116, 97,
/* 0x11b0 */ 114,116,  0,114,101, 97,100,  0,117,110,108,105,110,107,  0,109,
/* 0x11c0 */ 101,109,115,101,116,  0,117, 99,108, 95,110,114,118, 50, 98, 95,
/* 0x11d0 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56,  0,109,121, 95,
/* 0x11e0 */  98,107,112,116,  0,102,115,121,110, 99,  0,115,116, 97,116,  0,
/* 0x11f0 */  99,112,114, 48,  0,101,120,105,116,  0,111,112,101,110,  0,109,
/* 0x1200 */ 107,100,105,114,  0, 99,108,111,115,101,  0,  0, 12,  0,  0,  0,
/* 0x1210 */   1,  1,  0,  0, 32,  0,  0,  0,  1,  1,  0,  0, 48,  0,  0,  0,
/* 0x1220 */   1,  1,  0,  0, 64,  0,  0,  0,  1,  1,  0,  0, 80,  0,  0,  0,
/* 0x1230 */   1,  1,  0,  0, 96,  0,  0,  0,  1,  1,  0,  0, 20,  2,  0,  0,
/* 0x1240 */   2, 13,  0,  0,  0,  0,  0,  0,  1, 18,  0,  0,  0,  0,  0,  0,
/* 0x1250 */   1, 20,  0,  0, 12,  0,  0,  0,  1,  2,  0,  0, 40,  0,  0,  0,
/* 0x1260 */   1,  2,  0,  0, 64,  0,  0,  0,  1,  2,  0,  0, 84,  0,  0,  0,
/* 0x1270 */   1,  2,  0,  0,128,  0,  0,  0,  1, 30,  0,  0,140,  0,  0,  0,
/* 0x1280 */   1, 34,  0,  0,148,  0,  0,  0,  1,  2,  0,  0,168,  0,  0,  0,
/* 0x1290 */   1,  2,  0,  0,176,  0,  0,  0,  1,  2,  0,  0,188,  0,  0,  0,
/* 0x12a0 */   1, 38,  0,  0,208,  0,  0,  0,  1,  2,  0,  0,220,  0,  0,  0,
/* 0x12b0 */   1, 32,  0,  0,248,  0,  0,  0,  1,  2,  0,  0, 16,  1,  0,  0,
/* 0x12c0 */   1, 15,  0,  0, 36,  1,  0,  0,  1,  2,  0,  0, 40,  1,  0,  0,
/* 0x12d0 */   1,  2,  0,  0, 80,  1,  0,  0,  1, 37,  0,  0, 96,  1,  0,  0,
/* 0x12e0 */   1, 28,  0,  0,108,  1,  0,  0,  1, 39,  0,  0,116,  1,  0,  0,
/* 0x12f0 */   1,  2,  0,  0,124,  1,  0,  0,  1, 32,  0,  0,148,  1,  0,  0,
/* 0x1300 */   1,  2,  0,  0,164,  1,  0,  0,  1,  2,  0,  0,168,  1,  0,  0,
/* 0x1310 */   1,  2,  0,  0,180,  1,  0,  0,  1,  2,  0,  0,200,  1,  0,  0,
/* 0x1320 */   1, 15,  0,  0,224,  1,  0,  0,  1,  2,  0,  0,232,  1,  0,  0,
/* 0x1330 */   1,  2,  0,  0,236,  1,  0,  0,  1,  2,  0,  0, 16,  2,  0,  0,
/* 0x1340 */   1, 15,  0,  0, 28,  2,  0,  0,  1, 15,  0,  0, 48,  2,  0,  0,
/* 0x1350 */   1,  2,  0,  0, 52,  2,  0,  0,  1,  2,  0,  0, 60,  2,  0,  0,
/* 0x1360 */   1,  2,  0,  0, 64,  2,  0,  0,  1,  2,  0,  0, 88,  2,  0,  0,
/* 0x1370 */   1, 15,  0,  0,112,  2,  0,  0,  1,  2,  0,  0,116,  2,  0,  0,
/* 0x1380 */   1,  2,  0,  0,140,  2,  0,  0,  1, 15,  0,  0,148,  2,  0,  0,
/* 0x1390 */   1, 10,  0,  0,156,  2,  0,  0,  1,  2,  0,  0,168,  2,  0,  0,
/* 0x13a0 */   1,  2,  0,  0,180,  2,  0,  0,  1,  2,  0,  0,228,  2,  0,  0,
/* 0x13b0 */   1,  2,  0,  0,248,  2,  0,  0,  1, 26,  0,  0,  4,  3,  0,  0,
/* 0x13c0 */   1,  2,  0,  0, 16,  3,  0,  0,  1, 26,  0,  0, 28,  3,  0,  0,
/* 0x13d0 */   1,  2,  0,  0, 32,  3,  0,  0,  1,  2,  0,  0, 60,  3,  0,  0,
/* 0x13e0 */   1, 37,  0,  0, 68,  3,  0,  0,  1,  2,  0,  0, 72,  3,  0,  0,
/* 0x13f0 */   1,  2,  0,  0, 96,  3,  0,  0,  1, 32,  0,  0,108,  3,  0,  0,
/* 0x1400 */   1, 21,  0,  0,112,  3,  0,  0,  1,  2,  0,  0,132,  3,  0,  0,
/* 0x1410 */   1,  2,  0,  0,140,  3,  0,  0,  1,  2,  0,  0,144,  3,  0,  0,
/* 0x1420 */   1,  2,  0,  0,164,  3,  0,  0,  1,  2,  0,  0,172,  3,  0,  0,
/* 0x1430 */   1,  2,  0,  0,188,  3,  0,  0,  1,  2,  0,  0,196,  3,  0,  0,
/* 0x1440 */   1,  2,  0,  0,200,  3,  0,  0,  1, 25,  0,  0,232,  3,  0,  0,
/* 0x1450 */   1,  2,  0,  0,240,  3,  0,  0,  1,  2,  0,  0,252,  3,  0,  0,
/* 0x1460 */   1,  2,  0,  0, 12,  4,  0,  0,  1,  2,  0,  0, 20,  4,  0,  0,
/* 0x1470 */   1,  2,  0,  0, 36,  4,  0,  0,  1, 37,  0,  0, 48,  4,  0,  0,
/* 0x1480 */   1,  2,  0,  0, 56,  4,  0,  0,  1, 29,  0,  0, 64,  4,  0,  0,
/* 0x1490 */   1,  2,  0,  0, 76,  4,  0,  0,  1,  2,  0,  0, 80,  4,  0,  0,
/* 0x14a0 */   1,  8,  0,  0,104,  4,  0,  0,  1,  2,  0,  0,112,  4,  0,  0,
/* 0x14b0 */   1,  2,  0,  0,124,  4,  0,  0,  1, 16,  0,  0,132,  4,  0,  0,
/* 0x14c0 */   1,  2,  0,  0,136,  4,  0,  0,  1,  2,  0,  0,152,  4,  0,  0,
/* 0x14d0 */   1, 17,  0,  0,188,  4,  0,  0,  1, 23,  0,  0,204,  4,  0,  0,
/* 0x14e0 */   1, 17,  0,  0,216,  4,  0,  0,  1,  2,  0,  0,220,  4,  0,  0,
/* 0x14f0 */   1,  8,  0,  0,232,  4,  0,  0,  1,  2,  0,  0,248,  4,  0,  0,
/* 0x1500 */   1, 23,  0,  0,252,  4,  0,  0,  1,  2,  0,  0, 28,  5,  0,  0,
/* 0x1510 */   1, 19,  0,  0, 44,  5,  0,  0,  1,  2,  0,  0, 52,  5,  0,  0,
/* 0x1520 */   1,  2,  0,  0, 16,  0,  0,  0,  1,  3,  0,  0, 36,  0,  0,  0,
/* 0x1530 */   1, 26,  0,  0, 48,  0,  0,  0,  1,  3,  0,  0, 60,  0,  0,  0,
/* 0x1540 */   1, 26,  0,  0, 72,  0,  0,  0,  1,  3,  0,  0, 76,  0,  0,  0,
/* 0x1550 */   1,  3,  0,  0,104,  0,  0,  0,  1, 37,  0,  0,112,  0,  0,  0,
/* 0x1560 */   1,  3,  0,  0,124,  0,  0,  0,  1,  3,  0,  0,128,  0,  0,  0,
/* 0x1570 */   1,  3,  0,  0,208,  0,  0,  0,  1, 23,  0,  0,216,  0,  0,  0,
/* 0x1580 */   1, 36,  0,  0,228,  0,  0,  0,  1, 16,  0,  0,240,  0,  0,  0,
/* 0x1590 */   1,  3,  0,  0, 24,  1,  0,  0,  1, 19,  0,  0, 32,  1,  0,  0,
/* 0x15a0 */   1,  8,  0,  0,  0,  0,  0,  0,  2,  9,  0,  0, 16,  0,  0,  0,
/* 0x15b0 */   1,  4,  0,  0, 20,  0,  0,  0,  1,  4,  0,  0, 32,  0,  0,  0,
/* 0x15c0 */   1,  4,  0,  0, 40,  0,  0,  0,  1,  4,  0,  0, 88,  0,  0,  0,
/* 0x15d0 */   1,  1,  0,  0,144,  0,  0,  0,  1,  4,  0,  0,160,  0,  0,  0,
/* 0x15e0 */   1, 11,  0,  0,168,  0,  0,  0,  1,  4,  0,  0,216,  0,  0,  0,
/* 0x15f0 */   1,  4,  0,  0, 20,  1,  0,  0,  1,  4,  0,  0,140,  1,  0,  0,
/* 0x1600 */   1,  4,  0,  0,164,  1,  0,  0,  1,  4,  0,  0,220,  1,  0,  0,
/* 0x1610 */   1,  4,  0,  0,228,  1,  0,  0,  1,  4,  0,  0,232,  1,  0,  0,
/* 0x1620 */   1,  4,  0,  0,248,  1,  0,  0,  1,  4,  0,  0,252,  1,  0,  0,
/* 0x1630 */   1,  4,  0,  0,  0,  2,  0,  0,  1,  4,  0,  0, 12,  2,  0,  0,
/* 0x1640 */   1,  4,  0,  0, 28,  2,  0,  0,  1,  4,  0,  0, 32,  2,  0,  0,
/* 0x1650 */   1,  4,  0,  0, 40,  2,  0,  0,  1,  4,  0,  0, 48,  2,  0,  0,
/* 0x1660 */   1,  4,  0,  0, 52,  2,  0,  0,  1,  4,  0,  0, 80,  2,  0,  0,
/* 0x1670 */   1,  4,  0,  0, 84,  2,  0,  0,  1,  4,  0,  0,102,105,108,101,
/* 0x1680 */  32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45,108,105,
/* 0x1690 */ 116,116,108,101, 97,114,109, 10, 10, 83,101, 99,116,105,111,110,
/* 0x16a0 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x16b0 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x16c0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32,
/* 0x16d0 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x16e0 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70,
/* 0x16f0 */  77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32,
/* 0x1700 */  32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1710 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 69, 76, 70, 77,
/* 0x1720 */  65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 50, 49, 56, 32, 32,
/* 0x1730 */  48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1740 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 72, 85,
/* 0x1750 */  77, 70, 95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32,
/* 0x1760 */  48, 32, 32, 48, 32, 32, 48, 50, 52, 99, 32, 32, 50, 42, 42, 48,
/* 0x1770 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 72,
/* 0x1780 */  85, 77, 70, 95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32,
/* 0x1790 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 48, 32, 32, 50, 42, 42,
/* 0x17a0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x17b0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 32, 32, 48, 53,
/* 0x17c0 */  52, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 52, 32, 32,
/* 0x17d0 */  50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x17e0 */  32, 53, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32,
/* 0x17f0 */  32, 48, 49, 52, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 97,
/* 0x1800 */  48, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1810 */  83, 10, 32, 32, 54, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32,
/* 0x1820 */  32, 32, 32, 32, 48, 50, 54, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1830 */  48, 56,101, 48, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84,
/* 0x1840 */  69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76,
/* 0x1850 */  69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1860 */  32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69,
/* 0x1870 */  76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1880 */  32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x1890 */  82, 79, 73, 68, 32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x18a0 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x18b0 */  32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 32,
/* 0x18c0 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x18d0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65,
/* 0x18e0 */  73, 78, 88, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x18f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1900 */  69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32, 69, 76, 70, 77, 65,
/* 0x1910 */  73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1920 */  32, 32,100, 32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72, 85,
/* 0x1930 */  77, 70, 95, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1940 */  32, 32, 32,100, 32, 32, 72, 85, 77, 70, 95, 76, 32, 48, 32, 72,
/* 0x1950 */  85, 77, 70, 95, 76, 10, 48, 48, 48, 48, 48, 50, 53, 56, 32,103,
/* 0x1960 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32,
/* 0x1970 */  48, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10,
/* 0x1980 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1990 */  32, 42, 85, 78, 68, 42, 32, 48, 32, 77, 70, 76, 71, 10, 48, 48,
/* 0x19a0 */  48, 48, 48, 48,101, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x19b0 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,103,101,116,112,105,100,
/* 0x19c0 */  10, 48, 48, 48, 48, 48, 50, 54, 52, 32,103, 32, 32, 32, 32, 32,
/* 0x19d0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32,117,112,120,
/* 0x19e0 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1a00 */  70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109, 99,112,121, 10,
/* 0x1a10 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1a20 */  32, 42, 85, 78, 68, 42, 32, 48, 32, 79, 95, 66, 73, 78, 70, 79,
/* 0x1a30 */  10, 48, 48, 48, 48, 48, 49, 97, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1a40 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 80,115,121,
/* 0x1a50 */ 110, 99, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32,103, 32, 32, 32,
/* 0x1a60 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,
/* 0x1a70 */ 101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 48,100, 56, 32,
/* 0x1a80 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1a90 */  32, 48, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48, 48,
/* 0x1aa0 */  48, 48, 49, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1ab0 */  70, 77, 65, 73, 78, 90, 32, 48, 32,108,115,101,101,107, 10, 48,
/* 0x1ac0 */  48, 48, 48, 48, 50, 99, 99, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x1ad0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 48, 50, 56, 48,
/* 0x1ae0 */  32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x1af0 */  95, 97,110,100,114,111,105,100, 10, 48, 48, 48, 48, 48, 49,100,
/* 0x1b00 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1b10 */  78, 90, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x1b20 */  48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 76,
/* 0x1b30 */  73, 78, 85, 88, 32, 48, 49, 52, 48, 32,117,112,120, 95,109,109,
/* 0x1b40 */  97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120, 10,
/* 0x1b50 */  48, 48, 48, 48, 48, 49, 54, 52, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1b60 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,117,110, 97,109,
/* 0x1b70 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32,
/* 0x1b80 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32,101,110,
/* 0x1b90 */ 100, 95,100,101, 99,111,109,112,114,101,115,115, 10, 48, 48, 48,
/* 0x1ba0 */  48, 48, 49, 56, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1bb0 */  70, 77, 65, 73, 78, 90, 32, 48, 32,119,114,105,116,101, 10, 48,
/* 0x1bc0 */  48, 48, 48, 48, 48, 98, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1bd0 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,100, 97,116, 97,
/* 0x1be0 */ 115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32,
/* 0x1bf0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x1c00 */  32,103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104, 10,
/* 0x1c10 */  48, 48, 48, 48, 48, 48, 54, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1c20 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109,102,
/* 0x1c30 */ 100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c40 */  52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1c50 */  78, 88, 32, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48,
/* 0x1c60 */  48, 49, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1c70 */  77, 65, 73, 78, 90, 32, 48, 32,114,101, 97,100, 10, 48, 48, 48,
/* 0x1c80 */  48, 48, 49, 55, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1c90 */  70, 77, 65, 73, 78, 90, 32, 48, 32,117,110,108,105,110,107, 10,
/* 0x1ca0 */  48, 48, 48, 48, 48, 48, 50, 99, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1cb0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109,115,
/* 0x1cc0 */ 101,116, 10, 48, 48, 48, 48, 48, 49, 57, 52, 32,103, 32, 32, 32,
/* 0x1cd0 */  32, 32, 70, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 99, 52,
/* 0x1ce0 */  32,117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,
/* 0x1cf0 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 49, 99, 56,
/* 0x1d00 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1d10 */  90, 32, 48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48,
/* 0x1d20 */  48, 48, 99, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x1d30 */  77, 65, 73, 78, 90, 32, 48, 32,102,115,121,110, 99, 10, 48, 48,
/* 0x1d40 */  48, 48, 48, 49, 53, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1d50 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,115,116, 97,116, 10, 48,
/* 0x1d60 */  48, 48, 48, 48, 50, 49, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d70 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,112,114, 48, 10,
/* 0x1d80 */  48, 48, 48, 48, 48, 48, 57, 99, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1d90 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,101,120,105,116,
/* 0x1da0 */  10, 48, 48, 48, 48, 48, 49, 50, 56, 32,103, 32, 32, 32, 32, 32,
/* 0x1db0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,111,112,101,
/* 0x1dc0 */ 110, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32,103, 32, 32, 32, 32,
/* 0x1dd0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,107,
/* 0x1de0 */ 100,105,114, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32,103, 32, 32,
/* 0x1df0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1e00 */  99,108,111,115,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1e10 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,
/* 0x1e20 */  76, 70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x1e30 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e40 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x1e50 */  48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1e60 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x1e70 */  48, 48, 48, 48, 48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1e80 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1e90 */  78, 90, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82,
/* 0x1ea0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1eb0 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32,
/* 0x1ec0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1ed0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x1ee0 */  48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1ef0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x1f00 */  48, 48, 48, 48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1f10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1f20 */  78, 90, 10, 48, 48, 48, 48, 48, 50, 49, 52, 32, 82, 95, 65, 82,
/* 0x1f30 */  77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 79, 95,
/* 0x1f40 */  66, 73, 78, 70, 79, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1f50 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72,
/* 0x1f60 */  85, 77, 70, 95, 65, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1f70 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f80 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f90 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1fa0 */  32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x1fb0 */  95,102,100, 95, 97,110,100,114,111,105,100, 10, 10, 82, 69, 76,
/* 0x1fc0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x1fd0 */  70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70,
/* 0x1fe0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1ff0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2000 */  48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2010 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109,
/* 0x2020 */  97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120, 10,
/* 0x2030 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x2040 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 65, 78, 68,
/* 0x2050 */  82, 79, 73, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x2060 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2070 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x2080 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2090 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x20a0 */  48, 48, 48, 48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x20b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x20c0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82,
/* 0x20d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x20e0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x20f0 */  48, 48, 48, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2100 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2110 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65,
/* 0x2120 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x2130 */ 101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82,
/* 0x2140 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2150 */  32,115,116, 97,116, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82,
/* 0x2160 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2170 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2180 */  48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2190 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x21a0 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65,
/* 0x21b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x21c0 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x21d0 */  48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x21e0 */  32, 32, 32, 32, 32, 32,109,107,100,105,114, 10, 48, 48, 48, 48,
/* 0x21f0 */  48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2200 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2210 */  73, 68, 10, 48, 48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82,
/* 0x2220 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,121,
/* 0x2230 */  95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,102, 56, 32, 82,
/* 0x2240 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2250 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2260 */  48, 48, 49, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2270 */  32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10,
/* 0x2280 */  48, 48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2290 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x22a0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32,
/* 0x22b0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x22c0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x22d0 */  48, 48, 48, 49, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x22e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48,
/* 0x22f0 */  48, 48, 48, 49, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2300 */  52, 32, 32, 32, 32, 32, 32, 32, 32,114,101, 97,100, 10, 48, 48,
/* 0x2310 */  48, 48, 48, 49, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2320 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48,
/* 0x2330 */  48, 48, 48, 48, 49, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2340 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2350 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 55, 99, 32, 82,
/* 0x2360 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2370 */  32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 49, 57,
/* 0x2380 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2390 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x23a0 */  48, 48, 48, 48, 48, 49, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x23b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x23c0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97, 56, 32,
/* 0x23d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x23e0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x23f0 */  48, 48, 48, 49, 98, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2400 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2410 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 99, 56, 32, 82, 95,
/* 0x2420 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2430 */ 109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49,101, 48,
/* 0x2440 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2450 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2460 */  48, 48, 48, 48, 49,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2470 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2480 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 99, 32, 82,
/* 0x2490 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x24a0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x24b0 */  48, 48, 50, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x24c0 */  32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10,
/* 0x24d0 */  48, 48, 48, 48, 48, 50, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x24e0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,
/* 0x24f0 */ 112,121, 10, 48, 48, 48, 48, 48, 50, 51, 48, 32, 82, 95, 65, 82,
/* 0x2500 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2510 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,
/* 0x2520 */  51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2530 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2540 */  10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2550 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2560 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 52, 48,
/* 0x2570 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2580 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2590 */  48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x25a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,
/* 0x25b0 */ 121, 10, 48, 48, 48, 48, 48, 50, 55, 48, 32, 82, 95, 65, 82, 77,
/* 0x25c0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x25d0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 55,
/* 0x25e0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x25f0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2600 */  48, 48, 48, 48, 48, 50, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2610 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,
/* 0x2620 */ 112,121, 10, 48, 48, 48, 48, 48, 50, 57, 52, 32, 82, 95, 65, 82,
/* 0x2630 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,
/* 0x2640 */ 116,112,105,100, 10, 48, 48, 48, 48, 48, 50, 57, 99, 32, 82, 95,
/* 0x2650 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2660 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2670 */  48, 50, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2680 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2690 */  73, 68, 10, 48, 48, 48, 48, 48, 50, 98, 52, 32, 82, 95, 65, 82,
/* 0x26a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x26b0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,
/* 0x26c0 */ 101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x26d0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x26e0 */  10, 48, 48, 48, 48, 48, 50,102, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x26f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,
/* 0x2700 */ 100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 51, 48,
/* 0x2710 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2720 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2730 */  48, 48, 48, 48, 48, 51, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2740 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,100,
/* 0x2750 */  95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 51, 49, 99,
/* 0x2760 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2770 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2780 */  48, 48, 48, 48, 51, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2790 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x27a0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32, 82,
/* 0x27b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x27c0 */  32,111,112,101,110, 10, 48, 48, 48, 48, 48, 51, 52, 52, 32, 82,
/* 0x27d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x27e0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x27f0 */  48, 48, 51, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2800 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2810 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 54, 48, 32, 82, 95, 65,
/* 0x2820 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x2830 */ 121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 51, 54, 99, 32,
/* 0x2840 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2850 */  32, 32,117,110, 97,109,101, 10, 48, 48, 48, 48, 48, 51, 55, 48,
/* 0x2860 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2870 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2880 */  48, 48, 48, 48, 51, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2890 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x28a0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 99, 32, 82,
/* 0x28b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x28c0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x28d0 */  48, 48, 51, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x28e0 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x28f0 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 97, 52, 32, 82, 95, 65,
/* 0x2900 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2910 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2920 */  51, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2930 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x2940 */  68, 10, 48, 48, 48, 48, 48, 51, 98, 99, 32, 82, 95, 65, 82, 77,
/* 0x2950 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2960 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 99,
/* 0x2970 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2980 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2990 */  48, 48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x29a0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,117,
/* 0x29b0 */ 112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48, 48, 51,
/* 0x29c0 */ 101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x29d0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x29e0 */  10, 48, 48, 48, 48, 48, 51,102, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x29f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2a00 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,102, 99,
/* 0x2a10 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2a20 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2a30 */  48, 48, 48, 48, 52, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2a40 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2a50 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 49, 52, 32, 82,
/* 0x2a60 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a70 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2a80 */  48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2a90 */  32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48,
/* 0x2aa0 */  48, 48, 52, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2ac0 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65,
/* 0x2ad0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,
/* 0x2ae0 */ 110,108,105,110,107, 10, 48, 48, 48, 48, 48, 52, 52, 48, 32, 82,
/* 0x2af0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b00 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2b10 */  48, 48, 52, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2b20 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2b30 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 53, 48, 32, 82, 95, 65,
/* 0x2b40 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,
/* 0x2b50 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48,
/* 0x2b60 */  48, 48, 52, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2b70 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2b80 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 55, 48, 32, 82, 95, 65,
/* 0x2b90 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2ba0 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2bb0 */  52, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2bc0 */  32, 32, 32, 32, 32, 32,102,116,114,117,110, 99, 97,116,101, 10,
/* 0x2bd0 */  48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2be0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2bf0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 56, 56, 32,
/* 0x2c00 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2c10 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2c20 */  48, 48, 48, 52, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2c30 */  52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,101,107, 10, 48,
/* 0x2c40 */  48, 48, 48, 48, 52, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2c50 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101, 10,
/* 0x2c60 */  48, 48, 48, 48, 48, 52, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2c70 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,101,107,
/* 0x2c80 */  10, 48, 48, 48, 48, 48, 52,100, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2c90 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2ca0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,100, 99,
/* 0x2cb0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2cc0 */  32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,
/* 0x2cd0 */  10, 48, 48, 48, 48, 48, 52,101, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2ce0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2cf0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,102, 56,
/* 0x2d00 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2d10 */  32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 52,102,
/* 0x2d20 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2d30 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2d40 */  48, 48, 48, 48, 48, 53, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2d50 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10,
/* 0x2d60 */  48, 48, 48, 48, 48, 53, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2d70 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2d80 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 51, 52, 32,
/* 0x2d90 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2da0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 10, 82,
/* 0x2db0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x2dc0 */  83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78, 85, 88,
/* 0x2dd0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x2de0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x2df0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65,
/* 0x2e00 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2e10 */  77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 50,
/* 0x2e20 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2e30 */  32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101,
/* 0x2e40 */  10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2e50 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2e60 */  76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 51, 99, 32, 82,
/* 0x2e70 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e80 */  32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48, 48,
/* 0x2e90 */  48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2ea0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78,
/* 0x2eb0 */  85, 88, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65, 82,
/* 0x2ec0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2ed0 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 54, 56,
/* 0x2ee0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2ef0 */  32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48, 55, 48,
/* 0x2f00 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2f10 */  32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48,
/* 0x2f20 */  48, 48, 48, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2f30 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x2f40 */  88, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77,
/* 0x2f50 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2f60 */  95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,100, 48, 32,
/* 0x2f70 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2f80 */  32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48,100, 56,
/* 0x2f90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fa0 */  32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48,101, 52,
/* 0x2fb0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fc0 */  32, 32, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48, 48,
/* 0x2fd0 */  48, 48, 48,102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x2ff0 */  88, 10, 48, 48, 48, 48, 48, 49, 49, 56, 32, 82, 95, 65, 82, 77,
/* 0x3000 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,
/* 0x3010 */ 112, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77,
/* 0x3020 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116,
/* 0x3030 */  95,112, 97,103,101, 95,109, 97,115,107, 10, 10, 82, 69, 76, 79,
/* 0x3040 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x3050 */  79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79,
/* 0x3060 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x3070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x3080 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x3090 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 77, 70, 76, 71, 10,
/* 0x30a0 */  48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x30b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x30c0 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 65,
/* 0x30d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x30e0 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 50, 48,
/* 0x30f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3100 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x3110 */  48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3120 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x3130 */  48, 48, 48, 48, 48, 48, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3140 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x3150 */  73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65,
/* 0x3160 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x3170 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 97, 48,
/* 0x3180 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3190 */  32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,
/* 0x31a0 */ 102,100, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82,
/* 0x31b0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x31c0 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48,100, 56, 32,
/* 0x31d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x31e0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x31f0 */  49, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3200 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x3210 */  48, 48, 48, 48, 49, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3220 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x3230 */  78, 88, 10, 48, 48, 48, 48, 48, 49, 97, 52, 32, 82, 95, 65, 82,
/* 0x3240 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x3250 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49,100, 99, 32,
/* 0x3260 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3270 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x3280 */  49,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3290 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x32a0 */  48, 48, 48, 48, 49,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x32b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x32c0 */  78, 88, 10, 48, 48, 48, 48, 48, 49,102, 56, 32, 82, 95, 65, 82,
/* 0x32d0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x32e0 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49,102, 99, 32,
/* 0x32f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3300 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x3310 */  50, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3320 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x3330 */  48, 48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3340 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x3350 */  78, 88, 10, 48, 48, 48, 48, 48, 50, 49, 99, 32, 82, 95, 65, 82,
/* 0x3360 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x3370 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32,
/* 0x3380 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3390 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x33a0 */  50, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x33b0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,
/* 0x33c0 */  48, 48, 48, 48, 50, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x33d0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x33e0 */  78, 88, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65, 82,
/* 0x33f0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x3400 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 50, 53, 48, 32,
/* 0x3410 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3420 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x3430 */  50, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3440 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10
};
