; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=argpromotion < %s | FileCheck %s

; Make sure volatile and atomic loads are not promoted.

define internal i32 @callee_volatile(ptr %p) {
; CHECK-LABEL: @callee_volatile(
; CHECK-NEXT:    [[V:%.*]] = load volatile i32, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i32 [[V]]
;
  %v = load volatile i32, ptr %p
  ret i32 %v
}

define void @caller_volatile(ptr %p) {
; CHECK-LABEL: @caller_volatile(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @callee_volatile(ptr [[P:%.*]])
; CHECK-NEXT:    ret void
;
  call i32 @callee_volatile(ptr %p)
  ret void
}

define internal i32 @callee_atomic(ptr %p) {
; CHECK-LABEL: @callee_atomic(
; CHECK-NEXT:    [[V:%.*]] = load atomic i32, ptr [[P:%.*]] seq_cst, align 4
; CHECK-NEXT:    ret i32 [[V]]
;
  %v = load atomic i32, ptr %p seq_cst, align 4
  ret i32 %v
}

define void @caller_atomic(ptr %p) {
; CHECK-LABEL: @caller_atomic(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @callee_atomic(ptr [[P:%.*]])
; CHECK-NEXT:    ret void
;
  call i32 @callee_atomic(ptr %p)
  ret void
}
